<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
	<title>AQMS - HORIBA | Tech for Clean Air</title>

	<!-- responsive meta -->
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<!-- For IE -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
    <!-- master stylesheet -->
    <link rel="stylesheet" href="css/hover-min.css">
    <link rel="stylesheet" href="css/style.css">
	<!-- Responsive stylesheet -->
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="css/navigation-responsive.css">
	<link rel="stylesheet" href="css/home-page-responsive.css">
    <!-- Favicon -->
    
    <link rel="icon" type="image/png" sizes="96x96" href="images/favicon.png">

    <!-- Fixing Internet Explorer-->
    <!--[if lt IE 9]>
        <script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
        <script src="js/html5shiv.js"></script>
    <![endif]-->
    
</head>

<body>

    <div class="page-wrapper">

        <?php include("include/header.php"); ?>

        <section class="breadcrumb-area">
            <div class="container">
                <div class="row">
                    <div class="col-xl-12">
                        <div class="inner-content clearfix">
                            <div class="title float-left">
                               <h1>Augmenting air quality monitoring networks</h1>
                            </div>
                            <div class="breadcrumb-menu float-right">
                                <ul class="clearfix">
                                    <li><a href="index.php">Home</a></li>
                                    <li class="active">AQMS - HORIBA</li>
                                </ul>    
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        
        <section class="single-service-area">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-12 col-md-12 col-sm-12">
                <div class="single-service-top">
                    <div class="sec-title-four mb-0">
                        <h2 class="mb-3">AQMS - HORIBA</h2>
                    </div>
                    <div class="row">
                    	 <div class="col-xl-12">
                         	 <div class="text">
                                <p class="text-justify">
                                <img src="images/mission.jpg" alt="Awesome Image" class="img-fluid productimg-right">
                                An Air Quality Monitoring Station (AQMS) is a system that measures metrological parameters such as wind speed, wind direction, rainfall, radiation, temperature, barometric pressure and ambient parameters. The AQMS also integrates a series of ambient analyzers to monitor the concentration of air pollutants (such as SO2, NOx, CO, O3, THC, PM, etc.), continuously. HORIBA also provides mobile monitoring stations that can be used to monitor ambient conditions at multiple sites. Air quality monitoring refers to continuous measurement of specific air pollutants also known as "criteria air pollutants".  Obtained air pollution data together with natural background/trace gas monitoring and stationary source emission monitoring helps to define what kind of air pollution people are exposed to.  </p>
                            </div>                            
                         </div>
                         <div class="col-xl-12">
                         	 <div class="text">
                                <p class="text-justify">
                                <img src="images/products/1.jpg" alt="Awesome Image" class="img-fluid productimg-left">
                                HORIBA has more than 50 years of experience providing ambient monitoring solutions, recognized around the world. HORIBA has supplied over 15,000 units with the major share in many regions. The monitoring station is tailor-made according to the customer's request. HORIBA can provide several types of stations, calibration equipment and more to meet your challenging monitoring requirements. </p>
                                <p class="text-justify">The measured data can be remotely monitored and exported in various formats to the local central authorities. The data can be published via the Internet for easy public access to raise awareness on current air pollution levels. This way, the public can prevent outdoor activities and reduce health impacts during heavily polluted days</p>
                            </div>                            
                         </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-12 col-md-12 col-sm-12">
                <div class="single-service-sidebar">
                    <!--Start Single sidebar-->
                    <div class="single-sidebar">
                        <ul class="service-pages">
                            <li class="active">
                                <a href="#">
                                    <div class="icon">
                                        <img src="images/icon/p1.png"/>    
                                    </div>
                                    <div class="title">
                                        <h3>AQMS- HORIBA</h3>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                    <div class="icon">
                                        <img src="images/icon/p2.png"/>  
                                    </div>
                                    <div class="title">
                                        <h3>Indoor Air quality</h3>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                    <div class="icon">
                                        <img src="images/icon/p3.png"/>  
                                    </div>
                                    <div class="title">
                                        <h3>Control of vehicular and industrial emission</h3>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                    <div class="icon">
                                        <img src="images/icon/p4.png"/>  
                                    </div>
                                    <div class="title">
                                        <h3>Waste Management Technologies</h3>
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="#">
                                    <div class="icon">
                                        <img src="images/icon/p5.png"/>  
                                    </div>
                                    <div class="title">
                                        <h3>Dust Management Technologies</h3>
                                    </div>
                                </a>
                            </li>
                            
                        </ul>
                    </div>
                    <!--End Single sidebar-->
                    <div class="sidebar-contact-box text-center">
                        <div class="img-holder">
                            <img src="images/1.jpg" alt="Awesome Image">
                        </div>
                        <div class="inner-content">
                            <div class="icon-holder">
                                <span class="icon-question-2"></span>    
                            </div>
                            <h3>Talk to our expert for any query</h3>
                            <div class="bottom-box">
                                <h2>+91 11 4039 5508</h2>
                                <span>Email: info@techforcleanair.com</span>
                            </div>
                        </div>  
                    </div>
                </div>    
            </div>
        </div>
    </div>    
</section>

<section class="why-choose-area secpd1">
        <div class="container">
            <div class="sec-title">
                <p>Popular</p>
                <div class="title">Augmenting Air Quality Monitoring Networks <a href="#" class="thm-btn home-four hvr-sweep-to-left pt-0 pb-0">View All</a></div>
                <div class="border-box"></div>
            </div>
            <div class="row">
                <div class="col-xl-12">
                    <div class="choose-carousel owl-carousel owl-theme">
                        <!--Start Single Choose Box-->
                        <div class="single-choose-box text-center">
                            <h3><a href="#">AQMesh</a></h3>
                            <span class="icon"><img src="images/icon/icons/1.jpg"/></span>
                            <div class="button">
                                <a href="#"><span class="icon-null"></span></a>    
                            </div> 
                            <div class="overlay-content">
                                <h3><a href="#">AQMesh</a></h3>
                                <p>Individually, or as a network of pods, AQMesh measures key pollutants in ambient air using the best small sensor technology...</p>
                                <div class="button">
                                    <a href="#"><span class="icon-null"></span></a>    
                                </div>     
                            </div>       
                        </div>
                        <div class="single-choose-box text-center">
                            <h3><a href="#">Purple Air Monitor</a></h3>
                            <span class="icon"><img src="images/icon/icons/2.jpg"/></span>
                            <div class="button">
                                <a href="#"><span class="icon-null"></span></a>    
                            </div> 
                            <div class="overlay-content">
                                <h3><a href="#">Purple Air Monitor</a></h3>
                                <p>The PurpleAir is a small, inexpensive device for monitoring atmospheric concentrations of particulate matter. ...</p>
                                <div class="button">
                                    <a href="#"><span class="icon-null"></span></a>    
                                </div>     
                            </div>       
                        </div>
                        <div class="single-choose-box text-center">
                            <h3><a href="#">Dekati</a></h3>
                            <span class="icon"><img src="images/icon/icons/3.jpg"/></span>
                            <div class="button">
                                <a href="#"><span class="icon-null"></span></a>    
                            </div> 
                            <div class="overlay-content">
                                <h3><a href="#">Dekati</a></h3>
                                <p>Every day, unhealthy air quality affects the lives of millions of people all over the world. Numerous studies have shown the correlation...</p>
                                <div class="button">
                                    <a href="#"><span class="icon-null"></span></a>    
                                </div>     
                            </div>       
                        </div>
                        <div class="single-choose-box text-center">
                            <h3><a href="#">Shellios</a></h3>
                            <span class="icon"><img src="images/icon/icons/4.jpg"/></span>
                            <div class="button">
                                <a href="#"><span class="icon-null"></span></a>    
                            </div> 
                            <div class="overlay-content">
                                <h3><a href="#">Shellios</a></h3>
                                <p>Shellios is a helmet maker which offers smart safety solutions to two-wheeler riders. Its products offer smartphone connectivity for communications ...</p>
                                <div class="button">
                                    <a href="#"><span class="icon-null"></span></a>    
                                </div>     
                            </div>       
                        </div>
                        <div class="single-choose-box text-center">
                            <h3><a href="#">Gasera</a></h3>
                            <span class="icon"><img src="images/icon/icons/5.jpg"/></span>
                            <div class="button">
                                <a href="#"><span class="icon-null"></span></a>    
                            </div> 
                            <div class="overlay-content">
                                <h3><a href="#">Gasera</a></h3>
                                <p>A number of instruments exist on the market for simultaneous measurement of carbon dioxide (CO2), carbon monoxide (CO), temperature, and humidity...</p>
                                <div class="button">
                                    <a href="#"><span class="icon-null"></span></a>    
                                </div>     
                            </div>       
                        </div>
                        <!--End Single Choose Box-->
                        
                        
                        
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--End Why Choose Area-->
        
        <!-- /.sec-pad -->

        <?php include("include/footer.php"); ?>
        


    </div><!-- /.page-wrapper -->

    <script src="js/jquery.js"></script>
    <script src="js/bootstrap.bundle.min.js"></script>
    <script src="js/jquery.enllax.min.js"></script>
    <script src="js/jquery.magnific-popup.min.js"></script>
    <script src="js/owl.js"></script>
    <script src="js/wow.js"></script>
    <script src="js/isotope.js"></script>
    <script src="js/waypoints.min.js"></script>
    <script src="js/jquery.counterup.min.js"></script>
    <script src="js/bootstrap-select.min.js"></script>
    <script src="js/jquery.mCustomScrollbar.concat.min.js"></script>
    <script src="js/custom.js"></script>



</body>
</html>