/*
All of the code within the ZingChart software is developed and copyrighted by ZingChart, Inc., and may not be copied,
replicated, or used in any other software or application without prior permission from ZingChart. All usage must coincide with the
ZingChart End User License Agreement which can be requested by email at support@zingchart.com.

Build 2.9.2
*/
if(typeof(ZC)==="undefined"){if(window.ZC={AV:function(e,t){if(e.indexOf)return e.indexOf(t);for(var i=0,n=e.length;i<n;i++)if(e[i]===t)return i;return-1},VERSION:"2.9.2",VERSIONID:"2.9.2.2020.11.17",LICENSEKEY:"",ABZ:!1,CHARTS:["null","null3d","line","line3d","vline","area","area3d","varea","bar","bar3d","vbar","vbar3d","hbar","hbar3d","scatter","hscatter","bubble","hbubble","pie","pie3d","ring","ring3d","nestedpie","mixed","mixed3d","hmixed","radar","bullet","vbullet","hbullet","funnel","vfunnel","hfunnel","piano","heatmap","stock","range","vrange","gauge","venn"],EQUIV:{floatbar:["vfloatbar","hfloatbar"],boxplot:["vboxplot","hboxplot"],waterfall:["vwaterfall","hwaterfall"],populationpyramid:["population-pyramid","pop-pyramid"],bubblepie:["bubble-pie","bubblepie"],bar:["column","vbar"],radar:["polar","radar"],stream:["vstream"]},ALIAS:{ring:"pie"},execFn:function(e,t){var i=[].slice.call(arguments).splice(2);return ZC.evalFn(e,t).apply(t,i)},evalFn:function(e,t){for(var i=e.split("."),n=i.pop(),a=0;a<i.length;a++)t=t[i[a]];return t[n]},cache:{data:{},size:0,add:function(e,t){ZC.cache.data[e]=t,ZC.cache.size++,ZC.cache.size>2048&&(ZC.cache.data={},ZC.cache.size=0)}},DEBUG:0,TS:{},MAX:Number.MAX_VALUE,IMG404:[],BLANK:"data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==",TTLOCK:!1,REFRESH_TICK:{},ASYNC_TICK:[],COLORS:[],SEQ:0,LOGO_ABOUT:"data:image/png;base64,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",IMAGES:{"zc.logo":"data:image/gif;base64,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"},hosted:!1,adapter:"",flash:null,canvas:null,svg:null,vml:null,move:!1,objmove:!1,compat:function(){ZC.flash=ZC.canvas=ZC.svg=ZC.vml=!1;var e=!!document.createElement("canvas").getContext,t=!1;e&&(t="function"==typeof document.createElement("canvas").getContext("2d").fillText),ZC.canvas=e&&t,ZC.svg=document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1");var i=document.body.appendChild(document.createElement("div")),n=document.createElement("zcv:shape");n.className="zcvml",n.setAttribute("id","vml_flag1"),n.setAttribute("adj",new Object),i.appendChild(n),n.style.behavior="url(#default#VML)",ZC.vml=!n||"object"==typeof n.adj,i.parentNode.removeChild(i);var a=!1;navigator.mimeTypes&&navigator.mimeTypes["application/x-shockwave-flash"]?a=navigator.mimeTypes["application/x-shockwave-flash"].enabledPlugin:document.all&&-1===navigator.appVersion.indexOf("Mac")&&(a=new Function('try { var xObj = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");if (xObj) { xObj = null; return true; } } catch (e) { return false; }')()),ZC.flash=a?1:0},quirks:!(document.compatMode&&"CSS1Compat"===document.compatMode),ie67:!!/MSIE (\d+\.\d+);/.test(navigator.userAgent)&&parseFloat(RegExp.$1)<8,ie678:!!/MSIE (\d+\.\d+);/.test(navigator.userAgent)&&parseFloat(RegExp.$1)<9,mobile:/Mobile|BlackBerry|Opera Mini|PPC|Windows CE|Android/.test(navigator.userAgent),ipad:/iPad/.test(navigator.userAgent),iphone:/iPhone/.test(navigator.userAgent),websockets:"WebSocket"in window,webstorage:"sessionStorage"in window,RE:[],WA:[],DX:[0,0],ACK:null,_cp_:function(e,t,i,n,a,r){null===ZC._n_(i)&&(i=!0),null===ZC._n_(n)&&(n=!0),null===ZC._n_(a)&&(a=!1);var l=(r=r||[]).length;for(var o in e)if(0===l||l>0&&-1===ZC.AV(r,o))if(e[o]instanceof Array){if(n){(null===ZC._n_(t[o])||"override"!==o&&!a)&&(t[o]=[]);for(var s=0,c=e[o].length;s<c;s++)t[o].push(e[o][s])}}else e[o]instanceof Object&&!(e[o]instanceof Function)?n&&(null===ZC._n_(t[o])&&(t[o]={}),t[o]instanceof Object&&!(t[o]instanceof Function)&&ZC._cp_(e[o],t[o],i)):(null===ZC._n_(t[o])||i)&&(t[o]=e[o])},_cpa_:function(e,t){t||(t=[]);for(var i=0,n=e.length;i<n;i++)t.push(e[i])},_inj_:function(e,t){var i={};ZC._cp_(e,i),ZC._cp_(t,e),ZC._cp_(i,e)},_todash_:function(e,t,i){if("dashed"!==zingchart.SYNTAX){void 0===t&&(t=!0);var n,a,r=(i=i||[]).length;for(var l in e)if(e.hasOwnProperty(l)&&(0===r||r>0&&-1===ZC.AV(i,l))){var o=l.substring(0,1);if("."!==o&&"#"!==o)if(e[l]instanceof Array)if(ZC.U7(l)!==l){for(e[ZC.U7(l)]=[],n=0,a=e[l].length;n<a;n++)ZC._todash_(e[l][n]),e[ZC.U7(l)].push(e[l][n]);delete e[l]}else for(n=0,a=e[l].length;n<a;n++)ZC._todash_(e[l][n]);else e[l]instanceof Object&&!(e[l]instanceof Function)?(ZC.U7(l)!==l&&(e[ZC.U7(l)]={},ZC._cp_(e[l],e[ZC.U7(l)]),delete e[l]),t&&ZC._todash_(e[ZC.U7(l)],t,i)):ZC.U7(l)!==l&&(e[ZC.U7(l)]=e[l],delete e[l])}}},Z8:function(e,t){for(var i in e)if(e.hasOwnProperty(i)){var n;if((n=i.replace(t+"-",""))!==i)if(e[n]=e[i],e[i]instanceof Array)for(var a=0,r=e[i].length;a<r;a++)ZC.Z8(e[i][a],t);else e[i]instanceof Object&&!(e[i]instanceof Function)&&ZC.Z8(e[i],t)}},A98:function(e){for(var t="",i=0,n=e.length;i<n;i++){var a=i%2==0?i:e.length-i;t+=e.substring(a,a+1)}return t=t.replace(/\./g,"d")},AD7:function(e){var t=e;return t=t.replace("*","&"),t=t.replace("9","3"),t=t.replace("l","1")},A9T:function(e){return e.replace(/[a-zA-Z]/g,function(e){return String.fromCharCode((e<="Z"?90:122)>=(e=e.charCodeAt(0)+13)?e:e-26)})},AC3:function(e,t){var i=ZC.WS(ZC.ABS(e)),n=ZC.WS(ZC.A1W(t)),a=i.length;if(0===a)return"";for(var r,l,o=i[a-1],s=i[0],c=2654435769,h=Math.floor(6+52/a)*c;0!==h;){l=h>>>2&3;for(var C=a-1;C>0;C--)r=((o=i[C-1])>>>5^s<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),s=i[C]-=r;r=((o=i[a-1])>>>5^s<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),s=i[0]-=r,h-=c}return decodeURIComponent(ZC.AC2(ZC.A5H(i)))},AE0:function(e,t){e=encodeURIComponent(e);var i=ZC.WS(ZC.A1W(e)),n=ZC.WS(ZC.A1W(t)),a=i.length;if(0===a)return"";1===a&&(i[a++]=0);for(var r,l,o=i[a-1],s=i[0],c=Math.floor(6+52/a),h=0;c-- >0;){l=(h+=2654435769)>>>2&3;for(var C=0;C<a-1;C++)r=(o>>>5^(s=i[C+1])<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),o=i[C]+=r;r=(o>>>5^(s=i[0])<<2)+(s>>>3^o<<4)^(h^s)+(n[3&C^l]^o),o=i[a-1]+=r}return ZC.ABU(ZC.A5H(i))},WS:function(e){for(var t=new Array(Math.ceil(e.length/4)),i=0;i<t.length;i++)t[i]=e[4*i]+(e[4*i+1]<<8)+(e[4*i+2]<<16)+(e[4*i+3]<<24);return t},A5H:function(e){for(var t=[],i=0;i<e.length;i++)t.push(255&e[i],e[i]>>>8&255,e[i]>>>16&255,e[i]>>>24&255);return t},ABU:function(e){for(var t="",i=["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"],n=0;n<e.length;n++)t+=i[e[n]>>4]+i[15&e[n]];return t},ABS:function(e){for(var t=[],i="0x"===e.substr(0,2)?2:0;i<e.length;i+=2)t.push(parseInt(e.substr(i,2),16));return t},AC2:function(e){for(var t="",i=0;i<e.length;i++)0!==e[i]&&(t+=String.fromCharCode(e[i]));return t},A1W:function(e){for(var t=[],i=0;i<e.length;i++)t.push(e.charCodeAt(i));return t},_i_:function(e){return-1!==String(e).indexOf("e-")?0:""===(e=String(e).replace(/[^0-9\.\-]/gi,""))?0:Math.round(e)},_f_:function(e){return e=parseFloat(e),isNaN(e)?0:e},_x_:function(e,t){return void 0===t&&(t=2),parseFloat(Number(e).toFixed(t))},_a_:function(e){return Math.abs(e)},_b_:function(e){return"false"!==e&&"0"!==e&&("true"===e||"1"===e||!!e&&!0)},_p_:function(e){var t=(e=String(e).replace(/[^0-9\.\%\-]/gi,"")).indexOf("%");return-1!==t&&(e=e.substring(0,t),e=ZC._f_(e)/100),e},_h_:function(e){return window.toStaticHTML?window.toStaticHTML(e):e},_n_:function(e){return null===e||void 0===e?null:e},_c_:function(e,t){return null===e||void 0===e?t:e},_ang_:function(e){return(e%=360)<0&&(e+=360),e},IH:function(e,t){return ZC._f_(e)+""==e+""?t?ZC._f_(e):ZC._a_(e):-1!==(e+="").indexOf("%")?ZC._f_(e.replace("%",""))/100:-1!==e.indexOf("px")?ZC._f_(e.replace("px","")):ZC._f_(e)},QE:function(e){return parseInt(e,16)},OS:function(e){return ZC._i_(e).toString(16)},_r_:function(e,t){return parseInt(e+(t-e)*Math.random(),10)},_l_:function(e,t,i){return e=e<t?t:e,e=e>i?i:e},DT:function(e,t,i,n){return n?t<e&&e<i||i<e&&e<t:t<=e&&e<=i||i<=e&&e<=t},BQ:function(e,t){return Math.max(e,t)},CY:function(e,t){return Math.min(e,t)},A1H:function(e,t){null===ZC._n_(t)&&(t=!1);for(var i=0,n=e.length,a=-Number.MAX_VALUE;i<n;i++)t&&0==e[i]||(a=Math.max(a,e[i]));return a},XS:function(e,t){null===ZC._n_(t)&&(t=!1);for(var i=0,n=e.length,a=Number.MAX_VALUE;i<n;i++)t&&0==e[i]||(a=Math.min(a,e[i]));return a},_rcolor_:function(){for(var e=(16777215*Math.random()+1<<0).toString(16);e.length<6;)e="0"+e;return"#"+e},AA5:function(e,t){for(var i,n=ZC._f_(t),a=Number.MAX_VALUE,r=0,l=0,o=e.length;l<o;l++)(i=Math.abs(ZC._f_(e[l])-n))<a&&(r=l,a=i);return r},AEK:function(e){var t=e.split(".");return t[t.length-1]||""},GT:function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")},H0:function(e,t){return t=t||Math.E,isFinite(Math.log(e)/Math.log(t))?Math.log(e)/Math.log(t):0},TO:function(e){return 360*e/(2*Math.PI)},SZ:function(e){return 2*e*Math.PI/360},EF:function(e){return Math.cos(ZC.SZ(e))},EO:function(e){return Math.sin(ZC.SZ(e))},P4:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},EC:function(e){return-1!==e.indexOf("-")?e.replace(/(\-[a-z0-9])/g,function(e){return e.toUpperCase().replace("-","")}):e},U7:function(e){return e.toUpperCase()!==e&&-1===e.indexOf("-")&&e.substring(0,1).toLowerCase()===e.substring(0,1)?e.replace(/([A-Z])/g,function(e){return"-"+e.toLowerCase()}).replace(/([0-9]+)/g,function(e){return"-"+e.toLowerCase()}).replace("-3d","3d"):e},AEL:function(e){return ZC.XL.md5(e)},AK:function(e){return document.getElementById(e)},A1F:function(e,t){return e[0].length<t[0].length?1:e[0].length>t[0].length?-1:0},ZH:function(e){window.setTimeout(e,zingchart.TIMEOUT)},_fixed_:function(e,t){return t>=0&&t<=20?e.toFixed(t):""+e},_nfind_:function(e,t,i,n){var a=t.R[i].BU,r=t.R[n].BU;if(e==a)return i;if(e==r)return n;var l=ZC._i_((i+n)/2);if(!t.R[l]){for(;!t.R[l]&&l<n;)l++;if(l===n){for(l=ZC._i_((i+n)/2);!t.R[l]&&l>i;)l--;if(l===i)return null}}var o=t.R[l].BU;return l!==i&&l!==n?e==o?l:e>o?ZC._nfind_(e,t,l,n):ZC._nfind_(e,t,i,l):e==o?l:null},_tx_:function(e){var t,i,n,a,r=[1,1,0,0];if(zingchart.DEV.LOOKUPCSSTRANSFORM&&!ZC.vml&&ZC.AK(e)){var l=ZC.AK(e);for(t="";l&&(""===t||"none"===t);)t=ZC.A4(l).css("transform")||"",l=l.parentNode;-1!==(i=t.indexOf("matrix("))&&(n=t.indexOf(")",i),a=t.substring(i+7,n-i).split(","),r=[ZC._f_(a[0]),ZC._f_(a[3]),ZC._f_(a[4]),ZC._f_(a[5])])}return r}},ZC.hasPassive=!1,ZC.SEC=1e3,ZC.MIN=60*ZC.SEC,ZC.HR=60*ZC.MIN,ZC.DAY=24*ZC.HR,ZC.MON=30*ZC.DAY,ZC.YR=365*ZC.DAY,ZC.MAPTX=0,window.JSON=window.JSON||{},JSON.stringify=JSON.stringify||function(e){var t=typeof e;if("object"!==t||null===e)return"string"===t&&(e='"'+e.replace("\\","\\\\").replace('"','"')+'"'),String(e);var i,n,a=[],r=e&&e.constructor===Array;for(i in e)"function"!=typeof e[i]&&("string"===(t=typeof(n=e[i]))?n='"'+n.replace("\\","\\\\").replace('"','\\"')+'"':"object"===t&&null!==n&&(n=JSON.stringify(n)),a.push((r?"":'"'+i+'":')+String(n)));return(r?"[":"{")+String(a)+(r?"]":"}")},JSON.parse=JSON.parse||function(KS){return""===KS&&(KS='""'),eval("("+KS+")")},function(){var e=!1,t=/xyz/.test(function(){xyz})?/\bb\b/:/.*/;ZC.C8=function(){},ZC.C8.C7=function(i){function n(){!e&&this.$i&&this.$i.apply(this,arguments)}var a=this.prototype;e=!0;var r=new this;e=!1;for(var l in i)r[l]="function"==typeof r[l]&&"function"==typeof a[l]&&t.test(i[l])?function(e,t){return function(){var i=this.b;this.b=a[e];var n=t.apply(this,arguments);return this.b=i,n}}(l,i[l]):i[l];return n.prototype=r,n.constructor=n,n.C7=arguments.callee,n}}(),ZC.AAX=function(e){this.H=e,this.A9M=function(e,t){var i,n=this,a=n.B8.palette;if(null!==ZC._n_(t)&&null!==ZC._n_(a[t])&&(a=a[t]),null!==ZC._n_(a[e])){var r=a[e];return null===ZC._n_(r[2])&&(r[2]=ZC.AP.QT(r[1],10)),null===ZC._n_(r[3])&&(r[3]=ZC.AP.QT(r[1],10)),r}var l=["#00BAF2","#E80C60","#E2D51A","#9B26AF","#FB301E","#00AE4D","#20398B"];i=null!==ZC._n_(l[e-n.B8.palette.length])?l[e-n.B8.palette.length]:"#"+ZC.XL.md5(e).substr(e%20,6);var o=ZC.AP.QT(i,10),s=ZC.AP.QT(i,20),c="#FFF";return n.B8.palette&&n.B8.palette[0]&&n.B8.palette[0][0]&&(c=n.B8.palette[0][0]),[c,i,o,s]},this.A8O=function(e){e&&ZC._cp_(e,this.B8,!0)},this.AAP=function(e){var t=this;null!==ZC._n_(t.NU[e])&&(ZC._todash_(t.NU[e]),ZC._cp_(t.NU[e],t.B8))},this.NU={},ZC._cp_(zingchart.THEMES,this.NU),this.NU.classic={palette:[["#fff","#6a921f","#a7da47","#89b92e"],["#fff","#007fa3","#00b0e1","#0392bb"],["#fff","#a62b02","#ef4810","#cc3300"],["#fff","#b79007","#f9c332","#da9b04"],["#fff","#563d02","#84680a","#6e4503"],["#fff","#0b32a0","#4d62b1","#1540a0"]],graph:{refresh:{curtain:{alpha:.5,"background-color":"#999",color:"#000","font-size":15,bold:1,text:"Loading..."}},"background-color":"#e1eaec #edf3f5",title:{"font-size":14,bold:1,color:"#fff","background-color":"#00bbf1 #05a0cd",padding:6},subtitle:{"font-size":11,bold:1,color:"#333","margin-top":30,padding:6},source:{"font-size":10,color:"#333",width:"100%",bold:1,"text-align":"right",height:20,margin:"auto 0 0 auto",padding:5},nodata:{"font-size":12,color:"#333","text-align":"center","vertical-align":"middle",text:""},SCALE:{"font-size":11,"line-width":2,"line-color":"#3e6c7b",item:{flat:!0},"ref-line":{"line-width":1,"line-color":"#3e6c7b"},guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#2c4a59",alpha:.2},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#aaa",alpha:.1},tick:{visible:1,size:6,placement:"outer","line-width":2,"line-color":"#3e6c7b"},"minor-tick":{visible:1,size:4,placement:"outer","line-width":1,"line-color":"#3e6c7b"},label:{color:"#2c4a59",flat:!0}},"scroll-x":{bar:{height:16},handle:{height:16}},"scroll-y":{bar:{width:16},handle:{width:16}},legend:{"background-color":"#fff","border-width":1,alpha:.75,"border-alpha":.75,"border-color":"#666","shadow-distance":3,header:{padding:"4 6",color:"#fff","border-width":1,"border-color":"#3e6c7b","background-color":"#3e6c7b"},footer:{padding:"2 6","background-color":"#ccc","border-width":1,"border-color":"#666"},marker:{"border-color":"#333","border-width":1}},plot:{"value-box":{flat:!0},marker:{shadow:1,"line-width":1,"border-width":1},"hover-marker":{"line-width":1,"border-width":1}},guide:{"line-width":1,"line-color":"#999",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{padding:"3 6"}}},line:{plot:{"shadow-alpha":.5,marker:{size:4},"hover-marker":{size:5}}},area:{plot:{"shadow-alpha":.5,marker:{size:4},"hover-marker":{size:5}}},vbar:{plot:{"fill-angle":90,shadow:0}},hbar:{plot:{"fill-angle":180,shadow:0}},piano:{plotarea:{"mask-tolerance":[0,0]},plot:{shadow:0}},stock:{plot:{shadow:0}},vbullet:{plot:{shadow:0}},hbullet:{plot:{"fill-angle":0,shadow:0}},scatter:{plot:{marker:{size:4},"hover-marker":{size:5}}},hscatter:{plot:{marker:{size:4},"hover-marker":{size:5}}},bubble:{plot:{marker:{"border-width":0},"hover-marker":{"border-width":0}}},hbubble:{plot:{marker:{"border-width":0},"hover-marker":{"border-width":0}}},pie:{plot:{"border-width":1}},nestedpie:{plot:{"border-width":1}},radar:{plot:{marker:{size:3},"hover-marker":{size:4}},"scale-k":{guide:{alpha:.5,"background-color":"#eee #ddd"}}},gauge:{"scale-r":{"background-color":"-1",guide:{alpha:.5,"background-color":"#eee #ddd"},item:{"offset-r":0},ring:{size:1,items:[{"background-color":"#999",alpha:.8},{"background-color":"#666",alpha:.8}]}}},vfunnel:{plotarea:{margin:"50 100"},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":0},"minor-guide":{"line-width":0}},"scale-y":{guide:{alpha:.25,"background-color":"-1 #58595B"}},"scale-y-n":{guide:{alpha:.25,"background-color":"-1 #58595B"}},plot:{"border-width":1}},hfunnel:{plotarea:{margin:"50 100"},"scale-x":{label:{"font-angle":270}},"scale-x-n":{label:{"font-angle":90}},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":0},"minor-guide":{"line-width":0}},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"},guide:{alpha:.25,"background-color":"#58595B -1"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"},guide:{alpha:.25,"background-color":"#58595B -1"}},plot:{"border-width":1}},range:{plot:{marker:{type:"circle",size:4},"hover-marker":{size:5}}},line3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},area3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},mixed3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},vbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},hbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},pie3d:{plot:{"border-width":1}},"-":""},this.NU.light={palette:[["#fff","#29A2CC","#29A2CC","#1089B3"],["#fff","#D31E1E","#D31E1E","#BA0505"],["#fff","#7CA82B","#7CA82B","#638F12"],["#fff","#EF8535","#EF8535","#D66C1C"],["#fff","#A14BC9","#A14BC9","#8832B0"],["#fff","#A05F18","#A05F18","#874600"],["#fff","#265E96","#265E96","#0D457D"],["#fff","#6B7075","#6B7075","#52575C"],["#fff","#96C245","#96C245","#7CA82B"]],graph:{refresh:{curtain:{alpha:.5,"background-color":"#999",color:"#000","font-size":15,bold:1,text:"Loading..."}},"background-color":"#ffffff",title:{"font-size":21,bold:1,color:"#414042","background-color":"none",padding:6},subtitle:{"font-size":11,bold:1,color:"#414042","margin-top":30,padding:6},source:{"font-size":10,color:"#414042",width:"100%",bold:1,"text-align":"right",height:20,margin:"auto 0 0 auto",padding:5},nodata:{"font-size":12,color:"#333","text-align":"center","vertical-align":"middle",text:"No Data","background-color":"#BBBBBB",alpha:.8},SCALE:{"font-size":11,"line-width":1,"line-color":"#8C8C8C",item:{"font-size":12,flat:!0,color:"#808285"},"ref-line":{"line-width":1,"line-color":"#D1D3D4"},guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#DCDCDC",alpha:1},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#aaa",alpha:.1},tick:{visible:1,size:5,placement:"outer","line-width":1,"line-color":"#8C8C8C"},"minor-tick":{visible:1,size:3,placement:"outer","line-width":1,"line-color":"#A7A9AC"},label:{color:"#414042",flat:!0}},"scale-x":{normalize:!0,guide:{visible:!1}},scroll:{bar:{"background-color":"#F0F1F1",margin:1},handle:{"background-color":"#A7A9AC","border-radius":6}},"scroll-x":{bar:{height:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{height:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-y":{bar:{width:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{width:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-xi":{bar:{width:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{width:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-yi":{bar:{height:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{height:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},preview:{"background-color":"#fff","border-width":1,"border-color":"#A7A9AC",live:!0,mask:{"background-color":"#999"},active:{alpha:0},handle:{width:11,"border-width":2,"border-radius":3,"line-color":"#C6C6C6","border-color":"#A7A9AC","background-color":"#F0F1F1"},"handle-top":{height:11},"handle-bottom":{height:11}},tooltip:{shadow:1,"shadow-angle":45,"shadow-distance":1,"shadow-alpha":.25,"border-width":1,"border-color":"#fff","border-alpha":1},zoom:{"preserve-zoom":1,"background-color":"#929497"},legend:{"background-color":"#fff","border-width":1,shadow:0,"shadow-alpha":.2,alpha:1,"border-alpha":1,"border-color":"#cccccc",header:{padding:"5 0 5 10",color:"#222222","background-color":"none","border-width":0,"border-top":"0px solid none","border-bottom":"1px solid #cccccc"},footer:{padding:"5 0 5 10","border-top":"1px solid #cccccc"},shader:{"background-color":"#F0F1F1","line-color":"#C6C6C6",margin:2,height:8,"line-width":2,"line-style":"dotted"},icon:{"line-color":"#C6C6C6","line-width":2,style:"small"},marker:{"border-color":"#fff","border-width":1},"page-on":{"background-color":"#929497"},"page-off":{"background-color":"#D1D2D3"},scroll:{bar:{"background-color":"none","margin-top":3,"margin-bottom":3},handle:{"background-color":"#D1D2D3","border-top":"none","border-right":"none","border-bottom":"none","border-left":"none","border-radius":6,width:12,height:12}}},plot:{"value-box":{flat:!0},marker:{shadow:0,"line-width":1,"border-width":1,"border-color":"#fff"},"hover-marker":{"line-width":1,"border-width":1},monotone:!0},guide:{"line-width":1,"line-color":"#8C8C8C",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{padding:"3 6"}}},line:{plot:{"line-width":2,shadow:0,marker:{size:4},"hover-state":{},"hover-marker":{size:5,"border-width":1,"border-color":"#fff"}}},area:{plot:{"line-width":2,shadow:0,"alpha-area":.25,"background-color-style":"solid",marker:{size:4},"hover-state":{},"hover-marker":{size:5,"border-width":1,"border-color":"#fff"}}},vbar:{plot:{"fill-angle":90,shadow:0}},hbar:{plot:{"fill-angle":180,shadow:0}},piano:{plotarea:{"mask-tolerance":[0,0]},plot:{shadow:0},"scale-x":{guide:{visible:!0}}},stock:{plot:{shadow:0}},vbullet:{plot:{shadow:0,goal:{"border-width":1,"border-color":"#fff",height:8}}},hbullet:{plot:{"fill-angle":0,shadow:0,goal:{"border-width":1,"border-color":"#fff",width:8}}},scatter:{plot:{"line-color":"%palatte-0","border-color":"%palatte-0",marker:{size:5},"hover-marker":{size:6}},"scale-x":{guide:{visible:!0}}},hscatter:{plot:{"line-color":"%palatte-0","border-color":"%palatte-0",marker:{size:4},"hover-marker":{size:5}},"scale-x":{guide:{visible:!0}}},bubble:{plot:{marker:{"border-width":1,"border-color":"#fff"},"hover-marker":{"border-width":1,"border-color":"#fff"}},"scale-x":{guide:{visible:!0}}},hbubble:{plot:{marker:{"border-width":1,"border-color":"#fff"},"hover-marker":{"border-width":1,"border-color":"#fff"}},"scale-x":{guide:{visible:!0}}},pie:{plot:{shadow:0,"border-width":1,"value-box":{placement:"in","font-size":16,text:"%node-percent-value%"}}},nestedpie:{plot:{"border-width":1}},radar:{plot:{shadow:0,"line-width":2,"background-color":"%palette-1","active-area":!0,marker:{size:4},"hover-marker":{size:5,"border-color":"#fff"}},"scale-k":{guide:{"line-width":1,"line-style":"solid","line-color":"#8C8C8C","line-segment-size":6,"line-gap-size":6,alpha:1,"background-color":"#fff #F7F8F8"},tick:{"line-color":"#8C8C8C","line-width":1,size:10}},"scale-r":{},"scale-v":{"ref-line":{"line-color":"#8C8C8C","line-width":1},tick:{"line-color":"#8C8C8C","line-width":1},guide:{"line-color":"#CDCDCD","line-width":1}}},gauge:{plot:{shadow:0},scale:{"size-factor":1},"scale-r":{aperture:270,tick:{size:11,"line-width":2},"background-color":-1,guide:{"background-color":"#fff"},ring:{size:8,"background-color":"#CDCDCD"},center:{size:20,"background-color":"#fff","border-width":6,"border-color":"#1089B3"}}},vfunnel:{plotarea:{margin:"50 100"},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":1,"line-style":"solid","line-color":"#CDCDCD","line-segment-size":6,"line-gap-size":6,alpha:1},"minor-guide":{"line-width":0}},"scale-x":{visible:!1,guide:{visible:0}},"scale-y":{guide:{"background-color":"-1",alpha:1}},"scale-y-n":{guide:{"background-color":"-1"}},plot:{"border-width":1,"border-color":"#fff",shadow:0,"hover-state":{"line-color":"-1","border-color":"-1"}}},hfunnel:{plotarea:{margin:"50 100"},"scale-x":{visible:!1,guide:{visible:0},label:{"font-angle":270}},"scale-x-n":{label:{"font-angle":90}},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":1,"line-style":"solid","line-color":"#CDCDCD","line-segment-size":6,"line-gap-size":6,alpha:1},"minor-guide":{"line-width":0}},"scale-y":{guide:{"background-color":"-1",alpha:1},label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"},guide:{"background-color":"-1"}},plot:{"border-width":1,"border-color":"#fff",shadow:0,"hover-state":{"line-color":"-1","border-color":"-1"}}},range:{plot:{"background-color":"%palette-1",marker:{type:"circle",size:4},"hover-marker":{size:5}}},line3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},area3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},mixed3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},vbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},hbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},pie3d:{plot:{"border-width":1}},venn:{plot:{"border-width":0,shadow:0,alpha:.75,"background-color":"%palette-1"}},root:{gui:{"context-menu":{visible:!0,width:"125px",padding:"5 0","background-color":"#595959","border-width":0,"border-color":"#595959",position:"left",button:{visible:ZC.mobile,alpha:0},gear:{"background-color":"#000",type:"hamburger",alpha:1},item:{"background-color":"#595959","text-align":"left",padding:"4 20 4 15","border-width":0,"border-color":"#595959","font-size":"12px",color:"#fff","hover-state":{"background-color":"#414141"}},separator:{"line-width":1,"line-color":"#969696"}},"context-menu[mobile]":{item:{padding:"6 10 6 6"}}}},"-":""},this.NU.light.graph["crosshair-x"]=this.NU.light.graph["crosshair-y"]=this.NU.light.graph.guide,this.NU.dark={},ZC._cp_(this.NU.light,this.NU.dark,!0,!0),ZC._cp_({graph:{"background-color":"#221F1F",title:{color:"#fff"},subtitle:{color:"#fff"},source:{color:"#fff"},SCALE:{"line-color":"#D1D3D4",item:{color:"#D1D3D4"},"ref-line":{"line-color":"#D1D3D4"},guide:{"line-color":"#58595B"},"minor-guide":{"line-color":"#58595B"},tick:{"line-color":"#D1D3D4"},"minor-tick":{"line-color":"#D1D3D4"},label:{color:"#D1D3D4"}},scroll:{bar:{"background-color":"#6C6D70"},handle:{"background-color":"#A7A9AC"}},"scroll-x":{bar:{"border-top":"0px solid none","border-right":"2px solid #D1D3D4","border-bottom":"2px solid #D1D3D4","border-left":"2px solid #D1D3D4"},handle:{"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-y":{bar:{"border-top":"2px solid #D1D3D4","border-right":"0px solid none","border-bottom":"2px solid #D1D3D4","border-left":"2px solid #D1D3D4"}},preview:{"background-color":"#221F1F"},tooltip:{"border-color":"#000"},legend:{"background-color":"#221F1F",header:{color:"#fff",shader:{"background-color":"#414042","line-color":"#676667"}},footer:{color:"#D1D3D4","background-color":"#414042","border-top":"0px solid none","border-right":"2px solid #A7A9AC","border-bottom":"2px solid #A7A9AC","border-left":"2px solid #A7A9AC"},shader:{"background-color":"#414042","line-color":"#676667"},icon:{"line-color":"#676667"},"page-status":{color:"#D1D3D4"},"page-on":{"background-color":"#D1D2D3"},"page-off":{"background-color":"#929497"},marker:{"border-color":"#000"},item:{color:"#D1D3D4"}},plot:{marker:{"border-color":"#221F1F"}},guide:{"line-color":"#D1D3D4","scale-label":{"background-color":"#929497"},"plot-label":{"background-color":"#221F1F",color:"#FFF","border-color":"#5a5a5a"}}},line:{plot:{"hover-marker":{"border-color":"#221F1F"}}},area:{plot:{"hover-marker":{"border-color":"#221F1F"}}},vbullet:{plot:{goal:{"border-color":"#221F1F"}}},hbullet:{plot:{goal:{"border-color":"#221F1F"}}},bubble:{plot:{marker:{"border-color":"#221F1F"},"hover-marker":{"border-color":"#221F1F"}}},hbubble:{plot:{marker:{"border-color":"#221F1F"},"hover-marker":{"border-color":"#221F1F"}}},pie:{plot:{"border-color":"#221F1F"}},radar:{plot:{"hover-marker":{"border-color":"#221F1F"}},"scale-k":{guide:{"line-color":"#58595B","background-color":"#221F1F #312F30"},tick:{"line-color":"#D1D3D4"}},"scale-v":{"ref-line":{"line-color":"#58595B"},tick:{"line-color":"#58595B"},guide:{"line-color":"#58595B"}}},gauge:{"scale-r":{guide:{"background-color":"#221F1F"},ring:{"background-color":"#57585B"}}},vfunnel:{SCALE:{guide:{"line-color":"#58595B"}},plot:{"border-color":"#221F1F","hover-state":{"line-color":"#58595B","border-color":"#221F1F"}}},hfunnel:{SCALE:{guide:{"line-color":"#58595B"}},"scale-y":{guide:{alpha:.25,"background-color":"#b6c8cf -1"}},"scale-y-n":{guide:{alpha:.25,"background-color":"#b6c8cf -1"}},plot:{"border-color":"#221F1F","hover-state":{"line-color":"#58595B","border-color":"#221F1F"}}},root:{gui:{"context-menu":{gear:{"background-color":"#FFF"}}}},"-":""},this.NU.dark,!0,!0),this.NU.dark.graph["crosshair-x"]=this.NU.dark.graph["crosshair-y"]=this.NU.dark.graph.guide,this.NU.mini={graph:{title:{width:"100%",padding:"1 2 2","font-size":10},subtitle:{width:"100%",padding:"1 2 2","margin-top":14,"font-size":9},plotarea:{width:"100%",height:"100%",margin:"18 4 4 4"},SCALE:{visible:0},tooltip:{shadow:0,"border-radius":7},legend:{visible:0},preview:{visible:0},guide:{"line-width":1,"line-color":"#ccc",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{"border-color":"#ccc","border-radius":5,padding:"3 6"}},plot:{shadow:0,"value-box":{visible:0},"hover-state":{visible:0},"hover-marker":{visible:0},"max-trackers":99999,"max-nodes":99999}},line:{plot:{"line-width":1,marker:{type:"none"}}},line3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},area:{plot:{"line-width":1,marker:{type:"none"}}},area3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},scatter:{SCALE:{offset:5},plot:{marker:{size:3,shadow:!1,alpha:.8}}},hscatter:{SCALE:{offset:5},plot:{marker:{size:3,shadow:!1,alpha:.8}}},bubble:{SCALE:{offset:15},plot:{marker:{"fill-type":"none",shadow:!1,alpha:.8},"min-size":3,"max-size":9}},hbubble:{SCALE:{offset:15},plot:{marker:{"fill-type":"none",shadow:!1,alpha:.8},"min-size":3,"max-size":9}},pie:{plotarea:{margin:"18 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":.95}},pie3d:{plotarea:{margin:"32 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":1}},nestedpie:{plotarea:{margin:"18 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":.95}},radar:{plotarea:{margin:"18 4 4 4"},plot:{"line-width":1,marker:{shadow:0,size:2}},scale:{"size-factor":.95}},vbar3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},hbar3d:{"3d-aspect":{depth:20,angle:45,"x-angle":0,"y-angle":-20,"z-angle":0,zoom:.9}},venn:{plotarea:{margin:"18 4 4 4"},plot:{"border-width":0}},gauge:{plotarea:{margin:"18 4 4 4"},plot:{indicator:[5]},SCALE:{visible:1},scale:{"size-factor":.9},"scale-r":{"background-color":"-1",aperture:270,tick:{visible:0},item:{visible:0},guide:{visible:0},ring:{size:6,"background-color":"#CDCDCD",items:[]},center:{"border-width":0,size:2,"background-color":"#fff"}}},vfunnel:{plotarea:{margin:"18 4 4 4"}},hfunnel:{plotarea:{margin:"18 4 4 4"}},vbullet:{plot:{"bar-space":.5,goal:{"border-width":0,height:4}}},hbullet:{plot:{"bar-space":.5,goal:{"border-width":0,width:4}}},range:{plot:{"line-width":1,marker:{visible:0},"hover-state":{visible:0}}},"-":""},this.NU.negative={palette:[["#000","#909090","#969696","#9c9c9c"],["#000","#a0a0a0","#a6a6a6","#acacac"],["#000","#b0b0b0","#b6b6b6","#bcbcbc"],["#000","#c0c0c0","#c6c6c6","#cccccc"],["#000","#d0d0d0","#d6d6d6","#dcdcdc"],["#000","#e0e0e0","#e6e6e6","#ececec"],["#000","#f0f0f0","#f6f6f6","#fcfcfc"]],graph:{"background-color":"#111",title:{color:"#fff"},subtitle:{color:"#333"},SCALE:{"font-size":11,"line-width":2,"line-color":"#ccc",guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#ccc",alpha:.2},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#ccc",alpha:.2},tick:{visible:1,size:6,placement:"outer","line-width":2,"line-color":"#ccc"},"minor-tick":{visible:1,size:4,placement:"outer","line-width":1,"line-color":"#ccc"},label:{color:"#fff"},item:{color:"#fff"}}},radar:{"scale-k":{guide:{alpha:.5,"background-color":"#222 #333"}}},"-":""},this.NU.spark=this.NU.mini,this.B8={root:{gui:{behaviors:[{id:"PageScroll",enabled:"all"},{id:"ViewSource",enabled:"all"},{id:"BugReport",enabled:"none"},{id:"LogScale",enabled:"none"},{id:"LinScale",enabled:"none"},{id:"FullScreen",enabled:"none"},{id:"3D",enabled:"none"},{id:"ExportData",enabled:"none"},{id:"SaveAsImageJPG",enabled:"none"},{id:"DownloadCSV",enabled:ZC.ie678?"none":"all"},{id:"DownloadXLS",enabled:ZC.ie678?"none":"all"}],watermark:{type:1,position:"rb"},history:{margin:"10 auto auto 10",width:30,height:22,padding:4,item:{"background-color":"#369","border-width":1,"border-color":"#69c"},"item-off":{"background-color":"#eee","border-color":"#ddd"}},progress:{"background-color":"#fff",color:"#000"},"context-menu":{padding:0,"border-width":1,"border-color":"#000",button:{visible:ZC.mobile,margin:"5 auto auto 5",alpha:.8,"background-color":"#333 #999","border-radius":8,width:40,height:40},gear:{"background-color":"#fff #f6f6f6",type:"gear6",alpha:.8},item:{"background-color":"#36393D","text-align":"left",padding:"4 20 4 8","border-width":1,"border-color":"#000",color:"#fff","hover-state":{"background-color":"#0084AA"}},separator:{"line-width":1,"line-color":"#000000"}},"context-menu[mobile]":{item:{padding:"6 10 6 6"}}}},palette:[],graph:{title:{width:"100%",bold:1,"font-size":13},subtitle:{width:"100%",bold:1,"font-size":11},scroll:{bar:{"background-color":"#e1eaec","border-color":"#ddd"},handle:{"background-color":"#ddd","border-color":"#ccc","border-width":2,"border-top":"2px solid #eee","border-left":"2px solid #eee","border-right":"2px solid #999","border-bottom":"2px solid #999"}},"scroll-x":{bar:{height:16},handle:{height:16}},"scroll-y":{bar:{width:16},handle:{width:16}},"scroll-xi":{bar:{width:16},handle:{width:16}},"scroll-yi":{bar:{height:16},handle:{height:16}},preview:{width:"100%",height:50,margin:"auto 50 20 50","border-width":1,shadow:0,"background-color":"#f0f0f0","border-color":"#999",mask:{alpha:.5,"background-color":"#333"},active:{alpha:.1,"background-color":"#999"},handle:{width:9,height:16,"border-width":1,"line-width":1,"line-color":"#111","border-color":"#444","border-radius":2,"background-color":"#e6e6e6"},"handle-top":{width:16,height:9},"handle-bottom":{width:16,height:9}},"preview[yx]":{width:50,height:"100%",margin:"20 auto 50 20"},plotarea:{width:"100%",height:"100%",margin:"60 50 65 50"},"plotarea[preview]":{margin:"60 50 105 50"},SCALE:{"line-width":1,guide:{"line-width":1,"line-color":"#ddd"},tick:{size:6,"line-width":2},"minor-guide":{"line-width":1,"line-color":"#ddd"},"minor-tick":{size:4,"line-width":1},label:{bold:1,padding:6,flat:!0},item:{padding:2,"auto-align":!0,flat:!0},marker:{"line-width":1,"line-color":"#000","background-color":"#ccc"},"transform[date]":{item:{"font-size":10,padding:2,color:"#000","background-color":"#fff"}}},"SCALE[3d]":{"background-color":"#ccc"},"scale-y[default]":{label:{"font-angle":270},item:{"text-align":"right"}},"scale-y[opposite]":{label:{"font-angle":90},item:{"text-align":"left"}},plot:{error:{"line-width":1,"line-color":"#333",size:.5},"value-box":{flat:!0,text:"%v",bold:1,placement:"auto",shadow:1},"tooltip-text":"%v",shadow:1,"line-width":1,marker:{type:"square",shadow:1},"highlight-state":{shadow:!0,"shadow-blur":2,"shadow-distance":1,"shadow-alpha":.91}},tooltip:{shadow:1,padding:"4 8","shadow-distance":3,"offset-y":ZC.mobile?-40:-20},"tooltip[dynamic]":{padding:"4 8","offset-y":0},guide:{marker:{type:"circle"},"plot-label[single]":{text:'<b style="color:%color">%plot-text:</b> %node-value',padding:10,"background-color":"#fff #eee","border-width":1,"border-color":"#999",color:"#000","text-align":"left"},"plot-label[multiple]":{text:'<b style="color:%color">%plot-text:</b> %node-value',padding:5,"background-color":"#fff #eee","border-width":1,"border-color":"#999",color:"#000","text-align":"left"}},zoom:{"preserve-zoom":1,"border-width":0,"background-color":"#369",alpha:.25,label:{visible:!1,"background-color":"#fff","font-size":10,padding:2,"border-width":1,"border-color":"#999"}},arrow:{"border-width":1,"border-color":"#000","background-color":"#666",size:4},"legend[position]":{margin:10},legend:{"background-color":"#eee",alpha:1,shadow:1,margin:"10 10 auto auto",padding:"4 2 4 2",item:{"text-align":"left",margin:"2 6 2 4",padding:"2 4"},"item-off":{alpha:.25},marker:{shadow:0,size:6,"border-color":"#999","border-width":1},header:{"font-size":12,"text-align":"left",bold:1},footer:{"text-align":"left"},icon:{"line-color":"#000","line-width":1},"page-status":{color:"#000"},"page-on":{"background-color":"#f90"},"page-off":{"background-color":"#999"},scroll:{bar:{width:12,height:12,"background-color":"#e1eaec","border-color":"#ddd"},handle:{width:12,height:12,"background-color":"#ddd","border-color":"#ccc","border-width":2,"border-top":"2px solid #eee","border-left":"2px solid #eee","border-right":"2px solid #999","border-bottom":"2px solid #999"}}}},vbar:{plot:{"value-box":{placement:"top-out"}}},vbar3d:{plot:{"value-box":{placement:"top-out"}},"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0}},mixed3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0}},hbar:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}},plot:{"value-box":{placement:"top-out"}}},vline:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}}},varea:{plot:{"fill-angle":0},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}}},hbar3d:{"scale-y":{label:{"font-angle":0}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0}},"scale-x-n":{label:{"font-angle":90}},"3d-aspect":{depth:40,angle:45,"x-angle":0,"y-angle":-20,"z-angle":0},plot:{"value-box":{placement:"top-out"}}},hbullet:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}}},line:{plot:{"line-width":4,marker:{type:"circle",size:4}}},area:{plot:{"line-width":4,marker:{type:"circle",size:4},"value-box":{placement:"top"}}},line3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0},plot:{"border-width":1,"line-width":1,marker:{type:"circle",size:4,alpha:1,visible:0}}},area3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0},plot:{"border-width":1,"line-width":1,marker:{type:"circle",size:4,alpha:1,visible:0},"value-box":{placement:"top"}}},scatter:{SCALE:{offset:10},plot:{marker:{type:"circle",size:4},"value-box":{placement:"top"}}},poly:{SCALE:{offset:10},plot:{"alpha-area":.4,marker:{type:"none"},"value-box":{placement:"top"}}},hscatter:{SCALE:{offset:10},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}},plot:{marker:{type:"circle",size:4},"value-box":{placement:"top"}}},bubble:{SCALE:{offset:40},plot:{marker:{type:"circle","fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"hover-marker":{"fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"value-box":{placement:"middle",text:"%node-size-value"},"tooltip-text":"%node-size-value"}},hbubble:{SCALE:{offset:40},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}},plot:{marker:{type:"circle","fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"hover-marker":{"fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"value-box":{placement:"middle",text:"%node-size-value"},"tooltip-text":"%node-size-value"}},hmixed:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}}},pie:{plotarea:{margin:"35 5 5 5"},scale:{"size-factor":"auto","line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"radial","value-box":{connector:{"line-width":1},placement:"out",text:"%t",visible:1}}},pie3d:{"3d-aspect":{"x-angle":38,"y-angle":0,"z-angle":0},plotarea:{margin:"25 5 5 5"},scale:{"size-factor":"auto","line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"linear","value-box":{connector:{"line-width":1},placement:"out",text:"%t",visible:1}}},nestedpie:{plotarea:{margin:"40 5 15 5"},scale:{"size-factor":.8,"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"radial","value-box":{connector:{"line-width":1},text:"%t",visible:1}}},venn:{plotarea:{margin:"30 10 10 10"},plot:{alpha:.5,"border-width":4},scale:{"size-factor":.65,"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}}},radar:{SCALE:{guide:{"line-width":1,"line-color":"#999","background-color":"-1"},tick:{"line-width":1},item:{"auto-align":!1}},scale:{visible:0,"size-factor":.7},"scale-k":{"ref-angle":270},plotarea:{margin:"40 5 5 5"},plot:{"line-width":4,aspect:"line",marker:{type:"circle"}}},gauge:{SCALE:{guide:{"border-width":1,"border-color":"#999","background-color":"-1"}},scale:{"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0},"size-factor":.7},"scale-r":{"ref-angle":270,"background-color":"#fff",guide:{"line-width":0},tick:{placement:"inner"},item:{"offset-r":"-45%"}},plot:{size:"85%"},plotarea:{margin:"40 5 5 5"}},stock:{plot:{"line-width":1,"border-width":1,"tooltip-text":"Open:&nbsp;$%open<br>High:&nbsp;$%high<br>Low:&nbsp;$%low<br>Close:&nbsp;$%close"}},range:{plot:{"line-width":2,"value-box":{text:"%node-min-value - %node-max-value"},"tooltip-text":"%node-min-value - %node-max-value"}},"-":""},this.PF=function(e,t){var i,n=this,a=!1;return null!==ZC._n_(i=n.B8.graph[e])&&null!==ZC._n_(i.enabled)&&(a=a||ZC._b_(i.enabled)),null!==ZC._n_(n.B8[t])&&null!==ZC._n_(i=n.B8[t][e])&&null!==ZC._n_(i.enabled)&&(a=a||ZC._b_(i.enabled)),a},this.load=function(e,t,i,n){var a,r,l,o=this;i=null===ZC._n_(i)||ZC._b_(i),n=null!==ZC._n_(n)&&ZC._b_(n),t instanceof Array||(t=new Array(t));var s=[],c="";for(r=0,l=t.length;r<l;r++)if(/(\(\w+\))(.*)/.test(t[r])){var h=RegExp.$1;c=t[r].replace(h,"graph"),-1===ZC.AV(s,c)&&s.push(c),c=t[r].replace(h,h.substring(1,h.length-1)),-1===ZC.AV(s,c)&&s.push(c)}else-1===ZC.AV(s,t[r])&&s.push(t[r]),/root(.*)/.test(t[r])&&-1===ZC.AV(s,t[r].replace("root","loader"))&&s.push(t[r].replace("root","loader")),/loader(.*)/.test(t[r])&&-1===ZC.AV(s,t[r].replace("loader","root"))&&s.push(t[r].replace("loader","root"));var C={};for(r=0,l=s.length;r<l;r++){for(var u=s[r].split("."),d=o.B8,p=0,A=u.length;p<A;p++)if(null!==ZC._n_(a=d[u[p]]))d=a;else if(null!==ZC._n_(a=d[ZC.U7(u[p])]))d=a;else{if(null===ZC._n_(a=d[ZC.EC(u[p])])){d=null;break}d=a}if(d)for(var g in d)null!==ZC._n_(d[g])&&(n||"object"!=typeof d[g]||d[g].length)&&(i||null===ZC._n_(e[g])?o.H.QP&&null!==ZC._n_(o.H.QP[g])||(C[g]=d[g]):i&&"object"==typeof d[g]&&(o.H.QP&&null!==ZC._n_(o.H.QP[g])||(C[g]=d[g])))}ZC._cp_(C,e)}},ZC.AP={AGL:function(e,t){for(var i=[],n=0,a=e.p.length;n<a;n++)if(e.p[n]){var r=(e.p[n][0]-e.x)/e.w,l=(e.p[n][1]-e.y)/e.h;i.push([t.x+t.w*r,t.y+t.h*l])}else i.push(null);return{l:t.w*e.l/e.w,r:t.w*e.r/e.w,p:i}},AC7:function(e,t,i){var n=document.getElementsByTagName("head")[0],a=document.createElement("script");a.type="text/javascript",a.src=t+"?v"+ZC.VERSION;var r=!1;a.onload=a.onreadystatechange=function(){if(!(r||this.readyState&&"loaded"!==this.readyState&&"complete"!==this.readyState)){r=!0,a.onload=a.onreadystatechange=null,n&&a.parentNode&&n.removeChild(a);var e=new RegExp("zingchart-(.+?).min.js","g").exec(t);e&&ZC.WA.push(e[1]),i&&i(t)}},a.onerror=function(){!e&&zingchart.HU[0]&&(e=zingchart.HU[0]),e?e.NP({name:"Network error",message:"Resource not found ("+a.src+")"},"Module loader"):alert("Resource not found ("+a.src+")")},n.insertBefore(a,n.firstChild)},_rcolor_:function(){return"#"+ZC.XL.md5(ZC._r_(0,99999)).substr(ZC._r_(0,20),6)},WM:function(){},A7Y:function(e,t){return zingchart[e]||t&&t.A0V&&t.A0V[e]||zingchart.hasEvent(null,e)||t&&zingchart.hasEvent(t.K,e)},BZ:function(e,t,i,n,a){i instanceof Array||(i=[i]);var r=1;return null!==ZC._n_(n)&&i.push(n),a&&(r=2,i.push(a)),"touchstart"===e&&(e="mousedown"),"touchend"===e&&(e="mouseup"),"touchmove"===e&&(e="mousemove"),zingchart[e]&&"render"!==e&&(null!==ZC._n_(n)?i[i.length-r]=zingchart[e].apply(zingchart,i):zingchart[e].apply(zingchart,i)),t&&t.A0V[e]&&(null!==ZC._n_(n)?i[i.length-r]=t.A0V[e].apply(zingchart,i):t.A0V[e].apply(zingchart,i)),zingchart.hasEvent(null,e)&&(null!==ZC._n_(n)?i[i.length-r]=zingchart.callEvent(null,e,i,n):zingchart.callEvent(null,e,i)),t&&zingchart.hasEvent(t.K,e)&&(null!==ZC._n_(n)?i[i.length-r]=zingchart.callEvent(t.K,e,i,n):zingchart.callEvent(t.K,e,i)),i[i.length-r]},O1:function(e,t){if(t.AA%360!=0){for(var i=[[-t.I/2,-t.F/2],[t.I/2,-t.F/2],[t.I/2,t.F/2],[-t.I/2,t.F/2]],n="",a=0;a<4;a++)i[a]=[t.iX+t.I/2+t.BJ+ZC.MAPTX+i[a][0]*ZC.EF(t.AA)-i[a][1]*ZC.EO(t.AA),t.iY+t.F/2+t.BH+ZC.MAPTX+i[a][0]*ZC.EO(t.AA)+i[a][1]*ZC.EF(t.AA)],n+=ZC._i_(i[a][0])+","+ZC._i_(i[a][1])+",";return t.E=i,ZC.Q.GC("poly",t.E8,t.IR)+'class="'+e+'-label-area zc-label-area" id="'+t.K+'-area" coords="'+n.substring(0,n.length-1)+'" />'}return ZC.Q.GC("rect",t.E8,t.IR)+'class="'+e+'-label-area zc-label-area" id="'+t.K+'-area" coords="'+ZC._i_(t.iX+t.BJ+ZC.MAPTX)+","+ZC._i_(t.iY+t.BH+ZC.MAPTX)+","+ZC._i_(t.iX+t.BJ+t.I+ZC.MAPTX)+","+ZC._i_(t.iY+t.BH+t.F+ZC.MAPTX)+'" />'},MY:function(e){var t,i="",n=e.indexOf('id="');if(-1!==n){var a=e.indexOf('"',n+4);-1!==a&&(i=e.substring(n+4,a))}if(ZC.cache.data["area-score-"+i])return ZC.cache.data["area-score-"+i];var r=0;if(-1!==e.indexOf('shape="rect"')?(r+=1e4,5===(t=/coords=\"(\-*\d+),(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e)).length&&(r+=(ZC._i_(t[3])-ZC._i_(t[1]))*(ZC._i_(t[4])-ZC._i_(t[2])))):-1!==e.indexOf('shape="circle"')?(r+=100,t=/coords=\"(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e),null!==ZC._n_(t[3])&&(r+=ZC._i_(t[3])/10)):-1!==e.indexOf('shape="poly"')?-1!==e.indexOf("data-map")?r+=1e6:r+=1e3:r+=1,-1!==e.indexOf("data-z-sort")){var l=/data-z-sort=\"(\-*\d+)\"/.exec(e);l&&2===l.length&&(r*=ZC._i_(Math.pow(10,ZC._i_(l[1]))))}return""!==i&&ZC.cache.add("area-score-"+i,r),r},A4Q:function(e,t,i){for(var n=[],a=0,r=e.length;a<r;a++)if(null!==ZC._n_(e[a])){var l=e[a].slice(0);null!==ZC._n_(l[0])&&"string"!=typeof l[0]&&(l[0]+=t),null!==ZC._n_(l[1])&&"string"!=typeof l[1]&&(l[1]+=i),null!==ZC._n_(l[2])&&"string"!=typeof l[2]&&l.length<=4&&(l[2]+=t),null!==ZC._n_(l[3])&&"string"!=typeof l[3]&&l.length<=4&&(l[3]+=i),n.push(l)}else n.push(null);return n},OQ:function(e,t){var i;t=t||{},e=e||{};var n={};if(null!==ZC._n_(i=e.negation)&&(n.negation=i),null!==ZC._n_(i=e["short"])&&(n["short"]=ZC._b_(i)),null!==ZC._n_(i=e["short-unit"])&&(n["short-unit"]=i),null!==ZC._n_(i=e.exponent)&&(n.exponent=ZC._b_(i)),null!==ZC._n_(i=e["exponent-decimals"])&&(n["exponent-decimals"]=ZC._i_(i)),null!==ZC._n_(i=e["decimals-separator"])?n["decimals-separator"]=i:null===ZC._n_(t["decimals-separator"])&&null!==ZC._n_(i=ZC.HI["decimals-separator"])&&(n["decimals-separator"]=i),null!==ZC._n_(i=e["thousands-separator"])?n["thousands-separator"]=i:null===ZC._n_(t["thousands-separator"])&&null!==ZC._n_(i=ZC.HI["thousands-separator"])&&(n["thousands-separator"]=i),null!==ZC._n_(i=e.decimals)&&(n.decimals=ZC._i_(i)),null!==ZC._n_(i=e["decimals-dyn"])&&(n["decimals-dyn"]=i),null!==ZC._n_(i=e.transform)&&null!==ZC._n_(i.type))switch(i.type){case"date":n["transform-date"]=!0,null!==ZC._n_(i.text)&&(i.all=i.text),null!==ZC._n_(i.all)&&(n["transform-date-format"]=i.all)}return n},GF:function(e,t,i,n){var a,r=e,l=e+"",o=!1;if(n&&null!==ZC._n_(t["transform-date"])&&t["transform-date"]&&""+Number(l)===l&&(l=ZC.AP.Y2(Number(l),t["transform-date-format"],t.utc,t.timezone),o=!0),null===ZC._n_(t["decimals-separator"])&&null!==ZC._n_(e=ZC.HI["decimals-separator"])&&(t["decimals-separator"]=e),null===ZC._n_(t["thousands-separator"])&&null!==ZC._n_(e=ZC.HI["thousands-separator"])&&(t["thousands-separator"]=e),null!==ZC._n_(t.decimals)&&-1!==t.decimals&&"undefined"!=typeof t["max-decimals"]&&-1!==t["max-decimals"]&&(t.decimals=ZC.BQ(t["max-decimals"],t.decimals)),!o)if(null!==ZC._n_(t.exponent)&&t.exponent)l=Number(l).toExponential(ZC.CY(20,t["exponent-decimals"])),null!==ZC._n_(t["decimals-separator"])&&(l=l.replace(/\./g,t["decimals-separator"]));else{if(null!==ZC._n_(t["short"])&&t["short"]){a="";var s=t["short-unit"]||"";if("string"!=typeof s&&s.length){""+ZC._f_(s[0])!==s[0]&&(s=[1e3].concat(s));for(var c=1,h=s[0]||1e3,C=s.slice(1),u=null,d=0;d<C.length;d++)0===C[d].indexOf("#")&&(u=d,C[d]=C[d].substring(1));if(C.length){if(null!==u)c=u;else if(null!==ZC._n_(t["max-power"]))c=t["max-power"];else{var p=ZC.H0(ZC._a_(Number(l)),h);c=Math.floor(p),c=ZC.CY(c,C.length-1)}a=C[c];var A=(l=""+Number(l)/Math.pow(h,c)).split(".");2===A.length&&A[1].length>=9&&(l=null!==ZC._n_(t.decimals)&&-1!==t.decimals?""+ZC._x_(l,t.decimals):""+ZC._x_(l))}}else{var g=ZC.H0(ZC._a_(Number(l)))/Math.LN10;switch(ZC._a_(Number(l))){case 1e3:g=3;break;case 1e6:g=6;break;case 1e9:g=9}if(null!==ZC._n_(t["max-power"])&&(g=3*t["max-power"]),"KB"===s.toUpperCase())l=""+Number(l)/1024,a="KB";else if("MB"===s.toUpperCase())l=""+Number(l)/1048576,a="MB";else if("GB"===s.toUpperCase())l=""+Number(l)/1073741824,a="GB";else if("TB"===s.toUpperCase())l=""+Number(l)/1099511627776,a="TB";else if("PB"===s.toUpperCase())l=""+Number(l)/0x4000000000000,a="PB";else if(g>=0&&g<3)switch(s){default:l=l,a="";break;case"K":l=""+Number(l)/1e3,a="K";break;case"M":l=""+Number(l)/1e6,a="M";break;case"B":l=""+Number(l)/1e9,a="B"}else g>=3&&g<6&&""===s||"K"===s.toUpperCase()?(l=""+Number(l)/1e3,a="K"):g>=6&&g<9&&""===s||"M"===s.toUpperCase()?(l=""+Number(l)/1e6,a="M"):(g>=9&&""===s||"B"===s.toUpperCase())&&(l=""+Number(l)/1e9,a="B")}if(ZC.P4(l))if(null!==ZC._n_(t.decimals)&&-1!==t.decimals)l=ZC._fixed_(Number(l),ZC.BQ(0,ZC._i_(t.decimals)));else{var f=l.split(".")[1]||"";-1!==t["max-decimals"]&&t["max-decimals"]<f.length&&(l=ZC._fixed_(Number(l),ZC.BQ(0,ZC._i_(t["max-decimals"]))))}null!==ZC._n_(t["decimals-separator"])&&(l=l.replace(/\./g,t["decimals-separator"]))}var Z=i?i.K:"";if(!isNaN(l)&&("string"!=typeof r||-1===Z.indexOf("-scale-"))){if(null!==ZC._n_(t.decimals)&&-1!==t.decimals&&ZC.P4(l)&&(null!==ZC._n_(t["short"])&&t["short"]||(l=ZC._fixed_(Number(l),ZC.BQ(0,ZC._i_(t.decimals))))),null!==ZC._n_(t["thousands-separator"])||null!==ZC._n_(t["decimals-separator"])){for(var _=l.split("."),b="",m=0,v=_[0].length;m<v;m++){var D=_[0].substring(m,m+1);b+=D,-1===ZC.AV(["-","+"],D)&&(_[0].length-m-1)%3==0&&_[0].length-m-1!=0&&(b+=t["thousands-separator"])}l=b+(null!==ZC._n_(_[1])?t["decimals-separator"]+_[1]:"")}null!==ZC._n_(t["short"])&&t["short"]&&(l+=a)}}return l},AA8:function(e){var t=e.indexOf("("),i="",n="";-1!==t?(i=ZC.GT(e.substring(0,t)),n=ZC.GT(e.substring(t+1,e.length-1))):i=ZC.GT(e);var a=[],r="";if(""!==n){var l=!1,o=!1,s=!1;r="";for(var c=0,h=n.length;c<h;c++){var C=n.substring(c,c+1);switch(C){case"\\":s?(r+="\\",s=!1):s=!0;break;case'"':s?(r+='"',s=!1):o?(a.push(r),r="",o=!1):l?r+=C:o=!0;break;case"'":s?(r+="'",s=!1):l?(a.push(r),r="",l=!1):o?r+=C:l=!0;break;case" ":(l||o)&&(r+=C);break;case",":l||o?r+=C:(""!==r&&a.push(r),r="");break;default:r+=C}}}return""!==r&&a.push(r),[i,a]},A59:function(e){return e.toString().replace(/^([0-9])$/,"0$1")},Y2:function(e,t,i,n){e=ZC._i_(e),t=t||ZC.HI["date-formats"].minute,void 0===i&&(i=!1),void 0===n&&(n=0),i&&(e+=36e5*n);var a,r,l,o,s,c,h,C,u=new Date;u.setTime(e),i?(a=u.getUTCHours(),r=u.getUTCMinutes(),l=u.getUTCSeconds(),o=u.getUTCMilliseconds(),s=u.getUTCDay(),c=u.getUTCDate(),h=u.getUTCMonth(),C=u.getUTCFullYear()):(a=u.getHours(),r=u.getMinutes(),l=u.getSeconds(),o=u.getMilliseconds(),s=u.getDay(),c=u.getDate(),h=u.getMonth(),C=u.getFullYear());for(var d=[["mm",ZC.AP.A59(h+1)],["dd",ZC.AP.A59(c)],["Y",C],["y",C.toString().substr(2,2)],["F",ZC.HI["months-long"][h]],["m",h+1],["M",ZC.HI["months-short"][h]],["n",h],["d",c],["D",ZC.HI["days-short"][s]],["j",c],["l",ZC.HI["days-long"][s]],["N",s+1],["w",s],["S",function(){return c%10==1?"st":c%10==2?"nd":c%10==3?"rd":"th"}],["a",a<12?"am":"pm"],["A",a<12?"AM":"PM"],["g",a%12||12],["G",a],["h",ZC.AP.A59(a%12||12)],["H",ZC.AP.A59(a)],["i",ZC.AP.A59(r)],["s",ZC.AP.A59(l)],["q",o]],p=0;p<d.length;p++)t=t.replace("%"+d[p][0],d[p][1]);return t},A03:{},YV:function(e,t){var i=null;if(t&&t.BP?i=t.BP:t&&t.A&&t.A.BP&&(i=t.A.BP),"string"==typeof e&&-1!==e.indexOf("%color-")&&ZC.COLORS.length>0)for(var n=0;n<ZC.COLORS.length;n++)-1===e.indexOf("(+")&&-1===e.indexOf("(-")||(e=e.replace(/%color-(\d+?)\((\+|\-)(\d+?)\)/gi,function(){var e=ZC.AP.G5(ZC.COLORS[ZC._i_(arguments[1])]);return"+"===arguments[2]?e=ZC.AP.QT(e,ZC._i_(arguments[3])):"-"===arguments[2]&&(e=ZC.AP.JH(e,ZC._i_(arguments[3]))),e})),e=e.replace("%color-"+n,ZC.COLORS[n]);else"string"==typeof e&&i&&-1!==e.indexOf("%palette-")&&(e=i[ZC._i_(e.replace("%palette-",""))]);return e},G5:function(e,t){var i,n,a,r;if(null!==ZC._n_(ZC.AP.A03[e]))return ZC.AP.A03[e];var l=ZC.GT(String(e)),o=1,s=!1;return 0===l.length?"":("rgba("===(l=l.replace("0x","#")).substring(0,5)?(i=new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3}),\\s*([0-9.]+)\\)","gi").exec(l))&&(1===(n=ZC.OS(i[1])).length&&(n="0"+n),1===(a=ZC.OS(i[2])).length&&(a="0"+a),1===(r=ZC.OS(i[3])).length&&(r="0"+r),l="#"+n+a+r,o=ZC.BQ(0,ZC.CY(1,parseFloat(i[4]))),s=!0):"rgb("===l.substring(0,4)?(i=new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)","gi").exec(l))&&(1===(n=ZC.OS(i[1])).length&&(n="0"+n),1===(a=ZC.OS(i[2])).length&&(a="0"+a),1===(r=ZC.OS(i[3])).length&&(r="0"+r),l="#"+n+a+r):"#"===l.substring(0,1)?4===l.length?l="#"+l.substring(1,2)+l.substring(1,2)+l.substring(2,3)+l.substring(2,3)+l.substring(3,4)+l.substring(3,4):7!==l.length&&(l=""):null!==ZC._n_(ZC.Q.A9H[l.toUpperCase()])&&(l="#"+ZC.Q.A9H[l.toUpperCase()]),"none"!==l&&"transparent"!==l||(l="-1"),t||(ZC.AP.A03[e]=l),t&&s?[l,o]:l)},A1M:{},A2M:function(e,t){if(-1===e&&(e="#ffffff",t=0),null!==ZC._n_(ZC.AP.A1M[e+","+t]))return ZC.AP.A1M[e+","+t];4===e.length&&(e=e.substring(0,1)+e.substring(1,2)+e.substring(1,2)+e.substring(2,3)+e.substring(2,3)+e.substring(3,4)+e.substring(3,4));var i="rgba("+[ZC.QE(e.substring(1,3)),ZC.QE(e.substring(3,5)),ZC.QE(e.substring(5,7)),t].join(",")+")";return ZC.AP.A1M[e+","+t]=i,i},AD4:function(e,t,i){e/=255,t/=255,i/=255;var n,a,r,l=Math.max(e,t,i),o=Math.min(e,t,i);r=l;var s=l-o;if(a=0===l?0:s/l,l===o)n=0;else{switch(l){case e:n=(t-i)/s+(t<i?6:0);break;case t:n=(i-e)/s+2;break;case i:n=(e-t)/s+4}n/=6}return[n,a,r]},AD6:function(e,t,i){var n,a,r,l=Math.floor(6*e),o=6*e-l,s=i*(1-t),c=i*(1-o*t),h=i*(1-(1-o)*t);switch(l%6){case 0:n=i,a=h,r=s;break;case 1:n=c,a=i,r=s;break;case 2:n=s,a=i,r=h;break;case 3:n=s,a=c,r=i;break;case 4:n=h,a=s,r=i;break;case 5:n=i,a=s,r=c}return[255*n,255*a,255*r]},JH:function(e,t){if(-1===e)return-1;if(t>=100)return"#000000";e=ZC.AP.G5(e),void 0===t&&(t=10);var i=ZC.QE(e.substring(1,3)),n=ZC.QE(e.substring(3,5)),a=ZC.QE(e.substring(5,7)),r=ZC.AP.AD4(i,n,a);r[2]=t>0?Math.max(0,r[2]-r[2]*t/100):Math.min(1,r[2]-r[2]*t/100);var l=ZC.AP.AD6(r[0],r[1],r[2]);return l[0]=ZC._i_(l[0])<16?"0"+ZC.OS(l[0]):ZC.OS(l[0]),l[1]=ZC._i_(l[1])<16?"0"+ZC.OS(l[1]):ZC.OS(l[1]),l[2]=ZC._i_(l[2])<16?"0"+ZC.OS(l[2]):ZC.OS(l[2]),e="#"+l[0]+l[1]+l[2]},QT:function(e,t){if(-1===e)return-1;if(t>=100)return"#ffffff";e=ZC.AP.G5(e),void 0===t&&(t=10);var i=parseInt(e.substr(1,2),16),n=parseInt(e.substr(3,2),16),a=parseInt(e.substr(5,2),16);return"#"+(0|256+i+(256-i)*t/100).toString(16).substr(1)+(0|256+n+(256-n)*t/100).toString(16).substr(1)+(0|256+a+(256-a)*t/100).toString(16).substr(1)},_hex2rgb_:function(e,t){var i=parseInt(e.substr(1,2),16),n=parseInt(e.substr(3,2),16),a=parseInt(e.substr(5,2),16);return ZC._n_(t)?"rgb("+i+","+n+","+a+")":{r:i,g:n,b:a}},_rgb2hex_:function(e,t,i){return"#"+((1<<24)+(e<<16)+(t<<8)+i).toString(16).slice(1)},AA3:function(e,t,i){var n=ZC.AP._hex2rgb_(e);return(299*n.r+587*n.g+114*n.b)/1e3>=128?i:t},_colorAlpha_:function(e,t,i){e=ZC.AP.G5(e),t=ZC.AP.G5(t);var n=ZC.AP._hex2rgb_(e),a=ZC.AP._hex2rgb_(t),r={};for(var l in n)r[l]=Math.floor(i*n[l]+(1-i)*a[l]);return ZC.AP._rgb2hex_(r.r,r.g,r.b)},A30:function(){},ABL:function(){},gc:function(e,t){var i;for(i=0;i<t.length;i++)e[t[i]]=null;for(i in e)0===i.indexOf("zc_")&&"function"==typeof e[i]&&(e[i]=null)}},ZC.Q={A9H:{BLACK:"000000",BLUE:"0000FF",BROWN:"A52A2A",CYAN:"00FFFF",FUCHSIA:"FF00FF",GOLD:"FFD700",GRAY:"808080",GREEN:"008000",INDIGO:"4B0082",LIME:"00FF00",MAGENTA:"FF00FF",MAROON:"800000",NAVY:"000080",ORANGE:"FFA500",PINK:"FFC0CB",PURPLE:"800080",RED:"FF0000",SILVER:"C0C0C0",TURQUOISE:"40E0D0",VIOLET:"EE82EE",WHITE:"FFFFFF",YELLOW:"FFFF00"},GC:function(e,t,i){return"<area"+(i&&!t&&"hand"!==i?' style="cursor:'+i+'"':"")+(t&&"arrow"!==i||"hand"===i?' href="javascript:;"':"")+' shape="'+e+'" '},AB2:function(e){var t;if(ZC.A4.browser.msie)try{t=document.createElement("<iframe />")}catch(o){t=document.createElement("iframe")}else t=document.createElement("iframe");t.id=e.id+"-iframe",t.style.visibility="hidden",e.appendChild(t);var i=null,n=t.contentWindow||t.contentDocument;if(!(i=n.document?n.document:n).body){var a=i.createElement("HTML");i.appendChild(a);var r=i.createElement("HEAD");a.appendChild(r);var l=i.createElement("BODY");a.appendChild(l)}return i},C0:function(e){var t;if("undefined"==typeof ZC.TOUCHEVENTS){if(ZC.ie678)t=!1;else{t=!0;try{document.createEvent("TouchEvent")}catch(i){t=!1}}t&&!ZC.mobile&&(t=!1),t&&(t="ontouchstart"in document.documentElement),ZC.TOUCHEVENTS=t}else t=ZC.TOUCHEVENTS;if(t)switch(e){case"mouseover":case"mousedown":e="touchstart";break;case"mousemove":e="touchmove";break;case"mouseout":case"mouseup":e="touchend";break;case"click":e="touchstart"}return e},_sh_:function(e,t){var i,n,a,r=[],l=t.JP,o=t.OE,s=t.P1,c=l-s/2;if(e.length>0){var h=0,C=0;for(0!==l&&(h=ZC._i_(c*ZC.EF(o)+s),C=ZC._i_(c*ZC.EO(o)+s)),i=0,n=e.length;i<n;i++)if(null!==ZC._n_(e[i])){var u=[];for(a=0;a<e[i].length;a++)u[a]=e[i][a];var d=u.length;if(2===d||4===d)for(a=0;a<d;a++)u[a]=e[i][a]+(a%2?C+ZC._c_(t.BH,0):h+ZC._c_(t.BJ,0));r.push(u)}else r.push(null)}return r},_txp_:function(e,t,i,n,a){void 0===a&&(a=!1);var r,l,o=[e[0],e[1]];switch(e.length>=4&&(o[2]=e[2],o[3]=e[3]),e.length>=6&&(o[4]=e[4],o[5]=e[5]),7===e.length&&(o[6]=e[6]),t){case"canvas":case"svg":if(i.CZ){var s,c;s=c=i.B0%2==1?.5:0,ZC.A4.browser.msie&&ZC.quirks&&"svg"===t&&(s=i.B0%2==1?.5:0,c=i.B0%2==1?0:.5),o[0]=Math.round(o[0])-s,o[1]=Math.round(o[1])-c,4===o.length&&(o[2]=Math.round(o[2])-s,o[3]=Math.round(o[3])-c)}"svg"===t&&(o[0]=parseFloat(o[0].toFixed(4)),o[1]=parseFloat(o[1].toFixed(4)),4===o.length&&(o[2]=parseFloat(o[2].toFixed(4)),o[3]=parseFloat(o[3].toFixed(4)))),"canvas"!==t||n||"undefined"!=typeof i.BJ&&"undefined"!=typeof i.BH&&(o[0]+=i.BJ,o[1]+=i.BH,4===o.length&&(o[2]+=i.BJ,o[3]+=i.BH));break;case"vml":i.AA%360==0?(r=10,l=i.B0%2==1?0:r/2):(r=1,l=0),i.CZ?(o[0]=r*ZC._i_(ZC._i_(r*o[0])/r)-l,o[1]=r*ZC._i_(ZC._i_(r*o[1])/r)-l,4!==o.length&&7!==o.length||(o[2]=r*ZC._i_(ZC._i_(r*o[2])/r)-l,o[3]=r*ZC._i_(ZC._i_(r*o[3])/r)-l),7===o.length&&(o[4]=r*ZC._i_(ZC._i_(r*o[4])/r)-l,o[5]=r*ZC._i_(ZC._i_(r*o[5])/r)-l)):(o[0]=ZC._i_(r*o[0]),o[1]=ZC._i_(r*o[1]),4!==o.length&&7!==o.length||(o[2]=ZC._i_(r*o[2]),o[3]=ZC._i_(r*o[3])),7===o.length&&(o[4]=ZC._i_(r*o[4]),o[5]=ZC._i_(r*o[5])))}return o},A2O:function(e,t,i,n,a){var r,l,o,s,c,h,C;if(i.QJ&&(i.D["fast-vector-path"]=!0),!i.D["fast-vector-path"]){for(r=0,l=e.length;r<l;r++)e[r]&&(e[r][0]=parseFloat(Number(e[r][0]).toFixed(2)),e[r][1]=parseFloat(Number(e[r][1]).toFixed(2)));if(i.O3&&(C=i.K+":"+i.AA+":"+e.join("#"),ZC.cache.data["path-points-"+C]))return ZC.cache.data["path-points-"+C].split("#")}var u=[ZC.MAX,ZC.MAX,-ZC.MAX,-ZC.MAX],d=[],p=!1;for(r=0,l=e.length;r<l;r++)if(null!==ZC._n_(e[r])){if(i.D["fast-vector-path"]){if(o=e[r],"vml"===t){var A=i.AA%360==0?10:1;o[0]=ZC._i_(A*o[0]),o[1]=ZC._i_(A*o[1]),4===o.length&&(o[2]=ZC._i_(A*o[2]),o[3]=ZC._i_(A*o[3]))}}else o=ZC.Q._txp_(e[r],t,i,n,a);if(null!==ZC._n_(o)&&!isNaN(o[0])&&!isNaN(o[1])&&isFinite(o[0])&&isFinite(o[1]))if(l<=20&&n&&(u[0]=ZC.CY(u[0],o[0]/("vml"===t?10:1)),u[1]=ZC.CY(u[1],o[1]/("vml"===t?10:1)),u[2]=ZC.BQ(u[2],o[0]/("vml"===t?10:1)),u[3]=ZC.BQ(u[3],o[1]/("vml"===t?10:1))),0===r)d.push(("svg"===t?"M ":"m ")+o[0]+" "+o[1]);else if(p&&(d.push(("svg"===t?"M ":"m ")+o[0]+" "+o[1]),p=!1),2===o.length)d.push(("svg"===t?"L ":"l ")+o[0]+" "+o[1]);else if(4===o.length)d.push(("svg"===t?"Q ":"qb ")+o[0]+" "+o[1]+" "+o[2]+" "+o[3]),"vml"===t&&d.push("l "+o[2]+" "+o[3]);else if(6===o.length)if("svg"===t){var g=0;o[3]%360==o[4]%360&&(g=o[4]>=o[3]?.001:-.001),s=ZC.AO.BK(o[0],o[1],o[2],o[3]+g),c=ZC.AO.BK(o[0],o[1],o[2],o[4]-g),h="0 0",0===o[5]?o[4]-o[3]>360?(h="0 1",c[0]=s[0],c[1]=s[1]):h=o[4]-o[3]<=180?"0 1":"1 1":o[3]-o[4]>360?(h="0 0",c[0]=s[0],c[1]=s[1]):h=o[3]-o[4]<=180?"0 0":"1 0",d.push("a "+o[2]+","+o[2]+" 0 "+h+" "+(c[0]-s[0])+","+(c[1]-s[1]))}else"vml"===t&&(o[2]*=10,s=ZC.AO.BK(o[0],o[1],o[2],o[3]),c=ZC.AO.BK(o[0],o[1],o[2],o[4]),h=1===o[5]?"at":"wa",d.push(h+" "+ZC._i_(o[0]-o[2])+","+ZC._i_(o[1]-o[2])+","+ZC._i_(o[0]+o[2])+","+ZC._i_(o[1]+o[2])+" "+ZC._i_(s[0])+","+ZC._i_(s[1])+" "+ZC._i_(c[0])+","+ZC._i_(c[1])));else 7===o.length&&d.push(("svg"===t?"C ":"c ")+o[0]+" "+o[1]+" "+o[2]+" "+o[3]+" "+o[4]+" "+o[5])}else p=!0;return i.D["fast-vector-path"]||i.O3&&ZC.cache.add("path-points-"+C,d.join("#")),i.H&&l<=20&&n&&(i.H.D[i.K+"-bounds"]=u),d},M7:function(e,t){var i,n,a=e.originalEvent||e.originalEventZC;return t=ZC._i_(t||"0"),a&&a.touches?a.touches.length>0?(i=a.touches[t].pageX,n=a.touches[t].pageY):a.changedTouches.length>0&&(i=a.changedTouches[t].pageX,n=a.changedTouches[t].pageY):(i=e.pageX,n=e.pageY),[ZC._i_(i||"0"),ZC._i_(n||"0")]},F4:function(e,t,i){i=i||document;var n;return null!==ZC._n_(t)?i.createElementNS?n=i.createElementNS(t,e):(n=i.createElement(e)).setAttribute("xmlns",t):n=i.createElement(e),"zcv:"===e.substring(0,4)&&(n.className="zcvml"),n},EU:function(e){var t;e instanceof Array||(e=[e]);for(var i=0,n=e.length;i<n;i++)"object"!=typeof(t=e[i])&&(t=ZC.AK(e[i])),t&&("undefined"!=typeof t.parentElement?t.parentElement.removeChild(t):"undefined"!=typeof t.parentNode&&t.parentNode.removeChild(t))},G2:function(e,t){for(var i in t)if("string"==typeof i&&"object"!=typeof t[i]&&"function"!=typeof t[i])try{e.setAttribute(i,t[i])}catch(n){}},PD:function(e,t){for(var i in t)"string"==typeof i&&"object"!=typeof t[i]&&"function"!=typeof t[i]&&(e.style[i]=t[i])},AAW:function(e){var t;if(e===document)return!0;if(!e)return!1;if(!e.parentNode)return!1;if(e.style){if("none"===e.style.display)return!1;if("hidden"===e.style.visibility)return!1}if(window.getComputedStyle){if("none"===(t=window.getComputedStyle(e,"")).display)return!1;if("hidden"===t.visibility)return!1}if(t=e.currentStyle){if("none"===t.display)return!1;if("hidden"===t.visibility)return!1}return ZC.Q.AAW(e.parentNode)},SV:function(e){var t=e.className||ZC.A4(e).attr("class");return null!==ZC._n_(t)&&"object"==typeof t&&(t="undefined"!=typeof t.baseVal?t.baseVal:""),t||""},IQ:function(e,t,i,n,a,r,l,o){if(e)switch(l=l||"",t){case"canvas":o?e.getContext("2d").clearRect(i,n,a,r):e.width=e.width;break;case"vml":case"svg":var s=e.childNodes.length;if(s>1024&&"undefined"!=typeof e.innerHTML)return void(e.innerHTML="");if(s>0)for(var c=s-1;c>=0;c--)""===l?e.removeChild(e.childNodes[c]):0===e.childNodes[c].id.indexOf(l+"-")&&e.removeChild(e.childNodes[c])}},E9:function(e,t){switch("string"==typeof e&&(e=ZC.AK(e)),t){case"canvas":return e.getContext("2d");case"svg":case"vml":return e}},JW:function(e,t){switch(t){case"svg":return ZC.Q.ABI(e);case"vml":case"canvas":return ZC.Q.HX(e)}},HE:function(e,t){switch(t){case"svg":return ZC.Q.ABI(e);case"vml":return ZC.Q.HX(e);case"canvas":return ZC.Q.AD9(e)}},ABI:function(e){var t;if(ZC.AK(e.id))return ZC.AK(e.id);var i=ZC.Q.F4("g","http://www.w3.org/2000/svg");return null!==ZC._n_(t=e.id)&&i.setAttribute("id",t),null!==ZC._n_(t=e.cls)&&i.setAttribute("class",t),null!==ZC._n_(t=e.zidx)&&i.setAttribute("z-index",t),null!==ZC._n_(t=e["clip-path"])&&i.setAttribute("clip-path",t),e.after?e.p.insertBefore(i,e.after.nextSibling):e.p.appendChild(i),i},XA:function(e){var t;ZC.Q.EU(e.id);var i=ZC.Q.F4("clipPath","http://www.w3.org/2000/svg");return i.id=e.id,null!==ZC._n_(e.cx)?((t=ZC.Q.F4("circle","http://www.w3.org/2000/svg")).id=e.id+"-shape",ZC.Q.G2(t,{cx:e.cx,cy:e.cy,r:e.r})):((t=ZC.Q.F4("polygon","http://www.w3.org/2000/svg")).id=e.id+"-shape",ZC.Q.G2(t,{points:e.path})),i.appendChild(t),i},AD9:function(e){var t;if(ZC.AK(e.id))return ZC.AK(e.id);var i=document.createElement("canvas"),n=i.style;if(null!==ZC._n_(t=e.id)&&(i.id=t),null!==ZC._n_(t=e.cls)&&(i.className=t),null!==ZC._n_(t=e.wh)){var a=(""+t).split("/");e.width=a[0],e.height=a[1]}if(null!==ZC._n_(t=e.tl)){var r=(""+t).split("/");e.top=r[0],e.left=r[1]}return i.width=e.width,i.height=e.height,null!==ZC._n_(t=e.left)&&(n.left=t+"px"),null!==ZC._n_(t=e.top)&&(n.top=t+"px"),null!==ZC._n_(t=e.display)&&(n.display=t),null!==ZC._n_(t=e.position)&&(n.position=t),null!==ZC._n_(t=e.zidx)&&(n.zIndex=t),e.p.appendChild(i),i},HX:function(e){var t,i,n,a,r,l;if(ZC.AK(e.id))return n=ZC.AK(e.id),null!==ZC._n_(t=e.wh)&&(r=(""+t).split("/"),n.style.width=r[0]+"px",n.style.height=r[1]+"px"),null!==ZC._n_(t=e.tl)&&(l=(""+t).split("/"),n.style.top=l[0]+"px",n.style.left=l[1]+"px"),n;(a=(n=document.createElement("div")).style).whiteSpace="nowrap",null!==ZC._n_(t=e.wh)&&(r=(""+t).split("/"),e.width=r[0],e.height=r[1]),null!==ZC._n_(t=e.tl)&&(l=(""+t).split("/"),e.top=l[0],e.left=l[1]),null!==ZC._n_(t=e.id)&&(n.id=t),null!==ZC._n_(t=e.cls)&&""!==t&&(n.className=t);for(var o=[["top","","px"],["left","","px"],["width","","px"],["height","","px"],"position","overflow",["float","cssFloat|styleFloat"],["zidx","zIndex"],"clip","display",["fontSize","","px"],"fontFamily","fontWeight","fontStyle","textDecoration","textAlign","verticalAlign","color","border","borderTop","borderRight","borderBottom","borderLeft","background","cursor",["margin","marginTop|marginRight|marginBottom|marginLeft","px"],["marginTop","","px"],["marginRight","","px"],["marginBottom","","px"],["marginLeft","","px"],["padding","paddingTop|paddingRight|paddingBottom|paddingLeft","px"],["paddingTop","","px"],["paddingRight","","px"],["paddingBottom","","px"],["paddingLeft","","px"],"lineHeight","filter"],s=null,c=null,h=null,C=0,u=o.length;C<u;C++)if("string"==typeof o[C]&&(o[C]=[o[C]]),t=null,null!==ZC._n_(i=e[o[C][0]])&&(t=i),null!==ZC._n_(t)){null!==ZC._n_(o[C][1])&&""!==o[C][1]||(o[C][1]=o[C][0]);for(var d=o[C][1].split("|"),p=0,A=d.length;p<A;p++){var g=t+(null===ZC._n_(o[C][2])?"":o[C][2]);a[d[p]]=g,"fontFamily"===d[p]&&(s=g),"fontSize"===d[p]&&(c=ZC._i_(g)),"fontWeight"===d[p]&&(h=g)}}return null!==ZC._n_(t=e.opacity)&&(a.opacity=t,1!==ZC._f_(t)&&(a.filter="alpha(opacity = "+ZC._i_(100*ZC._f_(t))+")",a.opacity=t)),null!==ZC._n_(t=e.p)&&(e.after?t.insertBefore(n,e.after.nextSibling):t.appendChild(n)),null!==ZC._n_(t=e.html)&&(n.innerHTML=ZC._h_(t),-1!==t.indexOf("<")&&-1!==t.indexOf(">")&&ZC.A4(n).children().each(function(){null!==ZC._n_(s)&&(null!==ZC._n_(this.style.fontFamily)&&""!==this.style.fontFamily||(this.style.fontFamily=s)),null!==ZC._n_(c)&&(null!==ZC._n_(this.style.fontSize)&&""!==this.style.fontSize||(this.style.fontSize=c+"px")),null!==ZC._n_(h)&&(null!==ZC._n_(this.style.fontWeight)&&""!==this.style.fontWeight||(this.style.fontWeight=h))})),e.rtl&&(n.style.unicodeBidi="bidi-override",n.style.direction="rtl"),e.cursor&&"hand"===e.cursor&&(n.style.cursor="pointer"),n},VS:null,A3Y:function(e,t,i,n,a,r,l){var o,s,c,h;null===ZC._n_(l)&&(l=!1);var C=!1;"[HTMLMODE]"===t.substring(0,10)&&(C=!0,t=t.substring(10)),h=e+"-text-ruler",-1!==e.indexOf("-fullscreen")&&(h="zc-text-ruler");var u="{{"+t+"}}"+i.replace(/[^a-z]/gi,"").toLowerCase()+n+r+a;if(ZC.cache.data["text-width-"+u]&&!l)return ZC.cache.data["text-width-"+u];if(ZC.cache.data["text-height-"+u]&&l)return ZC.cache.data["text-height-"+u];var d=t;d=d.replace(/<hr>/g,'<hr style="margin:0;padding:0">');var p;return(p=ZC.AK(h))?(ZC.Q.VS&&ZC.Q.VS===e+i+n+r+a||(p.style.fontFamily=i,p.style.fontSize=n+"px",p.style.fontWeight=a,p.style.lineHeight=C?"130%":-1!==r?ZC._i_(r)+"px":"130%",ZC.Q.VS=e+i+n+r+a),p.innerHTML=d):(p=ZC.Q.HX({id:h,p:document.body,tl:"-9999/-9999",html:d,position:"absolute",fontFamily:i,fontSize:n,cls:"zc-text-ruler",fontWeight:a})).style.lineHeight=C?"130%":-1!==r?ZC._i_(r)+"px":"130%",-1===t.indexOf("<")||-1===t.indexOf(">")||C||ZC.A4(p).children().each(function(){"BR"!==this.tagName.toUpperCase()&&(null!==ZC._n_(this.style.fontFamily)&&""!==this.style.fontFamily||(this.style.fontFamily=i),null!==ZC._n_(this.style.fontSize)&&""!==this.style.fontSize||(this.style.fontSize=n+"px"),this.style.lineHeight=-1!==r?ZC._i_(r)+"px":"130%","B"!==this.tagName.toUpperCase()&&"STRONG"!==this.tagName.toUpperCase()&&(null!==ZC._n_(this.style.fontWeight)&&""!==this.style.fontWeight||(this.style.fontWeight=a)))}),(o=p.getBoundingClientRect())&&o.width>0?(s=o.width,l&&(c=o.height)):(s=ZC.mobile&&ZC.A4.browser.webkit?p.offsetWidth:ZC.A4(p).width(),l&&(c=ZC.mobile&&ZC.A4.browser.webkit?p.offsetHeight:ZC.A4(p).height())),l?(ZC.cache.add("text-height-"+u,c),c):(ZC.cache.add("text-width-"+u,s),s)}},!document.getElementsByClassName&&document.querySelectorAll&&(document.getElementsByClassName=function(e){return document.querySelectorAll("."+e)}),ZC.A4=function(e,t,i){var n,a,r,l,o=this;if(void 0===i&&(i=!0),i)return new ZC.A4(e,t,!1);if(o.OX=[],o.Q0=e,o.MF=t,o.length=0,o.MF=o.MF||document.getElementsByTagName("body")[0],"object"==typeof o.Q0)o.OX=[o.Q0];else if("string"==typeof o.Q0)for(var s=o.Q0.split(","),c=0;c<s.length;c++){var h=ZC.GT(s[c]),C=!1;if(2===(n=h.split(">")).length&&(C=!0,ZC.A4(n[0]).each(function(){var e=this;ZC.A4(n[1],this).each(function(){this.parentNode===e&&o.OX.push(this)})})),2===(n=h.split(" ")).length&&(C=!0,ZC.A4(n[0]).each(function(){ZC.A4(n[1],this).each(function(){o.OX.push(this)})})),!C)if("#"===h.substring(0,1))ZC.AK(h.substring(1))&&(o.OX=[ZC.AK(h.substring(1))]);else if("."===h.substring(0,1))if(document.getElementsByClassName){if(o.MF.getElementsByClassName)a=o.MF.getElementsByClassName(h.substring(1));else if(a=document.getElementsByClassName(h.substring(1)),o.MF!==document){var u=[];for(r=0,l=a.length;r<l;r++)ZC.A4.childof(a[r],o.MF)&&u.push(a[r]);a=u}for(r=0,l=a.length;r<l;r++)o.OX.push(a[r])}else{var d=new RegExp("(^|\\s)"+h.substring(1)+"(\\s|$)","i"),p=o.MF.getElementsByTagName("*"),A="";for(r=0,l=p.length;r<l;r++)"object"==typeof(A=p[r].className)&&(A="undefined"!=typeof A.baseVal?A.baseVal:""),""!==A&&d.test(A)&&o.OX.push(p[r])}else for(r=0,l=(a=o.MF.getElementsByTagName(h)).length;r<l;r++)o.OX.push(a[r])}return o.length=o.OX.length,this},ZC.A4.prototype={eachfn:function(){for(var e,t=[],i=0,n=this.OX.length;i<n;i++){var a=[this.OX[i]];if((e=arguments.length)>1)for(var r=1;r<e;r++)a.push(arguments[r]);t.push(arguments[0].apply(this,a))}return t},each:function(){for(var e,t=0,i=this.OX.length;t<i;t++){var n=[this.OX[t]];if((e=arguments.length)>1)for(var a=1;a<e;a++)n.push(arguments[a]);arguments[0].apply(this.OX[t],n)}return this},children:function(){var e=[];return this.each(function(){for(var t=0,i=this.childNodes.length;t<i;t++)1===this.childNodes[t].nodeType&&e.push(this.childNodes[t])}),this.OX=e,this},remove:function(){this.eachfn.call(this,function(e){e&&e.parentNode&&e.parentNode.removeChild(e)})},empty:function(){this.eachfn.call(this,function(e){if(e)for(;e.childNodes.length;)e.removeChild(e.childNodes[e.childNodes.length-1])})},A2I:function(e){void 0===e&&(e=!0);var t,i,n=this.eachfn.call(this,function(n){if(!n)return null;if(n===window){var a=document.body;return n.innerWidth?(t=n.innerWidth,i=n.innerHeight):a&&a.parentElement&&a.parentElement.clientWidth?(t=a.parentElement.clientWidth,i=a.parentElement.clientHeight):a&&a.clientWidth&&(t=a.clientWidth,i=a.clientHeight),{width:t,height:i}}var r,l,o=e?"block":ZC.A4(n).getstyle("display");if(window.getComputedStyle){var s=window.getComputedStyle(n,null);r=s.getPropertyValue("width").slice(0,-2),l=s.getPropertyValue("height").slice(0,-2)}else if(n.getBoundingClientRect){var c=n.getBoundingClientRect();r=c.width?c.width:n.offsetWidth,l=c.height?c.height:n.offsetHeight}else r=n.offsetWidth,l=n.offsetHeight;if("none"===o||""===o||void 0===o){var h=n.style,C=h.visibility,u=h.position,d=h.display;h.visibility="hidden",h.position="absolute",h.display="block",t=r,i=l,h.display=d,h.position=u,h.visibility=C}else t=r||0,i=l||0;return{width:t,height:i}});return 1===n.length?n[0]:n},getstyle:function(e){var t=this.eachfn.call(this,function(e,t){if("display"===t)return e.style.display;var i,n=document;if(t=ZC.EC(t),!e||e===n)return undefined;if("opacity"===t&&"undefined"!=typeof e.filters){var a=(ZC.A4(e).getstyle("filter")||"").match(/alpha\(opacity=(.*)\)/);return a&&a[1]?parseFloat(a[1])/100:1}if(-1!==ZC.AV(["float","cssFloat","styleFloat"],t))return(i=e.style["float"])?i:(i=e.style.cssFloat)?i:(i=e.style.styleFloat)?i:"none";var r=e.style?e.style[t]:null;if(!r)if(n.defaultView&&n.defaultView.getComputedStyle){var l=n.defaultView.getComputedStyle(e,null);t=t.replace(/([A-Z])/g,"-$1").toLowerCase(),r=l?l.getPropertyValue(t):null}else if(e.currentStyle&&(r=e.currentStyle[t],/^\d/.test(r)&&!/px$/.test(r)&&"fontWeight"!==t)){var o=e.style.left,s=e.runtimeStyle.left;e.runtimeStyle.left=e.currentStyle.left,e.style.left=r||0,r=e.style.pixelLeft+"px",e.style.left=o,e.runtimeStyle.left=s}return"opacity"===t&&(r=parseFloat(r)),/Opera/.test(navigator.userAgent)&&-1!==ZC.AV(["left","top","right","bottom"],t)&&"static"===ZC.A4(e).getstyle("position")&&(r="auto"),"auto"===r?null:r},e);return 1===t.length?t[0]:t},wh:function(){var e;return this.OX[0]?null!==ZC._n_(e=ZC.A4(this.OX[0]).A2I())?[ZC._i_(e.width),ZC._i_(e.height)]:[0,0]:null},width:function(e){var t;if(void 0===e){var i=this.eachfn.call(this,function(e){return null!==ZC._n_(t=ZC.A4(e).A2I())?ZC._i_(t.width):0});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t){e.style.width=t+"px"},e),this},height:function(e){var t;if(void 0===e){var i=this.eachfn.call(this,function(e){return null!==ZC._n_(t=ZC.A4(e).A2I())?ZC._i_(t.height):0});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t){e.style.height=t+"px"},e),this},scrollLeft:function(){return ZC.A4.scroll().left},scrollTop:function(){return ZC.A4.scroll().top},css:function(e,t){if(void 0===t){var i=this.eachfn.call(this,function(t){var i=ZC.A4(t).getstyle(e);return-1!==(""+i).indexOf("px")?ZC._i_(i):i});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t,i){e.style[t]=i},e,t),this},attr:function(e,t){if(void 0===t){var i=this.eachfn.call(this,function(t){return t.getAttribute(e)});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,t,i){e.setAttribute(t,i)},e,t),this},val:function(e){if(void 0===e){var t=this.eachfn.call(this,function(e){return e.value});return 1===t.length?t[0]:t}return this.eachfn.call(this,function(e,t){e.value=t},e),this},show:function(){return this.eachfn.call(this,function(e){e.style.display="block"}),this},hide:function(){return this.eachfn.call(this,function(e){e.style.display="none"}),this},offset:function(){var e=this.eachfn.call(this,function(e){if(!(e&&(e.x&&e.y||null!==!e.parentNode&&"none"!==ZC.A4(e).getstyle("display"))))return undefined;var t,i,n,a,r,l,o,s={top:0,left:0},c={top:0,left:0},h=e&&e.ownerDocument;return h&&((i=h.body)===e&&(s={top:i.offsetTop,left:i.offsetLeft}),t=h.documentElement,"undefined"!=typeof e.getBoundingClientRect&&(c=e.getBoundingClientRect()),n=h.defaultView||h.parentWindow,a=t.clientTop||i.clientTop||0,r=t.clientLeft||i.clientLeft||0,l=n.pageYOffset||t.scrollTop,o=n.pageXOffset||t.scrollLeft,s={top:c.top+l-a,left:c.left+o-r}),s});return 1===e.length?e[0]:e},bind:function(e,t,i){if(""!==(e=ZC.A4.cleanTouchEvents(e))){if(i||(i=!ZC.hasPassive||{passive:!0}),-1!==e.indexOf(" ")){for(var n=e.split(/\s+/),a=0;a<n.length;a++)this.bind(n[a],t,i);return this}return this.eachfn.call(this,function(e,t,n){function a(e){var t=(e=e||window.event).target||e.srcElement,i=ZC.A4.C0(e);null!==i&&n.call(t,i)}ZC.A4.IV||(ZC.A4.IV=[]),ZC.A4.IV.push([e,t,n,a]),e.addEventListener?e.addEventListener(t,a,i):e.attachEvent("on"+t,a)},e,t),this}},unbind:function(e,t){if(""!==(e=ZC.A4.cleanTouchEvents(e))){if(-1!==e.indexOf(" ")){for(var i=e.split(/\s+/),n=0;n<i.length;n++)this.unbind(i[n],t);return this}return this.eachfn.call(this,function(e,t,i){if("undefined"!=typeof ZC.A4.IV)for(var n=0,a=ZC.A4.IV.length;n<a;n++)if((ZC.A4.IV[n][0]===e||e.tagName&&"MAP"===e.tagName.toUpperCase()&&e.id===ZC.A4.IV[n][0].id)&&ZC.A4.IV[n][1]===t&&ZC.A4.IV[n][2]===i){e.removeEventListener?e.removeEventListener(t,ZC.A4.IV[n][3],!0):e.detachEvent("on"+t,ZC.A4.IV[n][3]),ZC.A4.IV.splice(n,1);break}},e,t),this}},live:function(e,t,i){function n(t){var i=(t=t||window.event).target||t.srcElement,n=i.className||"";"object"==typeof n&&(n="undefined"!=typeof n.baseVal&&null!==ZC._n_(n.baseVal)?n.baseVal:"");var a,l,o=ZC.A4.EVENTS[e],s=null,c=null,h=[];for(a=0,l=o.length;a<l;a++)("object"==typeof o[a][0]&&i===o[r][0]||"string"==typeof o[a][0]&&("."===o[a][0].substring(0,1)&&-1!==ZC.AV(n.split(" "),o[a][0].replace(".",""))||"#"===o[a][0].substring(0,1)&&i.id===o[a][0].substring(1)))&&(s=o[a][1],c=ZC.A4.C0(t),null!==ZC._n_(s)&&null!==ZC._n_(c)&&h.push([s,i,c]));for(a=0,l=h.length;a<l;a++)h[a][0].call(h[a][1],h[a][2])}if(""!==(e=ZC.A4.cleanTouchEvents(e))){if(i||(i=!ZC.hasPassive||{passive:!0}),-1===e.indexOf("touch")&&-1===e.indexOf("wheel")||(i={passive:!1}),-1!==e.indexOf(" ")){for(var a=e.split(/\s+/),r=0;r<a.length;r++)this.live(a[r],t,i);return this}var l=this.Q0;return ZC.A4.EVENTS||(ZC.A4.EVENTS={}),ZC.A4.EVENTS[e]||(ZC.A4.EVENTS[e]=[],document.addEventListener?document.addEventListener(e,n,i):document.attachEvent("on"+e,n)),ZC.A4.EVENTS[e].push([l,t]),this}},die:function(e,t){if(""!==(e=ZC.A4.cleanTouchEvents(e))){var i,n,a;if(-1!==e.indexOf(" ")){for(n=0,a=(i=e.split(/\s+/)).length;n<a;n++)this.die(i[n],t);return this}var r=this.Q0;if(ZC.A4.EVENTS||(ZC.A4.EVENTS={}),i=ZC.A4.EVENTS[e])for(n=i.length-1;n>=0;n--)i[n][0]!==r||t&&i[n][1]!==t||ZC.A4.EVENTS[e].splice(n,1);return this}}},ZC.A4._list_=function(e){for(var t=[],i=0;i<ZC.A4.EVENTS[e].length;i++)t.push(ZC.A4.EVENTS[e][i][0]);return t.join(",")},ZC.A4.cleanTouchEvents=function(e){return ZC.ie678&&(e=ZC.GT(e.replace(/touchstart|touchend|touchmove/,""))),e},ZC.A4.cache={},ZC.A4.browser={},function(){var e=/(webkit)[ \/]([\w.]+)/,t=/(opera)(?:.*version)?[ \/]([\w.]+)/,i=/(msie) ([\w.]+)/,n=/(mozilla)(?:.*? rv:([\w.]+))?/,a=/(trident)(?:.*? rv:([\w.]+))?/,r=function(r){r=r.toLowerCase();var l=e.exec(r)||t.exec(r)||i.exec(r)||a.exec(r)||r.indexOf("compatible")<0&&n.exec(r)||[];return[l[1]||"",l[2]||"0"]}(navigator.userAgent);r[0]&&("trident"===r[0]&&(r[0]="msie"),ZC.A4.browser[r[0]]=!0,ZC.A4.browser.version=r[1])}(),ZC.A4.scroll=function(){var e={top:0,left:0},t=document,i=t.documentElement,n=t.body;return i&&(i.scrollTop||i.scrollLeft)?(e.left=i.scrollLeft,e.top=i.scrollTop):n&&(e.left=n.scrollLeft,e.top=n.scrollTop),e},ZC.A4.C0=function(e){if(e.originalEventZC=e,e.target||(e.target=e.srcElement||document),3!==e.target.nodeType&&8!==e.target.nodeType||(e.target=e.target.parentNode),null===ZC._n_(e.pageX)&&null!==ZC._n_(e.clientX)){var t=e.target.ownerDocument||document,i=t.documentElement,n=t.body;e.pageX=e.clientX+(i&&i.scrollLeft||n&&n.scrollLeft||0)-(i&&i.clientLeft||n&&n.clientLeft||0),e.pageY=e.clientY+(i&&i.scrollTop||n&&n.scrollTop||0)-(i&&i.clientTop||n&&n.clientTop||0)}return e.which||e.button===undefined||(e.which=1&e.button?1:2&e.button?3:4&e.button?2:0),e.preventDefault||(e.preventDefault=function(){this.returnValue=!1}),e.stopPropagation||(e.stopPropagation=function(){this.cancelBubble=!0}),e},ZC.A4.childof=function(e,t){if(e===t)return!0;for(;e!==t&&e.parentNode;)if((e=e.parentNode)===t)return!0;return!1},ZC.A4.ajax=function(e){var t=e.url||"",i=e.type||"GET",n=e.data||"",a=!0;"undefined"!=typeof e.async&&(a=ZC._b_(e.async)),""===n.replace(/\&/g,"")&&(n="");var r=e.beforeSend||null,l=e.error||null,o=e.success||null,s=null;try{window.ActiveXObject?s=new ActiveXObject("Microsoft.XMLHTTP"):window.XMLHttpRequest&&(s=new XMLHttpRequest)}catch(h){}var c="file:"===window.location.protocol;if(s){a&&(s.onreadystatechange=function(){4===s.readyState&&((c||s.status>=200&&s.status<300)&&o&&o(s.responseText,s.status,s,t),s.status>=400&&l&&l(s,s.status,s.statusText,t),s.onreadystatechange=new window.Function,s=null)}),window.ActiveXObject||(s.onerror=function(){l&&l(s,0,"",t)}),"POST"===i.toUpperCase()?(s.open("POST",t,a),s.setRequestHeader("X-Requested-With","XMLHttpRequest"),s.setRequestHeader("Content-type","application/x-www-form-urlencoded")):(""!==n&&(-1===t.indexOf("?")&&(t+="?"),t+="&"+n),s.open("GET",t,a)),r&&r(s);try{s.send(n),a||((c||s.status>=200&&s.status<300)&&o&&o(s.responseText,s.status,s,t),s.status>=400&&l&&l(s,s.status,s.statusText,t),s=null)}catch(C){c&&l&&(l(s,s.status,s.statusText,t),s.onreadystatechange=new window.Function,s=null)}}},ZC.AO={ACD:function(e,t){function i(e,t){-1===ZC.AV(e,t)&&e.push(t)}var n,a,r=zingchart.DEV.SPREADFACTOR,l=[],o=0;for(n=0;n<e.length;n++)e[n]+=t;var s=-1;for(n=1;n<e.length;n++)ZC._a_(e[n]-e[n-1])<r?(l[o]=l[o]||{min:-1,max:-1,items:[]},-1===l[o].min&&(l[o].min=n>1?e[n-2]:t,-1===s&&(s=l[o].min),l[o].min),i(l[o].items,n-1),i(l[o].items,n)):l[o]&&(l[o].max=e[n],l[o].max,o++);l[o]&&-1===l[o].max&&(l[o].max=360+t);var c=l.length;if(c>1&&l[c-1].max-l[0].min==360){for(a=0;a<l[0].items.length;a++)e[l[0].items[a]]+=360;l[c-1].items=l[c-1].items.concat(l[0].items),l[c-1].max+=l[0].min,l=l.splice(1)}for(l.length>1&&(l[l.length-1].max=l[0].min+360),n=0;n<l.length;n++){var h=l[n],C=h.items.length,u=(h.max-h.min)/(C+4);u=ZC.CY(u,r);var d=0;for(a=0;a<h.items.length;a++)d+=e[h.items[a]];d/=h.items.length;for(var p=!0;p;)for(p=!1,a=1;a<h.items.length;a++)if(e[h.items[a]]-e[h.items[a-1]]<u){e[h.items[a-1]]<d?(e[h.items[a-1]]-=.45,e[h.items[a]]+=.05):e[h.items[a]]+=.25,p=!0;break}}return e},_int_:function(e){return Math.abs(e-ZC._i_(e))<Math.pow(10,-10)},XI:function(e,t,i){return i=i||1,!(e.x>t.x+t.width+i)&&(!(t.x>e.x+e.width+i)&&(!(e.y>t.y+t.height+i)&&!(t.y>e.y+e.height+i)))},_boxoverlap2_:function(e,t,i){return i=i||1,!(e.iX>t.iX+t.I+i)&&(!(t.iX>e.iX+e.I+i)&&(!(e.iY>t.iY+t.F+i)&&!(t.iY>e.iY+e.F+i)))},AG6:function(e,t){return e.iX>=t.iX&&e.iX<=t.iX+t.I&&e.iY>=t.iY&&e.iY<=t.iY+t.F&&e.iX+e.I>=t.iX&&e.iX+e.I<=t.iX+t.I&&e.iY+e.F>=t.iY&&e.iY+e.F<=t.iY+t.F},A5U:function(e,t,i){for(var n=Math.sqrt(e/Math.PI),a=Math.sqrt(t/Math.PI),r=Math.min(n,a),l=Math.max(n,a),o=ZC.MAX,s=0,c=r+l;c>l-r;c-=r/50){var h=r*r*Math.acos((c*c+r*r-l*l)/(2*c*r))+l*l*Math.acos((c*c+l*l-r*r)/(2*c*l))-.5*Math.sqrt((-c+r+l)*(c+r-l)*(c-r+l)*(c+r+l));Math.abs(h-i)<o&&(o=Math.abs(h-i),s=c)}return s},BK:function(e,t,i,n){return[e+i*Math.cos(2*n*Math.PI/360),t+i*Math.sin(2*n*Math.PI/360)]},A55:function(e,t,i,n,a){var r=ZC.TO(Math.atan((n-t)/(i-e)));return[e+ZC._i_(ZC.EF(r)*a),t+ZC._i_(ZC.EO(r)*a)]},JO:function(e,t,i,n,a,r){if(a=null===ZC._n_(a)?0:a,r=null===ZC._n_(r)||r,i-e!=0){var l=0,o=0,s=Math.atan((n-t)/(i-e));return(a<1||r)&&(l=a/2.5*Math.cos(s),o=a/2.5*Math.sin(s)),[(e+i)/2+(e<i?l:-l),(t+n)/2+o]}return[e,(t+n)/2]},AAZ:function(e,t){var i=(e[1]-t[1])/(e[0]-t[0]);return[i,e[1]-i*e[0]]},A4G:function(e,t,i,n){if(t[0]===n[0]&&t[1]===n[1])return t;if(e[0]===i[0]&&e[1]===i[1])return e;var a=ZC.AO.AAZ(e,t),r=a[0],l=a[1],o=ZC.AO.AAZ(i,n),s=o[0],c=(o[1]-l)/(r-s);return[c,r*c+l]},PM:function(e,t,i){null===ZC._n_(t)&&(t=5);var n=0,a=0;null!==ZC._n_(i)&&(n=i[0],a=i[1]);for(var r,l,o,s="",c=ZC.ie67?ZC.MAPTX:0,h=0,C=e.length;h<C;h++)e[h]&&(0===h?(l=e[h][0]+c+n,o=e[h][1]+c+a,r=h,s+=Math.round(l,10)+","+Math.round(o,10)+","):Math.sqrt((e[h][0]+c-l)*(e[h][0]+c-l)+(e[h][1]+c-o)*(e[h][1]+c-o))>t&&e[h-1]&&(Math.sqrt((e[h][0]-e[h-1][0])*(e[h][0]-e[h-1][0])+(e[h][1]-e[h-1][1])*(e[h][1]-e[h-1][1]))>t&&h-r>1&&(s+=Math.round(e[h-1][0]+c+n,10)+","+Math.round(e[h-1][1]+c+a,10)+","),l=e[h][0]+c+n,o=e[h][1]+c+a,r=h,s+=Math.round(l,10)+","+Math.round(o,10)+","));return s=s.substring(0,s.length-1)},YW:function(e,t){if(null===ZC._n_(e)||e.length<2)return"";null===ZC._n_(t)&&(t=6,ZC.mobile&&(t+=10));var i,n,a,r,l,o=[];for(i=0,n=e.length;i<n;i++)(0===i||i>0&&null!==ZC._n_(e[i])&&null!==ZC._n_(e[i-1])&&e[i].join("/")!==e[i-1].join("/")||null===ZC._n_(e[i]))&&o.push(e[i]);var s=[],c=[],h=!1;for(i=0,n=o.length;i<n;i++)if(o[i]){var C,u,d,p,A=o[i][0],g=o[i][1];if(o[i-1]&&(d=o[i-1][0],p=o[i-1][1],d===A&&(d-=.1)),o[i+1]&&(C=o[i+1][0],u=o[i+1][1],C===A&&(C+=.1)),0===i)a=Math.atan((u-g)/(C-A)),l=r=ZC.TO(a),C>=A&&(l+=180),s.push(ZC.AO.BK(A,g,t,r+90),ZC.AO.BK(A,g,t,l),ZC.AO.BK(A,g,t,r+270));else if(i===o.length-1)a=Math.atan((p-g)/(d-A)),l=r=ZC.TO(a),d>=A&&(l+=180),h?(c.push(ZC.AO.BK(A,g,t,r+270),ZC.AO.BK(A,g,t,l),ZC.AO.BK(A,g,t,r+90)),h=!1):s.push(ZC.AO.BK(A,g,t,r+270),ZC.AO.BK(A,g,t,l),ZC.AO.BK(A,g,t,r+90));else{var f=Math.atan((u-g)/(C-A)),Z=Math.atan((g-p)/(A-d));l=ZC.TO((f+Z)/2),s.push(ZC.AO.BK(A,g,t,l+270)),C>=A&&d>=A?(s.push(ZC.AO.BK(A,g,t,l+180)),s.push(ZC.AO.BK(A,g,t,l+90)),c.push(ZC.AO.BK(A,g,t,l)),h=!0):C<=A&&d<=A?(s.push(ZC.AO.BK(A,g,t,l)),s.push(ZC.AO.BK(A,g,t,l+90)),c.push(ZC.AO.BK(A,g,t,l+180)),h=!0):c.push(ZC.AO.BK(A,g,t,l+90))}}for(i=c.length-1;i>=0;i--)s.push(c[i]);return s},A20:function(e,t){var i=0,n=0,a=[];switch(e+=""){case"horizontal":case"h":i=1,n=t;break;case"vertical":case"v":i=t,n=1;break;default:a=e.split("x"),null!==ZC._n_(a[0])&&ZC._i_(a[0])+""===a[0]&&(i=ZC._i_(a[0])),null!==ZC._n_(a[1])&&ZC._i_(a[1])+""===a[1]&&(n=ZC._i_(a[1])),0===n&&0===i?(i=Math.ceil(Math.sqrt(t)),n=Math.ceil(t/i)):(0===n&&(n=Math.ceil(t/i)),0===i&&(i=Math.ceil(t/n)))}return[i,n]},AB0:function(e,t){return.5*(2*t[1]+(-t[0]+t[2])*e+(2*t[0]-5*t[1]+4*t[2]-t[3])*e*e+(-t[0]+3*t[1]-3*t[2]+t[3])*e*e*e)},AB4:function(e,t){var i,n,a,r,l,o=e.length,s=[],c=[],h=[];for(i=0;i<o-1;i++)n=e[i+1]-e[i],a=t[i+1]-t[i],c.push(n),s.push(a),h.push(a/n);var C=[h[0]];for(i=0;i<c.length-1;i++){r=h[i];var u=h[i+1];if(r*u<=0)C.push(0);else{n=c[i];var d=c[i+1];l=n+d,C.push(3*l/((l+d)/r+(l+n)/u))}}C.push(h[h.length-1]);var p=[],A=[];for(i=0;i<C.length-1;i++){r=h[i];var g=C[i],f=1/c[i];l=g+C[i+1]-r-r,p.push((r-g-l)*f),A.push(l*f*f)}return function(i){var n=e.length-1;if(i===e[n])return t[n];for(var a,r=0,l=A.length-1;r<=l;){a=Math.floor(.5*(r+l));var o=e[a];if(o<i)r=a+1;else{if(!(o>i))return t[a];l=a-1}}n=Math.max(0,l);var s=i-e[n],c=s*s;return t[n]+C[n]*s+p[n]*c+A[n]*s*c}},XZ:function(e,t,i,n){null===ZC._n_(n)&&(n=1/(i/t.length*4));var a,r,l=[];if(e)if((a=[].concat(t))[1]&&a[2]){a[0]=a[0]||a[1]||a[2]||a[3],a[1]=a[1]||a[2]||a[0]||a[3],a[2]=a[2]||a[3]||a[1]||a[0],a[3]=a[3]||a[2]||a[1]||a[0];var o=ZC.AO.AB4([0,1,2,3],a);for(r=1;r<=2;r+=n)l.push([r-1,o(r)])}else l.push([]);else for(var s=1;s<t.length-2;s++)if(1!==n)if((a=[t[s-1],t[s],t[s+1],t[s+2]])[1]&&a[2])for(a[0]=a[0]||a[1]||a[2]||a[3],a[1]=a[1]||a[2]||a[0]||a[3],a[2]=a[2]||a[3]||a[1]||a[0],a[3]=a[3]||a[2]||a[1]||a[0],r=0;r<=1;r+=n){var c=s+r,h=ZC.AO.AB0(r,a);l.push([c-1,h])}else l.push([]);else l.push([s-1,t[s]]);return l},A0A:function(e){for(var t=Math.round(ZC.H0(ZC._a_(e))/Math.LN10),i=[1,2,4,5,6,8,10],n=ZC.MAX,a=1,r=0;r<i.length;r++){var l=i[r]*Math.pow(10,t)-e;ZC._a_(l)<n&&(a=i[r],n=ZC._a_(l))}return a*Math.pow(10,t)},_nice_number_:function(e,t){var i,n;return i=Math.floor(Math.log(e)/Math.log(10)),n=e/Math.pow(10,i),(t?n<1.5?1:n<3?2:n<7?5:10:n<=1?1:n<=2?2:n<=5?5:10)*Math.pow(10,i)},W7:function(e,t,i,n,a,r){null===ZC._n_(a)&&(a=!0),r=null===ZC._n_(r)?10:Math.min(Math.max(2,r),100),null!==ZC._n_(n)&&0!==n||(n=1);var l,o,s,c,h,C,u=Math.floor(ZC.H0(ZC._a_(t))/Math.LN10);e===t&&(t+=Math.pow(10,u)),l=e,o=t,c=ZC.AO._nice_number_(o-l,!1),null===ZC._n_(i)?(s=c/(r-1),s=ZC.AO._nice_number_(s,!0),s*=n):s=i,a?(h=Math.floor(l/s)*s,C=Math.ceil(o/s)*s):(h=l,C=o,s=null===ZC._n_(i)?c/(r-1):i);var d=Math.floor(ZC.H0(ZC._a_(s))/Math.LN10),p=d<0?ZC._a_(d):0;if(0===p){var A=(""+s).split(".");2===A.length&&(p=A[1].length)}return[h,C,s,p,s]}},ZC.XL={md5:function(e){return ZC.XL.ACV(ZC.XL.ACW(ZC.XL.ACP(e)))},ACW:function(e){return ZC.XL.ACB(ZC.XL.ACS(ZC.XL.ACA(e),8*e.length))},ACV:function(e){for(var t,i="",n=0,a=e.length;n<a;n++)t=e.charCodeAt(n),i+="0123456789abcdef".charAt(t>>>4&15)+"0123456789abcdef".charAt(15&t);return i},ACP:function(e){for(var t,i,n="",a=-1,r=e.length;++a<r;)t=e.charCodeAt(a),i=a+1<r?e.charCodeAt(a+1):0,55296<=t&&t<=56319&&56320<=i&&i<=57343&&(t=65536+((1023&t)<<10)+(1023&i),a++),t<=127?n+=String.fromCharCode(t):t<=2047?n+=String.fromCharCode(192|t>>>6&31,128|63&t):t<=65535?n+=String.fromCharCode(224|t>>>12&15,128|t>>>6&63,128|63&t):t<=2097151&&(n+=String.fromCharCode(240|t>>>18&7,128|t>>>12&63,128|t>>>6&63,128|63&t));return n},ACA:function(e){var t,i=Array(e.length>>2);for(t=0;t<i.length;t++)i[t]=0;for(t=0;t<8*e.length;t+=8)i[t>>5]|=(255&e.charCodeAt(t/8))<<t%32;return i},ACB:function(e){for(var t="",i=0;i<32*e.length;i+=8)t+=String.fromCharCode(e[i>>5]>>>i%32&255);return t},ACS:function(e,t){function i(e,t,i,n,a,r){return o(s(o(o(t,e),o(n,r)),a),i)}function n(e,t,n,a,r,l,o){return i(t&n|~t&a,e,t,r,l,o)}function a(e,t,n,a,r,l,o){return i(t&a|n&~a,e,t,r,l,o)}function r(e,t,n,a,r,l,o){return i(t^n^a,e,t,r,l,o)}function l(e,t,n,a,r,l,o){return i(n^(t|~a),e,t,r,l,o)}function o(e,t){var i=(65535&e)+(65535&t);return(e>>16)+(t>>16)+(i>>16)<<16|65535&i}function s(e,t){return e<<t|e>>>32-t}e[t>>5]|=128<<t%32,e[14+(t+64>>>9<<4)]=t;for(var c=1732584193,h=-271733879,C=-1732584194,u=271733878,d=0,p=e.length;d<p;d+=16){var A=c,g=h,f=C,Z=u;h=l(h=l(h=l(h=l(h=r(h=r(h=r(h=r(h=a(h=a(h=a(h=a(h=n(h=n(h=n(h=n(h,C=n(C,u=n(u,c=n(c,h,C,u,e[d],7,-680876936),h,C,e[d+1],12,-389564586),c,h,e[d+2],17,606105819),u,c,e[d+3],22,-1044525330),C=n(C,u=n(u,c=n(c,h,C,u,e[d+4],7,-176418897),h,C,e[d+5],12,1200080426),c,h,e[d+6],17,-1473231341),u,c,e[d+7],22,-45705983),C=n(C,u=n(u,c=n(c,h,C,u,e[d+8],7,1770035416),h,C,e[d+9],12,-1958414417),c,h,e[d+10],17,-42063),u,c,e[d+11],22,-1990404162),C=n(C,u=n(u,c=n(c,h,C,u,e[d+12],7,1804603682),h,C,e[d+13],12,-40341101),c,h,e[d+14],17,-1502002290),u,c,e[d+15],22,1236535329),C=a(C,u=a(u,c=a(c,h,C,u,e[d+1],5,-165796510),h,C,e[d+6],9,-1069501632),c,h,e[d+11],14,643717713),u,c,e[d],20,-373897302),C=a(C,u=a(u,c=a(c,h,C,u,e[d+5],5,-701558691),h,C,e[d+10],9,38016083),c,h,e[d+15],14,-660478335),u,c,e[d+4],20,-405537848),C=a(C,u=a(u,c=a(c,h,C,u,e[d+9],5,568446438),h,C,e[d+14],9,-1019803690),c,h,e[d+3],14,-187363961),u,c,e[d+8],20,1163531501),C=a(C,u=a(u,c=a(c,h,C,u,e[d+13],5,-1444681467),h,C,e[d+2],9,-51403784),c,h,e[d+7],14,1735328473),u,c,e[d+12],20,-1926607734),C=r(C,u=r(u,c=r(c,h,C,u,e[d+5],4,-378558),h,C,e[d+8],11,-2022574463),c,h,e[d+11],16,1839030562),u,c,e[d+14],23,-35309556),C=r(C,u=r(u,c=r(c,h,C,u,e[d+1],4,-1530992060),h,C,e[d+4],11,1272893353),c,h,e[d+7],16,-155497632),u,c,e[d+10],23,-1094730640),C=r(C,u=r(u,c=r(c,h,C,u,e[d+13],4,681279174),h,C,e[d],11,-358537222),c,h,e[d+3],16,-722521979),u,c,e[d+6],23,76029189),C=r(C,u=r(u,c=r(c,h,C,u,e[d+9],4,-640364487),h,C,e[d+12],11,-421815835),c,h,e[d+15],16,530742520),u,c,e[d+2],23,-995338651),C=l(C,u=l(u,c=l(c,h,C,u,e[d],6,-198630844),h,C,e[d+7],10,1126891415),c,h,e[d+14],15,-1416354905),u,c,e[d+5],21,-57434055),C=l(C,u=l(u,c=l(c,h,C,u,e[d+12],6,1700485571),h,C,e[d+3],10,-1894986606),c,h,e[d+10],15,-1051523),u,c,e[d+1],21,-2054922799),C=l(C,u=l(u,c=l(c,h,C,u,e[d+8],6,1873313359),h,C,e[d+15],10,-30611744),c,h,e[d+6],15,-1560198380),u,c,e[d+13],21,1309151649),C=l(C,u=l(u,c=l(c,h,C,u,e[d+4],6,-145523070),h,C,e[d+11],10,-1120210379),c,h,e[d+2],15,718787259),u,c,e[d+9],21,-343485551),c=o(c,A),h=o(h,g),C=o(C,f),u=o(u,Z)}return Array(c,h,C,u)}},"undefined"==typeof zingchart&&(zingchart={ADG:!0}),zingchart.clipart={},zingchart.widgets={},zingchart.plugins={},zingchart.pool={},zingchart.pool.size=0,zingchart.pool.data={},zingchart.pool.getInstance=function(e,t,i,n){var a;if(null!==ZC._n_(zingchart.pool.data[i]))(a=zingchart.pool.data[i])._POOL_=!0,ZC.SKIPOBJCOUNT=!0,n||(a.$i(t),a.K=i),ZC.SKIPOBJCOUNT=!1;else{switch(e){case"DS":a=new ZC.DS(t);break;case"HS":a=new ZC.HS(t);break;case"DW":a=new ZC.DW(t);break;case"QU":a=new ZC.QU(t);break;case"D0":a=new ZC.D0(t)}a.K=i,zingchart.pool.size++,zingchart.pool.size>zingchart.DEV.MAXPOOLSIZE?(zingchart.pool.data={},zingchart.pool.size=0):zingchart.pool.data[i]=a}return a},zingchart.i18n={},zingchart.THEMES={},zingchart.V3D=2,zingchart.QUOTEDVALUES=!1,zingchart.EDITSOURCE=1,zingchart.MODULESDEP={line:"xy",line3d:"3d,line",area:"xy",area3d:"3d,area",vline:"yx",varea:"yx",vbar:"xy",vbar3d:"3d,vbar",hbar:"yx",hbar3d:"3d,hbar",scatter:"xy",bubble:"xy",hscatter:"yx",hbubble:"yx",pie:"r",pie3d:"3d,pie",nestedpie:"r",gauge:"r",vbullet:"vbar",hbullet:"hbar",vfunnel:"xy",hfunnel:"yx",piano:"xy",radar:"r",range:"xy",vrange:"yx",stock:"xy,vbar",venn:"r"},zingchart.SKIP={EVENT:!1,ANIMATION:!1,LEGEND:!1,CSV:!1,PARSE3D:!1},zingchart.MODULESDIR=function(e){for(var t=0;t<e.length;t++)if(e[t].src&&e[t].src.indexOf("zingchart.min.js")>-1)return e[t].src.split("zingchart.min.js")[0]+"modules/";return"./modules/"}(document.getElementsByTagName("head")[0].childNodes),zingchart.DEV={DOMFRAGMENTS:1,SORTTOKENS:1,PLOTSTATS:1,RESOURCES:1,KEEPSOURCE:1,SPREADTYPE:0,SPREADFACTOR:10,IGNORESUBUNIT:0,DELAYEDTRACKERS:0,STACKINGLOGIC:-1,SMARTDATELABELS:0,GC:1,CACHECANVASTEXT:0,CHECKDECIMALS:0,CACHESELECTION:0,MEDIARULES:1,SKIPTRACKERS:0,PLOTSHLAYER:0,RESIZESPEED:250,DEBOUNCESPEED:250,LOCALSVGEXPORT:1,SKIPPROGRESS:0,SKIPCONTEXTMENU:0,COPYDATA:1,GUIDETIMEOUT:0,LOOKUPCSSTRANSFORM:0,MAPSONBOTTOM:0,MAXPOOLSIZE:1024,MINTRACKERDIFF:1.5},zingchart.CANVASTEXT=0,zingchart.ZINDEX=1,zingchart.CMZINDEX=9999,zingchart.FSZINDEX=9998,zingchart.FSID=null,zingchart.ZCOUTPUT=0,zingchart.ASYNC=0,zingchart.SORTTRACKERS=0,zingchart.TIMEOUT=0,zingchart.USERCSS={},zingchart.OBJECTMODE="normal",zingchart.SYNTAX="mixed",zingchart.THEME=null,zingchart.EXPORTURL=("file:"===document.location.protocol?"http:":document.location.protocol)+"//export.zingchart.com/",zingchart.AJAXEXPORT=!1,zingchart.TOUCHZOOM="normal",zingchart.DEFAULT={height:480,width:640},zingchart.FASTWIDTH=0,zingchart.FONTSIZE=11,zingchart.FONTFAMILY="Lucida Sans Unicode,Lucida Grande,Lucida Sans,Helvetica,Arial,sans-serif",ZC.mobile&&(zingchart.FONTFAMILY="Lucida Sans,Helvetica,Arial,sans-serif"),zingchart.loadModules=function(e,t){for(var i=(""+e).split(","),n=0,a=i.length;n<a;n++){var r=ZC.GT(i[n]);r=ZC.ALIAS[r]||r,-1!==ZC.AV(["bar","bar3d","funnel","bullet"],r)&&(r="v"+r);var l=zingchart.MODULESDEP[r];null!==ZC._n_(l)&&zingchart.loadModules(l),-1===ZC.AV(ZC.RE,r)&&ZC.RE.push(r)}t&&zingchart.A15(null,ZC.RE,t)},zingchart.A15=function(e,t,i){function n(){function r(){++a===t.length?i():n()}var l,o=!0;zingchart.ACH(t[a])?l=zingchart.MODULESDIR+"zingchart-"+t[a]+".min.js":o=!1,o?ZC.AP.AC7(e,l,r):r()}var a=0;if(0===t.length)i();else{if(!document.getElementsByTagName("head")[0])return void i();n()}},zingchart.ACH=function(e){return-1!==ZC.AV(ZC.RE,e)&&-1===ZC.AV(ZC.WA,e)},zingchart.LD=[],ZC.ie67||function(){for(var e in ZC.IMAGES)ZC.IMAGES.hasOwnProperty(e)&&(zingchart.LD[e]=new Image,zingchart.LD[e].src=ZC.IMAGES[e])}(),"undefined"!=typeof Ext&&(zingchart.LD["zc.blank"]=new Image,zingchart.LD["zc.blank"].src=ZC.BLANK),zingchart.exec=function(e,t,i){return zingchart.exec_flash?zingchart.exec_flash(e,t,i):null},zingchart.ACY=function(O){var QB=O.dataurl||"",EW="",G,M6=null;null!==ZC._n_(G=O.data)&&("string"==typeof G?EW=G:M6=JSON.parse(JSON.stringify(G)));var DJ=null;if(""!==QB)ZC.A4.ajax({type:"GET",url:QB,async:!1,data:zingchart.ZCOUTPUT?"zcoutput=userdef":"",error:function(){return!1},success:function(K8){function _f_(e){ZC.cache.data["data-"+QB]=K8,O.output="auto",ZC._cp_(e.render,O)}try{DJ=JSON.parse(K8),_f_(DJ)}catch(J7){try{DJ=eval("("+K8+")"),_f_(DJ)}catch(J7){return!1}}}});else{if(""!==EW)try{DJ=JSON.parse(EW)}catch(J7){return!1}else null!==M6&&(DJ=M6);null===ZC._n_(O.output)&&(O.output="auto"),ZC._cp_(DJ.render,O)}return zingchart.render(O)},zingchart.ZU=null,zingchart.params={},zingchart.render=function(e,t){if(null===ZC._n_(t)&&(t=!1),t)return zingchart.ACY(e);null===ZC._n_(ZC.canvas)&&ZC.compat();var i=e.output||"auto";"html5"===i&&(i="auto"),ZC.mobile&&"auto"===i&&(i="svg");var n=!1;if("!"===i.substring(0,1)&&(n=!0,i=i.substring(1)),n||("auto"===i||"canvas"===i&&!ZC.canvas||"svg"===i&&!ZC.svg||"vml"===i&&!ZC.vml||"flash"===i&&!ZC.flash)&&(ZC.svg?i="svg":ZC.canvas?i="canvas":ZC.vml?i="vml":ZC.flash&&(i="flash")),"vml"===i&&null===ZC._n_(zingchart.ZU)&&(zingchart.ZU=!1),"flash"!==i)return zingchart.A8G(e,i);zingchart.render_flash(e)},document.attachEvent&&("complete"===document.readyState?zingchart.ZU=!0:document.attachEvent("onreadystatechange",function(){"complete"===document.readyState&&(zingchart.ZU=!0)})),zingchart.setlabel=zingchart.setLabel=function(e,t){ZC.HI[e]=t},zingchart.HU=[],zingchart.XR={},zingchart.ADF=0,zingchart.AD3=0,zingchart.ADD=!1,zingchart.A95=!1,zingchart.A9V=!1,zingchart.ACX=!1,zingchart.css=null,zingchart.WR=function(e){if(e.target.id){for(var t=null,i=0,n=zingchart.HU.length;i<n;i++)e.target.id.substr(0,zingchart.HU[i].K.length+1)===zingchart.HU[i].K+"-"&&(t=zingchart.HU[i]);return t}},ZC.GESTURE={id:null,on:!1,ts:null,type:null,dist:-1,mp:[-1,-1]},"undefined"==typeof zingchart.MG&&(zingchart.MG=function(e){if("INPUT"!==e.target.tagName.toUpperCase()&&"TEXTAREA"!==e.target.tagName.toUpperCase()){var t;if("pinch"===zingchart.TOUCHZOOM)switch(ZC.TOUCHEVENTS=!1,e.type){case"touchstart":for(var i=!1,n=0;n<zingchart.HU.length;n++)t=ZC.A4("#"+zingchart.HU[n].K+"-top"),ZC.DT(e.touches[0].pageX,t.offset().left,t.offset().left+t.width())&&ZC.DT(e.touches[0].pageY,t.offset().top,t.offset().top+t.height())&&(i=!0,ZC.GESTURE.id=zingchart.HU[n].K);i&&(ZC.GESTURE.on=!0);break;case"touchmove":if(ZC.GESTURE.on&&2===e.touches.length){e.preventDefault();var a=(e.touches[0].clientX-e.touches[1].clientX)*(e.touches[0].clientX-e.touches[1].clientX)+(e.touches[0].clientY-e.touches[1].clientY)*(e.touches[0].clientY-e.touches[1].clientY);a=Math.round(Math.sqrt(a));var r=[Math.round((e.touches[0].clientX+e.touches[1].clientX)/2),Math.round((e.touches[0].clientY+e.touches[1].clientY)/2)];if(-1===ZC.GESTURE.dist)ZC.GESTURE.dist=a,ZC.GESTURE.mp=r,ZC.GESTURE.ts=(new Date).getTime();else if((new Date).getTime()-ZC.GESTURE.ts>100){if(a>ZC.GESTURE.dist+50)ZC.GESTURE.type="pinch-in",zingchart.exec(ZC.GESTURE.id,"zoomin");else if(a<ZC.GESTURE.dist-50)ZC.GESTURE.type="pinch-out",zingchart.exec(ZC.GESTURE.id,"zoomout");else{ZC.GESTURE.type="panning";var l={};r[0]>ZC.GESTURE.mp[0]+10?(l["x-"]=!0,l.xdist=ZC._a_(ZC.GESTURE.mp[0]-r[0])):r[0]<ZC.GESTURE.mp[0]-10&&(l["x+"]=!0,l.xdist=ZC._a_(ZC.GESTURE.mp[0]-r[0])),r[1]>ZC.GESTURE.mp[1]+10?(l["y+"]=!0,l.ydist=ZC._a_(ZC.GESTURE.mp[1]-r[1])):r[1]<ZC.GESTURE.mp[1]-10&&(l["y-"]=!0,l.ydist=ZC._a_(ZC.GESTURE.mp[1]-r[1])),ZC.GESTURE.mp=r,zingchart.exec(ZC.GESTURE.id,"pan",l)}ZC.GESTURE.ts=(new Date).getTime()}}break;case"touchend":ZC.GESTURE.id=null,ZC.GESTURE.on=!1,ZC.GESTURE.type=null,ZC.GESTURE.ts=null,ZC.GESTURE.dist=-1,ZC.GESTURE.mp=[-1,-1]}if(window.ZC){window.ZC.DX=[e.pageX,e.pageY];var o=zingchart.WR(e);if(o){if(!zingchart.SKIP.EVENT){if("mousedown"===e.type&&(window.ZC.aMDXY=[e.pageX,e.pageY]),"touchstart"===e.type&&o.AH)for(var s=0;s<o.AH.length;s++)o.AH[s].LN();if(-1!==ZC.AV(["mouseover","mouseout","mouseover"],e.type)&&"IMG"!==e.target.tagName.toUpperCase())return;if("mouseout"===e.type&&(t=ZC.A4("#"+o.K+"-top"),ZC.DT(e.pageX,t.offset().left,t.offset().left+t.width(),!0)&&ZC.DT(e.pageY,t.offset().top,t.offset().top+t.height(),!0)))return;ZC.AP.BZ(e.type,o,zingchart.A09(e,o))}zingchart.SKIP.EVENT=!1}}}},ZC.A4(document).bind(ZC.Q.C0("mouseover"),zingchart.MG).bind(ZC.Q.C0("mouseout"),zingchart.MG).bind(ZC.Q.C0("mousemove"),zingchart.MG).bind(ZC.Q.C0("mousedown"),zingchart.MG).bind(ZC.Q.C0("mouseup"),zingchart.MG)),zingchart.A09=function(e,t){var i=ZC.Q.M7(e),n=t.A4O(i[0],i[1]),a=ZC.A4("#"+t.K+"-top"),r=Math.round(i[0]-a.offset().left),l=Math.round(i[1]-a.offset().top),o="none";return/(.*)\-scale\_(.*)\-item\_title\-area(.*)/.test(e.target.id)&&(o="scale-title"),/(.*)\-scale\_(.*)\-item\_(\d+)\-area(.*)/.test(e.target.id)&&(o="scale-item"),/(.*)\-plotset\-plot\-(\d+)\-node\-(\d+)(.*)/.test(e.target.id)&&(o="node"),/(.*)\-legend\-item\_(\d+)\-area/.test(e.target.id)&&(o="legend-item"),/(.*)\-legend\-marker\_(\d+)\-area/.test(e.target.id)&&(o="legend-marker"),/(.*)\-legend\-(.+)\-area/.test(e.target.id)&&(o="legend-element"),/(.*)\-menu\-item\-(.*)/.test(e.target.id)&&(o="menu-item"),/(.*)\-preview\-handler\-x(.*)/.test(e.target.id)&&(o="preview"),/(.*)\-shape\-(.*?)\-area/.test(e.target.id)&&(o="shape"),/(.*)\-label\-(.*?)\-area/.test(e.target.id)&&(o="label"),{id:t.K,ev:ZC.A4.C0(e),targetid:e.target.id,graphid:n?n.K:null,target:o,x:r,y:l,plotarea:!!n&&(r>=n.P.iX&&r<=n.P.iX+n.P.I&&l>=n.P.iY&&l<=n.P.iY+n.P.F),touch:ZC.mobile}},"undefined"==typeof zingchart.SA&&(zingchart.SA=function(e){for(var t=0,i=zingchart.HU.length;t<i;t++)zingchart.HU[t].hideCM();if(ZC.mobile&&ZC.move)ZC.move=!1;else if(ZC.mobile||!(e.which>1)){var n=zingchart.WR(e);if(n){if("click"===e.type&&ZC.aMDXY&&(ZC._a_(ZC.aMDXY[0]-e.pageX)>2||ZC._a_(ZC.aMDXY[1]-e.pageY)>2))return;if(!zingchart.SKIP.EVENT){var a=zingchart.A09(e,n);a.target=zingchart.plugins.CLICK_TARGET||a.target,zingchart.plugins.CLICK_TARGET=null,ZC.mobile&&"touchend"===e.type&&(n.D["click-ts"]&&(new Date).getTime()-n.D["click-ts"]<500&&ZC.AP.BZ("dblclick",n,a),n.D["click-ts"]=(new Date).getTime()),ZC.AP.BZ("dblclick"===e.type?"dblclick":"click",n,a)}zingchart.SKIP.EVENT=!1,e.target.id!==n.K+"-menu-area"?n.hideCM():zingchart.YU(e)}}},ZC.mobile?(ZC.A4(document).bind("touchmove",function(){ZC.move=!0}),ZC.A4(document).bind("touchend",function(){ZC.move=!1})):(ZC.A4(document).bind("click",zingchart.SA),ZC.A4(document).bind("dblclick",zingchart.SA))),"undefined"==typeof zingchart.A2N&&(zingchart.A2N=function(e){e.touches.length>0&&(ZC.TOUCHEVENTS=!0)},ZC.A4(document).bind("touchstart",zingchart.A2N)),"undefined"==typeof zingchart.YU&&(zingchart.YU=function(e,t,i){if(!e||"IMG"===e.target.tagName.toUpperCase()||"AREA"===e.target.tagName.toUpperCase()||-1!==ZC.Q.SV(e.target).indexOf("zc-scroll")||-1!==e.target.id.indexOf("-legend-")||-1!==e.target.id.indexOf("-preview-")||zingchart.DEV.SKIPTRACKERS){var n,a,r,l,o,s;i=i||{};var c=null===ZC._n_(t)?zingchart.WR(e):zingchart.getLoader(t);if(c){if(-1!==ZC.AV(c.KM,"skip_context_menu"))return!1;if(null===ZC._n_(t)?(a=ZC.Q.M7(e),n=c.A4O(a[0],a[1])):n=null!==ZC._n_(i.graphid)?c.OR(i.graphid):c.AH[0],!n)return!1;var h=ZC.A4("#"+c.K+"-top");null===ZC._n_(t)?(r=a[0]-h.offset().left,l=a[1]-h.offset().top):(r=c.I/2,l=c.F/2);var C={};e&&(C=zingchart.A09(e,c));var u=ZC.AP.BZ("contextmenu",c,C,!0);if(!u&&void 0!==u&&(!e&&!i["from-api"]||e&&e.target.id!==c.K+"-menu-area"))return e.preventDefault(),!1;var d=ZC._tx_(c.K);c.A5P(n?n.L:-1,e);var p=-1;if(0!==zingchart.CMZINDEX)p=zingchart.CMZINDEX;else for(var A=ZC.AK(c.K);-1===p&&null!==A.parentNode;)"auto"!==(p=ZC._i_(ZC.A4(A).css("zIndex")))&&""!==p&&null!==ZC._n_(p)||(p=-1),A=A.parentNode;p&&-1!==p&&null!==ZC._n_(p)||(p=1);var g=ZC.A4("#"+c.K+"-menu");if(g.css("zIndex",zingchart.ZINDEX+p+1),null===ZC._n_(t)){if(e.target.id===c.K+"-print-png"||e.target.id===c.K+"-print-jpeg")return!0;e.preventDefault()}if(!ZC.AK(c.K+"-menu"))return!1;r=h.offset().left,l=h.offset().top;var f=h.width(),Z=h.height();null===ZC._n_(t)?(o=(a=ZC.Q.M7(e))[0]||ZC.DX[0],s=a[1]||ZC.DX[1]):(o=r+c.I/2,s=l+5);var _=!1;if(c.VG("goback",!1),c.NY>0&&(c.VG("goback",!0),_=!0),c.VG("goforward",!1),c.NY<c.QQ.length-1&&(c.VG("goforward",!0),_=!0),c.VG("history",_,!0),o>=r&&o<=r+f*d[0]&&s>=l&&s<=l+Z*d[1]){ZC.A4(".zc-menu").each(function(){this.id!==c.K+"-menu"&&c.hideCM()}),c.SN=[o,s,null===ZC._n_(t)?e.target.id:t],g.css("opacity",0).show();var b=ZC._i_(g.css("width"))+ZC._i_(g.css("paddingLeft"))+ZC._i_(g.css("paddingRight")),m=ZC._i_(g.css("height"))+ZC._i_(g.css("paddingTop"))+ZC._i_(g.css("paddingBottom")),v=1,D=!1;c.o.gui&&c.o.gui["context-menu"]&&c.o.gui["context-menu"]&&(v=c.o.gui["context-menu"].alpha?c.o.gui["context-menu"].alpha:1,D=c.o.gui["context-menu"].docked),g.css("opacity",v).hide();var E,w;if("classic"!==c.LH&&D){if(D){var B=c.B8.NU[c.LH].root.gui["context-menu"];ZC._cp_(c.o.gui["context-menu"],B),E="left"!==c.o.gui["context-menu"].position&&ZC._n_(c.o.gui["context-menu"].position)?h.offset().left+h.width()-b:h.offset().left}w=h.offset().top,g.css("left",ZC.BQ(1,E)+"px").css("top",ZC.BQ(1,w)+"px").css("height",h.height()+"px").css("box-sizing","border-box").show(),g=ZC.A4("#"+c.K+"-menu"),D&&g.OX[0].scrollHeight>h.height()&&g.css("overflow-y","scroll")}else{if(null===ZC._n_(t)&&e.target.id===c.K+"-menu-area"){ZC.AK(c.K+"-menu").style.paddingTop=0;var K=ZC.A4("#"+c.K+"-menu-area").attr("coords").split(","),F=ZC._i_(K[3])-ZC._i_(K[1]);ZC.AK(c.K+"-menu").style.backgroundPosition=ZC._i_(K[0])>c.I/2?"100% 0% !important":"0% 0% !important",E=r+(ZC._i_(K[0])>c.I/2?ZC._i_(K[2])-b:ZC._i_(K[0])),w=l+(ZC._i_(K[1])>c.F/1.25?ZC._i_(K[3])-m-F:ZC._i_(K[3]))}else ZC.AK(c.K+"-menu").style.backgroundPosition="50% 0% !important",E=c.SN[0]-b/2,w=c.SN[1],m>c.F*d[1]?w=l:w-l+m>c.F*d[1]&&(w=ZC.BQ(w-m,c.F*d[1]-m)),E<r&&(E=ZC.BQ(E,r)),E+b>r+c.I*d[0]&&(E=ZC.CY(r+c.I*d[0]-b/2,E-b/2));if(i.position)switch(i.position){case"top":break;case"top-left":E=E-(c.I*d[0]-b)/2+5;break;case"top-right":E=E+(c.I*d[0]-b)/2-5;break;case"bottom":w=w+(c.F*d[1]-m)-10;break;case"bottom-left":w=w+(c.F*d[1]-m)-10,E=E-(c.I*d[0]-b)/2+5;break;case"bottom-right":w=w+(c.F*d[1]-m)-10,E=E+(c.I*d[0]-b)/2-5;break;case"left":w=w+(c.F*d[1]-m)/2-5,E=E-(c.I*d[0]-b)/2+5;break;case"right":w=w+(c.F*d[1]-m)/2-5,E=E+(c.I*d[1]-b)/2-5}else null!==ZC._n_(i.x)&&null!==ZC._n_(i.y)&&(E=r+ZC._i_(i.x),w=l+ZC._i_(i.y));if(g.css("left",ZC.BQ(1,E)+"px").css("top",ZC.BQ(1,w)+"px").show(),ZC.ie67){var x=ZC.A4("#"+c.K+"-menu div").width()[0]||120;g.css("width",x+"px")}}return c.A9B=!0,!1}}}},ZC.A4(document).bind("contextmenu",zingchart.YU)),zingchart.AA9=function(e,t){if(zingchart.css)return zingchart.css.addRule?zingchart.css.addRule(e,t):zingchart.css.insertRule(e+"{"+t+"}",0)},zingchart.wh=function(e,t,i){"auto"===t&&(t="100%"),"auto"===i&&(i="100%");var n,a,r=[0,0];return-1===(""+t).indexOf("%")&&-1===(""+i).indexOf("%")||(r=e.wh()),n=-1!==(""+t).indexOf("%")?r[0]*parseInt(t,10)/100:parseInt(t,10),a=-1!==(""+i).indexOf("%")?r[1]*parseInt(i,10)/100:parseInt(i,10),[n,a]},zingchart.IV={},zingchart.bind=function(e,t,i){e=e||"zingchart-global",zingchart.IV[e]||(zingchart.IV[e]={}),zingchart.IV[e][t]?zingchart.IV[e][t].push({fn:i}):zingchart.IV[e][t]=[{fn:i}]},zingchart.unbind=function(e,t,i){if(e=e||"zingchart-global",zingchart.IV[e]&&zingchart.IV[e][t])if(i){for(var n=0,a=zingchart.IV[e][t].length;n<a;n++)if(zingchart.IV[e][t][n].fn===i){zingchart.IV[e][t].splice(n,1);break}}else zingchart.IV[e][t]=null},zingchart.callEvent=function(e,t,i,n){if(e=e||"zingchart-global",zingchart.IV[e]&&zingchart.IV[e][t]){for(var a=0,r=zingchart.IV[e][t].length;a<r;a++)null!==ZC._n_(n)?i[i.length-1]=zingchart.IV[e][t][a].fn.apply(zingchart,i):zingchart.IV[e][t][a].fn.apply(zingchart,i);if(null!==ZC._n_(n))return i[i.length-1]}},zingchart.hasEvent=function(e,t){return e=e||"zingchart-global",zingchart.IV[e]&&zingchart.IV[e][t]},zingchart.A8G=function(e,t){function i(){if(!g.D.wh||g.D.wh!==g.I+"/"+g.F){for(var e=!1,t=0;t<zingchart.HU.length;t++)zingchart.HU[t].K===g.K&&(e=!0);e&&g.resize()}g.A00=!1}function n(){g.A00?g.V6.width!==g.I&&(clearTimeout(g.A63),g.V6.width=g.I,g.V6.height=g.F,g.A63=setTimeout(i,zingchart.DEV.DEBOUNCESPEED)):(g.A00=!0,g.V6={width:g.I,height:g.F},g.A63=setTimeout(i,zingchart.DEV.DEBOUNCESPEED))}ZC._todash_(e,!1);var a,r,l,o,s,c,h,C,u=[];if(null!==ZC._n_(a=e.flags)&&(u=a.split(",")),null!==ZC._n_(a=e.mode))switch(a){case"static":u=["skip_context_menu","skip_segment_tracking","skip_marker_tracking","skip_interactivity","use_single_canvas"]}var d="";if(null!==ZC._n_(a=e.container)&&(d=a),null!==ZC._n_(a=e.id)&&(d=a),ZC.AK(d)){var p=null;for(l=0;l<zingchart.HU.length;l++)zingchart.HU[l].K===d&&(p=zingchart.HU[l].M9);if(null!==ZC._n_(p)){if(""!==p)return;zingchart.exec(d,"destroy")}zingchart.params[d]={},ZC._cp_(e,zingchart.params[d]);var A=!1,g=null;for(l=0;l<zingchart.HU.length;l++)zingchart.HU[l].K===d&&(zingchart.HU[l]=new ZC.RG,g=zingchart.HU[l],A=!0);if(A||((g=new ZC.RG).M9="init",zingchart.HU.push(g)),g.K=d,zingchart.XR[d]=!0,"vml"!==t||zingchart.ZU||zingchart.A8G(e,t),!zingchart.A9V){zingchart.A9V=!0;var f={".zc-style":"font-family:"+zingchart.FONTFAMILY+";font-size:"+zingchart.FONTSIZE+"px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",".zc-style *":"font-family:"+zingchart.FONTFAMILY+";font-size:"+zingchart.FONTSIZE+"px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",".zc-top *":"text-align:left;margin:auto;text-shadow:none;",".zc-menu *":"text-align:left;margin:auto;",".zc-main text":"-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;",".zc-img":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-map":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-pixmap":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-preview-mask":"cursor:default;-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-about":"position:absolute;overflow:hidden;border:5px solid #fff;background:#003C4F url("+(ZC.ie67?"//":ZC.LOGO_ABOUT)+") no-repeat center 10px",".zc-about-1":"padding:80px 5px 5px 5px;text-align:center !important;",".zc-about-1 a":"color:#1AB6E3;font-size:17px;line-height:125%;",".zc-about-2":"padding:5px;color:#fff;text-align:center !important;",".zc-about-3":"padding:5px;text-align:center;line-height:125%;",".zc-about-3 div":"background-color:#1AB6E3;line-height:125%;color:#fff;border:1px solid #fff;padding:5px 10px;font-weight:bold;width:60px;margin:0 auto;cursor:pointer;text-align:center",".zc-about-4":"color:#fff;line-height:125%;",".zc-about-4 div":"float:right;color:#fff;line-height:125%;",".zc-viewsource":"border:5px solid #fff;background:#999",".zc-error":"border:5px solid #fff;background:#900",".zc-bugreport":"border:5px solid #fff;background:#999",".zc-form-row-label":"padding:4px 10px 2px;text-align:left;color:#fff",".zc-form-row-element":"padding:2px 8px",".zc-form-row-last":"padding:8px 8px 2px !important",".zc-form-row-element textarea":"text-align:left;background:#fff;color:#000;border:1px solid #333;",".zc-form-row-label input":"color:#000;padding:2px;margin:0 5px 0 0;background-color:#999;",".zc-form-row-element input":"color:#000;padding:2px;margin:0;background-color:#fff",".zc-form-row-last input":"padding:4px 10px !important;margin:0 20px 0 0 !important;background-color:#eee !important;border:2px outset #ccc !important",".zc-form-s0":"font-size:27px !important;letter-spacing:-1px;line-height:125%",".zc-form-s1":"font-size:17px !important;line-height:125%",".zc-form-s1 a":"color:#fff;padding:3px 10px;position:relative;top:4px;border:1px solid #333;border-bottom:0px solid #333",".zc-tab-active":"background-color:#fff;color:#333 !important",".zc-tab-inactive":"background-color:#999;color:#ddd !important",".zc-bugreport label":"display:inline-block;position:relative;top:-2px",".zc-viewimage div":"position:absolute;text-align:center;padding:5px;background:#999;color:#fff",".zc-license-ie67":"padding:0;position:absolute;font-size:12px;font-weight:bold;font-family:"+zingchart.FONTFAMILY+";color:#369;text-align:left",".zc-license":"padding:0;position:absolute;","#zc-fullscreen":"display:block;position:absolute;top:0;left:0;width:100%;height:100%;margin:0;padding:0;background:#fff;",".zc-menu":"position:absolute;display:none;background-repeat:no-repeat !important;background-position:50% 0% !important;",".zc-menu-sep":"font-size:1px;padding:0;line-height:1px;border-bottom:1px solid #000",".zc-menu-item":"cursor:pointer;white-space:nowrap",".zc-blocker":"background:#eee",".zc-blocker div.zc-blocker-msg":"position:absolute;border:2px solid #ccc;padding:10px 30px;background-color:#333;color:#fff",".zc-modal":"background-color:#fff;color:#000;border:2px solid #999",".zc-guide-label-table":"border-collapse:collapse",".zc-guide-label-table td":"padding:4px 10px 2px 2px",".zc-data-table":"border-collapse:collapse",".zc-data-table caption":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:17px;font-weight:600;padding:6px 14px 6px 4px;background-color:#ccc;border-bottom:2px solid #666",".zc-data-table th":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:13px;font-weight:600;padding:2px 14px 2px 4px;background-color:#ddd;border-bottom:1px solid #666",".zc-data-table td":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:11px;padding:1px 14px 1px 4px;background-color:#ffffff;border-bottom:1px solid #eee;white-space:nowrap",".zc-rel":"top:0;left:0;position:relative",".zc-abs":"top:0;left:0;position:absolute"};ZC.ie678||(f[".zc-data-table th:not(:last-child)"]="border-right:1px dotted #666",f[".zc-data-table td:not(:last-child)"]="border-right:1px solid #eee");var Z=document.getElementsByTagName("head")[0],_=document.createElement("style");if(_.type="text/css",_.setAttribute("data-author","zingchart"),Z.appendChild(_),!zingchart.css)for(l=0,o=document.styleSheets.length;l<o;l++)document.styleSheets[l].ownerNode&&"zingchart"===document.styleSheets[l].ownerNode.getAttribute("data-author")&&(zingchart.css=document.styleSheets[l]);zingchart.css||(zingchart.css=document.styleSheets[document.styleSheets.length-1]);for(var b in f)null!==ZC._n_(zingchart.USERCSS[b])?zingchart.AA9(b,zingchart.USERCSS[b]):zingchart.AA9(b,f[b])}"vml"!==t||zingchart.A95||(document.namespaces.add("zcv","urn:schemas-microsoft-com:vml"),document.createStyleSheet().cssText=".zcvml { behavior:url(#default#VML); }",zingchart.A95=!0);var m="";zingchart.THEME&&(m=zingchart.THEME),e.data&&null!==ZC._n_(a=e.data.theme)&&(m=a),null!==ZC._n_(a=e.theme)&&(m=a);var v={data:!1,defaults:!1,css:!1,csv:!1};if(null!==ZC._n_(a=e.cache))for(var D in v)null!==ZC._n_(r=a[D])&&(v[D]=ZC._b_(r));var E=!1;null!==ZC._n_(a=e.fullscreen)&&(E=ZC._b_(a));var w=!0;null!==ZC._n_(a=e["auto-resize"])&&(w=ZC._b_(a));var B=ZC.A4("#"+d);s=(e.width||"100%")+"",c=(e.height||""+zingchart.DEFAULT.height)+"","auto"===s&&(s="100%"),"auto"===c&&(c="100%");var K=zingchart.wh(B,s,c);h=K[0],C=K[1],E&&(h=ZC.A4(window).width(),C=ZC.A4(window).height(),document.body.style.overflow="hidden"),h<10&&(h=zingchart.DEFAULT.width),C<10&&(C=zingchart.DEFAULT.height),h=0===h?zingchart.DEFAULT.width:h,C=0===C?zingchart.DEFAULT.height:C;var F=e.dataurl||"",x=e.defaultsurl||"",y=null,I="",z=null;null!==ZC._n_(a=e.data)&&("string"==typeof a?I=a:z=zingchart.DEV.COPYDATA?JSON.parse(JSON.stringify(a)):a),null!==ZC._n_(a=e.defaults)&&("string"==typeof a&&(a=JSON.parse(a)),y=a),null!==ZC._n_(a=e.imggen)&&(g.A10=ZC._b_(a)),g.A10&&(g.FY=null),g.JJ=s+"/"+c,g.AC=t,g.A=g,g.iX=0,g.iY=0,g.I=h,g.F=C,g.FV=s,g.MN=c,g.QB=F,g.EW=I,g.M6=z,g.QN=x,g.MM=y,g.UA=!1,null!==ZC._n_(e.fullscreenmode)&&ZC._b_(e.fullscreenmode)&&(g.QV=!0),g.LO=E,g.RX=v,g.KM=u,g.LH=m,g.H=g,g.D.hideprogresslogo=!1,null!==ZC._n_(a=e.hideprogresslogo)&&(g.D.hideprogresslogo=ZC._b_(a)),null!==ZC._n_(a=e.customprogresslogo)&&(g.D.customprogresslogo=a),null!==ZC._n_(a=e.customprogresstext)&&(g.D.customprogresstext=a),null!==ZC._n_(a=e.exportdataurl)&&(g.D.exportdataurl=a),null!==ZC._n_(a=e.exportimageurl)&&(g.D.exportimageurl=a);var H={};null!==ZC._n_(a=e.bgcolor)&&(H["background-color"]=a),null!==ZC._n_(a=e["background-color"])&&(H["background-color"]=a),null!==ZC._n_(a=e["border-color"])&&(H["border-color"]=a),null!==ZC._n_(a=e["border-width"])&&(H["border-width"]=a),null!==ZC._n_(a=e.color)&&(H.color=a),g.D.progress=H,null!==ZC._n_(a=e["auto-load-modules"])&&(g.A6E=ZC._b_(a)),null!==ZC._n_(a=e.events)&&(g.A0V=a),null!==ZC._n_(a=e.modules)&&(g.A1I=a),null!==ZC._n_(a=e.format)&&(g.CI=a),null!==ZC._n_(a=e.csvdata)&&(g.NT=a),null!==ZC._n_(a=e.locale)&&null!==ZC._n_(zingchart.i18n[a])&&(g.A0W=a,ZC.HI=zingchart.i18n[a]),null!==ZC._n_(a=e["cache-control"])&&(g.MX=a);for(var M in zingchart.params)if(!zingchart.XR[M]){delete zingchart.params[M],delete ZC.TS[M];for(var S in zingchart.pool.data)0===S.indexOf(M+"-")&&(delete zingchart.pool.data[S],zingchart.pool.size--)}if(g.render(),B.css("overflow","hidden"),g.LO&&B.css("position","absolute").css("top",0).css("left",0),(-1!==g.FV.indexOf("%")||-1!==g.MN.indexOf("%")||g.LO||g.QV)&&w){var k=g.QV||g.LO?ZC.A4(window):B,X=k.width(),T=k.height(),P=0;g.A00=!1,g.YQ=window.setInterval(function(){var e;if(ZC.AK(d)&&!g.A27){var t=ZC.A4("#"+d+"-top"),i=!1;if(-1!==(""+g.FV).indexOf("%")&&t.length&&k.length&&t.width()!==k.width()&&(i=!0),0!==P||k.width()===X&&k.height()===T&&!i){if(k.width()+k.height()>0&&(k.width()!==X||k.height()!==T)&&(e=g.LO||g.QV?zingchart.wh(k,""+k.width(),""+k.height()):zingchart.wh(k,g.FV,g.MN))[0]>10&&e[1]>10){for(g.I=e[0],g.F=e[1],X=k.width(),T=k.height(),l=0,o=g.AH.length;l<o;l++)g.AH[l].M8[0]=0;n()}}else if(X=k.width(),T=k.height(),X>10&&T>10){for(-1!==(""+g.FV).indexOf("%")?g.I=X*ZC.IH(g.FV):g.I=X,-1!==(""+g.MN).indexOf("%")?g.F=T*ZC.IH(g.MN):g.F=T,l=0,o=g.AH.length;l<o;l++)g.AH[l].M8[0]=0;n()}P++}else window.clearInterval(g.YQ)},zingchart.DEV.RESIZESPEED)}return g}},window.zingchart=zingchart,ZC.A4.browser.msie&&parseFloat(ZC.A4.browser.version)<9){var _window_onunload_=window.onunload;window.onunload=function(){for(;zingchart.HU.length;){var e=zingchart.HU[0];e.AA1({},!0),e.YQ&&window.clearInterval(e.YQ),ZC.Q.EU([e.K+"-top",e.K+"-text-ruler"]);var t=ZC.AV(zingchart.HU,e);-1!==t&&zingchart.HU.splice(t,1),e=null}ZC.A4(document).unbind(ZC.Q.C0("mouseover"),zingchart.MG).unbind(ZC.Q.C0("mouseout"),zingchart.MG).unbind(ZC.Q.C0("mousemove"),zingchart.MG).unbind(ZC.Q.C0("mousedown"),zingchart.MG).unbind(ZC.Q.C0("mouseup"),zingchart.MG).unbind("click",zingchart.SA).unbind("contextmenu",zingchart.YU),zingchart.HU=[],_window_onunload_&&_window_onunload_()}}zingchart.i18n.en_us={rtl:!1,"decimals-separator":".","thousands-separator":"","menu-enablepagescroll":"Enable Page Scroll","menu-disablepagescroll":"Disable Page Scroll","menu-reload":"Reload","menu-print":"Print Chart","menu-viewaspng":"View As PNG","menu-viewasjpg":"View As JPG","menu-downloadpdf":"Download PDF","menu-downloadsvg":"Download SVG","menu-downloadcsv":"Download CSV","menu-downloadxls":"Download XLS","menu-viewdatatable":"View Data Table","menu-hidedatatable":"Hide Data Table","menu-exportdata":"Export Data","menu-zoomin":"Zoom In","menu-zoomout":"Zoom Out","menu-viewall":"View All","menu-viewsource":"View Source","menu-bugreport":"Submit Bug","menu-switchto2d":"Switch To 2D","menu-switchto3d":"Switch To 3D","menu-showguide":"Show Guide","menu-hideguide":"Hide Guide","menu-switchtolin":"Show Linear Scale","menu-switchtolog":"Show Log Scale","menu-fullscreen":"Full Screen","menu-exitfullscreen":"Exit Full Screen","menu-goback":"Go Back","menu-goforward":"Go Forward","date-formats":{msecond:"%d %M %Y<br>%g:%i:%s %A<br>%q ms",second:"%d %M %Y<br>%g:%i:%s %A",minute:"%d %M %Y<br>%g:%i %A",hour:"%d %M %Y<br>%g %A",day:"%d %M %Y",month:"%M %Y",year:"%Y"},"days-short":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"days-long":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],"months-short":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"months-long":["January","February","March","April","May","June","July","August","September","October","November","December"],"sync-wait":"Wait...","export-wait":"Exporting...","progress-wait-long":"Wait. Loading...","progress-wait-short":"Wait...","progress-wait-mini":"...","error-header":"An Error Has Occured","error-message":"Error Message:","error-close":"Close","bugreport-header":"Submit Bug Report","bugreport-senddata":"Send JSON Data","bugreport-sendcapture":"Send Graph Capture","bugreport-yourcomment":"Your Comment:","bugreport-jsondata":"JSON Data:","bugreport-youremail":"Your Email Address","bugreport-infoemail":"if you want to receive via email our reply to your problem","bugreport-emailmandatory":"Email address is mandatory...","bugreport-submit":"Submit","bugreport-cancel":"Cancel","bugreport-confirm":"Your bug report was sent.\n\nThank you!","about-close":"Close","viewsource-jsonsource":"Parsed JSON","viewsource-originalsource":"Original JSON","viewsource-close":"Close","viewsource-apply":"Apply","viewimage-close":"Close","legend-pagination":"Page %page% of %pages%"},ZC.HI=zingchart.i18n.en_us,zingchart.getLoader=function(e){for(var t=0;t<zingchart.HU.length;t++)if(zingchart.HU[t].K===e)return zingchart.HU[t];return null},zingchart.getGraph=function(e,t){return e.OR(t)},zingchart.clearLayer=function(e){e.A8&&e.A8.onmouseout();for(var t=0;t<e.AH.length;t++)e.AH[t].LN()},zingchart.getGraphInfo=function(e,t,i){return e.A4J(t,i)},zingchart.initThemes=function(e){e&&e.A9J(!0)},zingchart.setModule=function(e){ZC.WA.push(e)},zingchart.getModules=function(e){return e.A1I.split(",")},zingchart.defineModule=function(e,t,i){switch(zingchart.setModule(e),t){case"chart":zingchart.bind(null,"dataparse",function(t,n){for(var a=n.graphset.length,r=0;r<a;r++)if(n.graphset[r].type===e){var l=n.graphset[r];l.id?l.id=l.id:l.id=e.replace(/-/g,"")+r,n.graphset[r]=i(l)}return n});break;case"plugin":zingchart.bind(null,"dataparse",function(t,n){var a=zingchart.getLoader(t.id);if(-1!==zingchart.getModules(a).indexOf(e))for(var r=n.graphset.length,l=null,o=0;o<r;o++)(l=n.graphset[o]).hasOwnProperty(e)&&(n.graphset[o]=i(l,t.id));return n})}},zingchart.getPalette=function(e,t,i){return i=i||"bar",e.B8.A9M(t,i)},zingchart.getObject=function(e,t,i){var n,a;switch(i=i||"label"){case"shape":for(n=0,a=e.FE.length;n<a;n++)if(e.FE[n].H2===t||n===t)return e.FE[n].BE;break;case"label":for(n=0,a=e.BX.length;n<a;n++)if(e.BX[n].H2===t||n===t)return e.BX[n]}return null},zingchart.getInstance=function(e,t){switch(t){case"style":return new ZC.D0(e);case"shape":return new ZC.DW(e);case"box":return new ZC.HS(e);case"textbox":return new ZC.DS(e)}return null},zingchart.normalize=function(e){ZC._todash_(e)},zingchart.copy=function(e,t){ZC._cp_(e,t)},zingchart.formatDate=function(e,t,i,n){return ZC.AP.Y2(e,t,i,n)},zingchart.formatNumber=function(e,t){return ZC.AP.GF(e,t)},zingchart.fireEvent=function(e,t,i){ZC.AP.BZ(e,t,i)},zingchart.A8X=[],zingchart.extendAPI=function(e,t){zingchart.A8X.push({call:e,api:t})},zingchart.exec=function(e,t,i){return zingchart.getLoader(e)?zingchart.ACR(e,t,i):zingchart.exec_flash?zingchart.exec_flash(e,t,i):void 0},zingchart.ACR=function(e,t,i){var n,a,r;i=i||{},document.getElementById("zc-fullscreen")&&!i.skipfs&&(e="zc-fullscreen"),"string"==typeof i&&(i=JSON.parse(i));var l,o,s,c,h=zingchart.getLoader(e);if(null!==ZC._n_(i.preservezoom)&&(h.D.preservezoom=ZC._b_(i.preservezoom)),h)switch(t){case"goback":h.I7&&h.NY>0&&(ZC.AP.BZ("history_back",h,h.FH()),h.NY--,zingchart.exec(h.K,"setdata",{data:h.QQ[h.NY]}));break;case"goforward":h.I7&&h.NY<h.QQ.length-1&&(ZC.AP.BZ("history_forward",h,h.FH()),h.NY++,zingchart.exec(h.K,"setdata",{data:h.QQ[h.NY]}));break;case"setmode":if("undefined"==typeof h.D["mode-flags"]&&(h.D["mode-flags"]=h.KM.join(",")),""===i.mode&&"undefined"!=typeof h.D["mode-flags"])h.KM=h.D["mode-flags"].split(",");else{h.KM=[];var C=(""+i.mode).split(",");-1!==ZC.AV(C,"static")&&h.KM.push("skip_context_menu","skip_objects_tracking","skip_segment_tracking","skip_marker_tracking","skip_interactivity")}break;case"showmenu":ZC.DX[0]=ZC._n_(i.x)?i.x:ZC.DX[0],ZC.DX[1]=ZC._n_(i.y)?i.y:ZC.DX[1],i["from-api"]=!0,zingchart.YU(null,h.K,i);break;case"hidemenu":h.hideCM();break;case"destroy":case"zcdestroy":for(ZC.AP.BZ("beforedestroy",h,{id:e,loader:h}),delete zingchart.XR[e],a=0,r=h.AH.length;a<r;a++)h.AH[a].M8[0]=0,h.AH[a].BA&&(h.AH[a].BA.JA=!1,h.AH[a].unbind(!1,!0)),h.H9&&(h.H9.JA=!1);ZC.move=!1,h.A0G(),h.AA1(i,!0),zingchart.DEV.GC&&h.gc(),h.YQ&&window.clearInterval(h.YQ),h.YO&&window.clearInterval(h.YO),zingchart.IV[e]&&delete zingchart.IV[e],ZC.Q.EU([e+"-wrapper",e+"-top",e+"-text-ruler",e+"-dummy",e+"-progress"]),h.A13||delete zingchart.params[e],delete ZC.TS[e],delete ZC.cache.data["svg-rect"];for(var u in zingchart.pool.data)0===u.indexOf(e+"-")&&(delete zingchart.pool.data[u],zingchart.pool.size--);var d=ZC.AV(zingchart.HU,h);-1!==d&&zingchart.HU.splice(d,1),zingchart.HU.length||(zingchart.GUIDE_EV=null,delete zingchart.LD["zc.logo"]),h=null,ZC.AP.BZ("destroy",null,{id:e});break;case"getrender":return h.AC;case"clear":h.AA1(i);break;case"reload":h.A8R(i);break;case"load":h.ACU(i);break;case"enable":h.A3T();break;case"disable":h.A83(i.text);break;case"closemodal":ZC.Q.EU([h.K+"-modal",h.K+"-blocker"]);break;case"openmodal":if(!ZC.AK(h.K+"-modal"))return ZC.Q.HX({cls:"zc-abs zc-style zc-blocker",id:h.K+"-blocker",p:ZC.AK(h.K+"-top"),wh:h.I+"/"+h.F,opacity:.75}),ZC.Q.HX({cls:"zc-abs zc-style zc-modal",id:h.K+"-modal",p:ZC.AK(h.K+"-top"),tl:(h.F-i.height)/2+"/"+(h.I-i.width)/2,wh:i.width+"/"+i.height,opacity:1}),ZC.AK(h.K+"-modal");break;case"mapdata":h.ABW(i);break;case"print":h.A97();break;case"fullscreen":h.A5M();break;case"exitfullscreen":zingchart.exec("zc-fullscreen","destroy"),ZC.Q.EU("zc-fullscreen");break;case"resize":h.A27=!0;var p=h.I,A=h.F,g=h.JJ.split("/"),f=!1,Z=g[0],_=g[1];null!==ZC._n_(n=i.width)&&(Z=n),null!==ZC._n_(n=i.height)&&(_=n),null!==ZC._n_(n=i.scale)&&(f=ZC._b_(n)),h.A13&&(zingchart.params[h.K].width=Z,zingchart.params[h.K].height=_);var b=zingchart.wh(ZC.A4("#"+h.K),Z,_);(i.layout||(p!==b[0]||A!==b[1])&&b[0]>10&&b[1]>10)&&(h.I=b[0],h.F=b[1],null!==ZC._n_(n=i.layout)&&(h.o.layout=n),""===h.M9&&(h.D["from-api"]=!0,h.D.preservezoom=!0,h.resize(f),h.FV=Z,h.MN=_,h.A27=!1));break;case"plothide":case"hideplot":(l=h.C9(i.graphid))&&l.A3P(i,"hide");break;case"showguide":case"hideguide":ZC.DX[0]=ZC._n_(i.x)?i.x:ZC.DX[0],ZC.DX[1]=ZC._n_(i.y)?i.y:ZC.DX[1],(l=h.C9(i.graphid))&&h.YY(l.K,"showguide"===t);break;case"showtooltip":case"hidetooltip":case"clicknode":if(l=h.C9(i.graphid)){var m=i.ev||{};(o=l.HV(i.plotindex,i.plotid))&&o.R.length&&!i.xy?(s=o.L,c=ZC._i_(i.nodeindex||"0"),m.targetid=l.K+"-plotset-plot-"+s+"-node-"+c,m.update=!0):m.targetid=l.K+"-xy-"+ZC._i_(i.y||"0")+"-"+ZC._i_(i.x||"0"),"clicknode"===t?(m.which=0,l.T5(m)):l.A.A8&&("showtooltip"===t?l.A.A8.onmouseover(m,i.data):l.A.A8.hide())}break;case"locktooltip":ZC.TTLOCK=!0;break;case"unlocktooltip":ZC.TTLOCK=!1;break;case"showhoverstate":if(l=h.C9(i.graphid)){o=l.HV(i.plotindex,i.plotid),s=ZC._i_(o?o.L:0),c=ZC._i_(i.nodeindex||"0");var v=l.AY.A6[s].FP(c);l.LN(),v.A3H()}break;case"plotshow":case"showplot":(l=h.C9(i.graphid))&&l.A3P(i,"show");break;case"togglesource":ZC.AK(h.K+"-viewsource")?ZC.Q.EU(h.K+"-viewsource"):h.A5L();break;case"togglebugreport":ZC.AK(h.K+"-bugreport")?ZC.Q.EU(h.K+"-bugreport"):h.A6I();break;case"toggleabout":ZC.AK(h.K+"-about")?ZC.Q.EU([h.K+"-about",h.K+"-about-mask"]):h.A9D();break;case"toggleplot":(l=h.C9(i.graphid))&&l.Q4(i);break;case"getcharttype":return(l=h.C9(i.graphid))?l.AF:null;case"showversion":case"getversion":return ZC.VERSION;case"get3dview":return(l=h.C9(i.graphid))?l.F0:null;case"set3dview":(l=h.C9(i.graphid))&&(null===ZC._n_(h.o.graphset[l.L]["3d-aspect"])&&(h.o.graphset[l.L]["3d-aspect"]={}),ZC._cp_(i,h.o.graphset[l.L]["3d-aspect"]),null===ZC._n_(l.o["3d-aspect"])&&(l.o["3d-aspect"]={}),ZC._cp_(i,l.o["3d-aspect"]),zingchart.SKIP.PARSE3D=!0,l.autoFit(),l.K3(!0,!0),zingchart.SKIP.PARSE3D=!1);break;case"getpage":return h.L4;case"setpage":var D=0;null!==ZC._n_(n=i.page)&&(D=ZC._i_(n)),h.L4=D,ZC.ZH(function(){h.clear(),h.parse(),h.paint()},!0);break;case"unbinddocument":ZC.A4(document).unbind(ZC.Q.C0("mousemove"),zingchart.MG).unbind(ZC.Q.C0("mousedown"),zingchart.MG).unbind(ZC.Q.C0("mouseup"),zingchart.MG).unbind("click",zingchart.SA).unbind("contextmenu",zingchart.YU),h.D5&&h.D5.unbind()}var E;for(zingchart.ABE&&null!==(E=zingchart.ABE(e,t,i))&&(n=E),zingchart.AB1&&null!==(E=zingchart.AB1(e,t,i))&&(n=E),zingchart.AB5&&null!==(E=zingchart.AB5(e,t,i))&&(n=E),zingchart.ABF&&null!==(E=zingchart.ABF(e,t,i))&&(n=E),zingchart.AAJ&&null!==(E=zingchart.AAJ(e,t,i))&&(n=E),zingchart.ABG&&null!==(E=zingchart.ABG(e,t,i))&&(n=E),a=0,r=zingchart.A8X.length;a<r;a++)t===zingchart.A8X[a].call&&null!==(E=zingchart.A8X[a].api.call(zingchart,e,i))&&(n=E);return n},zingchart.extendAPI("addmenuitem",function(e,t){var i=zingchart.getLoader(e);i.DF["context-menu"]=i.DF["context-menu"]||{},i.DF["context-menu"]["custom-items"]=i.DF["context-menu"]["custom-items"]||[];for(var n=t.id||"",a=i.DF["context-menu"]["custom-items"],r=!1,l=0;l<a.length;l++)if(a[l].id===n){r=!0;break}r||i.DF["context-menu"]["custom-items"].push(t)}),ZC.ACO=ZC.C8.C7({$i:function(){var e=this;e.O8=null,e.o={},e.I0=null,e.J5=null,e.D={},e.E7=[],e.HT=null,e.N2=""},GZ:function(e,t,i,n,a){var r=this;if(e.HT){a=a||r.N2;var l=e.HT.call(r,n,a);i&&l&&(l[i+"-state"]?l=l[i+"-state"]:l[i+"State"]&&(l=l[i+"State"]));var o,s,c=r.getPMap(),h={},C={};for(var u in l)o=ZC.EC(u),s=ZC.U7(u),"backgroundColor"===o?h.A0=h.AE=ZC.AP.G5(l[u]):"borderRadius"===o?h.F5=h.FQ=h.FB=h.F2=l[u]:"padding"===u?h.FJ=h.FK=h.FR=h.EP=l[u]:c[o]?h[c[o]]=l[u]:h[o]=l[u],C[s]=l[u];t.o||ZC._cp_(l,h),ZC._cp_(h,t),t.o&&(ZC._cp_(C,t.o),t.KV())}},parse:function(){var e,t,i,n,a=this;"dashed"!==zingchart.SYNTAX&&ZC._todash_(a.o);var r="";if("undefined"!=typeof a.H&&(r=a.H.AC),ZC.Z8(a.o,"html5"),""!==r&&ZC.Z8(a.o,r),zingchart.DEV.MEDIARULES&&a.o["media-rules"]&&"undefined"!=typeof a.H)for(t=0;t<a.o["media-rules"].length;t++)i=a.o["media-rules"][t],n=!0,null!==ZC._n_(i["min-width"])&&ZC._i_(i["min-width"])>a.H.I&&(n=!1),null!==ZC._n_(i["max-width"])&&ZC._i_(i["max-width"])<a.H.I&&(n=!1),null!==ZC._n_(i["min-height"])&&ZC._i_(i["min-height"])>a.H.F&&(n=!1),null!==ZC._n_(i["max-height"])&&ZC._i_(i["max-height"])<a.H.F&&(n=!1),n&&ZC._cp_(i,a.o);for(a.o.rules&&(a.E7=a.o.rules),t=0;t<a.E7.length;t++)if("*"===a.E7[t].rule&&a.E7[t].js){a.o["js-rule"]=a.E7[t].js,a.E7.splice(t,1);break}if((e=a.o["js-rule"])&&("javascript:"===e.substring(0,11)||e.indexOf("(")<e.indexOf(")")))try{a.N2="";var l=e.replace("javascript:",""),o=e.indexOf("("),s=e.indexOf(")");-1!==o&&-1!==s&&(a.N2=l.substr(o+1,s-o-1),l=l.substr(0,o)),a.HT=ZC.evalFn(l,window)}catch(h){}if("undefined"!=typeof a.H&&null!==a.H.QP)for(var c in a.H.QP)a.H.QP.hasOwnProperty(c)&&null===ZC._n_(a.o[c])&&(a.o[c]=a.H.QP[c])},getPMap:function(){return{}},addPMap:function(e,t,i){for(var n=t.split(","),a=i.split(","),r=0,l=a.length;r<l;r++)e[n[r]]=a[r]},getData:function(){return this.o},setData:function(e){this.o=e},getAttributes:function(){return this.D},getAttribute:function(e){return this.D[e]},setAttribute:function(e,t){this.D[e]=t},get:function(e){var t=this.getPMap();return t[e]?this[t[e]]:null},set:function(e,t){var i=this.getPMap();i[e]&&(this[i[e]]=t)},append:function(e,t,i){null===t&&(t=!0);var n=this;e&&(n.I0||(n.I0={},ZC._cp_(n.o,n.I0,!0,i)),n.J5||(n.J5={}),ZC._cp_(e,n.J5,!0,i),ZC._cp_(e,n.o,!0,i)),"undefined"!=typeof n.AD0&&n.AD0()&&e&&ZC._cp_(e,n.o)},AD0:function(){},assign_a:function(e){for(var t=0,i=e.length;t<i;t++)this.o.hasOwnProperty(e[t][0])&&this.Z5(e[t][0],e[t][1],e[t][2],e[t][3],e[t][4])},Z5:function(e,t,i,n,a){var r,l=this;if(null!==(r=l.o[e])&&void 0!==r){if(i)switch(-1!==i.indexOf("p")&&(r=ZC._p_(r),i=i.replace("p","")),-1!==i.indexOf("a")&&(r=ZC._a_(r),i=i.replace("a","")),i){case"i":r=ZC._i_(r);break;case"f":r=ZC._f_(r);break;case"b":r=ZC._b_(r);break;case"c":r=ZC.AP.YV(r,l),(r=ZC.AP.G5(r,l))instanceof Array&&("color"===e||"font-color"===e?(l.o["text-alpha"]=r[1],l.UX=r[1],l.D["text-alpha"]=r[1]):"border-color"===e?(l.o["border-alpha"]=r[1],l.NQ=r[1],l.D["b-alpha"]=r[1]):("line-color"===e&&(l.D["l-alpha"]=r[1]),null===ZC._n_(l.o.alpha)&&(l.C5=r[1])),r=r[0])}null!==ZC._n_(n)&&null!==ZC._n_(a)&&(r=ZC._l_(r,n,a)),l[t]=r}},DE:function(){for(var e=this,t=!1,i=0,n=e.E7.length;i<n;i++){var a=!1;try{a=new Function("return ("+e.JE(e.E7[i].rule)+")")()}catch(r){a=!1}a&&(t=!0,e.append(e.E7[i]))}return t},ACG:function(e){for(var t=this,i="",n=0,a=e.length;n<a;n++){var r=!1;try{r=new Function("return ("+t.JE(e[n].rule)+")")()}catch(l){r=!1}r&&(i+="<"+e[n].rule+">")}return""!==i?[i,ZC.XL.md5(i)]:null},JE:function(){return!0},copy:function(e){var t=this;ZC._cp_(e.o,t.o),e.I0&&(t.I0=t.I0||{},ZC._cp_(e.I0,t.I0)),e.J5&&(t.J5=t.J5||{},ZC._cp_(e.J5,t.J5)),ZC._cp_(e.D,t.D),ZC._cp_(e.E7,t.E7)}}),ZC.D0=ZC.ACO.C7({$i:function(e){this.b(e);var t=this;e&&e.H&&(t.H=e.H),t.K="",t.DI=null,t.AM=!0,t.A0="-1",t.AE="-1",t.GQ="",t.HJ="",t.VC=!0,t.D9="",t.LZ="repeat",t.T4="50% 50%",t.WE="",t.KL=1,t.NE="linear",t.N8=90,t.W4=0,t.W2=0,t.B0=0,t.B7="#000",t.G9="",t.EX=0,t.G6=0,t.AT=0,t.BV="#000",t.C5=1,t.NQ=1,t.SW="butt",t.ZT="round",t.M4=!1,t.OE=45,t.JP=2,t.SU=.75,t.RQ="#999",t.P1=0,t.CZ=!0,t.MZ=!1,t.L1=!1,t.A1T=!1,t.OG=null,t.BG=""},getPMap:function(){var e=this.b();return this.addPMap(e,"visible,backgroundColor1,backgroundColor2,gradientColors,gradientStops,backgroundImage,backgroundRepeat,backgroundPosition,backgroundFit,backgroundScale,fillType,fillAngle,fillOffsetX,fillOffsetY,lineWidth,lineColor,lineStyle,lineSegmentSize,lineGapSize,borderWidth,borderColor,borderAlpha,alpha,lineCap,shadow,shadowAngle,shadowDistance,shadowAlpha,shadowColor,shadowBlur,class,border","AM,A0,AE,GQ,HJ,D9,LZ,T4,WE,KL,NE,N8,W4,W2,B0,B7,G9,EX,G6,AT,BV,NQ,C5,SW,M4,OE,JP,SU,RQ,P1,DI,BG"),e},copy:function(e){this.b(e);for(var t=this,i="AM,A0,AE,GQ,HJ,D9,VC,LZ,T4,WE,KL,NE,N8,W4,W2,B0,B7,G9,EX,G6,AT,BV,NQ,C5,SW,M4,OE,JP,SU,RQ,P1,CZ,L1,DI,H,BG".split(","),n=0,a=i.length;n<a;n++)"undefined"!=typeof e[i[n]]&&(t[i[n]]=e[i[n]])},AD0:function(){var e,t,i=this,n=!1;if((i.o["class"]||i.o.cls||i.o.id)&&null!==i.H&&null!==i.H.N){if(e=i.o["class"]||i.o.cls)for(var a=e.split(/(\s+)/),r=0,l=a.length;r<l;r++)(t=i.H.N["."+a[r]])&&(n=!0,ZC._cp_(t,i.o));(e=i.o.id)&&(t=i.H.N["#"+e])&&(n=!0,ZC._cp_(t,i.o))}return null!==i.O8&&(t=i.H.N[i.O8])&&(n=!0,ZC._cp_(t,i.o)),n},KV:function(e){var t,i=this;switch(null===ZC._n_(e)&&(e=i.B0),i.G9){case"dotted":i.EX=ZC.BQ(1,.75*e),i.G6=1.75*e;break;case"dashed":i.EX=4*e,i.G6=3*e;break;case"dashdot":i.EX=4*e,i.G6=2*e;break;default:i.EX=0,i.G6=0}null!==(t=ZC._n_(i.o["line-segment-size"]))&&(i.EX=parseInt(t,10)),null!==(t=ZC._n_(i.o["line-gap-size"]))&&(i.G6=parseInt(t,10))},parse:function(){var e,t,i,n,a,r,l,o,s;this.b();var c=this;if(null!==(e=ZC._n_(c.o.override))&&!c.A1T){var h=-1,C=-1;"undefined"!=typeof c.D.plotidx&&(h=ZC._i_(c.D.plotidx)),"undefined"!=typeof c.D.nodeidx&&(C=ZC._i_(c.D.nodeidx));var u,d,p;for(l=0,o=e.length;l<o;l++){if(u=-1,d=-1,e[l].hook){if(null!==(t=ZC._n_(e[l].hook["node-index"]))){if(d=0,p=[],"object"==typeof t)p=t;else if("string"==typeof t){if(-1!==t.indexOf(","))p=t.split(",");else if(-1!==t.indexOf("-"))for(i=t.split("-"),n=ZC._i_(i[0]);n<=ZC._i_(i[1]);n++)p.push(n)}else p=[t];-1!==ZC.AV(p,C)&&(d=1)}if(null!==(t=e[l].hook["plot-index"])&&void 0!==t){if(u=0,p=[],"object"==typeof t)p=t;else if("string"==typeof t){if(-1!==t.indexOf(","))p=t.split(",");else if(-1!==t.indexOf("-"))for(i=t.split("-"),n=ZC._i_(i[0]);n<ZC._i_(i[1]);n++)p.push(n)}else p=[t];-1!==ZC.AV(p,h)&&(u=1)}}0!==u&&0!==d&&c.append(e[l])}}if(null!==(e=c.OG)&&c.append(e),e=c.o["background-color"]){if(e=ZC.AP.YV(e,this),"rgb("===String(e).substring(0,4))for(a=new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)");r=a.exec(e);)e=e.replace(r[0],ZC.AP.G5(r[0]));if("rgba("===String(e).substring(0,5))for(a=new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\,\\s*([0-9.]+)\\)");r=a.exec(e);){var A=ZC.AP.G5(r[0],c);e=e.replace(r[0],A[0]),c.o.alpha=A[1],c.C5=A[1],c.D["bg-alpha"]=A[1],null===ZC._n_(c.D["b-alpha"])&&(c.D["b-alpha"]=1),null===ZC._n_(c.D["l-alpha"])&&(c.D["l-alpha"]=1)}var g=ZC.GT(String(e)).split(/\s+|;|,/);c.A0=ZC.AP.G5(g[0]),c.AE=1===g.length?c.A0:ZC.AP.G5(g[1])}if(!(null===ZC._n_(c.o["border-width"])&&null===ZC._n_(c.o["border-color"])&&null===ZC._n_(c.o["line-style"])||null===ZC._n_(c.o["border-top"])&&null===ZC._n_(c.o["border-right"])&&null===ZC._n_(c.o["border-bottom"])&&null===ZC._n_(c.o["border-left"])&&null===ZC._n_(c.o.border))){var f=["top","right","bottom","left"],Z={top:[0,"solid","#000"],right:[0,"solid","#000"],bottom:[0,"solid","#000"],left:[0,"solid","#000"]};if(c.I0=c.I0||{},e=c.I0.border)for(s=e.split(/\s/),l=0;l<4;l++)Z[f[l]]=[ZC._i_(s[0]||"0"),ZC.GT(s[1]||"solid"),ZC.AP.G5(s[2]||"#000000")];if(null!==ZC._n_(c.I0["border-width"]))for(l=0;l<4;l++)Z[f[l]][0]=c.I0["border-width"];if(null!==ZC._n_(c.I0["line-style"]))for(l=0;l<4;l++)Z[f[l]][1]=c.I0["line-style"];if(null!==ZC._n_(c.I0["border-color"]))for(l=0;l<4;l++)Z[f[l]][2]=c.I0["border-color"];for(l=0;l<4;l++)(e=c.I0["border-"+f[l]])&&(s=e.split(/\s/),Z[f[l]]=[ZC._i_(s[0]||"0"),ZC.GT(s[1]||"solid"),ZC.AP.G5(s[2]||"#000000")]);if(c.J5=c.J5||{},e=c.J5.border)for(s=e.split(/\s/),l=0;l<4;l++)Z[f[l]]=[ZC._i_(s[0]||"0"),ZC.GT(s[1]||"solid"),ZC.AP.G5(s[2]||"#000000")];if(null!==ZC._n_(c.J5["border-width"]))for(l=0;l<4;l++)Z[f[l]][0]=c.J5["border-width"];if(null!==ZC._n_(c.J5["line-style"]))for(l=0;l<4;l++)Z[f[l]][1]=c.J5["line-style"];if(null!==ZC._n_(c.J5["border-color"]))for(l=0;l<4;l++)Z[f[l]][2]=c.J5["border-color"];for(l=0;l<4;l++)(e=c.J5["border-"+f[l]])&&(s=e.split(/\s/),Z[f[l]]=[ZC._i_(s[0]||"0"),ZC.GT(s[1]||"solid"),ZC.AP.G5(s[2]||"#000000")]);for(l=0;l<4;l++)null===ZC._n_(c.o["border-"+f[l]])&&(c.o["border-"+f[l]]=Z[f[l]].join(" "))}c.assign_a([["visible","AM","b"],["background-color-1","A0","c"],["background-color-2","AE","c"],["gradient-colors","GQ"],["gradient-stops","HJ"],["background-clip","VC","b"],["background-image","D9"],["background-repeat","LZ"],["background-position","T4"],["background-fit","WE"],["background-scale","KL","f"],["fill-type","NE"],["fill-angle","N8","i"],["fill-offset-x","W4","f"],["fill-offset-y","W2","f"],["line-width","B0","i"],["line-color","B7","c"],["line-style","G9",""],["class","DI"],["cls","DI"],["border","BG"]]),"none"===c.NE&&(c.AE=c.A0,c.NE="linear"),""!==c.BG&&(s=c.BG.split(/\s/),c.AT=ZC._i_(s[0]||"0"),c.G9=ZC.GT(s[1]||"solid"),c.BV=ZC.AP.G5(s[2]||"#000000")),c.GQ=ZC.AP.YV(c.GQ,this),c.KV(),c.assign_a([["line-segment-size","EX","i"],["line-gap-size","G6","i"],["border-width","AT","i"],["border-color","BV","c"],["alpha","C5","f",0,1],["shadow","M4","b"],["shadow-angle","OE","i",0,360],["shadow-distance","JP","i"],["shadow-alpha","SU","f",0,1],["shadow-color","RQ","c"],["shadow-blur","P1","i"]]),c.NQ=c.C5,c.assign_a([["border-alpha","NQ","f",0,1]])}}),ZC.CS={contour:function(e,t,i){var n,a,r;if(e&&i&&0!==i.length){if(!t.D["fast-vector-path"])for(n=0,a=i.length;n<a;n++)i[n]&&(i[n][0]=parseFloat(Number(i[n][0]).toFixed(2)),i[n][1]=parseFloat(Number(i[n][1]).toFixed(2)));var l=!1,o=i.length;for(n=0;n<o;n++)null!==ZC._n_(i[n])&&(r=[i[n][0],i[n][1]],null!==ZC._n_(i[n][2])&&r.push(i[n][2],i[n][3]),null!==ZC._n_(i[n][4])&&r.push(i[n][4],i[n][5]),t.MZ&&(r[0]=Math.round(r[0]),r[1]=Math.round(r[1]),4===r.length&&(r[2]=Math.round(r[2]),r[3]=Math.round(r[3]))),t.CZ&&t.B0%2==1&&(r[0]-=.5,r[1]-=.5,4===r.length&&(r[2]-=.5,r[3]-=.5))),0===n?e.moveTo(r[0],r[1]):i[n]?(l&&(e.moveTo(r[0],r[1]),l=!1),2===r.length?e.lineTo(r[0],r[1]):4===r.length?e.quadraticCurveTo(r[0],r[1],r[2],r[3]):6===r.length&&e.arc(r[0],r[1],r[2],ZC.SZ(r[3]),ZC.SZ(r[4]),r[5])):l=!0}},setup:function(e,t){var i=t.H.AC;if(1!==t.C5&&t.L1&&(null===ZC._n_(t.o["border-color"])&&(t.BV=t.A0),null===ZC._n_(t.o["border-width"])))switch(i){case"canvas":t.AT=.2;break;case"svg":t.AT=.1;break;case"vml":t.AT=.2,t.D.A8F=t.C5/10}},paint:function(e,t,i,n,a,r){if(null===ZC._n_(a)&&(a=2),null===ZC._n_(n)&&(n=!1),null===ZC._n_(r)&&(r=!1),e&&i&&0!==i.length&&t){!r&&i.length>2&&null!==i[0]&&null!==i[i.length-1]&&i[0].join(",")===i[i.length-1].join(",")&&(t.SW="round");var l,o,s,c,h,C,u=t.H.AC;if("canvas"!==u||0!==t.B0&&"-1"!==t.B7){if(t.M4&&!n){t.C6=t.C6||t.Z;var d,p=ZC.Q._sh_(i,t);"undefined"!=typeof t.A58?d=t.A58:((d=new ZC.DW(t)).copy(t),d.K=t.K+"-sh",d.M4=!1,d.B0+=d.P1,d.B7=d.RQ),d.C5=t.C5*d.SU,"undefined"==typeof t.ADB&&(t.A58=d),d.CZ=!1,l=t.C6?ZC.Q.E9(t.C6,u):e,ZC.CS.setup(l,d),ZC.CS.paint(l,d,p,!1,1,r)}var A=ZC._i_(t.EX||"0"),g=ZC._i_(t.G6||"0");"solid"===t.G9&&(A=g=0);var f=i.length;"undefined"==typeof t.AA&&(t.AA=0),"canvas"===u&&(e.lineJoin=t.ZT,e.lineCap=t.SW,e.strokeStyle=ZC.AP.A2M(ZC.AP.G5(t.B7),n?t.NQ:t.C5),e.lineWidth=t.B0,e.beginPath());var Z=!1;if(-1!==ZC.AV(["svg","vml"],u))o=r?[]:ZC.Q.A2O(i,u,t,n);else{var _=!1;"dashdot"!==t.G9&&(_=e.setLineDash)&&e.setLineDash(0===A||0===g?[]:[A,g]);var b=0,m=[ZC.MAX,ZC.MAX,-ZC.MAX,-ZC.MAX];for(C=0;C<f;C++)if(null!==i[C]){if(null!==(s=ZC.objmove?i[C]:ZC.Q._txp_(i[C],u,t,n))&&!isNaN(s[0])&&!isNaN(s[1])&&isFinite(s[0])&&isFinite(s[1]))if(f<=6&&n&&(m[0]=ZC.CY(m[0],s[0]),m[1]=ZC.CY(m[1],s[1]),m[2]=ZC.BQ(m[2],s[0]),m[3]=ZC.BQ(m[3],s[1])),0===C)2===s.length?e.moveTo(s[0],s[1]):6===s.length&&e.arc(s[0],s[1],s[2],ZC.SZ(s[3]),ZC.SZ(s[4]),s[5]);else if(Z&&(e.moveTo(s[0],s[1]),Z=!1),_||0===A||0===g||4===s.length||6===s.length||7===s.length)2===s.length?e.lineTo(s[0],s[1]):4===s.length?e.quadraticCurveTo(s[0],s[1],s[2],s[3]):6===s.length?e.arc(s[0],s[1],s[2],ZC.SZ(s[3]),ZC.SZ(s[4]),s[5]):7===s.length&&e.bezierCurveTo(s[0],s[1],s[2],s[3],s[4],s[5]);else if(null!==i[C-1]){var v=ZC.Q._txp_(i[C-1],u,t,n),D=v[4===v.length?2:0],E=v[4===v.length?3:1],w=s[0],B=s[1],K=A+g,F=w-D,x=B-E,y=Math.sqrt(F*F+x*x)+b;if(y>A){b=0;var I;I="dashdot"===t.G9?Math.floor(ZC._a_(y/((K+t.B0+g)/2))):Math.floor(ZC._a_(y/K));var z=Math.atan2(x,F),H=Math.cos(z),M=Math.sin(z),S=D,k=E,X=A;for(c=0;c<I;c++)"dashdot"===t.G9&&(K=c%2?t.B0+g:A+g,X=c%2?t.B0:A),F=H*K,x=M*K,e.moveTo(S,k),e.lineTo(S+H*X,k+M*X),S+=F,k+=x;e.moveTo(S,k),(y=Math.sqrt((w-S)*(w-S)+(B-k)*(B-k)))>A?e.lineTo(S+H*A,k+M*A):y>0&&e.lineTo(S+H*y,k+M*y),e.moveTo(w,B)}else b=y}}else Z=!0;t.H&&f<=6&&n&&(t.H.D[t.K+"-bounds"]=m)}switch(u){case"canvas":e.globalCompositeOperation=t.A0M,e.stroke();break;case"svg":case"vml":if(null===ZC._n_(t.o["top-state"])&&t.H.O3&&(!n||t.D.areanode)){if(h=t.D.areanode?t.A0+"-"+t.AE+"-"+t.D9+"-"+t.B0+"-"+t.G9+"-"+t.C5+"-"+t.BJ+"-"+t.BH:t.B7+"-"+t.B0+"-"+t.G9+"-"+t.C5+"-"+t.BJ+"-"+t.BH,null===ZC._n_(t.H.NX[a])){t.H.NX[a]={uid:h,ctx:e,path:o,style:t,filled:n};break}if(t.H.NX[a].uid===h&&t.H.NX[a].path.length<2e3){c=t.H.NX[a].path,o&&o[0]&&(c.length>0&&c[c.length-1].replace(/[A-Z]+/,"")===o[0].replace(/[A-Z]+/,"")&&(o[0]=""),t.H.NX[a].path=t.H.NX[a].path.concat(o));break}"svg"===u?ZC.CS.W6(t.H.NX[a].ctx,t.H.NX[a].style,t.H.NX[a].path.join(" "),t.H.NX[a].filled):ZC.CS.W5(t.H.NX[a].ctx,t.H.NX[a].style,t.H.NX[a].path.join(" "),t.H.NX[a].filled),t.H.NX[a]={uid:h,ctx:e,path:o,style:t,filled:n};break}"svg"===u?ZC.CS.W6(e,t,o.join(" "),n,r):ZC.CS.W5(e,t,o.join(" "),n)}if(null!==ZC._n_(t.o["top-state"])&&!t.Y3&&!t.D["skip-top"]&&!t.VV){var T=new ZC.HS(t.A);T.copy(t),T.VV=!0,T.M4=!1,T.Z=t.Z,T.append(t.o["top-state"]),T.K=t.K+"-top",T.parse(),"svg"===u?ZC.CS.W6(e,T,o.join(" "),n,r):"vml"===u?ZC.CS.W5(e,T,o.join(" "),n):ZC.CS.paint(e,T,i,n,a,r)}}}},smooth:function(e,t,i){var n,a,r,l;ZC._n_(t)&&(t=!1),i=i||"h";var o=[],s=[];for(n=0,a=e.length;n<a;n++)e[n]&&("h"===i?(s.push(e[n][0]),o.push(e[n][1])):(s.push(e[n][1]),o.push(e[n][0])),0===n&&(s.push(s[0]),o.push(o[0])));for(s.push(s[s.length-1]),o.push(o[o.length-1]),e=[],r=1,l=o.length;r<l-1;r++){var c=[o[r-1],o[r],o[r+1],o[r+2]],h=ZC._a_(s[r+1]-s[r]),C=1/(h/c.length),u=ZC.AO.XZ(t,c,h,C);for(n=0,a=u.length;n<a;n++)null!==ZC._n_(u[n][0])&&null!==ZC._n_(u[n][1])?"h"===i?e.push([s[r]+u[n][0]*h,u[n][1]]):e.push([u[n][1],s[r]+u[n][0]*h]):e.push(null)}return e},_append_:function(e,t,i){t.H&&t.H.FY?(null===ZC._n_(t.H.FY[e.id])&&(t.H.FY[e.id]=document.createDocumentFragment()),t.H.FY[e.id].appendChild(i)):e.appendChild(i)},W6:function(e,t,i,n,a){if(""!==i||a){var r,l,o,s,c,h,C;ZC.cache.data["svg-rect"]||(ZC.cache.data["svg-rect"]=ZC.Q.F4("rect","http://www.w3.org/2000/svg")),r=a?ZC.cache.data["svg-rect"].cloneNode(!0):ZC.Q.F4("path","http://www.w3.org/2000/svg");var u={};if(t.DI&&""!==t.DI&&(u["class"]=t.DI),a||(u.d=i),a){t.I<0&&(t.iX-=t.I,t.I=-t.I),t.F<0&&(t.iY+=t.F,t.F=-t.F);var d=0,p=0,A=1;t.CZ&&(A=0,d=p=t.B0/2,0===t.iX&&(d=0),0===t.iY&&(p=0)),0===A||t.I<=3||t.F<=3?(l=Math.floor(t.iX)+d,o=Math.floor(t.iY)+p,s=Math.ceil(t.I)-2*d,c=Math.ceil(t.F)-2*d,h=t.F5,C=t.F5):(l=parseFloat(t.iX.toFixed(A))+d,o=parseFloat(t.iY.toFixed(A))+p,s=parseFloat(t.I.toFixed(A))-2*d,c=parseFloat(t.F.toFixed(A))-2*p,h=t.F5,C=t.F5),u.x=l,u.y=o,u.width=ZC.BQ(0,s),u.height=ZC.BQ(0,c),u.rx=h,u.ry=C,t.H&&(t.H.D[t.K+"-bounds"]=[u.x,u.y,u.x+u.width,u.y+u.height])}var g="";"undefined"==typeof t.K||""===t.K?"undefined"!=typeof t.H&&(g=t.H.GRAPHID+"-path-"+ZC.SEQ,ZC.SEQ++):g=t.K+"-path";var f="";if("undefined"!=typeof t.BJ&&"undefined"!=typeof t.BH&&(0===t.BJ&&0===t.BH||(f+="translate("+t.BJ+" "+t.BH+")")),"undefined"!=typeof t.AA&&0!==t.AA){var Z=t.AA;"undefined"!=typeof t.D.cx&&(Z+=","+(ZC._x_(t.D.cx)-.5)),"undefined"!=typeof t.D.cy&&(Z+=","+(ZC._x_(t.D.cy)-.5)),f+=" rotate("+Z+")"}n&&-1!==t.D.fill?(u.fill=t.D.fill,u["fill-opacity"]=t.C5):u.fill="none",u["stroke-linecap"]=t.SW,u["stroke-linejoin"]=t.ZT,t.B0>0&&(u.stroke=t.B7,u["stroke-width"]=t.B0,u["stroke-opacity"]=n?t.NQ:t.C5,"solid"===t.G9||0===t.EX&&0===t.G6||("dashdot"===t.G9?u["stroke-dasharray"]=[t.EX,t.G6,t.B0,t.G6].join(" "):u["stroke-dasharray"]=t.EX+","+t.G6)),r.id=g,""!==f&&(u.transform=f),t.o["fast-line"]&&t.B0>0?(r.setAttribute("stroke",u.stroke),r.setAttribute("stroke-width",u["stroke-width"]),r.setAttribute("stroke-opacity",u["stroke-opacity"]),r.setAttribute("d",i)):ZC.Q.G2(r,u),ZC.CS._append_(e,t,r);var _;if((!t.D.border||"all"===t.D.border)&&"undefined"!=typeof t.D.imgfill)if("string"==typeof t.D.imgfill)ZC.AK(g+"-imgfill")||(_=a?ZC.Q.F4("rect","http://www.w3.org/2000/svg"):ZC.Q.F4("path","http://www.w3.org/2000/svg"),ZC.Q.G2(_,{id:g+"-imgfill",transform:f,fill:t.D.imgfill,"fill-opacity":t.C5}),a?ZC.Q.G2(_,{x:l,y:o,width:ZC.BQ(0,s),height:ZC.BQ(0,c),rx:h,ry:C}):ZC.Q.G2(_,{d:i}),ZC.CS._append_(e,t,_));else if(!ZC.AK(g+"-imgfill")){var b=t.D.imgfill,m=ZC.Q.F4("image","http://www.w3.org/2000/svg");m.setAttributeNS?"zc."===t.D9.substring(0,3)?m.setAttributeNS("http://www.w3.org/1999/xlink","href",ZC.IMAGES[t.D9]):m.setAttributeNS("http://www.w3.org/1999/xlink","href",t.D9):"zc."===t.D9.substring(0,3)?m.setAttribute("src",ZC.IMAGES[t.D9]):m.setAttribute("src",t.D9),null!==ZC._n_(t.D["clip-path"])&&ZC.Q.G2(m,{"clip-path":"url(#"+t.D["clip-path"]+")"}),ZC.Q.G2(m,{id:g+"-imgfill",x:b[1],y:b[2],"fill-opacity":t.C5,width:t.D["bg-image-width"],height:t.D["bg-image-height"],preserveAspectRatio:"none"}),ZC.CS._append_(e,t,m)}}},W5:function(e,t,i,n){var a;n&&(i+=" x e");var r,l,o,s,c,h="";"undefined"==typeof t.K||""===t.K?"undefined"!=typeof t.H&&(h=t.H.GRAPHID+"-path-"+ZC.SEQ,ZC.SEQ++):h=t.K+"-path";var C=ZC.Q.F4("zcv:shape");C.style.position="absolute",C.style.rotation=t.AA,C.id=h;var u=ZC.Q.F4("zcv:path");if(u.v=i,u.setAttribute("VMLv",i),C.appendChild(u),0===t.B0)C.stroked=!1;else{var d=ZC.Q.F4("zcv:stroke");if(o=t.C5,"undefined"!=typeof t.D.A8F&&(o=t.D.A8F),"undefined"!=typeof t.D.stroke)r=t.D.stroke.weight,l=t.D.stroke.color,o=t.D.stroke.opacity,s=t.D.stroke.dashstyle;else{switch(s="solid",t.G9){case"solid":s="solid";break;case"dotted":s="dot";break;case"dashed":s="dash";break;default:s=t.G9}"solid"!==s&&"0 0"!=(a=ZC.CY(6,t.EX*t.B0)+" "+ZC.CY(8,t.G6*t.B0))&&(s=a),r=t.B0,l=t.B7}ZC.Q.G2(d,{weight:r+"px",color:l,opacity:o,miterlimit:10,endcap:"flat",joinstyle:"round",dashstyle:s}),C.appendChild(d)}n&&"undefined"!=typeof t.D.fill&&-1!==t.D.fill?(C.filled=!0,C.appendChild(t.D.fill)):C.filled=!1,ZC.Q.G2(C,{coordorigin:"0 0",coordsize:t.AA%360==0?"100 100":t.H.I+" "+t.H.F});var p=0,A=0;if(t.AA%360!=0&&"undefined"!=typeof t.D.cx&&"undefined"!=typeof t.D.cy){var g=t.H.I/2-t.D.cx,f=t.H.F/2-t.D.cy,Z=0===f?0:ZC.TO(Math.atan(g/f));t.D.cy>t.H.F/2&&(Z+=180);var _=Math.sqrt(g*g+f*f);p=g-_*ZC.EO(Z-t.AA),A=f-_*ZC.EF(Z-t.AA)}var b=0-p;null!==ZC._n_(t.BJ)&&(b+=t.BJ);var m=0-A;if(null!==ZC._n_(t.BH)&&(m+=t.BH),C.style.left=b+"px",C.style.top=m+"px",e.appendChild(C),t.AA%360==0?(C.style.width="10px",C.style.height="10px"):(C.style.width=t.H.I+"px",C.style.height=t.H.F+"px"),("all"===t.D.border||"undefined"!=typeof t.D.imgfill)&&"undefined"!=typeof t.D.imgfill){var v=t.D.imgfill;1===v.length?((C=ZC.Q.F4("zcv:shape")).style.position="absolute",C.style.rotation=t.AA,(u=ZC.Q.F4("zcv:path")).v=i,C.appendChild(u),C.appendChild(v[0]),C.stroked=!1,ZC.Q.G2(C,{id:h+"-imgfill",filled:!0,coordorigin:"0 0",coordsize:t.AA%360==0?"100 100":t.H.I+" "+t.H.F}),C.style.left=b+"px",C.style.top=m+"px",e.appendChild(C),t.AA%360==0?(C.style.width="10px",C.style.height="10px"):(C.style.width=t.H.I+"px",C.style.height=t.H.F+"px")):3===v.length&&((c=ZC.Q.F4("img")).id=h+"-img","zc."===t.D9.substring(0,3)?c.src=ZC.IMAGES[t.D9]:c.src=t.D9,c.style.position="absolute",c.style.left=v[1]+"px",c.style.top=v[2]+"px",c.style.width=t.D["bg-image-width"]+"px",c.style.height=t.D["bg-image-height"]+"px",e.appendChild(c))}}},ZC.DW=ZC.D0.C7({$i:function(e){this.b(e);var t=this;t.A=e,t.Z=null,t.C6=null,t.H2="",t.iX=-1,t.iY=-1,t.DQ="poly",t.E=[],t.D1=[0,0,0,0],t.AA=0,t.AI=0,t.KT=0,t.BJ=0,t.BH=0,t.A9O=0,t.DR=0,t.B3=0,t.BI=360,t.CN=0,t.TL=!1,t.ADA=!1,t.A50=0,t.AAK="",t.O3=!1,t.A9P=1,t.JN=1,t.E8=null,t.F9=null,t.IR="auto",t.K5=!1,t.A0M="source-over",t.QJ=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"objectId,x,y,points,bounds,pieAngleStart,pieAngleEnd,pieSlice,url,target,offsetX,offsetY,offsetR,size,size2,angle,shape,flat,cursor","H2,iX,iY,E,D1,B3,BI,CN,E8,F9,BJ,BH,DR,AI,KT,AA,DQ,K5,IR"),e},build:function(){},copy:function(e){this.b(e);var t,i,n=this,a="BJ,BH,DR,AI,KT,AA,DQ,K5,IR".split(",");for(t=0,i=a.length;t<i;t++)"undefined"!=typeof e[a[t]]&&(n[a[t]]=e[a[t]]);if(e.E&&e.E.length>0)for(n.E=[],t=0,i=e.E.length;t<i;t++)n.E.push(e.E[t])},ll_:function(e,t){var i=this;-1!==(""+e).indexOf("lat")&&(t="y"),-1!==(""+e).indexOf("lon")&&(t="x"),e=ZC._f_((""+e).replace("lat","").replace("lon",""));var n=zingchart.maps.maps[i.A50];return n&&(e=zingchart.maps.lonlat2xy(n._INFO_.x,n._INFO_.y,n._INFO_.width,n._INFO_.height,"x"===t?[e,0]:[0,e],n._INFO_.bbox,{map:i.A50,item:i.AAK,zoom:n._INFO_.zoom,offsetX:n._INFO_.offsetX,offsetY:n._INFO_.offsetY},!0)),e=ZC._i_("x"===t?e[0]:e[1])},kv_:function(e,t){var i,n=this;-1!==(""+e).indexOf("val")&&(t="y"),-1!==(""+e).indexOf("key")&&(t="x"),e=ZC._f_((""+e).replace("key","").replace("val",""));var a=n.H||zingchart.HU[0];if(a){var r=n.A||a.AH[0];r&&("x"===t?null!==(i=r.BT("k")[0])&&(e=ZC._i_(i.B2(e))):null!==(i=r.BT("v")[0])&&(e=ZC._i_(i.B2(e))))}return ZC._i_(e)},xy_:function(e,t,i){var n=this;t=t||"x";var a=""+e;if(-1!==a.indexOf("lat")||-1!==a.indexOf("lon"))return n.ll_(e,t);if(-1!==a.indexOf("val")||-1!==a.indexOf("key"))return n.kv_(e,t);if(""+ZC._f_(e)!==a)return-1!==(e+="").indexOf("%")?n.xy_(parseFloat(e.replace("%",""))/100,t,!0):-1!==e.indexOf("px")?n.xy_(parseFloat(e.replace("px","")),t):n.xy_(parseFloat(e),t);var r="undefined"!=typeof n.D["p-x"]?n.D["p-x"]:n.A.iX,l="undefined"!=typeof n.D["p-y"]?n.D["p-y"]:n.A.iY,o="undefined"!=typeof n.D["p-width"]?n.D["p-width"]:n.A.I,s="undefined"!=typeof n.D["p-height"]?n.D["p-height"]:n.A.F;return(e>=1||e<0||zingchart.DEV.IGNORESUBUNIT)&&!i?"x"===t?r+parseFloat(e):l+parseFloat(e):e>=0&&e<1||i?"x"===t?(o=o||1,Math.round(r+o*e)):(s=s||1,Math.round(l+s*e)):void 0},locate:function(e){var t,i=this;if(i.TL)return-1!==(""+i.o.x).indexOf("lon")?i.iX=i.ll_(i.o.x,"x"):i.Z5("x","iX"),-1!==(""+i.o.y).indexOf("lat")?i.iY=i.ll_(i.o.y,"y"):i.Z5("y","iY"),void i.A0S();1===e?(null!==(t=ZC._n_(i.o.x))&&(i.iX=i.xy_(t,"x")),null!==(t=ZC._n_(i.o.y))&&(i.iY=i.xy_(t,"y")),-1===i.iX&&(i.iX=i.A.iX),-1===i.iY&&(i.iY=i.A.iY)):2===e&&(i.A0S(),i.I=i.D1[2]-i.D1[0],i.F=i.D1[3]-i.D1[1])},A0S:function(){var e,t=this,i=ZC.MAX,n=ZC.MAX,a=-ZC.MAX,r=-ZC.MAX;switch(t.DQ){case"custom":i=0,n=0,a=0,r=0;break;case"circle":case"arc":case"pie":i=t.iX-t.AI,n=t.iY-t.AI,a=t.iX+t.AI,r=t.iY+t.AI;break;default:for(var l=0,o=t.E.length;l<o;l++)null!==(e=t.E[l])&&(i=Math.min(i,e[0]),n=Math.min(n,e[1]),a=Math.max(a,e[0]),r=Math.max(r,e[1]))}t.D1=[i,n,a,r]},FC:function(){var e,t=this;if("pie"===t.DQ){var i=1,n=[],a=t.B3+t.AA,r=t.BI+t.AA,l=t.AI+Math.floor(t.AT/2),o=t.CN-Math.floor(t.AT/2);for(l>50&&(i=2),l>100&&(i=4),0===o?a%360!=r%360&&n.push([t.iX,t.iY]):n.push(ZC.AO.BK(t.iX,t.iY,o,a),ZC.AO.BK(t.iX,t.iY,(l+o)/2,a-.25*t.AT),ZC.AO.BK(t.iX,t.iY,l,a)),e=a;e<=r;e+=i)n.push(ZC.AO.BK(t.iX,t.iY,l,e));if(n.push(ZC.AO.BK(t.iX,t.iY,l,r)),n.push(ZC.AO.BK(t.iX,t.iY,(l+o)/2,r+.25*t.AT)),0===o)a%360!=r%360&&n.push([t.iX,t.iY]);else{for(n.push(ZC.AO.BK(t.iX,t.iY,o,r)),e=r;e>=a;e-=i)n.push(ZC.AO.BK(t.iX,t.iY,o,e));n.push(ZC.AO.BK(t.iX,t.iY,o,a))}return n.push([n[0][0],n[0][1]]),ZC.AO.PM(n,Math.min(5,l/5),[t.BJ,t.BH])}if(0===t.AA||"rectangle"!==t.DQ&&"rect"!==t.DQ)return ZC.AO.PM(t.E,Math.min(5,t.AI/5),[t.BJ,t.BH]);var s,c,h,C,u,d,p,A,g=[];for(h=ZC._i_((t.D1[0]+t.D1[2])/2),C=ZC._i_((t.D1[1]+t.D1[3])/2),s=0,c=t.E.length;s<c;s++)null!==t.E[s]&&(u=t.E[s][0]-h,d=t.E[s][1]-C,p=u*ZC.EF(t.AA)-d*ZC.EO(t.AA),A=u*ZC.EO(t.AA)+d*ZC.EF(t.AA),g[s]=[p+h,A+C]);return ZC.AO.PM(g,Math.min(5,t.AI/5),[t.BJ,t.BH])},A4V:function(){var e,t,i,n,a,r,l,o,s,c=this,h=ZC.ie67?ZC.MAPTX:0;switch(c.DQ){case"line":if(i=[].concat(c.E),0!==c.AA)for(n=(c.D1[0]+c.D1[2])/2,a=(c.D1[1]+c.D1[3])/2,e=0,t=i.length;e<t;e++)null!==i[e]&&(r=i[e][0]-n,l=i[e][1]-a,o=r*ZC.EF(c.AA)-l*ZC.EO(c.AA),s=r*ZC.EO(c.AA)+l*ZC.EF(c.AA),i[e]=[o+n,s+a]);var C=["poly"];for(e=0,t=i.length;e<t-1;e++)null!==i[e]&&null!==i[e+1]&&C.push(ZC.AO.PM(ZC.AO.YW([i[e],i[e+1]]),4,[c.BJ,c.BH]));return C;case"cross":case"plus":return["circle",ZC._i_(c.iX+h+c.BJ)+","+ZC._i_(c.iY+h+c.BH)+","+ZC._i_(c.AI)];case"circle":case"arc":return["circle",ZC._i_(c.iX+h+c.BJ)+","+ZC._i_(c.iY+h+c.BH)+","+ZC._i_(c.AI+2)];case"pie":return["poly",c.FC()];default:var u,d=["poly"];for(i=[],e=0,t=c.E.length;e<t;e++)if(null!==c.E[e])if(6===c.E[e].length)for(var p=c.E[e][3];p<c.E[e][4];p+=1)i.push(ZC.AO.BK(c.E[e][0],c.E[e][1],c.E[e][2],p));else if(4===c.E[e].length&&i[e-1]){var A={x:i[i.length-1][0],y:i[i.length-1][1]},g={x:c.E[e][2],y:c.E[e][3]},f={x:c.E[e][0],y:c.E[e][1]};for(u=0;u<=1;u+=.1)i.push([(1-u)*(1-u)*A.x+2*u*(1-u)*f.x+u*u*g.x,(1-u)*(1-u)*A.y+2*u*(1-u)*f.y+u*u*g.y])}else if(7===c.E[e].length&&i[e-1]){var Z={x:i[i.length-1][0],y:i[i.length-1][1]},_={x:c.E[e][0],y:c.E[e][1]},b={x:c.E[e][2],y:c.E[e][3]},m={x:c.E[e][4],y:c.E[e][5]};for(u=0;u<=1;u+=.1){var v=(1-u)*(1-u)*(1-u),D=3*u*(1-u)*(1-u),E=3*u*u*(1-u),w=u*u*u;i.push([v*Z.x+D*_.x+E*b.x+w*m.x,v*Z.y+D*_.y+E*b.y+w*m.y])}}else i.push(c.E[e]);else i.length>-1&&d.push(ZC.AO.PM(i,Math.min(5,c.AI/5),[c.BJ,c.BH])),i=[];if(0!==c.AA)for(n=ZC._i_((c.D1[0]+c.D1[2])/2),a=ZC._i_((c.D1[1]+c.D1[3])/2),e=0,t=i.length;e<t;e++)null!==i[e]&&(r=i[e][0]-n,l=i[e][1]-a,o=r*ZC.EF(c.AA)-l*ZC.EO(c.AA),s=r*ZC.EO(c.AA)+l*ZC.EF(c.AA),i[e]=[o+n,s+a]);return i.length>-1&&d.push(ZC.AO.PM(i,Math.min(5,c.AI/5),[c.BJ,c.BH])),d}},parse:function(e){var t,i,n,a,r,l,o;null===ZC._n_(e)&&(e=!1),this.o.tween||e||this.b();var s=this;if(!s.o.tween&&!e){s.assign_a([["map","A50"]]),"string"==typeof s.o.item&&s.assign_a([["item","AAK"]]),0!==s.A50&&(null===ZC._n_(s.o["map-item"])||s.o["map-item"])&&(s.o["map-item"]=!0,s.o["map-skip-z-sort"]=!0);var c=["offset-x","offset-y"];for(i=0;i<2;i++){var h=c[i],C="offset-x"===h?"lon":"lat";if(null!==(t=s.o[h])&&void 0!==t&&-1!==(t=""+t).indexOf(C)){t=ZC._f_(t.replace(C,""));var u=zingchart.maps.maps[s.A50];u&&(t=zingchart.maps.translate(h.replace("offset-"),t,s.A.I,s.A.F,u._INFO_.bbox),s.o[h]=t)}}for(s.assign_a([["url","E8"],["target","F9"],["cursor","IR"],["id","H2"],["angle","AA","i"],["static","K5","b"],["flat","K5","b"],["angle-start","B3","f"],["angle-end","BI","f"],["slice","CN","i"],["size","AI","f"],["size-2","KT","f"],["fast-vector-path","QJ","b"],["type","DQ"],["points","E"],["offset-x","BJ"],["offset-y","BH"],["offset-z","A9O","i"],["offset-r","DR","i"],["z-sort","A9P","i"],["z-index","JN","f"],["composite","A0M"]]),s.BJ=ZC.IH(s.BJ,!0),s.BH=ZC.IH(s.BH,!0),s.BJ>-1&&s.BJ<1&&"undefined"!=typeof s.D["p-width"]&&(s.BJ*=s.D["p-width"]),s.BH>-1&&s.BH<1&&"undefined"!=typeof s.D["p-height"]&&(s.BH*=s.D["p-height"]),s.AI=ZC.BQ(1,s.AI),s.KT=ZC.BQ(1,s.KT),null!==s.o["z-sort"]&&"undefined"!=typeof s.o["z-sort"]||(s.A9P=s.JN),"rectangle"!==s.DQ&&"rect"!==s.DQ||s.assign_a([["width","AI","f"],["height","KT","f"]]),s.A4L?(s.E=JSON.parse(JSON.stringify(s.F8)),s.A4L=!1):s.F8=JSON.parse(JSON.stringify(s.E)),i=0,n=s.E.length;i<n;i++)if(null!==s.E[i])for(var d=0;d<s.E[i].length;d++)-1===(""+s.E[i][d]).indexOf("lat")&&-1===(""+s.E[i][d]).indexOf("lon")||(s.A4L=!0,s.E[i][d]=s.ll_(s.E[i][d],d%2==0?"x":"y")),-1===(""+s.E[i][d]).indexOf("key")&&-1===(""+s.E[i][d]).indexOf("val")||(s.A4L=!0,s.E[i][d]=s.kv_(s.E[i][d],d%2==0?"x":"y"))}if(s.o.tween=null,s.AA=s.AA%360,s.locate(1),"bar"!==s.DQ){var p=s.AI;switch(s.DQ){case"custom":break;case"triangle":p=s.AI;var A=.1*s.AI;s.E=[[s.iX-p,s.iY+p-A],[s.iX,s.iY-p-A],[s.iX+p,s.iY+p-A],[s.iX-p,s.iY+p-A]];break;case"square":p=ZC._i_(.9*s.AI),s.E=[[s.iX-p,s.iY-p],[s.iX-p,s.iY+p],[s.iX+p,s.iY+p],[s.iX+p,s.iY-p],[s.iX-p,s.iY-p]];break;case"diamond":p=ZC._i_(1.2*s.AI),s.E=[[s.iX-p,s.iY],[s.iX,s.iY+p],[s.iX+p,s.iY],[s.iX,s.iY-p],[s.iX-p,s.iY]];break;case"trapezoid":s.E=[[s.iX-p/2,s.iY+s.KT],[s.iX+p/2,s.iY+s.KT],[s.iX+p,s.iY-s.KT],[s.iX-p,s.iY-s.KT],[s.iX-p/2,s.iY+s.KT]];break;case"rectangle":case"rect":s.E=[[s.iX-p/2,s.iY-s.KT/2],[s.iX+p/2,s.iY-s.KT/2],[s.iX+p/2,s.iY+s.KT/2],[s.iX-p/2,s.iY+s.KT/2],[s.iX-p/2,s.iY-s.KT/2]];break;case"parallelogram":s.E=[[s.iX-p/2,s.iY-s.KT/2],[s.iX+3*p/2,s.iY-s.KT/2],[s.iX+p,s.iY+s.KT/2],[s.iX-p,s.iY+s.KT/2],[s.iX-p/2,s.iY-s.KT/2]];break;case"plus":p=s.AI,s.E=[[s.iX,s.iY-p],[s.iX,s.iY+p],null,[s.iX-p,s.iY],[s.iX+p,s.iY]];break;case"cross":p=s.AI,s.E=[[s.iX-p,s.iY-p],[s.iX+p,s.iY+p],null,[s.iX-p,s.iY+p],[s.iX+p,s.iY-p]];break;case"ic_line":p=s.AI/4,s.E=[[s.iX-2*p,s.iY+p],[s.iX-p,s.iY],[s.iX,s.iY+p],[s.iX+p,s.iY-p],[s.iX+2*p,s.iY]];break;case"ic_area":p=s.AI/4,s.E=[[s.iX-2*p,s.iY+2*p],[s.iX-2*p,s.iY+p],[s.iX-p,s.iY],[s.iX,s.iY+p],[s.iX+p,s.iY-p],[s.iX+2*p,s.iY],[s.iX+2*p,s.iY+2*p],[s.iX-2*p,s.iY+2*p]];break;case"ic_bars":s.CZ=!1,p=s.AI/4,s.E=[[s.iX-2*p,s.iY+2*p],[s.iX-2*p,s.iY-p],[s.iX-p,s.iY-p],[s.iX-p,s.iY+2*p],[s.iX-2*p,s.iY+2*p],[s.iX-2*p,s.iY+2*p-p],null,[s.iX-p/2,s.iY+2*p],[s.iX-p/2,s.iY],[s.iX+p/2,s.iY],[s.iX+p/2,s.iY+2*p],[s.iX-p/2,s.iY+2*p],[s.iX-p/2,s.iY+2*p-p],null,[s.iX+2*p,s.iY+2*p],[s.iX+2*p,s.iY-2*p],[s.iX+p,s.iY-2*p],[s.iX+p,s.iY+2*p],[s.iX+2*p,s.iY+2*p],[s.iX+2*p,s.iY+2*p-p]];break;case"arrow":p=2*s.AI;var g=s.AA;s.AA=0;var f=ZC.AO.BK(s.iX,s.iY,p,g-35),Z=ZC.AO.BK(s.iX,s.iY,p,g+35);s.E=[[s.iX,s.iY],f,null,[s.iX,s.iY],Z];break;case"star3":case"star4":case"star5":case"star6":case"star7":case"star8":case"star9":for(s.E=[],p=2*s.AI,r=360/(a=ZC._i_(s.DQ.replace("star",""))),l=a%2==0?0:-90,o=p/(a>4?2:7-a),i=0+l;i<360+l;i+=r)s.E.push(ZC.AO.BK(s.iX,s.iY,.75*p,i),ZC.AO.BK(s.iX,s.iY,.75*o,i+r/2));s.E.push([s.E[0][0],s.E[0][1]]);break;case"rpoly3":case"rpoly4":case"rpoly5":case"rpoly6":case"rpoly7":case"rpoly8":case"rpoly9":for(s.E=[],p=s.AI,r=360/(a=ZC._i_(s.DQ.replace("rpoly",""))),l=a%2==0?0:-90,null!==ZC._n_(s.o["angle-offset"])&&(l=ZC._i_(s.o["angle-offset"])),i=0+l;i<360+l;i+=r)s.E.push(ZC.AO.BK(s.iX,s.iY,p,i));s.E.push([s.E[0][0],s.E[0][1]]);break;case"gear3":case"gear4":case"gear5":case"gear6":case"gear7":case"gear8":case"gear9":for(s.E=[],p=2*s.AI,r=360/(2*(a=ZC._i_(s.DQ.replace("gear","")))),o=.75*p,i=0+(l=a%2==0?0:-90);i<360+l;i+=2*r){var _=i+r/2;s.E.push(ZC.AO.BK(s.iX,s.iY,.75*p,_),ZC.AO.BK(s.iX,s.iY,.75*p,_+r),ZC.AO.BK(s.iX,s.iY,.75*o,_+r+0*r),ZC.AO.BK(s.iX,s.iY,.75*o,_+2*r-0*r))}s.E.push([s.E[0][0],s.E[0][1]]);break;case"hamburger":p*=2;var b=s.iX,m=s.iY-10;s.E=s.E.concat([[b-p/2,m-s.KT/2],[b+p/2,m-s.KT/2],[b+p/2,m+s.KT/2],[b-p/2,m+s.KT/2],[b-p/2,m-s.KT/2],null]),m+=5,s.E=s.E.concat([[b-p/2,m-s.KT/2],[b+p/2,m-s.KT/2],[b+p/2,m+s.KT/2],[b-p/2,m+s.KT/2],[b-p/2,m-s.KT/2],null]),m+=5,s.E=s.E.concat([[b-p/2,m-s.KT/2],[b+p/2,m-s.KT/2],[b+p/2,m+s.KT/2],[b-p/2,m+s.KT/2],[b-p/2,m-s.KT/2],null]);break;case"ellipse":for(s.CZ=!1,s.E=[],i=0;i<=360;i+=5)s.E.push([s.iX+s.AI*ZC.EF(i),s.iY+s.KT*ZC.EO(i)]);s.E.push([s.E[0][0],s.E[0][1]]);break;case"arc":s.CZ=!1,s.E=[ZC.AO.BK(s.iX,s.iY,s.AI,s.B3),[s.iX,s.iY,s.AI,s.B3,s.BI,0]];break;case"pie":for(var v=(s.o["pie-transform"]||"").split(/=|,/);s.B3<0||s.BI<0;)s.B3+=360,s.BI+=360;s.CZ=!1;var D=!1;-1!==ZC.AV(["svg","vml"],s.H.AC)&&s.B3%360==s.BI%360&&(s.B3+=.05,s.BI-=.05,D=!0);var E,w,B,K,F,x=s.iX,y=s.iY,I=ZC._x_(s.B3,2),z=ZC._x_(s.BI,2),H=ZC._x_((I+z)/2,2),M=p,S=s.CN,k=0===S&&I%360!=z%360&&!D;switch(s.E=[],"circle"!==v[0]&&(0===S?I%360==z%360||D||s.E.push([x,y]):s.E.push(ZC.AO.BK(x,y,S,I))),v[0]){case"flat":case"fold":s.E.push(ZC.AO.BK(x,y,M,I),ZC.AO.BK(x,y,M-("fold"===v[0]?ZC._i_(v[1]):0),z)),k||s.E.push(ZC.AO.BK(x,y,S,z));break;case"callout":s.E.push(ZC.AO.BK(x,y,M,I),[x,y,M,I,z,0]),k||(E=1.5*ZC._i_(v[1])*360/(2*Math.PI*M),s.E.push(ZC.AO.BK(x,y,M,z),ZC.AO.BK(x,y,S,z),[x,y,S,z,H+E,1],ZC.AO.BK(x,y,S-ZC._i_(v[1]),H),ZC.AO.BK(x,y,S,H-E),[x,y,S,H-E,I,1]));break;case"flow":E=ZC._i_(v[1]),K=ZC.AO.BK(x,y,(S+M)/2,I),99===E||-99===E?s.E.push([K[0],K[1],(M-S)/2,I+180,I,99===E?1:0]):s.E.push(ZC.AO.BK(x,y,(S+M)/2,I+E)),s.E.push(ZC.AO.BK(x,y,M,I),[x,y,M,I,z,0]),F=ZC.AO.BK(x,y,(S+M)/2,z),k?99===E||-99===E?s.E.push(ZC.AO.BK(x,y,M,z),[F[0],F[1],(M-S)/2,z,z+180,99===E?0:1]):s.E.push(ZC.AO.BK(x,y,(S+M)/2,z+E)):(99===E||-99===E?s.E.push([F[0],F[1],(M-S)/2,z,z+180,99===E?0:1]):s.E.push(ZC.AO.BK(x,y,(S+M)/2,z+E)),s.E.push(ZC.AO.BK(x,y,S,z),[x,y,S,z,I,1]));break;case"circle":var X=ZC._f_(v[1]||"1"),T=(5+ZC._a_(z-I)%360*50/360)*X;B=z%360==I%360||D?[x,y]:ZC.AO.BK(x,y,(M+S)/2,(I+z)/2),s.E.push(ZC.AO.BK(B[0],B[1],T,0),[B[0],B[1],T,0,360,0]);break;case"bite":E=ZC._i_(v[1]),w=ZC._i_(2*M*ZC.EO(E/2)),B=ZC.AO.BK(x,y,M,I),s.E.push(ZC.AO.BK(x,y,M-w,I),[B[0],B[1],w,I+180,I+90+(90-(180-E)/2),1],[x,y,M,I+E,z,0]),k||s.E.push(ZC.AO.BK(x,y,S,z),[x,y,S,z,I,1]);break;case"droplet":for(var P=M,N=1,O=0;M*N+O>=P;)N=ZC._x_(N-.02,2),w=ZC._i_(M*N/ZC.EF((z-I)/2)),O=ZC._i_(M*N*Math.tan(ZC.SZ((z-I)/2)));B=ZC.AO.BK(x,y,w,H),s.E.push(ZC.AO.BK(x,y,M*N,I),[B[0],B[1],O,H-(360-(180-(z-I)))/2,H+(360-(180-(z-I)))/2,0]),k||s.E.push(ZC.AO.BK(x,y,S,z),[x,y,S,z,I,1]);break;default:s.E.push(ZC.AO.BK(x,y,M,I),[x,y,M,I,z,0]),0===S?I%360==z%360||D||s.E.push([x,y]):s.E.push(ZC.AO.BK(x,y,M,z),ZC.AO.BK(x,y,S,z),[x,y,S,z,I,1])}s.E.push([s.E[0][0],s.E[0][1]])}}s.locate(2)},paint:function(){var e=this;if("none"!==e.DQ&&("custom"===e.DQ||"circle"===e.DQ||"arc"===e.DQ||0!==e.E.length)){var t,i,n={x:"iX",y:"iY",width:"I",height:"F",size:"AI"};if(e.o["bottom-state"]&&!e.Y3&&!e.VV&&!e.bIsBottom){var a=new ZC.DW(e.A);a.copy(e),a.bIsBottom=!0,a.M4=!1,a.Z=e.Z,a.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY}),a.append(e.o["bottom-state"]),a.K=e.K+"-bottom",a.parse(),i=!1;for(t in n)null===ZC._n_(a.o[t])||-1===(""+a.o[t]).indexOf("+")&&-1===(""+a.o[t]).indexOf("-")||(a.o[t]=a[n[t]]=e[n[t]]+ZC._i_(a.o[t]),i=!0);i&&a.parse(),a.paint()}var r=e.H.AC;switch(e.M4&&e.C6&&e.A9U(),r){case"canvas":e.A1D();break;case"svg":e.W6();break;case"vml":e.W5()}if(e.o["top-state"]&&!e.Y3&&!e.VV&&!e.bIsBottom){var l=new ZC.DW(e.A);l.copy(e),l.VV=!0,l.M4=!1,l.Z=e.Z,l.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY}),l.append(e.o["top-state"]),l.K=e.K+"-top",l.parse(),i=!1;for(t in n)null===ZC._n_(l.o[t])||-1===(""+l.o[t]).indexOf("+")&&-1===(""+l.o[t]).indexOf("-")||(l.o[t]=l[n[t]]=e[n[t]]+ZC._i_(l.o[t]),i=!0);i&&l.parse(),l.paint()}}},A9U:function(){var e,t=this,i=new ZC.DW(t.A);i.K=t.K+"-sh",i.copy(t),i.O3=t.O3,i.Z=t.C6,i.M4=!1,i.Y3=!0,i.A0=i.AE=i.RQ,i.GQ=i.HJ="",i.D9="",i.G9="solid",i.BV=i.RQ,i.B0=0,i.C5=i.SU*t.C5,i.K=t.K+"-sh";var n=(t.JP-t.P1)*ZC.EF(t.OE)+t.P1,a=(t.JP-t.P1)*ZC.EO(t.OE)+t.P1;if(i.iX=t.iX+parseInt(n,10),i.iY=t.iY+parseInt(a,10),i.AI=t.AI+t.P1,t.E.length>0){e=[];for(var r=0,l=t.E.length;r<l;r++)if(null!==t.E[r]){for(var o=[],s=0;s<t.E[r].length;s++)o[s]=t.E[r][s];o[0]=t.E[r][0]+parseInt(n,10),o[1]=t.E[r][1]+parseInt(a,10),e.push(o)}else e.push(null)}i.D1=[t.D1[0]+n,t.D1[1]+a,t.D1[2]+n,t.D1[3]+a],i.E=e,i.paint()},A1N:function(){var e=this;return{lc:"-1"===e.B7?"rgba(255,255,255,0)":1===e.C5?e.B7:ZC.AP.A2M(ZC.AP.G5(e.B7),e.C5),bc:"-1"===e.BV?"rgba(255,255,255,0)":1===e.NQ?e.BV:ZC.AP.A2M(ZC.AP.G5(e.BV),e.NQ),bgc1:"-1"===e.A0?"rgba(255,255,255,0)":1===e.C5?e.A0:ZC.AP.A2M(ZC.AP.G5(e.A0),e.C5),bgc2:"-1"===e.AE?"rgba(255,255,255,0)":1===e.C5?e.AE:ZC.AP.A2M(ZC.AP.G5(e.AE),e.C5)}},Y6:function(e){var t,i,n,a=this;switch(a.DQ){case"circle":case"arc":case"pie":t=a.iX,i=a.iY,n=a.AI;break;default:t=a.D1[0]+(a.D1[2]-a.D1[0])/2,i=a.D1[1]+(a.D1[3]-a.D1[1])/2,n=ZC._a_(ZC.EF(a.N8)*(a.D1[2]-a.D1[0])/2+ZC.EO(a.N8)*(a.D1[3]-a.D1[1])/2)}ZC.P4(t)||(t=0),ZC.P4(i)||(i=0),ZC.P4(n)||(n=0);var r=a.W4,l=a.W2;if(ZC._a_(r)<=1&&(r=r*(a.D1[2]-a.D1[0])/2),ZC._a_(l)<=1&&(l=l*(a.D1[3]-a.D1[1])/2),t+=r,i+=l,"radial"===e)return{cx:t,cy:i,r:ZC._a_(n)};if("linear"===e){var o=n*ZC.EF(a.N8),s=n*ZC.EO(a.N8),c=t-o,h=i-s,C=t+o,u=i+s;return ZC._i_(h)===ZC._i_(u)&&ZC._a_(C-c)<5&&(u+=1),ZC._i_(c)===ZC._i_(C)&&ZC._a_(u-h)<5&&(C+=1),{x1:c,y1:h,x2:C,y2:u}}},RA:function(){var e,t=this;ZC.cache.data[t.D9]?e=ZC.cache.data[t.D9]:((e=new Image).src=t.D9,ZC.cache.data[t.D9]=e),1!==t.KL&&(e._width_?(e.width=e._width_,e.height=e._height_):(e._width_=e.width,e._height_=e.height));var i,n;switch(i=e.width*t.KL,n=e.height*t.KL,t.WE){case"x":i=t.I;break;case"y":n=t.F;break;case"xy":case"both":i=t.I,n=t.F}var a,r,l,o,s=t.T4.split(" "),c=s[0]||"",h=0,C=0;switch(c){case"":case"left":a=0,h=0;break;case"center":a=(t.I-i)/2,h=.5;break;case"right":a=t.I-i,h=1;break;default:-1!==c.indexOf("%")?(h=ZC._i_(c.replace(/[^0-9\-]/g,""))/100,a=(t.I-i)*h):(h=ZC._i_(c.replace(/[^0-9\-]/g,""))/t.I,a=ZC._i_(c.replace(/[^0-9\-]/g,"")))}l=a/t.I,"undefined"!=typeof t.KP?a+=t.iX+t.BJ:a+=t.D1[0]+t.BJ;var u=s[1]||"";switch(u){case"":case"top":r=0,C=0;break;case"middle":r=(t.F-n)/2,C=.5;break;case"bottom":r=t.F-n,C=1;break;default:-1!==u.indexOf("%")?(C=ZC._i_(u.replace(/[^0-9\-]/g,""))/100,r=(t.F-n)*C):(C=ZC._i_(u.replace(/[^0-9\-]/g,""))/t.F,r=ZC._i_(u.replace(/[^0-9\-]/g,"")))}if(o=r/t.F,"undefined"!=typeof t.KP?r+=t.iY+t.BH:r+=t.D1[1]+t.BH,"pie"===t.DQ){var d=t.AA+t.B3+(t.BI-t.B3)*h,p=ZC.AO.BK(t.iX,t.iY,t.CN+(t.AI-t.CN)*C,d);a=p[0]-e.width/2,r=p[1]-e.height/2}return t.D["bg-image-width"]=i,t.D["bg-image-height"]=n,{image:e,x:ZC._i_(a)+.5,y:ZC._i_(r)+.5,cx:ZC._f_(l),cy:ZC._f_(o),hPos:h,vPos:C}},ZB:function(e){for(var t=this,i=t.GQ.split(/\s+|;/),n=t.HJ.split(/\s+|;/),a=0,r=i.length;a<r;a++){var l=ZC.AP.G5(i[a],t);"object"!=typeof l&&(l=[l,t.C5]);var o=ZC.AP.A2M(l[0],l[1]),s=ZC._f_(n[a]||"1");ZC.DT(s,0,1)||(s=1),e.addColorStop(s,o)}},A1D:function(){var e,t,i,n,a,r,l,o,s=this,c=s.Z.getContext("2d");c.save(),"poly"===s.DQ||"line"===s.DQ?(t=s.D1[0]+(s.D1[2]-s.D1[0])/2,i=s.D1[1]+(s.D1[3]-s.D1[1])/2):(t=s.iX,i=s.iY);var h=s.A1N(),C=h.lc,u=h.bc,d=h.bgc1,p=h.bgc2;if(d!==p||""!==s.GQ&&""!==s.HJ){var A=s.Y6(s.NE);"radial"===s.NE?n=c.createRadialGradient(A.cx,A.cy,1,A.cx,A.cy,A.r):"linear"===s.NE&&(n=c.createLinearGradient(A.x1,A.y1,A.x2,A.y2)),""!==s.GQ&&""!==s.HJ?s.ZB(n):(n.addColorStop(0,d),n.addColorStop(1,p)),c.fillStyle=n}else""!==s.D9&&-1!==ZC.AV(["repeat","true",!0],s.LZ)&&"-1"===s.A0&&"-1"===s.AE&&(d="rgba(255,255,255,0)"),c.fillStyle=d;switch(s.DQ){case"custom":if((e=s.o.url)&&(ZC.cache.data[e]?a=ZC.cache.data[e]:((a=new Image).src=e,ZC.cache.data[e]=a),a.width=s.o.width?s.o.width:a.width,a.height=s.o.height?s.o.height:a.height,c.drawImage(a,s.iX-a.width/2+s.BJ,s.iY-a.height/2+s.BH,a.width,a.height),0===d.indexOf("#")&&7===d.length)){for(var g=parseInt(d.substring(1,3),16),f=parseInt(d.substring(3,5),16),Z=parseInt(d.substring(5,7),16),_=c.getImageData(s.iX-a.width/2+s.BJ,s.iY-a.height/2+s.BH,a.width,a.height),b=0;b<_.data.length;b+=4)_.data[b]=g|_.data[b],_.data[b+1]=f|_.data[b+1],_.data[b+2]=Z|_.data[b+2];c.putImageData(_,s.iX-a.width/2+s.BJ,s.iY-a.height/2+s.BH)}break;case"plus":case"cross":case"line":case"ic_line":case"arc":c.strokeStyle=C,c.lineWidth=s.B0;break;default:c.strokeStyle=u,c.lineWidth=s.AT}0!==s.AA&&(c.translate(t,i),isNaN(s.AA)||c.rotate(ZC.SZ(s.AA)),c.translate(-t,-i));var m=-1===ZC.AV(["cross","plus","arc","line","ic_line"],s.DQ);switch(isNaN(s.BJ)||isNaN(s.BH)||0===s.BJ&&0===s.BH||!m&&"arc"!==s.DQ||c.translate(s.BJ,s.BH),c.beginPath(),s.DQ){case"circle":case"arc":c.setLineDash&&"circle"===s.DQ&&(s.KV(s.AT),c.setLineDash(0===s.EX||0===s.G6?[]:[s.EX,s.G6])),c.arc(s.iX,s.iY,s.AI,ZC.SZ(s.B3),ZC.SZ(s.BI),!1);break;case"line":break;default:-1!==ZC.AV(["square","plus"],s.DQ)&&(s.MZ=!0),ZC.CS.contour(c,s,s.E),-1!==ZC.AV(["square","plus"],s.DQ)&&(s.MZ=!1)}if(c.globalCompositeOperation=s.A0M,m)if(""!==s.D9&&-1===ZC.AV(ZC.IMG404,s.D9)){c.fill(),c.save(),c.clip();var v;v=c.globalAlpha,c.globalAlpha=s.C5;var D=s.RA();switch(a=D.image,s.LZ){case"repeat":case!0:case"true":r=s.D1[0]-(a.width-(s.D1[2]-s.D1[0]))/2,l=s.D1[1]-(a.height-(s.D1[3]-s.D1[1]))/2,c.translate(r,l),o=c.createPattern(a,"repeat"),c.fillStyle=o,c.fill(),c.translate(-r,-l);break;case"no-repeat":case!1:case"false":c.drawImage(a,D.x-s.BJ,D.y-s.BH,s.D["bg-image-width"],s.D["bg-image-height"])}c.globalAlpha=v,c.restore()}else c.fill();switch(c.closePath(),c.beginPath(),s.DQ){case"circle":case"arc":c.arc(s.iX,s.iY,s.AI,ZC.SZ(s.B3),ZC.SZ(s.BI),!1),("circle"===s.DQ&&s.AT>0||"arc"===s.DQ&&s.B0>0)&&c.stroke(),c.closePath();break;case"plus":case"cross":case"line":case"ic_line":s.B0>0&&(ZC.CS.setup(c,s),s.o.spline?(s.CZ=!1,s.QJ=!0,ZC.CS.paint(c,s,ZC.CS.smooth(s.E,!1,s.o.direction||"h"))):ZC.CS.paint(c,s,s.E));break;default:if(s.AT>0){var E=s.B7,w=s.B0;s.B7=s.BV,s.B0=s.AT,s.KV(),ZC.CS.setup(c,s),ZC.CS.paint(c,s,s.E,!0),s.B7=E,s.B0=w,s.KV()}c.closePath()}c.restore()},A28:function(e){var t=this,i=e.info,n=i.image,a=!0;switch(t.LZ){default:a=!0;break;case"no-repeat":case"false":case!1:a=!1}var r=t.D9;0===n.src.indexOf("data:")&&(r=n.src),n.width*=t.KL,n.height*=t.KL;var l=""===t.K?"pattern-"+ZC.SEQ++:t.K+"-pattern";ZC.Q.EU(l);var o=ZC.Q.F4("image","http://www.w3.org/2000/svg");o.setAttributeNS?o.setAttributeNS("http://www.w3.org/1999/xlink","href",r):o.setAttribute("src",r),ZC.Q.G2(o,{id:l+"-image",preserveAspectRatio:"none",width:t.D["bg-image-width"],height:t.D["bg-image-height"]});var s=n.width,c=n.height;if(!a){s=c=1;var h,C;t.I>0&&t.F>0?(h=t.I,C=t.F):(h=t.D1[2]-t.D1[0],C=t.D1[3]-t.D1[1]);var u=ZC._i_(h*i.cx),d=ZC._i_(C*i.cy);if("pie"===t.DQ){s=t.H?t.H.I:t.A.I,c=t.H?t.H.F:t.A.F;var p=t.AA+t.B3+(t.BI-t.B3)*i.hPos,A=ZC.AO.BK(t.iX,t.iY,t.CN+(t.AI-t.CN)*i.vPos,p);u=A[0]-n.width/2,d=A[1]-n.height/2}t.D["pattern-image-id"]=l+"-image",t.D["pattern-tx"]=u,t.D["pattern-ty"]=d,ZC.Q.G2(o,{transform:"translate("+u+","+d+")"})}var g=ZC.Q.F4("pattern","http://www.w3.org/2000/svg");ZC.Q.G2(g,{x:a?e.x:0,y:a?e.y:0,width:s,height:c,id:l,patternUnits:a||"pie"===t.DQ?"userSpaceOnUse":"objectBoundingBox"}),t.H.K7.childNodes[0].appendChild(g),g.appendChild(o),t.D.imgfill="url(#"+l+")"},WP:function(e){null!==e&&void 0!==e||(e=!1);var t,i,n=this;if(n.A0!==n.AE||""!==n.GQ&&""!==n.HJ){var a=""===n.K?"gradient-"+ZC.SEQ++:n.K+"-gradient";(n.TL||e&&!ZC.AK(a))&&(e=!1),ZC.A4.browser.msie&&9===ZC._i_(ZC.A4.browser.version)&&(e=!1),ZC.AK(a)&&!e&&ZC.Q.EU(a);var r=n.Y6(n.NE);if("radial"===n.NE?(t=e?ZC.AK(a):ZC.Q.F4("radialGradient","http://www.w3.org/2000/svg"),ZC.Q.G2(t,{cx:ZC._i_(r.cx),cy:ZC._i_(r.cy),r:ZC._i_(r.r),fx:ZC._i_(r.cx),fy:ZC._i_(r.cy)})):"linear"===n.NE&&(t=e?ZC.AK(a):ZC.Q.F4("linearGradient","http://www.w3.org/2000/svg"),ZC.Q.G2(t,{x1:ZC._i_(r.x1),x2:ZC._i_(r.x2),y1:ZC._i_(r.y1),y2:ZC._i_(r.y2)})),!e){if(ZC.Q.G2(t,{id:a,gradientUnits:"userSpaceOnUse"}),n.H.K7.childNodes[0].appendChild(t),""!==n.GQ&&""!==n.HJ)for(var l=n.GQ.split(/\s+|;/),o=n.HJ.split(/\s+|;/),s=0,c=l.length;s<c;s++){var h=ZC.AP.G5(l[s],n);"object"!=typeof h&&(h=[h,n.C5]),l[s]=h[0];var C=o[s]||1;ZC.DT(C,0,1)||(C=1);var u=h[1];i=l[s],"-1"===l[s]&&(u=0,i="rgb(255,255,255)");var d=ZC.Q.F4("stop","http://www.w3.org/2000/svg");ZC.Q.G2(d,{offset:C,"stop-color":i,"stop-opacity":u}),t.appendChild(d)}else{var p=1,A=n.A0;"-1"===n.A0&&(p=0,A="rgb(255,255,255)");var g=ZC.Q.F4("stop","http://www.w3.org/2000/svg");ZC.Q.G2(g,{offset:0,"stop-color":A,"stop-opacity":p});var f=1,Z=n.AE;"-1"===n.AE&&(f=0,Z="rgb(255,255,255)");var _=ZC.Q.F4("stop","http://www.w3.org/2000/svg");ZC.Q.G2(_,{offset:1,"stop-color":Z,"stop-opacity":f}),t.appendChild(g),t.appendChild(_)}n.D.fill="url(#"+a+")"}}else"-1"!==n.A0&&(n.D.fill=n.A0)},A3L:function(){var e=this;if("object"==typeof e.D.imgfill&&"undefined"!=typeof e.H&&e.H){var t=e.A4V()[1].split(",");if("circle"===e.DQ)e.H.K7.appendChild(ZC.Q.XA({id:e.K+"_image-clip",cx:t[0],cy:t[1],r:t[2]})),e.D["clip-path"]=e.K+"_image-clip";else if(t.length>6){for(var i="",n=0,a=t.length;n<a;n+=2)i+=ZC._i_(t[n])+ZC._i_(e.BJ)+","+(ZC._i_(t[n+1])+ZC._i_(e.BH))+" ";e.H.K7.appendChild(ZC.Q.XA({id:e.K+"_image-clip",path:i})),e.D["clip-path"]=e.K+"_image-clip"}}},W6:function(){var e,t,i,n,a,r,l=this,o=l.Z;if("poly"===l.DQ||"line"===l.DQ?(t=l.D1[0]+(l.D1[2]-l.D1[0])/2,i=l.D1[1]+(l.D1[3]-l.D1[1])/2):(t=l.iX,i=l.iY),l.D.cx=t,l.D.cy=i,l.D.fill=-1,""!==l.D9){var s=l.RA();l.A28({info:s,x:t-s.image.width/2,y:i-s.image.height/2})}switch(l.VC&&l.A3L(),l.WP(),l.DQ){case"custom":if(e=l.o.url){var c,h=!1;ZC.cache.data[e]?n=ZC.cache.data[e]:((n=new Image).src=e,ZC.cache.data[e]=n),(h=e.indexOf(".svg")>0&&e.indexOf("#")>=0)?(c=ZC.Q.F4("svg","http://www.w3.org/2000/svg"),ZC.Q.G2(c,{viewBox:"0 0 8 8",fill:l.D.fill}),r=ZC.Q.F4("use","http://www.w3.org/2000/svg")):r=ZC.Q.F4("image","http://www.w3.org/2000/svg"),r.setAttributeNS?r.setAttributeNS("http://www.w3.org/1999/xlink","href",e):r.setAttribute("src",e);var C=l.o.width?l.o.width:n.width,u=l.o.height?l.o.height:n.height;n.width=C,n.height=u,h?ZC.Q.G2(c,{id:l.K+"-image",x:l.iX-n.width/2+l.BJ,y:l.iY-n.height/2+l.BH,width:n.width,height:n.height}):ZC.Q.G2(r,{id:l.K+"-image",x:l.iX-n.width/2+l.BJ,y:l.iY-n.height/2+l.BH,width:n.width,height:n.height}),h?(c.appendChild(r),o.appendChild(c)):o.appendChild(r)}break;case"circle":if(!ZC.AK(l.K+"-circle")&&(a=ZC.Q.F4("circle","http://www.w3.org/2000/svg"),-1!==l.D.fill?ZC.Q.G2(a,{fill:l.D.fill,"fill-opacity":l.C5}):ZC.Q.G2(a,{fill:"none"}),l.DI&&""!==l.DI&&ZC.Q.G2(a,{"class":l.DI}),ZC.Q.G2(a,{id:l.K+"-circle",cx:l.iX+l.BJ,cy:l.iY+l.BH,r:l.AI}),l.AT>0&&(ZC.Q.G2(a,{stroke:l.BV,"stroke-width":l.AT,"stroke-opacity":l.NQ}),l.KV(l.AT),"solid"===l.G9||0===l.EX&&0===l.G6||ZC.Q.G2(a,{"stroke-dasharray":"dashdot"===l.G9?[l.EX,l.G6,l.B0,l.G6].join(" "):[l.EX,l.G6].join(",")})),l.H&&l.H.FY?(l.H.FY[o.id]||(l.H.FY[o.id]=document.createDocumentFragment()),l.H.FY[o.id].appendChild(a)):o.appendChild(a),"undefined"!=typeof l.D.imgfill))if("string"==typeof l.D.imgfill)a=ZC.Q.F4("circle","http://www.w3.org/2000/svg"),ZC.Q.G2(a,{id:l.K+"-imgfill",fill:l.D.imgfill,"fill-opacity":l.C5,cx:l.iX+l.BJ,cy:l.iY+l.BH,r:l.AI,"stroke-width":0}),l.H&&l.H.FY?l.H.FY[o.id].appendChild(a):o.appendChild(a);else{var d=l.D.imgfill;(r=ZC.Q.F4("image","http://www.w3.org/2000/svg")).setAttributeNS&&r.setAttributeNS("http://www.w3.org/1999/xlink","href",l.D9),l.D["clip-path"]&&ZC.Q.G2(r,{"clip-path":"url(#"+l.D["clip-path"]+(ZC.A4.browser.webkit?"-shape":"")+")"}),ZC.Q.G2(r,{id:l.K+"-imgfill",x:d[1],y:d[2],width:d[0].width,height:d[0].height}),o.appendChild(r)}break;case"plus":case"cross":case"line":case"ic_line":case"arc":l.B0>0&&(ZC.CS.setup(o,l),l.o.spline?(l.CZ=!1,l.QJ=!0,ZC.CS.paint(o,l,ZC.CS.smooth(l.E,!1,l.o.direction||"h"))):ZC.CS.paint(o,l,l.E));break;default:var p=l.B7,A=l.B0;l.B7=l.BV,l.B0=l.AT,l.KV(),ZC.CS.setup(o,l),ZC.CS.paint(o,l,l.E,!0,0),l.B7=p,l.B0=A,l.KV()}},WQ:function(e,t){null!==t&&void 0!==t||(t=!1);var i,n=this;if(n.A0!==n.AE||""!==n.GQ&&""!==n.HJ){var a=""===n.K?"gradient-"+ZC.SEQ++:n.K+"-gradient";if(t&&!ZC.AK(a)&&(t=!1),ZC.AK(a)&&!t&&ZC.A4(a).remove(),i=t?ZC.AK(a):ZC.Q.F4("zcv:fill"),t&&(e=ZC.A4("#"+a).attr("focusposition")),""!==n.GQ&&""!==n.HJ){for(var r=n.GQ.split(/\s+|;/),l=n.HJ.split(/\s+|;/),o="",s="",c="",h=0,C=r.length;h<C;h++){r[h]=ZC.AP.G5(r[h]);var u="-1"===r[h]?"rgb(255,255,255)":r[h],d=l[h]||1;ZC.DT(d,0,1)||(d=1);var p=ZC._i_(100*d);0===h?o=u:h===C-1?s=u:c+=p+"% "+ZC.AP.G5(u)+","}""!==c&&(c=c.substring(0,c.length-1)),"radial"===n.NE?ZC.Q.G2(i,{id:a,type:"gradientradial",focusposition:e,color:o,color2:s,colors:c}):"linear"===n.NE&&ZC.Q.G2(i,{id:a,type:"gradient",method:"sigma",angle:270-n.N8-n.AA,color:o,color2:s,colors:c})}else{var A=n.A0;"-1"===n.A0&&(A="rgb(255,255,255)");var g=n.AE;"-1"===n.AE&&(g="rgb(255,255,255)"),"radial"===n.NE?ZC.Q.G2(i,{id:a,type:"gradientradial",focusposition:e,color:g,color2:A}):"linear"===n.NE&&ZC.Q.G2(i,{id:a,type:"gradient",method:"sigma",angle:270-n.N8-n.AA,color:A,color2:g})}var f="undefined"!=typeof n.D.opacity2?n.D.opacity2:n.C5;ZC.Q.G2(i,{opacity:n.C5,"o:opacity2":f}),n.D.fill=i}else i=ZC.Q.F4("zcv:fill"),"-1"!==n.A0&&(ZC.Q.G2(i,{type:"solid",color:n.A0,opacity:n.C5}),n.D.fill=i)},W5:function(){var e,t,i,n,a,r,l=this,o=l.Z;"poly"===l.DQ||"line"===l.DQ?(t=l.D1[0]+(l.D1[2]-l.D1[0])/2,i=l.D1[1]+(l.D1[3]-l.D1[1])/2):(t=l.iX,i=l.iY),l.D.cx=t,l.D.cy=i,l.D.fill=-1;var s=-1===ZC.AV(["cross","plus","arc","line","ic_line"],l.DQ),c=ZC.Q.F4("zcv:fill");if(""!==l.D9){var h=l.RA();switch(n=h.image,l.LZ){default:c.type="tile",c.src=l.D9,ZC.Q.G2(c,{position:h.cx+","+h.cy,opacity:l.C5,"o:opacity2":l.C5}),l.D.imgfill=[c];break;case"no-repeat":case"false":case!1:l.D.imgfill=[n,h.x,h.y]}}l.WQ("0,0");var C=ZC.Q.F4("zcv:stroke");switch(l.DQ){case"custom":(e=l.o.url)&&(ZC.cache.data[e]?n=ZC.cache.data[e]:((n=new Image).src=e,ZC.cache.data[e]=n),(r=ZC.Q.F4("img")).id=l.K+"-img",r.src=e,r.style.position="absolute",1!==l.KL&&(r.width*=l.KL,r.height*=l.KL,r.style.width=r.width+"px",r.style.height=r.height+"px"),r.style.left=l.iX-n.width/2+l.BJ+"px",r.style.top=l.iY-n.height/2+l.BH+"px",o.appendChild(r));break;case"plus":case"cross":case"line":case"ic_line":case"arc":C.weight=l.B0+"px",C.color=l.B7;break;default:C.weight=l.AT+"px",C.color=l.BV}switch(C.opacity=l.NQ,l.G9){case"solid":C.dashstyle="solid";break;case"dotted":C.dashstyle="dot";break;case"dashed":C.dashstyle="dash"}switch(-1===ZC.AV(["plus","cross","line","ic_line"],l.DQ)&&(l.D.stroke=C),l.DQ){case"circle":case"arc":if(!ZC.AK(l.K+"-circle")&&(a=ZC.Q.F4("circle"===l.DQ?"zcv:oval":"zcv:arc"),a.id=l.K+"-circle",a.style.position="absolute",-1!==l.D.fill&&s?a.appendChild(l.D.fill):a.filled=!1,l.AT>0||l.B0>0?a.appendChild(C):a.stroked=!1,a.style.left=l.iX+l.BJ-l.AI+"px",a.style.top=l.iY+l.BH-l.AI+"px",a.style.width=2*l.AI+"px",a.style.height=2*l.AI+"px","arc"===l.DQ&&ZC.Q.G2(a,{startangle:l.BI+90,endangle:l.B3+90}),o.appendChild(a),s&&"undefined"!=typeof l.D.imgfill)){var u=l.D.imgfill;1===u.length?((a=ZC.Q.F4("zcv:oval")).id=l.K+"-imgfill",a.style.position="absolute",o.appendChild(a),a.appendChild(u[0]),a.style.left=l.iX+l.BJ-l.AI+"px",a.style.top=l.iY+l.BH-l.AI+"px",a.style.width=2*l.AI+"px",a.style.height=2*l.AI+"px",a.stroked=!1,"arc"===l.DQ&&ZC.Q.G2(a,{startangle:l.BI+90,endangle:l.B3+90})):3===u.length&&((r=ZC.Q.F4("img")).id=l.K+"-img",r.src=l.D9,r.style.position="absolute",r.style.left=u[1]+"px",r.style.top=u[2]+"px",1!==l.KL&&(r.width*=l.KL,r.height*=l.KL,r.style.width=r.width+"px",r.style.height=r.height+"px"),o.appendChild(r))}break;case"plus":case"cross":case"line":case"ic_line":l.B0>0&&(ZC.CS.setup(o,l),l.o.spline?(l.CZ=!1,l.QJ=!0,ZC.CS.paint(o,l,ZC.CS.smooth(l.E,!1,l.o.direction||"h"))):ZC.CS.paint(o,l,l.E));break;default:var d=l.B7,p=l.B0;l.B7=l.BV,l.B0=l.AT,l.KV(),ZC.CS.setup(o,l),ZC.CS.paint(o,l,l.E,!0,0),l.B7=d,l.B0=p,l.KV()}}}),ZC.HS=ZC.DW.C7({$i:function(e){this.b(e);var t=this;t.DQ="box",t.I=0,t.F=0,t.A8C="",t.E5=-1,t.E6=-1,t.DP=-1,t.DV=-1,t.F5=0,t.FQ=0,t.F2=0,t.FB=0,t.A75=!1,t.KP=!1,t.ES="bottom",t.EV=0,t.M1=0,t.H6=8,t.G3=8,t.XD=[1,1],t.DM=null,t.OF=null,t.PR=!1,t.MZ=!0,t.PQ="",t.OC="",t.NL="",t.P6="",t.WG="tl",t.FA=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"width,height,borderRadiusTopLeft,borderRadiusTopRight,borderRadiusBottomRight,borderRadiusBottomLeft,callout,calloutType,calloutPosition,calloutHook,calloutWidth,calloutHeight,calloutOffset,calloutExtension,position,borderTop,borderRight,borderBottom,borderLeft,rectShortcut","I,F,F5,FQ,F2,FB,KP,ES,DM,H6,G3,EV,M1,A8C,PQ,OC,NL,P6,FA"),e},build:function(){},wh_:function(e,t,i){var n=this;if(t=t||"w",ZC._f_(e)+""!=e+"")return-1!==(e+="").indexOf("%")?n.wh_(ZC._f_(e.replace("%",""))/100,t,!0):-1!==e.indexOf("px")?n.wh_(ZC._f_(e.replace("px","")),t):n.wh_(ZC._f_(e),t);var a="undefined"!=typeof n.D["p-width"]?n.D["p-width"]:n.A.I,r="undefined"!=typeof n.D["p-height"]?n.D["p-height"]:n.A.F;return(e=ZC._a_(e))>1&&!i?ZC._i_(e):e<=1||i?"w"===t?ZC._i_(a*e):ZC._i_(r*e):void 0},m_:function(e,t,i,n,a){var r,l,o=this;if(i=i||0,n=n||0,t=t||"all",a=a||"n","all"===t){var s=String(e).split(/\s+|;|,/);return 1===s.length?[o.m_(s[0],"tb",i,n,a),o.m_(s[0],"lr",i,n,a),o.m_(s[0],"tb",i,n,a),o.m_(s[0],"lr",i,n,a)]:2===s.length?[o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a),o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a)]:3===s.length?[o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a),o.m_(s[2],"tb",i,n,a),o.m_(s[1],"lr",i,n,a)]:[o.m_(s[0],"tb",i,n,a),o.m_(s[1],"lr",i,n,a),o.m_(s[2],"tb",i,n,a),o.m_(s[3],"lr",i,n,a)]}return e+""=="auto"?-2:e+""=="dynamic"&&"y"===a?"dynamic":ZC._f_(e)+""!=e+""?-1!==(e+="").indexOf("%")?o.m_(ZC._f_(e.replace("%",""))/100,t):-1!==e.indexOf("px")?o.m_(ZC._f_(e.replace("px","")),t):o.m_(ZC._f_(e),t):((o.A||"undefined"!=typeof o.D["p-width"])&&(r="undefined"!=typeof o.D["p-width"]?o.D["p-width"]:o.A.I),(o.A||"undefined"!=typeof o.D["p-height"])&&(l="undefined"!=typeof o.D["p-height"]?o.D["p-height"]:o.A.F),(e=ZC._a_(e))>=1?ZC._i_(e):e<1?"lr"===t?ZC._i_((o.A?r:i)*e):ZC._i_((o.A?l:n)*e):void 0)},copy:function(e){this.b(e);for(var t=this,i="I,F,E5,DP,DV,E6,F5,FQ,F2,FB,KP,ES,DM,XD,H6,G3,EV,M1,A8C,PQ,OC,NL,P6,FA".split(","),n=0,a=i.length;n<a;n++)"undefined"!=typeof e[i[n]]&&(t[i[n]]=e[i[n]])},locate:function(e){var t,i,n,a,r,l=this;if(2!==(e=e||1))if(l.TL)l.assign_a([["x","iX"],["y","iY"],["width","I"],["height","F"]]);else{var o="undefined"!=typeof l.D["p-x"]?l.D["p-x"]:l.A.iX,s="undefined"!=typeof l.D["p-y"]?l.D["p-y"]:l.A.iY,c="undefined"!=typeof l.D["p-width"]?l.D["p-width"]:l.A.I,h="undefined"!=typeof l.D["p-height"]?l.D["p-height"]:l.A.F;if(!l.PR){var C=0,u=0,d=0,p=0;if(null!==ZC._n_(l.o.margin)){var A=""+l.o.margin;if(-1!==A.indexOf("dynamic")){var g=l.m_(A,"all",0,0,"y");"dynamic"===g[0]&&(l.D["d-margin-top"]=l.D["d-margin"]=!0),"dynamic"===g[1]&&(l.D["d-margin-right"]=l.D["d-margin"]=!0),"dynamic"===g[2]&&(l.D["d-margin-bottom"]=l.D["d-margin"]=!0),"dynamic"===g[3]&&(l.D["d-margin-left"]=l.D["d-margin"]=!0),l.o.margin=A.replace(/dynamic/g,"20")}}"dynamic"===l.o.margin&&(l.D["d-margin"]=l.D["d-margin-top"]=l.D["d-margin-right"]=l.D["d-margin-bottom"]=l.D["d-margin-left"]=!0,l.o.margin=null),"undefined"==typeof l.D["force-margins"]||null!==ZC._n_(l.o["adjust-layout"])&&ZC._b_(l.o["adjust-layout"])||(null!==ZC._n_(l.o["margin-top"])&&null===ZC._n_(l.o["margin-bottom"])&&(l.o["margin-bottom"]="auto"),null!==ZC._n_(l.o["margin-bottom"])&&null===ZC._n_(l.o["margin-top"])&&(l.o["margin-top"]="auto"),null!==ZC._n_(l.o["margin-left"])&&null===ZC._n_(l.o["margin-right"])&&(l.o["margin-right"]="auto"),null!==ZC._n_(l.o["margin-right"])&&null===ZC._n_(l.o["margin-left"])&&(l.o["margin-left"]="auto"));for(var f=["margin-top","margin-right","margin-bottom","margin-left"],Z=0,_=f.length;Z<_;Z++)"dynamic"===l.o[f[Z]]&&(l.D["d-"+f[Z]]=l.D["d-margin"]=!0,l.o[f[Z]]=null);null!==(t=ZC._n_(l.o.margin))&&(i=l.m_(t,"all"),null===ZC._n_(l.o["margin-top"])&&(C=i[0]),null===ZC._n_(l.o["margin-right"])&&(u=i[1]),null===ZC._n_(l.o["margin-bottom"])&&(d=i[2]),null===ZC._n_(l.o["margin-left"])&&(p=i[3])),null!==(t=ZC._n_(l.o["margin-top"]))&&(C=i=l.m_(t,"tb")),null!==(t=ZC._n_(l.o["margin-right"]))&&(u=i=l.m_(t,"lr")),null!==(t=ZC._n_(l.o["margin-bottom"]))&&(d=i=l.m_(t,"tb")),null!==(t=ZC._n_(l.o["margin-left"]))&&(p=i=l.m_(t,"lr"));var b=[C,u,d,p];null!==ZC._n_(l.o.x)&&(l.iX=l.xy_(l.o.x,"x")),null!==ZC._n_(l.o.y)&&(l.iY=l.xy_(l.o.y,"y"));var m;if(null!==(t=ZC._n_(l.o.width))){var v=ZC._p_(t);m=-1!==(""+t).indexOf("%"),l.I=v>1&&!m?ZC._i_(v):-2===p&&-2===u?ZC._i_(c*v):-2===p&&-2!==u?ZC._i_((c-u)*v):-2!==p&&-2===u?ZC._i_((c-p)*v):ZC._i_((c-p-u)*v),-1!==l.iX?(l.DV=l.iX-o,l.E6=o+c-l.DV-l.I):-2===p&&-2===u?(l.DV=l.E6=(c-l.I)/2,l.iX=o+l.DV):-2===p&&-2!==u?(l.E6=u,l.DV=c-l.E6-l.I,l.iX=o+l.DV):(l.DV=p,l.iX=o+l.DV,l instanceof ZC.DS?l.E6=u:l.E6=c-l.DV-l.I)}else-1!==l.iX?(l.DV=l.iX-o,l.E6=-2===u?0:u,l.I=c-l.DV-l.E6):-2===p&&-2===u?(l.DV=l.E6=0,l.iX=o+l.DV,l.I=c-l.DV-l.E6):-2===p&&-2!==u?(l.E6=u,l.DV=0,l.iX=o+l.DV,l.I=c-l.DV-l.E6):-2!==p&&-2===u?(l.DV=p,l instanceof ZC.DS?l.E6=u:l.E6=0,l.iX=o+l.DV,l.I=c-l.DV-l.E6):(l.DV=p,l.E6=u,l.iX=o+l.DV,l.I=c-l.DV-l.E6);if(null!==(t=ZC._n_(l.o.height))){var D=ZC._p_(t);m=-1!==(""+t).indexOf("%"),l.F=D>1&&!m?ZC._i_(D):-2===C&&-2===d?ZC._i_(h*D):-2===C&&-2!==d?ZC._i_((h-d)*D):-2!==C&&-2===d?ZC._i_((h-C)*D):ZC._i_((h-C-d)*D),-1!==l.iY?(l.E5=l.iY-s,l.DP=s+h-l.E5-l.F):-2===C&&-2===d?(l.E5=l.DP=(h-l.F)/2,l.iY=s+l.E5):-2===C&&-2!==d?(l.DP=d,l.E5=h-l.DP-l.F,l.iY=s+l.E5):(l.E5=C,l.iY=s+l.E5,l instanceof ZC.DS?l.DP=d:l.DP=h-l.E5-l.F)}else-1!==l.iY?(l.E5=l.iY-s,l.DP=-2===d?0:d,l.F=h-l.E5-l.DP):-2===C&&-2===C?(l.E5=l.E5=0,l.iY=s+l.E5,l.F=h-l.E5-l.DP):-2===C&&-2!==d?(l.DP=d,l.E5=0,l.iY=s+l.E5,l.F=h-l.E5-l.DP):-2===C&&-2!==d?(l.E5=C,l instanceof ZC.DS?l.DP=d:l.DP=0,l.iY=s+l.E5,l.F=h-l.E5-l.DP):(l.E5=C,l.DP=d,l.iY=s+l.E5,l.F=h-l.E5-l.DP);if(null!==(t=ZC._n_(l.o.position))){if(l.A&&"undefined"!=typeof l.A.iX&&"undefined"!=typeof l.A.iY&&"undefined"!=typeof l.A.I&&"undefined"!=typeof l.A.F){switch(n=0,a=0,(r=String(t).split(/\s+/))[0]){case"left":n=0;break;case"right":n=1;break;case"center":n=.5;break;default:(n=ZC.IH(r[0]))>1&&(n/=l.A.I)}switch(r[1]){case"top":a=0;break;case"bottom":a=1;break;case"middle":a=.5;break;default:(a=ZC.IH(r[1]))>1&&(a/=l.A.F)}}l.D["position-info"]=[n,a],l.iX=l.A.iX+ZC._i_(n*(l.A.I-l.I-b[1]-b[3]))+b[3],l.iY=l.A.iY+ZC._i_(a*(l.A.F-l.F-b[0]-b[2]))+b[0]}l.D1=[l.iX,l.iY,l.iX+l.I,l.iY+l.F]}}},parse:function(){this.b();var e,t=this;if(!t.o.tween){if(t.assign_a([["anchor","WG"],["rect-shortcut","FA","b"],["center-ref","A75","b"],["callout","KP","b"],["callout-type","ACM"],["callout-position","ES"],["callout-hook","DM"],["callout-ratio","XD"],["callout-width","H6","i"],["callout-height","G3","i"],["callout-offset","EV","i"],["callout-extension","M1","i"],["border-top","PQ"],["border-right","OC"],["border-bottom","NL"],["border-left","P6"]]),null!==(e=ZC._n_(t.o["border-radius"]))){var i=String(e).split(/\s+|;|,/);2===i.length?(t.F5=t.FQ=ZC._i_(i[0]),t.F2=t.FB=ZC._i_(i[1])):4===i.length?(t.F5=ZC._i_(i[0]),t.FQ=ZC._i_(i[1]),t.F2=ZC._i_(i[2]),t.FB=ZC._i_(i[3])):t.F5=t.FQ=t.F2=t.FB=ZC._i_(i[0])}null!==ZC._n_(t.o["callout-tip"])&&(t.OF=new ZC.DW(t.A)),t.assign_a([["border-radius-top-left","F5","i"],["border-radius-top-right","FQ","i"],["border-radius-bottom-right","F2","i"],["border-radius-bottom-left","FB","i"]])}},WK:function(e){var t=e.split(/\s/);return t[0]=ZC._i_(t[0]),t[2]=ZC.AP.G5(t[2]),t},paint:function(){var e=this;if(null!==e.DM&&!(e.DM instanceof Array)&&"zcgraph"===e.A.O4){var t=e.A.UV(e.DM);e.DM=[t[0],t[1]],e.DM[0]-=e.BJ,e.DM[1]-=e.BH}if(e.A75&&(e.iX-=e.I/2,e.iY-=e.F/2),"-1"!==e.BV&&0!==e.AT||e.PQ+e.OC+e.NL+e.P6!==""||"-1"!==e.A0||"-1"!==e.AE||""!==e.D9||""!==e.GQ||""!==e.HJ){var i=e.H.AC;e.M4&&e.C6&&e.A9U();var n,a={x:"iX",y:"iY",width:"I",height:"F"};if(e.o["bottom-state"]&&!e.Y3&&!e.bIsBottom&&!e.VV){var r=new ZC.HS(e.A);r.copy(e),r.bIsBottom=!0,r.M4=!1,r.Z=e.Z,r.WG=e.WG,r.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY,width:e.I,height:e.F}),r.append(e.o["bottom-state"]),r.K=e.K+"-bottom",r.parse(),r.setAnchor(),!1;for(n in a)null===ZC._n_(r.o[n])||-1===(""+r.o[n]).indexOf("+")&&-1===(""+r.o[n]).indexOf("-")||(r[a[n]]=e[a[n]]+ZC._i_(r.o[n]),!0);r.paint()}if(e.PQ+e.OC+e.NL+e.P6===""){switch(i){case"canvas":e.A1D();break;case"svg":e.W6();break;case"vml":e.W5()}if(e.KP&&e.OF){var l,o;if(e.DM&&2===e.DM.length?(l=e.DM[0],o=e.DM[1]):e.D.cp&&(l=e.D.cp[0],o=e.D.cp[1]),e.OF.Z=e.OF.C6=e.Z,e.OF.copy(e),e.OF.append(e.o["callout-tip"]),e.OF.K=e.K+"-callout-tip",e.OF.o.x=l,e.OF.o.y=o,e.D.cm){var s=e.D.cm[0],c=e.D.cm[1],h=Math.atan2(ZC._i_(c)-ZC._i_(o),ZC._i_(s)-ZC._i_(l));isNaN(h)&&(h=0),null===ZC._n_(e.OF.o.angle)&&(e.OF.o.angle=ZC.TO(h))}e.OF.parse(),e.OF.paint()}}else{var C=e.AT,u=e.BV,d=e.G9;switch(e.AT=0,i){case"canvas":e.A1D();break;case"svg":e.W6();break;case"vml":e.W5()}e.AT=C;var p=e.A0,A=e.AE;e.A0=e.AE="-1";for(var g,f=["top","right","bottom","left"],Z=["PQ","OC","NL","P6"],_=0;_<f.length;_++)if(""!==(g=e[Z[_]])&&"none"!==g){var b=e.WK(g);switch(e.AT=b[0],e.G9=b[1],e.BV=b[2],i){case"canvas":e.A1D(f[_]);break;case"svg":e.W6(f[_]);break;case"vml":e.W5(f[_])}e.AT=C,e.BV=u,e.G9=d}e.A0=p,e.AE=A}if(e.o["top-state"]&&!e.Y3&&!e.VV&&!e.bIsBottom){var m=new ZC.HS(e.A);m.copy(e),m.VV=!0,m.M4=!1,m.Z=e.Z,m.WG=e.WG,m.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY,width:e.I,height:e.F}),m.append(e.o["top-state"]),m.K=e.K+"-top",m.parse(),m.setAnchor(),!1;for(n in a)null===ZC._n_(m.o[n])||-1===(""+m.o[n]).indexOf("+")&&-1===(""+m.o[n]).indexOf("-")||(m[a[n]]=e[a[n]]+ZC._i_(m.o[n]),!0);m.paint()}}},setAnchor:function(){var e=this;switch(e.WG){case"tl":break;case"tr":e.iX-=e.I;break;case"bl":e.iY-=e.F;break;case"br":e.iX-=e.I,e.iY-=e.F;break;case"c":e.iX-=e.I/2,e.iY-=e.F/2;break;case"t":e.iX-=e.I/2;break;case"r":e.iX-=e.I,e.iY-=e.F/2;break;case"b":e.iX-=e.I/2,e.iY-=e.F;break;case"l":e.iY-=e.F/2}},A9U:function(){var e=this,t=new ZC.HS(e.A);t.K=e.K+"-sh",t.copy(e),t.Z=e.C6,t.M4=!1,t.Y3=!0,t.PQ=t.OC=t.NL=t.P6="",t.A0=t.AE=t.RQ,t.GQ=t.HJ="",t.D9="",t.G9="solid",t.BV=t.RQ,t.B0=0;var i=e.JP*ZC.EF(e.OE),n=e.JP*ZC.EO(e.OE);t.I=e.I+("vml"===e.H.AC?0:.5)-ZC.EF(e.OE)*e.P1/2,t.F=e.F+("vml"===e.H.AC?0:.5)-ZC.EO(e.OE)*e.P1/2,t.NQ=t.C5=t.SU*e.C5,t.K=e.K+"-sh",t.iX=e.iX+ZC._i_(i),t.iY=e.iY+ZC._i_(n),t.paint()},Y6:function(e){var t,i=this,n=i.iX,a=i.iY,r=n+i.I/2,l=a+i.F/2,o=i.W4,s=i.W2;if(ZC._a_(o)<=1&&(o=o*i.I/2),ZC._a_(s)<=1&&(s=s*i.F/2),r+=o,l+=s,"radial"===e){var c=ZC._i_((i.I+i.F)/2),h=ZC.CY(i.I,i.F);return t=h<c/4?(h+c)/2:h,{cx:r,cy:l,r:ZC._a_(t)}}if("linear"===e){var C=(t=i.I>=i.F?ZC._a_(ZC.EO(i.N8))>.5?i.F/2:i.I/2:ZC._a_(ZC.EF(i.N8))>.5?i.I/2:i.F/2)*ZC.EF(i.N8),u=t*ZC.EO(i.N8);return{x1:r-C,y1:l-u,x2:r+C,y2:l+u}}},VI:function(e){var t,i=this;void 0===e&&(e="all");var n,a,r=i.iX,l=i.iY;i.E=[],n=a=i.AT/2;var o=1;switch(i.H.AC){case"vml":o=2,i.AT%2==1&&(n=ZC._i_((i.AT-1)/2),a=ZC._i_((i.AT+1)/2))}var s=null,c=ZC._x_(r+n,2),h=ZC._x_(r-a,2),C=ZC._x_(l+n,2),u=ZC._x_(l-a,2),d=i.DM&&2===i.DM.length,p=ZC._i_(i.EV*(i.I-i.H6)/100),A=ZC._i_(i.EV*(i.F-i.G3)/100),g=0!==i.F5||0!==i.FQ||0!==i.F2||0!==i.FB,f=i.XD[0],Z=i.XD[1];switch(i.ES){case"top":i.D.cm=[i.iX+i.I/2+p,i.iY];break;case"bottom":i.D.cm=[i.iX+i.I/2+p,i.iY+i.F];break;case"left":i.D.cm=[i.iX,i.iY+i.F/2+A];break;case"right":i.D.cm=[i.iX+i.I,i.iY+i.F/2+A]}if(g){var _,b=ZC.CY(i.I/2,i.F/2);"top"!==e&&"all"!==e||(0!==i.F5?(_=i.I/2>=i.F5&&i.F/2>=i.F5?ZC._a_(i.F5):b,i.E.push([c,C+_]),i.F5>0&&i.E.push([c,C,c+o*_,C]),i.E.push([c+_,C])):i.E.push([c,C]),i.KP&&"top"===i.ES&&(i.E.push([c+i.I/2-f*i.H6/2-i.AT/2+p,C]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[c+i.I/2-i.AT/2+p,C-i.G3],i.E.push(s)),i.M1>0&&(t=i.E[i.E.length-1],i.E.push([t[0],t[1]-i.M1*(i.G3>0?1:-1)]),i.E.push([t[0],t[1]])),i.E.push([c+i.I/2-i.AT/2+Z*i.H6/2+p,C])),"top"===e&&(0!==i.FQ?(_=i.I/2>=i.FQ&&i.F/2>=i.FQ?ZC._a_(i.FQ):b,i.E.push([h+i.I-_,C])):i.E.push([h+i.I,C]))),"right"!==e&&"all"!==e||(0!==i.FQ?(_=i.I/2>=i.FQ&&i.F/2>=i.FQ?ZC._a_(i.FQ):b,i.E.push([h+i.I-_,C]),i.FQ>0?i.E.push([h+i.I,C,h+i.I,C+o*_]):i.E.push([h+i.I,C+_])):i.E.push([h+i.I,C]),i.KP&&"right"===i.ES&&(i.E.push([h+i.I,C+i.F/2-f*i.G3/2-i.AT/2+A]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[h+i.I+i.H6,C+i.F/2-i.AT/2+A],i.E.push(s)),i.E.push([h+i.I,C+i.F/2+Z*i.G3/2-i.AT/2+A])),"right"===e&&(0!==i.F2?(_=i.I/2>=i.F2&&i.F/2>=i.F2?ZC._a_(i.F2):b,i.E.push([h+i.I,u+i.F-_])):i.E.push([h+i.I,u+i.F]))),"bottom"!==e&&"all"!==e||(0!==i.F2?(_=i.I/2>=i.F2&&i.F/2>=i.F2?ZC._a_(i.F2):b,i.E.push([h+i.I,u+i.F-_]),i.F2>0?i.E.push([h+i.I,u+i.F,h+i.I-o*_,u+i.F]):i.E.push([h+i.I-_,u+i.F])):i.E.push([h+i.I,u+i.F]),i.KP&&"bottom"===i.ES&&(i.E.push([h+i.I/2+f*i.H6/2+i.AT/2+p,u+i.F]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[h+i.I/2+i.AT/2+p,u+i.F+i.G3],i.E.push(s)),i.M1>0&&(t=i.E[i.E.length-1],i.E.push([t[0],t[1]+i.M1*(i.G3>0?1:-1)]),i.E.push([t[0],t[1]])),i.E.push([h+i.I/2-Z*i.H6/2+i.AT/2+p,u+i.F])),"bottom"===e&&(0!==i.FB?(_=i.I/2>=i.FB&&i.F/2>=i.FB?ZC._a_(i.FB):b,i.E.push([c+_,u+i.F])):i.E.push([c,u+i.F]))),"left"!==e&&"all"!==e||(0!==i.FB?(_=i.I/2>=i.FB&&i.F/2>=i.FB?ZC._a_(i.FB):b,i.E.push([c+_,u+i.F]),i.FB>0?i.E.push([c,u+i.F,c,u+i.F-o*_]):i.E.push([c,u+i.F-_])):i.E.push([c,u+i.F]),i.KP&&"left"===i.ES&&(i.E.push([c,u+i.F/2+f*i.G3/2+i.AT/2+A]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[c-i.H6,u+i.F/2+i.AT/2+A],i.E.push(s)),i.E.push([c,u+i.F/2-Z*i.G3/2+i.AT/2+A])),0!==i.F5?(_=i.I/2>=i.F5&&i.F/2>=i.F5?ZC._a_(i.F5):b,i.E.push([c,C+_])):(i.E.push([c,C]),i.E.push([c+.1,C])))}else"top"!==e&&"all"!==e||(i.E.push([c,C]),i.KP&&"top"===i.ES&&(i.E.push([c+i.I/2-f*i.H6/2-i.AT/2+p,C]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[c+i.I/2-i.AT/2+p,C-i.G3],i.E.push(s)),i.M1>0&&(t=i.E[i.E.length-1],i.E.push([t[0],t[1]-i.M1*(i.G3>0?1:-1)]),i.E.push([t[0],t[1]])),i.E.push([c+i.I/2+Z*i.H6/2-i.AT/2+p,C])),"top"===e&&i.E.push([h+i.I,C])),"right"!==e&&"all"!==e||(i.E.push([h+i.I,C]),i.KP&&"right"===i.ES&&(i.E.push([h+i.I,C+i.F/2-i.AT/2-f*i.G3/2+A]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[h+i.I+i.H6,C+i.F/2-i.AT/2+A],i.E.push(s)),i.E.push([h+i.I,C+i.F/2-i.AT/2+Z*i.G3/2+A])),"right"===e&&i.E.push([h+i.I,u+i.F])),"bottom"!==e&&"all"!==e||(i.E.push([h+i.I,u+i.F]),i.KP&&"bottom"===i.ES&&(i.E.push([h+i.I/2+f*i.H6/2+i.AT/2+p,u+i.F]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[h+i.I/2+i.AT/2+p,u+i.F+i.G3],i.E.push(s)),i.M1>0&&(t=i.E[i.E.length-1],i.E.push([t[0],t[1]+i.M1*(i.G3>0?1:-1)]),i.E.push([t[0],t[1]])),i.E.push([h+i.I/2-Z*i.H6/2+i.AT/2+p,u+i.F])),"bottom"===e&&i.E.push([c,u+i.F])),"left"!==e&&"all"!==e||(i.E.push([c,u+i.F]),i.KP&&"left"===i.ES&&(i.E.push([c,u+i.F/2+i.AT/2+f*i.G3/2+A]),d?i.E.push([i.DM[0],i.DM[1]]):(s=[c-i.H6,u+i.F/2+i.AT/2+A],i.E.push(s)),i.E.push([c,u+i.F/2+i.AT/2-Z*i.G3/2+A])),i.E.push([c,C]),i.E.push([c+.1,C]));s&&(i.D.cp=s)},A1D:function(e){e=e||"all";var t,i,n,a=this,r=a.Z.getContext("2d");r.save(),r.globalCompositeOperation=a.A0M;var l=a.iX,o=a.iY,s=a.A1N(),c=s.bc,h=s.bgc1,C=s.bgc2;if("all"===e)if(h!==C||""!==a.GQ&&""!==a.HJ){var u=a.Y6(a.NE);"radial"===a.NE?t=r.createRadialGradient(u.cx,u.cy,1,u.cx,u.cy,u.r):"linear"===a.NE&&(u.x1=isNaN(u.x1)?0:u.x1,u.x2=isNaN(u.x2)?0:u.x2,u.y1=isNaN(u.y1)?0:u.y1,u.y2=isNaN(u.y2)?0:u.y2,t=r.createLinearGradient(u.x1,u.y1,u.x2,u.y2)),""!==a.GQ&&""!==a.HJ?a.ZB(t):(t.addColorStop(0,h),t.addColorStop(1,C)),r.fillStyle=t}else""!==a.D9&&-1!==ZC.AV(["repeat","true",!0],a.LZ)&&"-1"===a.A0&&"-1"===a.AE&&(h="rgba(255,255,255,0)"),r.fillStyle=h;r.strokeStyle=c,r.lineWidth=a.AT,r.translate(a.BJ,a.BH),0!==a.AA&&(r.translate(l+a.I/2,o+a.F/2),r.rotate(ZC.SZ(a.AA)),r.translate(-(l+a.I/2),-(o+a.F/2))),r.beginPath(),a.VI(e);var d=a.F5+a.FQ+a.F2+a.FB!==0;n=a.B0,a.B0=a.AT;var p=a.G9;if(a.G9="",a.KV(),ZC.CS.contour(r,a,a.E),a.B0=n,a.G9=p,a.KV(),"all"===e)if(""!==a.D9&&-1===ZC.AV(ZC.IMG404,a.D9)){r.fill(),r.save(),r.clip();var A=r.globalAlpha;r.globalAlpha=a.C5;var g=a.RA(),f=g.image;switch(a.LZ){default:r.translate(a.iX,a.iY),i=r.createPattern(f,"repeat"),r.fillStyle=i,r.fill(),r.translate(-g.x,-g.y);break;case"no-repeat":case"false":case!1:r.drawImage(f,g.x-a.BJ,g.y-a.BH,a.D["bg-image-width"],a.D["bg-image-height"])}r.globalAlpha=A,r.restore()}else r.fill();if(a.AT>0){var Z=a.B7;n=a.B0,a.B7=a.BV,a.B0=a.AT,a.KV(),ZC.CS.setup(r,a),a.SW=d?"round":"square",a.EX+a.G6>0&&(a.SW="butt"),a.ZT=d?"round":"miter",a.D["skip-top"]=!0,a.D.border=e,ZC.CS.paint(r,a,a.E,!0),a.B7=Z,a.B0=n,a.KV()}r.closePath(),r.restore()},W6:function(e){e=e||"all";var t=this,i=t.Z;t.D.fill=-1;var n=!1;if("all"===e){if(""!==t.D9&&-1===ZC.AV(ZC.IMG404,t.D9)){var a=t.RA();t.A28({info:a,x:t.iX,y:t.iY}),n=!0}t.WP()}if(t.VI(e),n&&"repeat"!==t.LZ&&(t.A0S(),t.KP)){var r=0,l=0;t.D1[1]<t.iY&&(l=t.D1[3]-t.D1[1]-t.F),t.D1[0]<t.iX&&(r=t.D1[2]-t.D1[0]-t.I),null===ZC._n_(t.D["pattern-tx"])?t.D["pattern-tx"]=r:t.D["pattern-tx"]+=r,null===ZC._n_(t.D["pattern-ty"])?t.D["pattern-ty"]=l:t.D["pattern-ty"]+=l,ZC.Q.G2(ZC.AK(t.D["pattern-image-id"]),{transform:"translate("+t.D["pattern-tx"]+","+t.D["pattern-ty"]+")"})}var o=t.F5+t.FQ+t.F2+t.FB!==0;t.D.cx=t.iX+t.I/2,t.D.cy=t.iY+t.F/2,t.VC&&t.A3L();var s=t.B7,c=t.B0;t.B7=t.BV,t.B0=t.AT,t.KV(),ZC.CS.setup(i,t),t.SW=o?"round":"square",t.EX+t.G6>0&&(t.SW="butt"),t.ZT=o?"round":"miter";var h=!1;ZC.A4.browser.msie||!t.FA||t.KP||""!==t.PQ||""!==t.OC||""!==t.NL||""!==t.P6||0!==t.F5||0!==t.FQ||0!==t.F2||0!==t.FB||(h=!0),t.D["skip-top"]=!0,t.D.border=e,ZC.CS.paint(i,t,t.E,!0,null,h),t.B7=s,t.B0=c,t.KV()},W5:function(e){e=e||"all";var t=this,i=t.Z;if("all"===e){var n=ZC.Q.F4("zcv:fill");if(""!==t.D9&&-1===ZC.AV(ZC.IMG404,t.D9)){var a=t.RA(),r=a.image;switch(t.LZ){default:n.type="tile",n.src=t.D9,ZC.Q.G2(n,{position:a.cx+","+a.cy,opacity:t.C5,"o:opacity2":t.C5}),t.D.imgfill=[n];break;case"no-repeat":case"false":case!1:t.D.imgfill=[r,a.x,a.y]}}t.WQ("0.5,0.5")}var l=ZC.Q.F4("zcv:stroke");switch(l.weight=t.AT+"px",l.color=t.BV,l.opacity=t.C5,t.G9){case"solid":l.dashstyle="solid";break;case"dotted":l.dashstyle="dot";break;case"dashed":l.dashstyle="dash"}t.D.stroke=l,t.VI(e);var o=t.F5+t.FQ+t.F2+t.FB!==0;t.D.cx=t.iX+t.I/2,t.D.cy=t.iY+t.F/2;var s=t.B7,c=t.B0;t.B7=t.BV,t.B0=t.AT,t.KV(),ZC.CS.setup(i,t),t.SW=o?"round":"square",t.EX+t.G6>0&&(t.SW="butt"),t.ZT=o?"round":"miter",t.D.border=e,ZC.CS.paint(i,t,t.E,"all"===e),t.B7=s,t.B0=c,t.KV()}}),ZC.DS=ZC.HS.C7({$i:function(e){this.b(e);var t=this;t.IK=null,t.GJ="",t.AR=null,t.OB="center",t.JU="middle",t.DK=zingchart.FONTSIZE,t.GD=zingchart.FONTFAMILY,t.C1="#000",t.A90=!1,t.N1=!1,t.QM=!1,t.K4="none",t.sFontWeight="normal",t.Y1=0,t.FJ=2,t.FK=2,t.FR=2,t.EP=2,t.A8D=!1,t.A21=!1,t.FF=-1,t.KK=0,t.NH=0,t.OJ=ZC.MAX,t.bRTL=!1,t.A17=!0,t.WJ=zingchart.FASTWIDTH,t.A5X=1.65,t.UX=1,t.VM=!1,t.A8=null,t.V2=!1,t.A4K=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"textAlign,verticalAlign,fontSize,fontFamily,color,bold,fontWeight,italic,underline,textDecoration,paddingTop,paddingRight,paddingBottom,paddingLeft,text","OB,JU,DK,GD,C1,A90,sFontWeight,N1,QM,K4,FJ,FK,FR,EP,AR"),e},copy:function(e){this.b(e);for(var t=this,i="OB,JU,DK,GD,C1,A90,sFontWeight,N1,K4,QM,FJ,FK,FR,EP,AR".split(","),n=0,a=i.length;n<a;n++)"undefined"!=typeof e[i[n]]&&(t[i[n]]=e[i[n]])},KE:function(e){return e},isBold:function(e){return"bold"===e||"bolder"===e||"500"===e||"600"===e||"700"===e||"800"===e||"900"===e},cwidth:function(e){var t=this;if(t.WJ)return e.replace(/(<([^>]+)>)/gi,"").length*t.DK/(t.A5X*(t.isBold(t.sFontWeight)?.87:1)*(t.N1?.95:1));var i="";return"undefined"!=typeof t.o["html-mode"]&&ZC._b_(t.o["html-mode"])&&(i="[HTMLMODE]"),ZC.Q.A3Y(this.H.K,i+e,this.GD,this.DK,this.sFontWeight,this.FF)},parse:function(){this.I=this.F=this.NH=this.KK=0,this.b();var e,t,i,n,a,r=this;if(!r.o.tween){if(r.Z5("text","AR"),null!==ZC._n_(r.AR)&&(r.AR=""+r.AR,r.AR=r.KE(r.AR),r.AR=r.AR.replace(/\n/g,"<br>").replace(/\\n/g,"<br>"),"svg"===r.H.AC&&(r.AR=r.AR.replace(/&nbsp;/g," "))),r.assign_a([["overlap","A17","b"],["fast-width","WJ","b"],["max-width","OJ","i"],["line-height","FF","i"],["width-ratio","A5X","f"],["wrap-text","A21","b"],["clip-text","A8D","b"],["bold","A90","b"],["italic","N1","b"],["underline","QM","b"],["text-decoration","K4"],["rtl","bRTL","b"],["text-align","OB"],["align","OB"],["vertical-align","JU"],["font-size","DK","f"],["max-chars","Y1","i"],["font-family","GD"],["font-angle","AA","i"],["color","C1","c"],["font-color","C1","c"],["text-alpha","UX","f",0,1],["lock-rotation","V2","b"]]),r.DK=ZC.BQ(1,r.DK),null===ZC._n_(r.o["text-alpha"])&&(r.UX=r.C5),r.A90&&(r.sFontWeight="bold"),null!==(e=ZC._n_(r.o["font-weight"]))&&(r.sFontWeight=e),null===ZC._n_(r.o["text-decoration"])&&(r.K4=r.QM?"underline":"none"),null!==(e=ZC._n_(r.o["font-style"]))&&(r.N1="italic"===e||"oblique"===e),null!==(e=ZC._n_(r.o.padding))){var l=String(e).split(/\s+|;|,/);t=1===l.length?[ZC._i_(l[0]),ZC._i_(l[0]),ZC._i_(l[0]),ZC._i_(l[0])]:2===l.length?[ZC._i_(l[0]),ZC._i_(l[1]),ZC._i_(l[0]),ZC._i_(l[1])]:3===l.length?[ZC._i_(l[0]),ZC._i_(l[1]),ZC._i_(l[2]),ZC._i_(l[0])]:[ZC._i_(l[0]),ZC._i_(l[1]),ZC._i_(l[2]),ZC._i_(l[3])],r.FJ=t[0],r.FK=t[1],r.FR=t[2],r.EP=t[3]}if(r.assign_a([["padding-top","FJ","i"],["padding-right","FK","i"],["padding-bottom","FR","i"],["padding-left","EP","i"]]),r.AR){r.Y1>0&&r.AR.length>r.Y1&&(r.AR=r.AR.substring(0,r.Y1)+"...");var o=r.AR.split(/<br>|<br\/>|<br \/>|\n/),s="";"undefined"!=typeof r.o["html-mode"]&&ZC._b_(r.o["html-mode"])&&(o=[r.AR],s="[HTMLMODE]");o.length;for(r.KK=ZC.Q.A3Y(this.H.K,s+r.AR,this.GD,this.DK,this.sFontWeight,this.FF,!0)+r.FJ+r.FR,i=0,n=o.length;i<n;i++)r.NH=ZC.BQ(r.NH,r.cwidth(o[i])+r.EP+r.FK)}else r.AR="",r.NH=ZC._i_(1.25*r.DK),r.KK=-1===r.FF?ZC._i_(1.25*r.DK):r.FF;if((null===ZC._n_(r.o.width)||isNaN(r.I)||0===r.I)&&(r.I=r.NH),(null===ZC._n_(r.o.height)||isNaN(r.F)||0===r.F)&&(r.F=r.KK),r.I=ZC.CY(r.I,r.OJ),r.A21&&r.NH>r.I&&!r.D.wrapped&&r.I>2*r.DK){var c,h="",C=0,u=r.AR.replace(/<br>/gi," [##] ").split(/\s|<br>/),d=[];for(i=0,n=u.length;i<n;i++)if((c=r.cwidth(u[i]))>.9*r.I){var p=Math.ceil(c/r.I*.9),A=Math.ceil(u[i].length/p);for(a=0;a<p;a++)d.push(u[i].substr(a*A,A))}else d.push(u[i]);for(i=0,n=d.length;i<n;i++)""!==d[i]&&("[##]"===d[i]?(h+="<br>",C=0):(C+=c=1+r.cwidth(d[i]+" "))>.9*r.I?(i>0&&(h+="<br>"),h+=d[i]+" ",C=c):h+=d[i]+" ");h=(h=h.replace(/<br><br>/g,"<br>").replace(/ <br> <br>/g," <br>")).replace(/(.+?)<br> $/g,"$1");var g=r.o.text;r.o.text=h,r.D.wrapped=!0,r.parse(),r.o.text=g,r.D.wrapped=!1}if("canvas"!==r.H.AC&&(r.AR=r.AR.replace(/&lt;/g,"<").replace(/&gt;/g,">")),!(null!==ZC._n_(r.o.width)&&null!==ZC._n_(r.o.height)||null===ZC._n_(r.o.position)&&null===ZC._n_(r.o.margin)&&null===ZC._n_(r.o["margin-top"])&&null===ZC._n_(r.o["margin-right"])&&null===ZC._n_(r.o["margin-bottom"])&&null===ZC._n_(r.o["margin-left"]))){r.iX=-1,r.iY=-1;var f=r.o.width,Z=r.o.height;null===ZC._n_(f)&&(r.o.width=r.I),null===ZC._n_(Z)&&(r.o.height=r.F),r.locate(),r.o.width=f,r.o.height=Z}if("undefined"==typeof r.o["html-mode"]||!r.o["html-mode"]){var _=Math.ceil((r.NH-r.EP-r.FK)/r.DK);_>0&&(r.AR=r.AR.replace(/<hr>/g,new Array(_).join("\u2014")))}}r.setAnchor()},paint:function(){var e,t,i,n,a,r,l,o,s,c,h,C=this;if(!C.VM&&!C.A17){var u=!0;null!==ZC._n_(C.o.flexible)&&(u=ZC._b_(C.o.flexible));var d,p,A={x:C.iX+C.EP-1,y:C.iY+C.FJ-1,width:C.I-C.EP-C.FK+2,height:C.F-C.FJ-C.FR+2,type:C.D.lbltype||""},g=[[0,0]];for(u&&(g=[[0,0],[0,2],[0,-4],[0,4],[0,-8],[3,0],[-6,0],[5,0],[-10,0]]),p=0;p<g.length;p++){for(d=!0,A.x+=g[p][0],A.y+=g[p][0],a=0,r=C.H.SP.length;a<r;a++)ZC.AO.XI(A,C.H.SP[a],-2)&&(d=!1);if(d){C.iX=A.x,C.iY=A.y;break}}if(!d)return;C.H.SP.push(A)}var f=C.H.AC;if(e=ZC.Q.E9(C.Z,f),C.VM||C.b(),!C.A4K&&(C.o.width||!(C.I-C.EP-C.FK<2))&&(C.o.height||!(C.KK-C.FJ-C.FR<2))){var Z=C.AA%360==0?"0":"";if((C.VM||zingchart.CANVASTEXT&&"canvas"===f)&&(Z=""),ZC.vml&&"svg"===f&&""===C.GJ&&(C.GJ=C.K+"-class"),!C.VM&&ZC.AK(C.K)&&(f="_",ZC.objmove))return ZC.AK(C.K).style.top=C.iY+C.BH+"px",void(ZC.AK(C.K).style.left=C.iX+C.BJ+"px");var _="undefined"!=typeof C.D["html-mode"]&&C.D["html-mode"],b=_;"undefined"!=typeof C.o["html-mode"]&&(_=ZC._b_(C.o["html-mode"]));var m=[C.AR];_||(m=C.AR.split(/<br>|<br\/>|<br \/>|\n/)),_&&!b&&"svg"===f&&"0"===Z&&(Z="0html");var v,D,E,w,B,K,F,x,y,I,z,H,M,S,k,X,T,P,N,O,Y,L,Q=C.IK?C.IK:C.Z.parentNode;switch(f+Z){case"canvas0":case"vml0":case"svg0html":if(n=1,!_)switch(C.JU){case"middle":n+=(C.F-C.KK)/2;break;case"bottom":n+=C.F-C.KK}if(l=ZC.Q.HX({id:C.K,cls:C.GJ,tl:ZC._x_(C.iY+C.BH)+"/"+ZC._x_(C.iX+C.BJ),wh:C.I+"/"+C.F,position:"absolute",padding:0,margin:0,overflow:_?"visible":"hidden",textAlign:C.OB}),_&&(b||f+Z!=="svg0html"||(Q=ZC.AK(C.H.K+"-top")),Q.appendChild(l)),ZC.Q.HX({id:C.K+"-t",cls:""!==C.GJ?C.GJ+"-t":"",p:l,width:C.I-C.EP-C.FK,height:_?null:C.KK-C.FJ-C.FR,tl:n+"/0",html:C.AR+"",position:"absolute",whiteSpace:"nowrap",opacity:C.UX,color:C.C1,fontWeight:C.sFontWeight,fontStyle:C.N1?"oblique":"normal",textDecoration:C.K4,fontSize:C.DK,fontFamily:C.GD,marginTop:C.FJ,marginRight:C.FK,marginBottom:C.FR,marginLeft:C.EP,verticalAlign:C.JU,textAlign:C.OB,lineHeight:-1===C.FF?"125%":C.FF+"px",rtl:C.bRTL,padding:0}),C.D["css-display"]&&(l.style.display=C.D["css-display"],C.D["css-display"]=null),b&&C.H&&C.H.A8&&!C.o.width&&!C.o.height){var R=ZC.A4("#"+C.K+"-t");"canvas"===f&&(ZC.AK(C.H.K+"-tooltip-c").width=R.width()+C.EP+C.FK,ZC.AK(C.H.K+"-tooltip-c").height=R.height()+C.FJ+C.FR),C.H.A8.clear(),C.I=R.width()+C.EP+C.FK,C.F=R.height()+C.FJ+C.FR,C.paint()}break;case"canvas":var G=!1;if(ZC.A4.browser.opera&&C.AA%90==0&&0!==C.AA&&(C.AA+=.5,G=!0),e=C.Z.getContext("2d"),zingchart.DEV.CACHECANVASTEXT&&(ZC.CanvasCache||(ZC.CanvasCache={})),!zingchart.DEV.CACHECANVASTEXT||zingchart.DEV.CACHECANVASTEXT&&!ZC.CanvasCache[C.K]){for(zingchart.DEV.CACHECANVASTEXT&&(ZC.CanvasCache[C.K]=document.createElement("canvas"),ZC.CanvasCache[C.K].width=C.NH,ZC.CanvasCache[C.K].height=C.KK),v=-1===C.FF?0:ZC._x_(C.FF-1.25*C.DK)/2,a=0,r=m.length;a<r;a++)if(""!==ZC.GT(m[a])){switch(t=1===r?C.NH:C.cwidth(m[a])+C.FK+C.EP,D=m[a],E=-1===D.indexOf("<")?D:D.replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,""),i=0,n=0,C.OB){case"center":i+=(C.I-t)/2;break;case"right":i+=C.I-t}switch(C.JU){case"middle":n+=(C.F-C.KK)/2;break;case"bottom":n+=C.F-C.KK}if(w=0,D!==E){for(;K=/<(.+?)>(.*?)<\/(.+?)>/.exec(D);){switch(F="",x="",(c=/(.+?)style=(.+?)(\'|")(.*?)/.exec(K[1]))&&(x=c[2].replace(/\'|"/g,"")),K[3]){case"b":case"strong":F="font-weight:bold";break;case"i":case"em":F="font-style:italic";break;case"u":F="text-decoration:underline"}I='[[span style="'+(""===F?"":F+";")+x+'"]]'+K[2]+"[[/span]]",D=D.replace(K[0],I)}for(z=!1,N=0,O=(K=(D=D.replace(/\[\[/g,"<").replace(/\]\]/g,">").replace(/<span/g,"[[*]]<span").replace(/<\/span>/g,"</span>[[*]]")).split("[[*]]")).length;N<O;N++)if(""!==K[N]){if(o=C.C1,H=C.sFontWeight,M=C.N1,S=C.QM,k=C.DK,X=C.GD,P=C.FF,T=C.K4,B=K[N],h=/<span style=(.+?)>(.+?)<\/(.+?)>/.exec(K[N]))for(B=h[2],Y=0,L=(y=h[1].replace(/\'|"/g,"").split(/;|:/)).length;Y<L-1;Y+=2)switch(ZC.GT(y[Y])){case"font-size":k=ZC._i_(ZC.GT(y[Y+1]));break;case"font-family":X=ZC.GT(y[Y+1]);break;case"font-weight":H=ZC.GT(y[Y+1]);break;case"font-style":-1!==ZC.AV(["italic","oblique"],ZC.GT(y[Y+1]))&&(M=!0);break;case"text-decoration":T=ZC.GT(y[Y+1]);break;case"line-height":P=ZC._i_(ZC.GT(y[Y+1]));break;case"color":o=ZC.AP.G5(ZC.GT(y[Y+1]))}0===a&&(v=-1===P?0:ZC._x_(P-1.25*k)/2);var J={idx:a,ctx:e,i:M,fw:H,fs:k,lh:P,ff:X,c:o,t:B,dx:i,dy:n};J.dy+=ZC._x_(v),J.dy+=z||C.isBold(H)||S?2:0,C.paintCANVASText(J),z=M,w++,i+=ZC.Q.A3Y(this.H.K,B,X,k,H,P)}null!==ZC._n_(P)&&null!==ZC._n_(k)&&(v+=-1===P?1.25*k:P)}else C.paintCANVASText({idx:a,ctx:e,i:C.N1,fw:C.sFontWeight,fs:C.DK,lh:C.FF,ff:C.GD,c:C.C1,t:m[a],dx:i,dy:n+v}),v+=-1===C.FF?1.25*C.DK:C.FF}}else e.drawImage(ZC.CanvasCache[C.K],C.iX+C.BJ,C.iY+C.BH);G&&(C.AA-=.5);break;case"vml":switch(n=0,C.JU){case"top":n-=(C.F-C.KK)/2;break;case"bottom":n+=(C.F-C.KK)/2}var U=ZC.Q.F4("zcv:line"),V=C.iX+C.BJ+C.I/2,W=C.iY+C.BH+C.F/2,j=ZC.EF(C.AA)*(C.I-C.EP-C.FK)/2,q=ZC.EO(C.AA)*(C.I-C.EP-C.FK)/2,$=ZC._i_(V-j-ZC.EF(90-C.AA)*n),ee=ZC._i_(W-q+ZC.EO(90-C.AA)*n),te=ZC._i_(V+j-ZC.EF(90-C.AA)*n),ie=ZC._i_(W+q+ZC.EO(90-C.AA)*n);$===te&&($-=.01,te+=.01),ee===ie&&(ee-=.01,ie+=.01),o=C.C1,0!==C.AA&&C.C5<1&&(o=ZC.AP.QT(o,99*(1-C.C5))),ZC.Q.G2(U,{id:C.K+"-line",from:$+"px,"+ee+"px",to:te+"px,"+ie+"px",fillcolor:o}),U.filled=!0,U.stroked=!1;var ne=ZC.Q.F4("zcv:path");ne.setAttribute("textpathok",!0),U.appendChild(ne);var ae=ZC.Q.F4("zcv:textpath"),re=C.AR.replace(/<br>|<br\/>|<br \/>/gi,"\n").replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,"");ZC.Q.G2(ae,{on:!0,string:re}),ZC.Q.PD(ae,{color:o,fontWeight:C.sFontWeight,fontStyle:C.N1?"oblique":"normal",textDecoration:C.K4,fontSize:C.DK+"px",fontFamily:C.GD,"v-text-align":C.OB}),U.appendChild(ae),e.appendChild(U);break;case"svg":case"svg0":var le=C.iX+C.EP+C.BJ,oe=C.iY+C.FJ+C.BH;if(l=ZC.Q.F4("text","http://www.w3.org/2000/svg"),ZC.Q.G2(l,{x:ZC._x_(le),y:ZC._x_(oe),id:C.K,"class":C.GJ,opacity:C.UX}),C.D["css-display"]&&(l.style.display=C.D["css-display"],C.D["css-display"]=null),C.bRTL&&ZC.Q.G2(l,{"text-anchor":ZC.A4.browser.msie?"":"end","writing-mode":"rl",direction:"rtl","unicode-bidi":"bidi-override"}),C.A8D&&(C.H.K7.appendChild(ZC.Q.XA({id:C.K+"-clip",path:[[C.iX+C.EP+C.AT+C.BJ,C.iY+C.FJ+C.AT+C.BH].join(","),[C.iX+C.I-C.FK-C.AT+C.BJ,C.iY+C.FJ+C.AT+C.BH].join(","),[C.iX+C.I-C.FK-C.AT+C.BJ,C.iY+C.F-C.FR-C.AT+C.BH].join(","),[C.iX+C.EP+C.AT+C.BJ,C.iY+C.F-C.FR-C.AT+C.BH].join(","),[C.iX+C.EP+C.AT+C.BJ,C.iY+C.FJ+C.AT+C.BH].join(",")].join(" ")})),ZC.Q.G2(l,{"clip-path":"url(#"+C.K+"-clip)"})),C.AA%360!=0&&l.setAttribute("transform","rotate("+C.AA+" "+(le+(C.I-C.EP-C.FK)/2)+" "+(oe+(C.F-C.FJ-C.FR)/2)+")"),_&&Q.appendChild(l),_){ZC.Q.EU(C.K+"-float");var se=ZC.Q.F4("div");ZC.Q.PD(se,{position:"absolute",left:0,top:0,width:C.I-C.EP-C.FK+"px",height:C.F-C.FJ-C.FR+"px",color:C.C1,fontSize:C.DK+"px",fontFamily:C.GD,fontWeight:C.sFontWeight,textDecoration:C.K4,textAlign:C.OB,fontStyle:C.N1?"italic":"normal"}),se.id=C.K+"-float",se.className="zc-style zc-html-mode",se.innerHTML=m[0],1===C.o["z-index"]?ZC.AK(C.H.K+"-top").append(se):ZC.AK(C.H.K+"-top").insertBefore(se,ZC.AK(C.H.K+"-img")),b&&C.H&&C.H.A8&&(C.o.width||C.o.height||(C.H.A8.clear(),se.style.width="",se.style.height="",C.I=ZC.A4(se).width()+C.EP+C.FK,C.F=ZC.A4(se).height()+C.FJ+C.FR,C.paint()))}else for(v=-1===C.FF?0:ZC._x_(C.FF-1.25*C.DK)/2,a=0,r=m.length;a<r;a++){switch(t=1===r?C.NH:C.cwidth(m[a])+C.FK+C.EP,D=m[a],E=-1===D.indexOf("<")?D:D.replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,""),i=0,n=C.DK,C.OB){case"center":i=(C.I-t)/2;break;case"right":i=C.I-t}switch(C.JU){case"middle":n+=(C.F-C.KK)/2;break;case"bottom":n+=C.F-C.KK}if(w=0,D!==E){for(;K=/<(.+?)>(.*?)<\/(.+?)>/.exec(D);){switch(F="",x="",(c=/(.+?)style=(.+?)(\'|")(.*?)/.exec(K[1]))&&(x=c[2].replace(/\'|"/g,"")),K[3]){case"b":case"strong":F="font-weight:bold";break;case"i":case"em":F="font-style:italic";break;case"u":F="text-decoration:underline"}I='[[span style="'+(""===F?"":F+";")+x+'"]]'+K[2]+"[[/span]]",D=D.replace(K[0],I)}for(z=!1,N=0,O=(K=(D=D.replace(/\[\[/g,"<").replace(/\]\]/g,">").replace(/<span/g,"[[*]]<span").replace(/<\/span>/g,"</span>[[*]]")).split("[[*]]")).length;N<O;N++)if(""!==K[N]){if(o=C.C1,H=C.sFontWeight,M=C.N1,S=C.QM,k=C.DK,X=C.GD,T=C.K4,P=C.FF,B=K[N],h=/<span style=(.+?)>(.+?)<\/(.+?)>/.exec(K[N]))for(B=h[2],Y=0,L=(y=h[1].replace(/\'|"/g,"").split(/;|:/)).length;Y<L-1;Y+=2)switch(ZC.GT(y[Y])){case"font-size":k=ZC._i_(ZC.GT(y[Y+1]));break;case"font-family":X=ZC.GT(y[Y+1]);break;case"font-weight":H=ZC.GT(y[Y+1]);break;case"font-style":-1!==ZC.AV(["italic","oblique"],ZC.GT(y[Y+1]))&&(M=!0);break;case"text-decoration":T=ZC.GT(y[Y+1]);break;case"line-height":P=ZC._i_(ZC.GT(y[Y+1]));break;case"color":o=ZC.AP.G5(ZC.GT(y[Y+1]))}n=k,s=ZC.Q.F4("tspan","http://www.w3.org/2000/svg"),0===w?(ZC.Q.G2(s,{x:ZC._x_(le+i),y:ZC._x_(oe+n),dy:ZC._x_(v)}),v+=-1===P?1.25*k:ZC.BQ(1.5*k,P)):ZC.Q.G2(s,{dx:z||C.isBold(H)||S?2:0}),ZC.Q.G2(s,{color:o,fill:o}),ZC.Q.PD(s,{fontWeight:H,fontStyle:M?"oblique":"normal",textDecoration:T,fontSize:k+"px",fontFamily:X,dominantBaseline:"auto"});var ce=document.createElement("span");-1!==B.indexOf("<")||-1!==B.indexOf(">")?ce.innerText=B:ce.innerHTML=B,B=ce.innerText||ce.textContent,ce=null,s.textContent=B,l.appendChild(s),z=M,w++}}else C.bRTL&&ZC.A4.browser.msie&&(i+=t-C.EP-C.FK),s=ZC.Q.F4("tspan","http://www.w3.org/2000/svg"),ZC.Q.G2(s,{x:ZC._x_(le+i),y:ZC._x_(oe+n),color:C.C1,fill:C.C1,dy:ZC._x_(v)}),ZC.Q.PD(s,{fontWeight:C.sFontWeight,fontStyle:C.N1?"oblique":"normal",textDecoration:C.K4,fontSize:C.DK+"px",fontFamily:C.GD,dominantBaseline:"auto"}),s.textContent=E,l.appendChild(s),v+=-1===C.FF?1.25*C.DK:C.FF}}_||!C.VM&&l&&Q&&(C.H.FY?(-1!==ZC.Q.SV(Q).indexOf("zc-text")&&null===ZC._n_(C.H.FY[Q.id])&&(C.H.FY[Q.id]=document.createDocumentFragment()),C.H.FY[Q.id]?C.H.FY[Q.id].appendChild(l):Q.appendChild(l)):Q.appendChild(l))}},paintCANVASText:function(e){var t=this,i=e.idx,n=e.ctx,a=e.i,r=e.fw,l=e.fs,o=e.ff,s=e.c,c=e.dx,h=e.dy,C=e.t;n.save(),n.globalAlpha=t.UX;var u="";if(u=(a?"italic":"normal")+" normal "+r+" "+l+"px "+o,n.font=u,n.fillStyle=s,n.textAlign="left",n.textBaseline="alphabetic",n.translate(t.iX+t.BJ,t.iY+t.BH),0!==t.AA&&(n.translate(t.I/2,t.F/2),n.rotate(ZC.SZ(t.AA)),n.translate(-t.I/2,-t.F/2)),n.translate(t.EP,t.FJ+l),n.translate(c,h),n.fillText(C,0,0),zingchart.DEV.CACHECANVASTEXT){var d=ZC.CanvasCache[t.K].getContext("2d");d.font=u,d.fillStyle=s,d.textAlign="left",d.textBaseline="alphabetic",d.fillText(C,t.EP,t.FJ+l+1.25*i*l)}n.restore()},EL:function(e){var t=this;if(ZC.canvas&&"canvas"===t.H.AC&&(e||(e=ZC.AK(t.H.K+"-textprint-c")),!zingchart.CANVASTEXT&&t.AA%360==0)){var i=t.Z;t.Z=e,t.VM=!0;var n=t.H.AC;t.H.AC="canvas",t.paint(),t.VM=!1,t.H.AC=n,t.Z=i}}}),ZC.RG=ZC.HS.C7({$i:function(e){this.b(e);var t=this;t.CI="json",t.NS={graphset:!0,graph:!0,"objects-bottom":!0,"objects-top":!0,maps:!0,plotarea:!0,plots:!0,guide:!0,"static":!0,"value-box":!0},t.A10=!1,t.A0W="en_us",t.QP=null,t.JJ="",t.UA=!1,t.RX={},t.MX="",t.ADI={},t.QB="",t.EW="",t.M6={},t.HM=null,t.AH=[],t.LH="",t.A8=null,t.H9=null,t.D5=null,t.B8=new ZC.AAX(t),t.QN="",t.MM=null,t.NX=[null,null,null,null],t.O3=!1,t.NB="x",t.K5=!1,t.TF=!1,t.ABM=!1,t.A3J=!1,t.GM=!1,t.A9K={},t.NT=null,t.QS={},t.LO=!1,t.QV=!1,t.ACZ=null,t.SN=[],t.N={},t.MT=null,t.DF=null,t.UD=0,t.A1U=0,t.A4Y=1,t.MD=null,t.S8="",t.AAR="F*nStrlng4Cu$tOmLlc9nc9!",t.M9="",t.A0V={},t.A0C=!1,t.AC="",t.K7=null,t.ZM=!1,t.QL=["",""],t.L4=0,t.KM=[],t.A85=0,t.A7D=0,t.A9B=!1,t.A1I="",t.A6E=!0,t.I7=null,t.QQ=[],t.NY=0,t.AAL=!1,t.S6={},t.A13=!1,t.FY=zingchart.DEV.DOMFRAGMENTS?{}:null,t.A27=!1,t.SP=[]},clearLabelBoxes:function(e){var t=this;if(e)for(var i=t.SP.length-1;i>=0;i--)t.SP[i].type===e&&t.SP.splice(i,1);else t.SP=[]},usc:function(){return-1!==ZC.AV(this.KM,"use_single_canvas")},mc:function(e){return e=e||"",ZC.AK(this.K+"-main-c"+(""===e?e:"-"+e))},hideCM:function(){var e;(e=ZC.AK(this.K+"-menu"))&&(e.style.display="none"),this.A9B=!1},ZI:function(){for(var e=this,t=e.NX.length,i=0;i<t;i++)if(null!==ZC._n_(e.NX[i])){switch(e.AC){case"svg":ZC.CS.W6(e.NX[i].ctx,e.NX[i].style,e.NX[i].path.join(" "),e.NX[i].filled);break;case"vml":ZC.CS.W5(e.NX[i].ctx,e.NX[i].style,e.NX[i].path.join(" "),e.NX[i].filled)}e.NX[i]=null}},A8U:function(){function WY(e){if(ZC.NOABOUT&&ZC.NOABOUT instanceof Array){var t=ZC.XL.md5(ZC.A98(ZC.A9T(e)));-1!==ZC.AV(ZC.NOABOUT,t)&&(s.ABM=!0)}}var s=this,i,A7,EY;ZC.LICENSE=ZC.LICENSE||zingchart.LICENSE||"",ZC.BUILDCODE=ZC.BUILDCODE||zingchart.BUILDCODE||"",ZC.LICENSEKEY=ZC.LICENSEKEY||zingchart.LICENSEKEY||"";var A5B;A5B="file:"===document.location.protocol?ZC.HOSTNAME||"":document.location.hostname;var A1L=[A5B],CV=A5B.split(".");for("www"===CV[0]?A1L.push(A5B.replace("www.","")):A1L.push("www."+A5B),i=0;i<=CV.length-2;i++){for(var AB3="*",j=i;j<CV.length;j++)AB3+="."+CV[j];A1L.push(AB3)}if(-1!==ZC.AV(A1L,"localhost")||-1!==ZC.AV(A1L,"127.0.0.1"))s.TF=!0,s.A3J=!0,WY("localhost");else{var A26=[["window.AC.Core.zflags","Q^fhx]XKoJJLnmLPUYiWUuQKAOGnuAIWrSN_ZIj_LYvS`jRkihLOSfysvRQTBtQOUUO^`SdgZUHWKDVQ[xST_SWRLyFKogwOclSB"],["window.jsNorthNine.AppIdentity","09Vczmfsf/Q5G8dRWLio+7PVG0KjUnLRqnRSPOeqf6gu/hpxK6BeHRUtuasojuRTPFQYdzNGN57nxLviTf1hV4lwaFjtbv/tA1g0W0k7AKV1g1ouow1nG/+EJLl0khmPDSKBJa8fkP70KLNtrxt5pE2yjx+IvQ40ajd/03rqqtR="]];for(i=0,A7=A26.length;i<A7;i++)try{if(eval(A26[i][0])===ZC.A9T(A26[i][1])){s.TF=!0;break}}catch(e){}for(i=0,A7=A1L.length;i<A7;i++){var A4S=ZC.XL.md5(ZC.A98(ZC.A9T(A1L[i])));ZC.LICENSE instanceof Array&&-1!==ZC.AV(ZC.LICENSE,A4S)&&(s.TF=!0,WY(A4S))}ZC.BUILDCODE instanceof Array&&2===ZC.BUILDCODE.length&&(EY=ZC.AD7(s.AAR),EY=EY.replace("O","0"),s.S8=ZC.AC3(ZC.BUILDCODE[0],EY),s.S8===ZC.BUILDCODE[1]&&(s.TF=!0,s.A3J=!0,WY(ZC.BUILDCODE[0])))}},A8O:function(){var e=this;if(null!==e.MM)ZC._todash_(e.MM),e.load();else if(null===ZC._n_(ZC.cache.data["defaults-"+e.QN])){var t=["query-string"===e.MX?"zcrandom="+Math.random():"",zingchart.ZCOUTPUT?"zcoutput="+e.AC:""].join("&");ZC.A4.ajax({type:"GET",url:e.QN,dataType:"text",beforeSend:function(t){e.RX.defaults||"http-headers"!==e.MX||t.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:t,error:function(t,i,n,a){return e.NP({name:"Network error",message:"Resource not found ("+a+")"},"URL Data loader"),!1},success:function(t){var i;try{i=JSON.parse(t),ZC.cache.data["defaults-"+e.QN]=t}catch(n){return e.NP(n,"JSON parser"),!1}e.MM=i,ZC._todash_(e.MM),e.load()}})}else{var i;try{i=JSON.parse(ZC.cache.data["defaults-"+e.QN])}catch(n){return e.NP(n,"JSON parser"),!1}e.MM=i,ZC._todash_(e.MM),e.load()}},load:function(e,t){var i=this;if(i.M9="load",""!==(t=t||i.QB)&&0!==t.indexOf("javascript:"))if(null===ZC._n_(ZC.cache.data["data-"+t])){var n=["query-string"===i.MX?"zcrandom="+Math.random():"",zingchart.ZCOUTPUT?"zcoutput="+i.AC:""].join("&");ZC.A4.ajax({type:"GET",url:t,dataType:"text",beforeSend:function(e){i.RX.data||"http-headers"!==i.MX||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:n,error:function(e,t,n,a){return i.NP({name:"Network error",message:"Resource not found ("+a+")"},"URL Data loader"),!1},success:function(t){i.data_(e,t)}})}else i.data_(e,ZC.cache.data["data-"+t]),ZC.cache.data["data-"+t]=null;else""!==i.EW?i.data_(e,i.EW):null!==i.M6&&(i.A6X?i.M6=JSON.parse(JSON.stringify(i.A6X)):i.A6X=JSON.parse(JSON.stringify(i.M6)),i.data_(e,i.M6))},data_:function(e,t){var i=this;ZC.TS[i.K]=(new Date).getTime(),ZC.AP.A7Y("dataload",i)?ZC.AP.BZ("dataload",i,i.FH(),t,function(t){i.load_(e,t)}):i.load_(e,t)},A4R:function(e){var t,i,n=this;if(!zingchart.DEV.RESOURCES)return[];e||(e=n.o);var a=[];if(e.graphset)for(t=0,i=e.graphset.length;t<i;t++){var r=e.graphset[t].type||"null";if(-1===ZC.AV(ZC.CHARTS,r)){"3d"===r.substring(r.length-2)&&(r=r.substring(0,r.length-2));for(var l in ZC.EQUIV)ZC.EQUIV.hasOwnProperty(l)&&-1!==ZC.AV(ZC.EQUIV[l],r)&&(r=l);zingchart.loadModules(r),a.push(r)}}for(n.ACJ(e),t=0,i=ZC.RE.length;t<i;t++)""!==ZC.GT(ZC.RE[t])&&-1===ZC.AV(ZC.WA,ZC.GT(ZC.RE[t]))&&a.push(ZC.GT(ZC.RE[t]));return a},ACJ:function(e){function t(e){return-1!==ZC.AV(["bar","bar3d","funnel","bullet"],e)&&(e="v"+e),-1===ZC.AV(ZC.CHARTS,e)&&(e=""),e}var i,n,a,r,l,o,s=this;if(e||(e=s.o),s.A6E)for(e.history&&zingchart.loadModules("history"),a=0,r=e.graphset.length;a<r;a++){if((i=e.graphset[a].type)&&"null"!==i)if("mixed"===i||"hmixed"===i||"mixed3d"===i){if(e.graphset[a].series)for(l=0,o=e.graphset[a].series.length;l<o;l++)(n=e.graphset[a].series[l].type)&&zingchart.loadModules(t(n));e.graphset[a].plot&&(n=e.graphset[a].plot.type)&&zingchart.loadModules(t(n))}else zingchart.loadModules(t(i));var c=!1,h=!1;if(e.graphset[a].series)for(l=0,o=e.graphset[a].series.length;l<o;l++)e.graphset[a].series[l].errors&&(c=!0),e.graphset[a].series[l].animation&&(h=!0);if(e.graphset[a].plot&&(e.graphset[a].plot.animation&&(h=!0),e.graphset[a].plot.errors&&(c=!0)),c&&zingchart.loadModules("errorbars"),h&&zingchart.loadModules("animation"),e.graphset[a].legend&&zingchart.loadModules("legend"),e.graphset[a].preview&&zingchart.loadModules("preview"),e.graphset[a].tooltip&&zingchart.loadModules("tooltip"),(e.graphset[a].labels||e.graphset[a].shapes||e.graphset[a].arrows)&&zingchart.loadModules("objects"),i=e.graphset[a].shapes)for(l=0,o=i.length;l<o;l++)"zingchart.maps"===i[l].type&&zingchart.loadModules("maps"),i[l].options&&i[l].options.name&&zingchart.loadModules("maps-"+i[l].options.name.replace(/\./g,"-"));(e.graphset[a].guide||e.graphset[a]["crosshair-x"]||e.graphset[a]["crosshair-y"]||e.graphset[a].crosshairX||e.graphset[a].crosshairY)&&zingchart.loadModules("guide"),(e.graphset[a]["scroll-x"]||e.graphset[a]["scroll-y"]||e.graphset[a].scrollX||e.graphset[a].scrollY)&&zingchart.loadModules("scroll"),(e.refresh||e.graphset[a].refresh)&&zingchart.loadModules("refresh");var C=!1,u=!1;for(var d in e.graphset[a])e.graphset[a].hasOwnProperty(d)&&0===d.indexOf("scale")&&(e.graphset[a][d].zooming&&(C=!0),e.graphset[a][d].markers&&(u=!0));(C||e.graphset[a].zoom)&&zingchart.loadModules("zoom"),u&&zingchart.loadModules("scalemarkers")}},load_:function(JG,TK){var s=this,G;s.D.rawsource=zingchart.DEV.KEEPSOURCE?TK:"N/A";var DJ=null;if("string"==typeof TK)try{DJ=JSON.parse(TK)}catch(J7){try{DJ=eval("("+TK+")")}catch(J7){return s.NP(J7,"JSON parser"),!1}}else DJ=TK;null===ZC._n_(DJ.graphset)&&(DJ={graphset:[DJ]}),s.D.source="N/A",zingchart.DEV.KEEPSOURCE&&(s.D.source=ZC.GT(JSON.stringify(DJ))),zingchart.A15(s,s.A4R(DJ),function(){DJ=ZC.AP.BZ("dataparse",s,s.FH(),DJ),zingchart.A15(s,s.A4R(DJ),function(){if(ZC.AP.BZ("modulesready",s,{id:s.K}),null===ZC._n_(JG))s.XK(DJ),s.o=DJ,s.A10?(s.parse(),s.paint()):s.Q1(function(){s.parse(),s.paint()});else{var e=s.OR(JG);if(null!==e&&null!==ZC._n_(G=DJ.graphset)){var t=G.length>1?G[e.L]:G[0];t.id||(t.id=e.o.id||""),s.o.graphset[e.L]=t,s.Q1(function(){s.parse(JG),s.AH[e.L].paint()})}}})})},XK:function(DJ){var s=this,G,i,A7,j,J9;for(null===ZC._n_(DJ.graphset)&&(DJ={graphset:[DJ]}),1===DJ.graphset.length&&null===ZC._n_(DJ.graphset[0])&&(DJ.graphset=[{type:"null"}]),i=0,A7=DJ.graphset.length;i<A7;i++)if(null!==ZC._n_(DJ.graphset[i])){if(null!==ZC._n_(G=DJ.graphset[i].shapes)){var FE=[];for(DJ.graphset[i].labels=DJ.graphset[i].labels||[],j=0,J9=G.length;j<J9;j++)if(G[j].generated&&G[j]["map-item"]||FE.push(G[j]),null!==ZC._n_(G[j].type)&&0===G[j].type.indexOf("zingchart."))try{var LS=G[j].options||{},EI=G[j].type+"."+(LS.name||"");LS.graphid=i;var A2P=eval(EI).call(s,LS,DJ,G[j]);for(var A3O in A2P)A2P.hasOwnProperty(A3O)&&("label"===A2P[A3O].objtype?DJ.graphset[i].labels.push(A2P[A3O]):FE.push(A2P[A3O]))}catch(e){}DJ.graphset[i].shapes=FE}var A69;if(null!==ZC._n_(A69=DJ.graphset[i].widgets))for(var AAS=s.A4J(DJ,i),k=0;k<A69.length;k++){var A2L=A69[k];if(null!==ZC._n_(A2L.type)&&null!==ZC._n_(zingchart.widgets[A2L.type])&&"function"==typeof zingchart.widgets[A2L.type].parse)try{var BO={};ZC._cp_(A2L,BO),BO.graph=AAS.graph,BO.loader={id:s.K,width:s.I,height:s.F};var o=zingchart.widgets[A2L.type].parse.call(s,BO);if(null!==ZC._n_(G=o.graphs))for(j=0;j<G.length;j++)DJ.graphset.push({}),ZC._cp_(G[j],DJ.graphset[DJ.graphset.length-1]);if(null!==ZC._n_(G=o.labels))for(null===ZC._n_(DJ.graphset[i].labels)&&(DJ.graphset[i].labels=[]),j=0;j<G.length;j++)DJ.graphset[i].labels.push(G[j]);if(null!==ZC._n_(G=o.shapes))for(null===ZC._n_(DJ.graphset[i].shapes)&&(DJ.graphset[i].shapes=[]),j=0;j<G.length;j++)DJ.graphset[i].shapes.push(G[j])}catch(e){}}}},AAA:function(e,t){var i=this;switch(e){case"line":return new ZC.A61(i);case"area":return new ZC.A5Z(i);case"vline":return new ZC.AA6(i);case"varea":return new ZC.AA2(i);case"bar":case"vbar":case"column":return new ZC.A2C(i);case"hbar":return new ZC.A2E(i);case"mixed":case"hmixed":case"mixed3d":for(var n=!1,a=i.o.graphset[t].series,r=0,l=a.length;r<l;r++)a[r]&&a[r].type&&-1!==a[r].type.indexOf("3d")&&(n=!0);return n?new ZC.A2R(i):i.o.graphset[t].plot&&i.o.graphset[t].type&&i.o.graphset[t].plot&&i.o.graphset[t].plot.type&&-1!==i.o.graphset[t].plot.type.indexOf("3d")?new ZC.A2R(i):"mixed"===e?new ZC.A4N(i):new ZC.A8H(i);case"scatter":return new ZC.A7G(i);case"hscatter":return new ZC.A6S(i);case"bubble":return new ZC.A8Q(i);case"hbubble":return new ZC.A7V(i);case"ring":case"pie":return new ZC.A38(i);case"nestedpie":return new ZC.A6K(i);case"radar":case"polar":return new ZC.A9E(i);case"venn":return new ZC.AAE(i);case"bullet":case"vbullet":return new ZC.A7C(i);case"hbullet":return new ZC.A79(i);case"funnel":case"vfunnel":return new ZC.A7F(i);case"hfunnel":return new ZC.A82(i);case"heatmap":case"piano":return new ZC.A9N(i);case"stock":return new ZC.A9I(i);case"range":return new ZC.A9F(i);case"vrange":return new ZC.ZCVRangeGraph(i);case"gauge":return new ZC.A9A(i);case"line3d":return new ZC.A8S(i);case"area3d":return new ZC.A8T(i);case"ring3d":case"pie3d":return new ZC.A57(i);case"bar3d":case"vbar3d":return new ZC.A8L(i);case"hbar3d":return new ZC.A8J(i);case"null3d":return new ZC.A8I(i);default:return new ZC.AA7(i)}},OR:function(e){for(var t=this,i=0,n=t.AH.length;i<n;i++)if(t.AH[i].K===t.K+"-graph-"+e||t.AH[i].K===t.K+"-graph-id"+e||t.AH[i].K===e||i===e)return t.AH[i];return null},A4O:function(e,t){var i=this,n=ZC.A4("#"+i.K+("svg"===i.AC?"-top":"-main")),a=ZC._tx_(i.K);e-=n.offset().left,t-=n.offset().top;for(var r=null,l=0,o=i.AH.length;l<o;l++)ZC.DT(e,i.AH[l].iX,i.AH[l].iX+i.AH[l].I*a[0])&&ZC.DT(t,i.AH[l].iY,i.AH[l].iY+i.AH[l].F*a[1])&&(r=i.AH[l]);return r},A9J:function(e){var t,i=this;if("undefined"==typeof i.D.themesloaded){void 0===e&&(e=!1),i.assign_a([["theme","LH"]]),i.o.graphset&&1===i.o.graphset.length&&null!==ZC._n_(t=i.o.graphset[0].theme)&&(i.LH=t),""===i.LH&&(i.LH="light"),i.LH=String(i.LH).replace("zingchart","classic");for(var n=i.LH.split(/\s+|;|,/),a=0,r=n.length;a<r;a++)i.B8.AAP(n[a]);i.B8.A8O(i.MM),ZC.mobile&&i.B8.AAP("mobile"),e||(i.D.themesloaded=!0)}},parse:function(e){var t,i,n,a,r,l,o=this;o.NB="x",o.D.json=ZC.GT(JSON.stringify(o.o)),ZC._cp_(o.o.layers,o.NS),1===o.o.graphset.length&&ZC._cp_(o.o.graphset[0].layers,o.NS);var s=o.FH();if(null!==ZC._n_(e)&&(s.graphid=e),ZC.AP.BZ("dataready",o,s),o.M9="parse",o.QL[1]=o.QL[0],o.QL[0]="",o.QL[0]+=o.I+":"+o.F+":",null!==ZC._n_(t=o.o.graphset))for(o.QL[0]+=t.length+":",a=0;a<t.length;a++)o.QL[0]+=(t[a].type||"")+":",o.QL[0]+=(t[a].x||"")+":"+(t[a].y||"")+":"+(t[a].width||"")+":"+(t[a].height||"")+":",null!==ZC._n_(t[a].series)&&(o.QL[0]+=t[a].series.length+":");if(ZC.AK(o.K+"-main-c")&&o.clear(e,!1),"undefined"!=typeof ZC.AA0&&(o.H9=new ZC.AA0(o)),null===ZC._n_(e)){o.A9J(),o.B8.B8["font-family"]&&(zingchart.FONTFAMILY=o.B8.B8["font-family"]);var c=!!o.o.gui;if(o.B8.load(o.o,"loader",!1,!0),o.assign_a([["gui","DF"],["globals","QP"]]),o.o.graphset&&1===o.o.graphset.length&&(i=o.o.graphset[0],null!==ZC._n_(t=i.gui)&&(o.DF=t),null!==ZC._n_(t=i.globals)&&(o.QP=t)),ZC._todash_(o.QP),ZC._cp_(o.B8.B8.root.gui,o.DF,!1,!0,!0),o.DF.behaviors)for(a=o.DF.behaviors.length-1;a>=0;a--)for(l=0;l<a;l++)if(o.DF.behaviors[a].id===o.DF.behaviors[l].id){o.DF.behaviors.splice(a,1);break}if(c||delete o.o.gui,ZC._todash_(o.DF),o.N={},null!==ZC._n_(t=o.o.style))for(n in t)"url"!==n&&(o.N[n]=t[n]);if(o.o.graphset&&1===o.o.graphset.length&&(i=o.o.graphset[0],null!==ZC._n_(t=i.style)))for(n in t)"url"!==n&&(o.N[n]=t[n]);ZC._todash_(o.N),o.NS.graphset&&o.b(),o.assign_a([["locale","A0W"],["set-locale","A0W"],["layout","NB"],["h-space","A85","i"],["v-space","A7D","i"],["flat","K5","b"],["show-progress","A0C","b"]]),o.o.graphset&&1===o.o.graphset.length&&(i=o.o.graphset[0],null!==ZC._n_(t=i.locale)&&(o.A0W=t),null!==ZC._n_(t=i["set-locale"])&&(o.A0W=t),null!==ZC._n_(t=i.flat)&&(o.K5=ZC._b_(t)),null!==ZC._n_(t=i["show-progress"])&&(o.A0C=ZC._b_(t))),null!==ZC._n_(t=zingchart.i18n[o.A0W])&&(ZC.HI=t),o.AH=[]}var h=0,C=0,u=o.I,d=o.F;if(null!==ZC._n_(o.o.margin)||null!==ZC._n_(o.o["margin-top"])||null!==ZC._n_(o.o["margin-right"])||null!==ZC._n_(o.o["margin-bottom"])||null!==ZC._n_(o.o["margin-left"])){var p=new ZC.HS(o);p.append(o.o,!1,!1),p.parse(),h=p.DV,C=p.E5,u=u-p.DV-p.E6,d=d-p.E5-p.DP}var A,g,f=o.OR(e);if(null!==ZC._n_(A=o.o.graphset)){var Z=0;for(a=0,r=A.length;a<r;a++)g=0,null!==ZC._n_(t=A[a].page)&&(g=ZC._i_(t)),Z+=o.L4===g?1:0;var _=ZC.AO.A20(o.NB,Z),b=ZC._i_(_[0]),m=ZC._i_(_[1]),v=0,D=0,E=0;for(a=0,r=A.length;a<r;a++){if(g=0,null===f&&null!==ZC._n_(t=A[a].page)&&(g=ZC._i_(t)),(null===f||E===f.L)&&o.L4===g){if(o.AH[E]=o.AAA(A[a].type||"null",a),o.AH[E].O8=o.AH[E].AF+"graph",o.B8.load(o.AH[E].o,"graph"),o.B8.load(o.AH[E].o,A[a].type||"null"),o.AH[E].append(o.o.graph),o.AH[E].append(A[a]),o.AH[E].L=E,null===ZC._n_(A[E].id)||""===A[E].id?o.AH[E].K=o.K+"-graph-id"+E:o.AH[E].K=o.K+"-graph-"+A[a].id,A.length>0){for(var w=0,B=0,K=ZC._i_((u-(m+1)*o.A85)/m),F=ZC._i_((d-(b+1)*o.A7D)/b),x=["x","y","width","height"],y=0;y<x.length;y++)null!==ZC._n_(o.D["graph-"+E+"-"+x[y]])&&(delete o.D["graph-"+E+"-"+x[y]],delete o.AH[E].o[x[y]]);null===ZC._n_(o.AH[E].o.x)?o.D["graph-"+E+"-x"]=o.AH[E].o.x=ZC._i_(o.iX+(v+1)*o.A85+v*K)+h:(w=ZC.IH(o.AH[E].o.x))<1&&(w=ZC._i_(o.I*w)),null===ZC._n_(o.AH[E].o.y)?o.D["graph-"+E+"-y"]=o.AH[E].o.y=ZC._i_(o.iY+(D+1)*o.A7D+D*F)+C:(B=ZC.IH(o.AH[E].o.y))<1&&(B=ZC._i_(o.F*B)),null===ZC._n_(o.AH[E].o.width)&&(o.D["graph-"+E+"-width"]=o.AH[E].o.width=Math.max(K,K-w)),null===ZC._n_(o.AH[E].o.height)&&(o.D["graph-"+E+"-height"]=o.AH[E].o.height=Math.max(F,F-B))}o.AH[E].parse()}o.L4===g&&(E++,++v===m&&(D++,v=0))}}null===ZC._n_(e)&&null!==ZC._n_(t=o.o.refresh)&&(o.HM={type:"full",interval:10},ZC._cp_(t,o.HM))},A3W:function(e,t){t=t||"";var i=[];for(var n in e)if("object"==typeof e[n])for(var a=this.A3W(e[n],t+"."+n),r=0,l=a.length;r<l;r++)-1===ZC.AV(i,a[r])&&i.push(a[r]);else{var o=t+"."+n;"background-image"!==n&&"backgroundImage"!==n||""===e[n]||"zc."===e[n].substring(0,3)||(!ZC.ie67&&ZC.PATTERNS&&"PATTERN_"===e[n].substring(0,8)&&(e[n]=ZC.PATTERNS[e[n].substring(8)]),"!"===e[n].charAt(0)&&(e[n]=e[n].substring(1),this.D["safe-images"]=this.D["safe-images"]||[],this.D["safe-images"].push(e[n])),i.push([e[n],"image"])),"src"===n&&""!==e[n]&&"zc."!==e[n].substring(0,3)&&-1!==o.indexOf(".images.")&&(!ZC.ie67&&ZC.PATTERNS&&"PATTERN_"===e[n].substring(0,8)&&(e[n]=ZC.PATTERNS[e[n].substring(8)]),"!"===e[n].charAt(0)&&(e[n]=e[n].substring(1),this.D["safe-images"]=this.D["safe-images"]||[],this.D["safe-images"].push(e[n])),i.push([e[n],"image"])),".csv"===o.substr(o.length-4,4)&&"string"==typeof e[n]&&i.push([e[n],"csv"]),"url"===n&&(-1!==o.indexOf(".style.")&&i.push([e[n],"css"]),-1!==o.indexOf(".csv.")&&i.push([e[n],"csv"]),-1!==o.indexOf(".marker.")&&i.push([e[n],"image"])),"string"==typeof e[n]&&"url"!==n&&(0===e[n].indexOf("url:")&&"values"===n||0===e[n].indexOf("javascript:"))&&-1===ZC.AV(["format","text","tooltipText"],ZC.EC(n))&&i.push([e[n],"data"])}return i},Q1:function(J8){function A2K(i){if(!(i>=J1.length)){var EW,MC,K9=J1[i][0],A08=J1[i][1];if("url:"===K9.substring(0,4)){var QB=K9.substring(4);s.QS["url:"+QB]="[]";try{EW=["query-string"===s.MX?"zcrandom="+Math.random():""].join("&"),ZC.A4.ajax({type:"GET",url:QB,beforeSend:function(e){s.RX.data||"http-headers"!==s.MX||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,t,i,n){return s.NP({name:"Network error",message:"Resource not found ("+n+")"},"URL Data loader"),!1},success:function(e,t,i,n){s.QS["url:"+n]=e,UD++}})}catch(J7){return s.NP(J7,"URL Data loader"),!1}}else if("javascript:"===K9.substring(0,11))if("zc.ext.load"===s.QS[K9]){s.QS[K9]="[]";var E0=ZC.AP.AA8(K9.substring(11)),O={id:s.K,resource:K9,callback:function(e){s.QS[K9]=e,UD++}},ZY=E0[0];O.arguments=E0[1];try{var Z1=eval(ZY).call(s,O);null!==ZC._n_(Z1)&&Z1&&(s.QS[K9]=Z1,UD++)}catch(J7){return s.NP(J7,"JavaScript data loader"),!1}}else UD++;else"image"===A08?(LD[K9]=new Image,LD[K9].crossOrigin="anonymous",LD[K9].onload=function(){UD++},LD[K9].onerror=function(){var e=ZC._b_(s.o.strict);if(ZC.IMG404.push(K9),e)return s.NP({name:"Network error",message:"Resource not found ("+this.src+")"},"Resource loader (image)"),!1;this.src=ZC.BLANK,UD++},LD[K9].src=K9,ZC.cache.data[K9]=LD[K9]):"css"===A08?(EW=["query-string"===s.MX?"zcrandom="+Math.random():""].join("&"),ZC.A4.ajax({type:"GET",url:K9,beforeSend:function(e){s.RX.css||"http-headers"!==s.MX||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,t,i){return s.NP(i,"Resource loader"),!1},success:function(e){for(var t={},i=e.match(/[a-zA-Z0-9\.\#\-](.+?)\{((.|\s)+?)\}/gi),n=0,a=i.length;n<a;n++){MC=i[n].split("{");var r=ZC.GT(MC[0]),l=r.split(/\s+/);if(1===l.length||2===l.length&&ZC.GT(l[0])==="#"+s.K){t[r=ZC.GT(1===l.length?l[0]:l[1])]||(t[r]={});for(var o=0,c=(MC=MC[1].replace("}","").split(";")).length;o<c;o++){var h=MC[o].split(":");2===h.length&&(t[r][ZC.GT(h[0])]=""+ZC.GT(h[1]))}}}null!==ZC._n_(s.o.style)?ZC._cp_(t,s.o.style):null!==ZC._n_(s.o.graphset)&&1===s.o.graphset.length&&s.o.graphset[0].style&&ZC._cp_(t,s.o.graphset[0].style),UD++}})):"csv"===A08&&(EW=["query-string"===s.MX?"zcrandom="+Math.random():""].join("&"),ZC.A4.ajax({type:"GET",url:K9,beforeSend:function(e){s.RX.csv||"http-headers"!==s.MX||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,t,i){return s.NP(i,"Resource loader"),!1},success:function(e,t,i,n){s.A9K[n]=e,UD++}}))}}var s=this;if(zingchart.DEV.RESOURCES){var J1=s.A3W(s.o).concat(s.A3W(s.MM));if(0!==J1.length){var UD=0,LD={},A14=0;s.D["safe-images"]=s.D["safe-images"]||[];var C3=window.setInterval(function(){if(UD>=J1.length){window.clearInterval(C3),s.ABH(s.o);for(var e in LD)if(0!==e.indexOf("data:")&&-1===ZC.AV(s.D["safe-images"],e))try{var t=document.createElement("canvas");t.width=LD[e].width,t.height=LD[e].height,t.getContext("2d").drawImage(LD[e],0,0);var i=t.toDataURL("image/png");LD[e].onload=null,LD[e].onerror=null,LD[e].src=i,ZC.cache.data[e]=LD[e]}catch(n){}window.setTimeout(function(){zingchart.XR[s.K]&&J8()},1)}else A2K(++A14)},20);A2K(A14)}else zingchart.XR[s.K]&&J8()}else zingchart.XR[s.K]&&J8()},ABH:function(BY){var s=this;for(var p in BY)if("object"==typeof BY[p])s.ABH(BY[p]);else for(var EW in s.QS)EW===BY[p]&&(BY[p]=eval(s.QS[EW]))},resize:function(e){var t,i,n,a,r=this;if(r.D.resize=!0,r.D.wh=r.I+"/"+r.F,r.o.graphset)if(r.A13)zingchart.exec(r.K,"destroy"),zingchart.render(zingchart.params[r.K]);else if(void 0===e&&(e=!1),ZC.AP.BZ("resize",r,r.FH()),e=!1);else{for(i=0;i<r.AH.length;i++)for(a=0;a<r.AH[i].AY.A6.length;a++)r.D["g-"+i+"-p-"+a+".visible"]=r.AH[i].D["plot"+a+".visible"];for(i=0;i<r.AH.length;i++)r.D["g-"+r.AH[i].L+"-selection"]=JSON.stringify(r.AH[i].CH);for(var l=r.o.graphset,o=["labels","shapes"],s=0,c=l.length;s<c;s++)for(var h=0;h<o.length;h++){var C=o[h],u=[];if(null!==ZC._n_(l[s][C])){for(i=0,n=l[s][C].length;i<n;i++)l[s][C][i].generated||u.push(l[s][C][i]);l[s][C]=u}}if(r.XK(r.o),r.o=ZC.AP.BZ("dataparse",r,r.FH(),r.o),ZC.A4("#"+r.K+"-top").width(r.I).height(r.F),r.D["from-api"]&&(ZC.A4("#"+r.K+"-wrapper").width(r.I).height(r.F),delete r.D["from-api"]),1===(t=ZC.A4("#"+r.K+"-img")).length&&t.width(r.I).height(r.F).css("clip","rect(1px,"+(r.I-1)+"px,"+(r.F-1)+"px,1px)"),"svg"===r.AC&&(r.K7.setAttribute("width",r.I),r.K7.setAttribute("height",r.F)),"canvas"===r.AC||"vml"===r.AC){for(ZC.A4("#"+r.K+"-main").width(r.I).height(r.F),i=0,n=r.AH.length;i<n;i++)ZC.A4("#"+r.AH[i].K+"-hover").remove();ZC.A4("#"+r.K+"-main>div").width(r.I).height(r.F)}for("canvas"===r.AC&&((t=ZC.AK(r.K+"-main-c"))&&(t.width=r.I,t.height=r.F),(t=ZC.AK(r.K+"-main-c-top"))&&(t.width=r.I,t.height=r.F),ZC.A4("#"+r.K+"-objects-bottom canvas, #"+r.K+"-objects-top canvas, #"+r.K+"-tools canvas").each(function(){this.width=r.I,this.height=r.F})),"vml"===r.AC&&ZC.A4("#"+r.K+"-objects-bottom div, #"+r.K+"-objects-top div, #"+r.K+"-tools div").each(function(){this.style.width=r.I+"px",this.style.height=r.F+"px"}),r.parse(),i=0,n=r.AH.length;i<n;i++)r.AH[i].U0&&r.AH[i].U0(),r.AH[i].HF=!0,r.AH[i].A5Q=r.AH[i].GA,r.AH[i].GA=!1;for(r.paint(),i=0;i<r.AH.length;i++)for(a=0;a<r.AH[i].AY.A6.length;a++)delete r.D["g-"+i+"-p-"+a+".visible"];for(i=0;i<r.AH.length;i++)r.AH[i].HF=!1,r.AH[i].GA=r.AH[i].A5Q,delete r.AH[i].A5Q,delete r.D["g-"+r.AH[i].L+"-selection"]}},clearGenerated:function(){var e=this.o.graphset,t=["labels","shapes"];if(e)for(var i=0,n=e.length;i<n;i++)for(var a=0;a<t.length;a++){var r=t[a],l=[];if(null!==ZC._n_(e[i][r])){for(var o=0,s=e[i][r].length;o<s;o++)e[i][r][o].generated||l.push(e[i][r][o]);e[i][r]=l}}},clear:function(e,t,i){var n=this;for(var a in n.D)-1!==a.indexOf("-label-")&&-1!==a.indexOf("-bounds")&&delete n.D[a];if(void 0===t&&(t=!0),ZC.A4("."+n.K+"-history-area").die("click",n.A0J),ZC.A4("."+n.K+"-history-area").remove(),null!==ZC._n_(e))n.OR(e).clear();else{t&&n.clearGenerated(),n._unbind_();for(var r=0,l=n.AH.length;r<l;r++)"vml"===n.AC&&i?n.AH[r].destroy():n.AH[r].clear();var o,s,c;null!==(o=ZC.AK(n.K+"-main-c"))&&ZC.Q.IQ(o,n.AC,n.iX,n.iY,n.I,n.F),null!==(c=ZC.AK(n.K+"-main-c-top"))&&ZC.Q.IQ(c,n.AC,n.iX,n.iY,n.I,n.F),null!==(s=ZC.AK(n.K+"-trigger-c"))&&(ZC.Q.IQ(s,n.AC,n.iX,n.iY,n.I,n.F),ZC.A4("#"+n.K+"-menu-area").remove()),n.A8&&n.A8.hide(),ZC.A4("."+n.K+"-menu-item").remove(),ZC.Q.EU([n.K+"-menu-trigger",n.K+"-menu"]),ZC.Q.EU(n.K+"-license-text"),null!==n.I7&&ZC.Q.EU([n.K+"-history-path",n.K+"-history-back-path",n.K+"-history-forw-path",n.K+"-history-gradient",n.K+"-history-back-gradient",n.K+"-history-forw-gradient"])}},AAU:function(){var e,t,i,n=this,a=n.I+"/"+n.F,r=ZC.Q.HX({id:n.K+"-wrapper",position:"relative",p:ZC.AK(n.K)});ZC.Q.PD(r,{height:"100%"===n.MN?n.MN:n.F+"px",width:"100%"===n.FV?n.FV:n.I+"px"});var l=ZC.Q.HX({cls:"zc-rel zc-top",wh:a,id:n.K+"-top",overflow:"hidden",position:"absolute",p:r});switch(zingchart.OFFSET&&(l.style.left="-0.5px",l.style.top="-0.5px"),n.AC){case"svg":n.K7=ZC.Q.F4("svg","http://www.w3.org/2000/svg"),n.K7.setAttributeNS&&n.K7.setAttributeNS(null,"xlink","http://www.w3.org/1999/xlink"),ZC.Q.G2(n.K7,{version:"1.1",id:n.K+"-svg","class":"zc-svg",width:n.I,height:n.F,display:"block"}),l.appendChild(n.K7);var o=ZC.Q.F4("defs","http://www.w3.org/2000/svg");if(o.id=n.K+"-defs",n.K7.appendChild(o),ZC.Q.JW({cls:"zc-rel zc-main",wh:a,id:n.K+"-main",p:n.K7},n.AC),n.A1X=[],n.o.graphset)for(e=0,t=n.o.graphset.length;e<t;e++)if((i=n.o.graphset[e].resources)&&i.length)for(var s=0;s<i.length;s++)if("css"===i[s].type&&i[s].url){var c=ZC.Q.F4("link","http://www.w3.org/2000/svg");ZC.Q.G2(c,{xmlns:"http://www.w3.org/1999/xhtml",href:i[s].url,rel:"stylesheet",type:"text/css"}),n.A1X.push(i[s].url),o.appendChild(c)}break;case"vml":case"canvas":ZC.Q.HX({cls:"zc-rel zc-main",wh:a,id:n.K+"-main",p:l})}},paintHistory:function(){},paint:function(){var e=this;e.M9="paint";var t=e.I+"/"+e.F;if(e.A0G(),null===ZC.AK(e.K+"-top")){e.AAU();var i=ZC.AK(e.K+"-main");if(e.NS.graphset&&ZC.Q.HE({cls:"zc-abs",id:e.K+"-main-c",wh:t,p:i},e.AC),e.H.usc())ZC.Q.HE({cls:"zc-abs",id:e.K+"-main-c-top",wh:t,p:i},e.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-print-c",p:i,wh:t,display:"none"},e.AC);else{ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-bottom",p:i},e.AC),zingchart.DEV.MAPSONBOTTOM&&ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-maps",p:i},e.AC),ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-graphset",p:i},e.AC),zingchart.DEV.MAPSONBOTTOM||ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-maps",p:i},e.AC),ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-top",p:i},e.AC),ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-hover",p:i},e.AC),ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-front",p:i},e.AC),ZC.Q.JW({cls:"zc-abs zc-text",wh:t,id:e.K+"-text",p:i},e.AC);var n="legend",a="tools";("legend"===e.o["top-layer"]||e.o.graphset&&1===e.o.graphset.length&&"legend"===e.o.graphset[0]["top-layer"])&&(n="tools",a="legend"),ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-"+n,p:i},e.AC),ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-"+a,p:i},e.AC);var r=ZC.AK(e.K+"-tools");e.NS["static"]&&ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-static-c",wh:t,p:r},e.AC),e.NS.guide&&ZC.Q.HE({cls:"zc-abs zc-layer zc-guide-c",id:e.K+"-guide-c",wh:t,p:r},e.AC),(ZC.A4.browser.opera&&ZC._i_(ZC.A4.browser.version)<=9.5||ZC.mobile||"classic"!==e.LH)&&ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-trigger-c",wh:t,p:r},e.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-print-c",p:r,wh:t,display:"none"},e.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-textprint-c",p:r,wh:t,display:"none"},e.AC),ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-text-top",p:i},e.AC)}if(!zingchart.DEV.SKIPTRACKERS){var l=document.createElement("img");if(l.id=e.K+"-img",l.className="zc-img",l.setAttribute("useMap","#"+e.K+"-map"),l.setAttribute("alt",""),ZC.Q.PD(l,{position:"absolute",borderWidth:0,width:e.I+2*ZC.MAPTX+"px",height:e.F+2*ZC.MAPTX+"px",left:-ZC.MAPTX+"px",top:-ZC.MAPTX+"px",zIndex:0,opacity:0,filter:"alpha(opacity=0)",clip:"rect("+(ZC.MAPTX+1)+"px,"+(e.I+ZC.MAPTX-1)+"px,"+(e.F+ZC.MAPTX-1)+"px,"+(ZC.MAPTX+1)+"px)"}),l.src=(ZC.ie67?"//":"")+ZC.BLANK,ZC.AK(e.K+"-top").appendChild(l),!e.H.usc()){var o=document.createElement("map");o.className="zc-map",ZC.Q.G2(o,{id:e.K+"-map",name:e.K+"-map"}),ZC.AK(e.K+"-top").appendChild(o)}}}e.Z=ZC.AK(e.K+"-main-c"),e.b();var s,c,h=!1,C=!1;for(s=0,c=e.AH.length;s<c;s++){e.AH[s].paint(),(null!==e.AH[s].CX&&e.AH[s].CX.AM||null!==e.AH[s].H7&&e.AH[s].H7.AM)&&(h=!0);for(var u=0;u<e.AH[s].BM.length;u++)if(e.AH[s].BM[u].GM){C=!0;break}}if(e.FY){for(var d in e.FY)ZC.AK(d).appendChild(e.FY[d]);e.FY=null}if(e.D.preservezoom=null,e.TF||e.UA||(e.YO?e.A8K():e.YO=window.setInterval(function(){e.A8U(),e.TF||e.UA?(window.clearInterval(e.YO),ZC.Q.EU(e.K+"-license-text")):ZC.AK(e.K+"-license-text")||e.A8K()},2e3)),-1===ZC.AV(e.KM,"skip_context_menu")&&e.A5P(),-1===ZC.AV(e.KM,"skip_interactivity")?("undefined"!=typeof ZC.A89&&(e.A8=new ZC.A89(e)),C&&e.H9.bind(),h&&"undefined"!=typeof ZC.K1&&(e.D5=new ZC.K1(e),e.D5.bind()),ZC.mobile&&(e.AFT=function(t){ZC.swipe={xy:ZC.Q.M7(t),ts:(new Date).getTime()},t.target.id===e.K+"-menu-area"?(ZC.move=!1,e.A8&&e.A8.hide(),zingchart.YU(t)):(null===e.DF||null===ZC._n_(e.DF["page-scroll"])||e.DF["page-scroll"]||t.preventDefault(),ZC.move=!1,e.hideCM(),e.A8&&e.A8.hide(),e.YS(t))},e.OP=function(){window.clearTimeout(e.AAT),e.A3Q=null},e.AFQ=function(t){if(ZC.swipe){var i=ZC.Q.M7(t);if(ZC._a_(i[0]-ZC.swipe.xy[0])>100&&(new Date).getTime()-ZC.swipe.ts<1e3){var n=e.FH();n.direction=i[0]>ZC.swipe.xy[0]?"right":"left",ZC.AP.BZ("swipe",e,n)}ZC.swipe=null}e.A9B||ZC.move||zingchart.SA(t),e.OP(t)},ZC.A4("#"+e.K+"-img").bind("touchstart",e.AFT).bind("touchmove",e.OP).bind("touchend",e.AFQ),ZC.A4("#"+e.K+"-menu-area").live("touchstart",e.AFT)),e.zc_loader_mousewheel=function(t){var i=e.FH();i.ev=t,ZC.AP.BZ("mousewheel",e,i)},ZC.A4("#"+e.K+"-img").bind("mousewheel",e.zc_loader_mousewheel),ZC.A4("#"+e.K+"-map").bind("mousewheel",e.zc_loader_mousewheel),e.A1S=function(t){27===t.keyCode&&e.QV&&(e.A7E||e.A8Z())},ZC.A4(document).bind("keyup",e.A1S),e.A8Z=function(){ZC.A4("#"+e.K+"-menu-item-exitfullscreen").die("click",e.A8Z),ZC.FSSTATUS=null,ZC.Q.EU(e.K+"-data-table"),e.destroy(),zingchart.FSID&&ZC.AK(zingchart.FSID)&&(ZC.AK(zingchart.FSID).style.display="none")},ZC.A4("#"+e.K+"-menu-item-exitfullscreen").live("click",e.A8Z)):ZC.mobile&&(e.zc_loader_touchstart_static=function(e){return e.preventDefault(),zingchart.SA(e),!1},ZC.A4("#"+e.K+"-img").bind("touchstart",e.zc_loader_touchstart_static)),null!==e.HM){var p=ZC._i_(e.HM.interval);p=p>=50?p:1e3*p,window.setTimeout(function(){e.MV(),e.load()},p)}e.M9="",ZC.TS[e.K]=(new Date).getTime()-ZC.TS[e.K],e.D["fire-complete"]&&(ZC.AP.BZ("complete",e,e.FH()),e.D["fire-complete"]=null),e.D["fire-load"]&&(ZC.AP.BZ("load",e,e.FH()),e.D["fire-load"]=null)},togglePreviewMasks:function(e){for(var t=this,i=0;i<t.AH.length;i++)t.AH[i].BA&&t.AH[i].BA.toggleMasks(e)},createPreviewMasks:function(){var e=this,t=document.createElement("canvas");t.width=e.I,t.height=e.F,t.setAttribute("class","");for(var i=0;i<e.AH.length;i++)e.AH[i].BA&&e.AH[i].BA.toggleMasks(!0,t);return t},AGC:function(){var e=this;null===ZC._n_(ZC.showZCAbout)&&(ZC.showZCAbout=function(e){zingchart.exec(e.id,"toggleabout")}),zingchart.exec(e.K,"addmenuitem",{text:"About ZingChart","function":"ZC.showZCAbout()",order:100})},A8K:function(){var e,t=this,i={},n=t.DF.watermark;t.B8.load(i,"loader.gui.watermark"),n&&ZC._cp_(n,i),1===t.o.graphset.length&&t.o.graphset[0].gui&&(e=t.o.graphset[0].gui.watermark)&&ZC._cp_(e,i);var a=ZC._l_(ZC._i_(i.type||1),1,2),r=i.position||"br";-1===ZC.AV(["tl","tr","br","bl"],r)&&(r="br"),t.ACT=r;var l=32,o=146,s=0,c=1,h="";ZC.ie67&&(l=30,o=168,s=8,c=1),o=126,l=22;var C={light:["#6D6E71","#00384A"],dark:["#FFFFFF","#09A9DA"]},u=C.light;if(zingchart.THEME&&(u="light"===t.LH||"classic"===t.LH?C.light:C.dark),1===t.o.graphset.length)if(t.o.graphset[0]["background-color"]){var d=ZC.AP.G5(t.o.graphset[0]["background-color"]);7===d.length&&(u=ZC.AP.AA3(d,C.dark,C.light))}else if(t.o.graphset[0].theme){var p=t.o.graphset[0].theme;u="light"===p||"classic"===p?C.light:C.dark}var A="undefined"!=typeof window&&window.location?window.location.origin:"",g="undefined"!=typeof window&&window.location?window.location.pathname:"";h='<a title="JavaScript Charts by ZingChart" style="color:'+u[0]+' !important;font-size:11px !important;display:block !important;opacity:1 !important; text-decoration:none;" href="http://www.zingchart.com/?origin='+A+"&pathname="+g+'">Powered by <span style="color:'+u[1]+'; font-weight:bold;">ZingChart</span></a>';var f,Z;switch(r){case"br":f=t.F-l,Z=t.I-o;break;case"bl":f=t.F-l,Z=6;break;case"tr":f=2,Z=t.I-o;break;case"tl":f=2,Z=6}null!==ZC._n_(e=ZC.AK(t.K+"-top"))&&ZC.Q.HX({cls:ZC.ie67?"-ie67":"",p:e,id:t.K+"-license-text",tl:f+"/"+Z,wh:o+"/"+(l-s),color:ZC.ie67?1===a?"#369":"#fff":"",padding:s,opacity:c,position:"absolute",cursor:"pointer",fontFamily:zingchart.FONTFAMILY,html:h},t.AC)},_unbind_:function(){var e=this;ZC.A4("#"+e.K+"-menu").die("mousedown",e.TE),ZC.A4("."+e.K+"-menu-item").die("mousedown",e.TE),ZC.A4("."+e.K+"-menu-item").die("click touchend",e.AGQ).die("mouseover",e.AFX).die("mouseout",e.AGM),e.D["menu-item-events"]=!1,null!==e.H9&&e.H9.unbind(),null!==e.D5&&e.D5.unbind(),ZC.mobile&&(ZC.A4("#"+e.K+"-img").unbind("touchstart",e.AFT).unbind("touchmove",e.OP).unbind("touchend",e.AFQ),ZC.A4("#"+e.K+"-menu-area").die("touchstart",e.AFT),ZC.A4("#"+e.K+"-img").unbind("touchstart",e.zc_loader_touchstart_static)),ZC.A4("#"+e.K+"-img").unbind("mousewheel",e.zc_loader_mousewheel),ZC.A4("#"+e.K+"-map").unbind("mousewheel",e.zc_loader_mousewheel),ZC.A4(document).unbind("keyup",e.A1S),ZC.A4("#"+e.K+"-menu-item-exitfullscreen").die("click",e.A8Z)},VG:function(e,t,i){void 0===i&&(i=!1);var n=ZC.AK("zc-menu-"+(i?"sep":"item")+"-"+e);n&&(n.style.display=t?"block":"none")},A5P:function(LA,ev){function A1J(e){return""!==e&&e?"url("+(0===e.indexOf("zc.")?ZC.IMAGES[e]:e)+")":"none"}function J4(e){return'<div id="'+s.K+"-menu-sep-"+e+'" class="zc-menu-sep" style="background-color:'+E1.A0+";background-image:"+A1J(E1.D9)+" repeat-x 50% 0%;border-bottom-width:"+U2["line-width"]+";border-bottom-color:"+U2["line-color"]+';">&nbsp;</div>'}function GS(e,t,i){t=t||ZC.HI["menu-"+e];var n=void 0!==i&&i?" zc-custom-menu-item "+s.K+"-custom-menu-item":"";return'<div class="'+s.K+"-menu-item"+n+'" style="width:'+s.MT.o.width+";color:"+E1.C1+";font-family:"+E1.GD+";font-size:"+E1.DK+"px;background-color:"+E1.A0+";background-image:"+A1J(E1.D9)+" repeat-x 50% 0%;border-top:"+(ZC.ie67?E1.AT:1)+"px solid "+E1.BV+";border-left:"+E1.AT+"px solid "+E1.BV+";border-right:"+E1.AT+"px solid "+E1.BV+";padding:"+E1.FJ+"px "+E1.FK+"px "+E1.FR+"px "+E1.EP+"px;text-align:"+E1.OB+";"+(ZC.HI.rtl?"unicode-bidi:bidi-override;direction:rtl;":"")+'" id="'+s.K+"-menu-item-"+e+'">'+t+"</div>"}function A2Q(e,t,i){var n=void 0!==i&&i?" zc-custom-menu-header "+s.K+"-custom-menu-header":"";return'<div class="zc-menu-header '+s.K+"-menu-header"+n+'" style="color:'+E1.C1+";background-color:#666;border-top:"+(ZC.ie67?E1.AT:1)+"px solid "+E1.BV+";border-left:"+E1.AT+"px solid "+E1.BV+";border-right:"+E1.AT+"px solid "+E1.BV+";padding:"+E1.FJ+"px "+E1.FK+"px "+E1.FR+"px "+E1.EP+"px;text-align:"+E1.OB+";"+(ZC.HI.rtl?"unicode-bidi:bidi-override;direction:rtl;":"")+'" id="'+s.K+"-menu-item-"+e+'">'+t+"</div>"}function G1(e){if(ABB)return{enabled:"none"};for(var t=0,i=RM.length;t<i;t++)if(RM[t].id===e)return RM[t];return{enabled:"all"}}if(!zingchart.DEV.SKIPCONTEXTMENU){var s=this,G,i,A7,j,J9;void 0===LA&&(LA=-1);var DF={};ZC._cp_(s.DF,DF),-1!==LA&&s.o.graphset[LA]&&ZC._cp_(s.o.graphset[LA].gui,DF,null,null,!0),ZC.A4("#"+s.K+"-menu").remove();var RM=[];for("undefined"==typeof ZC.AN&&RM.push({id:"3D",enabled:"none"},{id:"SwitchTo3D",enabled:"none"},{id:"SwitchTo2D",enabled:"none"}),i=DF.behaviors.length-1;i>0;i--)for(var sBId=DF.behaviors[i].id,ii=i-1;ii>=0;ii--)DF.behaviors[ii].id===sBId&&DF.behaviors.splice(ii,1);if(null!==ZC._n_(G=DF.behaviors))for(i=0,A7=G.length;i<A7;i++){var N5=!1;for(j=0,J9=RM.length;j<J9;j++)RM[j].id===G[i].id&&(N5=!0);N5||RM.push(G[i])}var JF=DF["context-menu"],OD=DF["context-menu[mobile]"];for(i=0,A7=RM.length;i<A7;i++)null!==ZC._n_(RM[i]["function"])&&(null===ZC._n_(JF)&&(JF={}),null===ZC._n_(JF["custom-items"])&&(JF["custom-items"]=[]),JF["custom-items"].push(RM[i]));JF["custom-items"]&&JF["custom-items"].sort(function(e,t){return ZC._i_(e.order||"0")>ZC._i_(t.order||"0")}),s.MT=new ZC.DS(s);var A0Z=s.LH.split(/\s+|;|,/);for(i=0,A7=A0Z.length;i<A7;i++)if(s.B8.NU[A0Z[i]]){var A0U=s.B8.NU[A0Z[i]].root||{};A0U&&A0U.gui&&A0U.gui.contextMenu&&ZC._cp_(A0U.gui.contextMenu,s.MT.o)}s.B8.load(s.MT.o,"loader.gui.context-menu"),JF&&s.MT.append(JF),ZC.mobile&&(s.B8.load(s.MT.o,"loader.gui.context-menu[mobile]"),OD&&s.MT.append(OD)),s.MT.WJ=!0,s.MT.parse();var E1,L9,U2,ABB,GR;if(s.MT.AM||!s.A3J){if(!ZC.AK(s.K+"-menu-area")){var A4W=!!(s.DF&&s.DF["context-menu"]&&s.DF["context-menu"].button)&&ZC._n_(s.DF["context-menu"].button.visible);if(A4W||"classic"!==s.LH&&A4W){GR=new ZC.DS(s),s.B8.load(GR.o,"loader.gui.context-menu.button"),JF&&ZC._n_(null!==(G=JF.button))&&GR.append(G),ZC.mobile&&(s.B8.load(GR.o,"loader.gui.context-menu[mobile].button"),OD&&null!==ZC._n_(G=OD.button)&&GR.append(G)),ZC._cp_(s.MT.o,JF);var A6G="left"===JF.position||"classic"===s.LH;if(GR.K=s.K+"-menu-trigger",GR.IK=ZC.AK(s.K+"-tools"),GR.Z=GR.C6=ZC.AK(s.K+"-trigger-c"),GR.WJ=!0,GR.parse(),GR.AM){GR.paint();var DB=ZC.A4("#"+s.H.K+"-top");if(""===GR.AR){var N0=new ZC.DW(s);if(N0.CZ=!1,s.B8.load(N0.o,"loader.gui.context-menu.gear"),JF&&null!==ZC._n_(G=JF.gear)&&N0.append(G),ZC.mobile&&(s.B8.load(N0.o,"loader.gui.context-menu[mobile].gear"),OD&&null!==ZC._n_(G=OD.gear)&&N0.append(G)),N0.K=s.K+"-menu-trigger-gear",N0.IK=ZC.AK(s.K+"-tools"),N0.Z=ZC.AK(s.K+"-trigger-c"),N0.iX=A6G?GR.iX+GR.I/2:DB.width()-(GR.iX+GR.I/2),N0.iY=GR.iY+GR.F/2,N0.AI=ZC.CY(GR.I,GR.F)/4.5,N0.parse(),N0.paint(),"hamburger"!==N0.DQ){var QA=new ZC.DW(s);QA.copy(GR),QA.K=s.K+"-menu-trigger-gear-hole",QA.IK=ZC.AK(s.K+"-tools"),QA.Z=ZC.AK(s.K+"-trigger-c"),QA.DQ="circle",QA.AI=ZC.CY(GR.I,GR.F)/7,QA.parse(),QA.iX=A6G?GR.iX+GR.I/2:DB.width()-(GR.iX+GR.I/2),QA.iY=GR.iY+GR.F/2,QA.paint()}}var _iX=A6G?GR.iX:DB.width()-(GR.iX+GR.I);ZC.AK(s.K+"-map").innerHTML+=ZC.Q.GC("rect")+'id="'+s.K+'-menu-area" coords="'+ZC._i_(_iX+ZC.MAPTX)+","+ZC._i_(GR.iY+ZC.MAPTX)+","+ZC._i_(_iX+GR.I+ZC.MAPTX)+","+ZC._i_(GR.iY+GR.F+ZC.MAPTX)+'" />'}}}E1=new ZC.DS(s),s.B8.load(E1.o,"loader.gui.context-menu.item"),JF&&null!==ZC._n_(G=JF.item)&&E1.append(G),ZC.mobile&&(s.B8.load(E1.o,"loader.gui.context-menu[mobile].item"),OD&&null!==ZC._n_(G=OD.item)&&E1.append(G)),E1.WJ=!0,E1.parse(),L9=new ZC.DS(s),L9.copy(E1),s.B8.load(L9.o,"loader.gui.context-menu.item.hover-state"),JF&&null!==ZC._n_(JF.item)&&null!==ZC._n_(G=JF.item["hover-state"])&&L9.append(G),ZC.mobile&&(s.B8.load(L9.o,"loader.gui.context-menu[mobile].item.hover-state"),OD&&null!==ZC._n_(OD.item)&&null!==ZC._n_(G=OD.item["hover-state"])&&L9.append(G)),L9.WJ=!0,L9.parse(),U2={},JF&&null!==ZC._n_(JF.separator)&&(U2=JF.separator);var JQ=[],EK=null;if(ABB=null!==ZC._n_(s.MT.o.empty)&&ZC._b_(s.MT.o.empty),ZC.mobile&&"none"!==(EK=G1("PageScroll")).enabled&&(null===s.DF||null===ZC._n_(s.DF["page-scroll"])||s.DF["page-scroll"]?JQ.push(GS("disablepagescroll",EK.text)):JQ.push(GS("enablepagescroll",EK.text)),JQ.push(J4("pagescroll"))),"none"!==(EK=G1("Reload")).enabled&&(JQ.push(GS("reload",EK.text)),JQ.push(J4("reload"))),"undefined"!=typeof ZC.A7W){EK=G1("SaveAsImage"),"none"!==EK.enabled&&("none"!==(EK=G1("SaveAsImagePNG")).enabled&&JQ.push(GS("viewaspng",EK.text?EK.text:null)),"none"!==(EK=G1("SaveAsImageJPG")).enabled&&JQ.push(GS("viewasjpg",EK.text?EK.text:null)),JQ.push(J4("export")));var T9=["DownloadPDF","DownloadSVG","DownloadCSV","DownloadXLS","ViewDataTable","ExportData","Print"],A5V=0,A1Q=0;for(i=0;i<T9.length;i++)"ViewDataTable"===T9[i]&&ZC.AK(s.K+"-data-table")&&(T9[i]="HideDataTable"),"none"!==(EK=G1(T9[i])).enabled&&(A5V++,A1Q=i,JQ.push(GS(T9[i].toLowerCase(),EK.text)));A5V>0&&JQ.push(J4(T9[A1Q].toLowerCase()))}if(-1!==LA){var GM=!1;for(j=0,J9=s.AH[LA].BM.length;j<J9;j++)s.AH[LA].BM[j].GM&&(GM=!0);if(GM&&"undefined"!=typeof ZC.AA0){var A0R=!1;EK=G1("ZoomIn"),"none"!==EK.enabled&&(JQ.push(GS("zoomin",EK.text)),A0R=!0),EK=G1("ZoomOut"),"none"!==EK.enabled&&(JQ.push(GS("zoomout",EK.text)),A0R=!0),EK=G1("ViewAll"),"none"!==EK.enabled&&(JQ.push(GS("viewall",EK.text)),A0R=!0),A0R&&JQ.push(J4("zoom"))}}var b2D=!1,b3D=!1;if(-1!==LA&&(-1!==ZC.AV(["line","area","bar","vbar","hbar","pie","mixed"],s.AH[LA].AF)&&(b2D=!0,s.X0="2d"),-1!==ZC.AV(["line3d","area3d","bar3d","vbar3d","hbar3d","pie3d","mixed3d"],s.AH[LA].AF)&&(b3D=!0,s.X0="3d")),(b2D||b3D)&&"none"!==(EK=G1("3D")).enabled&&"none"!==(EK=G1(b2D?"SwitchTo3D":"SwitchTo2D")).enabled&&(JQ.push(GS(b2D?"switchto3d":"switchto2d",EK.text)),JQ.push(J4("dimension"))),-1!==LA){var C=s.AH[LA],AAH=!1,ABN=!1;for(j=0;j<C.BM.length;j++){var B=C.BM[j];0===B.BC.indexOf("scale-y")&&(AAH=!0),"log"===B.CA&&(ABN=!0)}AAH&&"none"!==(EK=G1("Progression")).enabled&&"none"!==(EK=G1(ABN?"LinScale":"LogScale")).enabled&&(JQ.push(GS(ABN?"switchtolin":"switchtolog",EK.text)),JQ.push(J4("progression"))),(C.CX||C.H7)&&"none"!==(EK=G1("Guide")).enabled&&"none"!==(EK=G1(C.A1G?"HideGuide":"ShowGuide")).enabled&&(JQ.push(GS(C.A1G?"hideguide":"showguide",EK.text)),JQ.push(J4("guide")))}var AAV=0;if("undefined"!=typeof ZC.A8W&&("none"!==(EK=G1("ViewSource")).enabled&&(JQ.push(GS("viewsource",EK.text)),AAV++),"none"!==(EK=G1("BugReport")).enabled&&(JQ.push(GS("bugreport",EK.text)),AAV++)),AAV>0&&JQ.push(J4("tools")),"none"===(EK=G1("FullScreen")).enabled||s.LO||(s.QV?(EK=G1("ExitFullScreen"),JQ.push(GS("exitfullscreen",EK.text)),JQ.push(J4("exitfullscreen"))):(JQ.push(GS("fullscreen",EK.text)),JQ.push(J4("fullscreen")))),s.I7&&("none"!==(EK=G1("GoBack")).enabled&&JQ.push(GS("goback",EK.text)),"none"!==(EK=G1("GoForward")).enabled&&JQ.push(GS("goforward",EK.text)),JQ.push(J4("history"))),JQ.length>0&&-1!==JQ[JQ.length-1].indexOf("zc-menu-sep")&&JQ.splice(JQ.length-1,1),s.A1B={},-1!==LA){var B6;if(JF&&null!==ZC._n_(B6=JF["custom-items"]))for(JQ.length>0&&JQ.push(J4("custom")),i=0,A7=B6.length;i<A7;i++){var A3D=!0;if(null!==ZC._n_(B6[i].enabled)&&("none"===B6[i].enabled?A3D=!1:"all"!==B6[i].enabled&&(A3D=!ev||eval(B6[i].enabled).call(s,zingchart.A09(ev,s),B6[i].id,ev))),A3D){var AR,K=B6[i].id||"custom-"+i;"sep"===B6[i].id||"sep"===B6[i].type?JQ.push(J4(K)):"header"===B6[i].type?(AR=B6[i].text||"Custom Menu "+i,JQ.push(A2Q(K,AR,!0))):(AR=B6[i].text||"Custom Menu "+i,s.A1B[K]={fn:B6[i]["function"]||"",url:B6[i].url||"",target:B6[i].target||""},JQ.push(GS(K,AR,!0)))}}}s.TF||(JQ.push(J4("zingchart")),JQ.push(GS("xmiabt","About ZingChart"))),ZC.Q.HX({id:s.K+"-menu",p:document.body,cls:"zc-menu zc-style",top:null===ZC._n_(GR)?0:GR.iY+GR.F/2,left:null===ZC._n_(GR)?0:GR.iX+GR.I/2,borderBottom:s.MT.AT+"px solid "+s.MT.BV,background:(-1===s.MT.A0?"transparent":s.MT.A0)+" "+A1J(s.MT.D9),paddingTop:s.MT.FJ,paddingRight:s.MT.FK,paddingBottom:s.MT.FR,paddingLeft:s.MT.EP,html:JQ.join("")}),s.D["menu-item-events"]||(s.AGQ=function(e){var t,i=1!==e.target.nodeType?e.target.parentNode.id:e.target.id,n=i.substring(0,i.indexOf("-menu-item-")),a=zingchart.getLoader(n);ZC.mobile&&a.OP();var r=a.A4O(a.SN[0],a.SN[1]);a.hideCM(),ZC.mobile&&zingchart.SA(e);var l=i.replace(a.K+"-menu-item-","");a.AAG({graphid:r?r.K:null,menuitemid:l,ev:ZC.A4.C0(e)});var o=a.o["export-filename"]||a.o.graphset[0]["export-filename"]||"";switch(l){case"switchto2d":case"switchto3d":r&&a.A51(r.K);break;case"enablepagescroll":s.DF=s.DF||{},s.DF["page-scroll"]=!0;break;case"disablepagescroll":s.DF=s.DF||{},s.DF["page-scroll"]=!1;break;case"showguide":a.YY(r.K,!0);break;case"hideguide":a.YY(r.K,!1);break;case"switchtolin":a.A0P(r.K,"lin");break;case"switchtolog":a.A0P(r.K,"log");break;case"reload":a.A8R();break;case"viewaspng":a.O5("png");break;case"viewasjpg":a.O5("jpeg");break;case"downloadpdf":a.O5("pdf",""===o?null:{fn:o});break;case"downloadsvg":a.O5("svg",""===o?null:{fn:o});break;case"exportdata":zingchart.exec(a.K,"exportdata");break;case"downloadcsv":zingchart.exec(a.K,"downloadCSV",""===o?null:{fn:o});break;case"downloadxls":(t=G1("DownloadXLS"))["custom-function"]?a.A40({graphid:r?r.K:null,menuitemid:l,filename:o,"function":t["custom-function"]}):zingchart.exec(a.K,"downloadXLS",""===o?null:{fn:o});break;case"viewdatatable":case"hidedatatable":zingchart.exec(a.K,"viewDataTable",{menuid:l});break;case"print":a.A97();break;case"viewsource":a.A5L();break;case"bugreport":a.A6I();break;case"fullscreen":a.A5M();break;case"goback":zingchart.exec(a.K,"goback");break;case"goforward":zingchart.exec(a.K,"goforward");break;case"zoomin":r&&(a.H9.C=r,a.A8N({graphid:r.K,ev:e}));break;case"zoomout":r&&(a.H9.C=r,a.A7R({graphid:r.K,ev:e}));break;case"viewall":r&&(a.H9.C=r,a.A7N({graphid:r.K,ev:e}));break;case"xmiabt":a.A9D();break;default:null!==ZC._n_(G=s.A1B[l])&&(""!==G.fn?a.A40({graphid:r?r.K:null,menuitemid:l,"function":G.fn}):""!==G.url&&r&&r.UQ(e,G.url,G.target))}},s.AFX=function(){this.style.backgroundColor=L9.A0,this.style.color=L9.C1,this.style.borderLeft=this.style.borderRight=L9.AT+"px solid "+L9.BV},s.AGM=function(){this.style.backgroundColor=E1.A0,this.style.color=E1.C1,this.style.borderLeft=this.style.borderRight=E1.AT+"px solid "+E1.BV},s.TE=function(e){return e.preventDefault(),!1},ZC.A4("#"+s.K+"-menu").live("mousedown",s.TE),ZC.A4("."+s.K+"-menu-item").live("mousedown",s.TE),ZC.A4("."+s.K+"-menu-item").live("click touchend",s.AGQ).live("mouseover",s.AFX).live("mouseout",s.AGM),s.D["menu-item-events"]=!0)}}},destroy:function(){var e=this;e._unbind_(),zingchart.HU.length-=1,e.clear(),ZC.A4("#zc-fullscreen").remove(),document.body.style.overflow=""},MV:function(e,t){var i,n=this;if(null===ZC._n_(t)&&(t=!1),(t||n.A0C)&&-1===ZC.AV(n.KM,"skip_interactivity"))if(n.ZM=!0,t&&ZC.Q.HX({id:n.K+"-dummy",p:ZC.AK(n.K),wh:n.I+"/"+n.F}),n.D.hideprogresslogo||zingchart.DEV.SKIPPROGRESS)n.ZM=!1;else{var a=ZC.A4("#"+n.K);if(!(void 0===a.offset()||a.width()+a.height()===0||n.D.hideprogresslogo&&n.TF)){var r=a.offset().left+ZC._i_(a.css("border-left-width"))+(null===e?n.iX:e.iX),l=a.offset().top+ZC._i_(a.css("border-top-width"))+(null===e?n.iY:e.iY);(ZC.ipad||ZC.iphone)&&(r-=ZC.A4(window).scrollLeft(),l-=ZC.A4(window).scrollTop());var o=null===e?n.I:e.I,s=null===e?n.F:e.F,c=ZC._i_(.8*n.I),h=30,C=new ZC.DS(n);n.B8.load(C.o,"loader.gui.progress"),C.append(n.D.progress),null!==n.DF&&null!==ZC._n_(i=n.DF.progress)&&C.append(i),C.parse();var u,d=ZC.HI["progress-wait-long"];if(ZC.ie67)u=C.A0;else{var p=n.D.customprogresslogo||ZC.IMAGES["zc.logo"];u=C.A0+" url("+p+") no-repeat center center"}(o<180||s<90)&&(u=C.A0,h=-12),o<120&&o>60?(c=60,d=ZC.HI["progress-wait-short"]):o<60&&(c=20,d=ZC.HI["progress-wait-mini"]),d=n.D.customprogresstext||d;var A=ZC.Q.HX({id:n.K+"-progress",p:document.body,tl:l+"/"+r,width:o-2*C.AT,height:s-2*C.AT,position:"absolute",opacity:.8,border:C.AT+"px solid "+C.BV,background:u});ZC.Q.HX({id:n.K+"-progress-text",p:A,width:c,html:d,textAlign:"center",marginLeft:ZC._i_((o-c)/2),marginTop:ZC._i_(s/2+h),fontFamily:zingchart.FONTFAMILY,fontSize:zingchart.FONTSIZE,color:C.C1,fontWeight:"bold"})}}},A0G:function(){var e=this;ZC.Q.EU(e.K+"-dummy"),e.D.hideprogresslogo||(e.ZM=!1,ZC.Q.EU([e.K+"-progress-text",e.K+"-progress"]))},A4J:function(e,t){var i,n,a=this;i=null!==ZC._n_(n=e.graphset)?n:[e];var r=e.layout||"",l=ZC.AO.A20(r,i.length),o=i[t],s=a.I/l[1],c=a.F/l[0],h=Math.floor(t/l[1]),C=t%l[1]*s,u=h*c;o&&(null!==ZC._n_(n=o.x)&&(C=ZC._p_(n))<=1&&(C=ZC._i_(C*a.I)),null!==ZC._n_(n=o.y)&&(u=ZC._p_(n))<=1&&(u=ZC._i_(u*a.F)),null!==ZC._n_(n=o.width)&&(s=ZC._p_(n))<=1&&(s=ZC._i_(s*a.I)),null!==ZC._n_(n=o.height)&&(c=ZC._p_(n))<=1&&(c=ZC._i_(c*a.F)));var d=[0,0,0,0];return o.plotarea&&null!==ZC._n_(o.plotarea.margin)&&(d=new ZC.HS(null).m_(o.plotarea.margin,"all",s,c)),{graph:{x:ZC._i_(C),y:ZC._i_(u),width:ZC._i_(s),height:ZC._i_(c),index:t},plotarea:{x:d[3],y:d[0],width:s-d[1]-d[3],height:c-d[0]-d[2]}}},K3:function(){var e=this;null===ZC._n_(e.o.graphset)&&(e.o={graphset:[e.o]}),e.MV(),zingchart.A15(e,e.A4R(),function(){e.o=ZC.AP.BZ("dataparse",e,e.FH(),e.o),zingchart.XR[e.K]&&e.Q1(function(){e.parse(),e.paint()})})},render:function(){function e(){function e(){""!==t.QN||null!==t.MM?t.A8O():t.load()}t.UA||t.A8U(),t.MV(null,!0),zingchart.TIMEOUT>0?ZC.ZH(e):e()}var t=this;zingchart.ACH("progress")?ZC.AP.AC7(zingchart.MODULESDIR+"zingchart-progress.min.js",e):e()},YS:function(e){var t=this;null===ZC._n_(t.A3Q)&&(t.A3Q=(new Date).getTime(),t.AAT=window.setTimeout(function(){null!==ZC._n_(t.A3Q)&&(t.A3Q=null,zingchart.YU(e))},1500))},FH:function(){var e,t=this,i=0,n=0;return i="undefined"!=typeof t.SN[0]?t.SN[0]-i:0,n="undefined"!=typeof t.SN[1]?t.SN[1]-n:0,e=t.LH?t.LH:"light",{id:t.K,width:t.I,height:t.F,output:t.AC,x:i,y:n,targetid:t.SN[2],theme:e}},ABW:function(e){var t=this;e=e||{},null!==ZC._n_(e.resource)&&(t.QS[e.resource]=e.data||"[]",t.UD++)},A8N:function(){},A7R:function(){},A7N:function(){},PW:function(){},AA1:function(e,t){var i=this;if(e=e||{},null!==ZC._n_(e.graphid)){var n=i.OR(e.graphid);null!==n&&n.clear()}else i.clear(null,null,t);ZC.K1&&ZC.K1.GUIDES&&(ZC.K1.GUIDES[i.K]=null)},A83:function(e){e=e||ZC.HI["sync-wait"];var t=this;if(null===ZC.AK(t.K+"-blocker")){ZC.Q.HX({cls:"zc-abs zc-style zc-blocker",id:t.K+"-blocker",p:ZC.AK(t.K+"-top"),wh:t.I+"/"+t.F,opacity:.75}),ZC.Q.HX({cls:"zc-blocker-msg",id:t.K+"-blocker-t",p:ZC.AK(t.K+"-blocker"),html:e});var i=ZC.A4("#"+t.K+"-blocker-t");i.css("top",t.F/2-i.height()/2+"px").css("left",t.I/2-i.width()/2+"px")}},A3T:function(){ZC.Q.EU(this.K+"-blocker")},A9D:function(){var e=this;ZC.AP.BZ("about_show",e,e.FH()),ZC.Q.HX({cls:"zc-abs",id:e.K+"-about-mask",p:ZC.AK(e.K+"-top"),wh:e.I+"/"+e.F,background:"#ccc",opacity:.75});var t=ZC.CY(320,e.I),i=ZC.CY(215,e.F),n=ZC.BQ(0,(e.I-t)/2),a=ZC.BQ(0,(e.F-i)/2),r=ZC.Q.HX({cls:"zc-about zc-style",id:e.K+"-about",p:ZC.AK(e.K+"-top"),tl:a+"/"+n,wh:t-(ZC.quirks?0:10)+"/"+(i-(ZC.quirks?0:10))}),l="";""!==e.S8&&(l="Custom Built for<br />"+e.S8),r.innerHTML='<div class="zc-about-1"><a href="http://www.zingchart.com" target="_blank">zingchart.com</a></div><div class="zc-about-2">&copy;2009-'+(new Date).getFullYear()+'</div><div class="zc-about-3"><div id="'+e.K+'-about-close">'+ZC.HI["about-close"]+'</div></div><div class="zc-about-4" style="padding:'+(i-215)+'px 5px 5px 5px;"><div>&nbsp;<br />Build '+ZC.VERSION+" ["+e.AC+"]</div>"+l+"</div>",ZC.A4("#"+e.K+"-about-close").bind("click",function(){ZC.AP.BZ("about_hide",e,e.FH()),ZC.Q.EU([e.K+"-about",e.K+"-about-mask"])})},NP:function(e,t){var i=this;if(ZC.AP.A7Y("error",i))ZC.AP.BZ("error",i,{id:i.K,error:e,section:t,json:i.D.json||i.D.rawsource});else{var n="";n+="object"==typeof e?e.name+":"+e.message+"\n\n":e+"\n\n",null!==ZC._n_(t)&&(n+="Section:"+t+"\n\n"),n+="JSON data:\n\n"+i.D.json+"\n\n",i.A0G(),null===ZC.AK(i.K+"-top")&&i.AAU(),ZC.Q.HX({cls:"zc-abs zc-error zc-style",id:i.K+"-error",p:ZC.AK(i.K+"-top"),wh:i.I-(ZC.quirks?0:10)+"/"+(i.F-(ZC.quirks?0:10))}).innerHTML='<div class="zc-form-row-label zc-form-s0">'+ZC.HI["error-header"]+'</div><div class="zc-form-row-label zc-form-s1">'+ZC.HI["error-message"]+'</div><div class="zc-form-row-element"><textarea id="'+i.K+'-error-message" style="width:'+(i.I-35)+"px;height:"+(i.F-135)+'px;"></textarea></div><div class="zc-form-row-element zc-form-row-last"><input type="button" value="'+ZC.HI["error-close"]+'" id="'+i.K+'-error-close" /></div>',ZC.A4("#"+i.K+"-error-message").val(ZC.GT(n)),ZC.A4("#"+i.K+"-error-close").bind("click",function(){ZC.Q.EU(i.K+"-error")})}},A5L:function(){},A6I:function(){},A5M:function(){var e=this,t=document.createElement("div");t.id="zc-fullscreen",t.style.zIndex=zingchart.FSZINDEX,t.style.overflow="hidden";var i=document.body,n=!1;zingchart.FSID&&ZC.AK(zingchart.FSID)&&(n=!0,(i=ZC.AK(zingchart.FSID)).style.display="block"),i.appendChild(t),ZC.FSSTATUS={};var a,r;for(a=0,r=e.AH.length;a<r;a++){var l=e.AH[a];if(null!==l.AY)for(var o=0,s=l.AY.A6.length;o<s;o++)ZC.FSSTATUS["g-"+l.L+"-p-"+o]=l.D["plot"+o+".visible"]}ZC.Q.EU(e.K+"-data-table");var c,h=JSON.parse(e.D.json),C=h.graphset;for(a=C.length-1;a>=0;a--)if(C[a].generated)C.splice(a,1);else{if(null!==ZC._n_(C[a].shapes))for(c=C[a].shapes.length-1;c>=0;c--)C[a].shapes[c].generated&&C[a].shapes.splice(c,1);if(null!==ZC._n_(C[a].labels))for(c=C[a].labels.length-1;c>=0;c--)C[a].labels[c].generated&&C[a].labels.splice(c,1)}n||window.scroll(0,0),zingchart.render({id:"zc-fullscreen",output:e.AC,width:ZC.A4(n?i:window).width(),height:ZC.A4(n?i:window).height(),fullscreenmode:!0,theme:e.LH,modules:e.A1I,data:h,defaults:e.MM,defaultsurl:e.QN})},A0P:function(e,t){var i,n,a,r=this,l=0,o=!1;for(i=0,n=r.AH.length;i<n;i++)if(e===r.AH[i].K){for(l=i,a=0;a<r.AH[i].AY.A6.length;a++)if(r.AH[i].AY.A6[a].IG){o=!0;break}var s;for(s=r.AH[l].AJ["3d"]||o?r.o.graphset[i]:r.AH[i].o,a=0;a<10;a++){var c="scale-y"+(0===a?"":"-"+a);null===ZC._n_(s[c])&&null===ZC._n_(s[ZC.EC(c)])&&null!==r.AH[i].BN(c)?s[c]={progression:t}:(null!==ZC._n_(s[c])&&(s[c].progression=t),null!==ZC._n_(s[ZC.EC(c)])&&(s[ZC.EC(c)].progression=t))}}delete r.D["graph"+l+".zoom"],r.AH[l].AJ["3d"]||o?r.K3():r.AH[l].K3(!0,!0)},YY:function(e,t){var i=this;if(i.D5){for(var n=0,a=i.AH.length;n<a;n++)e===i.AH[n].K&&(i.AH[n].A1G=t,i.AH[n].D["guide-on"]=t);if(t){var r=ZC.A4("#"+i.K+"-top"),l={_pageX_:ZC.DX[0]-r.offset().left,_pageY_:ZC.DX[1]-r.offset().top,type:"mousemove",target:{id:i.K+"-img"}};i.D5.Q6(l)}else ZC.K1.clearGuide(i.K)}},A51:function(e){for(var t=this,i=["line","area","bar","vbar","hbar","pie","mixed"],n=0,a=t.AH.length;n<a;n++)if(e===t.AH[n].K){var r=t.o.graphset[n];if("mixed"===r.type)for(var l=0,o=r.series.length;l<o;l++){var s=r.series[l];s.type=s.type||"line","3d"===t.X0?s.type=s.type.replace("3d",""):-1!==ZC.AV(i,s.type)&&(s.type=s.type+"3d")}else"3d"===t.X0?r.type=r.type.replace("3d",""):-1!==ZC.AV(i,r.type)&&(r.type=r.type+"3d")}t.X0="3d"===t.X0?"2d":"3d",t.D.json=ZC.GT(JSON.stringify(t.o)),t.K3()},A8R:function(e){for(var t,i=this,n=0;n<i.AH.length;n++)delete i.D["g"+n+"-legend-collapsed"];if(e=e||{},ZC.AP.BZ("reload",i,{id:i.K,graphid:e.graphid}),null!==ZC._n_(t=e.graphid)){var a=i.C9(t);null!==a&&(i.MV(a),i.load(a.K))}else i.QQ=[],i.NY=-1,i.MV(),i.clearGenerated(),i.load()},ACU:function(e){var t,i=this;if(e=e||{},null!==ZC._n_(t=e.graphid)){var n=i.C9(t);null!==n&&null!==ZC._n_(e.dataurl)&&(i.MV(n),i.load(t,e.dataurl))}else null!==ZC._n_(t=e.dataurl)&&(i.QB=t,i.MV(),i.load())},A97:function(){},O5:function(){},Z0:function(){},AAG:function(e){var t=this;ZC._cp_(t.FH(),e),ZC.AP.BZ("menu_item_click",t,e)},A40:function(O){var s=this;try{var E0=ZC.AP.AA8(O["function"]);O["function"]=E0[0],O.arguments=E0[1],ZC._cp_(s.FH(),O),eval(O["function"]).call(s,O)}catch(J7){return s.NP(J7,"JavaScript data loader"),!1}},C9:function(e){var t=this;return null!==ZC._n_(e)?t.OR(e):t.AH.length>0?t.AH[0]:null},bind:function(e,t){zingchart.bind(this.K,e,t)},unbind:function(e,t){zingchart.unbind(this.K,e,t)},exec:function(e,t){return zingchart.exec(this.K,e,t)},gc:function(){for(var e=0,t=this.AH.length;e<t;e++)this.AH[e].gc()}}),ZC.JS=ZC.HS.C7({$i:function(e){this.b(e);var t=this;t.O4="zcgraph",t.H=e,t.AF="",t.IX=null,t.KJ=null,t.MP=null,t.RZ=null,t.P=null,t.BA=null,t.I9=null,t.I6=null,t.A5F=1,t.VB=1,t.A4Z=1,t.L=0,t.HM=null,t.M8=[1,0],t.A9Y=null,t.CB=!1,t.KQ="normal",t.BM=[],t.BX=[],t.XX=[],t.FE=[],t.LD=[],t.AY=new ZC.LF(t),t.H9=null,t.BF=null,t.A8=null,t.CX=null,t.H7=null,t.A1K="always",t.ABK=!0,t.M9="",t.RF=null,t.LG=!1,t.U9=!1,t.N6=0,t.Y8=!1,t.PX=!1,t.F0={true3d:1,angle:45,depth:40,"x-angle":0,"y-angle":0,"z-angle":0,zoom:1},t.AJ={"enable-guide":!1,"enable-preview":!1,"enable-scroll":!1,"enable-zooming":!0,"3d":!1,clip:!1,layout:"","enable-animation":!0,"angle-min":15,"angle-max":75,"x-angle-min":-65,"x-angle-max":65,"y-angle-min":-65,"y-angle-max":65,"z-angle-min":-65,"z-angle-max":65},t.O7=!1,t.A0X=!1,t.A93=[],t.A1G=!0,"undefined"!=typeof ZC.PB&&(t.LT=new ZC.PB(t)),t.GA=!1,t.CH={},t.IT=[],t.KD=!1,t.HF=!1,t.L4=0,t.BP=[],t.A43=!0,t.U8=zingchart.DEV.STACKINGLOGIC,-1===t.U8&&(t.U8=0)},getPMap:function(){var e=this.b();return this.addPMap(e,"index","L"),e},getToggleAction:function(){var e,t=this,i="hide";return t.BF&&""!==t.D["legend-last-trigger"]&&"undefined"!=typeof t.D["legend-last-trigger"]?i="item"===t.D["legend-last-trigger"]?t.BF.QX:t.BF.PL:(t.o.legend&&(e=t.o.legend["toggle-action"])&&(i=e),t.o.legend&&t.o.legend.item&&(e=t.o.legend.item["toggle-action"])&&(i=e)),(t.A.K5||t.D["toggle-action-remove"])&&(i="remove"),i},BT:function(e,t){void 0===t&&(t=!1);for(var i=[],n=this,a=0,r=n.BM.length;a<r;a++)n.BM[a].AF===e&&(!t||t&&n.BM[a].X.length>0)&&i.push(n.BM[a]);return i},BN:function(e){for(var t=this,i=0,n=t.BM.length;i<n;i++)if(t.BM[i].BC===e)return t.BM[i];return null},A2A:function(e){return e},ACF:function(e){return new ZC.AAB(this,e)},ACI:function(){for(var e=this,t=0,i=e.BM.length;t<i;t++){var n=e.BM[t],a=n.BC;e.A.B8.load(n.o,["("+e.AF+").SCALE","("+e.AF+")."+a.replace(/\-[0-9]+/,""),"("+e.AF+")."+a.replace(/\-[0-9]+/,"-n"),"("+e.AF+")."+a],!1,!0);var r=a.replace(/\-[0-9]+/,"")+"-n";e.o[r]&&n.append(e.o[r]),e.o[a]&&n.append(e.o[a]),e.AJ["3d"]&&e.A.B8.load(n.o,["("+e.AF+").SCALE[3d]","("+e.AF+")."+a.replace(/\-[0-9]+/,"")+"[3d]","("+e.AF+")."+a.replace(/\-[0-9]+/,"-n")+"[3d]","("+e.AF+")."+a+"[3d]"],!1,!0),e.AJ["3d"]&&n.append(e.o[a+"[3d]"]),n.parse()}},ABD:function(){return null},A99:function(e){var t,i,n=this,a=0,r=n.AY.A6.length;for(t=0;t<r;t++)a=ZC.BQ(a,n.AY.A6[t].R.length);var l;for(t=0,i=n.BM.length;t<i;t++)(l=n.BM[t]).A9L(e),2===e&&(l.JE=function(e){return e=e.replace(/(%N|%node-count)/g,a),e=e.replace(/(%P|%plot-count)/g,r),e=e.replace(/(%S|%scale-values-count)/g,l.X.length)},l.DE()&&l.parse()),null===ZC._n_(l.o["max-items"])&&null===ZC._n_(l.o["max-labels"])&&l.A7I(),null===ZC._n_(l.o["max-ticks"])&&l.AC4()},UV:function(){},NW:function(){},ADC:function(){},ABQ:function(){},setupPlotArea:function(){var e=this,t=e.A.B8,i="("+e.AF+")";e.P=new ZC.HS(e),e.P.O8="plotarea",e.P.K=e.K+"-plotarea";var n=[i+".plotarea"];if(e.BA&&n.push(i+".plotarea[preview]"),e.AJ["3d"]&&n.push(i+".plotarea[3d]"),t.load(e.P.o,n),e.P.append(e.o.chart),e.P.append(e.o.plotarea),e.BA&&e.P.append(e.o["plotarea[preview]"]),e.AJ["3d"]&&e.P.append(e.o["plotarea[3d]"]),"dynamic"===e.P.o["margin-top"]||"dynamic"===e.P.o["margin-right"]||"dynamic"===e.P.o["margin-bottom"]||"dynamic"===e.P.o["margin-left"]){var a=String(e.P.o.margin||"").split(/\s+|;|,/),r=a.length>0?a[0]:"",l=a.length>1?a[1]:"",o=a.length>0?a[2]||a[0]:"",s=a.length>1?a[3]||a[1]:"";"dynamic"===e.P.o["margin-top"]&&(r="dynamic"),"dynamic"===e.P.o["margin-right"]&&(l="dynamic"),"dynamic"===e.P.o["margin-bottom"]&&(o="dynamic"),"dynamic"===e.P.o["margin-left"]&&(s="dynamic"),e.P.o.margin=[r,l,o,s].join(" ")}if(e.D["plotarea-margins"]?e.P.o.margin=e.D["plotarea-margin"]:(e.D["plotarea-margins"]=!0,e.D["plotarea-margin"]=e.P.o.margin,e.D["plotarea-margin-top"]=e.P.o["margin-top"],e.D["plotarea-margin-right"]=e.P.o["margin-right"],e.D["plotarea-margin-bottom"]=e.P.o["margin-bottom"],e.D["plotarea-margin-left"]=e.P.o["margin-left"]),"undefined"!=typeof e.D["plotarea-p-x"]&&(e.P.D["p-x"]=e.D["plotarea-p-x"],e.P.D["p-y"]=e.D["plotarea-p-y"],e.P.D["p-width"]=e.D["plotarea-p-width"],e.P.D["p-height"]=e.D["plotarea-p-height"]),null!==ZC._n_(e.P.o["adjust-layout"])&&ZC._b_(e.P.o["adjust-layout"])&&(e.P.o.margin="dynamic"),e.P.parse(),e.AJ["3d"]&&!e.F0.true3d){var c=ZC._a_(ZC._i_(e.F0.depth*ZC.EO(e.F0.angle)));e.P.iY+=c,e.P.F-=c,e.P.I-=ZC._i_(e.F0.depth*ZC.EF(e.F0.angle))}if("undefined"!=typeof e.D["plotarea-p-x"])for(var h=0,C=e.BM.length;h<C;h++)e.BM[h].A44(),e.BM[h].IW()},setupDynamicPlotArea:function(){var e,t,i,n=this,a=["top","right","bottom","left"],r={};for(t=0;t<a.length;t++)r[a[t]]=!1,n.D["plotarea.d-margin-"+a[t]]&&(n.o.plotarea["margin-"+a[t]]=null),n.o.plotarea&&"dynamic"===n.o.plotarea["margin-"+a[t]]&&(r[a[t]]=!0,n.o.plotarea["margin-"+a[t]]="20");var l=!1,o={};if("xy"===n.AJ.layout&&(l=!0),("xy"===n.AJ.layout||"yx"===n.AJ.layout)&&(n.P.D["d-margin"]||n.D["plotarea.d-margin"])){for(var s=0,c=n.BM.length;s<c;s++){var h=0,C=0,u="",d=n.BM[s];if(d.AM&&d.T3){"k"===d.AF?u=d.CQ?"default"===d.B9?"left":"right":"default"===d.B9?"bottom":"top":"v"===d.AF&&(u=d.CQ?"default"===d.B9?"bottom":"top":"default"===d.B9?"left":"right");var p=0;if(n.P.D["d-margin-"+u]||n.D["plotarea.d-margin-"+u]){var A=new ZC.DS(d);A.copy(d.BR);var g=ZC.BQ(1,ZC._i_((d.A1-d.V)/d.EE));for(t=d.V;t<=d.A1;t+=g)if(A.AR=d.FO(t),A.A21&&("k"===d.AF&&!d.CQ||"v"===d.AF&&d.CQ)&&(A.o.width=ZC._i_(.9*d.A9)),A.parse(),A.AM)if(C=ZC.BQ(C,A.AA%180==0?A.F:A.I),h=ZC.BQ(h,A.AA%180==0?A.I:A.F),p=ZC.BQ(p,1.5*A.DK*(A.AR||"").split(/<br>|<br\/>|<br \/>|\n/).length),"top"===u||"bottom"===u){if(p=ZC.BQ(p,.465*A.DK+1.025*ZC._a_(ZC.EO(A.AA))*ZC.BQ(A.I,A.F)),h=A.I,C=p,l&&"k"===d.AF){o[d.BC]||(o[d.BC]=[]);var f=null===ZC._n_(A.o["auto-align"])||ZC._b_(A.o["auto-align"]),Z=.465*A.DK+1.025*ZC._a_(ZC.EF(A.AA))*ZC.BQ(A.I,A.F);"default"===d.B9?(f&&(ZC.DT(ZC._ang_(A.AA),90,180)||ZC.DT(ZC._ang_(A.AA),270,360))&&o[d.BC].push(Z),f||o[d.BC].push(Z/2)):(f&&(ZC.DT(ZC._ang_(A.AA),0,90)||ZC.DT(ZC._ang_(A.AA),180,270))&&o[d.BC].push(Z),f||o[d.BC].push(Z/2))}}else h=p=ZC.BQ(p,.465*A.DK+1.025*ZC._a_(ZC.EF(A.AA))*ZC.BQ(A.I,A.F)),C=A.F;var _=new ZC.DS(d);_.copy(d.M),_.AR=d.M.AR,_.parse(),""!==_.AR&&_.AM&&(C+=_.AA%180==0?_.F:_.I,h+=_.AA%180==0?_.I:_.F)}if(n.o.plotarea||(n.o.plotarea={}),("dynamic"===n.o.plotarea["margin-"+u]||n.P.D["d-margin-"+u])&&(n.P.D["d-margin-"+u]=!1,r[u]=!0,n.o.plotarea["margin-"+u]="0"),r[u]){n.o.plotarea["margin-"+u]=ZC._f_(n.o.plotarea["margin-"+u]||"0"),n.D[d.BC+"-distance"]=n.o.plotarea["margin-"+u];var b=("top"===u||"bottom"===u?ZC._i_(C):ZC._i_(h))+10+(n.AJ["3d"]?20:0);if(d.V7?n.o.plotarea["margin-"+u]=ZC.BQ(n.o.plotarea["margin-"+u],b):n.o.plotarea["margin-"+u]+=b,null!==ZC._n_(n.o.plotarea["margin-"+u+"-offset"])&&(n.o.plotarea["margin-"+u]+=ZC._i_(n.o.plotarea["margin-"+u+"-offset"])),!n.A.TF){var m={},v=n.A.DF.watermark;n.A.B8.load(m,"loader.gui.watermark"),v&&ZC._cp_(v,m),1===n.A.o.graphset.length&&n.A.o.graphset[0].gui&&(e=n.A.o.graphset[0].gui.watermark)&&ZC._cp_(e,m);var D=m.position||"br";-1===ZC.AV(["tl","tr","br","bl"],D)&&(D="br"),("bottom"!==u||"bl"!==D&&"br"!==D)&&("top"!==u||"tl"!==D&&"tr"!==D)||(n.o.plotarea["margin-"+u]+=15)}"bottom"===u&&("xy"===n.AJ.layout&&n.I9||"yx"===n.AJ.layout&&n.I6)&&(n.o.plotarea["margin-"+u]+=15),"left"===u&&("xy"===n.AJ.layout&&n.I6||"yx"===n.AJ.layout&&n.I9)&&(n.o.plotarea["margin-"+u]+=15),n.D["plotarea.d-margin-"+u]=!0}}}if(l&&r.left&&null!==ZC._n_(n.o.plotarea["margin-left"]))for(var E in o){var w=n.BN(E);for(t=0;t<o[E].length;t++)ZC._i_(n.o.plotarea["margin-left"])+t*w.A9+(w.DL?w.A9/2:0)-o[E][t]<0&&(n.o.plotarea["margin-left"]=o[E][t]-t*w.A9-(w.DL?w.A9/2:0))}ZC.Q.IQ(ZC.AK(n.K+"-plotarea-c"),n.H.AC,n.P.iX,n.P.iY,n.P.I,n.P.F,n.K),n.D["plotarea.paint"]=!0,n.setupPlotArea();var B=2,K=6;null!==ZC._n_(e=n.P.o["mask-tolerance"])&&(e instanceof Array?(B=K=ZC._i_(e[0]),e.length>1&&(K=ZC._i_(e[1]))):B=K=ZC._i_(e)),n.P.D.tolerance=B,"svg"===n.H.AC?((e=ZC.AK(n.K+"-clip-shape"))&&e.setAttribute("points",n.M3(B,"svg")),(e=ZC.AK(n.K+"-clip-hover-shape"))&&e.setAttribute("points",n.M3(K,"svg"))):(ZC.A4("#"+n.K+" div").each(function(){""!==this.style.clip&&(this.style.clip=n.M3(B))}),(e=ZC.AK(n.K+"-hover"))&&""!==e.style.clip&&(e.style.clip=n.M3(K)))}for(t=0,i=n.BM.length;t<i;t++)n.BM[t].A44(),n.BM[t].IW()},parse:function(){var e,t,i,n,a,r,l,o,s,c=this,h=c.A.B8,C="("+c.AF+")";(e=c.A.D["graph-state-"+c.L])&&(c.D=JSON.parse(e),null===ZC._n_(c.D["guide-on"])||ZC._b_(c.D["guide-on"])||(c.A1G=!1)),c.D.legend_toggle_action||(c.A.D["graph-"+c.K+"-legend-info"]=null),c.D.legend_toggle_action=null,c.M9="parse.init",c.b(),c.ADC(),-1!==JSON.stringify(c.o).indexOf("zingchart.maps")&&(c.o.plotarea=c.o.plotarea||{},c.o.plotarea.margin=0);var u=null;if(!zingchart.SKIP.CSV&&((e=c.o["html5-csv"])&&(c.RF=e["html5-url"]),(e=c.o.csv)&&("object"==typeof e?e.url?c.RF=e.url:e["data-string"]&&(u=e["data-string"]):c.RF=e),""!==c.RF&&null!==ZC._n_(c.A.A9K[c.RF])&&(u=c.A.A9K[c.RF]),c.H.NT&&(u=c.H.NT),u)){var d=c.ACF(u);c.o=d.parse()}if(c.LG=zingchart.ASYNC,c.assign_a([["utc","U9","b"],["timezone","N6","f"],["async","LG","b"],["stacked","CB","b"],["stack-type","KQ"],["animate-type","A1K"],["url-data","A9Y"],["page","L4","i"],["palette","BP"],["sort-objects","A43","b"]]),c.BP.length>0)for(h.B8.palette=[],n=0;n<c.BP.length;n++){var p=c.BP[n],A=ZC.AP.JH(c.BP[n],10),g=ZC.AP.QT(c.BP[n],10);h.B8.palette.push(["#fff",p,A,g])}"pie3d"===c.AF&&(c.F0.true3d=!0),(c.AJ["3d"]||c.A.A10)&&(c.LG=!1),c.ABQ(),-1===ZC.AV(c.H.KM,"skip_interactivity")&&((null!==ZC._n_(e=c.o.preview)||h.PF("preview",c.AF))&&c.AJ["enable-preview"]&&(c.BA&&!c.D["force-preview-parse"]||"undefined"==typeof ZC.A8E||(c.D["force-preview-parse"]=!1,c.BA=new ZC.A8E(c),c.BA.O8="preview",h.load(c.BA.o,C+".preview"),"yx"===c.AJ.layout&&h.load(c.BA.o,C+".preview[yx]"),(t=c.o.plotarea)&&c.BA.append({"background-color":t["background-color"],"background-color-1":t["background-color-1"],"background-color-2":t["background-color-2"],"gradient-stops":t["gradient-stops"],"gradient-colors":t["gradient-colors"]}),c.BA.append(e),c.BA.parse())),(null!==ZC._n_(e=c.o["scroll-x"])||h.PF("scroll-x",c.AF))&&c.AJ["enable-scroll"]&&(c.I9||"undefined"==typeof ZC.A3A||(c.I9=new ZC.A3A(c,"x"),c.I9.O8="scrollx",h.load(c.I9.o,C+".scroll-x"),c.I9.append(e),c.I9.parse())),(null!==ZC._n_(e=c.o["scroll-y"])||h.PF("scroll-y",c.AF))&&c.AJ["enable-scroll"]&&(c.I6||"undefined"==typeof ZC.A3A||(c.I6=new ZC.A3A(c,"y"),c.I6.O8="scrolly",h.load(c.I6.o,C+".scroll-y"),c.I6.append(e),c.I6.parse()))),c.setupPlotArea(),c.NW(),c.BM=[],c.ACI(),c.A99(1),null!==ZC._n_(e=c.o.series)&&(c.AY.o=e);var f=c.AY.o;for(n=0;n<f.length;n++)if(f[n].rel)for(s=0;s<f.length;s++)f[s].id&&f[s].id===f[n].rel&&(c.AY.o[n].values=[].concat(c.AY.o[s].values));if(c.AY.parse(),c.A99(2),(null!==ZC._n_(e=c.o.title)||h.PF("title",c.AF))&&(c.IX=new ZC.DS(c),c.IX.O8="title",h.load(c.IX.o,C+".title"),c.IX.append(e),c.IX.K=c.K+"-title",c.IX.K5=!0,c.IX.parse(),null===ZC._n_(c.IX.o.x))){var Z=c.iX,_=c.I;switch("plotarea"===c.IX.o["center-point"]&&(Z=c.P.iX,_=c.P.I),c.IX.OB){case"left":c.IX.iX=Z;break;case"center":c.IX.iX=Z+_/2-c.IX.I/2;break;case"right":c.IX.iX=Z+_-c.IX.I}}(null!==ZC._n_(e=c.o.subtitle)||h.PF("subtitle",c.AF))&&(c.KJ=new ZC.DS(c),c.KJ.O8="subtitle",h.load(c.KJ.o,C+".subtitle"),c.KJ.append(e),c.KJ.K=c.K+"-subtitle",c.KJ.parse()),null!==ZC._n_(e=c.o.source)&&(c.MP=new ZC.DS(c),c.MP.O8="source",h.load(c.MP.o,C+".source"),c.MP.append(e),c.MP.K=c.K+"-source",c.MP.parse()),"undefined"!=typeof ZC.A1A&&(null!==ZC._n_(e=c.o.legend)||h.PF("legend",c.AF))&&(c.BF=new ZC.A1A(c),c.BF.K=c.K+"-legend","undefined"!=typeof e.alpha&&e.alpha<.1&&"undefined"==typeof e["border-width"]&&"undefined"==typeof e["border-alpha"]&&(e["border-alpha"]=e.alpha),h.load(c.BF.o,C+".legend"),c.BF.alignPosition(e),(null!==ZC._n_(e)&&null!==ZC._n_(e.position)||null!==ZC._n_(c.BF.o.position))&&h.load(c.BF.o,C+".legend[position]"),c.BF.append(e),ZC._b_(c.BF.o.shared)&&(c.BF.D["p-x"]=c.A.iX,c.BF.D["p-y"]=c.A.iY,c.BF.D["p-width"]=c.A.I,c.BF.D["p-height"]=c.A.F),c.BF.alignPosition(e),c.BF.parse());var b=!1,m=c.iX,v=c.iY,D=c.I,E=c.F,w="";if(c.IX&&c.IX.AM&&c.IX.o["adjust-layout"]&&(b=!0,(i=c.IX.iY+c.IX.F/2)<v+E/2&&(w="top",E=v+E-c.IX.F-c.IX.iY,v=c.IX.iY+c.IX.F,c.KJ&&c.KJ.o["adjust-layout"]))){var B=c.KJ.iY+c.KJ.F/2;B<v+E/2&&B>i&&(E-=c.KJ.F,v+=c.KJ.F)}if(c.MP&&c.MP.AM&&c.MP.o["adjust-layout"]&&(b=!0,(i=c.MP.iY+c.MP.F/2)>v+E/2&&(E-=c.MP.F)),c.BA&&c.BA.AM&&c.BA.o["adjust-layout"]&&(b=!0,"xy"===c.AJ.layout?(i=c.BA.AQ.iY+c.BA.AQ.F/2)>v+E/2?E-=c.BA.AQ.F+c.BA.AQ.DP:(v=c.BA.AQ.iY+c.BA.AQ.F,E-=c.BA.AQ.F):(Z=c.BA.AQ.iX+c.BA.AQ.I/2)<m+D/2?(D-=c.BA.AQ.I+c.BA.AQ.DV,m+=c.BA.AQ.I+c.BA.AQ.DV):(m=c.BA.AQ.iX+c.BA.AQ.I,D-=c.BA.AQ.I)),c.BF&&c.BF.AM&&c.BF.o["adjust-layout"]){b=!0;var K=c.BF.D2&&c.BF.D2.enabled?15:5;if("top"===w&&c.BF.iY<c.IX.iY+c.IX.F+5){if(null!==ZC._n_(c.BF.o.position)){var F=(""+c.BF.o.position).split(" ");c.BF.o.position=F[0]+" "+(c.IX.iY-c.iY+c.IX.F+c.BF.MA+K)}else c.BF.o["margin-top"]=c.IX.iY-c.iY+c.IX.F+c.BF.MA;c.BF.parse()}c.BF.fixPlacement(),i=c.BF.iY+c.BF.F/2;var x="",y=(ZC.MAX,c.BF.D["position-info"]),I={Bottom:c.BF.iY-c.iY,Top:c.iY+c.F-c.BF.iY-c.BF.F,Right:c.BF.iX-c.iX,Left:c.iX+c.I-c.BF.iX-c.BF.I},z="";z=c.BF.I/c.BF.F>2?"v":c.BF.F/c.BF.I>2?"h":Math.max(I.Left*c.F,I.Right*c.F)/Math.max(I.Top*c.I,I.Bottom*c.I)>1?"h":"v",y?y[0]>=.8?x=y[1]<=.2?"v"===z?"top":"right":y[1]>=.8&&"v"===z?"bottom":"right":y[0]<=.2?x=y[1]<=.2?"v"===z?"top":"left":y[1]>=.8&&"v"===z?"bottom":"left":y[1]<=.2?x="top":y[1]>=.8&&(x="bottom"):Math.min(I.Top,I.Bottom)/Math.max(I.Top,I.Bottom)<Math.min(I.Left,I.Right)/Math.max(I.Left,I.Right)?I.Top>I.Bottom?(x="top",c.BF.E5):(x="bottom",c.BF.DP):I.Left>I.Right?(x="left",c.BF.DV):(x="right",c.BF.E6);var H=0;"top"===x&&(E=v+E-c.BF.F-c.BF.iY,v=c.BF.iY+c.BF.F),"bottom"===x&&(E-=H=E-c.BF.iY+v+c.BF.FJ+c.BF.FR),"left"===x&&(m+=H=c.BF.iX-c.iX+c.BF.I,D-=H),"right"===x&&(D-=H=D-(c.BF.iX-c.iX)+c.BF.EP+c.BF.FK)}else c.BF&&c.BF.fixPlacement();b&&(c.D["plotarea-p-x"]=m,c.D["plotarea-p-y"]=v,c.D["plotarea-p-width"]=D,c.D["plotarea-p-height"]=E,c.setupPlotArea()),c.setupDynamicPlotArea(),c.AY.parseLayout&&c.AY.parseLayout(!0),c.BA&&c.BA.o["adjust-layout"]&&("xy"===c.AJ.layout?(null===ZC._n_(c.BA.J5.x)&&(c.BA.AQ.iX=c.P.iX),null===ZC._n_(c.BA.J5.width)&&(c.BA.AQ.I=c.P.I)):(null===ZC._n_(c.BA.J5.y)&&(c.BA.AQ.iY=c.P.iY),null===ZC._n_(c.BA.J5.height)&&(c.BA.AQ.F=c.P.F)));var M=0;for(n=0;n<c.AY.A6.length;n++)M+=c.AY.A6[n].R.length;null!==ZC._n_(e=c.o["no-data"])&&0===M?(c.RZ=new ZC.DS(c),c.RZ.O8="nodata",h.load(c.RZ.o,C+".noData"),c.RZ.append({x:c.P.iX,y:c.P.iY,width:c.P.I,height:c.P.F}),c.RZ.append(e),c.RZ.K=c.K+"-nodata",c.RZ.parse()):c.RZ=null,c.D["plotarea-margins"]&&(c.D["plotarea-margins"]=null,c.o.plotarea=c.o.plotarea||{},c.o.plotarea.margin=c.D["plotarea-margin"],c.o.plotarea["margin-top"]=c.D["plotarea-margin-top"],c.o.plotarea["margin-right"]=c.D["plotarea-margin-right"],c.o.plotarea["margin-bottom"]=c.D["plotarea-margin-bottom"],c.o.plotarea["margin-left"]=c.D["plotarea-margin-left"]);var S=["top","right","bottom","left"];for(n=0;n<S.length;n++)c.D["plotarea.d-margin-"+S[n]]=null;if(ZC.Q.EU(c.A.K+"-tooltip"),"undefined"!=typeof c.D.datalength&&null!==ZC._n_(c.D.datalength)&&c.D.datalength.length>0&&"canvas"!==c.H.AC&&c.AY.A6)for(var k=0,X=c.AY.A6.length;k<X;k++){if(c.AY.A6[k].R.length<c.D.datalength[k])for(l=c.AY.A6[k].R.length,o=c.D.datalength[k];l<o;l++)r=c.K+"-plotset-plot-"+k+"-node-"+l,ZC.Q.EU([r+"-path",r+"-area-path",r+"-sh-path"]),-1!==ZC.AV(["scatter","bubble"],c.AF)&&ZC.Q.EU([r+"-marker-gradient",r+"-marker-path",r+"-marker-sh-path",r+"-marker-circle",r+"-marker-sh-circle"]),c.EM[k+"-"+l]=null;if(-1===ZC.AV(["scatter","bubble"],c.AF)||ZC.A4.browser.webkit)for(l=0,o=c.D.datalength[k];l<o;l++)r=c.K+"-plotset-plot-"+k+"-node-"+l,ZC.Q.EU([r+"-marker-gradient",r+"-marker-path",r+"-marker-sh-path",r+"-marker-circle",r+"-marker-sh-circle"])}for(c.D.datalength=null,n=0,a=c.AY.A6.length;n<a;n++)c.GA=c.GA||c.AY.A6[n].GA;(c.HF||"undefined"==typeof ZC.PB)&&(c.GA=!1),c.GA&&(c.LT.onStop=function(){c.M9="ready"}),-1===ZC.AV(c.H.KM,"skip_interactivity")&&(c.H9=new ZC.HS(c),c.H9.K=c.K+"-zoom",h.load(c.H9.o,C+".zoom"),c.H9.append(c.o.zoom),c.A8=new ZC.DS(c),c.A8.O8="tooltip",c.o.tooltip&&c.o.tooltip.placement&&c.o.tooltip.placement.indexOf("node")>-1?h.load(c.A8.o,C+".tooltip[dynamic]"):h.load(c.A8.o,C+".tooltip"),c.A8.append(c.o.tooltip),c.A8.PR=!0,c.A8.parse(),null!==ZC._n_(e=c.o.guide)&&(c.o["crosshair-x"]=e),(null!==ZC._n_(e=c.o["crosshair-x"])||h.PF("guide",c.AF)||h.PF("crosshair-x",c.AF))&&c.AJ["enable-guide"]&&(c.CX=new ZC.D0(c),c.CX.O8="crosshairx",h.load(c.CX.o,[C+".guide",C+".crosshair-x"],!0,!0),c.CX.append(e),c.CX.parse(),c.D["guide-on"]=!0),(null!==ZC._n_(e=c.o["crosshair-y"])||h.PF("crosshair-y",c.AF))&&c.AJ["enable-guide"]&&(c.H7=new ZC.D0(c),c.H7.O8="crosshairy",h.load(c.H7.o,[C+".guide",C+".crosshair-y"],!0,!0),c.H7.append(e),c.H7.parse(),c.D["guide-on"]=!0)),c.OU(),ZC.AP.BZ("gparse",c.A,c.I3()),null!==ZC._n_(e=c.o.refresh)&&(c.HM={type:"full",interval:10,transport:"http",method:"pull","adjust-scale":!1,"max-ticks":20,"reset-timeout":100,"stop-timeout":0,storage:!1,"storage-size":1e3},ZC._cp_(e,c.HM),c.U8=1),c.M9="parse.complete"},OU:function(){},PS:function(){},M3:function(e,t,i){var n=this,a=(i=i||n.P).iX,r=i.iY,l=i.I,o=i.F;if("svg"===t){if(n.AJ["3d"]){var s,c=[];e=1;var h,C,u,d,p=[],A=a-ZC.AN.E3,g=r-ZC.AN.E2;s=new ZC.CF(n,A+l/2-e,g-e,ZC.AN.FS),d=ZC._i_(s.EB[1]),s=new ZC.CF(n,A+l/2-e,g-e,0),u=ZC._i_(s.EB[1]),p.push(new ZC.CF(n,A-e,g-e,d<u?ZC.AN.FS:0),new ZC.CF(n,A+l+e,g-e,d<u?ZC.AN.FS:0)),s=new ZC.CF(n,A+l-e,g+o/2-e,ZC.AN.FS),h=ZC._i_(s.EB[0]),s=new ZC.CF(n,A+l-e,g+o/2-e,0),C=ZC._i_(s.EB[0]),p.push(new ZC.CF(n,A+l+e,g-e,h>C?ZC.AN.FS:0),new ZC.CF(n,A+l+e,g+o+e,h>C?ZC.AN.FS:0)),s=new ZC.CF(n,A+l/2-e,g+o+e,ZC.AN.FS),d=ZC._i_(s.EB[1]),s=new ZC.CF(n,A+l/2-e,g+o+e,0),u=ZC._i_(s.EB[1]),p.push(new ZC.CF(n,A+l+e,g+o+e,d>u?ZC.AN.FS:0),new ZC.CF(n,A-e,g+o+e,d>u?ZC.AN.FS:0)),s=new ZC.CF(n,A-e,g+o/2-e,ZC.AN.FS),h=ZC._i_(s.EB[0]),s=new ZC.CF(n,A-e,g+o/2-e,0),C=ZC._i_(s.EB[0]),p.push(new ZC.CF(n,A-e,g+o+e,h<C?ZC.AN.FS:0),new ZC.CF(n,A-e,g-e,h<C?ZC.AN.FS:0)),p.push(p[0]);for(var f=0;f<p.length;f++)s=p[f],c.push([ZC._i_(s.EB[0]),ZC._i_(s.EB[1])].join(","));return c.join(" ")}return[[a-e,r-e].join(","),[a+l+e,r-e].join(","),[a+l+e,r+o+e].join(","),[a-e,r+o+e].join(","),[a-e,r-e].join(",")].join(" ")}return"box"===t?a-e+","+(r-e)+","+(l+2*e)+","+(o+2*e):(n.AJ["3d"]&&(e+=10),"rect("+(r-e)+"px,"+(a+l+e)+"px,"+(r+o+e)+"px,"+(a-e)+"px)")},autoFit:function(){var e,t=this;if(t.AJ["3d"]&&t.F0["auto-fit"]){var i=!1;for(t.F0.zoom=1;!i&&t.F0.zoom>.25;){i=!0;var n=t.M3(0,"svg").split(" ");for(e=0;e<n.length;e++){var a=n[e].split(",");(ZC._i_(a[0])<t.iX+t.P.DV||ZC._i_(a[0])>t.iX+t.I-t.P.E6||ZC._i_(a[1])<t.iY+t.P.E5||ZC._i_(a[1])>t.iY+t.F-t.P.DP)&&(i=!1)}i||(t.F0.zoom-=.05),i&&(t.F0.zoom-=.025)}}},build:function(){var e,t,i,n,a,r,l,o,s=this,c=s.A.I+"/"+s.A.F,h="0/0";if(s.autoFit(),!s.H.usc()){var C=2,u=6;if(null!==ZC._n_(e=s.P.o["mask-tolerance"])&&(e instanceof Array?(C=u=ZC._i_(e[0]),e.length>1&&(u=ZC._i_(e[1]))):C=u=ZC._i_(e)),"svg"===s.A.AC&&s.AJ.clip&&(ZC.Q.EU([s.K+"-clip",s.K+"-clip-hover",s.K+"-clip-preview"]),s.A.K7.appendChild(ZC.Q.XA({id:s.K+"-clip",path:s.M3(C,"svg")})),s.A.K7.appendChild(ZC.Q.XA({id:s.K+"-clip-hover",path:s.M3(u,"svg")})),s.BA)){var d=s.AJ["3d"];s.AJ["3d"]=!1,s.A.K7.appendChild(ZC.Q.XA({id:s.K+"-clip-preview",path:s.M3(0,"svg",s.BA.AQ)})),s.AJ["3d"]=d}var p=!s.AJ.clip,A=p?null:s.M3(C),g=p?null:"url(#"+s.K+"-clip)",f=p?null:s.M3(u),Z=p?null:"url(#"+s.K+"-clip-hover)";if(s.BA&&(a=p?null:s.M3(0,s.A.AC,s.BA.AQ),r=p?null:"url(#"+s.K+"-clip-preview)"),ZC.Q.JW({cls:"zc-abs",id:s.K,p:ZC.AK(s.A.K+"-graphset"),tl:h,wh:c},s.A.AC),s.A.NS.graph&&ZC.Q.HE({cls:"zc-abs zc-layer zc-persistent",id:s.K+"-c",p:ZC.AK(s.K),wh:c},s.A.AC),ZC.Q.JW({id:s.K+"-plotarea",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AC),s.o.plotarea&&s.A.NS.plotarea&&ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-plotarea-c",p:ZC.AK(s.K+"-plotarea"),wh:c},s.A.AC),"null"!==s.AF&&s.A.NS.plots){for(ZC.Q.JW({id:s.K+"-scales-bl",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute","clip-path":g,clip:A},s.A.AC),t=0;t<s.A5F;t++)ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-scales-bl-"+t+"-c",p:ZC.AK(s.K+"-scales-bl"),wh:c},s.A.AC);if(s.AY.D["plot-sort"]){for(t=0,i=s.AY.A6.length;t<i;t++){for(s.AY.A6[t].UJ={},n=0;n<s.AY.A6[t].SO;n++)ZC.Q.EU(s.K+"-plots-bl-"+n);for(n=0;n<s.AY.A6[t].A19;n++)ZC.Q.EU(s.K+"-plots-fl-"+n)}delete s.AY.D["plot-sort"]}if(s.A.K5||s.AJ["3d"])ZC.AK(s.K+"-plots-bl")||ZC.Q.JW({id:s.K+"-plots-bl",p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-bl"),tl:h,wh:c,position:"absolute","clip-path":g,clip:A},s.A.AC),(l=ZC.Q.HE({cls:"zc-abs zc-layer zc-bl",id:s.K+"-plots-bl-c",p:ZC.AK(s.K+"-plots-bl"),wh:c},s.A.AC)).setAttribute("data-clip",s.M3(C,"box"));else for(t=0,i=s.AY.A6.length;t<i;t++)for(o=s.AY.M0[t],n=s.AY.A6[t].SO-1;n>=0;n--)ZC.AK(s.K+"-plots-bl-"+n)||ZC.Q.JW({id:s.K+"-plots-bl-"+n,p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-bl"),tl:h,wh:c,position:"absolute","clip-path":g,clip:A},s.A.AC),(l=ZC.Q.HE({cls:"zc-abs zc-layer zc-bl",id:s.K+"-plot-"+o+"-bl-"+n+"-c",p:ZC.AK(s.K+"-plots-bl-"+n),wh:c},s.A.AC)).setAttribute("data-clip",s.M3(C,"box")),l.style.display="block";for(t=0;t<s.VB;t++)ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-scales-ml-"+t+"-c",p:ZC.AK(s.K),wh:c},s.A.AC);if(s.A.K5||s.AJ["3d"])ZC.AK(s.K+"-plots-fl")||ZC.Q.JW({id:s.K+"-plots-fl",p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-ml-"+(s.VB-1)+"-c"),tl:h,wh:c,position:"absolute"},s.A.AC),(l=ZC.Q.HE({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plots-fl-c",p:ZC.AK(s.K+"-plots-fl"),wh:c},s.A.AC)).setAttribute("data-clip",s.M3(u,"box"));else for(t=0,i=s.AY.A6.length;t<i;t++)for(o=s.AY.M0[t],n=s.AY.A6[t].A19-1;n>=0;n--)ZC.AK(s.K+"-plots-fl-"+n)||ZC.Q.JW({id:s.K+"-plots-fl-"+n,p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-ml-"+(s.VB-1)+"-c"),tl:h,wh:c,position:"absolute"},s.A.AC),(l=ZC.Q.HE({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plot-"+o+"-fl-"+n+"-c",p:ZC.AK(s.K+"-plots-fl-"+n),wh:c},s.A.AC)).setAttribute("data-clip",s.M3(u,"box")),l.style.display="block";for(zingchart.DEV.PLOTSHLAYER&&(ZC.Q.JW({id:s.K+"-plots-hover",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plots-hover-c",p:ZC.AK(s.K+"-plots-hover"),wh:c},s.A.AC)),ZC.Q.JW({id:s.K+"-scales-fl",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute","clip-path":g,clip:A},s.A.AC),t=0;t<s.A4Z;t++)ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-scales-fl-"+t+"-c",p:ZC.AK(s.K+"-scales-fl"),wh:c},s.A.AC);if(s.BA&&(ZC.Q.JW({id:s.K+"-preview",p:ZC.AK(s.A.K+"-tools"),tl:h,wh:c,position:"absolute","clip-path":r,clip:a},s.A.AC),ZC.Q.HE({cls:"zc-abs",id:s.K+"-preview-c",p:ZC.AK(s.K+"-preview"),wh:c},s.A.AC)),ZC.Q.JW({id:s.K+"-scroll",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AC),s.o["scroll-x"]&&ZC.Q.HE({cls:"zc-abs",id:s.K+"-scroll-x-c",p:ZC.AK(s.K+"-scroll"),wh:c},s.A.AC),s.o["scroll-y"]&&ZC.Q.HE({cls:"zc-abs",id:s.K+"-scroll-y-c",p:ZC.AK(s.K+"-scroll"),wh:c},s.A.AC),ZC.Q.JW({id:s.K+"-plots-vb",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AC),s.A.NS["value-box"])if(s.A.K5||s.AJ["3d"])ZC.Q.HE({cls:"zc-abs zc-layer zc-vb",id:s.K+"-plots-vb-c",p:ZC.AK(s.K+"-plots-vb"),wh:c},s.A.AC);else for(t=0,i=s.AY.A6.length;t<i;t++)ZC.Q.HE({cls:"zc-abs zc-layer zc-vb",id:s.K+"-plot-"+t+"-vb-c",p:ZC.AK(s.K+"-plots-vb"),wh:c},s.A.AC)}(s.o.title||s.o.subtitle||s.o.source||s.o["no-data"])&&(ZC.Q.JW({id:s.K+"-titles",p:ZC.AK(s.K),tl:h,wh:c,position:"absolute"},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-titles-c",p:ZC.AK(s.K+"-titles"),wh:c},s.A.AC)),ZC.Q.JW({cls:"zc-abs",wh:c,id:s.K+"-hover",p:ZC.AK(s.A.K+"-hover"),"clip-path":Z,clip:f},s.A.AC),"canvas"===s.A.AC&&(ZC.AK(s.K+"-hover").style.clip=f),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-hover-c",p:ZC.AK(s.K+"-hover"),wh:c},s.A.AC),s.A.NS.maps&&-1!==JSON.stringify(s.o).indexOf("zingchart.maps")&&(ZC.Q.JW({cls:"zc-abs",wh:c,id:s.K+"-objects-maps",p:ZC.AK(s.A.K+"-objects-maps"),"clip-path":Z,clip:f},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-sh-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-click-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-hover-c",p:ZC.AK(s.K+"-objects-maps"),wh:c},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-print-c",p:ZC.AK(s.K+"-objects-maps"),wh:c,display:"none"},s.A.AC)),s.initObjectsLayers(),s.o.legend&&(ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-legend-c",p:ZC.AK(s.A.K+"-legend"),wh:c},s.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:s.K+"-legend-scroll-c",p:ZC.AK(s.A.K+"-legend"),wh:c},s.A.AC))}s.Z=s.H.usc()?s.H.mc():ZC.AK(s.K+"-c")},initObjectsLayers:function(){var e=this,t=e.A.I+"/"+e.A.F;!ZC.AK(e.K+"-objects-bottom")&&e.A.NS["objects-bottom"]&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-bottom",p:ZC.AK(e.A.K+"-objects-bottom")},e.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-objects-bottom-sh-c",p:ZC.AK(e.K+"-objects-bottom"),wh:t},e.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-objects-bottom-c",p:ZC.AK(e.K+"-objects-bottom"),wh:t},e.A.AC)),!ZC.AK(e.K+"-objects-top")&&e.A.NS["objects-top"]&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-top",p:ZC.AK(e.A.K+"-objects-top")},e.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-objects-top-sh-c",p:ZC.AK(e.K+"-objects-top"),wh:t},e.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-objects-top-c",p:ZC.AK(e.K+"-objects-top"),wh:t},e.A.AC)),(e.A.NS["objects-bottom"]||e.A.NS["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows)&&ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-objects-print-c",p:ZC.AK(e.K+"-objects-top"),wh:t,display:"none"},e.A.AC),!ZC.AK(e.K+"-objects-click")&&(e.A.NS["objects-bottom"]||e.A.NS["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-click",p:ZC.AK(e.A.K+"-hover")},e.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-objects-click-c",p:ZC.AK(e.K+"-objects-click"),wh:t},e.A.AC)),!ZC.AK(e.K+"-objects-hover")&&(e.A.NS["objects-bottom"]||e.A.NS["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JW({cls:"zc-abs",wh:t,id:e.K+"-objects-hover",p:ZC.AK(e.A.K+"-hover")},e.A.AC),ZC.Q.HE({cls:"zc-abs zc-layer",id:e.K+"-objects-hover-c",p:ZC.AK(e.K+"-objects-hover"),wh:t},e.A.AC))},A0E:function(){},clear_:function(){},destroy:function(){var e,t=this;null!==ZC._n_(e=t.A.S6[t.K])&&"feed"===t.HM.type&&(e.send("zingchart.stopfeed"),e.close(),t.A.S6[t.K]=null),t.GA&&t.LT.stop(!0),t.M9="clear.init",t.unbind(),t.BF&&t.BF.unbind(),t.BA&&t.BA.unbind(),t.I9&&t.I9.unbind(),t.I6&&t.I6.unbind(),t.M9="clear.complete"},clear:function(e,t){null===ZC._n_(e)&&(e=!1),null===ZC._n_(t)&&(t=!1);var i,n,a,r,l=this;l.T7={},null===ZC._n_(i=l.A.S6[l.K])||e||"feed"===l.HM.type&&(i.send("zingchart.stopfeed"),i.close(),l.A.S6[l.K]=null),l.GA&&l.LT.stop(!0),l.M9="clear.init",l.unbind(e),l.A0E(!1,!0),l.LN(),l.LN("click"),l.LN("guide",!0),l.LN("print",!0),l.LN("textprint",!0),e||(!l.BA||l.BA&&!l.BA.LG)&&l.LN("static",!0),l.AY.YH=[],l.A.SP=[],zingchart.SKIP.LEGEND||l.BF&&l.BF.clear(),l.D.datalength=[];var o=ZC.ie67?ZC.AK(l.A.K):null;if(ZC.mobile||ZC.ie67)ZC.A4("."+l.K+"-node-area",o).remove();else if(ZC.AK(l.A.K+"-img")&&ZC.AK(l.A.K+"-map")){ZC.AK(l.A.K+"-img").setAttribute("useMap","");var s=ZC.AK(l.A.K+"-map").cloneNode(!0);for(n=(a=s.childNodes.length)-1;n>=0;n--)-1!==s.childNodes[n].className.indexOf(l.K+"-node-area")&&s.removeChild(s.childNodes[n]);ZC.Q.EU(l.A.K+"-map"),ZC.AK(l.A.K+"-top").appendChild(s),ZC.AK(l.A.K+"-img").setAttribute("useMap","#"+l.A.K+"-map")}switch(l.AY.HN=[],ZC.A4("."+l.K+"-value-box",o).remove(),ZC.A4("."+l.K+"-scale-marker-label",o).remove(),ZC.A4("."+l.K+"-scale-item",o).remove(),ZC.A4("."+l.K+"-scale-label",o).remove(),ZC.A4("."+l.K+"-guide-label",o).remove(),ZC.A4("."+l.K+"-shape-label",o).remove(),ZC.A4("."+l.K+"-mapshape-label",o).remove(),e||ZC.A4("."+l.K+"-preview-item",o).remove(),l.A.AC){case"svg":for(n=0,a=l.AY.A6.length;n<a;n++)l.AY.A6[n].HG=null;ZC.A4("#"+l.A.K+"-defs").children().each(function(){"LINK"!==this.tagName.toUpperCase()&&(0!==this.id.indexOf(l.K+"-")&&1!==l.A.AH.length||(e?this.id!==l.K+"-gradient"&&-1===this.id.indexOf("-preview-gradient")&&-1===this.id.indexOf("-menu-trigger-gradient")&&-1!==this.id.indexOf(l.K+"-plotset-plot-")&&(t&&l.GA||(-1!==this.id.indexOf(l.K+"-legend-")?zingchart.SKIP.LEGEND||ZC.A4(this).remove():ZC.A4(this).remove())):-1===this.id.indexOf("zc-menu-")&&-1===this.id.indexOf("-menu-trigger-")&&(-1!==this.id.indexOf(l.K+"-legend-")?zingchart.SKIP.LEGEND||ZC.A4(this).remove():l.BA&&l.BA.LG?-1===this.id.indexOf("-preview-gradient")&&ZC.A4(this).remove():ZC.A4(this).remove())))}),e||ZC.Q.EU([l.K+"-clip",l.K+"-clip-hover",l.K+"-clip-preview"]),ZC.A4("#"+l.A.K+"-svg").children().each(function(){var e=l.K+"-";"clippath"===this.tagName.toLowerCase()&&this.id.substring(0,e.length)===e&&this.id!==l.K+"-clip"&&this.id!==l.K+"-clip-hover"&&this.id!==l.K+"-clip-preview"&&ZC.Q.EU(this.id)})}if(ZC.Q.EU(l.K+"-nodata"),ZC.Q.EU(l.A.K+"-tooltip-text-float"),e||(ZC.Q.EU([l.K+"-title",l.K+"-subtitle",l.K+"-source",l.K+"-hover"]),zingchart.SKIP.LEGEND||l.BF&&(ZC.Q.EU(l.K+"-legend-c"),ZC.Q.EU(l.K+"-legend-scroll-c"),ZC.A4("."+l.K+"-legend-item-area",o).remove(),ZC.A4("."+l.K+"-legend-marker-area",o).remove(),ZC.A4("."+l.K+"-legend-item",o).remove(),ZC.A4("."+l.K+"-legend-header",o).remove(),ZC.A4("."+l.K+"-legend-footer",o).remove(),ZC.A4("."+l.K+"-legend-frame",o).remove(),l.BF.gc(),l.BF=null),l.BA&&(l.BA.LG&&!l.A.D.resize||(l.BA.unbind(),ZC.A4("."+l.K+"-preview-handler").remove(),ZC.A4("."+l.K+"-preview-mask").remove(),ZC.A4("#"+l.K+"-preview").remove(),l.BA.gc(),l.BA=null)),l.I9&&(l.I9.unbind(),l.I9=null),ZC.Q.IQ(ZC.AK(l.K+"-scroll-x-c"),l.A.AC,l.iX,l.iY,l.I,l.F,l.K),ZC.Q.IQ(ZC.AK(l.K+"-scroll-y-c"),l.A.AC,l.iX,l.iY,l.I,l.F,l.K),ZC.A4("#"+l.K+"-scroll-x-handle").remove(),ZC.A4("#"+l.K+"-scroll-x-bar").remove(),l.I6&&(l.I6.unbind(),l.I6=null),ZC.A4("#"+l.K+"-scroll-y-handle").remove(),ZC.A4("#"+l.K+"-scroll-y-bar").remove(),ZC.A4("#"+l.K+"-c").empty(),l.H.QL[0]!==l.H.QL[1]&&""!==l.H.QL[1]&&("canvas"===l.H.AC&&ZC.A4("#"+l.K+" canvas").each(function(){this.width=1,this.height=1,ZC.Q.EU(this)}),ZC.A4("#"+l.K+" div").each(function(){ZC.Q.EU(this)}),ZC.Q.EU(l.K))),ZC.A4("#"+l.K+" .zc-layer").each(function(){var i=ZC.Q.SV(this);if(-1===i.indexOf("zc-persistent")){if(e&&(this.id===l.K+"-plotarea-c"||this.id===l.K+"-titles-c"))return;if(-1===this.id.indexOf(l.K+"-plot-")&&-1===this.id.indexOf(l.K+"-plots-"))ZC.Q.IQ(this,l.H.AC,l.iX,l.iY,l.I,l.F,l.K);else if(t&&l.GA&&!l.HF){if("canvas"!==l.H.AC)for(var n=0,a=l.AY.A6.length;n<a;n++)l.D.datalength[n]=l.AY.A6[n].R.length;(r=l.A.K5?new RegExp("-plots-[a-z]+-c","g").exec(this.id):new RegExp("-plot-(\\d+)-[a-z]+-\\d+-","g").exec(this.id))&&(!l.D["plot"+r[1]+".visible"]&&"remove"===l.getToggleAction()||l.A.K5)&&ZC.Q.IQ(this,l.H.AC,l.iX,l.iY,l.I,l.F,l.K),-1===i.indexOf("zc-vb")&&-1===i.indexOf("zc-fl")||ZC.Q.IQ(this,l.H.AC,l.iX,l.iY,l.I,l.F,l.K)}else ZC.Q.IQ(this,l.H.AC,l.iX,l.iY,l.I,l.F,l.K)}}),-1!==ZC.AV(l.H.KM,"use_single_canvas")){var c,h,C;(c=ZC.AK(l.H.K+"-main-c"))&&ZC.Q.IQ(c,l.H.AC,l.iX,l.iY,l.I,l.F,l.K),(h=ZC.AK(l.H.K+"-main-c-top"))&&ZC.Q.IQ(h,l.H.AC,l.iX,l.iY,l.I,l.F,l.K),(C=ZC.AK(l.H.K+"-print-c"))&&ZC.Q.IQ(C,l.H.AC,l.iX,l.iY,l.I,l.F,l.K)}l.clear_(),l.A.D.resize=!1,l.M9="clear.complete"},unbind:function(e,t){null===ZC._n_(e)&&(e=!1);var i=this;(-1===ZC.AV(i.H.KM,"skip_interactivity")||t)&&(ZC.A4("."+i.K+"-node-area").die("mousedown mouseover touchstart",i.WU).die("mouseup mouseout touchend",i.A16).die("mousemove touchmove",i.A0L).die("click",i.T5).die("contextmenu",i.T5).die("dblclick",i.A1E),i.BF&&(zingchart.SKIP.LEGEND||(ZC.A4("."+i.K+"-legend-item-area").die("mouseup touchstart",i.SG).die("DOMMouseScroll",i.zc_legend_mousescroll).die("mousewheel",i.zc_legend_mousescroll),ZC.A4("."+i.K+"-legend-marker-area").die("mouseup touchstart",i.SG).die("DOMMouseScroll",i.zc_legend_mousescroll).die("mousewheel",i.zc_legend_mousescroll),ZC.A4("#"+i.K+"-legend-frame").die("DOMMouseScroll",i.zc_legend_mousescroll).die("mousewheel",i.zc_legend_mousescroll),ZC.mobile||(ZC.A4("."+i.K+"-legend-item-area").die(ZC.Q.C0("mouseover"),i.QR).die(ZC.Q.C0("mouseout"),i.R4).die(ZC.Q.C0("mousemove"),i.PI),ZC.A4("."+i.K+"-legend-marker-area").die(ZC.Q.C0("mouseover"),i.QR).die(ZC.Q.C0("mouseout"),i.R4).die(ZC.Q.C0("mousemove"),i.PI))))),i.AC5()},AC5:function(){},S5:function(){},QK:function(){},KF:function(){},SD:function(){},RP:function(){},LN:function(e,t){var i=this;e=e||"hover",null===ZC._n_(t)&&(t=!1);var n=ZC.AK((t?i.A.K:i.K)+"-"+e+"-c");n&&(ZC.Q.IQ(n,i.H.AC,i.iX,i.iY,i.I,i.F,i.K,"textprint"===e),ZC.A4("."+i.K+"-label-hover").remove()),"hover"===e&&(ZC.Q.IQ(ZC.AK(i.K+"-objects-hover-c"),i.H.AC,i.iX,i.iY,i.I,i.F,i.K),ZC.Q.IQ(ZC.AK(i.K+"-objects-maps-hover-c"),i.H.AC,i.iX,i.iY,i.I,i.F,i.K),zingchart.DEV.PLOTSHLAYER&&ZC.Q.IQ(ZC.AK(i.K+"-plots-hover-c"),i.H.AC,i.iX,i.iY,i.I,i.F,i.K)),"click"===e&&(ZC.Q.IQ(ZC.AK(i.K+"-objects-click-c"),i.H.AC,i.iX,i.iY,i.I,i.F,i.K),ZC.Q.IQ(ZC.AK(i.K+"-objects-maps-click-c"),i.H.AC,i.iX,i.iY,i.I,i.F,i.K)),i.hideLayer_(e,t)},hideLayer_:function(){},A66:function(e,t){var i,n=this;if(null!==ZC._n_(e)&&null!==ZC._n_(t)){var a=n.AY.A6[e].IY,r=n.AY.A6[e].RI;if("none"===a)return;if(null!==ZC._n_(n.CH["p"+e])){if(null!==ZC._n_(n.CH["p"+e]["n"+t])){if(delete n.CH["p"+e]["n"+t],r)for(i=0;i<n.AY.A6.length;i++)delete n.CH["p"+i]["n"+t]}else if("graph"===a?(n.CH={},n.CH["p"+e]={}):"plot"===a&&(n.CH["p"+e]={}),n.CH["p"+e]["n"+t]=!0,r)for(i=0;i<n.AY.A6.length;i++)n.CH["p"+i]=n.CH["p"+i]||{},n.CH["p"+i]["n"+t]=!0}else if("graph"===a&&(n.CH={}),n.CH["p"+e]={},n.CH["p"+e]["n"+t]=!0,r)for(i=0;i<n.AY.A6.length;i++)n.CH["p"+i]=n.CH["p"+i]||{},n.CH["p"+i]["n"+t]=!0}null!==ZC._n_(e)&&null!==ZC._n_(t)&&(n.HF=!0,n.K3(!0,!0))},paint:function(e){function t(){if(s.AJ["3d"]){var e=ZC.DH.DA(s.P,s,s.P.iX-ZC.AN.E3,s.P.iX-ZC.AN.E3+s.P.I,s.P.iY-ZC.AN.E2,s.P.iY-ZC.AN.E2+s.P.F,ZC.AN.FS+10,ZC.AN.FS+10,"y"),t=ZC.DH.DA(s.P,s,s.P.iX-ZC.AN.E3,s.P.iX-ZC.AN.E3+s.P.I,s.P.iY-ZC.AN.E2,s.P.iY-ZC.AN.E2+s.P.F,ZC.AN.FS,ZC.AN.FS,"y");t.K=s.K+"-plotarea",t.P3=e.E,s.CK.add(t)}else{s.P.Z=s.P.C6=s.H.usc()?s.H.mc():ZC.AK(s.K+"-plotarea-c");var n,a=[s.P.iX,s.P.iY,s.P.I,s.P.F],r=s.P.AT,l=s.P.AT,o=s.P.AT,c=s.P.AT;""!==(i=s.P.PQ)&&(n=i.split(/\s/),r=ZC._i_(n[0])),""!==(i=s.P.OC)&&(n=i.split(/\s/),l=ZC._i_(n[0])),""!==(i=s.P.NL)&&(n=i.split(/\s/),o=ZC._i_(n[0])),""!==(i=s.P.P6)&&(n=i.split(/\s/),c=ZC._i_(n[0])),s.P.iX-=c+1,s.P.iY-=r+1,s.P.I+=c+l+1,s.P.F+=r+o+1,s.P.paint(),s.P.iX=a[0],s.P.iY=a[1],s.P.I=a[2],s.P.F=a[3]}}null===ZC._n_(e)&&(e=!1);var i,n,a,r,l,o,s=this;s.A.GRAPHID=s.K,s.UW=e,window.clearTimeout(ZC.ASYNC_TICK[s.K]),s.A.clearLabelBoxes("vb"+s.L);var c,h,C,u,d,p,A,g=s.BT("k")[0],f=ZC.MAX,Z=-ZC.MAX,_={},b=s.AY.A6,m=0;for(u=0;u<b.length;u++)if(b[u].o.rel)for(C=0;C<b.length;C++)if(b[C].o.id&&b[C].o.id===b[u].o.rel){m++,A=!0;var v=[];for(l=0;l<b[C].R.length;l++)(g.ED?b[C].R[l].BU>=g.B4&&b[C].R[l].BU<=g.BL:b[C].R[l].L>=g.V&&b[C].R[l].L<=g.A1)?(c=b[C].R[l].AD,f=Math.min(f,c),Z=Math.max(Z,c),A?(A=!1,b[C].R[l].BU?v.push([b[C].R[l].BU,0]):v.push(0),p=c):b[C].R[l].BU?v.push([b[C].R[l].BU,100*(c-p)/p]):v.push(100*(c-p)/p)):b[C].R[l].BU?v.push([b[C].R[l].BU,0]):v.push(0);_["p-"+u]=[].concat(v)}if(m>0){for(f=ZC.MAX,Z=-ZC.MAX,u=0;u<b.length;u++)if(b[u].o.rel&&_["p-"+u])for(l=0;l<b[u].R.length;l++)2===(h=_["p-"+u][l]).length?(c=h[1],b[u].X[l]=h,b[u].R[l].AD=b[u].R[l].CR=h[1]):(c=h,b[u].X[l]=b[u].R[l].AD=b[u].R[l].CR=h),b[u].FP(l),f=Math.min(f,c),Z=Math.max(Z,c);var D=s.BT("v")[0];D.RN(f,Z,!0),D.IW()}for(s.A.D["g-"+s.L+"-selection"]&&(s.CH=JSON.parse(s.A.D["g-"+s.L+"-selection"])),s.KD=!1,n=0,a=s.AY.A6.length;n<a;n++)s.IT[n]=!1;for(n in s.CH)if(s.CH.hasOwnProperty(n)){var E=ZC._i_(n.replace("p",""));for(d in s.CH[n])if(s.CH[n].hasOwnProperty(d)){s.IT[E]=!0,s.KD=!0;break}}if(s.A.A0G(),s.NW(),s.UW?s.D["plotarea.paint"]&&(t(),s.D["plotarea.paint"]=null):(s.build(),s.Z&&(s.C6=s.Z,s.b()),t()),"xy"===s.AJ.layout||"yx"===s.AJ.layout){var w=s.BT("v"),B=null;for(l=0;l<w.length;l++)(0===l||w[l].o["ref-zero"])&&w[l].FU<=0&&w[l].GY>=0&&w[l].T3&&(B=l);if(null!==ZC._n_(B)){var K=w[B].B2(0);for(l=0;l<w.length;l++)if(l!==B&&w[l].o["sync-zero"]&&w[l].FU<=0&&w[l].GY>=0&&w[l].T3){var F=w[l].B2(0);if(ZC._a_(F-K)>=1)for(var x=!0,y=0;x;)F>K?w[l].CQ?w[l].AU?w[l].A5+=1:w[l].BW+=1:w[l].AU?w[l].BW+=1:w[l].A5+=1:w[l].CQ?w[l].AU?w[l].BW+=1:w[l].A5+=1:w[l].AU?w[l].A5+=1:w[l].BW+=1,y++,w[l].IW(),w[l].A7I(),(y>(w[l].CQ?s.P.I:s.P.F)||ZC._a_(w[l].B2(0)-K)<1)&&(x=!1)}}}for(l=0,o=s.BM.length;l<o;l++)s.BM[l].Z=s.BM[l].C6=s.H.usc()?s.H.mc():ZC.AK(s.K+"-scales-bl-0-c"),s.A.O3=!0,s.BM[l].paint(),s.A.ZI(),s.A.O3=!1;var I="undefined"!=typeof s.D["shared-zoom"]&&null!==ZC._n_(s.D["shared-zoom"])&&s.D["shared-zoom"];if(s.BA&&s.BA.LG?s.BA.HY&&(s.BA.HY=!0,s.BA.paint()):s.D["skip-preview"]||!s.BA||s.UW&&!s.BA.HY||I||(s.BA.HY=!0,s.BA.paint()),s.D["shared-zoom"]=null,s.D["skip-preview"]=null,s.I9&&s.I9.paint(),s.I6&&s.I6.paint(),s.UW||(r=s.H.usc()?s.H.mc():ZC.AK(s.K+"-titles-c"),s.IX&&s.IX.AM&&null!==ZC._n_(s.IX.AR)&&(s.IX.Z=s.IX.C6=r,s.IX.paint(),!s.IX.K5&&ZC.AK(s.A.K+"-map")&&(ZC.AK(s.A.K+"-map").innerHTML+=ZC.AP.O1(s.K,s.IX))),s.KJ&&s.KJ.AM&&null!==ZC._n_(s.KJ.AR)&&(s.KJ.Z=s.KJ.C6=r,s.KJ.paint(),!s.KJ.K5&&ZC.AK(s.A.K+"-map")&&(ZC.AK(s.A.K+"-map").innerHTML+=ZC.AP.O1(s.K,s.KJ))),s.MP&&s.MP.AM&&null!==ZC._n_(s.MP.AR)&&(s.MP.Z=s.MP.C6=r,s.MP.paint(),!s.MP.K5&&ZC.AK(s.A.K+"-map")&&(ZC.AK(s.A.K+"-map").innerHTML+=ZC.AP.O1(s.K,s.MP))),s.RZ&&s.RZ.AM&&null!==ZC._n_(s.RZ.AR)&&(s.RZ.Z=s.RZ.C6=r,s.RZ.paint())),s.IX&&s.IX.EL(),s.KJ&&s.KJ.EL(),s.MP&&s.MP.EL(),s.AJ["3d"]||s.U3(),s.A.O3=!s.GA,zingchart.DEV.SKIPTRACKERS&&(s.A.O3=!1),s.A.D["graph."+s.K+".disableanimation"])for(l=0,o=s.AY.A6.length;l<o;l++)s.AY.A6[l].GA=!1;s.AY.paint(),s.H.paintHistory()},U3:function(){},clearPreview:function(){var e=this;e.BA&&(ZC.Q.IQ(ZC.AK(e.K+"-preview-c"),e.A.AC,e.iX,e.iY,e.I,e.F,e.K),e.A.H9&&!e.A.H9.A04&&e.BA.reset(),e.BA.HY=!0)},flatten:function(){},_end_:function(){function e(e){var t,i,n=(e.targetid||e.target.id).replace("-area-path","").replace("-path","").replace(/--([a-zA-Z0-9]+)/,"").replace("-marker","").replace("-circle","").split("-").reverse();return"node"===n[1]&&(t=n[2],i=n[0]),[t,i]}var t,i,n,a,r=this;for(r.D["toggle-action-remove"]=null,r.GA||r.A.ZI(),r.A.O3=!1,(r.LG||!r.GA||r.H.D["graph."+r.K+".disableanimation"]||!r.AJ["enable-animation"]||-1!==ZC.AV(r.H.KM,"skip_interactivity")||zingchart.SKIP.ANIMATION)&&(r.M9="ready"),"initial"===r.A1K&&(r.ABK=!1,r.H.D["graph."+r.K+".disableanimation"]=!0),i=0,n=r.BM.length;i<n;i++)r.BM[i].paint_();if(!r.A.D["fire-load"]){var l=ZC.AP.BZ("objectsinit",r.A,r.I3(),!0);if(l)for(var o=["labels","shapes","imges","arrows"],s=0;s<o.length;s++)l[o[s]]&&(r.o[o[s]]=(r.o[o[s]]||[]).concat(l[o[s]]))}if(r.AJ["3d"]||(r.flatten(),r.PS(),r.KF(),-1===ZC.AV(r.H.KM,"skip_interactivity")&&r.RP()),-1===ZC.AV(r.H.KM,"skip_interactivity")){var c=ZC.A4("."+r.K+"-node-area");r.WU=function(t){if(!(zingchart.NODE_EV&&"mouseover"===zingchart.NODE_EV_TYPE&&"mouseover"===t.type||(zingchart.NODE_EV_CHART=r.A.K,zingchart.NODE_EV=t,zingchart.NODE_EV_TYPE=t.type,ZC.move||r.BF&&r.BF.YA||-1===ZC.Q.SV(t.target).indexOf("zc-node-area")||"ready"!==r.M9))){ZC.mobile&&(r.D["node-target-id"]=t.target.id,ZC.move=!1,r.H.hideCM(),null===r.H.DF||null===ZC._n_(r.H.DF["page-scroll"])||r.H.DF["page-scroll"]||t.preventDefault(),r.A.YS(t));var a=e(t);if(r.AY.A6[a[0]]){var l=r.AY.A6[a[0]].FP(a[1]);if(l&&(l.N?(ZC.COLORS=[l.N.C1,l.N.A0,l.N.AE,l.N.BV,l.N.B7],l.N3&&ZC.COLORS.push(l.N3.A0,l.N3.AE,l.N3.BV,l.N3.B7)):ZC.COLORS=[],r.D["plot"+a[0]+".visible"])){var o=ZC.mobile?"mousedown":t.xtype||t.type;(ZC.mobile||"mousedown"!==o)&&r.A.A8&&r.A8&&r.A8.AM&&r.A.A8.onmouseover(t);var s=r.AY.A6[a[0]];if("plot"===s.A3G)for(i=0,n=s.R.length;i<n;i++)s.R[i]&&s.FP(i).A3H("hover");else l.A3H("hover");if(l.WX(t,o),l.A.WW(t,o),r.BF){ZC.move=!0;var c=a[0];r.AY.A6[c].o["legend-item"]&&null!==ZC._n_(r.AY.A6[c].o["legend-item"].order)&&(c=ZC._i_(r.AY.A6[c].o["legend-item"].order)),r.BF.S3?r.L===r.A.AH.length-1&&r.BF.highlightItem(c):r.BF.highlightItem(c),ZC.move=!1}}}}},c.live("mousedown mouseover touchstart",r.WU),r.A16=function(t){if(zingchart.NODE_EV=zingchart.NODE_EV_TYPE=null,zingchart.NODE_EV_CHART=null,!(ZC.move||r.BF&&r.BF.YA)){var i=t.target;if(ZC.mobile&&document.elementFromPoint){var n=ZC.Q.M7(t),a=Math.max(window.pageXOffset,document.documentElement.scrollLeft,document.body.scrollLeft),l=Math.max(window.pageYOffset,document.documentElement.scrollTop,document.body.scrollTop);if((i=document.elementFromPoint(n[0]-a,n[1]-l))&&r.D["node-target-id"]&&r.D["node-target-id"]!==i.id)return}if(-1!==ZC.Q.SV(t.target).indexOf("zc-node-area")&&"ready"===r.M9){ZC.mobile&&r.A.OP(t);var o=e(t),s=r.AY.A6[o[0]].FP(o[1]);if(s){if(r.D["plot"+o[0]+".visible"]){r.A.A8&&r.A8&&r.A8.AM&&r.A.A8.onmouseout(t),r.AY.A6[o[0]].E=[],s.LN(),r.LN();var c=ZC.mobile?"mouseup":t.xtype||t.type;s.WX(t,c),s.A.WW(t,c),r.BF&&(ZC.move=!0,r.BF.S3?r.L===r.A.AH.length-1&&r.BF.highlightItem(-1):r.BF.highlightItem(-1),ZC.move=!1)}!ZC.mobile||r.H.A9B||ZC.move||(zingchart.SA(t),r.T5(t))}}}},c.live("mouseup mouseout touchend",r.A16),r.A0L=function(t){if(zingchart.NODE_EV=t,zingchart.NODE_EV_CHART=r.A.K,zingchart.NODE_EV_TYPE=t.type,-1!==ZC.Q.SV(t.target).indexOf("zc-node-area")&&"ready"===r.M9){ZC.mobile&&r.A.OP(t);var i=e(t);r.D["plot"+i[0]+".visible"]&&r.A.A8&&r.A8&&r.A8.AM&&r.A.A8.onmousemove(t)}},c.live("mousemove touchmove",r.A0L),r.T5=function(t){if((t.targetid||-1!==ZC.Q.SV(t.target).indexOf("zc-node-area"))&&"ready"===r.M9){var i=e(t),n=r.AY.A6[i[0]].FP(i[1]);if(n&&("none"===n.A.IY||!ZC.mobile&&0!==t.button||(r.A.D.preservezoom=!0,r.clearPreview(),r.A66(n.A.L,n.L)),n.WX(t,"click"),n.A.WW(t,"click"),null!==ZC._n_(n.A.E8)&&"NULL"!==n.A.E8))if(n.A.E8 instanceof Array)for(var a=0;a<n.A.E8.length;a++){var l=n.A.F9;n.A.F9 instanceof Array&&(l=n.A.F9[a]||"graph="+(r.o.id||"")),a===n.L&&r.UQ(t,n.KE(n.A.E8[a],null,null,!0),l)}else r.UQ(t,n.KE(n.A.E8,null,null,!0),n.A.F9||"graph="+(r.o.id||""))}},r.A1E=function(t){if(-1!==ZC.Q.SV(t.target).indexOf("zc-node-area")&&"ready"===r.M9){var i=e(t),n=r.AY.A6[i[0]].FP(i[1]);n&&(n.WX(t,"doubleclick"),n.A.WW(t,"doubleclick"))}},ZC.mobile||c.live("click",r.T5).live("contextmenu",r.T5).live("dblclick",r.A1E)}if(r.ABV(),r.A.D["tr-ev-"+r.L]?(r.A.D["tr-ev-"+r.L]=null,r.A7Q()):r.A7Q(),r.A0X){r.A0X=!1;var h={graphid:r.K};for(i=0,n=r.BT("k").length;i<n;i++){var C=r.BT("k")[i];null!==ZC._n_(t=C.LI)&&(h["zoomx"+(a=1===C.L?"":"-"+C.L)]=!0,h["xmin"+a]=t[0],h["xmax"+a]=t[1])}for(i=0,n=r.BT("v").length;i<n;i++){var u=r.BT("v")[i];null!==ZC._n_(t=u.LI)&&(h["zoomy"+(a=1===u.L?"":"-"+u.L)]=!0,h["ymin"+a]=t[0],h["ymax"+a]=t[1])}if(h.zoomto=!0,r.A.FY){for(var d in r.A.FY)ZC.AK(d).appendChild(r.A.FY[d]);r.A.FY=null}r.A.PW(h)}},ABV:function(){},A7Q:function(){var e=this;if(e.A.A1U<e.A.AH.length&&(e.A.A1U++,ZC.AP.BZ("gload",e.A,e.I3())),ZC.AP.BZ("gcomplete",e.A,e.I3()),e.BA&&(e.BA.HY=!1),zingchart.NODE_EV&&zingchart.NODE_EV_CHART&&zingchart.NODE_EV_CHART===e.A.K){var t=ZC.A4("#"+e.A.K+"-top"),i=ZC.DX[0]-t.offset().left,n=ZC.DX[1]-t.offset().top,a=zingchart.exec(e.A.K,"getxyinfo",{x:i,y:n});if(a)for(var r=0;r<a.length;r++)if("node"===a[r].infotype&&a[r].xydistance<10){var l=a[r].graphid+"-plotset-plot-"+a[r].plotidx+"-node-"+a[r].nodeidx;zingchart.NODE_EV&&zingchart.NODE_EV.target&&zingchart.NODE_EV.target.id===l&&(e.WU(zingchart.NODE_EV),zingchart.NODE_EV=null)}}zingchart.GUIDE_EV&&e.A.D5&&e.A.D5.Q6(zingchart.GUIDE_EV),e.A.A4Y<e.A.AH.length?e.A.A4Y++:(e.A.A4Y=1,e.A.A1U===e.A.AH.length&&(e.A.A1U++,e.A.D["fire-load"]=!0,e.LG&&e.AY.A6.length>1&&(zingchart.SKIP.EVENT||ZC.AP.BZ("load",e.A,e.A.FH()))),e.A.D["fire-complete"]=!0,(e.D["graph-K3"]||e.LG&&e.AY.A6.length>1)&&(zingchart.SKIP.EVENT||ZC.AP.BZ("complete",e.A,e.A.FH()),e.D["graph-K3"]=null)),0!==e.A.QQ.length&&e.A.QQ[e.A.QQ.length-1]===e.A.D.json||(e.A.QQ[e.A.NY]!==e.A.D.json&&(e.A.QQ.length=e.A.NY+1),e.A.QQ[e.A.NY]=e.A.D.json)},K3:function(e,t){var i=this;null===ZC._n_(e)&&(e=!1),null===ZC._n_(t)&&(t=!1),i.A.MV(i),i.D["graph-K3"]=!0,i.clear(e,t),i.parse(),i.U0&&i.U0(),i.paint(e),i.BA&&i.BA.setScalesInfo(),i.HF=!1,zingchart.SKIP.CSV=!1},UQ:function(ev,E8,F9){if(2!==ev.button){var s=this,C,P9=[""];switch(null!==ZC._n_(F9)&&(P9=F9.split("=")),P9[0]){case"_blank":window.open(E8,"_blank");break;case"_top":window.top.location.href=E8;break;case"_parent":window.parent.location.href=E8;break;case"window":null!==ZC._n_(P9[1])&&""!==P9[1]&&(window.top[P9[1]].location.href=E8);break;case"graph":var XQ=null;if("()"===E8.substring(E8.length-2)||"javascript:"===E8.substring(0,11))try{var EI=E8.replace("javascript:","").replace("()","");eval(EI)&&(XQ=eval(EI).call(s))}catch(e){}null!==ZC._n_(P9[1])&&""!==P9[1]?"_top"===P9[1]||"_parent"===P9[1]?(s.A.MV(),XQ?zingchart.exec(s.A.K,"setdata",{data:XQ}):s.A.load(null,E8)):(C=s.A.OR(P9[1]))&&(s.A.MV(C),s.A.D["tr-ev-"+C.L]=!0,s.A.NY++,XQ?zingchart.exec(s.A.K,"setdata",{graphid:P9[1],data:XQ}):s.A.load(P9[1],E8)):(C=s.A.AH[0],s.A.MV(C),XQ?zingchart.exec(s.A.K,"setdata",{graphid:C.K,data:XQ}):(s.A.D["tr-ev-"+C.L]=!0,s.A.NY++,s.A.load(C.K,E8)));break;default:window.location.href=E8}}},HV:function(e,t,i){var n=this;if(null===ZC._n_(i)&&(i=n.AY.A6.length-1),null!==ZC._n_(e)&&void 0!==e)return n.AY.A6[e];if(null===ZC._n_(t)||void 0===t)return n.AY.A6[i];for(var a=0,r=n.AY.A6.length;a<r;a++)if(t===n.AY.A6[a].H2)return n.AY.A6[a];return null},A3P:function(e,t){var i,n,a=this;(e=e||{})["toggle-action"]=e["toggle-action"]||a.getToggleAction();var r=null;if("undefined"!=typeof e.plotindex&&(r=ZC._i_(e.plotindex)),-1===r)for(r=[],i=0,n=a.AY.A6.length;i<n;i++)r.push(i);r instanceof Array||(r=[r]);var l=e.plotid||"";l instanceof Array||(l=[l]);var o=[];for(i=0,n=ZC.BQ(r.length,l.length);i<n;i++){var s=a.HV(r[i],l[i]);if(s){var c={};ZC._cp_(e,c);var h=s.L;c.plotindex=h,c.plotid=s.H2,("show"===t&&!a.D["plot"+h+".visible"]||"hide"===t&&a.D["plot"+h+".visible"])&&o.push(c)}}for(i=0,n=o.length;i<n;i++)a.A.o.graphset[a.L].series[o[i].plotindex].visible="show"===t,i===n-1&&(o[i].K3=1),a.Q4(o[i])},Q4:function(e){var t,i,n,a=this;a.A.D["graph."+a.K+".disableanimation"]=!1,e=e||{};var r=!1;null!==ZC._n_(e.skip)&&e.skip&&(r=!0);var l=!1;e["toggle-action"]=e["toggle-action"]||a.getToggleAction(),null!==ZC._n_(t=e["ignore-legend"])&&(l=ZC._b_(t));var o=a.HV(e.plotindex,e.plotid);if(o){var s=o.L;switch(e["toggle-action"]){case"hide":if(a.BF&&(a.BF.D.showhide=!0),a.D["plot"+s+".visible"]=!a.D["plot"+s+".visible"],null!==ZC._n_(a.A.o.graphset[a.L].series)&&(a.A.o.graphset[a.L].series[s].visible=a.D["plot"+s+".visible"]),a.AJ["3d"])l=!0,r||a.K3();else{var c=a.D["plot"+s+".visible"]?"block":"none";if(zingchart.DEV.SKIPTRACKERS||ZC.A4("."+a.K+"-plotset-plot-"+s+"-node-area").each(function(){if("AREA"===this.tagName.toUpperCase()){var e=ZC.A4(this),t=e.attr("coords"),n=e.attr("shape");"none"===c?(t="-"+t.replace(/,/g,",-"),"rect"===n?4===(i=t.split(",")).length&&(t=[i[2],i[3],i[0],i[1]].join(",")):"circle"===n&&3===(i=t.split(",")).length&&(t=[i[0],i[1],-i[2]].join(","))):(t=t.replace(/\-/g,""),"rect"===n&&4===(i=t.split(",")).length&&(t=[i[2],i[3],i[0],i[1]].join(","))),e.attr("coords",t)}}),a.A.K5)ZC.AK(a.K+"-plots-bl-c").style.display=c,ZC.AK(a.K+"-plots-fl-c").style.display=c,ZC.AK(a.K+"-plots-vb-c").style.display=c;else{for(n=0;n<o.SO;n++)(t=ZC.AK(a.K+"-plot-"+s+"-bl-"+n+"-c"))&&(t.style.display=c);for(n=0;n<o.A19;n++)(t=ZC.AK(a.K+"-plot-"+s+"-fl-"+n+"-c"))&&(t.style.display=c);(t=ZC.AK(a.K+"-plot-"+s+"-vb-c"))&&(t.style.display=c)}var h=ZC.A4("."+a.K+"-plot-"+s+"-value-box");a.D["plot"+s+".visible"]?(h.show(),ZC.A4("."+a.K+"-plotset-plot-"+s+"-preview").show()):(h.hide(),ZC.A4("."+a.K+"-plotset-plot-"+s+"-preview").hide())}break;case"remove":a.clearPreview(),l=!0,a.D["toggle-action-remove"]=!0,a.D["plot"+s+".visible"]=!a.D["plot"+s+".visible"],e.K3&&(r||(a.LU("on-legend-toggle"),a.K3(!0,!0)))}a.BF&&!l&&(a.BF.clear(),a.BF.paint())}},LU:function(e){var t=this,i=!0,n=t.o.plot||{};null!==ZC._n_(n.animation)&&null!==ZC._n_(n.animation[e])&&(i=ZC._b_(n.animation[e])),t.HF="initial"===t.A1K||!i},I3:function(){return{id:this.A.K,graphidx:this.L,graphid:this.K.replace(this.A.K+"-graph-",""),x:this.iX,y:this.iY,width:this.I,height:this.F,loader:this.A.FH()}},RO:function(){},RU:function(){},gc:function(){for(var e=0;e<this.BM.length;e++)this.BM[e].gc();for(var t=0;t<this.AY.A6.length;t++)this.AY.A6[t].gc();ZC.AP.gc(this.AY,["A","C","H","F7","o","I0","J5"]),ZC.AP.gc(this,["Z","C6","AJ","IX","KJ","MP","F0"])}}),ZC.AA7=ZC.JS.C7({$i:function(e){this.b(e);var t=this;t.AF="null",t.AJ.clip=!0,t.AJ["enable-guide"]=!0,t.AJ["enable-preview"]=!0}}),ZC.WA.push("null3d"),ZC.A8I=ZC.JS.C7({$i:function(e){this.b(e);var t=this;t.AF="null3d",t.CK=new ZC.US,t.AJ["3d"]=!0,t.AJ["x-angle-min"]=-1800,t.AJ["x-angle-max"]=1800,t.AJ["y-angle-min"]=-1800,t.AJ["y-angle-max"]=1800,t.AJ["z-angle-min"]=-1800,t.AJ["z-angle-max"]=1800,zingchart.V3D=3},clear:function(){var e=this;e.b(),e.CK.clear()},paint:function(){var e=this;e.b(),e.PS(),e.S5(),e.flatten(),e.KF(),-1===ZC.AV(e.H.KM,"skip_interactivity")&&e.RP()}}),ZC.NC=ZC.JS.C7({$i:function(e){this.b(e);var t=this;t.AF="xy",t.AJ.clip=!0,t.AJ.layout="xy"},MJ:function(e){var t=this;switch(e){case"x":return new ZC.T0(t);case"y":return new ZC.T2(t)}},ACI:function(){var e,t=this,i=t.MJ("x","scale-x");for(i.BC="scale-x",i.K=t.K+"-scale-x",t.BM.push(i),e=2;e<50;e++)if(null!==ZC._n_(t.o["scale-x-"+e])){var n=t.MJ("x","scale-x-"+e);n.L=e,n.BC="scale-x-"+e,n.K=t.K+"-scale-x-"+e,t.BM.push(n)}var a=t.MJ("y","scale-y");for(a.BC="scale-y",a.K=t.K+"-scale-y",t.BM.push(a),e=2;e<50;e++)if(null!==ZC._n_(t.o["scale-y-"+e])){var r=t.MJ("y","scale-y-"+e);r.L=e,r.BC="scale-y-"+e,r.K=t.K+"-scale-y-"+e,t.BM.push(r)}t.b()}}),ZC.A4N=ZC.NC.C7({$i:function(e){this.b(e);var t=this;t.AF="mixed",t.AY=new ZC.Z6(t),t.AJ["enable-guide"]=!0,t.AJ["enable-preview"]=!0,t.AJ["enable-scroll"]=!0},MJ:function(e,t){switch(e){case"x":var i=!1;if(this.o.series)for(var n=0;n<this.o.series.length;n++)if(this.o.series[n]&&this.o.series[n].type&&-1!==ZC.AV(["bar","vbar","bullet","vbullet","stock","vbar3d"],this.o.series[n].type)){var a=(this.o.series[n].scales||"scale-x,scale-y").split(",");-1!==ZC.AV(a,t)&&(i=!0)}var r=this.b(e,t);return r.DL=i,r;case"y":return this.b(e,t)}}}),ZC.A8H=ZC.NC.C7({$i:function(e){this.b(e);var t=this;t.AF="hmixed",t.AJ.layout="yx",t.AJ["enable-guide"]=!0,t.AJ["enable-preview"]=!1,t.AJ["enable-scroll"]=!0,t.AY=new ZC.Z6(t)},MJ:function(e,t){switch(e){case"x":var i=new ZC.UN(this),n=!1;if(this.o.series)for(var a=0;a<this.o.series.length;a++)if(this.o.series[a]&&this.o.series[a].type&&-1!==ZC.AV(["hbar","hbullet"],this.o.series[a].type)){var r=(this.o.series[a].scales||"scale-x,scale-y").split(",");-1!==ZC.AV(r,t)&&(n=!0)}return i.DL=n,i;case"y":return new ZC.UP(this)}}}),ZC.A2R=ZC.A4N.C7({$i:function(e){this.b(e);var t=this;t.AF="mixed3d",t.AY=new ZC.Z6(t),t.CK=new ZC.US,t.AJ["3d"]=!0,t.AJ["enable-preview"]=!1,t.AJ["enable-animation"]=!1,t.AJ["enable-scroll"]=!0},clear:function(){var e=this;e.b(),e.CK.clear()},paint:function(){var e=this;e.b(),e.S5(),e.flatten(),e.PS(),e.FL.length&&(e.CK.clear(),e.KF(),e.S5()),e.U3(),-1===ZC.AV(e.H.KM,"skip_interactivity")&&e.RP()}}),ZC.LF=ZC.HS.C7({$i:function(e){this.b(e);var t=this;t.C=e,t.H=t.C.A,t.A6=[],t.HN=null,t.K6=[],t.JZ=[],t.PR=!0,t.F7=null,t.A47=!0,t.YH=[]},ACQ:function(){return new ZC.IC(this)},parse:function(){var e,t,i,n=this;for(n.K=n.A.K+"-plotset",n.F7=null,t=n.o.length-1;t>=0;t--)"undefined"==typeof n.o[t]&&n.o.splice(t,1);if(null===ZC._n_(n.D["plot-sort"])&&(n.D["plot-sort"]=!1),n.o.length>1){for(t=0,i=n.o.length;t<i;t++)"undefined"==typeof n.o[t].palette&&(n.o[t].palette=t);var a=[],r=[];for(t=0,i=n.o.length;t<i;t++)r[t]=t,a[t]={"z-index":n.o[t]["z-index"]||0};for(var l=!1;!l;)for(l=!0,t=0,i=a.length;t<i-1;t++)if(a[t]["z-index"]>a[t+1]["z-index"]){n.D["plot-sort"]=!0;var o=a[t];a[t]=a[t+1],a[t+1]=o;var s=r[t];r[t]=r[t+1],r[t+1]=s,l=!1}n.M0=r}else n.M0=[0];for(n.A6=[],t=0,i=n.o.length;t<i;t++){var c="";n.A.o.plot&&null!==ZC._n_(e=n.A.o.plot.type)&&(c=e),null!==ZC._n_(e=n.o[t].type)&&(c=e);var h=n.ACQ(c,t);h.O8=h.AF+"plot",h.L=t,h.JN=t,n.C.A.B8.load(h.o,["("+h.AF+").plot"]),h.sTypeX&&n.C.A.B8.load(h.o,["("+h.sTypeX+").plot"]),n.C.A.B8.load(h.o,["("+h.AF+").plot.animation"]),null!==ZC._n_(e=n.A.o.plot)&&h.append(e),h.append(n.o[t]),h.CB=n.A.CB,h.parse(),n.A6.push(h)}var C={},u=[],d=[],p={},A={},g=0,f=0;for(t=0,i=n.A6.length;t<i;t++)if(null!==ZC._n_(n.A.A.D["g-"+n.A.L+"-p-"+t+".visible"])&&(n.C.D["plot"+t+".visible"]=n.A.A.D["g-"+n.A.L+"-p-"+t+".visible"]),!n.A6[t].HK&&(n.C.D["plot"+t+".visible"]||"hide"===n.C.getToggleAction())){n.A6[t].CB?(-1===(f=ZC.AV(d,n.A6[t].DY))&&(d.push(n.A6[t].DY),f=d.length-1),null===ZC._n_(u[f])?u[f]=[t]:u[f].push(t)):(d.push(-1),f=d.length-1,null===ZC._n_(u[f])?u[f]=[t]:u[f].push(t));var Z=n.A6[t].AF;if(n.A6[t].o.type&&Z!==n.A6[t].o.type){var _=Z.indexOf("3d"),b=n.A6[t].o.type.indexOf("3d");(-1===_&&-1!==b||-1===_&&-1===b)&&(Z=n.A6[t].o.type)}-1!==ZC.AV(["bar","bar3d","bullet"],Z)&&(Z="v"+Z),-1===ZC.AV(["vbar","hbar","vbullet","hbullet","stock","vbar3d","hbar3d"],Z)||n.A6[t].HK||(null===ZC._n_(p[Z])&&(p[Z]=[]),null===ZC._n_(A[Z])&&(A[Z]=[]),n.A6[t].CB?(null===ZC._n_(C[n.A6[t].DY])?C[n.A6[t].DY]=1:C[n.A6[t].DY]++,-1===(g=ZC.AV(A[Z],n.A6[t].DY))&&(A[Z].push(n.A6[t].DY),g=A[Z].length-1),null===ZC._n_(p[Z][g])?p[Z][g]=[t]:p[Z][g].push(t)):(A[Z].push(-1),g=A[Z].length-1,null===ZC._n_(p[Z][g])?p[Z][g]=[t]:p[Z][g].push(t)))}if(n.K6=u,n.JZ=p,n.WB)for(var m in n.WB)n.WB[m].sort();for(n.A11=[],t=0;t<n.K6.length;t++)n.A11.push(n.K6[t][n.K6[t].length-1])},paint:function(){function e(i){var n=t.M0[i];(t.A6[n].HT||t.A6[n].E7.length&&t.A.BA||"none"!==t.A6[n].IY)&&(t.H.O3=!1),t.A47=!0;var a=t.C.getToggleAction();t.C.AJ["3d"]?t.C.D["plot"+n+".visible"]&&(t.A6[n].paint(),t.H.ZI()):(t.C.D["plot"+n+".visible"]||"hide"===a)&&("undefined"!=typeof t.C.D["plot-"+n+"-first-run"]&&(t.A6[n].TM=0),t.A6[n].paint(),t.A6[n].TM=0,t.H.ZI(),t.C.D["plot"+n+".visible"]||"hide"!==a||(t.C.D["plot"+n+".visible"]=!0,t.A.Q4({plotindex:n,"ignore-legend":!0}))),t.C.D["plot-"+n+"-first-run"]=!1,i<t.A6.length-1?t.C.LG?ZC.ASYNC_TICK[t.C.K]=window.setTimeout(function(){e(i+1)},10):t.A6.length<=100&&e(i+1):(!t.C.LG||t.C.LG&&t.A47)&&t._end_()}var t=this;if(t.HN=[],t.A6.length>0)if(t.A6.length>100&&!t.C.LG)for(var i=0;i<t.A6.length;i++)e(i);else e(0);else t._end_()},_end_:function(){function e(e){var t=0,n=e.indexOf("-plotset-plot-"),a=e.indexOf("-node-",n);return-1!==n&&-1!==a&&(t=e.substr(n+14,a-n-14)),"undefined"!=typeof i.A6[t].D["z-mid"]?i.A6[t].D["z-mid"]:t}var t,i=this;i.RV=null,i.VF=null;for(var n=0;n<i.C.BM.length;n++)i.C.BM[n].ET=null,i.C.BM[n].W8=null;var a=["bubble","hbubble","vbullet","hbullet","radar","vbar3d","hbar3d","mixed","mixed3d","pie3d","hmixed","hmixed3d"];(t=ZC.AK(i.C.A.K+"-map"))&&!i.H.A10&&(-1===ZC.AV(a,i.C.AF)&&1!==zingchart.SORTTRACKERS||i.HN.sort(function(t,n){return"pie3d"===i.C.AF?ZC.AP.MY(t)>ZC.AP.MY(n)?1:ZC.AP.MY(t)<ZC.AP.MY(n)?-1:0:e(t)>e(n)&&i.A.AJ["3d"]?1:e(t)<e(n)&&i.A.AJ["3d"]?-1:ZC.AP.MY(t)>ZC.AP.MY(n)?1:ZC.AP.MY(t)<ZC.AP.MY(n)?-1:0}),zingchart.DEV.DELAYEDTRACKERS?window.setTimeout(function(){t.innerHTML+=i.HN.join("")},500):t.innerHTML+=i.HN.join("")),i.F1=null,i.D6=null,i.C.A93=[],i.A._end_()}}),ZC.Z6=ZC.LF.C7({ACQ:function(e){var t=this;switch(e){default:return new ZC.QO(t);case"vline":var i=new ZC.QO(t);return i.OI=!0,i;case"poly":var n=new ZC.P5(t);return n.bPoly=!0,n.sTypeX="poly",n;case"area":return new ZC.QG(t);case"varea":var a=new ZC.QG(t);return a.OI=!0,a;case"bar":case"vbar":return new ZC.QI(t);case"hbar":return new ZC.QD(t);case"scatter":return new ZC.P5(t);case"hscatter":return new ZC.P5(t,"hscatter");case"bubble":return new ZC.RW(t);case"hbubble":return new ZC.RW(t,"hbubble");case"stock":return new ZC.V9(t);case"range":return new ZC.TU(t);case"line3d":return new ZC.UE(t);case"area3d":return new ZC.UB(t);case"bar3d":case"vbar3d":return new ZC.U4(t);case"bullet":case"vbullet":return new ZC.T8(t);case"hbullet":return new ZC.TA(t)}}}),ZC.IC=ZC.HS.C7({$i:function(e){this.b(e);var t=this;t.C=e.A,t.H=t.C.A,t.A5Y={},t.HK=!1,t.SO=3,t.A19=1,t.X=[],t.KB={},t.R=[],t.AF="",t.sTypeX=null,t.IB=null,t.RI=!1,t.IY="none",t.O2="plot",t.UL=!0,t.SR=null,t.SX=null,t.TJ={},t.A2=null,t.G4=null,t.PH=null,t.PE=null,t.BP=null,t.L=-1,t.BM=[],t.CB=!1,t.KQ="normal",t.DY=0,t.U=null,t.NZ=null,t.A8=null,t.JR=null,t.AR=null,t.JV=null,t.A64=null,t.YB=null,t.DU=-1,t.HW=-1,t.R5=null,t.RR=null,t.ZP=!1,t.SE=2,t.A2V=!1,t.TI="",t.ZN="standard",t.CW=null,t.A0Q=null,t.MO=null,t.RS=null,t.XU=!0,t.XG=null,t.Y0=1,t.QC=!1,t.QH=!0,t.JN=0,t.XV=null,t.ST=null,t.PR=!0,t.JY=null,t.AAD=1,t.A29=1,t.S0=[],t.J7=null,t.ED=!1,t.SQ=[],t.A6L=-1,t.GA=!1,t.L6=0,t.JD=.6,t.L5=0,t.AC0=0,t.ABY=null,t.TM=0,t.FT=null,t.IG=!1,t.YJ=!0,t.A6T=!1,t.XW=1,t.YG=0,t.I5=!1,t.L8=!1,t.A3G="node",t.LJ=!1,t.R3=-1,t.RH=0,t.Q8=!1,t.GO=[null,null,null,null],t.OZ="line"},applyRGBA:function(){var e,t=this;null!==ZC._n_(e=t.D["l-alpha"])&&null===ZC._n_(t.J5.alpha)&&(t.C5=e),null!==ZC._n_(e=t.D["bg-alpha"])&&null===ZC._n_(t.J5["alpha-area"])&&(t.o["alpha-area"]=e)},FP:function(e,t){var i=this;return(void 0===t||!i.GO[t]&&i.GO[1])&&(t=1),e=parseInt(e,10),!i.IG||"xy"!==i.C.AJ.layout&&"yx"!==i.C.AJ.layout?i.R[e]:i.R[e]&&i.GO[t]?(i.GO[t].K=i.K+"-node-"+e,i.GO[t].o={value:i.X[e]},"string"==typeof i.X[e]&&(i.GO[t].A1Z=!0),i.GO[t].L=e,"line"!==i.AF&&"area"!==i.AF&&"vline"!==i.AF&&"varea"!==i.AF||i.U?i.GO[t].parse():null===i.R[e].BU&&"undefined"==typeof i.C.D["plot-"+i.L+"-first-run"]||i.GO[t].parse(),"line"===i.AF||"area"===i.AF||"vline"===i.AF||"varea"===i.AF?"xy"===i.C.AJ.layout?(null!==i.R[e].BU?i.GO[t].iX=i.R[e].iX=i.B1.B2(i.R[e].BU):i.GO[t].iX=i.R[e].iX=i.B1.I4(e),i.CB&&"100%"===i.KQ?i.GO[t].iY=i.R[e].iY=i.CM.B2(100*i.R[e].CR/i.A.F7[e]["%total-"+i.DY]):i.GO[t].iY=i.R[e].iY=i.CM.B2(i.R[e].CR)):(null!==i.R[e].BU?i.GO[t].iY=i.R[e].iY=i.B1.B2(i.R[e].BU):i.GO[t].iY=i.R[e].iY=i.B1.I4(e),i.CB&&"100%"===i.KQ?i.GO[t].iX=i.R[e].iX=i.CM.B2(100*i.R[e].CR/i.A.F7[e]["%total-"+i.DY]):i.GO[t].iX=i.R[e].iX=i.CM.B2(i.R[e].CR)):i.GO[t].T1(),i.GO[t].JB=i.R[e].JB,i.GO[t]):null},UY:function(e,t){var i=this;i.JY[e]||(i.JY[e]=[]),(!i.IG||i.IG&&-1===ZC.AV(i.JY[e],t))&&i.JY[e].push(t)},TH:function(){return new ZC.M5(this)},ABT:function(){return{}},NO:function(){return this.Z5("palette","A6L","i"),this.C.A.B8.A9M(-1!==this.A6L?this.A6L:this.L,this.C.AF)},NM:function(){var e=this;if(e.BP[4]){var t,i={};for(var n in e.BP[4])-1===(t=n.indexOf("."))?null===ZC._n_(e.o[n])&&(i[n]=!0,e.o[n]=e.BP[4][n]):n.substring(0,t)===e.AF&&(null===ZC._n_(e.o[n.substring(t+1)])||i[n.substring(t+1)])&&(e.o[n.substring(t+1)]=e.BP[4][n])}},I8:function(e,t){var i,n,a=this,r=!1,l="";if("none"!==a.IY&&(a.C.IT[a.L]||a.C.KD)){var o=!(e.D["selected-state"]||e.D["background-state"]);a.C.CH["p"+a.L]&&a.C.CH["p"+a.L]["n"+e.L]?zingchart.DEV.CACHESELECTION&&o&&a.TJ["selected-state"]?(n=a.TJ["selected-state"],r=!0):(l="selected-state",(n=new ZC.DS(a)).copy(t),e.D["selected-state"]?n.OG=e.D["selected-state"]:n.OG=a.SR?a.SR.o:{}):"none"!==a.O2&&("plot"===a.O2&&a.C.IT[a.L]||"graph"===a.O2&&a.C.KD)&&(zingchart.DEV.CACHESELECTION&&o&&a.TJ["background-state"]?(n=a.TJ["background-state"],r=!0):(l="background-state",(n=new ZC.DS(a)).copy(t),e.D["background-state"]?n.OG=e.D["background-state"]:n.OG=a.SX?a.SX.o:{})),r||(n?(n.PR=!0,n.parse()):(n=new ZC.DS(a)).copy(t),zingchart.DEV.CACHESELECTION&&o&&""!==l&&(a.TJ[l]=n))}else(n=new ZC.DS(a)).copy(t);return null!==ZC._n_(i=a.SQ[e.L])&&(0===e.A.E7.length&&(e.A.E7=[{}]),"string"==typeof a.SQ[e.L]?n.append({"background-color":ZC.AP.JH(i,20)+" "+i,"line-color":i,"border-color":ZC.AP.JH(i,20)}):n.append(a.SQ[e.L]),n.parse()),n.Z=t.Z,n.C6=t.C6,n},BT:function(e){var t=this,i=[];if(null!==ZC._n_(e))for(var n=0,a=t.BM.length;n<a;n++){var r=t.C.BN(t.BM[n]);r&&r.AF===e&&i.push(t.BM[n])}else i=t.BM;return i},ML:function(){var e=this;return{negation:e.ZN,"thousands-separator":e.R5,"decimals-separator":e.RR,decimals:e.DU,"max-decimals":e.HW,"short":e.A2V,"short-unit":e.TI,exponent:e.ZP,"exponent-decimals":e.SE}},parse:function(){function e(e){var t=["("+r.AF+").plot."+e];return r.sTypeX&&t.push("("+r.sTypeX+").plot."+e),t}var t,i,n,a,r=this;if(r.UJ={},r.b(),r.JY={},null!==ZC._n_(t=r.o.scales))for(r.BM=t.split(/,|;|\s/),n=0;n<r.BM.length;n++)r.BM[n]=ZC.U7(ZC.GT(r.BM[n]));if(r.C.o.legend&&r.C.o.legend["highlight-plot"]&&(r.I5=!0),null!==ZC._n_(r.o.multiplier)&&null===ZC._n_(r.o["short"])&&(r.o["short"]=r.o.multiplier),null!==ZC._n_(r.o["click-marker"])&&null===ZC._n_(r.o["selection-mode"])&&null===ZC._n_(r.o["selected-marker"])&&(r.o["selection-mode"]="multiple",r.o["selected-marker"]={},ZC._cp_(r.o["click-marker"],r.o["selected-marker"])),r.KQ=r.C.KQ,r.assign_a([["ignore","HK","b"],["exponent","ZP","b"],["exponent-decimals","SE","ia"],["decimals","DU","ia"],["max-decimals","HW","i"],["preview","QH","b"],["stacked","CB","b"],["stack-type","KQ"],["exact","QC","b"],["text","AR"],["tooltip-text","JV"],["legend-text","A64"],["description","YB"],["stack","DY","i"],["z-index","JN","i"],["aspect","CW"],["mode","A0Q"],["density","XW","f"],["max-nodes","MO"],["max-trackers","RS"],["segment-trackers","XU","b"],["sampling-step","XG","i"],["scroll-step-multiplier","Y0","i"],["url","E8"],["target","F9"],["decimals-separator","RR"],["thousands-separator","R5"],["short","A2V","b"],["negation","ZN"],["short-unit","TI"],["fast-rules","A6T","b"],["errors","S0"],["styles","SQ"],["monotone","Q8","b"],["highlight","I5","b"],["highlight-legend","L8","b"],["hover-mode","A3G"],["mid-point","UL","b"],["clustered","LJ","b"],["cluster-index","R3","i"],["cluster-offset","RH","i"],["animate","GA","b"],["effect","L6","i"],["speed","JD","f"],["selection-mode","IY"],["group-selections","RI","b"],["background-mode","O2"],["extra-values","YG","ia"]]),r.AAI=r.QC,!r.D["quick-parse"]){if(ZC._todash_(r.SQ),r.I5&&(null===ZC._n_(r.C.o.legend)||null===ZC._n_(r.C.o.legend["highlight-legend"]))&&ZC._n_(null===r.o["highlight-legend"])&&(r.L8=r.I5),null!==ZC._n_(t=r.o.animation)){r.GA=!0;var l;null!==ZC._n_(i=t.effect)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(l=ZC.ANIMATION[(i+"").substring(10)])&&(i=l),r.L6=ZC._i_(i),0===r.L6&&(r.GA=!1)),null!==ZC._n_(i=t.speed)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(l=ZC.ANIMATION[(i+"").substring(10)])&&(i=l),r.JD=ZC._f_(i)),null!==ZC._n_(i=t.delay)&&(r.L2=ZC._f_(i)),null!==ZC._n_(i=t.method)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(l=ZC.ANIMATION[(i+"").substring(10)])&&(i=l),r.L5=ZC._i_(i)),null!==ZC._n_(i=t.sequence)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(l=ZC.ANIMATION[(i+"").substring(10)])&&(i=l),r.TM=ZC._i_(i)),null!==ZC._n_(i=t.attributes)&&(r.FT=i)}r.JD<10&&(r.JD*=1e3),r.L2<10&&(r.L2*=1e3),"undefined"!=typeof ZC.PB&&(r.JD=ZC.BQ(ZC.PB.TW,r.JD)),("fast"===r.A0Q||"undefined"==typeof ZC.PB||zingchart.SKIP.ANIMATION)&&(r.GA=!1),r.H.A10&&(r.GA=!1),-1!==ZC.AV(["line","area","vbar","hbar","stock","scatter","bubble","radar","piano"],r.AF)&&("fast"===r.A0Q?r.IG=!0:"normal"===r.A0Q||r.GA||-1!==JSON.stringify(r.o).indexOf('"rules"')||-1!==JSON.stringify(r.o).indexOf('"js-rule"')||0!==r.SQ.length||-1!==r.H.D.json.indexOf('"override"')||-1!==r.H.D.json.indexOf('"errors"')||"none"!==r.IY?r.IG=!1:r.IG=!0);for(var o in r.o)if("data-"===o.substring(0,5)){var s=o.substring(5);r.KB[s]=r.o[o]}var c=r.H.B8;if(r.IB=new ZC.D0(r),r.IB.append(r.o),c.load(r.IB.o,e("hover-state")),r.IB.append(r.o["hover-state"]),null!==ZC._n_(r.o["hover-state"])||"line"!==r.AF&&"area"!==r.AF||(r.IB.AM=!1),r.I5&&(r.S2=new ZC.D0(r),c.load(r.S2.o,e("highlight-state")),r.S2.append(r.o),null!==ZC._n_(t=r.o["highlight-state"])&&r.S2.append(t),null===ZC._n_(r.S2.o.shadow)&&(r.S2.o.shadow=!0)),null!==ZC._n_(t=r.o["selected-state"])&&(r.SR=new ZC.D0(r),c.load(r.SR.o,e("selected-state")),r.SR.append(t)),null!==ZC._n_(t=r.o["background-state"])&&(r.SX=new ZC.D0(r),c.load(r.SX.o,e("background-state")),r.SX.append(t)),r.A2=new ZC.D0(r),c.load(r.A2.o,e("marker")),c.load(r.A2.o,e("marker["+r.CW+"]")),r.A2.append(r.o.marker),"auto"===r.A2.o.type){var h=["circle","square","diamond","triangle","star5"];r.A2.o.type=h[r.L%h.length]}if(r.A2.parse(),(r.A2.E7.length>0||r.SQ.length>0||r.A2.o["top-state"])&&(r.YJ=!1),r.G4=new ZC.D0(r),c.load(r.G4.o,e("hover-marker")),r.G4.append(r.o.marker),r.G4.append(r.o["hover-marker"]),null!==ZC._n_(t=r.o["selected-marker"])&&(r.PH=new ZC.D0(r),c.load(r.PH.o,e("selected-marker")),r.PH.append(t)),null!==ZC._n_(t=r.o["background-marker"])&&(r.PE=new ZC.D0(r),c.load(r.PE.o,e("background-marker")),r.PE.append(t)),r.I5&&(r.UU=new ZC.D0(r),r.UU.append(r.o.marker),null!==ZC._n_(t=r.o["highlight-marker"])&&(c.load(r.UU.o,e("highlight-marker")),r.UU.append(t))),"normal"!==r.A0Q&&(r.SR||r.PH)&&(r.IG=!1),"fast"===r.A0Q&&(r.IG=!0),r.A8=new ZC.DS(r),r.o.tooltip&&r.o.tooltip.placement&&r.o.tooltip.placement.indexOf("node")>-1?c.load(r.A8.o,"("+r.AF+").tooltip[dynamic]"):c.load(r.A8.o,r.AF+".tooltip"),r.A8.append(r.o.tooltip),null!==ZC._n_(t=r.o.error)&&(r.J7=new ZC.DW(r),c.load(r.J7.o,e("error")),r.J7.append(t),null===ZC._n_(r.J7.o.size)&&(r.J7.o.size=4)),null!==ZC._n_(t=r.o["value-box"])){if(t instanceof Array)for(r.U=new ZC.D0(r),c.load(r.U.o,e("value-box")),null!==ZC._n_(i=r.C.o.plot)&&r.U.append(i["value-box"]),r.U.append(t[0]),t.length>1&&(r.NZ=[]),n=1;n<t.length;n++)r.NZ[n-1]=new ZC.D0(r),c.load(r.NZ[n-1].o,e("value-box")),null!==ZC._n_(i=r.C.o.plot)&&r.NZ[n-1].append(i["value-box"]),r.NZ[n-1].append(t[n]);else r.U=new ZC.D0(r),c.load(r.U.o,e("value-box")),null!==ZC._n_(i=r.C.o.plot)&&r.U.append(i["value-box"]),r.U.append(t);r.U.parse()}r.H.QV&&(r.AM=ZC.FSSTATUS["g-"+r.C.L+"-p-"+r.L]);var C=!1;for("undefined"==typeof r.C.D["plot"+r.L+".visible"]&&(C=!0),C?r.C.D["plot"+r.L+".visible"]=!0:r.AM=r.C.D["plot"+r.L+".visible"],r.AM||C&&(r.C.D["plot"+r.L+".visible"]=!1),n=0,a=r.C.BM.length;n<a;n++)null!==ZC._n_(r.C.BM[n].o.values)?r.C.BM[n].T3=!0:-1!==ZC.AV(r.BM,r.C.BM[n].BC)&&("remove"===r.C.getToggleAction()||r.C.A.K5?r.AM&&r.C.D["plot"+r.L+".visible"]&&(r.C.BM[n].T3=!0):r.C.BM[n].T3=!0);var u=null;if(r.K=r.A.K+"-plot-"+r.L,r.R=[],r.A.F7||(r.A.F7={}),-1!==r.AF.indexOf("area")&&-1===r.AF.indexOf("3d")&&r.CB){r.A.WB||(r.A.WB={}),r.A.WB["s"+r.DY]||(r.A.WB["s"+r.DY]=[]);var d=!1;if(null!==ZC._n_(r.o.values))for(n=0,a=r.o.values.length;n<a;n++)if("object"==typeof r.o.values[n]&&null!==ZC._n_(r.o.values[n])){d=!0;break}d&&(r.GA=!1,r.HT||0!==r.E7.length||(r.IG=!0,-1===zingchart.DEV.STACKINGLOGIC&&(r.C.U8=1)))}r.B1=r.C.BN(r.BT("k")[0]),r.CM=r.C.BN(r.BT("v")[0]);var p;if(null!==ZC._n_(r.o.values)&&""!==r.AF){r.X=r.o.values;var A=null;r.PT=[ZC.MAX,-ZC.MAX];var g=[],f=[],Z=0;for(n=0,a=r.X.length;n<a;n++){var _=!1;if(r.o["hint-ts"]||(null!==ZC._n_(r.X[n])&&"object"==typeof r.X[n]&&r.X[n].length>1?(null===ZC._n_(r.X[n][1])||"string"==typeof r.X[n][1]&&"NULL"===r.X[n][1].toUpperCase())&&(_=!0):(null===ZC._n_(r.X[n])||"string"==typeof r.X[n]&&"NULL"===r.X[n].toUpperCase())&&(_=!0),"piano"===r.C.AF&&(_=!1)),_)r.R.push(null);else{!r.IG||"xy"!==r.C.AJ.layout&&"yx"!==r.C.AJ.layout?u=r.TH():r.GO[1]||("bubble"===r.AF||"scatter"===r.AF?r.GO[1]=u=r.TH():(r.GO[0]=r.TH(),r.GO[1]=u=r.TH(),r.GO[2]=r.TH(),r.GO[3]=r.TH())),u.K=r.K+"-node-"+n,"string"==typeof r.X[n]&&zingchart.QUOTEDVALUES&&(r.X[n]=ZC._f_(r.X[n])),u.o={value:r.X[n]},"string"==typeof r.X[n]&&(u.A1Z=!0),u.L=n,r.o["hint-ts"]?(u.D.plotidx=r.L,u.D.nodeidx=u.L,u.K=r.K+"-node-"+u.L,u.BU=r.X[n][0],u.AD=r.X[n][1]):u.parse(),(a<256||zingchart.DEV.CHECKDECIMALS)&&null!==ZC._n_(u.AD)&&2===(p=u.AD.toString().split(".")).length&&(Z=ZC.BQ(Z,p[1].length)),u.BU&&(null!==A&&ZC._a_(u.BU-A)>0&&g.push(ZC._a_(u.BU-A)),A=u.BU),r.A.WB=r.A.WB||{};var b=r.A.WB["s"+r.DY];if(b&&(null!==A?-1===ZC.AV(b,u.BU)&&b.push(u.BU):-1===ZC.AV(b,n)&&b.push(n)),!r.IG||"xy"!==r.C.AJ.layout&&"yx"!==r.C.AJ.layout)r.R.push(u);else{var m={iX:u.iX,iY:u.iY,L:u.L,BU:u.BU,AD:u.AD,CR:u.AD,DN:u.DN,JB:u.JB};"bubble"===r.AF&&(m.SK=u.SK),r.R.push(m)}null!==u.BU&&(r.PT[0]=Math.min(r.PT[0],u.BU),r.PT[1]=Math.max(r.PT[1],u.BU)),r.C.D["plot"+r.L+".visible"]&&(zingchart.DEV.PLOTSTATS||"100%"===r.KQ)&&r.CB&&(null===ZC._n_(r.A.F7[n])?(r.A.F7[n]={},r.A.F7[n]["%total-"+r.DY]=u.AD):null===ZC._n_(r.A.F7[n]["%total-"+r.DY])?r.A.F7[n]["%total-"+r.DY]=u.AD:r.A.F7[n]["%total-"+r.DY]+=u.AD),zingchart.DEV.PLOTSTATS&&(f.push(u.AD),r.JR?(r.JR["%plot-max-index"]=n,r.JR["%plot-sum"]+=u.AD,a<256&&(r.JR["%plot-values"]+=","+u.AD)):r.JR={"%plot-min-index":n,"%plot-max-index":n,"%plot-sum":u.AD,"%plot-values":u.AD},r.A.F7||(r.A.F7={}),r.AM&&(null===ZC._n_(r.A.F7["%pstack-"+n+"-"+r.DY+"-sum"])?(r.A.F7["%pstack-"+n+"-"+r.DY+"-sum"]=u.AD,r.A.F7["%pstack-"+n+"-"+r.DY+"-stack-length"]=1):(r.A.F7["%pstack-"+n+"-"+r.DY+"-sum"]+=u.AD,r.A.F7["%pstack-"+n+"-"+r.DY+"-stack-length"]+=1)))}}(r.X.length<256||zingchart.DEV.CHECKDECIMALS)&&r.JR&&null!==ZC._n_(r.JR["%plot-sum"])&&2===(p=r.JR["%plot-sum"].toString().split(".")).length&&ZC._i_(p[1])>Z&&(r.JR["%plot-sum"]=ZC._f_(r.JR["%plot-sum"].toFixed(ZC.CY(20,Z)))),zingchart.DEV.PLOTSTATS?(r.JR&&(r.JR["%plot-average"]=r.JR["%plot-sum"]/r.X.length,r.JR["%plot-average"]=ZC._f_(r.JR["%plot-average"].toFixed(ZC.CY(20,Z+2)))),f.length>0&&(r.JR["%plot-min-value"]=ZC.XS(f),r.JR["%plot-max-value"]=ZC.A1H(f))):r.JR={"%plot-min-index":0,"%plot-max-index":r.X.length,"%plot-sum":-1,"%plot-values":"","%plot-average":-1,"%plot-min-value":-1,"%plot-max-value":-1},A&&g.length>0&&(r.AAD=ZC.XS(g),r.A29=ZC.A1H(g))}}},mapPointsToPreview:function(e,t){for(var i=this,n=i.C.P,a=i.C.BA.AQ,r=[],l=0,o=e.length;l<o;l++)if(e[l]){"vml"===i.H.AC&&t&&(e[l][0]=e[l][0]/10,e[l][1]=e[l][1]/10);var s=(e[l][0]-n.iX)/n.I,c=(e[l][1]-n.iY)/n.F,h=a.iX+a.AT+s*(a.I-2*a.AT),C=a.iY+a.AT+c*(a.F-2*a.AT);r.push([h,C])}else r.push(null);return r},paint:function(){var e=this,t=e.C.P.I;switch(e.C.AF){case"scatter":case"bubble":t=1e6;break;case"hbar":case"hbar3d":t=e.C.P.F}null===ZC._n_(e.MO)&&(e.MO=ZC._i_(t/4)),null===ZC._n_(e.RS)&&(e.RS=ZC._i_(t/4)),e.YJ&&(e.HA=null,e.HG=null,e.R9=null,e.Q5=null)},XF:function(e){var t,i,n,a=this;for(t=0,i=a.R.length;t<i;t++)a.R[t]&&(a.R[t].JB=!1);var r=a.C.P;if(a.R2=!1,a.FW=!0,a.TY=!1,n=0,a.C.O7||"undefined"!=typeof a.AAI&&(a.QC=a.AAI),e)a.R2=!0,a.RS<a.R.length&&(a.FW=!1);else{if(a.B1.ED&&a.ED){for(t=0,i=a.R.length;t<i;t++)a.R[t]&&(a.B1.IM.length>0||ZC.DT(a.R[t].BU,a.B1.X[a.B1.V],a.B1.X[a.B1.A1]))&&n++;a.RS<n&&(a.FW=!1),n*a.XW>r.I&&(a.TY=!0),a.MO>=n&&(a.R2=!0)}else a.MO>a.B1.A1-a.B1.V&&(a.R2=!0);a.W=1,a.B1.ED&&a.ED||(n=a.B1.A1-a.B1.V,a.RS<n&&(a.FW=!1),n*a.XW>r.I&&(a.TY=!0),!a.QC&&n*a.XW>r.I&&(a.W=ZC.BQ(1,ZC._i_(n*a.XW/r.I)))),a.B1.ED&&a.ED&&(a.QC||n*a.XW>r.I&&(a.W=ZC.BQ(1,ZC._i_(n*a.XW/r.I)))),a.C.O7&&(a.QC=!1,a.W*=a.Y0)}null!==ZC._n_(a.XG)&&a.W>a.XG&&(a.W=a.XG)},P8:function(e){function t(e,i){for(var n=e;n<ZC.CY(e+i,r.R.length);n++)r.R[n]?((l=r.FP(n)).Z=r.KC,l.paint(),l.JB=!0,r.R[n].JB=!0):"radar"===r.C.AF&&(n===r.R.length-1?"line"!==r.CW&&"area"!==r.CW&&"range"!==r.CW||ZC.CS.paint(r.Q2,r,r.E):r.E.push(null));e+i<r.R.length?r.C.LG?window.setTimeout(function(){t(e+i,i)},10):t(e+i,i):r.C.LG&&r.L===r.A.A6.length-1&&r.A._end_()}var i,n,a,r=this;null!==ZC._n_(e)&&e||(e=!1),r.B1&&"log"===r.B1.CA&&(e=!0),r.XF(e);var l=null;if(e||r.LJ)r.A.A47=!1,t(0,ZC.ie678||ZC.mobile?200:2e3);else{var o="vbar"!==r.AF&&"hbar"!==r.AF;if(r.B1.ED&&r.ED){a=r.G7=r.HD=r.W;var s=!0,c=0,h=0;for(i=0,n=r.R.length;i<n;i+=a)o&&(n-i==1?(r.G7=a,r.HD=1):n-i<r.W&&(r.G7=r.W,r.HD=n-i-1,a=n-i-1)),r.R[i]&&(r.B1.IM.length>0||ZC.DT(r.R[i].BU,r.B1.X[r.B1.V],r.B1.X[r.B1.A1])||o&&s&&r.R[i+a]&&r.R[i+a].BU>=r.B1.X[r.B1.V])&&(o&&s&&r.R[i-a]&&((l=r.FP(i-a)).Z=r.KC,l.paint(),l.JB=!0,s=!1,h++),(l=r.FP(i)).Z=r.KC,l.paint(),l.JB=!0,h++,s=!1,c=i);o&&h>0&&r.R[c+a]&&((l=r.FP(c+a)).Z=r.KC,l.paint(),l.JB=!0)}else{a=r.G7=r.HD=r.W;var C=0,u=1,d=null;if(!o){var p="vbar"===r.AF?r.C.P.I:r.C.P.F;C=4/("vbar"===r.AF?r.C.P.F:r.C.P.I)*(r.CM.BL-r.CM.B4),u=1+ZC._i_((r.B1.A1-r.B1.V)/(2*p)),a=1}for(i=r.B1.V;i<=r.B1.A1;i+=a)(r.B1.A1-r.B1.V)%r.W!=0&&o&&(r.B1.A1-i==0?(r.G7=a,r.HD=1):r.B1.A1-i<=r.W&&(r.G7=r.W,r.HD=r.B1.A1-i,a=r.B1.A1-i)),r.R[i]?(l=r.FP(i),(o||r.QC||!o&&null===d||ZC._a_(l.AD-d)>C||i%u==0)&&(l.Z=r.KC,l.paint(),l.JB=!0,r.R[i].JB=!0),d=l.AD):r.CB&&-1!==ZC.AV(["vbar","hbar","vbar3d","hbar3d"],r.AF)&&r.QF()}}},CO:function(e,t){var i=this;if(i.UJ[e+t])return i.UJ[e+t];var n=null;return n=i.H.usc()?ZC.AK(i.H.K+"-main-c"+("fl"===e?"-top":"")):i.H.K5||i.C.AJ["3d"]?ZC.AK(i.C.K+"-plots-"+e+"-c"):ZC.AK(i.C.K+"-plot-"+i.L+"-"+e+"-"+t+"-c"),i.UJ[e+t]||(i.UJ[e+t]=n),n},UZ:function(e){var t=this;return{id:t.H.K,graphid:t.C.K,graphidx:t.C.L,plotid:t.H2,plotindex:t.L,plottext:t.AR,ev:e?ZC.A4.C0(e):null,xdata:t.KB}},WW:function(e,t){ZC.AP.BZ("plot_"+t,this.H,this.UZ(e))},applyJsRuleSvg:function(e,t,i){var n,a=this;if(n=e.o["js-rule-svg"]){var r=ZC.AK(t),l=ZC.evalFn(n.replace("javascript:","").replace("()",""),window);if(r&&l)try{var o=l.call(a,i);for(var s in o)r.setAttribute(s,o[s])}catch(c){}}},sharedZScale:function(){var e=this,t=e.C,i=t.P;if(t.o["scale-z"]&&t.D["plot"+e.L+".visible"]){var n,a,r,l,o;if(n=new ZC.CF(t,i.iX+i.I-ZC.AN.E3+10,i.iY+i.F-ZC.AN.E2,e.D["z-mid"]),a=new ZC.DS(e),a.GJ=t.K+"-scale-z-item "+t.K+"-scale-item zc-scale-item",a.K=t.K+"-scale-z-item_"+e.L,a.AR=t.o["scale-z"].values[e.L],a.Z=a.C6=e.H.usc()?e.H.mc():ZC.AK(t.K+"-scales-ml-0-c"),o=ZC.Q.E9(a.Z,e.H.AC),a.IK=e.H.usc()?ZC.AK(e.H.K+"-main"):ZC.AK(e.H.K+"-text"),a.append(t.o["scale-z"].item),a.parse(),a.AA+=a.V2?0:ZC.DH.A2X(t,a),a.iX=n.EB[0],a.iY=n.EB[1],a.o["auto-align"]&&a.V2&&(a.iY-=a.F/2),a.paint(),null===ZC._n_(e.D["scale-z-item-max-width"])&&(e.D["scale-z-item-max-width"]=0),e.D["scale-z-item-max-width"]=ZC.BQ(e.D["scale-z-item-max-width"],a.I),e.D["z-cnt"]===e.D["z-plots"]-1&&t.o["scale-z"].label){n=new ZC.CF(t,i.iX+i.I-ZC.AN.E3+20+e.D["scale-z-item-max-width"],i.iY+i.F-ZC.AN.E2,ZC.AN.FS/2),(a=new ZC.DS(e)).GJ=t.K+"-scale-z-label "+t.K+"-scale-label zc-scale-label",a.K=t.K+"-scale-z-label",a.Z=a.C6=e.H.usc()?e.H.mc():ZC.AK(t.K+"-scales-ml-0-c"),o=ZC.Q.E9(a.Z,e.H.AC),a.IK=e.H.usc()?ZC.AK(e.H.K+"-main"):ZC.AK(e.H.K+"-text"),a.append(t.o["scale-z"].label),a.parse();var s,c;s=new ZC.CF(t,i.iX+i.I-ZC.AN.E3,i.iY+i.F-ZC.AN.E2,0),c=new ZC.CF(t,i.iX+i.I-ZC.AN.E3,i.iY+i.F-ZC.AN.E2,ZC.AN.FS);var h=ZC.TO(Math.atan((c.EB[1]-s.EB[1])/(c.EB[0]-s.EB[0])));a.AA+=a.V2?0:h,a.iX=n.EB[0],a.iY=n.EB[1],a.paint()}if(t.o["scale-z"].tick&&(l=new ZC.DW(e),l.B7="#cccccc",l.B0=1,l.AI=6,l.append(t.o["scale-z"].tick),l.parse(),l.AM&&l.B0>0)){l.K=t.K+"-scale-z-tick-"+e.L;for(var C=[],u=[[i.iX+i.I,i.iY+i.F],[i.iX+i.I+l.AI,i.iY+i.F]],d=0;d<u.length;d++)n=new ZC.CF(t,u[d][0]-ZC.AN.E3,u[d][1]-ZC.AN.E2,e.D["z-mid"]),C.push([n.EB[0],n.EB[1]]);ZC.CS.paint(o,l,C)}if(0===e.D["z-cnt"]&&((l=new ZC.D0(e)).B7="#cccccc",l.B0=1,l.append(t.o["scale-z"].axis),l.parse(),l.B0>0&&l.AM&&(l.A0=l.AE=l.B7,(r=ZC.DH.DA(l,t,i.iX+i.I-ZC.AN.E3-l.B0,i.iX+i.I-ZC.AN.E3,i.iY+i.F-ZC.AN.E2,i.iY+i.F-ZC.AN.E2,0,ZC.AN.FS,"x")).K=t.K+"-scale-z-axis",t.CK.add(r))),e.D["z-cnt"]>0&&t.o["scale-z"].guide&&((l=new ZC.D0(e)).B7="#cccccc",l.B0=1,l.append(t.o["scale-z"].guide),l.parse(),l.B0>0&&l.AM&&(l.A0=l.AE=l.B7,(r=ZC.DH.DA(l,t,i.iX-ZC.AN.E3,i.iX+i.I-ZC.AN.E3,i.iY+i.F-ZC.AN.E2,i.iY+i.F-ZC.AN.E2+l.B0,e.D["z-cnt"]*e.D["z-depth"],e.D["z-cnt"]*e.D["z-depth"],"y")).K=t.K+"-scale-z-guideh-"+e.L,t.CK.add(r),(r=ZC.DH.DA(l,t,i.iX-ZC.AN.E3,i.iX-ZC.AN.E3,i.iY-ZC.AN.E2,i.iY+i.F-ZC.AN.E2,e.D["z-cnt"]*e.D["z-depth"],e.D["z-cnt"]*e.D["z-depth"]+l.B0,"y")).K=t.K+"-scale-z-guidev-"+e.L,t.CK.add(r))),t.o["scale-z"].items&&t.o["scale-z"].items.length){(l=new ZC.D0(e)).A0=l.AE="#ff9900",l.C5=.25;var p=e.D["z-cnt"]%t.o["scale-z"].items.length;l.append(t.o["scale-z"].items[p]),l.parse(),(r=ZC.DH.DA(l,t,i.iX-ZC.AN.E3,i.iX+i.I-ZC.AN.E3,i.iY+i.F-ZC.AN.E2,i.iY+i.F-ZC.AN.E2,e.D["z-cnt"]*e.D["z-depth"],e.D["z-cnt"]*e.D["z-depth"]+e.D["z-depth"],"z")).K=e.K+"-item-",t.CK.add(r)}}},gc:function(){if(this.R)for(var e=0;e<this.R.length;e++)this.R[e]&&this.R[e].A&&ZC.AP.gc(this.R[e],["Z","C6","o","J5","I0","A","C","H","N","N3"]);ZC.AP.gc(this,["X","R","GO","JY","V1","A8","Z","C6","UJ","A2","TC","HA","G4","IB","KC","Q2","B1","CM","R","GO","JY","JR","o","J5","I0","A","C","H"])}}),ZC.W1=ZC.IC.C7({$i:function(e){this.b(e);var t=this;t.bXY=!0,t.AF="xy",t.BM=["scale-x","scale-y"]},paint:function(){this.b()}}),ZC.M5=ZC.DS.C7({$i:function(e){this.b(e);var t=this;t.C=e.A.A,t.H=t.C.A,t.L=-1,t.AD=null,t.DN=[],t.CR=null,t.BU=null,t.CJ=null,t.JL=[],t.HY=!1,t.PR=!0,t.N=t,t.JB=!1,t.A1Z=!1},GZ:function(e,t){this.b(this.A,e,t,this.LQ(null,!1),this.A.N2)},UV:function(){return[this.iX,this.iY,{reference:this,center:!0}]},ADH:function(){return[this.iX,this.iY]},getTooltipPosition:function(e,t,i){var n,a,r,l,o=this;switch(o.paint(!0),n=o.iX,a=o.iY,r=o.I,l=o.F,t){case"center":n=o.iX+r/2,a=o.iY+l/2;break;case"top":n=o.iX+r/2,a=o.iY,a=i?a-i:a;break;case"bottom":n=o.iX+r/2,a=o.iY+l,a=i?a+i:a;break;case"left":n=o.iX,a=o.iY+l/2,n=i?n-i:n;break;case"right":n=o.iX+r,a=o.iY+l/2,n=i?n+i:n;break;default:n+=o.BJ,a+=o.BH}return{x:n,y:a}},setNodeData:function(e){var t=this;for(var i in e)e.hasOwnProperty(i)&&(t.A.IG?t.A.R[t.L][i]=e[i]:t.D[i]=e[i])},getNodeData:function(e){return this.A.IG?this.A.R[this.L][e]:this.D[e]},AAO:function(){var e,t,i=this,n=i.C.D,a=i.A.L;null===ZC._n_(n.update)&&(n.update={});var r=n.update,l=""+i.AD,o=i.A.ML();for(ZC.P4(l)&&ZC._f_(l)<0&&"currency"===o.negation&&(l=ZC._a_(ZC._f_(l))),o.utc=i.C.U9,o.timezone=i.C.N6,l=ZC.AP.GF(l,o,i.A),r["plot-"+a+"-value"]=l,r["plot-"+a+"-value-0"]=l,e=0,t=i.DN.length;e<t;e++)r["plot-"+a+"-value-"+(e+1)]=i.DN[e];for(r["plot-value"]=r["plot-value-0"]=l,e=0,t=i.DN.length;e<t;e++)r["plot-value-"+(e+1)]=i.DN[e];for(var s in i.A.KB){var c=null;c="object"==typeof i.A.KB[s]&&i.A.KB[s].length?i.A.KB[s][i.L]:i.A.KB[s],r["plot-"+a+"-data-"+s]=c}},T1:function(){var e,t,i=this,n=i.A.B1,a=i.A.CM,r=[n.V,n.A1,a.V,a.A1];if(i.A.IG&&(i.CR=i.A.R[i.L].CR),i.JL!==r){n.CQ?(null!==i.BU?i.iY=n.B2(i.BU):i.iY=n.I4(i.L),i.A.CB&&"100%"===i.A.KQ?i.A.A.F7[i.L]["%total-"+i.A.DY]>0?i.iX=a.B2(100*i.CR/i.A.A.F7[i.L]["%total-"+i.A.DY]):i.iX=a.B2(100*i.CR):i.iX=a.B2(i.CR+0)):(null!==i.BU?i.iX=n.B2(i.BU):i.A.LJ?"bar"===i.A.sMetaType?i.iX=n.I4(i.A.R3):i.iX=n.I4(i.A.R3)+i.A.RH+i.L*(n.A9-2*i.A.RH)/(i.A.R.length-1)-n.A9/2:i.iX=n.I4(i.L),i.A.CB&&"100%"===i.A.KQ?i.A.A.F7[i.L]["%total-"+i.A.DY]>0?i.iY=a.B2(100*i.CR/i.A.A.F7[i.L]["%total-"+i.A.DY]):i.iY=a.B2(100*i.CR):i.iY=a.B2(i.CR+0)),i.A.IG&&(i.A.R[i.L].iX=i.iX,i.A.R[i.L].iY=i.iY),i.JL=r}i.HY||(0!==i.A.E7.length||-1===ZC.AV(["line","area","vbar","hbar","line3d","area3d","vbar3d","hbar3d"],i.A.AF)||i.A.o.override?ZC.A4.browser.mozilla?(i.copy(i.A),i.E7=i.A.E7,i.DE(),i.parse(!1),i.N=i):i.A.o.override?(i.copy(i.A),i.E7=i.A.E7,i.DE(),i.parse(!1),i.N=i):(e=i.ACG(i.A.E7),null===ZC._n_(t=i.A.A5Y[e])?(i.copy(i.A),i.E7=i.A.E7,i.DE(),i.parse(!1),i.N=i,i.A.A5Y[e]=i):i.N=t):i.N=i.A,i.A.o.override&&(i.N.D.plotidx=i.A.L,i.N.D.nodeidx=i.L,i.N.parse(!1)),i.HY=!0)},A9L:function(){var e,t=this;if(t.o.value instanceof Array&&(t.CJ=t.o.value.join(" "),"string"==typeof t.o.value[0]?-1!==(e=ZC.AV(t.A.B1.IM,t.o.value[0]))?t.BU=e:(t.A.B1.IM.push(t.o.value[0]),t.BU=t.A.B1.IM.length-1):t.BU=parseFloat(t.o.value[0]),"string"==typeof t.o.value[1]?-1!==(e=ZC.AV(t.A.CM.JI,t.o.value[1]))?t.AD=e:(t.A.CM.JI.push(t.o.value[1]),t.AD=t.A.CM.JI.length-1):t.AD=parseFloat(t.o.value[1]),null!==t.BU&&t.A.UY(t.BU,t.L),t.A.YG>0&&t.o.value.length>t.A.YG))for(var i=t.o.value.length-t.A.YG;i<t.o.value.length;i++)t.DN.push(t.o.value[i])},parse:function(e){var t=this;if(t.D.plotidx=t.A.L,t.D.nodeidx=t.L,t.K=t.A.K+"-node-"+t.L,null===ZC._n_(e)&&(e=!0),e){if(t.o.value instanceof Array||t.A.A9S)t.A9L();else if(t.CJ=t.o.value,"string"==typeof t.o.value){var i=ZC.AV(t.A.CM.JI,t.o.value);-1!==i?t.AD=i:(t.A.CM.JI.push(t.o.value),t.AD=t.A.CM.JI.length-1)}else t.AD=t.o.value;null===t.CR&&(t.CR=t.AD)}else t.b()},JE:function(e){return this.KE(e,{})},getFormatValue:function(){return this.AD},KE:function(AR,ER,LM,bUrl){var s=this,G,CJ,BD,i,A7,D4;void 0===LM&&(LM=!1);var oRE,oPPI=s.A.JR,oPS=s.A.A;if(!bUrl&&"javascript:"===AR.substring(0,11))try{var EI=AR.replace("javascript:","").replace("()","");eval(EI)&&(G=0===s.DN.length?s.AD:[s.AD].concat(s.DN),AR=eval(EI).call(s,G,{nodeindex:s.L,plotindex:s.A.L,plotid:s.A.H2,nodeinfo:s.LQ(null,!1),plotinfo:s.A.UZ()})||AR)}catch(e){}var EY,PC;if(AR+="",s.A.A6T){CJ=s.getFormatValue(),null!==ZC._n_(s.A.CM.JI[CJ])&&s.A1Z&&(CJ=s.A.CM.JI[CJ]),AR=AR.replace(/%node-numeric-value/g,s.AD).replace(/%node-value/g,CJ).replace(/%previous-node-value/g,s.A.R[s.L-1]?s.A.R[s.L-1].AD:null).replace(/%next-node-value/g,s.A.R[s.L+1]?s.A.R[s.L+1].AD:null).replace(/%node-index/g,s.L).replace(/%plot-text/g,s.A.AR).replace(/%plot-index/g,s.A.L).replace(/%plot-count/g,oPS.A6.length).replace(/%p/g,s.A.L).replace(/%P/g,oPS.A6.length).replace(/%v/g,CJ).replace(/%V/g,s.AD).replace(/%i/g,s.L).replace(/%n/g,s.L);for(EY in s.A.KB)PC="",PC=s.A.KB[EY]instanceof Array?null!==s.A.KB[EY][s.L]?s.A.KB[EY][s.L]:"":null!==s.A.KB[EY]?s.A.KB[EY]:"",oRE=new RegExp("%data-"+EY,"g"),AR=AR.replace(oRE,PC);return AR}var PJ="",RT="",RD="",VN="",S=s.C.BN(s.A.BT("k")[0]),Y=s.C.BN(s.A.BT("v")[0]);S&&(null!==s.BU?PJ=RT=RD=s.BU:(null!==ZC._n_(S.X[s.L])&&(PJ=RT=RD=S.X[s.L]),null!==ZC._n_(S.BX[s.L])&&(RD=RT=S.BX[s.L]))),null!==ZC._n_(G=s.A.B1.IM[PJ])&&"number"==typeof PJ&&(PJ=G),null!==ZC._n_(G=s.A.B1.IM[RT])&&"number"==typeof RT&&(RT=G),null!==ZC._n_(G=s.A.B1.IM[RD])&&"number"==typeof RD&&(RD=G),VN=null!==ZC._n_(s.A.AR)?s.A.AR:"Series "+(s.A.L+1),s.A.LJ&&s.A.A.A6[s.L]&&(VN=s.A.A.A6[s.L].AR||"Series "+s.L);var TS=(VN+"").split(/\s+/),A60=PJ;S&&(BD=S.ML(),ER&&ER["transform-date"]&&ZC._cp_({"transform-date":!0,"transform-date-format":ER["transform-date-format"]},BD),BD.utc=s.C.U9,BD.timezone=s.C.N6,RD=RT=ZC.AP.GF(PJ,BD,S,!0),null===ZC._n_(S.BX[s.BU])&&null===ZC._n_(S.BX[s.L])||(RT=RD=S.BX[s.BU]||S.BX[s.L]),BD["transform-date"]&&(RD=ZC.AP.GF(RD,BD,S,!0)));var A56=(RT+"").split(/\s+/),A6H=(RD+"").split(/\s+/),A1R=(PJ+"").split(/\s+/);CJ=s.getFormatValue(),s.A.CM&&null!==ZC._n_(s.A.CM.JI[CJ])&&s.A1Z&&(CJ=s.A.CM.JI[CJ]);var OK=ZC.P4(CJ)&&ZC._f_(CJ)<0;if(BD=s.A.ML(),ZC._cp_(ER,BD),OK&&"currency"===BD.negation&&(CJ=ZC._a_(ZC._f_(CJ))),BD.utc=s.C.U9,BD.timezone=s.C.N6,CJ=ZC.AP.GF(CJ,BD,s.A,!(!Y||!Y.FD)&&Y.FD),"%v"===AR&&"%vv"!==AR||"%node-value"===AR)return CJ;if("%t"===AR||"%plot-text"===AR)return VN;var CV=s.CV||[];if(Y&&Y.NA){var YD=Y.ML();null===ZC._n_(YD.decimals)&&(YD.decimals=0);var AAY=Y.CQ?Y.NA(this.iX,!0,"piano"===s.A.AF):Y.NA(this.iY,!0,"piano"===s.A.AF),W9=Y.FO(0,AAY,YD);CV.push(["%scale-value-value",W9],["%vv",W9]),null!==ZC._n_(G=Y.BX[s.L])?CV.push(["%scale-value-label",G],["%vl",G]):CV.push(["%scale-value-label",W9],["%vl",W9])}if(Y&&(-1!==AR.indexOf("%scale-value-text")||-1!==AR.indexOf("%vt"))){-1!==(G=ZC.AV(Y.X,s.AD))&&null!==ZC._n_(Y.BX)&&null!==ZC._n_(Y.BX[G])?CV.push(["%scale-value-text",Y.BX[G]],["%vt",Y.BX[G]]):CV.push(["%scale-value-text",s.AD],["%vt",s.AD]),oRE=-1!==AR.indexOf("%vt(")?new RegExp("(%vt)\\(([0-9]*)\\)"):new RegExp("(%scale-value-text)\\(([0-9]*)\\)");for(var oNode_,YE,A62,oPlot_;D4=oRE.exec(AR);)YE="",""!==(G=D4[2])&&(A62=ZC._i_(G),null!==ZC._n_(oPlot_=s.A.A.A6[A62])&&null!==(oNode_=oPlot_.FP(s.L))&&(YE=oNode_.KE(D4[1]))),AR=AR.replace(D4[0],YE),""!==YE&&CV.push([D4[0],YE])}null!==ZC._n_(s.A.LW)&&null!==ZC._n_(s.A.LW[s.L])&&CV.push(["%offset-values",s.A.LW[s.L]]),s.A.A.A11&&CV.push(["%stack-top",-1!==ZC.AV(s.A.A.A11,s.A.L)?1:0]);for(EY in s.A.KB)PC="","number"==typeof(PC=s.A.KB[EY]instanceof Array?null!==s.A.KB[EY][s.L]?s.A.KB[EY][s.L]:"":null!==s.A.KB[EY]?s.A.KB[EY]:"")&&(PC=ZC.AP.GF(PC,BD,s.A,!(!Y||!Y.FD)&&Y.FD)),CV.push(["%data-"+EY,PC]);for(i=0;i<A56.length;i++)CV.push(["%scale-key-label-"+i,A56[i]],["%kl"+i,A56[i]]);for(i=0;i<A6H.length;i++)CV.push(["%scale-key-text-"+i,A6H[i]],["%kt"+i,A6H[i]]);for(i=0;i<A1R.length;i++)CV.push(["%scale-key-value-"+i,A1R[i]],["%kv"+i,A1R[i]],["%k"+i,A1R[i]]);var p,pLen;for(p=0,pLen=oPS.A6.length;p<pLen;p++)null!==ZC._n_(oPS.A6[p].R[s.L])&&CV.push(["%plot-"+p+"-value",oPS.A6[p].R[s.L].AD]);CV.push(["%scale-key-label",RT],["%scale-key-text",RD],["%scale-key-value",PJ],["%scale-key-value-ts",A60],["%kvts",A60],["%kt",RD],["%kl",RT],["%kv",PJ],["%k",PJ],["%node-value",CJ],["%v",CJ],["%node-numeric-value",s.AD],["%previous-node-value",s.A.R[s.L-1]?s.A.R[s.L-1].AD:null],["%next-node-value",s.A.R[s.L+1]?s.A.R[s.L+1].AD:null],["%V",s.AD],["%node-index",s.L],["%node-x",s.iX],["%node-y",s.iY],["%chart-width",s.H.I],["%chart-height",s.H.F],["%i",s.L],["%n",s.L],["%node-count",s.A.R.length],["%N",s.A.R.length]);var ABJ=oPPI["%plot-sum"],A35=ABJ+"",ABP=oPPI["%plot-average"],A34=ABP+"",A8A=ZC._f_(oPS.F7["%pstack-"+s.L+"-"+s.A.DY+"-sum"]||"0"),A4P=A8A+"",AB6=ZC._f_(A8A/oPS.F7["%pstack-"+s.L+"-"+s.A.DY+"-stack-length"]),A53=String(AB6),A92=String(oPS.F7["%pstack-"+s.L+"-"+s.A.DY+"-stack-length"]),A6Q=0;null!==ZC._n_(oPS.F7)&&null!==ZC._n_(oPS.F7[s.L])&&(A6Q=ZC._f_(oPS.F7[s.L]["%total-"+s.A.DY]||"0"));var A3N=A6Q+"";A35=ZC.AP.GF(A35,BD),A34=ZC.AP.GF(A34,BD),A3N=ZC.AP.GF(A3N,BD),A4P=ZC.AP.GF(A4P,BD),A53=ZC.AP.GF(A53,BD),CV.push(["%node-error-plus",s.D["node-error-plus"]],["%node-error-minus",s.D["node-error-minus"]],["%stack-total",A4P],["%stack-average",A53],["%stack-length",A92],["%total",A3N],["%plot-min-index",oPPI["%plot-min-index"]],["%pmi",oPPI["%plot-min-index"]],["%plot-max-index",oPPI["%plot-max-index"]],["%pxi",oPPI["%plot-max-index"]],["%plot-min-value",oPPI["%plot-min-value"]],["%pmv",oPPI["%plot-min-value"]],["%plot-max-value",oPPI["%plot-max-value"]],["%pxv",oPPI["%plot-max-value"]],["%plot-sum",A35],["%psum",A35],["%plot-average",A34],["%pavg",A34],["%plot-values",oPPI["%plot-values"]],["%pv",oPPI["%plot-values"]]);var A9Q=100*s.AD/oPPI["%plot-sum"],YN=A9Q+"";null!==ZC._n_(BD.decimals)&&(YN=ZC.AP.GF(YN,BD)),CV.push(["%plot-percent",YN],["%pper",YN]);var bNpv=!1;for(i=0,A7=CV.length;i<A7;i++)if("%npv"===CV[i][0]){bNpv=!0;break}if(!bNpv&&null!==ZC._n_(s.A.A.F7)&&null!==ZC._n_(s.A.A.F7[s.L])){var JK=100*s.AD/s.A.A.F7[s.L]["%total-"+s.A.DY],HL=JK+"";null!==ZC._n_(BD.decimals)&&(HL=ZC.AP.GF(HL,BD)),CV.push(["%node-percent-value",HL],["%npv",HL])}for(i=0;i<TS.length;i++)CV.push(["%plot-text-"+i,TS[i]],["%t"+i,TS[i]]);CV.push(["%plot-text",VN],["%t",VN],["%plot-description",s.A.YB],["%plot-index",s.A.L],["%p",s.A.L],["%plot-count",oPS.A6.length],["%P",oPS.A6.length],["%id",s.H.K],["%graphid",s.C.K.replace(s.H.K+"-graph-","")]),-1!==AR.indexOf("%negation")&&(OK&&"currency"===BD.negation?(CV.push(["%negation","-"]),OK=!1):CV.push(["%negation",""])),CV.push(["%node-x",s.iX],["%node-y",s.iY],["%node-width",s.I],["%node-height",s.F],["%node-size",s.D["marker.size"]||1]),zingchart.DEV.SORTTOKENS&&CV.sort(ZC.A1F),oRE=new RegExp("\\(([^(]+?)\\)\\(([0-9]*)\\)(\\(*)([0-9]*)(\\)*)");for(var W3,AW,J;D4=oRE.exec(AR);){W3="";var CP=s.A.L,D8=s.L;""!==(G=D4[2])&&(CP=ZC._i_(G)),""!==(G=D4[4])&&(D8=ZC._i_(G)),null!==(J=oPS.A6[CP])&&null!==(AW=J.FP(D8,3))&&(W3=AW.KE(D4[1],ER)),AR=AR.replace(D4[0],W3)}if(-1!==AR.indexOf("%prop-")){oRE=new RegExp("%prop-([a-zA-Z0-9-]+)");for(var oMap=s.getPMap();D4=oRE.exec(AR);)null!==ZC._n_(oMap[D4[1]])&&null!==ZC._n_(s[oMap[D4[1]]])&&(AR=AR.replace(D4[0],s[oMap[D4[1]]]))}var BY;if(-1!==AR.indexOf("%linecolor"))for(oRE=new RegExp("%linecolor([0-9]*)");D4=oRE.exec(AR);)""===D4[1]?(BY=s.N||s).B7||(BY=s.A):BY=oPS.A6[D4[1]],AR=AR.replace(D4[0],BY?BY.B7||"#000":"#000");if(-1!==AR.indexOf("%backgroundcolor"))for(oRE=new RegExp("%backgroundcolor([0-9]*)");D4=oRE.exec(AR);)""===D4[1]?(BY=s.N||s).B7||(BY=s.A):BY=oPS.A6[D4[1]],AR="markerbg"===s.A.OZ?AR.replace(D4[0],BY&&BY.A2?BY.A2.A0||"#000":"#000"):AR.replace(D4[0],BY?BY.A0||"#000":"#000");if(-1!==AR.indexOf("%color"))for(oRE=new RegExp("%color([0-9]*)");D4=oRE.exec(AR);)""===D4[1]?(BY=s.N||s).B7&&"line"!==s.A.OZ||(BY=s.A):BY=oPS.A6[D4[1]],AR="line"===s.A.OZ?AR.replace(D4[0],BY?BY.B7||"#000":"#000"):"markerbg"===s.A.OZ?AR.replace(D4[0],BY&&BY.A2?BY.A2.A0||"#000":"#000"):AR.replace(D4[0],BY?BY.A0||"#000":"#000");for(AR=ZC.AP.YV(AR,this),i=0,A7=CV.length;i<A7;i++)oRE=new RegExp(CV[i][0],"g"),AR="undefined"==typeof CV[i][1]?AR.replace(oRE,""):LM?AR.replace(oRE,encodeURIComponent(CV[i][1])):AR.replace(oRE,CV[i][1]);return AR=AR.replace(new RegExp("%data-([a-zA-Z0-9]+)","g"),""),OK&&"currency"===BD.negation&&(AR="-"+AR),AR},paint:function(){},paint_:function(){},ABC:function(){return{color:this.N.A0}},XP:function(){return{"border-color":this.N.A0,"background-color":this.N.AE,color:this.N.C1}},A7U:function(){return this.XP()},GU:function(e,t){var i,n,a,r=this;if(t||(t=1),r.A.NZ&&r.A.NZ.length>0&&r.A.NZ.length>t-1&&r.GU(e,t+1),r.AM||"pie"===r.A.AF||"pie3d"===r.A.AF){var l,o=1===t?r.A.U:r.A.NZ[t-2];if(o){if(r.A.A71)(l=r.A.A71).K=r.K+"-value-box-"+t,l.Z=l.C6=r.H.usc()?r.H.mc("top"):r.C.AJ["3d"]||r.H.K5?ZC.AK(r.C.K+"-plots-vb-c"):ZC.AK(r.C.K+"-plot-"+r.A.L+"-vb-c"),l.IK=r.H.usc()?ZC.AK(r.C.A.K+"-top"):ZC.AK(r.C.A.K+"-text"),l.D.plotidx=r.A.L,l.D.nodeidx=r.L,a=ZC.AP.OQ(l.o,r.A.o),l.KE=function(e){return r.KE(e,a)},l.parse();else{l=new ZC.DS(r.A),o.o.rules||r.A.U.HT||(n="all",null!==ZC._n_(i=o.o.type)&&(n=i),"pie"===r.C.AF||"nestedpie"===r.C.AF||"pie3d"===r.C.AF||"all"!==n||r.A.NZ&&0!==r.A.NZ.length||(r.A.A71=l)),l.append(o.o),r.appendToValueBox&&!e&&(l.parse(),l.append(r.appendToValueBox(l))),l.GJ=r.C.K+"-value-box "+r.C.K+"-plot-"+r.A.L+"-value-box zc-value-box",l.K=r.K+"-value-box-"+t,l.Z=l.C6=r.H.usc()?r.H.mc("top"):r.C.AJ["3d"]||r.H.K5?ZC.AK(r.C.K+"-plots-vb-c"):ZC.AK(r.C.K+"-plot-"+r.A.L+"-vb-c"),l.IK=r.H.usc()?ZC.AK(r.C.A.K+"-top"):ZC.AK(r.C.A.K+"-text"),a=ZC.AP.OQ(l.o,r.A.o),l.KE=function(e){return r.KE(e,a)};var s=r.ABC(l);if(null!==ZC._n_(i=s.color)&&(l.C1=i),null!==ZC._n_(i=s["background-color"])&&(l.A0=l.AE=i),l.D.plotidx=r.A.L,l.D.nodeidx=r.L,r.A.U.HT&&(r.A.U.GZ(r.A.U,l,null,r.LQ(null,!1)),l.parse()),l.parse(),l.JE=function(e){return r.JE(e)},l.DE()&&l.parse(),!r.A.YI){var c=new ZC.DS(r.A);c.copy(l),r.A.YI=c}if(n="all",null!==ZC._n_(i=o.o.type)&&(n=i),l.AM){l.AM=!1;var h=r.A.o["value-box"].text||"";if("values("===n.substring(0,7)){var C=n.substring(7,n.length).replace(")","").split(",");-1!==ZC.AV(C,r.AD)&&(l.AM=!0)}else{var u=n.split(","),d={min:"%plot-min-value",max:"%plot-max-value",first:"%plot-min-index",last:"%plot-max-index"};for(var p in d)-1!==ZC.AV(u,p)&&(("first"!==p&&"last"!==p||r.L!==r.A.JR[d[p]])&&("min"!==p&&"max"!==p||r.AD!==r.A.JR[d[p]])||("object"==typeof h&&null!==ZC._n_(h[p])&&(l.o.text=h[p],l.parse()),l.AM=!0));-1!==ZC.AV(u,"all")&&(l.AM=!0)}}}if(r.C.D["plot"+r.A.L+".visible"]||(l.D["css-display"]="none"),e)return l;if(l.AM&&null!==ZC._n_(l.AR)&&""!==l.AR){var A=r.ACC(l);l.D.positioninfo=A,l.iX=A[0],l.iY=A[1];var g={};if(-1!==l.iX&&-1!==l.iY){var f=!1;if(null!==ZC._n_(l.o.overlap)&&!ZC._b_(l.o.overlap)){g={x:l.iX,y:l.iY,width:l.I,height:l.F};for(var Z=0,_=r.A.A.YH.length;Z<_;Z++)if(ZC.AO.XI(g,r.A.A.YH[Z])){f=!0;break}}f||(r.C.D["plot"+r.A.L+".visible"]||(l.D["css-display"]="none"),l.D.lbltype="vb"+r.C.L,l.paint(),l.EL(),r.A.A.YH.push(g),!l.K5&&ZC.AK(r.H.K+"-map")&&r.A.A.HN.push(ZC.AP.O1(r.C.K,l)))}}return l}}},setupValueBoxWH:function(e){if(null!==ZC._n_(e.o.width)){var t=ZC.IH(e.o.width);t<=1&&(t=this.I*t),e.I=t}if(null!==ZC._n_(e.o.height)){var i=ZC.IH(e.o.height);i<=1&&(i=this.I*i),e.F=i}return e},ACC:function(e){var t,i=this,n=i.C.BN(i.A.BT("v")[0]),a=i.AD>=n.L7&&!n.AU||i.AD<n.L7&&n.AU?-1:1,r="auto";if(null!==ZC._n_(t=e.o.placement)&&(r=t),"auto"===r){var l=null!==ZC._n_(i.A.R[i.L-1])?i.A.R[i.L-1].AD:i.AD,o=null!==ZC._n_(i.A.R[i.L+1])?i.A.R[i.L+1].AD:i.AD;l>=i.AD&&i.AD<=o?r="bottom":l<=i.AD&&i.AD>=o?r="top":l>=i.AD&&i.AD>=o?r=l/i.AD>i.AD/o?"bottom":"top":l<=i.AD&&i.AD<=o&&(r=i.AD/l>o/i.AD?"top":"bottom")}var s=e.I,c=e.F,h=i.iX-s/2,C=i.iY-c/2;switch(r){case"top":C-=a*(c/2+4);break;case"bottom":C+=a*(c/2+4);break;case"left":h-=s/2+4;break;case"right":h+=s/2+4}return i.C.AJ["3d"]||(h=ZC.BQ(i.C.P.iX-s/2,h),h=ZC.CY(i.C.P.iX+i.C.P.I-s/2,h),C=ZC.BQ(i.C.P.iY-c,C),C=ZC.CY(i.C.P.iY+i.C.P.F,C)),null!==ZC._n_(e.o.x)&&(h=e.iX),null!==ZC._n_(e.o.y)&&(C=e.iY),[ZC._i_(h),ZC._i_(C)]},P2:function(e,t){var i,n,a,r,l,o=this,s=["bubble","hbubble","scatter","hscatter"];if("undefined"==typeof o.A.bBS&&(o.A.bBS=-1===ZC.AV(s,o.A.AF)),null!==ZC._n_(o.A.o["markers-on-top"])&&(o.A.bBS=ZC._b_(o.A.o["markers-on-top"])),!o.C.O7||!o.A.bBS){null===ZC._n_(e)&&(e=!1),null===ZC._n_(t)&&(t=!1);var c=o.C.P.D.tolerance||2;if(ZC.DT(o.iX,o.C.P.iX-c,o.C.P.iX+o.C.P.I+c)&&ZC.DT(o.iY,o.C.P.iY-c,o.C.P.iY+o.C.P.F+c)){var h=o.C.K+"-node-area "+o.C.K+"-plotset-plot-"+o.A.L+"-node-area zc-node-area";if(-1===ZC.AV(o.H.KM,"skip_segment_tracking")&&o.A.FW){if(o.A.XU&&!zingchart.DEV.SKIPTRACKERS){var C=o.getNodeData("points");-1!==ZC.AV(o.H.KM,"use_fast_mode")&&-1!==ZC.AV(["line","area"],o.A.AF)&&void 0===C&&o.paint(!0),""!==(a="undefined"==typeof o.D.polypoints?ZC.AO.PM(ZC.AO.YW(C,ZC.BQ(6,o.A.B0/2)),4):ZC.AO.PM(C,4))&&o.A.A.HN.push(ZC.Q.GC("poly",o.A.E8,o.N.IR)+'class="'+h+'" id="'+o.K+'" coords="'+a+'" />')}if(("area"===o.A.AF||"area3d"===o.A.AF||"radar"===o.A.AF&&("area"===o.A.CW||"range"===o.A.CW))&&o.A.X2){var u=o.getNodeData("pointsarea");""!==(a=ZC.AO.PM(u,4))&&o.A.A.HN.push(ZC.Q.GC("poly",o.A.E8,o.A.IR)+'class="'+h+'" id="'+o.K+'--area" coords="'+a+'" />')}}if(o.A.U||!o.A.IG||!o.A.A2.o||"none"!==o.A.A2.o.type&&(null===ZC._n_(o.A.A2.o.visible)||ZC._b_(o.A.A2.o.visible))){if(t||o.A.R2){if(o.A.HA)r=o.A.HA,"svg"!==o.H.AC&&(e?(l=new ZC.CF(o.C,o.iX-ZC.AN.E3,o.iY-ZC.AN.E2,o.A.D["z-start"]||0),r.iX=ZC._x_(l.EB[0]),r.iY=ZC._x_(l.EB[1]),o.D["3dxy"]=[r.iX,r.iY]):(r.iX=ZC._x_(o.iX),r.iY=ZC._x_(o.iY)),r.D.plotidx=o.A.L,r.D.nodeidx=o.L,r.K=o.K+"-marker",r.parse(!0));else{if(o.IG?o.A._oMarker?r=o.A._oMarker:o.A._oMarker=r=new ZC.DW(o.A):r=new ZC.DW(o.A),r.K=o.K+"-marker",r.D["p-width"]=o.A.B1.A9,r.D["p-height"]=o.A.CM.A9,o.A.bBS)r.Z=o.A.CO("fl",0),r.C6=o.A.CO("fl",0);else if(r.Z=o.A.CO("bl",1),r.C6=o.A.CO("bl",0),Object&&Object.keys&&Object.keys(o.C.CH).length>0){var d=o.C.CH["p"+o.A.L];"none"!==o.A.IY&&d&&d["n"+o.L]&&(r.Z=o.A.CO("bl",2))}e?(l=new ZC.CF(o.C,o.iX-ZC.AN.E3,o.iY-ZC.AN.E2,o.A.D["z-start"]||0),r.iX=ZC._x_(l.EB[0]),r.iY=ZC._x_(l.EB[1]),o.D["3dxy"]=[r.iX,r.iY]):(r.iX=ZC._x_(o.iX),r.iY=ZC._x_(o.iY)),r.B7=o.A.BP[3],r.BV=o.A.BP[3],r.A0=o.A.BP[2],"bubble"===o.A.AF||"hbubble"===o.A.AF?r.AE=o.A.BP[1]:r.AE=o.A.BP[2],r.append(o.A.A2.o),null!==ZC._n_(o.D["marker.size"])&&(r.AI=o.D["marker.size"]),r.D.plotidx=o.A.L,r.D.nodeidx=o.L,"none"!==o.A.IY&&(o.C.IT[o.A.L]||o.C.KD)&&(o.C.CH["p"+o.A.L]&&o.C.CH["p"+o.A.L]["n"+o.L]?r.OG=o.A.PH?o.A.PH.o:{}:"none"!==o.A.O2&&("plot"===o.A.O2&&o.C.IT[o.A.L]||"graph"===o.A.O2&&o.C.KD)&&(r.OG=o.A.PE?o.A.PE.o:{})),null!==ZC._n_(i=o.A.o.marker)&&null!==ZC._n_(i.styles)&&null!==ZC._n_(n=i.styles[o.L])&&("string"==typeof n?r.append({"background-color":ZC.AP.QT(n,20),"line-color":ZC.AP.JH(n,20),"border-color":ZC.AP.JH(n,20)}):r.append(n)),r.parse(),r.JE=function(e){return o.JE(e)},r.DE()&&r.parse()}if(o.D["marker.size"]=ZC.BQ(2.02,o.D["marker.size"]||r.AI),r.DI=h,!(e||ZC.DT(r.iX,o.C.P.iX-2,o.C.P.iX+o.C.P.I+2)&&ZC.DT(r.iY,o.C.P.iY-2,o.C.P.iY+o.C.P.F+2)))return;if(r.HT&&(o.A.YJ=!1,r.GZ(r,r,null,o.LQ(null,!1)),r.parse()),o.N3=r,r.AM&&"none"!==r.AF){var p=function(){if(o.A.bBS||o.MW(ZC.Q.E9(o.A.CO("bl",0),o.H.AC)),o.D["marker.type"]=r.DQ,o.A.FW&&-1===ZC.AV(o.H.KM,"skip_marker_tracking")&&!zingchart.DEV.SKIPTRACKERS){var e=o.D["3dxy"]?o.D["3dxy"][0]:o.iX,t=o.D["3dxy"]?o.D["3dxy"][1]:o.iY,i=parseInt(e+r.BJ+ZC.MAPTX,10),n=parseInt(t+r.BH+ZC.MAPTX,10),a=parseInt(ZC.BQ(ZC.mobile?6:3,o.D["marker.size"]+1)*(ZC.mobile?1.25:1.05),10),l=!0;"undefined"!=typeof o.A.aLastMarkerXY?Math.sqrt((i-o.A.aLastMarkerXY[0])*(i-o.A.aLastMarkerXY[0])+(n-o.A.aLastMarkerXY[1])*(n-o.A.aLastMarkerXY[1]))<zingchart.DEV.MINTRACKERDIFF&&(l=!1):o.A.aLastMarkerXY=[i,n],l&&(o.A.aLastMarkerXY=[i,n],-1!==ZC.AV(["pie","square","rect","rectangle"],r.DQ)?o.A.A.HN.push(ZC.Q.GC("poly",o.A.E8,o.A.IR)+'class="'+h+'" id="'+o.K+'--marker" coords="'+r.FC()+'" />'):o.A.A.HN.push(ZC.Q.GC("circle",o.A.E8,o.A.IR)+'class="'+h+'" id="'+o.K+'--marker" coords="'+i+","+n+","+a+'" />'))}if(o.A.U&&(o.A.D.vboxid=o.K,o.GU()),!o.A.bBS&&o.C.BA&&o.C.BA.HY&&o.A.QH&&o.C.BA.AM){var s=o.C.P,c=o.C.BA,C=c.AQ,u=o.A.HA||r,d=new ZC.DW(o.A);d.copy(u);var p=(o.iX-s.iX)/s.I,A=(o.iY-s.iY)/s.F,g=Math.min(C.F/s.F,C.I/s.I);d.iX=C.iX+C.AT+p*(C.I-2*C.AT),d.iY=C.iY+C.AT+A*(C.F-2*C.AT),d.K=o.K+"-marker-preview",d.DI=o.A.K+"-preview";var f=u.AI;null!==ZC._n_(o.D["marker.size"])&&(f=o.D["marker.size"]),d.AI=ZC.BQ(2.02,.9*g*f),d.Z=d.C6=c.Z,d.parse(),d.paint()}},A=!1;if((!o.A.bBS||"radar"===o.A.AF&&"dots"===o.A.CW)&&(A=!0),o.A.GA&&A&&!o.C.HF){var g=r,f={},Z=r.C5,_=r.AI,b=r.iX,m=r.iY;g.iX=b,g.iY=m,f.x=b,f.y=m;var v=o.A.L6,D=o.C.P;g.C5=0,f.alpha=Z,3===v?(g.AI=2,f.size=_):8===v?(g.iX=b-D.iX,f.x=b):9===v?(g.iX=b+D.iX,f.x=b):10===v?(g.iY=m-D.iY,f.y=m):11===v&&(g.iY=m+D.iY,f.y=m);var E;for(E in o.A.FT)g[ZC.EA.GK[ZC.EC(E)]]=o.A.FT[E],f[ZC.EC(E)]=o.N[ZC.EA.GK[ZC.EC(E)]];if(null===ZC._n_(o.C.EM)&&(o.C.EM={}),null!==ZC._n_(o.C.EM[o.A.L+"-"+o.L]))for(E in o.C.EM[o.A.L+"-"+o.L])g[ZC.EA.GK[ZC.EC(E)]]=o.C.EM[o.A.L+"-"+o.L][E];o.C.EM[o.A.L+"-"+o.L]={},ZC._cp_(f,o.C.EM[o.A.L+"-"+o.L]);var w=new ZC.EA(g,f,o.A.JD,o.A.L2,ZC.EA.RC[o.A.L5],function(){p()});w.AW=o,w.O6=function(){o.MW(ZC.Q.E9(o.A.CO("bl",0),o.H.AC))},o.LL(w)}else{var B="circle"===r.DQ?"circle":"path";if(o.A.HG){var K=function(t,i){var n=t.cloneNode(!1),a=o.iX,l=o.iY;if(e){var s=new ZC.CF(o.C,a-ZC.AN.E3,l-ZC.AN.E2,o.A.D["z-start"]||0);a=ZC._x_(s.EB[0]),l=ZC._x_(s.EB[1]),o.D["3dxy"]=[a,l]}n.setAttribute("transform","translate("+ZC._i_(a-r.iX)+","+ZC._i_(l-r.iY)+") "+(n.getAttribute("transform")||"")),n.setAttribute("id",i),"bubble"!==o.A.AF&&"hbubble"!==o.A.AF||n.setAttribute("r",o.D["marker.size"]),t.parentNode.appendChild(n)};r.M4&&K(o.A.R9,o.K+"-marker-sh-"+B),K(o.A.HG,o.K+"-marker-"+B),r.D9&&K(o.A.Q5,o.K+"-marker-imgfill")}else{r.paint();var F=r.A0!==r.AE;if(!o.C.IT[o.A.L]&&o.A.YJ&&!F)if("svg"===o.H.AC){if(-1===ZC.AV(["pie","square","rect","rectangle","cross","plus","custom"],r.DQ))if(o.A.HA=r,zingchart.DEV.DOMFRAGMENTS&&document.querySelector){for(var x in o.H.FY)o.A.HG||(o.A.HG=o.H.FY[x].querySelector("#"+o.K+"-marker-"+B)),r.M4&&!o.A.R9&&(o.A.R9=o.H.FY[x].querySelector("#"+o.K+"-marker-sh-"+B)),r.D9&&!o.A.Q5&&(o.A.Q5=o.H.FY[x].querySelector("#"+o.K+"-marker-imgfill")||o.H.FY[x].querySelector("#"+o.K+"-marker-path-imgfill"));o.A.HG||(o.A.HG=ZC.AK(o.K+"-marker-"+B),r.M4&&(o.A.R9=ZC.AK(o.K+"-marker-sh-"+B)),r.D9&&(o.A.Q5=ZC.AK(o.K+"-marker-imgfill")))}else o.A.HG=ZC.AK(o.K+"-marker-"+B),r.M4&&(o.A.R9=ZC.AK(o.K+"-marker-sh-"+B)),r.D9&&(o.A.Q5=ZC.AK(o.K+"-marker-imgfill")||ZC.AK(o.K+"-marker-path-imgfill"))}else"bubble"!==o.A.AF&&"hbubble"!==o.A.AF&&(e||(o.A.HA=r))}"svg"===o.H.AC&&o.A.applyJsRuleSvg(o.A.A2,o.K+"-marker-"+B,o.LQ()),p()}}else o.A.U&&o.GU()}else o.A.U&&o.GU()}}}},LL:function(e,t){var i,n=this,a=n.C.LT,r=a.PA,l=n.A.TM;switch(l){default:t&&a.add(t),a.add(e);break;case 1:case 2:case 3:if(t){var o="all";if(1===l?o="plots-group-"+n.L+"-area":2===l&&(o="nodes-group-"+n.A.L+"-area"),null===ZC._n_(r[o])){var s=new ZC.A24(o);a.A9W(s,t.X3)}r[o].add(t)}if(i="all",1===l?i="plots-group-"+n.L:2===l&&(i="nodes-group-"+n.A.L),null===ZC._n_(r[i])){var c=new ZC.A24(i);a.A9W(c,e.X3)}r[i].add(e)}},TR:function(e){var t=this;t.A.IG&&t.A.bXY&&(t.T1(),e&&("scatter"!==t.A.AF&&"hscatter"!==t.A.AF&&"bubble"!==t.A.AF&&"hbubble"!==t.A.AF||t.paint(!0)));var i=t.A.BP;t.M2({layer:e,type:"shape",id:"marker",marker:!0,initcb:function(){this.DQ=t.D["marker.type"],this.iX=t.iX,this.iY=t.iY,"bubble"===t.A.AF||"hbubble"===t.A.AF?(this.AE=i[3],this.A0=i[2]):(this.B7=i[3],this.BV=i[3],this.A0=i[2],this.AE=i[1]),this.AI=t.D["marker.size"]}})},A1C:function(e){var t=this;t.M2({layer:e,type:"line",id:"line",initcb:function(){this.B7=t.A.BP[3]}})},M2:function(e){if(!ZC.move){var t,i,n,a,r,l,o=this,s=e.layer||"hover",c=e.id||"",h=!1;switch(o.GG=null,null!==ZC._n_(t=e.marker)&&(h=ZC._b_(t)),s){case"hover":null!==ZC._n_(o.C.CH["p"+o.A.L])&&null!==ZC._n_(o.C.CH["p"+o.A.L]["n"+o.L])||(n=h?o.A.G4:o.A.IB,a="hover");break;case"highlight":n=h?o.A.UU:o.A.S2,a="hover"}if(null!==ZC._n_(e.state)&&(n=e.state),n&&o.C.D["plot"+o.A.L+".visible"]&&n.AM){switch(e.type){case"box":(l=new ZC.HS(o.A)).PR=!0;break;case"line":l=new ZC.DW(o.A),r=ZC.Q.E9(o.C.K+"-"+a+"-c",o.H.AC),l.CZ=!1;break;case"shape":l=new ZC.DW(o.A);break;case"area":l=new ZC.DW(o.A),r=ZC.Q.E9(o.C.K+"-"+a+"-c",o.H.AC)}if(h&&(l.D["p-width"]=o.A.B1.A9,l.D["p-height"]=o.A.CM.A9),zingchart.DEV.PLOTSHLAYER&&"hover"===a?l.Z=l.C6=ZC.AK(o.C.K+"-plots-hover-c"):l.Z=l.C6=ZC.AK(o.C.K+"-"+a+"-c"),l.K=o.K+"-"+(""!==c?c+"-":"")+s,l.D.plotidx=o.A.L,l.D.nodeidx=o.L,"hover"!==s&&(l.A1T=!0),e.initcb&&e.initcb.call(l),l.append(n.o),e.parsecb&&e.parsecb.call(l),"hover"===s&&null!==ZC._n_(t=o.A.o)&&null!==ZC._n_(t.styles)&&null!==ZC._n_(i=t.styles[o.L])&&("string"==typeof i?l.append({"background-color":i,"line-color":i,"border-color":i}):l.append(i)),null!==ZC._n_(t=o.A.o[s+"-state"])&&null!==ZC._n_(t.styles)&&null!==ZC._n_(i=t.styles[o.L])&&("string"==typeof i?l.append({"background-color":i,"line-color":i,"border-color":i}):l.append(i)),o.A.HT&&o.GZ(l,s),"hover"===s&&o.A.A2&&o.A.A2.HT&&(o.A.A2.GZ(o.A.A2,l,null,o.LQ(null,!1)),l.parse()),l.parse(),l.JE=function(e){return o.JE(e)},l.DE()&&l.parse(),l.AM){switch(e.setupcb&&e.setupcb.call(l),e.type){case"box":case"shape":l.locate(2),l.paint();break;case"line":ZC.CS.setup(r,l),"plot"===o.A.A3G?ZC.CS.paint(r,l,o.A.V1):ZC.CS.paint(r,l,o.getNodeData("points"));break;case"area":"spline"!==o.A.CW&&(null!==ZC._n_(t=n.o["alpha-area"])&&(l.C5=ZC._f_(t)),ZC.CS.setup(r,l),l.paint())}o.GG=l}}}},MW:function(){},setup:function(){},A3H:function(){},LN:function(){var e=this;ZC.Q.EU([e.K+"-hover-gradient",e.K+"-marker-hover-gradient",e.H.K+"-tooltip-text-gradient",e.H.K+"-tooltip-text-sh-gradient"])},LQ:function(e,t){var i=this;void 0===t&&(t=!0);var n=!1;"none"!==i.A.IY&&i.C.CH&&i.C.CH["p"+i.A.L]&&i.C.CH["p"+i.A.L]["n"+i.L]&&(n=!0);var a={id:i.C.A.K,graphid:i.C.K,graphindex:i.C.L,plotid:i.A.H2,plotindex:i.A.L,nodeindex:i.L,key:null===i.BU?i.L:i.BU,scaleval:i.A.B1?i.A.B1.X[null===i.BU?i.L:i.BU]:null,scaletext:i.A.B1?i.A.B1.FO(i.L,null===i.BU?null:i.A):null,value:i.AD,text:t?i.KE(i.A.JV):i.A.JV,ev:e?ZC.A4.C0(e):null,x:i.iX,y:i.iY,width:i.I,height:i.F,size:i.D["marker.size"]||1,selected:n};for(var r in i.A.KB)i.A.KB[r]instanceof Array?null!==ZC._n_(i.A.KB[r][i.L])&&(a["data-"+r]=i.A.KB[r][i.L]):a["data-"+r]=i.A.KB[r];return a},WX:function(e,t){ZC.AP.BZ("node_"+t,this.H,this.LQ(e))}}),ZC.H8=ZC.HS.C7({$i:function(e){this.b(e);var t=this;t.H=t.A.A,t.BC="",t.X=[],t.BX=[],t.A4F=[],t.DL=!1,t.M=null,t.BR=null,t.IP=null,t.D5=null,t.GI=0,t.IA=null,t.FZ=null,t.H4=0,t.OW=null,t.L=1,t.A5=0,t.A3X=0,t.BW=0,t.AU=!1,t.CQ=!1,t.A9=0,t.iStepMultiplier=1,t.DU=-1,t.R5=ZC.HI["thousands-separator"]||"",t.RR=ZC.HI["decimals-separator"]||".",t.ZP=!1,t.SE=2,t.A2V=!1,t.TI="",t.ZN="standard",t.CI=null,t.AF="",t.EE=ZC.MAX,t.LY=ZC.MAX,t.GM=!1,t.Y5=!1,t.LI=null,t.NN=null,t.PY=[],t.E4=1,t.B4=-1,t.BL=-1,t.SC=-1,t.FU=-1,t.GY=-1,t.CA="lin",t.EH=10,t.FD=null,t.OY=1,t.PR=!0,t.A0B=!1,t.aAutoFit=[!1,!1],t.LP=null,t.WH=null,t.T3=!1,t.HW=-1,t.Y7=!1,t.B9="default",t.PU=!1,t.V7=!1,t.QY=1,t.sMaster="",t.bNormalize=!0},parse:function(){function e(e){var t=[c+".SCALE."+e,c+"."+i.BC+"."+e,c+"."+h+"."+e,c+"."+h+"["+i.B9+"]."+e,c+"."+C+"."+e];return i.A.AJ["3d"]&&(t=t.concat([c+".SCALE[3d]."+e,c+"."+i.BC+"[3d]."+e,c+"."+h+"[3d]."+e,c+"."+C+"[3d]."+e])),t}this.b();var t,i=this;if(null!==ZC._n_(t=i.o.step))if(ZC.P4(t))i.E4=ZC._f_(t);else{var n=t.replace(/[0-9]/gi,""),a=parseInt(t.replace(/[^0-9]/gi,""),10);switch(a=a||1,n){case"second":i.E4=1e3*a;break;case"minute":i.E4=1e3*a*60;break;case"hour":i.E4=1e3*a*60*60;break;case"day":i.E4=1e3*a*60*60*24;break;case"week":i.E4=1e3*a*60*60*24*7;break;case"month":i.E4=2629743e3*a;break;case"year":i.E4=31556926e3*a}}if(null!==ZC._n_(i.o.multiplier)&&null===ZC._n_(i.o["short"])&&(i.o["short"]=i.o.multiplier),i.assign_a([["labels","BX"],["tooltip-text","A4F"],["format","CI"],["offset-start","A5","i"],["offset-start","A3X","i"],["offset-end","BW","i"],["minor-ticks","GI","i"],["step-multiplier","iStepMultiplier","i"],["index","L","i"],["mirrored","AU","b"],["zooming","GM","b"],["zoom-snap","Y5","b"],["fixed-step","PU","b"],["zoom-to","LI"],["force-view","Y7","b"],["zoom-to-values","NN"],["items-overlap","A0B","b"],["used","T3","b"],["max-labels","EE","i"],["max-items","EE","i"],["ref-value","H4","f"],["decimals","DU","ia"],["decimals-separator","RR"],["thousands-separator","R5"],["short","A2V","b"],["short-unit","TI"],["negation","ZN"],["exponent","ZP","b"],["exponent-decimals","SE","ia"],["progression","CA"],["log-base","EH","fa"],["scale-factor","OY","fa"],["show-labels","LP"],["max-decimals","HW","i"],["placement","B9"],["factor","QY","f"],["master","sMaster"],["blended","V7","b"],["ranged","DL","b"],["normalize","bNormalize","b"]]),"log"===i.CA&&null===ZC._n_(i.o["minor-ticks"])&&(i.GI=Math.max(0,i.EH-2)),null!==ZC._n_(t=i.o["auto-fit"])&&(t.length?(i.aAutoFit[0]=ZC._b_(t[0]),i.aAutoFit[1]=ZC._b_(t[t.length-1])):i.aAutoFit[0]=i.aAutoFit[1]=ZC._b_(t)),"string"==typeof i.BX){var r=i.BX.split(":"),l=1;3===r.length&&(l=ZC._f_(r[2])),i.BX=[];for(var o=ZC._f_(r[0]);o<ZC._f_(r[1]);o+=l)i.BX.push(""+o);i.BX.push(""+r[1])}null!==ZC._n_(i.o["fixed-items"])&&(i.EE=ZC.MAX),i.EE=ZC.BQ(i.EE,2),null!==ZC._n_(t=i.o.offset)&&(i.A5=i.BW=ZC._i_(t),0!==ZC._i_(t)||"mixed"!==i.A.AF&&"mixed3d"!==i.A.AF||(i.DL=!1)),null!==ZC._n_(t=i.o["max-ticks"])?i.LY=ZC._i_(t):i.LY=i.EE,i.LY=ZC.BQ(2,i.LY),null!==ZC._n_(t=i.o.transform)&&(i.FD=new ZC.D0,i.FD.append(t));var s=i.A.A.B8,c="("+i.A.AF+")",h=i.BC.replace(/\-[0-9]/,""),C=i.BC.replace(/\-[0-9]/,"-n");if(null===ZC._n_(i.o.placement)&&i.L>1&&(i.B9="opposite"),null!==ZC._n_(t=i.o.markers))for(var u=0,d=t.length;u<d;u++){var p=new ZC.A8M(i);p.L=u,p.K=i.K+"-marker-"+u,s.load(p.o,e("marker")),p.append(t[u]),p.parse(),i.PY.push(p)}i.OW=new ZC.D0(i),s.load(i.OW.o,e("ref-line")),i.OW.append(i.o["ref-line"]),"k"===i.AF&&(i.OW.AM=!1),i.OW.parse(),i.M=new ZC.DS(i),s.load(i.M.o,e("label")),i.M.append(i.o.label),i.M.K=i.K+"-label",i.M.parse(),i.BR=new ZC.DS(i),s.load(i.BR.o,e("item")),i.BR.append(i.o.item),i.BR.K=i.K+"-item",i.BR.parse(),i.IP=new ZC.D0(i),s.load(i.IP.o,e("tick")),i.IP.append(i.o.tick),i.IP.parse(),i.D5=new ZC.D0(i),s.load(i.D5.o,e("guide")),i.D5.append(i.o.guide),i.D5.parse(),null===ZC._n_(i.D5.o.items)&&"-1"!==i.D5.A0&&"-1"!==i.D5.AE&&i.D5.A0!==i.D5.AE&&(i.D5.o.items=[{alpha:i.D5.C5,"background-color":i.D5.A0},{alpha:i.D5.C5,"background-color":i.D5.AE}]),i.IA=new ZC.D0(i),s.load(i.IA.o,e("minor-tick")),i.IA.append(i.o["minor-tick"]),i.IA.parse(),i.FZ=new ZC.D0(i),s.load(i.FZ.o,e("minor-guide")),i.FZ.append(i.o["minor-guide"]),i.FZ.parse(),i.A44()},A44:function(){var e,t=this,i={x:"iX",y:"iY",width:"I",height:"F"};for(var n in i){var a=t.A.P[i[n]];null!==ZC._n_(t.o[n])&&(a=ZC.IH(t.o[n]))>=0&&a<=1&&(a="x"===n||"y"===n?t.A.P["x"===n?"iX":"iY"]+ZC._i_(a*t.A.P["x"===n?"I":"F"]):ZC._i_(a*t.A.P[i[n]])),t[i[n]]=a}null!==ZC._n_(e=t.o.offset)&&(t.A5=t.BW=ZC._f_(ZC._p_(e))),null!==ZC._n_(e=t.o["offset-start"])&&(t.A5=ZC._f_(ZC._p_(e))),null!==ZC._n_(e=t.o["offset-end"])&&(t.BW=ZC._f_(ZC._p_(e)));var r="k"===t.AF&&!t.CQ||"v"===t.AF&&t.CQ?t.I:t.F;t.A5<1&&(t.A5*=r),t.BW<1&&(t.BW*=r)},YT:function(e){var t=this;null!==ZC._n_(t.o.rules)&&(t.WH||(t.WH=new ZC.H8(t.A)),t.WH.append(t.o),t.WH.parse(),t.WH.JE=e,t.WH.DE()&&(t.WH.parse(),t.DU=t.WH.DU,t.CI=t.WH.CI))},IW:function(){},A7I:function(){},AC4:function(){},A9L:function(){},clear:function(){},build:function(){},ML:function(){var e,t=this,i={negation:t.ZN,"thousands-separator":t.R5,"decimals-separator":t.RR,decimals:t.DU,"max-decimals":t.HW,"short":t.A2V,"short-unit":t.TI,exponent:t.ZP,"exponent-decimals":t.SE};if(t.FD)switch(t.FD.o.type){case"date":i["transform-date"]=!0,null!==ZC._n_(e=t.FD.o.text)&&(t.FD.o.all=e);var n=t.X[t.A1]-t.X[t.V],a="",r="",l={},o=["msecond","second","minute","hour","day","month","year"];for(var s in o)l[o[s]]=ZC.HI["date-formats"][o[s]];r=0<=n&&n<=1e3?"msecond":1e3<n&&n<=36e5?"second":36e5<n&&n<=864e5?"minute":864e5<n&&n<=26784e5?"hour":26784e5<n&&n<=316224e5?"day":316224e5<n&&n<=632448e6?"month":"year",a=null!==ZC._n_(t.FD.o[r])?t.FD.o[r]:null!==ZC._n_(t.FD.o.all)?t.FD.o.all:l[r],t.D.dateformat=a,i["transform-date-format"]=t.D.dateformat}return i},A06:function(){for(var e=this,t=e.A.AY.A6,i=-1,n=0,a=t.length;n<a;n++){var r=t[n].BT(e.AF);if(-1!==ZC.AV(r,e.BC)){switch(t[n].AF){case"pie":case"pie3d":case"nestedpie":case"vbar":case"vbar3d":case"hbar":case"hbar3d":case"vbullet":case"hbullet":case"area":case"area3d":case"gauge":case"vfunnel":case"hfunnel":case"venn":i=t[n].A0;break;case"scatter":case"bubble":i=-1!==t[n].A2.A0?t[n].A2.A0:t[n].A0;break;default:i=t[n].B7}break}}return i},paint:function(){var e=this;e.build(),e.A.AJ["3d"]||e.b()},MU:function(e,t,i,n){var a=this;if(null===ZC._n_(n)&&(n=5),a.A.AJ["3d"]){var r=new ZC.CF(a.A,e.iX+e.I/2-ZC.AN.E3,e.iY+e.F/2-ZC.AN.E2,0+e.A9O);e.iX=r.EB[0]-e.I/2+("v"===i?"default"===a.B9?-n:n:0),e.iY=r.EB[1]-e.F/2+("h"===i?"default"===a.B9?n:-n:0);var l=ZC.DH.A2X(a.A,e);null===ZC._n_(t)&&(t=e.AA,e.AA%90==0&&(t+=e.V2?0:l)),e.AA=t}return t},WT:function(e,t,i){var n=this,a=(i.items,i.lcoords),r=i.lstep,l=i.tdim,o=i.mdim,s=i.dim,c=i.html,h=[e.iX+e.BJ,e.iY+e.BH,e.I,e.F],C=ZC._a_(e.AA%180),u=!1;C%360!=0&&(u=!0),u&&(h=[e.iX+e.BJ+e.I/2-e.F/2,e.iY+e.BH+e.F/2-e.I/2,e.F,e.I]);var d=!0;if(e.AM){if(!n.A0B)if("log"===n.CA||t!==n.V&&t!==n.A1){t%r==0&&(d=!0);for(var p=0,A=a.length;p<A;p++)if(ZC.AO.XI({x:h[0],y:h[1],width:h[2],height:h[3]},{x:a[p][0],y:a[p][1],width:a[p][2],height:a[p][3]})){d=!1;break}}else d=!0;d&&(a.push(h),e.paint(),0,o=ZC.BQ(o,1.5*e.DK*(e.AR||"").split("<br>").length),"h"===s?(l+=e.F,o=ZC.BQ(o,ZC._a_(ZC.EO(C))*ZC.BQ(e.I,e.F))):"w"===s&&(l+=e.I,o=ZC.BQ(o,ZC._a_(ZC.EF(C))*ZC.BQ(e.I,e.F))),e.EL(),null===ZC._n_(n.o.tooltip)&&e.K5||(null!==ZC._n_(n.o.tooltip)&&(n.o.tooltip.text=n.o.tooltip.text||"%scale-value"),c.push(ZC.AP.O1(n.A.K,e))))}return{tdim:l,mdim:o,overlaps:!d}},VA:function(e,t){var i=this;if("v"===i.AF&&(i.H4!==i.B4&&i.H4!==i.BL||(null===ZC._n_(i.o["ref-line"])||null!==ZC._n_(i.o["ref-line"])&&null===ZC._n_(i.o["ref-line"].visible))&&(i.OW.AM=!1)),i.OW.K=i.K+"-ref-line",i.X.length>0&&i.OW.AM&&!i.A.AJ["3d"]&&i.OW.B0>0){"inherit"===i.OW.o["line-color"]&&-1!==t&&(i.OW.B7=t);var n=i.H4;if("k"===i.AF&&!i.CQ||"v"===i.AF&&i.CQ){var a=i.B2(n);a>=i.iX&&a<=i.iX+i.I&&ZC.CS.paint(e,i.OW,[[a,i.iY],[a,i.iY+i.F]])}else{var r=i.B2(n);r>=i.iY&&r<=i.iY+i.F&&ZC.CS.paint(e,i.OW,[[i.iX,r],[i.iX+i.I,r]])}}},paint_:function(){},XJ:function(){for(var e=this,t=0,i=e.PY.length;t<i;t++)e.X.length>0&&e.PY[t].paint()},gc:function(){ZC.AP.gc(this,["X","BX","Z","C6","D5","BR","M","FZ","IA","OW","IP","JE","o","I0","J5","A","H"])}}),ZC.A3E=ZC.H8.C7({$i:function(e){this.b(e);var t=this;t.ED=!1,t.AF="k",t.DD=-1,t.DZ=-1,t.V=-1,t.A1=-1,t.UT=1,t.DU=null,t.OH=0,t.A4U=!1,t.NV=!1,t.TX={},t.IM=[]},zoomTo:function(e,t){var i=this;if(i.GM){null!==ZC._n_(e)?i.V=e:i.V=i.DD,null!==ZC._n_(t)?i.A1=t:i.A1=i.DZ;var n=i.IM;if(n.length>0?(i.B4=ZC.AV(n,i.X[i.V]),i.BL=ZC.AV(n,i.X[i.A1])):(i.B4=i.X[i.V],i.BL=i.X[i.A1]),i.H.H9.C||(i.H.H9.C=i.A),i.A.H9&&null!==ZC._n_(i.A.H9.o.shared)&&ZC._b_(i.A.H9.o.shared)&&i.A.K===i.H.H9.C.K)for(var a=0,r=i.H.AH.length;a<r;a++){var l=i.H.AH[a];if(l.K!==i.A.K&&null!==ZC._n_(l.H9.o.shared)&&ZC._b_(l.H9.o.shared)){var o=l.BN(i.BC);o&&o.GM&&(e=Math.max(o.DD,Math.min(o.DZ,i.V)),t=Math.max(o.DD,Math.min(o.DZ,i.A1)),o.zoomTo(e,t),ZC.AK(l.K)&&(l.clear(!0),l.D["shared-zoom"]=!0,l.paint(),l.BA&&l.BA.update(e,t,null,null,!0)))}}i.IW()}},zoomToV:function(e,t){var i=this;null!==ZC._n_(e)?i.B4=e:i.B4=i.FU,null!==ZC._n_(t)?i.BL=t:i.BL=i.GY,i.RN(i.B4,i.BL,null===ZC._n_(e)&&null===ZC._n_(t))},FO:function(L,J,ER,bKeep,AD){var s=this,CU="";J?(CU=J.R[L].BU,s.FD&&"date"===s.FD.o.type||"number"==typeof CU||(null!==ZC._n_(s.BX[CU])?CU=s.BX[CU]:null!==ZC._n_(s.X[CU])&&(CU=s.X[CU]))):CU="log"===s.CA&&bKeep?L+1:null!==ZC._n_(s.BX[L])?s.BX[L]:s.X[L],"number"==typeof CU&&null!==ZC._n_(s.IM[CU])&&(CU=s.IM[CU]),null!==ZC._n_(AD)&&(CU=AD);var OK=ZC.P4(CU)&&ZC._f_(CU)<0,BD=s.ML();if(ZC._cp_(ER,BD),OK&&"currency"===BD.negation&&(CU=ZC._a_(ZC._f_(CU))),BD.utc=s.A.U9,BD.timezone=s.A.N6,CU=ZC.AP.GF(CU,BD,s,!0),s.CI)if("()"===s.CI.substring(s.CI.length-2)||"javascript:"===s.CI.substring(0,11))try{var EI=s.CI.replace("javascript:","").replace("()","");eval(EI)&&(CU=eval(EI).call(s,CU))}catch(e){}else CU=OK&&"currency"===BD.negation?"-"+s.CI.replace(/%v|%scale-value/g,CU):s.CI.replace(/%v|%scale-value/g,CU);return CU},KE:function(e,t,i,n,a){var r=this,l=r.FO(t,i,n,a),o=[];o.push(["%scale-label",l],["%scale-index",t],["%scale-position",t]),r.FD&&"date"===r.FD.o.type?o.push(["%scale-value",l],["%v",l]):"log"===r.CA&&a?o.push(["%scale-value",Math.pow(r.EH,t)],["%v",Math.pow(r.EH,t)]):o.push(["%scale-value",ZC._c_(r.X[t],"")],["%v",ZC._c_(r.X[t],"")]),o.push(["%l",l],["%t",l],["%i",t],["%c",t]),o.sort(ZC.A1F);for(var s=0,c=o.length;s<c;s++){var h=new RegExp(o[s][0],"g");e=e.replace(h,o[s][1])}return e},A7I:function(){var e=this,t=ZC.BQ(e.X.length,e.BX.length),i=0;if(t>0&&e.BR.AA%180==0){for(var n=ZC.BQ(1,ZC._i_(t/20)),a=0,r=0;r<t;r+=n){for(var l=((e.BX[r]||e.X[r])+"").split(/<br>|<br\/>|<br \/>|\n/),o=0,s=0,c=l.length;s<c;s++)o=ZC.BQ(o,10*l[s].replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,"").length);i+=o,a++}i=.75*i/Math.max(1,a)}else i=15;e.CQ?e.EE=ZC._i_((e.F-e.A5-e.BW)/15):e.EE=ZC._i_((e.I-e.A5-e.BW)/i),e.EE=ZC.CY(e.EE,10),(e.BL-e.B4)/e.E4+1<e.EE?e.EE=ZC.BQ(e.EE,ZC._i_((e.BL-e.B4)/e.E4)+1):(e.BL-e.B4)/(2*e.E4)+1<e.EE&&(e.EE=ZC.BQ(e.EE,ZC._i_((e.BL-e.B4)/(2*e.E4))+1)),e.EE=ZC.BQ(2,e.EE)},AC4:function(){var e=this;null===ZC._n_(e.o["max-ticks"])&&(e.LY=e.EE)},A9L:function(e){var t,i,n,a,r,l=this;if(1===e&&l.o.transform&&"date"===l.o.transform.type&&(null===ZC._n_(l.o.transform.uniform)||ZC._b_(l.o.transform.uniform)||(l.NV=!0)),1===e&&null!==ZC._n_(l.o.values))if(l.X=[],"object"==typeof l.o.values)for(l.X=l.o.values,0===l.BX.length&&(l.BX=l.X),n=0,a=l.X.length;n<a;n++)"string"==typeof l.X[n]&&(l.A4U=!0,l.IM.push(l.X[n]));else{var o=l.o.values.split(":"),s=l.E4;if(3===o.length&&(s=ZC._f_(o[2])),l.E4=l.SC=s,ZC._f_(o[0])>ZC._f_(o[1])){var c=o[0];o[0]=o[1],o[1]=c}if(s<=0&&(s=1),o.length>1){for(var h=0,C=0,u=0,d=(""+s).split("."),p=ZC._f_(o[0]);p<=ZC._f_(o[1]);p+=s){var A=(""+p).split(".");d.length>1&&A.length>1&&d[1].length>0&&A[1].length>=9&&ZC._a_(A[1].length-d[1].length)>2?(h+=d[1].length,C=ZC.BQ(C,d[1].length),u++,null!==(r=ZC._n_(l.o.decimals))?l.X.push(ZC._f_(Number(p).toFixed(ZC._i_(r)))):l.X.push(ZC._f_(ZC._fixed_(Number(p),d[1].length))),p=ZC._f_(ZC._fixed_(Number(p),d[1].length))):(h+=A[1]?A[1].length:0,C=ZC.BQ(C,A[1]?A[1].length:0),u++,null!==(r=ZC._n_(l.o.decimals))?l.X.push(ZC._f_(Number(p).toFixed(ZC._i_(r)))):l.X.push(p))}null===ZC._n_(l.o.decimals)&&(h=Math.ceil(h/u),l.DU=ZC._a_(C-h)<=1?C:h)}}if(2===e){var g=0,f=[];0===l.X.length?(t=ZC.MAX,i=-ZC.MAX):(t=l.X[0],i=l.X[l.X.length-1]);var Z=l.A.AY.A6,_=!1;for(n=0,a=Z.length;n<a;n++){var b=Z[n].BT();if(-1!==ZC.AV(b,l.BC)){for(var m=0===f.length,v=0,D=Z[n].R.length;v<D;v++)if(Z[n].R[v])if(null!==Z[n].R[v].BU){var E=Z[n].R[v].BU;t=ZC.CY(t,E),i=ZC.BQ(i,E),l.NV&&m&&f.push(E),l.ED=!0,Z[n].ED=!0}else _=!0;else l.NV&&m&&f.push("");Z[n].ED||(g=ZC.BQ(g,Z[n].R.length))}}if(null!==ZC._n_(l.o.values))for(n=0;n<l.X.length;n++)null===l.X[n]&&(l.X[n]="");if(null!==ZC._n_(l.o.labels))for(n=0;n<l.BX.length;n++)null===l.BX[n]&&(l.BX[n]="");if(g>l.X.length&&l.X.length>0&&!l.ED)for(n=l.X.length;n<g;n++);var w,B,K=0;for(n=0;n<Z.length;n++)Z[n].LJ&&(-1===Z[n].R3&&(Z[n].R3=K),K++,l.DL=!0);if(0===l.X.length)for(n=0;n<K;n++)l.X.push(n),l.BX.push(n);if(0===l.X.length)if(l.ED)_&&t>0&&(t=0),_&&i<g-1&&(i=g-1),null!==ZC._n_(l.o["min-value"])&&(t=ZC._f_(l.o["min-value"])),null!==ZC._n_(l.o["max-value"])&&(i=ZC._f_(l.o["max-value"])),i-t<l.E4&&i-t>0&&(l.E4=Math.pow(10,Math.floor(ZC.H0(i-t)/Math.LN10))),l.NV||l.RN(t,i,!0),0===t&&0===i&&"0,1"===l.X.join(",")&&(l.X=[0]);else if(null!==ZC._n_(l.o["max-value"])){w=0,B=0,null!==ZC._n_(l.o["min-value"])&&(w=ZC._f_(l.o["min-value"])),B=ZC._f_(l.o["max-value"]),n=0;var F=w;if(l.FD&&null!==ZC._n_(l.FD.o.type))switch(l.FD.o.type){case"date":l.E4=l.A1P(w,B)}else(B-w)/l.E4>1e4&&(l.E4=Math.pow(10,ZC.BQ(1,ZC._i_(ZC.H0(ZC._a_(B-w),10)-4))));for(;F<B;)F=l.A.A2A(n*l.E4+w),null===ZC._n_(l.X[n])&&(l.X[n]=F),n++}else if(w=null!==ZC._n_(l.o["min-value"])?ZC._f_(l.o["min-value"]):0,B=w+(g-1)*l.E4,"log"===l.CA)l.RN(w,B,!0);else for(n=0;n<g;n++)null===ZC._n_(l.X[n])&&(l.X[n]=l.A.A2A(n*l.E4+w));l.NV&&l.ED&&(l.X=[].concat(f),l.BX=[].concat(f))}if(l.NV)for(l.TX={},n=0,a=l.BX.length;n<a;n++)l.TX[l.BX[n]]=n;if(l.V=0,l.A1=l.X.length-1,l.DD=0,l.DZ=l.X.length-1,l.IM.length>0?(l.B4=l.V,l.BL=l.A1):(l.B4=ZC._f_(l.X[l.V]),l.BL=ZC._f_(l.X[l.A1])),l.NN){-1===ZC.AV(l.X,l.NN[0])&&ZC.P4(l.NN[0])&&null!==ZC._n_(l.X[0])&&-1!==l.SC&&(l.NN[0]=l.X[0]+l.SC*Math.floor((l.NN[0]-l.X[0])/l.SC)),-1===ZC.AV(l.X,l.NN[1])&&ZC.P4(l.NN[1])&&null!==ZC._n_(l.X[0])&&-1!==l.SC&&(l.NN[1]=l.X[0]+l.SC*Math.ceil((l.NN[1]-l.X[0])/l.SC));var x=ZC.AV(l.X,l.NN[0]),y=ZC.AV(l.X,l.NN[1]);l.LI=[-1===x?0:x,-1===y?l.X.length-1:y]}l.LI&&-1!==l.V&&-1!==l.A1&&((l.LI[0]>l.A1||l.LI[0]<l.V)&&(l.LI[0]=l.V),(l.LI[1]>l.A1||l.LI[1]<l.V)&&(l.LI[1]=l.A1));var I=l.H.D["graph"+l.A.L+".zoom"];if(null===ZC._n_(l.H.D.preservezoom)||l.H.D.preservezoom){var z=1===l.L?"":"-"+l.L;void 0!==I&&null!==ZC._n_(I["xmin"+z])&&null!==ZC._n_(I["xmax"+z])&&(l.LI=[I["xmin"+z],I["xmax"+z]])}else l.H.D["graph"+l.A.L+".zoom"]={};l.LI&&(l.A.A0X=!0)},RN:function(e,t,i){var n,a,r,l,o=this,s=!1,c=null!==ZC._n_(o.o.step)&&-1!==(""+o.o.step).indexOf("month");if(o.FD&&null!==ZC._n_(o.FD.o.type))switch(o.FD.o.type){case"date":var h=o.A1P(e,t);(t-e)%h!=0&&(c||(t+=h-(t-e)%h)),n=[e,t,h,1,h],s=!0}else if("log"===o.CA)n=[e,t,1,1,1];else{var C=null!==ZC._n_(o.o.step)||null!==ZC._n_(o.o["min-value"])||null!==ZC._n_(o.o["max-value"]);n=e!==t?ZC.AO.W7(e,t,o.E4,o.OY,C):[e,t,o.E4,1,o.E4]}-1===o.SC&&(o.SC=n[4]);var u=n[0],d=n[1];l=n[2],i&&"log"===o.CA&&(u=Math.floor(ZC.H0(u,o.EH)),d=Math.ceil(ZC.H0(d,o.EH))),null===ZC._n_(o.o.step)&&(d-u)/l>1e4&&(l=(d-u)/1e4,r=Math.ceil(ZC.H0(l)/Math.LN10),l=Math.pow(10,r)),null===ZC._n_(o.o["min-value"])&&u!==d&&(s&&c||(u-=u%l)),null===ZC._n_(o.o["max-value"])&&u!==d&&(s&&c||(d=d-d%l+(d%l==0?0:l))),r=Math.floor(ZC.H0(l)/Math.LN10);var p=n[3];r<p&&r<0&&(p=r),"log"===o.CA&&(p=ZC.BQ(1,p)),o.X=[];var A;if(s&&c){var g=ZC.AP.Y2(u,"%Y-%n-%d-%H-%i-%s",!1,0).split("-"),f=new Date(u).getTimezoneOffset(),Z=!0,_=ZC._i_((""+o.o.step).replace("month"));0===_&&(_=1);var b=ZC._i_(g[1]),m=ZC._i_(g[0]);for(o.X.push(u);Z&&u!==d;){Z=!1;var v=ZC._i_(g[2]);b+_>=12&&m++,b=(b+_)%12,(31===v&&(3===b||5===b||8===b||10===b)||v>28&&1===b)&&(v=1===b?m%4==0&&m%100!=0||m%400==0?29:28:30);var D=new Date(m,b,v,g[3],g[4],g[5]),E=D.getTimezoneOffset(),w=D.getTime()+6e4*(f-E);o.X.push(w),w<d&&w<=t&&(Z=!0)}}else if(i){o.FU=e,o.GY=t,o.UT=ZC._i_((d-u)/l);var B=(""+l).split("."),K=new String(B[1]||"0").length;for((d-u)%l!=0&&(d-=(d-u)%l)<t&&(d=d-(d-u)%l+l),a=u;a<=d+1e-4;a+=l){A=a;var F,x,y=o.DU;if("log"===o.CA)for(var I=!0;I;)I=!1,x=F=Math.pow(o.EH,A),F=ZC._f_(ZC._fixed_(F,y)),x<1&&x!==F&&ZC.BQ(x,F)/ZC.CY(x,F)>1.005&&(I=!0,++y>ZC.CY(20,-1===o.HW?99:o.HW)&&(I=!1));else F=null!==y?ZC._f_(ZC._fixed_(A,Math.max(y,K))):ZC._f_(ZC._fixed_(A,K));o.X.push(F)}}else for(l=ZC._f_((t-e)/o.UT),a=0;a<=o.UT;a++)A=e+l*a,p<0&&(A=ZC._f_(A.toFixed(-p))),o.X.push(A);o.V=0,o.A1=o.X.length-1,o.DD=0,o.DZ=o.X.length-1,o.B4=ZC._f_(o.X[o.V]),o.BL=ZC._f_(o.X[o.A1])},A1P:function(e,t,i){var n=this;void 0===i&&(i=!1);var a=t-e,r=Math.floor(ZC.H0(a)/Math.LN10);return null===ZC._n_(n.o.step)||i?r<=3?1:4===r?1e3:5===r?1e4:6===r?2e4:7===r?3e4:8===r?6e4:9===r?6e5:10===r?12e5:11===r?18e5:36e5:n.E4},parse:function(){this.b()},clear:function(){this.b()},build:function(){this.b()},paint:function(){this.b(),null!==ZC._n_(this.o.values)&&(this.T3=!0)}}),ZC.Z4=ZC.H8.C7({$i:function(e){this.b(e);var t=this;t.AF="v",t.V=-1,t.A1=-1,t.UT=0,t.DU=null,t.KQ="normal",t.JI=[]},zoomTo:function(e,t){var i,n,a=this;if(a.GM){null!==ZC._n_(e)?a.B4=e:a.B4=a.FU,null!==ZC._n_(t)?a.BL=t:a.BL=a.GY,("piano"===a.A.AF||a.PU)&&(a.B4=ZC._i_(a.B4),a.BL=ZC._i_(a.BL)),a.RN(a.B4,a.BL,!1);var r=a.A.BT("v");for(i=0;i<r.length;i++)r[i].BC!==a.BC&&r[i].sMaster===a.BC&&r[i].zoomTo(e,t);if(""===a.sMaster){if(a.H.H9.C||(a.H.H9.C=a.A),a.A.H9&&null!==ZC._n_(a.A.H9.o.shared)&&ZC._b_(a.A.H9.o.shared)&&a.A.K===a.H.H9.C.K)for(i=0,n=a.H.AH.length;i<n;i++){var l=a.H.AH[i];if(l.K!==a.A.K&&null!==ZC._n_(l.H9.o.shared)&&ZC._b_(l.H9.o.shared)){var o=l.BN(a.BC);o&&o.GM&&(e=Math.max(o.FU,Math.min(o.GY,a.B4)),t=Math.max(o.FU,Math.min(o.GY,a.BL)),o.zoomTo(e,t),ZC.AK(l.K)&&(l.clear(!0),l.D["shared-zoom"]=!0,l.paint(),l.BA&&l.BA.update(null,null,e,t,!0)))}}a.IW()}}},FO:function(L,CU,ER){var s=this;void 0===CU&&(CU="",CU=null!==ZC._n_(s.BX[L])?s.BX[L]:s.X[L]),"number"==typeof CU&&null!==ZC._n_(s.JI[CU])&&(CU=s.JI[CU]);var OK=ZC.P4(CU)&&ZC._f_(CU)<0,BD=s.ML();if(ZC._cp_(ER,BD),null!==ZC._n_(s.D["max-power"])&&(BD["max-power"]=s.D["max-power"]),OK&&"currency"===BD.negation&&(CU=ZC._a_(ZC._f_(CU))),BD.utc=s.A.U9,BD.timezone=s.A.N6,CU=ZC.AP.GF(CU,BD,s,!0),s.CI)if("()"===s.CI.substring(s.CI.length-2)||"javascript:"===s.CI.substring(0,11))try{var EI=s.CI.replace("javascript:","").replace("()","");eval(EI)&&(CU=eval(EI).call(s,CU))}catch(e){}else CU=OK&&"currency"===BD.negation?"-"+s.CI.replace(/%v|%scale-value/g,CU):s.CI.replace(/%v|%scale-value/g,CU);return CU},A7I:function(){var e=this,t=ZC.BQ(e.X.length,e.BX.length);if(0===t&&(t=10),"log"===e.CA)e.EE=999;else{var i=Math.max(15,10*ZC.BQ(e.X.join("").length,e.BX.join("").length)/t);e.CQ?e.EE=ZC._i_((e.I-e.A5-e.BW)/i):e.EE=ZC._i_((e.F-e.A5-e.BW)/10),e.EE=ZC.CY(e.EE,10),e.EE=ZC.BQ(2,e.EE)}},AC4:function(){var e=this;null===ZC._n_(e.o["max-ticks"])&&(e.LY=e.EE)},A9L:function(e){var t,i,n,a,r,l,o,s=this;if(""!==s.sMaster&&2===e){var c=s.A.BN(s.sMaster);if(c)return s.B4=c.B4,s.FU=c.FU,s.BL=c.BL,s.GY=c.GY,s.E4=c.E4,s.SC=c.SC,s.V=c.V,s.A1=c.A1,s.DD=c.DD,s.DZ=c.DZ,s.X=[].concat(c.X),void(s.BX=[].concat(c.BX))}1===e&&null===ZC._n_(s.o.values)&&null!==ZC._n_(t=s.A.ABD("v"))&&(s.o.values=t);var h,C=0,u=s.JI;if(1===e&&null!==ZC._n_(s.o.values)){if(s.X=[],"object"==typeof s.o.values){var d=s.o.values,p=ZC.XS(d),A=ZC.A1H(d),g=!0;for(i=0,n=d.length-2;i<n;i++)if("number"==typeof d[i+2]&&"number"==typeof d[i+1]&&"number"==typeof d[i]&&ZC._f_(d[i+2])-ZC._f_(d[i+1])!=ZC._f_(d[i+1])-ZC._f_(d[i])){g=!1;break}if(!g&&(s.o.values=p+":"+A,!s.LP))for(s.LP=[],i=0,n=d.length;i<n;i++)s.LP.push(""+d[i])}if("object"==typeof s.o.values){for(ZC._cpa_(s.o.values,s.X),0===s.BX.length&&ZC._cpa_(s.BX,s.X),i=0,n=s.X.length;i<n;i++)if("string"==typeof s.X[i]){var f=s.X[i],Z=ZC.AV(u,s.X[i]);-1===Z?(u.push(s.X[i]),s.X[i]=u.length-1):s.X[i]=Z,null===ZC._n_(s.BX[i])&&(s.BX[i]=f)}}else{var _=s.o.values.split(":");if(o=1,3===_.length&&(o=ZC._f_(_[2])),ZC._f_(_[0])>ZC._f_(_[1])){var b=_[0];_[0]=_[1],_[1]=b}if(o<=0&&(o=1),null!==ZC._n_(s.o["fixed-items"])&&(o=(ZC._f_(_[1])-ZC._f_(_[0]))/ZC.BQ(1,ZC._i_(s.o["fixed-items"])-1),s.UT=ZC.BQ(1,ZC._i_(s.o["fixed-items"])-1)),_.length>1){for(var m=0,v=0,D=0,E=(""+o).split("."),w=ZC._f_(_[0]);w<=ZC._f_(_[1]);w+=o)a=(""+w).split("."),E.length>1&&a.length>1&&E[1].length>0&&a[1].length>=9&&ZC._a_(a[1].length-E[1].length)>2?(m+=E[1].length,v=ZC.BQ(v,E[1].length),D++,s.X.push(ZC._f_(ZC._fixed_(Number(w),E[1].length)))):(m+=ZC._i_(a[1]?a[1].length:0),v=ZC.BQ(v,a[1]?a[1].length:0),D++,s.X.push(w));w-ZC._f_(_[1])!=0&&ZC._a_(w-ZC._f_(_[1]))/o<1e-8&&s.X.push(ZC._f_(_[1])),null===ZC._n_(s.o.decimals)&&(m=(a=(""+o).split("."))[1]?a[1].length:Math.ceil(m/D),s.DU=ZC._a_(v-m)<=1?v:m)}}s.V=0,s.A1=s.X.length-1,s.E4=o,u.length>1?(C=ZC.XS(s.X,!0),s.B4=ZC.XS(s.X),s.BL=ZC.A1H(s.X)):(s.B4=s.X[0],s.BL=s.X[s.X.length-1]),"log"===s.CA&&(0===s.B4&&(h=Math.floor(ZC.H0(C,s.EH)),s.B4=Math.pow(s.EH,Math.min(-1,h))),s.RN(ZC.H0(s.B4,s.EH),ZC.H0(s.BL,s.EH),!1))}if(2===e){var B={};null===ZC._n_(s.o.values)&&(s.X=[],r=ZC.MAX,l=-ZC.MAX);var K=[],F=s.A.AY.A6;for(i=0,n=F.length;i<n;i++)if(s.A.D["plot"+i+".visible"]||"hide"===s.A.getToggleAction()){var x=F[i].BT();if(-1!==ZC.AV(x,s.BC))for(var y=-1!==ZC.AV(["vbar","hbar","vbar3d","hbar3d"],F[i].AF),I=[],z=0,H=F[i].X.length;z<H;z++)if(F[i].R[z]){var M=null===F[i].R[z].BU?z:F[i].R[z].BU;if(F[i].CB&&-1!==ZC.AV(I,M))continue;I.push(M);var S=F[i].LW&&null!==ZC._n_(F[i].LW[z])?ZC._f_(F[i].LW[z]):0;if(F[i].CB)null===ZC._n_(B[F[i].DY])&&(B[F[i].DY]=[]),null===ZC._n_(B[F[i].DY][M])?F[i].R[z].AD>=0||!y?B[F[i].DY][M]=[F[i].R[z].AD,0]:B[F[i].DY][M]=[0,F[i].R[z].AD]:F[i].R[z].AD>=0||!y?B[F[i].DY][M][0]+=F[i].R[z].AD:B[F[i].DY][M][1]+=F[i].R[z].AD,F[i].R[z].AD>=0||!y?F[i].R[z].CR=B[F[i].DY][M][0]:F[i].R[z].CR=B[F[i].DY][M][1],null===ZC._n_(s.o.values)&&K.push(B[F[i].DY][M][0]+S,B[F[i].DY][M][1]+S);else if(null===ZC._n_(s.o.values)){K.push(F[i].R[z].AD+S),0!==S&&K.push(S);for(var k=0,X=F[i].R[z].DN.length;k<X;k++)K.push(F[i].R[z].DN[k]+S)}}}K.length>0&&(C=ZC.XS(K,!0),r=ZC.XS(K),l=ZC.A1H(K)),0!==s.X.length||r!==Number.MAX_VALUE&&l!==Number.MIN_VALUE||(s.X=[0,1],r=0,l=1),null===ZC._n_(s.o.values)&&(null!==ZC._n_(s.o["min-value"])&&"auto"!==s.o["min-value"]?r=ZC._f_(s.o["min-value"]):r>0&&"auto"!==s.o["min-value"]&&"log"!==s.CA&&(r=0),null!==ZC._n_(s.o["max-value"])&&(l=ZC._f_(s.o["max-value"])),r===ZC.MAX&&l===-ZC.MAX?(s.V=0,s.A1=0,s.B4=0,s.BL=0):"log"===s.CA?(0===r&&(h=Math.floor(ZC.H0(C,s.EH)),r=Math.pow(s.EH,Math.min(-1,h))),s.RN(ZC.H0(r,s.EH),ZC.H0(l,s.EH),!1)):s.RN(r,l,!0))}2===e&&(-1===s.FU&&-1===s.GY&&(s.FU=s.B4,s.GY=s.BL),-1===s.SC&&(s.SC=s.E4)),"auto"===s.o["min-value"]&&null===ZC._n_(s.o["ref-value"])&&(s.H4=s.B4),0===s.UT&&(s.UT=ZC._i_((s.BL-s.B4)/s.E4));var T=s.H.D["graph"+s.A.L+".zoom"];if(null===ZC._n_(s.H.D.preservezoom)||s.H.D.preservezoom){var P=1===s.L?"":"-"+s.L;2===e&&void 0!==T&&null!==ZC._n_(T["ymin"+P])&&null!==ZC._n_(T["ymax"+P])&&(ZC.DT(T["ymin"+P],s.B4,s.BL)||(T["ymin"+P]=s.B4),ZC.DT(T["ymax"+P],s.B4,s.BL)||(T["ymax"+P]=s.BL),s.LI=[T["ymin"+P],T["ymax"+P]])}else s.H.D["graph"+s.A.L+".zoom"]={};s.LI&&(s.A.A0X=!0)},RN:function(e,t,i){var n,a,r,l=this;"piano"!==l.A.AF&&!l.PU&&l.JI.length>1&&(e=0),l.TI.length&&null===ZC._n_(l.o["scale-factor"])&&(r=Math.floor(ZC.H0(ZC._a_(t),ZC._f_(l.TI[0]))),l.OY=Math.pow(ZC._f_(l.TI[0]),r)/Math.pow(1e3,r),l.D["max-power"]=r);var o,s=(o=l.FD&&"date"===l.FD.o.type?ZC.AO.W7(e,t,"lin"===l.CA?l.E4:null,l.OY,l.bNormalize,l.EE):ZC.AO.W7(e,t,"lin"===l.CA?l.o.step:null,l.OY,l.bNormalize,l.EE))[0],c=o[1],h=!1;a=Math.floor(o[0]),"log"===l.CA&&(r=Math.ceil(o[1]),o[1]-o[0]>=.5?h=!0:o=ZC.AO.W7(Math.pow(l.EH,o[0]),Math.pow(l.EH,o[1]),null,l.OY,l.bNormalize));var C=o[0],u=o[1],d=o[2];null!==ZC._n_(l.o["fixed-items"])&&(d=(u-C)/ZC.BQ(1,ZC._i_(l.o["fixed-items"])-1)),l.PU&&t===e&&(t+d<=l.BL?t+=d:e-=d),1!==l.QY&&(C*=l.QY,u*=l.QY,d*=l.QY),null!==ZC._n_(l.D["o-decimals"])?l.DU=l.D["o-decimals"]:l.D["o-decimals"]=l.DU,null===ZC._n_(l.o.decimals)&&("log"===l.CA&&h?l.DU=a<0?null:0:a<0?l.DU=o[3]:l.A2V||(l.DU=0));var p,A,g,f,Z,_=!0;if(h){a=Math.floor(C),r=Math.ceil(u),g=Math.pow(l.EH,e),f=Math.pow(l.EH,t),l.X=[];var b,m,v=[0,2,5];for(m=[0,1,2,3,4,5,6,7,8,9,10],n=a;n<=r;n++){var D=o[3];if(D=n<0?Math.max(ZC._a_(n),D):0,n===r)for(b=0;b<v.length;b++)Z=Math.pow(l.EH,n)+v[b]*Math.pow(l.EH,n-1),Z=ZC._f_(Z.toFixed(D)),-1===ZC.AV(l.X,Z)&&l.X.push(Z);for(b=0;b<m.length;b++)Z=m[b]*Math.pow(l.EH,n),Z=ZC._f_(Z.toFixed(D)),-1===ZC.AV(l.X,Z)&&l.X.push(Z)}l.X.sort(function(e,t){return e-t});for(var E=-1,w=-1,B=0;B<l.X.length-1;B++)l.X[B]<=g&&g<=l.X[B+1]&&(E=B),l.X[B]===f?w=B:l.X[B]<=f&&f<=l.X[B+1]&&(w=B+1);l.X=l.X.slice(E,w+1),0===l.X[0]&&l.X.shift(),s=ZC.H0(l.X[0],l.EH),c=ZC.H0(l.X[l.X.length-1],l.EH)}else{for("log"===l.CA&&(g=Math.pow(l.EH,e),f=Math.pow(l.EH,t));_;){_=!1,l.X=[],p=A=C;do{A=p,A=ZC._f_(A.toFixed(l.DU)),-1!==ZC.AV(l.X,A)&&(_=!0),"log"===l.CA?A>=C&&A<=u&&l.X.push(A):l.X.push(A),p+=d,p=ZC._f_(p.toFixed(o[3]))}while(p<=u);_&&(l.DU+=1)}"log"===l.CA&&(s=ZC.H0(C,l.EH),c=ZC.H0(u,l.EH),l.X.push(C),l.X.push(u),l.X.sort(function(e,t){return e-t}))}l.E4=d,l.V=0,l.A1=l.X.length-1,i?(l.B4=s,l.BL=c):(l.B4=e,l.BL=t)},parse:function(){var e=this;e.assign_a([["stack-type","KQ"]]),(e.A.CB&&"100%"===e.A.KQ||"100%"===e.KQ)&&null===ZC._n_(e.o.values)&&(e.o.values="0:100:20",e.o.format="%v%"),this.b()},clear:function(){this.b()},build:function(){this.b()},paint:function(){this.b(),null===ZC._n_(this.D.decimals)&&(this.D.decimals=null!==ZC._n_(this.DU)?this.DU:-1),null!==ZC._n_(this.o.values)&&(this.T3=!0)}});}
