Highcharts.chart('patient_services_doctors', {
  chart: {
    type: 'column'
  },
  title: {
    align: 'left',
    text: ''
  },
  subtitle: {
    align: 'left',
    text: ''
  },
  accessibility: {
    announceNewData: {
      enabled: true
    }
  },
  xAxis: {
    type: 'category'
  },
  yAxis: {
    title: {
      text: 'Total Percent of patients serviced'
    }

  },
  legend: {
    enabled: false
  },
  plotOptions: {
    series: {
      borderWidth: 0,
      dataLabels: {
        enabled: true,
        format: '{point.y:.1f}%'
      }
    }
  },

  tooltip: {
    headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
    pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}%</b> of total<br/>'
  },

  series: [
    {
      name: "Patents serviced by",
      colorByPoint: true,
      data: [
        {
          name: "Dr. Arun",
          y: 63.06,
          drilldown: "Dr. Arun"
        },
        {
          name: "Dr. Vivek",
          y: 19.84,
          drilldown: "Dr. Vivek"
        },
        {
          name: "Dr. Rashmi",
          y: 34.18,
          drilldown: "Dr. Rashmi"
        },
        {
          name: "Dr. Himika",
          y: 4.12,
          drilldown: "Dr. Himika"
        },
        {
          name: "Dr. Narayan",
          y: 42.33,
          drilldown: "Dr. Narayan"
        },
        {
          name: "Dr. Rishav",
          y: 72.45,
          drilldown: "Dr. Rishav"
        },
        {
          name: "Other",
          y: 1.582,
          drilldown: null
        }
      ]
    }
  ],

});

Highcharts.chart('patient_services_doctors2', {
  chart: {
    type: 'column'
  },
  title: {
    align: 'left',
    text: ''
  },
  subtitle: {
    align: 'left',
    text: ''
  },
  accessibility: {
    announceNewData: {
      enabled: true
    }
  },
  xAxis: {
    type: 'category'
  },
  yAxis: {
    title: {
      text: 'Total Percent of patients serviced'
    }

  },
  legend: {
    enabled: false
  },
  plotOptions: {
    series: {
      borderWidth: 0,
      dataLabels: {
        enabled: true,
        format: '{point.y:.1f}%'
      }
    }
  },

  tooltip: {
    headerFormat: '<span style="font-size:11px">{series.name}</span><br>',
    pointFormat: '<span style="color:{point.color}">{point.name}</span>: <b>{point.y:.2f}%</b> of total<br/>'
  },

  series: [
    {
      name: "Patents serviced by",
      colorByPoint: true,
      data: [
        {
          name: "Dr. Arun",
          y: 63.06,
          drilldown: "Dr. Arun"
        },
        {
          name: "Dr. Vivek",
          y: 19.84,
          drilldown: "Dr. Vivek"
        },
        {
          name: "Dr. Rashmi",
          y: 34.18,
          drilldown: "Dr. Rashmi"
        },
        {
          name: "Dr. Himika",
          y: 4.12,
          drilldown: "Dr. Himika"
        },
        {
          name: "Dr. Narayan",
          y: 42.33,
          drilldown: "Dr. Narayan"
        },
        {
          name: "Dr. Rishav",
          y: 72.45,
          drilldown: "Dr. Rishav"
        },
        {
          name: "Other",
          y: 1.582,
          drilldown: null
        }
      ]
    }
  ],

});