<!DOCTYPE html>
<html lang="en">

<head>
    <!-- ========== Meta Tags ========== -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="UNIDO | United Nations Industrial Development Organization">

    <!-- ========== Page Title ========== -->
    <title>IUAES Congress 2023</title>

    <!-- ========== Favicon Icon ========== -->
    <link rel="shortcut icon" href="assets/img/fav.png" type="image/x-icon">

     <?php $page='home'; include('include/stylesheets.php');?>

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="assets/js/html5/html5shiv.min.js"></script>
      <script src="assets/js/html5/respond.min.js"></script>
    <![endif]-->

    <!-- ========== Google Fonts ========== -->
    <link href="https://fonts.googleapis.com/css?family=Source+Sans+Pro&amp;display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700&amp;display=swap" rel="stylesheet">

</head>

<body>

    <?php include('include/header.php'); ?>
    
    <div class="banner-area">
        <div id="bootcarousel" class="carousel inc-top-heading slide carousel-fade" data-ride="carousel">
            <!-- Wrapper for slides -->
			 <div class="carousel-inner text-light carousel-zoom">
                <div class="item active">
                    <div class="slider-thumb bg-cover" style="background-image: url(assets/img/banner/iuaes-banner2.jpg);"></div>
                    <div class="box-table shadow dark">
                        <div class="box-cell">
                            <div class="content">
                                <h3 data-animation="animated slideInUp">19<sup>th</sup> IUAES  </h3>
                                <h2 data-animation="animated slideInUp">World Anthropological Congress 2023</h2>
                               <p data-animation="animated slideInDown"> Theme: Anthropology in Public Sphere: Global Peace and Development</p>
                               
                               
                            </div>
                                    
                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="slider-thumb bg-cover" style="background-image: url(assets/img/banner/iuaes-banner3.jpg);"></div>
                    
                </div>
                <div class="item">
                    <div class="slider-thumb bg-cover" style="background-image: url(assets/img/banner/iuaes-banner6.jpg);"></div>
                    
                </div>
                <div class="item">
                    <div class="slider-thumb bg-cover" style="background-image: url(assets/img/banner/iuaes-banner7.jpg);"></div>
                    
                </div>
            </div>
			
             <!-- End Wrapper for slides -->

            <!-- Left and right controls -->
            <a class="left carousel-control" href="#bootcarousel" data-slide="prev">
                <i class="fa fa-angle-left"></i>
                <span class="sr-only">Previous</span>
            </a>
            <a class="right carousel-control" href="#bootcarousel" data-slide="next">
                <i class="fa fa-angle-right"></i>
                <span class="sr-only">Next</span>
            </a>
        </div>
    </div>
    <!-- End Banner -->
	
	
	
   
	
	  <!-- Start Our Services
    ============================================= -->
    <div class="services-area carousel-shadow customtb-padding">
    
    
        <div class="container">
            <div class="row">
                
                <div class="col-md-8">
                
                	<div>
						<h3 class="heading-main">About The IUAES</h3>
					</div>
                     
                    <p class="text-justify">The IUAES is a world organization of scientists and institutions working in the fields of anthropology and ethnology, and is also of interest to archaeologists and linguists, among others. It aims to enhance exchange and communication among scholars of all regions of the world, in a collective effort to expand human knowledge. In this way it contributes to a better understanding of human society, and to a sustainable future based on harmony between nature and culture.</p>
<p class="text-justify"> The IUAES was established on 23 August 1948, but the foundations of The IUAES were laid much earlier. In 1865, various Congresses of Anthropological Sciences began to unite anthropologists in exchange and conversation. In 1934, these were formalized in the founding of The International Congress of Anthropological and Ethnological Sciences (ICAES). The President of the ICAES served as the President of the Union. In 1948, The IUAES and ICAES were brought into one organization, de facto. In 1968 the two organizations were united, de jure. In 2008, the ICAES Congress was renamed the IUAES World Congress...</p>
                      
                    <div class="text-right">
                        <a href="#" class="views-more-link btn btn-primary">Read More</a>
                    </div>
					
                </div>    
                    
                <div class="col-md-4"> 
                	 <div class="thumb shape-bg  mt-xs-20">
                        <img src="assets/img/who-we-are.jpg" alt="Thumb">
                        <a href="https://www.youtube.com/watch?v=owhuBrGIOsE" class="popup-youtube light video-play-button item-center">
                            <i class="fa fa-play"></i>
                        </a>
                     </div>
                  	
                </div>	
            </div>
        </div>
    </div>
    <!-- End Our Services -->
    
    
    
    
    
    <div class="kp-section customtb-padding">
    	<div class="container">
    		<div class="row">
            	<div class="col-md-12">
            	    <div class="mb-20">
						<h3 class="heading-main">Our Video Gallery</h3>
					</div>
                </div>
            	<div class="col-md-12">
                	<div class="services-items carousel-item-3 owl-carousel owl-theme img_height mb-20">
                    
                        <div class="item pr-30">
							<div class="service2">
								<div class="field-image">
									<img src="assets/img/videos/1.jpg"/>
                                    <div class=" media-icon video-item">
                                         <a class="popup-videos" href="https://www.youtube.com/watch?v=bnieIqAy0H8">
                                             <i class="fa fa-play"></i>
                                         </a>
                                    </div>
								</div>
								<div class="publication-content">
									<div class="field-title">
										<h3><a href="#">IUAES 2021</a></h3>
                                        <p>Bring to the table win-win survival strategies to dotted proactive domination.</p>
                                       
									</div>
								</div>
							</div>
                        </div>
                         <div class="item pr-30">
							<div class="service2">
								<div class="field-image">
									<img src="assets/img/videos/2.jpg"/>
                                    <div class=" media-icon video-item">
                                         <a class="popup-videos" href="https://www.youtube.com/watch?v=bnieIqAy0H8">
                                             <i class="fa fa-play"></i>
                                         </a>
                                    </div>
								</div>
								<div class="publication-content">
									<div class="field-title">
										<h3><a href="#">IUAES 2020 Croatia</a></h3>
                                        <p>Bring to the table win-win survival strategies to dotted proactive domination.</p>
                                       
									</div>
								</div>
							</div>
                        </div>
                        <div class="item pr-30">
							<div class="service2">
								<div class="field-image">
									<img src="assets/img/videos/3.jpg"/>
                                    <div class=" media-icon video-item">
                                         <a class="popup-videos" href="https://www.youtube.com/watch?v=bnieIqAy0H8">
                                             <i class="fa fa-play"></i>
                                         </a>
                                    </div>
								</div>
								<div class="publication-content">
									<div class="field-title">
										<h3><a href="#">Vídeo 18 IUAES - CapesCNPq</a></h3>
                                        <p>Bring to the table win-win survival strategies to dotted proactive domination.</p>
                                       
									</div>
								</div>
							</div>
                        </div>
                        <div class="item pr-30">
							<div class="service2">
								<div class="field-image">
									<img src="assets/img/videos/4.jpg"/>
                                    <div class=" media-icon video-item">
                                         <a class="popup-videos" href="https://www.youtube.com/watch?v=bnieIqAy0H8">
                                             <i class="fa fa-play"></i>
                                         </a>
                                    </div>
								</div>
								<div class="publication-content">
									<div class="field-title">
										<h3><a href="#">IUAES 2020 Croatia</a></h3>
                                        <p>Bring to the table win-win survival strategies to dotted proactive domination.</p>
                                       
									</div>
								</div>
							</div>
                        </div>
                        
                        
						
                         
                    </div>         
                </div>
                
                
                
                
                
            </div>
    	</div>
    </div>
    
    
   
    
    
    <div class="services-area inc-thumb bottom-less customtb-padding pb-30">
        <div class="container">
            <div class="row">
            
            	<div class="col-md-12">
            	    <div class="mb-20">
						<h3 class="heading-main">Latest News & Updates</h3>
					</div>
                    
                    
                </div>
                
               
                <div class="col-md-12">                
                    <div class="service-items owl-carousel owl-theme  owl-3">
                    <!-- Single Item -->
                    <div class="item">
                        <div class="s-item">
                            <div class="thumb" style="background-image: url(assets/img/news/1.jpg);">
                                <div class="thumb-buttons">
                                	<a href="#" class="event">9-14 March 2021</a>
                            		<a href="#" class="cat">Event</a>
                                </div>                            
                            </div>
                            <div class="info">
                                <h4> IUAES2020 Sibenik</h4>
                                <div class="meta-title mt-0">
                                    <span class="post-date"><i class="far fa-clock"></i> 01 Feb, 2021</span> 
                                    <span class="location"><i class="fa fa-user-alt"></i> Admin</span>
                                </div>
                                <p class="text-justify">
                                    Coming of Age on Earth: Legacies and next generation anthropology Croatia...
                                </p>
                                <a href="#">Read More <i class="ti-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <!-- End Single Item -->
                    <!-- Single Item -->
                    <div class="item">
                        <div class="s-item">
                            <div class="thumb" style="background-image: url(assets/img/news/2.jpg);">
                            	<div class="thumb-buttons">
                                	<a href="#" class="event">9-13 Nov 2021</a>
                            		<a href="#" class="cat">Event</a>
                                </div> 
                            </div>
                            <div class="info">
                            
                                <h4>IUAES2021 Yucatán</h4>
                                <div class="meta-title mt-0">
                                    <span class="post-date"><i class="far fa-clock"></i> 04 Feb, 2021</span> 
                                    <span class="location"><i class="fa fa-user-alt"></i> Admin</span>
                                </div>
                                <p class="text-justify">
                                    Heritages, Global interconnections in a possible world Mexico 9-13 Nov 2021...
                                </p>
                                <a href="#">Read More <i class="ti-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <!-- End Single Item -->
                    <!-- Single Item -->
                    <div class="item">
                        <div class="s-item">
                            <div class="thumb" style="background-image: url(assets/img/news/3.jpg);">
                            	<div class="thumb-buttons">
                            		<a href="#" class="cat">News</a>
                                </div> 
                            </div>
                            <div class="info">
                                <h4> IUAES2020 information:</h4>
                                 <div class="meta-title mt-0">
                                    <span class="post-date"><i class="far fa-clock"></i> 12 Feb, 2021</span> 
                                    <span class="location"><i class="fa fa-user-alt"></i> Admin</span>
                                </div>
                                <p class="text-justify">
                                    For those who want to have a pre-recorded presentation in the Congress, the set...
                                </p>
                                <a href="#">Read More <i class="ti-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <!-- End Single Item -->
                   
                    </div>
                </div>
               
                
                
            </div>
        </div>
    </div>
    
    <div class="why-chose-us-area bg-dark full text-light bg-cover" style="background-image:url(assets/img/bg1.jpg);">
        <div class="container-full">
            <div class="row">
                <div class="item-box">
                    <div class="col-md-6 col-md-offset-6 info">
                        <div class="heading">
                            <h4>IUAES: World Congress 2023, 12-19 January: India</h4>
                            <h2>Marginalities, Uncertainties, and World Anthropologies: Enlivening Past and Envisioning Future</h2>
                        </div>
                        <div class="content">
                            <p class="text-justify">The dramatic changes seen in the world of 2020, will remain as a critical chapter of human history, where humanity has emerged into what is known as the new normal', with new scars and new achievements. In the forthcoming World Congress to be held in Delhi, Bhubaneswar and few other cities of India, various facets of this transformed world with its new challenges and deconstructed realities shall be examined, deliberated and debated. Erosion/consolidation of existing boundaries and power hierarchies have sharpened the cleavages of gender, caste, race, ethnicities and class creating new marginalities and uncertainties.</p>
                            
                            <a class="btn circle btn-theme effect btn-md" href="#">Read More</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="services-area inc-thumb bottom-less customtb-padding pb-30">
        <div class="container">
            <div class="row">
            	<div class="col-md-12">
            	    <div class="mb-20">
						<h3 class="heading-main">Collaborating Partner</h3>
					</div>
                </div>
                <div class="col-md-12">                
                    <div class="service-items owl-carousel owl-theme partner-carousel">
                        <div class="item">
                            <a href=""><img src="assets/img/partner/2.png"></a>
                        </div>
                        <div class="item">
                            <a href=""><img src="assets/img/partner/4.png"></a>
                        </div>
                        <div class="item">
                            <a href=""><img src="assets/img/partner/5.png"></a>
                        </div>
                        <div class="item">
                            <a href=""><img src="assets/img/partner/6.png"></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    
    
    
    </div>
    <!-- End Our News Useful Links -->
	

	
	







    

    <?php include('include/footer.php');?>

    <?php include('include/scripts.php');?>

</body>
</html>