<!DOCTYPE html>
<html lang="en">
<head>

    <!-- META -->
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="keywords" content="" />
    <meta name="author" content="" />
    <meta name="robots" content="" />    
    <meta name="description" content="" />
    
    <!-- FAVICONS ICON -->
    <link rel="icon" href="images/favicon.ico" type="image/x-icon" />
    <link rel="shortcut icon" type="image/x-icon" href="images/favicon.png" />
    
    <!-- PAGE TITLE HERE -->
    <title> Constitution GCRA | Global Communication Research Association (GCRA)</title>
    
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    
    <!-- [if lt IE 9]>
        <script src="js/html5shiv.min.js"></script>
        <script src="js/respond.min.js"></script>
    <![endif] -->
    
    <!-- BOOTSTRAP STYLE SHEET -->
    <link rel="stylesheet" type="text/css" href="css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="css/fontawesome/css/font-awesome.min.css" />
    <link rel="stylesheet" type="text/css" href="css/flaticon.min.css">
    <link rel="stylesheet" type="text/css" href="css/animate.min.css">
    <link rel="stylesheet" type="text/css" href="css/owl.carousel.min.css">
    <link rel="stylesheet" type="text/css" href="css/bootstrap-select.min.css">
    <link rel="stylesheet" type="text/css" href="css/magnific-popup.min.css">
    <link rel="stylesheet" type="text/css" href="css/loader.min.css">    
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" class="skin" type="text/css" href="css/skin/skin-1.css">
    <link rel="stylesheet" type="text/css" href="css/custom.css"> 
    <link href='http://fonts.googleapis.com/css?family=Roboto:400,100,300,300italic,400italic,500,500italic,700,700italic,900italic,900' rel='stylesheet' type='text/css'>
    <link href='http://fonts.googleapis.com/css?family=Open+Sans:400,300,300italic,400italic,600,600italic,700,800italic,800,700italic' rel='stylesheet' type='text/css'>
    <link href="http://fonts.googleapis.com/css?family=Crete+Round:400,400i&amp;subset=latin-ext" rel="stylesheet">
    
 
</head>

<body id="bg">

	<div class="page-wraper"> 
       	
        <!-- HEADER START -->
        <?php include('include/header.php');?>
        <!-- HEADER END -->
        
        <!-- CONTENT START -->
        <div class="page-content">
        
            <!-- INNER PAGE BANNER -->
            <div class="wt-bnr-inr overlay-wraper" style="background-image:url(images/background/bg-8.jpg);">
            	<div class="overlay-main bg-black opacity-07"></div>
                <div class="container">
                    <div class="wt-bnr-inr-entry">
                        <h1 class="text-white">Constitution GCRA</h1>
                    </div>
                </div>
            </div>
            <!-- INNER PAGE BANNER END -->
            
            <!-- BREADCRUMB ROW -->                            
            <div class="bg-gray-light p-tb20">
            	<div class="container">
                    <ul class="wt-breadcrumb breadcrumb-style-2">
                        <li><a href="javascript:void(0);"><i class="fa fa-home"></i> Home</a></li>
                        <li>About Us</li>
                        <li>Constitution of GCRA</li>
                    </ul>
                </div>
            </div>
            <!-- BREADCRUMB ROW END -->
            
             
            <!-- ABOUT COMPANY SECTION START -->
            <div class="section-full p-t30 p-b40">
                <div class="container">
                	<!-- TITTLE START -->
                    
                    <!-- TITLE END -->                	
                    <div class="row">
                    	
                        <div class="col-md-12">
                        	
                            <div class="section-head text-left p-b10">
                                <h2 class="m-b0">Constitution Global Communication Research Association (GCRA)</h2>
                            </div>
                            <div>
                               <h2 class="text-primary"> Preamble</h2>
                               <p>Throughout the world large numbers of communication scholars and practitioners are underrepresented in forums of international Communications scholarship for reasons of geography, national security, economics and language.</p>
                               <p>The Global Communication Research Association seeks to provide a forum for those scholars and practitioners to be a part of the global communication community scholars able to express their research interests and best represent issues and problems of their countries.</p>
                               <p>Forums of communication will be low-cost conferences at physical locations and virtual settings.</p>
                               <p>The Association will also undertake research projects.</p>
                               <p>The Association will be characterized by inclusivity and focus on concerns of underrepresented scholars and practitioners in the different fields of communication.</p>
                               <p>The organizational values will be characterized by equitability, inclusivity, good governance and research excellence.</p>

                            </div>
                            <!-- Part 1 Start  -->
                            <div >
                                <h2 class="text-primary">PART 1 – Preliminary</h2>
                                <h4>VISION</h4>
                                <p>Be a forum and an organization pursuing media, communication, publication and technological and virtual inclusion, particularly reaching out to under-represented areas of all five continents.</p>
                                <h4>MISSION</h4>
                                <p>Carry out actions regarding communication and media research, diffusion of knowledge and innovation within an inclusive population framework, prioritizing the less advantaged geographical and professional contexts through in specific fields.</p>
                                <h4>OBJECTIVES</h4>
                                <p>The objectives of the Association are as follows:</p>
                                <ul class="list-checked">
                                    <li>Be a forum to pursue the exchange among civilizations with participation of researchers and professionals from all areas of communication including journalism, broadcasting, public relations, advertising, public opinion, digital communication, the extension fields and communication related areas;</li>
                                    <li>Uphold the needs of the researchers of communication, extension, the media, communication-related fields, and applied sciences;</li>
                                    <li>Undertake, document and publish research in the different fields of communication including global communication, development communication, social networks, political communication and public opinion, in addition to other under- represented areas research interests;</li>
                                    <li>Support the publication of articles and research works within viable local and regional means;</li>
                                    <li>Promote a participatory forum of information exchange regarding global rights, concerns, and priorities;</li>
                                    <li>Undertake initiatives within an ethical framework of good governance and accountability;</li>
                                    <li>Recognize the regional pride of different languages, social makeup, and cultures.</li>
                                </ul>
                            </div>
                             <!-- Part 1 End  -->
                             <!-- Part 2 Start  -->
                            <div>
                                 <h2 class="text-primary">PART 2 - Constitution</h2>
                                <p>The Association will operate under a Constitution. The preceding constitution is replaced by this current one after current Executive Board members in June 2018 identified at the end of this constitution have individually or collectively assented to this constitution with their signatures.</p>
                                <ol class="m-l15">
                                    <li><h5>Constitutional Amendments</h5>
                                   <p>Constitutional changes may be proposed by life or voting members of GCRA with secondment by a life or voting member three months before an Annual General Meeting. Such proposal will be received by the Secretary General and shared with the Executive Board. The procedure following this would be for the Executive Board to canvass membership opinion on the proposed amendment and make its recommendation to the Annual General Meeting where a two third’s majority would be required to reject the Executive Board’s recommendation.</p>
                                    </li>
                                    <li><h5>Membership generally</h5>
                                    <p>The Global Communication Research Association is composed of life members, voting members, associate members and Annual members. Voting members will be membership-fee paying members with voting rights. Life members are those involved and elected from its inception and foundation, as well as those who opted for this category following the norms and guidelines of the Association. Life members will have voting rights. Only life members and voting members may be elected to office.</p>
                                    <p>The Global Communication Research Association Executive Board may invite members of global communication-related research organizations or entities to become associate members or voting members if they prefer. In the latter instance they will be fee-paying members. These members would have voting rights if they are membership-fee paying members.</p>
                                    <p>Voting members can pay fees for three-year period. Life members pay one-time amount and annual members pay for yearly membership as per the calendar year.</p>
                                    </li>
                                    <li>
                                        <h5>Application for membership</h5>
                                        <p>The Global Communication Research Association accepts membership of persons who are involved in social research, including communication, journalism, mass media, virtual media, social media, applied media, educational communication, communication management, publishing, printing, photography, audiovisual media, science writing, and other areas related to communication research.</p>
                                    </li>
                                    <li><h5>Cessation of membership</h5>
                                    <p>Voting members cease to be members if they fail to pay their fees over a period of time to be defined in the rules set by the Executive Board. The Executive Board may remove associate members if their inactivity in the organization is deemed to be a problem as defined in the rules.</p>
                                    </li>
                                    <li><h5>Membership entitlements not transferable</h5>
                                   <p>Assigned entitlements, posts or duties of members are carried out by the Executive Board. Thus, only the Executive Board may intervene over such entitlements. Should any member request changes in his or her status within the Global Communication Research Association, he or she ought to do so under consultation with the Executive Board.</p>
                                    </li>
                                    <li><h5>Resignation of membership</h5>
                                    <p>Members may resign by writing to a designated officer of the Executive Board.</p>
                                    </li>
                                    </li>
                                    <li><h5>Register of members</h5>
                                    <p>A register of members will be maintained by a designated officer of the Executive Board. Interested academics, scientists, researchers and professional communicators may become members by filling up a form, provided by the Secretary General and the President. The registration shall be done via E-mail or other physical or electronic means.</p>
                                    </li>
                                    </li>
                                    <li><h5>Fees and subscriptions</h5>
                                    <p>Subscription rates for life, voting and annual membership will be set in the rules adopted from time to time by the Executive Board under Section 15.</p>
                                    <p>All fees will be used for administrative purposes of Global Communication Research Association’s activities.</p>
                                    </li>
                                    </li>
                                    <li><h5>Members’ liabilities</h5>
                                    <p>Members must uphold the principles and objectives of the Global Communication Research Association, bolster its actions and initiatives, and maintain a good, sincere and respectful relationship among all members.</p>
                                    </li>
                                    </li>
                                    <li><h5>Resolution of disputess</h5>
                                    <p>Whatever legal matters will be brought to the Executive Board, which will guide the ways and means of dealing with them, following the guidelines of this Constitution.</p>
                                    </li>
                                    </li>
                                    <li><h5>Disciplining of members</h5>
                                    <p>Members with whatever conduct that deviates the legal and ethical guidelines of this Constitution shall be approached by the Executive Board which will decide the appropriate procedures towards a solution.</p>
                                    </li>
                                    </li>
                                    <li><h5>Right of appeal of disciplined member</h5>
                                    <p>Members have the right to appeal under rules set by the Executive Board.</p>
                                    </li>
                                </ol>
                            </div>
                            <!-- Part 2 End  -->
                            <!-- Part 3 start  -->
                            <div>
                              <h2 class="text-primary">PART 3 - The Executive Board </h2>
                              <ol type="1" start="13" class="m-l15">
                                  <li>
                                      <h5>Powers of the Executive Board</h5>
                                      <p>The Executive Board has the legal, financial and ethical power for decision making regarding internal affairs of the Global Communication Research Association, always based on this Constitution.</p>
                                  </li>
                                  <li>
                                      <h5>Composition and membership of the Executive Board</h5>
                                      <p>The Executive Board is composed of five officers: a President, two Vice Presidents, one Secretary General, one Treasurer and the following ex-officio persons: the Editor of the Journal of Global Communication, and the Founder of the Global Communication Research Association or his Representative and the immediate past president of the Global Communication Research Association.</p>
                                  </li>
                                  <li>
                                      <h5>Rules governing the Association under the Constitution</h5>
                                      <p>The Executive Board is responsible for formulating rules under the constitution that affect the day-to-day management of the organization. Such rules need to be approved by the Executive Board after being canvassed with the membership.</p>
                                  </li>
                                  <li>
                                      <h5>Election of members of the Executive Board</h5>
                                      <p>The officers of the Executive Board shall be elected by a simple majority of votes of both life members and voting members. This shall be done every three years or when circumstances of inability or conduct matters disallow a member, under the rules, from continuing in the position. In that case, the Executive Board is entitled to choose another voting member as a replacement until the next election of members of the Executive Board. The Executive Board functioning at the time of the adoption of this constitution will continue in office for three years from the date of adoption.</p>
                                  </li>
                                  <li>
                                      <h5>Secretary General</h5>
                                      <p>The Secretary General is responsible for communication with the members concerning matters related to the Global Communication Research Association activities, meetings, conferences, research initiatives and involvement.</p>
                                      <p>The Secretary General is responsible for subscription of new members and constantly update the membership files via the Global Communication Research Association’s website. The Secretary General is also tasked with updating the members about the Global Communication Research Association’s activities within an interactive application, maintaining contact with the members and the Executive Board.</p>
                                  </li>
                                  <li>
                                      <h5>Treasurer</h5>
                                      <p>The Treasurer is responsible for the management of finances of Global Communication Research Association, keeping records of income and expenditure and reporting on these to the Executive Board and also preparing an annual budget for appraisal and approval by the Executive Board.</p>
                                  </li>
                                  <li>
                                      <h5>Casual vacancies</h5>
                                      <p>Whenever a position is vacant in an inter-election period, the President has to consult the Executive Board for a replacement and by common agreement appoint another person to hold that position.</p>
                                  </li>
                                  <li>
                                      <h5>Removal of Executive Board members</h5>
                                      <p>A member of the Executive Board shall be removed when he or she fails to keep any constitutional or ethical guidelines of the Association.</p>
                                  </li>
                                  <li>
                                      <h5>The Executive Board meetings and quorum</h5>
                                      <p>The plenum of the Global Communication Research Association’s Executive Board will he held every two years, in coincidence with the Global Communication Research Association’s international conference. There will be quorum when more than half of the members are present. Nevertheless, when circumstances do not allow the holding of a physical plenum, any decision making will be based on consultation and consensus reached via email, telephone, or other viable means.</p>
                                  </li>
                                   <li>
                                      <h5>Appointment of association members as EB members to constitute quorum</h5>
                                      <p>In case there is no quorum, other Association members could be appointed by the President, following previous consultation with other Executive Board members,</p>
                                  </li>
                                   <li>
                                      <h5>Use of technology at committee meetings</h5>
                                      <p>Whenever needed and possible, the Executive Board shall meet online, via Facebook, skype or other means, such as a WhatsApp group and communicate via chat or video chat. The Executive Board shall also communicate via E-mail. The key to a fluid communication is that members respond to messages in real time so as to do the appropriate follow ups in time, both efficiently and effectively.</p>
                                  </li>
                                  <li>
                                      <h5>Delegation by committee to sub-committee</h5>
                                      <p>The Executive Board may create sub-committees that need to be chaired by members of the EB but may include other voting members.</p>
                                  </li>
                                  <li>
                                      <h5>Voting and decisions</h5>
                                      <p>Votes are held when key decisions call for them. These decisions include policy making and change; legal and ethical themes; membership resignation or change due to health or other conditions.</p>
                                  </li>
                              </ol>
                            </div>
                            <!-- Part 3 End  -->
                            <!-- Part 4 start  -->
                            <div>
                                 <h2 class="text-primary"> PART 4 - General Meetings </h2>
                                <ol type="1" start="26" class="m-l15">
                                    <li>
                                        <h5>Annual general meetings - holding of</h5>
                                        <p>The Executive Board shall meet every year, online or, whenever possible, in a physical location. The guidelines under clause 20 apply here too.</p>
                                    </li>
                                    <li>
                                        <h5>Annual general meetings - calling of and business at</h5>
                                        <p>These meetings will be held to talk about policy and actions, to assess plans achievements and other matters concerning the members’ activities.</p>
                                    </li>
                                    <li>
                                        <h5>Special general meetings - calling of</h5>
                                        <p>The Executive Board shall be called for general meetings whenever there is urgent need for such a meeting. Urgency will be defined under rules to be developed by the Executive Board.</p>
                                    </li>
                                    <li>
                                        <h5>Notice</h5>
                                        <p>All notices for the Global Communication Research Association´s plans shall be communicated via electronic or physical means, utilizing those available and viable connections, especially through its website.</p>
                                    </li>
                                    <li>
                                        <h5>Quorum for general meetings</h5>
                                        <p>The Executive Board is composed of seven persons (1 President; 2 Vice-Presidents; 1 Secretary General; 1 Treasurer; 1 Founder; past-Presidents, 1 Editor - Journal of Global Communication1. To have a quorum means the presence of four members. In case of online meetings, for any decision making the President will contact all members and will try to get feedback of each member,</p>
                                    </li>
                                    <li>
                                        <h5>Presiding member</h5>
                                        <p>All the international events organized and carried out by the Global Communication Research Association shall be led by the current President. In cases that do not allow its presence, the President will designate a member of the Executive Board, to act as the representative of the President.</p>
                                    </li>
                                    <li>
                                        <h5>Adjournment</h5>
                                        <p>Any adjournment of assignments, events, activities of the Global Communication Research Association shall be notified timely and properly so as to avoid any inconveniences to everyone.</p>
                                    </li>
                                    <li>
                                        <h5>Making of decisions</h5>
                                        <p>Decisions will be made as spelled out in section No. 24.</p>
                                    </li>
                                    <li>
                                        <h5>Special resolutions</h5>
                                        <p>All special resolutions, amendments of this Constitution, and legal related matters will be elaborated and approved by the Executive Board.</p>
                                    </li>
                                    <li>
                                        <h5>Voting</h5>
                                        <p>Voting sessions will be held either physically or via electronic means.</p>
                                    </li>

                                    <li>
                                        <h5>Proxy votes not permitted</h5>
                                        <p>Only life members, Executive Board members, and associate members shall be allowed to vote.</p>
                                    </li>
                                    <li>
                                        <h5>Postal or electronic ballots</h5>
                                        <p>Each member will be notified by email or social online network when elections are held.</p>
                                    </li>
                                    <li>
                                        <h5>Use of technology at general meetings</h5>
                                        <p>The Global Communication Research Association having global reach, will be highly based on the use of technology, which enhance communication, exchange, and notifications among members and the public.</p>
                                    </li>
                                </ol>
                            </div>
                            <!-- Part 4 End  -->
                            <!-- Part 5 start  -->
                            <div>
                               <h2 class="text-primary"> PART 5 - Miscellaneous </h2>
                              <ol type="1" start="39" class="m-l15">
                                  <li>
                                      <h5>Insurance</h5>
                                      <p>It is optional that the current President insures any property of the Global Communication Research Association. It may include computers, electronic devices and archives.</p>
                                  </li>
                                  <li>
                                      <h5>Funds – source</h5>
                                      <p>The Global Communication Research Association shall search for funding for its administrative and functional activities, such as holding meetings, carrying out seminars, conferences and the like. It could also search for funds to pursue joint research projects on specific topics. This will be part of its priorities.</p>
                                  </li>
                                  <li>
                                      <h5>Funds - management</h5>
                                      <p>All funds shall be held in a reliable bank and kept in account of income, expenditure, deposits, and other amenities. In this regard, the treasurer will have a bank account in the name of the Global Communication Research Association. The President, in his residing country and city, will have another bank account to avoid transfer costs and for practical matters. All financial movements should be reported and made available to all members. Regarding the Journal of Global Communication, the Editor should be in direct contact with the Treasurer for income, transactions, agreements of financial management.</p>
                                  </li>
                                  <li>
                                      <h5>Association is non-profit</h5>
                                      <p>The Global Communication Research Association is a non-profit organization. Its aim is not to make money, but to provide a service to researchers, communication initiatives and activities.</p>
                                  </li><li>
                                      <h5>Distribution of property on winding up of association</h5>
                                      <p>Should the Association wind up, all properties shall be donated to charitable organizations.</p>
                                  </li>
                                  <li>
                                      <h5>Change of name, objects and constitution</h5>
                                      <p>In case of need to make any change or modification of name, objects and constitution, the plenum of the Executive Board must agree.</p>
                                  </li>
                                  <li>
                                      <h5>Custody of books etc.</h5>
                                      <p>The custody of books, archives, and documents of the Global Communication Research Association will be under the Secretary General. Copies (physical or electronic) should be with the President.</p>
                                  </li>
                                  <li>
                                      <h5>Inspection of books etc.</h5>
                                      <p>Occasionally, it will be necessary to carry out inspection of books by members of the Global Communication Research Association, as well as, in case of managing funds, have a biannual audit by an external source. The inspection of books is a principle of good governance and accountability.</p>
                                  </li>
                                  <li>
                                      <h5>Service of notices</h5>
                                      <p>The service of notices shall be made by electronic or physically means, considering the circumstances and context. Members ought to use viable ways to ensure the notice is served. The service shall include proper identification, date and signature of the sender.</p>
                                  </li><li>
                                      <h5>Financial year</h5>
                                      <p>The Global Communication Research Association will have its funds audited biannually and shall update about funds movements to Executive Board members annually. The Treasurer will work on such matters keeping a fluent contact with the members of the Executive Board.</p>
                                  </li>
                              </ol>
                            </div>
                            <!-- Part 5 End  -->
                        	
                        </div>
                        
                        
                        
                    </div>
                </div>
            </div>   
            <!-- ABOUT COMPANY SECTION END -->
                                
        </div>
        <!-- CONTENT END -->
        
        <!-- FOOTER START -->
        <?php include('include/footer.php');?>
        <!-- FOOTER END -->
        
       
        
    </div>
    

<!-- JAVASCRIPT  FILES ========================================= --> 
<script type="text/javascript"  src="js/jquery-1.12.4.min.js"></script><!-- JQUERY.MIN JS -->
<script type="text/javascript"  src="js/bootstrap.min.js"></script><!-- BOOTSTRAP.MIN JS -->
<script type="text/javascript"  src="js/bootstrap-select.min.js"></script><!-- FORM JS -->
<script type="text/javascript"  src="js/jquery.bootstrap-touchspin.min.js"></script><!-- FORM JS -->
<script type="text/javascript"  src="js/magnific-popup.min.js"></script><!-- MAGNIFIC-POPUP JS -->
<script type="text/javascript"  src="js/waypoints.min.js"></script><!-- WAYPOINTS JS -->
<script type="text/javascript"  src="js/counterup.min.js"></script><!-- COUNTERUP JS -->
<script type="text/javascript"  src="js/waypoints-sticky.min.js"></script><!-- COUNTERUP JS -->
<script type="text/javascript" src="js/isotope.pkgd.min.js"></script><!-- MASONRY  -->
<script type="text/javascript"  src="js/owl.carousel.min.js"></script><!-- OWL  SLIDER  -->
<script type="text/javascript"  src="js/stellar.min.js"></script><!-- PARALLAX BG IMAGE   --> 
<script type="text/javascript"  src="js/scrolla.min.js"></script><!-- ON SCROLL CONTENT ANIMTE   --> 
<script type="text/javascript"  src="js/custom.js"></script><!-- CUSTOM FUCTIONS  -->

 
</body>
</html>
