<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link href="css/all.css" rel="stylesheet">
    <link rel="shortcut icon" href="images/favicon.png" type="image/x-icon">
    <link rel="icon" href="images/favicon.png" type="image/x-icon">
    <title>Financing Energy Efficiency at MSMEs | Home</title>
    <meta name="keywords" content="" />
    <meta name="description" content="">
</head>

<body>
    <?php include('include/header.php'); ?>


    <section class="breadcrumb-area">
        <div class="container">
            <div class="row">
                <div class="col-xl-12">
                    <div class="inner-content clearfix">
                        <div class="title_breadcrumb float-left">
                            <h1>About Us</h1>
                        </div>
                        <div class="breadcrumb-menu float-right">
                            <ul class="clearfix">
                                <li><a href="index.php">Home</a></li>
                                <li class="active">About Us</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="about-wrap pt-4 pb-5">
        <div class="container">
            <div class="row">
                <div class="col-lg-3 col-12 order-lg-2">
                    <div class="tag_point">
                        <h5>Quick Links</h5>
                        <ul>
                            <li><a href="#hand"> Hand-Holding Support</a></li>
                            <li><a href="#Financing">Financing Mechanism</a></li>
                            <li><a href="">Technology Demonstration</a></li>
                            <li><a href="">KPIs and Benchmarking</a></li>
                            <li><a href="">Energy Management System</a></li>
                            <li><a href="">Web Tools</a></li>
                            <li><a href="">Technology Centers</a></li>
                        </ul>
                    </div>
                </div>

                <div class="col-lg-9 col-12 order-lg-1">
                    <div class="about_inner">
                        <img src="./images/aboutImg.png" alt="">
                        <p class="text-justify">BEE’s MSME Programme was started in 2010. The five clusters targeted under the programme (Phase I) include Ankleshwar (Chemical), Kolhapur (Foundry), Pune (Forging), Faridabad (Mixed Industries) and Tirunelveli (Lime-kiln). Subsequently, in 2014, technical assistance (Phase II) was extended to another six clusters including Ludhiana, Dehradun, Thane, Delhi-NCR, Varanasi (Mixed industries) and Sri Ganganagar (Brick Sector). Now, the project is forwarding the knowledge acquired from earlier phases to newer places for the benefit of the MSME fraternity. The five targeted clusters and sectors in Phase III are:</p>
                    </div>
                </div>



                <div class="col-lg-12 col-12 order-lg-3">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th scope="col">Programme</th>
                                <th scope="col">Cluster</th>
                                <th scope="col">Location</th>
                                <th scope="col">Sectors</th>
                                <!-- <th scope="col">Handle</th> -->
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th scope="row" rowspan="6" class="span_text">Phase III </th>

                            </tr>
                            <tr>
                                <td>Cluster 1</td>
                                <td>Surat, Vapi and Valsad</td>
                                <td>Paper, Textile, Chemical and Pharma</td>
                            </tr>
                            <tr>
                                <td>Cluster 2</td>
                                <td>Panipat, Kundli and Rai</td>
                                <td>Food Processing, Cold Storage, Textile and Agro</td>
                            </tr>

                            <tr>
                                <td>Cluster 3</td>
                                <td>Ludhiana, Jalandhar and Chandigarh</td>
                                <td>Mixed Industries</td>
                            </tr>

                            <tr>
                                <td>Cluster 4</td>
                                <td>Morbi & Rajkot</td>
                                <td>Ceramic, Foundry, Forging, Auto etc.</td>
                            </tr>

                            <tr>
                                <td>Cluster 5</td>
                                <td>Coimbatore, Erode, Virudachalam & Tirupur</td>
                                <td>Paper, Ceramic, Textile</td>
                            </tr>
                        </tbody>
                    </table>

                    <p>Initially, the project functioned in the energy efficiency domain. However, based on the learning, the project has shifted its focus to resource efficiency encompassing lean manufacturing, cleaner production and energy efficiency. The key activities under the project are described below:</p>
                </div>
            </div>

            <div class="row">
                <div class="col-lg-12" id="hand">
                    <h4>Hand-Holding Support</h4>
                    <p>The project provides end to end support to MSME industries spread in various parts of the country spanning diverse sectors interested in energy savings at their factory unit. This includes providing complete support right from preliminary energy audits to the implementation of energy efficiency measures which are tailor made for each industrial unit. The participating units are provided detailed information on suggested measures, their implementation timelines as well as energy saving impact on the overall financial health of the unit. With this, the general bottleneck associated with MSMEs that a single person is responsible for all the jobs is removed wherein project consultants act as partner to the unit in its energy efficiency implementation journey.</p>
                </div>

                <div class="col-lg-12" id="Financing">
                    <h4>Financing Mechanism</h4>
                    <p>MSMEs can reduce their energy consumption by investing in equipment, technologies or process improvements, which increase the energy efficiency of their facilities. SIDBI offers preferential financial assistance for investments in energy efficiency projects to existing MSMEs under a line of credit from the project, though the unit is free to approach regular bank.</p>
                    <p>Eligible MSMEs may apply for an Energy Efficiency Loan under the project by contacting local SIDBI branch or their preferred banking partner. Contact details of branch network are available at SIDBI’s website (www.sidbi.in). Further, information on energy efficiency financing schemes, loan application form and list of required supporting documents can be downloaded from this site. Company and technology-specific advice on how to reduce your company’s energy consumption can be obtained from a project appointed consultant. Additionally, the BEE offers comprehensive information on energy efficiency in their website <a href="https://www.beeindia.gov.in"> (https://www.beeindia.gov.in)</a> and this Portal.</p>
                </div>

                <div class="col-lg-12">
                    <h4>Technology Demonstration</h4>
                    <p>MSME units spread across the country practice a wide range of technologies concerning the products being manufactured at their unit. Few MSME units use new products, whereas others use age old machines/techniques/practices, which makes it difficult for them to sustain in this globally competitive market. Owing to this reason, some units outshine others because of their innovative technologies and practices. This project component aims to recognize such technologies and further promote them to create an enabling environment for easy replication in similar MSME units. The project also aims to bring the experience of touch, feel, sight and hands-on experience of technology to further promote it among relevant stakeholders across the country.</p>
                </div>

                <div class="col-lg-12">
                    <h4>KPIs and Benchmarking</h4>
                    <p>To sustain the initiatives taken under this project, a component is devised to formulate Key Performance Indicators (KPIs) and to establish benchmarks for each such energy efficiency parameter/indicator. Accordingly, the objective of this initiative is to develop sector specific energy efficiency benchmarks, which will help MSMEs in establishing their current performance level, areas for improvement, prioritize them and ways and means to improve their performance. This includes identification of sector specific</p>
                    <div class="Benchmarking_point">
                        <ul>
                            <li> Hand-Holding Support</li>
                            <li>Financing Mechanism</li>
                            <li>Technology Demonstration</li>
                            <li>KPIs and Benchmarking</li>
                            <li>Energy Management System</li>
                            <li>Web Tools</li>
                            <li>Technology Centers</li>
                        </ul>
                    </div>
                </div>

                <div class="col-lg-12">
                    <h4>Energy Management System</h4>
                    <p class="text-justify">The project recognizes the importance of energy management and aims to implement and create awareness about IS/ISO 50001 standard at the identified clusters and industrial towns to apprise the MSME unit owners/entrepreneurs regarding the benefits of implementing Energy Management System (EnMS), the process and recourses involved and further support towards training and final certification. Step by step measures like development of Standard Operating Procedure (SOPs)/Operational Control Procedures (OCPs) related to significant energy usage, its objective and targets for a unit, identification of legal and other statutory/regulatory requirements are some of the guidance areas. The project is also helping with audits by external auditors and to assist/guide the concerned units in responding to the queries raised and in settling the audit objections/observations in the most appropriate manner and help conduct Certified Internal Auditors training programmes covering two to three participants from each MSME unit. In the final stage, a consultant agency shall assist the unit by conducting Second Party Audit to confirm preparedness for Certification Audit and help conduct at least one demo Management Review Meeting (MRM) and preparing minutes thereof with culmination of providing requisite technical support to the identified units in getting their EnMS certified by an external auditing agency.</p>
                </div>

                <div class="col-lg-12">
                    <h4>Web Tools</h4>
                    <p class="text-justify">The project has developed a web tool for the assistance of energy auditors, bankers and MSME units alike. A mobile application named SIDBI REA (Resource Efficiency Assessment) has been developed for conducting resource efficiency audits and preparation of IGDPRs. The mobile application has technical formulas and methodologies built for the assistance of energy auditors and MSME units.</p>
                    <p class="text-justify">Energy auditors can use the application to assess the energy and resource saving potential of their clients by simply plugging in their measured data. The application generates a Detail Project Report (DPR) as an output for the auditor to help him in conducting their audits and save precious time required in report preparations. MSME units can also use the application for assessing their saving potential provided they have a measurement mechanism in place.</p>
                </div>

                <div class="col-lg-12">
                    <h4>Technology Centers</h4>
                    <p class="text-justify">MSME units spread across the country practice a wide range of technologies with respect to products being manufactured at their unit. Some of these are new and some use age old machines/techniques/practices, which makes it difficult for them to sustain in globally competitive market. Owing to this reason, some units outshine others because of their innovative technologies and practices. This project component aims to recognize such technologies and further promote them to create an enabling environment for easy replication in similar MSME units. The project also aims to bring the experience of touch, feel, sight and hands-on experience of technology to further promote it among relevant stakeholders across the country.</p>
                </div>

                <div class="col-lg-12">
                    <h4>Knowledge Management and Sharing</h4>
                    <p class="text-justify">The project aims to create a culture of energy and resource efficiency among the project clusters in which it is working and beyond too. This very portal is a part of the bigger GEF programmatic framework in India, where the knowledge developed under various initiatives are hosted for the benefit of MSMEs and other stakeholders. This portal hosts day to day updates from the project activities, e-newsletters, knowledge products like case studies, audio video documentaries and other cluster specific reports like best practice manuals, KPI and benchmark studies to name a few. Comprehensive list of technologies that are applicable in clusters, their suppliers as well as energy auditors/managers working therein are also listed. Cross cluster activities are also organized in the clusters to bring the best practices and technologies from relatively more advanced units and clusters to other places to help them achieve their energy saving targets.</p>
                    <p class="text-justify">Additionally, training workshops for energy professionals, auditors and engineering students are being organized in various sectors at the state-of-the-art training facility of National Productivity Council, Chennai. The objective of these training programmes is to bring the latest energy related initiatives available to the participating energy professionals in the most practical hands-on manner.</p>
                    <p class="text-justify">The role of MSMEs in India’s economic growth story cannot be over-emphasized. However, the latest census of MSMEs in India reflects a downward trend in its contribution towards gross domestic production and total manufacturing output. To reverse this trend and make MSMEs more competitive, initiatives such as skill development, technical assistance and ease of financing for the MSME sector should be made more prudent and aligned with MSMEs working.</p>
                </div>

            </div>

        </div>
    </section>

    <style>
        .table td,
        .table th {
            padding: .75rem;
            vertical-align: top;
            /* border-top: 1px solid #dee2e6; */
            border: 1px solid #dee2e6;
        }

        .table thead th {
            vertical-align: bottom;
            border-bottom: 0px !important;
        }

        .table thead th {
            vertical-align: bottom;
            border-bottom: 0px !important;
            background: #262a8a;
            color: #fff;
        }

        .table td,
        .table th {
            padding: .75rem;
            vertical-align: top;
            /* border-top: 1px solid #dee2e6; */
            border: 1px solid #dee2e6;
            background: #1da0541f;
        }

        .table td,
        .table th {
            padding: .75rem;
            vertical-align: top;
            /* border-top: 1px solid #dee2e6; */
            border: 0px;
        }
        .Benchmarking_point ul
        {
            margin-left: 20px;
        }
        .Benchmarking_point ul li {
            font-size: 14px;
            margin: 13px 0px;
            padding: 0px 18px;
            position: relative;
            display: flex;
            align-items: center;
        }

        .Benchmarking_point ul li::before
        {
            content: '\f138';
            font-family: "Font Awesome 5 Free";
            position: absolute;
            width: 10px;
            height: 10px;
            color: black;
            display: flex;
            justify-content: center;
            align-items: center;
            left: 0px;
            font-size: 10px;
            font-weight: 600;
            color: #1b0b6d;
        }
    </style>


    <!--Newsletter Start-->

    <div class="newsletter-wrap wow fadeInUp">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="title">
                        <h3 class="text-white"><small>Stay in Loop</small><br> Join our Newsletter</h3>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="news-info">
                        <form>
                            <div class="input-group">
                                <input type="text" class="form-control" name="search" placeholder="Your Email Address">
                                <div class="form_icon"><i class="fas fa-envelope"></i></div>
                            </div>
                            <input type="submit" class="sigup" value="Subscribe">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--Newsletter End-->



    <?php include('include/footer.php'); ?>
    <script src="js/all.js"></script>
    <script src="js/script.js"></script>
    <script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key=AIzaSyA5-ed0P7eZL44UHUnOF_WB-BN3XaUk4zk&callback=initMap&sensor=false&region=IN"></script>
    <script type="text/javascript">
        var markers = [{
                "title": 'Pune',
                "lat": '18.5196',
                "lng": '73.8553',
                "description": 'Pune is a mixed cluster in Maharastra <a href="abc.php">Read More</a>',
                "icon": 'https://lav.indevconsultancy.com/energy/d17/images/icons/mixed-industries.png'
            },
            {
                "title": 'Navi Mumbai',
                "lat": '18.990713',
                "lng": '73.116844',
                "description": 'Navi Mumbai is Foundry Cluster in Maharastra <a href="abc.php">Read More</a>',
                "icon": 'https://lav.indevconsultancy.com/energy/d17/images/icons/foundry.png'
            }
        ];
        window.onload = function() {
            LoadMap();
        }

        function LoadMap() {
            var mapOptions = {
                center: new google.maps.LatLng(markers[0].lat, markers[0].lng),
                zoom: 6,
                mapTypeId: google.maps.MapTypeId.ROADMAP
            };
            var map = new google.maps.Map(document.getElementById("dvMap"), mapOptions);

            //Create and open InfoWindow.
            var infoWindow = new google.maps.InfoWindow();

            for (var i = 0; i < markers.length; i++) {
                var data = markers[i];
                var myLatlng = new google.maps.LatLng(data.lat, data.lng);
                var marker = new google.maps.Marker({
                    position: myLatlng,
                    map: map,
                    title: data.title,
                    icon: data.icon
                });

                //Attach click event to the marker.
                (function(marker, data) {
                    google.maps.event.addListener(marker, "click", function(e) {
                        //Wrap the content inside an HTML DIV in order to set height and width of InfoWindow.
                        infoWindow.setContent("<div style = 'width:200px;min-height:40px'>" + data.description + "</div>");
                        infoWindow.open(map, marker);
                    });
                })(marker, data);
            }
        }
    </script>

    <script>
        (function($) {
            // $('.accordion > a').addClass('active').next().slideDown();
            $('.accordion > a:eq(0) a').addClass('active').next().slideDown();


            $('.accordion a').click(function(j) {
                // var dropDown = $(this).closest('a').find('a');

                if ($(this).hasClass('active')) {
                    $(this).removeClass('active');
                } else {
                    $(this).closest('.accordion').find('a.active').removeClass('active');
                    $(this).addClass('active');
                }
                dropDown.stop(false, true).slideToggle();
                j.preventDefault();
            });
        })(jQuery);
    </script>
</body>

</html>