/*
All of the code within the ZingChart software is developed and copyrighted by ZingChart, Inc., and may not be copied,
replicated, or used in any other software or application without prior permission from ZingChart. All usage must coincide with the
ZingChart End User License Agreement which can be requested by email at support@zingchart.com.

Build 2.9.8
*/
if(typeof(ZC)==="undefined"){if(window.ZC={AV:function(e,i){if(e.indexOf)return e.indexOf(i);for(var t=0,n=e.length;t<n;t++)if(e[t]===i)return t;return-1},VERSION:"2.9.8",VERSIONID:"2.9.8.2021.12.10",LICENSEKEY:"",ABV:!1,CHARTS:["null","null3d","line","line3d","vline","area","area3d","varea","bar","bar3d","vbar","vbar3d","hbar","hbar3d","scatter","hscatter","bubble","hbubble","pie","pie3d","ring","ring3d","nestedpie","mixed","mixed3d","hmixed","radar","bullet","vbullet","hbullet","funnel","vfunnel","hfunnel","piano","heatmap","stock","range","vrange","gauge","venn"],EQUIV:{floatbar:["vfloatbar","hfloatbar"],boxplot:["vboxplot","hboxplot"],waterfall:["vwaterfall","hwaterfall"],populationpyramid:["population-pyramid","pop-pyramid"],bubblepie:["bubble-pie","bubblepie"],bar:["column","vbar"],radar:["polar","radar"],stream:["vstream"]},ALIAS:{ring:"pie"},execFn:function(e,i){var t=[].slice.call(arguments).splice(2);return ZC.evalFn(e,i).apply(i,t)},evalFn:function(e,i){for(var t=e.split("."),n=t.pop(),a=0;a<t.length;a++)i=i[t[a]];return i[n]},cache:{data:{},size:0,add:function(e,i){ZC.cache.data[e]=i,ZC.cache.size++,ZC.cache.size>2048&&(ZC.cache.data={},ZC.cache.size=0)}},DEBUG:0,TS:{},MAX:Number.MAX_VALUE,IMG404:[],BLANK:"data:image/gif;base64,R0lGODlhAQABAIAAAP///wAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==",TTLOCK:!1,REFRESH_TICK:{},ASYNC_TICK:[],COLORS:[],SEQ:0,LOGO_ABOUT:"data:image/png;base64,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",IMAGES:{"zc.logo":"data:image/gif;base64,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"},hosted:!1,adapter:"",flash:null,canvas:null,svg:null,vml:null,move:!1,objmove:!1,compat:function(){ZC.flash=ZC.canvas=ZC.svg=ZC.vml=!1;var e=!!document.createElement("canvas").getContext,i=!1;e&&(i="function"==typeof document.createElement("canvas").getContext("2d").fillText);ZC.canvas=e&&i,ZC.svg=document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure","1.1");var t=document.body.appendChild(document.createElement("div")),n=document.createElement("zcv:shape");n.className="zcvml",n.setAttribute("id","vml_flag1"),n.setAttribute("adj",new Object),t.appendChild(n),n.style.behavior="url(#default#VML)",ZC.vml=!n||"object"==typeof n.adj,t.parentNode.removeChild(t);var a=!1;navigator.mimeTypes&&navigator.mimeTypes["application/x-shockwave-flash"]?a=navigator.mimeTypes["application/x-shockwave-flash"].enabledPlugin:document.all&&-1===navigator.appVersion.indexOf("Mac")&&(a=new Function('try { var xObj = new ActiveXObject("ShockwaveFlash.ShockwaveFlash");if (xObj) { xObj = null; return true; } } catch (e) { return false; }')()),ZC.flash=a?1:0},quirks:!(document.compatMode&&"CSS1Compat"===document.compatMode),ie67:!!/MSIE (\d+\.\d+);/.test(navigator.userAgent)&&parseFloat(RegExp.$1)<8,ie678:!!/MSIE (\d+\.\d+);/.test(navigator.userAgent)&&parseFloat(RegExp.$1)<9,mobile:/Mobile|BlackBerry|Opera Mini|PPC|Windows CE|Android/.test(navigator.userAgent),ipad:/iPad/.test(navigator.userAgent),iphone:/iPhone/.test(navigator.userAgent),websockets:"WebSocket"in window,webstorage:"sessionStorage"in window,RH:[],WI:[],E1:[0,0],ACO:null,_cp_:function(e,i,t,n,a,l){null===ZC._n_(t)&&(t=!0),null===ZC._n_(n)&&(n=!0),null===ZC._n_(a)&&(a=!1);var o=(l=l||[]).length;for(var r in e)if(0===o||o>0&&-1===ZC.AV(l,r))if(e[r]instanceof Array){if(n){(null===ZC._n_(i[r])||"override"!==r&&!a)&&(i[r]=[]);for(var s=0,A=e[r].length;s<A;s++)i[r].push(e[r][s])}}else e[r]instanceof Object&&!(e[r]instanceof Function)?n&&(null===ZC._n_(i[r])&&(i[r]={}),i[r]instanceof Object&&!(i[r]instanceof Function)&&ZC._cp_(e[r],i[r],t)):(null===ZC._n_(i[r])||t)&&(i[r]=e[r])},_cpa_:function(e,i){i||(i=[]);for(var t=0,n=e.length;t<n;t++)i.push(e[t])},_inj_:function(e,i){var t={};ZC._cp_(e,t),ZC._cp_(i,e),ZC._cp_(t,e)},_todash_:function(e,i,t){if("dashed"!==zingchart.SYNTAX){void 0===i&&(i=!0);var n,a,l=(t=t||[]).length;for(var o in e)if(e.hasOwnProperty(o)&&(0===l||l>0&&-1===ZC.AV(t,o))){var r=o.substring(0,1);if("."!==r&&"#"!==r)if(e[o]instanceof Array)if(ZC.UJ(o)!==o){for(e[ZC.UJ(o)]=[],n=0,a=e[o].length;n<a;n++)ZC._todash_(e[o][n]),e[ZC.UJ(o)].push(e[o][n]);delete e[o]}else for(n=0,a=e[o].length;n<a;n++)ZC._todash_(e[o][n]);else e[o]instanceof Object&&!(e[o]instanceof Function)?(ZC.UJ(o)!==o&&(e[ZC.UJ(o)]={},ZC._cp_(e[o],e[ZC.UJ(o)]),delete e[o]),i&&ZC._todash_(e[ZC.UJ(o)],i,t)):ZC.UJ(o)!==o&&(e[ZC.UJ(o)]=e[o],delete e[o])}}},ZO:function(e,i){for(var t in e){var n;if(e.hasOwnProperty(t))if((n=t.replace(i+"-",""))!==t)if(e[n]=e[t],e[t]instanceof Array)for(var a=0,l=e[t].length;a<l;a++)ZC.ZO(e[t][a],i);else e[t]instanceof Object&&!(e[t]instanceof Function)&&ZC.ZO(e[t],i)}},A9U:function(e){for(var i="",t=0,n=e.length;t<n;t++){var a=t%2==0?t:e.length-t;i+=e.substring(a,a+1)}return i=i.replace(/\./g,"d")},AD8:function(e){var i=e;return i=(i=(i=i.replace("*","&")).replace("9","3")).replace("l","1")},A9G:function(e){return e.replace(/[a-zA-Z]/g,function(e){return String.fromCharCode((e<="Z"?90:122)>=(e=e.charCodeAt(0)+13)?e:e-26)})},ACA:function(e,i){var t=ZC.X0(ZC.ABX(e)),n=ZC.X0(ZC.A1Z(i)),a=t.length;if(0===a)return"";for(var l,o,r=t[a-1],s=t[0],A=2654435769,C=Math.floor(6+52/a)*A;0!==C;){o=C>>>2&3;for(var c=a-1;c>0;c--)l=((r=t[c-1])>>>5^s<<2)+(s>>>3^r<<4)^(C^s)+(n[3&c^o]^r),s=t[c]-=l;l=((r=t[a-1])>>>5^s<<2)+(s>>>3^r<<4)^(C^s)+(n[3&c^o]^r),s=t[0]-=l,C-=A}return decodeURIComponent(ZC.ABT(ZC.A5X(t)))},AEU:function(e,i){e=encodeURIComponent(e);var t=ZC.X0(ZC.A1Z(e)),n=ZC.X0(ZC.A1Z(i)),a=t.length;if(0===a)return"";1===a&&(t[a++]=0);for(var l,o,r=t[a-1],s=t[0],A=Math.floor(6+52/a),C=0;A-- >0;){o=(C+=2654435769)>>>2&3;for(var c=0;c<a-1;c++)l=(r>>>5^(s=t[c+1])<<2)+(s>>>3^r<<4)^(C^s)+(n[3&c^o]^r),r=t[c]+=l;l=(r>>>5^(s=t[0])<<2)+(s>>>3^r<<4)^(C^s)+(n[3&c^o]^r),r=t[a-1]+=l}return ZC.ABW(ZC.A5X(t))},X0:function(e){for(var i=new Array(Math.ceil(e.length/4)),t=0;t<i.length;t++)i[t]=e[4*t]+(e[4*t+1]<<8)+(e[4*t+2]<<16)+(e[4*t+3]<<24);return i},A5X:function(e){for(var i=[],t=0;t<e.length;t++)i.push(255&e[t],e[t]>>>8&255,e[t]>>>16&255,e[t]>>>24&255);return i},ABW:function(e){for(var i="",t=["0","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f"],n=0;n<e.length;n++)i+=t[e[n]>>4]+t[15&e[n]];return i},ABX:function(e){for(var i=[],t="0x"===e.substr(0,2)?2:0;t<e.length;t+=2)i.push(parseInt(e.substr(t,2),16));return i},ABT:function(e){for(var i="",t=0;t<e.length;t++)0!==e[t]&&(i+=String.fromCharCode(e[t]));return i},A1Z:function(e){for(var i=[],t=0;t<e.length;t++)i.push(e.charCodeAt(t));return i},_i_:function(e){return-1!==String(e).indexOf("e-")?0:""===(e=String(e).replace(/[^0-9\.\-]/gi,""))?0:Math.round(e)},_f_:function(e){return e=parseFloat(e),isNaN(e)?0:e},_x_:function(e,i){return void 0===i&&(i=2),parseFloat(Number(e).toFixed(i))},_a_:function(e){return Math.abs(e)},_b_:function(e){return"false"!==e&&"0"!==e&&("true"===e||"1"===e||!!e&&!0)},_p_:function(e){var i=(e=String(e).replace(/[^0-9\.\%\-]/gi,"")).indexOf("%");return-1!==i&&(e=e.substring(0,i),e=ZC._f_(e)/100),e},_h_:function(e){return window.toStaticHTML?window.toStaticHTML(e):e},_n_:function(e){return null===e||void 0===e?null:e},_c_:function(e,i){return null===e||void 0===e?i:e},_ang_:function(e){return(e%=360)<0&&(e+=360),e},II:function(e,i){return ZC._f_(e)+""==e+""?i?ZC._f_(e):ZC._a_(e):-1!==(e+="").indexOf("%")?ZC._f_(e.replace("%",""))/100:-1!==e.indexOf("px")?ZC._f_(e.replace("px","")):ZC._f_(e)},QX:function(e){return parseInt(e,16)},OT:function(e){return ZC._i_(e).toString(16)},_r_:function(e,i){return parseInt(e+(i-e)*Math.random(),10)},_l_:function(e,i,t){return e=(e=e<i?i:e)>t?t:e},DS:function(e,i,t,n){return n?i<e&&e<t||t<e&&e<i:i<=e&&e<=t||t<=e&&e<=i},BQ:function(e,i){return Math.max(e,i)},CY:function(e,i){return Math.min(e,i)},A1L:function(e,i){null===ZC._n_(i)&&(i=!1);for(var t=0,n=e.length,a=-Number.MAX_VALUE;t<n;t++)i&&0==e[t]||(a=Math.max(a,e[t]));return a},XY:function(e,i){null===ZC._n_(i)&&(i=!1);for(var t=0,n=e.length,a=Number.MAX_VALUE;t<n;t++)i&&0==e[t]||(a=Math.min(a,e[t]));return a},_rcolor_:function(){for(var e=(16777215*Math.random()+1<<0).toString(16);e.length<6;)e="0"+e;return"#"+e},AAA:function(e,i){for(var t,n=ZC._f_(i),a=Number.MAX_VALUE,l=0,o=0,r=e.length;o<r;o++)(t=Math.abs(ZC._f_(e[o])-n))<a&&(l=o,a=t);return l},AEK:function(e){var i=e.split(".");return i[i.length-1]||""},GV:function(e){return e.replace(/^\s\s*/,"").replace(/\s\s*$/,"")},G6:function(e,i){return i=i||Math.E,isFinite(Math.log(e)/Math.log(i))?Math.log(e)/Math.log(i):0},TK:function(e){return 360*e/(2*Math.PI)},T1:function(e){return 2*e*Math.PI/360},EH:function(e){return Math.cos(ZC.T1(e))},EP:function(e){return Math.sin(ZC.T1(e))},P5:function(e){return!isNaN(parseFloat(e))&&isFinite(e)},EE:function(e){return-1!==e.indexOf("-")?e.replace(/(\-[a-z0-9])/g,function(e){return e.toUpperCase().replace("-","")}):e},UJ:function(e){return e.toUpperCase()!==e&&-1===e.indexOf("-")&&e.substring(0,1).toLowerCase()===e.substring(0,1)?e.replace(/([A-Z])/g,function(e){return"-"+e.toLowerCase()}).replace(/([0-9]+)/g,function(e){return"-"+e.toLowerCase()}).replace("-3d","3d"):e},AEL:function(e){return ZC.XK.md5(e)},AK:function(e){return document.getElementById(e)},A1H:function(e,i){return e[0].length<i[0].length?1:e[0].length>i[0].length?-1:0},ZJ:function(e){window.setTimeout(e,zingchart.TIMEOUT)},_fixed_:function(e,i){return i>=0&&i<=20?e.toFixed(i):""+e},_nfind_:function(e,i,t,n){var a=i.S[t].BT,l=i.S[n].BT;if(e==a)return t;if(e==l)return n;var o=ZC._i_((t+n)/2);if(!i.S[o]){for(;!i.S[o]&&o<n;)o++;if(o===n){for(o=ZC._i_((t+n)/2);!i.S[o]&&o>t;)o--;if(o===t)return null}}var r=i.S[o].BT;return o!==t&&o!==n?e==r?o:e>r?ZC._nfind_(e,i,o,n):ZC._nfind_(e,i,t,o):e==r?o:null},_tx_:function(e){var i,t,n,a,l=[1,1,0,0];if(zingchart.DEV.LOOKUPCSSTRANSFORM&&!ZC.vml&&ZC.AK(e)){var o=ZC.AK(e);for(i="";o&&(""===i||"none"===i);)i=ZC.A5(o).css("transform")||"",o=o.parentNode;-1!==(t=i.indexOf("matrix("))&&(n=i.indexOf(")",t),a=i.substring(t+7,n-t).split(","),l=[ZC._f_(a[0]),ZC._f_(a[3]),ZC._f_(a[4]),ZC._f_(a[5])])}return l},Utils_SetupFormat:function(e,i){return ZC.AP.O3(e,i)},Utils_Format:function(e,i,t,n){return ZC.AP.G2(e,i,t,n)},Loader_Api_Loader_Info:function(e){return e.FE()}},ZC.hasPassive=!1,ZC.SEC=1e3,ZC.MIN=60*ZC.SEC,ZC.HR=60*ZC.MIN,ZC.DAY=24*ZC.HR,ZC.MON=30*ZC.DAY,ZC.YR=365*ZC.DAY,ZC.MAPTX=0,window.JSON=window.JSON||{},JSON.stringify=JSON.stringify||function(e){var i=typeof e;if("object"!==i||null===e)return"string"===i&&(e='"'+e.replace("\\","\\\\").replace('"','"')+'"'),String(e);var t,n,a=[],l=e&&e.constructor===Array;for(t in e)"function"!=typeof e[t]&&("string"===(i=typeof(n=e[t]))?n='"'+n.replace("\\","\\\\").replace('"','\\"')+'"':"object"===i&&null!==n&&(n=JSON.stringify(n)),a.push((l?"":'"'+t+'":')+String(n)));return(l?"[":"{")+String(a)+(l?"]":"}")},JSON.parse=JSON.parse||function(KV){return""===KV&&(KV='""'),eval("("+KV+")")},function(){var e=!1,i=/xyz/.test(function(){xyz})?/\bb\b/:/.*/;ZC.C9=function(){},ZC.C9.CA=function(t){var n=this.prototype;e=!0;var a=new this;for(var l in e=!1,t)a[l]="function"==typeof a[l]&&"function"==typeof n[l]&&i.test(t[l])?function(e,i){return function(){var t=this.b;this.b=n[e];var a=i.apply(this,arguments);return this.b=t,a}}(l,t[l]):t[l];function o(){!e&&this.$i&&this.$i.apply(this,arguments)}return o.prototype=a,o.constructor=o,o.CA=arguments.callee,o}}(),ZC.AAT=function(e){this.H=e,this.A9B=function(e,i){var t,n=this,a=n.B8.palette;if(null!==ZC._n_(i)&&null!==ZC._n_(a[i])&&(a=a[i]),null!==ZC._n_(a[e])){var l=a[e];return null===ZC._n_(l[2])&&(l[2]=ZC.AP.QU(l[1],10)),null===ZC._n_(l[3])&&(l[3]=ZC.AP.QU(l[1],10)),l}var o=["#00BAF2","#E80C60","#E2D51A","#9B26AF","#FB301E","#00AE4D","#20398B"];t=null!==ZC._n_(o[e-n.B8.palette.length])?o[e-n.B8.palette.length]:"#"+ZC.XK.md5(e).substr(e%20,6);var r=ZC.AP.QU(t,10),s=ZC.AP.QU(t,20),A="#FFF";return n.B8.palette&&n.B8.palette[0]&&n.B8.palette[0][0]&&(A=n.B8.palette[0][0]),[A,t,r,s]},this.A8S=function(e){e&&ZC._cp_(e,this.B8,!0)},this.AAY=function(e){var i=this;null!==ZC._n_(i.NY[e])&&(ZC._todash_(i.NY[e]),ZC._cp_(i.NY[e],i.B8))},this.NY={},ZC._cp_(zingchart.THEMES,this.NY),this.NY.classic={palette:[["#fff","#6a921f","#a7da47","#89b92e"],["#fff","#007fa3","#00b0e1","#0392bb"],["#fff","#a62b02","#ef4810","#cc3300"],["#fff","#b79007","#f9c332","#da9b04"],["#fff","#563d02","#84680a","#6e4503"],["#fff","#0b32a0","#4d62b1","#1540a0"]],graph:{refresh:{curtain:{alpha:.5,"background-color":"#999",color:"#000","font-size":15,bold:1,text:"Loading..."}},"background-color":"#e1eaec #edf3f5",title:{"font-size":14,bold:1,color:"#fff","background-color":"#00bbf1 #05a0cd",padding:6},subtitle:{"font-size":11,bold:1,color:"#333","margin-top":30,padding:6},source:{"font-size":10,color:"#333",width:"100%",bold:1,"text-align":"right",height:20,margin:"auto 0 0 auto",padding:5},nodata:{"font-size":12,color:"#333","text-align":"center","vertical-align":"middle",text:""},SCALE:{"font-size":11,"line-width":2,"line-color":"#3e6c7b",item:{flat:!0},"ref-line":{"line-width":1,"line-color":"#3e6c7b"},guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#2c4a59",alpha:.2},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#aaa",alpha:.1},tick:{visible:1,size:6,placement:"outer","line-width":2,"line-color":"#3e6c7b"},"minor-tick":{visible:1,size:4,placement:"outer","line-width":1,"line-color":"#3e6c7b"},label:{color:"#2c4a59",flat:!0}},"scroll-x":{bar:{height:16},handle:{height:16}},"scroll-y":{bar:{width:16},handle:{width:16}},legend:{"background-color":"#fff","border-width":1,alpha:.75,"border-alpha":.75,"border-color":"#666","shadow-distance":3,header:{padding:"4 6",color:"#fff","border-width":1,"border-color":"#3e6c7b","background-color":"#3e6c7b"},footer:{padding:"2 6","background-color":"#ccc","border-width":1,"border-color":"#666"},marker:{"border-color":"#333","border-width":1}},plot:{"value-box":{flat:!0},marker:{shadow:1,"line-width":1,"border-width":1},"hover-marker":{"line-width":1,"border-width":1}},guide:{"line-width":1,"line-color":"#999",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{padding:"3 6"}}},line:{plot:{"shadow-alpha":.5,marker:{size:4},"hover-marker":{size:5}}},area:{plot:{"shadow-alpha":.5,marker:{size:4},"hover-marker":{size:5}}},vbar:{plot:{"fill-angle":90,shadow:0}},hbar:{plot:{"fill-angle":180,shadow:0}},piano:{plotarea:{"mask-tolerance":[0,0]},plot:{shadow:0}},stock:{plot:{shadow:0}},vbullet:{plot:{shadow:0}},hbullet:{plot:{"fill-angle":0,shadow:0}},scatter:{plot:{marker:{size:4},"hover-marker":{size:5}}},hscatter:{plot:{marker:{size:4},"hover-marker":{size:5}}},bubble:{plot:{marker:{"border-width":0},"hover-marker":{"border-width":0}}},hbubble:{plot:{marker:{"border-width":0},"hover-marker":{"border-width":0}}},pie:{plot:{"border-width":1}},nestedpie:{plot:{"border-width":1}},radar:{plot:{marker:{size:3},"hover-marker":{size:4}},"scale-k":{guide:{alpha:.5,"background-color":"#eee #ddd"}}},gauge:{"scale-r":{"background-color":"-1",guide:{alpha:.5,"background-color":"#eee #ddd"},item:{"offset-r":0},ring:{size:1,items:[{"background-color":"#999",alpha:.8},{"background-color":"#666",alpha:.8}]}}},vfunnel:{plotarea:{margin:"50 100"},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":0},"minor-guide":{"line-width":0}},"scale-y":{guide:{alpha:.25,"background-color":"-1 #58595B"}},"scale-y-n":{guide:{alpha:.25,"background-color":"-1 #58595B"}},plot:{"border-width":1}},hfunnel:{plotarea:{margin:"50 100"},"scale-x":{label:{"font-angle":270}},"scale-x-n":{label:{"font-angle":90}},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":0},"minor-guide":{"line-width":0}},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"},guide:{alpha:.25,"background-color":"#58595B -1"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"},guide:{alpha:.25,"background-color":"#58595B -1"}},plot:{"border-width":1}},range:{plot:{marker:{type:"circle",size:4},"hover-marker":{size:5}}},line3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},area3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},mixed3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},vbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},hbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},pie3d:{plot:{"border-width":1}},"-":""},this.NY.light={palette:[["#fff","#29A2CC","#29A2CC","#1089B3"],["#fff","#D31E1E","#D31E1E","#BA0505"],["#fff","#7CA82B","#7CA82B","#638F12"],["#fff","#EF8535","#EF8535","#D66C1C"],["#fff","#A14BC9","#A14BC9","#8832B0"],["#fff","#A05F18","#A05F18","#874600"],["#fff","#265E96","#265E96","#0D457D"],["#fff","#6B7075","#6B7075","#52575C"],["#fff","#96C245","#96C245","#7CA82B"]],graph:{refresh:{curtain:{alpha:.5,"background-color":"#999",color:"#000","font-size":15,bold:1,text:"Loading..."}},"background-color":"#ffffff",title:{"font-size":21,bold:1,color:"#414042","background-color":"none",padding:6},subtitle:{"font-size":11,bold:1,color:"#414042","margin-top":30,padding:6},source:{"font-size":10,color:"#414042",width:"100%",bold:1,"text-align":"right",height:20,margin:"auto 0 0 auto",padding:5},nodata:{"font-size":12,color:"#333","text-align":"center","vertical-align":"middle",text:"No Data","background-color":"#BBBBBB",alpha:.8},SCALE:{"font-size":11,"line-width":1,"line-color":"#8C8C8C",item:{"font-size":12,flat:!0,color:"#808285"},"ref-line":{"line-width":1,"line-color":"#D1D3D4"},guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#DCDCDC",alpha:1},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#aaa",alpha:.1},tick:{visible:1,size:5,placement:"outer","line-width":1,"line-color":"#8C8C8C"},"minor-tick":{visible:1,size:3,placement:"outer","line-width":1,"line-color":"#A7A9AC"},label:{color:"#414042",flat:!0}},"scale-x":{normalize:!0,guide:{visible:!1}},scroll:{bar:{"background-color":"#F0F1F1",margin:1},handle:{"background-color":"#A7A9AC","border-radius":6}},"scroll-x":{bar:{height:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{height:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-y":{bar:{width:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{width:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-xi":{bar:{width:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{width:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-yi":{bar:{height:16,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"},handle:{height:10,"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},preview:{"background-color":"#fff","border-width":1,"border-color":"#A7A9AC",live:!0,mask:{"background-color":"#999"},active:{alpha:0},handle:{width:11,"border-width":2,"border-radius":3,"line-color":"#C6C6C6","border-color":"#A7A9AC","background-color":"#F0F1F1"},"handle-top":{height:11},"handle-bottom":{height:11}},tooltip:{shadow:1,"shadow-angle":45,"shadow-distance":1,"shadow-alpha":.25,"border-width":1,"border-color":"#fff","border-alpha":1},zoom:{"preserve-zoom":1,"background-color":"#929497"},legend:{"background-color":"#fff","border-width":1,shadow:0,"shadow-alpha":.2,alpha:1,"border-alpha":1,"border-color":"#cccccc",header:{padding:"5 0 5 10",color:"#222222","background-color":"none","border-width":0,"border-top":"0px solid none","border-bottom":"1px solid #cccccc"},footer:{padding:"5 0 5 10","border-top":"1px solid #cccccc"},shader:{"background-color":"#F0F1F1","line-color":"#C6C6C6",margin:2,height:8,"line-width":2,"line-style":"dotted"},icon:{"line-color":"#C6C6C6","line-width":2,style:"small"},marker:{"border-color":"#fff","border-width":1},"page-on":{"background-color":"#929497"},"page-off":{"background-color":"#D1D2D3"},scroll:{bar:{"background-color":"none","margin-top":3,"margin-bottom":3},handle:{"background-color":"#D1D2D3","border-top":"none","border-right":"none","border-bottom":"none","border-left":"none","border-radius":6,width:12,height:12}}},plot:{"value-box":{flat:!0},marker:{shadow:0,"line-width":1,"border-width":1,"border-color":"#fff"},"hover-marker":{"line-width":1,"border-width":1},monotone:!0},guide:{"line-width":1,"line-color":"#8C8C8C",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{padding:"3 6"}}},line:{plot:{"line-width":2,shadow:0,marker:{size:4},"hover-state":{},"hover-marker":{size:5,"border-width":1,"border-color":"#fff"}}},area:{plot:{"line-width":2,shadow:0,"alpha-area":.25,"background-color-style":"solid",marker:{size:4},"hover-state":{},"hover-marker":{size:5,"border-width":1,"border-color":"#fff"}}},vbar:{plot:{"fill-angle":90,shadow:0}},hbar:{plot:{"fill-angle":180,shadow:0}},piano:{plotarea:{"mask-tolerance":[0,0]},plot:{shadow:0},"scale-x":{guide:{visible:!0}}},stock:{plot:{shadow:0}},vbullet:{plot:{shadow:0,goal:{"border-width":1,"border-color":"#fff",height:8}}},hbullet:{plot:{"fill-angle":0,shadow:0,goal:{"border-width":1,"border-color":"#fff",width:8}}},scatter:{plot:{"line-color":"%palette-0","border-color":"%palette-0",marker:{size:5},"hover-marker":{size:6}},"scale-x":{guide:{visible:!0}}},hscatter:{plot:{"line-color":"%palette-0","border-color":"%palette-0",marker:{size:4},"hover-marker":{size:5}},"scale-x":{guide:{visible:!0}}},bubble:{plot:{marker:{"border-width":1,"border-color":"#fff"},"hover-marker":{"border-width":1,"border-color":"#fff"}},"scale-x":{guide:{visible:!0}}},hbubble:{plot:{marker:{"border-width":1,"border-color":"#fff"},"hover-marker":{"border-width":1,"border-color":"#fff"}},"scale-x":{guide:{visible:!0}}},pie:{plot:{shadow:0,"border-width":1,"value-box":{placement:"in","font-size":16,text:"%node-percent-value%"}}},nestedpie:{plot:{"border-width":1}},radar:{plot:{shadow:0,"line-width":2,"background-color":"%palette-1","active-area":!0,marker:{size:4},"hover-marker":{size:5,"border-color":"#fff"}},"scale-k":{guide:{"line-width":1,"line-style":"solid","line-color":"#8C8C8C","line-segment-size":6,"line-gap-size":6,alpha:1,"background-color":"#fff #F7F8F8"},tick:{"line-color":"#8C8C8C","line-width":1,size:10}},"scale-r":{},"scale-v":{"ref-line":{"line-color":"#8C8C8C","line-width":1},tick:{"line-color":"#8C8C8C","line-width":1},guide:{"line-color":"#CDCDCD","line-width":1}}},gauge:{plot:{shadow:0},scale:{"size-factor":1},"scale-r":{aperture:270,tick:{size:11,"line-width":2},"background-color":-1,guide:{"background-color":"#fff"},ring:{size:8,"background-color":"#CDCDCD"},center:{size:20,"background-color":"#fff","border-width":6,"border-color":"#1089B3"}}},vfunnel:{plotarea:{margin:"50 100"},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":1,"line-style":"solid","line-color":"#CDCDCD","line-segment-size":6,"line-gap-size":6,alpha:1},"minor-guide":{"line-width":0}},"scale-x":{visible:!1,guide:{visible:0}},"scale-y":{guide:{"background-color":"-1",alpha:1}},"scale-y-n":{guide:{"background-color":"-1"}},plot:{"border-width":1,"border-color":"#fff",shadow:0,"hover-state":{"line-color":"-1","border-color":"-1"}}},hfunnel:{plotarea:{margin:"50 100"},"scale-x":{visible:!1,guide:{visible:0},label:{"font-angle":270}},"scale-x-n":{label:{"font-angle":90}},SCALE:{"line-width":0,tick:{"line-width":0},"minor-tick":{"line-width":0},guide:{"line-width":1,"line-style":"solid","line-color":"#CDCDCD","line-segment-size":6,"line-gap-size":6,alpha:1},"minor-guide":{"line-width":0}},"scale-y":{guide:{"background-color":"-1",alpha:1},label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"},guide:{"background-color":"-1"}},plot:{"border-width":1,"border-color":"#fff",shadow:0,"hover-state":{"line-color":"-1","border-color":"-1"}}},range:{plot:{"background-color":"%palette-1",marker:{type:"circle",size:4},"hover-marker":{size:5}}},line3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},area3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":0,"line-width":1}},mixed3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},vbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},hbar3d:{SCALE:{"line-color":"#ddd",tick:{visible:!1}},plot:{"border-width":1}},pie3d:{plot:{"border-width":1}},venn:{plot:{"border-width":0,shadow:0,alpha:.75,"background-color":"%palette-1"}},root:{gui:{"context-menu":{visible:!0,width:"125px",padding:"5 0","background-color":"#595959","border-width":0,"border-color":"#595959",position:"left",button:{visible:ZC.mobile,alpha:0},gear:{"background-color":"#000",type:"hamburger",alpha:1},item:{"background-color":"#595959","text-align":"left",padding:"4 20 4 15","border-width":0,"border-color":"#595959","font-size":"12px",color:"#fff","hover-state":{"background-color":"#414141"}},separator:{"line-width":1,"line-color":"#969696"}},"context-menu[mobile]":{item:{padding:"6 10 6 6"}}}},"-":""},this.NY.light.graph["crosshair-x"]=this.NY.light.graph["crosshair-y"]=this.NY.light.graph.guide,this.NY.dark={},ZC._cp_(this.NY.light,this.NY.dark,!0,!0),ZC._cp_({graph:{"background-color":"#221F1F",title:{color:"#fff"},subtitle:{color:"#fff"},source:{color:"#fff"},SCALE:{"line-color":"#D1D3D4",item:{color:"#D1D3D4"},"ref-line":{"line-color":"#D1D3D4"},guide:{"line-color":"#58595B"},"minor-guide":{"line-color":"#58595B"},tick:{"line-color":"#D1D3D4"},"minor-tick":{"line-color":"#D1D3D4"},label:{color:"#D1D3D4"}},scroll:{bar:{"background-color":"#6C6D70"},handle:{"background-color":"#A7A9AC"}},"scroll-x":{bar:{"border-top":"0px solid none","border-right":"2px solid #D1D3D4","border-bottom":"2px solid #D1D3D4","border-left":"2px solid #D1D3D4"},handle:{"border-top":"none","border-right":"none","border-bottom":"none","border-left":"none"}},"scroll-y":{bar:{"border-top":"2px solid #D1D3D4","border-right":"0px solid none","border-bottom":"2px solid #D1D3D4","border-left":"2px solid #D1D3D4"}},preview:{"background-color":"#221F1F"},tooltip:{"border-color":"#000"},legend:{"background-color":"#221F1F",header:{color:"#fff",shader:{"background-color":"#414042","line-color":"#676667"}},footer:{color:"#D1D3D4","background-color":"#414042","border-top":"0px solid none","border-right":"2px solid #A7A9AC","border-bottom":"2px solid #A7A9AC","border-left":"2px solid #A7A9AC"},shader:{"background-color":"#414042","line-color":"#676667"},icon:{"line-color":"#676667"},"page-status":{color:"#D1D3D4"},"page-on":{"background-color":"#D1D2D3"},"page-off":{"background-color":"#929497"},marker:{"border-color":"#000"},item:{color:"#D1D3D4"}},plot:{marker:{"border-color":"#221F1F"}},guide:{"line-color":"#D1D3D4","scale-label":{"background-color":"#929497"},"plot-label":{"background-color":"#221F1F",color:"#FFF","border-color":"#5a5a5a"}}},line:{plot:{"hover-marker":{"border-color":"#221F1F"}}},area:{plot:{"hover-marker":{"border-color":"#221F1F"}}},vbullet:{plot:{goal:{"border-color":"#221F1F"}}},hbullet:{plot:{goal:{"border-color":"#221F1F"}}},bubble:{plot:{marker:{"border-color":"#221F1F"},"hover-marker":{"border-color":"#221F1F"}}},hbubble:{plot:{marker:{"border-color":"#221F1F"},"hover-marker":{"border-color":"#221F1F"}}},pie:{plot:{"border-color":"#221F1F"}},radar:{plot:{"hover-marker":{"border-color":"#221F1F"}},"scale-k":{guide:{"line-color":"#58595B","background-color":"#221F1F #312F30"},tick:{"line-color":"#D1D3D4"}},"scale-v":{"ref-line":{"line-color":"#58595B"},tick:{"line-color":"#58595B"},guide:{"line-color":"#58595B"}}},gauge:{"scale-r":{guide:{"background-color":"#221F1F"},ring:{"background-color":"#57585B"}}},vfunnel:{SCALE:{guide:{"line-color":"#58595B"}},plot:{"border-color":"#221F1F","hover-state":{"line-color":"#58595B","border-color":"#221F1F"}}},hfunnel:{SCALE:{guide:{"line-color":"#58595B"}},"scale-y":{guide:{alpha:.25,"background-color":"#b6c8cf -1"}},"scale-y-n":{guide:{alpha:.25,"background-color":"#b6c8cf -1"}},plot:{"border-color":"#221F1F","hover-state":{"line-color":"#58595B","border-color":"#221F1F"}}},root:{gui:{"context-menu":{gear:{"background-color":"#FFF"}}}},"-":""},this.NY.dark,!0,!0),this.NY.dark.graph["crosshair-x"]=this.NY.dark.graph["crosshair-y"]=this.NY.dark.graph.guide,this.NY.mini={graph:{title:{width:"100%",padding:"1 2 2","font-size":10},subtitle:{width:"100%",padding:"1 2 2","margin-top":14,"font-size":9},plotarea:{width:"100%",height:"100%",margin:"18 4 4 4"},SCALE:{visible:0},tooltip:{shadow:0,"border-radius":7},legend:{visible:0},preview:{visible:0},guide:{"line-width":1,"line-color":"#ccc",alpha:1,"scale-label":{text:"%l",padding:"3 6"},"plot-label":{"border-color":"#ccc","border-radius":5,padding:"3 6"}},plot:{shadow:0,"value-box":{visible:0},"hover-state":{visible:0},"hover-marker":{visible:0},"max-trackers":99999,"max-nodes":99999}},line:{plot:{"line-width":1,marker:{type:"none"}}},line3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},area:{plot:{"line-width":1,marker:{type:"none"}}},area3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},scatter:{SCALE:{offset:5},plot:{marker:{size:3,shadow:!1,alpha:.8}}},hscatter:{SCALE:{offset:5},plot:{marker:{size:3,shadow:!1,alpha:.8}}},bubble:{SCALE:{offset:15},plot:{marker:{"fill-type":"none",shadow:!1,alpha:.8},"min-size":3,"max-size":9}},hbubble:{SCALE:{offset:15},plot:{marker:{"fill-type":"none",shadow:!1,alpha:.8},"min-size":3,"max-size":9}},pie:{plotarea:{margin:"18 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":.95}},pie3d:{plotarea:{margin:"32 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":1}},nestedpie:{plotarea:{margin:"18 4 4 4"},plot:{"value-box":{visible:0}},scale:{"size-factor":.95}},radar:{plotarea:{margin:"18 4 4 4"},plot:{"line-width":1,marker:{shadow:0,size:2}},scale:{"size-factor":.95}},vbar3d:{"3d-aspect":{depth:20,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0,zoom:.9}},hbar3d:{"3d-aspect":{depth:20,angle:45,"x-angle":0,"y-angle":-20,"z-angle":0,zoom:.9}},venn:{plotarea:{margin:"18 4 4 4"},plot:{"border-width":0}},gauge:{plotarea:{margin:"18 4 4 4"},plot:{indicator:[5]},SCALE:{visible:1},scale:{"size-factor":.9},"scale-r":{"background-color":"-1",aperture:270,tick:{visible:0},item:{visible:0},guide:{visible:0},ring:{size:6,"background-color":"#CDCDCD",items:[]},center:{"border-width":0,size:2,"background-color":"#fff"}}},vfunnel:{plotarea:{margin:"18 4 4 4"}},hfunnel:{plotarea:{margin:"18 4 4 4"}},vbullet:{plot:{"bar-space":.5,goal:{"border-width":0,height:4}}},hbullet:{plot:{"bar-space":.5,goal:{"border-width":0,width:4}}},range:{plot:{"line-width":1,marker:{visible:0},"hover-state":{visible:0}}},"-":""},this.NY.negative={palette:[["#000","#909090","#969696","#9c9c9c"],["#000","#a0a0a0","#a6a6a6","#acacac"],["#000","#b0b0b0","#b6b6b6","#bcbcbc"],["#000","#c0c0c0","#c6c6c6","#cccccc"],["#000","#d0d0d0","#d6d6d6","#dcdcdc"],["#000","#e0e0e0","#e6e6e6","#ececec"],["#000","#f0f0f0","#f6f6f6","#fcfcfc"]],graph:{"background-color":"#111",title:{color:"#fff"},subtitle:{color:"#333"},SCALE:{"font-size":11,"line-width":2,"line-color":"#ccc",guide:{visible:1,"line-width":1,"line-style":"solid","line-color":"#ccc",alpha:.2},"minor-guide":{visible:1,"line-width":1,"line-style":"solid","line-color":"#ccc",alpha:.2},tick:{visible:1,size:6,placement:"outer","line-width":2,"line-color":"#ccc"},"minor-tick":{visible:1,size:4,placement:"outer","line-width":1,"line-color":"#ccc"},label:{color:"#fff"},item:{color:"#fff"}}},radar:{"scale-k":{guide:{alpha:.5,"background-color":"#222 #333"}}},"-":""},this.NY.spark=this.NY.mini,this.B8={root:{gui:{behaviors:[{id:"PageScroll",enabled:"all"},{id:"ViewSource",enabled:"all"},{id:"BugReport",enabled:"none"},{id:"LogScale",enabled:"none"},{id:"LinScale",enabled:"none"},{id:"FullScreen",enabled:"none"},{id:"3D",enabled:"none"},{id:"ExportData",enabled:"none"},{id:"SaveAsImageJPG",enabled:"none"},{id:"DownloadCSV",enabled:ZC.ie678?"none":"all"},{id:"DownloadXLS",enabled:ZC.ie678?"none":"all"}],watermark:{type:1,position:"rb"},history:{margin:"10 auto auto 10",width:30,height:22,padding:4,item:{"background-color":"#369","border-width":1,"border-color":"#69c"},"item-off":{"background-color":"#eee","border-color":"#ddd"}},progress:{"background-color":"#fff",color:"#000"},"context-menu":{padding:0,"border-width":1,"border-color":"#000",button:{visible:ZC.mobile,margin:"5 auto auto 5",alpha:.8,"background-color":"#333 #999","border-radius":8,width:40,height:40},gear:{"background-color":"#fff #f6f6f6",type:"gear6",alpha:.8},item:{"background-color":"#36393D","text-align":"left",padding:"4 20 4 8","border-width":1,"border-color":"#000",color:"#fff","hover-state":{"background-color":"#0084AA"}},separator:{"line-width":1,"line-color":"#000000"}},"context-menu[mobile]":{item:{padding:"6 10 6 6"}}}},palette:[],graph:{title:{width:"100%",bold:1,"font-size":13},subtitle:{width:"100%",bold:1,"font-size":11},scroll:{bar:{"background-color":"#e1eaec","border-color":"#ddd"},handle:{"background-color":"#ddd","border-color":"#ccc","border-width":2,"border-top":"2px solid #eee","border-left":"2px solid #eee","border-right":"2px solid #999","border-bottom":"2px solid #999"}},"scroll-x":{bar:{height:16},handle:{height:16}},"scroll-y":{bar:{width:16},handle:{width:16}},"scroll-xi":{bar:{width:16},handle:{width:16}},"scroll-yi":{bar:{height:16},handle:{height:16}},preview:{width:"100%",height:50,margin:"auto 50 20 50","border-width":1,shadow:0,"background-color":"#f0f0f0","border-color":"#999",mask:{alpha:.5,"background-color":"#333"},active:{alpha:.1,"background-color":"#999"},handle:{width:9,height:16,"border-width":1,"line-width":1,"line-color":"#111","border-color":"#444","border-radius":2,"background-color":"#e6e6e6"},"handle-top":{width:16,height:9},"handle-bottom":{width:16,height:9}},"preview[yx]":{width:50,height:"100%",margin:"20 auto 50 20"},plotarea:{width:"100%",height:"100%",margin:"60 50 65 50"},"plotarea[preview]":{margin:"60 50 105 50"},SCALE:{"line-width":1,guide:{"line-width":1,"line-color":"#ddd"},tick:{size:6,"line-width":2},"minor-guide":{"line-width":1,"line-color":"#ddd"},"minor-tick":{size:4,"line-width":1},label:{bold:1,padding:6,flat:!0},item:{padding:2,"auto-align":!0,flat:!0},marker:{"line-width":1,"line-color":"#000","background-color":"#ccc"},"transform[date]":{item:{"font-size":10,padding:2,color:"#000","background-color":"#fff"}}},"SCALE[3d]":{"background-color":"#ccc"},"scale-y[default]":{label:{"font-angle":270},item:{"text-align":"right"}},"scale-y[opposite]":{label:{"font-angle":90},item:{"text-align":"left"}},plot:{error:{"line-width":1,"line-color":"#333",size:.5},"value-box":{flat:!0,text:"%v",bold:1,placement:"auto",shadow:1},"tooltip-text":"%v",shadow:1,"line-width":1,marker:{type:"square",shadow:1},"highlight-state":{shadow:!0,"shadow-blur":2,"shadow-distance":1,"shadow-alpha":.91}},tooltip:{shadow:1,padding:"4 8","shadow-distance":3,"offset-y":ZC.mobile?-40:-20},"tooltip[dynamic]":{padding:"4 8","offset-y":0},guide:{marker:{type:"circle"},"plot-label[single]":{text:'<b style="color:%color">%plot-text:</b> %node-value',padding:10,"background-color":"#fff #eee","border-width":1,"border-color":"#999",color:"#000","text-align":"left"},"plot-label[multiple]":{text:'<b style="color:%color">%plot-text:</b> %node-value',padding:5,"background-color":"#fff #eee","border-width":1,"border-color":"#999",color:"#000","text-align":"left"}},zoom:{"preserve-zoom":1,"border-width":0,"background-color":"#369",alpha:.25,label:{visible:!1,"background-color":"#fff","font-size":10,padding:2,"border-width":1,"border-color":"#999"}},arrow:{"border-width":1,"border-color":"#000","background-color":"#666",size:4},"legend[position]":{margin:10},legend:{"background-color":"#eee",alpha:1,shadow:1,margin:"10 10 auto auto",padding:"4 2 4 2",item:{"text-align":"left",margin:"2 6 2 4",padding:"2 4"},"item-off":{alpha:.25},marker:{shadow:0,size:6,"border-color":"#999","border-width":1},header:{"font-size":12,"text-align":"left",bold:1},footer:{"text-align":"left"},icon:{"line-color":"#000","line-width":1},"page-status":{color:"#000"},"page-on":{"background-color":"#f90"},"page-off":{"background-color":"#999"},scroll:{bar:{width:12,height:12,"background-color":"#e1eaec","border-color":"#ddd"},handle:{width:12,height:12,"background-color":"#ddd","border-color":"#ccc","border-width":2,"border-top":"2px solid #eee","border-left":"2px solid #eee","border-right":"2px solid #999","border-bottom":"2px solid #999"}}}},vbar:{plot:{"value-box":{placement:"top-out"}}},vbar3d:{plot:{"value-box":{placement:"top-out"}},"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0}},mixed3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0}},hbar:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}},plot:{"value-box":{placement:"top-out"}}},vline:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}}},varea:{plot:{"fill-angle":0},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x[default]":{label:{"font-angle":270}},"scale-x[opposite]":{label:{"font-angle":90}}},hbar3d:{"scale-y":{label:{"font-angle":0}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0}},"scale-x-n":{label:{"font-angle":90}},"3d-aspect":{depth:40,angle:45,"x-angle":0,"y-angle":-20,"z-angle":0},plot:{"value-box":{placement:"top-out"}}},hbullet:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}}},line:{plot:{"line-width":4,marker:{type:"circle",size:4}}},area:{plot:{"line-width":4,marker:{type:"circle",size:4},"value-box":{placement:"top"}}},line3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0},plot:{"border-width":1,"line-width":1,marker:{type:"circle",size:4,alpha:1,visible:0}}},area3d:{"3d-aspect":{depth:40,angle:45,"x-angle":-20,"y-angle":0,"z-angle":0},plot:{"border-width":1,"line-width":1,marker:{type:"circle",size:4,alpha:1,visible:0},"value-box":{placement:"top"}}},scatter:{SCALE:{offset:10},plot:{marker:{type:"circle",size:4},"value-box":{placement:"top"}}},poly:{SCALE:{offset:10},plot:{"alpha-area":.4,marker:{type:"none"},"value-box":{placement:"top"}}},hscatter:{SCALE:{offset:10},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}},plot:{marker:{type:"circle",size:4},"value-box":{placement:"top"}}},bubble:{SCALE:{offset:40},plot:{marker:{type:"circle","fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"hover-marker":{"fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"value-box":{placement:"middle",text:"%node-size-value"},"tooltip-text":"%node-size-value"}},hbubble:{SCALE:{offset:40},"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}},plot:{marker:{type:"circle","fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"hover-marker":{"fill-type":"radial","fill-offset-x":-.2,"fill-offset-y":-.2},"value-box":{placement:"middle",text:"%node-size-value"},"tooltip-text":"%node-size-value"}},hmixed:{"scale-y":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x":{label:{"font-angle":270}},"scale-y-n":{label:{"font-angle":0},item:{"text-align":"center"}},"scale-x-n":{label:{"font-angle":90}}},pie:{plotarea:{margin:"35 5 5 5"},scale:{"size-factor":"auto","line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"radial","value-box":{connector:{"line-width":1},placement:"out",text:"%t",visible:1}}},pie3d:{"3d-aspect":{"x-angle":38,"y-angle":0,"z-angle":0},plotarea:{margin:"25 5 5 5"},scale:{"size-factor":"auto","line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"linear","value-box":{connector:{"line-width":1},placement:"out",text:"%t",visible:1}}},nestedpie:{plotarea:{margin:"40 5 15 5"},scale:{"size-factor":.8,"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}},plot:{"fill-type":"radial","value-box":{connector:{"line-width":1},text:"%t",visible:1}}},venn:{plotarea:{margin:"30 10 10 10"},plot:{alpha:.5,"border-width":4},scale:{"size-factor":.65,"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0}}},radar:{SCALE:{guide:{"line-width":1,"line-color":"#999","background-color":"-1"},tick:{"line-width":1},item:{"auto-align":!1}},scale:{visible:0,"size-factor":.7},"scale-k":{"ref-angle":270},plotarea:{margin:"40 5 5 5"},plot:{"line-width":4,aspect:"line",marker:{type:"circle"}}},gauge:{SCALE:{guide:{"border-width":1,"border-color":"#999","background-color":"-1"}},scale:{"line-width":0,guide:{"line-width":0},"minor-guide":{"line-width":0},"size-factor":.7},"scale-r":{"ref-angle":270,"background-color":"#fff",guide:{"line-width":0},tick:{placement:"inner"},item:{"offset-r":"-45%"}},plot:{size:"85%"},plotarea:{margin:"40 5 5 5"}},stock:{plot:{"line-width":1,"border-width":1,"tooltip-text":"Open:&nbsp;$%open<br>High:&nbsp;$%high<br>Low:&nbsp;$%low<br>Close:&nbsp;$%close"}},range:{plot:{"line-width":2,"value-box":{text:"%node-min-value - %node-max-value"},"tooltip-text":"%node-min-value - %node-max-value"}},"-":""},this.PL=function(e,i){var t,n=this,a=!1;return null!==ZC._n_(t=n.B8.graph[e])&&null!==ZC._n_(t.enabled)&&(a=a||ZC._b_(t.enabled)),null!==ZC._n_(n.B8[i])&&null!==ZC._n_(t=n.B8[i][e])&&null!==ZC._n_(t.enabled)&&(a=a||ZC._b_(t.enabled)),a},this.load=function(e,i,t,n){var a,l,o,r=this;t=null===ZC._n_(t)||ZC._b_(t),n=null!==ZC._n_(n)&&ZC._b_(n),i instanceof Array||(i=new Array(i));var s=[],A="";for(l=0,o=i.length;l<o;l++)if(/(\(\w+\))(.*)/.test(i[l])){var C=RegExp.$1;A=i[l].replace(C,"graph"),-1===ZC.AV(s,A)&&s.push(A),A=i[l].replace(C,C.substring(1,C.length-1)),-1===ZC.AV(s,A)&&s.push(A)}else-1===ZC.AV(s,i[l])&&s.push(i[l]),/root(.*)/.test(i[l])&&-1===ZC.AV(s,i[l].replace("root","loader"))&&s.push(i[l].replace("root","loader")),/loader(.*)/.test(i[l])&&-1===ZC.AV(s,i[l].replace("loader","root"))&&s.push(i[l].replace("loader","root"));var c={};for(l=0,o=s.length;l<o;l++){for(var u=s[l].split("."),p=r.B8,Z=0,h=u.length;Z<h;Z++)if(null!==ZC._n_(a=p[u[Z]]))p=a;else if(null!==ZC._n_(a=p[ZC.UJ(u[Z])]))p=a;else{if(null===ZC._n_(a=p[ZC.EE(u[Z])])){p=null;break}p=a}if(p)for(var d in p)null!==ZC._n_(p[d])&&(n||"object"!=typeof p[d]||p[d].length)&&(t||null===ZC._n_(e[d])?r.H.QP&&null!==ZC._n_(r.H.QP[d])||(c[d]=p[d]):t&&"object"==typeof p[d]&&(r.H.QP&&null!==ZC._n_(r.H.QP[d])||(c[d]=p[d])))}ZC._cp_(c,e)}},ZC.AP={AGL:function(e,i){for(var t=[],n=0,a=e.p.length;n<a;n++)if(e.p[n]){var l=(e.p[n][0]-e.x)/e.w,o=(e.p[n][1]-e.y)/e.h;t.push([i.x+i.w*l,i.y+i.h*o])}else t.push(null);return{l:i.w*e.l/e.w,r:i.w*e.r/e.w,p:t}},ACC:function(e,i,t){var n=document.getElementsByTagName("head")[0],a=document.createElement("script");a.type="text/javascript",a.src=i+"?v"+ZC.VERSION;var l=!1;a.onload=a.onreadystatechange=function(){if(!(l||this.readyState&&"loaded"!==this.readyState&&"complete"!==this.readyState)){l=!0,a.onload=a.onreadystatechange=null,n&&a.parentNode&&n.removeChild(a);var e=new RegExp("zingchart-(.+?).min.js","g").exec(i);e&&ZC.WI.push(e[1]),t&&t(i)}},a.onerror=function(){!e&&zingchart.HZ[0]&&(e=zingchart.HZ[0]),e?e.NU({name:"Network error",message:"Resource not found ("+a.src+")"},"Module loader"):alert("Resource not found ("+a.src+")")},n.insertBefore(a,n.firstChild)},_rcolor_:function(){return"#"+ZC.XK.md5(ZC._r_(0,99999)).substr(ZC._r_(0,20),6)},WQ:function(){},A83:function(e,i){return zingchart[e]||i&&i.A18&&i.A18[e]||zingchart.hasEvent(null,e)||i&&zingchart.hasEvent(i.K,e)},BY:function(e,i,t,n,a){t instanceof Array||(t=[t]);var l=1;return null!==ZC._n_(n)&&t.push(n),a&&(l=2,t.push(a)),"touchstart"===e&&(e="mousedown"),"touchend"===e&&(e="mouseup"),"touchmove"===e&&(e="mousemove"),zingchart[e]&&"render"!==e&&(null!==ZC._n_(n)?t[t.length-l]=zingchart[e].apply(zingchart,t):zingchart[e].apply(zingchart,t)),i&&i.A18[e]&&(null!==ZC._n_(n)?t[t.length-l]=i.A18[e].apply(zingchart,t):i.A18[e].apply(zingchart,t)),zingchart.hasEvent(null,e)&&(null!==ZC._n_(n)?t[t.length-l]=zingchart.callEvent(null,e,t,n):zingchart.callEvent(null,e,t)),i&&zingchart.hasEvent(i.K,e)&&(null!==ZC._n_(n)?t[t.length-l]=zingchart.callEvent(i.K,e,t,n):zingchart.callEvent(i.K,e,t)),t[t.length-l]},O5:function(e,i){if(i.A9%360!=0){for(var t=[[-i.I/2,-i.F/2],[i.I/2,-i.F/2],[i.I/2,i.F/2],[-i.I/2,i.F/2]],n="",a=0;a<4;a++)t[a]=[i.iX+i.I/2+i.BM+ZC.MAPTX+t[a][0]*ZC.EH(i.A9)-t[a][1]*ZC.EP(i.A9),i.iY+i.F/2+i.BH+ZC.MAPTX+t[a][0]*ZC.EP(i.A9)+t[a][1]*ZC.EH(i.A9)],n+=ZC._i_(t[a][0])+","+ZC._i_(t[a][1])+",";return i.D=t,ZC.Q.G0("poly",i.EA,i.IV)+'class="'+e+'-label-area zc-label-area" id="'+i.K+'-area" coords="'+n.substring(0,n.length-1)+'" />'}return ZC.Q.G0("rect",i.EA,i.IV)+'class="'+e+'-label-area zc-label-area" id="'+i.K+'-area" coords="'+ZC._i_(i.iX+i.BM+ZC.MAPTX)+","+ZC._i_(i.iY+i.BH+ZC.MAPTX)+","+ZC._i_(i.iX+i.BM+i.I+ZC.MAPTX)+","+ZC._i_(i.iY+i.BH+i.F+ZC.MAPTX)+'" />'},N2:function(e){var i,t="",n=e.indexOf('id="');if(-1!==n){var a=e.indexOf('"',n+4);-1!==a&&(t=e.substring(n+4,a))}if(ZC.cache.data["area-score-"+t])return ZC.cache.data["area-score-"+t];var l=0;if(-1!==e.indexOf('shape="rect"')?(l+=1e4,5===(i=/coords=\"(\-*\d+),(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e)).length&&(l+=(ZC._i_(i[3])-ZC._i_(i[1]))*(ZC._i_(i[4])-ZC._i_(i[2])))):-1!==e.indexOf('shape="circle"')?(l+=100,i=/coords=\"(\-*\d+),(\-*\d+),(\-*\d+)\"/.exec(e),null!==ZC._n_(i[3])&&(l+=ZC._i_(i[3])/10)):-1!==e.indexOf('shape="poly"')?-1!==e.indexOf("data-map")?l+=1e6:l+=1e3:l+=1,-1!==e.indexOf("data-z-sort")){var o=/data-z-sort=\"(\-*\d+)\"/.exec(e);o&&2===o.length&&(l*=ZC._i_(Math.pow(10,ZC._i_(o[1]))))}return""!==t&&ZC.cache.add("area-score-"+t,l),l},A5B:function(e,i,t){for(var n=[],a=0,l=e.length;a<l;a++)if(null!==ZC._n_(e[a])){var o=e[a].slice(0);null!==ZC._n_(o[0])&&"string"!=typeof o[0]&&(o[0]+=i),null!==ZC._n_(o[1])&&"string"!=typeof o[1]&&(o[1]+=t),null!==ZC._n_(o[2])&&"string"!=typeof o[2]&&o.length<=4&&(o[2]+=i),null!==ZC._n_(o[3])&&"string"!=typeof o[3]&&o.length<=4&&(o[3]+=t),n.push(o)}else n.push(null);return n},O3:function(e,i){var t;i=i||{},e=e||{};var n={};if(null!==ZC._n_(t=e.negation)&&(n.negation=t),null!==ZC._n_(t=e.short)&&(n.short=ZC._b_(t)),null!==ZC._n_(t=e["short-unit"])&&(n["short-unit"]=t),null!==ZC._n_(t=e.exponent)&&(n.exponent=ZC._b_(t)),null!==ZC._n_(t=e["exponent-decimals"])&&(n["exponent-decimals"]=ZC._i_(t)),null!==ZC._n_(t=e["decimals-separator"])?n["decimals-separator"]=t:null===ZC._n_(i["decimals-separator"])&&null!==ZC._n_(t=ZC.HJ["decimals-separator"])&&(n["decimals-separator"]=t),null!==ZC._n_(t=e["thousands-separator"])?n["thousands-separator"]=t:null===ZC._n_(i["thousands-separator"])&&null!==ZC._n_(t=ZC.HJ["thousands-separator"])&&(n["thousands-separator"]=t),null!==ZC._n_(t=e.decimals)&&(n.decimals=ZC._i_(t)),null!==ZC._n_(t=e["decimals-dyn"])&&(n["decimals-dyn"]=t),null!==ZC._n_(t=e.transform)&&null!==ZC._n_(t.type))switch(t.type){case"date":n["transform-date"]=!0,null!==ZC._n_(t.text)&&(t.all=t.text),null!==ZC._n_(t.all)&&(n["transform-date-format"]=t.all)}return n},G2:function(e,i,t,n){var a,l=e,o=e+"",r=!1;if(n&&null!==ZC._n_(i["transform-date"])&&i["transform-date"]&&""+Number(o)===o&&(o=ZC.AP.Y5(Number(o),i["transform-date-format"],i.utc,i.timezone),r=!0),null===ZC._n_(i["decimals-separator"])&&null!==ZC._n_(e=ZC.HJ["decimals-separator"])&&(i["decimals-separator"]=e),null===ZC._n_(i["thousands-separator"])&&null!==ZC._n_(e=ZC.HJ["thousands-separator"])&&(i["thousands-separator"]=e),null!==ZC._n_(i.decimals)&&-1!==i.decimals&&"undefined"!=typeof i["max-decimals"]&&-1!==i["max-decimals"]&&(i.decimals=ZC.BQ(i["max-decimals"],i.decimals)),!r)if(null!==ZC._n_(i.exponent)&&i.exponent)o=Number(o).toExponential(ZC.CY(20,i["exponent-decimals"])),null!==ZC._n_(i["decimals-separator"])&&(o=o.replace(/\./g,i["decimals-separator"]));else{if(null!==ZC._n_(i.short)&&i.short){a="";var s=i["short-unit"]||"";if("string"!=typeof s&&s.length){""+ZC._f_(s[0])!==s[0]&&(s=[1e3].concat(s));for(var A=1,C=s[0]||1e3,c=s.slice(1),u=null,p=0;p<c.length;p++)0===c[p].indexOf("#")&&(u=p,c[p]=c[p].substring(1));if(c.length){if(null!==u)A=u;else if(null!==ZC._n_(i["max-power"]))A=i["max-power"];else{var Z=ZC.G6(ZC._a_(Number(o)),C);A=Math.floor(Z),A=ZC.CY(A,c.length-1)}a=c[A];var h=(o=""+Number(o)/Math.pow(C,A)).split(".");2===h.length&&h[1].length>=9&&(o=null!==ZC._n_(i.decimals)&&-1!==i.decimals?""+ZC._x_(o,i.decimals):""+ZC._x_(o))}}else{var d=ZC.G6(ZC._a_(Number(o)))/Math.LN10;switch(ZC._a_(Number(o))){case 1e3:d=3;break;case 1e6:d=6;break;case 1e9:d=9}if(null!==ZC._n_(i["max-power"])&&(d=3*i["max-power"]),"KB"===s.toUpperCase())o=""+Number(o)/1024,a="KB";else if("MB"===s.toUpperCase())o=""+Number(o)/1048576,a="MB";else if("GB"===s.toUpperCase())o=""+Number(o)/1073741824,a="GB";else if("TB"===s.toUpperCase())o=""+Number(o)/1099511627776,a="TB";else if("PB"===s.toUpperCase())o=""+Number(o)/0x4000000000000,a="PB";else if(d>=0&&d<3)switch(s){default:o=o,a="";break;case"K":o=""+Number(o)/1e3,a="K";break;case"M":o=""+Number(o)/1e6,a="M";break;case"B":o=""+Number(o)/1e9,a="B"}else d>=3&&d<6&&""===s||"K"===s.toUpperCase()?(o=""+Number(o)/1e3,a="K"):d>=6&&d<9&&""===s||"M"===s.toUpperCase()?(o=""+Number(o)/1e6,a="M"):(d>=9&&""===s||"B"===s.toUpperCase())&&(o=""+Number(o)/1e9,a="B")}if(ZC.P5(o))if(null!==ZC._n_(i.decimals)&&-1!==i.decimals)o=ZC._fixed_(Number(o),ZC.BQ(0,ZC._i_(i.decimals)));else{var f=o.split(".")[1]||"";-1!==i["max-decimals"]&&i["max-decimals"]<f.length&&(o=ZC._fixed_(Number(o),ZC.BQ(0,ZC._i_(i["max-decimals"]))))}null!==ZC._n_(i["decimals-separator"])&&(o=o.replace(/\./g,i["decimals-separator"]))}var _=t?t.K:"";if(!isNaN(o)&&("string"!=typeof l||-1===_.indexOf("-scale-"))){if(null!==ZC._n_(i.decimals)&&-1!==i.decimals&&ZC.P5(o)&&(null!==ZC._n_(i.short)&&i.short||(o=ZC._fixed_(Number(o),ZC.BQ(0,ZC._i_(i.decimals))))),null!==ZC._n_(i["thousands-separator"])||null!==ZC._n_(i["decimals-separator"])){for(var g=o.split("."),v="",b=0,B=g[0].length;b<B;b++){var m=g[0].substring(b,b+1);v+=m,-1===ZC.AV(["-","+"],m)&&(g[0].length-b-1)%3==0&&g[0].length-b-1!=0&&(v+=i["thousands-separator"])}o=v+(null!==ZC._n_(g[1])?i["decimals-separator"]+g[1]:"")}null!==ZC._n_(i.short)&&i.short&&(o+=a)}}return o},AAH:function(e){var i=e.indexOf("("),t="",n="";-1!==i?(t=ZC.GV(e.substring(0,i)),n=ZC.GV(e.substring(i+1,e.length-1))):t=ZC.GV(e);var a=[],l="";if(""!==n){var o=!1,r=!1,s=!1;l="";for(var A=0,C=n.length;A<C;A++){var c=n.substring(A,A+1);switch(c){case"\\":s?(l+="\\",s=!1):s=!0;break;case'"':s?(l+='"',s=!1):r?(a.push(l),l="",r=!1):o?l+=c:r=!0;break;case"'":s?(l+="'",s=!1):o?(a.push(l),l="",o=!1):r?l+=c:o=!0;break;case" ":(o||r)&&(l+=c);break;case",":o||r?l+=c:(""!==l&&a.push(l),l="");break;default:l+=c}}}return""!==l&&a.push(l),[t,a]},A4T:function(e){return e.toString().replace(/^([0-9])$/,"0$1")},Y5:function(e,i,t,n){e=ZC._i_(e),i=i||ZC.HJ["date-formats"].minute,void 0===t&&(t=!1),void 0===n&&(n=0),t&&(e+=36e5*n);var a,l,o,r,s,A,C,c,u=new Date;u.setTime(e),t?(a=u.getUTCHours(),l=u.getUTCMinutes(),o=u.getUTCSeconds(),r=u.getUTCMilliseconds(),s=u.getUTCDay(),A=u.getUTCDate(),C=u.getUTCMonth(),c=u.getUTCFullYear()):(a=u.getHours(),l=u.getMinutes(),o=u.getSeconds(),r=u.getMilliseconds(),s=u.getDay(),A=u.getDate(),C=u.getMonth(),c=u.getFullYear());for(var p=[["mm",ZC.AP.A4T(C+1)],["dd",ZC.AP.A4T(A)],["Y",c],["y",c.toString().substr(2,2)],["F",ZC.HJ["months-long"][C]],["m",C+1],["M",ZC.HJ["months-short"][C]],["n",C],["d",A],["D",ZC.HJ["days-short"][s]],["j",A],["l",ZC.HJ["days-long"][s]],["N",s+1],["w",s],["S",function(){return A%10==1?"st":A%10==2?"nd":A%10==3?"rd":"th"}],["a",a<12?"am":"pm"],["A",a<12?"AM":"PM"],["g",a%12||12],["G",a],["h",ZC.AP.A4T(a%12||12)],["H",ZC.AP.A4T(a)],["i",ZC.AP.A4T(l)],["s",ZC.AP.A4T(o)],["q",r]],Z=0;Z<p.length;Z++)i=i.replace("%"+p[Z][0],p[Z][1]);return i},A0D:{},YN:function(e,i){var t=null;if(i&&i.BP?t=i.BP:i&&i.A&&i.A.BP&&(t=i.A.BP),"string"==typeof e&&-1!==e.indexOf("%color-")&&ZC.COLORS.length>0)for(var n=0;n<ZC.COLORS.length;n++)-1===e.indexOf("(+")&&-1===e.indexOf("(-")||(e=e.replace(/%color-(\d+?)\((\+|\-)(\d+?)\)/gi,function(){var e=ZC.AP.GC(ZC.COLORS[ZC._i_(arguments[1])]);return"+"===arguments[2]?e=ZC.AP.QU(e,ZC._i_(arguments[3])):"-"===arguments[2]&&(e=ZC.AP.JN(e,ZC._i_(arguments[3]))),e})),e=e.replace("%color-"+n,ZC.COLORS[n]);else"string"==typeof e&&t&&-1!==e.indexOf("%palette-")&&(e=t[ZC._i_(e.replace("%palette-",""))]);return e},GC:function(e,i){var t,n,a,l;if(null!==ZC._n_(ZC.AP.A0D[e]))return ZC.AP.A0D[e];var o=ZC.GV(String(e)),r=1,s=!1;return 0===o.length?"":("rgba("===(o=o.replace("0x","#")).substring(0,5)?(t=new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3}),\\s*([0-9.]+)\\)","gi").exec(o))&&(1===(n=ZC.OT(t[1])).length&&(n="0"+n),1===(a=ZC.OT(t[2])).length&&(a="0"+a),1===(l=ZC.OT(t[3])).length&&(l="0"+l),o="#"+n+a+l,r=ZC.BQ(0,ZC.CY(1,parseFloat(t[4]))),s=!0):"rgb("===o.substring(0,4)?(t=new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)","gi").exec(o))&&(1===(n=ZC.OT(t[1])).length&&(n="0"+n),1===(a=ZC.OT(t[2])).length&&(a="0"+a),1===(l=ZC.OT(t[3])).length&&(l="0"+l),o="#"+n+a+l):"#"===o.substring(0,1)?4===o.length?o="#"+o.substring(1,2)+o.substring(1,2)+o.substring(2,3)+o.substring(2,3)+o.substring(3,4)+o.substring(3,4):7!==o.length&&(o=""):null!==ZC._n_(ZC.Q.A9O[o.toUpperCase()])&&(o="#"+ZC.Q.A9O[o.toUpperCase()]),"none"!==o&&"transparent"!==o||(o="-1"),i||(ZC.AP.A0D[e]=o),i&&s?[o,r]:o)},A1N:{},A32:function(e,i){if(-1===e&&(e="#ffffff",i=0),null!==ZC._n_(ZC.AP.A1N[e+","+i]))return ZC.AP.A1N[e+","+i];4===e.length&&(e=e.substring(0,1)+e.substring(1,2)+e.substring(1,2)+e.substring(2,3)+e.substring(2,3)+e.substring(3,4)+e.substring(3,4));var t="rgba("+[ZC.QX(e.substring(1,3)),ZC.QX(e.substring(3,5)),ZC.QX(e.substring(5,7)),i].join(",")+")";return ZC.AP.A1N[e+","+i]=t,t},AD9:function(e,i,t){e/=255,i/=255,t/=255;var n,a,l,o=Math.max(e,i,t),r=Math.min(e,i,t);l=o;var s=o-r;if(a=0===o?0:s/o,o===r)n=0;else{switch(o){case e:n=(i-t)/s+(i<t?6:0);break;case i:n=(t-e)/s+2;break;case t:n=(e-i)/s+4}n/=6}return[n,a,l]},AD7:function(e,i,t){var n,a,l,o=Math.floor(6*e),r=6*e-o,s=t*(1-i),A=t*(1-r*i),C=t*(1-(1-r)*i);switch(o%6){case 0:n=t,a=C,l=s;break;case 1:n=A,a=t,l=s;break;case 2:n=s,a=t,l=C;break;case 3:n=s,a=A,l=t;break;case 4:n=C,a=s,l=t;break;case 5:n=t,a=s,l=A}return[255*n,255*a,255*l]},JN:function(e,i){if(-1===e)return-1;if(i>=100)return"#000000";e=ZC.AP.GC(e),void 0===i&&(i=10);var t=ZC.QX(e.substring(1,3)),n=ZC.QX(e.substring(3,5)),a=ZC.QX(e.substring(5,7)),l=ZC.AP.AD9(t,n,a);l[2]=i>0?Math.max(0,l[2]-l[2]*i/100):Math.min(1,l[2]-l[2]*i/100);var o=ZC.AP.AD7(l[0],l[1],l[2]);return o[0]=ZC._i_(o[0])<16?"0"+ZC.OT(o[0]):ZC.OT(o[0]),o[1]=ZC._i_(o[1])<16?"0"+ZC.OT(o[1]):ZC.OT(o[1]),o[2]=ZC._i_(o[2])<16?"0"+ZC.OT(o[2]):ZC.OT(o[2]),e="#"+o[0]+o[1]+o[2]},QU:function(e,i){if(-1===e)return-1;if(i>=100)return"#ffffff";e=ZC.AP.GC(e),void 0===i&&(i=10);var t=parseInt(e.substr(1,2),16),n=parseInt(e.substr(3,2),16),a=parseInt(e.substr(5,2),16);return"#"+(0|256+t+(256-t)*i/100).toString(16).substr(1)+(0|256+n+(256-n)*i/100).toString(16).substr(1)+(0|256+a+(256-a)*i/100).toString(16).substr(1)},_hex2rgb_:function(e,i){var t=parseInt(e.substr(1,2),16),n=parseInt(e.substr(3,2),16),a=parseInt(e.substr(5,2),16);return ZC._n_(i)?"rgb("+t+","+n+","+a+")":{r:t,g:n,b:a}},_rgb2hex_:function(e,i,t){return"#"+((1<<24)+(e<<16)+(i<<8)+t).toString(16).slice(1)},AA9:function(e,i,t){var n=ZC.AP._hex2rgb_(e);return(299*n.r+587*n.g+114*n.b)/1e3>=128?t:i},_colorAlpha_:function(e,i,t){e=ZC.AP.GC(e),i=ZC.AP.GC(i);var n=ZC.AP._hex2rgb_(e),a=ZC.AP._hex2rgb_(i),l={};for(var o in n)l[o]=Math.floor(t*n[o]+(1-t)*a[o]);return ZC.AP._rgb2hex_(l.r,l.g,l.b)},A3E:function(){},ABR:function(){},gc:function(e,i){var t;for(t=0;t<i.length;t++)e[i[t]]=null;for(t in e)0===t.indexOf("zc_")&&"function"==typeof e[t]&&(e[t]=null)}},ZC.Q={A9O:{BLACK:"000000",BLUE:"0000FF",BROWN:"A52A2A",CYAN:"00FFFF",FUCHSIA:"FF00FF",GOLD:"FFD700",GRAY:"808080",GREEN:"008000",INDIGO:"4B0082",LIME:"00FF00",MAGENTA:"FF00FF",MAROON:"800000",NAVY:"000080",ORANGE:"FFA500",PINK:"FFC0CB",PURPLE:"800080",RED:"FF0000",SILVER:"C0C0C0",TURQUOISE:"40E0D0",VIOLET:"EE82EE",WHITE:"FFFFFF",YELLOW:"FFFF00"},G0:function(e,i,t){return"<area"+(t&&!i&&"hand"!==t?' style="cursor:'+t+'"':"")+(i&&"arrow"!==t||"hand"===t?' href="javascript:;"':"")+' shape="'+e+'" '},ABE:function(e){var i;if(ZC.A5.browser.msie)try{i=document.createElement("<iframe />")}catch(r){i=document.createElement("iframe")}else i=document.createElement("iframe");i.id=e.id+"-iframe",i.style.visibility="hidden",e.appendChild(i);var t=null,n=i.contentWindow||i.contentDocument;if(!(t=n.document?n.document:n).body){var a=t.createElement("HTML");t.appendChild(a);var l=t.createElement("HEAD");a.appendChild(l);var o=t.createElement("BODY");a.appendChild(o)}return t},BZ:function(e){var i;if("undefined"==typeof ZC.TOUCHEVENTS){if(ZC.ie678)i=!1;else{i=!0;try{document.createEvent("TouchEvent")}catch(t){i=!1}}i&&!ZC.mobile&&(i=!1),i&&(i="ontouchstart"in document.documentElement),ZC.TOUCHEVENTS=i}else i=ZC.TOUCHEVENTS;if(i)switch(e){case"mouseover":case"mousedown":e="touchstart";break;case"mousemove":e="touchmove";break;case"mouseout":case"mouseup":e="touchend";break;case"click":e="touchstart"}return e},_sh_:function(e,i){var t,n,a,l=[],o=i.JW,r=i.OH,s=i.PD,A=o-s/2;if(e.length>0){var C=0,c=0;for(0!==o&&(C=ZC._i_(A*ZC.EH(r)+s),c=ZC._i_(A*ZC.EP(r)+s)),t=0,n=e.length;t<n;t++)if(null!==ZC._n_(e[t])){var u=[];for(a=0;a<e[t].length;a++)u[a]=e[t][a];var p=u.length;if(2===p||4===p)for(a=0;a<p;a++)u[a]=e[t][a]+(a%2?c+ZC._c_(i.BH,0):C+ZC._c_(i.BM,0));l.push(u)}else l.push(null)}return l},_txp_:function(e,i,t,n,a){void 0===a&&(a=!1);var l,o,r=[e[0],e[1]];switch(e.length>=4&&(r[2]=e[2],r[3]=e[3]),e.length>=6&&(r[4]=e[4],r[5]=e[5]),7===e.length&&(r[6]=e[6]),i){case"canvas":case"svg":var s,A;if(t.CZ)s=A=t.AZ%2==1?.5:0,ZC.A5.browser.msie&&ZC.quirks&&"svg"===i&&(s=t.AZ%2==1?.5:0,A=t.AZ%2==1?0:.5),r[0]=Math.round(r[0])-s,r[1]=Math.round(r[1])-A,4===r.length&&(r[2]=Math.round(r[2])-s,r[3]=Math.round(r[3])-A);"svg"===i&&(r[0]=parseFloat(r[0].toFixed(4)),r[1]=parseFloat(r[1].toFixed(4)),4===r.length&&(r[2]=parseFloat(r[2].toFixed(4)),r[3]=parseFloat(r[3].toFixed(4)))),"canvas"!==i||n||"undefined"!=typeof t.BM&&"undefined"!=typeof t.BH&&(r[0]+=t.BM,r[1]+=t.BH,4===r.length&&(r[2]+=t.BM,r[3]+=t.BH));break;case"vml":t.A9%360==0?(l=10,o=t.AZ%2==1?0:l/2):(l=1,o=0),t.CZ?(r[0]=l*ZC._i_(ZC._i_(l*r[0])/l)-o,r[1]=l*ZC._i_(ZC._i_(l*r[1])/l)-o,4!==r.length&&7!==r.length||(r[2]=l*ZC._i_(ZC._i_(l*r[2])/l)-o,r[3]=l*ZC._i_(ZC._i_(l*r[3])/l)-o),7===r.length&&(r[4]=l*ZC._i_(ZC._i_(l*r[4])/l)-o,r[5]=l*ZC._i_(ZC._i_(l*r[5])/l)-o)):(r[0]=ZC._i_(l*r[0]),r[1]=ZC._i_(l*r[1]),4!==r.length&&7!==r.length||(r[2]=ZC._i_(l*r[2]),r[3]=ZC._i_(l*r[3])),7===r.length&&(r[4]=ZC._i_(l*r[4]),r[5]=ZC._i_(l*r[5])))}return r},A2W:function(e,i,t,n,a){var l,o,r,s,A,C,c;if(t.QW&&(t.E["fast-vector-path"]=!0),!t.E["fast-vector-path"]){for(l=0,o=e.length;l<o;l++)e[l]&&(e[l][0]=parseFloat(Number(e[l][0]).toFixed(2)),e[l][1]=parseFloat(Number(e[l][1]).toFixed(2)));if(t.O7&&(c=t.K+":"+t.A9+":"+e.join("#"),ZC.cache.data["path-points-"+c]))return ZC.cache.data["path-points-"+c].split("#")}var u=[ZC.MAX,ZC.MAX,-ZC.MAX,-ZC.MAX],p=[],Z=!1;for(l=0,o=e.length;l<o;l++)if(null!==ZC._n_(e[l])){if(t.E["fast-vector-path"]){if(r=e[l],"vml"===i){var h=t.A9%360==0?10:1;r[0]=ZC._i_(h*r[0]),r[1]=ZC._i_(h*r[1]),4===r.length&&(r[2]=ZC._i_(h*r[2]),r[3]=ZC._i_(h*r[3]))}}else r=ZC.Q._txp_(e[l],i,t,n,a);if(null!==ZC._n_(r)&&!isNaN(r[0])&&!isNaN(r[1])&&isFinite(r[0])&&isFinite(r[1]))if(o<=20&&n&&(u[0]=ZC.CY(u[0],r[0]/("vml"===i?10:1)),u[1]=ZC.CY(u[1],r[1]/("vml"===i?10:1)),u[2]=ZC.BQ(u[2],r[0]/("vml"===i?10:1)),u[3]=ZC.BQ(u[3],r[1]/("vml"===i?10:1))),0===l)p.push(("svg"===i?"M ":"m ")+r[0]+" "+r[1]);else if(Z&&(p.push(("svg"===i?"M ":"m ")+r[0]+" "+r[1]),Z=!1),2===r.length)p.push(("svg"===i?"L ":"l ")+r[0]+" "+r[1]);else if(4===r.length)p.push(("svg"===i?"Q ":"qb ")+r[0]+" "+r[1]+" "+r[2]+" "+r[3]),"vml"===i&&p.push("l "+r[2]+" "+r[3]);else if(6===r.length)if("svg"===i){var d=0;r[3]%360==r[4]%360&&(d=r[4]>=r[3]?.001:-.001),s=ZC.AQ.BN(r[0],r[1],r[2],r[3]+d),A=ZC.AQ.BN(r[0],r[1],r[2],r[4]-d),C="0 0",0===r[5]?r[4]-r[3]>360?(C="0 1",A[0]=s[0],A[1]=s[1]):C=r[4]-r[3]<=180?"0 1":"1 1":r[3]-r[4]>360?(C="0 0",A[0]=s[0],A[1]=s[1]):C=r[3]-r[4]<=180?"0 0":"1 0",p.push("a "+r[2]+","+r[2]+" 0 "+C+" "+(A[0]-s[0])+","+(A[1]-s[1]))}else"vml"===i&&(r[2]*=10,s=ZC.AQ.BN(r[0],r[1],r[2],r[3]),A=ZC.AQ.BN(r[0],r[1],r[2],r[4]),C=1===r[5]?"at":"wa",p.push(C+" "+ZC._i_(r[0]-r[2])+","+ZC._i_(r[1]-r[2])+","+ZC._i_(r[0]+r[2])+","+ZC._i_(r[1]+r[2])+" "+ZC._i_(s[0])+","+ZC._i_(s[1])+" "+ZC._i_(A[0])+","+ZC._i_(A[1])));else 7===r.length&&p.push(("svg"===i?"C ":"c ")+r[0]+" "+r[1]+" "+r[2]+" "+r[3]+" "+r[4]+" "+r[5])}else Z=!0;return t.E["fast-vector-path"]||t.O7&&ZC.cache.add("path-points-"+c,p.join("#")),t.H&&o<=20&&n&&(t.H.E[t.K+"-bounds"]=u),p},MB:function(e,i){var t,n,a=e.originalEvent||e.originalEventZC;return i=ZC._i_(i||"0"),a&&a.touches?a.touches.length>0?(t=a.touches[i].pageX,n=a.touches[i].pageY):a.changedTouches.length>0&&(t=a.changedTouches[i].pageX,n=a.changedTouches[i].pageY):(t=e.pageX,n=e.pageY),[ZC._i_(t||"0"),ZC._i_(n||"0")]},F5:function(e,i,t){var n;return t=t||document,null!==ZC._n_(i)?t.createElementNS?n=t.createElementNS(i,e):(n=t.createElement(e)).setAttribute("xmlns",i):n=t.createElement(e),"zcv:"===e.substring(0,4)&&(n.className="zcvml"),n},EU:function(e){var i;e instanceof Array||(e=[e]);for(var t=0,n=e.length;t<n;t++)"object"!=typeof(i=e[t])&&(i=ZC.AK(e[t])),i&&("undefined"!=typeof i.parentElement?i.parentElement.removeChild(i):"undefined"!=typeof i.parentNode&&i.parentNode.removeChild(i))},G3:function(e,i){for(var t in i)if("string"==typeof t&&"object"!=typeof i[t]&&"function"!=typeof i[t])try{e.setAttribute(t,i[t])}catch(n){}},PJ:function(e,i){for(var t in i)"string"==typeof t&&"object"!=typeof i[t]&&"function"!=typeof i[t]&&(e.style[t]=i[t])},AB3:function(e){var i;if(e===document)return!0;if(!e)return!1;if(!e.parentNode)return!1;if(e.style){if("none"===e.style.display)return!1;if("hidden"===e.style.visibility)return!1}if(window.getComputedStyle){if("none"===(i=window.getComputedStyle(e,"")).display)return!1;if("hidden"===i.visibility)return!1}if(i=e.currentStyle){if("none"===i.display)return!1;if("hidden"===i.visibility)return!1}return ZC.Q.AB3(e.parentNode)},T8:function(e){var i=e.className||ZC.A5(e).attr("class");return null!==ZC._n_(i)&&"object"==typeof i&&(i="undefined"!=typeof i.baseVal?i.baseVal:""),i||""},IU:function(e,i,t,n,a,l,o,r){if(e)switch(o=o||"",i){case"canvas":r?e.getContext("2d").clearRect(t,n,a,l):e.width=e.width;break;case"vml":case"svg":var s=e.childNodes.length;if(s>1024&&"undefined"!=typeof e.innerHTML)return void(e.innerHTML="");if(s>0)for(var A=s-1;A>=0;A--)""===o?e.removeChild(e.childNodes[A]):0===e.childNodes[A].id.indexOf(o+"-")&&e.removeChild(e.childNodes[A])}},EB:function(e,i){switch("string"==typeof e&&(e=ZC.AK(e)),i){case"canvas":return e.getContext("2d");case"svg":case"vml":return e}},JZ:function(e,i){switch(i){case"svg":return ZC.Q.ABK(e);case"vml":case"canvas":return ZC.Q.HY(e)}},HC:function(e,i){switch(i){case"svg":return ZC.Q.ABK(e);case"vml":return ZC.Q.HY(e);case"canvas":return ZC.Q.ADB(e)}},ABK:function(e){var i;if(ZC.AK(e.id))return ZC.AK(e.id);var t=ZC.Q.F5("g","http://www.w3.org/2000/svg");return null!==ZC._n_(i=e.id)&&t.setAttribute("id",i),null!==ZC._n_(i=e.cls)&&t.setAttribute("class",i),null!==ZC._n_(i=e.zidx)&&t.setAttribute("z-index",i),null!==ZC._n_(i=e["clip-path"])&&t.setAttribute("clip-path",i),e.after?e.p.insertBefore(t,e.after.nextSibling):e.p.appendChild(t),t},X8:function(e){var i;ZC.Q.EU(e.id);var t=ZC.Q.F5("clipPath","http://www.w3.org/2000/svg");return t.id=e.id,null!==ZC._n_(e.cx)?((i=ZC.Q.F5("circle","http://www.w3.org/2000/svg")).id=e.id+"-shape",ZC.Q.G3(i,{cx:e.cx,cy:e.cy,r:e.r})):((i=ZC.Q.F5("polygon","http://www.w3.org/2000/svg")).id=e.id+"-shape",ZC.Q.G3(i,{points:e.path})),t.appendChild(i),t},ADB:function(e){var i;if(ZC.AK(e.id))return ZC.AK(e.id);var t=document.createElement("canvas"),n=t.style;if(null!==ZC._n_(i=e.id)&&(t.id=i),null!==ZC._n_(i=e.cls)&&(t.className=i),null!==ZC._n_(i=e.wh)){var a=(""+i).split("/");e.width=a[0],e.height=a[1]}if(null!==ZC._n_(i=e.tl)){var l=(""+i).split("/");e.top=l[0],e.left=l[1]}return t.width=e.width,t.height=e.height,null!==ZC._n_(i=e.left)&&(n.left=i+"px"),null!==ZC._n_(i=e.top)&&(n.top=i+"px"),null!==ZC._n_(i=e.display)&&(n.display=i),null!==ZC._n_(i=e.position)&&(n.position=i),null!==ZC._n_(i=e.zidx)&&(n.zIndex=i),e.p.appendChild(t),t},HY:function(e){var i,t,n,a,l,o;if(ZC.AK(e.id))return n=ZC.AK(e.id),null!==ZC._n_(i=e.wh)&&(l=(""+i).split("/"),n.style.width=l[0]+"px",n.style.height=l[1]+"px"),null!==ZC._n_(i=e.tl)&&(o=(""+i).split("/"),n.style.top=o[0]+"px",n.style.left=o[1]+"px"),n;(a=(n=document.createElement("div")).style).whiteSpace="nowrap",null!==ZC._n_(i=e.wh)&&(l=(""+i).split("/"),e.width=l[0],e.height=l[1]),null!==ZC._n_(i=e.tl)&&(o=(""+i).split("/"),e.top=o[0],e.left=o[1]),null!==ZC._n_(i=e.id)&&(n.id=i),null!==ZC._n_(i=e.cls)&&""!==i&&(n.className=i);for(var r=[["top","","px"],["left","","px"],["width","","px"],["height","","px"],"position","overflow",["float","cssFloat|styleFloat"],["zidx","zIndex"],"clip","display",["fontSize","","px"],"fontFamily","fontWeight","fontStyle","textDecoration","textAlign","verticalAlign","color","border","borderTop","borderRight","borderBottom","borderLeft","background","cursor",["margin","marginTop|marginRight|marginBottom|marginLeft","px"],["marginTop","","px"],["marginRight","","px"],["marginBottom","","px"],["marginLeft","","px"],["padding","paddingTop|paddingRight|paddingBottom|paddingLeft","px"],["paddingTop","","px"],["paddingRight","","px"],["paddingBottom","","px"],["paddingLeft","","px"],"lineHeight","filter"],s=null,A=null,C=null,c=0,u=r.length;c<u;c++)if("string"==typeof r[c]&&(r[c]=[r[c]]),i=null,null!==ZC._n_(t=e[r[c][0]])&&(i=t),null!==ZC._n_(i)){null!==ZC._n_(r[c][1])&&""!==r[c][1]||(r[c][1]=r[c][0]);for(var p=r[c][1].split("|"),Z=0,h=p.length;Z<h;Z++){var d=i+(null===ZC._n_(r[c][2])?"":r[c][2]);a[p[Z]]=d,"fontFamily"===p[Z]&&(s=d),"fontSize"===p[Z]&&(A=ZC._i_(d)),"fontWeight"===p[Z]&&(C=d)}}return null!==ZC._n_(i=e.opacity)&&(a.opacity=i,1!==ZC._f_(i)&&(a.filter="alpha(opacity = "+ZC._i_(100*ZC._f_(i))+")",a.opacity=i)),null!==ZC._n_(i=e.p)&&(e.after?i.insertBefore(n,e.after.nextSibling):i.appendChild(n)),null!==ZC._n_(i=e.html)&&(n.innerHTML=ZC._h_(i),-1!==i.indexOf("<")&&-1!==i.indexOf(">")&&ZC.A5(n).children().each(function(){null!==ZC._n_(s)&&(null!==ZC._n_(this.style.fontFamily)&&""!==this.style.fontFamily||(this.style.fontFamily=s)),null!==ZC._n_(A)&&(null!==ZC._n_(this.style.fontSize)&&""!==this.style.fontSize||(this.style.fontSize=A+"px")),null!==ZC._n_(C)&&(null!==ZC._n_(this.style.fontWeight)&&""!==this.style.fontWeight||(this.style.fontWeight=C))})),e.rtl&&(n.style.unicodeBidi="bidi-override",n.style.direction="rtl"),e.cursor&&"hand"===e.cursor&&(n.style.cursor="pointer"),n},W1:null,A43:function(e,i,t,n,a,l,o){var r,s,A,C;null===ZC._n_(o)&&(o=!1);var c=!1;"[HTMLMODE]"===i.substring(0,10)&&(c=!0,i=i.substring(10)),C=e+"-text-ruler",-1!==e.indexOf("-fullscreen")&&(C="zc-text-ruler");var u="{{"+i+"}}"+t.replace(/[^a-z]/gi,"").toLowerCase()+n+l+a;if(ZC.cache.data["text-width-"+u]&&!o)return ZC.cache.data["text-width-"+u];if(ZC.cache.data["text-height-"+u]&&o)return ZC.cache.data["text-height-"+u];var p,Z=i;return Z=Z.replace(/<hr>/g,'<hr style="margin:0;padding:0">'),(p=ZC.AK(C))?(ZC.Q.W1&&ZC.Q.W1===e+t+n+l+a||(p.style.fontFamily=t,p.style.fontSize=n+"px",p.style.fontWeight=a,p.style.lineHeight=c?"130%":-1!==l?ZC._i_(l)+"px":"130%",ZC.Q.W1=e+t+n+l+a),p.innerHTML=Z):(p=ZC.Q.HY({id:C,p:document.body,tl:"-9999/-9999",html:Z,position:"absolute",fontFamily:t,fontSize:n,cls:"zc-text-ruler",fontWeight:a})).style.lineHeight=c?"130%":-1!==l?ZC._i_(l)+"px":"130%",-1===i.indexOf("<")||-1===i.indexOf(">")||c||ZC.A5(p).children().each(function(){"BR"!==this.tagName.toUpperCase()&&(null!==ZC._n_(this.style.fontFamily)&&""!==this.style.fontFamily||(this.style.fontFamily=t),null!==ZC._n_(this.style.fontSize)&&""!==this.style.fontSize||(this.style.fontSize=n+"px"),this.style.lineHeight=-1!==l?ZC._i_(l)+"px":"130%","B"!==this.tagName.toUpperCase()&&"STRONG"!==this.tagName.toUpperCase()&&(null!==ZC._n_(this.style.fontWeight)&&""!==this.style.fontWeight||(this.style.fontWeight=a)))}),(r=p.getBoundingClientRect())&&r.width>0?(s=r.width,o&&(A=r.height)):(s=ZC.mobile&&ZC.A5.browser.webkit?p.offsetWidth:ZC.A5(p).width(),o&&(A=ZC.mobile&&ZC.A5.browser.webkit?p.offsetHeight:ZC.A5(p).height())),o?(ZC.cache.add("text-height-"+u,A),A):(ZC.cache.add("text-width-"+u,s),s)}},!document.getElementsByClassName&&document.querySelectorAll&&(document.getElementsByClassName=function(e){return document.querySelectorAll("."+e)}),ZC.A5=function(e,i,t){var n,a,l,o,r=this;if(void 0===t&&(t=!0),t)return new ZC.A5(e,i,!1);if(r.P1=[],r.QD=e,r.MH=i,r.length=0,r.MH=r.MH||document.getElementsByTagName("body")[0],"object"==typeof r.QD)r.P1=[r.QD];else if("string"==typeof r.QD)for(var s=r.QD.split(","),A=0;A<s.length;A++){var C=ZC.GV(s[A]),c=!1;if(2===(n=C.split(">")).length&&(c=!0,ZC.A5(n[0]).each(function(){var e=this;ZC.A5(n[1],this).each(function(){this.parentNode===e&&r.P1.push(this)})})),2===(n=C.split(" ")).length&&(c=!0,ZC.A5(n[0]).each(function(){ZC.A5(n[1],this).each(function(){r.P1.push(this)})})),!c)if("#"===C.substring(0,1))ZC.AK(C.substring(1))&&(r.P1=[ZC.AK(C.substring(1))]);else if("."===C.substring(0,1))if(document.getElementsByClassName){if(r.MH.getElementsByClassName)a=r.MH.getElementsByClassName(C.substring(1));else if(a=document.getElementsByClassName(C.substring(1)),r.MH!==document){var u=[];for(l=0,o=a.length;l<o;l++)ZC.A5.childof(a[l],r.MH)&&u.push(a[l]);a=u}for(l=0,o=a.length;l<o;l++)r.P1.push(a[l])}else{var p=new RegExp("(^|\\s)"+C.substring(1)+"(\\s|$)","i"),Z=r.MH.getElementsByTagName("*"),h="";for(l=0,o=Z.length;l<o;l++)"object"==typeof(h=Z[l].className)&&(h="undefined"!=typeof h.baseVal?h.baseVal:""),""!==h&&p.test(h)&&r.P1.push(Z[l])}else for(l=0,o=(a=r.MH.getElementsByTagName(C)).length;l<o;l++)r.P1.push(a[l])}return r.length=r.P1.length,this},ZC.A5.prototype={eachfn:function(){for(var e,i=[],t=0,n=this.P1.length;t<n;t++){var a=[this.P1[t]];if((e=arguments.length)>1)for(var l=1;l<e;l++)a.push(arguments[l]);i.push(arguments[0].apply(this,a))}return i},each:function(){for(var e,i=0,t=this.P1.length;i<t;i++){var n=[this.P1[i]];if((e=arguments.length)>1)for(var a=1;a<e;a++)n.push(arguments[a]);arguments[0].apply(this.P1[i],n)}return this},children:function(){var e=[];return this.each(function(){for(var i=0,t=this.childNodes.length;i<t;i++)1===this.childNodes[i].nodeType&&e.push(this.childNodes[i])}),this.P1=e,this},remove:function(){this.eachfn.call(this,function(e){e&&e.parentNode&&e.parentNode.removeChild(e)})},empty:function(){this.eachfn.call(this,function(e){if(e)for(;e.childNodes.length;)e.removeChild(e.childNodes[e.childNodes.length-1])})},A2V:function(e){var i,t;void 0===e&&(e=!0);var n=this.eachfn.call(this,function(n){if(!n)return null;if(n===window){var a=document.body;return n.innerWidth?(i=n.innerWidth,t=n.innerHeight):a&&a.parentElement&&a.parentElement.clientWidth?(i=a.parentElement.clientWidth,t=a.parentElement.clientHeight):a&&a.clientWidth&&(i=a.clientWidth,t=a.clientHeight),{width:i,height:t}}var l,o,r=e?"block":ZC.A5(n).getstyle("display");if(window.getComputedStyle){var s=window.getComputedStyle(n,null);l=s.getPropertyValue("width").slice(0,-2),o=s.getPropertyValue("height").slice(0,-2)}else if(n.getBoundingClientRect){var A=n.getBoundingClientRect();l=A.width?A.width:n.offsetWidth,o=A.height?A.height:n.offsetHeight}else l=n.offsetWidth,o=n.offsetHeight;if("none"===r||""===r||void 0===r){var C=n.style,c=C.visibility,u=C.position,p=C.display;C.visibility="hidden",C.position="absolute",C.display="block",i=l,t=o,C.display=p,C.position=u,C.visibility=c}else i=l||0,t=o||0;return{width:i,height:t}});return 1===n.length?n[0]:n},getstyle:function(e){var i=this.eachfn.call(this,function(e,i){if("display"===i)return e.style.display;var t,n=document;if(i=ZC.EE(i),!e||e===n)return undefined;if("opacity"===i&&"undefined"!=typeof e.filters){var a=(ZC.A5(e).getstyle("filter")||"").match(/alpha\(opacity=(.*)\)/);return a&&a[1]?parseFloat(a[1])/100:1}if(-1!==ZC.AV(["float","cssFloat","styleFloat"],i))return(t=e.style.float)?t:(t=e.style.cssFloat)?t:(t=e.style.styleFloat)?t:"none";var l=e.style?e.style[i]:null;if(!l)if(n.defaultView&&n.defaultView.getComputedStyle){var o=n.defaultView.getComputedStyle(e,null);i=i.replace(/([A-Z])/g,"-$1").toLowerCase(),l=o?o.getPropertyValue(i):null}else if(e.currentStyle&&(l=e.currentStyle[i],/^\d/.test(l)&&!/px$/.test(l)&&"fontWeight"!==i)){var r=e.style.left,s=e.runtimeStyle.left;e.runtimeStyle.left=e.currentStyle.left,e.style.left=l||0,l=e.style.pixelLeft+"px",e.style.left=r,e.runtimeStyle.left=s}return"opacity"===i&&(l=parseFloat(l)),/Opera/.test(navigator.userAgent)&&-1!==ZC.AV(["left","top","right","bottom"],i)&&"static"===ZC.A5(e).getstyle("position")&&(l="auto"),"auto"===l?null:l},e);return 1===i.length?i[0]:i},wh:function(){var e;return this.P1[0]?null!==ZC._n_(e=ZC.A5(this.P1[0]).A2V())?[ZC._i_(e.width),ZC._i_(e.height)]:[0,0]:null},width:function(e){var i;if(void 0===e){var t=this.eachfn.call(this,function(e){return null!==ZC._n_(i=ZC.A5(e).A2V())?ZC._i_(i.width):0});return 1===t.length?t[0]:t}return this.eachfn.call(this,function(e,i){e.style.width=i+"px"},e),this},height:function(e){var i;if(void 0===e){var t=this.eachfn.call(this,function(e){return null!==ZC._n_(i=ZC.A5(e).A2V())?ZC._i_(i.height):0});return 1===t.length?t[0]:t}return this.eachfn.call(this,function(e,i){e.style.height=i+"px"},e),this},scrollLeft:function(){return ZC.A5.scroll().left},scrollTop:function(){return ZC.A5.scroll().top},css:function(e,i){if(void 0===i){var t=this.eachfn.call(this,function(i){var t=ZC.A5(i).getstyle(e);return-1!==(""+t).indexOf("px")?ZC._i_(t):t});return 1===t.length?t[0]:t}return this.eachfn.call(this,function(e,i,t){e.style[i]=t},e,i),this},attr:function(e,i){if(void 0===i){var t=this.eachfn.call(this,function(i){return i.getAttribute(e)});return 1===t.length?t[0]:t}return this.eachfn.call(this,function(e,i,t){e.setAttribute(i,t)},e,i),this},val:function(e){if(void 0===e){var i=this.eachfn.call(this,function(e){return e.value});return 1===i.length?i[0]:i}return this.eachfn.call(this,function(e,i){e.value=i},e),this},show:function(){return this.eachfn.call(this,function(e){e.style.display="block"}),this},hide:function(){return this.eachfn.call(this,function(e){e.style.display="none"}),this},offset:function(){var e=this.eachfn.call(this,function(e){if(!(e&&(e.x&&e.y||null!==!e.parentNode&&"none"!==ZC.A5(e).getstyle("display"))))return undefined;var i,t,n,a,l,o,r,s={top:0,left:0},A={top:0,left:0},C=e&&e.ownerDocument;return C&&((t=C.body)===e&&(s={top:t.offsetTop,left:t.offsetLeft}),i=C.documentElement,"undefined"!=typeof e.getBoundingClientRect&&(A=e.getBoundingClientRect()),n=C.defaultView||C.parentWindow,a=i.clientTop||t.clientTop||0,l=i.clientLeft||t.clientLeft||0,o=n.pageYOffset||i.scrollTop,r=n.pageXOffset||i.scrollLeft,s={top:A.top+o-a,left:A.left+r-l}),s});return 1===e.length?e[0]:e},bind:function(e,i,t){if(""!==(e=ZC.A5.cleanTouchEvents(e))){if(t||(t=!ZC.hasPassive||{passive:!0}),-1!==e.indexOf(" ")){for(var n=e.split(/\s+/),a=0;a<n.length;a++)this.bind(n[a],i,t);return this}return this.eachfn.call(this,function(e,i,n){function a(e){var i=(e=e||window.event).target||e.srcElement,t=ZC.A5.BZ(e);null!==t&&n.call(i,t)}ZC.A5.IY||(ZC.A5.IY=[]),ZC.A5.IY.push([e,i,n,a]),e.addEventListener?e.addEventListener(i,a,t):e.attachEvent("on"+i,a)},e,i),this}},unbind:function(e,i){if(""!==(e=ZC.A5.cleanTouchEvents(e))){if(-1!==e.indexOf(" ")){for(var t=e.split(/\s+/),n=0;n<t.length;n++)this.unbind(t[n],i);return this}return this.eachfn.call(this,function(e,i,t){if("undefined"!=typeof ZC.A5.IY)for(var n=0,a=ZC.A5.IY.length;n<a;n++)if((ZC.A5.IY[n][0]===e||e.tagName&&"MAP"===e.tagName.toUpperCase()&&e.id===ZC.A5.IY[n][0].id)&&ZC.A5.IY[n][1]===i&&ZC.A5.IY[n][2]===t){e.removeEventListener?e.removeEventListener(i,ZC.A5.IY[n][3],!0):e.detachEvent("on"+i,ZC.A5.IY[n][3]),ZC.A5.IY.splice(n,1);break}},e,i),this}},live:function(e,i,t){if(""!==(e=ZC.A5.cleanTouchEvents(e))){if(t||(t=!ZC.hasPassive||{passive:!0}),-1===e.indexOf("touch")&&-1===e.indexOf("wheel")||(t={passive:!1}),-1!==e.indexOf(" ")){for(var n=e.split(/\s+/),a=0;a<n.length;a++)this.live(n[a],i,t);return this}var l=this.QD;return ZC.A5.EVENTS||(ZC.A5.EVENTS={}),ZC.A5.EVENTS[e]||(ZC.A5.EVENTS[e]=[],document.addEventListener?document.addEventListener(e,o,t):document.attachEvent("on"+e,o)),ZC.A5.EVENTS[e].push([l,i]),this}function o(i){var t=(i=i||window.event).target||i.srcElement,n=t.className||"";"object"==typeof n&&(n="undefined"!=typeof n.baseVal&&null!==ZC._n_(n.baseVal)?n.baseVal:"");var l,o,r=ZC.A5.EVENTS[e],s=null,A=null,C=[];for(l=0,o=r.length;l<o;l++)("object"==typeof r[l][0]&&t===r[a][0]||"string"==typeof r[l][0]&&("."===r[l][0].substring(0,1)&&-1!==ZC.AV(n.split(" "),r[l][0].replace(".",""))||"#"===r[l][0].substring(0,1)&&t.id===r[l][0].substring(1)))&&(s=r[l][1],A=ZC.A5.BZ(i),null!==ZC._n_(s)&&null!==ZC._n_(A)&&C.push([s,t,A]));for(l=0,o=C.length;l<o;l++)C[l][0].call(C[l][1],C[l][2])}},die:function(e,i){if(""!==(e=ZC.A5.cleanTouchEvents(e))){var t,n,a;if(-1!==e.indexOf(" ")){for(n=0,a=(t=e.split(/\s+/)).length;n<a;n++)this.die(t[n],i);return this}var l=this.QD;if(ZC.A5.EVENTS||(ZC.A5.EVENTS={}),t=ZC.A5.EVENTS[e])for(n=t.length-1;n>=0;n--)t[n][0]!==l||i&&t[n][1]!==i||ZC.A5.EVENTS[e].splice(n,1);return this}}},ZC.A5._list_=function(e){for(var i=[],t=0;t<ZC.A5.EVENTS[e].length;t++)i.push(ZC.A5.EVENTS[e][t][0]);return i.join(",")},ZC.A5.cleanTouchEvents=function(e){return ZC.ie678&&(e=ZC.GV(e.replace(/touchstart|touchend|touchmove/,""))),e},ZC.A5.cache={},ZC.A5.browser={},function(){var e=/(webkit)[ \/]([\w.]+)/,i=/(opera)(?:.*version)?[ \/]([\w.]+)/,t=/(msie) ([\w.]+)/,n=/(mozilla)(?:.*? rv:([\w.]+))?/,a=/(trident)(?:.*? rv:([\w.]+))?/,l=function(l){l=l.toLowerCase();var o=e.exec(l)||i.exec(l)||t.exec(l)||a.exec(l)||l.indexOf("compatible")<0&&n.exec(l)||[];return[o[1]||"",o[2]||"0"]}(navigator.userAgent);l[0]&&("trident"===l[0]&&(l[0]="msie"),ZC.A5.browser[l[0]]=!0,ZC.A5.browser.version=l[1])}(),ZC.A5.scroll=function(){var e={top:0,left:0},i=document,t=i.documentElement,n=i.body;return t&&(t.scrollTop||t.scrollLeft)?(e.left=t.scrollLeft,e.top=t.scrollTop):n&&(e.left=n.scrollLeft,e.top=n.scrollTop),e},ZC.A5.BZ=function(e){if(e.originalEventZC=e,e.target||(e.target=e.srcElement||document),3!==e.target.nodeType&&8!==e.target.nodeType||(e.target=e.target.parentNode),null===ZC._n_(e.pageX)&&null!==ZC._n_(e.clientX)){var i=e.target.ownerDocument||document,t=i.documentElement,n=i.body;e.pageX=e.clientX+(t&&t.scrollLeft||n&&n.scrollLeft||0)-(t&&t.clientLeft||n&&n.clientLeft||0),e.pageY=e.clientY+(t&&t.scrollTop||n&&n.scrollTop||0)-(t&&t.clientTop||n&&n.clientTop||0)}return e.which||e.button===undefined||(e.which=1&e.button?1:2&e.button?3:4&e.button?2:0),e.preventDefault||(e.preventDefault=function(){this.returnValue=!1}),e.stopPropagation||(e.stopPropagation=function(){this.cancelBubble=!0}),e},ZC.A5.childof=function(e,i){if(e===i)return!0;for(;e!==i&&e.parentNode;)if((e=e.parentNode)===i)return!0;return!1},ZC.A5.ajax=function(e){var i=e.url||"",t=e.type||"GET",n=e.data||"",a=!0;"undefined"!=typeof e.async&&(a=ZC._b_(e.async)),""===n.replace(/\&/g,"")&&(n="");var l=e.beforeSend||null,o=e.error||null,r=e.success||null,s=null;try{window.ActiveXObject?s=new ActiveXObject("Microsoft.XMLHTTP"):window.XMLHttpRequest&&(s=new XMLHttpRequest)}catch(C){}var A="file:"===window.location.protocol;if(s){a&&(s.onreadystatechange=function(){4===s.readyState&&((A||s.status>=200&&s.status<300)&&r&&r(s.responseText,s.status,s,i),s.status>=400&&o&&o(s,s.status,s.statusText,i),s.onreadystatechange=new window.Function,s=null)}),window.ActiveXObject||(s.onerror=function(){o&&o(s,0,"",i)}),"POST"===t.toUpperCase()?(s.open("POST",i,a),s.setRequestHeader("X-Requested-With","XMLHttpRequest"),s.setRequestHeader("Content-type","application/x-www-form-urlencoded")):(""!==n&&(-1===i.indexOf("?")&&(i+="?"),i+="&"+n),s.open("GET",i,a)),l&&l(s);try{s.send(n),a||((A||s.status>=200&&s.status<300)&&r&&r(s.responseText,s.status,s,i),s.status>=400&&o&&o(s,s.status,s.statusText,i),s=null)}catch(c){A&&o&&(o(s,s.status,s.statusText,i),s.onreadystatechange=new window.Function,s=null)}}},ZC.AQ={ACI:function(e,i){var t,n,a=zingchart.DEV.SPREADFACTOR,l=[],o=0;function r(e,i){-1===ZC.AV(e,i)&&e.push(i)}for(t=0;t<e.length;t++)e[t]+=i;var s=-1;for(t=1;t<e.length;t++)ZC._a_(e[t]-e[t-1])<a?(l[o]=l[o]||{min:-1,max:-1,items:[]},-1===l[o].min&&(l[o].min=t>1?e[t-2]:i,-1===s&&(s=l[o].min),l[o].min),r(l[o].items,t-1),r(l[o].items,t)):l[o]&&(l[o].max=e[t],l[o].max,o++);l[o]&&-1===l[o].max&&(l[o].max=360+i);var A=l.length;if(A>1&&l[A-1].max-l[0].min==360){for(n=0;n<l[0].items.length;n++)e[l[0].items[n]]+=360;l[A-1].items=l[A-1].items.concat(l[0].items),l[A-1].max+=l[0].min,l=l.splice(1)}for(l.length>1&&(l[l.length-1].max=l[0].min+360),t=0;t<l.length;t++){var C=l[t],c=C.items.length,u=(C.max-C.min)/(c+4);u=ZC.CY(u,a);var p=0;for(n=0;n<C.items.length;n++)p+=e[C.items[n]];p/=C.items.length;for(var Z=!0;Z;)for(Z=!1,n=1;n<C.items.length;n++)if(e[C.items[n]]-e[C.items[n-1]]<u){e[C.items[n-1]]<p?(e[C.items[n-1]]-=.45,e[C.items[n]]+=.05):e[C.items[n]]+=.25,Z=!0;break}}return e},_int_:function(e){return Math.abs(e-ZC._i_(e))<Math.pow(10,-10)},XM:function(e,i,t){return t=t||1,!(e.x>i.x+i.width+t)&&(!(i.x>e.x+e.width+t)&&(!(e.y>i.y+i.height+t)&&!(i.y>e.y+e.height+t)))},_boxoverlap2_:function(e,i,t){return t=t||1,!(e.iX>i.iX+i.I+t)&&(!(i.iX>e.iX+e.I+t)&&(!(e.iY>i.iY+i.F+t)&&!(i.iY>e.iY+e.F+t)))},AG6:function(e,i){return e.iX>=i.iX&&e.iX<=i.iX+i.I&&e.iY>=i.iY&&e.iY<=i.iY+i.F&&e.iX+e.I>=i.iX&&e.iX+e.I<=i.iX+i.I&&e.iY+e.F>=i.iY&&e.iY+e.F<=i.iY+i.F},A6D:function(e,i,t){for(var n=Math.sqrt(e/Math.PI),a=Math.sqrt(i/Math.PI),l=Math.min(n,a),o=Math.max(n,a),r=ZC.MAX,s=0,A=l+o;A>o-l;A-=l/50){var C=l*l*Math.acos((A*A+l*l-o*o)/(2*A*l))+o*o*Math.acos((A*A+o*o-l*l)/(2*A*o))-.5*Math.sqrt((-A+l+o)*(A+l-o)*(A-l+o)*(A+l+o));Math.abs(C-t)<r&&(r=Math.abs(C-t),s=A)}return s},BN:function(e,i,t,n){return[e+t*Math.cos(2*n*Math.PI/360),i+t*Math.sin(2*n*Math.PI/360)]},A5I:function(e,i,t,n,a){var l=ZC.TK(Math.atan((n-i)/(t-e)));return[e+ZC._i_(ZC.EH(l)*a),i+ZC._i_(ZC.EP(l)*a)]},JT:function(e,i,t,n,a,l){if(a=null===ZC._n_(a)?0:a,l=null===ZC._n_(l)||l,t-e!=0){var o=0,r=0,s=Math.atan((n-i)/(t-e));return(a<1||l)&&(o=a/2.5*Math.cos(s),r=a/2.5*Math.sin(s)),[(e+t)/2+(e<t?o:-o),(i+n)/2+r]}return[e,(i+n)/2]},AB0:function(e,i){var t=(e[1]-i[1])/(e[0]-i[0]);return[t,e[1]-t*e[0]]},A4K:function(e,i,t,n){if(i[0]===n[0]&&i[1]===n[1])return i;if(e[0]===t[0]&&e[1]===t[1])return e;var a=ZC.AQ.AB0(e,i),l=a[0],o=a[1],r=ZC.AQ.AB0(t,n),s=r[0],A=(r[1]-o)/(l-s);return[A,l*A+o]},PR:function(e,i,t){null===ZC._n_(i)&&(i=5);var n=0,a=0;null!==ZC._n_(t)&&(n=t[0],a=t[1]);for(var l,o,r,s="",A=ZC.ie67?ZC.MAPTX:0,C=0,c=e.length;C<c;C++)e[C]&&(0===C?(o=e[C][0]+A+n,r=e[C][1]+A+a,l=C,s+=Math.round(o,10)+","+Math.round(r,10)+","):Math.sqrt((e[C][0]+A-o)*(e[C][0]+A-o)+(e[C][1]+A-r)*(e[C][1]+A-r))>i&&e[C-1]&&(Math.sqrt((e[C][0]-e[C-1][0])*(e[C][0]-e[C-1][0])+(e[C][1]-e[C-1][1])*(e[C][1]-e[C-1][1]))>i&&C-l>1&&(s+=Math.round(e[C-1][0]+A+n,10)+","+Math.round(e[C-1][1]+A+a,10)+","),o=e[C][0]+A+n,r=e[C][1]+A+a,l=C,s+=Math.round(o,10)+","+Math.round(r,10)+","));return s=s.substring(0,s.length-1)},Z0:function(e,i){if(null===ZC._n_(e)||e.length<2)return"";null===ZC._n_(i)&&(i=6,ZC.mobile&&(i+=10));var t,n,a,l,o,r=[];for(t=0,n=e.length;t<n;t++)(0===t||t>0&&null!==ZC._n_(e[t])&&null!==ZC._n_(e[t-1])&&e[t].join("/")!==e[t-1].join("/")||null===ZC._n_(e[t]))&&r.push(e[t]);var s=[],A=[],C=!1;for(t=0,n=r.length;t<n;t++)if(r[t]){var c,u,p,Z,h=r[t][0],d=r[t][1];if(r[t-1]&&(p=r[t-1][0],Z=r[t-1][1],p===h&&(p-=.1)),r[t+1]&&(c=r[t+1][0],u=r[t+1][1],c===h&&(c+=.1)),0===t)a=Math.atan((u-d)/(c-h)),o=l=ZC.TK(a),c>=h&&(o+=180),s.push(ZC.AQ.BN(h,d,i,l+90),ZC.AQ.BN(h,d,i,o),ZC.AQ.BN(h,d,i,l+270));else if(t===r.length-1)a=Math.atan((Z-d)/(p-h)),o=l=ZC.TK(a),p>=h&&(o+=180),C?(A.push(ZC.AQ.BN(h,d,i,l+270),ZC.AQ.BN(h,d,i,o),ZC.AQ.BN(h,d,i,l+90)),C=!1):s.push(ZC.AQ.BN(h,d,i,l+270),ZC.AQ.BN(h,d,i,o),ZC.AQ.BN(h,d,i,l+90));else{var f=Math.atan((u-d)/(c-h)),_=Math.atan((d-Z)/(h-p));o=ZC.TK((f+_)/2),s.push(ZC.AQ.BN(h,d,i,o+270)),c>=h&&p>=h?(s.push(ZC.AQ.BN(h,d,i,o+180)),s.push(ZC.AQ.BN(h,d,i,o+90)),A.push(ZC.AQ.BN(h,d,i,o)),C=!0):c<=h&&p<=h?(s.push(ZC.AQ.BN(h,d,i,o)),s.push(ZC.AQ.BN(h,d,i,o+90)),A.push(ZC.AQ.BN(h,d,i,o+180)),C=!0):A.push(ZC.AQ.BN(h,d,i,o+90))}}for(t=A.length-1;t>=0;t--)s.push(A[t]);return s},A2C:function(e,i){var t=0,n=0,a=[];switch(e+=""){case"horizontal":case"h":t=1,n=i;break;case"vertical":case"v":t=i,n=1;break;default:a=e.split("x"),null!==ZC._n_(a[0])&&ZC._i_(a[0])+""===a[0]&&(t=ZC._i_(a[0])),null!==ZC._n_(a[1])&&ZC._i_(a[1])+""===a[1]&&(n=ZC._i_(a[1])),0===n&&0===t?(t=Math.ceil(Math.sqrt(i)),n=Math.ceil(i/t)):(0===n&&(n=Math.ceil(i/t)),0===t&&(t=Math.ceil(i/n)))}return[t,n]},AB4:function(e,i){return.5*(2*i[1]+(-i[0]+i[2])*e+(2*i[0]-5*i[1]+4*i[2]-i[3])*e*e+(-i[0]+3*i[1]-3*i[2]+i[3])*e*e*e)},AB7:function(e,i){var t,n,a,l,o,r=e.length,s=[],A=[],C=[];for(t=0;t<r-1;t++)n=e[t+1]-e[t],a=i[t+1]-i[t],A.push(n),s.push(a),C.push(a/n);var c=[C[0]];for(t=0;t<A.length-1;t++){l=C[t];var u=C[t+1];if(l*u<=0)c.push(0);else{n=A[t];var p=A[t+1];o=n+p,c.push(3*o/((o+p)/l+(o+n)/u))}}c.push(C[C.length-1]);var Z=[],h=[];for(t=0;t<c.length-1;t++){l=C[t];var d=c[t],f=1/A[t];o=d+c[t+1]-l-l,Z.push((l-d-o)*f),h.push(o*f*f)}return function(t){var n=e.length-1;if(t===e[n])return i[n];for(var a,l=0,o=h.length-1;l<=o;){a=Math.floor(.5*(l+o));var r=e[a];if(r<t)l=a+1;else{if(!(r>t))return i[a];o=a-1}}n=Math.max(0,o);var s=t-e[n],A=s*s;return i[n]+c[n]*s+Z[n]*A+h[n]*s*A}},Y9:function(e,i,t,n){null===ZC._n_(n)&&(n=1/(t/i.length*4));var a,l,o=[];if(e)if((a=[].concat(i))[1]&&a[2]){a[0]=a[0]||a[1]||a[2]||a[3],a[1]=a[1]||a[2]||a[0]||a[3],a[2]=a[2]||a[3]||a[1]||a[0],a[3]=a[3]||a[2]||a[1]||a[0];var r=ZC.AQ.AB7([0,1,2,3],a);for(l=1;l<=2;l+=n)o.push([l-1,r(l)])}else o.push([]);else for(var s=1;s<i.length-2;s++)if(1!==n)if((a=[i[s-1],i[s],i[s+1],i[s+2]])[1]&&a[2])for(a[0]=a[0]||a[1]||a[2]||a[3],a[1]=a[1]||a[2]||a[0]||a[3],a[2]=a[2]||a[3]||a[1]||a[0],a[3]=a[3]||a[2]||a[1]||a[0],l=0;l<=1;l+=n){var A=s+l,C=ZC.AQ.AB4(l,a);o.push([A-1,C])}else o.push([]);else o.push([s-1,i[s]]);return o},A0K:function(e){for(var i=Math.round(ZC.G6(ZC._a_(e))/Math.LN10),t=[1,2,4,5,6,8,10],n=ZC.MAX,a=1,l=0;l<t.length;l++){var o=t[l]*Math.pow(10,i)-e;ZC._a_(o)<n&&(a=t[l],n=ZC._a_(o))}return a*Math.pow(10,i)},_nice_number_:function(e,i){var t,n;return t=Math.floor(Math.log(e)/Math.log(10)),n=e/Math.pow(10,t),(i?n<1.5?1:n<3?2:n<7?5:10:n<=1?1:n<=2?2:n<=5?5:10)*Math.pow(10,t)},VS:function(e,i,t,n,a,l){var o,r,s,A,C,c;null===ZC._n_(a)&&(a=!0),l=null===ZC._n_(l)?10:Math.min(Math.max(2,l),100),null!==ZC._n_(n)&&0!==n||(n=1);var u=Math.floor(ZC.G6(ZC._a_(i))/Math.LN10);e===i&&(i+=Math.pow(10,u)),o=e,r=i,A=ZC.AQ._nice_number_(r-o,!1),null===ZC._n_(t)?(s=A/(l-1),s=ZC.AQ._nice_number_(s,!0),s*=n):s=t,a?(C=Math.floor(o/s)*s,c=Math.ceil(r/s)*s):(C=o,c=r,s=null===ZC._n_(t)?A/(l-1):t);var p=Math.floor(ZC.G6(ZC._a_(s))/Math.LN10),Z=p<0?ZC._a_(p):0;if(0===Z){var h=(""+s).split(".");2===h.length&&(Z=h[1].length)}return[C,c,s,Z,s]}},ZC.XK={md5:function(e){return ZC.XK.ACT(ZC.XK.ACU(ZC.XK.ACQ(e)))},ACU:function(e){return ZC.XK.AC6(ZC.XK.ACV(ZC.XK.ACD(e),8*e.length))},ACT:function(e){for(var i,t="",n=0,a=e.length;n<a;n++)i=e.charCodeAt(n),t+="0123456789abcdef".charAt(i>>>4&15)+"0123456789abcdef".charAt(15&i);return t},ACQ:function(e){for(var i,t,n="",a=-1,l=e.length;++a<l;)i=e.charCodeAt(a),t=a+1<l?e.charCodeAt(a+1):0,55296<=i&&i<=56319&&56320<=t&&t<=57343&&(i=65536+((1023&i)<<10)+(1023&t),a++),i<=127?n+=String.fromCharCode(i):i<=2047?n+=String.fromCharCode(192|i>>>6&31,128|63&i):i<=65535?n+=String.fromCharCode(224|i>>>12&15,128|i>>>6&63,128|63&i):i<=2097151&&(n+=String.fromCharCode(240|i>>>18&7,128|i>>>12&63,128|i>>>6&63,128|63&i));return n},ACD:function(e){var i,t=Array(e.length>>2);for(i=0;i<t.length;i++)t[i]=0;for(i=0;i<8*e.length;i+=8)t[i>>5]|=(255&e.charCodeAt(i/8))<<i%32;return t},AC6:function(e){for(var i="",t=0;t<32*e.length;t+=8)i+=String.fromCharCode(e[t>>5]>>>t%32&255);return i},ACV:function(e,i){function t(e,i,t,n,a,l){return r((o=r(r(i,e),r(n,l)))<<(s=a)|o>>>32-s,t);var o,s}function n(e,i,n,a,l,o,r){return t(i&n|~i&a,e,i,l,o,r)}function a(e,i,n,a,l,o,r){return t(i&a|n&~a,e,i,l,o,r)}function l(e,i,n,a,l,o,r){return t(i^n^a,e,i,l,o,r)}function o(e,i,n,a,l,o,r){return t(n^(i|~a),e,i,l,o,r)}function r(e,i){var t=(65535&e)+(65535&i);return(e>>16)+(i>>16)+(t>>16)<<16|65535&t}e[i>>5]|=128<<i%32,e[14+(i+64>>>9<<4)]=i;for(var s=1732584193,A=-271733879,C=-1732584194,c=271733878,u=0,p=e.length;u<p;u+=16){var Z=s,h=A,d=C,f=c;A=o(A=o(A=o(A=o(A=l(A=l(A=l(A=l(A=a(A=a(A=a(A=a(A=n(A=n(A=n(A=n(A,C=n(C,c=n(c,s=n(s,A,C,c,e[u],7,-680876936),A,C,e[u+1],12,-389564586),s,A,e[u+2],17,606105819),c,s,e[u+3],22,-1044525330),C=n(C,c=n(c,s=n(s,A,C,c,e[u+4],7,-176418897),A,C,e[u+5],12,1200080426),s,A,e[u+6],17,-1473231341),c,s,e[u+7],22,-45705983),C=n(C,c=n(c,s=n(s,A,C,c,e[u+8],7,1770035416),A,C,e[u+9],12,-1958414417),s,A,e[u+10],17,-42063),c,s,e[u+11],22,-1990404162),C=n(C,c=n(c,s=n(s,A,C,c,e[u+12],7,1804603682),A,C,e[u+13],12,-40341101),s,A,e[u+14],17,-1502002290),c,s,e[u+15],22,1236535329),C=a(C,c=a(c,s=a(s,A,C,c,e[u+1],5,-165796510),A,C,e[u+6],9,-1069501632),s,A,e[u+11],14,643717713),c,s,e[u],20,-373897302),C=a(C,c=a(c,s=a(s,A,C,c,e[u+5],5,-701558691),A,C,e[u+10],9,38016083),s,A,e[u+15],14,-660478335),c,s,e[u+4],20,-405537848),C=a(C,c=a(c,s=a(s,A,C,c,e[u+9],5,568446438),A,C,e[u+14],9,-1019803690),s,A,e[u+3],14,-187363961),c,s,e[u+8],20,1163531501),C=a(C,c=a(c,s=a(s,A,C,c,e[u+13],5,-1444681467),A,C,e[u+2],9,-51403784),s,A,e[u+7],14,1735328473),c,s,e[u+12],20,-1926607734),C=l(C,c=l(c,s=l(s,A,C,c,e[u+5],4,-378558),A,C,e[u+8],11,-2022574463),s,A,e[u+11],16,1839030562),c,s,e[u+14],23,-35309556),C=l(C,c=l(c,s=l(s,A,C,c,e[u+1],4,-1530992060),A,C,e[u+4],11,1272893353),s,A,e[u+7],16,-155497632),c,s,e[u+10],23,-1094730640),C=l(C,c=l(c,s=l(s,A,C,c,e[u+13],4,681279174),A,C,e[u],11,-358537222),s,A,e[u+3],16,-722521979),c,s,e[u+6],23,76029189),C=l(C,c=l(c,s=l(s,A,C,c,e[u+9],4,-640364487),A,C,e[u+12],11,-421815835),s,A,e[u+15],16,530742520),c,s,e[u+2],23,-995338651),C=o(C,c=o(c,s=o(s,A,C,c,e[u],6,-198630844),A,C,e[u+7],10,1126891415),s,A,e[u+14],15,-1416354905),c,s,e[u+5],21,-57434055),C=o(C,c=o(c,s=o(s,A,C,c,e[u+12],6,1700485571),A,C,e[u+3],10,-1894986606),s,A,e[u+10],15,-1051523),c,s,e[u+1],21,-2054922799),C=o(C,c=o(c,s=o(s,A,C,c,e[u+8],6,1873313359),A,C,e[u+15],10,-30611744),s,A,e[u+6],15,-1560198380),c,s,e[u+13],21,1309151649),C=o(C,c=o(c,s=o(s,A,C,c,e[u+4],6,-145523070),A,C,e[u+11],10,-1120210379),s,A,e[u+2],15,718787259),c,s,e[u+9],21,-343485551),s=r(s,Z),A=r(A,h),C=r(C,d),c=r(c,f)}return Array(s,A,C,c)}},"undefined"==typeof zingchart&&(zingchart={ADG:!0}),zingchart.clipart={},zingchart.widgets={},zingchart.plugins={},zingchart.pool={},zingchart.pool.size=0,zingchart.pool.data={},zingchart.pool.getInstance=function(e,i,t,n){var a;if(null!==ZC._n_(zingchart.pool.data[t]))(a=zingchart.pool.data[t])._POOL_=!0,ZC.SKIPOBJCOUNT=!0,n||(a.$i(i),a.K=t),ZC.SKIPOBJCOUNT=!1;else{switch(e){case"DN":a=new ZC.DN(i);break;case"HL":a=new ZC.HL(i);break;case"DT":a=new ZC.DT(i);break;case"OY":a=new ZC.OY(i);break;case"D0":a=new ZC.D0(i)}a.K=t,zingchart.pool.size++,zingchart.pool.size>zingchart.DEV.MAXPOOLSIZE?(zingchart.pool.data={},zingchart.pool.size=0):zingchart.pool.data[t]=a}return a},zingchart.i18n={},zingchart.THEMES={},zingchart.V3D=2,zingchart.QUOTEDVALUES=!1,zingchart.EDITSOURCE=1,zingchart.MODULESDEP={line:"xy",line3d:"3d,line",area:"xy",area3d:"3d,area",vline:"yx",varea:"yx",vbar:"xy",vbar3d:"3d,vbar",hbar:"yx",hbar3d:"3d,hbar",scatter:"xy",bubble:"xy",hscatter:"yx",hbubble:"yx",pie:"r",pie3d:"3d,pie",nestedpie:"r",gauge:"r",vbullet:"vbar",hbullet:"hbar",vfunnel:"xy",hfunnel:"yx",piano:"xy",radar:"r",range:"xy",vrange:"yx",stock:"xy,vbar",venn:"r"},zingchart.SKIP={EVENT:!1,ANIMATION:!1,LEGEND:!1,CSV:!1,PARSE3D:!1},zingchart.MODULESDIR=function(e){for(var i=0;i<e.length;i++){if(e[i].src)if(e[i].src.indexOf("zingchart.min.js")>-1)return e[i].src.split("zingchart.min.js")[0]+"modules/"}return"./modules/"}(document.getElementsByTagName("head")[0].childNodes),zingchart.DEV={DOMFRAGMENTS:1,SORTTOKENS:1,PLOTSTATS:1,RESOURCES:1,KEEPSOURCE:1,SPREADTYPE:0,SPREADFACTOR:10,IGNORESUBUNIT:0,DELAYEDTRACKERS:0,STACKINGLOGIC:-1,SMARTDATELABELS:0,GC:1,CACHECANVASTEXT:0,CHECKDECIMALS:0,CACHESELECTION:0,MEDIARULES:1,SKIPTRACKERS:0,PLOTSHLAYER:0,RESIZESPEED:250,DEBOUNCESPEED:250,LOCALSVGEXPORT:1,SKIPPROGRESS:0,SKIPCONTEXTMENU:0,COPYDATA:1,GUIDETIMEOUT:0,LOOKUPCSSTRANSFORM:0,MAPSONBOTTOM:0,MAXPOOLSIZE:1024,MINTRACKERDIFF:1.5},zingchart.CANVASTEXT=0,zingchart.ZINDEX=1,zingchart.CMZINDEX=9999,zingchart.FSZINDEX=9998,zingchart.FSID=null,zingchart.ZCOUTPUT=0,zingchart.ASYNC=0,zingchart.SORTTRACKERS=0,zingchart.TIMEOUT=0,zingchart.USERCSS={},zingchart.OBJECTMODE="normal",zingchart.SYNTAX="mixed",zingchart.THEME=null,zingchart.EXPORTURL=("file:"===document.location.protocol?"http:":document.location.protocol)+"//export.zingchart.com/",zingchart.AJAXEXPORT=!1,zingchart.TOUCHZOOM="normal",zingchart.DEFAULT={height:480,width:640},zingchart.FASTWIDTH=0,zingchart.FONTSIZE=11,zingchart.FONTFAMILY="Lucida Sans Unicode,Lucida Grande,Lucida Sans,Helvetica,Arial,sans-serif",ZC.mobile&&(zingchart.FONTFAMILY="Lucida Sans,Helvetica,Arial,sans-serif"),zingchart.loadModules=function(e,i){for(var t=(""+e).split(","),n=0,a=t.length;n<a;n++){var l=ZC.GV(t[n]);l=ZC.ALIAS[l]||l,-1!==ZC.AV(["bar","bar3d","funnel","bullet"],l)&&(l="v"+l);var o=zingchart.MODULESDEP[l];null!==ZC._n_(o)&&zingchart.loadModules(o),-1===ZC.AV(ZC.RH,l)&&ZC.RH.push(l)}i&&zingchart.A1E(null,ZC.RH,i)},zingchart.A1E=function(e,i,t){var n=0;if(0===i.length)t();else{if(!document.getElementsByTagName("head")[0])return void t();!function a(){var l,o=!0;function r(){++n===i.length?t():a()}zingchart.ACL(i[n])?l=zingchart.MODULESDIR+"zingchart-"+i[n]+".min.js":o=!1,o?ZC.AP.ACC(e,l,r):r()}()}},zingchart.ACL=function(e){return-1!==ZC.AV(ZC.RH,e)&&-1===ZC.AV(ZC.WI,e)},zingchart.LH=[],ZC.ie67||function(){for(var e in ZC.IMAGES)ZC.IMAGES.hasOwnProperty(e)&&(zingchart.LH[e]=new Image,zingchart.LH[e].src=ZC.IMAGES[e])}(),"undefined"!=typeof Ext&&(zingchart.LH["zc.blank"]=new Image,zingchart.LH["zc.blank"].src=ZC.BLANK),zingchart.exec=function(e,i,t){return zingchart.exec_flash?zingchart.exec_flash(e,i,t):null},zingchart.AD4=function(O){var QM=O.dataurl||"",EW="",G,M9=null;null!==ZC._n_(G=O.data)&&("string"==typeof G?EW=G:M9=JSON.parse(JSON.stringify(G)));var DL=null;if(""!==QM)ZC.A5.ajax({type:"GET",url:QM,async:!1,data:zingchart.ZCOUTPUT?"zcoutput=userdef":"",error:function(){return!1},success:function(KC){function _f_(e){ZC.cache.data["data-"+QM]=KC,O.output="auto",ZC._cp_(e.render,O)}try{DL=JSON.parse(KC),_f_(DL)}catch(JA){try{DL=eval("("+KC+")"),_f_(DL)}catch(JA){return!1}}}});else{if(""!==EW)try{DL=JSON.parse(EW)}catch(JA){return!1}else null!==M9&&(DL=M9);null===ZC._n_(O.output)&&(O.output="auto"),ZC._cp_(DL.render,O)}return zingchart.render(O)},zingchart.A01=null,zingchart.params={},zingchart.render=function(e,i){if(null===ZC._n_(i)&&(i=!1),i)return zingchart.AD4(e);null===ZC._n_(ZC.canvas)&&ZC.compat();var t=e.output||"auto";"html5"===t&&(t="auto"),ZC.mobile&&"auto"===t&&(t="svg");var n=!1;if("!"===t.substring(0,1)&&(n=!0,t=t.substring(1)),n||("auto"===t||"canvas"===t&&!ZC.canvas||"svg"===t&&!ZC.svg||"vml"===t&&!ZC.vml||"flash"===t&&!ZC.flash)&&(ZC.svg?t="svg":ZC.canvas?t="canvas":ZC.vml?t="vml":ZC.flash&&(t="flash")),"vml"===t&&null===ZC._n_(zingchart.A01)&&(zingchart.A01=!1),"flash"!==t)return zingchart.A8O(e,t);zingchart.render_flash(e)},document.attachEvent&&("complete"===document.readyState?zingchart.A01=!0:document.attachEvent("onreadystatechange",function(){"complete"===document.readyState&&(zingchart.A01=!0)})),zingchart.setlabel=zingchart.setLabel=function(e,i){ZC.HJ[e]=i},zingchart.HZ=[],zingchart.XZ={},zingchart.ADF=0,zingchart.AD1=0,zingchart.ADD=!1,zingchart.AA4=!1,zingchart.AA3=!1,zingchart.ACX=!1,zingchart.css=null,zingchart.WX=function(e){if(e.target.id){for(var i=null,t=0,n=zingchart.HZ.length;t<n;t++)e.target.id.substr(0,zingchart.HZ[t].K.length+1)===zingchart.HZ[t].K+"-"&&(i=zingchart.HZ[t]);return i}},ZC.GESTURE={id:null,on:!1,ts:null,type:null,dist:-1,mp:[-1,-1]},"undefined"==typeof zingchart.MI&&(zingchart.MI=function(e){if(e.target&&e.target.tagName&&"INPUT"!==e.target.tagName.toUpperCase()&&"TEXTAREA"!==e.target.tagName.toUpperCase()){var i;if("pinch"===zingchart.TOUCHZOOM)switch(ZC.TOUCHEVENTS=!1,e.type){case"touchstart":for(var t=!1,n=0;n<zingchart.HZ.length;n++)i=ZC.A5("#"+zingchart.HZ[n].K+"-top"),ZC.DS(e.touches[0].pageX,i.offset().left,i.offset().left+i.width())&&ZC.DS(e.touches[0].pageY,i.offset().top,i.offset().top+i.height())&&(t=!0,ZC.GESTURE.id=zingchart.HZ[n].K);t&&(ZC.GESTURE.on=!0);break;case"touchmove":if(ZC.GESTURE.on&&2===e.touches.length){e.preventDefault();var a=(e.touches[0].clientX-e.touches[1].clientX)*(e.touches[0].clientX-e.touches[1].clientX)+(e.touches[0].clientY-e.touches[1].clientY)*(e.touches[0].clientY-e.touches[1].clientY);a=Math.round(Math.sqrt(a));var l=[Math.round((e.touches[0].clientX+e.touches[1].clientX)/2),Math.round((e.touches[0].clientY+e.touches[1].clientY)/2)];if(-1===ZC.GESTURE.dist)ZC.GESTURE.dist=a,ZC.GESTURE.mp=l,ZC.GESTURE.ts=(new Date).getTime();else if((new Date).getTime()-ZC.GESTURE.ts>100){if(a>ZC.GESTURE.dist+50)ZC.GESTURE.type="pinch-in",zingchart.exec(ZC.GESTURE.id,"zoomin");else if(a<ZC.GESTURE.dist-50)ZC.GESTURE.type="pinch-out",zingchart.exec(ZC.GESTURE.id,"zoomout");else{ZC.GESTURE.type="panning";var o={};l[0]>ZC.GESTURE.mp[0]+10?(o["x-"]=!0,o.xdist=ZC._a_(ZC.GESTURE.mp[0]-l[0])):l[0]<ZC.GESTURE.mp[0]-10&&(o["x+"]=!0,o.xdist=ZC._a_(ZC.GESTURE.mp[0]-l[0])),l[1]>ZC.GESTURE.mp[1]+10?(o["y+"]=!0,o.ydist=ZC._a_(ZC.GESTURE.mp[1]-l[1])):l[1]<ZC.GESTURE.mp[1]-10&&(o["y-"]=!0,o.ydist=ZC._a_(ZC.GESTURE.mp[1]-l[1])),ZC.GESTURE.mp=l,zingchart.exec(ZC.GESTURE.id,"pan",o)}ZC.GESTURE.ts=(new Date).getTime()}}break;case"touchend":ZC.GESTURE.id=null,ZC.GESTURE.on=!1,ZC.GESTURE.type=null,ZC.GESTURE.ts=null,ZC.GESTURE.dist=-1,ZC.GESTURE.mp=[-1,-1]}if(window.ZC){window.ZC.E1=[e.pageX,e.pageY];var r=zingchart.WX(e);if(r){if(!zingchart.SKIP.EVENT){if("mousedown"===e.type&&(window.ZC.aMDXY=[e.pageX,e.pageY]),"touchstart"===e.type&&r.AG)for(var s=0;s<r.AG.length;s++)r.AG[s].LD();if(-1!==ZC.AV(["mouseover","mouseout","mouseover"],e.type)&&"IMG"!==e.target.tagName.toUpperCase())return;if("mouseout"===e.type&&(i=ZC.A5("#"+r.K+"-top"),ZC.DS(e.pageX,i.offset().left,i.offset().left+i.width(),!0)&&ZC.DS(e.pageY,i.offset().top,i.offset().top+i.height(),!0)))return;ZC.AP.BY(e.type,r,zingchart.A0A(e,r))}zingchart.SKIP.EVENT=!1}}}},ZC.A5(document).bind(ZC.Q.BZ("mouseover"),zingchart.MI).bind(ZC.Q.BZ("mouseout"),zingchart.MI).bind(ZC.Q.BZ("mousemove"),zingchart.MI).bind(ZC.Q.BZ("mousedown"),zingchart.MI).bind(ZC.Q.BZ("mouseup"),zingchart.MI)),zingchart.A0A=function(e,i){var t=ZC.Q.MB(e),n=i.A4A(t[0],t[1]),a=ZC.A5("#"+i.K+"-top"),l=Math.round(t[0]-a.offset().left),o=Math.round(t[1]-a.offset().top),r="none";return/(.*)\-scale\_(.*)\-item\_title\-area(.*)/.test(e.target.id)&&(r="scale-title"),/(.*)\-scale\_(.*)\-item\_(\d+)\-area(.*)/.test(e.target.id)&&(r="scale-item"),/(.*)\-plotset\-plot\-(\d+)\-node\-(\d+)(.*)/.test(e.target.id)&&(r="node"),/(.*)\-legend\-item\_(\d+)\-area/.test(e.target.id)&&(r="legend-item"),/(.*)\-legend\-marker\_(\d+)\-area/.test(e.target.id)&&(r="legend-marker"),/(.*)\-legend\-(.+)\-area/.test(e.target.id)&&(r="legend-element"),/(.*)\-menu\-item\-(.*)/.test(e.target.id)&&(r="menu-item"),/(.*)\-preview\-handler\-x(.*)/.test(e.target.id)&&(r="preview"),/(.*)\-shape\-(.*?)\-area/.test(e.target.id)&&(r="shape"),/(.*)\-label\-(.*?)\-area/.test(e.target.id)&&(r="label"),{id:i.K,ev:ZC.A5.BZ(e),targetid:e.target.id,graphid:n?n.K:null,target:r,x:l,y:o,plotarea:!!n&&(l>=n.P.iX&&l<=n.P.iX+n.P.I&&o>=n.P.iY&&o<=n.P.iY+n.P.F),touch:ZC.mobile}},"undefined"==typeof zingchart.SB&&(zingchart.SB=function(e){for(var i=0,t=zingchart.HZ.length;i<t;i++)zingchart.HZ[i].hideCM();if(ZC.mobile&&ZC.move)ZC.move=!1;else if(ZC.mobile||!(e.which>1)){var n=zingchart.WX(e);if(n){if("click"===e.type&&ZC.aMDXY&&(ZC._a_(ZC.aMDXY[0]-e.pageX)>2||ZC._a_(ZC.aMDXY[1]-e.pageY)>2))return;if(!zingchart.SKIP.EVENT){var a=zingchart.A0A(e,n);a.target=zingchart.plugins.CLICK_TARGET||a.target,zingchart.plugins.CLICK_TARGET=null,ZC.mobile&&"touchend"===e.type&&(n.E["click-ts"]&&(new Date).getTime()-n.E["click-ts"]<500&&ZC.AP.BY("dblclick",n,a),n.E["click-ts"]=(new Date).getTime()),ZC.AP.BY("dblclick"===e.type?"dblclick":"click",n,a)}zingchart.SKIP.EVENT=!1,e.target.id!==n.K+"-menu-area"?n.hideCM():zingchart.YS(e)}}},ZC.mobile?(ZC.A5(document).bind("touchmove",function(){ZC.move=!0}),ZC.A5(document).bind("touchend",function(){ZC.move=!1})):(ZC.A5(document).bind("click",zingchart.SB),ZC.A5(document).bind("dblclick",zingchart.SB))),"undefined"==typeof zingchart.A2S&&(zingchart.A2S=function(e){e.touches.length>0&&(ZC.TOUCHEVENTS=!0)},ZC.A5(document).bind("touchstart",zingchart.A2S)),"undefined"==typeof zingchart.YS&&(zingchart.YS=function(e,i,t){if(!(e&&e.target&&e.target.tagName&&"IMG"!==e.target.tagName.toUpperCase()&&"AREA"!==e.target.tagName.toUpperCase()&&-1===ZC.Q.T8(e.target).indexOf("zc-scroll")&&-1===e.target.id.indexOf("-legend-")&&-1===e.target.id.indexOf("-preview-"))||zingchart.DEV.SKIPTRACKERS){var n,a,l,o,r,s;t=t||{};var A=null===ZC._n_(i)?zingchart.WX(e):zingchart.getLoader(i);if(A){if(-1!==ZC.AV(A.KR,"skip_context_menu"))return!1;if(null===ZC._n_(i)?(a=ZC.Q.MB(e),n=A.A4A(a[0],a[1])):n=null!==ZC._n_(t.graphid)?A.OQ(t.graphid):A.AG[0],!n)return!1;var C=ZC.A5("#"+A.K+"-top");null===ZC._n_(i)?(l=a[0]-C.offset().left,o=a[1]-C.offset().top):(l=A.I/2,o=A.F/2);var c={};e&&(c=zingchart.A0A(e,A));var u=ZC.AP.BY("contextmenu",A,c,!0);if(!u&&void 0!==u&&(!e&&!t["from-api"]||e&&e.target.id!==A.K+"-menu-area"))return e.preventDefault(),!1;var p=ZC._tx_(A.K);A.A5T(n?n.L:-1,e);var Z=-1;if(0!==zingchart.CMZINDEX)Z=zingchart.CMZINDEX;else for(var h=ZC.AK(A.K);-1===Z&&null!==h.parentNode;)"auto"!==(Z=ZC._i_(ZC.A5(h).css("zIndex")))&&""!==Z&&null!==ZC._n_(Z)||(Z=-1),h=h.parentNode;Z&&-1!==Z&&null!==ZC._n_(Z)||(Z=1);var d=ZC.A5("#"+A.K+"-menu");if(d.css("zIndex",zingchart.ZINDEX+Z+1),null===ZC._n_(i)){if(e.target.id===A.K+"-print-png"||e.target.id===A.K+"-print-jpeg")return!0;e.preventDefault()}if(!ZC.AK(A.K+"-menu"))return!1;l=C.offset().left,o=C.offset().top;var f=C.width(),_=C.height();null===ZC._n_(i)?(r=(a=ZC.Q.MB(e))[0]||ZC.E1[0],s=a[1]||ZC.E1[1]):(r=l+A.I/2,s=o+5);var g=!1;if(A.VL("goback",!1),A.NS>0&&(A.VL("goback",!0),g=!0),A.VL("goforward",!1),A.NS<A.QL.length-1&&(A.VL("goforward",!0),g=!0),A.VL("history",g,!0),r>=l&&r<=l+f*p[0]&&s>=o&&s<=o+_*p[1]){ZC.A5(".zc-menu").each(function(){this.id!==A.K+"-menu"&&A.hideCM()}),A.SW=[r,s,null===ZC._n_(i)?e.target.id:i],d.css("opacity",0).show();var v,b,B=ZC._i_(d.css("width"))+ZC._i_(d.css("paddingLeft"))+ZC._i_(d.css("paddingRight")),m=ZC._i_(d.css("height"))+ZC._i_(d.css("paddingTop"))+ZC._i_(d.css("paddingBottom")),E=1,D=!1;if(A.o.gui&&A.o.gui["context-menu"]&&A.o.gui["context-menu"]&&(E=A.o.gui["context-menu"].alpha?A.o.gui["context-menu"].alpha:1,D=A.o.gui["context-menu"].docked),d.css("opacity",E).hide(),"classic"!==A.LL&&D){if(D){var K=A.B8.NY[A.LL].root.gui["context-menu"];ZC._cp_(A.o.gui["context-menu"],K),v="left"!==A.o.gui["context-menu"].position&&ZC._n_(A.o.gui["context-menu"].position)?C.offset().left+C.width()-B:C.offset().left}b=C.offset().top,d.css("left",ZC.BQ(1,v)+"px").css("top",ZC.BQ(1,b)+"px").css("height",C.height()+"px").css("box-sizing","border-box").show(),d=ZC.A5("#"+A.K+"-menu"),D&&d.P1[0].scrollHeight>C.height()&&d.css("overflow-y","scroll")}else{if(null===ZC._n_(i)&&e.target.id===A.K+"-menu-area"){ZC.AK(A.K+"-menu").style.paddingTop=0;var F=ZC.A5("#"+A.K+"-menu-area").attr("coords").split(","),x=ZC._i_(F[3])-ZC._i_(F[1]);ZC.AK(A.K+"-menu").style.backgroundPosition=ZC._i_(F[0])>A.I/2?"100% 0% !important":"0% 0% !important",v=l+(ZC._i_(F[0])>A.I/2?ZC._i_(F[2])-B:ZC._i_(F[0])),b=o+(ZC._i_(F[1])>A.F/1.25?ZC._i_(F[3])-m-x:ZC._i_(F[3]))}else ZC.AK(A.K+"-menu").style.backgroundPosition="50% 0% !important",v=A.SW[0]-B/2,b=A.SW[1],m>A.F*p[1]?b=o:b-o+m>A.F*p[1]&&(b=ZC.BQ(b-m,A.F*p[1]-m)),v<l&&(v=ZC.BQ(v,l)),v+B>l+A.I*p[0]&&(v=ZC.CY(l+A.I*p[0]-B/2,v-B/2));if(t.position)switch(t.position){case"top":break;case"top-left":v=v-(A.I*p[0]-B)/2+5;break;case"top-right":v=v+(A.I*p[0]-B)/2-5;break;case"bottom":b=b+(A.F*p[1]-m)-10;break;case"bottom-left":b=b+(A.F*p[1]-m)-10,v=v-(A.I*p[0]-B)/2+5;break;case"bottom-right":b=b+(A.F*p[1]-m)-10,v=v+(A.I*p[0]-B)/2-5;break;case"left":b=b+(A.F*p[1]-m)/2-5,v=v-(A.I*p[0]-B)/2+5;break;case"right":b=b+(A.F*p[1]-m)/2-5,v=v+(A.I*p[1]-B)/2-5}else null!==ZC._n_(t.x)&&null!==ZC._n_(t.y)&&(v=l+ZC._i_(t.x),b=o+ZC._i_(t.y));if(d.css("left",ZC.BQ(1,v)+"px").css("top",ZC.BQ(1,b)+"px").show(),ZC.ie67){var I=ZC.A5("#"+A.K+"-menu div").width()[0]||120;d.css("width",I+"px")}}return A.AA2=!0,!1}}}},ZC.A5(document).bind("contextmenu",zingchart.YS)),zingchart.AAF=function(e,i){if(zingchart.css)return zingchart.css.addRule?zingchart.css.addRule(e,i):zingchart.css.insertRule(e+"{"+i+"}",0)},zingchart.wh=function(e,i,t){"auto"===i&&(i="100%"),"auto"===t&&(t="100%");var n=[0,0];return-1===(""+i).indexOf("%")&&-1===(""+t).indexOf("%")||(n=e.wh()),[-1!==(""+i).indexOf("%")?n[0]*parseInt(i,10)/100:parseInt(i,10),-1!==(""+t).indexOf("%")?n[1]*parseInt(t,10)/100:parseInt(t,10)]},zingchart.IY={},zingchart.bind=function(e,i,t){e=e||"zingchart-global",zingchart.IY[e]||(zingchart.IY[e]={}),zingchart.IY[e][i]?zingchart.IY[e][i].push({fn:t}):zingchart.IY[e][i]=[{fn:t}]},zingchart.unbind=function(e,i,t){if(e=e||"zingchart-global",zingchart.IY[e]&&zingchart.IY[e][i])if(t){for(var n=0,a=zingchart.IY[e][i].length;n<a;n++)if(zingchart.IY[e][i][n].fn===t){zingchart.IY[e][i].splice(n,1);break}}else zingchart.IY[e][i]=null},zingchart.callEvent=function(e,i,t,n){if(e=e||"zingchart-global",zingchart.IY[e]&&zingchart.IY[e][i]){for(var a=0,l=zingchart.IY[e][i].length;a<l;a++)null!==ZC._n_(n)?t[t.length-1]=zingchart.IY[e][i][a].fn.apply(zingchart,t):zingchart.IY[e][i][a].fn.apply(zingchart,t);if(null!==ZC._n_(n))return t[t.length-1]}},zingchart.hasEvent=function(e,i){return e=e||"zingchart-global",zingchart.IY[e]&&zingchart.IY[e][i]},zingchart.A8O=function(e,i){ZC._todash_(e,!1);var t,n,a,l,o,r,s,A,C=[];if(null!==ZC._n_(t=e.flags)&&(C=t.split(",")),null!==ZC._n_(t=e.mode))switch(t){case"static":C=["skip_context_menu","skip_segment_tracking","skip_marker_tracking","skip_interactivity","use_single_canvas"]}var c="";if(null!==ZC._n_(t=e.container)&&(c=t),null!==ZC._n_(t=e.id)&&(c=t),ZC.AK(c)){var u=null;for(a=0;a<zingchart.HZ.length;a++)zingchart.HZ[a].K===c&&(u=zingchart.HZ[a].MA);if(null!==ZC._n_(u)){if(""!==u)return;zingchart.exec(c,"destroy")}zingchart.params[c]={},ZC._cp_(e,zingchart.params[c]);var p=!1,Z=null;for(a=0;a<zingchart.HZ.length;a++)zingchart.HZ[a].K===c&&(zingchart.HZ[a]=new ZC.Q2,Z=zingchart.HZ[a],p=!0);if(p||((Z=new ZC.Q2).MA="init",zingchart.HZ.push(Z)),Z.K=c,zingchart.XZ[c]=!0,"vml"!==i||zingchart.A01||zingchart.A8O(e,i),!zingchart.AA3){zingchart.AA3=!0;var h={".zc-style":"font-family:"+zingchart.FONTFAMILY+";font-size:"+zingchart.FONTSIZE+"px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",".zc-style *":"font-family:"+zingchart.FONTFAMILY+";font-size:"+zingchart.FONTSIZE+"px;font-weight:normal;font-style:normal;text-decoration:none;text-shadow:none;",".zc-top *":"text-align:left;margin:auto;text-shadow:none;",".zc-menu *":"text-align:left;margin:auto;",".zc-main text":"-webkit-touch-callout:none;-webkit-user-select:none;-khtml-user-select:none;-moz-user-select:none;-ms-user-select:none;user-select:none;",".zc-img":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-map":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-pixmap":"-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-preview-mask":"cursor:default;-webkit-user-select:none;-webkit-touch-callout:none;-webkit-tap-highlight-color:transparent;",".zc-about":"position:absolute;overflow:hidden;border:5px solid #fff;background:#003C4F url("+(ZC.ie67?"//":ZC.LOGO_ABOUT)+") no-repeat center 10px",".zc-about-1":"padding:80px 5px 5px 5px;text-align:center !important;",".zc-about-1 a":"color:#1AB6E3;font-size:17px;line-height:125%;",".zc-about-2":"padding:5px;color:#fff;text-align:center !important;",".zc-about-3":"padding:5px;text-align:center;line-height:125%;",".zc-about-3 div":"background-color:#1AB6E3;line-height:125%;color:#fff;border:1px solid #fff;padding:5px 10px;font-weight:bold;width:60px;margin:0 auto;cursor:pointer;text-align:center",".zc-about-4":"color:#fff;line-height:125%;",".zc-about-4 div":"float:right;color:#fff;line-height:125%;",".zc-viewsource":"border:5px solid #fff;background:#999",".zc-error":"border:5px solid #fff;background:#900",".zc-bugreport":"border:5px solid #fff;background:#999",".zc-form-row-label":"padding:4px 10px 2px;text-align:left;color:#fff",".zc-form-row-element":"padding:2px 8px",".zc-form-row-last":"padding:8px 8px 2px !important",".zc-form-row-element textarea":"text-align:left;background:#fff;color:#000;border:1px solid #333;",".zc-form-row-label input":"color:#000;padding:2px;margin:0 5px 0 0;background-color:#999;",".zc-form-row-element input":"color:#000;padding:2px;margin:0;background-color:#fff",".zc-form-row-last input":"padding:4px 10px !important;margin:0 20px 0 0 !important;background-color:#eee !important;border:2px outset #ccc !important",".zc-form-s0":"font-size:27px !important;letter-spacing:-1px;line-height:125%",".zc-form-s1":"font-size:17px !important;line-height:125%",".zc-form-s1 a":"color:#fff;padding:3px 10px;position:relative;top:4px;border:1px solid #333;border-bottom:0px solid #333",".zc-tab-active":"background-color:#fff;color:#333 !important",".zc-tab-inactive":"background-color:#999;color:#ddd !important",".zc-bugreport label":"display:inline-block;position:relative;top:-2px",".zc-viewimage div":"position:absolute;text-align:center;padding:5px;background:#999;color:#fff",".zc-license-ie67":"padding:0;position:absolute;font-size:12px;font-weight:bold;font-family:"+zingchart.FONTFAMILY+";color:#369;text-align:left",".zc-license":"padding:0;position:absolute;","#zc-fullscreen":"display:block;position:absolute;top:0;left:0;width:100%;height:100%;margin:0;padding:0;background:#fff;",".zc-menu":"position:absolute;display:none;background-repeat:no-repeat !important;background-position:50% 0% !important;",".zc-menu-sep":"font-size:1px;padding:0;line-height:1px;border-bottom:1px solid #000",".zc-menu-item":"cursor:pointer;white-space:nowrap",".zc-blocker":"background:#eee",".zc-blocker div.zc-blocker-msg":"position:absolute;border:2px solid #ccc;padding:10px 30px;background-color:#333;color:#fff",".zc-modal":"background-color:#fff;color:#000;border:2px solid #999",".zc-guide-label-table":"border-collapse:collapse",".zc-guide-label-table td":"padding:4px 10px 2px 2px",".zc-data-table":"border-collapse:collapse",".zc-data-table caption":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:17px;font-weight:600;padding:6px 14px 6px 4px;background-color:#ccc;border-bottom:2px solid #666",".zc-data-table th":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:13px;font-weight:600;padding:2px 14px 2px 4px;background-color:#ddd;border-bottom:1px solid #666",".zc-data-table td":"font-family:"+zingchart.FONTFAMILY+";text-align:left;font-size:11px;padding:1px 14px 1px 4px;background-color:#ffffff;border-bottom:1px solid #eee;white-space:nowrap",".zc-rel":"top:0;left:0;position:relative",".zc-abs":"top:0;left:0;position:absolute"};ZC.ie678||(h[".zc-data-table th:not(:last-child)"]="border-right:1px dotted #666",h[".zc-data-table td:not(:last-child)"]="border-right:1px solid #eee");var d=document.getElementsByTagName("head")[0],f=document.createElement("style");if(f.type="text/css",f.setAttribute("data-author","zingchart"),d.appendChild(f),!zingchart.css)for(a=0,l=document.styleSheets.length;a<l;a++)document.styleSheets[a].ownerNode&&"zingchart"===document.styleSheets[a].ownerNode.getAttribute("data-author")&&(zingchart.css=document.styleSheets[a]);for(var _ in zingchart.css||(zingchart.css=document.styleSheets[document.styleSheets.length-1]),h)null!==ZC._n_(zingchart.USERCSS[_])?zingchart.AAF(_,zingchart.USERCSS[_]):zingchart.AAF(_,h[_])}if("vml"===i&&!zingchart.AA4)document.namespaces.add("zcv","urn:schemas-microsoft-com:vml"),document.createStyleSheet().cssText=".zcvml { behavior:url(#default#VML); }",zingchart.AA4=!0;var g="";zingchart.THEME&&(g=zingchart.THEME),e.data&&null!==ZC._n_(t=e.data.theme)&&(g=t),null!==ZC._n_(t=e.theme)&&(g=t);var v={data:!1,defaults:!1,css:!1,csv:!1};if(null!==ZC._n_(t=e.cache))for(var b in v)null!==ZC._n_(n=t[b])&&(v[b]=ZC._b_(n));var B=!1;null!==ZC._n_(t=e.fullscreen)&&(B=ZC._b_(t));var m=!0;null!==ZC._n_(t=e["auto-resize"])&&(m=ZC._b_(t));var E=ZC.A5("#"+c);o=(e.width||"100%")+"",r=(e.height||""+zingchart.DEFAULT.height)+"","auto"===o&&(o="100%"),"auto"===r&&(r="100%");var D=zingchart.wh(E,o,r);s=D[0],A=D[1],B&&(s=ZC.A5(window).width(),A=ZC.A5(window).height(),document.body.style.overflow="hidden"),s<10&&(s=zingchart.DEFAULT.width),A<10&&(A=zingchart.DEFAULT.height),s=0===s?zingchart.DEFAULT.width:s,A=0===A?zingchart.DEFAULT.height:A;var K=e.dataurl||"",F=e.defaultsurl||"",x=null,I="",y=null;null!==ZC._n_(t=e.data)&&("string"==typeof t?I=t:y=zingchart.DEV.COPYDATA?JSON.parse(JSON.stringify(t)):t),null!==ZC._n_(t=e.defaults)&&("string"==typeof t&&(t=JSON.parse(t)),x=t),null!==ZC._n_(t=e.imggen)&&(Z.A19=ZC._b_(t)),Z.A19&&(Z.G1=null),Z.JL=o+"/"+r,Z.AA=i,Z.A=Z,Z.iX=0,Z.iY=0,Z.I=s,Z.F=A,Z.FZ=o,Z.MT=r,Z.QM=K,Z.EW=I,Z.M9=y,Z.QJ=F,Z.ML=x,Z.UN=!1,null!==ZC._n_(e.fullscreenmode)&&ZC._b_(e.fullscreenmode)&&(Z.QZ=!0),Z.LS=B,Z.RS=v,Z.KR=C,Z.LL=g,Z.H=Z,Z.E.hideprogresslogo=!1,null!==ZC._n_(t=e.hideprogresslogo)&&(Z.E.hideprogresslogo=ZC._b_(t)),null!==ZC._n_(t=e.customprogresslogo)&&(Z.E.customprogresslogo=t),null!==ZC._n_(t=e.customprogresstext)&&(Z.E.customprogresstext=t),null!==ZC._n_(t=e.exportdataurl)&&(Z.E.exportdataurl=t),null!==ZC._n_(t=e.exportimageurl)&&(Z.E.exportimageurl=t);var w={};for(var Y in null!==ZC._n_(t=e.bgcolor)&&(w["background-color"]=t),null!==ZC._n_(t=e["background-color"])&&(w["background-color"]=t),null!==ZC._n_(t=e["border-color"])&&(w["border-color"]=t),null!==ZC._n_(t=e["border-width"])&&(w["border-width"]=t),null!==ZC._n_(t=e.color)&&(w.color=t),Z.E.progress=w,null!==ZC._n_(t=e["auto-load-modules"])&&(Z.A6L=ZC._b_(t)),null!==ZC._n_(t=e.events)&&(Z.A18=t),null!==ZC._n_(t=e.modules)&&(Z.A1A=t),null!==ZC._n_(t=e.format)&&(Z.CI=t),null!==ZC._n_(t=e.csvdata)&&(Z.NW=t),null!==ZC._n_(t=e.locale)&&null!==ZC._n_(zingchart.i18n[t])&&(Z.A14=t,ZC.HJ=zingchart.i18n[t]),null!==ZC._n_(t=e["cache-control"])&&(Z.MZ=t),null!==ZC._n_(t=e.accessibility)&&(Z.bA11y=ZC._b_(t)),null!==ZC._n_(t=e.description)&&(Z.P2=t+""),zingchart.params)if(!zingchart.XZ[Y])for(var X in delete zingchart.params[Y],delete ZC.TS[Y],zingchart.pool.data)0===X.indexOf(Y+"-")&&(delete zingchart.pool.data[X],zingchart.pool.size--);if(Z.render(),E.css("overflow","hidden"),Z.LS&&E.css("position","absolute").css("top",0).css("left",0),(-1!==Z.FZ.indexOf("%")||-1!==Z.MT.indexOf("%")||Z.LS||Z.QZ)&&m){var M=Z.QZ||Z.LS?ZC.A5(window):E,L=M.width(),H=M.height(),P=0;Z.A0P=!1,Z.YV=window.setInterval(function(){var e;if(ZC.AK(c)&&!Z.A2H){var i=ZC.A5("#"+c+"-top"),t=!1;if(-1!==(""+Z.FZ).indexOf("%")&&i.length&&M.length&&i.width()!==M.width()&&(t=!0),0!==P||M.width()===L&&M.height()===H&&!t){if(M.width()+M.height()>0&&(M.width()!==L||M.height()!==H)&&(e=Z.LS||Z.QZ?zingchart.wh(M,""+M.width(),""+M.height()):zingchart.wh(M,Z.FZ,Z.MT))[0]>10&&e[1]>10){for(Z.I=ZC._i_(e[0]),Z.F=ZC._i_(e[1]),L=M.width(),H=M.height(),a=0,l=Z.AG.length;a<l;a++)Z.AG[a].MC[0]=0;G()}}else if(L=M.width(),H=M.height(),L>10&&H>10){for(-1!==(""+Z.FZ).indexOf("%")?Z.I=ZC._i_(L*ZC.II(Z.FZ)):Z.I=ZC._i_(L),-1!==(""+Z.MT).indexOf("%")?Z.F=ZC._i_(H*ZC.II(Z.MT)):Z.F=ZC._i_(H),a=0,l=Z.AG.length;a<l;a++)Z.AG[a].MC[0]=0;G()}P++}else window.clearInterval(Z.YV)},zingchart.DEV.RESIZESPEED)}return Z}function N(){if(!Z.E.wh||Z.E.wh!==Z.I+"/"+Z.F){for(var e=!1,i=0;i<zingchart.HZ.length;i++)zingchart.HZ[i].K===Z.K&&(e=!0);e&&Z.resize()}Z.A0P=!1}function G(){Z.A0P?Z.VD.width!==Z.I&&(clearTimeout(Z.A64),Z.VD.width=Z.I,Z.VD.height=Z.F,Z.A64=setTimeout(N,zingchart.DEV.DEBOUNCESPEED)):(Z.A0P=!0,Z.VD={width:Z.I,height:Z.F},Z.A64=setTimeout(N,zingchart.DEV.DEBOUNCESPEED))}},window.zingchart=zingchart,ZC.A5.browser.msie&&parseFloat(ZC.A5.browser.version)<9){var _window_onunload_=window.onunload;window.onunload=function(){for(;zingchart.HZ.length;)zingchart.exec(zingchart.HZ[0].K,"destroy");ZC.A5(document).unbind(ZC.Q.BZ("mouseover"),zingchart.MI).unbind(ZC.Q.BZ("mouseout"),zingchart.MI).unbind(ZC.Q.BZ("mousemove"),zingchart.MI).unbind(ZC.Q.BZ("mousedown"),zingchart.MI).unbind(ZC.Q.BZ("mouseup"),zingchart.MI).unbind("click",zingchart.SB).unbind("contextmenu",zingchart.YS),zingchart.HZ=[],_window_onunload_&&_window_onunload_()}}zingchart.i18n.en_us={rtl:!1,"decimals-separator":".","thousands-separator":"","menu-enablepagescroll":"Enable Page Scroll","menu-disablepagescroll":"Disable Page Scroll","menu-reload":"Reload","menu-print":"Print Chart","menu-viewaspng":"View As PNG","menu-viewasjpg":"View As JPG","menu-downloadpdf":"Download PDF","menu-downloadsvg":"Download SVG","menu-downloadcsv":"Download CSV","menu-downloadxls":"Download XLS","menu-viewdatatable":"View Data Table","menu-hidedatatable":"Hide Data Table","menu-exportdata":"Export Data","menu-zoomin":"Zoom In","menu-zoomout":"Zoom Out","menu-viewall":"View All","menu-viewsource":"View Source","menu-bugreport":"Submit Bug","menu-switchto2d":"Switch To 2D","menu-switchto3d":"Switch To 3D","menu-showguide":"Show Guide","menu-hideguide":"Hide Guide","menu-switchtolin":"Show Linear Scale","menu-switchtolog":"Show Log Scale","menu-fullscreen":"Full Screen","menu-exitfullscreen":"Exit Full Screen","menu-goback":"Go Back","menu-goforward":"Go Forward","date-formats":{msecond:"%d %M %Y<br>%g:%i:%s %A<br>%q ms",second:"%d %M %Y<br>%g:%i:%s %A",minute:"%d %M %Y<br>%g:%i %A",hour:"%d %M %Y<br>%g %A",day:"%d %M %Y",month:"%M %Y",year:"%Y"},"days-short":["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],"days-long":["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],"months-short":["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"],"months-long":["January","February","March","April","May","June","July","August","September","October","November","December"],"sync-wait":"Wait...","export-wait":"Exporting...","progress-wait-long":"Wait. Loading...","progress-wait-short":"Wait...","progress-wait-mini":"...","error-header":"An Error Has Occured","error-message":"Error Message:","error-close":"Close","bugreport-header":"Submit Bug Report","bugreport-senddata":"Send JSON Data","bugreport-sendcapture":"Send Graph Capture","bugreport-yourcomment":"Your Comment:","bugreport-jsondata":"JSON Data:","bugreport-youremail":"Your Email Address","bugreport-infoemail":"if you want to receive via email our reply to your problem","bugreport-emailmandatory":"Email address is mandatory...","bugreport-submit":"Submit","bugreport-cancel":"Cancel","bugreport-confirm":"Your bug report was sent.\n\nThank you!","about-close":"Close","viewsource-jsonsource":"Parsed JSON","viewsource-originalsource":"Original JSON","viewsource-close":"Close","viewsource-apply":"Apply","viewimage-close":"Close","legend-pagination":"Page %page% of %pages%"},ZC.HJ=zingchart.i18n.en_us,zingchart.getLoader=function(e){for(var i=0;i<zingchart.HZ.length;i++)if(zingchart.HZ[i].K===e)return zingchart.HZ[i];return null},zingchart.getGraph=function(e,i){return e.OQ(i)},zingchart.clearLayer=function(e){e.A7&&e.A7.onmouseout();for(var i=0;i<e.AG.length;i++)e.AG[i].LD()},zingchart.getGraphInfo=function(e,i,t){return e.A4O(i,t)},zingchart.initThemes=function(e){e&&e.A9Y(!0)},zingchart.setModule=function(e){ZC.WI.push(e)},zingchart.getModules=function(e){return e.A1A.split(",")},zingchart.defineModule=function(e,i,t){switch(zingchart.setModule(e),i){case"chart":zingchart.bind(null,"dataparse",function(i,n){for(var a=n.graphset.length,l=0;l<a;l++)if(n.graphset[l].type===e){var o=n.graphset[l];o.id?o.id=o.id:o.id=e.replace(/-/g,"")+l,n.graphset[l]=t(o)}return n});break;case"plugin":zingchart.bind(null,"dataparse",function(i,n){var a=zingchart.getLoader(i.id);if(-1!==zingchart.getModules(a).indexOf(e))for(var l=n.graphset.length,o=null,r=0;r<l;r++)(o=n.graphset[r]).hasOwnProperty(e)&&(n.graphset[r]=t(o,i.id));return n})}},zingchart.getPalette=function(e,i,t){return t=t||"bar",e.B8.A9B(i,t)},zingchart.getObject=function(e,i,t){var n,a;switch(t=t||"label"){case"shape":for(n=0,a=e.FH.length;n<a;n++)if(e.FH[n].H8===i||n===i)return e.FH[n].BG;break;case"label":for(n=0,a=e.BX.length;n<a;n++)if(e.BX[n].H8===i||n===i)return e.BX[n]}return null},zingchart.getInstance=function(e,i){switch(i){case"style":return new ZC.D0(e);case"shape":return new ZC.DT(e);case"box":return new ZC.HL(e);case"textbox":return new ZC.DN(e)}return null},zingchart.normalize=function(e){ZC._todash_(e)},zingchart.copy=function(e,i){ZC._cp_(e,i)},zingchart.formatDate=function(e,i,t,n){return ZC.AP.Y5(e,i,t,n)},zingchart.formatNumber=function(e,i){return ZC.AP.G2(e,i)},zingchart.fireEvent=function(e,i,t){ZC.AP.BY(e,i,t)},zingchart.A93=[],zingchart.extendAPI=function(e,i){zingchart.A93.push({call:e,api:i})},zingchart.exec=function(e,i,t){return zingchart.getLoader(e)?zingchart.ACY(e,i,t):zingchart.exec_flash?zingchart.exec_flash(e,i,t):void 0},zingchart.ACY=function(e,i,t){var n,a,l;t=t||{},document.getElementById("zc-fullscreen")&&!t.skipfs&&(e="zc-fullscreen"),"string"==typeof t&&(t=JSON.parse(t));var o,r,s,A,C,c=zingchart.getLoader(e);if(null!==ZC._n_(t.preservezoom)&&(c.E.preservezoom=ZC._b_(t.preservezoom)),c)switch(i){case"goback":c.IC&&c.NS>0&&(ZC.AP.BY("history_back",c,c.FE()),c.NS--,zingchart.exec(c.K,"setdata",{data:c.QL[c.NS]}));break;case"goforward":c.IC&&c.NS<c.QL.length-1&&(ZC.AP.BY("history_forward",c,c.FE()),c.NS++,zingchart.exec(c.K,"setdata",{data:c.QL[c.NS]}));break;case"setmode":if("undefined"==typeof c.E["mode-flags"]&&(c.E["mode-flags"]=c.KR.join(",")),""===t.mode&&"undefined"!=typeof c.E["mode-flags"])c.KR=c.E["mode-flags"].split(",");else{c.KR=[];var u=(""+t.mode).split(",");-1!==ZC.AV(u,"static")&&c.KR.push("skip_context_menu","skip_objects_tracking","skip_segment_tracking","skip_marker_tracking","skip_interactivity")}break;case"showmenu":ZC.E1[0]=ZC._n_(t.x)?t.x:ZC.E1[0],ZC.E1[1]=ZC._n_(t.y)?t.y:ZC.E1[1],t["from-api"]=!0,zingchart.YS(null,c.K,t);break;case"hidemenu":c.hideCM();break;case"destroy":case"zcdestroy":for(ZC.AP.BY("beforedestroy",c,{id:e,loader:c}),delete zingchart.XZ[e],a=0,l=c.AG.length;a<l;a++)c.AG[a].MC[0]=0,c.AG[a].B9&&(c.AG[a].B9.IM=!1,c.AG[a].unbind(!1,!0)),c.H2&&(c.H2.IM=!1);for(var p in ZC.move=!1,c.A0C(),c.A9H(t,!0),zingchart.DEV.GC&&c.gc(),c.YV&&window.clearInterval(c.YV),c.Z3&&window.clearInterval(c.Z3),zingchart.IY[e]&&delete zingchart.IY[e],ZC.Q.EU([e+"-wrapper",e+"-top",e+"-text-ruler",e+"-dummy",e+"-progress"]),c.A1K||delete zingchart.params[e],delete ZC.TS[e],delete ZC.cache.data["svg-rect"],zingchart.pool.data)0===p.indexOf(e+"-")&&(delete zingchart.pool.data[p],zingchart.pool.size--);var Z=ZC.AV(zingchart.HZ,c);-1!==Z&&zingchart.HZ.splice(Z,1),zingchart.HZ.length||(zingchart.GUIDE_EV=null,delete zingchart.LH["zc.logo"]),c=null,ZC.AP.BY("destroy",null,{id:e});break;case"getrender":return c.AA;case"clear":c.A9H(t);break;case"reload":c.A8Y(t);break;case"load":c.ACZ(t);break;case"enable":c.A42();break;case"disable":c.A7W(t.text);break;case"closemodal":ZC.Q.EU([c.K+"-modal",c.K+"-blocker"]);break;case"openmodal":if(!ZC.AK(c.K+"-modal"))return ZC.Q.HY({cls:"zc-abs zc-style zc-blocker",id:c.K+"-blocker",p:ZC.AK(c.K+"-top"),wh:c.I+"/"+c.F,opacity:.75}),ZC.Q.HY({cls:"zc-abs zc-style zc-modal",id:c.K+"-modal",p:ZC.AK(c.K+"-top"),tl:(c.F-t.height)/2+"/"+(c.I-t.width)/2,wh:t.width+"/"+t.height,opacity:1}),ZC.AK(c.K+"-modal");break;case"mapdata":c.AC5(t);break;case"print":c.A98();break;case"fullscreen":c.A5W();break;case"exitfullscreen":zingchart.exec("zc-fullscreen","destroy"),ZC.Q.EU("zc-fullscreen");break;case"resize":c.A2H=!0;var h=c.I,d=c.F,f=c.JL.split("/"),_=!1,g=f[0],v=f[1];null!==ZC._n_(n=t.width)&&(g=n),null!==ZC._n_(n=t.height)&&(v=n),null!==ZC._n_(n=t.scale)&&(_=ZC._b_(n)),c.A1K&&(zingchart.params[c.K].width=g,zingchart.params[c.K].height=v);var b=zingchart.wh(ZC.A5("#"+c.K),g,v);(t.layout||(h!==b[0]||d!==b[1])&&b[0]>10&&b[1]>10)&&(c.I=b[0],c.F=b[1],null!==ZC._n_(n=t.layout)&&(c.o.layout=n),""===c.MA&&(c.E["from-api"]=!0,c.E.preservezoom=!0,c.resize(_),c.FZ=g,c.MT=v,c.A2H=!1));break;case"plothide":case"hideplot":(o=c.C8(t.graphid))&&o.A3C(t,"hide");break;case"showguide":case"hideguide":ZC.E1[0]=ZC._n_(t.x)?t.x:ZC.E1[0],ZC.E1[1]=ZC._n_(t.y)?t.y:ZC.E1[1],(o=c.C8(t.graphid))&&c.Z7(o.K,"showguide"===i);break;case"showtooltip":case"hidetooltip":case"clicknode":if(o=c.C8(t.graphid)){var B=t.ev||{};"showtooltip"!==i&&"clicknode"!==i||((r=o.I0(t.plotindex,t.plotid))&&r.S.length&&!t.xy?(s=r.L,A=ZC._i_(t.nodeindex||"0"),B.targetid=o.K+"-plotset-plot-"+s+"-node-"+A,B.update=!0):B.targetid=o.K+"-xy-"+ZC._i_(t.y||"0")+"-"+ZC._i_(t.x||"0")),"clicknode"===i?(B.which=0,o.TB(B)):o.A.A7&&("showtooltip"===i?o.A.A7.onmouseover(B,t.data):o.A.A7.hide())}break;case"locktooltip":ZC.TTLOCK=!0;break;case"unlocktooltip":ZC.TTLOCK=!1;break;case"showhoverstate":if(o=c.C8(t.graphid)){r=o.I0(t.plotindex,t.plotid),s=ZC._i_(r?r.L:0),A=ZC._i_(t.nodeindex||"0");var m=o.AY.A4[s].FK(A);o.LD(),m.A0W()}break;case"plotshow":case"showplot":(o=c.C8(t.graphid))&&o.A3C(t,"show");break;case"togglesource":ZC.AK(c.K+"-viewsource")?ZC.Q.EU(c.K+"-viewsource"):c.A5O();break;case"togglebugreport":ZC.AK(c.K+"-bugreport")?ZC.Q.EU(c.K+"-bugreport"):c.A6T();break;case"toggleabout":ZC.AK(c.K+"-about")?ZC.Q.EU([c.K+"-about",c.K+"-about-mask"]):c.A9E();break;case"toggleplot":(o=c.C8(t.graphid))&&o.QC(t);break;case"getcharttype":return(o=c.C8(t.graphid))?o.AF:null;case"showversion":case"getversion":return ZC.VERSION;case"get3dview":return(o=c.C8(t.graphid))?o.F0:null;case"set3dview":(o=c.C8(t.graphid))&&(null===ZC._n_(c.o.graphset[o.L]["3d-aspect"])&&(c.o.graphset[o.L]["3d-aspect"]={}),ZC._cp_(t,c.o.graphset[o.L]["3d-aspect"]),null===ZC._n_(o.o["3d-aspect"])&&(o.o["3d-aspect"]={}),ZC._cp_(t,o.o["3d-aspect"]),zingchart.SKIP.PARSE3D=!0,o.autoFit(),o.K6(!0,!0),zingchart.SKIP.PARSE3D=!1);break;case"getpage":return c.L3;case"setpage":var E=0;null!==ZC._n_(n=t.page)&&(E=ZC._i_(n)),c.L3=E,ZC.ZJ(function(){c.clear(),c.parse(),c.paint()},!0);break;case"unbinddocument":ZC.A5(document).unbind(ZC.Q.BZ("mousemove"),zingchart.MI).unbind(ZC.Q.BZ("mousedown"),zingchart.MI).unbind(ZC.Q.BZ("mouseup"),zingchart.MI).unbind("click",zingchart.SB).unbind("contextmenu",zingchart.YS),c.D7&&c.D7.unbind()}var D=[];for(zingchart.ABJ&&null!==(C=zingchart.ABJ(e,i,t))&&(n=C),D=["addobject","removeobject","updateobject","repaintobjects","getobjectsbyclass","getallobjects","getlabelinfo","getshapeinfo","setobjectsmode","settweenmode"],zingchart.AB5&&-1!==ZC.AV(D,i)&&null!==(C=zingchart.AB5(e,i,t))&&(n=C),D=["getimagedata","exportimage","saveasimage","exportdata","downloadCSV","downloadXLS","downloadRAW","viewDataTable"],zingchart.AB6&&-1!==ZC.AV(D,i)&&null!==(C=zingchart.AB6(e,i,t))&&(n=C),D=["getzoom","pan","zoomin","zoomout","zoomto","zoomtovalues","viewall"],zingchart.ABP&&-1!==ZC.AV(D,i)&&null!==(C=zingchart.ABP(e,i,t))&&(n=C),D=["clearselection","getselection","setselection","select","deselect"],zingchart.AAL&&-1!==ZC.AV(D,i)&&null!==(C=zingchart.AAL(e,i,t))&&(n=C),D=["clearfeed","getinterval","setinterval","stopfeed","startfeed"],zingchart.ABH&&-1!==ZC.AV(D,i)&&null!==(C=zingchart.ABH(e,i,t))&&(n=C),a=0,l=zingchart.A93.length;a<l;a++)i===zingchart.A93[a].call&&null!==(C=zingchart.A93[a].api.call(zingchart,e,t))&&(n=C);return n},zingchart.extendAPI("addmenuitem",function(e,i){var t=zingchart.getLoader(e);t.DF["context-menu"]=t.DF["context-menu"]||{},t.DF["context-menu"]["custom-items"]=t.DF["context-menu"]["custom-items"]||[];for(var n=i.id||"",a=t.DF["context-menu"]["custom-items"],l=!1,o=0;o<a.length;o++)if(a[o].id===n){l=!0;break}l||t.DF["context-menu"]["custom-items"].push(i)}),zingchart.ABJ=function(e,i,t){var n;document.getElementById("zc-fullscreen")&&(e="zc-fullscreen"),"string"==typeof(t=t||{})&&(t=JSON.parse(t));var a,l,o,r,s,A,C,c,u,p,Z,h,d,f,_,g,v,b,B,m,E,D,K,F=zingchart.getLoader(e),x=!(null!==ZC._n_(t.update)&&!ZC._b_(t.update)),I=null!==ZC._n_(t.history)&&ZC._b_(t.history),y="undefined"!=typeof t.smart&&ZC._b_(t.smart);if(F){switch(-1===ZC.AV(["resize","addplot","removeplot","modify","modifyplot","setnodevalue","addnode","removenode","setdata"],i)&&((l=F.FE()).params=t,ZC.AP.BY(i,F,l)),i){case"clearscroll":if(!(a=F.C8(t.graphid)))return null;a.HS&&a.HS.M7&&(a.HS.M7(),a.HS.unbind()),a.HQ&&a.HQ.M7&&(a.HQ.M7(),a.HQ.unbind());break;case"getbubblesize":return(a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))?o.getSize(t.value||1):null;case"fastlinexycoords":var w=(a=F.AG[0]).BL("scale-x"),Y=a.BL("scale-y");return w&&Y?[w.AT(t.key),Y.AT(t.val)]:[0,0];case"getscaleinfo":return(a=F.C8(t.graphid))&&(r=a.BL(t.name||""))?null!==ZC._n_(t.value)?r.AT?r.AT(t.value):null:null!==ZC._n_(t.coord)&&r.NE?r.NE(t.coord):null:null;case"getobjectinfo":if(!(a=F.C8(t.graphid)))return null;var X={id:"K",x:"iX",y:"iY",width:"I",height:"F",color:"C2",lineColor:"B7",lineWidth:"AZ",borderColor:"BW",borderWidth:"AU",backgroundColor1:"A0",backgroundColor2:"AE"};switch(t.object){case"graph":for(p in l={},X)l[p]=a[X[p]];return ZC._cp_({type:a.AF},l),l;case"plotarea":for(p in l={},X)l[p]=a.P[X[p]];return l;case"legend":if(l={},a.BD)for(p in X)l[p]=a.BD[X[p]];return l;case"scale":if(!(r=a.BL(t.name||"")))return null;for(p in l={},X)l[p]=r[X[p]];return ZC._cp_({type:r.AF,text:r.M&&r.M.AM||"",datetime:null!==r.FG&&"date"===r.FG.o.type,step:r.E5,step_:r.SG,stepSize:r.AC,values:r.V,placement:r.BA,aperture:r.EI,zooming:r.GO,offsetStart:r.AB,offsetEnd:r.BV,sizeFactor:r.JE,inversed:r.CO},l),r.M&&""!==r.M.AM&&(l.label={x:r.M.iX,y:r.M.iY,width:r.M.I,height:r.M.F,angle:r.M.A9}),"v"===r.AF?ZC._cp_({progression:r.C1,logBase:r.E6,minValue:r.B3,maxValue:r.BJ,minValue_:r.FW,maxValue_:r.H1},l):"scale-r"===t.name?ZC._cp_({refAngle:r.DH},l):ZC._cp_({minValue:r.V[r.W],maxValue:r.V[r.A1],minValue_:r.V[r.DC],maxValue_:r.V[r.DX],minIndex:r.W,maxIndex:r.A1,minIndex_:r.DC,maxIndex_:r.DX},l),l;case"plot":if(!(o=a.I0(t.plotindex,t.plotid)))return null;for(p in l={},X)l[p]=o[X[p]];var M=o.AN&&a.E["plot"+o.L+".visible"];return ZC._cp_({visible:M,id:o.H8,index:o.L,type:o.AF,text:o.AM,values:o.V,scales:o.BO,stacked:o.CC,stackType:o.KQ,stack:o.DZ,xdata:o.KH},l),o.TT&&ZC._cp_({marker:{visible:o.TT.AN,size:o.TT.AI,type:o.TT.DU,backgroundColor1:o.TT.A0,backgroundColor2:o.TT.AE,borderColor:o.TT.BW,borderWidth:o.TT.AU}},l),l;case"node":if(o=a.I0(t.plotindex,t.plotid)){if(B=null!==ZC._n_(t.nodeindex)?ZC._i_(t.nodeindex):0,!o.S[B])return null;for(p in s=o.FK(B),(l={}).bounds=s.H.E[s.K+"-bounds"],X)-1!==ZC.AV(["x","y","width","height"],p)?l[p]=s[X[p]]:l[p]=s.N[X[p]];if(ZC._cp_({plotindex:o.L,index:s.L,size:s.AI,value:s.AD,keyvalue:s.BT,onviewport:s.JD},l),-1!==o.AF.indexOf("pie")&&ZC._cp_({angleStart:s.B4,angleEnd:s.BK,slice:s.A.PS,npv:100*s.AD/s.A.A.KM[s.L]},l),o.KH){var L={};for(p in o.KH)o.KH[p]instanceof Array?L[p]=o.KH[p][B]:L[p]=o.KH[p];l.xdata=L}return l}return null}break;case"getxyinfo":var H=[],P=t.x,N=t.y,G=ZC._tx_(F.K);P/=G[0],N/=G[1];for(var S=0;S<F.AG.length;S++){a=F.AG[S];for(var O=0;O<a.AY.A4.length;O++){o=a.AY.A4[O];var k=a.BL(o.BU("k")[0]),T=a.BL(o.BU("v")[0]);if(k&&T){if(k.OE&&k.OE){var z=k.OE(k.CO?N:P),Q=k.OE(k.CO?N:P,null,!0);H.push({infotype:"key-scale",xydistance:ZC._a_(P-k.IB(z)),graphid:a.K,plotidx:o.L,scalename:k.BE,scaleidx:z,scalepos:Q,scaletext:k.BX[z]||"",scalevalue:k.V[z],scalenumvalue:k.NE(k.CO?N:P)})}if(T.NE){var J=T.NE(T.CO?P:N,!0);H.push({infotype:"value-scale",xydistance:ZC._a_(T.CO?P:N-T.AT(J)),graphid:a.K,plotidx:o.L,scalename:T.BE,scalevalue:J})}for(var V,R=ZC.MAX,W=null,U=0,j=o.S.length;U<j;U++)if(null!==(s=o.FK(U)))switch(a.AJ.layout){case"xy":case"yx":var q=!1;"vbar"===s.A.AF?(V=s.getNodeData("h")||s.F,ZC.DS(P,s.iX-s.I/2,s.iX+s.I/2)&&ZC.DS(N,s.iY,s.iY+V)&&(q=!0,R=1)):"hbar"===s.A.AF&&(V=s.getNodeData("w")||s.I,ZC.DS(P,s.iX,s.iX+V)&&ZC.DS(N,s.iY-s.F/2,s.iY+s.F/2)&&(q=!0,R=1)),((n=Math.sqrt((s.iX-P)*(s.iX-P)+(s.iY-N)*(s.iY-N)))<R||q)&&(W={infotype:"node",xydistance:R,graphid:a.K,plotidx:o.L,plotid:o.H8,nodeidx:s.L,nodevalue:s.AD,nodekeyvalue:null===s.BT?k.V[s.L]:s.BT},q||(R=n));break;case"":var $=s.ACE();(n=Math.sqrt(($[0]-P)*($[0]-P)+($[1]-N)*($[1]-N)))<R&&(W={infotype:"node",xydistance:R,graphid:a.K,plotidx:o.L,plotid:o.H8,nodeidx:s.L,nodevalue:s.AD,nodekeyvalue:null===s.BT?k.V[s.L]:s.BT},R=n)}W&&H.push(W)}}}return H;case"update":t.objects?(a=F.C8(t.graphid))&&(a.OW(),a.QR()):null!==ZC._n_(t.graphid)&&(a=F.C8(t.graphid))?F.QH(function(){a.K6(y,y)}):F.K6();break;case"setcharttype":(a=F.C8(t.graphid))&&(null!==ZC._n_(t["preserve-state"])&&ZC._b_(t["preserve-state"])?F.E["graph-state-"+a.L]=JSON.stringify(a.E):F.E["graph-state-"+a.L]=null,F.o.graphset[a.L].type=a.o.type=a.AF=t.type,x&&F.K6());break;case"addgraph":F.o.graphset.push(t.data||{}),x&&F.K6();break;case"addplot":if(zingchart.SKIP.CSV=!0,h={},d=t.plotdata?"plotdata":"data",null!==ZC._n_(t[d])&&("object"==typeof t[d]?ZC._cp_(t[d],h):h=JSON.parse(t[d])),ZC._todash_(h),a=F.C8(t.graphid)){var ee=[];if(null===ZC._n_(a.o.series)&&(a.o.series=[]),Z=(null!==ZC._n_(t.plotindex)||null!==ZC._n_(t.plotid))&&(o=a.I0(t.plotindex,t.plotid))?o.L:a.o.series.length,null!==ZC._n_(a.IX)&&a.IX.splice(Z,0,!1),null!==ZC._n_(a.CB)){for(E in K={},a.CB)(D=ZC._i_(E.replace("p","")))<Z?K[E]=a.CB[E]:K["p"+(D+1)]=a.CB[E];K["p"+Z]={},a.CB=K}for(A=0,C=a.o.series.length;A<=C;A++)A===Z&&ee.push(h),a.o.series[A]&&ee.push(a.o.series[A]);ZC.AP.BY("plot_add",F,{id:F.K,graphid:a.K,plotindex:Z,data:h}),F.o.graphset[a.L].series=a.o.series=ee,F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&(a.E["from-api"]=!0,F.QH(function(){a.K6(y,y)}))}break;case"removeplot":if(zingchart.SKIP.CSV=!0,(a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))){if(null!==ZC._n_(a.IX)&&a.IX.splice(o.L,1),null!==ZC._n_(a.CB)){for(E in K={},a.CB)(D=ZC._i_(E.replace("p","")))<o.L?K[E]=a.CB[E]:K["p"+(D-1)]=a.CB[E];a.CB=K}a.o.series.splice(o.L,1),F.o.graphset[a.L].series=a.o.series,F.E.json=ZC.GV(JSON.stringify(F.o)),ZC.AP.BY("plot_remove",F,{id:F.K,graphid:a.K,plotindex:o.L}),a.LV("on-change"),a.K6(y,y)}break;case"modify":if(zingchart.SKIP.CSV=!0,h={},null!==ZC._n_(t.data)&&("object"==typeof t.data?ZC._cp_(t.data,h):h=JSON.parse(t.data)),ZC._todash_(h),a=F.C8(t.graphid)){if(a.B9&&(a.B9.I2=!1,a.E["force-preview-parse"]=!0),null!==ZC._n_(t.object))switch(t.object){case"title":ZC._cp_(h,a.o.title);break;case"plotset":case"series":ZC._cp_(h,a.o.series);break;case"plotarea":ZC._cp_(h,a.o.plotarea);break;case"legend":ZC._cp_(h,a.o.legend);break;case"plot":ZC._cp_(h,a.o.plot);break;case"map":ZC._cp_(h,a.o.shapes[0])}else ZC._cp_(h,a.o);switch(t.object){case"title":F.o.graphset[a.L].title=a.o.title;break;case"plotset":case"series":F.o.graphset[a.L].series=a.o.series;break;case"plotarea":F.o.graphset[a.L].plotarea=a.o.plotarea;break;case"legend":F.o.graphset[a.L].legend=a.o.legend;break;case"plot":F.o.graphset[a.L].plot=a.o.plot;break;case"map":F.o.graphset[a.L].shapes[0]=a.o.shapes[0],F.XO(F.o),a.o.shapes=F.o.graphset[a.L].shapes;break;default:F.o.graphset[a.L]=a.o}F.E.json=ZC.GV(JSON.stringify(F.o)),ZC.AP.BY("modify",F,{id:F.K,graphid:a.K,data:h,object:t.object}),a.LV("on-change"),x&&(a.E["from-api"]=!0,F.QH(function(){a.K6(y,y)}))}break;case"modifyplot":zingchart.SKIP.CSV=!0,h={},d=t.plotdata?"plotdata":"data",null!==ZC._n_(t[d])&&("object"==typeof t[d]?ZC._cp_(t[d],h):h=JSON.parse(t[d])),ZC._todash_(h),(a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))&&(null===ZC._n_(F.o.graphset[a.L].series)&&(F.o.graphset[a.L].series=[]),ZC._cp_(h,a.o.series[o.L]),F.o.graphset[a.L].series[o.L]=a.o.series[o.L],F.E.json=ZC.GV(JSON.stringify(F.o)),ZC.AP.BY("plot_modify",F,{id:F.K,graphid:a.K,plotindex:o.L,data:h}),a.LV("on-change"),x&&(a.E["from-api"]=!0,F.QH(function(){a.K6(y,y)})));break;case"setnodevalue":zingchart.SKIP.CSV=!0,(a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))&&(B=0,null!==ZC._n_(t.nodeindex)&&(B=ZC._i_(t.nodeindex)),n=0,null!==ZC._n_(t.value)&&(n=t.value),ZC.AP.BY("node_set",F,{id:F.K,graphid:a.K,plotindex:o.L,nodeindex:B,key:B,value:n,text:n}),F.o.graphset[a.L].series[o.L].values[B]=a.o.series[o.L].values[B]=n,F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&(a.E["from-api"]=!0,a.K6(y,y)));break;case"setscalevalues":if(zingchart.SKIP.CSV=!0,a=F.C8(t.graphid)){for(f=t.scale||"scale-x",_=0,g=a.BO.length;_<g;_++)f===a.BO[_].BE&&null!==ZC._n_(a.o[f])&&(a.o[f].values=t.values,F.o.graphset[a.L][f]=F.o.graphset[a.L][f]||{},F.o.graphset[a.L][f].values=t.values);F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&(a.E["from-api"]=!0,a.K6(y,y))}break;case"addscalevalue":if(zingchart.SKIP.CSV=!0,a=F.C8(t.graphid)){for(f=t.scale||"scale-x",_=0,g=a.BO.length;_<g;_++)if(f===a.BO[_].BE&&null!==ZC._n_(a.o[f])&&null!==ZC._n_(a.o[f].values)){for(B=null===ZC._n_(t.nodeindex)?a.o[f].values.length:ZC._i_(t.nodeindex),(b=a.o[f].values).push(null),A=b.length-1;A>B;A--)b[A]=b[A-1];b[B]=t.value||"",F.o.graphset[a.L][f].values=b}F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&(a.E["from-api"]=!0,a.K6(y,y))}break;case"removescalevalue":if(zingchart.SKIP.CSV=!0,a=F.C8(t.graphid)){for(f=t.scale||"scale-x",_=0,g=a.BO.length;_<g;_++)f===a.BO[_].BE&&null!==ZC._n_(a.o[f])&&null!==ZC._n_(a.o[f].values)&&(B=null===ZC._n_(t.nodeindex)?a.o[f].values.length-1:ZC._i_(t.nodeindex),(b=a.o[f].values).splice(B,1),F.o.graphset[a.L][f].values=b);F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&(a.E["from-api"]=!0,a.K6(y,y))}break;case"addnode":zingchart.SKIP.CSV=!0,a=F.C8(t.graphid);var ie=t.value instanceof Array;if(a&&(o=a.I0(t.plotindex,t.plotid))){v=a.o.series[o.L].values,B=null===ZC._n_(t.nodeindex)?v.length:t.nodeindex,v.push(null);var te=v.length;for(B=ZC.BQ(0,ZC.CY(B,te)),A=te-1;A>B;A--)v[A]=v[A-1];if(v[B]=t.value,!ie)for(_=0,g=a.BO.length;_<g;_++)if(f=a.BO[_].BE,"k"===a.BO[_].AF&&null!==ZC._n_(t[f+"-value"])&&null!==ZC._n_(a.o[f])&&null!==ZC._n_(a.o[f].values)){for((b=a.o[f].values).push(null),A=b.length-1;A>B;A--)b[A]=b[A-1];b[B]=t[f+"-value"],F.o.graphset[a.L][f].values=b}ZC.AP.BY("node_add",F,{id:F.K,graphid:a.K,plotindex:o.L,nodeindex:B,key:B,value:t.value,text:t.value}),F.o.graphset[a.L].series[o.L].values=a.o.series[o.L].values,F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&(a.E["from-api"]=!0,a.K6(y,y))}break;case"removenode":if(zingchart.SKIP.CSV=!0,(a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))){v=a.o.series[o.L].values,B=null===ZC._n_(t.nodeindex)?o.S.length-1:ZC._i_(t.nodeindex);var ne=!0;if(null!==ZC._n_(t.nodekeyvalue))for(ne=!1,_=0,g=o.S.length;_<g;_++){if(null===o.S[_]&&_===t.nodekeyvalue){ne=!0,B=_;break}if(o.S[_]&&null!==ZC._n_(o.S[_].BT)&&o.S[_].BT===t.nodekeyvalue){ne=!0,B=_;break}}if(ne&&ZC.DS(B,0,o.S.length-1)){for(v.splice(B,1),_=0,g=a.BO.length;_<g;_++)f=a.BO[_].BE,"k"===a.BO[_].AF&&null!==ZC._n_(t[f])&&ZC._b_(t[f])&&null!==ZC._n_(a.o[f])&&null!==ZC._n_(a.o[f].values)&&((b=a.o[f].values).splice(B,1),F.o.graphset[a.L][f].values=b);(ne||o.S[B])&&(ZC.AP.BY("node_remove",F,{id:F.K,graphid:a.K,plotindex:o.L,nodeindex:B,key:B,value:o.S[B]?o.S[B].AD:null,text:o.S[B]?o.S[B].AD:null}),F.o.graphset[a.L].series[o.L].values=a.o.series[o.L].values,F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&(a.E["from-api"]=!0,a.K6(y,y)))}}break;case"setdata":if(h={},null!==ZC._n_(t.data))if("object"==typeof t.data)zingchart.DEV.COPYDATA?h=JSON.parse(JSON.stringify(t.data)):ZC._cp_(t.data,h);else try{h=JSON.parse(t.data)}catch(fe){return F.NU(fe,"JSON parser"),!1}ZC._todash_(h),null===ZC._n_(t.preservezoom)&&(F.E.preservezoom=!1),a=null,null!==ZC._n_(t.graphid)&&(a=F.C8(t.graphid)),ZC.AP.BY("setdata",F,{id:F.K,graphid:a?a.K:null,data:h});var ae,le,oe=["x","y","width","height"];if(a){for(ae=0;ae<oe.length;ae++)delete F.E["graph-"+a.L+"-"+oe[ae]];F.o.graphset[a.L]=a.o=h;var re=!1;if(h.widgets)re=!0;else if(h.shapes)for(A=0;A<h.shapes.length;A++)"zingchart.maps"===h.shapes[A].type&&(re=!0);re&&F.XO(F.o),F.E.json=ZC.GV(JSON.stringify(F.o)),x&&(a.E["from-api"]=!0,I&&F.NS++,F.QH(function(){F.parse(a.K),F.AG[a.L].paint()}))}else{for(ae=0;ae<oe.length;ae++)for(le=0;le<F.AG.length;le++)delete F.E["graph-"+le+"-"+oe[ae]];F.o=h,F.E.json=ZC.GV(JSON.stringify(F.o)),F.XO(F.o),x&&(I&&F.NS++,F.K6())}break;case"getseriesdata":return(a=F.C8(t.graphid))?null!==ZC._n_(t.plotindex)||null!==ZC._n_(t.plotid)?(o=a.I0(t.plotindex,t.plotid,0))?a.o.series[o.L]:null:a.o.series:null;case"setseriesdata":case"appendseriesdata":if(zingchart.SKIP.CSV=!0,a=F.C8(t.graphid)){if(null!==ZC._n_(t.plotindex)||null!==ZC._n_(t.plotid)?(o=a.I0(t.plotindex,t.plotid,0),h="setseriesdata"===i?{}:a.o.series&&a.o.series[o.L]?a.o.series[o.L]:{}):h="setseriesdata"===i?[]:a.o.series||[],null!==ZC._n_(t.data)&&("object"==typeof t.data?ZC._cp_(t.data,h):ZC._cp_(JSON.parse(t.data),h)),ZC._todash_(h),null!==ZC._n_(t.plotindex)||null!==ZC._n_(t.plotid))o=a.I0(t.plotindex,t.plotid,0),F.o.graphset[a.L].series[o.L]=a.o.series[o.L]=h,h.hasOwnProperty("visible")&&(a.E["plot"+o.L+".visible"]=h.visible);else for(F.o.graphset[a.L].series=a.o.series=h,A=0;A<h.length;A++)h[A].hasOwnProperty("visible")&&(a.E["plot"+A+".visible"]=h[A].visible);F.E.json=ZC.GV(JSON.stringify(F.o)),a.LV("on-change"),x&&F.QH(function(){a.K6(y,y)})}break;case"getseriesvalues":if(a=F.C8(t.graphid)){if(null!==ZC._n_(t.plotindex)||null!==ZC._n_(t.plotid))return(o=a.I0(t.plotindex,t.plotid,0))&&a.o.series[o.L].values||[];for(m=[],A=0,C=a.AY.A4.length;A<C;A++)m.push(a.o.series[A].values||[]);return m}return null;case"setseriesvalues":case"appendseriesvalues":zingchart.SKIP.CSV=!0,m=[],null!==ZC._n_(t.values)&&(m="object"==typeof t.values?t.values:JSON.parse(t.values));var se=!1;if(a=F.C8(t.graphid)){if(null===ZC._n_(t.plotindex)&&null===ZC._n_(t.plotid)||(m=[m],se=!0),se||"setseriesvalues"!==i){for(o=a.I0(t.plotindex,t.plotid,0),A=0,C=m.length;A<C;A++)if(a.AY.A4[o.L+A])if("setseriesvalues"===i)se&&(F.o.graphset[a.L].series[o.L+A].values=a.o.series[o.L+A].values=m[A]);else{var Ae=F.o.graphset[a.L].series[o.L+A].values,Ce=m[A].length>0&&null!==ZC._n_(m[A][0])&&m[A][0].length>1,ce=!0;if(null!==ZC._n_(n=t.ignoreduplicates)&&(ce=ZC._b_(n)),Ce){var ue=Ae.length;for(c=0,u=m[A].length;c<u;c++){for(var pe=!1,Ze=ue-1;Ze>=0;Ze--){if(m[A][c][0]>Ae[Ze][0]){Ae.push(m[A][c]),pe=!0;break}if(m[A][c][0]===Ae[Ze][0]){pe=!0;break}}pe&&ce||Ae.push(m[A][c])}}else for(c=0,u=m[A].length;c<u;c++)Ae.push(m[A][c]);t["max-values"]&&ZC._i_(t["max-values"])<Ae.length&&(Ae=Ae.slice(-t["max-values"])),F.o.graphset[a.L].series[o.L+A].values=a.o.series[o.L+A].values=Ae}}else{for(_=0;_<m.length;_++)F.o.graphset[a.L].series[_]=F.o.graphset[a.L].series[_]||{},a.o.series[_]=a.o.series[_]||{},F.o.graphset[a.L].series[_].values=a.o.series[_].values=m[_];if(a.o.series.length>m.length)for(_=m.length;_<a.o.series.length;_++)delete F.o.graphset[a.L].series[_],delete a.o.series[_]}a.LV("on-change"),F.E.json=ZC.GV(JSON.stringify(F.o)),x&&a.K6(y,y)}break;case"togglelegend":if((a=F.C8(t.graphid))&&a.BD){var he=!0;"undefined"==typeof a.BD.o.visible||a.BD.o.visible||(he=!1),a.BD.o.visible=!he,a.BD.clear(!1),a.BD.parse(),a.BD.paint()}break;case"legendminimize":case"legendmaximize":(a=F.C8(t.graphid))&&a.BD&&("legendminimize"===i?(ZC.AP.BY("legend_minimize",F,a.GX()),ZC.AP.BY("legend_hide",F,a.GX())):(ZC.AP.BY("legend_maximize",F,a.GX()),ZC.AP.BY("legend_show",F,a.GX())),a.BD.N8="legendminimize"===i,a.BD.VT(),a.BD.clear(!1),a.BD.parse(),a.BD.paint());break;case"legendscroll":(a=F.C8(t.graphid))&&a.BD&&(o=a.I0(t.plotindex,t.plotid))&&(a.BD.scrollTo(ZC._i_(o.L)),a.BD.VT(),a.BD.clear(!0),a.BD.YG=!0,a.BD.parse(),a.BD.paint());break;case"toggledimension":(a=F.C8(t.graphid))&&F.A54(a.K);break;case"getdata":return h=JSON.parse(F.E.json),ZC._todash_(h,!0),h;case"getoriginaljson":return h=JSON.parse(F.E.source),ZC._todash_(h,!0),h;case"getgraphlength":return F.AG.length;case"getplotlength":return(a=F.C8(t.graphid))?a.AY.A4.length:0;case"getscales":if(a=F.C8(t.graphid)){var de=[];for(A=0;A<a.BO.length;A++)de.push(a.BO[A].BE);return de}return[];case"getnodelength":return(a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))?o.S.length:null;case"getnodevalue":return(a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))&&null!==ZC._n_(t.nodeindex)&&(s=o.S[ZC._i_(t.nodeindex)])?o.EF?[s.BT,s.AD]:s.AD:null;case"getplotvalues":if((a=F.C8(t.graphid))&&(o=a.I0(t.plotindex,t.plotid))){for(m=[],A=0,C=o.S.length;A<C;A++)o.S[A]?o.EF?m.push([o.S[A].BT,o.S[A].AD]):m.push(o.S[A].AD):m.push(null);return m}return null}}return null};var A9T={$i:function(){var e=this;e.OG=null,e.o={},e.I6=null,e.J9=null,e.E={},e.E7=[],e.HT=null,e.MJ=""},H3:function(e,i,t,n,a){var l=this;if(e.HT){a=a||l.MJ;var o=e.HT.call(l,n,a);t&&o&&(o[t+"-state"]?o=o[t+"-state"]:o[t+"State"]&&(o=o[t+"State"]));var r,s,A=l.getPMap(),C={},c={};for(var u in o)r=ZC.EE(u),s=ZC.UJ(u),"backgroundColor"===r?C.A0=C.AE=ZC.AP.GC(o[u]):"borderRadius"===r?C.F6=C.FS=C.FD=C.F2=o[u]:"padding"===u?C.FM=C.FN=C.FU=C.EQ=o[u]:A[r]?C[A[r]]=o[u]:C[r]=o[u],c[s]=o[u];i.o||ZC._cp_(o,C),ZC._cp_(C,i),i.o&&(ZC._cp_(c,i.o),i.KX())}},parse:function(){var s=this,G,i,oRule,KT;"dashed"!==zingchart.SYNTAX&&ZC._todash_(s.o);var AA="";if("undefined"!=typeof s.H&&(AA=s.H.AA),ZC.ZO(s.o,"html5"),""!==AA&&ZC.ZO(s.o,AA),zingchart.DEV.MEDIARULES&&s.o["media-rules"]&&"undefined"!=typeof s.H)for(i=0;i<s.o["media-rules"].length;i++)oRule=s.o["media-rules"][i],KT=!0,null!==ZC._n_(oRule["min-width"])&&ZC._i_(oRule["min-width"])>s.H.I&&(KT=!1),null!==ZC._n_(oRule["max-width"])&&ZC._i_(oRule["max-width"])<s.H.I&&(KT=!1),null!==ZC._n_(oRule["min-height"])&&ZC._i_(oRule["min-height"])>s.H.F&&(KT=!1),null!==ZC._n_(oRule["max-height"])&&ZC._i_(oRule["max-height"])<s.H.F&&(KT=!1),KT&&ZC._cp_(oRule,s.o);for(s.o.rules&&(s.E7=s.o.rules),i=0;i<s.E7.length;i++)if("*"===s.E7[i].rule&&s.E7[i].js){s.o["js-rule"]=s.E7[i].js,s.E7.splice(i,1);break}if(G=s.o["js-rule"])if("function"==typeof G)s.MJ="",s.HT=eval(G);else if("javascript:"===G.substring(0,11)||G.indexOf("(")<G.indexOf(")"))try{s.MJ="";var EC=G.replace("javascript:",""),iOpen=G.indexOf("("),iClose=G.indexOf(")");-1!==iOpen&&-1!==iClose&&(s.MJ=EC.substr(iOpen+1,iClose-iOpen-1),EC=EC.substr(0,iOpen)),s.HT=ZC.evalFn(EC,window)}catch(e){}if("undefined"!=typeof s.H&&null!==s.H.QP)for(var g in s.H.QP)s.H.QP.hasOwnProperty(g)&&null===ZC._n_(s.o[g])&&(s.o[g]=s.H.QP[g])},getPMap:function(){return{}},addPMap:function(e,i,t){for(var n=i.split(","),a=t.split(","),l=0,o=a.length;l<o;l++)e[n[l]]=a[l]},getData:function(){return this.o},setData:function(e){this.o=e},getAttributes:function(){return this.E},getAttribute:function(e){return this.E[e]},setAttribute:function(e,i){this.E[e]=i},get:function(e){var i=this.getPMap();return i[e]?this[i[e]]:null},set:function(e,i){var t=this.getPMap();t[e]&&(this[t[e]]=i)},append:function(e,i,t){null===i&&(i=!0);var n=this;e&&(n.I6||(n.I6={},ZC._cp_(n.o,n.I6,!0,t)),n.J9||(n.J9={}),ZC._cp_(e,n.J9,!0,t),ZC._cp_(e,n.o,!0,t)),"undefined"!=typeof n.AD2&&n.AD2()&&e&&ZC._cp_(e,n.o)},AD2:function(){},assign_a:function(e){for(var i=0,t=e.length;i<t;i++)this.o.hasOwnProperty(e[i][0])&&this.ZQ(e[i][0],e[i][1],e[i][2],e[i][3],e[i][4])},ZQ:function(e,i,t,n,a){var l,o=this;if(null!==(l=o.o[e])&&void 0!==l){if(t)switch(-1!==t.indexOf("p")&&(l=ZC._p_(l),t=t.replace("p","")),-1!==t.indexOf("a")&&(l=ZC._a_(l),t=t.replace("a","")),t){case"i":l=ZC._i_(l);break;case"f":l=ZC._f_(l);break;case"b":l=ZC._b_(l);break;case"c":l=ZC.AP.YN(l,o),(l=ZC.AP.GC(l,o))instanceof Array&&("color"===e||"font-color"===e?(o.o["text-alpha"]=l[1],o.V5=l[1],o.E["text-alpha"]=l[1]):"border-color"===e?(o.o["border-alpha"]=l[1],o.O0=l[1],o.E["b-alpha"]=l[1]):("line-color"===e&&(o.E["l-alpha"]=l[1]),null===ZC._n_(o.o.alpha)&&(o.C6=l[1])),l=l[0])}null!==ZC._n_(n)&&null!==ZC._n_(a)&&(l=ZC._l_(l,n,a)),o[i]=l}},DE:function(){for(var e=this,i=!1,t=0,n=e.E7.length;t<n;t++){var a=!1;try{a=new Function("return ("+e.J2(e.E7[t].rule)+")")()}catch(l){a=!1}a&&(i=!0,e.append(e.E7[t]))}return i},ACJ:function(e){for(var i="",t=0,n=e.length;t<n;t++){var a=!1;try{a=new Function("return ("+this.J2(e[t].rule)+")")()}catch(l){a=!1}a&&(i+="<"+e[t].rule+">")}return""!==i?[i,ZC.XK.md5(i)]:null},J2:function(){return!0},copy:function(e){var i=this;ZC._cp_(e.o,i.o),e.I6&&(i.I6=i.I6||{},ZC._cp_(e.I6,i.I6)),e.J9&&(i.J9=i.J9||{},ZC._cp_(e.J9,i.J9)),ZC._cp_(e.E,i.E),ZC._cp_(e.E7,i.E7)}};ZC.A9T=ZC.C9.CA(A9T);var D0={$i:function(e){this.b(e);var i=this;e&&e.H&&(i.H=e.H),i.K="",i.DK=null,i.AN=!0,i.A0="-1",i.AE="-1",i.GR="",i.HN="",i.VM=!0,i.DA="",i.M4="repeat",i.TA="50% 50%",i.WN="",i.KO=1,i.NH="linear",i.N7=90,i.VO=0,i.W5=0,i.AZ=0,i.B7="#000",i.GD="",i.EX=0,i.G9=0,i.AU=0,i.BW="#000",i.C6=1,i.O0=1,i.T7="butt",i.ZZ="round",i.M8=!1,i.OH=45,i.JW=2,i.T5=.75,i.RT="#999",i.PD=0,i.CZ=!0,i.N4=!1,i.L5=!1,i.A2A=!1,i.LO=null,i.BF=""},getPMap:function(){var e=this.b();return this.addPMap(e,"visible,backgroundColor1,backgroundColor2,gradientColors,gradientStops,backgroundImage,backgroundRepeat,backgroundPosition,backgroundFit,backgroundScale,fillType,fillAngle,fillOffsetX,fillOffsetY,lineWidth,lineColor,lineStyle,lineSegmentSize,lineGapSize,borderWidth,borderColor,borderAlpha,alpha,lineCap,shadow,shadowAngle,shadowDistance,shadowAlpha,shadowColor,shadowBlur,class,border","AN,A0,AE,GR,HN,DA,M4,TA,WN,KO,NH,N7,VO,W5,AZ,B7,GD,EX,G9,AU,BW,O0,C6,T7,M8,OH,JW,T5,RT,PD,DK,BF"),e},copy:function(e){this.b(e);for(var i="AN,A0,AE,GR,HN,DA,VM,M4,TA,WN,KO,NH,N7,VO,W5,AZ,B7,GD,EX,G9,AU,BW,O0,C6,T7,M8,OH,JW,T5,RT,PD,CZ,L5,DK,H,BF".split(","),t=0,n=i.length;t<n;t++)"undefined"!=typeof e[i[t]]&&(this[i[t]]=e[i[t]])},AD2:function(){var e,i,t=this,n=!1;if((t.o["class"]||t.o.cls||t.o.id)&&null!==t.H&&null!==t.H.N){if(e=t.o["class"]||t.o.cls)for(var a=e.split(/(\s+)/),l=0,o=a.length;l<o;l++)(i=t.H.N["."+a[l]])&&(n=!0,ZC._cp_(i,t.o));(e=t.o.id)&&(i=t.H.N["#"+e])&&(n=!0,ZC._cp_(i,t.o))}return null!==t.OG&&(i=t.H.N[t.OG])&&(n=!0,ZC._cp_(i,t.o)),n},KX:function(e){var i,t=this;switch(null===ZC._n_(e)&&(e=t.AZ),t.GD){case"dotted":t.EX=ZC.BQ(1,.75*e),t.G9=1.75*e;break;case"dashed":t.EX=4*e,t.G9=3*e;break;case"dashdot":t.EX=4*e,t.G9=2*e;break;default:t.EX=0,t.G9=0}null!==(i=ZC._n_(t.o["line-segment-size"]))&&(t.EX=parseInt(i,10)),null!==(i=ZC._n_(t.o["line-gap-size"]))&&(t.G9=parseInt(i,10))},parse:function(){var e,i,t,n,a,l,o,r,s;this.b();var A=this;if(null!==(e=ZC._n_(A.o.override))&&!A.A2A){var C,c,u,p=-1,Z=-1;for("undefined"!=typeof A.E.plotidx&&(p=ZC._i_(A.E.plotidx)),"undefined"!=typeof A.E.nodeidx&&(Z=ZC._i_(A.E.nodeidx)),o=0,r=e.length;o<r;o++){if(C=-1,c=-1,e[o].hook){if(null!==(i=ZC._n_(e[o].hook["node-index"]))){if(c=0,u=[],"object"==typeof i)u=i;else if("string"==typeof i){if(-1!==i.indexOf(","))u=i.split(",");else if(-1!==i.indexOf("-"))for(t=i.split("-"),n=ZC._i_(t[0]);n<=ZC._i_(t[1]);n++)u.push(n)}else u=[i];-1!==ZC.AV(u,Z)&&(c=1)}if(null!==(i=e[o].hook["plot-index"])&&void 0!==i){if(C=0,u=[],"object"==typeof i)u=i;else if("string"==typeof i){if(-1!==i.indexOf(","))u=i.split(",");else if(-1!==i.indexOf("-"))for(t=i.split("-"),n=ZC._i_(t[0]);n<ZC._i_(t[1]);n++)u.push(n)}else u=[i];-1!==ZC.AV(u,p)&&(C=1)}}0!==C&&0!==c&&A.append(e[o])}}if(null!==(e=A.LO)&&A.append(e),e=A.o["background-color"]){if(e=ZC.AP.YN(e,this),"rgb("===String(e).substring(0,4))for(a=new RegExp("rgb\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\)");l=a.exec(e);)e=e.replace(l[0],ZC.AP.GC(l[0]));if("rgba("===String(e).substring(0,5))for(a=new RegExp("rgba\\((\\d{1,3}),\\s*(\\d{1,3}),\\s*(\\d{1,3})\\,\\s*([0-9.]+)\\)");l=a.exec(e);){var h=ZC.AP.GC(l[0],A);e=e.replace(l[0],h[0]),A.o.alpha=h[1],A.C6=h[1],A.E["bg-alpha"]=h[1],null===ZC._n_(A.E["b-alpha"])&&(A.E["b-alpha"]=1),null===ZC._n_(A.E["l-alpha"])&&(A.E["l-alpha"]=1)}var d=ZC.GV(String(e)).split(/\s+|;|,/);A.A0=ZC.AP.GC(d[0]),A.AE=1===d.length?A.A0:ZC.AP.GC(d[1])}if(!(null===ZC._n_(A.o["border-width"])&&null===ZC._n_(A.o["border-color"])&&null===ZC._n_(A.o["line-style"])||null===ZC._n_(A.o["border-top"])&&null===ZC._n_(A.o["border-right"])&&null===ZC._n_(A.o["border-bottom"])&&null===ZC._n_(A.o["border-left"])&&null===ZC._n_(A.o.border))){var f=["top","right","bottom","left"],_={top:[0,"solid","#000"],right:[0,"solid","#000"],bottom:[0,"solid","#000"],left:[0,"solid","#000"]};if(A.I6=A.I6||{},e=A.I6.border)for(s=e.split(/\s/),o=0;o<4;o++)_[f[o]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")];if(null!==ZC._n_(A.I6["border-width"]))for(o=0;o<4;o++)_[f[o]][0]=A.I6["border-width"];if(null!==ZC._n_(A.I6["line-style"]))for(o=0;o<4;o++)_[f[o]][1]=A.I6["line-style"];if(null!==ZC._n_(A.I6["border-color"]))for(o=0;o<4;o++)_[f[o]][2]=A.I6["border-color"];for(o=0;o<4;o++)(e=A.I6["border-"+f[o]])&&(s=e.split(/\s/),_[f[o]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")]);if(A.J9=A.J9||{},e=A.J9.border)for(s=e.split(/\s/),o=0;o<4;o++)_[f[o]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")];if(null!==ZC._n_(A.J9["border-width"]))for(o=0;o<4;o++)_[f[o]][0]=A.J9["border-width"];if(null!==ZC._n_(A.J9["line-style"]))for(o=0;o<4;o++)_[f[o]][1]=A.J9["line-style"];if(null!==ZC._n_(A.J9["border-color"]))for(o=0;o<4;o++)_[f[o]][2]=A.J9["border-color"];for(o=0;o<4;o++)(e=A.J9["border-"+f[o]])&&(s=e.split(/\s/),_[f[o]]=[ZC._i_(s[0]||"0"),ZC.GV(s[1]||"solid"),ZC.AP.GC(s[2]||"#000000")]);for(o=0;o<4;o++)null===ZC._n_(A.o["border-"+f[o]])&&(A.o["border-"+f[o]]=_[f[o]].join(" "))}A.assign_a([["visible","AN","b"],["background-color-1","A0","c"],["background-color-2","AE","c"],["gradient-colors","GR"],["gradient-stops","HN"],["pixel-correction","CZ","b"],["background-clip","VM","b"],["background-image","DA"],["background-repeat","M4"],["background-position","TA"],["background-fit","WN"],["background-scale","KO","f"],["fill-type","NH"],["fill-angle","N7","i"],["fill-offset-x","VO","f"],["fill-offset-y","W5","f"],["line-width","AZ","i"],["line-color","B7","c"],["line-style","GD",""],["class","DK"],["cls","DK"],["border","BF"]]),"none"===A.NH&&(A.AE=A.A0,A.NH="linear"),""!==A.BF&&(s=A.BF.split(/\s/),A.AU=ZC._i_(s[0]||"0"),A.GD=ZC.GV(s[1]||"solid"),A.BW=ZC.AP.GC(s[2]||"#000000")),A.GR=ZC.AP.YN(A.GR,this),A.KX(),A.assign_a([["line-segment-size","EX","i"],["line-gap-size","G9","i"],["border-width","AU","i"],["border-color","BW","c"],["alpha","C6","f",0,1],["shadow","M8","b"],["shadow-angle","OH","i",0,360],["shadow-distance","JW","i"],["shadow-alpha","T5","f",0,1],["shadow-color","RT","c"],["shadow-blur","PD","i"]]),A.O0=A.C6,A.assign_a([["border-alpha","O0","f",0,1]])}};ZC.D0=ZC.A9T.CA(D0),ZC.CR={contour:function(e,i,t){var n,a,l;if(e&&t&&0!==t.length){if(!i.E["fast-vector-path"])for(n=0,a=t.length;n<a;n++)t[n]&&(t[n][0]=parseFloat(Number(t[n][0]).toFixed(2)),t[n][1]=parseFloat(Number(t[n][1]).toFixed(2)));var o=!1,r=t.length;for(n=0;n<r;n++)null!==ZC._n_(t[n])&&(l=[t[n][0],t[n][1]],null!==ZC._n_(t[n][2])&&l.push(t[n][2],t[n][3]),null!==ZC._n_(t[n][4])&&l.push(t[n][4],t[n][5]),i.N4&&(l[0]=Math.round(l[0]),l[1]=Math.round(l[1]),4===l.length&&(l[2]=Math.round(l[2]),l[3]=Math.round(l[3]))),i.CZ&&i.AZ%2==1&&(l[0]-=.5,l[1]-=.5,4===l.length&&(l[2]-=.5,l[3]-=.5))),0===n?e.moveTo(l[0],l[1]):t[n]?(o&&(e.moveTo(l[0],l[1]),o=!1),2===l.length?e.lineTo(l[0],l[1]):4===l.length?e.quadraticCurveTo(l[0],l[1],l[2],l[3]):6===l.length&&e.arc(l[0],l[1],l[2],ZC.T1(l[3]),ZC.T1(l[4]),l[5])):o=!0}},setup:function(e,i){var t=i.H.AA;if(1!==i.C6&&i.L5&&(null===ZC._n_(i.o["border-color"])&&(i.BW=i.A0),null===ZC._n_(i.o["border-width"])))switch(t){case"canvas":i.AU=.2;break;case"svg":i.AU=.1;break;case"vml":i.AU=.2,i.E.A8F=i.C6/10}},paint:function(e,i,t,n,a,l){if(null===ZC._n_(a)&&(a=2),null===ZC._n_(n)&&(n=!1),null===ZC._n_(l)&&(l=!1),e&&t&&0!==t.length&&i){var o,r,s,A,C,c;!l&&t.length>2&&null!==t[0]&&null!==t[t.length-1]&&t[0].join(",")===t[t.length-1].join(",")&&(i.T7="round");var u=i.H.AA;if("canvas"!==u||0!==i.AZ&&"-1"!==i.B7){if(i.M8&&!n){i.C7=i.C7||i.Z;var p,Z=ZC.Q._sh_(t,i);"undefined"!=typeof i.A4V?p=i.A4V:((p=new ZC.DT(i)).copy(i),p.K=i.K+"-sh",p.M8=!1,p.AZ+=p.PD,p.B7=p.RT),p.C6=i.C6*p.T5,"undefined"==typeof i.ADH&&(i.A4V=p),p.CZ=!1,o=i.C7?ZC.Q.EB(i.C7,u):e,ZC.CR.setup(o,p),ZC.CR.paint(o,p,Z,!1,1,l)}var h=ZC._i_(i.EX||"0"),d=ZC._i_(i.G9||"0");"solid"===i.GD&&(h=d=0);var f=t.length;"undefined"==typeof i.A9&&(i.A9=0),"canvas"===u&&(e.lineJoin=i.ZZ,e.lineCap=i.T7,e.strokeStyle=ZC.AP.A32(ZC.AP.GC(i.B7),n?i.O0:i.C6),e.lineWidth=i.AZ,e.beginPath());var _=!1;if(-1!==ZC.AV(["svg","vml"],u))r=l?[]:ZC.Q.A2W(t,u,i,n);else{var g=!1;"dashdot"!==i.GD&&(g=e.setLineDash)&&e.setLineDash(0===h||0===d?[]:[h,d]);var v=0,b=[ZC.MAX,ZC.MAX,-ZC.MAX,-ZC.MAX];for(c=0;c<f;c++)if(null!==t[c]){if(null!==(s=ZC.objmove?t[c]:ZC.Q._txp_(t[c],u,i,n))&&!isNaN(s[0])&&!isNaN(s[1])&&isFinite(s[0])&&isFinite(s[1]))if(f<=6&&n&&(b[0]=ZC.CY(b[0],s[0]),b[1]=ZC.CY(b[1],s[1]),b[2]=ZC.BQ(b[2],s[0]),b[3]=ZC.BQ(b[3],s[1])),0===c)2===s.length?e.moveTo(s[0],s[1]):6===s.length&&e.arc(s[0],s[1],s[2],ZC.T1(s[3]),ZC.T1(s[4]),s[5]);else if(_&&(e.moveTo(s[0],s[1]),_=!1),g||0===h||0===d||4===s.length||6===s.length||7===s.length)2===s.length?e.lineTo(s[0],s[1]):4===s.length?e.quadraticCurveTo(s[0],s[1],s[2],s[3]):6===s.length?e.arc(s[0],s[1],s[2],ZC.T1(s[3]),ZC.T1(s[4]),s[5]):7===s.length&&e.bezierCurveTo(s[0],s[1],s[2],s[3],s[4],s[5]);else if(null!==t[c-1]){var B=ZC.Q._txp_(t[c-1],u,i,n),m=B[4===B.length?2:0],E=B[4===B.length?3:1],D=s[0],K=s[1],F=h+d,x=D-m,I=K-E,y=Math.sqrt(x*x+I*I)+v;if(y>h){var w;v=0,w="dashdot"===i.GD?Math.floor(ZC._a_(y/((F+i.AZ+d)/2))):Math.floor(ZC._a_(y/F));var Y=Math.atan2(I,x),X=Math.cos(Y),M=Math.sin(Y),L=m,H=E,P=h;for(A=0;A<w;A++)"dashdot"===i.GD&&(F=A%2?i.AZ+d:h+d,P=A%2?i.AZ:h),x=X*F,I=M*F,e.moveTo(L,H),e.lineTo(L+X*P,H+M*P),L+=x,H+=I;e.moveTo(L,H),(y=Math.sqrt((D-L)*(D-L)+(K-H)*(K-H)))>h?e.lineTo(L+X*h,H+M*h):y>0&&e.lineTo(L+X*y,H+M*y),e.moveTo(D,K)}else v=y}}else _=!0;i.H&&f<=6&&n&&(i.H.E[i.K+"-bounds"]=b)}switch(u){case"canvas":e.globalCompositeOperation=i.A0Z,e.stroke();break;case"svg":case"vml":if(null===ZC._n_(i.o["top-state"])&&i.H.O7&&(!n||i.E.areanode)){if(C=i.E.areanode?i.A0+"-"+i.AE+"-"+i.DA+"-"+i.AZ+"-"+i.GD+"-"+i.C6+"-"+i.BM+"-"+i.BH:i.B7+"-"+i.AZ+"-"+i.GD+"-"+i.C6+"-"+i.BM+"-"+i.BH,null===ZC._n_(i.H.NT[a])){i.H.NT[a]={uid:C,ctx:e,path:r,style:i,filled:n};break}if(i.H.NT[a].uid===C&&i.H.NT[a].path.length<2e3){A=i.H.NT[a].path,r&&r[0]&&(A.length>0&&A[A.length-1].replace(/[A-Z]+/,"")===r[0].replace(/[A-Z]+/,"")&&(r[0]=""),i.H.NT[a].path=i.H.NT[a].path.concat(r));break}"svg"===u?ZC.CR.VX(i.H.NT[a].ctx,i.H.NT[a].style,i.H.NT[a].path.join(" "),i.H.NT[a].filled):ZC.CR.VW(i.H.NT[a].ctx,i.H.NT[a].style,i.H.NT[a].path.join(" "),i.H.NT[a].filled),i.H.NT[a]={uid:C,ctx:e,path:r,style:i,filled:n};break}"svg"===u?ZC.CR.VX(e,i,r.join(" "),n,l):ZC.CR.VW(e,i,r.join(" "),n)}if(null!==ZC._n_(i.o["top-state"])&&!i.Y6&&!i.E["skip-top"]&&!i.VN){var N=new ZC.HL(i.A);N.copy(i),N.VN=!0,N.M8=!1,N.Z=i.Z,N.append(i.o["top-state"]),N.K=i.K+"-top",N.parse(),"svg"===u?ZC.CR.VX(e,N,r.join(" "),n,l):"vml"===u?ZC.CR.VW(e,N,r.join(" "),n):ZC.CR.paint(e,N,t,n,a,l)}}}},smooth:function(e,i,t){var n,a,l,o;ZC._n_(i)&&(i=!1),t=t||"h";var r=[],s=[];for(n=0,a=e.length;n<a;n++)e[n]&&("h"===t?(s.push(e[n][0]),r.push(e[n][1])):(s.push(e[n][1]),r.push(e[n][0])),0===n&&(s.push(s[0]),r.push(r[0])));for(s.push(s[s.length-1]),r.push(r[r.length-1]),e=[],l=1,o=r.length;l<o-1;l++){var A=[r[l-1],r[l],r[l+1],r[l+2]],C=ZC._a_(s[l+1]-s[l]),c=1/(C/A.length),u=ZC.AQ.Y9(i,A,C,c);for(n=0,a=u.length;n<a;n++)null!==ZC._n_(u[n][0])&&null!==ZC._n_(u[n][1])?"h"===t?e.push([s[l]+u[n][0]*C,u[n][1]]):e.push([u[n][1],s[l]+u[n][0]*C]):e.push(null)}return e},_append_:function(e,i,t){i.H&&i.H.G1?(null===ZC._n_(i.H.G1[e.id])&&(i.H.G1[e.id]=document.createDocumentFragment()),i.H.G1[e.id].appendChild(t)):e.appendChild(t)},VX:function(e,i,t,n,a){if(""!==t||a){var l,o,r,s,A,C,c;ZC.cache.data["svg-rect"]||(ZC.cache.data["svg-rect"]=ZC.Q.F5("rect","http://www.w3.org/2000/svg")),l=a?ZC.cache.data["svg-rect"].cloneNode(!0):ZC.Q.F5("path","http://www.w3.org/2000/svg");var u={};if(i.DK&&""!==i.DK&&(u["class"]=i.DK),a||(u.d=t),a){i.I<0&&(i.iX-=i.I,i.I=-i.I),i.F<0&&(i.iY+=i.F,i.F=-i.F);var p=0,Z=0,h=1;i.CZ&&(h=0,p=Z=i.AZ/2,0===i.iX&&(p=0),0===i.iY&&(Z=0)),0===h||i.I<=3||i.F<=3?(o=Math.floor(i.iX)+p,r=Math.floor(i.iY)+Z,s=Math.ceil(i.I)-2*p,A=Math.ceil(i.F)-2*p,C=i.F6,c=i.F6):(o=parseFloat(i.iX.toFixed(h))+p,r=parseFloat(i.iY.toFixed(h))+Z,s=parseFloat(i.I.toFixed(h))-2*p,A=parseFloat(i.F.toFixed(h))-2*Z,C=i.F6,c=i.F6),u.x=o,u.y=r,u.width=ZC.BQ(0,s),u.height=ZC.BQ(0,A),u.rx=C,u.ry=c,i.H&&(i.H.E[i.K+"-bounds"]=[u.x,u.y,u.x+u.width,u.y+u.height])}var d="";"undefined"==typeof i.K||""===i.K?"undefined"!=typeof i.H&&(d=i.H.GRAPHID+"-path-"+ZC.SEQ,ZC.SEQ++):d=i.K+"-path";var f,_="";if("undefined"!=typeof i.BM&&"undefined"!=typeof i.BH&&(0===i.BM&&0===i.BH||(_+="translate("+i.BM+" "+i.BH+")")),"undefined"!=typeof i.A9&&0!==i.A9){var g=i.A9;"undefined"!=typeof i.E.cx&&(g+=","+(ZC._x_(i.E.cx)-.5)),"undefined"!=typeof i.E.cy&&(g+=","+(ZC._x_(i.E.cy)-.5)),_+=" rotate("+g+")"}if(n&&-1!==i.E.fill?(u.fill=i.E.fill,u["fill-opacity"]=i.C6):u.fill="none",u["stroke-linecap"]=i.T7,u["stroke-linejoin"]=i.ZZ,i.AZ>0&&(u.stroke=i.B7,u["stroke-width"]=i.AZ,u["stroke-opacity"]=n?i.O0:i.C6,"solid"===i.GD||0===i.EX&&0===i.G9||("dashdot"===i.GD?u["stroke-dasharray"]=[i.EX,i.G9,i.AZ,i.G9].join(" "):u["stroke-dasharray"]=i.EX+","+i.G9)),l.id=d,""!==_&&(u.transform=_),i.o["fast-line"]&&i.AZ>0?(l.setAttribute("stroke",u.stroke),l.setAttribute("stroke-width",u["stroke-width"]),l.setAttribute("stroke-opacity",u["stroke-opacity"]),l.setAttribute("d",t)):ZC.Q.G3(l,u),ZC.CR._append_(e,i,l),(!i.E.border||"all"===i.E.border)&&"undefined"!=typeof i.E.imgfill)if("string"==typeof i.E.imgfill)ZC.AK(d+"-imgfill")||(f=a?ZC.Q.F5("rect","http://www.w3.org/2000/svg"):ZC.Q.F5("path","http://www.w3.org/2000/svg"),ZC.Q.G3(f,{id:d+"-imgfill",transform:_,fill:i.E.imgfill,"fill-opacity":i.C6}),a?ZC.Q.G3(f,{x:o,y:r,width:ZC.BQ(0,s),height:ZC.BQ(0,A),rx:C,ry:c}):ZC.Q.G3(f,{d:t}),ZC.CR._append_(e,i,f));else if(!ZC.AK(d+"-imgfill")){var v=i.E.imgfill,b=ZC.Q.F5("image","http://www.w3.org/2000/svg");b.setAttributeNS?"zc."===i.DA.substring(0,3)?b.setAttributeNS("http://www.w3.org/1999/xlink","href",ZC.IMAGES[i.DA]):b.setAttributeNS("http://www.w3.org/1999/xlink","href",i.DA):"zc."===i.DA.substring(0,3)?b.setAttribute("src",ZC.IMAGES[i.DA]):b.setAttribute("src",i.DA),null!==ZC._n_(i.E["clip-path"])&&ZC.Q.G3(b,{"clip-path":"url(#"+i.E["clip-path"]+")"}),ZC.Q.G3(b,{id:d+"-imgfill",x:v[1],y:v[2],"fill-opacity":i.C6,width:i.E["bg-image-width"],height:i.E["bg-image-height"],preserveAspectRatio:"none"}),ZC.CR._append_(e,i,b)}}},VW:function(e,i,t,n){var a,l,o,r,s,A;n&&(t+=" x e");var C="";"undefined"==typeof i.K||""===i.K?"undefined"!=typeof i.H&&(C=i.H.GRAPHID+"-path-"+ZC.SEQ,ZC.SEQ++):C=i.K+"-path";var c=ZC.Q.F5("zcv:shape");c.style.position="absolute",c.style.rotation=i.A9,c.id=C;var u=ZC.Q.F5("zcv:path");if(u.v=t,u.setAttribute("VMLv",t),c.appendChild(u),0===i.AZ)c.stroked=!1;else{var p=ZC.Q.F5("zcv:stroke");if(r=i.C6,"undefined"!=typeof i.E.A8F&&(r=i.E.A8F),"undefined"!=typeof i.E.stroke)l=i.E.stroke.weight,o=i.E.stroke.color,r=i.E.stroke.opacity,s=i.E.stroke.dashstyle;else{switch(s="solid",i.GD){case"solid":s="solid";break;case"dotted":s="dot";break;case"dashed":s="dash";break;default:s=i.GD}"solid"!==s&&"0 0"!=(a=ZC.CY(6,i.EX*i.AZ)+" "+ZC.CY(8,i.G9*i.AZ))&&(s=a),l=i.AZ,o=i.B7}ZC.Q.G3(p,{weight:l+"px",color:o,opacity:r,miterlimit:10,endcap:"flat",joinstyle:"round",dashstyle:s}),c.appendChild(p)}n&&"undefined"!=typeof i.E.fill&&-1!==i.E.fill?(c.filled=!0,c.appendChild(i.E.fill)):c.filled=!1,ZC.Q.G3(c,{coordorigin:"0 0",coordsize:i.A9%360==0?"100 100":i.H.I+" "+i.H.F});var Z=0,h=0;if(i.A9%360!=0&&"undefined"!=typeof i.E.cx&&"undefined"!=typeof i.E.cy){var d=i.H.I/2-i.E.cx,f=i.H.F/2-i.E.cy,_=0===f?0:ZC.TK(Math.atan(d/f));i.E.cy>i.H.F/2&&(_+=180);var g=Math.sqrt(d*d+f*f);Z=d-g*ZC.EP(_-i.A9),h=f-g*ZC.EH(_-i.A9)}var v=0-Z;null!==ZC._n_(i.BM)&&(v+=i.BM);var b=0-h;if(null!==ZC._n_(i.BH)&&(b+=i.BH),c.style.left=v+"px",c.style.top=b+"px",e.appendChild(c),i.A9%360==0?(c.style.width="10px",c.style.height="10px"):(c.style.width=i.H.I+"px",c.style.height=i.H.F+"px"),("all"===i.E.border||"undefined"!=typeof i.E.imgfill)&&"undefined"!=typeof i.E.imgfill){var B=i.E.imgfill;1===B.length?((c=ZC.Q.F5("zcv:shape")).style.position="absolute",c.style.rotation=i.A9,(u=ZC.Q.F5("zcv:path")).v=t,c.appendChild(u),c.appendChild(B[0]),c.stroked=!1,ZC.Q.G3(c,{id:C+"-imgfill",filled:!0,coordorigin:"0 0",coordsize:i.A9%360==0?"100 100":i.H.I+" "+i.H.F}),c.style.left=v+"px",c.style.top=b+"px",e.appendChild(c),i.A9%360==0?(c.style.width="10px",c.style.height="10px"):(c.style.width=i.H.I+"px",c.style.height=i.H.F+"px")):3===B.length&&((A=ZC.Q.F5("img")).id=C+"-img","zc."===i.DA.substring(0,3)?A.src=ZC.IMAGES[i.DA]:A.src=i.DA,A.style.position="absolute",A.style.left=B[1]+"px",A.style.top=B[2]+"px",A.style.width=i.E["bg-image-width"]+"px",A.style.height=i.E["bg-image-height"]+"px",e.appendChild(A))}}};var DT={$i:function(e){this.b(e);var i=this;i.A=e,i.Z=null,i.C7=null,i.H8="",i.iX=-1,i.iY=-1,i.DU="poly",i.D=[],i.D1=[0,0,0,0],i.A9=0,i.AI=0,i.JQ=0,i.BM=0,i.BH=0,i.AA8=0,i.DV=0,i.B4=0,i.BK=360,i.CN=0,i.U0=!1,i.ADA=!1,i.A5F=0,i.AAO="",i.O7=!1,i.A9D=1,i.JR=1,i.EA=null,i.FB=null,i.IV="auto",i.K9=!1,i.A0Z="source-over",i.QW=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"objectId,x,y,points,bounds,pieAngleStart,pieAngleEnd,pieSlice,url,target,offsetX,offsetY,offsetR,size,size2,angle,shape,flat,cursor","H8,iX,iY,D,D1,B4,BK,CN,EA,FB,BM,BH,DV,AI,JQ,A9,DU,K9,IV"),e},build:function(){},copy:function(e){this.b(e);var i,t,n=this,a="BM,BH,DV,AI,JQ,A9,DU,K9,IV".split(",");for(i=0,t=a.length;i<t;i++)"undefined"!=typeof e[a[i]]&&(n[a[i]]=e[a[i]]);if(e.D&&e.D.length>0)for(n.D=[],i=0,t=e.D.length;i<t;i++)n.D.push(e.D[i])},ll_:function(e,i){var t=this;-1!==(""+e).indexOf("lat")&&(i="y"),-1!==(""+e).indexOf("lon")&&(i="x"),e=ZC._f_((""+e).replace("lat","").replace("lon",""));var n=zingchart.maps.maps[t.A5F];return n&&(e=zingchart.maps.lonlat2xy(n._INFO_.x,n._INFO_.y,n._INFO_.width,n._INFO_.height,"x"===i?[e,0]:[0,e],n._INFO_.bbox,{map:t.A5F,item:t.AAO,zoom:n._INFO_.zoom,offsetX:n._INFO_.offsetX,offsetY:n._INFO_.offsetY},!0)),e=ZC._i_("x"===i?e[0]:e[1])},kv_:function(e,i){var t;-1!==(""+e).indexOf("val")&&(i="y"),-1!==(""+e).indexOf("key")&&(i="x"),e=ZC._f_((""+e).replace("key","").replace("val",""));var n=this.H||zingchart.HZ[0];if(n){var a=this.A||n.AG[0];a&&("x"===i?null!==(t=a.BU("k")[0])&&(e=ZC._i_(t.AT(e))):null!==(t=a.BU("v")[0])&&(e=ZC._i_(t.AT(e))))}return ZC._i_(e)},xy_:function(e,i,t){var n=this;i=i||"x";var a=""+e;if(-1!==a.indexOf("lat")||-1!==a.indexOf("lon"))return n.ll_(e,i);if(-1!==a.indexOf("val")||-1!==a.indexOf("key"))return n.kv_(e,i);if(""+ZC._f_(e)!==a)return-1!==(e+="").indexOf("%")?n.xy_(parseFloat(e.replace("%",""))/100,i,!0):-1!==e.indexOf("px")?n.xy_(parseFloat(e.replace("px","")),i):n.xy_(parseFloat(e),i);var l="undefined"!=typeof n.E["p-x"]?n.E["p-x"]:n.A.iX,o="undefined"!=typeof n.E["p-y"]?n.E["p-y"]:n.A.iY,r="undefined"!=typeof n.E["p-width"]?n.E["p-width"]:n.A.I,s="undefined"!=typeof n.E["p-height"]?n.E["p-height"]:n.A.F;return(e>=1||e<0||zingchart.DEV.IGNORESUBUNIT)&&!t?"x"===i?l+parseFloat(e):o+parseFloat(e):e>=0&&e<1||t?"x"===i?(r=r||1,Math.round(l+r*e)):(s=s||1,Math.round(o+s*e)):void 0},locate:function(e){var i,t=this;if(t.U0)return-1!==(""+t.o.x).indexOf("lon")?t.iX=t.ll_(t.o.x,"x"):t.ZQ("x","iX"),-1!==(""+t.o.y).indexOf("lat")?t.iY=t.ll_(t.o.y,"y"):t.ZQ("y","iY"),void t.A3W();1===e?(null!==(i=ZC._n_(t.o.x))&&(t.iX=t.xy_(i,"x")),null!==(i=ZC._n_(t.o.y))&&(t.iY=t.xy_(i,"y")),-1===t.iX&&(t.iX=t.A.iX),-1===t.iY&&(t.iY=t.A.iY)):2===e&&(t.A3W(),t.I=t.D1[2]-t.D1[0],t.F=t.D1[3]-t.D1[1])},A3W:function(){var e,i=this,t=ZC.MAX,n=ZC.MAX,a=-ZC.MAX,l=-ZC.MAX;switch(i.DU){case"custom":t=0,n=0,a=0,l=0;break;case"circle":case"arc":case"pie":t=i.iX-i.AI,n=i.iY-i.AI,a=i.iX+i.AI,l=i.iY+i.AI;break;default:for(var o=0,r=i.D.length;o<r;o++)null!==(e=i.D[o])&&(t=Math.min(t,e[0]),n=Math.min(n,e[1]),a=Math.max(a,e[0]),l=Math.max(l,e[1]))}i.D1=[t,n,a,l]},FF:function(){var e,i=this;if("pie"===i.DU){var t=1,n=[],a=i.B4+i.A9,l=i.BK+i.A9,o=i.AI+Math.floor(i.AU/2),r=i.CN-Math.floor(i.AU/2);for(o>50&&(t=2),o>100&&(t=4),0===r?a%360!=l%360&&n.push([i.iX,i.iY]):n.push(ZC.AQ.BN(i.iX,i.iY,r,a),ZC.AQ.BN(i.iX,i.iY,(o+r)/2,a-.25*i.AU),ZC.AQ.BN(i.iX,i.iY,o,a)),e=a;e<=l;e+=t)n.push(ZC.AQ.BN(i.iX,i.iY,o,e));if(n.push(ZC.AQ.BN(i.iX,i.iY,o,l)),n.push(ZC.AQ.BN(i.iX,i.iY,(o+r)/2,l+.25*i.AU)),0===r)a%360!=l%360&&n.push([i.iX,i.iY]);else{for(n.push(ZC.AQ.BN(i.iX,i.iY,r,l)),e=l;e>=a;e-=t)n.push(ZC.AQ.BN(i.iX,i.iY,r,e));n.push(ZC.AQ.BN(i.iX,i.iY,r,a))}return n.push([n[0][0],n[0][1]]),ZC.AQ.PR(n,Math.min(5,o/5),[i.BM,i.BH])}if(0===i.A9||"rectangle"!==i.DU&&"rect"!==i.DU)return ZC.AQ.PR(i.D,Math.min(5,i.AI/5),[i.BM,i.BH]);var s,A,C,c,u,p,Z,h,d=[];for(C=ZC._i_((i.D1[0]+i.D1[2])/2),c=ZC._i_((i.D1[1]+i.D1[3])/2),s=0,A=i.D.length;s<A;s++)null!==i.D[s]&&(u=i.D[s][0]-C,p=i.D[s][1]-c,Z=u*ZC.EH(i.A9)-p*ZC.EP(i.A9),h=u*ZC.EP(i.A9)+p*ZC.EH(i.A9),d[s]=[Z+C,h+c]);return ZC.AQ.PR(d,Math.min(5,i.AI/5),[i.BM,i.BH])},A4Y:function(){var e,i,t,n,a,l,o,r,s,A=this,C=ZC.ie67?ZC.MAPTX:0;switch(A.DU){case"line":if(t=[].concat(A.D),0!==A.A9)for(n=(A.D1[0]+A.D1[2])/2,a=(A.D1[1]+A.D1[3])/2,e=0,i=t.length;e<i;e++)null!==t[e]&&(l=t[e][0]-n,o=t[e][1]-a,r=l*ZC.EH(A.A9)-o*ZC.EP(A.A9),s=l*ZC.EP(A.A9)+o*ZC.EH(A.A9),t[e]=[r+n,s+a]);var c=["poly"];for(e=0,i=t.length;e<i-1;e++)null!==t[e]&&null!==t[e+1]&&c.push(ZC.AQ.PR(ZC.AQ.Z0([t[e],t[e+1]]),4,[A.BM,A.BH]));return c;case"cross":case"plus":return["circle",ZC._i_(A.iX+C+A.BM)+","+ZC._i_(A.iY+C+A.BH)+","+ZC._i_(A.AI)];case"circle":case"arc":return["circle",ZC._i_(A.iX+C+A.BM)+","+ZC._i_(A.iY+C+A.BH)+","+ZC._i_(A.AI+2)];case"pie":return["poly",A.FF()];default:var u,p=["poly"];for(t=[],e=0,i=A.D.length;e<i;e++)if(null!==A.D[e])if(6===A.D[e].length)for(var Z=A.D[e][3];Z<A.D[e][4];Z+=1)t.push(ZC.AQ.BN(A.D[e][0],A.D[e][1],A.D[e][2],Z));else if(4===A.D[e].length&&t[e-1]){var h={x:t[t.length-1][0],y:t[t.length-1][1]},d={x:A.D[e][2],y:A.D[e][3]},f={x:A.D[e][0],y:A.D[e][1]};for(u=0;u<=1;u+=.1)t.push([(1-u)*(1-u)*h.x+2*u*(1-u)*f.x+u*u*d.x,(1-u)*(1-u)*h.y+2*u*(1-u)*f.y+u*u*d.y])}else if(7===A.D[e].length&&t[e-1]){var _={x:t[t.length-1][0],y:t[t.length-1][1]},g={x:A.D[e][0],y:A.D[e][1]},v={x:A.D[e][2],y:A.D[e][3]},b={x:A.D[e][4],y:A.D[e][5]};for(u=0;u<=1;u+=.1){var B=(1-u)*(1-u)*(1-u),m=3*u*(1-u)*(1-u),E=3*u*u*(1-u),D=u*u*u;t.push([B*_.x+m*g.x+E*v.x+D*b.x,B*_.y+m*g.y+E*v.y+D*b.y])}}else t.push(A.D[e]);else t.length>-1&&p.push(ZC.AQ.PR(t,Math.min(5,A.AI/5),[A.BM,A.BH])),t=[];if(0!==A.A9)for(n=ZC._i_((A.D1[0]+A.D1[2])/2),a=ZC._i_((A.D1[1]+A.D1[3])/2),e=0,i=t.length;e<i;e++)null!==t[e]&&(l=t[e][0]-n,o=t[e][1]-a,r=l*ZC.EH(A.A9)-o*ZC.EP(A.A9),s=l*ZC.EP(A.A9)+o*ZC.EH(A.A9),t[e]=[r+n,s+a]);return t.length>-1&&p.push(ZC.AQ.PR(t,Math.min(5,A.AI/5),[A.BM,A.BH])),p}},parse:function(e){var i,t,n,a,l,o,r;null===ZC._n_(e)&&(e=!1),this.o.tween||e||this.b();var s=this;if(!s.o.tween&&!e){s.assign_a([["map","A5F"]]),"string"==typeof s.o.item&&s.assign_a([["item","AAO"]]),0!==s.A5F&&(null===ZC._n_(s.o["map-item"])||s.o["map-item"])&&(s.o["map-item"]=!0,s.o["map-skip-z-sort"]=!0);var A=["offset-x","offset-y"];for(t=0;t<2;t++){var C=A[t],c="offset-x"===C?"lon":"lat";if(null!==(i=s.o[C])&&void 0!==i&&-1!==(i=""+i).indexOf(c)){i=ZC._f_(i.replace(c,""));var u=zingchart.maps.maps[s.A5F];u&&(i=zingchart.maps.translate(C.replace("offset-"),i,s.A.I,s.A.F,u._INFO_.bbox),s.o[C]=i)}}for(s.assign_a([["url","EA"],["target","FB"],["cursor","IV"],["id","H8"],["angle","A9","i"],["static","K9","b"],["flat","K9","b"],["angle-start","B4","f"],["angle-end","BK","f"],["slice","CN","i"],["size","AI","f"],["size-2","JQ","f"],["fast-vector-path","QW","b"],["type","DU"],["points","D"],["offset-x","BM"],["offset-y","BH"],["offset-z","AA8","i"],["offset-r","DV","i"],["z-sort","A9D","i"],["z-index","JR","f"],["composite","A0Z"]]),s.BM=ZC.II(s.BM,!0),s.BH=ZC.II(s.BH,!0),s.BM>-1&&s.BM<1&&"undefined"!=typeof s.E["p-width"]&&(s.BM*=s.E["p-width"]),s.BH>-1&&s.BH<1&&"undefined"!=typeof s.E["p-height"]&&(s.BH*=s.E["p-height"]),s.AI=ZC.BQ(1,s.AI),s.JQ=ZC.BQ(1,s.JQ),null!==s.o["z-sort"]&&"undefined"!=typeof s.o["z-sort"]||(s.A9D=s.JR),"rectangle"!==s.DU&&"rect"!==s.DU||s.assign_a([["width","AI","f"],["height","JQ","f"]]),s.A59?(s.D=JSON.parse(JSON.stringify(s.F9)),s.A59=!1):s.F9=JSON.parse(JSON.stringify(s.D)),t=0,n=s.D.length;t<n;t++)if(null!==s.D[t])for(var p=0;p<s.D[t].length;p++)-1===(""+s.D[t][p]).indexOf("lat")&&-1===(""+s.D[t][p]).indexOf("lon")||(s.A59=!0,s.D[t][p]=s.ll_(s.D[t][p],p%2==0?"x":"y")),-1===(""+s.D[t][p]).indexOf("key")&&-1===(""+s.D[t][p]).indexOf("val")||(s.A59=!0,s.D[t][p]=s.kv_(s.D[t][p],p%2==0?"x":"y"))}if(s.o.tween=null,s.A9=s.A9%360,s.locate(1),"bar"!==s.DU){var Z=s.AI,h=s.JQ;switch(s.DU){case"custom":break;case"triangle":Z=s.AI;var d=.1*s.AI;s.D=[[s.iX-Z,s.iY+Z-d],[s.iX,s.iY-Z-d],[s.iX+Z,s.iY+Z-d],[s.iX-Z,s.iY+Z-d]];break;case"square":Z=ZC._i_(.9*s.AI),s.D=[[s.iX-Z,s.iY-Z],[s.iX-Z,s.iY+Z],[s.iX+Z,s.iY+Z],[s.iX+Z,s.iY-Z],[s.iX-Z,s.iY-Z]];break;case"diamond":Z=ZC._i_(1.2*s.AI),h=ZC._i_(1.2*(1===s.JQ?s.AI:s.JQ)),s.D=[[s.iX-Z,s.iY],[s.iX,s.iY+h],[s.iX+Z,s.iY],[s.iX,s.iY-h],[s.iX-Z,s.iY]];break;case"trapezoid":s.D=[[s.iX-Z/2,s.iY+s.JQ],[s.iX+Z/2,s.iY+s.JQ],[s.iX+Z,s.iY-s.JQ],[s.iX-Z,s.iY-s.JQ],[s.iX-Z/2,s.iY+s.JQ]];break;case"rectangle":case"rect":s.D=[[s.iX-Z/2,s.iY-s.JQ/2],[s.iX+Z/2,s.iY-s.JQ/2],[s.iX+Z/2,s.iY+s.JQ/2],[s.iX-Z/2,s.iY+s.JQ/2],[s.iX-Z/2,s.iY-s.JQ/2]];break;case"parallelogram":s.D=[[s.iX-Z/2,s.iY-s.JQ/2],[s.iX+3*Z/2,s.iY-s.JQ/2],[s.iX+Z,s.iY+s.JQ/2],[s.iX-Z,s.iY+s.JQ/2],[s.iX-Z/2,s.iY-s.JQ/2]];break;case"plus":Z=s.AI,s.D=[[s.iX,s.iY-Z],[s.iX,s.iY+Z],null,[s.iX-Z,s.iY],[s.iX+Z,s.iY]];break;case"cross":Z=s.AI,s.D=[[s.iX-Z,s.iY-Z],[s.iX+Z,s.iY+Z],null,[s.iX-Z,s.iY+Z],[s.iX+Z,s.iY-Z]];break;case"ic_line":Z=s.AI/4,s.D=[[s.iX-2*Z,s.iY+Z],[s.iX-Z,s.iY],[s.iX,s.iY+Z],[s.iX+Z,s.iY-Z],[s.iX+2*Z,s.iY]];break;case"ic_area":Z=s.AI/4,s.D=[[s.iX-2*Z,s.iY+2*Z],[s.iX-2*Z,s.iY+Z],[s.iX-Z,s.iY],[s.iX,s.iY+Z],[s.iX+Z,s.iY-Z],[s.iX+2*Z,s.iY],[s.iX+2*Z,s.iY+2*Z],[s.iX-2*Z,s.iY+2*Z]];break;case"ic_bars":s.CZ=!1,Z=s.AI/4,s.D=[[s.iX-2*Z,s.iY+2*Z],[s.iX-2*Z,s.iY-Z],[s.iX-Z,s.iY-Z],[s.iX-Z,s.iY+2*Z],[s.iX-2*Z,s.iY+2*Z],[s.iX-2*Z,s.iY+2*Z-Z],null,[s.iX-Z/2,s.iY+2*Z],[s.iX-Z/2,s.iY],[s.iX+Z/2,s.iY],[s.iX+Z/2,s.iY+2*Z],[s.iX-Z/2,s.iY+2*Z],[s.iX-Z/2,s.iY+2*Z-Z],null,[s.iX+2*Z,s.iY+2*Z],[s.iX+2*Z,s.iY-2*Z],[s.iX+Z,s.iY-2*Z],[s.iX+Z,s.iY+2*Z],[s.iX+2*Z,s.iY+2*Z],[s.iX+2*Z,s.iY+2*Z-Z]];break;case"arrow":Z=2*s.AI;var f=s.A9;s.A9=0;var _=ZC.AQ.BN(s.iX,s.iY,Z,f-35),g=ZC.AQ.BN(s.iX,s.iY,Z,f+35);s.D=[[s.iX,s.iY],_,null,[s.iX,s.iY],g];break;case"star3":case"star4":case"star5":case"star6":case"star7":case"star8":case"star9":for(s.D=[],Z=2*s.AI,l=360/(a=ZC._i_(s.DU.replace("star",""))),o=a%2==0?0:-90,r=Z/(a>4?2:7-a),t=0+o;t<360+o;t+=l)s.D.push(ZC.AQ.BN(s.iX,s.iY,.75*Z,t),ZC.AQ.BN(s.iX,s.iY,.75*r,t+l/2));s.D.push([s.D[0][0],s.D[0][1]]);break;case"rpoly3":case"rpoly4":case"rpoly5":case"rpoly6":case"rpoly7":case"rpoly8":case"rpoly9":for(s.D=[],Z=s.AI,l=360/(a=ZC._i_(s.DU.replace("rpoly",""))),o=a%2==0?0:-90,null!==ZC._n_(s.o["angle-offset"])&&(o=ZC._i_(s.o["angle-offset"])),t=0+o;t<360+o;t+=l)s.D.push(ZC.AQ.BN(s.iX,s.iY,Z,t));s.D.push([s.D[0][0],s.D[0][1]]);break;case"gear3":case"gear4":case"gear5":case"gear6":case"gear7":case"gear8":case"gear9":for(s.D=[],Z=2*s.AI,l=360/(2*(a=ZC._i_(s.DU.replace("gear","")))),r=.75*Z,t=0+(o=a%2==0?0:-90);t<360+o;t+=2*l){var v=t+l/2;s.D.push(ZC.AQ.BN(s.iX,s.iY,.75*Z,v),ZC.AQ.BN(s.iX,s.iY,.75*Z,v+l),ZC.AQ.BN(s.iX,s.iY,.75*r,v+l+0*l),ZC.AQ.BN(s.iX,s.iY,.75*r,v+2*l-0*l))}s.D.push([s.D[0][0],s.D[0][1]]);break;case"hamburger":Z*=2;var b=s.iX,B=s.iY-10;s.D=s.D.concat([[b-Z/2,B-s.JQ/2],[b+Z/2,B-s.JQ/2],[b+Z/2,B+s.JQ/2],[b-Z/2,B+s.JQ/2],[b-Z/2,B-s.JQ/2],null]),B+=5,s.D=s.D.concat([[b-Z/2,B-s.JQ/2],[b+Z/2,B-s.JQ/2],[b+Z/2,B+s.JQ/2],[b-Z/2,B+s.JQ/2],[b-Z/2,B-s.JQ/2],null]),B+=5,s.D=s.D.concat([[b-Z/2,B-s.JQ/2],[b+Z/2,B-s.JQ/2],[b+Z/2,B+s.JQ/2],[b-Z/2,B+s.JQ/2],[b-Z/2,B-s.JQ/2],null]);break;case"ellipse":for(s.CZ=!1,s.D=[],t=0;t<=360;t+=5)s.D.push([s.iX+s.AI*ZC.EH(t),s.iY+s.JQ*ZC.EP(t)]);s.D.push([s.D[0][0],s.D[0][1]]);break;case"arc":s.CZ=!1,s.D=[ZC.AQ.BN(s.iX,s.iY,s.AI,s.B4),[s.iX,s.iY,s.AI,s.B4,s.BK,0]];break;case"pie":for(var m=(s.o["pie-transform"]||"").split(/=|,/);s.B4<0||s.BK<0;)s.B4+=360,s.BK+=360;s.CZ=!1;var E=!1;-1!==ZC.AV(["svg","vml"],s.H.AA)&&s.B4%360==s.BK%360&&(s.B4+=.05,s.BK-=.05,E=!0);var D,K,F,x,I,y=s.iX,w=s.iY,Y=ZC._x_(s.B4,2),X=ZC._x_(s.BK,2),M=ZC._x_((Y+X)/2,2),L=Z,H=s.CN,P=0===H&&Y%360!=X%360&&!E;switch(s.D=[],"circle"!==m[0]&&(0===H?Y%360==X%360||E||s.D.push([y,w]):s.D.push(ZC.AQ.BN(y,w,H,Y))),m[0]){case"flat":case"fold":s.D.push(ZC.AQ.BN(y,w,L,Y),ZC.AQ.BN(y,w,L-("fold"===m[0]?ZC._i_(m[1]):0),X)),P||s.D.push(ZC.AQ.BN(y,w,H,X));break;case"callout":s.D.push(ZC.AQ.BN(y,w,L,Y),[y,w,L,Y,X,0]),P||(D=1.5*ZC._i_(m[1])*360/(2*Math.PI*L),s.D.push(ZC.AQ.BN(y,w,L,X),ZC.AQ.BN(y,w,H,X),[y,w,H,X,M+D,1],ZC.AQ.BN(y,w,H-ZC._i_(m[1]),M),ZC.AQ.BN(y,w,H,M-D),[y,w,H,M-D,Y,1]));break;case"flow":D=ZC._i_(m[1]),x=ZC.AQ.BN(y,w,(H+L)/2,Y),99===D||-99===D?s.D.push([x[0],x[1],(L-H)/2,Y+180,Y,99===D?1:0]):s.D.push(ZC.AQ.BN(y,w,(H+L)/2,Y+D)),s.D.push(ZC.AQ.BN(y,w,L,Y),[y,w,L,Y,X,0]),I=ZC.AQ.BN(y,w,(H+L)/2,X),P?99===D||-99===D?s.D.push(ZC.AQ.BN(y,w,L,X),[I[0],I[1],(L-H)/2,X,X+180,99===D?0:1]):s.D.push(ZC.AQ.BN(y,w,(H+L)/2,X+D)):(99===D||-99===D?s.D.push([I[0],I[1],(L-H)/2,X,X+180,99===D?0:1]):s.D.push(ZC.AQ.BN(y,w,(H+L)/2,X+D)),s.D.push(ZC.AQ.BN(y,w,H,X),[y,w,H,X,Y,1]));break;case"circle":var N=ZC._f_(m[1]||"1"),G=(5+ZC._a_(X-Y)%360*50/360)*N;F=X%360==Y%360||E?[y,w]:ZC.AQ.BN(y,w,(L+H)/2,(Y+X)/2),s.D.push(ZC.AQ.BN(F[0],F[1],G,0),[F[0],F[1],G,0,360,0]);break;case"bite":D=ZC._i_(m[1]),K=ZC._i_(2*L*ZC.EP(D/2)),F=ZC.AQ.BN(y,w,L,Y),s.D.push(ZC.AQ.BN(y,w,L-K,Y),[F[0],F[1],K,Y+180,Y+90+(90-(180-D)/2),1],[y,w,L,Y+D,X,0]),P||s.D.push(ZC.AQ.BN(y,w,H,X),[y,w,H,X,Y,1]);break;case"droplet":for(var S=L,O=1,k=0;L*O+k>=S;)O=ZC._x_(O-.02,2),K=ZC._i_(L*O/ZC.EH((X-Y)/2)),k=ZC._i_(L*O*Math.tan(ZC.T1((X-Y)/2)));F=ZC.AQ.BN(y,w,K,M),s.D.push(ZC.AQ.BN(y,w,L*O,Y),[F[0],F[1],k,M-(360-(180-(X-Y)))/2,M+(360-(180-(X-Y)))/2,0]),P||s.D.push(ZC.AQ.BN(y,w,H,X),[y,w,H,X,Y,1]);break;default:s.D.push(ZC.AQ.BN(y,w,L,Y),[y,w,L,Y,X,0]),0===H?Y%360==X%360||E||s.D.push([y,w]):s.D.push(ZC.AQ.BN(y,w,L,X),ZC.AQ.BN(y,w,H,X),[y,w,H,X,Y,1])}s.D.push([s.D[0][0],s.D[0][1]])}}s.locate(2)},paint:function(){var e=this;if("none"!==e.DU&&("custom"===e.DU||"circle"===e.DU||"arc"===e.DU||0!==e.D.length)){var i,t,n={x:"iX",y:"iY",width:"I",height:"F",size:"AI"};if(e.o["bottom-state"]&&!e.Y6&&!e.VN&&!e.bIsBottom){var a=new ZC.DT(e.A);for(i in a.copy(e),a.bIsBottom=!0,a.M8=!1,a.Z=e.Z,a.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY}),a.append(e.o["bottom-state"]),a.K=e.K+"-bottom",a.parse(),t=!1,n)null===ZC._n_(a.o[i])||-1===(""+a.o[i]).indexOf("+")&&-1===(""+a.o[i]).indexOf("-")||(a.o[i]=a[n[i]]=e[n[i]]+ZC._i_(a.o[i]),t=!0);t&&a.parse(),a.paint()}var l=e.H.AA;switch(e.M8&&e.C7&&e.A97(),l){case"canvas":e.A1V();break;case"svg":e.VX();break;case"vml":e.VW()}if(e.o["top-state"]&&!e.Y6&&!e.VN&&!e.bIsBottom){var o=new ZC.DT(e.A);for(i in o.copy(e),o.VN=!0,o.M8=!1,o.Z=e.Z,o.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY}),o.append(e.o["top-state"]),o.K=e.K+"-top",o.parse(),t=!1,n)null===ZC._n_(o.o[i])||-1===(""+o.o[i]).indexOf("+")&&-1===(""+o.o[i]).indexOf("-")||(o.o[i]=o[n[i]]=e[n[i]]+ZC._i_(o.o[i]),t=!0);t&&o.parse(),o.paint()}}},A97:function(){var e,i=this,t=new ZC.DT(i.A);t.K=i.K+"-sh",t.copy(i),t.O7=i.O7,t.Z=i.C7,t.M8=!1,t.Y6=!0,t.A0=t.AE=t.RT,t.GR=t.HN="",t.DA="",t.GD="solid",t.BW=t.RT,t.AZ=0,t.C6=t.T5*i.C6,t.K=i.K+"-sh";var n=(i.JW-i.PD)*ZC.EH(i.OH)+i.PD,a=(i.JW-i.PD)*ZC.EP(i.OH)+i.PD;if(t.iX=i.iX+parseInt(n,10),t.iY=i.iY+parseInt(a,10),t.AI=i.AI+i.PD,i.D.length>0){e=[];for(var l=0,o=i.D.length;l<o;l++)if(null!==i.D[l]){for(var r=[],s=0;s<i.D[l].length;s++)r[s]=i.D[l][s];r[0]=i.D[l][0]+parseInt(n,10),r[1]=i.D[l][1]+parseInt(a,10),e.push(r)}else e.push(null)}t.D1=[i.D1[0]+n,i.D1[1]+a,i.D1[2]+n,i.D1[3]+a],t.D=e,t.paint()},A1I:function(){var e=this;return{lc:"-1"===e.B7?"rgba(255,255,255,0)":1===e.C6?e.B7:ZC.AP.A32(ZC.AP.GC(e.B7),e.C6),bc:"-1"===e.BW?"rgba(255,255,255,0)":1===e.O0?e.BW:ZC.AP.A32(ZC.AP.GC(e.BW),e.O0),bgc1:"-1"===e.A0?"rgba(255,255,255,0)":1===e.C6?e.A0:ZC.AP.A32(ZC.AP.GC(e.A0),e.C6),bgc2:"-1"===e.AE?"rgba(255,255,255,0)":1===e.C6?e.AE:ZC.AP.A32(ZC.AP.GC(e.AE),e.C6)}},YD:function(e){var i,t,n,a=this;switch(a.DU){case"circle":case"arc":case"pie":i=a.iX,t=a.iY,n=a.AI;break;default:i=a.D1[0]+(a.D1[2]-a.D1[0])/2,t=a.D1[1]+(a.D1[3]-a.D1[1])/2,n=ZC._a_(ZC.EH(a.N7)*(a.D1[2]-a.D1[0])/2+ZC.EP(a.N7)*(a.D1[3]-a.D1[1])/2)}ZC.P5(i)||(i=0),ZC.P5(t)||(t=0),ZC.P5(n)||(n=0);var l=a.VO,o=a.W5;if(ZC._a_(l)<=1&&(l=l*(a.D1[2]-a.D1[0])/2),ZC._a_(o)<=1&&(o=o*(a.D1[3]-a.D1[1])/2),i+=l,t+=o,"radial"===e)return{cx:i,cy:t,r:ZC._a_(n)};if("linear"===e){var r=n*ZC.EH(a.N7),s=n*ZC.EP(a.N7),A=i-r,C=t-s,c=i+r,u=t+s;return ZC._i_(C)===ZC._i_(u)&&ZC._a_(c-A)<5&&(u+=1),ZC._i_(A)===ZC._i_(c)&&ZC._a_(u-C)<5&&(c+=1),{x1:A,y1:C,x2:c,y2:u}}},RB:function(){var e,i,t,n,a,l,o,r=this;switch(ZC.cache.data[r.DA]?e=ZC.cache.data[r.DA]:((e=new Image).src=r.DA,ZC.cache.data[r.DA]=e),1!==r.KO&&(e._width_?(e.width=e._width_,e.height=e._height_):(e._width_=e.width,e._height_=e.height)),i=e.width*r.KO,t=e.height*r.KO,r.WN){case"x":i=r.I;break;case"y":t=r.F;break;case"xy":case"both":i=r.I,t=r.F}var s=r.TA.split(" "),A=s[0]||"",C=0,c=0;switch(A){case"":case"left":n=0,C=0;break;case"center":n=(r.I-i)/2,C=.5;break;case"right":n=r.I-i,C=1;break;default:-1!==A.indexOf("%")?(C=ZC._i_(A.replace(/[^0-9\-]/g,""))/100,n=(r.I-i)*C):(C=ZC._i_(A.replace(/[^0-9\-]/g,""))/r.I,n=ZC._i_(A.replace(/[^0-9\-]/g,"")))}l=n/r.I,"undefined"!=typeof r.KP?n+=r.iX+r.BM:n+=r.D1[0]+r.BM;var u=s[1]||"";switch(u){case"":case"top":a=0,c=0;break;case"middle":a=(r.F-t)/2,c=.5;break;case"bottom":a=r.F-t,c=1;break;default:-1!==u.indexOf("%")?(c=ZC._i_(u.replace(/[^0-9\-]/g,""))/100,a=(r.F-t)*c):(c=ZC._i_(u.replace(/[^0-9\-]/g,""))/r.F,a=ZC._i_(u.replace(/[^0-9\-]/g,"")))}if(o=a/r.F,"undefined"!=typeof r.KP?a+=r.iY+r.BH:a+=r.D1[1]+r.BH,"pie"===r.DU){var p=r.A9+r.B4+(r.BK-r.B4)*C,Z=ZC.AQ.BN(r.iX,r.iY,r.CN+(r.AI-r.CN)*c,p);n=Z[0]-e.width/2,a=Z[1]-e.height/2}return r.E["bg-image-width"]=i,r.E["bg-image-height"]=t,{image:e,x:ZC._i_(n)+.5,y:ZC._i_(a)+.5,cx:ZC._f_(l),cy:ZC._f_(o),hPos:C,vPos:c}},ZH:function(e){for(var i=this,t=i.GR.split(/\s+|;/),n=i.HN.split(/\s+|;/),a=0,l=t.length;a<l;a++){var o=ZC.AP.GC(t[a],i);"object"!=typeof o&&(o=[o,i.C6]);var r=ZC.AP.A32(o[0],o[1]),s=ZC._f_(n[a]||"1");ZC.DS(s,0,1)||(s=1),e.addColorStop(s,r)}},A1V:function(){var e,i,t,n,a,l,o,r,s=this,A=s.Z.getContext("2d");A.save(),"poly"===s.DU||"line"===s.DU?(i=s.D1[0]+(s.D1[2]-s.D1[0])/2,t=s.D1[1]+(s.D1[3]-s.D1[1])/2):(i=s.iX,t=s.iY);var C=s.A1I(),c=C.lc,u=C.bc,p=C.bgc1,Z=C.bgc2;if(p!==Z||""!==s.GR&&""!==s.HN){var h=s.YD(s.NH);"radial"===s.NH?n=A.createRadialGradient(h.cx,h.cy,1,h.cx,h.cy,h.r):"linear"===s.NH&&(n=A.createLinearGradient(h.x1,h.y1,h.x2,h.y2)),""!==s.GR&&""!==s.HN?s.ZH(n):(n.addColorStop(0,p),n.addColorStop(1,Z)),A.fillStyle=n}else""!==s.DA&&-1!==ZC.AV(["repeat","true",!0],s.M4)&&"-1"===s.A0&&"-1"===s.AE&&(p="rgba(255,255,255,0)"),A.fillStyle=p;switch(s.DU){case"custom":if((e=s.o.url)&&(ZC.cache.data[e]?a=ZC.cache.data[e]:((a=new Image).src=e,ZC.cache.data[e]=a),a.width=s.o.width?s.o.width:a.width,a.height=s.o.height?s.o.height:a.height,A.drawImage(a,s.iX-a.width/2+s.BM,s.iY-a.height/2+s.BH,a.width,a.height),0===p.indexOf("#")&&7===p.length)){for(var d=parseInt(p.substring(1,3),16),f=parseInt(p.substring(3,5),16),_=parseInt(p.substring(5,7),16),g=A.getImageData(s.iX-a.width/2+s.BM,s.iY-a.height/2+s.BH,a.width,a.height),v=0;v<g.data.length;v+=4)g.data[v]=d|g.data[v],g.data[v+1]=f|g.data[v+1],g.data[v+2]=_|g.data[v+2];A.putImageData(g,s.iX-a.width/2+s.BM,s.iY-a.height/2+s.BH)}break;case"plus":case"cross":case"line":case"ic_line":case"arc":A.strokeStyle=c,A.lineWidth=s.AZ;break;default:A.strokeStyle=u,A.lineWidth=s.AU}0!==s.A9&&(A.translate(i,t),isNaN(s.A9)||A.rotate(ZC.T1(s.A9)),A.translate(-i,-t));var b=-1===ZC.AV(["cross","plus","arc","line","ic_line"],s.DU);switch(isNaN(s.BM)||isNaN(s.BH)||0===s.BM&&0===s.BH||!b&&"arc"!==s.DU||A.translate(s.BM,s.BH),A.beginPath(),s.DU){case"circle":case"arc":A.setLineDash&&"circle"===s.DU&&(s.KX(s.AU),A.setLineDash(0===s.EX||0===s.G9?[]:[s.EX,s.G9])),A.arc(s.iX,s.iY,s.AI,ZC.T1(s.B4),ZC.T1(s.BK),!1);break;case"line":break;default:-1!==ZC.AV(["square","plus"],s.DU)&&(s.N4=!0),ZC.CR.contour(A,s,s.D),-1!==ZC.AV(["square","plus"],s.DU)&&(s.N4=!1)}if(A.globalCompositeOperation=s.A0Z,b)if(""!==s.DA&&-1===ZC.AV(ZC.IMG404,s.DA)){var B;A.fill(),A.save(),A.clip(),B=A.globalAlpha,A.globalAlpha=s.C6;var m=s.RB();switch(a=m.image,s.M4){case"repeat":case!0:case"true":l=s.D1[0]-(a.width-(s.D1[2]-s.D1[0]))/2,o=s.D1[1]-(a.height-(s.D1[3]-s.D1[1]))/2,A.translate(l,o),r=A.createPattern(a,"repeat"),A.fillStyle=r,A.fill(),A.translate(-l,-o);break;case"no-repeat":case!1:case"false":A.drawImage(a,m.x-s.BM,m.y-s.BH,s.E["bg-image-width"],s.E["bg-image-height"])}A.globalAlpha=B,A.restore()}else A.fill();switch(A.closePath(),A.beginPath(),s.DU){case"circle":case"arc":A.arc(s.iX,s.iY,s.AI,ZC.T1(s.B4),ZC.T1(s.BK),!1),("circle"===s.DU&&s.AU>0||"arc"===s.DU&&s.AZ>0)&&A.stroke(),A.closePath();break;case"plus":case"cross":case"line":case"ic_line":s.AZ>0&&(ZC.CR.setup(A,s),s.o.spline?(s.CZ=!1,s.QW=!0,ZC.CR.paint(A,s,ZC.CR.smooth(s.D,!1,s.o.direction||"h"))):ZC.CR.paint(A,s,s.D));break;default:if(s.AU>0){var E=s.B7,D=s.AZ;s.B7=s.BW,s.AZ=s.AU,s.KX(),ZC.CR.setup(A,s),ZC.CR.paint(A,s,s.D,!0),s.B7=E,s.AZ=D,s.KX()}A.closePath()}A.restore()},A2O:function(e){var i=this,t=e.info,n=t.image,a=!0;switch(i.M4){default:a=!0;break;case"no-repeat":case"false":case!1:a=!1}var l=i.DA;0===n.src.indexOf("data:")&&(l=n.src),n.width*=i.KO,n.height*=i.KO;var o=""===i.K?"pattern-"+ZC.SEQ++:i.K+"-pattern";ZC.Q.EU(o);var r=ZC.Q.F5("image","http://www.w3.org/2000/svg");r.setAttributeNS?r.setAttributeNS("http://www.w3.org/1999/xlink","href",l):r.setAttribute("src",l),ZC.Q.G3(r,{id:o+"-image",preserveAspectRatio:"none",width:i.E["bg-image-width"],height:i.E["bg-image-height"]});var s=n.width,A=n.height;if(!a){var C,c;s=A=1,i.I>0&&i.F>0?(C=i.I,c=i.F):(C=i.D1[2]-i.D1[0],c=i.D1[3]-i.D1[1]);var u=ZC._i_(C*t.cx),p=ZC._i_(c*t.cy);if("pie"===i.DU){s=i.H?i.H.I:i.A.I,A=i.H?i.H.F:i.A.F;var Z=i.A9+i.B4+(i.BK-i.B4)*t.hPos,h=ZC.AQ.BN(i.iX,i.iY,i.CN+(i.AI-i.CN)*t.vPos,Z);u=h[0]-n.width/2,p=h[1]-n.height/2}i.E["pattern-image-id"]=o+"-image",i.E["pattern-tx"]=u,i.E["pattern-ty"]=p,ZC.Q.G3(r,{transform:"translate("+u+","+p+")"})}var d=ZC.Q.F5("pattern","http://www.w3.org/2000/svg");ZC.Q.G3(d,{x:a?e.x:0,y:a?e.y:0,width:s,height:A,id:o,patternUnits:a||"pie"===i.DU?"userSpaceOnUse":"objectBoundingBox"}),i.H.KE.childNodes[0].appendChild(d),d.appendChild(r),i.E.imgfill="url(#"+o+")"},WZ:function(e){null!==e&&void 0!==e||(e=!1);var i,t,n=this;if(n.A0!==n.AE||""!==n.GR&&""!==n.HN){var a=""===n.K?"gradient-"+ZC.SEQ++:n.K+"-gradient";(n.U0||e&&!ZC.AK(a))&&(e=!1),ZC.A5.browser.msie&&9===ZC._i_(ZC.A5.browser.version)&&(e=!1),ZC.AK(a)&&!e&&ZC.Q.EU(a);var l=n.YD(n.NH);if("radial"===n.NH?(i=e?ZC.AK(a):ZC.Q.F5("radialGradient","http://www.w3.org/2000/svg"),ZC.Q.G3(i,{cx:ZC._i_(l.cx),cy:ZC._i_(l.cy),r:ZC._i_(l.r),fx:ZC._i_(l.cx),fy:ZC._i_(l.cy)})):"linear"===n.NH&&(i=e?ZC.AK(a):ZC.Q.F5("linearGradient","http://www.w3.org/2000/svg"),ZC.Q.G3(i,{x1:ZC._i_(l.x1),x2:ZC._i_(l.x2),y1:ZC._i_(l.y1),y2:ZC._i_(l.y2)})),!e){if(ZC.Q.G3(i,{id:a,gradientUnits:"userSpaceOnUse"}),n.H.KE.childNodes[0].appendChild(i),""!==n.GR&&""!==n.HN)for(var o=n.GR.split(/\s+|;/),r=n.HN.split(/\s+|;/),s=0,A=o.length;s<A;s++){var C=ZC.AP.GC(o[s],n);"object"!=typeof C&&(C=[C,n.C6]),o[s]=C[0];var c=r[s]||1;ZC.DS(c,0,1)||(c=1);var u=C[1];t=o[s],"-1"===o[s]&&(u=0,t="rgb(255,255,255)");var p=ZC.Q.F5("stop","http://www.w3.org/2000/svg");ZC.Q.G3(p,{offset:c,"stop-color":t,"stop-opacity":u}),i.appendChild(p)}else{var Z=1,h=n.A0;"-1"===n.A0&&(Z=0,h="rgb(255,255,255)");var d=ZC.Q.F5("stop","http://www.w3.org/2000/svg");ZC.Q.G3(d,{offset:0,"stop-color":h,"stop-opacity":Z});var f=1,_=n.AE;"-1"===n.AE&&(f=0,_="rgb(255,255,255)");var g=ZC.Q.F5("stop","http://www.w3.org/2000/svg");ZC.Q.G3(g,{offset:1,"stop-color":_,"stop-opacity":f}),i.appendChild(d),i.appendChild(g)}n.E.fill="url(#"+a+")"}}else"-1"!==n.A0&&(n.E.fill=n.A0)},A3G:function(){var e=this;if("object"==typeof e.E.imgfill&&"undefined"!=typeof e.H&&e.H){var i=e.A4Y()[1].split(",");if("circle"===e.DU)e.H.KE.appendChild(ZC.Q.X8({id:e.K+"_image-clip",cx:i[0],cy:i[1],r:i[2]})),e.E["clip-path"]=e.K+"_image-clip";else if(i.length>6){for(var t="",n=0,a=i.length;n<a;n+=2)t+=ZC._i_(i[n])+ZC._i_(e.BM)+","+(ZC._i_(i[n+1])+ZC._i_(e.BH))+" ";e.H.KE.appendChild(ZC.Q.X8({id:e.K+"_image-clip",path:t})),e.E["clip-path"]=e.K+"_image-clip"}}},VX:function(){var e,i,t,n,a,l,o=this,r=o.Z;if("poly"===o.DU||"line"===o.DU?(i=o.D1[0]+(o.D1[2]-o.D1[0])/2,t=o.D1[1]+(o.D1[3]-o.D1[1])/2):(i=o.iX,t=o.iY),o.E.cx=i,o.E.cy=t,o.E.fill=-1,""!==o.DA){var s=o.RB();o.A2O({info:s,x:i-s.image.width/2,y:t-s.image.height/2})}switch(o.VM&&o.A3G(),o.WZ(),o.DU){case"custom":if(e=o.o.url){var A,C;ZC.cache.data[e]?n=ZC.cache.data[e]:((n=new Image).src=e,ZC.cache.data[e]=n),(A=e.indexOf(".svg")>0&&e.indexOf("#")>=0)?(C=ZC.Q.F5("svg","http://www.w3.org/2000/svg"),ZC.Q.G3(C,{viewBox:"0 0 8 8",fill:o.E.fill}),l=ZC.Q.F5("use","http://www.w3.org/2000/svg")):l=ZC.Q.F5("image","http://www.w3.org/2000/svg"),l.setAttributeNS?l.setAttributeNS("http://www.w3.org/1999/xlink","href",e):l.setAttribute("src",e);var c=o.o.width?o.o.width:n.width,u=o.o.height?o.o.height:n.height;n.width=c,n.height=u,A?ZC.Q.G3(C,{id:o.K+"-image",x:o.iX-n.width/2+o.BM,y:o.iY-n.height/2+o.BH,width:n.width,height:n.height}):ZC.Q.G3(l,{id:o.K+"-image",x:o.iX-n.width/2+o.BM,y:o.iY-n.height/2+o.BH,width:n.width,height:n.height}),A?(C.appendChild(l),r.appendChild(C)):r.appendChild(l)}break;case"circle":if(!ZC.AK(o.K+"-circle")&&(a=ZC.Q.F5("circle","http://www.w3.org/2000/svg"),-1!==o.E.fill?ZC.Q.G3(a,{fill:o.E.fill,"fill-opacity":o.C6}):ZC.Q.G3(a,{fill:"none"}),o.DK&&""!==o.DK&&ZC.Q.G3(a,{"class":o.DK}),ZC.Q.G3(a,{id:o.K+"-circle",cx:o.iX+o.BM,cy:o.iY+o.BH,r:o.AI}),o.AU>0&&(ZC.Q.G3(a,{stroke:o.BW,"stroke-width":o.AU,"stroke-opacity":o.O0}),o.KX(o.AU),"solid"===o.GD||0===o.EX&&0===o.G9||ZC.Q.G3(a,{"stroke-dasharray":"dashdot"===o.GD?[o.EX,o.G9,o.AZ,o.G9].join(" "):[o.EX,o.G9].join(",")})),o.H&&o.H.G1?(o.H.G1[r.id]||(o.H.G1[r.id]=document.createDocumentFragment()),o.H.G1[r.id].appendChild(a)):r.appendChild(a),"undefined"!=typeof o.E.imgfill))if("string"==typeof o.E.imgfill)a=ZC.Q.F5("circle","http://www.w3.org/2000/svg"),ZC.Q.G3(a,{id:o.K+"-imgfill",fill:o.E.imgfill,"fill-opacity":o.C6,cx:o.iX+o.BM,cy:o.iY+o.BH,r:o.AI,"stroke-width":0}),o.H&&o.H.G1?o.H.G1[r.id].appendChild(a):r.appendChild(a);else{var p=o.E.imgfill;(l=ZC.Q.F5("image","http://www.w3.org/2000/svg")).setAttributeNS&&l.setAttributeNS("http://www.w3.org/1999/xlink","href",o.DA),o.E["clip-path"]&&ZC.Q.G3(l,{"clip-path":"url(#"+o.E["clip-path"]+(ZC.A5.browser.webkit?"-shape":"")+")"}),ZC.Q.G3(l,{id:o.K+"-imgfill",x:p[1],y:p[2],width:p[0].width,height:p[0].height}),r.appendChild(l)}break;case"plus":case"cross":case"line":case"ic_line":case"arc":o.AZ>0&&(ZC.CR.setup(r,o),o.o.spline?(o.CZ=!1,o.QW=!0,ZC.CR.paint(r,o,ZC.CR.smooth(o.D,!1,o.o.direction||"h"))):ZC.CR.paint(r,o,o.D));break;default:var Z=o.B7,h=o.AZ;o.B7=o.BW,o.AZ=o.AU,o.KX(),ZC.CR.setup(r,o),ZC.CR.paint(r,o,o.D,!0,0),o.B7=Z,o.AZ=h,o.KX()}},WY:function(e,i){null!==i&&void 0!==i||(i=!1);var t,n=this;if(n.A0!==n.AE||""!==n.GR&&""!==n.HN){var a=""===n.K?"gradient-"+ZC.SEQ++:n.K+"-gradient";if(i&&!ZC.AK(a)&&(i=!1),ZC.AK(a)&&!i&&ZC.A5(a).remove(),t=i?ZC.AK(a):ZC.Q.F5("zcv:fill"),i&&(e=ZC.A5("#"+a).attr("focusposition")),""!==n.GR&&""!==n.HN){for(var l=n.GR.split(/\s+|;/),o=n.HN.split(/\s+|;/),r="",s="",A="",C=0,c=l.length;C<c;C++){l[C]=ZC.AP.GC(l[C]);var u="-1"===l[C]?"rgb(255,255,255)":l[C],p=o[C]||1;ZC.DS(p,0,1)||(p=1);var Z=ZC._i_(100*p);0===C?r=u:C===c-1?s=u:A+=Z+"% "+ZC.AP.GC(u)+","}""!==A&&(A=A.substring(0,A.length-1)),"radial"===n.NH?ZC.Q.G3(t,{id:a,type:"gradientradial",focusposition:e,color:r,color2:s,colors:A}):"linear"===n.NH&&ZC.Q.G3(t,{id:a,type:"gradient",method:"sigma",angle:270-n.N7-n.A9,color:r,color2:s,colors:A})}else{var h=n.A0;"-1"===n.A0&&(h="rgb(255,255,255)");var d=n.AE;"-1"===n.AE&&(d="rgb(255,255,255)"),"radial"===n.NH?ZC.Q.G3(t,{id:a,type:"gradientradial",focusposition:e,color:d,color2:h}):"linear"===n.NH&&ZC.Q.G3(t,{id:a,type:"gradient",method:"sigma",angle:270-n.N7-n.A9,color:h,color2:d})}var f="undefined"!=typeof n.E.opacity2?n.E.opacity2:n.C6;ZC.Q.G3(t,{opacity:n.C6,"o:opacity2":f}),n.E.fill=t}else t=ZC.Q.F5("zcv:fill"),"-1"!==n.A0&&(ZC.Q.G3(t,{type:"solid",color:n.A0,opacity:n.C6}),n.E.fill=t)},VW:function(){var e,i,t,n,a,l,o=this,r=o.Z;"poly"===o.DU||"line"===o.DU?(i=o.D1[0]+(o.D1[2]-o.D1[0])/2,t=o.D1[1]+(o.D1[3]-o.D1[1])/2):(i=o.iX,t=o.iY),o.E.cx=i,o.E.cy=t,o.E.fill=-1;var s=-1===ZC.AV(["cross","plus","arc","line","ic_line"],o.DU),A=ZC.Q.F5("zcv:fill");if(""!==o.DA){var C=o.RB();switch(n=C.image,o.M4){default:A.type="tile",A.src=o.DA,ZC.Q.G3(A,{position:C.cx+","+C.cy,opacity:o.C6,"o:opacity2":o.C6}),o.E.imgfill=[A];break;case"no-repeat":case"false":case!1:o.E.imgfill=[n,C.x,C.y]}}o.WY("0,0");var c=ZC.Q.F5("zcv:stroke");switch(o.DU){case"custom":(e=o.o.url)&&(ZC.cache.data[e]?n=ZC.cache.data[e]:((n=new Image).src=e,ZC.cache.data[e]=n),(l=ZC.Q.F5("img")).id=o.K+"-img",l.src=e,l.style.position="absolute",1!==o.KO&&(l.width*=o.KO,l.height*=o.KO,l.style.width=l.width+"px",l.style.height=l.height+"px"),l.style.left=o.iX-n.width/2+o.BM+"px",l.style.top=o.iY-n.height/2+o.BH+"px",r.appendChild(l));break;case"plus":case"cross":case"line":case"ic_line":case"arc":c.weight=o.AZ+"px",c.color=o.B7;break;default:c.weight=o.AU+"px",c.color=o.BW}switch(c.opacity=o.O0,o.GD){case"solid":c.dashstyle="solid";break;case"dotted":c.dashstyle="dot";break;case"dashed":c.dashstyle="dash"}switch(-1===ZC.AV(["plus","cross","line","ic_line"],o.DU)&&(o.E.stroke=c),o.DU){case"circle":case"arc":if(!ZC.AK(o.K+"-circle")&&((a=ZC.Q.F5("circle"===o.DU?"zcv:oval":"zcv:arc")).id=o.K+"-circle",a.style.position="absolute",-1!==o.E.fill&&s?a.appendChild(o.E.fill):a.filled=!1,o.AU>0||o.AZ>0?a.appendChild(c):a.stroked=!1,a.style.left=o.iX+o.BM-o.AI+"px",a.style.top=o.iY+o.BH-o.AI+"px",a.style.width=2*o.AI+"px",a.style.height=2*o.AI+"px","arc"===o.DU&&ZC.Q.G3(a,{startangle:o.BK+90,endangle:o.B4+90}),r.appendChild(a),s&&"undefined"!=typeof o.E.imgfill)){var u=o.E.imgfill;1===u.length?((a=ZC.Q.F5("zcv:oval")).id=o.K+"-imgfill",a.style.position="absolute",r.appendChild(a),a.appendChild(u[0]),a.style.left=o.iX+o.BM-o.AI+"px",a.style.top=o.iY+o.BH-o.AI+"px",a.style.width=2*o.AI+"px",a.style.height=2*o.AI+"px",a.stroked=!1,"arc"===o.DU&&ZC.Q.G3(a,{startangle:o.BK+90,endangle:o.B4+90})):3===u.length&&((l=ZC.Q.F5("img")).id=o.K+"-img",l.src=o.DA,l.style.position="absolute",l.style.left=u[1]+"px",l.style.top=u[2]+"px",1!==o.KO&&(l.width*=o.KO,l.height*=o.KO,l.style.width=l.width+"px",l.style.height=l.height+"px"),r.appendChild(l))}break;case"plus":case"cross":case"line":case"ic_line":o.AZ>0&&(ZC.CR.setup(r,o),o.o.spline?(o.CZ=!1,o.QW=!0,ZC.CR.paint(r,o,ZC.CR.smooth(o.D,!1,o.o.direction||"h"))):ZC.CR.paint(r,o,o.D));break;default:var p=o.B7,Z=o.AZ;o.B7=o.BW,o.AZ=o.AU,o.KX(),ZC.CR.setup(r,o),ZC.CR.paint(r,o,o.D,!0,0),o.B7=p,o.AZ=Z,o.KX()}}};ZC.DT=ZC.D0.CA(DT);var HL={$i:function(e){this.b(e);var i=this;i.DU="box",i.I=0,i.F=0,i.A8G="",i.E8=-1,i.E9=-1,i.DR=-1,i.DY=-1,i.F6=0,i.FS=0,i.F2=0,i.FD=0,i.A7G=!1,i.KP=!1,i.EM="bottom",i.EV=0,i.M3=0,i.H9=8,i.G8=8,i.XT=[1,1],i.DM=null,i.OL=null,i.PU=!1,i.N4=!0,i.Q1="",i.OJ="",i.NP="",i.P6="",i.WT="tl",i.FC=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"width,height,borderRadiusTopLeft,borderRadiusTopRight,borderRadiusBottomRight,borderRadiusBottomLeft,callout,calloutType,calloutPosition,calloutHook,calloutWidth,calloutHeight,calloutOffset,calloutExtension,position,borderTop,borderRight,borderBottom,borderLeft,rectShortcut","I,F,F6,FS,F2,FD,KP,EM,DM,H9,G8,EV,M3,A8G,Q1,OJ,NP,P6,FC"),e},build:function(){},wh_:function(e,i,t){var n=this;if(i=i||"w",ZC._f_(e)+""!=e+"")return-1!==(e+="").indexOf("%")?n.wh_(ZC._f_(e.replace("%",""))/100,i,!0):-1!==e.indexOf("px")?n.wh_(ZC._f_(e.replace("px","")),i):n.wh_(ZC._f_(e),i);var a="undefined"!=typeof n.E["p-width"]?n.E["p-width"]:n.A.I,l="undefined"!=typeof n.E["p-height"]?n.E["p-height"]:n.A.F;return(e=ZC._a_(e))>1&&!t?ZC._i_(e):e<=1||t?"w"===i?ZC._i_(a*e):ZC._i_(l*e):void 0},m_:function(e,i,t,n,a){var l,o,r=this;if(t=t||0,n=n||0,i=i||"all",a=a||"n","all"===i){var s=String(e).split(/\s+|;|,/);return 1===s.length?[r.m_(s[0],"tb",t,n,a),r.m_(s[0],"lr",t,n,a),r.m_(s[0],"tb",t,n,a),r.m_(s[0],"lr",t,n,a)]:2===s.length?[r.m_(s[0],"tb",t,n,a),r.m_(s[1],"lr",t,n,a),r.m_(s[0],"tb",t,n,a),r.m_(s[1],"lr",t,n,a)]:3===s.length?[r.m_(s[0],"tb",t,n,a),r.m_(s[1],"lr",t,n,a),r.m_(s[2],"tb",t,n,a),r.m_(s[1],"lr",t,n,a)]:[r.m_(s[0],"tb",t,n,a),r.m_(s[1],"lr",t,n,a),r.m_(s[2],"tb",t,n,a),r.m_(s[3],"lr",t,n,a)]}return e+""=="auto"?-2:e+""=="dynamic"&&"y"===a?"dynamic":ZC._f_(e)+""!=e+""?-1!==(e+="").indexOf("%")?r.m_(ZC._f_(e.replace("%",""))/100,i):-1!==e.indexOf("px")?r.m_(ZC._f_(e.replace("px","")),i):r.m_(ZC._f_(e),i):((r.A||"undefined"!=typeof r.E["p-width"])&&(l="undefined"!=typeof r.E["p-width"]?r.E["p-width"]:r.A.I),(r.A||"undefined"!=typeof r.E["p-height"])&&(o="undefined"!=typeof r.E["p-height"]?r.E["p-height"]:r.A.F),(e=ZC._a_(e))>=1?ZC._i_(e):e<1?"lr"===i?ZC._i_((r.A?l:t)*e):ZC._i_((r.A?o:n)*e):void 0)},copy:function(e){this.b(e);for(var i="I,F,E8,DR,DY,E9,F6,FS,F2,FD,KP,EM,DM,XT,H9,G8,EV,M3,A8G,Q1,OJ,NP,P6,FC".split(","),t=0,n=i.length;t<n;t++)"undefined"!=typeof e[i[t]]&&(this[i[t]]=e[i[t]])},locate:function(e){var i,t,n,a,l,o=this;if(2!==(e=e||1))if(o.U0)o.assign_a([["x","iX"],["y","iY"],["width","I"],["height","F"]]);else{var r="undefined"!=typeof o.E["p-x"]?o.E["p-x"]:o.A.iX,s="undefined"!=typeof o.E["p-y"]?o.E["p-y"]:o.A.iY,A="undefined"!=typeof o.E["p-width"]?o.E["p-width"]:o.A.I,C="undefined"!=typeof o.E["p-height"]?o.E["p-height"]:o.A.F;if(!o.PU){var c=0,u=0,p=0,Z=0;if(null!==ZC._n_(o.o.margin)){var h=""+o.o.margin;if(-1!==h.indexOf("dynamic")){var d=o.m_(h,"all",0,0,"y");"dynamic"===d[0]&&(o.E["d-margin-top"]=o.E["d-margin"]=!0),"dynamic"===d[1]&&(o.E["d-margin-right"]=o.E["d-margin"]=!0),"dynamic"===d[2]&&(o.E["d-margin-bottom"]=o.E["d-margin"]=!0),"dynamic"===d[3]&&(o.E["d-margin-left"]=o.E["d-margin"]=!0),o.o.margin=h.replace(/dynamic/g,"20")}}"dynamic"===o.o.margin&&(o.E["d-margin"]=o.E["d-margin-top"]=o.E["d-margin-right"]=o.E["d-margin-bottom"]=o.E["d-margin-left"]=!0,o.o.margin=null),"undefined"==typeof o.E["force-margins"]||null!==ZC._n_(o.o["adjust-layout"])&&ZC._b_(o.o["adjust-layout"])||(null!==ZC._n_(o.o["margin-top"])&&null===ZC._n_(o.o["margin-bottom"])&&(o.o["margin-bottom"]="auto"),null!==ZC._n_(o.o["margin-bottom"])&&null===ZC._n_(o.o["margin-top"])&&(o.o["margin-top"]="auto"),null!==ZC._n_(o.o["margin-left"])&&null===ZC._n_(o.o["margin-right"])&&(o.o["margin-right"]="auto"),null!==ZC._n_(o.o["margin-right"])&&null===ZC._n_(o.o["margin-left"])&&(o.o["margin-left"]="auto"));for(var f=["margin-top","margin-right","margin-bottom","margin-left"],_=0,g=f.length;_<g;_++)"dynamic"===o.o[f[_]]&&(o.E["d-"+f[_]]=o.E["d-margin"]=!0,o.o[f[_]]=null);null!==(i=ZC._n_(o.o.margin))&&(t=o.m_(i,"all"),null===ZC._n_(o.o["margin-top"])&&(c=t[0]),null===ZC._n_(o.o["margin-right"])&&(u=t[1]),null===ZC._n_(o.o["margin-bottom"])&&(p=t[2]),null===ZC._n_(o.o["margin-left"])&&(Z=t[3])),null!==(i=ZC._n_(o.o["margin-top"]))&&(c=t=o.m_(i,"tb")),null!==(i=ZC._n_(o.o["margin-right"]))&&(u=t=o.m_(i,"lr")),null!==(i=ZC._n_(o.o["margin-bottom"]))&&(p=t=o.m_(i,"tb")),null!==(i=ZC._n_(o.o["margin-left"]))&&(Z=t=o.m_(i,"lr"));var v,b=[c,u,p,Z];if(null!==ZC._n_(o.o.x)&&(o.iX=o.xy_(o.o.x,"x")),null!==ZC._n_(o.o.y)&&(o.iY=o.xy_(o.o.y,"y")),null!==(i=ZC._n_(o.o.width))){var B=ZC._p_(i);v=-1!==(""+i).indexOf("%"),o.I=B>1&&!v?ZC._i_(B):-2===Z&&-2===u?ZC._i_(A*B):-2===Z&&-2!==u?ZC._i_((A-u)*B):-2!==Z&&-2===u?ZC._i_((A-Z)*B):ZC._i_((A-Z-u)*B),-1!==o.iX?(o.DY=o.iX-r,o.E9=r+A-o.DY-o.I):-2===Z&&-2===u?(o.DY=o.E9=(A-o.I)/2,o.iX=r+o.DY):-2===Z&&-2!==u?(o.E9=u,o.DY=A-o.E9-o.I,o.iX=r+o.DY):(o.DY=Z,o.iX=r+o.DY,o instanceof ZC.DN?o.E9=u:o.E9=A-o.DY-o.I)}else-1!==o.iX?(o.DY=o.iX-r,o.E9=-2===u?0:u,o.I=A-o.DY-o.E9):-2===Z&&-2===u?(o.DY=o.E9=0,o.iX=r+o.DY,o.I=A-o.DY-o.E9):-2===Z&&-2!==u?(o.E9=u,o.DY=0,o.iX=r+o.DY,o.I=A-o.DY-o.E9):-2!==Z&&-2===u?(o.DY=Z,o instanceof ZC.DN?o.E9=u:o.E9=0,o.iX=r+o.DY,o.I=A-o.DY-o.E9):(o.DY=Z,o.E9=u,o.iX=r+o.DY,o.I=A-o.DY-o.E9);if(null!==(i=ZC._n_(o.o.height))){var m=ZC._p_(i);v=-1!==(""+i).indexOf("%"),o.F=m>1&&!v?ZC._i_(m):-2===c&&-2===p?ZC._i_(C*m):-2===c&&-2!==p?ZC._i_((C-p)*m):-2!==c&&-2===p?ZC._i_((C-c)*m):ZC._i_((C-c-p)*m),-1!==o.iY?(o.E8=o.iY-s,o.DR=s+C-o.E8-o.F):-2===c&&-2===p?(o.E8=o.DR=(C-o.F)/2,o.iY=s+o.E8):-2===c&&-2!==p?(o.DR=p,o.E8=C-o.DR-o.F,o.iY=s+o.E8):(o.E8=c,o.iY=s+o.E8,o instanceof ZC.DN?o.DR=p:o.DR=C-o.E8-o.F)}else-1!==o.iY?(o.E8=o.iY-s,o.DR=-2===p?0:p,o.F=C-o.E8-o.DR):-2===c&&-2===c?(o.E8=o.E8=0,o.iY=s+o.E8,o.F=C-o.E8-o.DR):-2===c&&-2!==p?(o.DR=p,o.E8=0,o.iY=s+o.E8,o.F=C-o.E8-o.DR):-2===c&&-2!==p?(o.E8=c,o instanceof ZC.DN?o.DR=p:o.DR=0,o.iY=s+o.E8,o.F=C-o.E8-o.DR):(o.E8=c,o.DR=p,o.iY=s+o.E8,o.F=C-o.E8-o.DR);if(null!==(i=ZC._n_(o.o.position))){if(o.A&&"undefined"!=typeof o.A.iX&&"undefined"!=typeof o.A.iY&&"undefined"!=typeof o.A.I&&"undefined"!=typeof o.A.F){switch(n=0,a=0,(l=String(i).split(/\s+/))[0]){case"left":n=0;break;case"right":n=1;break;case"center":n=.5;break;default:(n=ZC.II(l[0]))>1&&(n/=o.A.I)}switch(l[1]){case"top":a=0;break;case"bottom":a=1;break;case"middle":a=.5;break;default:(a=ZC.II(l[1]))>1&&(a/=o.A.F)}}o.E["position-info"]=[n,a],o.iX=o.A.iX+ZC._i_(n*(o.A.I-o.I-b[1]-b[3]))+b[3],o.iY=o.A.iY+ZC._i_(a*(o.A.F-o.F-b[0]-b[2]))+b[0]}o.D1=[o.iX,o.iY,o.iX+o.I,o.iY+o.F]}}},parse:function(){this.b();var e,i=this;if(!i.o.tween){if(i.assign_a([["anchor","WT"],["rect-shortcut","FC","b"],["center-ref","A7G","b"],["callout","KP","b"],["callout-type","ACR"],["callout-position","EM"],["callout-hook","DM"],["callout-ratio","XT"],["callout-width","H9","i"],["callout-height","G8","i"],["callout-offset","EV","i"],["callout-extension","M3","i"],["border-top","Q1"],["border-right","OJ"],["border-bottom","NP"],["border-left","P6"]]),null!==(e=ZC._n_(i.o["border-radius"]))){var t=String(e).split(/\s+|;|,/);2===t.length?(i.F6=i.FS=ZC._i_(t[0]),i.F2=i.FD=ZC._i_(t[1])):4===t.length?(i.F6=ZC._i_(t[0]),i.FS=ZC._i_(t[1]),i.F2=ZC._i_(t[2]),i.FD=ZC._i_(t[3])):i.F6=i.FS=i.F2=i.FD=ZC._i_(t[0])}null!==ZC._n_(i.o["callout-tip"])&&(i.OL=new ZC.DT(i.A)),i.assign_a([["border-radius-top-left","F6","i"],["border-radius-top-right","FS","i"],["border-radius-bottom-right","F2","i"],["border-radius-bottom-left","FD","i"]])}},WO:function(e){var i=e.split(/\s/);return i[0]=ZC._i_(i[0]),i[2]=ZC.AP.GC(i[2]),i},paint:function(){var e=this;if(null!==e.DM&&!(e.DM instanceof Array)&&"zcgraph"===e.A.OB){var i=e.A.UY(e.DM);e.DM=[i[0],i[1]],e.DM[0]-=e.BM,e.DM[1]-=e.BH}if(e.A7G&&(e.iX-=e.I/2,e.iY-=e.F/2),"-1"!==e.BW&&0!==e.AU||e.Q1+e.OJ+e.NP+e.P6!==""||"-1"!==e.A0||"-1"!==e.AE||""!==e.DA||""!==e.GR||""!==e.HN){var t,n=e.H.AA;e.M8&&e.C7&&e.A97();var a={x:"iX",y:"iY",width:"I",height:"F"};if(e.o["bottom-state"]&&!e.Y6&&!e.bIsBottom&&!e.VN){var l=new ZC.HL(e.A);for(t in l.copy(e),l.bIsBottom=!0,l.M8=!1,l.Z=e.Z,l.WT=e.WT,l.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY,width:e.I,height:e.F}),l.append(e.o["bottom-state"]),l.K=e.K+"-bottom",l.parse(),l.setAnchor(),!1,a)null===ZC._n_(l.o[t])||-1===(""+l.o[t]).indexOf("+")&&-1===(""+l.o[t]).indexOf("-")||(l[a[t]]=e[a[t]]+ZC._i_(l.o[t]),!0);l.paint()}if(e.Q1+e.OJ+e.NP+e.P6===""){switch(n){case"canvas":e.A1V();break;case"svg":e.VX();break;case"vml":e.VW()}if(e.KP&&e.OL){var o,r;if(e.DM&&2===e.DM.length?(o=e.DM[0],r=e.DM[1]):e.E.cp&&(o=e.E.cp[0],r=e.E.cp[1]),e.OL.Z=e.OL.C7=e.Z,e.OL.copy(e),e.OL.append(e.o["callout-tip"]),e.OL.K=e.K+"-callout-tip",e.OL.o.x=o,e.OL.o.y=r,e.E.cm){var s=e.E.cm[0],A=e.E.cm[1],C=Math.atan2(ZC._i_(A)-ZC._i_(r),ZC._i_(s)-ZC._i_(o));isNaN(C)&&(C=0),null===ZC._n_(e.OL.o.angle)&&(e.OL.o.angle=ZC.TK(C))}e.OL.parse(),e.OL.paint()}}else{var c=e.AU,u=e.BW,p=e.GD;switch(e.AU=0,n){case"canvas":e.A1V();break;case"svg":e.VX();break;case"vml":e.VW()}e.AU=c;var Z=e.A0,h=e.AE;e.A0=e.AE="-1";for(var d,f=["top","right","bottom","left"],_=["Q1","OJ","NP","P6"],g=0;g<f.length;g++)if(""!==(d=e[_[g]])&&"none"!==d){var v=e.WO(d);switch(e.AU=v[0],e.GD=v[1],e.BW=v[2],n){case"canvas":e.A1V(f[g]);break;case"svg":e.VX(f[g]);break;case"vml":e.VW(f[g])}e.AU=c,e.BW=u,e.GD=p}e.A0=Z,e.AE=h}if(e.o["top-state"]&&!e.Y6&&!e.VN&&!e.bIsBottom){var b=new ZC.HL(e.A);for(t in b.copy(e),b.VN=!0,b.M8=!1,b.Z=e.Z,b.WT=e.WT,b.append({x:e.iX-e.A.iX,y:e.iY-e.A.iY,width:e.I,height:e.F}),b.append(e.o["top-state"]),b.K=e.K+"-top",b.parse(),b.setAnchor(),!1,a)null===ZC._n_(b.o[t])||-1===(""+b.o[t]).indexOf("+")&&-1===(""+b.o[t]).indexOf("-")||(b[a[t]]=e[a[t]]+ZC._i_(b.o[t]),!0);b.paint()}}},setAnchor:function(){var e=this;switch(e.WT){case"tl":break;case"tr":e.iX-=e.I;break;case"bl":e.iY-=e.F;break;case"br":e.iX-=e.I,e.iY-=e.F;break;case"c":e.iX-=e.I/2,e.iY-=e.F/2;break;case"t":e.iX-=e.I/2;break;case"r":e.iX-=e.I,e.iY-=e.F/2;break;case"b":e.iX-=e.I/2,e.iY-=e.F;break;case"l":e.iY-=e.F/2}},A97:function(){var e=this,i=new ZC.HL(e.A);i.K=e.K+"-sh",i.copy(e),i.Z=e.C7,i.M8=!1,i.Y6=!0,i.Q1=i.OJ=i.NP=i.P6="",i.A0=i.AE=i.RT,i.GR=i.HN="",i.DA="",i.GD="solid",i.BW=i.RT,i.AZ=0;var t=e.JW*ZC.EH(e.OH),n=e.JW*ZC.EP(e.OH);i.I=e.I+("vml"===e.H.AA?0:.5)-ZC.EH(e.OH)*e.PD/2,i.F=e.F+("vml"===e.H.AA?0:.5)-ZC.EP(e.OH)*e.PD/2,i.O0=i.C6=i.T5*e.C6,i.K=e.K+"-sh",i.iX=e.iX+ZC._i_(t),i.iY=e.iY+ZC._i_(n),i.paint()},YD:function(e){var i,t=this,n=t.iX,a=t.iY,l=n+t.I/2,o=a+t.F/2,r=t.VO,s=t.W5;if(ZC._a_(r)<=1&&(r=r*t.I/2),ZC._a_(s)<=1&&(s=s*t.F/2),l+=r,o+=s,"radial"===e){var A=ZC._i_((t.I+t.F)/2),C=ZC.CY(t.I,t.F);return i=C<A/4?(C+A)/2:C,{cx:l,cy:o,r:ZC._a_(i)}}if("linear"===e){var c=(i=t.I>=t.F?ZC._a_(ZC.EP(t.N7))>.5?t.F/2:t.I/2:ZC._a_(ZC.EH(t.N7))>.5?t.I/2:t.F/2)*ZC.EH(t.N7),u=i*ZC.EP(t.N7);return{x1:l-c,y1:o-u,x2:l+c,y2:o+u}}},W0:function(e){var i,t=this;void 0===e&&(e="all");var n,a,l=t.iX,o=t.iY;t.D=[],n=a=t.AU/2;var r=1;switch(t.H.AA){case"vml":r=2,t.AU%2==1&&(n=ZC._i_((t.AU-1)/2),a=ZC._i_((t.AU+1)/2))}var s=null,A=ZC._x_(l+n,2),C=ZC._x_(l-a,2),c=ZC._x_(o+n,2),u=ZC._x_(o-a,2),p=t.DM&&2===t.DM.length,Z=ZC._i_(t.EV*(t.I-t.H9)/100),h=ZC._i_(t.EV*(t.F-t.G8)/100),d=0!==t.F6||0!==t.FS||0!==t.F2||0!==t.FD,f=t.XT[0],_=t.XT[1];switch(t.EM){case"top":t.E.cm=[t.iX+t.I/2+Z,t.iY];break;case"bottom":t.E.cm=[t.iX+t.I/2+Z,t.iY+t.F];break;case"left":t.E.cm=[t.iX,t.iY+t.F/2+h];break;case"right":t.E.cm=[t.iX+t.I,t.iY+t.F/2+h]}if(d){var g,v=ZC.CY(t.I/2,t.F/2);"top"!==e&&"all"!==e||(0!==t.F6?(g=t.I/2>=t.F6&&t.F/2>=t.F6?ZC._a_(t.F6):v,t.D.push([A,c+g]),t.F6>0&&t.D.push([A,c,A+r*g,c]),t.D.push([A+g,c])):t.D.push([A,c]),t.KP&&"top"===t.EM&&(t.D.push([A+t.I/2-f*t.H9/2-t.AU/2+Z,c]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[A+t.I/2-t.AU/2+Z,c-t.G8],t.D.push(s)),t.M3>0&&(i=t.D[t.D.length-1],t.D.push([i[0],i[1]-t.M3*(t.G8>0?1:-1)]),t.D.push([i[0],i[1]])),t.D.push([A+t.I/2-t.AU/2+_*t.H9/2+Z,c])),"top"===e&&(0!==t.FS?(g=t.I/2>=t.FS&&t.F/2>=t.FS?ZC._a_(t.FS):v,t.D.push([C+t.I-g,c])):t.D.push([C+t.I,c]))),"right"!==e&&"all"!==e||(0!==t.FS?(g=t.I/2>=t.FS&&t.F/2>=t.FS?ZC._a_(t.FS):v,t.D.push([C+t.I-g,c]),t.FS>0?t.D.push([C+t.I,c,C+t.I,c+r*g]):t.D.push([C+t.I,c+g])):t.D.push([C+t.I,c]),t.KP&&"right"===t.EM&&(t.D.push([C+t.I,c+t.F/2-f*t.G8/2-t.AU/2+h]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[C+t.I+t.H9,c+t.F/2-t.AU/2+h],t.D.push(s)),t.D.push([C+t.I,c+t.F/2+_*t.G8/2-t.AU/2+h])),"right"===e&&(0!==t.F2?(g=t.I/2>=t.F2&&t.F/2>=t.F2?ZC._a_(t.F2):v,t.D.push([C+t.I,u+t.F-g])):t.D.push([C+t.I,u+t.F]))),"bottom"!==e&&"all"!==e||(0!==t.F2?(g=t.I/2>=t.F2&&t.F/2>=t.F2?ZC._a_(t.F2):v,t.D.push([C+t.I,u+t.F-g]),t.F2>0?t.D.push([C+t.I,u+t.F,C+t.I-r*g,u+t.F]):t.D.push([C+t.I-g,u+t.F])):t.D.push([C+t.I,u+t.F]),t.KP&&"bottom"===t.EM&&(t.D.push([C+t.I/2+f*t.H9/2+t.AU/2+Z,u+t.F]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[C+t.I/2+t.AU/2+Z,u+t.F+t.G8],t.D.push(s)),t.M3>0&&(i=t.D[t.D.length-1],t.D.push([i[0],i[1]+t.M3*(t.G8>0?1:-1)]),t.D.push([i[0],i[1]])),t.D.push([C+t.I/2-_*t.H9/2+t.AU/2+Z,u+t.F])),"bottom"===e&&(0!==t.FD?(g=t.I/2>=t.FD&&t.F/2>=t.FD?ZC._a_(t.FD):v,t.D.push([A+g,u+t.F])):t.D.push([A,u+t.F]))),"left"!==e&&"all"!==e||(0!==t.FD?(g=t.I/2>=t.FD&&t.F/2>=t.FD?ZC._a_(t.FD):v,t.D.push([A+g,u+t.F]),t.FD>0?t.D.push([A,u+t.F,A,u+t.F-r*g]):t.D.push([A,u+t.F-g])):t.D.push([A,u+t.F]),t.KP&&"left"===t.EM&&(t.D.push([A,u+t.F/2+f*t.G8/2+t.AU/2+h]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[A-t.H9,u+t.F/2+t.AU/2+h],t.D.push(s)),t.D.push([A,u+t.F/2-_*t.G8/2+t.AU/2+h])),0!==t.F6?(g=t.I/2>=t.F6&&t.F/2>=t.F6?ZC._a_(t.F6):v,t.D.push([A,c+g])):(t.D.push([A,c]),t.D.push([A+.1,c])))}else"top"!==e&&"all"!==e||("top"===e?t.D.push([A+.5,c+.5]):t.D.push([A,c]),t.KP&&"top"===t.EM&&(t.D.push([A+t.I/2-f*t.H9/2-t.AU/2+Z,c]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[A+t.I/2-t.AU/2+Z,c-t.G8],t.D.push(s)),t.M3>0&&(i=t.D[t.D.length-1],t.D.push([i[0],i[1]-t.M3*(t.G8>0?1:-1)]),t.D.push([i[0],i[1]])),t.D.push([A+t.I/2+_*t.H9/2-t.AU/2+Z,c])),"top"===e&&t.D.push([C+t.I+.5,c+.5])),"right"!==e&&"all"!==e||("right"===e?t.D.push([C+t.I+.5,c+.5]):t.D.push([C+t.I,c]),t.KP&&"right"===t.EM&&(t.D.push([C+t.I,c+t.F/2-t.AU/2-f*t.G8/2+h]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[C+t.I+t.H9,c+t.F/2-t.AU/2+h],t.D.push(s)),t.D.push([C+t.I,c+t.F/2-t.AU/2+_*t.G8/2+h])),"right"===e&&t.D.push([C+t.I+.5,u+t.F+.5])),"bottom"!==e&&"all"!==e||("bottom"===e?t.D.push([C+t.I+.5,u+t.F+.5]):t.D.push([C+t.I,u+t.F]),t.KP&&"bottom"===t.EM&&(t.D.push([C+t.I/2+f*t.H9/2+t.AU/2+Z,u+t.F]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[C+t.I/2+t.AU/2+Z,u+t.F+t.G8],t.D.push(s)),t.M3>0&&(i=t.D[t.D.length-1],t.D.push([i[0],i[1]+t.M3*(t.G8>0?1:-1)]),t.D.push([i[0],i[1]])),t.D.push([C+t.I/2-_*t.H9/2+t.AU/2+Z,u+t.F])),"bottom"===e&&t.D.push([A+.5,u+t.F+.5])),"left"!==e&&"all"!==e||("left"===e?t.D.push([A+.5,u+t.F+.5]):t.D.push([A,u+t.F]),t.KP&&"left"===t.EM&&(t.D.push([A,u+t.F/2+t.AU/2+f*t.G8/2+h]),p?t.D.push([t.DM[0],t.DM[1]]):(s=[A-t.H9,u+t.F/2+t.AU/2+h],t.D.push(s)),t.D.push([A,u+t.F/2+t.AU/2-_*t.G8/2+h])),"left"===e?t.D.push([A+.5,c+.5]):(t.D.push([A,c]),t.D.push([A+.1,c])));s&&(t.E.cp=s)},A1V:function(e){e=e||"all";var i,t,n,a=this,l=a.Z.getContext("2d");l.save(),l.globalCompositeOperation=a.A0Z;var o=a.iX,r=a.iY,s=a.A1I(),A=s.bc,C=s.bgc1,c=s.bgc2;if("all"===e)if(C!==c||""!==a.GR&&""!==a.HN){var u=a.YD(a.NH);"radial"===a.NH?i=l.createRadialGradient(u.cx,u.cy,1,u.cx,u.cy,u.r):"linear"===a.NH&&(u.x1=isNaN(u.x1)?0:u.x1,u.x2=isNaN(u.x2)?0:u.x2,u.y1=isNaN(u.y1)?0:u.y1,u.y2=isNaN(u.y2)?0:u.y2,i=l.createLinearGradient(u.x1,u.y1,u.x2,u.y2)),""!==a.GR&&""!==a.HN?a.ZH(i):(i.addColorStop(0,C),i.addColorStop(1,c)),l.fillStyle=i}else""!==a.DA&&-1!==ZC.AV(["repeat","true",!0],a.M4)&&"-1"===a.A0&&"-1"===a.AE&&(C="rgba(255,255,255,0)"),l.fillStyle=C;l.strokeStyle=A,l.lineWidth=a.AU,l.translate(a.BM,a.BH),0!==a.A9&&(l.translate(o+a.I/2,r+a.F/2),l.rotate(ZC.T1(a.A9)),l.translate(-(o+a.I/2),-(r+a.F/2))),l.beginPath(),a.W0(e);var p=a.F6+a.FS+a.F2+a.FD!==0;n=a.AZ,a.AZ=a.AU;var Z=a.GD;if(a.GD="",a.KX(),ZC.CR.contour(l,a,a.D),a.AZ=n,a.GD=Z,a.KX(),"all"===e)if(""!==a.DA&&-1===ZC.AV(ZC.IMG404,a.DA)){l.fill(),l.save(),l.clip();var h=l.globalAlpha;l.globalAlpha=a.C6;var d=a.RB(),f=d.image;switch(a.M4){default:l.translate(a.iX,a.iY),t=l.createPattern(f,"repeat"),l.fillStyle=t,l.fill(),l.translate(-d.x,-d.y);break;case"no-repeat":case"false":case!1:l.drawImage(f,d.x-a.BM,d.y-a.BH,a.E["bg-image-width"],a.E["bg-image-height"])}l.globalAlpha=h,l.restore()}else l.fill();if(a.AU>0){var _=a.B7;n=a.AZ,a.B7=a.BW,a.AZ=a.AU,a.KX(),ZC.CR.setup(l,a),a.T7=p?"round":"square",a.EX+a.G9>0&&(a.T7="butt"),a.ZZ=p?"round":"miter",a.E["skip-top"]=!0,a.E.border=e,ZC.CR.paint(l,a,a.D,!0),a.B7=_,a.AZ=n,a.KX()}l.closePath(),l.restore()},VX:function(e){e=e||"all";var i=this,t=i.Z;i.E.fill=-1;var n=!1;if("all"===e){if(""!==i.DA&&-1===ZC.AV(ZC.IMG404,i.DA)){var a=i.RB();i.A2O({info:a,x:i.iX,y:i.iY}),n=!0}i.WZ()}if(i.W0(e),n&&"repeat"!==i.M4&&i.KP){var l=0,o=0;i.D1[1]<i.iY&&(o=i.D1[3]-i.D1[1]-i.F),i.D1[0]<i.iX&&(l=i.D1[2]-i.D1[0]-i.I),null===ZC._n_(i.E["pattern-tx"])?i.E["pattern-tx"]=l:i.E["pattern-tx"]+=l,null===ZC._n_(i.E["pattern-ty"])?i.E["pattern-ty"]=o:i.E["pattern-ty"]+=o,ZC.Q.G3(ZC.AK(i.E["pattern-image-id"]),{transform:"translate("+i.E["pattern-tx"]+","+i.E["pattern-ty"]+")"})}var r=i.F6+i.FS+i.F2+i.FD!==0;i.E.cx=i.iX+i.I/2,i.E.cy=i.iY+i.F/2,i.VM&&i.A3G();var s=i.B7,A=i.AZ;i.B7=i.BW,i.AZ=i.AU,i.KX(),ZC.CR.setup(t,i),i.T7=r?"round":"square",i.EX+i.G9>0&&(i.T7="butt"),i.ZZ=r?"round":"miter";var C=!1;ZC.A5.browser.msie||!i.FC||i.KP||""!==i.Q1||""!==i.OJ||""!==i.NP||""!==i.P6||0!==i.F6||0!==i.FS||0!==i.F2||0!==i.FD||(C=!0),i.E["skip-top"]=!0,i.E.border=e,ZC.CR.paint(t,i,i.D,!0,null,C),i.B7=s,i.AZ=A,i.KX()},VW:function(e){e=e||"all";var i=this,t=i.Z;if("all"===e){var n=ZC.Q.F5("zcv:fill");if(""!==i.DA&&-1===ZC.AV(ZC.IMG404,i.DA)){var a=i.RB(),l=a.image;switch(i.M4){default:n.type="tile",n.src=i.DA,ZC.Q.G3(n,{position:a.cx+","+a.cy,opacity:i.C6,"o:opacity2":i.C6}),i.E.imgfill=[n];break;case"no-repeat":case"false":case!1:i.E.imgfill=[l,a.x,a.y]}}i.WY("0.5,0.5")}var o=ZC.Q.F5("zcv:stroke");switch(o.weight=i.AU+"px",o.color=i.BW,o.opacity=i.C6,i.GD){case"solid":o.dashstyle="solid";break;case"dotted":o.dashstyle="dot";break;case"dashed":o.dashstyle="dash"}i.E.stroke=o,i.W0(e);var r=i.F6+i.FS+i.F2+i.FD!==0;i.E.cx=i.iX+i.I/2,i.E.cy=i.iY+i.F/2;var s=i.B7,A=i.AZ;i.B7=i.BW,i.AZ=i.AU,i.KX(),ZC.CR.setup(t,i),i.T7=r?"round":"square",i.EX+i.G9>0&&(i.T7="butt"),i.ZZ=r?"round":"miter",i.E.border=e,ZC.CR.paint(t,i,i.D,"all"===e),i.B7=s,i.AZ=A,i.KX()}};ZC.HL=ZC.DT.CA(HL);var OY={$i:function(e){this.b(e);var i=this;i.WS=null,i.BG=null,i.M=null,i.SK=null,i.A7=null,i.K9=!1,i.O7=!1,i.KY=!1,i.A65=!1},parse:function(){var e,i=this;i.BG=zingchart.pool.getInstance("box"===i.WS.type?"HL":"DT",i.A,i.K+"-shape",i.WS.tween),i.BG.append(i.WS),i.BG.iX=i.iX,i.BG.iY=i.iY,i.BG.K=i.K+"-gshape",i.BG.O7=i.O7,i.A65||null===ZC._n_(e=i.BG.o.points)||(i.BG.o.points=ZC.AP.A5B(e,i.A.iX,i.A.iY),i.A65=!0),i.BG.parse(),null!==ZC._n_(e=i.BG.o.label)&&null!==ZC._n_(e.text)&&""!==e.text&&("undefined"==typeof e.visible||ZC._b_(e.visible))&&(i.M=zingchart.pool.getInstance("DN",i,i.A.K+"-shape-label-"+i.H8,ZC.objmove),ZC.objmove||i.M.append(e)),null!==ZC._n_(e=i.BG.o["static"])&&(i.K9=ZC._b_(e)),null!==ZC._n_(e=i.BG.o.flat)&&(i.K9=ZC._b_(e)),null!==ZC._n_(e=i.BG.o.dynamic)&&(i.KY=ZC._b_(e)),null!==ZC._n_(e=i.BG.o.connector)&&(i.SK=new ZC.DT(i),i.SK.append(e),i.SK.parse())},paint:function(){var e,i=this;if(i.BG.Z=i.Z,i.BG.C7=i.C7,i.BG.locate(2),i.BG.VN=!1,"box"===i.BG.o.type&&(i.iX-=i.BG.I/2,i.iY-=i.BG.F/2,i.BG.iX-=i.BG.I/2,i.BG.iY-=i.BG.F/2),i.BG.paint(),i.M){if(i.M.Z=i.M.C7=i.Z,i.M.IL=ZC.AK(i.A.A.K+"-text"),i.M.K=i.A.K+"-shape-label-"+i.H8,i.M.GL=i.A.K+"-shape-label zc-shape-label",i.M.o.anchor=i.M.o.anchor||"c",!i.WS["map-item"])switch(i.DU){default:i.M.o.x=i.iX,i.M.o.y=i.iY;break;case"line":case"poly":case"rect":case"rectangle":i.M.o.x=ZC._i_((i.BG.D1[0]+i.BG.D1[2])/2),i.M.o.y=ZC._i_((i.BG.D1[1]+i.BG.D1[3])/2)}if(ZC.objmove||i.M.parse(),i.M.iX=i.M.iX+i.BG.BM,i.M.iY=i.M.iY+i.BG.BH,i.M.AN){if(i.SK&&i.SK.D.length>0){if(!ZC.AK(i.A.K+"-objects-front")){var t=i.A.A.I+"/"+i.A.A.F;ZC.Q.JZ({cls:"zc-abs",wh:t,id:i.A.K+"-objects-front",p:ZC.AK(i.A.A.K+"-objects-front")},i.A.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:i.A.K+"-objects-front-c",p:ZC.AK(i.A.K+"-objects-front"),wh:t},i.A.A.AA)}var n=i.SK.D,a=i.SK.o.anchor||"",l=n[n.length-1];switch(a){case"l":i.M.iX=l[0]+i.BG.BM,i.M.iY=l[1]-i.M.F/2+i.BG.BH;break;case"r":i.M.iX=l[0]-i.M.I+i.BG.BM,i.M.iY=l[1]-i.M.F/2+i.BG.BH;break;case"t":i.M.iX=l[0]-i.M.I/2+i.BG.BM,i.M.iY=l[1]+i.BG.BH;break;case"b":i.M.iX=l[0]-i.M.I/2+i.BG.BM,i.M.iY=l[1]-i.M.F+i.BG.BH;break;default:i.M.iX=l[0]-i.M.I/2+i.BG.BM,i.M.iY=l[1]-i.M.F/2+i.BG.BH}e=ZC.Q.EB(ZC.AK(i.A.K+"-objects-front-c"),i.A.H.AA),ZC.CR.setup(e,i.SK),ZC.CR.paint(e,i.SK,n)}if(i.M.VN=!1,i.WS["map-item"]&&(i.M.GL=i.A.K+"-mapshape-label zc-mapshape-label",i.M.iX<i.A.iX||i.M.iX+i.M.I>i.A.iX+i.A.I||i.M.iY<i.A.iY||i.M.iY+i.M.F>i.A.iY+i.A.F))return;i.M.paint(),i.E["print-canvas"]?i.M.EK(ZC.AK(i.E["print-canvas"])):i.M.EK()}}}};ZC.OY=ZC.DT.CA(OY);var DN={$i:function(e){this.b(e);var i=this;i.IL=null,i.GL="",i.AM=null,i.O8="center",i.JX="middle",i.DG=zingchart.FONTSIZE,i.GH=zingchart.FONTFAMILY,i.C2="#000",i.A92=!1,i.N5=!1,i.QT=!1,i.K8="none",i.sFontWeight="normal",i.YB=0,i.FM=2,i.FN=2,i.FU=2,i.EQ=2,i.A8K=!1,i.A29=!1,i.FI=-1,i.KA=0,i.NM=0,i.OM=ZC.MAX,i.bRTL=!1,i.A1D=!0,i.V2=zingchart.FASTWIDTH,i.A69=1.65,i.V5=1,i.VP=!1,i.A7=null,i.V9=!1,i.A5J=!1},getPMap:function(){var e=this.b();return this.addPMap(e,"textAlign,verticalAlign,fontSize,fontFamily,color,bold,fontWeight,italic,underline,textDecoration,paddingTop,paddingRight,paddingBottom,paddingLeft,text","O8,JX,DG,GH,C2,A92,sFontWeight,N5,QT,K8,FM,FN,FU,EQ,AM"),e},copy:function(e){this.b(e);for(var i="O8,JX,DG,GH,C2,A92,sFontWeight,N5,K8,QT,FM,FN,FU,EQ,AM".split(","),t=0,n=i.length;t<n;t++)"undefined"!=typeof e[i[t]]&&(this[i[t]]=e[i[t]])},overrideFormat:function(e){for(var i=["decimals","thousands-separator","decimals-separator"],t=0;t<i.length;t++)e[i[t]]="undefined"!=typeof this.o[i[t]]?this.o[i[t]]:e[i[t]];return e},JV:function(e){return e},isBold:function(e){return"bold"===e||"bolder"===e||"500"===e||"600"===e||"700"===e||"800"===e||"900"===e},cwidth:function(e){var i=this;if(i.V2)return e.replace(/(<([^>]+)>)/gi,"").length*i.DG/(i.A69*(i.isBold(i.sFontWeight)?.87:1)*(i.N5?.95:1));var t="";return"undefined"!=typeof i.o["html-mode"]&&ZC._b_(i.o["html-mode"])&&(t="[HTMLMODE]"),ZC.Q.A43(this.H.K,t+e,this.GH,this.DG,this.sFontWeight,this.FI)},parse:function(){this.I=this.F=this.NM=this.KA=0,this.b();var e,i,t,n,a,l=this;if(!l.o.tween){if(l.ZQ("text","AM"),null!==ZC._n_(l.AM)&&(l.AM=""+l.AM,l.AM=l.JV(l.AM),l.AM=l.AM.replace(/\n/g,"<br>").replace(/\\n/g,"<br>"),"svg"===l.H.AA&&(l.AM=l.AM.replace(/&nbsp;/g," ")),l.AM=l.AM.replace(/<audio|<video|<embed|<object/gi,""),-1!==l.AM.indexOf("img")&&(l.AM=l.AM.replace(/on(.+?)=/gi,""))),l.assign_a([["overlap","A1D","b"],["fast-width","V2","b"],["max-width","OM","i"],["line-height","FI","i"],["width-ratio","A69","f"],["wrap-text","A29","b"],["clip-text","A8K","b"],["bold","A92","b"],["italic","N5","b"],["underline","QT","b"],["text-decoration","K8"],["rtl","bRTL","b"],["text-align","O8"],["align","O8"],["vertical-align","JX"],["font-size","DG","f"],["max-chars","YB","i"],["font-family","GH"],["font-angle","A9","i"],["color","C2","c"],["font-color","C2","c"],["text-alpha","V5","f",0,1],["lock-rotation","V9","b"]]),l.DG=ZC.BQ(1,l.DG),null===ZC._n_(l.o["text-alpha"])&&(l.V5=l.C6),l.A92&&(l.sFontWeight="bold"),null!==(e=ZC._n_(l.o["font-weight"]))&&(l.sFontWeight=e),null===ZC._n_(l.o["text-decoration"])&&(l.K8=l.QT?"underline":"none"),null!==(e=ZC._n_(l.o["font-style"]))&&(l.N5="italic"===e||"oblique"===e),null!==(e=ZC._n_(l.o.padding))){var o=String(e).split(/\s+|;|,/);i=1===o.length?[ZC._i_(o[0]),ZC._i_(o[0]),ZC._i_(o[0]),ZC._i_(o[0])]:2===o.length?[ZC._i_(o[0]),ZC._i_(o[1]),ZC._i_(o[0]),ZC._i_(o[1])]:3===o.length?[ZC._i_(o[0]),ZC._i_(o[1]),ZC._i_(o[2]),ZC._i_(o[0])]:[ZC._i_(o[0]),ZC._i_(o[1]),ZC._i_(o[2]),ZC._i_(o[3])],l.FM=i[0],l.FN=i[1],l.FU=i[2],l.EQ=i[3]}if(l.assign_a([["padding-top","FM","i"],["padding-right","FN","i"],["padding-bottom","FU","i"],["padding-left","EQ","i"]]),l.AM){l.YB>0&&l.AM.length>l.YB&&(l.AM=l.AM.substring(0,l.YB)+"...");var r=l.AM.split(/<br>|<br\/>|<br \/>|\n/),s="";"undefined"!=typeof l.o["html-mode"]&&ZC._b_(l.o["html-mode"])&&(r=[l.AM],s="[HTMLMODE]");r.length;for(l.V2?l.KA=1.65*this.DG:l.KA=ZC.Q.A43(this.H.K,s+l.AM,this.GH,this.DG,this.sFontWeight,this.FI,!0)+l.FM+l.FU,t=0,n=r.length;t<n;t++)l.NM=ZC.BQ(l.NM,l.cwidth(r[t])+l.EQ+l.FN)}else l.AM="",l.NM=ZC._i_(1.25*l.DG),l.KA=-1===l.FI?ZC._i_(1.25*l.DG):l.FI;if((null===ZC._n_(l.o.width)||isNaN(l.I)||0===l.I)&&(l.I=l.NM),(null===ZC._n_(l.o.height)||isNaN(l.F)||0===l.F)&&(l.F=l.KA),l.I=ZC.CY(l.I,l.OM),l.A29&&l.NM>l.I&&!l.E.wrapped&&l.I>2*l.DG){var A,C="",c=0,u=l.AM.replace(/<br>/gi," [##] ").split(/\s|<br>/),p=[];for(t=0,n=u.length;t<n;t++)if((A=l.cwidth(u[t]))>.9*l.I){var Z=Math.ceil(A/l.I*.9),h=Math.ceil(u[t].length/Z);for(a=0;a<Z;a++)p.push(u[t].substr(a*h,h))}else p.push(u[t]);for(t=0,n=p.length;t<n;t++)""!==p[t]&&("[##]"===p[t]?(C+="<br>",c=0):(c+=A=1+l.cwidth(p[t]+" "))>.9*l.I?(t>0&&(C+="<br>"),C+=p[t]+" ",c=A):C+=p[t]+" ");C=(C=C.replace(/<br><br>/g,"<br>").replace(/ <br> <br>/g," <br>")).replace(/(.+?)<br> $/g,"$1");var d=l.o.text;l.o.text=C,l.E.wrapped=!0,l.parse(),l.o.text=d,l.E.wrapped=!1}if("canvas"!==l.H.AA&&(l.AM=l.AM.replace(/&lt;/g,"<").replace(/&gt;/g,">")),!(null!==ZC._n_(l.o.width)&&null!==ZC._n_(l.o.height)||null===ZC._n_(l.o.position)&&null===ZC._n_(l.o.margin)&&null===ZC._n_(l.o["margin-top"])&&null===ZC._n_(l.o["margin-right"])&&null===ZC._n_(l.o["margin-bottom"])&&null===ZC._n_(l.o["margin-left"]))){l.iX=-1,l.iY=-1;var f=l.o.width,_=l.o.height;null===ZC._n_(f)&&(l.o.width=l.I),null===ZC._n_(_)&&(l.o.height=l.F),l.locate(),l.o.width=f,l.o.height=_}if("undefined"==typeof l.o["html-mode"]||!l.o["html-mode"]){var g=Math.ceil((l.NM-l.EQ-l.FN)/l.DG);g>0&&(l.AM=l.AM.replace(/<hr>/g,new Array(g).join("\u2014")))}}l.setAnchor()},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c=this;if(!c.VP&&!c.A1D){var u=!0;null!==ZC._n_(c.o.flexible)&&(u=ZC._b_(c.o.flexible));var p,Z,h={x:c.iX+c.EQ-1,y:c.iY+c.FM-1,width:c.I-c.EQ-c.FN+2,height:c.F-c.FM-c.FU+2,type:c.E.lbltype||""},d=[[0,0]];for(u&&(d=[[0,0],[0,2],[0,-4],[0,4],[0,-8],[3,0],[-6,0],[5,0],[-10,0]]),Z=0;Z<d.length;Z++){for(p=!0,h.x+=d[Z][0],h.y+=d[Z][0],a=0,l=c.H.ST.length;a<l;a++)ZC.AQ.XM(h,c.H.ST[a],-2)&&(p=!1);if(p){c.iX=h.x,c.iY=h.y;break}}if(!p)return;c.H.ST.push(h)}var f=c.H.AA;if(e=ZC.Q.EB(c.Z,f),c.VP||c.b(),!c.A5J&&(c.o.width||!(c.I-c.EQ-c.FN<2))&&(c.o.height||!(c.KA-c.FM-c.FU<2))){var _=c.A9%360==0?"0":"";if((c.VP||zingchart.CANVASTEXT&&"canvas"===f)&&(_=""),ZC.vml&&"svg"===f&&""===c.GL&&(c.GL=c.K+"-class"),!c.VP&&ZC.AK(c.K)&&(f="_",ZC.objmove))return ZC.AK(c.K).style.top=c.iY+c.BH+"px",void(ZC.AK(c.K).style.left=c.iX+c.BM+"px");var g="undefined"!=typeof c.E["html-mode"]&&c.E["html-mode"],v=g;"undefined"!=typeof c.o["html-mode"]&&(g=ZC._b_(c.o["html-mode"]));var b,B,m,E,D,K,F,x,I,y,w,Y,X,M,L,H,P,N,G,S,O,k,T=[c.AM];g||(T=c.AM.split(/<br>|<br\/>|<br \/>|\n/)),g&&!v&&"svg"===f&&"0"===_&&(_="0html");var z=c.IL?c.IL:c.Z.parentNode;switch(f+_){case"canvas0":case"vml0":case"svg0html":if(n=1,!g)switch(c.JX){case"middle":n+=(c.F-c.KA)/2;break;case"bottom":n+=c.F-c.KA}if(o=ZC.Q.HY({id:c.K,cls:c.GL,tl:ZC._x_(c.iY+c.BH)+"/"+ZC._x_(c.iX+c.BM),wh:c.I+"/"+c.F,position:"absolute",padding:0,margin:0,overflow:g?"visible":"hidden",textAlign:c.O8}),g&&(v||f+_!=="svg0html"||(z=ZC.AK(c.H.K+"-top")),z.appendChild(o)),ZC.Q.HY({id:c.K+"-t",cls:""!==c.GL?c.GL+"-t":"",p:o,width:c.I-c.EQ-c.FN,height:g?null:c.KA-c.FM-c.FU,tl:n+"/0",html:c.AM+"",position:"absolute",whiteSpace:"nowrap",opacity:c.V5,color:c.C2,fontWeight:c.sFontWeight,fontStyle:c.N5?"oblique":"normal",textDecoration:c.K8,fontSize:c.DG,fontFamily:c.GH,marginTop:c.FM,marginRight:c.FN,marginBottom:c.FU,marginLeft:c.EQ,verticalAlign:c.JX,textAlign:c.O8,lineHeight:-1===c.FI?"125%":c.FI+"px",rtl:c.bRTL,padding:0}),c.E["css-display"]&&(o.style.display=c.E["css-display"],c.E["css-display"]=null),v&&c.H&&c.H.A7&&!c.o.width&&!c.o.height){var Q=ZC.A5("#"+c.K+"-t");"canvas"===f&&(ZC.AK(c.H.K+"-tooltip-c").width=Q.width()+c.EQ+c.FN,ZC.AK(c.H.K+"-tooltip-c").height=Q.height()+c.FM+c.FU),c.H.A7.clear(),c.I=Q.width()+c.EQ+c.FN,c.F=Q.height()+c.FM+c.FU,c.paint()}break;case"canvas":var J=!1;if(ZC.A5.browser.opera&&c.A9%90==0&&0!==c.A9&&(c.A9+=.5,J=!0),e=c.Z.getContext("2d"),zingchart.DEV.CACHECANVASTEXT&&(ZC.CanvasCache||(ZC.CanvasCache={})),!zingchart.DEV.CACHECANVASTEXT||zingchart.DEV.CACHECANVASTEXT&&!ZC.CanvasCache[c.K]){for(zingchart.DEV.CACHECANVASTEXT&&(ZC.CanvasCache[c.K]=document.createElement("canvas"),ZC.CanvasCache[c.K].width=c.NM,ZC.CanvasCache[c.K].height=c.KA),b=-1===c.FI?0:ZC._x_(c.FI-1.25*c.DG)/2,a=0,l=T.length;a<l;a++)if(""!==ZC.GV(T[a])){switch(i=1===l?c.NM:c.cwidth(T[a])+c.FN+c.EQ,m=-1===(B=T[a]).indexOf("<")?B:B.replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,""),t=0,n=0,c.O8){case"center":t+=(c.I-i)/2;break;case"right":t+=c.I-i}switch(c.JX){case"middle":n+=(c.F-c.KA)/2;break;case"bottom":n+=c.F-c.KA}if(E=0,B!==m){for(;K=/<(.+?)>(.*?)<\/(.+?)>/.exec(B);){switch(F="",x="",(A=/(.+?)style=(.+?)(\'|")(.*?)/.exec(K[1]))&&(x=A[2].replace(/\'|"/g,"")),K[3]){case"b":case"strong":F="font-weight:bold";break;case"i":case"em":F="font-style:italic";break;case"u":F="text-decoration:underline"}y='[[span style="'+(""===F?"":F+";")+x+'"]]'+K[2]+"[[/span]]",B=B.replace(K[0],y)}for(w=!1,G=0,S=(K=(B=B.replace(/\[\[/g,"<").replace(/\]\]/g,">").replace(/<span/g,"[[*]]<span").replace(/<\/span>/g,"</span>[[*]]")).split("[[*]]")).length;G<S;G++)if(""!==K[G]){if(r=c.C2,Y=c.sFontWeight,X=c.N5,M=c.QT,L=c.DG,H=c.GH,N=c.FI,P=c.K8,D=K[G],C=/<span style=(.+?)>(.+?)<\/(.+?)>/.exec(K[G]))for(D=C[2],O=0,k=(I=C[1].replace(/\'|"/g,"").split(/;|:/)).length;O<k-1;O+=2)switch(ZC.GV(I[O])){case"font-size":L=ZC._i_(ZC.GV(I[O+1]));break;case"font-family":H=ZC.GV(I[O+1]);break;case"font-weight":Y=ZC.GV(I[O+1]);break;case"font-style":-1!==ZC.AV(["italic","oblique"],ZC.GV(I[O+1]))&&(X=!0);break;case"text-decoration":P=ZC.GV(I[O+1]);break;case"line-height":N=ZC._i_(ZC.GV(I[O+1]));break;case"color":r=ZC.AP.GC(ZC.GV(I[O+1]))}0===a&&(b=-1===N?0:ZC._x_(N-1.25*L)/2);var V={idx:a,ctx:e,i:X,fw:Y,fs:L,lh:N,ff:H,c:r,t:D,dx:t,dy:n};V.dy+=ZC._x_(b),V.dy+=w||c.isBold(Y)||M?2:0,c.paintCANVASText(V),w=X,E++,t+=ZC.Q.A43(this.H.K,D,H,L,Y,N)}null!==ZC._n_(N)&&null!==ZC._n_(L)&&(b+=-1===N?1.25*L:N)}else c.paintCANVASText({idx:a,ctx:e,i:c.N5,fw:c.sFontWeight,fs:c.DG,lh:c.FI,ff:c.GH,c:c.C2,t:T[a],dx:t,dy:n+b}),b+=-1===c.FI?1.25*c.DG:c.FI}}else e.drawImage(ZC.CanvasCache[c.K],c.iX+c.BM,c.iY+c.BH);J&&(c.A9-=.5);break;case"vml":switch(n=0,c.JX){case"top":n-=(c.F-c.KA)/2;break;case"bottom":n+=(c.F-c.KA)/2}var R=ZC.Q.F5("zcv:line"),W=c.iX+c.BM+c.I/2,U=c.iY+c.BH+c.F/2,j=ZC.EH(c.A9)*(c.I-c.EQ-c.FN)/2,q=ZC.EP(c.A9)*(c.I-c.EQ-c.FN)/2,$=ZC._i_(W-j-ZC.EH(90-c.A9)*n),ee=ZC._i_(U-q+ZC.EP(90-c.A9)*n),ie=ZC._i_(W+j-ZC.EH(90-c.A9)*n),te=ZC._i_(U+q+ZC.EP(90-c.A9)*n);$===ie&&($-=.01,ie+=.01),ee===te&&(ee-=.01,te+=.01),r=c.C2,0!==c.A9&&c.C6<1&&(r=ZC.AP.QU(r,99*(1-c.C6))),ZC.Q.G3(R,{id:c.K+"-line",from:$+"px,"+ee+"px",to:ie+"px,"+te+"px",fillcolor:r}),R.filled=!0,R.stroked=!1;var ne=ZC.Q.F5("zcv:path");ne.setAttribute("textpathok",!0),R.appendChild(ne);var ae=ZC.Q.F5("zcv:textpath"),le=c.AM.replace(/<br>|<br\/>|<br \/>/gi,"\n").replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,"");ZC.Q.G3(ae,{on:!0,string:le}),ZC.Q.PJ(ae,{color:r,fontWeight:c.sFontWeight,fontStyle:c.N5?"oblique":"normal",textDecoration:c.K8,fontSize:c.DG+"px",fontFamily:c.GH,"v-text-align":c.O8}),R.appendChild(ae),e.appendChild(R);break;case"svg":case"svg0":var oe=c.iX+c.EQ+c.BM,re=c.iY+c.FM+c.BH;if(o=ZC.Q.F5("text","http://www.w3.org/2000/svg"),ZC.Q.G3(o,{x:ZC._x_(oe),y:ZC._x_(re),id:c.K,"class":c.GL,opacity:c.V5}),c.E["css-display"]&&(o.style.display=c.E["css-display"],c.E["css-display"]=null),c.bRTL&&ZC.Q.G3(o,{"text-anchor":ZC.A5.browser.msie?"":"end","writing-mode":"rl",direction:"rtl","unicode-bidi":"bidi-override"}),c.A8K&&(c.H.KE.appendChild(ZC.Q.X8({id:c.K+"-clip",path:[[c.iX+c.EQ+c.AU+c.BM,c.iY+c.FM+c.AU+c.BH].join(","),[c.iX+c.I-c.FN-c.AU+c.BM,c.iY+c.FM+c.AU+c.BH].join(","),[c.iX+c.I-c.FN-c.AU+c.BM,c.iY+c.F-c.FU-c.AU+c.BH].join(","),[c.iX+c.EQ+c.AU+c.BM,c.iY+c.F-c.FU-c.AU+c.BH].join(","),[c.iX+c.EQ+c.AU+c.BM,c.iY+c.FM+c.AU+c.BH].join(",")].join(" ")})),ZC.Q.G3(o,{"clip-path":"url(#"+c.K+"-clip)"})),c.A9%360!=0&&o.setAttribute("transform","rotate("+c.A9+" "+(oe+(c.I-c.EQ-c.FN)/2)+" "+(re+(c.F-c.FM-c.FU)/2)+")"),g&&z.appendChild(o),g){ZC.Q.EU(c.K+"-float");var se=ZC.Q.F5("div");ZC.Q.PJ(se,{position:"absolute",left:0,top:0,width:c.I-c.EQ-c.FN+"px",height:c.F-c.FM-c.FU+"px",color:c.C2,fontSize:c.DG+"px",fontFamily:c.GH,fontWeight:c.sFontWeight,textDecoration:c.K8,textAlign:c.O8,fontStyle:c.N5?"italic":"normal"}),se.id=c.K+"-float",se.className="zc-style zc-html-mode",se.innerHTML=T[0],1===c.o["z-index"]?ZC.AK(c.H.K+"-top").append(se):ZC.AK(c.H.K+"-top").insertBefore(se,ZC.AK(c.H.K+"-img")),v&&c.H&&c.H.A7&&(c.o.width||c.o.height||(c.H.A7.clear(),se.style.width="",se.style.height="",c.I=ZC.A5(se).width()+c.EQ+c.FN,c.F=ZC.A5(se).height()+c.FM+c.FU,c.paint()))}else for(b=-1===c.FI?0:ZC._x_(c.FI-1.25*c.DG)/2,a=0,l=T.length;a<l;a++){switch(i=1===l?c.NM:c.cwidth(T[a])+c.FN+c.EQ,m=-1===(B=T[a]).indexOf("<")?B:B.replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,""),t=0,n=c.DG,c.O8){case"center":t=(c.I-i)/2;break;case"right":t=c.I-i}switch(c.JX){case"middle":n+=(c.F-c.KA)/2;break;case"bottom":n+=c.F-c.KA}if(E=0,B!==m){for(;K=/<(.+?)>(.*?)<\/(.+?)>/.exec(B);){switch(F="",x="",(A=/(.+?)style=(.+?)(\'|")(.*?)/.exec(K[1]))&&(x=A[2].replace(/\'|"/g,"")),K[3]){case"b":case"strong":F="font-weight:bold";break;case"i":case"em":F="font-style:italic";break;case"u":F="text-decoration:underline"}y='[[span style="'+(""===F?"":F+";")+x+'"]]'+K[2]+"[[/span]]",B=B.replace(K[0],y)}for(w=!1,G=0,S=(K=(B=B.replace(/\[\[/g,"<").replace(/\]\]/g,">").replace(/<span/g,"[[*]]<span").replace(/<\/span>/g,"</span>[[*]]")).split("[[*]]")).length;G<S;G++)if(""!==K[G]){if(r=c.C2,Y=c.sFontWeight,X=c.N5,M=c.QT,L=c.DG,H=c.GH,P=c.K8,N=c.FI,D=K[G],C=/<span style=(.+?)>(.+?)<\/(.+?)>/.exec(K[G]))for(D=C[2],O=0,k=(I=C[1].replace(/\'|"/g,"").split(/;|:/)).length;O<k-1;O+=2)switch(ZC.GV(I[O])){case"font-size":L=ZC._i_(ZC.GV(I[O+1]));break;case"font-family":H=ZC.GV(I[O+1]);break;case"font-weight":Y=ZC.GV(I[O+1]);break;case"font-style":-1!==ZC.AV(["italic","oblique"],ZC.GV(I[O+1]))&&(X=!0);break;case"text-decoration":P=ZC.GV(I[O+1]);break;case"line-height":N=ZC._i_(ZC.GV(I[O+1]));break;case"color":r=ZC.AP.GC(ZC.GV(I[O+1]))}n=L,s=ZC.Q.F5("tspan","http://www.w3.org/2000/svg"),0===E?(ZC.Q.G3(s,{x:ZC._x_(oe+t),y:ZC._x_(re+n),dy:ZC._x_(b)}),b+=-1===N?1.25*L:ZC.BQ(1.5*L,N)):ZC.Q.G3(s,{dx:w||c.isBold(Y)||M?2:0}),ZC.Q.G3(s,{color:r,fill:r}),ZC.Q.PJ(s,{fontWeight:Y,fontStyle:X?"oblique":"normal",textDecoration:P,fontSize:L+"px",fontFamily:H,dominantBaseline:"auto"});var Ae=document.createElement("span");-1!==D.indexOf("<")||-1!==D.indexOf(">")?Ae.innerText=D:Ae.innerHTML=D,D=Ae.innerText||Ae.textContent,Ae=null,s.textContent=D,o.appendChild(s),w=X,E++}}else c.bRTL&&ZC.A5.browser.msie&&(t+=i-c.EQ-c.FN),s=ZC.Q.F5("tspan","http://www.w3.org/2000/svg"),ZC.Q.G3(s,{x:ZC._x_(oe+t),y:ZC._x_(re+n),color:c.C2,fill:c.C2,dy:ZC._x_(b)}),ZC.Q.PJ(s,{fontWeight:c.sFontWeight,fontStyle:c.N5?"oblique":"normal",textDecoration:c.K8,fontSize:c.DG+"px",fontFamily:c.GH,dominantBaseline:"auto"}),s.textContent=m,o.appendChild(s),b+=-1===c.FI?1.25*c.DG:c.FI}}if(!g)if(!c.VP&&o&&z)if(c.H.G1)-1!==ZC.Q.T8(z).indexOf("zc-text")&&null===ZC._n_(c.H.G1[z.id])&&(c.H.G1[z.id]=document.createDocumentFragment()),c.H.G1[z.id]?c.H.G1[z.id].appendChild(o):z.appendChild(o);else z.appendChild(o)}},paintCANVASText:function(e){var i=this,t=e.idx,n=e.ctx,a=e.i,l=e.fw,o=e.fs,r=e.ff,s=e.c,A=e.dx,C=e.dy,c=e.t;n.save(),n.globalAlpha=i.V5;var u;if(u=(a?"italic":"normal")+" normal "+l+" "+o+"px "+r,n.font=u,n.fillStyle=s,n.textAlign="left",n.textBaseline="alphabetic",n.translate(i.iX+i.BM,i.iY+i.BH),0!==i.A9&&(n.translate(i.I/2,i.F/2),n.rotate(ZC.T1(i.A9)),n.translate(-i.I/2,-i.F/2)),n.translate(i.EQ,i.FM+o),n.translate(A,C),n.fillText(c,0,0),zingchart.DEV.CACHECANVASTEXT){var p=ZC.CanvasCache[i.K].getContext("2d");p.font=u,p.fillStyle=s,p.textAlign="left",p.textBaseline="alphabetic",p.fillText(c,i.EQ,i.FM+o+1.25*t*o)}n.restore()},EK:function(e){var i=this;if(ZC.canvas&&"canvas"===i.H.AA&&(e||(e=ZC.AK(i.H.K+"-textprint-c")),!zingchart.CANVASTEXT&&i.A9%360==0)){var t=i.Z;i.Z=e,i.VP=!0;var n=i.H.AA;i.H.AA="canvas",i.paint(),i.VP=!1,i.H.AA=n,i.Z=t}}};ZC.DN=ZC.HL.CA(DN);var Q2={$i:function(e){this.b(e);var i=this;i.CI="json",i.NZ={graphset:!0,graph:!0,"objects-bottom":!0,"objects-top":!0,maps:!0,plotarea:!0,plots:!0,guide:!0,"static":!0,"value-box":!0},i.bA11y=!1,i.P2="",i.A19=!1,i.A14="en_us",i.QP=null,i.JL="",i.UN=!1,i.RS={},i.MZ="",i.ADI={},i.QM="",i.EW="",i.M9={},i.HP=null,i.AG=[],i.LL="",i.A7=null,i.H2=null,i.D7=null,i.B8=new ZC.AAT(i),i.QJ="",i.ML=null,i.NT=[null,null,null,null],i.O7=!1,i.NF="x",i.K9=!1,i.TJ=!1,i.ABL=!1,i.A3D=!1,i.GO=!1,i.A9P={},i.NW=null,i.QS={},i.LS=!1,i.QZ=!1,i.AD3=null,i.SW=[],i.N={},i.MY=null,i.DF=null,i.UQ=0,i.A28=0,i.A4G=1,i.MF=null,i.SD="",i.AAZ="F*nStrlng4Cu$tOmLlc9nc9!",i.MA="",i.A18={},i.A0L=!1,i.AA="",i.KE=null,i.ZT=!1,i.QO=["",""],i.L3=0,i.KR=[],i.A8B=0,i.A87=0,i.AA2=!1,i.A1A="",i.A6L=!0,i.IC=null,i.QL=[],i.NS=0,i.AAQ=!1,i.SA={},i.A1K=!1,i.G1=zingchart.DEV.DOMFRAGMENTS?{}:null,i.A2H=!1,i.ST=[]},clearLabelBoxes:function(e){var i=this;if(e)for(var t=i.ST.length-1;t>=0;t--)i.ST[t].type===e&&i.ST.splice(t,1);else i.ST=[]},usc:function(){return-1!==ZC.AV(this.KR,"use_single_canvas")},mc:function(e){return e=e||"",ZC.AK(this.K+"-main-c"+(""===e?e:"-"+e))},hideCM:function(){var e;(e=ZC.AK(this.K+"-menu"))&&(e.style.display="none"),this.AA2=!1},ZV:function(){for(var e=this,i=e.NT.length,t=0;t<i;t++)if(null!==ZC._n_(e.NT[t])){switch(e.AA){case"svg":ZC.CR.VX(e.NT[t].ctx,e.NT[t].style,e.NT[t].path.join(" "),e.NT[t].filled);break;case"vml":ZC.CR.VW(e.NT[t].ctx,e.NT[t].style,e.NT[t].path.join(" "),e.NT[t].filled)}e.NT[t]=null}},A8N:function(){var s=this,i,A6,EY,A5N;ZC.LICENSE=ZC.LICENSE||zingchart.LICENSE||"",ZC.BUILDCODE=ZC.BUILDCODE||zingchart.BUILDCODE||"",ZC.LICENSEKEY=ZC.LICENSEKEY||zingchart.LICENSEKEY||"",A5N="file:"===document.location.protocol?ZC.HOSTNAME||"":document.location.hostname;var A1S=[A5N],CV=A5N.split(".");for("www"===CV[0]?A1S.push(A5N.replace("www.","")):A1S.push("www."+A5N),i=0;i<=CV.length-2;i++){for(var ABB="*",j=i;j<CV.length;j++)ABB+="."+CV[j];A1S.push(ABB)}function X6(e){if(ZC.NOABOUT&&ZC.NOABOUT instanceof Array){var i=ZC.XK.md5(ZC.A9U(ZC.A9G(e)));-1!==ZC.AV(ZC.NOABOUT,i)&&(s.ABL=!0)}}if(-1!==ZC.AV(A1S,"localhost")||-1!==ZC.AV(A1S,"127.0.0.1"))s.TJ=!0,s.A3D=!0,X6("localhost");else{var A2F=[["window.AC.Core.zflags","Q^fhx]XKoJJLnmLPUYiWUuQKAOGnuAIWrSN_ZIj_LYvS`jRkihLOSfysvRQTBtQOUUO^`SdgZUHWKDVQ[xST_SWRLyFKogwOclSB"],["window.jsNorthNine.AppIdentity","09Vczmfsf/Q5G8dRWLio+7PVG0KjUnLRqnRSPOeqf6gu/hpxK6BeHRUtuasojuRTPFQYdzNGN57nxLviTf1hV4lwaFjtbv/tA1g0W0k7AKV1g1ouow1nG/+EJLl0khmPDSKBJa8fkP70KLNtrxt5pE2yjx+IvQ40ajd/03rqqtR="]];for(i=0,A6=A2F.length;i<A6;i++)try{if(eval(A2F[i][0])===ZC.A9G(A2F[i][1])){s.TJ=!0;break}}catch(e){}for(i=0,A6=A1S.length;i<A6;i++){var A4H=ZC.XK.md5(ZC.A9U(ZC.A9G(A1S[i])));ZC.LICENSE instanceof Array&&-1!==ZC.AV(ZC.LICENSE,A4H)&&(s.TJ=!0,X6(A4H))}ZC.BUILDCODE instanceof Array&&2===ZC.BUILDCODE.length&&(EY=ZC.AD8(s.AAZ),EY=EY.replace("O","0"),s.SD=ZC.ACA(ZC.BUILDCODE[0],EY),s.SD===ZC.BUILDCODE[1]&&(s.TJ=!0,s.A3D=!0,X6(ZC.BUILDCODE[0])))}},A8S:function(){var e=this;if(null!==e.ML)ZC._todash_(e.ML),e.load();else if(null===ZC._n_(ZC.cache.data["defaults-"+e.QJ])){var i=["query-string"===e.MZ?"zcrandom="+Math.random():"",zingchart.ZCOUTPUT?"zcoutput="+e.AA:""].join("&");ZC.A5.ajax({type:"GET",url:e.QJ,dataType:"text",beforeSend:function(i){e.RS.defaults||"http-headers"!==e.MZ||i.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:i,error:function(i,t,n,a){return e.NU({name:"Network error",message:"Resource not found ("+a+")"},"URL Data loader"),!1},success:function(i){var t;try{t=JSON.parse(i),ZC.cache.data["defaults-"+e.QJ]=i}catch(n){return e.NU(n,"JSON parser"),!1}e.ML=t,ZC._todash_(e.ML),e.load()}})}else{var t;try{t=JSON.parse(ZC.cache.data["defaults-"+e.QJ])}catch(n){return e.NU(n,"JSON parser"),!1}e.ML=t,ZC._todash_(e.ML),e.load()}},load:function(e,i){var t=this;if(t.MA="load",""!==(i=i||t.QM)&&0!==i.indexOf("javascript:"))if(null===ZC._n_(ZC.cache.data["data-"+i])){var n=["query-string"===t.MZ?"zcrandom="+Math.random():"",zingchart.ZCOUTPUT?"zcoutput="+t.AA:""].join("&");ZC.A5.ajax({type:"GET",url:i,dataType:"text",beforeSend:function(e){t.RS.data||"http-headers"!==t.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:n,error:function(e,i,n,a){return t.NU({name:"Network error",message:"Resource not found ("+a+")"},"URL Data loader"),!1},success:function(i){t.data_(e,i)}})}else t.data_(e,ZC.cache.data["data-"+i]),ZC.cache.data["data-"+i]=null;else""!==t.EW?t.data_(e,t.EW):null!==t.M9&&(t.A73?t.M9=JSON.parse(JSON.stringify(t.A73)):t.A73=JSON.parse(JSON.stringify(t.M9)),t.data_(e,t.M9))},data_:function(e,i){var t=this;ZC.TS[t.K]=(new Date).getTime(),ZC.AP.A83("dataload",t)?ZC.AP.BY("dataload",t,t.FE(),i,function(i){t.load_(e,i)}):t.load_(e,i)},A4W:function(e){var i,t;if(!zingchart.DEV.RESOURCES)return[];e||(e=this.o);var n=[];if(e.graphset)for(i=0,t=e.graphset.length;i<t;i++){var a=e.graphset[i].type||"null";if(-1===ZC.AV(ZC.CHARTS,a)){for(var l in"3d"===a.substring(a.length-2)&&(a=a.substring(0,a.length-2)),ZC.EQUIV)ZC.EQUIV.hasOwnProperty(l)&&-1!==ZC.AV(ZC.EQUIV[l],a)&&(a=l);zingchart.loadModules(a),n.push(a)}}for(this.ACM(e),i=0,t=ZC.RH.length;i<t;i++)""!==ZC.GV(ZC.RH[i])&&-1===ZC.AV(ZC.WI,ZC.GV(ZC.RH[i]))&&n.push(ZC.GV(ZC.RH[i]));return n},ACM:function(e){e||(e=this.o)},load_:function(JJ,TP){var s=this,G;s.E.rawsource=zingchart.DEV.KEEPSOURCE?TP:"N/A";var DL=null;if("string"==typeof TP)try{DL=JSON.parse(TP)}catch(JA){try{DL=eval("("+TP+")")}catch(JA){return s.NU(JA,"JSON parser"),!1}}else DL=TP;null===ZC._n_(DL.graphset)&&(DL={graphset:[DL]}),s.E.source="N/A",zingchart.DEV.KEEPSOURCE&&(s.E.source=ZC.GV(JSON.stringify(DL))),zingchart.A1E(s,s.A4W(DL),function(){DL=ZC.AP.BY("dataparse",s,s.FE(),DL),zingchart.A1E(s,s.A4W(DL),function(){if(ZC.AP.BY("modulesready",s,{id:s.K}),null===ZC._n_(JJ))s.XO(DL),s.o=DL,s.A19?(s.parse(),s.paint()):s.QH(function(){s.parse(),s.paint()});else{var e=s.OQ(JJ);if(null!==e&&null!==ZC._n_(G=DL.graphset)){var i=G.length>1?G[e.L]:G[0];i.id||(i.id=e.o.id||""),s.o.graphset[e.L]=i,s.QH(function(){s.parse(JJ),s.AG[e.L].paint()})}}})})},XO:function(DL){var s=this,G,i,A6,j,J8;for(null===ZC._n_(DL.graphset)&&(DL={graphset:[DL]}),1===DL.graphset.length&&null===ZC._n_(DL.graphset[0])&&(DL.graphset=[{type:"null"}]),i=0,A6=DL.graphset.length;i<A6;i++)if(null!==ZC._n_(DL.graphset[i])){if(null!==ZC._n_(G=DL.graphset[i].shapes)){var FH=[];for(DL.graphset[i].labels=DL.graphset[i].labels||[],j=0,J8=G.length;j<J8;j++)if(G[j].generated&&G[j]["map-item"]||FH.push(G[j]),null!==ZC._n_(G[j].type)&&0===G[j].type.indexOf("zingchart."))try{var LX=G[j].options||{},EC=G[j].type+"."+(LX.name||"");LX.graphid=i;var A30=eval(EC).call(s,LX,DL,G[j]);for(var A3F in A30)A30.hasOwnProperty(A3F)&&("label"===A30[A3F].objtype?DL.graphset[i].labels.push(A30[A3F]):FH.push(A30[A3F]))}catch(e){}DL.graphset[i].shapes=FH}var A6H;if(null!==ZC._n_(A6H=DL.graphset[i].widgets))for(var AAX=s.A4O(DL,i),k=0;k<A6H.length;k++){var A36=A6H[k];if(null!==ZC._n_(A36.type)&&null!==ZC._n_(zingchart.widgets[A36.type])&&"function"==typeof zingchart.widgets[A36.type].parse)try{var BI={};ZC._cp_(A36,BI),BI.graph=AAX.graph,BI.loader={id:s.K,width:s.I,height:s.F};var o=zingchart.widgets[A36.type].parse.call(s,BI);if(null!==ZC._n_(G=o.graphs))for(j=0;j<G.length;j++)DL.graphset.push({}),ZC._cp_(G[j],DL.graphset[DL.graphset.length-1]);if(null!==ZC._n_(G=o.labels))for(null===ZC._n_(DL.graphset[i].labels)&&(DL.graphset[i].labels=[]),j=0;j<G.length;j++)DL.graphset[i].labels.push(G[j]);if(null!==ZC._n_(G=o.shapes))for(null===ZC._n_(DL.graphset[i].shapes)&&(DL.graphset[i].shapes=[]),j=0;j<G.length;j++)DL.graphset[i].shapes.push(G[j])}catch(e){}}}},AAG:function(e,i){var t=this;switch(e){case"line":return new ZC.A66(t);case"area":return new ZC.A5Z(t);case"vline":return new ZC.A9C(t);case"varea":return new ZC.A9A(t);case"bar":case"vbar":case"column":return new ZC.A2N(t);case"hbar":return new ZC.A2G(t);case"mixed":case"hmixed":case"mixed3d":for(var n=!1,a=t.o.graphset[i].series,l=0,o=a.length;l<o;l++)a[l]&&a[l].type&&-1!==a[l].type.indexOf("3d")&&(n=!0);return n?new ZC.A31(t):t.o.graphset[i].plot&&t.o.graphset[i].type&&t.o.graphset[i].plot&&t.o.graphset[i].plot.type&&-1!==t.o.graphset[i].plot.type.indexOf("3d")?new ZC.A31(t):"mixed"===e?new ZC.A58(t):new ZC.A8Q(t);case"scatter":return new ZC.A89(t);case"hscatter":return new ZC.A7F(t);case"bubble":return new ZC.A8W(t);case"hbubble":return new ZC.A84(t);case"ring":case"pie":return new ZC.A3U(t);case"nestedpie":return new ZC.A6K(t);case"radar":case"polar":return new ZC.A9Q(t);case"venn":return new ZC.AAK(t);case"bullet":case"vbullet":return new ZC.A80(t);case"hbullet":return new ZC.A82(t);case"funnel":case"vfunnel":return new ZC.A88(t);case"hfunnel":return new ZC.A86(t);case"heatmap":case"piano":return new ZC.A99(t);case"stock":return new ZC.A9X(t);case"range":return new ZC.A9N(t);case"vrange":return new ZC.ZCVRangeGraph(t);case"gauge":return new ZC.AA1(t);case"line3d":return new ZC.A8R(t);case"area3d":return new ZC.A8Z(t);case"ring3d":case"pie3d":return new ZC.A5G(t);case"bar3d":case"vbar3d":return new ZC.A90(t);case"hbar3d":return new ZC.A8T(t);case"null3d":return new ZC.A8M(t);default:return new ZC.AAJ(t)}},OQ:function(e){for(var i=this,t=0,n=i.AG.length;t<n;t++)if(i.AG[t].K===i.K+"-graph-"+e||i.AG[t].K===i.K+"-graph-id"+e||i.AG[t].K===e||t===e)return i.AG[t];return null},A4A:function(e,i){var t=this,n=ZC.A5("#"+t.K+("svg"===t.AA?"-top":"-main")),a=ZC._tx_(t.K);e-=n.offset().left,i-=n.offset().top;for(var l=null,o=0,r=t.AG.length;o<r;o++)ZC.DS(e,t.AG[o].iX,t.AG[o].iX+t.AG[o].I*a[0])&&ZC.DS(i,t.AG[o].iY,t.AG[o].iY+t.AG[o].F*a[1])&&(l=t.AG[o]);return l},A9Y:function(e){var i,t=this;if("undefined"==typeof t.E.themesloaded){void 0===e&&(e=!1),t.assign_a([["theme","LL"]]),t.o.graphset&&1===t.o.graphset.length&&null!==ZC._n_(i=t.o.graphset[0].theme)&&(t.LL=i),""===t.LL&&(t.LL="light"),t.LL=String(t.LL).replace("zingchart","classic");for(var n=t.LL.split(/\s+|;|,/),a=0,l=n.length;a<l;a++)t.B8.AAY(n[a]);t.B8.A8S(t.ML),ZC.mobile&&t.B8.AAY("mobile"),e||(t.E.themesloaded=!0)}},parse:function(e){var i,t,n,a,l,o,r=this;r.NF="x",r.E.json=ZC.GV(JSON.stringify(r.o)),ZC._cp_(r.o.layers,r.NZ),1===r.o.graphset.length&&ZC._cp_(r.o.graphset[0].layers,r.NZ);var s=r.FE();if(null!==ZC._n_(e)&&(s.graphid=e),ZC.AP.BY("dataready",r,s),r.MA="parse",r.QO[1]=r.QO[0],r.QO[0]="",r.QO[0]+=r.I+":"+r.F+":",null!==ZC._n_(i=r.o.graphset))for(r.QO[0]+=i.length+":",a=0;a<i.length;a++)r.QO[0]+=(i[a].type||"")+":",r.QO[0]+=(i[a].x||"")+":"+(i[a].y||"")+":"+(i[a].width||"")+":"+(i[a].height||"")+":",null!==ZC._n_(i[a].series)&&(r.QO[0]+=i[a].series.length+":");if(ZC.AK(r.K+"-main-c")&&r.clear(e,!1),"undefined"!=typeof ZC.A4Z&&(r.H2=new ZC.A4Z(r)),null===ZC._n_(e)){r.A9Y(),r.B8.B8["font-family"]&&(zingchart.FONTFAMILY=r.B8.B8["font-family"]);var A=!!r.o.gui;if(r.B8.load(r.o,"loader",!1,!0),r.assign_a([["gui","DF"],["globals","QP"]]),r.o.graphset&&1===r.o.graphset.length&&(t=r.o.graphset[0],null!==ZC._n_(i=t.gui)&&(r.DF=i),null!==ZC._n_(i=t.globals)&&(r.QP=i)),ZC._todash_(r.QP),ZC._cp_(r.B8.B8.root.gui,r.DF,!1,!0,!0),r.DF.behaviors)for(a=r.DF.behaviors.length-1;a>=0;a--)for(o=0;o<a;o++)if(r.DF.behaviors[a].id===r.DF.behaviors[o].id){r.DF.behaviors.splice(a,1);break}if(A||delete r.o.gui,ZC._todash_(r.DF),r.N={},null!==ZC._n_(i=r.o.style))for(n in i)"url"!==n&&(r.N[n]=i[n]);if(r.o.graphset&&1===r.o.graphset.length&&(t=r.o.graphset[0],null!==ZC._n_(i=t.style)))for(n in i)"url"!==n&&(r.N[n]=i[n]);ZC._todash_(r.N),r.NZ.graphset&&r.b(),r.assign_a([["locale","A14"],["set-locale","A14"],["layout","NF"],["h-space","A8B","i"],["v-space","A87","i"],["flat","K9","b"],["show-progress","A0L","b"]]),r.o.graphset&&1===r.o.graphset.length&&(t=r.o.graphset[0],null!==ZC._n_(i=t.locale)&&(r.A14=i),null!==ZC._n_(i=t["set-locale"])&&(r.A14=i),null!==ZC._n_(i=t.flat)&&(r.K9=ZC._b_(i)),null!==ZC._n_(i=t["show-progress"])&&(r.A0L=ZC._b_(i))),null!==ZC._n_(i=zingchart.i18n[r.A14])&&(ZC.HJ=i),r.AG=[]}var C=0,c=0,u=r.I,p=r.F;if(null!==ZC._n_(r.o.margin)||null!==ZC._n_(r.o["margin-top"])||null!==ZC._n_(r.o["margin-right"])||null!==ZC._n_(r.o["margin-bottom"])||null!==ZC._n_(r.o["margin-left"])){var Z=new ZC.HL(r);Z.append(r.o,!1,!1),Z.parse(),C=Z.DY,c=Z.E8,u=u-Z.DY-Z.E9,p=p-Z.E8-Z.DR}var h,d,f=r.OQ(e);if(null!==ZC._n_(h=r.o.graphset)){var _=0;for(a=0,l=h.length;a<l;a++)d=0,null!==ZC._n_(i=h[a].page)&&(d=ZC._i_(i)),_+=r.L3===d?1:0;var g=ZC.AQ.A2C(r.NF,_),v=ZC._i_(g[0]),b=ZC._i_(g[1]),B=0,m=0,E=0;for(a=0,l=h.length;a<l;a++){if(d=0,null===f&&null!==ZC._n_(i=h[a].page)&&(d=ZC._i_(i)),(null===f||E===f.L)&&r.L3===d){if(r.AG[E]=r.AAG(h[a].type||"null",a),r.AG[E].OG=r.AG[E].AF+"graph",r.B8.load(r.AG[E].o,"graph"),r.B8.load(r.AG[E].o,h[a].type||"null"),r.AG[E].append(r.o.graph),r.AG[E].append(h[a]),r.AG[E].L=E,null===ZC._n_(h[E].id)||""===h[E].id?r.AG[E].K=r.K+"-graph-id"+E:r.AG[E].K=r.K+"-graph-"+h[a].id,h.length>0){for(var D=0,K=0,F=ZC._i_((u-(b+1)*r.A8B)/b),x=ZC._i_((p-(v+1)*r.A87)/v),I=["x","y","width","height"],y=0;y<I.length;y++)null!==ZC._n_(r.E["graph-"+E+"-"+I[y]])&&(delete r.E["graph-"+E+"-"+I[y]],delete r.AG[E].o[I[y]]);null===ZC._n_(r.AG[E].o.x)?r.E["graph-"+E+"-x"]=r.AG[E].o.x=ZC._i_(r.iX+(B+1)*r.A8B+B*F)+C:(D=ZC.II(r.AG[E].o.x))<1&&(D=ZC._i_(r.I*D)),null===ZC._n_(r.AG[E].o.y)?r.E["graph-"+E+"-y"]=r.AG[E].o.y=ZC._i_(r.iY+(m+1)*r.A87+m*x)+c:(K=ZC.II(r.AG[E].o.y))<1&&(K=ZC._i_(r.F*K)),null===ZC._n_(r.AG[E].o.width)&&(r.E["graph-"+E+"-width"]=r.AG[E].o.width=Math.max(F,F-D)),null===ZC._n_(r.AG[E].o.height)&&(r.E["graph-"+E+"-height"]=r.AG[E].o.height=Math.max(x,x-K))}r.AG[E].parse()}r.L3===d&&(E++,++B===b&&(m++,B=0))}}null===ZC._n_(e)&&null!==ZC._n_(i=r.o.refresh)&&(r.HP={type:"full",interval:10},ZC._cp_(i,r.HP))},A41:function(e,i){i=i||"";var t=[];for(var n in e)if("object"==typeof e[n])for(var a=this.A41(e[n],i+"."+n),l=0,o=a.length;l<o;l++)-1===ZC.AV(t,a[l])&&t.push(a[l]);else{var r=i+"."+n;"background-image"!==n&&"backgroundImage"!==n||""===e[n]||"zc."===e[n].substring(0,3)||(!ZC.ie67&&ZC.PATTERNS&&"PATTERN_"===e[n].substring(0,8)&&(e[n]=ZC.PATTERNS[e[n].substring(8)]),"!"===e[n].charAt(0)&&(e[n]=e[n].substring(1),this.E["safe-images"]=this.E["safe-images"]||[],this.E["safe-images"].push(e[n])),t.push([e[n],"image"])),"src"===n&&""!==e[n]&&"zc."!==e[n].substring(0,3)&&-1!==r.indexOf(".images.")&&(!ZC.ie67&&ZC.PATTERNS&&"PATTERN_"===e[n].substring(0,8)&&(e[n]=ZC.PATTERNS[e[n].substring(8)]),"!"===e[n].charAt(0)&&(e[n]=e[n].substring(1),this.E["safe-images"]=this.E["safe-images"]||[],this.E["safe-images"].push(e[n])),t.push([e[n],"image"])),".csv"===r.substr(r.length-4,4)&&"string"==typeof e[n]&&t.push([e[n],"csv"]),"url"===n&&(-1!==r.indexOf(".style.")&&t.push([e[n],"css"]),-1!==r.indexOf(".csv.")&&t.push([e[n],"csv"]),-1!==r.indexOf(".marker.")&&t.push([e[n],"image"])),"string"==typeof e[n]&&"url"!==n&&(0===e[n].indexOf("url:")&&"values"===n||0===e[n].indexOf("javascript:"))&&-1===ZC.AV(["format","text","tooltipText"],ZC.EE(n))&&t.push([e[n],"data"])}return t},QH:function(J7){var s=this;if(zingchart.DEV.RESOURCES){var J4=s.A41(s.o).concat(s.A41(s.ML));if(0!==J4.length){var UQ=0,LH={},A1W=0;s.E["safe-images"]=s.E["safe-images"]||[];var C4=window.setInterval(function(){if(UQ>=J4.length){for(var e in window.clearInterval(C4),s.ABM(s.o),LH)if(0!==e.indexOf("data:")&&-1===ZC.AV(s.E["safe-images"],e))try{var i=document.createElement("canvas");i.width=LH[e].width,i.height=LH[e].height,i.getContext("2d").drawImage(LH[e],0,0);var t=i.toDataURL("image/png");LH[e].onload=null,LH[e].onerror=null,LH[e].src=t,ZC.cache.data[e]=LH[e]}catch(n){}window.setTimeout(function(){zingchart.XZ[s.K]&&J7()},1)}else A2Q(++A1W)},20);A2Q(A1W)}else zingchart.XZ[s.K]&&J7()}else zingchart.XZ[s.K]&&J7();function A2Q(i){if(!(i>=J4.length)){var EW,MG,KD=J4[i][0],A0I=J4[i][1];if("url:"===KD.substring(0,4)){var QM=KD.substring(4);s.QS["url:"+QM]="[]";try{EW=["query-string"===s.MZ?"zcrandom="+Math.random():""].join("&"),ZC.A5.ajax({type:"GET",url:QM,beforeSend:function(e){s.RS.data||"http-headers"!==s.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,i,t,n){return s.NU({name:"Network error",message:"Resource not found ("+n+")"},"URL Data loader"),!1},success:function(e,i,t,n){s.QS["url:"+n]=e,UQ++}})}catch(JA){return s.NU(JA,"URL Data loader"),!1}}else if("javascript:"===KD.substring(0,11))if("zc.ext.load"===s.QS[KD]){s.QS[KD]="[]";var DW=ZC.AP.AAH(KD.substring(11)),O={id:s.K,resource:KD,callback:function(e){s.QS[KD]=e,UQ++}},ZY=DW[0];O.arguments=DW[1];try{var ZN=eval(ZY).call(s,O);null!==ZC._n_(ZN)&&ZN&&(s.QS[KD]=ZN,UQ++)}catch(JA){return s.NU(JA,"JavaScript data loader"),!1}}else UQ++;else"image"===A0I?(LH[KD]=new Image,LH[KD].crossOrigin="anonymous",LH[KD].onload=function(){UQ++},LH[KD].onerror=function(){var e=ZC._b_(s.o.strict);if(ZC.IMG404.push(KD),e)return s.NU({name:"Network error",message:"Resource not found ("+this.src+")"},"Resource loader (image)"),!1;this.src=ZC.BLANK,UQ++},LH[KD].src=KD,ZC.cache.data[KD]=LH[KD]):"css"===A0I?(EW=["query-string"===s.MZ?"zcrandom="+Math.random():""].join("&"),ZC.A5.ajax({type:"GET",url:KD,beforeSend:function(e){s.RS.css||"http-headers"!==s.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,i,t){return s.NU(t,"Resource loader"),!1},success:function(e){for(var i={},t=e.match(/[a-zA-Z0-9\.\#\-](.+?)\{((.|\s)+?)\}/gi),n=0,a=t.length;n<a;n++){MG=t[n].split("{");var l=ZC.GV(MG[0]),o=l.split(/\s+/);if(1===o.length||2===o.length&&ZC.GV(o[0])==="#"+s.K){i[l=ZC.GV(1===o.length?o[0]:o[1])]||(i[l]={});for(var r=0,A=(MG=MG[1].replace("}","").split(";")).length;r<A;r++){var C=MG[r].split(":");2===C.length&&(i[l][ZC.GV(C[0])]=""+ZC.GV(C[1]))}}}null!==ZC._n_(s.o.style)?ZC._cp_(i,s.o.style):null!==ZC._n_(s.o.graphset)&&1===s.o.graphset.length&&s.o.graphset[0].style&&ZC._cp_(i,s.o.graphset[0].style),UQ++}})):"csv"===A0I&&(EW=["query-string"===s.MZ?"zcrandom="+Math.random():""].join("&"),ZC.A5.ajax({type:"GET",url:KD,beforeSend:function(e){s.RS.csv||"http-headers"!==s.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,error:function(e,i,t){return s.NU(t,"Resource loader"),!1},success:function(e,i,t,n){s.A9P[n]=e,UQ++}}))}}},ABM:function(C0){var s=this;for(var p in C0)if("object"==typeof C0[p])s.ABM(C0[p]);else for(var EW in s.QS)EW===C0[p]&&(C0[p]=eval(s.QS[EW]))},resize:function(e){var i,t,n,a,l=this;if(l.E.resize=!0,l.E.wh=l.I+"/"+l.F,l.o.graphset)if(l.A1K)zingchart.exec(l.K,"destroy"),zingchart.render(zingchart.params[l.K]);else{for(void 0===e&&(e=!1),t=0;t<l.AG.length;t++)null!==ZC._n_(l.H2)&&l.H2.IM&&l.H2.TZ(null),null!==ZC._n_(l.AG[t].HS)&&l.AG[t].HS.IM&&l.AG[t].HS.M7(null),null!==ZC._n_(l.AG[t].HQ)&&l.AG[t].HQ.IM&&l.AG[t].HQ.M7(null),null!==ZC._n_(l.AG[t].B9)&&l.AG[t].B9.A3X&&l.AG[t].B9.TH();if(ZC.AP.BY("resize",l,l.FE()),e=!1);else{for(t=0;t<l.AG.length;t++)for(a=0;a<l.AG[t].AY.A4.length;a++)l.E["g-"+t+"-p-"+a+".visible"]=l.AG[t].E["plot"+a+".visible"];for(t=0;t<l.AG.length;t++)l.E["g-"+l.AG[t].L+"-selection"]=JSON.stringify(l.AG[t].CB);for(var o=l.o.graphset,r=["labels","shapes"],s=0,A=o.length;s<A;s++)for(var C=0;C<r.length;C++){var c=r[C],u=[];if(null!==ZC._n_(o[s][c])){for(t=0,n=o[s][c].length;t<n;t++)o[s][c][t].generated||u.push(o[s][c][t]);o[s][c]=u}}if(l.XO(l.o),l.o=ZC.AP.BY("dataparse",l,l.FE(),l.o),ZC.A5("#"+l.K+"-top").width(l.I).height(l.F),l.E["from-api"]&&(ZC.A5("#"+l.K+"-wrapper").width(l.I).height(l.F),delete l.E["from-api"]),1===(i=ZC.A5("#"+l.K+"-img")).length&&i.width(l.I).height(l.F).css("clip","rect(1px,"+(l.I-1)+"px,"+(l.F-1)+"px,1px)"),"svg"===l.AA&&(l.KE.setAttribute("width",l.I),l.KE.setAttribute("height",l.F)),"canvas"===l.AA||"vml"===l.AA){for(ZC.A5("#"+l.K+"-main").width(l.I).height(l.F),t=0,n=l.AG.length;t<n;t++)ZC.A5("#"+l.AG[t].K+"-hover").remove();ZC.A5("#"+l.K+"-main>div").width(l.I).height(l.F)}for("canvas"===l.AA&&((i=ZC.AK(l.K+"-main-c"))&&(i.width=l.I,i.height=l.F),(i=ZC.AK(l.K+"-main-c-top"))&&(i.width=l.I,i.height=l.F),ZC.A5("#"+l.K+"-objects-bottom canvas, #"+l.K+"-objects-top canvas, #"+l.K+"-tools canvas").each(function(){this.width=l.I,this.height=l.F})),"vml"===l.AA&&ZC.A5("#"+l.K+"-objects-bottom div, #"+l.K+"-objects-top div, #"+l.K+"-tools div").each(function(){this.style.width=l.I+"px",this.style.height=l.F+"px"}),l.parse(),t=0,n=l.AG.length;t<n;t++)l.AG[t].U5&&l.AG[t].U5(),l.AG[t].HH=!0,l.AG[t].A6A=l.AG[t].GG,l.AG[t].GG=!1;for(l.paint(),t=0;t<l.AG.length;t++)for(a=0;a<l.AG[t].AY.A4.length;a++)delete l.E["g-"+t+"-p-"+a+".visible"];for(t=0;t<l.AG.length;t++)l.AG[t].HH=!1,l.AG[t].GG=l.AG[t].A6A,delete l.AG[t].A6A,delete l.E["g-"+l.AG[t].L+"-selection"]}}},clearGenerated:function(){var e=this.o.graphset,i=["labels","shapes"];if(e)for(var t=0,n=e.length;t<n;t++)for(var a=0;a<i.length;a++){var l=i[a],o=[];if(null!==ZC._n_(e[t][l])){for(var r=0,s=e[t][l].length;r<s;r++)e[t][l][r].generated||o.push(e[t][l][r]);e[t][l]=o}}},clear:function(e,i,t){var n=this;for(var a in n.E)-1!==a.indexOf("-label-")&&-1!==a.indexOf("-bounds")&&delete n.E[a];if(void 0===i&&(i=!0),ZC.A5("."+n.K+"-history-area").die("click",n.A0Q),ZC.A5("."+n.K+"-history-area").remove(),null!==ZC._n_(e))n.OQ(e).clear();else{i&&n.clearGenerated(),n._unbind_();for(var l=0,o=n.AG.length;l<o;l++)"vml"===n.AA&&t?n.AG[l].destroy():n.AG[l].clear();var r,s,A;null!==(r=ZC.AK(n.K+"-main-c"))&&ZC.Q.IU(r,n.AA,n.iX,n.iY,n.I,n.F),null!==(A=ZC.AK(n.K+"-main-c-top"))&&ZC.Q.IU(A,n.AA,n.iX,n.iY,n.I,n.F),null!==(s=ZC.AK(n.K+"-trigger-c"))&&(ZC.Q.IU(s,n.AA,n.iX,n.iY,n.I,n.F),ZC.A5("#"+n.K+"-menu-area").remove()),n.A7&&n.A7.hide(),ZC.A5("."+n.K+"-menu-item").remove(),ZC.Q.EU([n.K+"-menu-trigger",n.K+"-menu"]),ZC.Q.EU(n.K+"-license-text"),null!==n.IC&&ZC.Q.EU([n.K+"-history-path",n.K+"-history-back-path",n.K+"-history-forw-path",n.K+"-history-gradient",n.K+"-history-back-gradient",n.K+"-history-forw-gradient"])}},AAS:function(){var e,i,t,n=this,a=n.I+"/"+n.F,l=ZC.Q.HY({id:n.K+"-wrapper",position:"relative",p:ZC.AK(n.K)});ZC.Q.PJ(l,{height:"100%"===n.MT?n.MT:n.F+"px",width:"100%"===n.FZ?n.FZ:n.I+"px"}),n.bA11y&&ZC.Q.G3(l,{tabindex:0,"aria-label":"ZingChart "+n.P2});var o=ZC.Q.HY({cls:"zc-rel zc-top",wh:a,id:n.K+"-top",overflow:"hidden",position:"absolute",p:l});switch(zingchart.OFFSET&&(o.style.left="-0.5px",o.style.top="-0.5px"),n.AA){case"svg":n.KE=ZC.Q.F5("svg","http://www.w3.org/2000/svg"),n.KE.setAttributeNS&&n.KE.setAttributeNS(null,"xlink","http://www.w3.org/1999/xlink"),ZC.Q.G3(n.KE,{version:"1.1",id:n.K+"-svg","class":"zc-svg",width:n.I,height:n.F,display:"block"}),o.appendChild(n.KE);var r=ZC.Q.F5("defs","http://www.w3.org/2000/svg");if(r.id=n.K+"-defs",n.KE.appendChild(r),ZC.Q.JZ({cls:"zc-rel zc-main",wh:a,id:n.K+"-main",p:n.KE},n.AA),n.A24=[],n.o.graphset)for(e=0,i=n.o.graphset.length;e<i;e++)if((t=n.o.graphset[e].resources)&&t.length)for(var s=0;s<t.length;s++)if("css"===t[s].type&&t[s].url){var A=ZC.Q.F5("link","http://www.w3.org/2000/svg");ZC.Q.G3(A,{xmlns:"http://www.w3.org/1999/xhtml",href:t[s].url,rel:"stylesheet",type:"text/css"}),n.A24.push(t[s].url),r.appendChild(A)}break;case"vml":case"canvas":ZC.Q.HY({cls:"zc-rel zc-main",wh:a,id:n.K+"-main",p:o})}},paintHistory:function(){},paint:function(){var e=this;e.MA="paint";var i=e.I+"/"+e.F;if(e.A0C(),null===ZC.AK(e.K+"-top")){e.AAS();var t=ZC.AK(e.K+"-main");if(e.NZ.graphset&&ZC.Q.HC({cls:"zc-abs",id:e.K+"-main-c",wh:i,p:t},e.AA),e.H.usc())ZC.Q.HC({cls:"zc-abs",id:e.K+"-main-c-top",wh:i,p:t},e.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-print-c",p:t,wh:i,display:"none"},e.AA);else{ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-bottom",p:t},e.AA),zingchart.DEV.MAPSONBOTTOM&&ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-maps",p:t},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-graphset",p:t},e.AA),zingchart.DEV.MAPSONBOTTOM||ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-maps",p:t},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-top",p:t},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-hover",p:t},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-front",p:t},e.AA),ZC.Q.JZ({cls:"zc-abs zc-text",wh:i,id:e.K+"-text",p:t},e.AA);var n="legend",a="tools";("legend"===e.o["top-layer"]||e.o.graphset&&1===e.o.graphset.length&&"legend"===e.o.graphset[0]["top-layer"])&&(n="tools",a="legend"),ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-"+n,p:t},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-"+a,p:t},e.AA);var l=ZC.AK(e.K+"-tools");e.NZ["static"]&&ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-static-c",wh:i,p:l},e.AA),e.NZ.guide&&ZC.Q.HC({cls:"zc-abs zc-layer zc-guide-c",id:e.K+"-guide-c",wh:i,p:l},e.AA),(ZC.A5.browser.opera&&ZC._i_(ZC.A5.browser.version)<=9.5||ZC.mobile||"classic"!==e.LL)&&ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-trigger-c",wh:i,p:l},e.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-print-c",p:l,wh:i,display:"none"},e.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-textprint-c",p:l,wh:i,display:"none"},e.AA),ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-text-top",p:t},e.AA)}if(!zingchart.DEV.SKIPTRACKERS){var o=document.createElement("img");if(o.id=e.K+"-img",o.className="zc-img",o.setAttribute("useMap","#"+e.K+"-map"),o.setAttribute("alt","ZingChart "+e.P2),ZC.Q.PJ(o,{position:"absolute",borderWidth:0,width:e.I+2*ZC.MAPTX+"px",height:e.F+2*ZC.MAPTX+"px",left:-ZC.MAPTX+"px",top:-ZC.MAPTX+"px",zIndex:0,opacity:0,filter:"alpha(opacity=0)",clip:"rect("+(ZC.MAPTX+1)+"px,"+(e.I+ZC.MAPTX-1)+"px,"+(e.F+ZC.MAPTX-1)+"px,"+(ZC.MAPTX+1)+"px)"}),o.src=(ZC.ie67?"//":"")+ZC.BLANK,ZC.AK(e.K+"-top").appendChild(o),!e.H.usc()){var r=document.createElement("map");r.className="zc-map",ZC.Q.G3(r,{id:e.K+"-map",name:e.K+"-map"}),ZC.AK(e.K+"-top").appendChild(r);for(var s=0;s<e.AG.length;s++)r.innerHTML+='<area shape="rect" coords="0,0,1,1" id="mark'+s+'">'}}}e.Z=ZC.AK(e.K+"-main-c"),e.b();var A,C,c=!1,u=!1;for(A=0,C=e.AG.length;A<C;A++){e.AG[A].paint(),(null!==e.AG[A].CX&&e.AG[A].CX.AN||null!==e.AG[A].HA&&e.AG[A].HA.AN)&&(c=!0);for(var p=0;p<e.AG[A].BO.length;p++)if(e.AG[A].BO[p].GO){u=!0;break}}if(e.G1){for(var Z in e.G1)ZC.AK(Z).appendChild(e.G1[Z]);e.G1=null}if(e.E.preservezoom=null,e.TJ||e.UN||(e.Z3?e.A91():e.Z3=window.setInterval(function(){e.A8N(),e.TJ||e.UN?(window.clearInterval(e.Z3),ZC.Q.EU(e.K+"-license-text")):ZC.AK(e.K+"-license-text")||e.A91()},2e3)),ZC.A5("."+e.K+"-node-area").live("focus",function(e){var i=e.target.id.split("-");"plot"===i[4]&&"node"===i[6]&&zingchart.exec(i[0],"showtooltip",{graphid:i[2],plotindex:i[5],nodeindex:i[7]})}),-1===ZC.AV(e.KR,"skip_context_menu")&&e.A5T(),-1===ZC.AV(e.KR,"skip_interactivity")?("undefined"!=typeof ZC.A27&&(e.A7=new ZC.A27(e)),u&&e.H2.bind(),c&&"undefined"!=typeof ZC.JS&&(e.D7=new ZC.JS(e),e.D7.bind()),ZC.mobile&&(e.AFW=function(i){ZC.swipe={xy:ZC.Q.MB(i),ts:(new Date).getTime()},i.target.id===e.K+"-menu-area"?(ZC.move=!1,e.A7&&e.A7.hide(),zingchart.YS(i)):(null===e.DF||null===ZC._n_(e.DF["page-scroll"])||e.DF["page-scroll"]||i.preventDefault(),ZC.move=!1,e.hideCM(),e.A7&&e.A7.hide(),e.YI(i))},e.OU=function(){window.clearTimeout(e.AAW),e.A3S=null},e.AFT=function(i){if(ZC.swipe){var t=ZC.Q.MB(i);if(ZC._a_(t[0]-ZC.swipe.xy[0])>100&&(new Date).getTime()-ZC.swipe.ts<1e3){var n=e.FE();n.direction=t[0]>ZC.swipe.xy[0]?"right":"left",ZC.AP.BY("swipe",e,n)}ZC.swipe=null}e.AA2||ZC.move||zingchart.SB(i),e.OU(i)},ZC.A5("#"+e.K+"-img").bind("touchstart",e.AFW).bind("touchmove",e.OU).bind("touchend",e.AFT),ZC.A5("#"+e.K+"-menu-area").live("touchstart",e.AFW)),e.zc_loader_mousewheel=function(i){var t=e.FE();t.ev=i,ZC.AP.BY("mousewheel",e,t)},ZC.A5("#"+e.K+"-img").bind("mousewheel",e.zc_loader_mousewheel),ZC.A5("#"+e.K+"-map").bind("mousewheel",e.zc_loader_mousewheel),"svg"===e.AA&&ZC.A5("#"+e.K+"-svg").bind("mousewheel",e.zc_loader_mousewheel),e.A25=function(i){27===i.keyCode&&e.QZ&&(e.A7S||e.A95())},ZC.A5(document).bind("keyup",e.A25),e.A95=function(){ZC.A5("#"+e.K+"-menu-item-exitfullscreen").die("click",e.A95),ZC.FSSTATUS=null,ZC.Q.EU(e.K+"-data-table"),e.destroy(),zingchart.FSID&&ZC.AK(zingchart.FSID)&&(ZC.AK(zingchart.FSID).style.display="none")},ZC.A5("#"+e.K+"-menu-item-exitfullscreen").live("click",e.A95)):ZC.mobile&&(e.zc_loader_touchstart_static=function(e){return e.preventDefault(),zingchart.SB(e),!1},ZC.A5("#"+e.K+"-img").bind("touchstart",e.zc_loader_touchstart_static)),null!==e.HP){var h=ZC._i_(e.HP.interval);h=h>=50?h:1e3*h,window.setTimeout(function(){e.N3(),e.load()},h)}e.MA="",ZC.TS[e.K]=(new Date).getTime()-ZC.TS[e.K],e.E["fire-complete"]&&(ZC.AP.BY("complete",e,e.FE()),e.E["fire-complete"]=null),e.E["fire-load"]&&(ZC.AP.BY("load",e,e.FE()),e.E["fire-load"]=null)},togglePreviewMasks:function(e){for(var i=this,t=0;t<i.AG.length;t++)i.AG[t].B9&&i.AG[t].B9.toggleMasks(e)},createPreviewMasks:function(){var e=this,i=document.createElement("canvas");i.width=e.I,i.height=e.F,i.setAttribute("class","");for(var t=0;t<e.AG.length;t++)e.AG[t].B9&&e.AG[t].B9.toggleMasks(!0,i);return i},AGC:function(){null===ZC._n_(ZC.showZCAbout)&&(ZC.showZCAbout=function(e){zingchart.exec(e.id,"toggleabout")}),zingchart.exec(this.K,"addmenuitem",{text:"About ZingChart","function":"ZC.showZCAbout()",order:100})},A91:function(){var e,i=this,t={},n=i.DF.watermark;i.B8.load(t,"loader.gui.watermark"),n&&ZC._cp_(n,t),1===i.o.graphset.length&&i.o.graphset[0].gui&&(e=i.o.graphset[0].gui.watermark)&&ZC._cp_(e,t);var a=ZC._l_(ZC._i_(t.type||1),1,2),l=t.position||"br";-1===ZC.AV(["tl","tr","br","bl"],l)&&(l="br"),i.ACS=l;var o,r=32,s=146,A=0,C=1;ZC.ie67&&(r=30,s=168,A=8,C=1),s=126,r=22;var c={light:["#6D6E71","#00384A"],dark:["#FFFFFF","#09A9DA"]},u=c.light;if(zingchart.THEME&&(u="light"===i.LL||"classic"===i.LL?c.light:c.dark),1===i.o.graphset.length)if(i.o.graphset[0]["background-color"]){var p=ZC.AP.GC(i.o.graphset[0]["background-color"]);7===p.length&&(u=ZC.AP.AA9(p,c.dark,c.light))}else if(i.o.graphset[0].theme){var Z=i.o.graphset[0].theme;u="light"===Z||"classic"===Z?c.light:c.dark}var h,d,f="undefined"!=typeof window&&window.location?window.location.origin:"",_="undefined"!=typeof window&&window.location?window.location.pathname:"";switch(o='<a title="JavaScript Charts by ZingChart" style="color:'+u[0]+' !important;font-size:11px !important;display:block !important;opacity:1 !important; text-decoration:none;" href="http://www.zingchart.com/?origin='+f+"&pathname="+_+'">Powered by <span style="color:'+u[1]+'; font-weight:bold;">ZingChart</span></a>',l){case"br":h=i.F-r,d=i.I-s;break;case"bl":h=i.F-r,d=6;break;case"tr":h=2,d=i.I-s;break;case"tl":h=2,d=6}null!==ZC._n_(e=ZC.AK(i.K+"-top"))&&ZC.Q.HY({cls:ZC.ie67?"-ie67":"",p:e,id:i.K+"-license-text",tl:h+"/"+d,wh:s+"/"+(r-A),color:ZC.ie67?1===a?"#369":"#fff":"",padding:A,opacity:C,position:"absolute",cursor:"pointer",fontFamily:zingchart.FONTFAMILY,html:o})},_unbind_:function(){var e=this;ZC.A5("#"+e.K+"-menu").die("mousedown",e.TM),ZC.A5("."+e.K+"-menu-item").die("mousedown",e.TM),ZC.A5("."+e.K+"-menu-item").die("click touchend",e.AGR).die("mouseover",e.AG8).die("mouseout",e.AGN),e.E["menu-item-events"]=!1,ZC.A5("."+e.K+"-node-area").die("focus"),null!==e.H2&&e.H2.unbind(),null!==e.D7&&e.D7.unbind(),ZC.mobile&&(ZC.A5("#"+e.K+"-img").unbind("touchstart",e.AFW).unbind("touchmove",e.OU).unbind("touchend",e.AFT),ZC.A5("#"+e.K+"-menu-area").die("touchstart",e.AFW),ZC.A5("#"+e.K+"-img").unbind("touchstart",e.zc_loader_touchstart_static)),ZC.A5("#"+e.K+"-img").unbind("mousewheel",e.zc_loader_mousewheel),ZC.A5("#"+e.K+"-map").unbind("mousewheel",e.zc_loader_mousewheel),"svg"===e.AA&&ZC.A5("#"+e.K+"-svg").unbind("mousewheel",e.zc_loader_mousewheel),ZC.A5(document).unbind("keyup",e.A25),ZC.A5("#"+e.K+"-menu-item-exitfullscreen").die("click",e.A95)},VL:function(e,i,t){void 0===t&&(t=!1);var n=ZC.AK("zc-menu-"+(t?"sep":"item")+"-"+e);n&&(n.style.display=i?"block":"none")},A5T:function(LC,ev){if(!zingchart.DEV.SKIPCONTEXTMENU){var s=this,G,i,A6,j,J8;void 0===LC&&(LC=-1);var DF={};ZC._cp_(s.DF,DF),-1!==LC&&s.o.graphset[LC]&&ZC._cp_(s.o.graphset[LC].gui,DF,null,null,!0),ZC.A5("#"+s.K+"-menu").remove();var PF=[];for("undefined"==typeof ZC.AO&&PF.push({id:"3D",enabled:"none"},{id:"SwitchTo3D",enabled:"none"},{id:"SwitchTo2D",enabled:"none"}),i=DF.behaviors.length-1;i>0;i--)for(var sBId=DF.behaviors[i].id,ii=i-1;ii>=0;ii--)DF.behaviors[ii].id===sBId&&DF.behaviors.splice(ii,1);if(null!==ZC._n_(G=DF.behaviors))for(i=0,A6=G.length;i<A6;i++){var N9=!1;for(j=0,J8=PF.length;j<J8;j++)PF[j].id===G[i].id&&(N9=!0);N9||PF.push(G[i])}var JH=DF["context-menu"],OI=DF["context-menu[mobile]"];for(i=0,A6=PF.length;i<A6;i++)null!==ZC._n_(PF[i]["function"])&&(null===ZC._n_(JH)&&(JH={}),null===ZC._n_(JH["custom-items"])&&(JH["custom-items"]=[]),JH["custom-items"].push(PF[i]));JH["custom-items"]&&JH["custom-items"].sort(function(e,i){return ZC._i_(e.order||"0")>ZC._i_(i.order||"0")}),s.MY=new ZC.DN(s);var A15=s.LL.split(/\s+|;|,/),E0,LB,U7,ABA,GS;for(i=0,A6=A15.length;i<A6;i++)if(s.B8.NY[A15[i]]){var A10=s.B8.NY[A15[i]].root||{};A10&&A10.gui&&A10.gui.contextMenu&&ZC._cp_(A10.gui.contextMenu,s.MY.o)}if(s.B8.load(s.MY.o,"loader.gui.context-menu"),JH&&s.MY.append(JH),ZC.mobile&&(s.B8.load(s.MY.o,"loader.gui.context-menu[mobile]"),OI&&s.MY.append(OI)),s.MY.V2=!0,s.MY.parse(),s.MY.AN||!s.A3D){if(!ZC.AK(s.K+"-menu-area")){var A55=!!(s.DF&&s.DF["context-menu"]&&s.DF["context-menu"].button)&&ZC._n_(s.DF["context-menu"].button.visible);if(A55||"classic"!==s.LL&&A55){GS=new ZC.DN(s),s.B8.load(GS.o,"loader.gui.context-menu.button"),JH&&ZC._n_(null!==(G=JH.button))&&GS.append(G),ZC.mobile&&(s.B8.load(GS.o,"loader.gui.context-menu[mobile].button"),OI&&null!==ZC._n_(G=OI.button)&&GS.append(G)),ZC._cp_(s.MY.o,JH);var A6E="left"===JH.position||"classic"===s.LL;if(GS.K=s.K+"-menu-trigger",GS.IL=ZC.AK(s.K+"-tools"),GS.Z=GS.C7=ZC.AK(s.K+"-trigger-c"),GS.V2=!0,GS.parse(),GS.AN){GS.paint();var DD=ZC.A5("#"+s.H.K+"-top");if(""===GS.AM){var N0=new ZC.DT(s);if(N0.CZ=!1,s.B8.load(N0.o,"loader.gui.context-menu.gear"),JH&&null!==ZC._n_(G=JH.gear)&&N0.append(G),ZC.mobile&&(s.B8.load(N0.o,"loader.gui.context-menu[mobile].gear"),OI&&null!==ZC._n_(G=OI.gear)&&N0.append(G)),N0.K=s.K+"-menu-trigger-gear",N0.IL=ZC.AK(s.K+"-tools"),N0.Z=ZC.AK(s.K+"-trigger-c"),N0.iX=A6E?GS.iX+GS.I/2:DD.width()-(GS.iX+GS.I/2),N0.iY=GS.iY+GS.F/2,N0.AI=ZC.CY(GS.I,GS.F)/4.5,N0.parse(),N0.paint(),"hamburger"!==N0.DU){var QI=new ZC.DT(s);QI.copy(GS),QI.K=s.K+"-menu-trigger-gear-hole",QI.IL=ZC.AK(s.K+"-tools"),QI.Z=ZC.AK(s.K+"-trigger-c"),QI.DU="circle",QI.AI=ZC.CY(GS.I,GS.F)/7,QI.parse(),QI.iX=A6E?GS.iX+GS.I/2:DD.width()-(GS.iX+GS.I/2),QI.iY=GS.iY+GS.F/2,QI.paint()}}var _iX=A6E?GS.iX:DD.width()-(GS.iX+GS.I);ZC.AK(s.K+"-map").innerHTML+=ZC.Q.G0("rect")+'id="'+s.K+'-menu-area" coords="'+ZC._i_(_iX+ZC.MAPTX)+","+ZC._i_(GS.iY+ZC.MAPTX)+","+ZC._i_(_iX+GS.I+ZC.MAPTX)+","+ZC._i_(GS.iY+GS.F+ZC.MAPTX)+'" />'}}}E0=new ZC.DN(s),s.B8.load(E0.o,"loader.gui.context-menu.item"),JH&&null!==ZC._n_(G=JH.item)&&E0.append(G),ZC.mobile&&(s.B8.load(E0.o,"loader.gui.context-menu[mobile].item"),OI&&null!==ZC._n_(G=OI.item)&&E0.append(G)),E0.V2=!0,E0.parse(),LB=new ZC.DN(s),LB.copy(E0),s.B8.load(LB.o,"loader.gui.context-menu.item.hover-state"),JH&&null!==ZC._n_(JH.item)&&null!==ZC._n_(G=JH.item["hover-state"])&&LB.append(G),ZC.mobile&&(s.B8.load(LB.o,"loader.gui.context-menu[mobile].item.hover-state"),OI&&null!==ZC._n_(OI.item)&&null!==ZC._n_(G=OI.item["hover-state"])&&LB.append(G)),LB.V2=!0,LB.parse(),U7={},JH&&null!==ZC._n_(JH.separator)&&(U7=JH.separator);var JU=[],EJ=null;if(ABA=null!==ZC._n_(s.MY.o.empty)&&ZC._b_(s.MY.o.empty),ZC.mobile&&(EJ=G7("PageScroll"),"none"!==EJ.enabled&&(null===s.DF||null===ZC._n_(s.DF["page-scroll"])||s.DF["page-scroll"]?JU.push(GU("disablepagescroll",EJ.text)):JU.push(GU("enablepagescroll",EJ.text)),JU.push(J6("pagescroll")))),EJ=G7("Reload"),"none"!==EJ.enabled&&(JU.push(GU("reload",EJ.text)),JU.push(J6("reload"))),"undefined"!=typeof ZC.A7X){EJ=G7("SaveAsImage"),"none"!==EJ.enabled&&(EJ=G7("SaveAsImagePNG"),"none"!==EJ.enabled&&JU.push(GU("viewaspng",EJ.text?EJ.text:null)),EJ=G7("SaveAsImageJPG"),"none"!==EJ.enabled&&JU.push(GU("viewasjpg",EJ.text?EJ.text:null)),JU.push(J6("export")));var TE=["DownloadPDF","DownloadSVG","DownloadCSV","DownloadXLS","ViewDataTable","ExportData","Print"],A63=0,A23=0;for(i=0;i<TE.length;i++)"ViewDataTable"===TE[i]&&ZC.AK(s.K+"-data-table")&&(TE[i]="HideDataTable"),EJ=G7(TE[i]),"none"!==EJ.enabled&&(A63++,A23=i,JU.push(GU(TE[i].toLowerCase(),EJ.text)));A63>0&&JU.push(J6(TE[A23].toLowerCase()))}if(-1!==LC){var GO=!1;for(j=0,J8=s.AG[LC].BO.length;j<J8;j++)s.AG[LC].BO[j].GO&&(GO=!0);if(GO&&"undefined"!=typeof ZC.A4Z){var A13=!1;EJ=G7("ZoomIn"),"none"!==EJ.enabled&&(JU.push(GU("zoomin",EJ.text)),A13=!0),EJ=G7("ZoomOut"),"none"!==EJ.enabled&&(JU.push(GU("zoomout",EJ.text)),A13=!0),EJ=G7("ViewAll"),"none"!==EJ.enabled&&(JU.push(GU("viewall",EJ.text)),A13=!0),A13&&JU.push(J6("zoom"))}}var b2D=!1,b3D=!1;if(-1!==LC&&(-1!==ZC.AV(["line","area","bar","vbar","hbar","pie","mixed"],s.AG[LC].AF)&&(b2D=!0,s.XH="2d"),-1!==ZC.AV(["line3d","area3d","bar3d","vbar3d","hbar3d","pie3d","mixed3d"],s.AG[LC].AF)&&(b3D=!0,s.XH="3d")),(b2D||b3D)&&(EJ=G7("3D"),"none"!==EJ.enabled&&(EJ=G7(b2D?"SwitchTo3D":"SwitchTo2D"),"none"!==EJ.enabled&&(JU.push(GU(b2D?"switchto3d":"switchto2d",EJ.text)),JU.push(J6("dimension"))))),-1!==LC){var C=s.AG[LC],AAR=!1,ABI=!1;for(j=0;j<C.BO.length;j++){var B=C.BO[j];0===B.BE.indexOf("scale-y")&&(AAR=!0),"log"===B.C1&&(ABI=!0)}AAR&&(EJ=G7("Progression"),"none"!==EJ.enabled&&(EJ=G7(ABI?"LinScale":"LogScale"),"none"!==EJ.enabled&&(JU.push(GU(ABI?"switchtolin":"switchtolog",EJ.text)),JU.push(J6("progression"))))),(C.CX||C.HA)&&(EJ=G7("Guide"),"none"!==EJ.enabled&&(EJ=G7(C.A1J?"HideGuide":"ShowGuide"),"none"!==EJ.enabled&&(JU.push(GU(C.A1J?"hideguide":"showguide",EJ.text)),JU.push(J6("guide")))))}var AAU=0,B6;if("undefined"!=typeof ZC.A8P&&(EJ=G7("ViewSource"),"none"!==EJ.enabled&&(JU.push(GU("viewsource",EJ.text)),AAU++),EJ=G7("BugReport"),"none"!==EJ.enabled&&(JU.push(GU("bugreport",EJ.text)),AAU++)),AAU>0&&JU.push(J6("tools")),EJ=G7("FullScreen"),"none"===EJ.enabled||s.LS||(s.QZ?(EJ=G7("ExitFullScreen"),JU.push(GU("exitfullscreen",EJ.text)),JU.push(J6("exitfullscreen"))):(JU.push(GU("fullscreen",EJ.text)),JU.push(J6("fullscreen")))),s.IC&&(EJ=G7("GoBack"),"none"!==EJ.enabled&&JU.push(GU("goback",EJ.text)),EJ=G7("GoForward"),"none"!==EJ.enabled&&JU.push(GU("goforward",EJ.text)),JU.push(J6("history"))),JU.length>0&&-1!==JU[JU.length-1].indexOf("zc-menu-sep")&&JU.splice(JU.length-1,1),s.A1T={},-1!==LC)if(JH&&null!==ZC._n_(B6=JH["custom-items"]))for(JU.length>0&&JU.push(J6("custom")),i=0,A6=B6.length;i<A6;i++){var A3L=!0;if(null!==ZC._n_(B6[i].enabled)&&("none"===B6[i].enabled?A3L=!1:"all"!==B6[i].enabled&&(A3L=!ev||eval(B6[i].enabled).call(s,zingchart.A0A(ev,s),B6[i].id,ev))),A3L){var AM,K=B6[i].id||"custom-"+i;"sep"===B6[i].id||"sep"===B6[i].type?JU.push(J6(K,!0)):"header"===B6[i].type?(AM=B6[i].text||"Custom Menu "+i,JU.push(A2R(K,AM,!0))):(AM=B6[i].text||"Custom Menu "+i,s.A1T[K]={fn:B6[i]["function"]||"",url:B6[i].url||"",target:B6[i].target||""},JU.push(GU(K,AM,!0)))}}s.TJ||(JU.push(J6("zingchart")),JU.push(GU("xmiabt","About ZingChart"))),ZC.Q.HY({id:s.K+"-menu",p:document.body,cls:"zc-menu zc-style",top:null===ZC._n_(GS)?0:GS.iY+GS.F/2,left:null===ZC._n_(GS)?0:GS.iX+GS.I/2,borderBottom:s.MY.AU+"px solid "+s.MY.BW,background:(-1===s.MY.A0?"transparent":s.MY.A0)+" "+A1P(s.MY.DA),paddingTop:s.MY.FM,paddingRight:s.MY.FN,paddingBottom:s.MY.FU,paddingLeft:s.MY.EQ,html:JU.join("")}),s.E["menu-item-events"]||(s.AGR=function(e){var i,t=1!==e.target.nodeType?e.target.parentNode.id:e.target.id,n=t.substring(0,t.indexOf("-menu-item-")),a=zingchart.getLoader(n);ZC.mobile&&a.OU();var l=a.A4A(a.SW[0],a.SW[1]);a.hideCM(),ZC.mobile&&zingchart.SB(e);var o=t.replace(a.K+"-menu-item-","");a.AAI({graphid:l?l.K:null,menuitemid:o,ev:ZC.A5.BZ(e)});var r=a.o["export-filename"]||a.o.graphset[0]["export-filename"]||"";switch(o){case"switchto2d":case"switchto3d":l&&a.A54(l.K);break;case"enablepagescroll":s.DF=s.DF||{},s.DF["page-scroll"]=!0;break;case"disablepagescroll":s.DF=s.DF||{},s.DF["page-scroll"]=!1;break;case"showguide":a.Z7(l.K,!0);break;case"hideguide":a.Z7(l.K,!1);break;case"switchtolin":a.A0Y(l.K,"lin");break;case"switchtolog":a.A0Y(l.K,"log");break;case"reload":a.A8Y();break;case"viewaspng":a.OD("png");break;case"viewasjpg":a.OD("jpeg");break;case"downloadpdf":a.OD("pdf",""===r?null:{fn:r+".pdf"});break;case"downloadsvg":a.OD("svg",""===r?null:{fn:r+".svg"});break;case"exportdata":zingchart.exec(a.K,"exportdata");break;case"downloadcsv":zingchart.exec(a.K,"downloadCSV",""===r?null:{fn:r});break;case"downloadxls":var A=a.o["export-sheetname"]||a.o.graphset[0]["export-sheetname"]||"ZingChart";(i=G7("DownloadXLS"))["custom-function"]?a.A47({graphid:l?l.K:null,menuitemid:o,filename:r,sheetname:A,"function":i["custom-function"]}):zingchart.exec(a.K,"downloadXLS",""===r?null:{fn:r,sn:A});break;case"viewdatatable":case"hidedatatable":zingchart.exec(a.K,"viewDataTable",{menuid:o});break;case"print":a.A98();break;case"viewsource":a.A5O();break;case"bugreport":a.A6T();break;case"fullscreen":a.A5W();break;case"goback":zingchart.exec(a.K,"goback");break;case"goforward":zingchart.exec(a.K,"goforward");break;case"zoomin":l&&(a.H2.C=l,a.A8X({graphid:l.K,ev:e}));break;case"zoomout":l&&(a.H2.C=l,a.A8D({graphid:l.K,ev:e}));break;case"viewall":l&&(a.H2.C=l,a.A8A({graphid:l.K,ev:e}));break;case"xmiabt":a.A9E();break;default:null!==ZC._n_(G=s.A1T[o])&&(""!==G.fn?a.A47({graphid:l?l.K:null,menuitemid:o,"function":G.fn}):""!==G.url&&l&&l.UZ(e,G.url,G.target))}},s.AG8=function(){this.style.backgroundColor=LB.A0,this.style.color=LB.C2,this.style.borderLeft=this.style.borderRight=LB.AU+"px solid "+LB.BW},s.AGN=function(){this.style.backgroundColor=E0.A0,this.style.color=E0.C2,this.style.borderLeft=this.style.borderRight=E0.AU+"px solid "+E0.BW},s.TM=function(e){return e.preventDefault(),!1},ZC.A5("#"+s.K+"-menu").live("mousedown",s.TM),ZC.A5("."+s.K+"-menu-item").live("mousedown",s.TM),ZC.A5("."+s.K+"-menu-item").live("click touchend",s.AGR).live("mouseover",s.AG8).live("mouseout",s.AGN),s.E["menu-item-events"]=!0)}}function A1P(e){return""!==e&&e?"url("+(0===e.indexOf("zc.")?ZC.IMAGES[e]:e)+")":"none"}function J6(e){return'<div id="'+s.K+"-menu-sep-"+e+'" class="zc-menu-sep" style="background-color:'+E0.A0+";background-image:"+A1P(E0.DA)+" repeat-x 50% 0%;border-bottom-width:"+U7["line-width"]+";border-bottom-color:"+U7["line-color"]+';">&nbsp;</div>'}function GU(e,i,t){i=i||ZC.HJ["menu-"+e];var n=void 0!==t&&t?" zc-custom-menu-item "+s.K+"-custom-menu-item":"";return'<div class="'+s.K+"-menu-item"+n+'" style="width:'+s.MY.o.width+";color:"+E0.C2+";font-family:"+E0.GH+";font-size:"+E0.DG+"px;background-color:"+E0.A0+";background-image:"+A1P(E0.DA)+" repeat-x 50% 0%;border-top:"+(ZC.ie67?E0.AU:1)+"px solid "+E0.BW+";border-left:"+E0.AU+"px solid "+E0.BW+";border-right:"+E0.AU+"px solid "+E0.BW+";padding:"+E0.FM+"px "+E0.FN+"px "+E0.FU+"px "+E0.EQ+"px;text-align:"+E0.O8+";"+(ZC.HJ.rtl?"unicode-bidi:bidi-override;direction:rtl;":"")+'" id="'+s.K+"-menu-item-"+e+'">'+i+"</div>"}function A2R(e,i,t){var n=void 0!==t&&t?" zc-custom-menu-header "+s.K+"-custom-menu-header":"";return'<div class="zc-menu-header '+s.K+"-menu-header"+n+'" style="color:'+E0.C2+";background-color:#666;border-top:"+(ZC.ie67?E0.AU:1)+"px solid "+E0.BW+";border-left:"+E0.AU+"px solid "+E0.BW+";border-right:"+E0.AU+"px solid "+E0.BW+";padding:"+E0.FM+"px "+E0.FN+"px "+E0.FU+"px "+E0.EQ+"px;text-align:"+E0.O8+";"+(ZC.HJ.rtl?"unicode-bidi:bidi-override;direction:rtl;":"")+'" id="'+s.K+"-menu-item-"+e+'">'+i+"</div>"}function G7(e){var i={ViewAsImage:"SaveAsImage",ViewAsImagePNG:"SaveAsImagePNG",ViewAsImageJPG:"SaveAsImageJPG"};if(ABA)return{enabled:"none"};for(var t=0,n=PF.length;t<n;t++){if(PF[t].id===e)return PF[t];if(i[PF[t].id]&&i[PF[t].id]===e)return PF[t]}return{enabled:"all"}}},destroy:function(){this._unbind_(),zingchart.HZ.length-=1,this.clear(),ZC.A5("#zc-fullscreen").remove(),document.body.style.overflow=""},N3:function(e,i){var t,n=this;if(null===ZC._n_(i)&&(i=!1),(i||n.A0L)&&-1===ZC.AV(n.KR,"skip_interactivity"))if(n.ZT=!0,i&&ZC.Q.HY({id:n.K+"-dummy",p:ZC.AK(n.K),wh:n.I+"/"+n.F}),n.E.hideprogresslogo||zingchart.DEV.SKIPPROGRESS)n.ZT=!1;else{var a=ZC.A5("#"+n.K);if(!(void 0===a.offset()||a.width()+a.height()===0||n.E.hideprogresslogo&&n.TJ)){var l=a.offset().left+ZC._i_(a.css("border-left-width"))+(null===e?n.iX:e.iX),o=a.offset().top+ZC._i_(a.css("border-top-width"))+(null===e?n.iY:e.iY);(ZC.ipad||ZC.iphone)&&(l-=ZC.A5(window).scrollLeft(),o-=ZC.A5(window).scrollTop());var r=null===e?n.I:e.I,s=null===e?n.F:e.F,A=ZC._i_(.8*n.I),C=30,c=new ZC.DN(n);n.B8.load(c.o,"loader.gui.progress"),c.append(n.E.progress),null!==n.DF&&null!==ZC._n_(t=n.DF.progress)&&c.append(t),c.parse();var u,p=ZC.HJ["progress-wait-long"];if(ZC.ie67)u=c.A0;else{var Z=n.E.customprogresslogo||ZC.IMAGES["zc.logo"];u=c.A0+" url("+Z+") no-repeat center center"}(r<180||s<90)&&(u=c.A0,C=-12),r<120&&r>60?(A=60,p=ZC.HJ["progress-wait-short"]):r<60&&(A=20,p=ZC.HJ["progress-wait-mini"]),p=n.E.customprogresstext||p;var h=ZC.Q.HY({id:n.K+"-progress",p:document.body,tl:o+"/"+l,width:r-2*c.AU,height:s-2*c.AU,position:"absolute",opacity:.8,border:c.AU+"px solid "+c.BW,background:u});ZC.Q.HY({id:n.K+"-progress-text",p:h,width:A,html:p,textAlign:"center",marginLeft:ZC._i_((r-A)/2),marginTop:ZC._i_(s/2+C),fontFamily:zingchart.FONTFAMILY,fontSize:zingchart.FONTSIZE,color:c.C2,fontWeight:"bold"})}}},A0C:function(){var e=this;ZC.Q.EU(e.K+"-dummy"),e.E.hideprogresslogo||(e.ZT=!1,ZC.Q.EU([e.K+"-progress-text",e.K+"-progress"]))},A4O:function(e,i){var t,n,a=this;t=null!==ZC._n_(n=e.graphset)?n:[e];var l=e.layout||"",o=ZC.AQ.A2C(l,t.length),r=t[i],s=a.I/o[1],A=a.F/o[0],C=Math.floor(i/o[1]),c=i%o[1]*s,u=C*A;r&&(null!==ZC._n_(n=r.x)&&(c=ZC._p_(n))<=1&&(c=ZC._i_(c*a.I)),null!==ZC._n_(n=r.y)&&(u=ZC._p_(n))<=1&&(u=ZC._i_(u*a.F)),null!==ZC._n_(n=r.width)&&(s=ZC._p_(n))<=1&&(s=ZC._i_(s*a.I)),null!==ZC._n_(n=r.height)&&(A=ZC._p_(n))<=1&&(A=ZC._i_(A*a.F)));var p=[0,0,0,0];if(r.plotarea){if(a.B8.load(r.plotarea,["("+r.type+").plotarea"],!1,!0),null!==ZC._n_(r.plotarea.margin))p=new ZC.HL(null).m_(r.plotarea.margin,"all",s,A);for(var Z=["top","right","bottom","left"],h=0;h<4;h++)if(null!==ZC._n_(r.plotarea["margin-"+Z[h]])){var d=r.plotarea["margin-"+Z[h]];ZC._i_(d)+""==d+""&&(p[h]=ZC._i_(d))}}return{graph:{x:ZC._i_(c),y:ZC._i_(u),width:ZC._i_(s),height:ZC._i_(A),index:i},plotarea:{x:p[3],y:p[0],width:s-p[1]-p[3],height:A-p[0]-p[2]}}},K6:function(){var e=this;null===ZC._n_(e.o.graphset)&&(e.o={graphset:[e.o]}),e.N3(),zingchart.A1E(e,e.A4W(),function(){e.o=ZC.AP.BY("dataparse",e,e.FE(),e.o),zingchart.XZ[e.K]&&e.QH(function(){e.parse(),e.paint()})})},render:function(){var e=this;!function(){function i(){""!==e.QJ||null!==e.ML?e.A8S():e.load()}e.UN||e.A8N(),e.N3(null,!0),zingchart.TIMEOUT>0?ZC.ZJ(i):i()}()},YI:function(e){var i=this;null===ZC._n_(i.A3S)&&(i.A3S=(new Date).getTime(),i.AAW=window.setTimeout(function(){null!==ZC._n_(i.A3S)&&(i.A3S=null,zingchart.YS(e))},1500))},FE:function(){var e,i=this,t=0,n=0;return t="undefined"!=typeof i.SW[0]?i.SW[0]-t:0,n="undefined"!=typeof i.SW[1]?i.SW[1]-n:0,e=i.LL?i.LL:"light",{id:i.K,width:i.I,height:i.F,output:i.AA,x:t,y:n,targetid:i.SW[2],theme:e}},AC5:function(e){e=e||{},null!==ZC._n_(e.resource)&&(this.QS[e.resource]=e.data||"[]",this.UQ++)},A8X:function(){},A8D:function(){},A8A:function(){},PV:function(){},A9H:function(e,i){var t=this;if(e=e||{},null!==ZC._n_(e.graphid)){var n=t.OQ(e.graphid);null!==n&&n.clear()}else t.clear(null,null,i);ZC.JS&&ZC.JS.GUIDES&&(ZC.JS.GUIDES[t.K]=null)},A7W:function(e){e=e||ZC.HJ["sync-wait"];var i=this;if(null===ZC.AK(i.K+"-blocker")){ZC.Q.HY({cls:"zc-abs zc-style zc-blocker",id:i.K+"-blocker",p:ZC.AK(i.K+"-top"),wh:i.I+"/"+i.F,opacity:.75}),ZC.Q.HY({cls:"zc-blocker-msg",id:i.K+"-blocker-t",p:ZC.AK(i.K+"-blocker"),html:e});var t=ZC.A5("#"+i.K+"-blocker-t");t.css("top",i.F/2-t.height()/2+"px").css("left",i.I/2-t.width()/2+"px")}},A42:function(){ZC.Q.EU(this.K+"-blocker")},A9E:function(){var e=this;ZC.AP.BY("about_show",e,e.FE()),ZC.Q.HY({cls:"zc-abs",id:e.K+"-about-mask",p:ZC.AK(e.K+"-top"),wh:e.I+"/"+e.F,background:"#ccc",opacity:.75});var i=ZC.CY(320,e.I),t=ZC.CY(215,e.F),n=ZC.BQ(0,(e.I-i)/2),a=ZC.BQ(0,(e.F-t)/2),l=ZC.Q.HY({cls:"zc-about zc-style",id:e.K+"-about",p:ZC.AK(e.K+"-top"),tl:a+"/"+n,wh:i-(ZC.quirks?0:10)+"/"+(t-(ZC.quirks?0:10))}),o="";""!==e.SD&&(o="Custom Built for<br />"+e.SD),l.innerHTML='<div class="zc-about-1"><a href="http://www.zingchart.com" target="_blank">zingchart.com</a></div><div class="zc-about-2">&copy;2009-'+(new Date).getFullYear()+'</div><div class="zc-about-3"><div id="'+e.K+'-about-close">'+ZC.HJ["about-close"]+'</div></div><div class="zc-about-4" style="padding:'+(t-215)+'px 5px 5px 5px;"><div>&nbsp;<br />Build '+ZC.VERSION+" ["+e.AA+"]</div>"+o+"</div>",ZC.A5("#"+e.K+"-about-close").bind("click",function(){ZC.AP.BY("about_hide",e,e.FE()),ZC.Q.EU([e.K+"-about",e.K+"-about-mask"])})},NU:function(e,i){var t=this;if(ZC.AP.A83("error",t))ZC.AP.BY("error",t,{id:t.K,error:e,section:i,json:t.E.json||t.E.rawsource});else{var n="";n+="object"==typeof e?e.name+":"+e.message+"\n\n":e+"\n\n",null!==ZC._n_(i)&&(n+="Section:"+i+"\n\n"),n+="JSON data:\n\n"+t.E.json+"\n\n",t.A0C(),null===ZC.AK(t.K+"-top")&&t.AAS(),ZC.Q.HY({cls:"zc-abs zc-error zc-style",id:t.K+"-error",p:ZC.AK(t.K+"-top"),wh:t.I-(ZC.quirks?0:10)+"/"+(t.F-(ZC.quirks?0:10))}).innerHTML='<div class="zc-form-row-label zc-form-s0">'+ZC.HJ["error-header"]+'</div><div class="zc-form-row-label zc-form-s1">'+ZC.HJ["error-message"]+'</div><div class="zc-form-row-element"><textarea id="'+t.K+'-error-message" style="width:'+(t.I-35)+"px;height:"+(t.F-135)+'px;"></textarea></div><div class="zc-form-row-element zc-form-row-last"><input type="button" value="'+ZC.HJ["error-close"]+'" id="'+t.K+'-error-close" /></div>',ZC.A5("#"+t.K+"-error-message").val(ZC.GV(n)),ZC.A5("#"+t.K+"-error-close").bind("click",function(){ZC.Q.EU(t.K+"-error")})}},A5O:function(){},A6T:function(){},A5W:function(){var e=this,i=document.createElement("div");i.id="zc-fullscreen",i.style.zIndex=zingchart.FSZINDEX,i.style.overflow="hidden";var t,n,a=document.body,l=!1;for(zingchart.FSID&&ZC.AK(zingchart.FSID)&&(l=!0,(a=ZC.AK(zingchart.FSID)).style.display="block"),a.appendChild(i),ZC.FSSTATUS={},t=0,n=e.AG.length;t<n;t++){var o=e.AG[t];if(null!==o.AY)for(var r=0,s=o.AY.A4.length;r<s;r++)ZC.FSSTATUS["g-"+o.L+"-p-"+r]=o.E["plot"+r+".visible"]}ZC.Q.EU(e.K+"-data-table");var A,C=JSON.parse(e.E.json),c=C.graphset;for(t=c.length-1;t>=0;t--)if(c[t].generated)c.splice(t,1);else{if(null!==ZC._n_(c[t].shapes))for(A=c[t].shapes.length-1;A>=0;A--)c[t].shapes[A].generated&&c[t].shapes.splice(A,1);if(null!==ZC._n_(c[t].labels))for(A=c[t].labels.length-1;A>=0;A--)c[t].labels[A].generated&&c[t].labels.splice(A,1)}l||window.scroll(0,0),zingchart.render({id:"zc-fullscreen",output:e.AA,width:ZC.A5(l?a:window).width(),height:ZC.A5(l?a:window).height(),fullscreenmode:!0,theme:e.LL,modules:e.A1A,data:C,defaults:e.ML,defaultsurl:e.QJ})},A0Y:function(e,i){var t,n,a,l=this,o=0,r=!1;for(t=0,n=l.AG.length;t<n;t++)if(e===l.AG[t].K){for(o=t,a=0;a<l.AG[t].AY.A4.length;a++)if(l.AG[t].AY.A4[a].I3){r=!0;break}var s;for(s=l.AG[o].AJ["3d"]||r?l.o.graphset[t]:l.AG[t].o,a=0;a<10;a++){var A="scale-y"+(0===a?"":"-"+a);null===ZC._n_(s[A])&&null===ZC._n_(s[ZC.EE(A)])&&null!==l.AG[t].BL(A)?s[A]={progression:i}:(null!==ZC._n_(s[A])&&(s[A].progression=i),null!==ZC._n_(s[ZC.EE(A)])&&(s[ZC.EE(A)].progression=i))}}delete l.E["graph"+o+".zoom"],l.AG[o].AJ["3d"]||r?l.K6():l.AG[o].K6(!0,!0)},Z7:function(e,i){var t=this;if(t.D7){for(var n=0,a=t.AG.length;n<a;n++)e===t.AG[n].K&&(t.AG[n].A1J=i,t.AG[n].E["guide-on"]=i);if(i){var l=ZC.A5("#"+t.K+"-top"),o={_pageX_:ZC.E1[0]-l.offset().left,_pageY_:ZC.E1[1]-l.offset().top,type:"mousemove",target:{id:t.K+"-img"}};t.D7.Q7(o)}else ZC.JS.clearGuide(t.K)}},A54:function(e){for(var i=this,t=["line","area","bar","vbar","hbar","pie","mixed"],n=0,a=i.AG.length;n<a;n++)if(e===i.AG[n].K){var l=i.o.graphset[n];if("mixed"===l.type)for(var o=0,r=l.series.length;o<r;o++){var s=l.series[o];s.type=s.type||"line","3d"===i.XH?s.type=s.type.replace("3d",""):-1!==ZC.AV(t,s.type)&&(s.type=s.type+"3d")}else"3d"===i.XH?l.type=l.type.replace("3d",""):-1!==ZC.AV(t,l.type)&&(l.type=l.type+"3d")}i.XH="3d"===i.XH?"2d":"3d",i.E.json=ZC.GV(JSON.stringify(i.o)),i.K6()},A8Y:function(e){for(var i,t=this,n=0;n<t.AG.length;n++)delete t.E["g"+n+"-legend-collapsed"];if(e=e||{},ZC.AP.BY("reload",t,{id:t.K,graphid:e.graphid}),null!==ZC._n_(i=e.graphid)){var a=t.C8(i);null!==a&&(t.N3(a),t.load(a.K))}else t.QL=[],t.NS=-1,t.N3(),t.clearGenerated(),t.load()},ACZ:function(e){var i,t=this;if(e=e||{},null!==ZC._n_(i=e.graphid)){var n=t.C8(i);null!==n&&null!==ZC._n_(e.dataurl)&&(t.N3(n),t.load(i,e.dataurl))}else null!==ZC._n_(i=e.dataurl)&&(t.QM=i,t.N3(),t.load())},A98:function(){},OD:function(){},Z4:function(){},AAI:function(e){ZC._cp_(this.FE(),e),ZC.AP.BY("menu_item_click",this,e)},A47:function(O){var s=this;try{var DW=ZC.AP.AAH(O["function"]);O["function"]=DW[0],O.arguments=DW[1],ZC._cp_(s.FE(),O),eval(O["function"]).call(s,O)}catch(JA){return s.NU(JA,"JavaScript data loader"),!1}},C8:function(e){var i=this;return null!==ZC._n_(e)?i.OQ(e):i.AG.length>0?i.AG[0]:null},bind:function(e,i){zingchart.bind(this.K,e,i)},unbind:function(e,i){zingchart.unbind(this.K,e,i)},exec:function(e,i){return zingchart.exec(this.K,e,i)},gc:function(){for(var e=0,i=this.AG.length;e<i;e++)this.AG[e].gc()}};ZC.Q2=ZC.HL.CA(Q2),ZC.Q2.prototype.AD6=function(e){var i,t,n,a,l,o=this;if((e=e||{}).action="pan",i=null!==ZC._n_(e.graphid)?o.OQ(e.graphid):o.AG[0]){for(t=0,n=i.BU("k").length;t<n;t++){var r=i.BU("k")[t];if(a=1===r.L?"":"-"+r.L,r.GO&&(null===ZC._n_(e["zoomx"+a])||e["zoomx"+a])){e["zoomx"+a]=!0;var s,A=e.xdist||50;l=r.I/ZC.CY(r.I,Math.abs(A));var C=r.W,c=r.A1;A<0?(s=ZC.CY(r.W-r.DC,ZC._i_((r.A1-r.W)/l)),C=r.W-s,c=r.A1-s):(s=ZC.CY(r.DX-r.A1,ZC._i_((r.A1-r.W)/l)),C=r.W+s,c=r.A1+s),e["xmin"+a]=C,e["xmax"+a]=c}}for(t=0,n=i.BU("v").length;t<n;t++){var u=i.BU("v")[t];if(a=1===u.L?"":"-"+u.L,u.GO&&(null===ZC._n_(e["zoomy"+a])||e["zoomy"+a])){e["zoomy"+a]=!0;var p,Z=e.ydist||50;l=u.F/ZC.CY(u.F,Math.abs(Z));var h=u.B3,d=u.BJ;A<0?(p=ZC.CY(u.B3-u.FW,ZC._i_((u.BJ-u.B3)/l)),h=u.B3-p,d=u.BJ-p):(p=ZC.CY(u.H1-u.BJ,ZC._i_((u.BJ-u.B3)/l)),h=u.B3+p,d=u.BJ+p),u.PZ&&1===u.E5&&(h=Math.round(h),d=Math.round(d)),e["ymin"+a]=h,e["ymax"+a]=d}}o.PV(e)}},ZC.Q2.prototype.A8X=function(e){var i,t,n,a,l=this;if((e=e||{}).action="zoomin",i=null!==ZC._n_(e.graphid)?l.OQ(e.graphid):l.AG[0]){for(t=0,n=i.BU("k").length;t<n;t++){var o=i.BU("k")[t];if(a=1===o.L?"":"-"+o.L,o.GO&&(null===ZC._n_(e["zoomx"+a])||e["zoomx"+a])){e["zoomx"+a]=!0;var r=o.A1-o.W,s=o.W+(r<2?0:ZC._i_(r/4)),A=o.A1-(r<2?0:ZC._i_(r/4));s<A?(e["xmin"+a]=s,e["xmax"+a]=A):(e["xmin"+a]=o.W,e["xmax"+a]=o.A1)}}for(t=0,n=i.BU("v").length;t<n;t++){var C=i.BU("v")[t];if(a=1===C.L?"":"-"+C.L,C.GO&&(null===ZC._n_(e["zoomy"+a])||e["zoomy"+a])){e["zoomy"+a]=!0;var c=C.BJ-C.B3,u=C.B3+ZC._f_(c/4),p=C.BJ-ZC._f_(c/4);C.PZ&&1===C.E5&&(u=Math.round(u),p=Math.round(p)),u<p&&(e["ymin"+a]=u,e["ymax"+a]=p)}}l.PV(e)}},ZC.Q2.prototype.A8D=function(e){var i,t,n,a,l,o,r,s=this;if((e=e||{}).action="zoomout",e.previewscale=!0,i=null!==ZC._n_(e.graphid)?s.OQ(e.graphid):s.AG[0]){for(t=0,n=i.BU("k").length;t<n;t++){var A=i.BU("k")[t];if(r=1===A.L?"":"-"+A.L,A.GO&&(null===ZC._n_(e["zoomx"+r])||e["zoomx"+r]))if(e["zoomx"+r]=!0,i.B9&&i.B9.LK){var C=ZC._i_(i.B9.NJ[A.BE].values.length*i.B9.IG/i.B9.AR.I),c=ZC._i_(i.B9.NJ[A.BE].values.length*i.B9.H7/i.B9.AR.I);a=ZC.BQ(2,c-C),(l=ZC.BQ(0,C-ZC._i_(a/2)))<(o=ZC.CY(i.B9.NJ[A.BE].values.length-1,c+ZC._i_(a/2)))&&(e["xmin"+r]=l,e["xmax"+r]=o)}else a=ZC.BQ(2,A.A1-A.W),(l=ZC.BQ(A.DC,A.W-ZC._i_(a/2)))<(o=ZC.CY(A.DX,A.A1+ZC._i_(a/2)))&&(e["xmin"+r]=l,e["xmax"+r]=o)}for(t=0,n=i.BU("v").length;t<n;t++){var u=i.BU("v")[t];if(r=1===u.L?"":"-"+u.L,u.GO&&(null===ZC._n_(e["zoomy"+r])||e["zoomy"+r])){e["zoomy"+r]=!0;var p=u.BJ-u.B3,Z=ZC.BQ(u.FW,u.B3-ZC._f_(p/2)),h=ZC.CY(u.H1,u.BJ+ZC._f_(p/2));u.PZ&&1===u.E5&&(Math.round(h)-Math.round(Z)>1?(Z=Math.round(Z),h=Math.round(h)):(Z=Math.floor(Z),h=Math.ceil(h))),(Z=ZC.BQ(u.FW,Z))<(h=ZC.CY(u.H1,h))&&(e["ymin"+r]=Z,e["ymax"+r]=h)}}s.PV(e)}},ZC.Q2.prototype.A8A=function(e){var i,t,n,a,l,o=this;for(e=e||{},t=null!==ZC._n_(e.graphid)?o.OQ(e.graphid):o.AG[0],e.action="viewall",n=0,a=t.BU("k").length;n<a;n++)if(e["zoomx"+(l=1===(i=t.BU("k")[n]).L?"":"-"+i.L)]=!0,e["xmin"+l]=null,e["xmax"+l]=null,t.o[i.BE]&&(t.o[i.BE]["zoom-to"]=null,t.o[i.BE]["zoom-to-values"]=null),t.B9&&t.B9.LK){var r=t.B9.NJ[i.BE].values;e["kmin"+l+"-async"]=r[0],e["kmax"+l+"-async"]=r[r.length-1]}for(n=0,a=t.BU("v").length;n<a;n++)i=t.BU("v")[n],t.o[i.BE]&&(t.o[i.BE]["zoom-to"]=null,t.o[i.BE]["zoom-to-values"]=null),i.DQ=null!==ZC._n_(i.E.decimals)&&-1!==i.E.decimals?i.E.decimals:null,l=1===i.L?"":"-"+i.L,i.KN=null,e["zoomy"+l]=!0,e["ymin"+l]=null,e["ymax"+l]=null;o.PV(e)},ZC.Q2.prototype.PV=function(e){var i,t,n,a,l,o,r,s,A,C,c,u,p,Z,h,d=this;(e=e||{}).id=d.K;var f=null!==ZC._n_(e.zoom)&&!e.zoom;if(t=null!==ZC._n_(e.graphid)?d.OQ(e.graphid):d.AG[0]){f&&(d.E["graph."+t.L+".ignore-zoom"]=!0),d.E["graph."+t.L+".ignore-zoom"]&&(f=!0),"undefined"==typeof e.scroll&&(ZC.Q.IU(ZC.AK(t.K+"-scroll-x-c"),t.A.AA,t.iX,t.iY,t.I,t.F),ZC.Q.IU(ZC.AK(t.K+"-scroll-y-c"),t.A.AA,t.iX,t.iY,t.I,t.F)),t.B9&&(t.B9.I2=!1);var _=d.E["graph"+t.L+".zoom"]||{};for(e.yzoomed=!1,(l=t.BU("v")[0])&&null!==ZC._n_(e.ymin)&&null!==ZC._n_(e.ymax)&&(e.ymin===l.FW&&e.ymax===l.H1||(e.yzoomed=!0)),s=0,A=t.BU("k").length;s<A;s++)if(C=1===(a=t.BU("k")[s]).L?"":"-"+a.L,null!==ZC._n_(e["kmin"+C])&&null!==ZC._n_(e["kmax"+C]))if(e["kmin"+C]===e["kmax"+C])delete e["kmin"+C],delete e["kmax"+C];else{for(var g=!1,v=!1,b=0,B=a.V.length;b<B&&(e["kmin"+C]<=a.V[b]&&!g&&(e["xmin"+C]=b,g=!0),e["kmax"+C]<=a.V[b]&&!v&&(e["xmax"+C]=b,v=!0),!g||!v);b++);g||(e["xmin"+C]=0),v||(e["xmax"+C]=a.V.length-1),e["zoomx"+C]=!0,e.xzoomed=!(g&&v)}else n=t.B9&&t.B9.LK&&e.previewscale?t.B9.NJ[a.BE].values:a.V,null!==ZC._n_(i=n[e["xmin"+C]])&&(e["kmin"+C]=i),null!==ZC._n_(i=n[e["xmax"+C]])&&(e["kmax"+C]=i),e.xzoomed=!(e["xmin"+C]===a.DC&&e["xmax"+C]===a.DX);"viewall"===e.action&&(e.xzoomed=!1,e.yzoomed=!1);var m=ZC.AP.BY("zoom",t.A,e,!0);if(e.async&&!f)return;if(t.B9&&t.B9.LK){n=t.B9.NJ[a.BE].values;var E=ZC.XY(n),D=ZC.A1L(n);null!==ZC._n_(e.kmin)&&"undefined"!=typeof e.kmin?(o=ZC._i_(t.B9.AR.I*(e.kmin-E)/(D-E)),o=ZC.BQ(o,0)):o=0,null!==ZC._n_(e.kmax)&&"undefined"!=typeof e.kmax?(r=ZC._i_(t.B9.AR.I*(e.kmax-E)/(D-E)),r=ZC.CY(r,t.B9.AR.I)):r=t.B9.AR.I,f||t.B9.update(o,r,t.B9.L1,t.B9.HF)}if(m||void 0===m){for(s=0,A=t.BU("k").length;s<A;s++)e["zoomx"+(C=1===(a=t.BU("k")[s]).L?"":"-"+a.L)]&&(f||a.zoomTo(e["xmin"+C],e["xmax"+C]),_["xmin"+C]=e["xmin"+C],_["xmax"+C]=e["xmax"+C]);for(s=0,A=t.BU("v").length;s<A;s++)e["zoomy"+(C=1===(l=t.BU("v")[s]).L?"":"-"+l.L)]&&null!==ZC._n_(l)&&(f||l.zoomTo(e["ymin"+C],e["ymax"+C]),_["ymin"+C]=e["ymin"+C],_["ymax"+C]=e["ymax"+C]);if(f&&(d.H2.C=t),d.H2.parse(),d.H2.A0G)for(d.E["graph"+t.L+".zoom"]=_,Z=0,h=d.AG.length;Z<h;Z++)t.K!==d.AG[Z].K&&d.AG[Z].H2&&ZC._b_(d.AG[Z].H2.o.shared)&&(d.E["graph"+d.AG[Z].L+".zoom"]=_);if(t.B9&&!e.preview&&t.B9.update(e.xmin,e.xmax,e.ymin,e.ymax,!0),f)return;t.clear(!0);for(var K=t.BU("v"),F=0;F<K.length;F++)if((l=t.BU("v")[F])&&(l.aAutoFit[0]||l.aAutoFit[1])){for(var x=l.aAutoFit[0]?ZC.MAX:l.FW,I=l.aAutoFit[1]?-ZC.MAX:l.H1,y=0,w=t.AY.A4.length;y<w;y++)if(t.AY.A4[y].AN&&-1!==ZC.AV(t.AY.A4[y].BO,l.BE))if(a.EF){for(s=0,A=t.AY.A4[y].S.length;s<A;s++)if((p=t.AY.A4[y].S[s])&&ZC.DS(p.BT,a.V[a.W],a.V[a.A1]))for(l.aAutoFit[0]&&(x=ZC.CY(x,p.CS)),l.aAutoFit[1]&&(I=ZC.BQ(I,p.CS)),c=0,u=p.DP.length;c<u;c++)l.aAutoFit[0]&&(x=ZC.CY(x,p.DP[c])),l.aAutoFit[1]&&(I=ZC.BQ(I,p.DP[c]))}else for(s=a.W;s<=a.A1;s++)if(p=t.AY.A4[y].S[s])for(l.aAutoFit[0]&&(x=ZC.CY(x,p.CS)),l.aAutoFit[1]&&(I=ZC.BQ(I,p.CS)),c=0,u=p.DP.length;c<u;c++)l.aAutoFit[0]&&(x=ZC.CY(x,p.DP[c])),l.aAutoFit[1]&&(I=ZC.BQ(I,p.DP[c]));"log"===l.C1&&(x=ZC.G6(x,l.E6),I=ZC.G6(I,l.E6)),l.RQ(x,I,!0),l.J1();var Y=t.BU("v");for(s=0;s<Y.length;s++)Y[s].BE!==l.BE&&Y[s].sMaster===l.BE&&(Y[s].RQ(x,I,!0),Y[s].J1())}var X=ZC._b_(e.zoomto);t.E["skip-preview"]=!0;var M=["top","right","bottom","left"];for(s=0;s<M.length;s++)(t.P.E["d-margin-"+M[s]]||t.E["plotarea.d-margin-"+M[s]]||ZC._b_(t.P.o["adjust-layout"]))&&(t.o.plotarea["margin-"+M[s]]&&!Number.isNaN(t.o.plotarea["margin-"+M[s]])||(t.o.plotarea["margin-"+M[s]]=t.P.o["margin-"+M[s]]="dynamic",t.E["plotarea.d-margin"]=t.E["plotarea.d-margin-"+M[s]]=!0));t.setupDynamicPlotArea(),t.paint(!X),d.H2.C=null,ZC.AP.BY("postzoom",t.A,e)}}},zingchart.ABP=function(e,i,t){var n,a,l,o,r,s,A,C,c;document.getElementById("zc-fullscreen")&&(e="zc-fullscreen"),"string"==typeof(t=t||{})&&(t=JSON.parse(t));var u=zingchart.getLoader(e);if(null!==ZC._n_(t.preservezoom)&&(u.E.preservezoom=ZC._b_(t.preservezoom)),u)switch(i){case"getzoom":if(o={},l=u.C8(t.graphid))for(n=0,a=l.BO.length;n<a;n++){var p=l.BO[n];"k"===p.AF?o[p.BE]={xmin:p.W,xmax:p.A1,vmin:p.V[p.W],vmax:p.V[p.A1]}:o[p.BE]={ymin:p.B3,ymax:p.BJ,vmin:p.V[p.W],vmax:p.V[p.A1]}}return o;case"pan":u.AD6(t);break;case"zoomin":u.A8X(t);break;case"zoomout":u.A8D(t);break;case"zoomto":if(l=u.C8(t.graphid),null!==ZC._n_(t.xall)&&t.xall)for(n=0,a=l.BU("k").length;n<a;n++)t["xmin"+(A=1===(r=l.BU("k")[n]).L?"":"-"+r.L)]=t.xmin||null,t["xmax"+A]=t.xmax||null,t["kmin"+A]=t.kmin||null,t["kmax"+A]=t.kmax||null;for(n=0,a=l.BU("k").length;n<a;n++)null===t["xmin"+(A=1===(r=l.BU("k")[n]).L?"":"-"+r.L)]&&null===ZC._n_(t["xmax"+A])&&null===ZC._n_(t["kmin"+A])&&null===ZC._n_(t["kmax"+A])||(t["zoomx"+A]=!0),"log"===r.C1&&(null!==ZC._n_(t["xmin"+A])&&(t["xmin"+A]=ZC.G6(t["xmin"+A],r.E6)),null!==ZC._n_(t["xmax"+A])&&(t["xmax"+A]=ZC.G6(t["xmax"+A],r.E6)));if(null!==ZC._n_(t.yall)&&t.yall)for(n=0,a=l.BU("v").length;n<a;n++)t["ymin"+(A=1===(s=l.BU("v")[n]).L?"":"-"+s.L)]=t.ymin||null,t["ymax"+A]=t.ymax||null;for(n=0,a=l.BU("v").length;n<a;n++)A=1===(s=l.BU("v")[n]).L?"":"-"+s.L,null===ZC._n_(t["ymin"+A])&&null===ZC._n_(t["ymax"+A])||(t["zoomy"+A]=!0),"log"===s.C1&&(null!==ZC._n_(t["ymin"+A])&&(t["ymin"+A]=ZC.G6(t["ymin"+A],s.E6)),null!==ZC._n_(t["ymax"+A])&&(t["ymax"+A]=ZC.G6(t["ymax"+A],s.E6)));u.PV(t);break;case"zoomtovalues":if(l=u.C8(t.graphid),null!==ZC._n_(t.xall)&&t.xall)for(n=0,a=l.BU("k").length;n<a;n++)t["xmin"+(A=1===(r=l.BU("k")[n]).L?"":"-"+r.L)]=t.xmin||null,t["xmax"+A]=t.xmax||null;for(n=0,a=l.BU("k").length;n<a;n++)A=1===(r=l.BU("k")[n]).L?"":"-"+r.L,null===ZC._n_(t["xmin"+A])&&null===ZC._n_(t["xmax"+A])||(l.B9&&l.B9.LK?(t.previewscale=!0,t["kmin"+A+"-async"]=t["xmin"+A],t["xmin"+A]=ZC.AAA(l.B9.NJ[r.BE].values,t["xmin"+A])):-1!==(C=ZC.AV(r.V,t["xmin"+A]))&&(t["xmin"+A]=C),l.B9&&l.B9.LK?(t.previewscale=!0,t["kmax"+A+"-async"]=t["xmax"+A],t["xmax"+A]=ZC.AAA(l.B9.NJ[r.BE].values,t["xmax"+A])):-1!==(c=ZC.AV(r.V,t["xmax"+A]))&&(t["xmax"+A]=c),t["zoomx"+A]=!0);if(null!==ZC._n_(t.yall)&&t.yall)for(n=0,a=l.BU("v").length;n<a;n++)t["ymin"+(A=1===(s=l.BU("v")[n]).L?"":"-"+s.L)]=t.ymin||null,t["ymax"+A]=t.ymax||null;for(n=0,a=l.BU("v").length;n<a;n++)A=1===(s=l.BU("v")[n]).L?"":"-"+s.L,null===ZC._n_(t["ymin"+A])&&null===ZC._n_(t["ymax"+A])||(t["zoomy"+A]=!0);u.PV(t);break;case"viewall":u.A8A(t)}return null},ZC.A7X={},ZC.AP.A3E=function(e,i,t,n){"jpg"===(n=n||"png")&&(n="jpeg");var a=document.createElement("canvas");a.width=i,a.height=t,a.style.width=i+"px",a.style.height=t+"px";var l,o=a.getContext("2d");e instanceof Array||(e=[e]);for(var r=0,s=e.length;r<s;r++)if(-1===e[r].className.indexOf("zc-no-print")){var A=!1;try{e[r].toDataURL("image/"+n)}catch(c){A=!0}if(!A)if(l=e[r].getAttribute("data-clip")){var C=l.split(",");o.drawImage(e[r],ZC.BQ(0,C[0]),ZC.BQ(0,C[1]),ZC.CY(C[2],e[r].width),ZC.CY(C[3],e[r].height),ZC.BQ(0,C[0]),ZC.BQ(0,C[1]),ZC.CY(C[2],e[r].width),ZC.CY(C[3],e[r].height))}else o.drawImage(e[r],0,0,e[r].width,e[r].height,0,0,i,t)}return a.toDataURL("image/"+n)},ZC.AP.ABR=function(e,i,t,n,a){null===ZC._n_(a)&&(a=!1);var l=ZC.AP.A3E(e,i,t,n);if(a){var o=document.createElement("img");return o.src=l,o}l=l.replace("image/"+n,"image/octet-stream"),document.location.href=l},ZC.Q2.prototype.A98=function(){var e=this,i=[];if(!e.A7S){e.A7S=!0;var t=document.body.childNodes,n=ZC.A5(document.body).css("background-color"),a=ZC.A5(document.body).css("background-image");ZC.A5(document.body).css("background-color","#fff").css("background-image","none");for(var l=0,o=t.length;l<o;l++)1===t[l].nodeType&&(i[l]=t[l].style.display,t[l].style.display="none");document.body.appendChild(ZC.AK(e.K+"-wrapper")),window.setTimeout(function(){window.print(),window.setTimeout(function(){ZC.A5(document.body).css("background-color",n).css("background-image",a),ZC.AK(e.K+"-wrapper")&&ZC.AK(e.K).appendChild(ZC.AK(e.K+"-wrapper"));for(var l=0,o=t.length;l<o;l++)1===t[l].nodeType&&(t[l].style.display=i[l]);e.A7S=!1},1e3)},50)}},ZC.Q2.prototype.OD=function(e,i,t,n){var a=this;if(i=i||{},void 0===t&&(t=!1),!ZC.AK(a.K+"-viewimage")){e=e||"png";var l=i.download,o=i.fn||"";ZC.Q.IU(ZC.AK(a.K+"-guide-c"),a.AA,0,0,a.I,a.F),ZC.A5(".zc-guide-label").remove();var r,s,A=("canvas"===a.AA||zingchart.AJAXEXPORT||zingchart.DEV.LOCALSVGEXPORT)&&"pdf"!==e&&"svg"!==e;if(ZC.mobile||!A||t||l||(r=ZC.Q.HY({cls:"zc-abs zc-viewimage zc-style",id:a.K+"-viewimage",zidx:5,p:ZC.AK(a.K+"-top"),wh:a.I+"/"+a.F}),s=ZC.Q.HY({id:a.K+"-viewimage-close",p:r,zidx:10,tl:"5/"+(a.I-15),html:ZC.HJ["viewimage-close"]}),ZC.A5(s).css("cursor","pointer").css("left",a.I-15-ZC.A5(s).width()+"px"),ZC.A5(s).bind("click",function(){ZC.A5(r).remove()})),ZC.mobile&&(l=!0),!zingchart.DEV.LOCALSVGEXPORT||l||"svg"!==a.AA||"png"!==e&&"jpeg"!==e){var C;if("canvas"===a.AA&&"pdf"!==e&&"svg"!==e){var c,u,p=document.createElement("canvas");for(p.width=a.I,p.height=a.F,c=0,u=a.AG.length;c<u;c++)a.AG[c].BD&&a.AG[c].BD.EK(p);var Z=[];ZC.A5("#"+a.K+" canvas").each(function(){-1===ZC.AV([a.K+"-guide-c",a.K+"-trigger-c"],this.id)&&Z.push(this)}),Z.push(p),Z.push(a.createPreviewMasks());var h=ZC.AP.ABR(Z,a.I,a.F,e,!0);h.id=a.K+"-print-"+e,r.appendChild(h)}else if(t||a.A7W(ZC.HJ["export-wait"]),"vml"===a.AA||"canvas"===a.AA&&("pdf"===e||"svg"===e)){var d=document.createElement("div"),f="zc-export-svg-"+a.K;d.id=f,d.style.display="none",document.body.appendChild(d),zingchart.render({id:f,output:"!svg",imggen:!0,width:a.I,height:a.F,data:a.E.json,defaults:a.ML,theme:a.LL,hideprogresslogo:!0,events:{load:function(){window.setTimeout(function(){var e=zingchart.getLoader(f);if(e.E["dynamic-objects"])var i=window.setInterval(function(){"ready"===e.E["dynamic-objects"]&&(window.clearInterval(i),e.togglePreviewMasks(!0),C=ZC.AK(f+"-top").innerHTML,e.togglePreviewMasks(!1),zingchart.exec(f,"destroy",{skipfs:!0}),_())},100);else e.togglePreviewMasks(!0),C=ZC.AK(f+"-top").innerHTML,e.togglePreviewMasks(!1),zingchart.exec(f,"destroy",{skipfs:!0}),_()},100)}}})}else"svg"===a.AA&&(a.togglePreviewMasks(!0),C=ZC.AK(a.K+"-top").innerHTML,_(),a.togglePreviewMasks(!1));A&&!t&&(ZC.A5(s).css("cursor","pointer").css("left",a.I-15-ZC.A5(s).width()+"px"),ZC.A5(s).bind("click",function(){ZC.A5(r).remove()}))}else zingchart.exec(a.K,"getimagedata",{callback:function(l){if(-1!==l){var o=document.createElement("img");o.id=a.K+"-print-"+e,o.src=l,r.appendChild(o)}else ZC.Q.EU(a.K+"-viewimage"),zingchart.DEV.LOCALSVGEXPORT=0,a.OD(e,i,t,n)}})}function _(){var s,A,c={svg:C=(C=C.replace(/<foreignObject(.+?)<\/foreignObject>/g,"")).replace(' xmlns="http://www.w3.org/2000/svg"',""),w:a.I,h:a.F,t:e,fn:o};if(ZC._cp_(i,c),zingchart.AJAXEXPORT&&"pdf"!==e&&"svg"!==e&&!l){var u="base64=1&";for(A in c)u+=A+"="+encodeURIComponent(c[A])+"&";ZC.A5.ajax({type:"post",url:zingchart.EXPORTURL,data:u,success:function(i,l,o){if(a.A42(),t)n&&n(i,l,o);else{var s=document.createElement("img");s.src=i,s.id=a.K+"-print-"+e,r.appendChild(s)}}})}else{ZC.AK(a.K+"-export")&&ZC.Q.EU(a.K+"-export");var p=ZC.Q.HY({cls:"zc-abs zc-style",id:a.K+"-export",p:ZC.AK(a.K+"-top"),display:"none"}),Z=(s=null!==ZC._n_(c.uid)&&null!==ZC._n_(c.page)?ZC.Q.ABE(ZC.AK(a.K+"-export")):document).createElement("FORM");for(A in Z.action=zingchart.EXPORTURL,Z.method="post",Z.enctype="multipart/form-data",null!==ZC._n_(c.uid)&&null!==ZC._n_(c.page)?s.body.appendChild(Z):p.appendChild(Z),Z.style.display="none",c){var h=s.createElement("INPUT");h.type="hidden",h.name=A,h.value=c[A],Z.appendChild(h)}Z.submit(),Z=null,null!==ZC._n_(c.uid)&&null!==ZC._n_(c.page)&&window.setTimeout(function(){ZC.A5("#"+a.K+"-export").remove()},6e4),window.setTimeout(function(){a.A42()},1e3)}}},ZC.Q2.prototype.Z4=function(e){var i=this;e=e||"png";var t,n,a=[],l=document.createElement("canvas");for(l.width=i.I,l.height=i.F,t=0,n=i.AG.length;t<n;t++)i.AG[t].BD&&i.AG[t].BD.EK(l);return ZC.A5("#"+i.K+" canvas").each(function(){-1===ZC.AV([i.K+"-guide-c",i.K+"-tooltip-c"],this.id)&&a.push(this)}),a.push(l),a.push(i.createPreviewMasks()),ZC.AP.A3E(a,i.I,i.F,e)},ZC.AP.downloadFile=function(e,i,t){if(!ZC.ie678){t=t||"application/octet-stream";var n=document.createElement("a");navigator.msSaveBlob?navigator.msSaveBlob(new Blob([e],{type:t}),i):URL&&"download"in n?(n.href=URL.createObjectURL(new Blob([e],{type:t})),n.setAttribute("download",i),document.body.appendChild(n),n.click(),document.body.removeChild(n)):location.href="data:application/octet-stream,"+encodeURIComponent(e)}},ZC.AP.XW=function(e,i){var t,n,a,l,o,r,s,A,C,c,u,p,Z,h=[],d="",f=[];for("xls"===(i=i||"csv")&&h.push('<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="http://www.w3.org/TR/REC-html40">',"<head>","\x3c!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>[ZC]</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--\x3e",'<style>td{border:none;font-family:Calibri,sans-serif} .number{mso-number-format:"0.00";} .text{mso-number-format:"@";}</style>',"<meta name=ProgId content=Excel.Sheet>","<meta charset=UTF-8>","</head>","<body>"),t=0,n=e.AG.length;t<n;t++){var _=e.AG[t],g=_.AY.A4;e.E.fastlinedata&&(g=e.E.fastlinedata);var v={},b=[],B=_.BU("k")[0];"html"!==i&&"xls"!==i&&"raw"!==i||(h.push("<table>"),_.IR&&""!==_.IR.AM&&(f.push([_.IR.AM]),h.push("<caption>"+_.IR.AM+"</caption>")),h.push("<thead>"),h.push("<tr>")),u=[],Z=[];var m="Category",E=!1;for(B&&(B.FG&&"date"===B.FG.o.type&&(m="Date",E=!0),B.M&&B.M.AM&&(m=B.M.AM.replace(/\"|\'/g,""))),"csv"===i?u.push('"'+m+'"'):"raw"===i?Z.push(m):"html"!==i&&"xls"!==i||u.push("<th>"+m+"</th>"),a=0,l=g.length;a<l;a++)(null===ZC._n_(g[a].o["export"])||ZC._b_(g[a].o["export"]))&&(p=(p=null!==ZC._n_(g[a].AM)?g[a].AM+"":"Series "+a).replace(/\"|\'/g,""),"csv"===i?u.push('"'+p+'"'):"raw"===i?Z.push(p):"html"!==i&&"xls"!==i||u.push("<th"+("xls"===i?' scope="col" class="text"':"")+">"+p+"</th>"),b.push(""));if("csv"===i?h.push(u.join(",")):"raw"===i?f.push(Z):"html"!==i&&"xls"!==i||h.push(u.join("")),"html"!==i&&"xls"!==i||(h.push("</tr>"),h.push("</thead>"),h.push("<tbody>")),B){for(s=0,A=B.V.length;s<A;s++)v[s+""]={hasData:!1,nodes:[].concat(b)};var D=[];for(a=0,l=g.length;a<l;a++)if(null===ZC._n_(g[a].o["export"])||ZC._b_(g[a].o["export"]))for(o=0,r=g[a].S.length;o<r;o++){var K=g[a].S[o];K&&(v[s=null!==ZC._n_(K.BT)?""+K.BT:""+o]=v[s]||{hasData:!0,nodes:[].concat(b)},v[s].nodes[a]=K.AD,v[s].hasData=!0,null!==ZC._n_(K.BT)&&D.push(""+K.BT))}var F=[];for(s in v)v[s].hasData&&F.push([s,v[s].nodes]);F.sort(function(e,i){return e[0]-i[0]});var x=null;for(C=0,c=F.length;C<c;C++){if("html"!==i&&"xls"!==i||h.push("<tr>"),"pie"!==_.AF&&"pie3d"!==_.AF&&"nestedpie"!==_.AF||B.V[F[C][0]]&&(F[C][0]=B.V[F[C][0]]),B.BX[F[C][0]]&&(F[C][0]=B.BX[F[C][0]]),B.V[F[C][0]]&&-1===ZC.AV(D,F[C][0])&&(F[C][0]=B.V[F[C][0]]),(x=_.A.FE()).row=C,x.col=0,x.value=F[C][0],F[C][0]=ZC.AP.BY("dataexport",_.A,x,F[C][0],null),ZC._n_(F[C][1]))for(var I=0;I<F[C][1].length;I++)(x=_.A.FE()).row=C,x.col=I+1,x.value=F[C][1][I],F[C][1][I]=ZC.AP.BY("dataexport",_.A,x,F[C][1][I],null);E&&(F[C][0]=ZC.AP.Y5(F[C][0],"%Y-%mm-%dd %H:%i:%s",_.UL,_.NB),"csv"===i&&(F[C][0]='"'+F[C][0]+'"')),"csv"===i?h.push([].concat(F[C][0]).concat(F[C][1]).join(",")):"raw"===i?f.push([].concat(F[C][0]).concat(F[C][1])):"html"!==i&&"xls"!==i||h.push("<td"+("xls"===i?' scope="row"':"")+">"+[].concat(F[C][0]).concat(F[C][1]).join("</td><td>")+"</td>"),"html"!==i&&"xls"!==i||h.push("</tr>")}}"html"!==i&&"xls"!==i||(h.push("</tbody>"),h.push("</table>")),n>1&&t<n-1&&("csv"===i?h.push("","",""):"html"!==i&&"xls"!==i||h.push("<p>&nbsp;</p>"))}return"xls"===i&&h.push("</body>","</html>"),"raw"===i?f:("csv"===i?d=h.join("\n"):"html"!==i&&"xls"!==i||(d=h.join("")),d)},zingchart.AB6=function(e,i,t){var n,a,l,o,r,s="",A="";function C(e){ZC.A5.ajax({type:"post",url:a,data:e,success:function(e,i,t){l&&l(e,i,t)}})}document.getElementById("zc-fullscreen")&&(e="zc-fullscreen"),"string"==typeof(t=t||{})&&(t=JSON.parse(t));var c=zingchart.getLoader(e);if(c)switch(i){case"getimagedata":if(o="png",null!==ZC._n_(n=t.format)&&(o=n),null!==ZC._n_(n=t.filetype)&&(o=n),"jpg"===o&&(o="jpeg"),zingchart.DEV.LOCALSVGEXPORT&&"svg"===c.AA&&("png"===o||"jpeg"===o)){c.togglePreviewMasks(!0);var u=ZC.AK(c.K+"-svg").parentNode.innerHTML,p=u.indexOf(">"),Z=u.indexOf("</svg>");u=(u='<svg xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" version="1.1" width="'+c.I+'" height="'+c.F+'">[CSS]'+u.substring(p+1,Z+6)).replace(/<foreignObject(.+?)<\/foreignObject>/g,"");var h=function(){var e,i=window.URL||window.webkitURL||window,n=!1;navigator&&navigator.userAgent&&-1!==navigator.userAgent.indexOf("Safari")&&-1===navigator.userAgent.indexOf("Chrome")&&(n=!0),e=i.createObjectURL&&window.Blob&&!n?i.createObjectURL(new window.Blob([u],{type:"image/svg+xml;charset-utf-16"})):"data:image/svg+xml;charset=UTF-8,"+encodeURIComponent(u),c.togglePreviewMasks(!1);var a=new window.Image;a.crossOrigin="anonymous",a.src=e,a.onload=function(){var i=document.createElement("canvas"),n=i.getContext("2d");if(i.width=a.width,i.height=a.height,n.drawImage(a,0,0,i.width,i.height),t.callback&&"function"==typeof t.callback)try{t.callback(i.toDataURL("image/"+o))}catch(l){t.callback(e)}}},d=0,f=function(){var e=new XMLHttpRequest;e.open("get",c.A24[d]),e.responseType="text",e.onloadend=function(e){var i=e.target.response,t=i.match(/https?:\/\/[^ \)]+/g),n=0;t.forEach(function(e){var a=new XMLHttpRequest;a.open("get",e),a.responseType="blob",a.onloadend=function(a){var l=new FileReader;l.onloadend=function(a){i=i.replace(new RegExp(e),a.target.result),++n===t.length&&(u=u.replace("[CSS]","[CSS]<style><![CDATA["+i+"]]></style>"),++d===c.A24.length?(u=u.replace("[CSS]",""),h()):f())},l.readAsDataURL(a.target.response)},a.send()})},e.send()};c.A24.length?f():(u=u.replace("[CSS]",""),h())}if("canvas"!==c.AA&&!zingchart.AJAXEXPORT)return-1;if("canvas"===c.AA){if(!t.callback||"function"!=typeof t.callback)return c.Z4(o);try{t.callback(c.Z4(o))}catch(b){t.callback(-1)}}else c.OD(o,{},!0,t.callback);break;case"exportimage":case"saveasimage":if(!t.download&&"canvas"!==c.AA&&!zingchart.AJAXEXPORT)return-1;if(o="png",r={},null!==ZC._n_(n=t.options)&&(r=n),null!==ZC._n_(n=t.uid)&&(r.uid=n),null!==ZC._n_(n=t.page)&&(r.page=n),null!==ZC._n_(n=t.format)&&(o=n),null!==ZC._n_(n=t.filetype)&&(o=n),null!==ZC._n_(n=t.filename)&&(s=n),a=c.E.exportimageurl||"",null!==ZC._n_(n=t.url)&&(a=n),l=null,null!==ZC._n_(n=t.callback)&&(l=n),"jpg"===o&&(o="jpeg"),t.download&&("canvas"!==c.AA||"pdf"===o))return r.download=!0,""!==s&&(r.fn=s),void c.OD(o,r);if(""!==a){if("canvas"===c.AA)return C(c.Z4(o));c.OD(o,r,!0,function(e){return C(e)})}break;case"exportdata":if(a=c.E.exportdataurl||"",null!==ZC._n_(n=t.url)&&(a=n),A=ZC.AP.XW(c,"csv"),""===a)return A;l=null,null!==ZC._n_(n=t.callback)&&(l=n),ZC.A5.ajax({type:"post",url:a,data:A,success:function(e,i,t){l&&l(e,i,t)}});break;case"downloadCSV":A=ZC.AP.XW(c,"csv"),ZC.AP.downloadFile(A,(t.fn||c.K)+".csv","text/csv;encoding:utf-8");break;case"downloadXLS":A=ZC.AP.XW(c,"xls");var _=t.sn||"ZingChart";A=A.replace("<x:Name>[ZC]</x:Name>","<x:Name>"+_+"</x:Name>"),ZC.AP.downloadFile(A,(t.fn||c.K)+".xls","application/vnd.ms-excel;encoding:utf-8");break;case"downloadRAW":var g=ZC.AP.XW(c,"raw");if(!t.callback||"function"!=typeof t.callback)return g;try{t.callback(g,t.fn||c.K)}catch(b){t.callback(-1)}break;case"viewDataTable":if("viewdatatable"===t.menuid)if(A=ZC.AP.XW(c,"html"),ZC.AK(c.K+"-data-table"))ZC.AK(c.K+"-data-table").innerHTML=A;else{var v=ZC.Q.HY({id:c.K+"-data-table",cls:"zc-data-table "+c.K+"-data-table"});ZC.Q.PJ(v,{width:c.I+"px","max-height":"400px",overflow:"auto"}),v.innerHTML=A,ZC.AK(c.K).parentNode.insertBefore(v,ZC.AK(c.K).nextSibling)}else"hidedatatable"===t.menuid&&ZC.Q.EU(c.K+"-data-table")}return null},ZC.A8P={},ZC.AP.WQ=function(e){for(var i,t="",n=!1,a=!1,l=0,o="",r=0,s=(e=e.replace(/\t|\r|\n/g,"")).length;r<s;r++)switch(i=e.substr(r,1)){case'"':n=!n,t+=e.substr(r,1),o=i;break;case"{":t+=e.substr(r,1),n||(t+="\n"+new Array(l+1).join("    "),l++,o=i);break;case"}":n||(t+="\n"+new Array(l).join("    "),l--,o=i),t+=e.substr(r,1);break;case"[":var A=e.indexOf("]",r),C=e.indexOf("}",r);C=-1===C?999999:C;var c=e.indexOf("{",r);c=-1===c?999999:c,A<ZC.CY(C,c)?(a=!0,t+=e.substr(r,1)):(a=!1,t+=e.substr(r,1),t+="\n"+new Array(l+1).join("    "),l++),o=i;break;case"]":a&&(a=!1),"}"===o&&(l--,t+="\n"+new Array(l).join("    ")),t+=e.substr(r,1),o=i;break;case" ":n&&(t+=e.substr(r,1),o=i);break;case",":t+=e.substr(r,1),n||a||(t+="\n"+new Array(l).join("    ")),o=i;break;default:t+=e.substr(r,1),o=i}return t},ZC.Q2.prototype.A5O=function(){var e=this;ZC.AP.BY("source_show",e,e.FE());var i=ZC.Q.HY({cls:"zc-abs zc-viewsource zc-style",id:e.K+"-viewsource",p:ZC.AK(e.K+"-top"),wh:e.I-(ZC.quirks?0:10)+"/"+(e.F-(ZC.quirks?0:10))});i.style.zIndex=99,i.innerHTML=ZC._h_('<div class="zc-form-row-label zc-form-s1">&nbsp;<a href="javascript:void(0)" id="'+e.K+'-viewsource-originalsource" class="zc-tab-active">'+ZC.HJ["viewsource-originalsource"]+'</a>&nbsp;<a href="javascript:void(0)" id="'+e.K+'-viewsource-jsonsource" class="zc-tab-inactive">'+ZC.HJ["viewsource-jsonsource"]+'</a></div><div class="zc-form-row-element"><textarea id="'+e.K+'-viewsource-json" style="width:'+(e.I-35)+"px;height:"+(e.F-95)+'px;"></textarea></div><div class="zc-form-row-element zc-form-row-last" id="'+e.K+'-viewsource-actions"><input type="button" value="'+ZC.HJ["viewsource-close"]+'" id="'+e.K+'-viewsource-close" /></div>'),zingchart.EDITSOURCE&&(ZC.AK(e.K+"-viewsource-actions").innerHTML+='<input type="button" value="'+ZC.HJ["viewsource-apply"]+'" id="'+e.K+'-viewsource-apply" />'),ZC.A5("#"+e.K+"-viewsource-json").val(ZC.AP.WQ(e.E.source)),ZC.A5("#"+e.K+"-viewsource-jsonsource").bind("click",function(){ZC.AK(e.K+"-viewsource-jsonsource").className="zc-tab-active",ZC.AK(e.K+"-viewsource-originalsource").className="zc-tab-inactive",ZC.A5("#"+e.K+"-viewsource-json").val(ZC.AP.WQ(e.E.json))}),ZC.A5("#"+e.K+"-viewsource-originalsource").bind("click",function(){ZC.AK(e.K+"-viewsource-jsonsource").className="zc-tab-inactive",ZC.AK(e.K+"-viewsource-originalsource").className="zc-tab-active",ZC.A5("#"+e.K+"-viewsource-json").val(ZC.AP.WQ(e.E.source))}),ZC.A5("#"+e.K+"-viewsource-close").bind("click",function(){ZC.AP.BY("source_hide",e,e.FE()),ZC.Q.EU(e.K+"-viewsource")}),zingchart.EDITSOURCE&&ZC.A5("#"+e.K+"-viewsource-apply").bind("click",function(){ZC.AP.BY("source_hide",e,e.FE());var i=ZC.A5("#"+e.K+"-viewsource-json").val();ZC.Q.EU(e.K+"-viewsource"),zingchart.exec(e.K,"setdata",{data:i})})},ZC.Q2.prototype.A6T=function(){var e=this;if(e.I<300||e.F<300)window.open("http://www.zingchart.com/support/","","");else{var i=ZC.Q.HY({cls:"zc-abs zc-bugreport zc-style",id:e.K+"-bugreport",p:ZC.AK(e.K+"-top"),wh:e.I-(ZC.quirks?0:10)+"/"+(e.F-(ZC.quirks?0:10))}),t="";t+='<div class="zc-form-row-label zc-form-s0">'+ZC.HJ["bugreport-header"]+'</div><div class="zc-form-row-label"><input type="checkbox" id="'+e.K+'-chkdata" checked="checked" /><label for="'+e.K+'-chkdata">'+ZC.HJ["bugreport-senddata"]+"</label>",ZC.canvas&&(t+='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input type="checkbox" id="'+e.K+'-chkcapture" checked="checked" /><label for="'+e.K+'-chkcapture">'+ZC.HJ["bugreport-sendcapture"]+"</label>"),t+='</div><div class="zc-form-row-label zc-form-s1">'+ZC.HJ["bugreport-yourcomment"]+'</div><div class="zc-form-row-element"><textarea id="'+e.K+'-bugreport-comment" style="width:'+(e.I-35)+"px;height:"+((e.F-300)/2-10)+'px;"></textarea></div><div class="zc-form-row-label zc-form-s1">'+ZC.HJ["bugreport-jsondata"]+'</div><div class="zc-form-row-element"><textarea id="'+e.K+'-bugreport-json" style="width:'+(e.I-35)+"px;height:"+(e.F-210)/2+'px;"></textarea></div><div class="zc-form-row-label zc-form-s1">'+ZC.HJ["bugreport-youremail"]+(e.I>=510?" <span>("+ZC.HJ["bugreport-infoemail"]+")</span>":"")+'</div><div class="zc-form-row-element"><input type="text" id="'+e.K+'-bugreport-email" style="width:'+(e.I-35)+'px;" /></div><div class="zc-form-row-element zc-form-row-last"><input type="button" value="'+ZC.HJ["bugreport-submit"]+'" id="'+e.K+'-bugreport-submit" /><input type="button" value="'+ZC.HJ["bugreport-cancel"]+'" id="'+e.K+'-bugreport-cancel" /></div>',i.innerHTML=ZC._h_(t),ZC.A5("#"+e.K+"-bugreport-json").val("PARSED\n----------\n"+ZC.AP.WQ(e.E.json)+"\n\nORIGINAL\n----------\n"+ZC.AP.WQ(e.E.source)),ZC.A5("#"+e.K+"-bugreport-cancel").bind("click",function(){ZC.Q.EU(e.K+"-bugreport")}),ZC.A5("#"+e.K+"-bugreport-submit").bind("click",function(){var i=ZC.A5("#"+e.K+"-bugreport-email"),t="",n=function(){var n=("Parsed:"+e.E.json+" Original:"+e.E.source).replace(/\r|\n|\t|(\s{2,})/g,""),a="",l=[];ZC.A5("#"+e.K+"-chkcapture").attr("checked")&&l.push("****IMAGE:",t),ZC.A5("#"+e.K+"-chkdata").attr("checked")&&l.push("****JSON:",n),l.push("****COMMENT:",ZC.A5("#"+e.K+"-bugreport-comment").val(),"****EMAIL:",i.val(),"****VERSION:",ZC.VERSION,"****WIDTH:",e.I,"****HEIGHT:",e.F,"****URL:",window.location.href,"****UA:",navigator.userAgent,"****RENDER:",e.AA.toUpperCase(),"****RESOLUTION:",screen.width+"x"+screen.height);for(var o=0;o<l.length-1;o+=2)a+=l[o]+encodeURIComponent(l[o+1]);a+="****END";var r=ZC.Q.ABE(ZC.AK(e.K+"-bugreport")),s=r.createElement("FORM");s.action=document.location.protocol+"//www.zingchart.com/support/submitreportH5.php",s.method="post",r.body.appendChild(s);var A=r.createElement("INPUT");A.type="text",A.name="data",A.value=a,s.appendChild(A),s.submit(),window.setTimeout(function(){alert(ZC.HJ["bugreport-confirm"]),ZC.Q.EU(e.K+"-bugreport")},1e3)};"canvas"===e.AA?(t=zingchart.exec(e.K,"getimagedata",{}),n()):t=zingchart.exec(e.K,"getimagedata",{callback:function(e){t=e,n()}})})}},ZC.Q2.prototype.paintHistory=function(){var e,i,t,n=this;ZC.Q.EU([n.K+"-history-path",n.K+"-history-back-path",n.K+"-history-forw-path",n.K+"-history-gradient",n.K+"-history-back-gradient",n.K+"-history-forw-gradient"]),null!==ZC._n_(e=n.o.history)&&(n.IC=new ZC.DN(n),n.B8.load(n.IC.o,"loader.gui.history"),n.IC.append(e),n.IC.parse(),n.IC.A5J=!0,i=new ZC.DT(n),n.B8.load(i.o,"loader.gui.history.item"),i.append(e.item),i.parse(),t=new ZC.DT(n),n.B8.load(t.o,"loader.gui.history.item-off"),t.append(e.item),t.append(e["item-off"]),t.parse());var a="";if(n.IC){n.IC.K=n.K+"-history",n.IC.Z=n.IC.C7=ZC.AK(n.K+"-static-c"),n.IC.paint();var l=n.IC.iX+n.IC.EQ,o=n.IC.iY+n.IC.FM,r=n.IC.I-n.IC.EQ-n.IC.FN,s=n.IC.F-n.IC.FM-n.IC.FU,A=new ZC.DT(n);A.K=n.K+"-history-back",A.copy(i),A.CZ=!1,0===n.NS&&A.copy(t),A.D=[[l,o+s/2],[l+r/3,o],[l+r/3,o+s],[l,o+s/2]],A.IL=ZC.AK(n.A.K+"-text"),A.Z=A.C7=ZC.AK(n.K+"-static-c"),A.parse(),A.paint(),n.NS>0&&(a+=ZC.Q.G0("rect",!0)+'class="'+n.K+'-history-area zc-history-area" id="'+n.K+'-history-back-area" coords="',a+=ZC._i_(l+ZC.MAPTX)+","+ZC._i_(o+ZC.MAPTX)+","+ZC._i_(l+r/3+ZC.MAPTX)+","+ZC._i_(o+s+ZC.MAPTX),a+='" />');var C=new ZC.DT(n);C.K=n.K+"-history-forw",C.copy(i),C.CZ=!1,n.NS!==n.QL.length-1&&0!==n.QL.length||C.copy(t),C.D=[[l+r,o+s/2],[l+2*r/3,o],[l+2*r/3,o+s],[l+r,o+s/2]],C.IL=ZC.AK(n.A.K+"-text"),C.Z=C.C7=ZC.AK(n.K+"-static-c"),C.parse(),C.paint(),n.NS<n.QL.length-1&&(a+=ZC.Q.G0("rect",!0)+'class="'+n.K+'-history-area zc-history-area" id="'+n.K+'-history-forw-area" coords="',a+=ZC._i_(l+2*r/3+ZC.MAPTX)+","+ZC._i_(o+ZC.MAPTX)+","+ZC._i_(l+r+ZC.MAPTX)+","+ZC._i_(o+s+ZC.MAPTX),a+='" />'),""!==a&&(ZC.AK(n.K+"-map").innerHTML+=a),n.A0Q=function(e){e.target.id===n.K+"-history-back-area"?zingchart.exec(n.K,"goback"):e.target.id===n.K+"-history-forw-area"&&zingchart.exec(n.K,"goforward")},ZC.A5("."+n.K+"-history-area").live("click",n.A0Q)}},ZC.AO={A4S:1,E2:0,E3:0,FT:40},ZC.DI={A2T:function(e,i){var t,n;return i.A9%180==0?(t=new ZC.CE(e,-e.I/2,i.iY-e.iY-e.F/4,0),n=new ZC.CE(e,e.I/2,i.iY-e.iY-e.F/4,0)):(t=new ZC.CE(e,i.iX-e.iX-e.I/4,-e.F/2,0),n=new ZC.CE(e,i.iX-e.iX-e.I/4,e.F/2,0)),ZC.TK(Math.atan((n.ED[1]-t.ED[1])/(n.ED[0]-t.ED[0])))+(i.A9%180==0?0:i.A9%360==90?90:-90)},DB:function(e,i,t,n,a,l,o,r,s){s=s||"z";var A,C,c,u,p=new ZC.W6(e,i);switch(s){case"x":A=new ZC.CE(i,t,a,o),C=new ZC.CE(i,n,a,o),c=new ZC.CE(i,n,l,r),u=new ZC.CE(i,t,l,r);break;case"y":A=new ZC.CE(i,t,a,o),C=new ZC.CE(i,t,l,o),c=new ZC.CE(i,n,l,r),u=new ZC.CE(i,n,a,r);break;case"z":A=new ZC.CE(i,t,a,o),C=new ZC.CE(i,t,a,r),c=new ZC.CE(i,n,l,r),u=new ZC.CE(i,n,l,o)}return p.add(A),p.add(C),p.add(c),p.add(u),p},D8:function(e,i,t,n){void 0===n&&(n=!1);var a,l=null,o=null;t instanceof Array?l=t:(l=t.points,o=t.mathpoints);for(var r=new ZC.W6(e,i),s=0,A=l.length;s<A;s++)null!==ZC._n_(l[s])&&(n?r.add(l[s],o?o[s]:null):r.add(new ZC.CE(i,l[s][0],l[s][1],l[s][2]),o?new ZC.CE(i,o[s][0],o[s][1],o[s][2]):null));return(a=e.o["z-modifier"])&&(r.MD=[ZC._i_(a),ZC._i_(a),ZC._i_(a)]),r}};var CE={$i:function(e,i,t,n){this.parse(e,i,t,n)},parse:function(e,i,t,n){var a=this;a.C=e,a.iX=i,a.iY=t,n-=a.C.F0.depth/2,a.iZ=n,a.EL=0,a.EO=0,a.AAP=0,a.ED=[];var l=a.C.F0.angle,o=a.C.F0.zoom;if(a.C.F0.true3d){var r={x:i,y:t,z:n},s={x:0,y:0,z:0},A={x:a.C.F0["x-angle"],y:a.C.F0["y-angle"],z:a.C.F0["z-angle"]},C=2*Math.PI/360,c=Math.sin(A.x*C),u=Math.sin(A.y*C),p=Math.sin(A.z*C),Z=Math.cos(A.x*C),h=Math.cos(A.y*C),d=Math.cos(A.z*C);a.EL=h*(p*(r.y-s.y)+d*(r.x-s.x))-u*(r.z-s.z),a.EO=c*(h*(r.z-s.z)+u*(p*(r.y-s.y)+d*(r.x-s.x)))+Z*(d*(r.y-s.y)-p*(r.x-s.x)),a.AAP=Z*(h*(r.z-s.z)+u*(p*(r.y-s.y)+d*(r.x-s.x)))-c*(d*(r.y-s.y)-p*(r.x-s.x)),a.ED[0]=ZC.AO.E2+ZC.AO.A4S/(ZC.AO.A4S+a.AAP)*a.EL*o,a.ED[1]=ZC.AO.E3+ZC.AO.A4S/(ZC.AO.A4S+a.AAP)*a.EO*o}else a.ED[0]=ZC.AO.E2+i+n*ZC.EH(l)*o,a.ED[1]=ZC.AO.E3+t-n*ZC.EP(l)*o}};ZC.CE=ZC.C9.CA(CE);var W6={$i:function(e,i){var t=this;t.C=i,t.N=e,t.K="",t.K9=!1,t.MD=[1,1,1],t.FX=-1,t.D=[],t.PA=[],t.SO=-9999,t.ZS=-9999,t.A5C=9999,t.A4U=9999,t.A9J=9999,t.A3M=0,t.A20=0,t.ABY=0},add:function(e,i){this.D.push(e),this.PA.push(i||e)},ADC:function(){for(var e=this,i=e.PA.length,t=0;t<i;t++){var n=e.PA[t];e.SO=ZC.BQ(e.SO,n.iZ),ZC._b_(e.C.F0.true3d)?(e.A5C=ZC.CY(e.A5C,n.iZ),e.ZS=ZC.BQ(e.ZS,n.AAP),e.A20+=n.iY):(e.A4U=ZC.CY(e.A4U,n.iX),e.A9J=ZC.CY(e.A9J,n.iY),e.A3M+=n.iX,e.A20+=n.iY,e.ABY+=n.iZ)}e.A3M/=i,e.A20/=i,e.ABY/=i},FF:function(){for(var e=this,i="",t=0,n=e.D.length;t<n;t++)i+=ZC._i_(e.D[t].ED[0]+ZC.MAPTX)+","+ZC._i_(e.D[t].ED[1]+ZC.MAPTX)+",";return i=i.substring(0,i.length-1)}};ZC.W6=ZC.C9.CA(W6);var SJ={$i:function(){var e=this;e.A52=[],e.A6I={},e.WW=[],e.SH={}},clear:function(){var e=this;e.A52=[],e.WW=[],e.SH={}},add:function(e){this.A52.push(e)},sortFaces:function(e,i){return 1===zingchart.V3D?e[0][0]>i[0][0]?-1:e[0][0]<i[0][0]?1:e[0][1]>i[0][1]?1:e[0][1]<i[0][1]?-1:e[0][2]>i[0][2]?-1:e[0][2]<i[0][2]?1:e[0][3]>i[0][3]?-1:e[0][3]<i[0][3]?1:0:2===zingchart.V3D?-1!==e[0][3]||-1!==i[0][3]?e[0][3]>i[0][3]?1:e[0][3]<i[0][3]?-1:0:e[0][0]>i[0][0]?-1:e[0][0]<i[0][0]?1:e[0][1]>i[0][1]?1:e[0][1]<i[0][1]?-1:e[0][2]>i[0][2]?1:e[0][2]<i[0][2]?-1:0:3===zingchart.V3D?e[0]>i[0]?-1:e[0]<i[0]?1:0:void 0}};ZC.SJ=ZC.C9.CA(SJ);var A27={$i:function(e){var i=this;i.H=e,i.VE=!1,i.OP=250,i.GI=0,i.IH=0,i.GZ=20,i.BA="",i.CG=[],i.A7=null},onmouseout:function(){var e=this;ZC.mobile||(e.VE?(null!==ZC._n_(e.C4)&&window.clearInterval(e.C4),e.C4=window.setInterval(function(){var i=e.H.K,t=ZC.A5("#"+i+("svg"===e.H.AA?"-top":"-main")),n=ZC.E1[0]-t.offset().left,a=ZC.E1[1]-t.offset().top;ZC.DS(n,e.GI,e.GI+e.A7.I)&&ZC.DS(a,e.IH,e.IH+e.A7.F)||(null!==ZC._n_(e.C4)&&window.clearInterval(e.C4),e.hide())},e.OP)):e.hide())},clear:function(){var e=this;ZC.Q.IU(ZC.AK(e.H.K+"-tooltip-c"),e.H.AA,e.iX,e.iY,e.I,e.F,e.K)},hide:function(){if(!ZC.TTLOCK){var e=this.H.K;ZC.Q.EU([e+"-tooltip-text",e+"-tooltip",e+"-tooltip-text-float"]),"svg"===this.H.AA&&ZC.A5("clipPath").each(function(){-1!==this.id.indexOf("-hover_image-clip")&&ZC.Q.EU(this.id)})}},show:function(e){var i,t=this;null!==ZC._n_(t.C4)&&window.clearInterval(t.C4);var n=t.H.K;if(0!==ZC.A5("#"+n+"-tooltip-c").length&&t.A7){var a=ZC._tx_(t.H.K),l=ZC.Q.MB(e),o=ZC.A5("#"+n+("svg"===t.H.AA?"-top":"-main")),r=null===ZC._n_(e.target)?t.A7.o.x:l[0]-o.offset().left,s=null===ZC._n_(e.target)?t.A7.o.y:l[1]-o.offset().top,A=r-t.A7.I*a[0]/2,C=s-t.A7.F*a[1],c=A,u=1+2*t.A7.JW;if(null!==ZC._n_(t.A7.o.x)&&((A=ZC.II(t.A7.o.x,!0))>0&&A<1&&(A=ZC._i_(t.H.I*A)),t.A7.o.fixed&&(A-=t.A7.I/2)),null!==ZC._n_(t.A7.o.y)&&((C=ZC.II(t.A7.o.y,!0))>0&&C<1&&(C=ZC._i_(t.H.F*C)),t.A7.o.fixed&&(C-=t.A7.F/2)),A+=ZC._i_(t.A7.E["offset-x"]),C+=ZC._i_(t.A7.E["offset-y"]),"svg"===t.H.AA||!t.A7.o.placement||t.A7.o.fixed){var p=0,Z=!1,h=t.A7.EM;A/a[0]<u&&(p=c/a[0]-u-t.A7.H9/2,A=u),A/a[0]+t.A7.I>t.H.I-u&&(p=c/a[0]+t.A7.I-t.H.I+u+t.A7.H9/2,A=(t.H.I-u-t.A7.I)*a[0]),C/a[1]<u&&(t.CG.node||!t.A7.o.placement||t.A7.o.fixed?(C=u+ZC._i_(t.A7.E["offset-y"]),C=t.CG.node?C<u?u:C:C<u?s-ZC._i_(t.A7.E["offset-y"]):C,h="top",Z=!0):C=u+(s-ZC._i_(t.A7.E["offset-y"]))),C/a[1]+t.A7.F>t.H.F-u&&(C=t.H.F-u-t.A7.F,(t.CG.node||!t.A7.o.placement||t.A7.o.fixed)&&(h="top",Z=!0)),Z&&(t.A7.EM=h),(0!==p||Z)&&t.A7.Z&&(t.clear(),Z&&(t.A7.EM=h),p=ZC.CY(p,t.A7.I/2-t.A7.H9/2),p=48*(p=ZC.BQ(p,-t.A7.I/2+t.A7.H9/2))/(t.A7.I/2-t.A7.H9/2),t.A7.EV=p,t.A7.AN&&t.A7.paint())}switch(t.GI=A,t.IH=C,t.H.AA){case"svg":null===ZC._n_(t.A7.o.x)&&null===ZC._n_(t.A7.o.y)&&ZC.AK(n+"-tooltip").setAttribute("transform","translate("+A/a[0]+","+C/a[1]+")"),t.A7.E["html-mode"]&&ZC.Q.PJ(ZC.AK(n+"-tooltip-text-float"),{left:(""===t.BA?A/a[0]:t.A7.iX)+t.A7.EQ+"px",top:(""===t.BA?C/a[1]:t.A7.iY)+t.A7.FM+"px"});break;case"vml":null===ZC._n_(t.A7.o.x)&&null===ZC._n_(t.A7.o.y)&&ZC.Q.PJ(ZC.AK(n+"-tooltip"),{left:A+"px",top:C+"px"});break;case"canvas":null!==ZC._n_(t.CG.x)&&(A=t.CG.x),null!==ZC._n_(t.CG.y)&&(C=t.CG.y);var d=t.A7.E["html-mode"]?0:20;switch(t.A7.WT){case"tl":break;case"tr":A-=t.A7.I;break;case"bl":C-=t.A7.F;break;case"br":A-=t.A7.I,C-=t.A7.F;break;case"c":A-=t.A7.I/2,C-=t.A7.F/2;break;case"t":A-=t.A7.I/2;break;case"r":A-=t.A7.I,C-=t.A7.F/2;break;case"b":A-=t.A7.I/2,C-=t.A7.F;break;case"l":C-=t.A7.F/2}ZC.Q.PJ(ZC.AK(n+"-tooltip-c"),{left:A/a[0]-d+"px",top:C/a[1]-d+"px"}),null!==(i=ZC.AK(n+"-tooltip-text"))&&(i.style.display="none",ZC.Q.PJ(i,{width:t.A7.I+"px",height:t.A7.F+"px",left:A/a[0]+"px",top:C/a[1]+"px"}),i.style.display="block")}}},onmousemove:function(e){this.show(e)},onmouseover:function(e,i){var t,n,a,l,o,r,s,A=this,C=A.H.K,c=e.targetid||e.target.id,u=c.replace(/--([a-zA-Z0-9]+)/,"").replace("-gshape-area","-area").replace("-area-path","").replace("-path","").replace("-marker-circle","").replace("-marker","").split("-").reverse(),p=c.split("--"),Z=!1,h=!1,d=!1;if("node"===u[1]&&"plot"===u[3]&&"plotset"===u[4]&&(Z=!0),ZC.Q.EU([C+"-tooltip-text",C+"-tooltip",C+"-tooltip-text-float"]),Z){if(!(l=A.H.OQ(u[5])))return;if(o=l.AY.A4[u[2]],r=o.FK(u[0]),"xy"===l.AJ.layout&&r.T6(),!r)return;ZC.A5("#"+C+"-graph-"+u[5]+"-plot-"+u[2]+"-bg-hover-c").show()}else"legend"===u[2]&&0===u[1].indexOf("item")&&(h=!0),0!==u[2].indexOf("scale")||0!==u[1].indexOf("item")&&0!==u[1].indexOf("marker")||(d=!0),l=A.H.OQ(u[3]);if(ZC.AK(C+"-tooltip")||(ZC.Q.JZ({id:C+"-tooltip",p:ZC.AK(C+"-main"),cls:"zc-abs zc-tooltip",wh:A.H.I+"/"+A.H.F,overflow:"hidden"},A.H.AA),ZC.Q.HC({id:C+"-tooltip-c",p:ZC.AK(C+"-tooltip"),cls:"zc-abs",tl:"-999/-999",width:140,height:60},A.H.AA)),A.A7=zingchart.pool.getInstance("DN",A,C+"-tooltip-text"),A.A7.OG="tooltip",A.A7.A=A.H,l&&l.A7&&A.A7.copy(l.A7),Z)A.A7.append(o.A7.o),l.CB["p"+o.L]&&l.CB["p"+o.L]["n"+r.L]&&A.A7.append(o.A7.o["selected-state"]),2===p.length&&A.A7.append(o.ABZ(p[1]));else{var f=!1;if(h&&l.BD&&null!==ZC._n_(l.BD.o.tooltip)&&(A.A7.o.text="",A.A7.append(l.BD.o.tooltip),f=!0),d){A.A7.append({"background-color":"#fff","border-width":1,"border-color":"#999"});var _=l.BL(u[2].replace(/\_/g,"-"));if(_&&null!==ZC._n_(_.o.tooltip)&&(A.A7.o.text="",A.A7.append(_.o.tooltip),f=!0),0===u[1].indexOf("item_"))_&&(-1!==u[1].indexOf("_title")&&_.o.label&&_.o.label.tooltip?(A.A7.o.text="",A.A7.append(_.o.label.tooltip),f=!0):_.o.item&&_.o.item.tooltip&&(A.A7.o.text="",A.A7.append(_.o.item.tooltip),f=!0));else if(0===u[1].indexOf("marker_")){var g=ZC._i_(u[1].replace("marker_",""));_.Q4[g]&&_.Q4[g].o.label&&_.Q4[g].o.label.tooltip&&(A.A7.o.text="",A.A7.append(_.Q4[g].o.label.tooltip),f=!0)}}if("shape"===u[2])if(A.A7.append({"background-color":"#fff","border-width":1,"border-color":"#999"}),e.target.getAttribute("data-lowlevel"))A.A7.append({text:e.target.getAttribute("data-tooltip-text")}),f=!0;else for(n=0,a=l.FH.length;n<a;n++)if(null!==ZC._n_(l.FH[n])){var v=l.FH[n]instanceof ZC.OY?l.FH[n].BG:l.FH[n];l.K+"-shape-"+u[1]===l.FH[n].K&&null!==ZC._n_(t=v.o.tooltip)&&(A.A7.append(t),A.A7.o.fixed&&(A.A7.o.x=v.iX,A.A7.o.y=v.iY),f=!0)}if("label"===u[2])for(A.A7.append({"background-color":"#fff","border-width":1,"border-color":"#999"}),n=0,a=l.BX.length;n<a;n++)l.K+"-label-"+u[1]===l.BX[n].K&&null!==ZC._n_(t=l.BX[n].o.tooltip)&&(A.A7.append(t),A.A7.o.fixed&&(A.A7.o.x=l.BX[n].iX+l.BX[n].I/2,A.A7.o.y=l.BX[n].iY+l.BX[n].F/2),f=!0);if("xy"===u[2]&&(A.A7.append({"background-color":"#fff","border-width":1,"border-color":"#999"}),f=!0),!f)return}i&&A.A7.append(i),A.VE=!1,A.OP=250,null!==ZC._n_(t=A.A7.o.sticky)&&(A.VE=ZC._b_(t)),null!==ZC._n_(t=A.A7.o.timeout)&&(A.OP=ZC._i_(t)),null!==ZC._n_(t=A.A7.o.placement)?A.BA=t:A.BA="",null!==ZC._n_(t=A.A7.o.distance)&&(A.GZ=ZC._i_(t)),A.A7.iX=0,A.A7.iY=0,A.A7.Z=A.A7.C7=ZC.AK(C+"-tooltip-c");var b={};if(Z)s=r.Y4(),r.H3(s),null!==ZC._n_(s["line-color"])?A.A7.A0=A.A7.AE=ZC.AP.JN(s["line-color"]):A.A7.A0=A.A7.AE=ZC.AP.JN(s["background-color"]),A.A7.BW=s["border-color"],A.A7.C2=s.color,null!==ZC._n_(o.o.rules)?(A.A00||(A.A00=new ZC.HV(o.A),A.A00.E["quick-parse"]=!0),A.A00.append(o.o),A.A00.parse(),A.A00.J2=function(e){return r.J2(e)},A.A00.DE()&&A.A00.parse(),A.A7.AM=A.A00.JB):A.A7.AM=o.JB,b=ZC.AP.O3(A.A7.o,o.o),A.A7.JV=function(e){return r.JV(e,b)},A.A7.E.plotidx=r.A.L,A.A7.E.nodeidx=r.L;else if(h){for(o=l.AY.A4[u[1].replace("item_","")],A.A7.append(o.o["legend-tooltip"]),r=null,n=0,a=o.S.length;n<a;n++)if(null!==o.S[n]){r=o.FK(n);break}if(r){if("-1"===(s=r.Y4())["background-color"])return;A.A7.A0=A.A7.AE=ZC.AP.JN(s["background-color"]),A.A7.C2=s.color}else A.A7.A0=A.A7.AE=ZC.AP.JN(o.BP[1]),A.A7.C2=o.BP[0];A.A7.AM=o.P2,A.A7.JV=function(e){return e=(e=e.replace(/%plot-description/g,o.P2)).replace(/%plot-text|%t/g,o.AM)}}else if(d){if(0===u[1].indexOf("item_")){var B=u[1].replace("item_","").split("_"),m=1===B.length?ZC._i_(B[0]):ZC._i_(B[1]);A.A7.JV=function(e){e=e||"%scale-value";var i=_.BX[m]||_.V[m];if(_.FG){var t={"transform-date":!0,"transform-date-format":_.FG.o.all||_.FG.o.text||"",utc:l.UL,timezone:l.NB};i=ZC.AP.G2(i,t,A.A,!!_.FG&&_.FG)}for(var n in"number"==typeof i&&_.IQ&&null!==ZC._n_(_.IQ[i])&&(i=_.IQ[i]),e=(e=e.replace(/%text|%item-text|%scale-value|%v/g,i)).replace(/%tooltip-text/g,_.A53[m]||""),_.o)_.o.hasOwnProperty(n)&&"data-"===n.substring(0,5)&&(e=e.replace("%"+n,_.o[n][m]||"","g"));return e}}}else A.A7.JV=function(e){return e};if(null===ZC._n_(A.A7.o["text-alpha"])&&(A.A7.o["text-alpha"]=1),A.A7.parse(),!Z&&"canvas"!==A.H.AA&&A.A7.o.fixed&&(A.A7.iX=A.A7.iX-A.A7.I/2+A.A7.BM,A.A7.iY=A.A7.iY-A.A7.F/2+A.A7.BH),A.A7.AN){var E,D;if(A.A7.HT&&(Z&&A.A7.H3(A.A7,A.A7,null,r.LT(e,!1)),A.A7.parse()),A.A7.E["html-mode"]=!1,null!==ZC._n_(t=A.A7.o["html-mode"])&&(A.A7.E["html-mode"]=ZC._b_(t)),Z&&(A.A7.J2=function(e){return r.J2(e)},A.A7.DE()&&(b=A.A7.overrideFormat(b),A.A7.parse())),"canvas"!==A.H.AA&&"vml"!==A.H.AA||0===A.A7.A9)E=A.A7.I+A.A7.JW,D=A.A7.F+A.A7.JW,E+=40,D+=40,A.A7.E["offset-x"]=A.A7.BM,A.A7.E["offset-y"]=A.A7.BH;else{var K=1.25*ZC.BQ(A.A7.I,A.A7.F)+A.A7.JW;E=K,D=K,A.A7.iX+=(K-A.A7.I)/2,A.A7.iY+=(K-A.A7.F)/2,A.A7.E["offset-x"]=-(K-A.A7.I)/2+A.A7.BM,A.A7.E["offset-y"]=-(K-A.A7.F)/2+A.A7.BH}if(ZC.A5("#"+C+"-tooltip-c").attr("width",E).attr("height",D),"vml"===A.H.AA&&ZC.Q.PJ(ZC.AK(C+"-tooltip-c"),{top:0,left:0}),A.A7.QF=A.A7.BM,A.A7.ME=A.A7.BH,A.A7.BM=0,A.A7.BH=0,!e.type&&Z){var F=r.iX,x=r.iY;if(null!==ZC._n_(r.bCXY)){var I=r.ACE();F=I[0],x=I[1]}"canvas"===A.H.AA?(null===ZC._n_(A.A7.o.x)&&(A.A7.o.x=F-A.A7.I/2),null===ZC._n_(A.A7.o.y)&&(A.A7.o.y=x-A.A7.F)):(null===ZC._n_(A.A7.o.x)&&(A.A7.iX=F-A.A7.I/2),null===ZC._n_(A.A7.o.y)&&(A.A7.iY=x-A.A7.F-20))}if(Z&&(A.CG=A.getPlacementInfo(r),""!==A.BA&&("canvas"!==A.H.AA?(A.A7.o.x=A.A7.iX=A.CG.x,A.A7.o.y=A.A7.iY=A.CG.y):(A.A7.o.x=A.A7.iX=0,A.A7.o.y=A.A7.iY=0),A.A7.EM=A.CG.cp,A.A7.EV=A.CG.co)),A.A7.AN&&""!==A.A7.AM&&("canvas"===A.H.AA&&(A.A7.E["html-mode"]||(A.A7.iX=20,A.A7.iY=20)),A.A7.paint()),(e.type&&Z||e.update)&&(r.AB2(),r.C.QR(!0)),e.type||"canvas"===A.H.AA)A.show(e);else if(A.A7.E["html-mode"]){var y=A.A7.iX+A.A7.EQ,w=A.A7.iY+A.A7.FM;ZC.Q.PJ(ZC.AK(C+"-tooltip-text-float"),{left:y+"px",top:w+"px",zIndex:zingchart.ZINDEX})}}},getPlacementInfo:function(e){var i,t=this,n={},a=t.A7.H9,l=t.A7.G8,o=t.A7.I,r=t.A7.F;if(t.A7.E["html-mode"]&&("horizontal"===t.BA||"vertical"===t.BA||"node:"===t.BA.substring(0,5))&&(t.A7.iX=-9999,t.A7.iY=-9999,t.A7.AN)){t.A7.paint();var s=ZC.A5("#"+t.H.K+"-tooltip-text-"+("canvas"===t.H.AA?"t":"float"));o=s.width()+t.A7.EQ+t.A7.FN,r=s.height()+t.A7.FM+t.A7.FU,null!==ZC._n_(t.A7.o.width)&&(o=ZC._i_(t.A7.o.width)),null!==ZC._n_(t.A7.o.height)&&(r=ZC._i_(t.A7.o.height))}if("horizontal"===t.BA)e.iX+e.I/2<e.C.iX+e.C.I/2?(n.x=e.iX+0*e.I+t.GZ,n.y=e.iY+0*e.F/2-r/2,n.cp="left"):(n.x=e.iX-o-t.GZ,n.y=e.iY+0*e.F/2-r/2,n.cp="right"),n.y<5&&(i=5-n.y,n.co=-ZC._i_(100*i/(r-l)),n.y=5),n.y+r>t.H.F-5&&(i=t.H.F-5-n.y-r,n.co=-ZC._i_(100*i/(r-l)),n.y=t.H.F-5-r);else if("vertical"===t.BA)e.iY+e.F/2<e.C.iY+e.C.F/2?(n.y=e.iY+0*e.F+t.GZ,n.x=e.iX+0*e.I/2-o/2,n.cp="top"):(n.y=e.iY-r-t.GZ,n.x=e.iX+0*e.I/2-o/2,n.cp="bottom"),n.x<5&&(i=5-n.x,n.co=-ZC._i_(100*i/(t.A7.I-a)),n.x=5),n.x+o>t.H.I-5&&(i=t.H.I-5-n.x-o,n.co=-ZC._i_(100*i/(o-a)),n.x=t.H.I-5-o);else if("node:"===t.BA.substring(0,5)&&e.getTooltipPosition){switch((n=e.getTooltipPosition(t.A7,t.BA.substring(5))).node=!0,n.side=t.BA.substring(5),n.side){case"left":n.x=n.x-o+t.A7.QF,n.y=n.y-r/2+t.A7.ME;break;case"right":n.x=n.x+t.A7.QF,n.y=n.y-r/2+t.A7.ME;break;case"top":n.x=n.x-o/2+t.A7.QF,n.y=n.y-r+t.A7.ME;break;case"bottom":n.x=n.x-o/2+t.A7.QF,n.y=n.y+t.A7.ME;break;case"center":n.x=n.x-o/2+t.A7.QF,n.y=n.y-r/2+t.A7.ME}n.cp=t.A7.EM}if(n.node){var A=0;n.y+r>t.H.F-5&&("top"===n.side||"bottom"===n.side?(n.y=n.y-r-("bottom"===n.side?0:t.A7.G8)-t.A7.ME,n.cp="bottom"):n.y=t.H.F-r-5),n.y<5&&("top"===n.side||"bottom"===n.side?(n.y=n.y+("top"===n.side?0:t.A7.G8)+r-t.A7.ME,n.cp="top"):n.y=5),n.x+o>t.H.I-5&&("left"===n.side||"right"===n.side?(n.x=n.x-o-t.A7.QF-5,n.cp="right"):(A=48*(o-t.H.I+n.x+t.A7.H9/2)/(t.A7.I/2),n.x=t.H.I-o-t.A7.QF-5),n.co=A),n.x<5&&("left"===n.side||"right"===n.side?(n.x=n.x+t.A7.I-t.A7.QF+5,n.cp="left"):(A=48*(n.x-t.A7.H9/2)/(t.A7.I/2),n.x=5),n.co=A)}return n}};ZC.A27=ZC.C9.CA(A27);var A4Z={$i:function(e){this.b(e);var i=this;i.H=e,i.IM=!1,i.C=null,i.PO=null,i.UK=null,i.I8=0,i.LE=0,i.I7=0,i.LF=0,i.A8=null,i.AL=null,i.Z9=!1,i.AB9=0,i.A0G=!1,i.M=null},parse:function(){var e=this;e.C&&(e.C.H2&&e.append(e.C.H2.o),e.b(),e.ZQ("preserve-zoom","A0G","b"),e.M=new ZC.DN(e),e.C.A.B8.load(e.M.o,"graph.zoom.label"),e.M.append(e.o.label),e.M.parse(),e.o.label&&!1!==e.o.label.visible&&(e.M.AN=!0))},unbind:function(){var e=this;zingchart.DEV.SKIPTRACKERS?ZC.A5(document.body).unbind("mousedown touchstart",e.R3):ZC.A5("#"+e.H.K+"-img").unbind("mousedown touchstart",e.R3),ZC.A5(".zc-node-area").die("mousedown touchstart",e.R3),ZC.A5(document.body).unbind("mousemove touchmove",e.U4),ZC.A5(document.body).unbind("mouseup touchend",e.TZ)},bind:function(){var e=this,i=e.H.K;e.R3=function(t){if((!ZC.mobile||"pinch"!==zingchart.TOUCHZOOM)&&!(t.which>1||-1!==ZC.Q.T8(t.target).indexOf("zc-menu-item")||ZC.move)&&("mousedown"!==t.type||!ZC.TOUCHEVENTS)&&-1===t.target.id.indexOf("-legend-header-area")&&(ZC.mobile||t.preventDefault(),e.H.hideCM(),(ZC.mobile||!(t.which>1))&&("vml"!==e.H.AA||-1===t.target.className.indexOf("zc-node-area")))){t.shiftKey&&(e.Z9=!0);var n=ZC.Q.MB(t),a=ZC._tx_(e.H.K),l=ZC.A5("#"+i+"-top").offset(),o=(n[0]-l.left)/a[0],r=(n[1]-l.top)/a[1];e.PO=o,e.UK=r,e.Z9&&(e.AB9=o);for(var s,A=!1,C=0,c=e.H.AG.length;C<c;C++)s=e.H.AG[C].P,ZC.DS(o,s.iX-5,s.iX+s.I+5)&&ZC.DS(r,s.iY-5,s.iY+s.F+5)&&(e.C=e.H.AG[C]);if(null!==e.C){var u={id:e.H.K,graphid:e.C.K,ev:t},p=ZC.AP.BY("beforezoom",e.H,u,!0);if(void 0!==p&&!p)return;if(e.C.H2&&null!==ZC._n_(e.C.H2.o.active)&&!ZC._b_(e.C.H2.o.active))return;s=e.C.P,e.C.AY.A4.length>0&&(e.A8=e.C.BL(e.C.AY.A4[0].BU("k")[0]),e.AL=e.C.BL(e.C.AY.A4[0].BU("v")[0])),null!==e.A8&&null!==e.AL&&e.C.AJ["enable-zooming"]&&(e.A8.GO||e.AL.GO)&&(e.I8=e.A8.CO?r:o,e.I7=e.AL.CO?o:r,A=!0,e.A8.GO?e.A8.CO?e.I8=ZC._l_(e.I8,s.iY,s.iY+s.F):e.I8=ZC._l_(e.I8,s.iX,s.iX+s.I):e.I8=e.A8.CO?s.iY:s.iX,e.AL.GO?e.AL.CO?e.I7=ZC._l_(e.I7,s.iX,s.iX+s.I):e.I7=ZC._l_(e.I7,s.iY,s.iY+s.F):e.I7=e.AL.CO?s.iX:s.iY)}return A&&(e.LE=e.I8,e.LF=e.I7,e.IM=!0,ZC.A5(document.body).bind("mousemove touchmove",e.U4),ZC.A5(document.body).bind("mouseup touchend",e.TZ),e.Z9?document.body.style.cursor="pointer":(e.parse(),e.C.AJ["3d"]||ZC.Q.HY({id:i+"-zoom",p:ZC.AK(i+"-top"),top:-9,left:-9,wh:"1/1",position:"absolute",border:e.AU+"px solid "+e.BW,background:e.A0,opacity:e.C6}),e.M.AN&&(ZC.Q.HY({id:i+"-from",p:ZC.AK(i+"-top"),top:-9999,left:-9999,position:"absolute",paddingTop:e.M.FM,paddingRight:e.M.FN,paddingBottom:e.M.FU,paddingLeft:e.M.EQ,border:e.M.AU+"px solid "+e.M.BW,background:e.M.A0,color:e.M.C2,fontFamily:e.M.GH,fontWeight:e.M.sFontWeight,fontStyle:e.M.N5?"oblique":"normal",fontSize:e.M.DG,text:""}),ZC.Q.HY({id:i+"-to",p:ZC.AK(i+"-top"),top:-9999,left:-9999,position:"absolute",paddingTop:e.M.FM,paddingRight:e.M.FN,paddingBottom:e.M.FU,paddingLeft:e.M.EQ,border:e.M.AU+"px solid "+e.M.BW,background:e.M.A0,color:e.M.C2,fontFamily:e.M.GH,fontWeight:e.M.sFontWeight,fontStyle:e.M.N5?"oblique":"normal",fontSize:e.M.DG,text:""})),document.body.style.cursor="crosshair")),!!ZC.mobile&&void 0}},e.U4=function(t){if("mousemove"!==t.type||!ZC.TOUCHEVENTS){var n,a;if(ZC.mobile||t.preventDefault(),ZC.move=!0,e.C||(ZC.move=!1,e.IM=!1,ZC.A5(document.body).unbind("mousemove touchmove",e.U4),ZC.A5(document.body).unbind("mouseup touchend",e.TZ),document.body.style.cursor="auto",ZC.Q.EU([i+"-zoom",i+"-from",i+"-to"])),e.IM){e.C.A.A7.hide();var l=ZC.Q.MB(t),o=ZC._tx_(e.H.K),r=ZC.A5("#"+i+"-top").offset(),s=(l[0]-r.left)/o[0],A=(l[1]-r.top)/o[1];if(t.ctrlKey){var C=ZC.CY(s-e.PO,A-e.UK);s=e.PO+C,A=e.UK+C}if(e.LE=e.A8.CO?A:s,e.LF=e.AL.CO?s:A,!e.Z9){var c,u,p,Z,h=e.C.P;n=e.A8.AW?e.A8.BV:e.A8.AB,a=e.A8.AW?e.A8.AB:e.A8.BV,e.A8.GO?e.A8.CO?(e.A8.Y7&&(e.I8=e.A8.iY+n+e.A8.AC*ZC._i_((e.I8-e.A8.iY-n)/e.A8.AC),e.LE=e.A8.iY+n+e.A8.AC*ZC._i_((e.LE-e.A8.iY-n)/e.A8.AC)),e.I8=ZC._l_(e.I8,h.iY+a,h.iY+h.F-n),e.LE=ZC._l_(e.LE,h.iY+a,h.iY+h.F-n)):(e.A8.Y7&&(e.I8=e.A8.iX+n+e.A8.AC*ZC._i_((e.I8-e.A8.iX-n)/e.A8.AC),e.LE=e.A8.iX+n+e.A8.AC*ZC._i_((e.LE-e.A8.iX-n)/e.A8.AC)),e.I8=ZC._l_(e.I8,h.iX+n,h.iX+h.I-a),e.LE=ZC._l_(e.LE,h.iX+n,h.iX+h.I-a)):(e.I8=e.A8.CO?h.iY+a:h.iX+n,e.LE=e.A8.CO?h.iY+h.F-n:h.iX+h.I-a),n=e.AL.AW?e.AL.AB:e.AL.BV,a=e.AL.AW?e.AL.BV:e.AL.AB,e.AL.GO?e.AL.CO?(e.AL.Y7&&(e.I7=e.AL.iX+n+e.AL.AC*ZC._i_((e.I7-e.AL.iX-n)/e.AL.AC),e.LF=e.AL.iX+n+e.AL.AC*ZC._i_((e.LF-e.AL.iX-n)/e.AL.AC)),e.I7=ZC._l_(e.I7,h.iX+a,h.iX+h.I-n),e.LF=ZC._l_(e.LF,h.iX+a,h.iX+h.I-n)):(e.AL.Y7&&(e.I7=e.AL.iY+n+e.AL.AC*ZC._i_((e.I7-e.AL.iY-n)/e.AL.AC),e.LF=e.AL.iY+n+e.AL.AC*ZC._i_((e.LF-e.AL.iY-n)/e.AL.AC)),e.I7=ZC._l_(e.I7,h.iY+n,h.iY+h.F-a),e.LF=ZC._l_(e.LF,h.iY+n,h.iY+h.F-a)):(e.I7=e.AL.CO?h.iX+a:h.iY+n,e.LF=e.AL.CO?h.iX+h.I-n:h.iY+h.F-a);var d=ZC.A5.browser.msie?0:2*e.AU;e.C.AJ["3d"]&&(d=0);var f=ZC.AK(i+"-zoom");if(e.A8.CO&&e.AL.CO?(c=ZC._a_(e.LF-e.I7-d),u=ZC._a_(e.LE-e.I8-d),p=ZC.CY(e.I7,e.LF),Z=ZC.CY(e.I8,e.LE)):(c=ZC._a_(e.LE-e.I8-d),u=ZC._a_(e.LF-e.I7-d),p=ZC.CY(e.I8,e.LE),Z=ZC.CY(e.I7,e.LF)),e.C.AJ["3d"]){e.C.NX();var _=ZC.AK(e.H.K+"-guide-c");_&&(ZC.Q.IU(_,e.H.AA,e.C.iX,e.C.iY,e.C.I,e.C.F),ZC.A5(".zc-guide-label").remove()),(f=new ZC.DT(e)).Z=_,f.A0=f.AE=e.A0,f.BW=e.BW,f.AU=e.AU,f.C6=e.C6,f.D=[[p,Z],[p+c,Z],[p+c,Z+u],[p,Z+u],[p,Z]];for(var g=0;g<f.D.length;g++){var v=new ZC.CE(e.C,f.D[g][0]-ZC.AO.E2,f.D[g][1]-ZC.AO.E3,0);f.D[g][0]=v.ED[0],f.D[g][1]=v.ED[1]}f.parse(),f.paint()}else ZC.Q.PJ(f,{width:c+"px",height:u+"px",left:p+"px",top:Z+"px"});if(e.M.AN){var b=ZC.CY(e.I8,e.LE),B=ZC.BQ(e.I8,e.LE),m=ZC.CY(e.I7,e.LF),E=ZC.BQ(e.I7,e.LF),D=ZC.AK(i+"-from"),K=ZC.AK(i+"-to"),F={decimals:null===ZC._n_(e.AL.DQ)?1:e.AL.DQ};D.innerHTML=e.A8.FQ(e.A8.OE(b))+"/"+e.AL.FQ(-1,e.AL.NE(m),F),K.innerHTML=e.A8.FQ(e.A8.OE(B))+"/"+e.AL.FQ(-1,e.AL.NE(E),F),ZC.Q.PJ(D,{left:p-e.AU-ZC._i_(ZC.A5(D).width())+"px",top:Z-e.AU-ZC._i_(ZC.A5(D).height())+"px"}),ZC.Q.PJ(K,{left:p+e.AU+e.M.AU+c+"px",top:Z+e.AU+e.M.AU+u+"px"})}}}return!1}},e.TZ=function(t){if((!t||"mouseup"!==t.type||!ZC.TOUCHEVENTS)&&e.C){if(ZC.move=!1,e.IM=!1,document.body.style.cursor="auto",ZC.Q.EU([i+"-zoom",i+"-from",i+"-to"]),e.C.AJ["3d"]){e.C.NX();var n=ZC.AK(e.H.K+"-guide-c");n&&(ZC.Q.IU(n,e.H.AA,e.C.iX,e.C.iY,e.C.I,e.C.F),ZC.A5(".zc-guide-label").remove())}if(ZC.A5(document.body).unbind("mousemove touchmove",e.U4),ZC.A5(document.body).unbind("mouseup touchend",e.TZ),e.Z9)e.Z9=!1;else{var a,l,o,r,s,A,C,c,u,p={graphid:e.C.K,ev:t};if(ZC._a_(e.I8-e.LE)>10&&ZC._a_(e.I7-e.LF)>10){var Z,h,d=!1,f=!1;for(r=0,s=(o=e.C.BU("k")).length;r<s;r++)(Z=o[r])&&o[r].GO&&(A=1===Z.L?"":"-"+Z.L,a=Z.OE(ZC.CY(e.I8,e.LE)),l=Z.OE(ZC.BQ(e.I8,e.LE)),ZC._a_(l-a)>=1&&(p["zoomx"+A]=!0,p["xmin"+A]=ZC.CY(a,l),p["xmax"+A]=ZC.BQ(a,l),"log"===Z.C1&&(p["kmin"+A]=Z.V[ZC._i_(ZC.G6(p["xmin"+A],Z.E6))],p["kmax"+A]=Z.V[ZC._i_(ZC.G6(p["xmax"+A],Z.E6))],delete p["xmin"+A],delete p["xmax"+A]),d=!0));for(r=0,s=(o=e.C.BU("v")).length;r<s;r++)(h=o[r])&&o[r].GO&&(A=1===h.L?"":"-"+h.L,C=h.NE(ZC.BQ(e.I7,e.LF)),c=h.NE(ZC.CY(e.I7,e.LF)),u=(h.H1-h.FW)/Math.pow(10,10),ZC._a_(c-C)>=u&&(p["zoomy"+A]=!0,p["ymin"+A]=ZC.CY(C,c),p["ymax"+A]=ZC.BQ(C,c),f=!0));d||f?(zingchart.SKIP.EVENT=!0,e.C.A.PV(p)):zingchart.SKIP.EVENT=!0}else(ZC._a_(e.I8-e.LE)>5||ZC._a_(e.I7-e.LF)>5)&&(zingchart.SKIP.EVENT=!0);e.C=null}}},ZC.mobile&&"normal"!==zingchart.TOUCHZOOM||(zingchart.DEV.SKIPTRACKERS?ZC.A5(document.body).bind("mousedown touchstart",e.R3):ZC.A5("#"+i+"-img").bind("mousedown touchstart",e.R3),ZC.A5(".zc-node-area").live("mousedown touchstart",e.R3))}};ZC.A4Z=ZC.HL.CA(A4Z);var A2D={$i:function(e){this.b(e);var i=this;i.I2=!0,i.ABU=!1,i.C=e,i.H=e.A,i.IM=!1,i.A3X=!1,i.H5=null,i.AR=null,i.Z=null,i.IG=0,i.H7=0,i.PC=0,i.A0N=0,i.LK=!1,i.NJ=null,i.bBind=!1,i.BX=null,i.A1R=!1},parse:function(){var e,i=this;i.K=i.C.K+"-preview",i.assign_a([["live","ABU","b"],["async","LK","b"],["min-distance","PC","i"],["min-distance-x","PC","i"],["min-distance-y","PC","i"],["visible","AN","b"]]);var t="("+i.C.AF+").preview",n=i.H.B8;function a(e){return[t+".handler",t+".handler-"+e,t+".handle",t+".handle-"+e]}i.AR=new ZC.HL(i.C),i.AR.K=i.C.K+"-preview-viewport",n.load(i.AR.o,[t]),i.AR.append(i.o),i.AR.parse(),i.o.label&&(i.BX=[]),i.o.handle&&i.o.handle.label&&(i.J5=new ZC.DN(i.C),i.J5.append(i.o.handle.label),i.J5.append({text:" "}),i.J5.parse(),i.J5.AN&&(i.A1R=!0)),i.OV=new ZC.D0(i.C),n.load(i.OV.o,[t+".mask"]),null!==ZC._n_(e=i.o.mask)&&i.OV.append(e),i.OV.parse(),i.UI=new ZC.D0(i.C),n.load(i.UI.o,[t+".active"]),null!==ZC._n_(e=i.o.active)&&i.UI.append(e),i.UI.parse(),i.IP=new ZC.HL(i.AR),i.HG=new ZC.HL(i.AR),i.JC=new ZC.HL(i.AR),i.H4=new ZC.HL(i.AR),n.load(i.IP.o,a("left")),n.load(i.HG.o,a("right")),n.load(i.JC.o,a("top")),n.load(i.H4.o,a("bottom"));for(var l=["handle","handler"],o=0;o<l.length;o++)null!==ZC._n_(e=i.o[l[o]])&&(i.IP.append(e),i.HG.append(e),i.JC.append(e),i.H4.append(e)),null!==ZC._n_(e=i.o[l[o]+"-left"])&&i.IP.append(e),null!==ZC._n_(e=i.o[l[o]+"-right"])&&i.HG.append(e),null!==ZC._n_(e=i.o[l[o]+"-top"])&&i.JC.append(e),null!==ZC._n_(e=i.o[l[o]+"-bottom"])&&i.H4.append(e);i.IP.parse(),i.HG.parse(),i.JC.parse(),i.H4.parse()},setScalesInfo:function(){var e=this;e.NJ={};for(var i,t=e.C.BO,n=0,a=t.length;n<a;n++)(i=t[n])&&("k"===i.AF?e.NJ[i.BE]={minindex:i.DC,maxindex:i.DX,minvalue:i.V[i.DC],maxvalue:i.V[i.DX],stepsize:i.AC,values:[].concat(i.V)}:e.NJ[i.BE]={minvalue:i.FW,maxvalue:i.H1})},toggleMasks:function(e,i){for(var t=this,n=["x-left","x-right","y-top","y-bottom"],a=0;a<n.length;a++)if(e){var l=new ZC.HL(t.C);switch(l.K=t.C.K+"-preview-mask-"+n[a],l.A0=l.AE=t.OV.A0,l.C6=t.OV.C6,l.Z=l.C7=i||ZC.AK(t.C.K+"-preview-c"),n[a]){case"x-left":l.iX=t.AR.iX,l.iY=t.AR.iY,l.I=ZC.A5(t.A3A).css("width"),l.F=t.AR.F;break;case"x-right":l.iX=t.AR.iX+t.AR.I-ZC.A5(t.XD).css("width"),l.iY=t.AR.iY,l.I=ZC.A5(t.XD).css("width"),l.F=t.AR.F;break;case"y-top":l.iX=t.AR.iX,l.iY=t.AR.iY,l.I=t.AR.I,l.F=ZC.A5(t.A4B).css("height");break;case"y-bottom":l.iX=t.AR.iX,l.iY=t.AR.iY+t.AR.F-ZC.A5(t.W3).css("height"),l.I=t.AR.I,l.F=ZC.A5(t.W3).css("height")}l.paint()}else ZC.Q.EU(t.C.K+"-preview-mask-"+n[a]+"-path")},paint:function(){var e,i,t,n,a,l,o,r,s,A=this;if(A.PT=ZC.mobile?40:ZC.ie67?0:20,A.AN){A.Z=A.AR.Z=A.AR.C7=ZC.AK(A.C.K+"-preview-c"),A.AR.paint();var C=ZC.AK(A.H.K+"-top"),c=A.C.BU("k")[0],u=A.C.BU("v")[0];if(null===A.NJ&&A.setScalesInfo(),"svg"!==A.H.AA?(e=ZC.AK(A.C.K+"-preview"))&&ZC.Q.PJ(e,{clip:A.C.M6(0,"canvas",A.AR)}):(e=ZC.AK(A.C.K+"-clip-preview-shape"))&&ZC.Q.G3(e,{points:A.C.M6(0,"svg",A.AR)}),0===A.PC&&c&&(A.PC=ZC.BQ(1,ZC._i_(2*A.AR.I/c.V.length)),"log"===c.C1&&(A.PC=ZC.BQ(1,ZC._i_(A.PC/c.E6)))),A.BX){var p=ZC.ie67?ZC.AK(A.H.K):null;ZC.A5("."+A.C.K+"-preview-item",p).remove();for(var Z=[],h=0;h<A.BX.length;h++){var d=(A.BX[h].x-c.iX)/c.I,f=ZC._i_(A.AR.iX+d*A.AR.I),_=new ZC.DN(A.C);if(_.append({"line-width":1,"line-color":"#999",text:A.BX[h].text,x:f,y:A.AR.iY}),_.append(A.o.label),_.parse(),_.Z=A.Z,_.IL=A.H.usc()?ZC.AK(A.H.K+"-main"):ZC.AK(A.H.K+"-text"),_.GL=A.K+"-item "+A.C.K+"-preview-item zc-preview-item",_.K=A.K+"-item-"+h,_.iX>=A.AR.iX&&_.iX+_.I<=A.AR.iX+A.AR.I){for(var g=!1,v=0;v<Z.length;v++)_.iX>Z[v].x&&_.iX<Z[v].x+Z[v].width&&(g=!0);!g&&_.AN&&(_.paint(),Z.push({x:_.iX,width:_.I}));var b=[[f,A.AR.iY],[f,A.AR.iY+A.AR.F]];n=ZC.Q.EB(A.Z,A.H.AA),ZC.CR.paint(n,_,b)}}}if((c.GO||u.GO)&&(A.KG=ZC.Q.HY({cls:"zc-abs zc-preview-handler zc-preview-handler-middle "+A.C.K+"-preview-handler",id:A.K+"-handler-middle",wh:A.AR.I+"/"+A.AR.F,tl:A.AR.iY+"/"+A.AR.iX,background:A.UI.A0,opacity:A.UI.C6,cursor:"pointer",p:C})),!c.CO&&c.GO||u.CO&&u.GO){A.A3A=ZC.Q.HY({cls:"zc-abs zc-preview-mask zc-preview-mask-left "+A.C.K+"-preview-mask",id:A.K+"-mask-x-left",wh:"0/"+A.AR.F,tl:A.AR.iY+"/"+A.AR.iX,background:A.OV.A0,opacity:A.OV.C6,p:C}),A.XD=ZC.Q.HY({cls:"zc-abs zc-preview-mask zc-preview-mask-right "+A.C.K+"-preview-mask",id:A.K+"-mask-x-right",wh:"0/"+A.AR.F,tl:A.AR.iY+"/"+(A.AR.iX+A.AR.I),background:A.OV.A0,opacity:A.OV.C6,p:C}),i=A.IP.I,t=A.IP.F,A.KJ=ZC.Q.HY({cls:"zc-abs zc-preview-handler zc-preview-handler-left "+A.C.K+"-preview-handler",id:A.K+"-handler-x-left",wh:ZC.quirks?null:i+"/"+t,tl:ZC._i_(A.AR.iY+(A.AR.F-t)/4-A.PT/2)+"/"+ZC._i_(A.AR.iX-i/2-A.PT/2),lineHeight:"10%",cursor:"pointer",p:C,border:A.PT/2+"px solid transparent"});var B=A.KJ;if("svg"===A.H.AA&&!ZC.AK(A.K+"-handler-x-left-svg")){var m=ZC.Q.F5("svg","http://www.w3.org/2000/svg");ZC.Q.G3(m,{version:"1.1",id:A.K+"-handler-x-left-svg",width:i,height:t}),A.KJ.appendChild(m),B=m}if(!ZC.AK(A.K+"-handler-x-left-c")){var E=ZC.Q.HC({cls:"zc-no-print",id:A.K+"-handler-x-left-c",wh:i+"/"+t,p:B},A.H.AA);A.IP.Z=E,A.IP.K=A.K+"-handler-x-left-c-preview",A.IP.iX=0,A.IP.iY=0,A.IP.paint(),n=ZC.Q.EB(A.H.usc()?A.H.K+"-main-c":A.K+"-handler-x-left-c",A.H.AA);var D=A.IP.AZ,K=A.IP.AU;r=ZC._i_(i/2-D),o=ZC._i_(i/2+D),s=[[r,l=K+3],[r,a=t-K-2],null,[o,l],[o,a]],A.IP.CZ=!0,ZC.CR.paint(n,A.IP,s)}i=A.HG.I,t=A.HG.F,A.JY=ZC.Q.HY({cls:"zc-abs zc-preview-handler zc-preview-handler-right "+A.C.K+"-preview-handler",id:A.K+"-handler-x-right",wh:ZC.quirks?null:i+"/"+t,tl:ZC._i_(A.AR.iY+A.AR.F-A.HG.F-(A.AR.F-t)/4-A.PT/2)+"/"+ZC._i_(A.AR.iX+A.AR.I-A.HG.I/2-A.PT/2),lineHeight:"10%",cursor:"pointer",p:C,border:A.PT/2+"px solid transparent"});var F=A.JY;if("svg"===A.H.AA&&!ZC.AK(A.K+"-handler-x-right-svg")){var x=ZC.Q.F5("svg","http://www.w3.org/2000/svg");ZC.Q.G3(x,{version:"1.1",id:A.K+"-handler-x-right-svg",width:i,height:t}),A.JY.appendChild(x),F=x}if(!ZC.AK(A.K+"-handler-x-right-c")){var I=ZC.Q.HC({cls:"zc-no-print",id:A.K+"-handler-x-right-c",wh:i+"/"+t,p:F},A.H.AA);A.HG.Z=I,A.HG.K=A.K+"-handler-x-right-c-preview",A.HG.iX=0,A.HG.iY=0,A.HG.paint(),n=ZC.Q.EB(A.H.usc()?A.H.K+"-main-c":A.K+"-handler-x-right-c",A.H.AA);var y=A.HG.AZ,w=A.HG.AU;r=ZC._i_(i/2-y),o=ZC._i_(i/2+y),s=[[r,l=w+3],[r,a=t-w-2],null,[o,l],[o,a]],A.HG.CZ=!0,ZC.CR.paint(n,A.HG,s)}}if(!u.CO&&u.GO||c.CO&&c.GO){A.A4B=ZC.Q.HY({cls:"zc-abs zc-preview-mask zc-preview-mask-top "+A.C.K+"-preview-mask",id:A.K+"-mask-x-top",wh:A.AR.I+"/0",tl:A.AR.iY+"/"+A.AR.iX,background:A.OV.A0,opacity:A.OV.C6,p:C}),A.W3=ZC.Q.HY({cls:"zc-abs zc-preview-mask zc-preview-mask-bottom "+A.C.K+"-preview-mask",id:A.K+"-mask-x-bottom",wh:A.AR.I+"/0",tl:A.AR.iY+A.AR.F+"/"+A.AR.iX,background:A.OV.A0,opacity:A.OV.C6,p:C}),i=A.JC.I,t=A.JC.F,A.L2=ZC.Q.HY({cls:"zc-abs zc-preview-handler zc-preview-handler-top "+A.C.K+"-preview-handler",id:A.K+"-handler-y-top",wh:ZC.quirks?null:i+"/"+t,tl:ZC._i_(A.AR.iY-t/2-A.PT/2)+"/"+ZC._i_(A.AR.iX+(A.AR.I-i)/4-A.PT/2),lineHeight:"10%",cursor:"pointer",p:C,border:A.PT/2+"px solid transparent"});var Y=A.L2;if("svg"===A.H.AA&&!ZC.AK(A.K+"-handler-y-top-svg")){var X=ZC.Q.F5("svg","http://www.w3.org/2000/svg");ZC.Q.G3(X,{version:"1.1",id:A.K+"-handler-y-top-svg",width:i,height:t}),A.L2.appendChild(X),Y=X}if(!ZC.AK(A.K+"-handler-y-top-c")){var M=ZC.Q.HC({cls:"zc-no-print",id:A.K+"-handler-y-top-c",wh:i+"/"+t,p:Y},A.H.AA);A.JC.Z=M,A.JC.K=A.K+"-handler-y-top-c-preview",A.JC.iX=0,A.JC.iY=0,A.JC.paint(),n=ZC.Q.EB(A.H.usc()?A.H.K+"-main-c":A.K+"-handler-y-top-c",A.H.AA);var L=A.JC.AZ,H=A.JC.AU;a=ZC._i_(t/2-L),s=[[r=i-H-2,l=ZC._i_(t/2+L)],[o=H+3,l],null,[r,a],[o,a]],A.JC.CZ=!0,ZC.CR.paint(n,A.JC,s)}i=A.H4.I,t=A.H4.F,A.JG=ZC.Q.HY({cls:"zc-abs zc-preview-handler zc-preview-handler-bottom "+A.C.K+"-preview-handler",id:A.K+"-handler-y-bottom",wh:ZC.quirks?null:i+"/"+t,tl:ZC._i_(A.AR.iY+A.AR.F-A.H4.F/2-A.PT/2)+"/"+ZC._i_(A.AR.iX+A.AR.I-A.H4.I-(A.AR.I-i)/4-A.PT/2),lineHeight:"10%",cursor:"pointer",p:C,border:A.PT/2+"px solid transparent"});var P=A.JG;if("svg"===A.H.AA&&!ZC.AK(A.K+"-handler-y-bottom-svg")){var N=ZC.Q.F5("svg","http://www.w3.org/2000/svg");ZC.Q.G3(N,{version:"1.1",id:A.K+"-handler-y-bottom-svg",width:i,height:t}),A.JG.appendChild(N),P=N}if(!ZC.AK(A.K+"-handler-y-bottom-c")){var G=ZC.Q.HC({cls:"zc-no-print",id:A.K+"-handler-y-bottom-c",wh:i+"/"+t,p:P},A.H.AA);A.H4.Z=G,A.H4.K=A.K+"-handler-y-bottom-c-preview",A.H4.iX=0,A.H4.iY=0,A.H4.paint(),n=ZC.Q.EB(A.H.usc()?A.H.K+"-main-c":A.K+"-handler-y-bottom-c",A.H.AA);var S=A.H4.AZ,O=A.H4.AU;a=ZC._i_(t/2-S),s=[[r=i-O-2,l=ZC._i_(t/2+S)],[o=O+3,l],null,[r,a],[o,a]],A.H4.CZ=!0,ZC.CR.paint(n,A.H4,s)}}if(A.IG=0,A.H7=A.AR.I,A.L1=0,A.HF=A.AR.F,c.GO&&A.A1R){var k=c.W,T=c.A1;c.FG&&"date"===c.FG.o.type&&(k=c.FQ(c.W,null,null).replace(/<br>/g," "),T=c.FQ(c.A1,null,null).replace(/<br>/g," ")),A.R6=ZC.Q.HY({cls:"zc-abs zc-preview-label "+A.C.K+"-preview-label",id:A.K+"-min-label",background:A.J5.A0,opacity:A.J5.C6,fontFamily:A.J5.GH,fontSize:A.J5.DG,fontWeight:A.J5.sFontWeight,color:A.J5.C2,padding:0,html:k+"",p:C}),A.R6.style.left=A.AR.iX+"px",A.R6.style.top=A.AR.iY+A.AR.F+"px",A.R8=ZC.Q.HY({cls:"zc-abs zc-preview-label "+A.C.K+"-preview-label",id:A.K+"-max-label",background:A.J5.A0,opacity:A.J5.C6,fontFamily:A.J5.GH,fontSize:A.J5.DG,fontWeight:A.J5.sFontWeight,color:A.J5.C2,padding:0,html:T+"",p:C}),A.R8.style.left=A.AR.iX+A.AR.I+"px",A.R8.style.top=A.AR.iY+A.AR.F+"px",A.IG>ZC.A5(A.R6).width()?A.R6.style.left=A.AR.iX+A.IG-ZC.A5(A.R6).width()+"px":A.R6.style.left=A.AR.iX+"px",A.AR.I-A.H7>ZC.A5(A.R8).width()?A.R8.style.left=A.AR.iX+A.H7+"px":A.R8.style.left=A.AR.iX+A.H7-ZC.A5(A.R8).width()+"px"}A.bind(),A.BX&&(A.BX=[])}},reset:function(){var e=this,i=e.C.BU("k")[0],t=e.C.BU("v",!0)[0];t||(t=e.C.BU("v")[0]),i&&t&&e.update(i.DC,i.DX,t.FW,t.H1,!0)},update:function(e,i,t,n,a){null===ZC._n_(a)&&(a=!1);var l=this;if(a||(e>=i&&(e=i-1),t>=n&&(t=n-1)),l.AN){var o=l.C.BU("k")[0],r=l.C.BU("v",!0)[0];r||(r=l.C.BU("v")[0]);var s=!0;if(a){if(o&&r){if(o.CO&&r.CO){var A=e,C=i;e=t,i=n,t=A,n=C}o.CO?(null===ZC._n_(n)&&(n=o.A1),null===ZC._n_(t)&&(t=o.W)):(null===ZC._n_(e)&&(e=o.W),null===ZC._n_(i)&&(i=o.A1)),r.CO?(null===ZC._n_(e)&&(e=r.aAutoFit[0]?r.FW:r.B3),null===ZC._n_(i)&&(i=r.aAutoFit[1]?r.H1:r.BJ)):(null===ZC._n_(t)&&(t=r.aAutoFit[0]?r.FW:r.B3),null===ZC._n_(n)&&(n=r.aAutoFit[1]?r.H1:r.BJ)),o.CO||r.CO?o.AW?l.update((e-r.FW)*l.AR.I/(r.H1-r.FW),(i-r.FW)*l.AR.I/(r.H1-r.FW),(t-o.DC)*l.AR.F/(o.DX-o.DC),(n-o.DC)*l.AR.F/(o.DX-o.DC)):l.update((e-r.FW)*l.AR.I/(r.H1-r.FW),(i-r.FW)*l.AR.I/(r.H1-r.FW),l.AR.F-(n-o.DC)*l.AR.F/(o.DX-o.DC),l.AR.F-(t-o.DC)*l.AR.F/(o.DX-o.DC)):o.AW?l.update(l.AR.I-(i-o.DC)*l.AR.I/(o.DX-o.DC),l.AR.I-(e-o.DC)*l.AR.I/(o.DX-o.DC),l.AR.F-(n-r.FW)*l.AR.F/(r.H1-r.FW),l.AR.F-(t-r.FW)*l.AR.F/(r.H1-r.FW)):l.update((e-o.DC)*l.AR.I/(o.DX-o.DC),(i-o.DC)*l.AR.I/(o.DX-o.DC),l.AR.F-(n-r.FW)*l.AR.F/(r.H1-r.FW),l.AR.F-(t-r.FW)*l.AR.F/(r.H1-r.FW))}}else if(i-e<l.PC&&(l.H5===l.JY?i=e+l.PC:l.H5===l.KJ&&(e=i-l.PC)),n-t<l.A0N&&(l.H5===l.JG?n=t+l.A0N:l.H5===l.L2&&(t=n-l.A0N)),e>i&&(l.H5===l.KJ?l.update(i-1,i,t,n):l.H5===l.JY&&l.update(e,e+1,t,n),s=!1),e<0&&(l.H5===l.KJ?l.update(0,i,t,n):l.H5===l.KG&&l.update(0,ZC.A5(l.KG).width(),t,n),s=!1),i>l.AR.I&&(l.H5===l.JY?l.update(e,l.AR.I,t,n):l.H5===l.KG&&l.update(l.AR.I-ZC.A5(l.KG).width(),l.AR.I,t,n),s=!1),t>n&&(l.H5===l.L2?l.update(e,i,t-1,n):l.H5===l.JG&&l.update(e,i,t,n+1),s=!1),t<0&&(l.H5===l.L2?l.update(e,i,0,n):l.H5===l.KG&&l.update(e,i,0,ZC.A5(l.KG).height()),s=!1),n>l.AR.F&&(l.H5===l.JG?l.update(e,i,t,l.AR.F):l.H5===l.KG&&l.update(e,i,l.AR.F-ZC.A5(l.KG).height(),l.AR.F),s=!1),s){if(o&&o.Y7){var c=l.AR.I/(o.V.length-(o.DJ?0:1));e=c*Math.round(e/c),i=ZC.CY(c*Math.round(i/c),l.AR.I)}l.IG=e,l.H7=i,l.L1=t,l.HF=n,(!o.CO&&o.GO||r.CO&&r.GO)&&(l.KJ.style.left=ZC._i_(l.AR.iX+l.IG-l.IP.I/2-l.PT/2)+"px",l.A3A.style.width=ZC._i_(l.IG)+"px",l.JY.style.left=ZC._i_(l.AR.iX+l.H7-l.HG.I/2-l.PT/2)+"px",l.XD.style.left=ZC._i_(l.AR.iX+l.H7)+"px",l.XD.style.width=ZC._i_(l.AR.I-l.H7)+"px"),(!r.CO&&r.GO||o.CO&&o.GO)&&(l.L2.style.top=ZC._i_(l.AR.iY+l.L1-l.JC.F/2-l.PT/2)+"px",l.A4B.style.height=ZC._i_(l.L1)+"px",l.JG.style.top=ZC._i_(l.AR.iY+l.HF-l.H4.F/2-l.PT/2)+"px",l.W3.style.top=ZC._i_(l.AR.iY+l.HF)+"px",l.W3.style.height=ZC._i_(l.AR.F-l.HF)+"px"),(o.GO||r.GO)&&(l.KG.style.left=ZC._i_(l.AR.iX+l.IG)+"px",l.KG.style.width=ZC._i_(l.H7-l.IG)+"px",l.KG.style.top=ZC._i_(l.AR.iY+l.L1)+"px",l.KG.style.height=ZC._i_(l.HF-l.L1)+"px"),l.ABU&&l.IM&&(l.C.OA=!0,l.zoom(!0)),o.GO&&l.A1R&&(o.FG&&"date"===o.FG.o.type?(l.R6.innerHTML=o.FQ(o.W,null,null).replace(/<br>/g," "),l.R8.innerHTML=o.FQ(o.A1,null,null).replace(/<br>/g," ")):(l.R6.innerHTML=o.W,l.R8.innerHTML=o.A1),l.IG>ZC.A5(l.R6).width()?l.R6.style.left=l.AR.iX+l.IG-ZC.A5(l.R6).width()+"px":l.R6.style.left=l.AR.iX+"px",l.AR.I-l.H7>ZC.A5(l.R8).width()?l.R8.style.left=l.AR.iX+l.H7+"px":l.R8.style.left=l.AR.iX+l.H7-ZC.A5(l.R8).width()+"px")}}},zoom:function(e){for(var i,t=this,n={graphid:t.C.K,preview:1,async:t.LK,previewscale:!0,zooming:e},a=t.C.BO,l=t.C.BU("k")[0],o=t.C.BU("v")[0],r=0,s=a.length;r<s;r++)if(i=a[r]){var A=1===i.L?"":"-"+i.L;if("k"===i.AF){if(l.GO){var C=t.LK?t.NJ[i.BE].minindex:i.DC,c=t.LK?t.NJ[i.BE].maxindex:i.DX;if(n["zoomx"+A]=!0,l.CO?(n["xmin"+A]=ZC._i_((t.AR.F-t.HF)/t.AR.F*(c-C)),n["xmax"+A]=ZC._i_((t.AR.F-t.L1)/t.AR.F*(c-C))):(n["xmin"+A]=ZC._i_(t.IG/t.AR.I*(c-C)),n["xmax"+A]=ZC._i_(t.H7/t.AR.I*(c-C))),l.AW){n["xmin"+A]=c-n["xmin"+A],n["xmax"+A]=c-n["xmax"+A];var u=n["xmin"+A];n["xmin"+A]=n["xmax"+A],n["xmax"+A]=u}}}else if(o.GO){var p=t.LK?t.NJ[i.BE].minvalue:i.FW,Z=t.LK?t.NJ[i.BE].maxvalue:i.H1;n["zoomy"+A]=!0,o.CO?(n["ymin"+A]=p+t.IG/t.AR.I*(Z-p),n["ymax"+A]=p+t.H7/t.AR.I*(Z-p)):(n["ymin"+A]=p+(t.AR.F-t.HF)/t.AR.F*(Z-p),n["ymax"+A]=p+(t.AR.F-t.L1)/t.AR.F*(Z-p))}}t.H.PV(n)},unbind:function(){var e=this;ZC.A5("."+e.C.K+"-preview-handler").unbind("mousedown touchstart",e.Z2),ZC.A5("."+e.C.K+"-preview-mask").unbind("click",e.AEJ),ZC.A5(document.body).unbind("mousemove touchmove",e.V1),ZC.A5(document.body).unbind("mouseup touchend",e.TH),e.bBind=!1},bind:function(){var e=this;if(!e.bBind){var i=e.H.K,t=0,n=0;e.AEJ=function(t){if(t.preventDefault(),e.H.H2){e.H.H2.C=e.C,e.H.H2.parse();var n=ZC.Q.MB(t),a=ZC.A5("#"+i+"-top").offset();if(-1!==t.target.id.indexOf("preview-mask-x-left")||-1!==t.target.id.indexOf("preview-mask-x-right")){var l=n[0]-a.left-e.AR.iX,o=e.H7-e.IG;l-o/2<0?(e.IG=0,e.H7=o):l+o/2>e.AR.I?(e.IG=e.AR.I-o,e.H7=e.AR.I):(e.IG=ZC._i_(l-o/2),e.H7=ZC._i_(l+o/2))}else{var r=n[1]-a.top-e.AR.iY,s=e.HF-e.L1;r-s/2<0?(e.L1=0,e.HF=s):r+s/2>e.AR.F?(e.L1=e.AR.F-s,e.HF=e.AR.F):(e.L1=ZC._i_(r-s/2),e.HF=ZC._i_(r+s/2))}return e.IM=!1,e.C.OA=!1,e.update(e.IG,e.H7,e.L1,e.HF),e.zoom(!1),!1}},e.Z2=function(a){if(a.preventDefault(),e.H.H2){e.H.H2.C=e.C,e.H.H2.parse();for(var l=a.target;l&&"BODY"!==l.tagName.toUpperCase();){if(-1!==ZC.Q.T8(l).indexOf("zc-preview-handler"))break;l=l.parentNode}if((ZC.mobile||!(a.which>1))&&l){var o=ZC.Q.MB(a),r=ZC._tx_(e.H.K),s=ZC.A5("#"+i+"-top").offset(),A=(o[0]-s.left)/r[0]-e.AR.iX,C=(o[1]-s.top)/r[1]-e.AR.iY;return-1!==l.id.indexOf("handler-x-left")?e.H5=e.KJ:-1!==l.id.indexOf("handler-x-right")?e.H5=e.JY:-1!==l.id.indexOf("handler-y-top")?e.H5=e.L2:-1!==l.id.indexOf("handler-y-bottom")?e.H5=e.JG:-1!==l.id.indexOf("handler-middle")&&(e.H5=e.KG,t=A-e.IG,n=C-e.L1),ZC.A5(document.body).bind("mousemove touchmove",e.V1),ZC.A5(document.body).bind("mouseup touchend",e.TH),e.IM=!0,e.A3X=!1,!1}}},e.V1=function(a){if(e.IM){e.A3X=!0,zingchart.exec(e.H.K,"setmode",{mode:"static,fast"});var l=ZC._tx_(e.H.K),o=ZC.Q.MB(a),r=ZC.A5("#"+i+"-top").offset(),s=(o[0]-r.left)/l[0]-e.AR.iX,A=(o[1]-r.top)/l[1]-e.AR.iY;e.H5===e.KJ?e.update(s,e.H7,e.L1,e.HF):e.H5===e.JY?e.update(e.IG,s,e.L1,e.HF):e.H5===e.L2?e.update(e.IG,e.H7,A,e.HF):e.H5===e.JG?e.update(e.IG,e.H7,e.L1,A):e.H5===e.KG&&e.update(s-t,s-t+ZC.A5(e.KG).width(),A-n,A-n+ZC.A5(e.KG).height())}return!1},e.TH=function(){return zingchart.exec(e.H.K,"setmode",{mode:""}),e.IM&&(ZC.A5(document.body).unbind("mousemove touchmove",e.V1),ZC.A5(document.body).unbind("mouseup touchend",e.TH),e.IM=!1,e.C.OA=!1,e.A3X&&e.zoom(!1),e.A3X=!1),!1},ZC.A5("."+e.C.K+"-preview-handler").bind("mousedown touchstart",e.Z2),ZC.A5("."+e.C.K+"-preview-mask").bind("click",e.AEJ),e.bBind=!0}},gc:function(){ZC.AP.gc(this,["Z","C7","o","I6","J9","C","H","AR","UI","KJ","JY","L2","JG","KG","JC","HG","H4","IP","oMask","OV","A3A","XD","A4B","W3"])}};ZC.A2D=ZC.D0.CA(A2D);var ZF={$i:function(e,i){this.b(e);var t=this;t.C=e,t.H=e.A,t.IM=!1,t.Z=null,t.BM=0,t.BH=0,t.A79="",t.bYX="yx"===t.C.AJ.layout,t.AF=t.sTypeE=t.sTypeN="scroll-"+(i||"x"),t.bYX&&(t.AF+="i",t.sTypeE="scroll-xi"===t.AF?"scroll-y":"scroll-x")},parse:function(){var e,i=this;i.K=i.C.K+"-"+i.sTypeE,i.assign_a([["offset-x","BM"],["offset-y","BH"]]);var t="("+i.C.AF+").",n=i.H.B8;i.B0=new ZC.HL(i.C),n.load(i.B0.o,[t+"scroll.bar",t+i.AF+".bar"]),null!==ZC._n_(e=i.o.bar)&&i.B0.append(e),i.B0.parse(),i.B2=new ZC.HL(i.C),n.load(i.B2.o,[t+"scroll.handle",t+i.AF+".handle"]),null!==ZC._n_(e=i.o.handle)&&i.B2.append(e),i.B2.parse()},paint:function(){var e=this,i=e.C.BU("k")[0],t=e.C.BU("v")[0],n=e.C.P;if(("scroll-x"===e.AF||"scroll-xi"===e.AF)&&i.DC===i.W&&i.DX===i.A1||("scroll-y"===e.AF||"scroll-yi"===e.AF)&&t.FW===t.B3&&t.H1===t.BJ)return e.unbind(),ZC.A5("#"+e.C.K+"-"+e.AF+"-handle").remove(),ZC.A5("#"+e.C.K+"-"+e.AF+"-bar").remove(),void ZC.Q.IU(e.Z,e.H.AA,e.C.iX,e.C.iY,e.C.I,e.C.F);e.Z=ZC.AK(e.C.K+"-"+e.sTypeN+"-c");var a=ZC.AK(e.H.K+"-top");"scroll-x"===e.AF||"scroll-yi"===e.AF?(e.B0.iX=n.iX+e.BM,e.B0.iY=n.iY+n.F+i.AZ-1+e.BH,e.B0.I=n.I,e.bYX?(e.B2.I=ZC._i_(ZC.BQ(4,e.B0.I*((t.BJ-t.B3)/(t.H1-t.FW)))),t.FW===t.B3?t.AW?e.B2.iX=e.B0.iX+e.B0.I-e.B2.I:e.B2.iX=e.B0.iX:t.H1===t.BJ?t.AW?e.B2.iX=e.B0.iX:e.B2.iX=e.B0.iX+e.B0.I-e.B2.I:t.AW?e.B2.iX=ZC._i_(e.B0.iX+e.B0.I-e.B2.I-e.B0.I*(t.B3-t.FW)/(t.H1-t.FW)):e.B2.iX=ZC._i_(e.B0.iX+e.B0.I*(t.B3-t.FW)/(t.H1-t.FW))):(e.B2.I=ZC._i_(ZC.BQ(4,e.B0.I*((i.A1-i.W)/(i.DX-i.DC)))),i.DC===i.W?i.AW?e.B2.iX=e.B0.iX+e.B0.I-e.B2.I:e.B2.iX=e.B0.iX:i.DX===i.A1?i.AW?e.B2.iX=e.B0.iX:e.B2.iX=e.B0.iX+e.B0.I-e.B2.I:i.AW?e.B2.iX=ZC._i_(e.B0.iX+e.B0.I-e.B2.I-e.B0.I*(i.W-i.DC)/(i.DX-i.DC)):e.B2.iX=ZC._i_(e.B0.iX+e.B0.I*(i.W-i.DC)/(i.DX-i.DC))),ZC.AK(e.K+"-handle")?(ZC.A5("#"+e.K+"-bar").css("top",e.B0.iY+"px"),ZC.A5("#"+e.K+"-handle").css("left",e.B2.iX+"px").css("top",e.B0.iY+"px").css("width",ZC.BQ(15,e.B2.I)+"px"),e.paint_()):(e.AAC=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-x-bar "+e.C.K+"-scroll-x-bar",id:e.K+"-bar",wh:e.B0.I+"/"+e.B0.F,tl:e.B0.iY+"/"+e.B0.iX,opacity:0,p:a}),e.Z8=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-x-handle "+e.C.K+"-scroll-x-handle",id:e.K+"-handle",wh:ZC.BQ(15,e.B2.I)+"/"+e.B0.F,tl:e.B0.iY+"/"+(e.B2.iX-2),background:"#fff",opacity:0,p:a}),e.Z8.style.cursor="pointer",e.paint_(),e.IM||e.bind())):(e.B0.iX=n.iX-e.B0.I-1+e.BM,e.B0.iY=n.iY+e.BH,e.B0.F=n.F,e.bYX?(e.B2.F=ZC._i_(ZC.BQ(4,e.B0.F*((i.A1-i.W)/(i.DX-i.DC)))),i.DC===i.W?i.AW?e.B2.iY=e.B0.iY:e.B2.iY=e.B0.iY+e.B0.F-e.B2.F:i.DX===i.A1?i.AW?e.B2.iY=e.B0.iY+e.B0.F-e.B2.F:e.B2.iY=e.B0.iY:i.AW?e.B2.iY=ZC._i_(e.B0.iY+e.B0.F*(i.W-i.DC)/(i.DX-i.DC)):e.B2.iY=ZC._i_(e.B0.iY+e.B0.F-e.B2.F-e.B0.F*(i.W-i.DC)/(i.DX-i.DC))):(e.B2.F=ZC._i_(ZC.BQ(4,e.B0.F*((t.BJ-t.B3)/(t.H1-t.FW)))),t.FW===t.B3?t.AW?e.B2.iY=e.B0.iY:e.B2.iY=e.B0.iY+e.B0.F-e.B2.F:t.H1===t.BJ?t.AW?e.B2.iY=e.B0.iY+e.B0.F-e.B2.F:e.B2.iY=e.B0.iY:t.AW?e.B2.iY=ZC._i_(e.B0.iY+e.B0.F*(t.B3-t.FW)/(t.H1-t.FW)):e.B2.iY=ZC._i_(e.B0.iY+e.B0.F-e.B2.F-e.B0.F*(t.B3-t.FW)/(t.H1-t.FW))),ZC.AK(e.K+"-handle")?(ZC.A5("#"+e.K+"-bar").css("left",e.B0.iX+"px"),ZC.A5("#"+e.K+"-handle").css("top",e.B2.iY+"px").css("left",e.B0.iX+"px").css("height",ZC.BQ(15,e.B2.F)+"px"),e.paint_()):(e.AAE=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-y-bar "+e.C.K+"-scroll-y-bar",id:e.K+"-bar",wh:e.B0.I+"/"+e.B0.F,tl:e.B0.iY+"/"+e.B0.iX,opacity:0,p:a}),e.ZM=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-y-handle "+e.C.K+"-scroll-y-handle",id:e.K+"-handle",wh:e.B0.I+"/"+ZC.BQ(15,e.B2.F),tl:e.B2.iY-2+"/"+e.B0.iX,background:"#fff",opacity:0,p:a}),e.ZM.style.cursor="pointer",e.paint_(),e.IM||e.bind()))},zoom:function(e){for(var i,t,n,a=this,l={graphid:a.C.K,zooming:e,scroll:!0},o=a.C.BO,r=a.C.BU("k")[0],s=a.C.BU("v")[0],A=0,C=o.length;A<C;A++)if(i=o[A]){var c=1===i.L?"":"-"+i.L;if(r.GO&&"scroll-x"===a.AF&&"k"===i.AF&&!a.bYX){var u=i.A1-i.W;l["zoomx"+c]=!0,t=(a.B2.iX-a.B0.iX)/a.B0.I,n=(a.B2.iX-a.B0.iX+a.B2.I)/a.B0.I,r.AW?(l["xmin"+c]=i.DX-ZC._i_(n*(i.DX-i.DC)),l["xmax"+c]=i.DX-ZC._i_(t*(i.DX-i.DC))):(l["xmin"+c]=i.DC+ZC._i_(t*(i.DX-i.DC)),l["xmax"+c]=i.DC+ZC._i_(n*(i.DX-i.DC))),l["xmax"+c]-l["xmin"+c]!==u&&(l["xmax"+c]===i.DX?l["xmin"+c]=l["xmax"+c]-u:l["xmax"+c]=l["xmin"+c]+u)}else if(s.GO&&"scroll-y"===a.AF&&"v"===i.AF&&!a.bYX)l["zoomy"+c]=!0,t=(a.B0.F-(a.B2.iY-a.B0.iY+a.B2.F))/a.B0.F,n=(a.B0.F-(a.B2.iY-a.B0.iY))/a.B0.F,s.AW?(l["ymin"+c]=i.H1-ZC._f_(n*(i.H1-i.FW)),l["ymax"+c]=i.H1-ZC._f_(t*(i.H1-i.FW))):(l["ymin"+c]=i.FW+ZC._f_(t*(i.H1-i.FW)),l["ymax"+c]=i.FW+ZC._f_(n*(i.H1-i.FW)));else if(r.GO&&"scroll-xi"===a.AF&&"k"===i.AF&&a.bYX){u=i.A1-i.W;l["zoomx"+c]=!0,t=(a.B0.F-a.B2.iY+a.B0.iY-a.B2.F)/a.B0.F,n=(a.B0.F-a.B2.iY+a.B0.iY)/a.B0.F,r.AW?(l["xmin"+c]=i.DX-ZC._i_(n*(i.DX-i.DC)),l["xmax"+c]=i.DX-ZC._i_(t*(i.DX-i.DC))):(l["xmin"+c]=i.DC+ZC._i_(t*(i.DX-i.DC)),l["xmax"+c]=i.DC+ZC._i_(n*(i.DX-i.DC))),l["xmax"+c]-l["xmin"+c]!==u&&(l["xmax"+c]===i.DX?l["xmin"+c]=l["xmax"+c]-u:l["xmax"+c]=l["xmin"+c]+u)}else s.GO&&"scroll-yi"===a.AF&&"v"===i.AF&&a.bYX&&(l["zoomy"+c]=!0,t=(a.B2.iX-a.B0.iX)/a.B0.I,n=(a.B2.iX-a.B0.iX+a.B2.I)/a.B0.I,s.AW?(l["ymin"+c]=i.H1-ZC._f_(n*(i.H1-i.FW)),l["ymax"+c]=i.H1-ZC._f_(t*(i.H1-i.FW))):(l["ymin"+c]=i.FW+ZC._f_(t*(i.H1-i.FW)),l["ymax"+c]=i.FW+ZC._f_(n*(i.H1-i.FW))))}a.H.PV(l)},paint_:function(){var e,i,t=this;ZC.Q.IU(t.Z,t.H.AA,t.C.iX,t.C.iY,t.C.I,t.C.F),"scroll-x"===t.AF||"scroll-yi"===t.AF?((e=new ZC.HL(t)).K=t.C.K+"-scroll-x-bar",e.copy(t.B0),e.Z=e.C7=t.Z,e.iX=t.B0.iX,e.iY=t.B0.iY,e.I=t.B0.I,e.F=t.B0.F,e.paint(),(i=new ZC.HL(t)).K=t.C.K+"-scroll-x-handle",i.copy(t.B2),i.Z=i.C7=t.Z,i.iX=t.B2.iX,i.iY=t.B0.iY+(t.B0.F-t.B2.F)/2-1,i.I=ZC.BQ(15,t.B2.I),i.iX+i.I>t.C.P.iX+t.C.P.I&&(i.iX=t.C.P.iX+t.C.P.I-i.I),i.iX<t.C.P.iX&&(i.iX=t.C.P.iX),i.F=t.B2.F,i.paint(),ZC.A5("#"+t.K+"-handle").css("left",i.iX+"px")):((e=new ZC.HL(t)).K=t.C.K+"-scroll-y-bar",e.copy(t.B0),e.Z=e.C7=t.Z,e.iX=t.B0.iX,e.iY=t.B0.iY,e.I=t.B0.I,e.F=t.B0.F,e.paint(),(i=new ZC.HL(t)).K=t.C.K+"-scroll-y-handle",i.copy(t.B2),i.Z=i.C7=t.Z,i.iX=t.B0.iX+(t.B0.I-t.B2.I)/2,i.iY=t.B2.iY,i.I=t.B2.I,i.F=ZC.BQ(15,t.B2.F),i.iY+i.F>t.C.P.iY+t.C.P.F&&(i.iY=t.C.P.iY+t.C.P.F-i.F),i.iY<t.C.P.iY&&(i.iY=t.C.P.iY),i.paint(),ZC.A5("#"+t.K+"-handle").css("top",i.iY+"px"))},setScrollingFlag:function(e){var i=this;if(i.C.OA=e,i.C.H2&&ZC._b_(i.C.H2.o.shared))for(var t=0;t<i.H.AG.length;t++)i.H.AG[t].H2&&ZC._b_(i.H.AG[t].H2.o.shared)&&(i.H.AG[t].OA=e)},update:function(e){var i=this;"scroll-x"===i.AF||"scroll-yi"===i.AF?(i.B2.iX=e,ZC.A5("#"+i.K+"-handle").css("left",e+"px"),i.paint_()):(i.B2.iY=e,ZC.A5("#"+i.K+"-handle").css("top",e+"px"),i.paint_()),i.IM&&(i.setScrollingFlag(!0),i.zoom(!0))},unbind:function(){var e=this;ZC.A5("."+e.C.K+"-"+e.AF+"-handle").unbind("mousedown touchstart",e.RC),ZC.A5("."+e.C.K+"-"+e.AF+"-bar").unbind("click",e.RE)},overscroll:function(e){var i=this.C.GX();i.type=e,ZC.AP.BY("overscroll",this.H,i)},bind:function(){var e=this,i=e.H.K,t=0,n=0;e.RC=function(a){if(a.preventDefault(),!(a.button>1)&&(e.A79=e.H.KR.join(","),e.H.KR.push("skip_context_menu","skip_objects_tracking","skip_segment_tracking","skip_marker_tracking","skip_interactivity"),e.H.H2)){e.H.H2.C=e.C,e.H.H2.parse();for(var l=a.target;l&&"BODY"!==l.tagName.toUpperCase();){if(-1!==ZC.Q.T8(l).indexOf("zc-"+e.AF+"-handle"))break;l=l.parentNode}if((ZC.mobile||!(a.which>1))&&l){var o=ZC.Q.MB(a),r=ZC.A5("#"+i+"-top").offset();if("scroll-x"===e.AF||"scroll-yi"===e.AF){var s=o[0]-r.left;t=s-e.B2.iX}else{var A=o[1]-r.top;n=A-e.B2.iY}return ZC.A5(document.body).bind("mousemove touchmove",e.RF),ZC.A5(document.body).bind("mouseup touchend",e.M7),e.IM=!0,!1}}},e.RF=function(a){if(e.IM){e.setScrollingFlag(!1);var l=ZC.Q.MB(a),o=ZC.A5("#"+i+"-top").offset();if("scroll-x"===e.AF||"scroll-yi"===e.AF){var r=l[0]-o.left;r-t<e.B0.iX&&(r<e.B0.iX-15&&e.overscroll("scroll-x-left"),r=e.B0.iX+t),r-t+e.B2.I>e.B0.iX+e.B0.I&&(r>e.B0.iX+e.B0.I+15&&e.overscroll("scroll-x-right"),r=e.B0.iX+e.B0.I+t-e.B2.I),e.update(r-t)}else{var s=l[1]-o.top;s-n<e.B0.iY&&(s<e.B0.iY-15&&e.overscroll("scroll-y-top"),s=e.B0.iY+n),s-n+e.B2.F>e.B0.iY+e.B0.F&&(s>e.B0.iY+e.B0.F+15&&e.overscroll("scroll-y-bottom"),s=e.B0.iY+e.B0.F+n-e.B2.F),e.update(s-n)}}return!1},e.M7=function(i){return e.H.KR=e.A79.split(","),e.IM&&(ZC.A5(document.body).unbind("mousemove touchmove",e.RF),ZC.A5(document.body).unbind("mouseup touchend",e.M7),e.IM=!1,e.setScrollingFlag(!1),i&&e.zoom(!1)),!1},e.RE=function(t){e.IM=!1,e.setScrollingFlag(!1);var n=ZC.Q.MB(t),a=ZC.A5("#"+i+"-top").offset();"scroll-x"===e.AF||"scroll-yi"===e.AF?n[0]-a.left>e.B2.iX?e.update(ZC.CY(e.B0.iX+e.B0.I-e.B2.I-2*e.B2.AU,e.B2.iX+(n[0]-a.left-e.B2.iX)/4)):e.update(ZC.BQ(e.B0.iX,n[0]-a.left+(e.B2.iX-n[0]+a.left-e.B2.I)/4)):n[1]-a.top>e.B2.iY?e.update(ZC.CY(e.B0.iY+e.B0.F-e.B2.F-2*e.B2.AU,e.B2.iY+(n[1]-a.top-e.B2.iY)/4)):e.update(ZC.BQ(e.B0.iY,n[1]-a.top+(e.B2.iY-n[1]+a.top-e.B2.F)/4)),e.zoom(!1)},ZC.A5("."+e.C.K+"-"+e.sTypeE+"-handle").bind("mousedown touchstart",e.RC),ZC.A5("."+e.C.K+"-"+e.sTypeE+"-bar").bind("click",e.RE)}};ZC.ZF=ZC.D0.CA(ZF);var WR={$i:function(e,i){this.b(e);var t=this;t.BD=e,t.IM=!1,t.Z=null,t.A79="",t.KS=1,t.H0=1,t.AF="scroll-"+(i||"y")},parse:function(){var e,i=this;i.K=i.BD.K+"-legend-"+i.AF;var t=i.BD.A.H.B8,n="("+i.BD.A.AF+")";i.B0=new ZC.HL(i.BD),t.load(i.B0.o,[n+".legend.scroll.bar",i.AF+".bar"]),null!==ZC._n_(e=i.o.bar)&&i.B0.append(e),i.B0.parse(),i.B2=new ZC.HL(i.BD),t.load(i.B2.o,[n+".legend.scroll.handle",i.AF+".handle"]),null!==ZC._n_(e=i.o.handle)&&i.B2.append(e),i.B2.parse()},paint:function(){var e,i=this;if(!i.IM){i.Z=ZC.AK(i.BD.A.K+"-legend-scroll-c");var t=ZC.AK(i.H.K+"-top");"scroll-y"===i.AF?(i.B0.iX=i.BD.iX+i.BD.I-i.B0.I-1,i.B0.iY=i.BD.EO,i.B0.F=i.BD.F-(i.BD.KL?i.BD.KL.F:0)-(i.BD.EO-i.BD.iY),e=Math.ceil(i.BD.B6.length/i.H0-i.BD.EG/i.H0)+1,i.B2.F=i.B0.F/e,i.B2.iY=i.B0.iY,0!==i.BD.D4.min&&(i.B2.iY+=i.BD.D4.min/i.H0*i.B2.F),ZC.AK(i.K+"-legend-handle")?(ZC.A5("#"+i.K+"-legend-handle").css("left",i.B0.iX+"px").css("top",i.B2.iY+"px").css("height",i.B2.F-0*i.B2.AU+"px"),ZC.A5("#"+i.K+"-legend-bar").css("left",i.B0.iX+"px").css("top",i.B0.iY+"px"),ZC.A5("#"+i.BD.K+"-frame").css("left",i.BD.iX+"px").css("top",i.BD.EO+"px"),i.paint_()):(i.AAE=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-y-bar "+i.BD.K+"-scroll-y-legend-bar",id:i.K+"-legend-bar",wh:i.B0.I+"/"+i.B0.F,tl:i.B0.iY+"/"+i.B0.iX,background:"#fff",opacity:0,zidx:1,p:t}),i.ZM=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-y-handle "+i.BD.K+"-scroll-y-legend-handle",id:i.K+"-legend-handle",wh:i.B0.I-0*i.B2.AU+"/"+(i.B2.F-0*i.B2.AU),tl:i.B2.iY+"/"+i.B0.iX,background:"#fff",opacity:0,zidx:1,p:t}),i.ZM.style.cursor="pointer",i.paint_())):"scroll-x"===i.AF&&(i.B0.iX=i.BD.iX,i.B0.iY=i.BD.iY+i.BD.F-i.B0.F-1,i.B0.I=i.BD.I,e=Math.ceil(i.BD.B6.length/i.KS-i.BD.EG/i.KS)+1,i.B2.I=i.B0.I/e,i.B2.iX=i.B0.iX,0!==i.BD.D4.min&&(i.B2.iX+=i.BD.D4.min/i.KS*i.B2.I),ZC.AK(i.K+"-legend-handle")?(ZC.A5("#"+i.K+"-legend-handle").css("left",i.B2.iX+"px").css("top",i.B0.iY+"px").css("width",i.B2.I-0*i.B2.AU+"px"),ZC.A5("#"+i.K+"-legend-bar").css("left",i.B0.iX+"px").css("top",i.B0.iY+"px"),ZC.A5("#"+i.BD.K+"-frame").css("left",i.BD.iX+"px").css("top",i.BD.EO+"px"),i.paint_()):(i.AAC=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-x-bar "+i.BD.K+"-scroll-x-legend-bar",id:i.K+"-legend-bar",wh:i.B0.I+"/"+i.B0.F,tl:i.B0.iY+"/"+i.B0.iX,background:"#fff",opacity:0,zidx:1,p:t}),i.Z8=ZC.Q.HY({cls:"zc-abs zc-scroll zc-scroll-x-handle "+i.BD.K+"-scroll-x-legend-handle",id:i.K+"-legend-handle",wh:i.B2.I-0*i.B2.AU+"/"+(i.B0.F-0*i.B2.AU),tl:i.B0.iY+"/"+i.B2.iX,background:"#fff",opacity:0,zidx:1,p:t}),i.Z8.style.cursor="pointer",i.paint_())),ZC.move||i.bind()}},paint_:function(){var e,i,t=this;"scroll-y"===t.AF?((e=new ZC.HL(t)).K=t.BD.K+"-scroll-y-legend-bar",e.copy(t.B0),e.Z=t.Z,e.iX=t.B0.iX,e.iY=t.B0.iY,e.I=t.B0.I,e.F=t.B0.F,e.paint(),(i=new ZC.HL(t)).K=t.BD.K+"-scroll-y-legend-handle",i.copy(t.B2),i.Z=t.Z,i.iX=t.B0.iX,i.iY=t.B2.iY,i.I=t.B2.I,i.F=t.B2.F,i.paint()):"scroll-x"===t.AF&&((e=new ZC.HL(t)).K=t.BD.K+"-scroll-x-legend-bar",e.copy(t.B0),e.Z=t.Z,e.iX=t.B0.iX,e.iY=t.B0.iY,e.I=t.B0.I,e.F=t.B0.F,e.paint(),(i=new ZC.HL(t)).K=t.BD.K+"-scroll-x-legend-handle",i.copy(t.B2),i.Z=t.Z,i.iX=t.B2.iX,i.iY=t.B0.iY,i.I=t.B2.I,i.F=t.B0.F,i.paint())},update:function(e){var i,t,n,a,l,o,r=this,s=r.BD;if("scroll-y"===r.AF){if(e<r.B2.iY&&!1,e===r.B2.iY)return;r.B2.iY=e,ZC.A5("#"+r.K+"-legend-handle").css("top",e+"px"),i=r.B2.iY-r.B0.iY,a=Math.ceil(s.B6.length/r.H0-s.EG/r.H0)+1,t=r.B0.F/a,o=r.H0}else if("scroll-x"===r.AF){if(e>r.B2.iX&&!1,e===r.B2.iX)return;r.B2.iX=e,ZC.A5("#"+r.K+"-legend-handle").css("left",e+"px"),i=r.B2.iX-r.B0.iX,a=Math.ceil(s.B6.length/r.KS-s.EG/r.KS)+1,t=r.B0.I/a,o=r.KS}n=Math.round(i/t),l=s.B6.length-s.EG,s.B6.length%o&&(l+=o-s.B6.length%o),s.D4.min=Math.min(n*o,l),s.D4.max=s.D4.min+s.EG,s.VT(),s.clear(!1),s.parse(),s.paint(),r.paint_(),r.bind()},unbind:function(){var e=this;ZC.A5("."+e.BD.K+"-"+e.AF+"-legend-handle").unbind("mousedown touchstart",e.RC),ZC.A5("."+e.BD.K+"-"+e.AF+"-legend-bar").unbind("click",e.RE)},bind:function(){var e=this,i=e.H.K,t=0,n=0;e.RC=function(a){if(a.preventDefault(),!(a.button>1)){for(var l=a.target;l&&"BODY"!==l.tagName.toUpperCase();){if(-1!==ZC.Q.T8(l).indexOf("zc-"+e.AF+"-handle"))break;l=l.parentNode}if((ZC.mobile||!(a.which>1))&&l){var o=ZC.Q.MB(a),r=ZC.A5("#"+i+"-top").offset();if("scroll-y"===e.AF){var s=o[1]-r.top;n=s-e.B2.iY}else if("scroll-x"===e.AF){var A=o[0]-r.left;t=A-e.B2.iX}return ZC.A5(document.body).bind("mousemove touchmove",e.RF),ZC.A5(document.body).bind("mouseup touchend",e.M7),e.IM=!0,!1}}},e.RF=function(a){if(a.preventDefault(),e.IM){var l=ZC.Q.MB(a),o=ZC.A5("#"+i+"-top").offset();if("scroll-y"===e.AF){var r=l[1]-o.top;r-n<e.B0.iY&&(r=e.B0.iY+n),r-n+e.B2.F>e.B0.iY+e.B0.F&&(r=e.B0.iY+e.B0.F+n-e.B2.F),e.update(r-n)}else if("scroll-x"===e.AF){var s=l[0]-o.left;s-t<e.B0.iX&&(s=e.B0.iX+t),s-t+e.B2.I>e.B0.iX+e.B0.I&&(s=e.B0.iX+e.B0.I+t-e.B2.I),e.update(s-t)}}return!1},e.M7=function(){return e.H.KR=e.A79.split(","),e.IM&&(ZC.A5(document.body).unbind("mousemove touchmove",e.RF),ZC.A5(document.body).unbind("mouseup touchend",e.M7),e.IM=!1),!1},e.A3V=function(i){(i.detail?-120*i.detail:i.wheelDelta)/120>0?e.update(ZC.BQ(e.B0.iY,e.B2.iY-e.B2.F)):e.update(ZC.CY(e.B0.iY+e.B0.F-e.B2.F,e.B2.iY+e.B2.F))},e.RE=function(t){e.IM=!0;var n=ZC.Q.MB(t),a=ZC.A5("#"+i+"-top").offset();"scroll-y"===e.AF?n[1]-a.top>e.B2.iY?e.update(ZC.CY(e.B0.iY+e.B0.F-e.B2.F,e.B2.iY+e.B2.F)):e.update(ZC.BQ(e.B0.iY,e.B2.iY-e.B2.F)):"scroll-x"===e.AF&&(n[0]-a.left>e.B2.iX?e.update(ZC.CY(e.B0.iX+e.B0.I-e.B2.I,e.B2.iX+e.B2.I)):e.update(ZC.BQ(e.B0.iX,e.B2.iX-e.B2.I))),e.IM=!1},ZC.A5("."+e.BD.K+"-"+e.AF+"-legend-handle").bind("mousedown touchstart",e.RC),ZC.A5("."+e.BD.K+"-"+e.AF+"-legend-bar").bind("click",e.RE)}};ZC.WR=ZC.D0.CA(WR);var UV={$i:function(e){this.b(e);var i=this;i.OG="legend",i.B6=null,i.Q4=null,i.NF="x1",i.IJ="hide",i.R1="",i.PP="",i.UR=!1,i.V0=!1,i.TU="none",i.UM="header",i.EG=9999,i.D2=null,i.BR=null,i.ZG=null,i.A2=null,i.NL=null,i.FO=null,i.KL=null,i.QF=0,i.ME=0,i.YG=!0,i.EO=0,i.GM=0,i.sAlign="",i.JX="",i.D4={enabled:!1,min:-1,max:-1,page:-1,pages:-1},i.M1=!1,i.N8=!1,i.ND=-1,i.PQ=!1,i.A4I=1,i.WJ=0,i.L9=!1,i.XR=!1,i.YF=!1,i.XU=[]},highlightItem:function(e){var i,t,n=this,a=!1,l=ZC.move,o=n.L9;-1!==e&&(o=n.L9||n.A.AY.A4[e].L9),n.o.item&&null!==ZC._n_(i=n.o.item["highlight-item"])&&(a=ZC._b_(i),null===ZC._n_(n.o["highlight-legend"])&&null===n.A.AY.A4[e].o["highlight-legend"]&&(o=a)),(a||o)&&(a&&(n.E["highlight-item"]=e),o&&(n.E["highlight-legend"]=ZC._i_(e)),t=n.scrollTo(ZC._i_(e)),n.VT(),n.clear(!0,t),n.YG=!0,n.parse(),n.fixPlacement(!0),n.paint(),ZC.move=l)},scrollTo:function(e){var i,t,n=this,a=!1;return e>=0&&(e<n.D4.min||e>=n.D4.max)&&(a=!0,"scroll"===n.TU?(e%(t="scroll-y"===n.D2.AF?n.D2.H0:n.D2.KS)&&(e-=e%t),n.D4.min=e,n.D4.max=e+n.EG,n.D4.max>n.B6.length&&(n.D4.min=n.B6.length-n.EG,n.B6.length%t&&(n.D4.min=n.D4.min+(t-n.B6.length%t)),n.D4.max=n.B6.length)):"page"===n.TU&&(i=Math.floor(e/n.EG),n.D4.min=i*n.EG,n.D4.max=n.D4.min+n.EG,n.D4.page=i+1)),a},parse:function(){var e,i,t,n,a=this;if(a.E["force-margins"]=!0,a.QF=0,a.ME=0,null!==ZC._n_(e=a.A.A.E["graph-"+a.A.K+"-legend-info"])&&(a.o.x=e.x-a.A.iX,a.o.y=e.y-a.A.iY),ZC.move)a.FO&&a.FO.parse(),a.KL&&a.KL.parse();else{n=a.A.H.B8;var l="("+a.A.AF+")";a.b(),a.assign_a([["collapse","M1","b"],["minimize","UR","b"],["draggable","V0","b"],["shared","PQ","b"],["overflow","TU"],["max-items","EG","i"],["group","A4I","i"],["drag-handler","UM"],["highlight-plot","WJ","b"],["highlight-legend","L9","b"],["align","sAlign"],["vertical-align","JX"]]),a.M1&&!a.UR&&(a.M1=!1),zingchart.DEV.MEDIARULES&&(a.E["forced-align-position"]||(a.alignPosition({align:a.sAlign,"vertical-align":a.JX,layout:a.NF}),a.E["forced-align-position"]=!0)),a.WJ&&null===ZC._n_(a.o["highlight-legend"])&&(a.L9=a.WJ),a.BR=new ZC.DN(a),n.load(a.BR.o,l+".legend.item"),a.o.item&&null===ZC._n_(a.o.item.visible)&&(a.o.item.visible=!0),a.BR.append(a.o.item),a.BR.parse(),a.ZG=new ZC.DN(a),n.load(a.ZG.o,l+".legend.item-off"),a.o["item-off"]&&null===ZC._n_(a.o["item-off"].visible)&&(a.o["item-off"].visible=!0),a.ZG.append(a.o["item-off"]),a.ZG.parse(),a.A2=new ZC.DT(a),n.load(a.A2.o,l+".legend.marker"),a.o.marker&&null===ZC._n_(a.o.marker.visible)&&(a.o.marker.visible=!0),a.A2.append(a.o.marker),a.A2.E.type="default",a.A2.E["show-marker"]=!0,a.A2.E["show-line"]=!1,null!==ZC._n_(e=a.A2.o.type)&&(a.A2.E.type=e),null!==ZC._n_(e=a.A2.o["show-line"])&&(a.A2.E["show-line"]=ZC._b_(e)),null!==ZC._n_(e=a.BR.o["marker-style"])&&(a.A2.E.type=e),null!==ZC._n_(e=a.BR.o["show-line"])&&(a.A2.E["show-line"]=ZC._b_(e)),null!==ZC._n_(e=a.BR.o["show-marker"])&&(a.A2.o.visible=ZC._b_(e)),a.A2.parse(),a.NL=new ZC.DT(a),n.load(a.NL.o,l+".legend.marker-off"),a.o["marker-off"]&&(a.o["marker-off"].visible=!0),a.NL.append(a.o["marker-off"]),a.NL.E.type="default",a.NL.E["show-marker"]=!0,a.NL.E["show-line"]=!1,null!==ZC._n_(e=a.NL.o.type)&&(a.NL.E.type=e),null!==ZC._n_(e=a.NL.o["show-line"])&&(a.NL.E["show-line"]=ZC._b_(e)),null!==ZC._n_(e=a.BR.o["marker-style"])&&(a.NL.E.type=e),null!==ZC._n_(e=a.BR.o["show-line"])&&(a.NL.E["show-line"]=ZC._b_(e)),null!==ZC._n_(e=a.BR.o["show-marker"])&&(a.NL.o.visible=ZC._b_(e)),a.NL.parse(),(null!==ZC._n_(e=a.o.header)||a.V0||a.UR)&&(a.FO=new ZC.DN(a),a.FO.OG="legendheader",a.FO.GL="zc-legend-item "+a.K+"-header",a.FO.K=a.K+"-header",n.load(a.FO.o,l+".legend.header"),a.FO.o.text=a.FO.o.text||" ",a.FO.append(e),a.FO.parse(),a.FO.AN||(a.FO=null)),null!==ZC._n_(e=a.o.footer)&&(a.KL=new ZC.DN(a),a.KL.OG="legendfooter",a.KL.GL="zc-legend-item "+a.K+"-footer",a.KL.K=a.K+"-footer",n.load(a.KL.o,l+".legend.footer"),a.KL.append(e),a.KL.parse(),a.KL.AN||(a.KL=null));var o=a.A.AY.A4;null!==ZC._n_(e=a.o.layout)?a.NF=e:25*o.length>a.A.F&&(a.NF="x"+Math.ceil(25*o.length/a.A.F)),null!==ZC._n_(e=a.o["toggle-action"])&&(a.IJ=e),a.R1=a.PP=a.IJ,null!==ZC._n_(a.o.item)&&null!==ZC._n_(e=a.o.item["toggle-action"])&&(a.R1=e),null!==ZC._n_(a.o.marker)&&null!==ZC._n_(e=a.o.marker["toggle-action"])&&(a.PP=e);var r=function(e){if(o[i]&&o[i].FK(0)){var t=ZC.AP.O3(a.BR.o,o[i].o);e=o[i].FK(0).JV(e,t)}return e},s=[];for(a.B6=[],i=0,t=o.length;i<t;i++){var A=a.A.AY.M2[i],C=new ZC.DN(a);C.copy(a.BR),C.append(o[A].o["legend-item"]),null===ZC._n_(C.o.text)&&null!==ZC._n_(e=o[A].A6C)&&(C.o.text=e),null===ZC._n_(C.o.text)&&null!==ZC._n_(e=o[A].AM)&&(C.o.text=e),C.AM=null===ZC._n_(C.o.text)?"Series "+(A+1):C.o.text,C.E.order=A,C.E.index=A,null!==ZC._n_(o[A].o["legend-item"])&&null!==ZC._n_(e=o[A].o["legend-item"].order)&&(C.E.order=ZC._i_(e)),s.push([i,A,C.E.order]),-1!==C.AM.indexOf("%")&&(C.JV=r),C.parse(),a.B6.push(C)}for(s.sort(function(e,i){return e[2]-i[2]}),i=0;i<s.length;i++)s[i][2]=i,o[s[i][1]].o["legend-item"]=o[s[i][1]].o["legend-item"]||{},o[s[i][1]].o["legend-item"].order=s[i][2],a.B6[s[i][0]].E.order=s[i][2];(e=a.A.E["legend-info"])&&(a.N8=e.collapsed)}if(a.B6&&a.A2){"page"===a.TU?((e=a.A.E["legend-info"])?(a.D4.min=e.min,a.D4.max=e.max,a.D4.page=e.page):(a.D4.min=0,a.D4.max=a.EG,a.D4.page=1),a.D4.pages=Math.ceil(a.B6.length/a.EG),a.D4.page>a.D4.pages&&(a.D4.page=a.D4.pages,a.D4.min=(a.D4.page-1)*a.EG,a.D4.max=a.D4.page*a.EG-1),a.D4.page=ZC.CY(a.D4.page,a.D4.pages)):"scroll"===a.TU?(e=a.A.E["legend-info"])?(a.D4.min=e.min,a.D4.max=e.max,a.D4.page=e.page):(a.D4.min=0,a.D4.max=a.EG,a.D4.page=1):(a.D4.min=0,a.D4.max="hidden"===a.TU?a.EG:a.B6.length,a.D4.page=1),a.VT(!1),a.B6.sort(function(e,i){return e.E.order-i.E.order}),a.o["reverse-series"]&&a.B6.reverse();var c=.9*a.A.I;null!==ZC._n_(a.o.width)&&(c=a.I);var u=0,p=0,Z=-ZC.MAX,h=-ZC.MAX,d=a.A2.E["show-line"]?3:2,f=0,_=1,g=1;if("float"===a.NF){for(i=0,t=a.B6.length;i<t;i++)if(f+=a.B6[i].AN?1:0,!(i<a.D4.min||i>=a.D4.max||a.N8)&&a.B6[i].AN){var v=a.B6[i].I+a.B6[i].DY+a.B6[i].E9+d*a.B6[i].DG;h=ZC.BQ(h,a.B6[i].F+a.B6[i].E8+a.B6[i].DR),u+v>c?(Z=ZC.BQ(Z,u),p+=h,u=v,h=ZC.BQ(h,a.B6[i].F+a.B6[i].E8+a.B6[i].DR)):u+=v}Z=ZC.BQ(Z,u),h!==-ZC.MAX&&(p+=h),Z!==-ZC.MAX&&(u=Z)}else{var b=0;for(i=0,t=a.B6.length;i<t;i++)f+=a.B6[i].AN?1:0,i<a.D4.min||i>=a.D4.max||a.N8||(b+=a.B6[i].AN?1:0);var B=ZC.AQ.A2C(a.NF,b);for(_=B[0],g=B[1],i=0,t=a.B6.length;i<t;i++)(i<a.D4.min||i>=a.D4.max||a.N8)&&("scroll"!==a.TU||f<=a.EG)||a.B6[i].AN&&(Z=ZC.BQ(Z,a.B6[i].I+a.B6[i].DY+a.B6[i].E9+d*a.B6[i].DG),h=ZC.BQ(h,a.B6[i].F+a.B6[i].E8+a.B6[i].DR),1===g&&(p+=a.B6[i].F+a.B6[i].E8+a.B6[i].DR));u=g*Z,p=_*h}if("page"===a.TU&&f>a.EG&&(a.D4.enabled=!0),"scroll"===a.TU&&f>a.EG&&(a.D2||(!_||_>g?(a.D2=new ZC.WR(a,"y"),n.load(a.D2.o,".scroll-y")):(a.D2=new ZC.WR(a,"x"),n.load(a.D2.o,".scroll-x")),a.D2.append(a.o.scroll),a.D2.KS=_,a.D2.H0=g,a.D2.parse()),a.N8||("scroll-y"===a.D2.AF?u+=a.D2.B0.I:p+=a.D2.B0.F)),a.FO){var m=a.FO.I;a.V0&&"icon"===a.UM?(m+=15,a.UR&&(m+=25)):a.UR&&(m+=15),u=ZC.BQ(u,m)}a.KL&&(u=ZC.BQ(u,a.KL.I));var E=!1,D=!1;if(null===ZC._n_(a.o.width)&&(a.o.width=u,E=!0),null===ZC._n_(a.o.height)&&(a.o.height=p,D=!0),a.iX=-1,a.iY=-1,!ZC.move&&a.FO&&null!==ZC._n_(e=a.A.A.E["legend"+a.A.L+"-xy-ratio"])){a.locate();var K=a.I+a.EQ+a.FN,F=a.F+a.FM+a.FU,x=a.PQ?a.A.A:a.A;a.iX=x.I*e[0],a.iX=ZC.BQ(a.iX,1.1),a.o.x=a.iX=ZC.CY(a.iX,x.I-K-2),a.iY=(x.F-a.FO.F)*e[1],a.iY=ZC.BQ(a.iY,1.1),a.o.y=a.iY=ZC.CY(a.iY,x.F-F-a.FO.F-2)}if(a.locate(),null!==ZC._n_(a.o.position)&&"undefined"!=typeof a.E["position-info"]?(a.E["position-info"][0]>.5&&(a.QF+=a.EQ+a.FN),a.E["position-info"][1]>.5?a.ME+=a.FM+a.FU:(a.FO&&(a.ME-=a.FO.F),a.KL&&(a.ME-=a.KL.F),a.D4&&a.D4.enabled&&(a.ME-=20))):((0===a.A.iX||a.iX+a.I/2>a.A.iX+a.A.I/2)&&(a.QF+=a.EQ+a.FN),(0===a.A.iY||a.iY+a.F/2>a.A.iY+a.A.F/2)&&(a.ME+=a.FM+a.FU)),!ZC.move&&(e=a.A.A.E["graph-"+a.A.K+"-legend-info"])&&(e.x&&(a.iX=e.x),e.y&&(a.iY=e.y)),a.GM=a.F,a.EO=a.iY,a.FO&&(a.F+=a.FO.F,a.EO+=a.FO.F,a.ME+=a.FO.F),a.KL&&(a.F+=a.KL.F,a.ME+=a.KL.F),a.D4.enabled&&!a.N8){var I=new ZC.DN(a);I.AM=" ",I.append(a.o["page-status"]),null!==ZC._n_(I.o.text)&&""!==I.o.text||(I.o.text="#"),I.parse(),a.F+=I.F+4,a.ME+=I.F+4}E&&(a.o.width=null),D&&(a.o.height=null),a.N8||(a.I+=a.EQ+a.FN,a.F+=a.FM+a.FU),a.E["default-width"]&&(a.I=a.E["default-width"])}},alignPosition:function(e){var i=this;if(null!==ZC._n_(e)){var t=i.A.H.B8.B8.graph.legend,n=e.align||t.align,a=e["vertical-align"]||t["vertical-align"],l=e.layout||t.layout;(n||a)&&("center"===n?(null===ZC._n_(i.o.layout)&&(l=i.o.layout="horizontal"),i.o.position="50% "):i.o.position="left"===n?"0% ":"100% ",i.o.position+="middle"===a?"50%":"bottom"===a?"100%":"0%","horizontal"!==l&&"middle"!==a||(i.o["adjust-layout"]=!0))}},VT:function(e){var i=this;void 0===e&&(e=!0),i.A.E["legend-info"]={collapsed:i.N8,min:i.D4.min,max:i.D4.max,page:i.D4.page},e&&(i.A.A.E["graph-"+i.A.K+"-legend-info"]={x:i.iX,y:i.iY})},clear:function(e,i){null===ZC._n_(e)&&(e=!1),null===ZC._n_(i)&&(i=!1);var t=this,n=t.A.K+"-legend-",a=null;ZC.A5("."+n+"item",a).remove(),ZC.A5("."+n+"header",a).remove(),ZC.A5("."+n+"footer",a).remove(),ZC.A5("#"+n+"page-status",a).remove(),e&&!i||(ZC.move||t.unbind(),ZC.A5("."+n+"page-area",a).remove(),ZC.A5("."+n+"header-area",a).remove(),ZC.A5("."+n+"item-area",a).remove(),ZC.A5("."+n+"marker-area",a).remove()),ZC.move?ZC.Q.IU(ZC.AK(n+"c"),t.A.H.AA,t.A.iX,t.A.iY,t.A.I,t.A.F):ZC.Q.IU(ZC.AK(n+"c"),t.A.H.AA,t.iX-2*t.AU-2*t.JW,t.iY-2*t.AU-2*t.JW,t.I+4*t.AU+4*t.JW,t.F+4*t.AU+4*t.JW),t.D2&&ZC.Q.IU(ZC.AK(n+"scroll-c"),t.A.H.AA,t.A.iX,t.A.iY,t.A.I,t.A.F)},unbind:function(){var e=this;ZC.A5("#"+e.K+"-frame").die(ZC.Q.BZ("mouseover"),e.zc_legend_mouseover).die(ZC.Q.BZ("mouseout"),e.zc_legend_mouseout),ZC.A5("#"+e.K+"-move-area").die(ZC.Q.BZ("mousedown"),e.Z5),ZC.A5("#"+e.K+"-minimize-area").die(ZC.Q.BZ("click"),e.Y2),ZC.A5("."+e.K+"-page-area").die(ZC.Q.BZ("click"),e.YY),e.D2&&e.D2.unbind(),e.BR&&e.BR.o.reorder&&ZC.A5("."+e.A.K+"-legend-item-area").die("mousedown",e.W8)},fixPlacement:function(e){var i=this;if(i.YG&&null===ZC._n_(i.o.y)||e){if(!i.o.position&&e||(i.iX-=i.QF),i.iX<i.DY&&(i.DY<i.E9||-2===i.E9)&&(i.iX=i.DY),!i.o.position&&e||(i.iY-=i.ME,i.EO-=i.ME),i.iY<i.E8&&(i.E8<i.DR||-2===i.DR)){var t=i.EO-i.iY;i.iY=i.E8,i.EO=i.E8+t}i.YG=!1}},EK:function(e){var i=this;i.FO&&i.FO.EK(e),i.KL&&i.KL.EK(e);for(var t=0;t<i.XU.length;t++)i.XU[t].EK(e)},paint:function(e){var i,t,n,a,l,o,r,s,A,C,c,u,p,Z,h,d,f=this;if(f.AN&&(f.E["default-width"]||(f.E["default-width"]=f.I),f.B6)){var _=ZC.AK(f.H.K+"-top"),g=f.A.AY.A4,v=0;for(o=0,r=f.B6.length;o<r;o++)o<f.D4.min||o>=f.D4.max||f.N8||(v+=f.B6[o].AN?1:0);f.A5J=!0,f.b(),f.FO&&(f.FO.iX=f.iX,f.FO.iY=f.iY,f.FO.I=f.I,f.FO.Z=f.FO.C7=f.Z,f.FO.paint(),ZC.move||"canvas"!==f.A.A.AA&&f.FO.EK(),f.V0&&"icon"===f.UM&&((n=new ZC.DT(f)).Z=f.Z,n.B7="#000",n.AZ=1,n.DU="line",n.append(f.o.icon),a=f.FO.iX+f.FO.I-10,l=f.FO.iY+f.FO.F/2,n.D=[[a-7,l],[a+7,l],null,[a,l-7],[a,l+7],null,[a-6,l-1],[a-6,l+1],null,[a-5,l-2],[a-5,l+2],null,[a+6,l-1],[a+6,l+1],null,[a+5,l-2],[a+5,l+2],null,[a-1,l-6],[a+1,l-6],null,[a-2,l-5],[a+2,l-5],null,[a-1,l+6],[a+1,l+6],null,[a-2,l+5],[a+2,l+5]],n.parse(),n.paint()),f.UR&&((t=new ZC.DT(f)).Z=f.Z,t.B7=ZC.AP.AA9(f.A0,"#fff","#000"),t.AZ=1,t.append(f.o.icon),t.DU="line",a=f.FO.iX+f.FO.I-10-(f.V0&&"icon"===f.UM?20:0),l=f.FO.iY+f.FO.F/2,t.D=[[a-7,l-2],[a+2,l-2],[a+2,l+7],[a-7,l+7],[a-7,l-2],[a+2,l-2],null,[a-4,l-5],[a+5,l-5],[a+5,l+4],[a-4,l+4],[a-4,l-5],[a+5,l-5]],t.parse(),t.paint())),f.KL&&(f.KL.iX=f.iX,f.KL.iY=f.iY+f.F-f.KL.F,f.KL.I=f.I,f.KL.Z=f.KL.C7=f.Z,f.KL.paint(),ZC.move||"canvas"!==f.A.A.AA&&f.KL.EK());var b=ZC.AQ.A2C(f.NF,v),B=b[0],m=b[1],E=f.I/m,D=f.GM/B,K=0,F=0;f.Q4=[];var x,I=0,y=-ZC.MAX,w=f.A2.E["show-line"]?3:2,Y=null,X=function(i){var t=i;if(null===ZC._n_(e)&&(e=0),g[x]&&g[x].S[e]){var n=ZC.AP.O3(f.BR.o,g[x].o);i=g[x].FK(e).JV(i,n)}return f.XR=f.XR||i!==t,i},M=0;for(f.XR=!1,o=0,r=f.B6.length;o<r;o++)if(!(o-M<f.D4.min||o-M>=f.D4.max||f.N8)){var L=new ZC.DN(f);L.copy(f.B6[o]),f.E["highlight-legend"]===o&&(L.append({bold:!0}),null!==ZC._n_(f.o.item)&&L.append(f.o.item["highlight-state"])),x=L.E.index;var H=new ZC.DN(f);H.OG="legenditem",H.K=f.K+"-item_"+x,H.GL="zc-legend-item "+f.K+"-item",H.copy(L),f.A.E["plot"+x+".visible"]&&"off"!==g[x].o["legend-status"]||H.append(f.ZG.o),H.append(g[x].o["legend-item"]),H.JV=X,H.parse(),H.AN?("float"===f.NF?(y=ZC.BQ(y,L.F),null===ZC._n_(Y)?(L.iX=f.iX+f.EQ+L.DY+w*L.DG,L.iY=f.EO+f.FM+L.E8,I=f.EO):(L.iX=Y.iX+Y.I+Y.E9+L.DY+w*L.DG,ZC._i_(L.iX+L.I+L.E9)>ZC._i_(f.iX+f.I)&&(L.iX=f.iX+f.EQ+L.DY+w*L.DG,I+=y+L.E8+L.DR,y=-ZC.MAX),L.iY=I+f.FM+L.E8)):(L.iX=f.iX+(0===F?f.EQ:0)+F*E+L.DY+w*L.DG,L.iY=f.EO+f.FM+K*D+L.E8,++F===m&&(F=0,K++)),Y=L,H.iX=L.iX=ZC._i_(L.iX),H.iY=L.iY=ZC._i_(L.iY),H.Z=H.C7=f.Z,H.iX+=f.BM,H.iY+=f.BH,x===f.ND&&(f.E["calculate-y"]&&(f.E["calculate-y"]=!1,f.E["dragged-offset-y"]=f.E["dragged-y"]-H.iY),H.iY=f.E["dragged-y"]-f.E["dragged-offset-y"]-H.DG/4),H.paint(),"undefined"!=typeof f.E.showhide&&null!==ZC._n_(f.E.showhide)||ZC.move||("canvas"!==f.A.A.AA?H.EK():f.XU.push(H))):M++;var P=f.A2.E.type;null!==ZC._n_(i=g[x].o["legend-marker"])&&null!==ZC._n_(i.type)&&(P=i.type);var N,G=!1;switch("match"!==P&&"inherit"!==P||(G=!0,P=null!==ZC._n_(i=g[x].A2.o.type)?i:"default"),-1!==ZC.AV(["default","square"],P)?N=new ZC.HL(f):(N=new ZC.DT(f)).DU=P,N.OG="legendmarker",N.append(f.A2.o),f.A.E["plot"+x+".visible"]&&"off"!==g[x].o["legend-status"]||N.append(f.NL.o),N.N7=g[x].N7,g[x].AF){case"pie":case"pie3d":case"nestedpie":case"vbar":case"vbar3d":case"hbar":case"hbar3d":case"vbullet":case"hbullet":case"area":case"area3d":case"gauge":case"vfunnel":case"hfunnel":case"venn":N.A0=g[x].A0,N.AE=g[x].AE,N.GR=g[x].GR,N.HN=g[x].HN;break;case"scatter":case"hscatter":case"bubble":case"hbubble":N.A0="-1"!==g[x].A2.A0?g[x].A2.A0:g[x].A0,N.AE="-1"!==g[x].A2.AE?g[x].A2.AE:g[x].AE,N.GR=""!==g[x].A2.GR?g[x].A2.GR:g[x].GR,N.HN=""!==g[x].A2.HN?g[x].A2.HN:g[x].HN;break;default:N.A0=g[x].B7,N.AE=g[x].B7}"line"!==N.DU&&"area"!==N.DU||(N.B7=N.A0,N.AZ=2),G&&N.append(g[x].A2.o),N.o["line-style"]="solid",N.o.type=N.DU,N.append(g[x].o["legend-marker"]),G&&(N.o.type=N.DU),N.E["show-marker"]=!0,N.E["show-line"]=!1,null!==ZC._n_(i=N.o["show-line"])&&(N.E["show-line"]=ZC._b_(i)),null!==ZC._n_(i=H.o["show-line"])&&(N.E["show-line"]=ZC._b_(i)),null!==ZC._n_(i=H.o["show-marker"])&&(N.o.visible=ZC._b_(i)),-1!==ZC.AV(["default","square"],P)&&null!==ZC._n_(i=N.o.size)&&(null===ZC._n_(N.o.width)&&(N.o.width=2*ZC._i_(i)),null===ZC._n_(N.o.height)&&(N.o.height=2*ZC._i_(i))),N.K=f.K+"-marker_"+x,N.Z=N.C7=f.Z,N.iX=H.iX-w*H.DG+(w-1)*H.DG/2+H.DG/2,N.iY=H.iY+(H.F-H.DG)/2+H.DG/2,N.parse(),f.E["highlight-legend"]===o&&(N.append({size:N.AI+1,width:N.I+2,height:N.F+2}),g[x]&&g[x].S[e]&&g[x].S[e].GJ&&N.append({A0:g[x].S[e].GJ.A0,AE:g[x].S[e].GJ.AE}),null!==ZC._n_(f.o.marker)&&N.append(f.o.marker["highlight-state"]),N.parse()),"line"===N.DU?(N.o.points=[[N.iX-1.75*N.AI,N.iY],[N.iX+1.75*N.AI,N.iY]],N.parse()):"area"===N.DU&&(N.o.points=[[N.iX-1.75*N.AI,N.iY+N.AI],[N.iX+1.75*N.AI,N.iY+N.AI],[N.iX+1*N.AI,N.iY-N.AI/2],[N.iX,N.iY],[N.iX-1.25*N.AI,N.iY-N.AI],[N.iX-1.75*N.AI,N.iY+N.AI]],N.parse());var S=N.iX+N.BM,O=N.iY+N.BH;if(-1!==ZC.AV(["default","square"],P)&&(N.iX-=N.I/2,N.iY-=N.F/2),f.A.E["plot"+x+".visible"]&&"off"!==g[x].o["legend-status"]||(N.C6/=4),H.AN&&N.E["show-line"]){var k=ZC.Q.EB(f.Z,f.A.H.AA),T=new ZC.D0(f);T.Z=f.Z,T.copy(g[x]),T.o["line-style"]=f.A2.GD,T.append(g[x].o),T.append(f.A2.o),T.append(g[x].o["legend-item"]),T.append(g[x].o["legend-marker"]),T.parse(),f.A.E["plot"+x+".visible"]||(T.C6=.25);var z=[],Q=N.AN?2:1;s="box"===N.DU?N.I/2:N.AI,z.push([S-Q*s-(T.AZ>1?1:0),O-(T.AZ>1?.5:0)]),z.push([S+Q*s,O-(T.AZ>1?.5:0)]),T.CZ=!0,ZC.CR.paint(k,T,z)}x===f.ND&&(N.iY=f.E["dragged-y"]-f.E["dragged-offset-y"]/2),N.AN&&H.AN&&N.paint(),f.Q4.push(N);var J=!0;if(null!==ZC._n_(i=f.BR.o.toggle)&&(J=ZC._b_(i)),f.E["item.toggle"]=J,(H.AN||N.AN)&&-1===ZC.AV(f.A.H.KR,"skip_interactivity")){var V=N.BM+("box"===N.DU?N.iX+N.I/2:N.iX),R=N.BH+("box"===N.DU?N.iY+N.F/2:N.iY);s="box"===N.DU?N.I/2:N.AI,A="box"===N.DU?N.F/2:N.AI;var W=(N.E["show-line"]?2:1)*s;ZC.AK(H.K+"-area")||(N.AN&&"disabled"!==f.PP&&"disabled"!==N.o["toggle-action"]&&(ZC.AK(N.K+"-area")||ZC.Q.HY({cls:f.K+"-marker-area zc-legend-marker-area zc-abs",id:N.K+"-area",wh:2*W+"/"+2*A,tl:R-A+"/"+(V-W),opacity:0,background:"#fff",cursor:N.IV,p:_,zidx:1})),H.AN&&"disabled"!==f.R1&&"disabled"!==H.o["toggle-action"]&&(ZC.AK(H.K+"-area")||ZC.Q.HY({cls:f.K+"-item-area zc-legend-item-area zc-abs",id:H.K+"-area",wh:H.I+"/"+H.F,tl:H.iY+H.BH+"/"+(H.iX+H.BM),opacity:0,background:"#fff",cursor:H.IV,p:_,zidx:1})))}}if(f.D2&&!f.N8&&(f.D2.paint(),ZC.AK(f.K+"-scroll-c").style.display="block"),f.D2&&f.N8&&(ZC.AK(f.K+"-scroll-c").style.display="none"),f.D4.enabled&&!f.N8){var U=new ZC.DN(f);U.Z=U.C7=f.Z,U.K=f.K+"-page-status",U.AM=ZC.HJ["legend-pagination"].replace("%page%",f.D4.page).replace("%pages%",f.D4.pages),U.append(f.o["page-status"]),U.parse(),f.I<U.I+48&&(U.AM=f.D4.page+"/"+f.D4.pages,U.parse()),U.iX=f.iX+f.I/2-U.I/2,U.iY=f.iY+f.F-(f.KL?f.KL.F:0)-U.F-4,U.AN&&U.paint();var j=f.A.H.B8,q="("+f.A.AF+")",$={"background-color":"#999"},ee={"background-color":"#f90"};j.load($,q+".legend.page-off"),j.load(ee,q+".legend.page-on"),(c=new ZC.DT(f)).Z=c.C7=f.Z,c.K=f.K+"-page-prev",c.A0=c.AE=f.D4.page>1?ee["background-color"]:$["background-color"],c.append(f.D4.page>1?f.o["page-on"]:f.o["page-off"]),C=f.iX+f.I/2-U.I/2-6,u=U.iY+U.F/2,c.parse(),c.AI=ZC.BQ(c.AI,8),d=ZC._i_(.75*c.AI),c.D=[[C,u-d],[C,u+d],[C-c.AI,u],[C,u-d]],c.parse(),c.AN&&c.paint(),(Z=new ZC.DT(f)).Z=Z.C7=f.Z,Z.K=f.K+"-page-next",Z.A0=Z.AE=f.D4.page<f.D4.pages?ee["background-color"]:$["background-color"],Z.append(f.D4.page<f.D4.pages?f.o["page-on"]:f.o["page-off"]),p=f.iX+f.I/2+U.I/2+6,h=U.iY+U.F/2,Z.parse(),Z.AI=ZC.BQ(Z.AI,8),d=ZC._i_(.75*Z.AI),Z.D=[[p,h-d],[p,h+d],[p+Z.AI,h],[p,h-d]],Z.parse(),Z.AN&&Z.paint()}if(!ZC.move){var ie,te,ne=f.F,ae=f.iY;f.FO&&(ne-=f.FO.F,ae+=f.FO.F),ZC.AK(f.K+"-frame")?ZC.A5("#"+f.K+"-frame").css("top",ae+"px").css("left",f.iX+"px").css("width",f.I+"px").css("height",ne+"px"):ZC.Q.HY({cls:"zc-abs zc-legend-frame "+f.K+"-frame",id:f.K+"-frame",wh:f.I+"/"+ne,tl:ae+"/"+f.iX,opacity:0,background:"#fff",p:_,zidx:0}),f.D4.enabled&&!f.N8&&(f.D4.page>1&&ZC.Q.HY({cls:f.K+"-page-area zc-legend-page-area zc-abs",id:f.K+"-page-prev-area",wh:c.AI+"/"+2*c.AI,tl:ZC._i_(u+c.BH-c.AI)+"/"+ZC._i_(C+c.BM-c.AI),opacity:0,p:_,zidx:1}),f.D4.page<f.D4.pages&&ZC.Q.HY({cls:f.K+"-page-area zc-legend-page-area zc-abs",id:f.K+"-page-next-area",wh:Z.AI+"/"+2*Z.AI,tl:ZC._i_(h+c.BH-Z.AI)+"/"+ZC._i_(p+Z.BM),opacity:0,p:_,zidx:1})),f.FO&&f.V0&&("icon"===f.UM?(te=ZC._i_(f.FO.iY+ZC.MAPTX+n.BH)+"/"+ZC._i_(f.FO.iX+f.FO.I-20+ZC.MAPTX+n.BM),ie="20/"+f.FO.F):(te=ZC._i_(f.FO.iY+ZC.MAPTX)+"/"+ZC._i_(f.FO.iX+ZC.MAPTX),ie=f.FO.I-(f.UR?23:0)+"/"+f.FO.F),ZC.Q.HY({cls:f.K+"-header-area zc-legend-header-area zc-abs",id:f.K+"-move-area",wh:ie,tl:te,opacity:0,p:_,zidx:1})),f.UR&&(f.V0&&"icon"===f.UM?(te=ZC._i_(f.FO.iY+ZC.MAPTX+t.BH)+"/"+ZC._i_(f.FO.iX+f.FO.I-41+ZC.MAPTX+t.BM),ie="20/"+f.FO.F):(te=ZC._i_(f.FO.iY+ZC.MAPTX+t.BH)+"/"+ZC._i_(f.FO.iX+f.FO.I-22+ZC.MAPTX+t.BM),ie="20/"+f.FO.F),ZC.Q.HY({cls:f.K+"-header-area zc-legend-header-area zc-abs",id:f.K+"-minimize-area",wh:ie,tl:te,opacity:0,p:_,zidx:1})),f.OS=0,f.ZW=0,f.zc_legend_mouseover=function(){f.YF=!0},f.zc_legend_mouseout=function(){f.YF=!1},f.Z5=function(e){if(e.preventDefault(),f.H.hideCM(),ZC.move=!0,ZC.mobile||!(e.which>1)){f.A.A.E["graph-"+f.A.K+"-legend-info"]=null;var i=ZC.Q.MB(e),t=ZC.A5("#"+f.A.A.K+"-top").offset();f.OS=i[0]-t.left-f.FO.iX,f.ZW=i[1]-t.top-f.FO.iY,f.oldcursor=document.body.style.cursor,document.body.style.cursor="move",ZC.A5(document.body).bind(ZC.Q.BZ("mousemove"),f.Z6),ZC.A5(document.body).bind(ZC.Q.BZ("mouseup"),f.A0T)}},f.Z6=function(e){var i=ZC.Q.MB(e),t=ZC.A5("#"+f.A.A.K+"-top").offset(),n=i[0]-t.left-f.OS,a=i[1]-t.top-f.ZW;if(f.PQ?(n=ZC.BQ(n,f.H.iX+2),n=ZC.CY(n,f.H.iX+f.H.I-f.I-2),a=ZC.BQ(a,f.H.iY+2),a=ZC.CY(a,f.H.iY+f.H.F-f.F-4)):(n=ZC.BQ(n,f.A.iX+2),n=ZC.CY(n,f.A.iX+f.A.I-f.I-2),a=ZC.BQ(a,f.A.iY+2),a=ZC.CY(a,f.A.iY+f.A.F-f.F-4)),f.PQ||(n-=f.A.iX,a-=f.A.iY),f.o.x=n,f.o.y=a,f.o.position=null,f.clear(!0),f.parse(),f.paint(),f.FO){var l=f.PQ?f.A.A:f.A;f.A.A.E["legend"+f.A.L+"-xy-ratio"]=[n/l.I,a/(l.F-f.FO.F)]}},f.A0T=function(){ZC.move=!1,document.body.style.cursor=f.oldcursor,delete f.oldcursor,ZC.A5(document.body).unbind(ZC.Q.BZ("mousemove"),f.Z6),ZC.A5(document.body).unbind(ZC.Q.BZ("mouseup"),f.A0T),f.XU=[],f.clear(!1),f.parse(),f.paint(),f.VT()},f.YY=function(e){f.E["default-width"]=null,-1!==(e.targetid||e.target.id).indexOf("-page-next-area")?(f.D4.min+=f.EG,f.D4.max+=f.EG,f.D4.page+=1):(f.D4.min-=f.EG,f.D4.max-=f.EG,f.D4.page-=1),(!(i=f.A.A.E["graph-"+f.A.K+"-legend-info"])||null===ZC._n_(i.x)&&null===ZC._n_(i.y))&&(f.iX=null,f.iY=null),f.VT(),f.A.K6()},f.Y2=function(e){var i=f.N8?"legendmaximize":"legendminimize";e&&(f.A.A.E["legend-toggling"]=1),zingchart.exec(f.A.H.K,i,{graphid:f.A.L}),e&&(f.A.A.E["legend-toggling"]=0),e&&(f.A.A.E["g"+f.A.L+"-legend-collapsed"]="legendminimize"===i)},f.MN=function(e){ZC.move=!0;var i=ZC.Q.MB(e),t=ZC.A5("#"+f.A.A.K+"-top").offset(),n=i[0]-t.left,a=i[1]-t.top;f.E["dragged-x"]=n,f.E["dragged-y"]=a,f.VT(),f.clear(!1),f.parse(),f.paint()},f.W8=function(e){if(e.preventDefault(),f.H.hideCM(),f.IV=document.body.style.cursor,document.body.style.cursor="move",ZC.mobile||!(e.which>1)){var i=new RegExp("-legend-item_([0-9]+)-area","g").exec(e.target.id);i&&(f.E["dragged-offset-y"]=0,f.E["calculate-y"]=!0,f.E["dragged-x"]=0,f.E["dragged-y"]=0,f.ND=ZC._i_(i[1]),f.iDragPos=ZC.AV(f.A.AY.M2,f.ND),ZC.A5(document.body).bind(ZC.Q.BZ("mousemove"),f.MN),ZC.A5(document.body).bind(ZC.Q.BZ("mouseup"),f.XB))}},f.XB=function(){var e=f.ND,i=f.iDragPos;if(f.ND=-1,f.iDragPos=-1,f.E["calculate-y"]=!1,document.body.style.cursor=f.IV,ZC.move||(e=-1,i=-1),ZC.A5(document.body).unbind(ZC.Q.BZ("mousemove"),f.MN),ZC.A5(document.body).unbind(ZC.Q.BZ("mouseup"),f.XB),ZC.move&&-1!==e){for(var t=f.A.AY.A4,n=f.A.AY.M2,a=0,l=t.length;a<l;a++)t[a].o["legend-item"]=t[a].o["legend-item"]||{},null===ZC._n_(t[a].o["legend-item"].order)&&(t[a].o["legend-item"].order=ZC._i_(t[a].o["z-index"]||a+1));for(var o=t[e].o["legend-item"].order,r=-1,s=0,A=f.Q4.length;s<A;s++)f.E["dragged-y"]-f.E["dragged-offset-y"]/2>f.Q4[s].iY&&(r=s);for(t[e].o["legend-item"].order=-1===r?.5:t[n[r]].o["legend-item"].order+.5,s=0,A=f.Q4.length;s<A;s++)r>i?t[s].o["legend-item"].order<t[e].o["legend-item"].order&&t[s].o["legend-item"].order>o&&t[s].o["legend-item"].order--:t[s].o["legend-item"].order>t[e].o["legend-item"].order&&t[s].o["legend-item"].order<o&&t[s].o["legend-item"].order++;for(t[e].o["legend-item"].order=r>i?Math.floor(t[e].o["legend-item"].order):Math.ceil(t[e].o["legend-item"].order),s=0,A=f.Q4.length;s<A;s++)f.A.o.series[s]["z-index"]=t[s].o["legend-item"].order}f.A.AY.E["plot-sort"]=!0,ZC.move=!1,f.clear(!1),f.A.K6()},ZC.A5("#"+f.K+"-frame").live(ZC.Q.BZ("mouseover"),f.zc_legend_mouseover).live(ZC.Q.BZ("mouseout"),f.zc_legend_mouseout),ZC.A5("#"+f.K+"-move-area").live(ZC.Q.BZ("mousedown"),f.Z5),ZC.A5("#"+f.K+"-minimize-area").live(ZC.Q.BZ("click"),f.Y2),ZC.A5("."+f.K+"-page-area").live(ZC.Q.BZ("click"),f.YY),f.BR.o.reorder&&ZC.A5("."+f.A.K+"-legend-item-area").live("mousedown",f.W8)}f.E.showhide=null,1===f.A.A.E["legend-toggling"]||ZC.move||(f.M1&&null===ZC._n_(f.A.A.E["g"+f.A.L+"-legend-collapsed"])||f.A.A.E["g"+f.A.L+"-legend-collapsed"]&&!f.N8)&&(window.setTimeout(function(){f.Y2(!0)},0),f.A.A.E["g"+f.A.L+"-legend-collapsed"]=!0)}},gc:function(){ZC.AP.gc(this,["B6","D","Q4","Z","C7","o","J9","I6","KL","FO","BR","ZG","H","A","A2","NL","D4"])}};ZC.UV=ZC.DN.CA(UV);var A81={$i:function(e){this.b(e);var i=this;i.MW=null,i.BB=null,i.M=null,i.JR=0,i.BG=null,i.GE="bottom",i.L0=40,i.A37=[2,4]},parse:function(){var e,i,t,n=this;(n.assign_a([["z-index","JR","i"],["length","L0","i"],["aspect","A37"],["direction","GE"]]),null===ZC._n_(n.o.from)&&null===ZC._n_(n.o.to))&&(null!==ZC._n_(n.o.x)&&null!==ZC._n_(n.o.y)&&null!==ZC._n_(n.o.length)&&null!==ZC._n_(n.o.angle)&&(i="string"==typeof n.o.x?n.A.UY(n.o.x)[0]:ZC._i_(n.o.x),t="string"==typeof n.o.y?n.A.UY(n.o.y)[1]:ZC._i_(n.o.y),n.o.from={x:i+n.L0*ZC.EP(n.A9+180),y:t+n.L0*ZC.EH(n.A9+180)},n.o.to={x:i+n.L0*ZC.EP(n.A9),y:t+n.L0*ZC.EH(n.A9)}));null!==ZC._n_(e=n.o.from)&&(n.MW=new ZC.DT(n.A),n.MW.append(e),null!==e.hook&&(n.MW.E.hook=e.hook),n.MW.parse(),"string"==typeof e&&(n.MW.E.hook=e)),null!==ZC._n_(e=n.o.to)&&(n.BB=new ZC.DT(n.A),n.BB.append(e),null!==e.hook&&(n.BB.E.hook=e.hook),n.BB.parse(),"string"==typeof e&&(n.BB.E.hook=e)),(null!==ZC._n_(e=n.o.label)||""!==n.o.text&&"undefined"!=typeof n.o.text)&&(n.M=new ZC.DN(n),n.M.append(n.o),n.M.append(e),n.M.parse()),n.b()},paint:function(){var e,i,t=this;if(t.AN&&(null!==t.MW||null!==t.BB))if(t.AI<1&&(t.AI=1),!t.MW||null===ZC._n_(e=t.MW.E.hook)||(i=t.A.UY(e),t.MW.iX=i[0],t.MW.iY=i[1],t.MW.iX+=t.MW.BM,t.MW.iY+=t.MW.BH,ZC.DS(t.MW.iX,t.A.P.iX-2,t.A.P.iX+t.A.P.I+2)&&ZC.DS(t.MW.iY,t.A.P.iY-2,t.A.P.iY+t.A.P.F+2)))if(!t.BB||null===ZC._n_(e=t.BB.E.hook)||(i=t.A.UY(e),t.BB.iX=i[0],t.BB.iY=i[1],t.BB.iX+=t.BB.BM,t.BB.iY+=t.BB.BH,ZC.DS(t.BB.iX,t.A.P.iX-2,t.A.P.iX+t.A.P.I+2)&&ZC.DS(t.BB.iY,t.A.P.iY-2,t.A.P.iY+t.A.P.F+2))){var n,a;if(t.MW&&t.BB)n=[t.MW.iX,t.MW.iY],a=[t.BB.iX,t.BB.iY];else if(t.MW&&!t.BB)switch(n=[t.MW.iX,t.MW.iY],t.GE){case"top":a=[t.MW.iX,t.MW.iY+t.L0];break;case"right":a=[t.MW.iX+t.L0,t.MW.iY];break;case"bottom":a=[t.MW.iX,t.MW.iY-t.L0];break;case"left":a=[t.MW.iX-t.L0,t.MW.iY]}else if(!t.MW&&t.BB)switch(a=[t.BB.iX,t.BB.iY],t.GE){case"top":n=[t.BB.iX,t.BB.iY+t.L0];break;case"right":n=[t.BB.iX-t.L0,t.BB.iY];break;case"bottom":n=[t.BB.iX,t.BB.iY-t.L0];break;case"left":n=[t.BB.iX+t.L0,t.BB.iY]}var l,o=a[0]-n[0],r=a[1]-n[1],s=ZC.TK(Math.atan2(r,o)),A=Math.sqrt(o*o+r*r),C=[];if(C.push(n),l=ZC.AQ.BN(n[0],n[1],t.AI/2,s+90),C.push(l),l=ZC.AQ.BN(l[0],l[1],A-t.A37[1]*t.AI/2,s),C.push(l),l=ZC.AQ.BN(l[0],l[1],t.A37[0]*t.AI/2,s+90),C.push(l),C.push(a),l=ZC.AQ.BN(l[0],l[1],(2*t.A37[0]+2)*t.AI/2,s-90),C.push(l),l=ZC.AQ.BN(l[0],l[1],t.A37[0]*t.AI/2,s+90),C.push(l),l=ZC.AQ.BN(n[0],n[1],t.AI/2,s-90),C.push(l),C.push(n),t.BG=new ZC.DT(t.A),t.BG.K=t.K,t.BG.Z=t.BG.C7=t.Z,t.BG.copy(t),t.BG.D=C,t.BG.CZ=!1,t.BG.parse(),t.BG.paint(),null!==t.M&&t.M.AN){t.M.Z=t.Z,t.M.K=t.A.K+"-arrow-label-"+t.H8,t.M.GL=t.A.K+"-arrow-label zc-arrow-label";var c=ZC.AQ.JT(n[0],n[1],a[0],a[1]);t.M.iX=c[0],t.M.iY=c[1],t.M.BM-=t.M.I/2,t.M.BH-=t.M.F/2,null!==ZC._n_(t.M.o["font-angle"])&&"inherit"===t.M.o["font-angle"]&&(t.M.A9=s),t.M.paint(),t.M.EK()}}else t.AN=!1;else t.AN=!1}};ZC.A81=ZC.DT.CA(A81);var JS={$i:function(e){var i=this;i.H=e,i.S3=!1,i.C4=null,i.Z1=null,i.Q7=null,i.zc_guide_touchend=null},unbind:function(){var e=this;e.C4&&window.clearInterval(e.C4),e.Z1&&window.clearInterval(e.Z1),ZC.A5(document.body).unbind("mousemove touchstart touchmove",e.Q7),ZC.A5(document.body).unbind("touchend",e.zc_guide_touchend)},bind:function(){var e,i=this,t=i.H.K,n=ZC.AK(t+"-guide-c"),a=ZC.Q.EB(n,i.H.AA),l={},o={},r={},s={},A=null,C=null,c=null;function u(){!C&&c&&(c.E["guide-active-plot"]=null),ZC.JS.GUIDES&&ZC.JS.GUIDES[t]&&!ZC.JS.GUIDES[t].blocked&&ZC.JS.clearGuide(t),C=null}ZC.mobile||null!==ZC._n_(ZC.Z1)||(i.Z1=window.setInterval(function(){for(var e=!0,n=0,a=zingchart.HZ.length;n<a;n++)if(t===zingchart.HZ[n].K)if(ZC.AK(zingchart.HZ[n].K+"-top")){var l=ZC._tx_(t),o=ZC.A5("#"+zingchart.HZ[n].K+"-top").offset();ZC.E1[0]>=o.left&&ZC.E1[0]<=o.left+zingchart.HZ[n].I*l[0]&&ZC.E1[1]>=o.top&&ZC.E1[1]<=o.top+zingchart.HZ[n].F*l[1]&&(e=!1)}else window.clearInterval(i.Z1);e&&(u(),ZC.JS.GUIDES&&ZC.JS.GUIDES[t]&&ZC.JS.GUIDES[t].active&&(ZC.AP.BY("guide_mouseout",i.H,i.H.FE()),ZC.JS.GUIDES[t].active=!1))},500)),i.Q7=function(p){if(zingchart.GUIDE_EV=p,!p.target.id||-1===p.target.id.indexOf("-menu-item-")){var Z,h,d,f,_,g,v,b,B,m,E,D,K,F,x,I,y,w,Y,X,M,L,H,P,N,G,S;ZC.MAX,ZC.MAX;for(Z=0;Z<zingchart.HZ.length;Z++)if(zingchart.HZ[Z].K!==i.H.K&&-1!==zingchart.HZ[Z].K.indexOf("-fullscreen"))return;if((ZC.ie67||"mousemove"!==p.type||!ZC.TOUCHEVENTS)&&-1!==p.target.id.indexOf(i.H.K+"-")&&(!ZC.move||ZC.mobile)){if(i.H.ZT||!ZC.AK(t+"-top"))return!1;if(!ZC.Q.AB3(ZC.AK(t+"-top")))return!1;var O=[],k=ZC.Q.MB(p),T=k[0],z=k[1];if(null!==ZC._n_(p._pageX_)&&(T=p._pageX_),null!==ZC._n_(p._pageY_)&&(z=p._pageY_),null===ZC._n_(p._pageX_)&&null===ZC._n_(p._pageY_)){var Q=ZC.A5("#"+t+"-top").offset();d=T-Q.left,f=z-Q.top}else d=T,f=z;var J=ZC._tx_(i.H.K);for(d/=J[0],f/=J[1],Z=0,h=i.H.AG.length;Z<h;Z++)_=i.H.AG[Z].P,ZC.DS(d,_.iX-15,_.iX+_.I+15)&&ZC.DS(f,_.iY-15,_.iY+_.F+15)&&(C=i.H.AG[Z]),ZC.DS(d,i.H.AG[Z].iX,i.H.AG[Z].iX+i.H.AG[Z].I)&&ZC.DS(f,i.H.AG[Z].iY,i.H.AG[Z].iY+i.H.AG[Z].F)&&(A=i.H.AG[Z]);var V=null,R=!1;if(C){if(ZC.JS.GUIDES=ZC.JS.GUIDES||{},ZC.JS.GUIDES[t]=ZC.JS.GUIDES[t]||{},p.fromAPI||(ZC.JS.GUIDES[t].blocked=!1,ZC.JS.GUIDES[t].active=!0),c=C,C.CX&&"hover"===C.CX.o.trigger){null!==ZC._n_(C.E["guide-active-plot"])&&(V=C.E["guide-active-plot"]);var W=/(.+)-plotset-plot-(.+)-node-(.+)/.exec(p.target.id);if(W&&W.length&&(V=parseInt(W[2],10),C.E["guide-active-plot"]=V),null===ZC._n_(V))return}if(!C.A1J)return void u();for(O.push(C),C&&C.CX&&(R=null!==ZC._n_(C.CX.o.shared)&&ZC._b_(C.CX.o.shared)),Z=0,h=i.H.AG.length;Z<h;Z++)if(i.H.AG[Z]!==C){_=i.H.AG[Z].P;var U=i.H.AG[Z].CX,j=i.H.AG[Z].HA,q=U&&null!==ZC._n_(U.o.shared)&&ZC._b_(U.o.shared);q&&("xy"===C.AJ.layout&&"xy"===i.H.AG[Z].AJ.layout&&(U||j)&&ZC.DS(d,_.iX-5,_.iX+_.I+5)&&(ZC.DS(f,_.iY-5,_.iY+_.F+5)||R&&q)||"yx"===C.AJ.layout&&"yx"===i.H.AG[Z].AJ.layout&&(U||j)&&ZC.DS(f,_.iY-5,_.iY+_.F+5)&&(ZC.DS(d,_.iX-5,_.iX+_.I+5)||R&&q))&&O.push(i.H.AG[Z])}}else if(ZC.JS.GUIDES)for(var $ in ZC.JS.GUIDES)if(ZC.JS.GUIDES[$]&&ZC.JS.GUIDES[$].active){var ee=zingchart.getLoader($);N=ee.FE(),ZC.AP.BY("guide_mouseout",ee,N),ZC.JS.GUIDES[$].active=!1}if(0===O.length&&(l={},o={},r={},i.S3&&(null===ZC._n_(p._pageX_)&&u(),i.S3=!1),c&&c.A.A7&&A&&A.K!==c.K&&c.A.A7.hide()),O.length>0){i.S3=!0;for(var ie=!1,te=0,ne=O.length;te<ne;te++){var ae=!1;if(null===ZC._n_(l[te])&&(l[te]={}),null===ZC._n_(o[te])&&(o[te]={}),null===ZC._n_(r[te])&&(r[te]={}),(O[te].CX||O[te].HA)&&"ready"===O[te].MA){var le,oe=[],re=[],se=[],Ae=!1,Ce="",ce=[],ue=[],pe=[],Ze=[],he={},de={},fe=[];_=O[te].P;var _e=O[te].CX&&null!==ZC._n_(O[te].CX.o.exact)&&ZC._b_(O[te].CX.o.exact),ge=-1;O[te].CX&&(ge=ZC._i_(ZC._c_(O[te].CX.o.tolerance||-1))),F=[-1,ZC.MAX],x=[-1,ZC.MAX],ZC.MAX,ZC.MAX;var ve,be,Be=!0,me=[],Ee="";O[te].CX&&(null!==ZC._n_(O[te].CX.o["plot-label"])&&ZC._n_(null!==(e=O[te].CX.o["plot-label"].multiple))&&(Be=ZC._b_(e)),null!==ZC._n_(O[te].CX.o["value-label"])&&ZC._n_(null!==(e=O[te].CX.o["value-label"].multiple))&&(Be=ZC._b_(e)));var De={};for(L=0,H=O[te].AY.A4.length;L<H;L++)if(!O[te].AY.A4[L].LP&&(Z=L,O[te].CX&&O[te].CX.o["reverse-series"]&&(Z=H-L-1),O[te].E["plot"+Z+".visible"])){if(null!==ZC._n_(V)&&Z!==V)continue;if(!(ve=O[te].BL(O[te].AY.A4[Z].BU("k")[0])))continue;if(ve.CO){var Ke=ve.AW?ve.iY+ve.BV:ve.iY+ve.AB,Fe=ve.AW?ve.iY+ve.F-ve.BV:ve.iY+ve.F-ve.AB;f=ZC._l_(f,Ke,Fe),g=ve.EF&&O[te].AY.A4[Z].EF?ve.OE(f,O[te].AY.A4[Z]):ve.OE(f)}else{var xe=ve.AW?ve.iX+ve.BV:ve.iX+ve.AB,Ie=ve.AW?ve.iX+ve.I-ve.AB:ve.iX+ve.I-ve.BV;d=ZC._l_(d,xe,Ie),g=ve.EF&&O[te].AY.A4[Z].EF?ve.OE(d,O[te].AY.A4[Z]):ve.OE(d)}if(null===ZC._n_(g))continue;var ye,we,Ye,Xe,Me,Le,He,Pe,Ne=[];if(Ne="undefined"==typeof g.length||0===g.length?[g]:g,O[te].CX){for(var Ge=0,Se=Ne.length;Ge<Se;Ge++)if(g=Ne[Ge],v=O[te].AY.A4[Z].FK(g)){le=v,v.setup(),v.N?(ZC.COLORS=[v.N.C2,v.N.A0,v.N.AE,v.N.BW,v.N.B7],v.NC&&ZC.COLORS.push(v.NC.A0,v.NC.AE,v.NC.BW,v.NC.B7)):ZC.COLORS=[],v.A.I3&&"undefined"!=typeof v.E.A5M&&v.paint(!0),I=v.iX,y=v.iY,"undefined"!=typeof v.E.A5M&&(I=parseInt(v.E.A5M,10)),"undefined"!=typeof v.E.A7M&&(y=parseInt(v.E.A7M,10)),D=I,K=y,he[Z]={index:g,y:y},O[te].BD&&O[te].BD.XR&&(O[te].BD.clear(!0),O[te].BD.parse(),O[te].BD.paint(g)),(b=new ZC.DN(ve)).Z=b.C7=n,b.K=O[te].K+"-guide-label-"+g+"-"+Z,b.GL=O[te].A.K+"-guide-label "+O[te].K+"-guide-label zc-guide-label",Be&&(M=v.A8E(),b.AM=v.A.JB),Be?b.append(O[te].CX.o["plot-label[multiple]"]):b.append(O[te].CX.o["plot-label[single]"]),b.append(O[te].CX.o["plot-label"]),b.append(O[te].CX.o["value-label"]),b.append(O[te].AY.A4[Z].o["guide-label"]),E=ZC.AP.O3(b.o,O[te].AY.A4[Z].o),b.JV=function(e){return v?v.JV(e,E):e},v.AB2();var Oe="auto";if(null!==ZC._n_(e=b.o.placement)&&(Oe=e),b.E.placement=Oe,b.KP=Be,b.E.plotidx=v.A.L,b.E.nodeidx=v.L,b.parse(),P=null!==ZC._n_(b.o.distance)?ZC._i_(b.o.distance):6,b.E7&&b.E7.length&&(b.J2=function(e){return e=v?v.JV(e,E):e.replace(/(%i)|(%node-index)/g,g)},b.DE()&&(E=b.overrideFormat(E),b.parse())),b.HT&&v&&(b.H3(b,b,null,v.LT(null,!1),b.MJ),b.parse()),ZC.DS(v.iX,_.iX-.5,_.iX+_.I+.5)){switch(Be||(0===re.length&&(null===ZC._n_(b.o["header-text"])||Ae||(Ae=!0,Ee+=v.JV(b.o["header-text"],E)+"<br>"),null!==ZC._n_(b.o["footer-text"])&&""===Ce&&(Ce=v.JV(b.o["footer-text"],E)+"<br>")),b.AN&&""!==b.AM&&(ZC._b_(b.o["single-text"])?me.push(v.JV(b.AM,E)):me.push(v.JV(b.AM,E)+"<br>"))),b.E.pos=re.length,b.E["node-value"]=v.AD,b.E["marker-x"]=I,b.E["marker-y"]=y,b.E["guide-style"]=v.A8E(),Oe){default:null===ZC._n_(b.o.x)?ve.CO?v.iY<=_.iY+_.F/2?(b.iY=y-b.F-P,b.EM="bottom"):(b.iY=y+P,b.EM="top"):v.iX>=_.iX+_.I/2?(b.iX=I-b.I-P,b.EM="right"):(b.iX=I+P,b.EM="left"):b.iX-=_.iX,null===ZC._n_(b.o.y)?ve.CO?(b.iX=I-b.I/2,b.iX<_.iX&&(b.iX=_.iX),b.iX+b.I>_.iX+_.I&&(b.iX=_.iX+_.I-b.I)):(b.iY=y-b.F/2,b.iY<_.iY&&(b.iY=_.iY),b.iY+b.F>_.iY+_.F&&(b.iY=_.iY+_.F-b.F)):b.iY-=_.iY,b.DM=[I,y];break;case"left":b.iX=I-b.I-P,b.iY=y-b.F/2,b.DM=[I,y];break;case"right":b.iX=I+P,b.iY=y-b.F/2,b.DM=[I,y];break;case"top":ve.CO?(b.iX=_.iX+_.I-b.I,b.iY=y-b.F/2,b.EM="left",b.DM=[_.iX+_.I-b.I-P,y]):(b.iX=I-b.I/2,b.iY=_.iY,b.EM="bottom",b.DM=[I,b.iY+b.F+P]);break;case"node-top":ve.CO?(b.iX=I+2*P,b.iY=y-b.F/2,b.EM="left",b.DM=[I+P,y]):(b.iX=I-b.I/2,b.iY=y-b.F-2*P,b.EM="bottom",b.DM=[I,y-P]);break;case"bottom":ve.CO?(b.iX=_.iX,b.iY=y-b.F/2,b.EM="right",b.DM=[_.iX+b.I+P,y]):(b.iX=I-b.I/2,b.iY=_.iY+_.F-b.F,b.EM="top",b.DM=[I,b.iY-P])}oe.push({plotindex:v.A.L,nodeindex:v.L,keyvalue:v.BT||ve.V[v.L],value:v.AD,text:b.AM,x:b.iX,y:b.iY,refx:I,refy:y}),-1===ZC.AV(se,b.AM)&&(s[b]=v,se.push(b.AM)),ve.CO?b.E.diff=_e||-1!==ge?ZC._a_(y-f):-1:b.E.diff=_e||-1!==ge?ZC._a_(I-d):-1,b.AN&&re.push(b),o[te][Z]=b,ae=!0}}if(!v)continue}if(O[te].CX&&ZC.DS(v.iX,_.iX-1,_.iX+_.I+1)){if((m=new ZC.DN(ve)).Z=m.C7=n,m.K=O[te].K+"-guide-scale-x-label-"+Z,m.GL=O[te].A.K+"-guide-label "+O[te].K+"-guide-label zc-guide-label",m.A0=m.AE=ve.B7,m.C2=O[te].AJ["3d"]?"#999":"#fff",m.append(O[te].CX.o["scale-label"]),m.append(O[te].CX.o[ve.BE+"-label"]),m.append(O[te].AY.A4[Z].o["scale-label"]),m.KP=!0,m.E.nodeidx=v.L,E=ZC.AP.O3(m.o),null===ZC._n_(E.decimals)){var ke=Math.floor(ZC.G6(null!==v.BT?v.BT:v.L,10));E.decimals=ke<0?1-ke:0}if(m.JV=function(e){e=ve.JV(e,g,ve.EF&&O[te].AY.A4[Z].EF?O[te].AY.A4[Z]:null,E,!0);var i=O[te].AY.A4[Z].KH;if(v&&i)for(var t in i){var n;n=i[t]instanceof Array?ZC._c_(i[t][v.L],""):ZC._c_(i[t],""),e=e.replace("%data-"+t,n,"g")}return e},m.parse(),P=null!==ZC._n_(m.o.distance)?ZC._i_(m.o.distance):6,m.E7&&m.E7.length&&(m.J2=function(e){return e=v?v.JV(e,E):e.replace(/(%i)|(%node-index)/g,g)},m.DE()&&m.parse()),m.HT&&v&&(m.H3(m,m,null,v.LT(null,!1),m.MJ),m.parse()),de[ve.BE]=m.AM,ye=ZC._b_(m.o["callout-position"]),we=m.o.x,Ye=m.o.y,"opposite"!==ve.BA?ve.CO?(Xe="right",Le=ve.E.iX-m.I-P,Me=[ve.E.iX,K],He=K-m.F/2):(Xe="top",Le=D-m.I/2,Me=[D,ve.E.iY],He=ve.E.iY+P):ve.CO?(Xe="left",Le=ve.E.iX+P,Me=[ve.E.iX,K],He=K-m.F/2):(Xe="bottom",Le=D-m.I/2,Me=[D,ve.E.iY],He=ve.E.iY-m.F-P),ye||(m.EM=Xe),we||(m.iX=Le),ye||we||Ye||(m.DM=Me),Ye||(m.iY=He),m.AN&&ve.AN&&""!==m.AM){var Te=!1;if(fe.length)for(var ze=0;ze<fe.length;ze++)m.AM+"@"+ve.BE===fe[ze]&&(Te=!0);Te||(fe.push(m.AM+"@"+ve.BE),ve.CO?m.E.diff=_e||-1!==ge?ZC._a_(K-f):-1:m.E.diff=_e||-1!==ge?ZC._a_(D-d):-1,pe.push(m)),Ze.push(ve.BE),r[te][Z]=m,ae=!0}-1!==String(O[te].CX.o["line-width"]).indexOf("%")&&(Pe=ZC.II(O[te].CX.o["line-width"]))>0&&Pe<=1&&(O[te].CX.AZ=ZC._i_(Pe*ve.AC)),ve.CO?((-1===x[0]||x[1]>ZC._a_(K-f))&&(x=[K,ZC._a_(K-f)]),ce.push([_e||-1!==ge?ZC._a_(K-f):-1,[null,[ve.E.iX,K],[O[te].P.iX+("opposite"===ve.BA?0:O[te].P.I),K]]])):((-1===F[0]||F[1]>ZC._a_(D-d))&&(F=[D,ZC._a_(D-d)]),ce.push([_e||-1!==ge?ZC._a_(D-d):-1,[null,[D,ve.E.iY],[D,O[te].P.iY+("opposite"===ve.BA?O[te].P.F:0)]]]))}if(be=O[te].BL(O[te].AY.A4[Z].BU("v")[0]),-1===ZC.AV(Ze,be.BE)&&O[te].HA&&("xy"===O[te].AJ.layout&&ZC.DS(f,be.iY,be.iY+be.F)||"yx"===O[te].AJ.layout&&ZC.DS(f,be.iX,be.iX+be.I))){var Qe="single";O[te].HA.o.type&&"multiple"===O[te].HA.o.type&&(Qe="multiple"),"multiple"===Qe&&null!==ZC._n_(he[Z])&&(be.CO?d=he[Z].x:f=he[Z].y),(m=new ZC.DN(be)).Z=m.C7=n,m.K=O[te].K+"-guide-scale-y-label-"+Z,m.GL=O[te].A.K+"-guide-label "+O[te].K+"-guide-label zc-guide-label";var Je=be.B7;"multiple"===Qe&&(Je=O[te].AY.A4[Z].B7),m.A0=m.AE=Je,m.C2=O[te].AJ["3d"]&&"multiple"!==Qe?"#999":"#fff",m.append(O[te].HA.o["scale-label"]),m.append(O[te].HA.o[be.BE+"-label"]),m.KP=!0;var Ve=be.CO?be.NE(d,!0):be.NE(f,!0),Re=Ve;if(E=be.MP(),ZC._cp_(ZC.AP.O3(m.o,be.o),E),null===ZC._n_(E.decimals)){ke=Math.floor(ZC.G6(Ve,10));E.decimals=ke<=0?1-ke:0}Ve=be.FQ(0,Ve,E),m.o.text=Ve,m.parse(),P=null!==ZC._n_(m.o.distance)?ZC._i_(m.o.distance):6,m.E7&&m.E7.length&&(m.J2=function(e){return e=e.replace(/(%v)|(%scale-value)/g,Re).replace(/(%t)|(%scale-text)/g,Ve).replace(/(%coord)/,be.CO?d:f)},m.DE()&&m.parse()),m.HT&&v&&(De={value:Re,text:Ve,coord:be.CO?d:f},m.H3(m,m,null,De,m.MJ),m.parse()),de[be.BE]=m.AM,ye=ZC._b_(m.o["callout-position"]),we=m.o.x,Ye=m.o.y,"opposite"!==be.BA?be.CO?(Xe="top",Le=d-m.I/2,He=be.E.iY+P,Me=[d,be.E.iY]):(Xe="right",Le=be.E.iX-m.I-P,He=f-m.F/2,Me=[be.E.iX,f]):be.CO?(Xe="bottom",Le=d-m.I/2,He=be.E.iY-m.F-P,Me=[d,be.E.iY]):(Xe="left",Le=be.E.iX+P,He=f-m.F/2,Me=[be.E.iX,f]),ye||(m.EM=Xe),we||(m.iX=Le),ye||we||Ye||(m.DM=Me),Ye||(m.iY=He),m.AN&&be.AN&&(m.E.diff=-1,pe.push(m),"multiple"===Qe&&null!==ZC._n_(he[Z])||Ze.push(be.BE),r[te][Z]=m,ae=!0),-1!==String(O[te].HA.o["line-width"]).indexOf("%")&&(Pe=ZC.II(O[te].HA.o["line-width"]))>0&&Pe<=1&&(O[te].HA.AZ=ZC._i_(Pe*be.AC)),be.CO?ue.push(null,[d,be.E.iY],[d,O[te].P.iY+("opposite"===be.BA?O[te].P.F:0)]):ue.push(null,[be.E.iX,f],[O[te].P.iX+("opposite"===be.BA?0:O[te].P.I),f])}}if(!_e&&pe.length>1)for(var We=pe[pe.length-1],Ue=ZC._i_((We.FM+We.FU+We.EQ+We.FN)/4),je=pe.length-1;je>=0;je--)for(var qe=je;qe>=0;qe--)je!==qe&&ZC.AQ._boxoverlap2_(pe[je],pe[qe],-Ue)&&(pe[qe].C6=.3,pe[qe].V5=.1);for(B=ZC.MAX,Z=0,h=re.length;Z<h;Z++)re[Z].E.diff>=0&&(B=ZC.CY(re[Z].E.diff,B));-1!==ge&&(B=ZC.BQ(B,ge));var $e=!1,ei=1,ii=!1;re[0]&&(ii=ZC._b_(re[0].o["single-text"]),re[0].o["table-columns"]&&ZC._b_(re[0].o["html-mode"])&&($e=!0,ei=ZC._i_(re[0].o["table-columns"]||"1"),Ee+='<table class="zc-guide-label-table '+i.H.K+'-guide-label-table">')),!Be&&re.length>0&&("asc"!==re[0].o["sort-by-value"]&&"desc"!==re[0].o["sort-by-value"]||re.sort(function(e,i){return(e.E["node-value"]-i.E["node-value"])*("asc"===re[0].o["sort-by-value"]?1:-1)}));var ti=0;for(G=0,S=re.length;G<S&&(!(-1===re[G].E.diff||re[G].E.diff<=B)||($e?(ti%ei==0&&(Ee+="<tr>"),Ee+="<td>"+me[G]+"</td>",ti%ei==ei-1&&(Ee+="</tr>"),ti++):Ee+=me[re[G].E.pos],$e||!ii));G++);if($e&&(ti%ei!=ei-1&&(Ee+="</tr>"),Ee+="</table>"),""!==Ce&&(Ee+=Ce),!Be&&re.length>0&&(_e?ve.CO?(d=I=D,f=y=x[0]):(d=I=F[0],f=y=K):(d=I=D,f=y=K),""!==Ee&&(re[0].o.text=$e||ii?Ee:Ee.substring(0,Ee.length-4),re[0].parse()),P=null!==ZC._n_(b.o.distance)?ZC._i_(b.o.distance):6,null===ZC._n_(b.o.x)?ve.CO?d<O[te].iX+O[te].I/2?re[0].iX=d+P+14:re[0].iX=d-re[0].I-P-14:le&&le.iX>=_.iX+_.I/2?re[0].iX=I-re[0].I-P:re[0].iX=I+P:re[0].iX-=_.iX,null===ZC._n_(b.o.y)?ve.CO?le&&le.iY>=_.iY+_.F/2?re[0].iY=y-re[0].F-P:re[0].iY=y+P:f<O[te].iY+O[te].F/2?re[0].iY=f+P+14:re[0].iY=f-re[0].F-P-14:re[0].iY-=_.iY),ae){var ni=-1,ai=-1;if(ie||(null===ZC._n_(p._pageX_)&&u(),ie=!0),ce.length>0){var li=[];for(B=ZC.MAX,w=0,Y=ce.length;w<Y;w++)ce[w][0]>=0&&(B=ZC.CY(ce[w][0],B));for(-1!==ge&&(B=ZC.BQ(B,ge)),w=0,Y=ce.length;w<Y;w++)null!==ZC._n_(ce[w])&&(-1===ce[w][0]||ce[w][0]<=B)&&(O[te].CX&&O[te].CX.o["single-line"]&&ZC._b_(O[te].CX.o["single-line"])?(li=[].concat(ce[w][1]),"xy"===O[te].AJ.layout?ni=ZC._x_(ce[w][1][1][0]):"yx"===O[te].AJ.layout&&(ai=ZC._x_(ce[w][1][1][1]))):li=li.concat(ce[w][1]));if(O[te].CX.o.mask){var oi=-1;li.length>1&&li[1]&&(oi=li[1][0]||-1),O[te].CX.oMask||(O[te].CX.oMask=new ZC.HL(O[te]),O[te].CX.oMask.append({"background-color":"#fff",alpha:.85}),O[te].CX.oMask.append(O[te].CX.o.mask),O[te].CX.oMask.Z=n,O[te].CX.oMask.parse()),O[te].CX.oMask.iX=oi,O[te].CX.oMask.iY=O[te].P.iY,O[te].CX.oMask.I=Math.max(2,O[te].P.iX+O[te].P.I-oi+2),O[te].CX.oMask.F=O[te].P.F,O[te].CX.oMask.paint()}if(O[te].AJ["3d"])for(O[te].NX(),w=0,Y=li.length;w<Y;w++)li[w]&&(X=new ZC.CE(O[te],li[w][0]-ZC.AO.E2,li[w][1]-ZC.AO.E3,0),li[w][0]=X.ED[0],li[w][1]=X.ED[1]);O[te].CX.K=O[te].K+"-crosshair-x",O[te].CX.HT&&v&&(O[te].CX.H3(O[te].CX,O[te].CX,null,v.LT(null,!1),O[te].CX.MJ),O[te].CX.parse()),O[te].CX.AN&&ZC.CR.paint(a,O[te].CX,li)}if(ue.length>0){if(O[te].AJ["3d"])for(O[te].NX(),w=0,Y=ue.length;w<Y;w++)null!==ZC._n_(ue[w])&&(X=new ZC.CE(O[te],ue[w][0]-ZC.AO.E2,ue[w][1]-ZC.AO.E3,0),ue[w][0]=X.ED[0],ue[w][1]=X.ED[1]);O[te].HA.HT&&v&&(O[te].HA.H3(O[te].HA,O[te].HA,null,De,O[te].HA.MJ),O[te].HA.parse()),O[te].HA.AN&&ZC.CR.paint(a,O[te].HA,ue)}if(Be){for(Z=re.length-1;Z>=0;Z--)ZC.DS(re[Z].DM[0],_.iX-5,_.iX+_.I+5)&&ZC.DS(re[Z].DM[1],_.iY-5,_.iY+_.F+5)||re.splice(Z,1);if(re.length>1)for(var ri=!0;ri;)for(ri=!1,Z=0;Z<re.length-1;Z++)if(re[Z].AN&&(be.CO&&re[Z].iX>re[Z+1].iX||!be.CO&&re[Z].iY>re[Z+1].iY)){var si=re[Z];re[Z]=re[Z+1],re[Z+1]=si,ri=!0}if(re.length>0){var Ai=[],Ci=[];for(Z=0;Z<re.length;Z++)null!==ZC._n_(re[Z].o.x)&&null!==ZC._n_(re[Z].o.y)&&Ci.push(re[Z]);for(var ci,ui,pi,Zi=!0,hi=0,di=re.length*re.length;Zi&&hi<di;)for(hi++,Zi=!1,Z=0;Z<re.length-1;Z++)if(re[Z].AN&&-1===ZC.AV(Ci,re[Z]))if(ve.CO){if(re[Z+1].iX<re[Z].iX+re[Z].I){if(re[Z+1].iX-re[Z].I-4<_.iX&&-1===ZC.AV(Ai,re[Z])&&(Ai.push(re[Z]),re[Z].iX=_.iX),re[Z+1].iX=re[Z].iX+re[Z].I+4,re[Z+1].iX+re[Z+1].I>_.iX+_.I)for(pi=re[Z+1].iX-(_.iX+_.I-re[Z+1].I),ci=0,ui=re.length;ci<ui;ci++)re[ci].iX-pi>=_.iX?re[ci].iX-=pi:(re[ci].iX=_.iX,ci>0&&(re[Z+1].E["marker-y"]<_.iY+_.F/2?re[ci].iY=re[ci-1].iY+re[ci-1].F+4:re[ci].iY=re[ci-1].iY-re[ci].F-4));Zi=!0}}else if(re[Z+1].iY<re[Z].iY+re[Z].F){if(re[Z+1].iY-re[Z].F-4<_.iY&&-1===ZC.AV(Ai,re[Z])&&(Ai.push(re[Z]),re[Z].iY=_.iY),re[Z+1].iY=re[Z].iY+re[Z].F+4,re[Z+1].iY+re[Z+1].F>_.iY+_.F)for(pi=re[Z+1].iY-(_.iY+_.F-re[Z+1].F),ci=0,ui=re.length;ci<ui;ci++)re[ci].iY-pi>=_.iY?re[ci].iY-=pi:(re[ci].iY=_.iY,ci>0&&(re[Z+1].E["marker-x"]<_.iX+_.I/2?re[ci].iX=re[ci-1].iX+re[ci-1].I+4:re[ci].iX=re[ci-1].iX-re[ci].I-4));Zi=!0}}}var fi=!1;for(Z=0,h=pe.length;Z<h;Z++)if(-1===pe[Z].E.diff||pe[Z].E.diff<=B){var _i=pe[Z];O[te].AJ["3d"]&&(O[te].NX(),X=new ZC.CE(O[te],_i.iX+_i.I/2-ZC.AO.E2,_i.iY+_i.F/2-ZC.AO.E3,0),_i.iX=X.ED[0]-_i.I/2,_i.iY=X.ED[1]-_i.F/2,X=new ZC.CE(O[te],_i.DM[0]-ZC.AO.E2,_i.DM[1]-ZC.AO.E3,0),_i.DM[0]=X.ED[0],_i.DM[1]=X.ED[1]),O[te].CX&&O[te].CX.o["single-line"]&&ZC._b_(O[te].CX.o["single-line"])?("xy"===O[te].AJ.layout&&ni===ZC._x_(_i.iX+_i.I/2)||"yx"===O[te].AJ.layout&&ai===ZC._x_(_i.iY+_i.F/2))&&!fi&&(_i.paint(),fi=!0):_i.paint()}for(B=ZC.MAX,G=0,S=re.length;G<S;G++)re[G].E.diff>=0&&(B=ZC.CY(re[G].E.diff,B));for(-1!==ge&&(B=ZC.BQ(B,ge)),L=0,G=0,S=re.length;G<S;G++)if(-1===re[G].E.diff||re[G].E.diff<=B){var gi=ZC.DS(re[G].DM[0],_.iX-5,_.iX+_.I+5)&&ZC.DS(re[G].DM[1],_.iY-5,_.iY+_.F+5);if(!Be||gi){if(re[G].AN){switch(re[G].E.placement){case"top":ve.CO?re[G].DM[0]=re[G].iX-re[G].G8:re[G].DM[1]=re[G].iY+re[G].F+re[G].G8;break;case"bottom":ve.CO?re[G].DM[0]=re[G].iX+re[G].I+re[G].G8:re[G].DM[1]=re[G].iY-re[G].G8}if(-1!==ZC.AV(["top","bottom"],re[G].E.placement)){var vi=re[G].iX+re[G].I/2;re[G].iX=ZC.BQ(re[G].iX,0),re[G].iX=ZC.CY(re[G].iX,i.H.I-re[G].I),re[G].iY=ZC.BQ(re[G].iY,0),re[G].iY=ZC.CY(re[G].iY,i.H.F-re[G].F),null===ZC._n_(re[G].o["callout-offset"])&&(re[G].EV=parseInt(100*(vi-re[G].iX-re[G].I/2)/(re[G].I-re[G].H9),10))}if(O[te].AJ["3d"]&&(O[te].NX(),X=new ZC.CE(O[te],re[G].iX+re[G].I/2-ZC.AO.E2,re[G].iY+re[G].F/2-ZC.AO.E3,0),re[G].iX=X.ED[0]-re[G].I/2,re[G].iY=X.ED[1]-re[G].F/2,X=new ZC.CE(O[te],re[G].DM[0]-ZC.AO.E2,re[G].DM[1]-ZC.AO.E3,0),re[G].DM[0]=X.ED[0],re[G].DM[1]=X.ED[1],"left"===re[G].EM?re[G].iX=re[G].DM[0]+P:re[G].iX=re[G].DM[0]-re[G].I-P),O[te].AJ["3d"]||Be||0!==L||(re[G].iX=ZC.BQ(_.iX-5,re[G].iX),re[G].iY=ZC.BQ(_.iY-5,re[G].iY),re[G].iX=ZC.CY(_.iX+_.I-re[G].I+5,re[G].iX),re[G].iY=ZC.CY(_.iY+_.F-re[G].F+5,re[G].iY)),Be||!Be&&0===L){var bi=Be?G:0;(!Be||"canvas"===i.H.AA&&re[bi].o["background-image"]&&""!==re[bi].o["background-image"])&&re[bi].parse(),0!==re[bi].C6&&re[bi].paint(),L++}}if(gi){var Bi=new ZC.DT(O[te]);if(i.H.B8.load(Bi.o,"("+O[te].AF+").guide.marker"),Bi.K=re[G].K+"-marker",Bi.Z=Bi.C7=n,Bi.iX=re[G].E["marker-x"],Bi.iY=re[G].E["marker-y"],O[te].AJ["3d"]&&(O[te].NX(),X=new ZC.CE(O[te],Bi.iX-ZC.AO.E2,Bi.iY-ZC.AO.E3,0),Bi.iX=X.ED[0],Bi.iY=X.ED[1]),M=re[G].E["guide-style"],Bi.A0=Bi.AE=ZC.AP.JN(M["background-color"]),Bi.BW=M.color,Bi.append(O[te].CX.o.marker),Bi.append(O[te].AY.A4[re[G].E.plotidx].o["guide-marker"]),"inherit"===Bi.o.type){var mi=O[te].AY.A4[re[G].E.plotidx];mi.A2&&mi.A2.o.type&&(Bi.o.type=mi.A2.o.type)}Bi.parse(),Bi.AN&&"none"!==Bi.DU&&Bi.AI>1&&Bi.paint()}}}(N=O[te].GX()).items=oe,N.guide={x:I,y:y},N.ev=p,N["scale-label"]=de,ZC.AP.BY("guide_mousemove",i.H,N),O[te].QR(!0)}else(N={}).guide={x:I,y:y},N.ev=p,ZC.AP.BY("guide_mousemove",i.H,N)}}}}}},i.zc_guide_touchend=function(){0!==zingchart.DEV.GUIDETIMEOUT&&window.setTimeout(function(){u()},ZC._i_(zingchart.DEV.GUIDETIMEOUT))},ZC.A5(document.body).bind("mousemove touchstart touchmove",i.Q7),ZC.A5(document.body).bind("touchend",i.zc_guide_touchend)}};ZC.JS=ZC.C9.CA(JS),ZC.JS.clearGuide=function(e){var i=zingchart.getLoader(e);if(i){zingchart.GUIDE_EV=null;var t=ZC.AK(e+"-guide-c"),n=ZC.A5(t).width(),a=ZC.A5(t).height();ZC.A5("."+e+"-guide-label").remove(),ZC.Q.IU(t,i.AA,0,0,n,a),ZC.A5("#"+e+"-defs").children().each(function(){this.id&&-1!==this.id.indexOf("-guide-label-")&&ZC.Q.EU(this.id)})}},zingchart.extendAPI("resetguide",function(e,i){"string"==typeof(i=i||{})&&(i=JSON.parse(i)),ZC.JS.GUIDES[e]=ZC.JS.GUIDES[e]||{},ZC.JS.GUIDES[e].blocked=!1,ZC.JS.clearGuide(e)}),zingchart.extendAPI("setguide",function(e,i){"string"==typeof(i=i||{})&&(i=JSON.parse(i));var t,n,a=zingchart.getLoader(e),l=a.C8(i.graphid),o=l.BL("scale-x");"xy"===l.AJ.layout?(t=i.x||o.AT(i.keyvalue),n=l.iY+l.F/2):(t=l.iX+l.I/2,n=i.y||o.AT(i.keyvalue));var r={_pageX_:t,_pageY_:n,type:ZC.mobile?"touchstart":"mousemove",target:{id:e+"-img"}};ZC.JS.GUIDES=ZC.JS.GUIDES||{},ZC.JS.GUIDES[e]=ZC.JS.GUIDES[e]||{},ZC.JS.GUIDES[e].blocked=!0,ZC.JS.clearGuide(e),r.fromAPI=!0,a.D7.Q7(r)});var A2M={$i:function(e,i){var t=this;t.o=null,t.C=e,t.NW=i},parse:function(){var e,i=this;i.o=i.C.o;var t,n,a,l,o,r,s,A,C,c=i.NW,u="\r\n",p=",",Z=!1,h=null,d=null,f=null,_=null,g=null,v=!1,b=!1,B=null,m={};null!==ZC._n_(e=i.o["html5-csv"])&&(m=e),null!==ZC._n_(e=i.o.csv)&&(m=e),null!==ZC._n_(e=m.separator)&&(p=e),null!==ZC._n_(e=m.mirrored)&&(Z=ZC._b_(e)),null!==ZC._n_(e=m.title)&&(h=ZC._b_(e)),null!==ZC._n_(e=m["string-values"])&&(b=ZC._b_(e)),Z?(null!==ZC._n_(e=m["horizontal-labels"])&&(f=ZC._b_(e)),null!==ZC._n_(e=m["vertical-labels"])&&(d=ZC._b_(e))):(null!==ZC._n_(e=m["horizontal-labels"])&&(d=ZC._b_(e)),null!==ZC._n_(e=m["vertical-labels"])&&(f=ZC._b_(e))),null!==ZC._n_(e=m["smart-scales"])&&(_=ZC._b_(e)),null!==ZC._n_(e=m["separate-scales"])&&(g=ZC._b_(e)),null!==ZC._n_(e=m["keyval-format"])&&(v=ZC._b_(e)),null!==ZC._n_(e=m.columns)&&(B=e);var E=null;null!==ZC._n_(e=m["thousands-separator"])&&(E=e);var D=null;if(null!==ZC._n_(e=m["decimals-separator"])&&(D=e),null!==E&&null===D&&(D="."===E?",":"."),null!==D&&null===E&&(E="."===D?",":"."),null!==ZC._n_(B)&&B.length>0){t=[],null!==ZC._n_(e=m["row-separator"])?u=e:c.split(/\n/).length>0?u="\n":c.split(/\r/).length>0&&(u="\r");var K=c.split(u),F=0;for(l=0,o=K.length;l<o;l++)if(""!==K[l].replace(/\s+/g,"")){t[F]=[];for(var x=0,I=0;x<K[l].length-1;)a=K[l].substring(x,x+B[I]),t[F].push(a),x+=B[I],I++;F++}}else{t=[[]],n=null!==ZC._n_(e=m["row-separator"])?new RegExp("(\\"+p+"|"+e+'|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+p+e+"]*))","gi"):new RegExp("(\\"+p+'|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+p+"\\r\\n]*))","gi");for(var y=null;y=n.exec(c);){var w=y[1];w.length&&w!==p&&t.push([]),a=y[2]?y[2].replace(new RegExp('""',"g"),'"'):y[3],t[t.length-1].push(a)}}var Y=[];for(l=0,o=t.length;l<o;l++)0!==t[l].join("").replace(/\s+/g,"").length&&Y.push(t[l]);var X=0,M=0;if((null===ZC._n_(h)||h)&&(Y.length>1&&1===Y[0].length?(null===ZC._n_(i.o.title)?i.o.title={text:Y[0][0]}:null===ZC._n_(i.o.title.text)&&(i.o.title.text=Y[0][0]),h=!0):h=!1),h&&X++,Z){for(t=[],h&&t.push(Y[0]),r=X,s=Y.length;r<s;r++)for(A=0,C=Y[r].length;A<C;A++)null===ZC._n_(t[A+X])&&(t[A+X]=[]),t[A+X].push(Y[r][A]);Y=t}if("function"==typeof zingchart.csvParser)for(r=0,s=Y.length;r<s;r++)for(A=0,C=Y[r].length;A<C;A++)Y[r][A]=zingchart.csvParser.call(this,Y[r][A],r,A,i.C.A.K);var L=0;for(l=0,o=Y.length;l<o;l++)L=ZC.BQ(L,Y[l].length);var H=[];if(null===ZC._n_(d)){var P=Y[X].join("").length;d=Y[X].join("").replace(/[0-9]/g,"").length/P>.75}d&&(H=Y[X],X++);var N=[];if(null===ZC._n_(f))if(d&&-1!==H[0].indexOf("\\"))f=!0;else{var G="";for(r=X,s=Y.length;r<s;r++)G+=Y[r][0];var S=G.length;f=G.replace(/[0-9]/g,"").length/S>.75}if(f){for(r=X,s=Y.length;r<s;r++)v?N.push(ZC._i_(Y[r][M])):N.push(Y[r][M]);M++}var O=[],k=[];for(A=M;A<L;A++){k[A-M]=[];var T=E,z=D,Q=0,J=null;for(r=X,s=Y.length;r<s;r++)if(null!==ZC._n_(Y[r][A])&&""!==Y[r][A]&&"undefined"!=typeof Y[r][A]){if(a=Y[r][A],null!==ZC._n_(J)||b||(J=a.replace(/[0-9\-\,\.\+\e]+/g,"%v")),b||(a=a.replace(/[^0-9\-\,\.\+\e]+/g,"")),null===T||null===z){var V=a.indexOf("."),R=a.indexOf(",");-1!==V&&-1!==R?V<R?(T=".",z=",",Q=ZC.BQ(0,a.length-R)):(T=",",z=".",Q=ZC.BQ(0,a.length-V)):-1===V&&-1!==R?a.length-R-1==3?(T=",",z="."):(T=".",z=",",Q=ZC.BQ(0,a.length-R)):-1!==V&&-1===R&&(a.length-V-1==3?(T=".",z=","):(T=",",z=".",Q=ZC.BQ(0,a.length-V)))}"."===T&&(a=a.replace(/\./g,"").replace(/,/g,".")),","===T&&(a=a.replace(/,/g,"")),k[A-M].push(b?a:ZC._f_(a))}else k[A-M].push(null);O[A-M]={},null!==ZC._n_(J)&&(O[A-M].format=J),null!==ZC._n_(T)&&(O[A-M]["thousands-separator"]=T),null!==ZC._n_(T)&&(O[A-M]["decimals-separator"]=z),0!==Q&&(O[A-M].decimals=Q)}if(v)for(l=0,o=k.length;l<o;l++)for(var W=0;W<k[l].length;W++)k[l][W]=[N[W],k[l][W]];var U=[];switch(i.C.AF){case"line":case"area":case"vbar":case"hbar":case"line3d":case"area3d":case"vbar3d":case"hbar3d":case"mixed":null===ZC._n_(i.o["scale-x"])&&(i.o["scale-x"]={});var j=[];f&&null!==ZC._n_(H[0])&&(j=H[0].split(/\\/)),null!==ZC._n_(j[0])&&(null===ZC._n_(i.o["scale-x"].label)&&(i.o["scale-x"].label={}),null===ZC._n_(i.o["scale-x"].label.text)&&(i.o["scale-x"].label.text=j[0])),f&&(null===ZC._n_(i.o["scale-x"].values)?i.o["scale-x"].values=N:null===ZC._n_(i.o["scale-x"].labels)&&(i.o["scale-x"].labels=N));var q=[];if(null!==ZC._n_(g)&&g)for(l=0,o=k.length;l<o;l++)q[l]="scale-y"+(0===l?"":"-"+(l+1));else if(null!==ZC._n_(_)&&_){var $={},ee=0,ie=[];for(l=0,o=k.length;l<o;l++){for(var te=0,ne=0,ae=k[l].length;ne<ae;ne++)te+=k[l][ne];te/=k[l].length;var le=Math.round(ZC.G6(te)/Math.LN10/2);null===ZC._n_($[le])&&($[le]="scale-y"+(0===ee?"":"-"+(ee+1))),-1===ZC.AV(ie,O[l].format)?(q[l]="scale-y"+(0===ee?"":"-"+(ee+1)),ee++):(q[l]=$[le],ee++),ie.push(O[l].format)}}for(0===q.length&&(q[0]="scale-y"),null===ZC._n_(i.o.series)&&(i.o.series=[]),l=0,o=k.length;l<o;l++)null===ZC._n_(i.o.series[l])&&(i.o.series[l]={}),i.o.series[l].values=k[l],d&&(null===ZC._n_(i.o.series[l].text)&&(i.o.series[l].text=H[l+M],U.push(H[l+M])),null===ZC._n_(i.o.series[l]["legend-text"])&&(i.o.series[l]["legend-text"]=H[l+M],U.push(H[l+M])),null===ZC._n_(i.o.series[l]["tooltip-text"])&&null!==ZC._n_(O[l].format)&&(i.o.series[l]["tooltip-text"]=O[l].format)),null!==ZC._n_(q[l])&&(null===ZC._n_(i.o[q[l]])&&(i.o[q[l]]={}),null!==ZC._n_(j[1])&&(null===ZC._n_(i.o[q[l]].label)&&(i.o[q[l]].label={}),null===ZC._n_(i.o[q[l]].label.text)&&(i.o[q[l]].label.text=j[1])),null===ZC._n_(i.o.series[l].scales)&&(i.o.series[l].scales="scale-x,"+q[l]),null===ZC._n_(i.o[q[l]].decimals)&&null!==ZC._n_(O[l].decimals)&&(i.o[q[l]].decimals=O[l].decimals),null===ZC._n_(i.o[q[l]]["thousands-separator"])&&null!==ZC._n_(O[l]["thousands-separator"])&&(i.o[q[l]]["thousands-separator"]=O[l]["thousands-separator"]),null===ZC._n_(i.o[q[l]]["decimals-separator"])&&null!==ZC._n_(O[l]["decimals-separator"])&&(i.o[q[l]]["decimals-separator"]=O[l]["decimals-separator"]),null===ZC._n_(i.o[q[l]].format)&&null!==ZC._n_(O[l].format)&&(i.o[q[l]].format=O[l].format));break;case"pie":case"pie3d":case"gauge":case"nestedpie":if(null===ZC._n_(i.o.scale)&&(i.o.scale={}),f&&null!==ZC._n_(H[0])){var oe=H[0].split(/\\/);null===ZC._n_(i.o.scale.label)&&(i.o.scale.label={}),null===ZC._n_(i.o.scale.label.text)&&(i.o.scale.label.text=oe[0])}for(f&&(null===ZC._n_(i.o.scale.values)?i.o.scale.values=N:null===ZC._n_(i.o.scale.labels)&&(i.o.scale.labels=N)),null===ZC._n_(i.o.series)&&(i.o.series=[]),l=0,o=k.length;l<o;l++)null===ZC._n_(i.o.series[l])&&(i.o.series[l]={}),i.o.series[l].values=k[l],d&&(null===ZC._n_(i.o.series[l].text)&&(i.o.series[l].text=H[l+M],U.push(H[l+M])),null===ZC._n_(i.o.series[l]["legend-text"])&&(i.o.series[l]["legend-text"]=H[l+M],U.push(H[l+M])),null===ZC._n_(i.o.series[l]["tooltip-text"])&&null!==ZC._n_(O[l].format)&&(i.o.series[l]["tooltip-text"]=O[l].format)),null===ZC._n_(i.o["scale-v"])&&(i.o["scale-v"]={}),null===ZC._n_(i.o["scale-v"].decimals)&&null!==ZC._n_(O[l].decimals)&&(i.o["scale-v"].decimals=O[l].decimals),null===ZC._n_(i.o["scale-v"]["thousands-separator"])&&null!==ZC._n_(O[l]["thousands-separator"])&&(i.o["scale-v"]["thousands-separator"]=O[l]["thousands-separator"]),null===ZC._n_(i.o["scale-v"]["decimals-separator"])&&null!==ZC._n_(O[l]["decimals-separator"])&&(i.o["scale-v"]["decimals-separator"]=O[l]["decimals-separator"]),null===ZC._n_(i.o["scale-v"].format)&&null!==ZC._n_(O[l].format)&&(i.o["scale-v"].format=O[l].format)}return""!==U.join("")&&null===ZC._n_(i.o.legend)&&(i.o.legend={}),i.o=JSON.parse(JSON.stringify(i.o).replace(/\\\\/g,"\\")),i.o}};ZC.A2M=ZC.C9.CA(A2M),ZC.JI=ZC.HL.CA({$i:function(e){this.b(e);var i=this;i.OB="zcgraph",i.H=e,i.AF="",i.IR=null,i.P2="",i.K0=null,i.MR=null,i.S5=null,i.P=null,i.B9=null,i.HS=null,i.HQ=null,i.A5Y=1,i.VH=1,i.A50=1,i.L=0,i.HP=null,i.MC=[1,0],i.A9L=null,i.CC=!1,i.KQ="normal",i.BO=[],i.BX=[],i.YC=[],i.FH=[],i.LH=[],i.AY=new ZC.LJ(i),i.H2=null,i.BD=null,i.A7=null,i.CX=null,i.HA=null,i.A1Q="always",i.ABO=!0,i.MA="",i.RJ=null,i.LK=!1,i.UL=!1,i.NB=0,i.YK=!1,i.Q5=!1,i.F0={true3d:1,angle:45,depth:40,"x-angle":0,"y-angle":0,"z-angle":0,zoom:1},i.AJ={"enable-guide":!1,"enable-preview":!1,"enable-scroll":!1,"enable-zooming":!0,"3d":!1,clip:!1,layout:"","enable-animation":!0,"angle-min":15,"angle-max":75,"x-angle-min":-65,"x-angle-max":65,"y-angle-min":-65,"y-angle-max":65,"z-angle-min":-65,"z-angle-max":65},i.OA=!1,i.A17=!1,i.A9W=[],i.A1J=!0,"undefined"!=typeof ZC.PE&&(i.LW=new ZC.PE(i)),i.GG=!1,i.CB={},i.IX=[],i.KI=!1,i.HH=!1,i.L3=0,i.BP=[],i.A4C=!0,i.UO=zingchart.DEV.STACKINGLOGIC,-1===i.UO&&(i.UO=0)},a11y:function(){if(this.A.bA11y){return ZC.Q.G0("rect","","")+'class="zc-graph-descriptor" tabindex="0" aria-label="Chart '+(this.L+1)+" of "+this.A.AG.length+", "+({vbar:"column",vbar3d:"3d column",hbar:"bar",hbar3d:"3d bar",line3d:"3d line",area3d:"3d area",pie3d:"3d pie"}[this.AF]||this.AF)+" chart. "+(this.IR?this.IR.AM:"Untitled")+". "+(this.K0?this.K0.AM:"")+". "+this.P2+'" id="'+this.K+'--graph" coords="0,0,0,0" data-z-sort="-200" />'}return""},getPMap:function(){var e=this.b();return this.addPMap(e,"index","L"),e},getToggleAction:function(){var e,i=this,t="hide";return i.BD&&""!==i.E["legend-last-trigger"]&&"undefined"!=typeof i.E["legend-last-trigger"]?t="item"===i.E["legend-last-trigger"]?i.BD.R1:i.BD.PP:(i.o.legend&&(e=i.o.legend["toggle-action"])&&(t=e),i.o.legend&&i.o.legend.item&&(e=i.o.legend.item["toggle-action"])&&(t=e)),(i.A.K9||i.E["toggle-action-remove"])&&(t="remove"),t},BU:function(e,i){void 0===i&&(i=!1);for(var t=[],n=this,a=0,l=n.BO.length;a<l;a++)n.BO[a].AF===e&&(!i||i&&n.BO[a].V.length>0)&&t.push(n.BO[a]);return t},BL:function(e){for(var i=this,t=0,n=i.BO.length;t<n;t++)if(i.BO[t].BE===e)return i.BO[t];return null},A2P:function(e){return e},ACH:function(e){return new ZC.A2M(this,e)},ACN:function(){for(var e=this,i=0,t=e.BO.length;i<t;i++){var n=e.BO[i],a=n.BE;e.A.B8.load(n.o,["("+e.AF+").SCALE","("+e.AF+")."+a.replace(/\-[0-9]+/,""),"("+e.AF+")."+a.replace(/\-[0-9]+/,"-n"),"("+e.AF+")."+a],!1,!0);var l=a.replace(/\-[0-9]+/,"")+"-n";e.o[l]&&n.append(e.o[l]),e.o[a]&&n.append(e.o[a]),e.AJ["3d"]&&e.A.B8.load(n.o,["("+e.AF+").SCALE[3d]","("+e.AF+")."+a.replace(/\-[0-9]+/,"")+"[3d]","("+e.AF+")."+a.replace(/\-[0-9]+/,"-n")+"[3d]","("+e.AF+")."+a+"[3d]"],!1,!0),e.AJ["3d"]&&n.append(e.o[a+"[3d]"]),n.parse()}},ABG:function(){return null},AAB:function(e){var i,t,n,a=this,l=0,o=a.AY.A4.length;for(i=0;i<o;i++)l=ZC.BQ(l,a.AY.A4[i].S.length);function r(e){return e=(e=(e=e.replace(/(%N|%node-count)/g,l)).replace(/(%P|%plot-count)/g,o)).replace(/(%S|%scale-values-count)/g,n.V.length)}for(i=0,t=a.BO.length;i<t;i++)(n=a.BO[i]).A96(e),2===e&&(n.J2=r,n.DE()&&n.parse()),null===ZC._n_(n.o["max-items"])&&null===ZC._n_(n.o["max-labels"])&&n.A7U(),null===ZC._n_(n.o["max-ticks"])&&n.AC9()},UY:function(){},NX:function(){},ADE:function(){},AC1:function(){},setupPlotArea:function(){var e=this,i=e.A.B8,t="("+e.AF+")";e.P=new ZC.HL(e),e.P.OG="plotarea",e.P.K=e.K+"-plotarea";var n=[t+".plotarea"];if(e.B9&&n.push(t+".plotarea[preview]"),e.AJ["3d"]&&n.push(t+".plotarea[3d]"),i.load(e.P.o,n),e.P.append(e.o.chart),e.P.append(e.o.plotarea),e.B9&&e.P.append(e.o["plotarea[preview]"]),e.AJ["3d"]&&e.P.append(e.o["plotarea[3d]"]),"dynamic"===e.P.o["margin-top"]||"dynamic"===e.P.o["margin-right"]||"dynamic"===e.P.o["margin-bottom"]||"dynamic"===e.P.o["margin-left"]){var a=String(e.P.o.margin||"").split(/\s+|;|,/),l=a.length>0?a[0]:"",o=a.length>1?a[1]:"",r=a.length>0?a[2]||a[0]:"",s=a.length>1?a[3]||a[1]:"";"dynamic"===e.P.o["margin-top"]&&(l="dynamic"),"dynamic"===e.P.o["margin-right"]&&(o="dynamic"),"dynamic"===e.P.o["margin-bottom"]&&(r="dynamic"),"dynamic"===e.P.o["margin-left"]&&(s="dynamic"),e.P.o.margin=[l,o,r,s].join(" ")}if(e.E["plotarea-margins"]?e.P.o.margin=e.E["plotarea-margin"]:(e.E["plotarea-margins"]=!0,e.E["plotarea-margin"]=e.P.o.margin,e.E["plotarea-margin-top"]=e.P.o["margin-top"],e.E["plotarea-margin-right"]=e.P.o["margin-right"],e.E["plotarea-margin-bottom"]=e.P.o["margin-bottom"],e.E["plotarea-margin-left"]=e.P.o["margin-left"]),"undefined"!=typeof e.E["plotarea-p-x"]&&(e.P.E["p-x"]=e.E["plotarea-p-x"],e.P.E["p-y"]=e.E["plotarea-p-y"],e.P.E["p-width"]=e.E["plotarea-p-width"],e.P.E["p-height"]=e.E["plotarea-p-height"]),null!==ZC._n_(e.P.o["adjust-layout"])&&ZC._b_(e.P.o["adjust-layout"])&&(e.P.o.margin="dynamic"),e.P.parse(),e.AJ["3d"]&&!e.F0.true3d){var A=ZC._a_(ZC._i_(e.F0.depth*ZC.EP(e.F0.angle)));e.P.iY+=A,e.P.F-=A,e.P.I-=ZC._i_(e.F0.depth*ZC.EH(e.F0.angle))}if("undefined"!=typeof e.E["plotarea-p-x"])for(var C=0,c=e.BO.length;C<c;C++)e.BO[C].A51(),e.BO[C].J1()},setupDynamicPlotArea:function(){var e,i,t,n=this,a=["top","right","bottom","left"],l={};for(i=0;i<a.length;i++)l[a[i]]=!1,n.E["plotarea.d-margin-"+a[i]]&&(n.o.plotarea["margin-"+a[i]]=null),n.o.plotarea&&"dynamic"===n.o.plotarea["margin-"+a[i]]&&(l[a[i]]=!0,n.o.plotarea["margin-"+a[i]]="20");var o=!1,r={};if("xy"===n.AJ.layout&&(o=!0),("xy"===n.AJ.layout||"yx"===n.AJ.layout)&&(n.P.E["d-margin"]||n.E["plotarea.d-margin"])){for(var s=0,A=n.BO.length;s<A;s++){var C=0,c=0,u="",p=n.BO[s];if(p.AN&&p.T9){"k"===p.AF?u=p.CO?"default"===p.BA?"left":"right":"default"===p.BA?"bottom":"top":"v"===p.AF&&(u=p.CO?"default"===p.BA?"bottom":"top":"default"===p.BA?"left":"right");var Z=0;if(n.P.E["d-margin-"+u]||n.E["plotarea.d-margin-"+u]){var h=new ZC.DN(p);h.copy(p.BR);var d=ZC.BQ(1,ZC._i_((p.A1-p.W)/p.EG));for(i=p.W;i<=p.A1;i+=d)if(h.AM=p.FQ(i),h.A29&&("k"===p.AF&&!p.CO||"v"===p.AF&&p.CO)&&(h.o.width=ZC._i_(.9*p.AC)),h.parse(),h.AN)if(c=ZC.BQ(c,h.A9%180==0?h.F:h.I),C=ZC.BQ(C,h.A9%180==0?h.I:h.F),Z=ZC.BQ(Z,1.5*h.DG*(h.AM||"").split(/<br>|<br\/>|<br \/>|\n/).length),"top"===u||"bottom"===u){if(Z=ZC.BQ(Z,.465*h.DG+1.025*ZC._a_(ZC.EP(h.A9))*ZC.BQ(h.I,h.F)),C=h.I,c=Z,o&&"k"===p.AF){r[p.BE]||(r[p.BE]=[]);var f=null===ZC._n_(h.o["auto-align"])||ZC._b_(h.o["auto-align"]),_=.465*h.DG+1.025*ZC._a_(ZC.EH(h.A9))*ZC.BQ(h.I,h.F);"default"===p.BA?(f&&(ZC.DS(ZC._ang_(h.A9),90,180)||ZC.DS(ZC._ang_(h.A9),270,360))&&r[p.BE].push(_),f||r[p.BE].push(_/2)):(f&&(ZC.DS(ZC._ang_(h.A9),0,90)||ZC.DS(ZC._ang_(h.A9),180,270))&&r[p.BE].push(_),f||r[p.BE].push(_/2))}}else C=Z=ZC.BQ(Z,.465*h.DG+1.025*ZC._a_(ZC.EH(h.A9))*ZC.BQ(h.I,h.F)),c=h.F;var g=new ZC.DN(p);g.copy(p.M),g.AM=p.M.AM,g.parse(),""!==g.AM&&g.AN&&(c+=g.A9%180==0?g.F:g.I,C+=g.A9%180==0?g.I:g.F)}if(n.o.plotarea||(n.o.plotarea={}),("dynamic"===n.o.plotarea["margin-"+u]||n.P.E["d-margin-"+u])&&(n.P.E["d-margin-"+u]=!1,l[u]=!0,n.o.plotarea["margin-"+u]="0"),l[u]){n.o.plotarea["margin-"+u]=ZC._f_(n.o.plotarea["margin-"+u]||"0"),n.E[p.BE+"-distance"]=n.o.plotarea["margin-"+u];var v=("top"===u||"bottom"===u?ZC._i_(c):ZC._i_(C))+10+(n.AJ["3d"]?20:0);if(p.VE?n.o.plotarea["margin-"+u]=ZC.BQ(n.o.plotarea["margin-"+u],v):n.o.plotarea["margin-"+u]+=v,null!==ZC._n_(n.o.plotarea["margin-"+u+"-offset"])&&(n.o.plotarea["margin-"+u]+=ZC._i_(n.o.plotarea["margin-"+u+"-offset"])),!n.A.TJ){var b={},B=n.A.DF.watermark;n.A.B8.load(b,"loader.gui.watermark"),B&&ZC._cp_(B,b),1===n.A.o.graphset.length&&n.A.o.graphset[0].gui&&(e=n.A.o.graphset[0].gui.watermark)&&ZC._cp_(e,b);var m=b.position||"br";-1===ZC.AV(["tl","tr","br","bl"],m)&&(m="br"),("bottom"!==u||"bl"!==m&&"br"!==m)&&("top"!==u||"tl"!==m&&"tr"!==m)||(n.o.plotarea["margin-"+u]+=15)}"bottom"===u&&("xy"===n.AJ.layout&&n.HS||"yx"===n.AJ.layout&&n.HQ)&&(n.o.plotarea["margin-"+u]+=15),"left"===u&&("xy"===n.AJ.layout&&n.HQ||"yx"===n.AJ.layout&&n.HS)&&(n.o.plotarea["margin-"+u]+=15),n.E["plotarea.d-margin-"+u]=!0}}}if(o&&l.left&&null!==ZC._n_(n.o.plotarea["margin-left"]))for(var E in r){var D=n.BL(E);for(i=0;i<r[E].length;i++){ZC._i_(n.o.plotarea["margin-left"])+i*D.AC+(D.DJ?D.AC/2:0)-r[E][i]<0&&(n.o.plotarea["margin-left"]=r[E][i]-i*D.AC-(D.DJ?D.AC/2:0))}}ZC.Q.IU(ZC.AK(n.K+"-plotarea-c"),n.H.AA,n.P.iX,n.P.iY,n.P.I,n.P.F,n.K),n.E["plotarea.paint"]=!0,n.setupPlotArea();var K=2,F=6;null!==ZC._n_(e=n.P.o["mask-tolerance"])&&(e instanceof Array?(K=F=ZC._i_(e[0]),e.length>1&&(F=ZC._i_(e[1]))):K=F=ZC._i_(e)),n.P.E.tolerance=K,"svg"===n.H.AA?((e=ZC.AK(n.K+"-clip-shape"))&&e.setAttribute("points",n.M6(K,"svg")),(e=ZC.AK(n.K+"-clip-hover-shape"))&&e.setAttribute("points",n.M6(F,"svg"))):(ZC.A5("#"+n.K+" div").each(function(){""!==this.style.clip&&(this.style.clip=n.M6(K))}),(e=ZC.AK(n.K+"-hover"))&&""!==e.style.clip&&(e.style.clip=n.M6(F)))}for(i=0,t=n.BO.length;i<t;i++)n.BO[i].A51(),n.BO[i].J1()},parse:function(){var e,i,t,n,a,l,o,r,s,A=this,C=A.A.B8,c="("+A.AF+")";(e=A.A.E["graph-state-"+A.L])&&(A.E=JSON.parse(e),null===ZC._n_(A.E["guide-on"])||ZC._b_(A.E["guide-on"])||(A.A1J=!1)),A.E.legend_toggle_action||(A.A.E["graph-"+A.K+"-legend-info"]=null),A.E.legend_toggle_action=null,A.MA="parse.init",A.b(),A.ADE(),-1!==JSON.stringify(A.o).indexOf("zingchart.maps")&&(A.o.plotarea=A.o.plotarea||{},A.o.plotarea.margin=0);var u=null;if(!zingchart.SKIP.CSV&&((e=A.o["html5-csv"])&&(A.RJ=e["html5-url"]),(e=A.o.csv)&&("object"==typeof e?e.url?A.RJ=e.url:e["data-string"]&&(u=e["data-string"]):A.RJ=e),""!==A.RJ&&null!==ZC._n_(A.A.A9P[A.RJ])&&(u=A.A.A9P[A.RJ]),A.H.NW&&(u=A.H.NW),u)){var p=A.ACH(u);A.o=p.parse()}if(A.LK=zingchart.ASYNC,A.assign_a([["utc","UL","b"],["timezone","NB","f"],["async","LK","b"],["stacked","CC","b"],["stack-type","KQ"],["animate-type","A1Q"],["url-data","A9L"],["page","L3","i"],["palette","BP"],["sort-objects","A4C","b"],["description","P2"]]),A.BP.length>0)for(C.B8.palette=[],n=0;n<A.BP.length;n++){var Z=A.BP[n],h=ZC.AP.JN(A.BP[n],10),d=ZC.AP.QU(A.BP[n],10);C.B8.palette.push(["#fff",Z,h,d])}"pie3d"===A.AF&&(A.F0.true3d=!0),(A.AJ["3d"]||A.A.A19)&&(A.LK=!1),A.AC1(),-1===ZC.AV(A.H.KR,"skip_interactivity")&&((null!==ZC._n_(e=A.o.preview)||C.PL("preview",A.AF))&&A.AJ["enable-preview"]&&(A.B9&&!A.E["force-preview-parse"]||"undefined"==typeof ZC.A2D||(A.E["force-preview-parse"]=!1,A.B9=new ZC.A2D(A),A.B9.OG="preview",C.load(A.B9.o,c+".preview"),"yx"===A.AJ.layout&&C.load(A.B9.o,c+".preview[yx]"),(i=A.o.plotarea)&&A.B9.append({"background-color":i["background-color"],"background-color-1":i["background-color-1"],"background-color-2":i["background-color-2"],"gradient-stops":i["gradient-stops"],"gradient-colors":i["gradient-colors"]}),A.B9.append(e),A.B9.parse())),(null!==ZC._n_(e=A.o["scroll-x"])||C.PL("scroll-x",A.AF))&&A.AJ["enable-scroll"]&&(A.HS||"undefined"==typeof ZC.ZF||(A.HS=new ZC.ZF(A,"x"),A.HS.OG="scrollx",C.load(A.HS.o,c+".scroll-x"),A.HS.append(e),A.HS.parse())),(null!==ZC._n_(e=A.o["scroll-y"])||C.PL("scroll-y",A.AF))&&A.AJ["enable-scroll"]&&(A.HQ||"undefined"==typeof ZC.ZF||(A.HQ=new ZC.ZF(A,"y"),A.HQ.OG="scrolly",C.load(A.HQ.o,c+".scroll-y"),A.HQ.append(e),A.HQ.parse()))),A.setupPlotArea(),A.NX(),A.BO=[],A.ACN(),A.AAB(1),null!==ZC._n_(e=A.o.series)&&(A.AY.o=e);var f=A.AY.o;for(n=0;n<f.length;n++)if(f[n].rel)for(s=0;s<f.length;s++)f[s].id&&f[s].id===f[n].rel&&(A.AY.o[n].values=[].concat(A.AY.o[s].values));if(A.AY.parse(),A.AAB(2),(null!==ZC._n_(e=A.o.title)||C.PL("title",A.AF))&&(A.IR=new ZC.DN(A),A.IR.OG="title",C.load(A.IR.o,c+".title"),A.IR.append(e),A.IR.K=A.K+"-title",A.IR.K9=!0,A.IR.parse(),null===ZC._n_(A.IR.o.x))){var _=A.iX,g=A.I;switch("plotarea"===A.IR.o["center-point"]&&(_=A.P.iX,g=A.P.I),A.IR.O8){case"left":A.IR.iX=_;break;case"center":A.IR.iX=_+g/2-A.IR.I/2;break;case"right":A.IR.iX=_+g-A.IR.I}}(null!==ZC._n_(e=A.o.subtitle)||C.PL("subtitle",A.AF))&&(A.K0=new ZC.DN(A),A.K0.OG="subtitle",C.load(A.K0.o,c+".subtitle"),A.K0.append(e),A.K0.K=A.K+"-subtitle",A.K0.parse()),null!==ZC._n_(e=A.o.source)&&(A.MR=new ZC.DN(A),A.MR.OG="source",C.load(A.MR.o,c+".source"),A.MR.append(e),A.MR.K=A.K+"-source",A.MR.parse()),"undefined"!=typeof ZC.UV&&(null!==ZC._n_(e=A.o.legend)||C.PL("legend",A.AF))&&(A.BD=new ZC.UV(A),A.BD.K=A.K+"-legend","undefined"!=typeof e.alpha&&e.alpha<.1&&"undefined"==typeof e["border-width"]&&"undefined"==typeof e["border-alpha"]&&(e["border-alpha"]=e.alpha),C.load(A.BD.o,c+".legend"),A.BD.alignPosition(e),(null!==ZC._n_(e)&&null!==ZC._n_(e.position)||null!==ZC._n_(A.BD.o.position))&&C.load(A.BD.o,c+".legend[position]"),A.BD.append(e),ZC._b_(A.BD.o.shared)&&(A.BD.E["p-x"]=A.A.iX,A.BD.E["p-y"]=A.A.iY,A.BD.E["p-width"]=A.A.I,A.BD.E["p-height"]=A.A.F),A.BD.alignPosition(e),A.BD.parse());var v=!1,b=A.iX,B=A.iY,m=A.I,E=A.F,D="";if(A.IR&&A.IR.AN&&A.IR.o["adjust-layout"]&&(v=!0,(t=A.IR.iY+A.IR.F/2)<B+E/2&&(D="top",E=B+E-A.IR.F-A.IR.iY,B=A.IR.iY+A.IR.F,A.K0&&A.K0.o["adjust-layout"]))){var K=A.K0.iY+A.K0.F/2;K<B+E/2&&K>t&&(E-=A.K0.F,B+=A.K0.F)}if(A.MR&&A.MR.AN&&A.MR.o["adjust-layout"]&&(v=!0,(t=A.MR.iY+A.MR.F/2)>B+E/2&&(E-=A.MR.F)),A.B9&&A.B9.AN&&A.B9.o["adjust-layout"]&&(v=!0,"xy"===A.AJ.layout?(t=A.B9.AR.iY+A.B9.AR.F/2)>B+E/2?E-=A.B9.AR.F+A.B9.AR.DR:(B=A.B9.AR.iY+A.B9.AR.F,E-=A.B9.AR.F):(_=A.B9.AR.iX+A.B9.AR.I/2)<b+m/2?(m-=A.B9.AR.I+A.B9.AR.DY,b+=A.B9.AR.I+A.B9.AR.DY):(b=A.B9.AR.iX+A.B9.AR.I,m-=A.B9.AR.I)),A.BD&&A.BD.AN&&A.BD.o["adjust-layout"]){v=!0;var F=A.BD.D4&&A.BD.D4.enabled?15:5;if("top"===D&&A.BD.iY<A.IR.iY+A.IR.F+5){if(null!==ZC._n_(A.BD.o.position)){var x=(""+A.BD.o.position).split(" ");A.BD.o.position=x[0]+" "+(A.IR.iY-A.iY+A.IR.F+A.BD.ME+F)}else A.BD.o["margin-top"]=A.IR.iY-A.iY+A.IR.F+A.BD.ME;A.BD.parse()}A.BD.fixPlacement(),t=A.BD.iY+A.BD.F/2;var I="",y=(ZC.MAX,A.BD.E["position-info"]),w={Bottom:A.BD.iY-A.iY,Top:A.iY+A.F-A.BD.iY-A.BD.F,Right:A.BD.iX-A.iX,Left:A.iX+A.I-A.BD.iX-A.BD.I},Y="";if(A.BD.I/A.BD.F>2)Y="v";else if(A.BD.F/A.BD.I>2)Y="h";else{Y=Math.max(w.Left*A.F,w.Right*A.F)/Math.max(w.Top*A.I,w.Bottom*A.I)>1?"h":"v"}if(y)y[0]>=.8?I=y[1]<=.2?"v"===Y?"top":"right":y[1]>=.8&&"v"===Y?"bottom":"right":y[0]<=.2?I=y[1]<=.2?"v"===Y?"top":"left":y[1]>=.8&&"v"===Y?"bottom":"left":y[1]<=.2?I="top":y[1]>=.8&&(I="bottom");else Math.min(w.Top,w.Bottom)/Math.max(w.Top,w.Bottom)<Math.min(w.Left,w.Right)/Math.max(w.Left,w.Right)?w.Top>w.Bottom?(I="top",A.BD.E8):(I="bottom",A.BD.DR):w.Left>w.Right?(I="left",A.BD.DY):(I="right",A.BD.E9);var X=0;"top"===I&&(E=B+E-A.BD.F-A.BD.iY,B=A.BD.iY+A.BD.F),"bottom"===I&&(E-=X=E-A.BD.iY+B+A.BD.FM+A.BD.FU),"left"===I&&(b+=X=A.BD.iX-A.iX+A.BD.I,m-=X),"right"===I&&(m-=X=m-(A.BD.iX-A.iX)+A.BD.EQ+A.BD.FN)}else A.BD&&A.BD.fixPlacement();v&&(A.E["plotarea-p-x"]=b,A.E["plotarea-p-y"]=B,A.E["plotarea-p-width"]=m,A.E["plotarea-p-height"]=E,A.setupPlotArea()),A.setupDynamicPlotArea(),A.AY.parseLayout&&A.AY.parseLayout(!0),A.B9&&A.B9.o["adjust-layout"]&&("xy"===A.AJ.layout?(null===ZC._n_(A.B9.J9.x)&&(A.B9.AR.iX=A.P.iX),null===ZC._n_(A.B9.J9.width)&&(A.B9.AR.I=A.P.I)):(null===ZC._n_(A.B9.J9.y)&&(A.B9.AR.iY=A.P.iY),null===ZC._n_(A.B9.J9.height)&&(A.B9.AR.F=A.P.F)));var M=0;for(n=0;n<A.AY.A4.length;n++)M+=A.AY.A4[n].S.length;null!==ZC._n_(e=A.o["no-data"])&&0===M?(A.S5=new ZC.DN(A),A.S5.OG="nodata",C.load(A.S5.o,c+".noData"),A.S5.append({x:A.P.iX,y:A.P.iY,width:A.P.I,height:A.P.F}),A.S5.append(e),A.S5.K=A.K+"-nodata",A.S5.parse()):A.S5=null,A.E["plotarea-margins"]&&(A.E["plotarea-margins"]=null,A.o.plotarea=A.o.plotarea||{},A.o.plotarea.margin=A.E["plotarea-margin"],A.o.plotarea["margin-top"]=A.E["plotarea-margin-top"],A.o.plotarea["margin-right"]=A.E["plotarea-margin-right"],A.o.plotarea["margin-bottom"]=A.E["plotarea-margin-bottom"],A.o.plotarea["margin-left"]=A.E["plotarea-margin-left"]);var L=["top","right","bottom","left"];for(n=0;n<L.length;n++)A.E["plotarea.d-margin-"+L[n]]=null;if(ZC.Q.EU(A.A.K+"-tooltip"),"undefined"!=typeof A.E.datalength&&null!==ZC._n_(A.E.datalength)&&A.E.datalength.length>0&&"canvas"!==A.H.AA&&A.AY.A4)for(var H=0,P=A.AY.A4.length;H<P;H++){if(A.AY.A4[H].S.length<A.E.datalength[H])for(o=A.AY.A4[H].S.length,r=A.E.datalength[H];o<r;o++)l=A.K+"-plotset-plot-"+H+"-node-"+o,ZC.Q.EU([l+"-path",l+"-area-path",l+"-sh-path"]),-1!==ZC.AV(["scatter","bubble"],A.AF)&&ZC.Q.EU([l+"-marker-gradient",l+"-marker-path",l+"-marker-sh-path",l+"-marker-circle",l+"-marker-sh-circle"]),A.EN[H+"-"+o]=null;if(-1===ZC.AV(["scatter","bubble"],A.AF)||ZC.A5.browser.webkit)for(o=0,r=A.E.datalength[H];o<r;o++)l=A.K+"-plotset-plot-"+H+"-node-"+o,ZC.Q.EU([l+"-marker-gradient",l+"-marker-path",l+"-marker-sh-path",l+"-marker-circle",l+"-marker-sh-circle"])}for(A.E.datalength=null,n=0,a=A.AY.A4.length;n<a;n++)A.GG=A.GG||A.AY.A4[n].GG;(A.HH||"undefined"==typeof ZC.PE)&&(A.GG=!1),A.GG&&(A.LW.onStop=function(){A.MA="ready"}),-1===ZC.AV(A.H.KR,"skip_interactivity")&&(A.H2=new ZC.HL(A),A.H2.K=A.K+"-zoom",C.load(A.H2.o,c+".zoom"),A.H2.append(A.o.zoom),A.A7=new ZC.DN(A),A.A7.OG="tooltip",A.o.tooltip&&A.o.tooltip.placement&&A.o.tooltip.placement.indexOf("node")>-1?C.load(A.A7.o,c+".tooltip[dynamic]"):C.load(A.A7.o,c+".tooltip"),A.A7.append(A.o.tooltip),A.A7.PU=!0,A.A7.parse(),null!==ZC._n_(e=A.o.guide)&&(A.o["crosshair-x"]=e),(null!==ZC._n_(e=A.o["crosshair-x"])||C.PL("guide",A.AF)||C.PL("crosshair-x",A.AF))&&A.AJ["enable-guide"]&&(A.CX=new ZC.D0(A),A.CX.OG="crosshairx",C.load(A.CX.o,[c+".guide",c+".crosshair-x"],!0,!0),A.CX.append(e),A.CX.parse(),A.E["guide-on"]=!0),(null!==ZC._n_(e=A.o["crosshair-y"])||C.PL("crosshair-y",A.AF))&&A.AJ["enable-guide"]&&(A.HA=new ZC.D0(A),A.HA.OG="crosshairy",C.load(A.HA.o,[c+".guide",c+".crosshair-y"],!0,!0),A.HA.append(e),A.HA.parse(),A.E["guide-on"]=!0)),A.OW(),ZC.AP.BY("gparse",A.A,A.GX()),null!==ZC._n_(e=A.o.refresh)&&(A.HP={type:"full",interval:10,transport:"http",method:"pull","adjust-scale":!1,"max-ticks":20,"reset-timeout":100,"stop-timeout":0,storage:!1,"storage-size":1e3},ZC._cp_(e,A.HP),A.UO=1),A.MA="parse.complete"},OW:function(){},PW:function(){},M6:function(e,i,t){var n=this,a=(t=t||n.P).iX,l=t.iY,o=t.I,r=t.F;if("svg"===i){if(n.AJ["3d"]){var s,A=[];e=1;var C,c,u,p,Z=[],h=a-ZC.AO.E2,d=l-ZC.AO.E3;s=new ZC.CE(n,h+o/2-e,d-e,ZC.AO.FT),p=ZC._i_(s.ED[1]),s=new ZC.CE(n,h+o/2-e,d-e,0),u=ZC._i_(s.ED[1]),Z.push(new ZC.CE(n,h-e,d-e,p<u?ZC.AO.FT:0),new ZC.CE(n,h+o+e,d-e,p<u?ZC.AO.FT:0)),s=new ZC.CE(n,h+o-e,d+r/2-e,ZC.AO.FT),C=ZC._i_(s.ED[0]),s=new ZC.CE(n,h+o-e,d+r/2-e,0),c=ZC._i_(s.ED[0]),Z.push(new ZC.CE(n,h+o+e,d-e,C>c?ZC.AO.FT:0),new ZC.CE(n,h+o+e,d+r+e,C>c?ZC.AO.FT:0)),s=new ZC.CE(n,h+o/2-e,d+r+e,ZC.AO.FT),p=ZC._i_(s.ED[1]),s=new ZC.CE(n,h+o/2-e,d+r+e,0),u=ZC._i_(s.ED[1]),Z.push(new ZC.CE(n,h+o+e,d+r+e,p>u?ZC.AO.FT:0),new ZC.CE(n,h-e,d+r+e,p>u?ZC.AO.FT:0)),s=new ZC.CE(n,h-e,d+r/2-e,ZC.AO.FT),C=ZC._i_(s.ED[0]),s=new ZC.CE(n,h-e,d+r/2-e,0),c=ZC._i_(s.ED[0]),Z.push(new ZC.CE(n,h-e,d+r+e,C<c?ZC.AO.FT:0),new ZC.CE(n,h-e,d-e,C<c?ZC.AO.FT:0)),Z.push(Z[0]);for(var f=0;f<Z.length;f++)s=Z[f],A.push([ZC._i_(s.ED[0]),ZC._i_(s.ED[1])].join(","));return A.join(" ")}return[[a-e,l-e].join(","),[a+o+e,l-e].join(","),[a+o+e,l+r+e].join(","),[a-e,l+r+e].join(","),[a-e,l-e].join(",")].join(" ")}return"box"===i?a-e+","+(l-e)+","+(o+2*e)+","+(r+2*e):(n.AJ["3d"]&&(e+=10),"rect("+(l-e)+"px,"+(a+o+e)+"px,"+(l+r+e)+"px,"+(a-e)+"px)")},autoFit:function(){var e,i=this;if(i.AJ["3d"]&&i.F0["auto-fit"]){var t=!1;for(i.F0.zoom=1;!t&&i.F0.zoom>.25;){t=!0;var n=i.M6(0,"svg").split(" ");for(e=0;e<n.length;e++){var a=n[e].split(",");(ZC._i_(a[0])<i.iX+i.P.DY||ZC._i_(a[0])>i.iX+i.I-i.P.E9||ZC._i_(a[1])<i.iY+i.P.E8||ZC._i_(a[1])>i.iY+i.F-i.P.DR)&&(t=!1)}t||(i.F0.zoom-=.05),t&&(i.F0.zoom-=.025)}}},build:function(){var e,i,t,n,a,l,o,r,s=this,A=s.A.I+"/"+s.A.F,C="0/0";if(s.autoFit(),!s.H.usc()){var c=2,u=6;if(null!==ZC._n_(e=s.P.o["mask-tolerance"])&&(e instanceof Array?(c=u=ZC._i_(e[0]),e.length>1&&(u=ZC._i_(e[1]))):c=u=ZC._i_(e)),"svg"===s.A.AA&&s.AJ.clip&&(ZC.Q.EU([s.K+"-clip",s.K+"-clip-hover",s.K+"-clip-preview"]),s.A.KE.appendChild(ZC.Q.X8({id:s.K+"-clip",path:s.M6(c,"svg")})),s.A.KE.appendChild(ZC.Q.X8({id:s.K+"-clip-hover",path:s.M6(u,"svg")})),s.B9)){var p=s.AJ["3d"];s.AJ["3d"]=!1,s.A.KE.appendChild(ZC.Q.X8({id:s.K+"-clip-preview",path:s.M6(0,"svg",s.B9.AR)})),s.AJ["3d"]=p}var Z=!s.AJ.clip,h=Z?null:s.M6(c),d=Z?null:"url(#"+s.K+"-clip)",f=Z?null:s.M6(u),_=Z?null:"url(#"+s.K+"-clip-hover)";if(s.B9&&(a=Z?null:s.M6(0,s.A.AA,s.B9.AR),l=Z?null:"url(#"+s.K+"-clip-preview)"),ZC.Q.JZ({cls:"zc-abs",id:s.K,p:ZC.AK(s.A.K+"-graphset"),tl:C,wh:A},s.A.AA),s.A.NZ.graph&&ZC.Q.HC({cls:"zc-abs zc-layer zc-persistent",id:s.K+"-c",p:ZC.AK(s.K),wh:A},s.A.AA),ZC.Q.JZ({id:s.K+"-plotarea",p:ZC.AK(s.K),tl:C,wh:A,position:"absolute"},s.A.AA),s.o.plotarea&&s.A.NZ.plotarea&&ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-plotarea-c",p:ZC.AK(s.K+"-plotarea"),wh:A},s.A.AA),"null"!==s.AF&&s.A.NZ.plots){for(ZC.Q.JZ({id:s.K+"-scales-bl",p:ZC.AK(s.K),tl:C,wh:A,position:"absolute","clip-path":d,clip:h},s.A.AA),i=0;i<s.A5Y;i++)ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-scales-bl-"+i+"-c",p:ZC.AK(s.K+"-scales-bl"),wh:A},s.A.AA);if(s.AY.E["plot-sort"]){for(i=0,t=s.AY.A4.length;i<t;i++){for(s.AY.A4[i].UP={},n=0;n<s.AY.A4[i].SV;n++)ZC.Q.EU(s.K+"-plots-bl-"+n);for(n=0;n<s.AY.A4[i].A1G;n++)ZC.Q.EU(s.K+"-plots-fl-"+n)}delete s.AY.E["plot-sort"]}if(s.A.K9||s.AJ["3d"])ZC.AK(s.K+"-plots-bl")||ZC.Q.JZ({id:s.K+"-plots-bl",p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-bl"),tl:C,wh:A,position:"absolute","clip-path":d,clip:h},s.A.AA),(o=ZC.Q.HC({cls:"zc-abs zc-layer zc-bl",id:s.K+"-plots-bl-c",p:ZC.AK(s.K+"-plots-bl"),wh:A},s.A.AA)).setAttribute("data-clip",s.M6(c,"box"));else for(i=0,t=s.AY.A4.length;i<t;i++)for(r=s.AY.M2[i],n=s.AY.A4[i].SV-1;n>=0;n--)ZC.AK(s.K+"-plots-bl-"+n)||ZC.Q.JZ({id:s.K+"-plots-bl-"+n,p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-bl"),tl:C,wh:A,position:"absolute","clip-path":d,clip:h},s.A.AA),(o=ZC.Q.HC({cls:"zc-abs zc-layer zc-bl",id:s.K+"-plot-"+r+"-bl-"+n+"-c",p:ZC.AK(s.K+"-plots-bl-"+n),wh:A},s.A.AA)).setAttribute("data-clip",s.M6(c,"box")),o.style.display="block";for(i=0;i<s.VH;i++)ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-scales-ml-"+i+"-c",p:ZC.AK(s.K),wh:A},s.A.AA);if(s.A.K9||s.AJ["3d"])ZC.AK(s.K+"-plots-fl")||ZC.Q.JZ({id:s.K+"-plots-fl",p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-ml-"+(s.VH-1)+"-c"),tl:C,wh:A,position:"absolute"},s.A.AA),(o=ZC.Q.HC({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plots-fl-c",p:ZC.AK(s.K+"-plots-fl"),wh:A},s.A.AA)).setAttribute("data-clip",s.M6(u,"box"));else for(i=0,t=s.AY.A4.length;i<t;i++)for(r=s.AY.M2[i],n=s.AY.A4[i].A1G-1;n>=0;n--)ZC.AK(s.K+"-plots-fl-"+n)||ZC.Q.JZ({id:s.K+"-plots-fl-"+n,p:ZC.AK(s.K),after:ZC.AK(s.K+"-scales-ml-"+(s.VH-1)+"-c"),tl:C,wh:A,position:"absolute"},s.A.AA),(o=ZC.Q.HC({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plot-"+r+"-fl-"+n+"-c",p:ZC.AK(s.K+"-plots-fl-"+n),wh:A},s.A.AA)).setAttribute("data-clip",s.M6(u,"box")),o.style.display="block";for(zingchart.DEV.PLOTSHLAYER&&(ZC.Q.JZ({id:s.K+"-plots-hover",p:ZC.AK(s.K),tl:C,wh:A,position:"absolute"},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer zc-fl",id:s.K+"-plots-hover-c",p:ZC.AK(s.K+"-plots-hover"),wh:A},s.A.AA)),ZC.Q.JZ({id:s.K+"-scales-fl",p:ZC.AK(s.K),tl:C,wh:A,position:"absolute","clip-path":d,clip:h},s.A.AA),i=0;i<s.A50;i++)ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-scales-fl-"+i+"-c",p:ZC.AK(s.K+"-scales-fl"),wh:A},s.A.AA);if(s.B9&&(ZC.Q.JZ({id:s.K+"-preview",p:ZC.AK(s.A.K+"-tools"),tl:C,wh:A,position:"absolute","clip-path":l,clip:a},s.A.AA),ZC.Q.HC({cls:"zc-abs",id:s.K+"-preview-c",p:ZC.AK(s.K+"-preview"),wh:A},s.A.AA)),ZC.Q.JZ({id:s.K+"-scroll",p:ZC.AK(s.K),tl:C,wh:A,position:"absolute"},s.A.AA),s.o["scroll-x"]&&ZC.Q.HC({cls:"zc-abs",id:s.K+"-scroll-x-c",p:ZC.AK(s.K+"-scroll"),wh:A},s.A.AA),s.o["scroll-y"]&&ZC.Q.HC({cls:"zc-abs",id:s.K+"-scroll-y-c",p:ZC.AK(s.K+"-scroll"),wh:A},s.A.AA),ZC.Q.JZ({id:s.K+"-plots-vb",p:ZC.AK(s.K),tl:C,wh:A,position:"absolute"},s.A.AA),s.A.NZ["value-box"])if(s.A.K9||s.AJ["3d"])ZC.Q.HC({cls:"zc-abs zc-layer zc-vb",id:s.K+"-plots-vb-c",p:ZC.AK(s.K+"-plots-vb"),wh:A},s.A.AA);else for(i=0,t=s.AY.A4.length;i<t;i++)ZC.Q.HC({cls:"zc-abs zc-layer zc-vb",id:s.K+"-plot-"+i+"-vb-c",p:ZC.AK(s.K+"-plots-vb"),wh:A},s.A.AA)}(s.o.title||s.o.subtitle||s.o.source||s.o["no-data"])&&(ZC.Q.JZ({id:s.K+"-titles",p:ZC.AK(s.K),tl:C,wh:A,position:"absolute"},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-titles-c",p:ZC.AK(s.K+"-titles"),wh:A},s.A.AA)),ZC.Q.JZ({cls:"zc-abs",wh:A,id:s.K+"-hover",p:ZC.AK(s.A.K+"-hover"),"clip-path":_,clip:f},s.A.AA),"canvas"===s.A.AA&&(ZC.AK(s.K+"-hover").style.clip=f),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-hover-c",p:ZC.AK(s.K+"-hover"),wh:A},s.A.AA),s.A.NZ.maps&&-1!==JSON.stringify(s.o).indexOf("zingchart.maps")&&(ZC.Q.JZ({cls:"zc-abs",wh:A,id:s.K+"-objects-maps",p:ZC.AK(s.A.K+"-objects-maps"),"clip-path":_,clip:f},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-sh-c",p:ZC.AK(s.K+"-objects-maps"),wh:A},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-c",p:ZC.AK(s.K+"-objects-maps"),wh:A},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-click-c",p:ZC.AK(s.K+"-objects-maps"),wh:A},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-hover-c",p:ZC.AK(s.K+"-objects-maps"),wh:A},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-objects-maps-print-c",p:ZC.AK(s.K+"-objects-maps"),wh:A,display:"none"},s.A.AA)),s.initObjectsLayers(),s.o.legend&&(ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-legend-c",p:ZC.AK(s.A.K+"-legend"),wh:A},s.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:s.K+"-legend-scroll-c",p:ZC.AK(s.A.K+"-legend"),wh:A},s.A.AA))}s.Z=s.H.usc()?s.H.mc():ZC.AK(s.K+"-c")},initObjectsLayers:function(){var e=this,i=e.A.I+"/"+e.A.F;!ZC.AK(e.K+"-objects-bottom")&&e.A.NZ["objects-bottom"]&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-bottom",p:ZC.AK(e.A.K+"-objects-bottom")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-bottom-sh-c",p:ZC.AK(e.K+"-objects-bottom"),wh:i},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-bottom-c",p:ZC.AK(e.K+"-objects-bottom"),wh:i},e.A.AA)),!ZC.AK(e.K+"-objects-top")&&e.A.NZ["objects-top"]&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-top",p:ZC.AK(e.A.K+"-objects-top")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-top-sh-c",p:ZC.AK(e.K+"-objects-top"),wh:i},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-top-c",p:ZC.AK(e.K+"-objects-top"),wh:i},e.A.AA)),(e.A.NZ["objects-bottom"]||e.A.NZ["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows)&&ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-print-c",p:ZC.AK(e.K+"-objects-top"),wh:i,display:"none"},e.A.AA),!ZC.AK(e.K+"-objects-click")&&(e.A.NZ["objects-bottom"]||e.A.NZ["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-click",p:ZC.AK(e.A.K+"-hover")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-click-c",p:ZC.AK(e.K+"-objects-click"),wh:i},e.A.AA)),!ZC.AK(e.K+"-objects-hover")&&(e.A.NZ["objects-bottom"]||e.A.NZ["objects-top"])&&(e.o.shapes||e.o.labels||e.o.arrows||e.o.images)&&(ZC.Q.JZ({cls:"zc-abs",wh:i,id:e.K+"-objects-hover",p:ZC.AK(e.A.K+"-hover")},e.A.AA),ZC.Q.HC({cls:"zc-abs zc-layer",id:e.K+"-objects-hover-c",p:ZC.AK(e.K+"-objects-hover"),wh:i},e.A.AA))},A0M:function(){},clear_:function(){},destroy:function(){var e,i=this;null!==ZC._n_(e=i.A.SA[i.K])&&"feed"===i.HP.type&&(e.send("zingchart.stopfeed"),e.close(),i.A.SA[i.K]=null),i.GG&&i.LW.stop(!0),i.MA="clear.init",i.unbind(),i.BD&&i.BD.unbind(),i.B9&&i.B9.unbind(),i.HS&&i.HS.unbind(),i.HQ&&i.HQ.unbind(),i.MA="clear.complete"},clear:function(e,i){null===ZC._n_(e)&&(e=!1),null===ZC._n_(i)&&(i=!1);var t,n,a,l,o=this;o.TG={},null===ZC._n_(t=o.A.SA[o.K])||e||"feed"===o.HP.type&&(t.send("zingchart.stopfeed"),t.close(),o.A.SA[o.K]=null),o.GG&&o.LW.stop(!0),o.MA="clear.init",o.unbind(e),o.A0M(!1,!0),o.LD(),o.LD("click"),o.LD("guide",!0),o.LD("print",!0),o.LD("textprint",!0),e||(!o.B9||o.B9&&!o.B9.LK)&&o.LD("static",!0),o.AY.YZ=[],o.A.ST=[],zingchart.SKIP.LEGEND||o.BD&&o.BD.clear(),o.E.datalength=[];var r,s,A,C=ZC.ie67?ZC.AK(o.A.K):null;if(ZC.mobile||ZC.ie67)ZC.A5("."+o.K+"-node-area",C).remove();else if(ZC.AK(o.A.K+"-img")&&ZC.AK(o.A.K+"-map")){ZC.AK(o.A.K+"-img").setAttribute("useMap","");var c=ZC.AK(o.A.K+"-map").cloneNode(!0);for(n=(a=c.childNodes.length)-1;n>=0;n--)-1!==c.childNodes[n].className.indexOf(o.K+"-node-area")&&c.removeChild(c.childNodes[n]);ZC.Q.EU(o.A.K+"-map"),ZC.AK(o.A.K+"-top").appendChild(c),ZC.AK(o.A.K+"-img").setAttribute("useMap","#"+o.A.K+"-map")}switch(ZC.Q.EU(o.K+"--graph"),o.AY.HE=[],ZC.A5("."+o.K+"-value-box",C).remove(),ZC.A5("."+o.K+"-scale-marker-label",C).remove(),ZC.A5("."+o.K+"-scale-item",C).remove(),ZC.A5("."+o.K+"-scale-label",C).remove(),ZC.A5("."+o.K+"-guide-label",C).remove(),ZC.A5("."+o.K+"-shape-label",C).remove(),ZC.A5("."+o.K+"-mapshape-label",C).remove(),e||ZC.A5("."+o.K+"-preview-item",C).remove(),o.A.AA){case"svg":for(n=0,a=o.AY.A4.length;n<a;n++)o.AY.A4[n].HI=null;ZC.A5("#"+o.A.K+"-defs").children().each(function(){"LINK"!==this.tagName.toUpperCase()&&(0!==this.id.indexOf(o.K+"-")&&1!==o.A.AG.length||(e?this.id!==o.K+"-gradient"&&-1===this.id.indexOf("-preview-gradient")&&-1===this.id.indexOf("-menu-trigger-gradient")&&-1!==this.id.indexOf(o.K+"-plotset-plot-")&&(i&&o.GG||-1!==this.id.indexOf(o.K+"-legend-")&&zingchart.SKIP.LEGEND||ZC.A5(this).remove()):-1===this.id.indexOf("zc-menu-")&&-1===this.id.indexOf("-menu-trigger-")&&(-1!==this.id.indexOf(o.K+"-legend-")?zingchart.SKIP.LEGEND||ZC.A5(this).remove():o.B9&&o.B9.LK?-1===this.id.indexOf("-preview-gradient")&&ZC.A5(this).remove():ZC.A5(this).remove())))}),e||ZC.Q.EU([o.K+"-clip",o.K+"-clip-hover",o.K+"-clip-preview"]),ZC.A5("#"+o.A.K+"-svg").children().each(function(){var e=o.K+"-";"clippath"===this.tagName.toLowerCase()&&this.id.substring(0,e.length)===e&&this.id!==o.K+"-clip"&&this.id!==o.K+"-clip-hover"&&this.id!==o.K+"-clip-preview"&&ZC.Q.EU(this.id)})}(ZC.Q.EU(o.K+"-nodata"),ZC.Q.EU(o.A.K+"-tooltip-text-float"),e||(ZC.Q.EU([o.K+"-title",o.K+"-subtitle",o.K+"-source",o.K+"-hover"]),zingchart.SKIP.LEGEND||o.BD&&(ZC.Q.EU(o.K+"-legend-c"),ZC.Q.EU(o.K+"-legend-scroll-c"),ZC.A5("."+o.K+"-legend-item-area",C).remove(),ZC.A5("."+o.K+"-legend-marker-area",C).remove(),ZC.A5("."+o.K+"-legend-item",C).remove(),ZC.A5("."+o.K+"-legend-header",C).remove(),ZC.A5("."+o.K+"-legend-footer",C).remove(),ZC.A5("."+o.K+"-legend-frame",C).remove(),o.BD.gc(),o.BD=null),o.B9&&(o.B9.LK&&!o.A.E.resize||(o.B9.unbind(),ZC.A5("."+o.K+"-preview-handler").remove(),ZC.A5("."+o.K+"-preview-mask").remove(),ZC.A5("#"+o.K+"-preview").remove(),o.B9.gc(),o.B9=null)),o.HS&&(o.HS.unbind(),o.HS=null),ZC.Q.IU(ZC.AK(o.K+"-scroll-x-c"),o.A.AA,o.iX,o.iY,o.I,o.F,o.K),ZC.Q.IU(ZC.AK(o.K+"-scroll-y-c"),o.A.AA,o.iX,o.iY,o.I,o.F,o.K),ZC.A5("#"+o.K+"-scroll-x-handle").remove(),ZC.A5("#"+o.K+"-scroll-x-bar").remove(),o.HQ&&(o.HQ.unbind(),o.HQ=null),ZC.A5("#"+o.K+"-scroll-y-handle").remove(),ZC.A5("#"+o.K+"-scroll-y-bar").remove(),ZC.A5("#"+o.K+"-c").empty(),o.H.QO[0]!==o.H.QO[1]&&""!==o.H.QO[1]&&("canvas"===o.H.AA&&ZC.A5("#"+o.K+" canvas").each(function(){this.width=1,this.height=1,ZC.Q.EU(this)}),ZC.A5("#"+o.K+" div").each(function(){ZC.Q.EU(this)}),ZC.Q.EU(o.K))),ZC.A5("#"+o.K+" .zc-layer").each(function(){var t=ZC.Q.T8(this);if(-1===t.indexOf("zc-persistent")){if(e&&(this.id===o.K+"-plotarea-c"||this.id===o.K+"-titles-c"))return;if(-1===this.id.indexOf(o.K+"-plot-")&&-1===this.id.indexOf(o.K+"-plots-"))ZC.Q.IU(this,o.H.AA,o.iX,o.iY,o.I,o.F,o.K);else if(i&&o.GG&&!o.HH){if("canvas"!==o.H.AA)for(var n=0,a=o.AY.A4.length;n<a;n++)o.E.datalength[n]=o.AY.A4[n].S.length;(l=o.A.K9?new RegExp("-plots-[a-z]+-c","g").exec(this.id):new RegExp("-plot-(\\d+)-[a-z]+-\\d+-","g").exec(this.id))&&(!o.E["plot"+l[1]+".visible"]&&"remove"===o.getToggleAction()||o.A.K9)&&ZC.Q.IU(this,o.H.AA,o.iX,o.iY,o.I,o.F,o.K),-1===t.indexOf("zc-vb")&&-1===t.indexOf("zc-fl")||ZC.Q.IU(this,o.H.AA,o.iX,o.iY,o.I,o.F,o.K)}else ZC.Q.IU(this,o.H.AA,o.iX,o.iY,o.I,o.F,o.K)}}),-1!==ZC.AV(o.H.KR,"use_single_canvas"))&&((r=ZC.AK(o.H.K+"-main-c"))&&ZC.Q.IU(r,o.H.AA,o.iX,o.iY,o.I,o.F,o.K),(s=ZC.AK(o.H.K+"-main-c-top"))&&ZC.Q.IU(s,o.H.AA,o.iX,o.iY,o.I,o.F,o.K),(A=ZC.AK(o.H.K+"-print-c"))&&ZC.Q.IU(A,o.H.AA,o.iX,o.iY,o.I,o.F,o.K));o.clear_(),o.A.E.resize=!1,o.MA="clear.complete"},unbind:function(e,i){null===ZC._n_(e)&&(e=!1);var t=this;(-1===ZC.AV(t.H.KR,"skip_interactivity")||i)&&(ZC.A5("."+t.K+"-node-area").die("mousedown mouseover touchstart",t.X2).die("mouseup mouseout touchend",t.A1U).die("mousemove touchmove",t.A0R).die("click",t.TB).die("contextmenu",t.TB).die("dblclick",t.A1B),t.BD&&(zingchart.SKIP.LEGEND||(ZC.A5("."+t.K+"-legend-item-area").die("mouseup touchstart",t.SP).die("DOMMouseScroll",t.zc_legend_mousescroll).die("mousewheel",t.zc_legend_mousescroll),ZC.A5("."+t.K+"-legend-marker-area").die("mouseup touchstart",t.SP).die("DOMMouseScroll",t.zc_legend_mousescroll).die("mousewheel",t.zc_legend_mousescroll),ZC.A5("#"+t.K+"-legend-frame").die("DOMMouseScroll",t.zc_legend_mousescroll).die("mousewheel",t.zc_legend_mousescroll),ZC.mobile||(ZC.A5("."+t.K+"-legend-item-area").die(ZC.Q.BZ("mouseover"),t.QQ).die(ZC.Q.BZ("mouseout"),t.R9).die(ZC.Q.BZ("mousemove"),t.PN),ZC.A5("."+t.K+"-legend-marker-area").die(ZC.Q.BZ("mouseover"),t.QQ).die(ZC.Q.BZ("mouseout"),t.R9).die(ZC.Q.BZ("mousemove"),t.PN))))),t.AC7()},AC7:function(){},S9:function(){},QR:function(){},KK:function(){},SF:function(){},S0:function(){},LD:function(e,i){var t=this;e=e||"hover",null===ZC._n_(i)&&(i=!1);var n=ZC.AK((i?t.A.K:t.K)+"-"+e+"-c");n&&(ZC.Q.IU(n,t.H.AA,t.iX,t.iY,t.I,t.F,t.K,"textprint"===e),ZC.A5("."+t.K+"-label-hover").remove()),"hover"===e&&(ZC.Q.IU(ZC.AK(t.K+"-objects-hover-c"),t.H.AA,t.iX,t.iY,t.I,t.F,t.K),ZC.Q.IU(ZC.AK(t.K+"-objects-maps-hover-c"),t.H.AA,t.iX,t.iY,t.I,t.F,t.K),zingchart.DEV.PLOTSHLAYER&&ZC.Q.IU(ZC.AK(t.K+"-plots-hover-c"),t.H.AA,t.iX,t.iY,t.I,t.F,t.K)),"click"===e&&(ZC.Q.IU(ZC.AK(t.K+"-objects-click-c"),t.H.AA,t.iX,t.iY,t.I,t.F,t.K),ZC.Q.IU(ZC.AK(t.K+"-objects-maps-click-c"),t.H.AA,t.iX,t.iY,t.I,t.F,t.K)),t.hideLayer_(e,i)},hideLayer_:function(){},A6U:function(e,i){var t,n=this;if(null!==ZC._n_(e)&&null!==ZC._n_(i)){var a=n.AY.A4[e].IZ,l=n.AY.A4[e].RO;if("none"===a)return;if(null!==ZC._n_(n.CB["p"+e])){if(null!==ZC._n_(n.CB["p"+e]["n"+i])){if(delete n.CB["p"+e]["n"+i],l)for(t=0;t<n.AY.A4.length;t++)delete n.CB["p"+t]["n"+i]}else if("graph"===a?(n.CB={},n.CB["p"+e]={}):"plot"===a&&(n.CB["p"+e]={}),n.CB["p"+e]["n"+i]=!0,l)for(t=0;t<n.AY.A4.length;t++)n.CB["p"+t]=n.CB["p"+t]||{},n.CB["p"+t]["n"+i]=!0}else if("graph"===a&&(n.CB={}),n.CB["p"+e]={},n.CB["p"+e]["n"+i]=!0,l)for(t=0;t<n.AY.A4.length;t++)n.CB["p"+t]=n.CB["p"+t]||{},n.CB["p"+t]["n"+i]=!0}null!==ZC._n_(e)&&null!==ZC._n_(i)&&(n.HH=!0,n.K6(!0,!0))},paint:function(e){null===ZC._n_(e)&&(e=!1);var i,t,n,a,l,o,r=this;r.A.GRAPHID=r.K,r.UX=e,window.clearTimeout(ZC.ASYNC_TICK[r.K]),r.A.clearLabelBoxes("vb"+r.L);var s,A,C,c,u,p,Z,h=r.BU("k")[0],d=ZC.MAX,f=-ZC.MAX,_={},g=r.AY.A4,v=0;for(c=0;c<g.length;c++)if(g[c].o.rel)for(C=0;C<g.length;C++)if(g[C].o.id&&g[C].o.id===g[c].o.rel){v++,Z=!0;var b=[];for(l=0;l<g[C].S.length;l++)(h.EF?g[C].S[l].BT>=h.B3&&g[C].S[l].BT<=h.BJ:g[C].S[l].L>=h.W&&g[C].S[l].L<=h.A1)?(s=g[C].S[l].AD,d=Math.min(d,s),f=Math.max(f,s),Z?(Z=!1,g[C].S[l].BT?b.push([g[C].S[l].BT,0]):b.push(0),p=s):g[C].S[l].BT?b.push([g[C].S[l].BT,100*(s-p)/p]):b.push(100*(s-p)/p)):g[C].S[l].BT?b.push([g[C].S[l].BT,0]):b.push(0);_["p-"+c]=[].concat(b)}if(v>0){for(d=ZC.MAX,f=-ZC.MAX,c=0;c<g.length;c++)if(g[c].o.rel&&_["p-"+c])for(l=0;l<g[c].S.length;l++)2===(A=_["p-"+c][l]).length?(s=A[1],g[c].V[l]=A,g[c].S[l].AD=g[c].S[l].CS=A[1]):(s=A,g[c].V[l]=g[c].S[l].AD=g[c].S[l].CS=A),g[c].FK(l),d=Math.min(d,s),f=Math.max(f,s);var B=r.BU("v")[0];B.RQ(d,f,!0),B.J1()}for(r.A.E["g-"+r.L+"-selection"]&&(r.CB=JSON.parse(r.A.E["g-"+r.L+"-selection"])),r.KI=!1,t=0,n=r.AY.A4.length;t<n;t++)r.IX[t]=!1;for(t in r.CB)if(r.CB.hasOwnProperty(t)){var m=ZC._i_(t.replace("p",""));for(u in r.CB[t])if(r.CB[t].hasOwnProperty(u)){r.IX[m]=!0,r.KI=!0;break}}function E(){if(r.AJ["3d"]){var e=ZC.DI.DB(r.P,r,r.P.iX-ZC.AO.E2,r.P.iX-ZC.AO.E2+r.P.I,r.P.iY-ZC.AO.E3,r.P.iY-ZC.AO.E3+r.P.F,ZC.AO.FT+10,ZC.AO.FT+10,"y"),t=ZC.DI.DB(r.P,r,r.P.iX-ZC.AO.E2,r.P.iX-ZC.AO.E2+r.P.I,r.P.iY-ZC.AO.E3,r.P.iY-ZC.AO.E3+r.P.F,ZC.AO.FT,ZC.AO.FT,"y");t.K=r.K+"-plotarea",t.PA=e.D,r.CL.add(t)}else{r.P.Z=r.P.C7=r.H.usc()?r.H.mc():ZC.AK(r.K+"-plotarea-c");var n,a=[r.P.iX,r.P.iY,r.P.I,r.P.F],l=r.P.AU,o=r.P.AU,s=r.P.AU,A=r.P.AU;""!==(i=r.P.Q1)&&(n=i.split(/\s/),l=ZC._i_(n[0])),""!==(i=r.P.OJ)&&(n=i.split(/\s/),o=ZC._i_(n[0])),""!==(i=r.P.NP)&&(n=i.split(/\s/),s=ZC._i_(n[0])),""!==(i=r.P.P6)&&(n=i.split(/\s/),A=ZC._i_(n[0])),r.P.iX-=A+1,r.P.iY-=l+1,r.P.I+=A+o+1,r.P.F+=l+s+1,r.P.paint(),r.P.iX=a[0],r.P.iY=a[1],r.P.I=a[2],r.P.F=a[3]}}if(r.A.A0C(),r.NX(),r.UX?r.E["plotarea.paint"]&&(E(),r.E["plotarea.paint"]=null):(r.build(),r.Z&&(r.C7=r.Z,r.b()),E()),"xy"===r.AJ.layout||"yx"===r.AJ.layout){var D=r.BU("v"),K=null;for(l=0;l<D.length;l++)(0===l||D[l].o["ref-zero"])&&D[l].FW<=0&&D[l].H1>=0&&D[l].T9&&(K=l);if(null!==ZC._n_(K)){var F=D[K].AT(0);for(l=0;l<D.length;l++)if(l!==K&&D[l].o["sync-zero"]&&D[l].FW<=0&&D[l].H1>=0&&D[l].T9){var x=D[l].AT(0);if(ZC._a_(x-F)>=1)for(var I=!0,y=0;I;)x>F?D[l].CO?D[l].AW?D[l].AB+=1:D[l].BV+=1:D[l].AW?D[l].BV+=1:D[l].AB+=1:D[l].CO?D[l].AW?D[l].BV+=1:D[l].AB+=1:D[l].AW?D[l].AB+=1:D[l].BV+=1,y++,D[l].J1(),D[l].A7U(),(y>(D[l].CO?r.P.I:r.P.F)||ZC._a_(D[l].AT(0)-F)<1)&&(I=!1)}}}for(l=0,o=r.BO.length;l<o;l++)r.BO[l].Z=r.BO[l].C7=r.H.usc()?r.H.mc():ZC.AK(r.K+"-scales-bl-0-c"),r.A.O7=!0,r.BO[l].paint(),r.A.ZV(),r.A.O7=!1;var w="undefined"!=typeof r.E["shared-zoom"]&&null!==ZC._n_(r.E["shared-zoom"])&&r.E["shared-zoom"];if(r.B9&&r.B9.LK?r.B9.I2&&(r.B9.I2=!0,r.B9.paint()):r.E["skip-preview"]||!r.B9||r.UX&&!r.B9.I2||w||(r.B9.I2=!0,r.B9.paint()),r.E["shared-zoom"]=null,r.E["skip-preview"]=null,r.HS&&r.HS.paint(),r.HQ&&r.HQ.paint(),r.UX||(a=r.H.usc()?r.H.mc():ZC.AK(r.K+"-titles-c"),r.IR&&r.IR.AN&&null!==ZC._n_(r.IR.AM)&&(r.IR.Z=r.IR.C7=a,r.IR.paint(),!r.IR.K9&&ZC.AK(r.A.K+"-map")&&(ZC.AK(r.A.K+"-map").innerHTML+=ZC.AP.O5(r.K,r.IR))),r.K0&&r.K0.AN&&null!==ZC._n_(r.K0.AM)&&(r.K0.Z=r.K0.C7=a,r.K0.paint(),!r.K0.K9&&ZC.AK(r.A.K+"-map")&&(ZC.AK(r.A.K+"-map").innerHTML+=ZC.AP.O5(r.K,r.K0))),r.MR&&r.MR.AN&&null!==ZC._n_(r.MR.AM)&&(r.MR.Z=r.MR.C7=a,r.MR.paint(),!r.MR.K9&&ZC.AK(r.A.K+"-map")&&(ZC.AK(r.A.K+"-map").innerHTML+=ZC.AP.O5(r.K,r.MR))),r.S5&&r.S5.AN&&null!==ZC._n_(r.S5.AM)&&(r.S5.Z=r.S5.C7=a,r.S5.paint())),r.IR&&r.IR.EK(),r.K0&&r.K0.EK(),r.MR&&r.MR.EK(),r.AJ["3d"]||r.UD(),r.A.O7=!r.GG,zingchart.DEV.SKIPTRACKERS&&(r.A.O7=!1),r.A.E["graph."+r.K+".disableanimation"])for(l=0,o=r.AY.A4.length;l<o;l++)r.AY.A4[l].GG=!1;r.AY.paint(),r.H.paintHistory()},UD:function(){},clearPreview:function(){var e=this;e.B9&&(ZC.Q.IU(ZC.AK(e.K+"-preview-c"),e.A.AA,e.iX,e.iY,e.I,e.F,e.K),e.A.H2&&!e.A.H2.A0G&&e.B9.reset(),e.B9.I2=!0)},flatten:function(){},_end_:function(){var e,i,t,n,a=this;for(a.E["toggle-action-remove"]=null,a.GG||a.A.ZV(),a.A.O7=!1,(a.LK||!a.GG||a.H.E["graph."+a.K+".disableanimation"]||!a.AJ["enable-animation"]||-1!==ZC.AV(a.H.KR,"skip_interactivity")||zingchart.SKIP.ANIMATION)&&(a.MA="ready"),"initial"===a.A1Q&&(a.ABO=!1,a.H.E["graph."+a.K+".disableanimation"]=!0),i=0,t=a.BO.length;i<t;i++)a.BO[i].paint_();if(!a.A.E["fire-load"]){var l=ZC.AP.BY("objectsinit",a.A,a.GX(),!0);if(l)for(var o=["labels","shapes","imges","arrows"],r=0;r<o.length;r++)l[o[r]]&&(a.o[o[r]]=(a.o[o[r]]||[]).concat(l[o[r]]))}function s(e){var i,t,n=(e.targetid||e.target.id).replace("-area-path","").replace("-path","").replace(/--([a-zA-Z0-9]+)/,"").replace("-marker","").replace("-circle","").split("-").reverse();return"node"===n[1]&&(i=n[2],t=n[0]),[i,t]}if(a.AJ["3d"]||(a.flatten(),a.PW(),a.KK(),-1===ZC.AV(a.H.KR,"skip_interactivity")&&a.S0()),-1===ZC.AV(a.H.KR,"skip_interactivity")){var A=ZC.A5("."+a.K+"-node-area");a.X2=function(e){if(!(zingchart.NODE_EV&&"mouseover"===zingchart.NODE_EV_TYPE&&"mouseover"===e.type||(zingchart.NODE_EV_CHART=a.A.K,zingchart.NODE_EV=e,zingchart.NODE_EV_TYPE=e.type,ZC.move||a.BD&&a.BD.YF||-1===ZC.Q.T8(e.target).indexOf("zc-node-area")||"ready"!==a.MA))){ZC.mobile&&(a.E["node-target-id"]=e.target.id,ZC.move=!1,a.H.hideCM(),null===a.H.DF||null===ZC._n_(a.H.DF["page-scroll"])||a.H.DF["page-scroll"]||e.preventDefault(),a.A.YI(e));var n=s(e);if(a.AY.A4[n[0]]){var l=a.AY.A4[n[0]].FK(n[1]);if(l&&(l.N?(ZC.COLORS=[l.N.C2,l.N.A0,l.N.AE,l.N.BW,l.N.B7],l.NC&&ZC.COLORS.push(l.NC.A0,l.NC.AE,l.NC.BW,l.NC.B7)):ZC.COLORS=[],a.E["plot"+n[0]+".visible"])){var o=ZC.mobile?"mousedown":e.xtype||e.type;(ZC.mobile||"mousedown"!==o)&&a.A.A7&&a.A7&&a.A7.AN&&a.A.A7.onmouseover(e);var r=a.AY.A4[n[0]];if("plot"===r.A3K)for(i=0,t=r.S.length;i<t;i++)r.S[i]&&r.FK(i).A0W("hover");else l.A0W("hover");if(l.X4(e,o),l.A.X5(e,o),a.BD){ZC.move=!0;var A=n[0];a.AY.A4[A].o["legend-item"]&&null!==ZC._n_(a.AY.A4[A].o["legend-item"].order)&&(A=ZC._i_(a.AY.A4[A].o["legend-item"].order)),a.BD.o["reverse-series"]&&(A=a.AY.A4.length-1-A),a.BD.PQ?a.L===a.A.AG.length-1&&a.BD.highlightItem(A):a.BD.highlightItem(A),ZC.move=!1}}}}},A.live("mousedown mouseover touchstart",a.X2),a.A1U=function(e){if(zingchart.NODE_EV=zingchart.NODE_EV_TYPE=null,zingchart.NODE_EV_CHART=null,!(ZC.move||a.BD&&a.BD.YF)){var i=e.target;if(ZC.mobile&&document.elementFromPoint){var t=ZC.Q.MB(e),n=Math.max(window.pageXOffset,document.documentElement.scrollLeft,document.body.scrollLeft),l=Math.max(window.pageYOffset,document.documentElement.scrollTop,document.body.scrollTop);if((i=document.elementFromPoint(t[0]-n,t[1]-l))&&a.E["node-target-id"]&&a.E["node-target-id"]!==i.id)return}if(-1!==ZC.Q.T8(e.target).indexOf("zc-node-area")&&"ready"===a.MA){ZC.mobile&&a.A.OU(e);var o=s(e),r=a.AY.A4[o[0]].FK(o[1]);if(r){if(a.E["plot"+o[0]+".visible"]){a.A.A7&&a.A7&&a.A7.AN&&a.A.A7.onmouseout(e),a.AY.A4[o[0]].D=[],r.LD(),a.LD();var A=ZC.mobile?"mouseup":e.xtype||e.type;r.X4(e,A),r.A.X5(e,A),a.BD&&(ZC.move=!0,a.BD.PQ?a.L===a.A.AG.length-1&&a.BD.highlightItem(-1):a.BD.highlightItem(-1),ZC.move=!1)}!ZC.mobile||a.H.AA2||ZC.move||"touchend"!==e.type||(zingchart.SB(e),a.TB(e))}}}},A.live("mouseup mouseout touchend",a.A1U),a.A0R=function(e){if(zingchart.NODE_EV=e,zingchart.NODE_EV_CHART=a.A.K,zingchart.NODE_EV_TYPE=e.type,-1!==ZC.Q.T8(e.target).indexOf("zc-node-area")&&"ready"===a.MA){ZC.mobile&&a.A.OU(e);var i=s(e);a.E["plot"+i[0]+".visible"]&&a.A.A7&&a.A7&&a.A7.AN&&a.A.A7.onmousemove(e)}},A.live("mousemove touchmove",a.A0R),a.TB=function(e){if((e.targetid||-1!==ZC.Q.T8(e.target).indexOf("zc-node-area"))&&"ready"===a.MA){var i=s(e),t=a.AY.A4[i[0]].FK(i[1]);if(t&&("none"===t.A.IZ||!ZC.mobile&&0!==e.button||(a.A.E.preservezoom=!0,a.clearPreview(),a.A6U(t.A.L,t.L)),t.X4(e,"click"),t.A.X5(e,"click"),null!==ZC._n_(t.A.EA)&&"NULL"!==t.A.EA))if(t.A.EA instanceof Array)for(var n=0;n<t.A.EA.length;n++){var l=t.A.FB;t.A.FB instanceof Array&&(l=t.A.FB[n]||"graph="+(a.o.id||"")),n===t.L&&a.UZ(e,t.JV(t.A.EA[n],null,null,!0),l)}else a.UZ(e,t.JV(t.A.EA,null,null,!0),t.A.FB||"graph="+(a.o.id||""))}},a.A1B=function(e){if(-1!==ZC.Q.T8(e.target).indexOf("zc-node-area")&&"ready"===a.MA){var i=s(e),t=a.AY.A4[i[0]].FK(i[1]);t&&(t.X4(e,"doubleclick"),t.A.X5(e,"doubleclick"))}},ZC.mobile||A.live("click",a.TB).live("contextmenu",a.TB).live("dblclick",a.A1B)}if(a.AC2(),a.A.E["tr-ev-"+a.L]?(a.A.E["tr-ev-"+a.L]=null,a.A7Q()):a.A7Q(),a.A17){a.A17=!1;var C={graphid:a.K};for(i=0,t=a.BU("k").length;i<t;i++){var c=a.BU("k")[i];null!==ZC._n_(e=c.KN)&&(C["zoomx"+(n=1===c.L?"":"-"+c.L)]=!0,C["xmin"+n]=e[0],C["xmax"+n]=e[1])}for(i=0,t=a.BU("v").length;i<t;i++){var u=a.BU("v")[i];null!==ZC._n_(e=u.KN)&&(C["zoomy"+(n=1===u.L?"":"-"+u.L)]=!0,C["ymin"+n]=e[0],C["ymax"+n]=e[1])}if(C.zoomto=!0,a.A.G1){for(var p in a.A.G1)ZC.AK(p).appendChild(a.A.G1[p]);a.A.G1=null}a.A.PV(C)}},AC2:function(){},A7Q:function(){var e=this;if(e.A.A28<e.A.AG.length&&(e.A.A28++,ZC.AP.BY("gload",e.A,e.GX())),ZC.AP.BY("gcomplete",e.A,e.GX()),e.B9&&(e.B9.I2=!1),zingchart.NODE_EV&&zingchart.NODE_EV_CHART&&zingchart.NODE_EV_CHART===e.A.K){var i=ZC.A5("#"+e.A.K+"-top"),t=ZC.E1[0]-i.offset().left,n=ZC.E1[1]-i.offset().top,a=zingchart.exec(e.A.K,"getxyinfo",{x:t,y:n});if(a)for(var l=0;l<a.length;l++)if("node"===a[l].infotype&&a[l].xydistance<10){var o=a[l].graphid+"-plotset-plot-"+a[l].plotidx+"-node-"+a[l].nodeidx;zingchart.NODE_EV&&zingchart.NODE_EV.target&&zingchart.NODE_EV.target.id===o&&(e.X2(zingchart.NODE_EV),zingchart.NODE_EV=null)}}zingchart.GUIDE_EV&&e.A.D7&&e.A.D7.Q7(zingchart.GUIDE_EV),e.A.A4G<e.A.AG.length?e.A.A4G++:(e.A.A4G=1,e.A.A28===e.A.AG.length&&(e.A.A28++,e.A.E["fire-load"]=!0,e.LK&&e.AY.A4.length>1&&(zingchart.SKIP.EVENT||ZC.AP.BY("load",e.A,e.A.FE()))),e.A.E["fire-complete"]=!0,(e.E["graph-K6"]||e.LK&&e.AY.A4.length>1)&&(zingchart.SKIP.EVENT||ZC.AP.BY("complete",e.A,e.A.FE()),e.E["graph-K6"]=null)),0!==e.A.QL.length&&e.A.QL[e.A.QL.length-1]===e.A.E.json||(e.A.QL[e.A.NS]!==e.A.E.json&&(e.A.QL.length=e.A.NS+1),e.A.QL[e.A.NS]=e.A.E.json)},K6:function(e,i){var t=this;null===ZC._n_(e)&&(e=!1),null===ZC._n_(i)&&(i=!1),t.A.N3(t),t.E["graph-K6"]=!0,t.clear(e,i),t.parse(),t.U5&&t.U5(),t.paint(e),t.B9&&t.B9.setScalesInfo(),t.HH=!1,zingchart.SKIP.CSV=!1},UZ:function(ev,EA,FB){if(2!==ev.button){var s=this,C,P9=[""];switch(null!==ZC._n_(FB)&&(P9=FB.split("=")),P9[0]){case"_blank":window.open(EA,"_blank");break;case"_top":window.top.location.href=EA;break;case"_parent":window.parent.location.href=EA;break;case"window":null!==ZC._n_(P9[1])&&""!==P9[1]&&(window.top[P9[1]].location.href=EA);break;case"graph":var Y3=null;if("()"===EA.substring(EA.length-2)||"javascript:"===EA.substring(0,11))try{var EC=EA.replace("javascript:","").replace("()","");eval(EC)&&(Y3=eval(EC).call(s))}catch(e){}null!==ZC._n_(P9[1])&&""!==P9[1]?"_top"===P9[1]||"_parent"===P9[1]?(s.A.N3(),Y3?zingchart.exec(s.A.K,"setdata",{data:Y3}):s.A.load(null,EA)):(C=s.A.OQ(P9[1]),C&&(s.A.N3(C),s.A.E["tr-ev-"+C.L]=!0,s.A.NS++,Y3?zingchart.exec(s.A.K,"setdata",{graphid:P9[1],data:Y3}):s.A.load(P9[1],EA))):(C=s.A.AG[0],s.A.N3(C),Y3?zingchart.exec(s.A.K,"setdata",{graphid:C.K,data:Y3}):(s.A.E["tr-ev-"+C.L]=!0,s.A.NS++,s.A.load(C.K,EA)));break;default:window.location.href=EA}}},I0:function(e,i,t){var n=this;if(null===ZC._n_(t)&&(t=n.AY.A4.length-1),null!==ZC._n_(e)&&void 0!==e)return n.AY.A4[e];if(null===ZC._n_(i)||void 0===i)return n.AY.A4[t];for(var a=0,l=n.AY.A4.length;a<l;a++)if(i===n.AY.A4[a].H8)return n.AY.A4[a];return null},A3C:function(e,i){var t,n,a=this;(e=e||{})["toggle-action"]=e["toggle-action"]||a.getToggleAction();var l=null;if("undefined"!=typeof e.plotindex&&(l=ZC._i_(e.plotindex)),-1===l)for(l=[],t=0,n=a.AY.A4.length;t<n;t++)l.push(t);l instanceof Array||(l=[l]);var o=e.plotid||"";o instanceof Array||(o=[o]);var r=[];for(t=0,n=ZC.BQ(l.length,o.length);t<n;t++){var s=a.I0(l[t],o[t]);if(s){var A={};ZC._cp_(e,A);var C=s.L;A.plotindex=C,A.plotid=s.H8,("show"===i&&!a.E["plot"+C+".visible"]||"hide"===i&&a.E["plot"+C+".visible"])&&r.push(A)}}for(t=0,n=r.length;t<n;t++)a.A.o.graphset[a.L].series[r[t].plotindex].visible="show"===i,t===n-1&&(r[t].K6=1),a.QC(r[t])},QC:function(e){var i,t,n,a=this;a.A.E["graph."+a.K+".disableanimation"]=!1,e=e||{};var l=!1;null!==ZC._n_(e.skip)&&e.skip&&(l=!0),null===ZC._n_(e.update)||e.update||(l=!0);var o=!1;e["toggle-action"]=e["toggle-action"]||a.getToggleAction(),null!==ZC._n_(i=e["ignore-legend"])&&(o=ZC._b_(i));var r=a.I0(e.plotindex,e.plotid);if(r){var s=r.L;switch(e["toggle-action"]){case"hide":if(a.BD&&(a.BD.E.showhide=!0),a.E["plot"+s+".visible"]=!a.E["plot"+s+".visible"],null!==ZC._n_(a.A.o.graphset[a.L].series)&&(a.A.o.graphset[a.L].series[s].visible=a.E["plot"+s+".visible"]),a.AJ["3d"])o=!0,l||a.K6();else{var A=a.E["plot"+s+".visible"]?"block":"none";if(zingchart.DEV.SKIPTRACKERS||ZC.A5("."+a.K+"-plotset-plot-"+s+"-node-area").each(function(){if("AREA"===this.tagName.toUpperCase()){var e=ZC.A5(this),i=e.attr("coords"),n=e.attr("shape");"none"===A?(i="-"+i.replace(/,/g,",-"),"rect"===n?4===(t=i.split(",")).length&&(i=[t[2],t[3],t[0],t[1]].join(",")):"circle"===n&&3===(t=i.split(",")).length&&(i=[t[0],t[1],-t[2]].join(","))):(i=i.replace(/\-/g,""),"rect"===n&&4===(t=i.split(",")).length&&(i=[t[2],t[3],t[0],t[1]].join(","))),e.attr("coords",i)}}),a.A.K9)ZC.AK(a.K+"-plots-bl-c").style.display=A,ZC.AK(a.K+"-plots-fl-c").style.display=A,ZC.AK(a.K+"-plots-vb-c").style.display=A;else{for(n=0;n<r.SV;n++)(i=ZC.AK(a.K+"-plot-"+s+"-bl-"+n+"-c"))&&(i.style.display=A);for(n=0;n<r.A1G;n++)(i=ZC.AK(a.K+"-plot-"+s+"-fl-"+n+"-c"))&&(i.style.display=A);(i=ZC.AK(a.K+"-plot-"+s+"-vb-c"))&&(i.style.display=A)}var C=ZC.A5("."+a.K+"-plot-"+s+"-value-box");a.E["plot"+s+".visible"]?(C.show(),ZC.A5("."+a.K+"-plotset-plot-"+s+"-preview").show()):(C.hide(),ZC.A5("."+a.K+"-plotset-plot-"+s+"-preview").hide())}break;case"remove":a.clearPreview(),o=!0,a.E["toggle-action-remove"]=!0,a.E["plot"+s+".visible"]=!a.E["plot"+s+".visible"],e.K6&&(l||(a.LV("on-legend-toggle"),a.K6(!0,!0)))}a.BD&&!o&&(a.BD.clear(),a.BD.paint())}},LV:function(e){var i=this,t=!0,n=i.o.plot||{};null!==ZC._n_(n.animation)&&null!==ZC._n_(n.animation[e])&&(t=ZC._b_(n.animation[e])),i.HH="initial"===i.A1Q||!t},GX:function(){return{id:this.A.K,graphidx:this.L,graphid:this.K.replace(this.A.K+"-graph-",""),x:this.iX,y:this.iY,width:this.I,height:this.F,loader:this.A.FE()}},RY:function(){},RV:function(){},gc:function(){for(var e=0;e<this.BO.length;e++)this.BO[e].gc();for(var i=0;i<this.AY.A4.length;i++)this.AY.A4[i].gc();ZC.AP.gc(this.AY,["A","C","H","F8","o","I6","J9"]),ZC.AP.gc(this,["Z","C7","AJ","IR","K0","MR","F0"])}}),ZC.JI.prototype.PW=function(){var e,i,t,n,a,l,o,r,s=this;s.initObjectsLayers(),s.BX=[],s.FH=[],s.YC=[],s.LH=[],s.FA=[],s.XA={};var A,C,c,u=s.A.B8,p="("+s.AF+")";if(null!==ZC._n_(A=s.o.labels))for(i=0,t=A.length;i<t;i++){A[i].id||(A[i].id="lbl_"+i+"_"+ZC._r_(1e3,9999)),n=A[i].id||i,a=!1,l=!1,s.E["objects.updates"]&&-1===ZC.AV(s.E["objects.updates"],n)&&(a=!0,l=!0),A[i].tween&&(a=!0);var Z=zingchart.pool.getInstance("DN",s,s.K+"-label-"+n,a);if(!l||!Z._POOL_){if(u.load(Z.o,p+".label"),Z.append(A[i]),null!==ZC._n_(e=Z.o.parent))for(var h=0;h<s.BX.length;h++)if(""+s.BX[h].H8==""+e){Z.E["p-x"]=s.BX[h].iX,Z.E["p-y"]=s.BX[h].iY,Z.E["p-width"]=s.BX[h].I,Z.E["p-height"]=s.BX[h].F;break}if(Z.H8=n,Z.K=s.K+"-label-"+n,Z.GL=s.K+"-label zc-label",null!==ZC._n_(e=A[i].hook)&&(Z.E.hook=e),Z.JV=function(i){if(!i||-1===(""+i).indexOf("%"))return i;i=""+i;var t,n=[];n.push(["%id",s.A.K]),n.push(["%graphid",s.K.replace(s.A.K+"-graph-","")]);var a=s.E.update;for(var l in a)n.push(["%"+l,a[l]]);n.sort(ZC.A1H);for(var o=0,r=n.length;o<r;o++)t=new RegExp(n[o][0],"g"),i=i.replace(t,n[o][1]);var A,C,c,u,p=Z.o["default-value"]||" ";for(t=new RegExp("(%plot-([0-9]+?)-value(-*)([0-9]*?))|(%plot-value-([0-9]+?))|(%plot-value)|(%npv)|(%node-percent-value)","g"),i=i.replace(t,p),t=new RegExp("%plot-([0-9]+?)-data-([a-zA-Z0-9-]+)","g"),i=i.replace(t,p),t=new RegExp("\\((.+?)\\)\\(([0-9]*)\\)\\(([0-9]*)\\)");A=t.exec(i);)if("%node-value"===A[1]){C="";var h=0,d=0;""!==(e=A[2])&&(h=ZC._i_(e)),""!==(e=A[3])&&(d=ZC._i_(e)),(u=s.AY.A4[h])&&(c=u.FK(d,3))&&(C=c.JV(A[1])),i=i.replace(A[0],C)}return i},Z.parse(),A[i]["3d"]){var d=new ZC.CE(s,Z.iX+Z.I/2-ZC.AO.E2,Z.iY+Z.F/2-ZC.AO.E3,ZC._i_(A[i].z||"0"));Z.iX=d.ED[0]-Z.I/2,Z.iY=d.ED[1]-Z.F/2}}s.BX.push(Z),s.FA.push({type:"label",index:i,zindex:Z.JR}),s.XA[n]={shape:"label",idx:i}}if(null!==ZC._n_(C=s.o.arrows))for(i=0,t=C.length;i<t;i++){var f=new ZC.A81(s);u.load(f.o,p+".arrow"),f.append(C[i]),n=C[i].id||i,f.K=s.K+"-arrow-"+n,f.parse(),s.YC.push(f),s.FA.push({type:"arrow",index:i,zindex:f.JR})}var _,g=0;if(null!==ZC._n_(c=s.o.shapes))for(i=0,t=c.length;i<t;i++)if(null===ZC._n_(c[i].type)||0!==c[i].type.indexOf("zingchart.")){var v,b,B;if(c[i].id||(c[i].id="shp_"+i+"_"+ZC._r_(1e3,9999)),n=c[i].id||i,l=null!==ZC._n_(zingchart.pool[s.K+"-shape-"+n])&&zingchart.SKIP.PARSE3D,a=!1,s.E["objects.updates"]&&-1===ZC.AV(s.E["objects.updates"],n)&&(a=!0,l=!0),c[i].tween&&(a=!0),c[i]["3d"]?((o=zingchart.pool.getInstance("DT",s,s.K+"-shape-"+n,!0)).o=c[i],("poly"!==c[i].type||c[i]["map-item"])&&(l=!1)):(null!==ZC._n_(c[i].label)?(o=zingchart.pool.getInstance("OY",s,s.K+"-shape-"+n,a)).WS=c[i]:((o=zingchart.pool.getInstance("DT",s,s.K+"-shape-"+n,a)).o=c[i],o.append({},!0)),a&&o._POOL_||(l=!1)),l||(o.H8=n,o.K=s.K+"-shape-"+n,o.O7=!0,c[i]["map-item"]&&(o.O7=!1),o.parse()),null!==ZC._n_(e=c[i].hook)&&(o.E.hook=e),c[i]["3d"]){if(c[i]["map-item"]){for(v=[],b=0,B=o.D.length;b<B;b++)null!==o.D[b]?(r=new ZC.CE(s,o.D[b][0]-ZC.AO.E2,o.D[b][1]-ZC.AO.E3,ZC._i_(o.D[b][2]||c[i].z||"0")),v.push(r.ED)):v.push(null);o.D=v,s.FH.push(o),s.FA.push({type:"shape",index:g,zindex:o.JR,z3d:r.AAP}),s.XA[n]={shape:o.DU,idx:g}}else if("poly"===c[i].type){var m=ZC.DI.D8(o,s,c[i].points,!1);s.CL.add(m),s.FH.push(null)}else{if(o.D.length>0){for(v=[],b=0,B=o.D.length;b<B;b++)r=new ZC.CE(s,o.D[b][0]-ZC.AO.E2,o.D[b][1]-ZC.AO.E3,ZC._i_(o.D[b][2]||c[i].z||"0")),v.push(r.ED);o.D=v}else r=new ZC.CE(s,o.iX-ZC.AO.E2,o.iY-ZC.AO.E3,ZC._i_(c[i].z||"0")),o.iX=ZC._i_(r.ED[0]),o.iY=ZC._i_(r.ED[1]);s.FH.push(o),s.FA.push({type:"shape",index:g,zindex:o.JR,z3d:r.AAP})}o.E["3dtx"]=!0,o.E["3d"]=!0}else s.FH.push(o),o instanceof ZC.OY?(s.FA.push({type:"shape",index:g,zindex:o.BG.JR}),s.XA[n]={shape:o.BG.DU,idx:g}):(s.FA.push({type:"shape",index:g,zindex:o.JR}),s.XA[n]={shape:o.DU,idx:g});g++}if(null!==ZC._n_(_=s.o.images))for(i=0,t=_.length;i<t;i++){var E=_[i].src;if(ZC.cache.data[E]){var D=new ZC.HL(s);D.append({"background-repeat":"no-repeat","background-image":E,width:ZC.cache.data[E].width,height:ZC.cache.data[E].height}),D.append(_[i]),n=_[i].id||i,D.H8=n,D.K=s.K+"-image-"+n,D.L=i,D.parse(),s.LH.push(D),s.FA.push({type:"image",index:i,zindex:D.JR})}}s.E["objects.updates"]=null,s.FA=s.FA.sort(function(e,i){return null!==ZC._n_(e.z3d)&&null!==ZC._n_(i.z3d)?e.z3d-i.z3d>0?1:-1:0}),s.FA=s.FA.sort(function(e,i){return e.zindex-i.zindex==0?e.index-i.index:e.zindex-i.zindex})},ZC.JI.prototype.A0M=function(e,i){void 0===e&&(e=!1),void 0===i&&(i=!1);var t,n=this,a=[n.K+"-objects-bottom-sh-c",n.K+"-objects-bottom-c",n.K+"-objects-top-sh-c",n.K+"-objects-top-c",n.K+"-objects-front-c",n.K+"-objects-print-c"];ZC.SKIPMAPS||a.push(n.K+"-objects-maps-sh-c",n.K+"-objects-maps-c");for(var l=0;l<a.length;l++)(t=ZC.AK(a[l]))&&ZC.Q.IU(t,n.H.AA,n.iX,n.iY,n.I,n.F,n.K);"canvas"===n.A.AA&&!zingchart.CANVASTEXT&&ZC.objmove||(ZC.A5("."+n.K+"-label").remove(),ZC.A5("."+n.K+"-shape-label").remove(),ZC.A5("."+n.K+"-arrow-label").remove()),e||(ZC.A5("."+n.K+"-label-area").each(function(){if(-1===ZC.AV([n.K+"-title-area",n.K+"-subtitle-area",n.K+"-source-area"],this.id)){var e=new RegExp("scale_(x|y|k|v)-(item_|marker_)([0-9]+)").exec(this.id);!i&&e&&e.length||ZC.Q.EU(this.id)}}),ZC.A5("."+n.K+"-shape-area").each(function(){(!ZC.SKIPMAPS||ZC.SKIPMAPS&&"1"!==this.getAttribute("data-map"))&&ZC.Q.EU(this.id)}),ZC.A5("."+n.K+"-arrow-area").remove()),"svg"===n.A.AA&&ZC.A5("#"+n.A.K+"-svg").children().each(function(){var e=n.K+"-label-";"clippath"===this.tagName.toLowerCase()&&this.id.substring(0,e.length)===e&&ZC.Q.EU(this.id)})},ZC.JI.prototype.AC7=function(){var e=this;(e.H.NZ["objects-top"]||e.H.NZ["objects-bottom"])&&(ZC.A5("."+e.K+"-label-area").die(ZC.mobile?"touchstart":"mousedown mouseover",e.A07).die(ZC.mobile?"touchend":"mouseup mouseout",e.A0S).die(ZC.mobile?"touchmove":"mousemove",e.A06),ZC.mobile||ZC.A5("."+e.K+"-label-area").die("click",e.UA).die("dblclick",e.UA),ZC.A5("."+e.K+"-shape-area").die(ZC.mobile?"touchstart":"mousedown mouseover",e.A05).die(ZC.mobile?"touchend":"mouseup mouseout",e.A0U).die(ZC.mobile?"touchmove":"mousemove",e.A03),ZC.mobile||ZC.A5("."+e.K+"-shape-area").die("click",e.UH).die("dblclick",e.UH))},ZC.JI.prototype.OW=function(){var e,i,t,n,a=this;if(a.YK=!1,null!==ZC._n_(t=a.o.labels))for(e=0,i=t.length;e<i;e++){var l=""+(t[e].text||"");if(-1!==l.indexOf("%node-")||-1!==l.indexOf("%plot-")||-1!==l.indexOf("%npv")||-1!==l.indexOf("%node-percent-value")||ZC._b_(t[e].dynamic)){a.YK=!0;break}}if(null!==ZC._n_(n=a.o.shapes))for(e=0,i=n.length;e<i;e++)if(ZC._b_(n[e].dynamic)){a.YK=!0;break}},ZC.JI.prototype.QR=function(e){var i=this;i.A0M(e),i.PW(),i.KK(e),ZC.SKIPMAPS=!1},ZC.JI.prototype.KK=function(e){void 0===e&&(e=!1);var i,t,n,a=this,l=[],o=[];function r(e){var i=a.YC[e];if(i.AN&&(i.Z=i.C7=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-"+(i.JR<0?"bottom":"top")+"-c"),i.paint(),i.AN&&ZC.AK(a.A.K+"-map"))){var t=i.BG.A4Y(),n=ZC.Q.G0(t[0],i.BG.EA,i.BG.IV)+'class="'+a.K+'-arrow-area zc-arrow-area" id="'+i.BG.K+'-area" coords="'+t[1]+'" />';"top"===i.o.placement?o.push(n):l.push(n)}}function s(e){if(a.FH[e]){var t=a.FH[e],n=t instanceof ZC.OY?t.BG:t;if((!ZC.SKIPMAPS||!n.o["map-item"])&&n.AN){if(null!==ZC._n_(i=t.E.hook)){var r=a.UY(i);-1!==r[0]&&(n.iX=ZC._i_(r[0])),-1!==r[1]&&(n.iY=ZC._i_(r[1]))}if(!t.E["3d"]||t.E["3dtx"]){t.Z=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-"+(n.JR<0?"bottom":"top")+"-c"),t.C7=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-"+(n.JR<0?"bottom":"top")+"-sh-c"),n.o["map-item"]&&(t.Z=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-maps-c"),t.C7=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-maps-sh-c"));var s="";null!==ZC._n_(i=n.o.limit)&&("x"===i?s="x":"y"===i?s="y":"xy"===i&&(s="xy")),(""===s||"x"===s&&ZC.DS(n.iX-n.BM,a.P.iX-2,a.P.iX+a.P.I+2)||"y"===s&&ZC.DS(n.iY-n.BH,a.P.iY-2,a.P.iY+a.P.F+2)||"xy"===s&&ZC.DS(n.iX+n.BM,a.P.iX-2,a.P.iX+a.P.I-2)&&ZC.DS(n.iY+n.BH,a.P.iY-2,a.P.iY+a.P.F+2))&&(t.VN=!1,t.E["print-canvas"]=a.K+"-"+(n.o["map-item"]?"maps":"objects")+"-print-c",t.paint())}if(!t.K9&&!a.Q5&&"normal"===zingchart.OBJECTMODE){var A=n.A4Y();if(ZC.AK(a.A.K+"-map"))for(var C=1,c=A.length;C<c;C++)if(""!==A[C]){var u=n.o["map-item"]&&!n.o["map-skip-z-sort"]?' data-map="1"':"",p=ZC.Q.G0(A[0],n.EA,n.IV)+'class="'+a.K+'-shape-area zc-shape-area" id="'+n.K+"-area"+(C>1?"--"+C:"")+'" coords="'+A[C]+'" data-z-sort="'+n.A9D+'"'+u+" />";"top"===t.o.placement?o.push(p):l.push(p)}}}}}function A(e){var i=a.LH[e];if(i.AN)if(i.Z=i.C7=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-"+(i.JR<0?"bottom":"top")+"-c"),null!==ZC._n_(i.o.repeat)&&ZC._b_(i.o.repeat)){var t=ZC._i_(ZC._c_(i.o.items,0)),n=null;if(i.o.inactive&&((n=new ZC.HL(i.A)).copy(i),n.append(i.o.inactive),n.parse(),n.Z=n.C7=i.Z),t>0||n){var l=ZC._i_(ZC._c_(i.o.rows,-1)),o=ZC._i_(ZC._c_(i.o.cols,-1)),r=ZC._i_(ZC._c_(i.o["space-x"],0)),s=ZC._i_(ZC._c_(i.o["space-y"],0)),A=ZC._i_(ZC._c_(i.o["offset-row"],0)),C=ZC._i_(ZC._c_(i.o["offset-col"],0));-1!==l&&-1===o?o=Math.ceil(t/l):-1===l&&-1!==o?l=Math.ceil(t/o):-1===l&&-1===o&&(o=Math.ceil(Math.sqrt(t)),l=Math.ceil(t/o));for(var c=i.iX,u=i.iY,p=i.K,Z=0;Z<l;Z++)for(var h=0;h<o;h++)i.iX=c+h*r+Z*A,i.iY=u+Z*s+h*C,i.K=p+(Z*o+h),Z*o+h<t?i.paint():n&&(n.iX=i.iX,n.iY=i.iY,n.K=i.K,n.paint())}else i.paint()}else i.paint()}function C(e){var t=a.BX[e];if(t.AN){if(t.E.lbltype="label",null!==ZC._n_(i=t.E.hook)){var n=a.UY(i);if(-1===n[0]&&-1===n[1])return;if(-1!==n[0]&&(t.iX=n[0]),-1!==n[1]&&(t.iY=n[1]),null===ZC._n_(n[2])||t.o.anchor||null!==ZC._n_(n[2].center)&&n[2].center&&(t.iX-=t.I/2,t.iY-=t.F/2),t.o.anchor&&t.setAnchor(),t.o["3d"]){var r=0;n[2]&&n[2].z?r=n[2].z:t.o.z&&(r=ZC._i_(t.o.z));var s=new ZC.CE(a,t.iX+t.I/2-ZC.AO.E2,t.iY+t.F/2-ZC.AO.E3,r);t.iX=s.ED[0]-t.I/2,t.iY=s.ED[1]-t.F/2}}t.iX=ZC._i_(t.iX),t.iY=ZC._i_(t.iY),t.IL=ZC.AK(a.A.K+"-text"),t.Z=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-"+(t.JR<0?"bottom":"top")+"-c"),t.C7=a.H.usc()?a.H.mc("top"):ZC.AK(a.K+"-objects-"+(t.JR<0?"bottom":"top")+"-sh-c");var A="";if(null!==ZC._n_(i=t.o.limit)&&("x"===i?A="x":"y"===i?A="y":"xy"===i&&(A="xy")),(""===A||"x"===A&&ZC.DS(t.iX-t.BM,a.P.iX-t.I/2-2,a.P.iX+a.P.I-t.I/2+2)||"y"===A&&ZC.DS(t.iY-t.BH,a.P.iY-t.F/2-2,a.P.iY+a.P.F-t.F/2+2)||"xy"===A&&ZC.DS(t.iX+t.BM,a.P.iX-t.I/2-2,a.P.iX+a.P.I-t.I/2+2)&&ZC.DS(t.iY+t.BH,a.P.iY-t.F/2-2,a.P.iY+a.P.F-t.F/2+2))&&(t.VN=!1,t.paint(),t.EK(ZC.AK(a.K+"-objects-print-c")),!t.K9&&!a.Q5&&"normal"===zingchart.OBJECTMODE&&ZC.AK(a.A.K+"-map"))){var C=ZC.AP.O5(a.K,t);"top"===t.o.placement?o.push(C):l.push(C)}}}if(a.H.clearLabelBoxes("label"),a.FA)for(t=0,n=a.FA.length;t<n;t++){var c=a.FA[t].index;switch(a.FA[t].type){case"arrow":r(c);break;case"shape":s(c);break;case"image":A(c);break;case"label":C(c)}}for(t=0;t<a.AY.A4.length;t++)a.AY.A4[t].RL=null;if(!e&&"normal"===zingchart.OBJECTMODE&&(o.length>0||l.length>0)&&ZC.AK(a.A.K+"-map")){if(a.A4C){var u=function(e,i){return-1!==e.indexOf("data-map")&&-1!==i.indexOf("data-map")?ZC.AP.N2(i)-ZC.AP.N2(e):ZC.AP.N2(e)-ZC.AP.N2(i)};o.sort(u),l.sort(u)}zingchart.DEV.MAPSONBOTTOM?window.setTimeout(function(){ZC.AK(a.A.K+"-map").innerHTML=o.join("")+ZC.AK(a.A.K+"-map").innerHTML+l.join("")},33):ZC.AK(a.A.K+"-map").innerHTML=o.join("")+ZC.AK(a.A.K+"-map").innerHTML+l.join("")}a.A.E["fire-load"]||ZC.AP.BY("objectsready",a.A,a.GX())},ZC.JI.prototype.SF=function(e,i,t,n){var a,l,o,r,s=this;switch(t=t||"hover",e){case"shape":var A=s.FH[i],C=A instanceof ZC.OY?A.BG:A;if(null!==ZC._n_(C.o[t+"-state"])){if(!n&&C.o.group)for(o=0,r=s.FH.length;o<r;o++)o!==i&&(s.FH[o].o.group===C.o.group||s.FH[o].BG&&s.FH[o].BG.o.group===C.o.group)&&s.SF(e,o,t,!0);if((a=new ZC.DT(s)).append(C.o),a.append(C.o[t+"-state"]),l=C.o.id||i,a.H8=l+"-"+t,a.K=s.K+"-shape-"+l+"-"+t,a.parse(),A.E["3d"]&&(a.D=C.D,a.iX=A.iX,a.iY=A.iY),a.AN)if(a.Z=a.C7=ZC.AK(s.K+"-objects-"+t+"-c"),a.o["map-item"]&&(a.Z=a.C7=ZC.AK(s.K+"-objects-maps-"+t+"-c")),a.o["map-item"]&&zingchart.maps.LITE&&"canvas"!==s.A.AA){if("svg"===s.A.AA){var c=ZC.A5("#"+s.K+"-shape-"+a.H8+"-gshape-path");s.E["map-shape-info"]={fill:c.attr("fill"),stroke:c.attr("stroke"),"stroke-width":c.attr("stroke-width")},"poly"===a.DU?(c.attr("fill",a.A0),c.attr("stroke-width",a.AU),c.attr("stroke",a.BW)):"line"===a.DU&&(c.attr("stroke-width",a.AZ),c.attr("stroke",a.B7))}else if("vml"===s.A.AA){var u=ZC.AK(s.K+"-shape-"+a.H8+"-gshape-path"),p=ZC.A5(u.childNodes[1]),Z=ZC.A5(u.childNodes[2]);s.E["map-shape-info"]={fill:""+Z.attr("color"),stroke:""+p.attr("color"),"stroke-width":""+p.attr("weight")},"poly"===a.DU?(Z.attr("color",a.A0),p.attr("weight",a.AU),p.attr("color",a.BW)):"line"===a.DU&&(p.attr("weight",a.AZ),p.attr("color",a.B7))}}else a.paint(),"canvas"===s.A.AA&&zingchart.CANVASTEXT&&A.M&&(A.M.Z=A.M.C7=ZC.AK(s.K+"-objects-"+t+"-c"),A.M.paint())}break;case"label":var h=s.BX[i];if(h&&null!==ZC._n_(h.o[t+"-state"])){if(!n&&h.o.group)for(o=0,r=s.BX.length;o<r;o++)o!==i&&s.BX[o].o.group===h.o.group&&s.SF(e,o,t,!0);var d=zingchart.pool.getInstance("DN",s,s.K+"-label-"+t);d.append(h.o),d.append(h.o[t+"-state"]),l=h.id||i,d.H8=l+"-"+t,d.K=s.K+"-label-"+l+"-"+t,d.GL=s.K+"-label "+s.K+"-label-"+t+" zc-label zc-label-"+t,d.IL=ZC.AK(s.A.K+"-text"),d.parse(),d.AN&&(d.iX=h.iX,d.iY=h.iY,d.I=h.I,d.F=h.F,d.Z=d.C7=ZC.AK(s.K+"-objects-"+t+"-c"),ZC.AK(s.K+"-label-"+l)&&(ZC.AK(s.K+"-label-"+l).style.display="none"),d.paint())}}},ZC.JI.prototype.S0=function(){var e,i,t,n=this;(n.H.NZ["objects-top"]||n.H.NZ["objects-bottom"])&&(n.A05=function(e){ZC.mobile&&(n.LD(),ZC.move=!1,n.H.hideCM(),null===n.H.DF||null===ZC._n_(n.H.DF["page-scroll"])||n.H.DF["page-scroll"]||e.preventDefault(),n.A.YI(e));var i=a(e);i.tooltip&&n.A7&&n.A.A7&&n.A7.AN&&n.A.A7.onmouseover(e);var t=ZC.mobile?"mousedown":e.xtype||e.type;i.lowlevel||n.SF("shape",i.shapeindex),n.RV(t,i)},n.A0U=function(e){ZC.mobile&&(n.H.AA2||ZC.move||(zingchart.SB(e),n.UH(e)),n.A.OU(e)),n.A7&&n.A.A7&&n.A7.AN&&n.A.A7.onmouseout(e),ZC.mobile||n.LD();var i=ZC.mobile?"mouseup":e.xtype||e.type,t=a(e);if(t.shape&&t.shape.mapItem&&zingchart.maps.LITE&&"canvas"!==n.A.AA)if("svg"===n.A.AA){var l=ZC.A5("#"+n.K+"-shape-"+t.shape.id+"-gshape-path");"poly"===t.shape.type&&l.attr("fill",n.E["map-shape-info"].fill),l.attr("stroke",n.E["map-shape-info"].stroke),l.attr("stroke-width",n.E["map-shape-info"]["stroke-width"])}else if("vml"===n.A.AA){var o=ZC.AK(n.K+"-shape-"+t.shape.id+"-gshape-path"),r=o.childNodes[1],s=o.childNodes[2],A=n.E["map-shape-info"];"poly"===t.shape.type&&ZC.Q.G3(s,{color:A.fill}),ZC.Q.G3(r,{weight:A["stroke-width"],color:A.stroke})}n.RV(i,t)},n.A03=function(e){var i=a(e);i.tooltip&&n.A7&&n.A.A7&&n.A7.AN&&n.A.A7.onmousemove(e),n.RV("mousemove",i)},n.UH=function(e){var i=a(e);if("dblclick"!==e.type){e.ctrlKey||n.LD("click"),n.TG=n.TG||{},n.TG["s_"+i.shapeid]?(n.TG["s_"+i.shapeid]=null,n.LD("click")):(e.ctrlKey||(n.TG={}),n.TG["s_"+i.shapeid]=1,n.SF("shape",i.shapeindex,"click")),n.RV("click",i);var t=n.FH[i.shapeindex].BG||n.FH[i.shapeindex];if(ZC.mobile&&(n.E["click-ts"]&&(new Date).getTime()-n.E["click-ts"]<500&&n.RV("dblclick",i),n.E["click-ts"]=(new Date).getTime()),t&&t.EA&&"NULL"!==t.EA)if(t.EA instanceof Array)for(var l=0;l<t.EA.length;l++)null!==ZC._n_(t.FB[l])&&n.UZ(e,t.EA[l],t.FB[l]);else n.UZ(e,t.EA,t.FB)}else n.RV("dblclick",i)},ZC.A5("."+n.K+"-shape-area").live(ZC.mobile?"touchstart":"mousedown mouseover",n.A05).live(ZC.mobile?"touchend":"mouseup mouseout",n.A0U).live(ZC.mobile?"touchmove":"mousemove",n.A03),ZC.mobile||ZC.A5("."+n.K+"-shape-area").live("click",n.UH).live("dblclick",n.UH),n.A07=function(e){ZC.mobile&&(n.LD(),ZC.move=!1,n.H.hideCM(),null===n.H.DF||null===ZC._n_(n.H.DF["page-scroll"])||n.H.DF["page-scroll"]||e.preventDefault(),n.A.YI(e));var i=l(e);if(i.tooltip&&n.A7&&n.A.A7&&n.A7.AN&&n.A.A7.onmouseover(e),null!==i&&"label"===i.type){var t=ZC.mobile?"mousedown":e.xtype||e.type;i["data-active"]||n.SF("label",i.labelindex),n.RY(t,i)}},n.A0S=function(e){ZC.mobile&&(n.H.AA2||ZC.move||(zingchart.SB(e),n.UA(e)),n.A.OU(e)),n.A7&&n.A.A7&&n.A7.AN&&n.A.A7.onmouseout(e),ZC.mobile||n.LD();var i=l(e);if(null!==i){var t=ZC.mobile?"mouseup":e.xtype||e.type;ZC.AK(n.K+"-label-"+i.label.id)&&(ZC.AK(n.K+"-label-"+i.label.id).style.display="block"),n.RY(t,i)}},n.A06=function(e){var i=l(e);i.tooltip&&n.A7&&n.A.A7&&n.A7.AN&&n.A.A7.onmousemove(e),n.RY("mousemove",i)},n.UA=function(e){var i=l(e);if("dblclick"!==e.type){e.ctrlKey||n.LD("click"),n.TG=n.TG||{},n.TG["l_"+i.labelid]?(n.TG["l_"+i.labelid]=null,n.LD("click")):(e.ctrlKey||(n.TG={}),n.TG["l_"+i.labelid]=1,n.SF("label",i.labelindex,"click")),n.RY("click",i),ZC.mobile&&(n.E["click-ts"]&&(new Date).getTime()-n.E["click-ts"]<500&&n.RY("dblclick",i),n.E["click-ts"]=(new Date).getTime());var t=n.BX[i.labelindex];if(!t)switch(i.type){case"graph-title":t={EA:n.IR.EA,FB:n.IR.FB};break;case"graph-subtitle":t={EA:n.K0.EA,FB:n.K0.FB};break;case"graph-source":t={EA:n.MR.EA,FB:n.MR.FB}}if(t&&t.EA&&"NULL"!==t.EA)if(t.EA instanceof Array)for(var a=0;a<t.EA.length;a++)null!==ZC._n_(t.FB[a])&&(t.EA[a]=t.EA[a].replace("%id",n.A.K),t.EA[a]=t.EA[a].replace("%graphid",n.K.replace(n.A.K+"-graph-","")),n.UZ(e,t.EA[a],t.FB[a]));else t.EA=t.EA.replace("%id",n.A.K),t.EA=t.EA.replace("%graphid",n.K.replace(n.A.K+"-graph-","")),n.UZ(e,t.EA,t.FB)}else n.RY("dblclick",i)},ZC.A5("."+n.K+"-label-area").live(ZC.mobile?"touchstart":"mousedown mouseover",n.A07).live(ZC.mobile?"touchend":"mouseup mouseout",n.A0S).live(ZC.mobile?"touchmove":"mousemove",n.A06),ZC.mobile||ZC.A5("."+n.K+"-label-area").live("click",n.UA).live("dblclick",n.UA));function a(e){for(var i=(e.targetid||e.target.id).replace(/\-\-\d+/g,"").replace(n.K+"-shape-","").replace("-gshape-area","").replace("-area",""),t=-1,a=null,l=0,o=n.FH.length;l<o;l++)if(n.FH[l]&&""+n.FH[l].H8==""+i){t=l,a=n.FH[l]instanceof ZC.OY?n.FH[l].BG:n.FH[l];break}if(!a&&e.target.getAttribute("data-lowlevel"))return{shapeid:e.target.id,lowlevel:!0,ev:e};if(-1===t)return null;var r={shapeid:i,shapeindex:t,tooltip:a.o.tooltip?1:0,shape:{id:i,index:t,cls:a.DK,x:a.iX,y:a.iY,type:a.DU,mapItem:a.o["map-item"],points:a.D,width:a.I,height:a.F,size:a.AI,size2:a.JQ,angle:a.A9,zIndex:a.JR},ev:e};for(var s in a.o)a.o.hasOwnProperty(s)&&"data-"===s.substring(0,5)&&(r[s]=a.o[s]);return r}function l(a){var l,o=a.targetid||a.target.id;if(o===n.K+"-title-area"||o===n.K+"-subtitle-area"||o===n.K+"-source-area"){var r=null,s=-1;switch(l=o.replace(n.K+"-","").replace("-area","")){case"title":r=n.IR,s=-1;break;case"subtitle":r=n.K0,s=-2;break;case"source":r=n.MR,s=-3}return{type:"graph-"+l,labelid:r.K,labelindex:s,text:r.AM,label:{id:r.K,index:s,text:r.AM},ev:a}}if(-1===o.indexOf("-scale")||-1===o.indexOf("-item")&&-1===o.indexOf("-marker")){if(-1!==o.indexOf("-value-box-")){e=o.replace(n.K+"-plotset-plot-","").replace("-value-box-area",""),i=e.split("-node-");var A=n.AY.A4[ZC._i_(i[0])].FK(ZC._i_(i[1]));return A?{type:"value-box",labelid:"vb_"+i.join("_"),plotindex:ZC._i_(i[0]),nodeindex:ZC._i_(i[1]),text:A.AD,label:{id:"vb_"+i.join("_"),text:A.AD},ev:a}:null}e=o.replace(n.K+"-label-","").replace("-area","");for(var C=-1,c=null,u=0,p=n.BX.length;u<p;u++)if(""+n.BX[u].H8==""+e){C=u,c=n.BX[u];break}if(t=-1===C?"":n.BX[C].AM,-1===C)return null;var Z={type:"label",labelid:e,labelindex:C,text:t,tooltip:c.o.tooltip?1:0,label:{id:e,index:C,cls:c.DK,x:c.iX+c.BM,y:c.iY+c.BH,width:c.I,height:c.F,text:t},ev:a};for(var h in c.o)c.o.hasOwnProperty(h)&&"data-"===h.substring(0,5)&&(Z[h]=c.o[h]);return Z}e=o.replace(n.K+"-","").replace("-area","");var d=(i=e.split("-"))[1].split("_"),f=0;2===d.length?f=ZC._i_(d[1]):3===d.length&&(f=ZC._i_(d[2]));var _,g=i[0].replace(/_/g,"-"),v=n.BL(g);return-1!==o.indexOf("-item")?(l="scale-item",_="si_"+i[1].replace("item_",""),t=v.BX[f]||v.V[f],"si_title"===_&&(t=v.M.AM)):(l="scale-marker",_="sm_"+i[1].replace("marker_",""),t=v.E["marker_text_"+f]||""),{type:l,labelid:_,labelindex:f,scale:g,text:t,tooltip:v.o.tooltip||v.o.item&&v.o.item.tooltip?1:0,label:{id:_,index:f,text:t},ev:a}}},ZC.JI.prototype.RY=function(e,i){ZC._cp_(this.GX(),i),i.ev=ZC.A5.BZ(i.ev),ZC.AP.BY("label_"+e,this.A,i)},ZC.JI.prototype.RV=function(e,i){ZC._cp_(this.GX(),i),i.ev=ZC.A5.BZ(i.ev),ZC.AP.BY("shape_"+e,this.A,i)},ZC.JI.prototype.UY=function(e){var i,t,n=this;if("string"==typeof e){var a={},l=e.split(":");if(2===l.length){a.type=l[0];for(var o=0,r=(l=l[1].split(/\s|,|;/)).length;o<r;o++){var s=l[o].split("=");a[s[0]]=s[1]}}e=a}var A=[-1,-1];switch(n.E.hooks=!0,e.type){case"scale":var C,c,u,p="",Z=-1,h=null;if(null!==ZC._n_(i=e.name)&&(p=i),null!==ZC._n_(i=e.index)&&(Z=ZC._i_(i)),null!==ZC._n_(i=e.value)&&(h=ZC._i_(i)),t=null,""===p&&(p="scale-x"),t=n.BL(p))switch(t.IB&&-1!==Z?u=t.IB(Z):t.AT&&(null!==ZC._n_(h)?u=t.AT(h):-1!==Z&&(u=t.AT(t.V[Z]))),n.AJ.layout){case"radar":case"gauge":C=u[0],c=u[1];break;case"xy":"k"===t.AF?(C=u,c=t.iY,"default"===t.BA&&(c+=t.F)):"v"===t.AF&&(c=u,C=t.iX,"opposite"===t.BA&&(C+=t.I));break;case"yx":"k"===t.AF?(c=u,C=t.iX,"opposite"===t.BA&&(C+=t.I)):"v"===t.AF&&(C=u,c=t.iY,"default"===t.BA&&(c+=t.F))}A=[C,c,{center:!0}];break;case"node":var d=-1,f=null,_=null,g=null,v=null;null!==ZC._n_(i=e.plot)&&(g=i),null!==ZC._n_(i=e.plotindex)&&(g=i),null!==ZC._n_(i=e.plotid)&&(v=i);var b=n.I0(g,v);null!==ZC._n_(i=e.index)&&(d=ZC._i_(i)),null!==ZC._n_(i=e.value)&&(f=i),null!==ZC._n_(i=e.keyvalue)&&(_=i);var B=null;if(b){if(-1!==d&&b.S[d])B=b.FK(d,3);else if(null!==ZC._n_(f)||null!==ZC._n_(_)){var m,E;if(t=b.C.BL(b.BO[0]),null!==_&&null===f&&b.S.length>4096&&t.FG&&"date"===t.FG.o.type&&null!==(m=ZC._nfind_(_,b,0,b.S.length-1))&&(B=b.FK(m,3)),!B)for(m=0,E=b.S.length;m<E;m++)b.S[m]&&(null!==f&&b.S[m].AD==f&&(B=b.FK(m,3)),null!==_&&null!==ZC._n_(b.S[m].BT)&&b.S[m].BT==_&&(B=b.FK(m,3)))}B&&(B.setup(),A=B.UY(e),!B.JD&&ZC.DS(A[0],n.P.iX,n.P.iX+n.P.I)&&ZC.DS(A[1],n.P.iY,n.P.iY+n.P.F)&&(B.JD=!0),B.JD&&B.AN&&B.A.AN&&B.C.E["plot"+B.A.L+".visible"]||(A=[-1,-1])),b.E["z-mid"]&&(A[2].z=b.E["z-mid"])}}return null!==ZC._n_(e.x)&&(A[0]=ZC._i_(e.x)),null!==ZC._n_(e.y)&&(A[1]=ZC._i_(e.y)),null!==ZC._n_(i=e["offset-x"])&&(A[0]+=ZC._i_(i)),null!==ZC._n_(i=e["offset-y"])&&(A[1]+=ZC._i_(i)),A},zingchart.AB5=function(e,i,t){document.getElementById("zc-fullscreen")&&(e="zc-fullscreen"),"string"==typeof(t=t||{})&&(t=JSON.parse(t));var n,a,l,o,r,s,A,C,c,u,p,Z,h,d,f=!(null!==ZC._n_(t.update)&&!ZC._b_(t.update)),_=!!t.dynamic&&ZC._b_(t.dynamic),g=zingchart.getLoader(e);if(g)switch(i){case"addobject":if((n=g.C8(t.graphid))&&t.data){if(c=(C=t.data instanceof Array)?[]:{},ZC._cp_(t.data,c),a=t.type||"label",C)for(r=0,s=c.length;r<s;r++)a=t.type||c[r].objtype||"label",n.o[a+"s"]||(n.o[a+"s"]=[]),_&&(c[r]["map-item"]=!1),n.o[a+"s"].push(c[r]);else n.o[a+"s"]||(n.o[a+"s"]=[]),_&&(c["map-item"]=!1),n.o[a+"s"].push(c);f&&(n.OW(),n.QR(_))}t.callback&&"function"==typeof t.callback&&t.callback(t);break;case"removeobject":if(n=g.C8(t.graphid),t["class"]&&(t.cls=t["class"]),n&&(t.id||t.cls||t.group)){a=t.type||"label",A=n.o[a+"s"]||[],l=t.id?"string"==typeof t.id?[t.id]:t.id:[],o=t.cls?"string"==typeof t.cls?[t.cls]:t.cls:[],u=!1;var v=[];for(r=A.length-1;r>=0;r--)(null!==ZC._n_(A[r].id)&&-1!==ZC.AV(l,A[r].id)||null!==ZC._n_(A[r].cls)&&-1!==ZC.AV(o,A[r].cls)||null!==ZC._n_(A[r]["class"])&&-1!==ZC.AV(o,A[r]["class"])||t.group&&A[r].group===t.group)&&(null!==ZC._n_(A[r].id)&&v.push(A[r].id),A.splice(r,1),u=!0);for(r=0;r<v.length;r++)ZC.Q.EU([n.K+"-label-"+v[r]+"-gradient",n.K+"-label-"+v[r]+"-top-gradient",n.K+"-shape-"+v[r]+"-gradient",n.K+"-shape-"+v[r]+"-top-gradient",n.K+"-shape-"+v[r]+"-gshape-gradient",n.K+"-shape-"+v[r]+"-gshape-top-gradient"]);u&&f&&(n.OW(),n.QR(_))}t.callback&&"function"==typeof t.callback&&t.callback(t);break;case"updateobject":if(t["class"]&&(t.cls=t["class"]),(n=g.C8(t.graphid))&&t.data){n.E["objects.updates"]=[],a=t.type||"label",A=n.o[a+"s"]||[],d="label"===a?n.BX:n.FH,c=(C=t.data instanceof Array)?[]:{},ZC._cp_(t.data,c),u=!1;var b=!0,B=function(e,i){var t,l,o,r=n.XA[e.id||""],s=!1;if(r&&("label"===r.shape?(o=n.BX[r.idx],Object.keys&&3===Object.keys(e).length&&null!==ZC._n_(e.x)&&null!==ZC._n_(e.y)&&(o.iX=e.x,o.iY=e.y,s=!0)):((o=n.FH[r.idx]).BG&&o.BG.o["map-item"]&&(b=!1),"circle"===r.shape?Object.keys&&3===Object.keys(e).length&&null!==ZC._n_(e.x)&&null!==ZC._n_(e.y)&&(o.BG?(o.BG.iX=e.x,o.BG.iY=e.y):(o.iX=e.x,o.iY=e.y),s=!0):"line"===r.shape&&Object.keys&&2===Object.keys(e).length&&null!==ZC._n_(e.points)&&(o.BG?o.BG.D=e.points:o.D=e.points,s=!0))),s||n.E["objects.updates"].push(e.id),ZC._cp_(e,i),null!==ZC._n_(e.animation)){var A=null;if("label"===a){for(t=0,l=n.BX.length;t<l;t++)if(n.BX[t].H8===e.id){A=n.BX[t];break}}else if("shape"===a)for(t=0,l=n.FH.length;t<l;t++)if(n.FH[t].H8===e.id){A=n.FH[t]instanceof ZC.OY?n.FH[t].BG:n.FH[t];break}var C=n.LW,c={};if(ZC._cp_(e,c),null!==ZC._n_(c.x)&&(c.x+=n.iX),null!==ZC._n_(c.y)&&(c.y+=n.iY),null!==ZC._n_(c.points))for(t=0,l=c.points.length;t<l;t++)null!==ZC._n_(c.points[t])&&(c.points[t][0]+=n.iX,c.points[t][1]+=n.iY,null!==ZC._n_(c.points[t][2])&&(c.points[t][2]+=n.iX),null!==ZC._n_(c.points[t][3])&&(c.points[t][3]+=n.iY));c.animation=null;var p=new ZC.E4(A,c,ZC._i_(e.animation.speed||"300"),ZC._i_(e.animation.delay||"0"),ZC.E4.RI[ZC._i_(e.animation.method||"0")],function(){null!==ZC._n_(e.animation.end)&&e.animation.end.call()});n.Q5=!0,window.setTimeout(function(){C.add(p)},33)}u=!0};if(C){var m=!1,E=!1;for(r=0,s=c.length;r<s;r++){if(null!==ZC._n_(c[r].objtype)&&(A=n.o[c[r].objtype+"s"]),A)for(p=0,Z=A.length;p<Z;p++)null!==ZC._n_(c[r].id)&&null!==ZC._n_(A[p].id)&&A[p].id===c[r].id&&B(c[r],A[p]);null!==ZC._n_(c[r].animation)?m=!0:E=!0,E&&m&&(ZC.SKIPMAPS=b,n.PW())}}else if(t.group)for(p=0,Z=A.length;p<Z;p++)A[p].group===t.group&&(c.id=A[p].id,B(c,A[p]));else if(t.cls)for(p=0,Z=A.length;p<Z;p++)A[p].cls===t.cls&&(c.id=A[p].id,B(c,A[p]));else for(e=c.id||t.id,p=0,Z=A.length;p<Z;p++)null!==ZC._n_(A[p].id)&&null!==ZC._n_(e)&&A[p].id===e&&(c.id=e,B(c,A[p]));ZC.SKIPMAPS=b,!u||!f&&n.Q5||n.Q5||(n.OW(),n.QR(_))}t.callback&&"function"==typeof t.callback&&t.callback(t);break;case"repaintobjects":(n=g.C8(t.graphid))&&(n.OW(),n.QR(_)),t.callback&&"function"==typeof t.callback&&t.callback(t);break;case"getallobjects":if(l=[],n=g.C8(t.graphid))for(a=t.type||"label",r=0,s=(A=n.o[a+"s"]||[]).length;r<s;r++)null!==ZC._n_(A[r].id)&&l.push(A[r].id);return l;case"getobjectsbyclass":if(t["class"]&&(t.cls=t["class"]),l=[],(n=g.C8(t.graphid))&&t.cls){a=t.type||"label",A=n.o[a+"s"]||[];var D=t.cls instanceof Array?t.cls:[t.cls];for(r=0,s=A.length;r<s;r++)-1===ZC.AV(D,A[r].cls)&&-1===ZC.AV(D,A[r]["class"])||null===ZC._n_(A[r].id)||l.push(A[r].id)}return l;case"getlabelinfo":case"getshapeinfo":var K={x:"iX",y:"iY",width:"I",height:"F",color:"C2",lineColor:"B7",lineWidth:"AZ",borderColor:"BW",borderWidth:"AU",backgroundColor1:"A0",backgroundColor2:"AE",size:"AI",type:"DU",text:"AM",fontSize:"DG",callout:"KP",calloutPosition:"EM",offsetX:"BM",offsetY:"BH"};if(n=g.C8(t.graphid),a=t.type||"label","getlabelinfo"===i&&"label"!==a||"getshapeinfo"===i&&"shape"!==a)return null;if(e=t.id||"",n&&""!==e){d=[],"label"===a?d=n.BX:"shape"===a&&(d=n.FH);var F=null;for(r=0,s=d.length;r<s;r++)d[r].H8===e&&(F=d[r]);if(F){var x={};if("shape"===a){if(F.M)for(h in x.label={},K)x.label[h]=F.M[K[h]];F.BG&&(F=F.BG)}for(h in K)x[h]=F[K[h]];return x}}return null;case"setobjectsmode":zingchart.OBJECTMODE="normal",t.mode&&"flat"===t.mode&&(zingchart.OBJECTMODE="flat");break;case"settweenmode":ZC.objmove=!1,t.mode&&"position"===t.mode&&(ZC.objmove=!0)}return null},ZC.JI.prototype.A2Z=function(){var e,i,t=this,n=0;for(e=0,i=t.BO.length;e<i;e++)"k"===t.BO[e].AF&&t.o[t.BO[e].BE]&&t.o[t.BO[e].BE].values&&(n=ZC.BQ(n,t.o[t.BO[e].BE].values.length));for(e=0,i=t.AY.A4.length;e<i;e++)null!==ZC._n_(t.o.series[e])&&t.o.series[e].values&&(n=ZC.BQ(n,t.o.series[e].values.length));return n},ZC.JI.prototype.U5=function(){var e,i=this;if(i.HP)for(var t=i.A2Z(),n=0,a=i.BO.length;n<a;n++)"k"===i.BO[n].AF&&(i.BO[n].CO?(e=(i.BO[n].F-i.BO[n].AB-i.BO[n].BV)/ZC._i_(i.HP["max-ticks"]),i.BO[n].OK=ZC.BQ(0,i.BO[n].F-t*e)):(e=(i.BO[n].I-i.BO[n].AB-i.BO[n].BV)/ZC._i_(i.HP["max-ticks"]),i.BO[n].OK=ZC.BQ(0,i.BO[n].I-t*e)),ZC._b_(i.HP["adjust-scale"])&&(i.BO[n].OK=0),i.BO[n].AB=i.BO[n].A46+i.BO[n].OK,i.A.E[i.BO[n].BE+"-feed-offset-start"]=i.BO[n].AB,i.BO[n].W=ZC.BQ(0,i.BO[n].A1-i.HP["max-ticks"]+1),i.BO[n].J1())},ZC.JI.prototype.AC2=function(){var s=this,G,MQ,ws;if(s.E["from-api"]&&(window.clearTimeout(ZC.REFRESH_TICK[s.K]),delete s.E["from-api"]),s.HP){var OP=ZC._i_(s.HP.interval);if(OP=OP>=50?OP:1e3*OP,"full"===s.HP.type)"http"===s.HP.transport?ZC.REFRESH_TICK[s.K]=window.setTimeout(function(){s.A.N3(s),ZC.ZJ(function(){s.A.load(s.K,s.A9L)})},OP):"websockets"===s.HP.transport&&ZC.websockets&&(s.H.SA[s.K]?"pull"===s.HP.method&&(ZC.REFRESH_TICK[s.K]=window.setTimeout(function(){s.H.SA[s.K].send("zingchart.getdata")},OP)):(ws=new WebSocket(s.HP.url,"zingchart"),ws.onopen=function(){ws.send("zingchart."+s.HP.type),ws.send("zingchart."+s.HP.method),ws.send("zingchart.getdata")},ws.onmessage=function(e){"ready"===s.MA&&(s.A.N3(s),s.MA="full",ZC.ZJ(function(){zingchart.exec(s.A.K,"setdata",{graphid:s.K,data:e.data,softclear:!0})}))},s.H.SA[s.K]=ws));else if("feed"===s.HP.type&&null!==ZC._n_(s.HP.url)){if(null!==ZC._n_(s.HP.curtain)){var OC=s.BU("k");if(OC.length>0&&(ZC.Q.EU(s.K+"-curtain-t"),OC[0].OK>0)){var LU=new ZC.DN(s);s.A.B8.load(LU.o,"("+s.AF+").refresh.curtain"),LU.append(s.HP.curtain),LU.parse(),LU.AN&&(OC[0].CO&&LU.F<=OC[0].OK||!OC[0].CO&&LU.I<=OC[0].OK)&&(LU.K=s.K+"-curtain-t",LU.IL=ZC.AK(s.A.K+"-text-top"),OC[0].CO?(LU.F>OC[0].OK&&(LU.AM="",LU.parse()),LU.iX=s.P.iX,LU.iY=OC[0].AW?s.P.iY:s.P.iY+s.P.F-OC[0].OK,LU.I=s.P.I,LU.F=OC[0].OK):(LU.I>OC[0].OK&&(LU.AM="",LU.parse()),LU.iX=OC[0].AW?s.P.iX+s.P.I-OC[0].OK:s.P.iX,LU.iY=s.P.iY,LU.I=OC[0].OK,LU.F=s.P.F),LU.Z=LU.C7=ZC.AK(s.K+"-scales-ml-0-c"),LU.paint())}}var A12=s.HP.transport,A45=ZC._i_(s.HP["reset-timeout"]),A5A=ZC._i_(s.HP["stop-timeout"]),A9I=ZC._b_(s.HP.storage),A08=!0;null!==ZC._n_(s.HP["preserve-data"])&&(A08=ZC._b_(s.HP["preserve-data"]));var A4M=function(KC){for(var TP=eval("("+KC+")"),i,A6,A8I=TP instanceof Array?TP:[TP],r=0,rLen=A8I.length;r<rLen;r++){var DL=A8I[r];for(i=0,A6=s.BO.length;i<A6;i++)if("k"===s.BO[i].AF){var BE=s.BO[i].BE;null!==ZC._n_(DL[BE])&&null!==ZC._n_(s.o[BE])&&(null===ZC._n_(s.o[BE].values)&&(s.H.o.graphset[s.L][BE].values=[],s.o[BE].values=[]),s.o[BE].values.push(DL[BE]),!A08&&s.o[BE].values.length>ZC._i_(s.HP["max-ticks"])&&s.o[BE].values.splice(0,1),s.H.o.graphset[s.L][BE].values.push(DL[BE]),(s.o[BE].values.length>A45||1===s.MC[1])&&(s.H.o.graphset[s.L][BE].values=[],s.o[BE].values=[],s.H.E["graph"+s.L+".zoom"]&&(s.H.E["graph"+s.L+".zoom"].xmin=null,s.H.E["graph"+s.L+".zoom"].xmax=null),s.HS&&(s.HS.unbind(),ZC.Q.IU(ZC.AK(s.K+"-scroll-x-c"),s.A.AA,s.iX,s.iY,s.I,s.F,s.K),ZC.A5("#"+s.K+"-scroll-x-handle").remove(),ZC.A5("#"+s.K+"-scroll-x-bar").remove()),s.HQ&&(s.HQ.unbind(),ZC.Q.IU(ZC.AK(s.K+"-scroll-y-c"),s.A.AA,s.iX,s.iY,s.I,s.F,s.K),ZC.A5("#"+s.K+"-scroll-y-handle").remove(),ZC.A5("#"+s.K+"-scroll-y-bar").remove())),ZC.webstorage&&A9I&&ZC.AP.storage.push("zingchart.scale."+s.K+"."+BE,""+DL[BE]))}for(i=0,A6=s.AY.A4.length;i<A6;i++)if(null!==ZC._n_(s.o.series[i])){var A3I=null;null!==ZC._n_(G=DL["plot-"+i])?A3I=G:null!==ZC._n_(G=DL["plot"+i])&&(A3I=G),"xy"===s.AJ.layout||"yx"===s.AJ.layout?(s.H.o.graphset[s.L].series[i].values.push(A3I),!A08&&s.H.o.graphset[s.L].series[i].values.length>ZC._i_(s.HP["max-ticks"])&&s.H.o.graphset[s.L].series[i].values.splice(0,1)):s.H.o.graphset[s.L].series[i].values=[A3I],ZC.webstorage&&A9I&&(G=DL["plot"+i],"object"==typeof G&&(G=G.join("###")),ZC.AP.storage.push("zingchart.plot."+s.K+".plot"+i,""+G)),(s.o.series[i].values.length>A45||1===s.MC[1])&&(ZC.AP.BY("feed_clear",s.A,s.GX(),DL),s.H.o.graphset[s.L].series[i].values=[])}MQ=s.A2Z()}("ready"===s.MA||s.GG)&&(1===s.MC[1]&&(s.MC[1]=0),(MQ<=A5A||0===A5A)&&(s.MA="feed",ZC.ZJ(function(){ZC.AK(s.A.K+"-main")&&(ZC.AP.BY("feed_step",s.H,s.GX(),s.o),s.parse(),s.clear(!0),s.U5(),s.paint(!0,!0))})))};if("http"===A12||"js"===A12){var EA=s.HP.url;ZC.REFRESH_TICK[s.K]=window.setTimeout(function(){if(1===s.MC[0]||1===s.MC[1])if(s.A.N3(s),"http"===A12){var EW=["query-string"===s.A.MZ?"zcrandom="+Math.random():"",zingchart.ZCOUTPUT?"zcoutput="+s.H.AA:""].join("&");ZC.A5.ajax({type:"GET",url:EA,beforeSend:function(e){s.A.RS.data||"http-headers"!==s.A.MZ||e.setRequestHeader("If-Modified-Since","Thu, 01 Jan 1970 00:00:00 GMT")},data:EW,dataType:"text",error:function(){},success:function(e){A4M(e)}})}else if("()"===EA.substring(EA.length-2)||"javascript:"===EA.substring(0,11))try{var EC=EA.replace("javascript:","").replace("()","");eval(EC)&&eval(EC).call(s,function(e){A4M(e)},s.GX())}catch(e){}},OP)}else"websockets"===A12&&ZC.websockets&&(s.H.SA[s.K]?"pull"===s.HP.method&&(ZC.REFRESH_TICK[s.K]=window.setTimeout(function(){s.H.SA[s.K].send("zingchart.getdata")},OP)):(ws=new WebSocket(s.HP.url,"zingchart"),ws.onopen=function(){ws.send("zingchart."+s.HP.type),ws.send("zingchart."+s.HP.method),ws.send("zingchart.startfeed"),"pull"===s.HP.method&&ws.send("zingchart.getdata")},ws.onmessage=function(e){1!==s.MC[0]&&1!==s.MC[1]||A4M(e.data)},s.H.SA[s.K]=ws))}}},zingchart.ABH=function(e,i,t){var n;document.getElementById("zc-fullscreen")&&(e="zc-fullscreen"),"string"==typeof(t=t||{})&&(t=JSON.parse(t));var a=zingchart.getLoader(e);if(a){var l=a.C8(t.graphid);switch(i){case"clearfeed":l.MC[1]=1,0===l.MC[0]&&ZC.ZJ(function(){l.parse(),l.clear(!0),l.U5(),l.paint(!0,!0)});break;case"getinterval":return l.HP.interval;case"setinterval":ZC.AP.BY("feed_interval_modify",a,l.GX()),l.o.refresh=l.o.refresh||{},l.o.refresh.interval=t.interval||1;break;case"stopfeed":1===l.MC[0]&&(ZC.AP.BY("feed_stop",a,l.GX()),l.MC[0]=0,null!==ZC._n_(n=a.SA[l.K])&&n.send("zingchart.stopfeed"));break;case"startfeed":0===l.MC[0]&&(ZC.AP.BY("feed_start",a,l.GX()),l.MC[0]=1,null!==ZC._n_(n=a.SA[l.K])&&n.send("zingchart.startfeed"),ZC.ZJ(function(){l.parse(),l.clear(!0),l.U5(),l.paint(!0,!0)}))}}return null},ZC.AP.A48=function(e){for(var i={},t=[],n=0,a=(t="object"==typeof e?e:JSON.parse(e)).length;n<a;n++)if(null!==ZC._n_(e=t[n])){i["p"+n]={};var l=[];if("object"==typeof e)l=e;else if("string"==typeof e&&/\d+\-\d+/.test(e)){var o=e.split("-");if(2===o.length){l=[];for(var r=ZC._i_(o[0]);r<=ZC._i_(o[1]);r++)l.push(r)}}else l=[e];for(var s=0,A=l.length;s<A;s++)i["p"+n]["n"+l[s]]=!0}return i},ZC.JI.prototype.AC1=function(){var e,i=this;null!==ZC._n_(e=i.o.selection)&&(i.CB=ZC.AP.A48(e),i.o.selection=null)},zingchart.AAL=function(e,i,t){var n,a,l,o,r,s,A,C,c;document.getElementById("zc-fullscreen")&&(e="zc-fullscreen"),"string"==typeof(t=t||{})&&(t=JSON.parse(t));var u=zingchart.getLoader(e);if(u)switch(i){case"clearselection":if(a=u.C8(t.graphid)){for(a.CB={},l=0,o=a.AY.A4.length;l<o;l++)a.IX[l]=!1;a.HH=!0,a.clearPreview(),a.K6(!0,!0)}break;case"getselection":if(a=u.C8(t.graphid)){for(s=[],l=0,o=a.AY.A4.length;l<o;l++)if(s[l]=null,null!==ZC._n_(a.CB["p"+l])){var p=[];for(A in a.CB["p"+l])a.CB["p"+l].hasOwnProperty(A)&&a.CB["p"+l][A]&&p.push(ZC._i_(A.replace("n","")));s[l]=p}return s}return{};case"setselection":var Z={};s=[],null!==ZC._n_(n=t.selection)&&(Z=ZC.AP.A48(n)),(a=u.C8(t.graphid))&&(a.CB=Z,a.HH=!0,a.clearPreview(),a.K6(!0,!0));break;case"select":case"deselect":var h=[],d=function(e){var t=!1;null!==ZC._n_(n=e.toggle)&&(t=ZC._b_(n));var a=u.C8(e.graphid);if(a){for(l=0,o=a.AY.A4.length;l<o;l++)a.IX[l]=!1;var s=null,p=null;if(null!==ZC._n_(n=e.plotindex))if("object"==typeof n)s=n;else if("string"==typeof n&&/\d+\-\d+/.test(n)){if(2===(r=n.split("-")).length)for(s=[],c=ZC._i_(r[0]);c<=ZC._i_(r[1]);c++)s.push(c)}else s=[n];if(null!==ZC._n_(n=e.plotid)){var Z=[];for(Z="object"==typeof n?n:[n],c=0;c<Z.length;c++){var d=a.I0(null,Z[c]);d&&(s||(s=[]),s.push(d.L))}}if(null!==ZC._n_(n=e.nodeindex))if("object"==typeof n)p=n;else if("string"==typeof n&&/\d+\-\d+/.test(n)){if(2===(r=n.split("-")).length)for(p=[],c=ZC._i_(r[0]);c<=ZC._i_(r[1]);c++)p.push(c)}else p=[n];if(null===ZC._n_(s))for(s=[],l=0,o=a.AY.A4.length;l<o;l++)s.push(l);for(l=0,o=s.length;l<o;l++){var f=s[l];if(a.AY.A4[f])if(null===ZC._n_(a.CB["p"+f])&&(a.CB["p"+f]={}),null===ZC._n_(p))for(A=0,C=a.AY.A4[f].S.length;A<C;A++)"select"===i?t&&a.CB["p"+f]["n"+A]?delete a.CB["p"+f]["n"+A]:a.CB["p"+f]["n"+A]=!0:"deselect"===i&&delete a.CB["p"+f]["n"+A];else for(A=0,C=p.length;A<C;A++)"select"===i?t&&a.CB["p"+f]["n"+p[A]]?delete a.CB["p"+f]["n"+p[A]]:a.CB["p"+f]["n"+p[A]]=!0:"deselect"===i&&delete a.CB["p"+f]["n"+p[A]]}-1===ZC.AV(h,a)&&h.push(a)}};if(t instanceof Array)for(c=0;c<t.length;c++)d(t[c]);else d(t);for(c=0;c<h.length;c++)h[c].HH=!0,h[c].clearPreview(),h[c].K6(!0,!0)}return null},ZC.JI.prototype.NX=function(){var e=this;e.AJ["3d"]&&"undefined"!=typeof ZC.AO&&(ZC.AO.A4S=2.5*ZC.BQ(e.I,e.F),ZC.AO.E2=e.P.iX+e.P.I/2,ZC.AO.E3=e.P.iY+e.P.F/2,ZC.AO.FT=ZC._i_(e.F0.depth),ZC.AO.E2+=e.F0["offset-x"],ZC.AO.E3+=e.F0["offset-y"])},ZC.JI.prototype.ADE=function(){var e,i,t=this;if(t.AJ["3d"]&&"undefined"!=typeof ZC.AO){if(t.A.B8.load(t.F0,"graph.3d-aspect"),t.A.B8.load(t.F0,t.AF+".3d-aspect"),null!==ZC._n_(e=t.o["3d-aspect"])&&ZC._cp_(e,t.F0),"pie3d"===t.AF&&t.o.plot&&t.o.plot.tilt){var n=ZC._l_(ZC._f_(t.o.plot.tilt),1,3);t.F0["x-angle"]=25+(n-1)/2*(t.AJ["x-angle-max"]-t.AJ["x-angle-min"])}var a=["angle","depth","x-angle","y-angle","z-angle","zoom","offset-x","offset-y"];for(i=0;i<a.length;i++)t.F0[a[i]]=ZC._f_(t.F0[a[i]]);var l=["angle","x-angle","y-angle","z-angle"];for(i=0;i<l.length;i++)ZC.DS(t.F0[l[i]],t.AJ[l[i]+"-min"],t.AJ[l[i]+"-max"])||(t.F0[l[i]]=t.AJ[l[i]+"-min"]);t.F0.true3d=ZC._b_(t.F0.true3d)}},ZC.JI.prototype.S9=function(){var e,i,t,n,a=this;3!==zingchart.V3D&&(zingchart.V3D=a.F0.true3d?1:2);var l=a.CL.A52.length;for(e=0;e<l;e++)(i=a.CL.A52[e]).ADC(),a.F0.true3d?3===zingchart.V3D?a.CL.WW[e]=[ZC._f_(i.ZS.toFixed(1))*i.MD[2],e]:a.CL.WW[e]=[[ZC._f_(i.SO.toFixed(1))*i.MD[0],ZC._f_(i.A5C.toFixed(1))*i.MD[1],ZC._f_(i.ZS.toFixed(1))*i.MD[2],ZC._f_(i.A20.toFixed(1))],e]:a.CL.WW[e]=[[ZC._f_(i.SO.toFixed(1))*i.MD[0],ZC._f_(i.A4U.toFixed(1))*i.MD[1],ZC._f_(i.A3M.toFixed(1))*i.MD[2],ZC._i_(i.FX)],e];a.CL.WW.sort(a.CL.sortFaces);var o=new ZC.DT(a);for(t=a.H.usc()?a.H.mc():ZC.AK(a.K+"-plots-bl-c"),n=ZC.Q.EB(t,a.H.AA),e=0;e<l;e++){var r=[],s=a.CL.WW[e][1],A=(i=a.CL.A52[s]).D.length;if(A>0){for(var C=0;C<A;C++)r.push(i.D[C].ED);r.push(i.D[0].ED),o.$i(a),o.K=a.K+"-3dshape-"+(""!==i.K?i.K:ZC.SEQ++),o.copy(i.N),o.CZ=!1,o.Z=t,o.locate(1),o.D=r,o.DU="poly",o.locate(2),o.paint()}}var c=[];for(var u in a.CL.SH)c.push([u,a.CL.SH[u].zIndex]);c.sort(function(e,i){return i[1]-e[1]});for(var p=0;p<c.length;p++){var Z=a.CL.SH[c[p][0]];ZC.CR.setup(n,Z.style),ZC.CR.paint(n,Z.style,Z.points)}},ZC.JI.prototype.UD=function(){if(!zingchart.SKIP.LEGEND){var e,i=this;if(i.BD){if(i.BD.PQ&&i.L!==i.A.AG.length-1&&!i.BD.o.force)return;i.BD.Z=i.BD.C7=i.H.usc()?i.H.mc("top"):ZC.AK(i.K+"-legend-c"),i.BD.paint(),-1===ZC.AV(i.H.KR,"skip_interactivity")&&(i.QQ=function(e){var t,n;if(!ZC.move){i.A7&&i.A.A7&&i.A7.AN&&i.A.A7.onmouseover(e);var a=e.targetid||e.target.id,l=ZC._i_(a.replace(i.K,"").replace("-legend-item_","").replace("-legend-marker_","").replace("-area","").replace("-marker","")),o=i.AY.A4[l];if(o.FY&&(i.BD.WJ||o.IA)&&o.S.length)for(t=0,n=o.S.length;t<n;t++)if(null!==o.S[t]&&o.S[t].JD&&(o.FK(t).A0W("highlight"),i.BD.PQ))for(var r=0;r<i.A.AG.length;r++)if(i.A.AG[r].BD&&i.A.AG[r].BD.PQ&&i.A.AG[r].AY.A4[o.L]){var s=i.A.AG[r].AY.A4[o.L];s.FK(t)&&s.FK(t).A0W("highlight")}ZC.move=!0;var A=o.L;o.o["legend-item"]&&null!==ZC._n_(o.o["legend-item"].order)&&(A=ZC._i_(o.o["legend-item"].order)),i.BD.o["reverse-series"]&&(A=i.AY.A4.length-1-A),i.BD.highlightItem(A),ZC.move=!1;var C=i.AY.A4[l].UW(e);i.E["legend-action-index"]=l,ZC.AP.BY("legend_mouseover",i.A,C)}},i.PN=function(e){ZC.move||i.A7&&i.A.A7&&i.A7.AN&&i.A.A7.onmousemove(e)},i.R9=function(e){if(!ZC.move){if(i.A7&&i.A.A7&&i.A7.AN&&i.A.A7.onmouseout(e),i.LD(),i.BD.PQ)for(var t=0;t<i.A.AG.length;t++)i.A.AG[t].BD&&i.A.AG[t].BD.PQ&&i.A.AG[t].LD();ZC.move=!0,i.BD.highlightItem(-1),ZC.move=!1;var n=ZC._c_(i.E["legend-action-index"],0),a=i.AY.A4[n].UW(e);ZC.AP.BY("legend_mouseout",i.A,a)}},i.zc_legend_mousescroll=function(e){i.BD.D2&&"scroll-y"===i.BD.D2.AF&&(e.preventDefault(),i.BD.D2.A3V(e))},i.SP=function(t){if(i.E.legend_toggle_action=!0,!(ZC.move||(zingchart.SB(t),t.which>1))){var n,a,l,o=t.targetid||t.target.id,r=ZC._b_(i.BD.BR.o.reorder);ZC.mobile&&i.H.A7&&i.H.A7.hide();var s="item";-1!==o.indexOf("-legend-marker_")&&(s="marker"),i.LD(),t.preventDefault();var A=i.BD.IJ;"item"===s?A=i.BD.R1:"marker"===s&&(A=i.BD.PP),i.A.K9&&(A="remove"),i.E["legend-last-trigger"]=s;var C=ZC._i_(o.replace(i.K+"-legend-item_","").replace(i.K+"-legend-marker_","").replace("-area",""));if(i.o.series&&i.o.series[C]){if(null!==ZC._n_(e=i.o.series[C]["legend-item"])){var c=e.url||"",u=e.target||"";""!==c&&i.UZ(t,c,u)}i.o.series[C].visible=!0}var p,Z,h,d=i.AY.A4[C].UW(t);switch(d.visible=ZC._b_(i.E["plot"+C+".visible"]),ZC.AP.BY("legend_click",i.A,d),ZC.AP.BY("legend_"+s+"_click",i.A,d),A){default:break;case"hide":case"remove":if(t.shiftKey){var f=0;for(n=0,a=i.AY.A4.length;n<a;n++)if(n!==C&&(l=++f===a-1,i.QC({"ignore-legend":r,K6:l,plotindex:n,"toggle-action":A}),i.BD.PQ))for(p=0,Z=i.H.AG.length;p<Z;p++)(h=i.H.AG[p]).BD&&h.BD.PQ&&h.BD.A4I===i.BD.A4I&&h.K!==i.K&&h.QC({"ignore-legend":!0,K6:l,plotindex:n,"toggle-action":A})}else if(i.QC({"ignore-legend":r,K6:1,plotindex:C,"toggle-action":A}),i.BD.PQ)for(p=0,Z=i.H.AG.length;p<Z;p++)(h=i.H.AG[p]).BD&&h.BD.PQ&&h.BD.A4I===i.BD.A4I&&h.K!==i.K&&h.QC({"ignore-legend":!0,K6:1,plotindex:C,"toggle-action":A})}"hide"===A&&i.E.hooks&&(i.OW(),i.QR())}},ZC.A5("."+i.K+"-legend-item-area").live("mouseup touchstart",i.SP).live("DOMMouseScroll",i.zc_legend_mousescroll).live("mousewheel",i.zc_legend_mousescroll),ZC.A5("."+i.K+"-legend-marker-area").live("mouseup touchstart",i.SP).live("DOMMouseScroll",i.zc_legend_mousescroll).live("mousewheel",i.zc_legend_mousescroll),ZC.A5("#"+i.K+"-legend-frame").live("DOMMouseScroll",i.zc_legend_mousescroll).live("mousewheel",i.zc_legend_mousescroll),ZC.mobile||(ZC.A5("."+i.K+"-legend-item-area").live(ZC.Q.BZ("mouseover"),i.QQ).live(ZC.Q.BZ("mouseout"),i.R9).live(ZC.Q.BZ("mousemove"),i.PN),ZC.A5("."+i.K+"-legend-marker-area").live(ZC.Q.BZ("mouseover"),i.QQ).live(ZC.Q.BZ("mouseout"),i.R9).live(ZC.Q.BZ("mousemove"),i.PN)))}}},ZC.AAJ=ZC.JI.CA({$i:function(e){this.b(e);var i=this;i.AF="null",i.AJ.clip=!0,i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0}}),ZC.A8M=ZC.JI.CA({$i:function(e){this.b(e);var i=this;i.AF="null3d",i.CL=new ZC.SJ,i.AJ["3d"]=!0,i.AJ["x-angle-min"]=-1800,i.AJ["x-angle-max"]=1800,i.AJ["y-angle-min"]=-1800,i.AJ["y-angle-max"]=1800,i.AJ["z-angle-min"]=-1800,i.AJ["z-angle-max"]=1800,zingchart.V3D=3},clear:function(){this.b(),this.CL.clear()},paint:function(){var e=this;e.b(),e.PW(),e.S9(),e.flatten(),e.KK(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.NI=ZC.JI.CA({$i:function(e){this.b(e);var i=this;i.AF="xy",i.AJ.clip=!0,i.AJ.layout="xy"},MO:function(e){switch(e){case"x":return new ZC.Q6(this);case"y":return new ZC.Q3(this)}},ACN:function(){var e,i=this,t=i.MO("x","scale-x");for(t.BE="scale-x",t.K=i.K+"-scale-x",i.BO.push(t),e=2;e<50;e++)if(null!==ZC._n_(i.o["scale-x-"+e])){var n=i.MO("x","scale-x-"+e);n.L=e,n.BE="scale-x-"+e,n.K=i.K+"-scale-x-"+e,i.BO.push(n)}var a=i.MO("y","scale-y");for(a.BE="scale-y",a.K=i.K+"-scale-y",i.BO.push(a),e=2;e<50;e++)if(null!==ZC._n_(i.o["scale-y-"+e])){var l=i.MO("y","scale-y-"+e);l.L=e,l.BE="scale-y-"+e,l.K=i.K+"-scale-y-"+e,i.BO.push(l)}i.b()}}),ZC.A66=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="line",i.AY=new ZC.A40(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0}}),ZC.A5Z=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="area",i.AY=new ZC.A3Z(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0}}),ZC.A9C=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="vline",i.AJ.layout="yx",i.AY=new ZC.A7L(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0},MO:function(e){switch(e){case"x":return new ZC.SU(this);case"y":return new ZC.SR(this)}}}),ZC.A9A=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="varea",i.AJ.layout="yx",i.AY=new ZC.A7N(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0},MO:function(e){switch(e){case"x":return new ZC.SU(this);case"y":return new ZC.SR(this)}}}),ZC.A2N=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="vbar",i.AY=new ZC.A09(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0},MO:function(e,i){switch(e){case"x":var t=this.b(e,i);return t.DJ=!0,t;case"y":return this.b(e,i)}}}),ZC.A2G=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="hbar",i.AJ.layout="yx",i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0,i.AY=new ZC.A0H(i)},MO:function(e){switch(e){case"x":var i=new ZC.SU(this);return i.DJ=!0,i;case"y":return new ZC.SR(this)}}}),ZC.A58=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="mixed",i.AY=new ZC.ZE(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0},MO:function(e,i){switch(e){case"x":var t=!1;if(this.o.series)for(var n=0;n<this.o.series.length;n++)if(this.o.series[n]&&this.o.series[n].type&&-1!==ZC.AV(["bar","vbar","bullet","vbullet","stock","vbar3d"],this.o.series[n].type)){var a=(this.o.series[n].scales||"scale-x,scale-y").split(",");-1!==ZC.AV(a,i)&&(t=!0)}var l=this.b(e,i);return l.DJ=t,l;case"y":return this.b(e,i)}}}),ZC.A8Q=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="hmixed",i.AJ.layout="yx",i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!1,i.AJ["enable-scroll"]=!0,i.AY=new ZC.ZE(i)},MO:function(e,i){switch(e){case"x":var t=new ZC.SU(this),n=!1;if(this.o.series)for(var a=0;a<this.o.series.length;a++)if(this.o.series[a]&&this.o.series[a].type&&-1!==ZC.AV(["hbar","hbullet"],this.o.series[a].type)){var l=(this.o.series[a].scales||"scale-x,scale-y").split(",");-1!==ZC.AV(l,i)&&(n=!0)}return t.DJ=n,t;case"y":return new ZC.SR(this)}}}),ZC.A31=ZC.A58.CA({$i:function(e){this.b(e);var i=this;i.AF="mixed3d",i.AY=new ZC.ZE(i),i.CL=new ZC.SJ,i.AJ["3d"]=!0,i.AJ["enable-preview"]=!1,i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0},clear:function(){this.b(),this.CL.clear()},paint:function(){var e=this;e.b(),e.S9(),e.flatten(),e.PW(),e.FA.length&&(e.CL.clear(),e.KK(),e.S9()),e.UD(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.A89=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="scatter",i.AY=new ZC.A6N(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0}}),ZC.A7F=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="hscatter",i.AJ.layout="yx",i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!1,i.AJ["enable-scroll"]=!0,i.AY=new ZC.A5S(i)},MO:function(e){switch(e){case"x":return new ZC.SU(this);case"y":return new ZC.SR(this)}}}),ZC.A8W=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="bubble",i.AY=new ZC.A77(i),i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-scroll"]=!0}}),ZC.A84=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="hbubble",i.AJ.layout="yx",i.AJ["enable-guide"]=!0,i.AJ["enable-preview"]=!1,i.AJ["enable-scroll"]=!0,i.AY=new ZC.A6R(i)},MO:function(e){switch(e){case"x":return new ZC.SU(this);case"y":return new ZC.SR(this)}}}),ZC.A3U=ZC.JI.CA({$i:function(e){this.b(e),this.AF="pie",this.AY=new ZC.A4Q(this)},A2P:function(){return""},MO:function(e){switch(e){case"m":return new ZC.T2(this);case"v":return new ZC.VQ(this);case"r":return new ZC.A2B(this)}},ACN:function(){var e=this,i=e.MO("m","scale"),t=e.MO("v","scale-v"),n=e.MO("r","scale-r");i.BE="scale",i.K=e.K+"-scale",e.o.series&&e.o.series.length&&e.o.series[0].values&&(i.NF="1x"+e.o.series[0].values.length),t.BE="scale-v",t.K=e.K+"-scale-v",n.BE="scale-r",n.K=e.K+"-scale-r",e.BO.push(i,t,n),e.b()},clear_:function(){-1!==ZC.AV(["svg","vml"],this.H.AA)&&ZC.A5("#"+this.K+" .zc-layer").each(function(){/\-plot-\d+\-bl\-\d+\-/.test(this.id)&&ZC.A5(this).children().each(function(){/\-connector\-path/.test(this.id)&&ZC.Q.EU(this)})})}}),ZC.A6K=ZC.JI.CA({$i:function(e){this.b(e);var i=this;i.AF="nestedpie",i.AY=new ZC.A4R(i)},A2P:function(){return""},MO:function(e){switch(e){case"m":return new ZC.T2(this)}},ACN:function(){var e=this,i=e.MO("m","scale");i.BE="scale",i.K=e.K+"-scale",e.BO.push(i),e.b()}}),ZC.A9Q=ZC.JI.CA({$i:function(e){this.b(e);var i=this;if(i.AF="radar",i.AJ.layout="radar",i.AY=new ZC.A8C(i),-1!==ZC.AV(i.A.K,"polar")){for(var t=1,n=0;n<i.A.M9.series.length;n++)t=ZC.BQ(t,i.A.M9.series[n].values.length);t=Math.round(360/t).toString(),null===ZC._n_(i.A.M9.plot)?i.A.M9.plot={aspect:"area"}:ZC._cp_({aspect:"area"},i.A.M9.plot),null===ZC._n_(i.A.M9["scale-k"])?i.A.M9["scale-k"]={aspect:"circle",format:"%v\xb0",values:"0:330:"+t}:ZC._cp_({aspect:"circle",format:"%v\xb0",values:"0:330:"+t},i.A.M9["scale-k"],!0)}},A2P:function(){return""},MO:function(e){var i=this;switch(e){case"m":return new ZC.T2(i);case"k":return new ZC.ZL(i);case"v":return new ZC.ZK(i)}},ACN:function(){var e=this,i=e.MO("k","scale-k");i.BE="scale-k",i.K=e.K+"-scale-k",e.BO.push(i);var t=e.MO("v","scale-v");t.BE="scale-v",t.K=e.K+"-scale-v",e.BO.push(t);var n=e.MO("m","scale");n.BE="scale",n.K=e.K+"-scale",e.BO.push(n),e.b()}}),ZC.A80=ZC.A2N.CA({$i:function(e){this.b(e);var i=this;i.AF="vbullet",i.AY=new ZC.A6O(i),i.AJ["enable-animation"]=!1}}),ZC.A82=ZC.A2G.CA({$i:function(e){this.b(e);var i=this;i.AF="hbullet",i.AJ.layout="yx",i.AY=new ZC.A6M(i),i.AJ["enable-animation"]=!1}}),ZC.A99=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="piano",i.AY=new ZC.A7P(i),i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0},ABG:function(e){var i=this;if("v"===e){var t=[];if(i.o.series&&i.o.series.length)for(var n=0;n<i.o.series.length;n++)t.push(i.o.series[n].text||"Metric "+(n+1));return t}},MO:function(e){switch(e){case"x":var i=new ZC.Q6(this);return i.DJ=!0,i;case"y":var t=new ZC.Q3(this);return t.DJ=!0,t.append({step:1,"fixed-step":!0}),t}}}),ZC.A88=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="vfunnel",i.AY=new ZC.A6G(i),i.AJ["enable-animation"]=!1,i.AJ["enable-zooming"]=!1,i.AJ["enable-scroll"]=!1},MO:function(e,i){switch(e){case"x":var t=this.b(e,i);return t.DJ=!0,t;case"y":var n=this.b(e,i);return n.DJ=!0,n}},ABG:function(e){if("v"===e){for(var i=[],t=0;t<this.o.series.length;t++)i.push("Step "+(t+1));return i}},paint:function(){for(var e=this,i=0,t=e.BO.length;i<t;i++)"v"===e.BO[i].AF&&(e.BO[i].AW=!e.BO[i].AW);e.b()}}),ZC.A86=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="hfunnel",i.AY=new ZC.A6F(i),i.AJ["enable-animation"]=!1,i.AJ["enable-zooming"]=!1,i.AJ["enable-scroll"]=!1},ABG:function(e){if("v"===e){for(var i=[],t=0;t<this.o.series.length;t++)i.push("Step "+(t+1));return i}},MO:function(e){switch(e){case"x":var i=new ZC.SU(this);return i.DJ=!0,i;case"y":var t=new ZC.SR(this);return t.DJ=!0,t}}}),ZC.A9X=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="stock",i.AY=new ZC.A7Y(i),i.AJ["enable-guide"]=!0,i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0,i.AJ["enable-preview"]=!0},MO:function(e,i){switch(e){case"x":var t=this.b(e,i);return t.DJ=!0,t;case"y":return this.b(e,i)}}}),ZC.AA1=ZC.JI.CA({$i:function(e){this.b(e);var i=this;i.AF="gauge",i.AJ.layout="gauge",i.AY=new ZC.A7T(i)},A2P:function(){return""},MO:function(e){var i=this;switch(e){case"m":return new ZC.T2(i);case"r":return new ZC.A7Z(i);case"v":return new ZC.VQ(i)}},ACN:function(){var e,i=this,t=i.MO("m","scale");for(t.BE="scale",t.K=i.K+"-scale",i.BO.push(t),e=2;e<10;e++)if(null!==ZC._n_(i.o["scale-"+e])){var n=i.MO("m","scale-"+e);n.L=e,n.BE="scale-"+e,n.K=i.K+"-scale-"+e,i.BO.push(n)}var a=i.MO("r","scale-r");for(a.BE="scale-r",a.K=i.K+"-scale-r",i.BO.push(a),e=2;e<10;e++)if(null!==ZC._n_(i.o["scale-r-"+e])){var l=i.MO("r","scale-r-"+e);l.L=e,l.BE="scale-r-"+e,l.K=i.K+"-scale-r-"+e,i.BO.push(l)}i.b()},hideLayer_:function(){var e=this;ZC.A5("#"+e.K+"-plots-bl-2").children().each(function(){ZC.Q.IU(this,e.H.AA,e.iX,e.iY,e.I,e.F,e.K)})}}),ZC.A9N=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="range",i.AY=new ZC.A7J(i),i.AJ["enable-guide"]=!0,i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0,i.AJ["enable-preview"]=!0}}),ZC.ZCVRangeGraph=ZC.NI.CA({$i:function(e){this.b(e);var i=this;i.AF="range",i.AJ.layout="yx",i.AY=new ZC.ZCVRangePlotSet(i),i.AJ["enable-guide"]=!0,i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0,i.AJ["enable-preview"]=!1},MO:function(e){switch(e){case"x":return new ZC.SU(this);case"y":return new ZC.SR(this)}}}),ZC.A5G=ZC.A3U.CA({$i:function(e){this.b(e);var i=this;i.AF="pie3d",i.AY=new ZC.A7V(i),i.CL=new ZC.SJ,i.AJ["3d"]=!0,i.AJ["enable-animation"]=!1,i.AJ["x-angle-min"]=15,i.AJ["x-angle-max"]=75,i.AJ["y-angle-min"]=0,i.AJ["y-angle-max"]=0,i.AJ["z-angle-min"]=0,i.AJ["z-angle-max"]=0},clear:function(){this.b(),this.CL.clear()},paint:function(){var e=this;e.b(),e.S9(),e.flatten(),e.PW(),e.FA.length&&(e.CL.clear(),e.KK(),e.S9()),e.UD(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.A8T=ZC.A2G.CA({$i:function(e){this.b(e);var i=this;i.AF="hbar3d",i.AY=new ZC.A7A(i),i.CL=new ZC.SJ,i.AJ["3d"]=!0,i.AJ["enable-preview"]=!1,i.AJ["enable-animation"]=!1,i.AJ["x-angle-min"]=-20,i.AJ["x-angle-max"]=20,i.AJ["y-angle-min"]=-20,i.AJ["y-angle-max"]=0},clear:function(){this.b(),this.CL.clear()},paint:function(){var e=this;e.b(),e.S9(),e.flatten(),e.PW(),e.FA.length&&(e.CL.clear(),e.KK(),e.S9()),e.UD(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.A90=ZC.A2N.CA({$i:function(e){this.b(e);var i=this;i.AF="vbar3d",i.AY=new ZC.A7D(i),i.CL=new ZC.SJ,i.AJ["3d"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0},clear:function(e,i){this.b(e,i),this.CL.clear()},paint:function(){var e=this;e.b(),e.S9(),e.flatten(),e.PW(),e.FA.length&&(e.CL.clear(),e.KK(),e.S9()),e.UD(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.A8R=ZC.A66.CA({$i:function(e){this.b(e);var i=this;i.AF="line3d",i.AY=new ZC.A6Z(i),i.CL=new ZC.SJ,i.AJ["3d"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0},clear:function(e,i){this.b(e,i),this.CL.clear()},paint:function(){var e=this;e.b(),e.S9(),e.flatten(),e.PW(),e.FA.length&&(e.CL.clear(),e.KK(),e.S9()),e.UD(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.A8Z=ZC.A5Z.CA({$i:function(e){this.b(e);var i=this;i.AF="area3d",i.AY=new ZC.A75(i),i.CL=new ZC.SJ,i.AJ["3d"]=!0,i.AJ["enable-preview"]=!0,i.AJ["enable-animation"]=!1,i.AJ["enable-scroll"]=!0},clear:function(e,i){this.b(e,i),this.CL.clear()},paint:function(){var e=this;e.b(),e.S9(),e.flatten(),e.PW(),e.FA.length&&(e.CL.clear(),e.KK(),e.S9()),e.UD(),-1===ZC.AV(e.H.KR,"skip_interactivity")&&e.S0()}}),ZC.AAK=ZC.JI.CA({$i:function(e){this.b(e);var i=this;i.AF="venn",i.AY=new ZC.A8U(i)},A2P:function(){return""},MO:function(e){switch(e){case"m":return new ZC.T2(this)}},parse:function(){var e=this;e.b(),e.BD&&(e.BD.IJ="remove",e.BD.R1="remove",e.BD.PP="remove")},ACN:function(){var e=this,i=e.MO("m","scale");i.BE="scale",i.K=e.K+"-scale",e.BO.push(i),e.b()}}),ZC.LJ=ZC.HL.CA({$i:function(e){this.b(e);var i=this;i.C=e,i.H=i.C.A,i.A4=[],i.HE=null,i.KB=[],i.K3=[],i.PU=!0,i.F8=null,i.A4X=!0,i.YZ=[]},ACW:function(){return new ZC.HV(this)},parse:function(){var e,i,t,n=this;for(n.K=n.A.K+"-plotset",n.F8=null,i=n.o.length-1;i>=0;i--)"undefined"==typeof n.o[i]&&n.o.splice(i,1);if(null===ZC._n_(n.E["plot-sort"])&&(n.E["plot-sort"]=!1),n.o.length>1){for(i=0,t=n.o.length;i<t;i++)"undefined"==typeof n.o[i].palette&&(n.o[i].palette=i);var a=[],l=[];for(i=0,t=n.o.length;i<t;i++)l[i]=i,a[i]={"z-index":n.o[i]["z-index"]||0};for(var o=!1;!o;)for(o=!0,i=0,t=a.length;i<t-1;i++){if(a[i]["z-index"]>a[i+1]["z-index"]){n.E["plot-sort"]=!0;var r=a[i];a[i]=a[i+1],a[i+1]=r;var s=l[i];l[i]=l[i+1],l[i+1]=s,o=!1}}n.M2=l}else n.M2=[0];for(n.A4=[],i=0,t=n.o.length;i<t;i++){var A="";n.A.o.plot&&null!==ZC._n_(e=n.A.o.plot.type)&&(A=e),null!==ZC._n_(e=n.o[i].type)&&(A=e);var C=n.ACW(A,i);C.OG=C.AF+"plot",C.L=i,C.JR=i,n.C.A.B8.load(C.o,["("+C.AF+").plot"]),C.sTypeX&&n.C.A.B8.load(C.o,["("+C.sTypeX+").plot"]),n.C.A.B8.load(C.o,["("+C.AF+").plot.animation"]),null!==ZC._n_(e=n.A.o.plot)&&C.append(e),C.append(n.o[i]),C.CC=n.A.CC,C.parse(),n.A4.push(C)}var c={},u=[],p=[],Z={},h={},d=0,f=0;for(i=0,t=n.A4.length;i<t;i++)if(null!==ZC._n_(n.A.A.E["g-"+n.A.L+"-p-"+i+".visible"])&&(n.C.E["plot"+i+".visible"]=n.A.A.E["g-"+n.A.L+"-p-"+i+".visible"]),!n.A4[i].HM&&(n.C.E["plot"+i+".visible"]||"hide"===n.C.getToggleAction())){n.A4[i].CC?(-1===(f=ZC.AV(p,n.A4[i].DZ))&&(p.push(n.A4[i].DZ),f=p.length-1),null===ZC._n_(u[f])?u[f]=[i]:u[f].push(i)):(p.push(-1),f=p.length-1,null===ZC._n_(u[f])?u[f]=[i]:u[f].push(i));var _=n.A4[i].AF;if(n.A4[i].o.type&&_!==n.A4[i].o.type){var g=_.indexOf("3d"),v=n.A4[i].o.type.indexOf("3d");(-1===g&&-1!==v||-1===g&&-1===v)&&(_=n.A4[i].o.type)}-1!==ZC.AV(["bar","bar3d","bullet"],_)&&(_="v"+_),-1===ZC.AV(["vbar","hbar","vbullet","hbullet","stock","vbar3d","hbar3d"],_)||n.A4[i].HM||(null===ZC._n_(Z[_])&&(Z[_]=[]),null===ZC._n_(h[_])&&(h[_]=[]),n.A4[i].CC?(null===ZC._n_(c[n.A4[i].DZ])?c[n.A4[i].DZ]=1:c[n.A4[i].DZ]++,-1===(d=ZC.AV(h[_],n.A4[i].DZ))&&(h[_].push(n.A4[i].DZ),d=h[_].length-1),null===ZC._n_(Z[_][d])?Z[_][d]=[i]:Z[_][d].push(i)):(h[_].push(-1),d=h[_].length-1,null===ZC._n_(Z[_][d])?Z[_][d]=[i]:Z[_][d].push(i)))}if(n.KB=u,n.K3=Z,n.WM)for(var b in n.WM)n.WM[b].sort();for(n.A1C=[],i=0;i<n.KB.length;i++)n.A1C.push(n.KB[i][n.KB[i].length-1])},paint:function(){var e=this;function i(t){var n=e.M2[t];(e.A4[n].HT||e.A4[n].E7.length&&e.A.B9||"none"!==e.A4[n].IZ)&&(e.H.O7=!1),e.A4X=!0;var a=e.C.getToggleAction();e.A4[n].o["skip-paint"]||(e.C.AJ["3d"]?e.C.E["plot"+n+".visible"]&&(e.A4[n].paint(),e.H.ZV()):(e.C.E["plot"+n+".visible"]||"hide"===a)&&("undefined"!=typeof e.C.E["plot-"+n+"-first-run"]&&(e.A4[n].TL=0),e.A4[n].paint(),e.A4[n].TL=0,e.H.ZV(),e.C.E["plot"+n+".visible"]||"hide"!==a||(e.C.E["plot"+n+".visible"]=!0,e.A.QC({plotindex:n,"ignore-legend":!0})))),e.C.E["plot-"+n+"-first-run"]=!1,t<e.A4.length-1?e.C.LK?ZC.ASYNC_TICK[e.C.K]=window.setTimeout(function(){i(t+1)},10):e.A4.length<=100&&i(t+1):(!e.C.LK||e.C.LK&&e.A4X)&&e._end_()}if(e.HE=[],e.A4.length>0)if(e.A4.length>100&&!e.C.LK)for(var t=0;t<e.A4.length;t++)i(t);else i(0);else e._end_()},_end_:function(){var e,i=this;i.RU=null,i.VJ=null;for(var t=0;t<i.C.BO.length;t++)i.C.BO[t].ET=null,i.C.BO[t].WK=null;function n(e){var t=0,n=e.indexOf("-plotset-plot-"),a=e.indexOf("-node-",n);return-1!==n&&-1!==a&&(t=e.substr(n+14,a-n-14)),"undefined"!=typeof i.A4[t].E["z-mid"]?i.A4[t].E["z-mid"]:t}if((e=ZC.AK(i.C.A.K+"-map"))&&!i.H.A19){-1===ZC.AV(["bubble","hbubble","vbullet","hbullet","radar","vbar3d","hbar3d","mixed","mixed3d","pie3d","hmixed","hmixed3d"],i.C.AF)&&1!==zingchart.SORTTRACKERS||i.HE.sort(function(e,t){return"pie3d"===i.C.AF?ZC.AP.N2(e)>ZC.AP.N2(t)?1:ZC.AP.N2(e)<ZC.AP.N2(t)?-1:0:n(e)>n(t)&&i.A.AJ["3d"]?1:n(e)<n(t)&&i.A.AJ["3d"]?-1:ZC.AP.N2(e)>ZC.AP.N2(t)?1:ZC.AP.N2(e)<ZC.AP.N2(t)?-1:0});var a='<area shape="rect" coords="0,0,1,1" id="mark'+i.A.L+'">',l=i.A.a11y(),o=e.innerHTML.indexOf(a);zingchart.DEV.DELAYEDTRACKERS?window.setTimeout(function(){-1!==o?e.innerHTML=e.innerHTML.substring(0,o+a.length)+l+i.HE.join("")+e.innerHTML.substring(o+a.length):e.innerHTML+=l+i.HE.join("")},500):-1!==o?e.innerHTML=e.innerHTML.substring(0,o+a.length)+l+i.HE.join("")+e.innerHTML.substring(o+a.length):e.innerHTML+=l+i.HE.join("")}i.F1=null,i.D6=null,i.C.A9W=[],i.A._end_()}}),ZC.A40=ZC.LJ.CA({ACW:function(){return new ZC.QK(this)}}),ZC.A3Z=ZC.LJ.CA({ACW:function(){return new ZC.QV(this)}}),ZC.A7L=ZC.LJ.CA({ACW:function(){var e=new ZC.QK(this);return e.O6=!0,e}}),ZC.A7N=ZC.LJ.CA({ACW:function(){var e=new ZC.QV(this);return e.O6=!0,e}}),ZC.A09=ZC.LJ.CA({ACW:function(){return new ZC.QY(this)}}),ZC.A0H=ZC.LJ.CA({ACW:function(){return new ZC.R0(this)}}),ZC.ZE=ZC.LJ.CA({ACW:function(e){var i=this;switch(e){default:return new ZC.QK(i);case"vline":var t=new ZC.QK(i);return t.O6=!0,t;case"poly":var n=new ZC.P7(i);return n.bPoly=!0,n.sTypeX="poly",n;case"area":return new ZC.QV(i);case"varea":var a=new ZC.QV(i);return a.O6=!0,a;case"bar":case"vbar":return new ZC.QY(i);case"hbar":return new ZC.R0(i);case"scatter":return new ZC.P7(i);case"hscatter":return new ZC.P7(i,"hscatter");case"bubble":return new ZC.RZ(i);case"hbubble":return new ZC.RZ(i,"hbubble");case"stock":return new ZC.VB(i);case"range":return new ZC.SQ(i);case"vrange":var l=new ZC.SQ(i);return l.O6=!0,l;case"line3d":return new ZC.UC(i);case"area3d":return new ZC.UB(i);case"bar3d":case"vbar3d":return new ZC.UE(i);case"bullet":case"vbullet":return new ZC.TC(i);case"hbullet":return new ZC.TF(i)}}}),ZC.A6N=ZC.LJ.CA({ACW:function(){return new ZC.P7(this)}}),ZC.ACG=ZC.LJ.CA({ACW:function(){var e=new ZC.P7(this);return e.bPoly=!0,e.sTypeX="poly",e}}),ZC.A5S=ZC.LJ.CA({ACW:function(){return new ZC.P7(this,"hscatter")}}),ZC.A77=ZC.LJ.CA({ACW:function(){return new ZC.RZ(this)}}),ZC.A6R=ZC.LJ.CA({ACW:function(){return new ZC.RZ(this,"hbubble")}}),ZC.A4Q=ZC.LJ.CA({$i:function(e){this.b(e);var i=this;i.KM=[],i.P4=[],i.TS=[]},ACW:function(){return new ZC.VV(this)},parseLayout:function(e){var i,t,n,a,l=this;e&&(l.TS=[],l.P4=[]);var o,r=l.A.BL("scale-r"),s=l.A.BL("scale"),A=.9,C=1;l.A4.length>=10&&(C=1),l.A4.length>=20&&(C=1.25),l.A4.length>=30&&(C=1.5);var c=r.DH;for(i=0,t=l.A4.length;i<t;i++)null!==ZC._n_(l.A4[i].o["ref-angle"])&&(c=l.A4[i].DH);for(i=0,t=l.A4.length;i<t;i++)if(l.C.E["plot"+i+".visible"]||"hide"===l.C.getToggleAction())for(var u=0,p=l.A4[i].S.length;u<p;u++)if(l.A4[i].S[u]){l.YE["n"+u]=l.YE["n"+u]||[];var Z,h,d=l.A4[i].S[u];null===ZC._n_(l.P4[u])&&(l.P4[u]=c),Z=null!==ZC._n_(a=l.A4[i].o["angle-start"])?ZC._f_(a):l.P4[u],h=l.KM[u],null!==ZC._n_(l.A4[i].o.totals)&&null!==ZC._n_(l.A4[i].o.totals[u])&&(h=l.KM[u]=ZC._f_(l.A4[i].o.totals[u])),n=0===h?Z+r.EI*(1/t):0===d.AD&&l.A4[i].TI?Z+r.EI*(.005*l.KM[u])/h:Z+r.EI*d.AD/h,l.P4[u]=n,d.B4=Z,d.BK=n;var f=d.GW(!0);if("out"===f.o.placement&&f.AN){var _=ZC._i_((Z+n)/2);l.YE["n"+u][i]=_-c,o=ZC.CY(s.I/2-C*f.I-f.DV-35,s.F/2-C*f.F-f.DV-15),A=ZC.CY(A,2*o/ZC.CY(s.I,s.F))}}if("pie3d"===l.A.AF&&(A*=.75),A=ZC.BQ(.1,ZC.CY(.9,A)),"auto"===s.o["size-factor"]&&(s.JE=A),e)for(var g in l.YE)l.YE[g]=ZC.AQ.ACI(l.YE[g],c)},parse:function(){var e=this;e.A.o.plot&&"auto"===e.A.o.plot.layout&&(null===ZC._n_(e.A.o.plot["ref-angle"])&&(e.A.o.plot["ref-angle"]=-90),e.o.sort(function(e,i){return i.values[0]-e.values[0]})),e.TS=[],e.KM=[],e.P4=[],e.YE={},e.b();for(var i=0,t=e.A4.length;i<t;i++)for(var n=0,a=e.A4[i].S.length;n<a;n++)e.A4[i].S[n]&&e.A4[i].S[n]&&(e.C.E["plot"+i+".visible"]||"hide"===e.C.getToggleAction())&&0===e.A4[i].S[n].AD&&e.A4[i].TI&&(e.KM[n]+=.005*e.KM[n]);e.parseLayout()}}),ZC.A4R=ZC.LJ.CA({$i:function(e){this.b(e);this.KM=[],this.P4=[]},ACW:function(){return new ZC.TO(this)},parse:function(){var e=this;e.KM=[],e.P4=[],e.b();for(var i,t=e.A.BL("scale"),n=t.iX+t.I/2,a=1,l=0,o=e.A4.length;l<o;l++)if(e.C.E["plot"+l+".visible"]||"hide"===e.C.getToggleAction())for(var r=0,s=e.A4[l].S.length;r<s;r++)if(e.A4[l].S[r]){var A=e.A4[l].S[r];null===ZC._n_(e.P4[r])&&(e.P4[r]=e.A4[l].DH);var C=e.P4[r],c=C+360*A.AD/e.KM[r];e.P4[r]=c,A.B4=C,A.BK=c;var u=A.GW(!0);if(u&&"in"!==u.o.placement){var p=ZC._i_((C+c)/2);i=((p>=0&&p<=90||p>=270&&p<=360?t.iX+t.I-(u.I+25):t.iX+(u.I+25))-n)/ZC.EH(p),a=ZC.CY(a,2*i/t.I),i=t.F/2-(u.F/2+10),a=ZC.CY(a,2*i/t.F)}}a=ZC.BQ(.15,ZC.CY(.85,a)),"auto"===t.o["size-factor"]&&(t.o["size-factor"]=t.JE=a)}}),ZC.A8C=ZC.LJ.CA({A2E:{},$i:function(e){this.b(e)},ACW:function(){return new ZC.XE(this)},paint:function(){this.A2E={},this.b()}}),ZC.A6O=ZC.A09.CA({ACW:function(){return new ZC.TC(this)}}),ZC.A6M=ZC.A0H.CA({ACW:function(){return new ZC.TF(this)}}),ZC.A7P=ZC.LJ.CA({ACW:function(){return new ZC.XG(this)}}),ZC.A22=ZC.LJ.CA({parse:function(){var e,i,t,n,a,l=this;for(l.B3=ZC.MAX,l.BJ=-ZC.MAX,l.A7K=[],l.SC=[],l.b(),e=0,i=l.A4.length;e<i;e++)for(t=0,n=l.A4[e].S.length;t<n;t++)l.A4[e].S[t]&&(a=l.A4[e].S[t],null===ZC._n_(l.SC[t])&&(l.SC[t]=ZC.MAX),null===ZC._n_(l.A7K[t])&&(l.A7K[t]=-ZC.MAX),l.SC[t]=ZC.CY(l.SC[t],a.AD),l.A7K[t]=ZC.BQ(l.A7K[t],a.AD));for(e=0,i=l.A4.length;e<i;e++)for(t=0,n=l.A4[e].S.length;t<n;t++)l.A4[e].S[t]&&(a=l.A4[e].S[t],l.B3=ZC.CY(l.B3,a.AD),l.BJ=ZC.BQ(l.BJ,a.AD))}}),ZC.A6G=ZC.A22.CA({ACW:function(){return new ZC.VA(this)}}),ZC.A6F=ZC.A22.CA({ACW:function(){return new ZC.V8(this)}}),ZC.A7Y=ZC.LJ.CA({ACW:function(){return new ZC.VB(this)}}),ZC.A7T=ZC.LJ.CA({ACW:function(){return new ZC.X7(this)}}),ZC.A7J=ZC.LJ.CA({ACW:function(){return new ZC.SQ(this)}}),ZC.ZCVRangePlotSet=ZC.LJ.CA({ACW:function(){var e=new ZC.SQ(this);return e.O6=!0,e}}),ZC.A7V=ZC.A4Q.CA({ACW:function(){return new ZC.XJ(this)}}),ZC.A7D=ZC.A09.CA({ACW:function(){return new ZC.UE(this)}}),ZC.A7A=ZC.A0H.CA({ACW:function(){return new ZC.VZ(this)}}),ZC.A6Z=ZC.A40.CA({ACW:function(){return new ZC.UC(this)}}),ZC.A75=ZC.A3Z.CA({ACW:function(){return new ZC.UB(this)}}),ZC.A8U=ZC.LJ.CA({$i:function(e){this.b(e),this.DW=[],this.NV=[],this.X9=[]},ACW:function(){return new ZC.YU(this)},paint:function(){var e,i,t,n,a,l,o,r,s,A,C=this,c=C.A.BL("scale"),u=ZC.CY(c.GF,c.GK),p=-ZC.MAX,Z=ZC.CY(3,C.A4.length);for(e=0,i=Z;e<i;e++)for(A=C.A4[e].S,a=ZC.AP.O3(C.A4[e].o["value-box"],C.A4[e].o),t=0,n=A.length;t<n;t++)A[t].setup(),p=ZC.BQ(p,A[t].AD),A[t].WP=ZC.AP.G2(C.A4[e].AC0[t],a);var h=u/(4*Math.sqrt(p/Math.PI));function d(e,i){var t=ZC._a_(e[0]-i[0]),n=ZC._a_(e[1]-i[1]);return Math.sqrt(t*t+n*n)}var f,_,g,v=[],b=[],B=[],m=[],E=null;for(C.NV=[],e=0,i=Z;e<i;e++)for(v[e]||(v[e]=[]),b[e]||(b[e]=[],B[e]=[]),C.DW[e]||(C.DW[e]=[]),A=C.A4[e].S,m=C.A4[e+1]&&e+1<3?C.A4[e+1].S:C.A4[0].S,t=0,n=A.length;t<n;t++){C.NV[t]||(C.NV[t]=[]),C.X9[t]||(C.X9[t]={}),A[t].WG=m[t].AD,0===e?(f=h*Math.sqrt(A[t].AD/Math.PI),_=h*Math.sqrt(A[t].WG/Math.PI),v[e][t]=h*ZC.AQ.A6D(A[t].AD,A[t].WG,A[t].WP),b[e][t]=A[t].iX-ZC.BQ(f,_)/2,B[e][t]=A[t].iY+A[t].F/4):1===e?(v[e][t]=h*ZC.AQ.A6D(A[t].AD,A[t].WG,A[t].WP),b[e][t]=b[0][t]+v[0][t],B[e][t]=B[0][t],2===Z&&(g=(b[0][t]-f-(c.GK-(b[1][t]+_)))/2,C.A4[e-1].S[t].iX-=g,b[1][t]-=g,C.DW[0][t].x-=g,C.NV[t][0][0]-=g,C.A4[e-1].S[t].iY=c.iY+c.GF/2,B[1][t]=c.iY+c.GF/2,C.DW[0][t].y=c.iY+c.GF/2)):2===e&&(v[e][t]=h*ZC.AQ.A6D(A[t].AD,A[t].WG,A[t].WP),o=(v[0][t]*v[0][t]-v[1][t]*v[1][t]+v[2][t]*v[2][t])/(2*v[0][t]),b[e][t]=b[0][t]+o,r=Math.sqrt(v[2][t]*v[2][t]-o*o),B[e][t]=B[0][t]-r,3===Z&&(g=(b[0][t]-f-(c.GK-(b[1][t]+_)))/2,C.A4[0].S[t].iX-=g,C.A4[1].S[t].iX-=g,C.DW[0][t].x-=g,C.DW[1][t].x-=g,C.NV[t][0][0]-=g,b[2][t]-=g)),A[t].iX=b[e][t]+c.iX,A[t].iY=B[e][t],A[t].I=h*Math.sqrt(A[t].AD/Math.PI),A[t].F=h*Math.sqrt(A[t].AD/Math.PI),A[t].AI=h*Math.sqrt(A[t].AD/Math.PI),null===ZC._n_(E)&&(E=A[t].AD/(Math.PI*A[t].AI*A[t].AI));var D=h*Math.sqrt(A[t].AD/Math.PI),K=h*Math.sqrt(A[t].WG/Math.PI),F=D+K-v[e][t],x=(2*F*K-F*F)/(2*(D+K-F)),I=F-x;if(C.DW[e][t]={x:b[e][t],y:B[e][t],sz:A[t].AI,r1:D,r2:K,dx1:I,dx2:x},0===e?(r=Math.sqrt(D*D-(D-x)*(D-x)),C.NV[t].push([b[0][t]+D-x,B[0][t]-r])):2===e&&(D=C.DW[1][t].r1,K=C.DW[1][t].r2,I=C.DW[1][t].dx1,x=C.DW[1][t].dx2,l=ZC.TK(Math.asin((B[1][t]-B[2][t])/v[1][t]))-ZC.TK(Math.acos((D-x)/D)),C.NV[t].push([b[1][t]-D*ZC.EH(l)-g,B[1][t]-D*ZC.EP(l)]),D=C.DW[2][t].r1,K=C.DW[2][t].r2,I=C.DW[2][t].dx1,x=C.DW[2][t].dx2,l=ZC.TK(Math.asin((B[0][t]-B[2][t])/v[2][t]))-ZC.TK(Math.acos((K-I)/K)),C.NV[t].push([b[0][t]+K*ZC.EH(l)-g,B[0][t]-K*ZC.EP(l)])),e===Z-1)if(3===Z){if(null!==ZC._n_(C.A4[0].A9Z[t]))C.X9[t].area=C.A4[0].A9Z[t];else{var y=[-1],w=[-1];y[1]=d(C.NV[t][0],C.NV[t][2]),y[2]=d(C.NV[t][0],C.NV[t][1]),y[3]=d(C.NV[t][2],C.NV[t][1]),w[1]=C.DW[0][t].sz,w[2]=C.DW[1][t].sz,w[3]=C.DW[2][t].sz;var Y=.25*Math.sqrt((y[1]+y[2]+y[3])*(y[1]+y[2]-y[3])*(y[1]+y[3]-y[2])*(y[2]+y[3]-y[1]));for(s=1;s<=3;s++)Y+=w[s]*w[s]*Math.asin(y[s]/(2*w[s]))-y[s]/4*Math.sqrt(4*w[s]*w[s]-y[s]*y[s]);C.X9[t].area=E*Y}C.DW[0][t].intxy=ZC.AQ.A5I(C.DW[0][t].x,C.DW[0][t].y,C.DW[1][t].x,C.DW[1][t].y,C.DW[0][t].r1-(C.DW[0][t].dx1+C.DW[0][t].dx2)/2),C.DW[1][t].intxy=ZC.AQ.A5I(C.DW[1][t].x,C.DW[1][t].y,C.DW[2][t].x,C.DW[2][t].y,-(C.DW[1][t].r1-(C.DW[1][t].dx1+C.DW[1][t].dx2)/2)),C.DW[2][t].intxy=ZC.AQ.A5I(C.DW[2][t].x,C.DW[2][t].y,C.DW[0][t].x,C.DW[0][t].y,-(C.DW[2][t].r1-(C.DW[2][t].dx1+C.DW[2][t].dx2)/2)),C.X9[t].xy=[(C.NV[t][0][0]+C.NV[t][1][0]+C.NV[t][2][0])/3,(C.NV[t][0][1]+C.NV[t][1][1]+C.NV[t][2][1])/3]}else C.DW[0][t].intxy=ZC.AQ.A5I(C.DW[0][t].x,C.DW[0][t].y,C.DW[1][t].x,C.DW[1][t].y,C.DW[0][t].r1-(C.DW[0][t].dx1+C.DW[0][t].dx2)/2),C.DW[1][t].intxy=[-9999,-9999]}if(3===Z)for(e=0,i=Z;e<i;e++)for(a=ZC.AP.O3(C.A4[e].o["value-box"],C.A4[e].o),null!==ZC._n_(a.decimals)&&-1!==a.decimals||(a.decimals=0),t=0,n=C.A4[e].S.length;t<n;t++)C.X9[t].area=ZC.AP.G2(C.X9[t].area,a);C.b()}});var HV={$i:function(e){this.b(e);var i=this;i.C=e.A,i.H=i.C.A,i.A68={},i.HM=!1,i.SV=3,i.A1G=1,i.V=[],i.KH={},i.S=[],i.AF="",i.sTypeX=null,i.IE=null,i.RO=!1,i.IZ="none",i.O2="plot",i.UT=!0,i.SZ=null,i.T3=null,i.TN={},i.A2=null,i.GA=null,i.PM=null,i.PI=null,i.BP=null,i.L=-1,i.BO=[],i.CC=!1,i.KQ="normal",i.DZ=0,i.U=null,i.NQ=null,i.A7=null,i.JM=null,i.AM=null,i.JB=null,i.A6C=null,i.P2=null,i.DQ=-1,i.I1=-1,i.RD=null,i.RW=null,i.ZX=!1,i.SE=2,i.A33=!1,i.TX="",i.A04="standard",i.CW=null,i.A0X=null,i.MS=null,i.RX=null,i.Y1=!0,i.XQ=null,i.YA=1,i.Q8=!1,i.QN=!0,i.JR=0,i.XX=null,i.T0=null,i.PU=!0,i.K2=null,i.AAD=1,i.A2K=1,i.S6=[],i.JA=null,i.EF=!1,i.SY=[],i.A6Q=-1,i.GG=!1,i.L7=0,i.JF=.6,i.L8=0,i.AC3=0,i.AC4=null,i.TL=0,i.FV=null,i.I3=!1,i.YH=!0,i.A78=!1,i.Y0=1,i.YL=0,i.IA=!1,i.L9=!1,i.A3K="node",i.LP=!1,i.R4=-1,i.RK=0,i.Q9=!1,i.GQ=[null,null,null,null],i.P3="line"},applyRGBA:function(){var e,i=this;null!==ZC._n_(e=i.E["l-alpha"])&&null===ZC._n_(i.J9.alpha)&&(i.C6=e),null!==ZC._n_(e=i.E["bg-alpha"])&&null===ZC._n_(i.J9["alpha-area"])&&(i.o["alpha-area"]=e)},FK:function(e,i,t){var n=this;return void 0===t&&(t=!1),(void 0===i||!n.GQ[i]&&n.GQ[1])&&(i=1),e=parseInt(e,10),!n.I3||"xy"!==n.C.AJ.layout&&"yx"!==n.C.AJ.layout?n.S[e]:n.S[e]&&n.GQ[i]?(n.GQ[i].K=n.K+"-node-"+e,n.GQ[i].o={value:n.V[e]},"string"==typeof n.V[e]&&(n.GQ[i].A26=!0),n.GQ[i].L=e,"line"!==n.AF&&"area"!==n.AF&&"vline"!==n.AF&&"varea"!==n.AF||n.U?n.GQ[i].parse():(t||null!==n.S[e].BT||"undefined"!=typeof n.C.E["plot-"+n.L+"-first-run"])&&n.GQ[i].parse(),"line"===n.AF||"area"===n.AF||"vline"===n.AF||"varea"===n.AF?"xy"===n.C.AJ.layout?(null!==n.S[e].BT?n.GQ[i].iX=n.S[e].iX=n.B1.AT(n.S[e].BT):n.GQ[i].iX=n.S[e].iX=n.B1.IB(e),n.CC&&"100%"===n.KQ?n.GQ[i].iY=n.S[e].iY=n.CM.AT(100*n.S[e].CS/n.A.F8[e]["%total-"+n.DZ]):n.GQ[i].iY=n.S[e].iY=n.CM.AT(n.S[e].CS)):(null!==n.S[e].BT?n.GQ[i].iY=n.S[e].iY=n.B1.AT(n.S[e].BT):n.GQ[i].iY=n.S[e].iY=n.B1.IB(e),n.CC&&"100%"===n.KQ?n.GQ[i].iX=n.S[e].iX=n.CM.AT(100*n.S[e].CS/n.A.F8[e]["%total-"+n.DZ]):n.GQ[i].iX=n.S[e].iX=n.CM.AT(n.S[e].CS)):n.GQ[i].T6(),n.GQ[i].JD=n.S[e].JD,n.GQ[i]):null},V4:function(e,i){var t=this;t.K2[e]||(t.K2[e]=[]),(!t.I3||t.I3&&-1===ZC.AV(t.K2[e],i))&&t.K2[e].push(i)},TQ:function(){return new ZC.LG(this)},ABZ:function(){return{}},NR:function(){return this.ZQ("palette","A6Q","i"),this.C.A.B8.A9B(-1!==this.A6Q?this.A6Q:this.L,this.C.AF)},NO:function(){var e=this;if(e.BP[4]){var i,t={};for(var n in e.BP[4])-1===(i=n.indexOf("."))?null===ZC._n_(e.o[n])&&(t[n]=!0,e.o[n]=e.BP[4][n]):n.substring(0,i)===e.AF&&(null===ZC._n_(e.o[n.substring(i+1)])||t[n.substring(i+1)])&&(e.o[n.substring(i+1)]=e.BP[4][n])}},ID:function(e,i){var t,n,a=this,l=!1,o="";if("none"!==a.IZ&&(a.C.IX[a.L]||a.C.KI)){var r=!(e.E["selected-state"]||e.E["background-state"]);a.C.CB["p"+a.L]&&a.C.CB["p"+a.L]["n"+e.L]?zingchart.DEV.CACHESELECTION&&r&&a.TN["selected-state"]?(n=a.TN["selected-state"],l=!0):(o="selected-state",(n=new ZC.DN(a)).copy(i),e.E["selected-state"]?n.LO=e.E["selected-state"]:n.LO=a.SZ?a.SZ.o:{}):"none"!==a.O2&&("plot"===a.O2&&a.C.IX[a.L]||"graph"===a.O2&&a.C.KI)&&(zingchart.DEV.CACHESELECTION&&r&&a.TN["background-state"]?(n=a.TN["background-state"],l=!0):(o="background-state",(n=new ZC.DN(a)).copy(i),e.E["background-state"]?n.LO=e.E["background-state"]:n.LO=a.T3?a.T3.o:{})),l||(n?(n.PU=!0,n.parse()):(n=new ZC.DN(a)).copy(i),zingchart.DEV.CACHESELECTION&&r&&""!==o&&(a.TN[o]=n))}else(n=new ZC.DN(a)).copy(i);return null!==ZC._n_(t=a.SY[e.L])&&(0===e.A.E7.length&&(e.A.E7=[{}]),"string"==typeof a.SY[e.L]?n.append({"background-color":ZC.AP.JN(t,20)+" "+t,"line-color":t,"border-color":ZC.AP.JN(t,20)}):n.append(a.SY[e.L]),n.parse()),n.Z=i.Z,n.C7=i.C7,n},BU:function(e){var i=this,t=[];if(null!==ZC._n_(e))for(var n=0,a=i.BO.length;n<a;n++){var l=i.C.BL(i.BO[n]);l&&l.AF===e&&t.push(i.BO[n])}else t=i.BO;return t},MP:function(){var e=this;return{negation:e.A04,"thousands-separator":e.RD,"decimals-separator":e.RW,decimals:e.DQ,"max-decimals":e.I1,short:e.A33,"short-unit":e.TX,exponent:e.ZX,"exponent-decimals":e.SE}},parse:function(){var e,i,t,n=this;if(n.UP={},n.b(),n.K2={},null!==ZC._n_(e=n.o.scales))for(n.BO=e.split(/,|;|\s/),Z=0;Z<n.BO.length;Z++)n.BO[Z]=ZC.UJ(ZC.GV(n.BO[Z]));if(n.C.o.legend&&n.C.o.legend["highlight-plot"]&&(n.IA=!0),null!==ZC._n_(n.o.multiplier)&&null===ZC._n_(n.o.short)&&(n.o.short=n.o.multiplier),null!==ZC._n_(n.o["click-marker"])&&null===ZC._n_(n.o["selection-mode"])&&null===ZC._n_(n.o["selected-marker"])&&(n.o["selection-mode"]="multiple",n.o["selected-marker"]={},ZC._cp_(n.o["click-marker"],n.o["selected-marker"])),n.KQ=n.C.KQ,n.assign_a([["ignore","HM","b"],["exponent","ZX","b"],["exponent-decimals","SE","ia"],["decimals","DQ","ia"],["max-decimals","I1","i"],["preview","QN","b"],["stacked","CC","b"],["stack-type","KQ"],["exact","Q8","b"],["text","AM"],["tooltip-text","JB"],["legend-text","A6C"],["description","P2"],["stack","DZ","i"],["z-index","JR","i"],["aspect","CW"],["mode","A0X"],["density","Y0","f"],["max-nodes","MS"],["max-trackers","RX"],["segment-trackers","Y1","b"],["sampling-step","XQ","i"],["scroll-step-multiplier","YA","i"],["url","EA"],["target","FB"],["decimals-separator","RW"],["thousands-separator","RD"],["short","A33","b"],["negation","A04"],["short-unit","TX"],["fast-rules","A78","b"],["errors","S6"],["styles","SY"],["monotone","Q9","b"],["highlight","IA","b"],["highlight-legend","L9","b"],["hover-mode","A3K"],["mid-point","UT","b"],["clustered","LP","b"],["cluster-index","R4","i"],["cluster-offset","RK","i"],["animate","GG","b"],["effect","L7","i"],["speed","JF","f"],["selection-mode","IZ"],["group-selections","RO","b"],["background-mode","O2"],["extra-values","YL","ia"]]),n.AAN=n.Q8,!n.E["quick-parse"]){var a;if(ZC._todash_(n.SY),n.IA&&(null===ZC._n_(n.C.o.legend)||null===ZC._n_(n.C.o.legend["highlight-legend"]))&&ZC._n_(null===n.o["highlight-legend"])&&(n.L9=n.IA),null!==ZC._n_(e=n.o.animation))n.GG=!0,null!==ZC._n_(i=e.effect)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(i+"").substring(10)])&&(i=a),n.L7=ZC._i_(i),0===n.L7&&(n.GG=!1)),null!==ZC._n_(i=e.speed)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(i+"").substring(10)])&&(i=a),n.JF=ZC._f_(i)),null!==ZC._n_(i=e.delay)&&(n.L6=ZC._f_(i)),null!==ZC._n_(i=e.method)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(i+"").substring(10)])&&(i=a),n.L8=ZC._i_(i)),null!==ZC._n_(i=e.sequence)&&(0===(i+"").indexOf("ANIMATION_")&&null!==ZC._n_(a=ZC.ANIMATION[(i+"").substring(10)])&&(i=a),n.TL=ZC._i_(i)),null!==ZC._n_(i=e.attributes)&&(n.FV=i);for(var l in n.JF<10&&(n.JF*=1e3),n.L6<10&&(n.L6*=1e3),"undefined"!=typeof ZC.PE&&(n.JF=ZC.BQ(ZC.PE.U3,n.JF)),("fast"===n.A0X||"undefined"==typeof ZC.PE||zingchart.SKIP.ANIMATION)&&(n.GG=!1),n.H.A19&&(n.GG=!1),-1!==ZC.AV(["line","area","vbar","hbar","stock","scatter","bubble","radar","piano"],n.AF)&&("fast"===n.A0X?n.I3=!0:"normal"===n.A0X||n.GG||-1!==JSON.stringify(n.o).indexOf('"rules"')||-1!==JSON.stringify(n.o).indexOf('"js-rule"')||0!==n.SY.length||-1!==n.H.E.json.indexOf('"override"')||-1!==n.H.E.json.indexOf('"errors"')||"none"!==n.IZ?n.I3=!1:n.I3=!0),n.o)if("data-"===l.substring(0,5)){var o=l.substring(5);n.KH[o]=n.o[l]}var r=n.H.B8;if(n.IE=new ZC.D0(n),n.IE.append(n.o),r.load(n.IE.o,B("hover-state")),n.IE.append(n.o["hover-state"]),null!==ZC._n_(n.o["hover-state"])||"line"!==n.AF&&"area"!==n.AF||(n.IE.AN=!1),n.IA&&(n.S2=new ZC.D0(n),r.load(n.S2.o,B("highlight-state")),n.S2.append(n.o),null!==ZC._n_(e=n.o["highlight-state"])&&n.S2.append(e),null===ZC._n_(n.S2.o.shadow)&&(n.S2.o.shadow=!0)),null!==ZC._n_(e=n.o["selected-state"])&&(n.SZ=new ZC.D0(n),r.load(n.SZ.o,B("selected-state")),n.SZ.append(e)),null!==ZC._n_(e=n.o["background-state"])&&(n.T3=new ZC.D0(n),r.load(n.T3.o,B("background-state")),n.T3.append(e)),n.A2=new ZC.D0(n),r.load(n.A2.o,B("marker")),r.load(n.A2.o,B("marker["+n.CW+"]")),n.A2.append(n.o.marker),"auto"===n.A2.o.type){var s=["circle","square","diamond","triangle","star5"];n.A2.o.type=s[n.L%s.length]}if(n.A2.parse(),(n.A2.E7.length>0||n.SY.length>0||n.A2.o["top-state"])&&(n.YH=!1),n.GA=new ZC.D0(n),r.load(n.GA.o,B("hover-marker")),n.GA.append(n.o.marker),n.GA.append(n.o["hover-marker"]),null!==ZC._n_(e=n.o["selected-marker"])&&(n.PM=new ZC.D0(n),r.load(n.PM.o,B("selected-marker")),n.PM.append(e)),null!==ZC._n_(e=n.o["background-marker"])&&(n.PI=new ZC.D0(n),r.load(n.PI.o,B("background-marker")),n.PI.append(e)),n.IA&&(n.V6=new ZC.D0(n),n.V6.append(n.o.marker),null!==ZC._n_(e=n.o["highlight-marker"])&&(r.load(n.V6.o,B("highlight-marker")),n.V6.append(e))),"normal"!==n.A0X&&(n.SZ||n.PM)&&(n.I3=!1),"fast"===n.A0X&&(n.I3=!0),n.A7=new ZC.DN(n),n.o.tooltip&&n.o.tooltip.placement&&n.o.tooltip.placement.indexOf("node")>-1?r.load(n.A7.o,"("+n.AF+").tooltip[dynamic]"):r.load(n.A7.o,n.AF+".tooltip"),n.A7.append(n.o.tooltip),null!==ZC._n_(e=n.o.error)&&(n.JA=new ZC.DT(n),r.load(n.JA.o,B("error")),n.JA.append(e),null===ZC._n_(n.JA.o.size)&&(n.JA.o.size=4)),null!==ZC._n_(e=n.o["value-box"])){if(e instanceof Array)for(n.U=new ZC.D0(n),r.load(n.U.o,B("value-box")),null!==ZC._n_(i=n.C.o.plot)&&n.U.append(i["value-box"]),n.U.append(e[0]),e.length>1&&(n.NQ=[]),Z=1;Z<e.length;Z++)n.NQ[Z-1]=new ZC.D0(n),r.load(n.NQ[Z-1].o,B("value-box")),null!==ZC._n_(i=n.C.o.plot)&&n.NQ[Z-1].append(i["value-box"]),n.NQ[Z-1].append(e[Z]);else n.U=new ZC.D0(n),r.load(n.U.o,B("value-box")),null!==ZC._n_(i=n.C.o.plot)&&n.U.append(i["value-box"]),n.U.append(e);n.U.parse()}n.H.QZ&&(n.AN=ZC.FSSTATUS["g-"+n.C.L+"-p-"+n.L]);var A=!1;for("undefined"==typeof n.C.E["plot"+n.L+".visible"]&&(A=!0),A?n.C.E["plot"+n.L+".visible"]=!0:n.AN=n.C.E["plot"+n.L+".visible"],n.AN||A&&(n.C.E["plot"+n.L+".visible"]=!1),Z=0,t=n.C.BO.length;Z<t;Z++)null!==ZC._n_(n.C.BO[Z].o.values)?n.C.BO[Z].T9=!0:-1!==ZC.AV(n.BO,n.C.BO[Z].BE)&&("remove"===n.C.getToggleAction()||n.C.A.K9?n.AN&&n.C.E["plot"+n.L+".visible"]&&(n.C.BO[Z].T9=!0):n.C.BO[Z].T9=!0);var C,c=null;if(n.K=n.A.K+"-plot-"+n.L,n.S=[],n.A.F8||(n.A.F8={}),-1!==n.AF.indexOf("area")&&-1===n.AF.indexOf("3d")&&n.CC){n.A.WM||(n.A.WM={}),n.A.WM["s"+n.DZ]||(n.A.WM["s"+n.DZ]=[]);var u=!1;if(null!==ZC._n_(n.o.values))for(Z=0,t=n.o.values.length;Z<t;Z++)if("object"==typeof n.o.values[Z]&&null!==ZC._n_(n.o.values[Z])){u=!0;break}u&&(n.GG=!1,n.HT||0!==n.E7.length||(n.I3=!0,-1===zingchart.DEV.STACKINGLOGIC&&(n.C.UO=1)))}if(n.B1=n.C.BL(n.BU("k")[0]),n.CM=n.C.BL(n.BU("v")[0]),null!==ZC._n_(n.o.values)&&""!==n.AF){if(n.V=n.o.values,n.I3&&"area"===n.AF&&"spline"===n.CW){for(var p=!1,Z=0;Z<n.V.length;Z++)if(null===ZC._n_(n.V[Z])){p=!0;break}p&&(n.I3=!1)}var h=null;n.PY=[ZC.MAX,-ZC.MAX];var d=[],f=[],_=0;for(Z=0,t=n.V.length;Z<t;Z++){var g=!1;if(n.o["hint-ts"]||(null!==ZC._n_(n.V[Z])&&"object"==typeof n.V[Z]&&n.V[Z].length>1?(null===ZC._n_(n.V[Z][1])||"string"==typeof n.V[Z][1]&&"NULL"===n.V[Z][1].toUpperCase())&&(g=!0):(null===ZC._n_(n.V[Z])||"string"==typeof n.V[Z]&&"NULL"===n.V[Z].toUpperCase())&&(g=!0),"piano"===n.C.AF&&(g=!1)),g)n.S.push(null);else{!n.I3||"xy"!==n.C.AJ.layout&&"yx"!==n.C.AJ.layout?c=n.TQ():n.GQ[1]||("bubble"===n.AF||"scatter"===n.AF?n.GQ[1]=c=n.TQ():(n.GQ[0]=n.TQ(),n.GQ[1]=c=n.TQ(),n.GQ[2]=n.TQ(),n.GQ[3]=n.TQ())),c.K=n.K+"-node-"+Z,"string"==typeof n.V[Z]&&zingchart.QUOTEDVALUES&&(n.V[Z]=ZC._f_(n.V[Z])),c.o={value:n.V[Z]},"string"==typeof n.V[Z]&&(c.A26=!0),c.L=Z,n.o["hint-ts"]?(c.E.plotidx=n.L,c.E.nodeidx=c.L,c.K=n.K+"-node-"+c.L,c.BT=n.V[Z][0],c.AD=n.V[Z][1]):c.parse(),(t<256||zingchart.DEV.CHECKDECIMALS)&&null!==ZC._n_(c.AD)&&2===(C=c.AD.toString().split(".")).length&&(_=ZC.BQ(_,C[1].length)),c.BT&&(null!==h&&ZC._a_(c.BT-h)>0&&d.push(ZC._a_(c.BT-h)),h=c.BT),n.A.WM=n.A.WM||{};var v=n.A.WM["s"+n.DZ];if(v&&(null!==h?-1===ZC.AV(v,c.BT)&&v.push(c.BT):-1===ZC.AV(v,Z)&&v.push(Z)),!n.I3||"xy"!==n.C.AJ.layout&&"yx"!==n.C.AJ.layout)n.S.push(c);else{var b={iX:c.iX,iY:c.iY,L:c.L,BT:c.BT,AD:c.AD,CS:c.AD,DP:c.DP,JD:c.JD};"bubble"===n.AF&&(b.SI=c.SI),n.S.push(b)}null!==c.BT&&(n.PY[0]=Math.min(n.PY[0],c.BT),n.PY[1]=Math.max(n.PY[1],c.BT)),n.C.E["plot"+n.L+".visible"]&&(zingchart.DEV.PLOTSTATS||"100%"===n.KQ)&&n.CC&&(null===ZC._n_(n.A.F8[Z])?(n.A.F8[Z]={},n.A.F8[Z]["%total-"+n.DZ]=c.AD):null===ZC._n_(n.A.F8[Z]["%total-"+n.DZ])?n.A.F8[Z]["%total-"+n.DZ]=c.AD:n.A.F8[Z]["%total-"+n.DZ]+=c.AD),zingchart.DEV.PLOTSTATS&&(f.push(c.AD),n.JM?(n.JM["%plot-max-index"]=Z,n.JM["%plot-sum"]+=c.AD,t<256&&(n.JM["%plot-values"]+=","+c.AD)):n.JM={"%plot-min-index":Z,"%plot-max-index":Z,"%plot-sum":c.AD,"%plot-values":c.AD},n.A.F8||(n.A.F8={}),n.AN&&(null===ZC._n_(n.A.F8["%pstack-"+Z+"-"+n.DZ+"-sum"])?(n.A.F8["%pstack-"+Z+"-"+n.DZ+"-sum"]=c.AD,n.A.F8["%pstack-"+Z+"-"+n.DZ+"-stack-length"]=1):(n.A.F8["%pstack-"+Z+"-"+n.DZ+"-sum"]+=c.AD,n.A.F8["%pstack-"+Z+"-"+n.DZ+"-stack-length"]+=1)))}}(n.V.length<256||zingchart.DEV.CHECKDECIMALS)&&n.JM&&null!==ZC._n_(n.JM["%plot-sum"])&&2===(C=n.JM["%plot-sum"].toString().split(".")).length&&ZC._i_(C[1])>_&&(n.JM["%plot-sum"]=ZC._f_(n.JM["%plot-sum"].toFixed(ZC.CY(20,_)))),zingchart.DEV.PLOTSTATS?(n.JM&&(n.JM["%plot-average"]=n.JM["%plot-sum"]/n.V.length,n.JM["%plot-average"]=ZC._f_(n.JM["%plot-average"].toFixed(ZC.CY(20,_+2)))),f.length>0&&(n.JM["%plot-min-value"]=ZC.XY(f),n.JM["%plot-max-value"]=ZC.A1L(f))):n.JM={"%plot-min-index":0,"%plot-max-index":n.V.length,"%plot-sum":-1,"%plot-values":"","%plot-average":-1,"%plot-min-value":-1,"%plot-max-value":-1},h&&d.length>0&&(n.AAD=ZC.XY(d),n.A2K=ZC.A1L(d))}}function B(e){var i=["("+n.AF+").plot."+e];return n.sTypeX&&i.push("("+n.sTypeX+").plot."+e),i}},mapPointsToPreview:function(e,i){for(var t=this,n=t.C.P,a=t.C.B9.AR,l=[],o=0,r=e.length;o<r;o++)if(e[o]){"vml"===t.H.AA&&i&&(e[o][0]=e[o][0]/10,e[o][1]=e[o][1]/10);var s=(e[o][0]-n.iX)/n.I,A=(e[o][1]-n.iY)/n.F,C=a.iX+a.AU+s*(a.I-2*a.AU),c=a.iY+a.AU+A*(a.F-2*a.AU);l.push([C,c])}else l.push(null);return l},paint:function(){var e=this,i=e.C.P.I;switch(e.C.AF){case"scatter":case"bubble":i=1e6;break;case"hbar":case"hbar3d":i=e.C.P.F}null===ZC._n_(e.MS)&&(e.MS=ZC._i_(i/4)),null===ZC._n_(e.RX)&&(e.RX=ZC._i_(i/4)),e.YH&&(e.HB=null,e.HI=null,e.RA=null,e.QB=null)},XN:function(e){var i,t,n,a=this;for(i=0,t=a.S.length;i<t;i++)a.S[i]&&(a.S[i].JD=!1);var l=a.C.P;if(a.R7=!1,a.FY=!0,a.U8=!1,n=0,a.C.OA||"undefined"!=typeof a.AAN&&(a.Q8=a.AAN),e)a.R7=!0,a.RX<a.S.length&&(a.FY=!1);else{if(a.B1.EF&&a.EF){for(i=0,t=a.S.length;i<t;i++)a.S[i]&&(a.B1.IQ.length>0||ZC.DS(a.S[i].BT,a.B1.V[a.B1.W],a.B1.V[a.B1.A1]))&&n++;a.RX<n&&(a.FY=!1),n*a.Y0>l.I&&(a.U8=!0),a.MS>=n&&(a.R7=!0)}else a.MS>a.B1.A1-a.B1.W&&(a.R7=!0);a.Y=1,a.B1.EF&&a.EF||(n=a.B1.A1-a.B1.W,a.RX<n&&(a.FY=!1),n*a.Y0>l.I&&(a.U8=!0),!a.Q8&&n*a.Y0>l.I&&(a.Y=ZC.BQ(1,ZC._i_(n*a.Y0/l.I)))),a.B1.EF&&a.EF&&(a.Q8||n*a.Y0>l.I&&(a.Y=ZC.BQ(1,ZC._i_(n*a.Y0/l.I)))),a.C.OA&&(a.Q8=!1,a.Y*=a.YA)}null!==ZC._n_(a.XQ)&&a.Y>a.XQ&&(a.Y=a.XQ)},PB:function(e){var i,t,n,a=this;null!==ZC._n_(e)&&e||(e=!1),a.B1&&"log"===a.B1.C1&&(e=!0),a.XN(e);var l=null;if(e||a.LP)a.A.A4X=!1,function Z(e,i){for(var t=e;t<ZC.CY(e+i,a.S.length);t++)a.S[t]?((l=a.FK(t)).Z=a.KF,l.paint(),l.JD=!0,a.S[t].JD=!0):"radar"===a.C.AF&&(t===a.S.length-1?"line"!==a.CW&&"area"!==a.CW&&"range"!==a.CW||ZC.CR.paint(a.QE,a,a.D):a.D.push(null));e+i<a.S.length?a.C.LK?window.setTimeout(function(){Z(e+i,i)},10):Z(e+i,i):a.C.LK&&a.L===a.A.A4.length-1&&a.A._end_()}(0,ZC.ie678||ZC.mobile?200:2e3);else{var o="vbar"!==a.AF&&"hbar"!==a.AF;if(a.B1.EF&&a.EF){n=a.GB=a.HD=a.Y;var r=!0,s=0,A=0;for(i=0,t=a.S.length;i<t;i+=n)o&&(t-i==1?(a.GB=n,a.HD=1):t-i<a.Y&&(a.GB=a.Y,a.HD=t-i-1,n=t-i-1)),a.S[i]&&(a.B1.IQ.length>0||ZC.DS(a.S[i].BT,a.B1.V[a.B1.W],a.B1.V[a.B1.A1])||o&&r&&a.S[i+n]&&a.S[i+n].BT>=a.B1.V[a.B1.W])&&(o&&r&&a.S[i-n]&&((l=a.FK(i-n)).Z=a.KF,l.paint(),l.JD=!0,r=!1,A++),(l=a.FK(i)).Z=a.KF,l.paint(),l.JD=!0,A++,r=!1,s=i);o&&A>0&&a.S[s+n]&&((l=a.FK(s+n)).Z=a.KF,l.paint(),l.JD=!0)}else{n=a.GB=a.HD=a.Y;var C=0,c=1,u=null;if(!o){var p="vbar"===a.AF?a.C.P.I:a.C.P.F;C=4/("vbar"===a.AF?a.C.P.F:a.C.P.I)*(a.CM.BJ-a.CM.B3),c=1+ZC._i_((a.B1.A1-a.B1.W)/(2*p)),n=1}for(i=a.B1.W;i<=a.B1.A1;i+=n)(a.B1.A1-a.B1.W)%a.Y!=0&&o&&(a.B1.A1-i==0?(a.GB=n,a.HD=1):a.B1.A1-i<=a.Y&&(a.GB=a.Y,a.HD=a.B1.A1-i,n=a.B1.A1-i)),a.S[i]?(l=a.FK(i),(o||a.Q8||!o&&null===u||ZC._a_(l.AD-u)>C||i%c==0)&&(l.Z=a.KF,l.paint(),l.JD=!0,a.S[i].JD=!0),u=l.AD):a.CC&&-1!==ZC.AV(["vbar","hbar","vbar3d","hbar3d"],a.AF)&&a.SM()}}},CP:function(e,i){var t=this;if(t.UP[e+i])return t.UP[e+i];var n=null;return n=t.H.usc()?ZC.AK(t.H.K+"-main-c"+("fl"===e?"-top":"")):t.H.K9||t.C.AJ["3d"]?ZC.AK(t.C.K+"-plots-"+e+"-c"):ZC.AK(t.C.K+"-plot-"+t.L+"-"+e+"-"+i+"-c"),t.UP[e+i]||(t.UP[e+i]=n),n},UW:function(e){var i=this;return{id:i.H.K,graphid:i.C.K,graphidx:i.C.L,plotid:i.H8,plotindex:i.L,plottext:i.AM,ev:e?ZC.A5.BZ(e):null,xdata:i.KH}},X5:function(e,i){ZC.AP.BY("plot_"+i,this.H,this.UW(e))},applyJsRuleSvg:function(e,i,t){var n;if(n=e.o["js-rule-svg"]){var a=ZC.AK(i),l=ZC.evalFn(n.replace("javascript:","").replace("()",""),window);if(a&&l)try{var o=l.call(this,t);for(var r in o)a.setAttribute(r,o[r])}catch(s){}}},sharedZScale:function(){var e=this,i=e.C,t=i.P;if(i.o["scale-z"]&&i.E["plot"+e.L+".visible"]){var n,a,l,o,r;if(n=new ZC.CE(i,t.iX+t.I-ZC.AO.E2+10,t.iY+t.F-ZC.AO.E3,e.E["z-mid"]),(a=new ZC.DN(e)).GL=i.K+"-scale-z-item "+i.K+"-scale-item zc-scale-item",a.K=i.K+"-scale-z-item_"+e.L,a.AM=i.o["scale-z"].values[e.L],a.Z=a.C7=e.H.usc()?e.H.mc():ZC.AK(i.K+"-scales-ml-0-c"),r=ZC.Q.EB(a.Z,e.H.AA),a.IL=e.H.usc()?ZC.AK(e.H.K+"-main"):ZC.AK(e.H.K+"-text"),a.append(i.o["scale-z"].item),a.parse(),a.A9+=a.V9?0:ZC.DI.A2T(i,a),a.iX=n.ED[0],a.iY=n.ED[1],a.o["auto-align"]&&a.V9&&(a.iY-=a.F/2),a.paint(),null===ZC._n_(e.E["scale-z-item-max-width"])&&(e.E["scale-z-item-max-width"]=0),e.E["scale-z-item-max-width"]=ZC.BQ(e.E["scale-z-item-max-width"],a.I),e.E["z-cnt"]===e.E["z-plots"]-1&&i.o["scale-z"].label){var s,A;n=new ZC.CE(i,t.iX+t.I-ZC.AO.E2+20+e.E["scale-z-item-max-width"],t.iY+t.F-ZC.AO.E3,ZC.AO.FT/2),(a=new ZC.DN(e)).GL=i.K+"-scale-z-label "+i.K+"-scale-label zc-scale-label",a.K=i.K+"-scale-z-label",a.Z=a.C7=e.H.usc()?e.H.mc():ZC.AK(i.K+"-scales-ml-0-c"),r=ZC.Q.EB(a.Z,e.H.AA),a.IL=e.H.usc()?ZC.AK(e.H.K+"-main"):ZC.AK(e.H.K+"-text"),a.append(i.o["scale-z"].label),a.parse(),s=new ZC.CE(i,t.iX+t.I-ZC.AO.E2,t.iY+t.F-ZC.AO.E3,0),A=new ZC.CE(i,t.iX+t.I-ZC.AO.E2,t.iY+t.F-ZC.AO.E3,ZC.AO.FT);var C=ZC.TK(Math.atan((A.ED[1]-s.ED[1])/(A.ED[0]-s.ED[0])));a.A9+=a.V9?0:C,a.iX=n.ED[0],a.iY=n.ED[1],a.paint()}if(i.o["scale-z"].tick&&((o=new ZC.DT(e)).B7="#cccccc",o.AZ=1,o.AI=6,o.append(i.o["scale-z"].tick),o.parse(),o.AN&&o.AZ>0)){o.K=i.K+"-scale-z-tick-"+e.L;for(var c=[],u=[[t.iX+t.I,t.iY+t.F],[t.iX+t.I+o.AI,t.iY+t.F]],p=0;p<u.length;p++)n=new ZC.CE(i,u[p][0]-ZC.AO.E2,u[p][1]-ZC.AO.E3,e.E["z-mid"]),c.push([n.ED[0],n.ED[1]]);ZC.CR.paint(r,o,c)}if(0===e.E["z-cnt"]&&((o=new ZC.D0(e)).B7="#cccccc",o.AZ=1,o.append(i.o["scale-z"].axis),o.parse(),o.AZ>0&&o.AN&&(o.A0=o.AE=o.B7,(l=ZC.DI.DB(o,i,t.iX+t.I-ZC.AO.E2-o.AZ,t.iX+t.I-ZC.AO.E2,t.iY+t.F-ZC.AO.E3,t.iY+t.F-ZC.AO.E3,0,ZC.AO.FT,"x")).K=i.K+"-scale-z-axis",i.CL.add(l))),e.E["z-cnt"]>0&&i.o["scale-z"].guide&&((o=new ZC.D0(e)).B7="#cccccc",o.AZ=1,o.append(i.o["scale-z"].guide),o.parse(),o.AZ>0&&o.AN&&(o.A0=o.AE=o.B7,(l=ZC.DI.DB(o,i,t.iX-ZC.AO.E2,t.iX+t.I-ZC.AO.E2,t.iY+t.F-ZC.AO.E3,t.iY+t.F-ZC.AO.E3+o.AZ,e.E["z-cnt"]*e.E["z-depth"],e.E["z-cnt"]*e.E["z-depth"],"y")).K=i.K+"-scale-z-guideh-"+e.L,i.CL.add(l),(l=ZC.DI.DB(o,i,t.iX-ZC.AO.E2,t.iX-ZC.AO.E2,t.iY-ZC.AO.E3,t.iY+t.F-ZC.AO.E3,e.E["z-cnt"]*e.E["z-depth"],e.E["z-cnt"]*e.E["z-depth"]+o.AZ,"y")).K=i.K+"-scale-z-guidev-"+e.L,i.CL.add(l))),i.o["scale-z"].items&&i.o["scale-z"].items.length){(o=new ZC.D0(e)).A0=o.AE="#ff9900",o.C6=.25;var Z=e.E["z-cnt"]%i.o["scale-z"].items.length;o.append(i.o["scale-z"].items[Z]),o.parse(),(l=ZC.DI.DB(o,i,t.iX-ZC.AO.E2,t.iX+t.I-ZC.AO.E2,t.iY+t.F-ZC.AO.E3,t.iY+t.F-ZC.AO.E3,e.E["z-cnt"]*e.E["z-depth"],e.E["z-cnt"]*e.E["z-depth"]+e.E["z-depth"],"z")).K=e.K+"-item-",i.CL.add(l)}}},gc:function(){if(this.S)for(var e=0;e<this.S.length;e++)this.S[e]&&this.S[e].A&&ZC.AP.gc(this.S[e],["Z","C7","o","J9","I6","A","C","H","N","NC"]);ZC.AP.gc(this,["V","S","GQ","K2","V3","A7","Z","C7","UP","A2","TT","HB","GA","IE","KF","QE","B1","CM","S","GQ","K2","JM","o","J9","I6","A","C","H"])}};ZC.HV=ZC.HL.CA(HV),ZC.VY=ZC.HV.CA({$i:function(e){this.b(e);var i=this;i.bXY=!0,i.AF="xy",i.BO=["scale-x","scale-y"]},paint:function(){this.b()}}),ZC.QK=ZC.VY.CA({$i:function(e){this.b(e);var i=this;i.AF="line",i.CW="segmented",i.Y=1,i.SL="middle",i.V3=[],i.N1=!0,i.O6=!1},TQ:function(){return new ZC.A38(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.B7=e.BP[1],e.NO(),e.b(),e.assign_a([["step-start","SL"],["smart-sampling","N1","b"]]),e.B1=e.C.BL(e.BU("k")[0]),e.CM=e.C.BL(e.BU("v")[0])},paint:function(){var e,i,t,n,a,l,o,r=this;r.b(),r.V3=[];var s=r.O6;if(r.KF=r.CP("bl",0),r.QE=ZC.Q.EB(r.CP("bl",1),r.H.AA),!r.I3||r.C.AJ["3d"])r.PB(),r.D=null;else{r.XN(),r.C7=r.CP("bl",0);var A=!0;(null!==ZC._n_(r.A2.o.visible)&&!ZC._b_(r.A2.o.visible)||null!==ZC._n_(r.A.o.type)&&"none"===r.A2.o.type)&&(A=!1);var C=[],c=[],u=[],p=!0,Z=0,h=null;n=0;var d=-1,f=-1,_=r.A.A4[0].S6&&r.A.A4[0].S6.length,g=r.Y,v=r.CW;if(r.Y>1&&"spline"===v&&(v="segmented"),r.B1.EF&&r.EF){for(t=r.Y,r.N1&&(t=1),e=0,i=r.S.length;e<i;e+=t)f-e<=r.Y&&(t=ZC.BQ(1,f-e)),r.S[e]&&(r.B1.IQ.length>0||ZC.DS(r.S[e].BT,r.B1.V[r.B1.W],r.B1.V[r.B1.A1])||p&&r.S[e+t]&&r.S[e+t].BT>=r.B1.V[r.B1.W])&&(p&&r.S[e-t]&&(-1===d&&(d=e-t),f=e-t,p=!1,Z++),-1===d&&(d=e),f=e,Z++,p=!1,n=e);Z>0&&r.S[n+t]&&(-1===d&&(d=n+t),f=n+t,r.S[n+t].JD=!0)}else d=r.B1.W,f=r.LP||"log"===r.B1.C1?r.S.length:r.B1.A1;r.Y=g;var b=-1;t=r.Y,r.N1&&(t=1);var B=null,m=null,E=0,D=1;n=d,s?f-d>r.C.P.F&&(E=4/r.C.P.I*(r.CM.BJ-r.CM.B3),D=ZC._f_((f-d)/(4*r.C.P.F))):f-d>r.C.P.I&&(E=4/r.C.P.F*(r.CM.BJ-r.CM.B3),D=ZC._f_((f-d)/(4*r.C.P.I))),r.o["sampling-threshold"]&&(E*=Math.max(1,(f-d)/ZC._i_(r.o["sampling-threshold"])),D*=Math.max(1,(f-d)/ZC._i_(r.o["sampling-threshold"])));for(r.D=[],e=d;e<=f;e+=t){var K=!1;if(((f-d)%r.Y!=0||r.B1.EF&&r.EF)&&f-e<=r.Y&&(t=ZC.BQ(1,f-e),K=!0),r.N1&&!K&&r.S[e])if(null===ZC._n_(B))B=r.S[e].CS,n=e,m=0;else{if(Math.abs(r.S[e].CS-B)<E&&e-n<D&&(!r.EF||r.S[e].BT-m<4*r.B1.SG))continue;B=r.S[e].CS,m=r.S[e].BT,n=e}if(0,h=r.FK(e)){switch(r.S[e].JD=!0,(r.FY||r.LP)&&h.paint(!0),-1===b&&(b=h.iX),v){default:C.push([h.iX,h.iY]);break;case"spline":s?(c.push(h.iX),u.push(h.iY),1===c.length&&(c.push(h.iX),u.push(h.iY))):(c.push(h.iY),u.push(h.iX),1===c.length&&(c.push(h.iY),u.push(h.iX)));break;case"stepped":switch(r.SL){default:(l=r.FK(e-t,0))&&(l.setup(),a=ZC.AQ.JT(r.S[e-t].iX,r.S[e-t].iY,h.iX,h.iY),C.push(s?[h.iX,a[1]]:[a[0],h.iY])),C.push([h.iX,h.iY]),(o=r.FK(e+t,0))&&(o.setup(),a=ZC.AQ.JT(h.iX,h.iY,r.S[e+t].iX,r.S[e+t].iY),C.push(s?[h.iX,a[1]]:[a[0],h.iY]));break;case"before":(l=r.FK(e-t,0))&&(l.setup(),C.push([r.S[e-t].iX,r.S[e-t].iY],[r.S[e-t].iX,h.iY])),C.push([h.iX,h.iY]);break;case"after":C.push([h.iX,h.iY]),(o=r.FK(e+t,0))&&(o.setup(),C.push([r.S[e+t].iX,h.iY],[r.S[e+t].iX,r.S[e+t].iY]))}break;case"jumped":(l=r.FK(e-t,0))?(l.setup(),a=ZC.AQ.JT(r.S[e-t].iX,r.S[e-t].iY,h.iX,h.iY),C.push(s?[h.iX,a[1]]:[a[0],h.iY])):C.push(s?[h.iX,h.iY-r.B1.AC/2]:[h.iX-r.B1.AC/2,h.iY]),C.push([h.iX,h.iY]),(o=r.FK(e+t,0))?(o.setup(),a=ZC.AQ.JT(h.iX,h.iY,r.S[e+t].iX,r.S[e+t].iY),C.push(s?[h.iX,a[1]]:[a[0],h.iY])):C.push(s?[h.iX,h.iY+r.B1.AC/2]:[h.iX+r.B1.AC/2,h.iY]),C.push(null)}_&&h.N6(ZC.Q.EB(r.CP("fl",0),r.H.AA)),(r.R7&&A||r.FY||r.U)&&h.P8(),h.JD=!0}else null!==ZC._n_(r.o["connect-nulls"])&&ZC._b_(r.o["connect-nulls"])||(C.push(null),c.push(null),u.push(null))}if("spline"===v){c.push(c[c.length-1]),u.push(u[u.length-1]),C=[];for(var F=1;F<c.length-1;F++){var x=[c[F-1],c[F],c[F+1],c[F+2]],I=ZC._a_(u[F+1]-u[F]);I=Math.min(I,Math.max(r.C.I,r.C.F));var y=ZC.AQ.Y9(r.Q9,x,I);for(e=0;e<y.length;e++)null!==ZC._n_(y[e][0])&&null!==ZC._n_(y[e][1])?s?C.push([y[e][1],u[F]+(r.B1.AW?1:-1)*y[e][0]*I]):C.push([u[F]+(r.B1.AW?-1:1)*y[e][0]*I,y[e][1]]):C.push(null)}}r.CZ=!1;var w=r.H.O7;if(r.H.O7=!1,r.E["fast-vector-path"]=!0,ZC.CR.setup(r.QE,r),ZC.CR.paint(r.QE,r,C),r.H.O7=w,r.C.B9&&r.C.B9.I2&&r.QN){var Y=r.mapPointsToPreview(C,!0),X=ZC.Q.EB(r.C.B9.Z,r.H.AA),M=new ZC.D0(r);M.copy(r),M.K=r.K+"-preview",M.DK=r.K+"-preview",M.AZ=1;var L=r.o["preview-state"];L&&(M.append(L),M.parse()),ZC.CR.paint(X,M,Y,null,3)}}}}),ZC.QV=ZC.VY.CA({$i:function(e){this.b(e);var i=this;i.AF="area",i.Y=1,i.CW="segmented",i.SV=3,i.HX=i.C.AJ["3d"]?1:.5,i.SL="middle",i.A44=!0,i.V3=[],i.N1=!0,i.XC=!1,i.O6=!1},TQ:function(){return new ZC.A35(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.B7=e.BP[1],e.C.AJ["3d"]||"solid"===e.o["background-color-style"]?e.A0=e.AE=e.BP[1]:(e.A0=e.BP[0],e.AE=e.BP[1]),e.NO(),e.b(),e.applyRGBA(),e.assign_a([["alpha-area","HX","f",0,1],["step-start","SL"],["active-area","XC","b"],["contour-on-top","A44","b"],["smart-sampling","N1","b"]]),e.B1=e.C.BL(e.BU("k")[0]),e.CM=e.C.BL(e.BU("v")[0])},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c=this;c.b(),c.V3=[];var u=c.O6;if(-1===ZC.AV(["segmented","spline","stepped"],c.CW)&&(c.CW="segmented"),c.KF=c.CP("bl",0),c.A56=ZC.Q.EB(c.CP("bl",1),c.H.AA),c.QE=ZC.Q.EB(c.CP("bl",c.A44?2:1),c.H.AA),A=c.C.P,!c.I3||c.C.AJ["3d"]){var p=ZC.MAX,Z=-ZC.MAX;for(e=0,i=c.S.length;e<i;e++)c.S[e]&&(p=ZC.CY(p,c.S[e].CS),Z=ZC.BQ(Z,c.S[e].CS));var h=c.CM.AT(p),d=c.CM.AT(Z),f=c.CM.AT(c.CM.H6);if(ZC.DS(f,h,d)&&(c.CM.AW?f<h&&(h=f):f>d&&(d=f)),c.E["min-y"]=Math.min(h,d),c.E["max-y"]=Math.max(h,d),c.CC&&c.A.F1){var _=ZC.MAX,g=-ZC.MAX;for(e=0,i=c.A.F1.length;e<i;e++)if(c.A.F1[e])for(var v=0,b=c.A.F1[e].length;v<b;v++)_=ZC.CY(_,c.A.F1[e][v][1]),g=ZC.BQ(g,c.A.F1[e][v][1]);c.CM.AW?c.E["min-y"]=_:c.E["max-y"]=g}c.E["max-y"]-c.E["min-y"]<100&&(c.E["max-y"]+=50,c.E["min-y"]-=50),c.PB(),c.D=null,c.D6=null,c.AH=null}else{c.XN(),c.C7=c.CP("bl",0);var B=!0;(null!==ZC._n_(c.A2.o.visible)&&!ZC._b_(c.A2.o.visible)||null!==ZC._n_(c.A.o.type)&&"none"===c.A2.o.type)&&(B=!1);var m=c.CC&&0===c.C.UO,E=[],D=[],K=[],F=[],x=[],I=c.CM.H6;c.o["ref-value"]&&(I=ZC._f_(c.o["ref-value"]));var y=c.CM.AT(I);u?"xy"===c.C.AJ.layout?(y=c.B1.AT(I),y=ZC._l_(y,c.B1.iX,c.B1.iX+c.B1.I)):y=ZC._l_(y,c.CM.iX,c.CM.iX+c.CM.I):"yx"===c.C.AJ.layout?(y=c.B1.AT(I),y=ZC._l_(y,c.B1.iY,c.B1.iY+c.B1.F)):y=ZC._l_(y,c.CM.iY,c.CM.iY+c.CM.F);var w=!0,Y=0,X=null;t=0;var M=-1,L=-1,H=c.A.A4[0].S6&&c.A.A4[0].S6.length,P=c.Y,N=c.CW;if(c.Y>1&&"spline"===N&&(N="segmented"),c.B1.EF&&c.EF){for(n=c.Y,c.N1&&(n=1),e=0,i=c.S.length;e<i;e+=n)L-e<=c.Y&&(n=ZC.BQ(1,L-e)),c.S[e]&&(c.B1.IQ.length>0||ZC.DS(c.S[e].BT,c.B1.V[c.B1.W],c.B1.V[c.B1.A1])||w&&c.S[e+n]&&c.S[e+n].BT>=c.B1.V[c.B1.W])&&(w&&c.S[e-n]&&(-1===M&&(M=e-n),L=e-n,w=!1,Y++),-1===M&&(M=e),L=e,Y++,w=!1,t=e);Y>0&&c.S[t+n]&&(-1===M&&(M=t+n),L=t+n,c.S[t+n].JD=!0)}else M=c.B1.W,L=c.LP||"log"===c.B1.C1?c.S.length:c.B1.A1;c.Y=P,m||c.A.D6&&(D=c.A.D6.reverse());var G=null,S=null,O=0,k=1;t=M,u?L-M>c.C.P.F&&(O=4/c.C.P.I*(c.CM.BJ-c.CM.B3),k=ZC._f_((L-M)/(4*c.C.P.F))):L-M>c.C.P.I&&(O=4/c.C.P.F*(c.CM.BJ-c.CM.B3),k=ZC._f_((L-M)/(4*c.C.P.I)));var T=!1,z=!1,Q=-1;n=c.Y,c.N1&&(n=1),T=!0,!c.A.RU&&m&&(c.A.RU={},c.A.VJ={});var J=null,V=null;if(c.A.RU&&!c.A.RU["s"+c.DZ]&&m){c.A.RU["s"+c.DZ]={},c.A.VJ["s"+c.DZ]={};var R=c.A.WM["s"+c.DZ];for(e=0;e<=R.length;e++)null!==ZC._n_(R[e])&&(a=c.B1.EF?ZC._i_(c.B1.AT(R[e])):ZC._i_(c.B1.IB(R[e])),c.A.RU["s"+c.DZ][a]=y,c.A.VJ["s"+c.DZ][a]=y)}for(m&&(J=c.A.RU["s"+c.DZ],V=c.A.VJ["s"+c.DZ]),e=M;e<=L;e+=n){var W=!1;if(((L-M)%c.Y!=0||c.B1.EF&&c.EF)&&L-e<=c.Y&&(n=ZC.BQ(1,L-e),W=!0),c.N1&&!W&&c.S[e])if(null===ZC._n_(G))G=c.S[e].CS,t=e,S=0;else{if(Math.abs(c.S[e].CS-G)<O&&e-t<k&&(!c.EF||c.S[e].BT-S<4*c.B1.SG))continue;G=c.S[e].CS,S=c.S[e].BT,t=e}if(X=c.FK(e)){switch(c.S[e].JD=!0,(c.FY||c.LP)&&X.paint(!0),(z||("segmented"===N||"stepped"===N)&&e===M&&0===D.length)&&(m||(D.push(u?[y,X.iY]:[X.iX,y]),z&&K.push(u?[y,X.iY]:[X.iX,y]))),z=!1,-1===Q&&(Q=X.iX),N){default:m||T&&(u?X.iY>c.B1.iY&&(K.push([y,c.B1.iY]),K.push([y,X.iY]),D.push([y,X.iY])):X.iX>c.B1.iX&&(K.push([c.B1.iX,y]),K.push([X.iX,y]),D.push([X.iX,y])),T=!1),E.push([X.iX,X.iY]),m?u?V[ZC._i_(X.iY)]=X.iX:V[ZC._i_(X.iX)]=X.iY:(K.push([X.iX,X.iY]),D.push([X.iX,X.iY]));break;case"spline":u?(F.push(X.iX),x.push(X.iY),1===F.length&&(F.push(X.iX),x.push(X.iY))):(F.push(X.iY),x.push(X.iX),1===F.length&&(F.push(X.iY),x.push(X.iX)));break;case"stepped":var U=c.B1.AW?-1:1;switch(c.SL){default:(o=c.FK(e-n,0))&&(o.setup(),l=ZC.AQ.JT(c.S[e-n].iX,c.S[e-n].iY,X.iX,X.iY),E.push(u?[X.iX,l[1]]:[l[0],X.iY]),m?u?V[ZC._i_(l[1])-U]=X.iX:V[ZC._i_(l[0])+U]=X.iY:(K.push(u?[X.iX,l[1]]:[l[0],X.iY]),D.push(u?[X.iX,l[1]]:[l[0],X.iY]))),E.push([X.iX,X.iY]),m?u?V[ZC._i_(X.iY)]=X.iX:V[ZC._i_(X.iX)]=X.iY:(K.push([X.iX,X.iY]),D.push([X.iX,X.iY])),(r=c.FK(e+n,0))&&(r.setup(),l=ZC.AQ.JT(X.iX,X.iY,c.S[e+n].iX,c.S[e+n].iY),E.push(u?[X.iX,l[1]]:[l[0],X.iY]),m?u?V[ZC._i_(l[1])+U]=X.iX:V[ZC._i_(l[0])-U]=X.iY:(K.push(u?[X.iX,l[1]]:[l[0],X.iY]),D.push(u?[X.iX,l[1]]:[l[0],X.iY])));break;case"before":(o=c.FK(e-n,0))&&(o.setup(),E.push([c.S[e-n].iX,c.S[e-n].iY],[c.S[e-n].iX,X.iY]),m?u?(V[ZC._i_(X.iY)+U]=c.S[e-n].iX,V[ZC._i_(X.iY)]=c.S[e-n].iX):(V[ZC._i_(c.S[e-n].iX)]=c.S[e-n].iY,V[ZC._i_(c.S[e-n].iX)+U]=X.iY):(K.push([c.S[e-n].iX,c.S[e-n].iY],[c.S[e-n].iX,X.iY]),D.push([c.S[e-n].iX,c.S[e-n].iY],[c.S[e-n].iX,X.iY]))),E.push([X.iX,X.iY]),m?u?V[ZC._i_(X.iY)]=X.iX:V[ZC._i_(X.iX)]=X.iY:(K.push([X.iX,X.iY]),D.push([X.iX,X.iY]));break;case"after":E.push([X.iX,X.iY]),m?u?V[ZC._i_(X.iY)]=X.iX:V[ZC._i_(X.iX)]=X.iY:(K.push([X.iX,X.iY]),D.push([X.iX,X.iY])),(r=c.FK(e+n,0))&&(r.setup(),E.push([c.S[e+n].iX,X.iY],[c.S[e+n].iX,c.S[e+n].iY]),m?u?(V[ZC._i_(X.iY)-U]=c.S[e+n].iX,V[ZC._i_(c.S[e+n].iY)]=c.S[e+n].iX):(V[ZC._i_(c.S[e+n].iX)-U]=X.iY,V[ZC._i_(c.S[e+n].iX)]=c.S[e+n].iY):(K.push([c.S[e+n].iX,X.iY],[c.S[e+n].iX,c.S[e+n].iY]),D.push([c.S[e+n].iX,X.iY],[c.S[e+n].iX,c.S[e+n].iY])))}}H&&X.N6(ZC.Q.EB(c.CP("fl",0),c.H.AA)),(c.R7&&B||c.FY||c.U)&&X.P8(),X.JD=!0}else null!==ZC._n_(c.o["connect-nulls"])&&ZC._b_(c.o["connect-nulls"])||(E.push(null),F.push(null),x.push(null),m||(D.length-1>=0&&D.push(u?[y,D[D.length-1][1]]:[D[D.length-1][0],y]),K.length-1>=0&&K.push(u?[y,D[D.length-1][1]]:[D[D.length-1][0],y]),z=!0))}if("segmented"!==N&&"stepped"!==N||m||D.length-1>=0&&(u?D.push([y,D[D.length-1][1]]):D.push([D[D.length-1][0],y])),"spline"===N){F.push(F[F.length-1]),x.push(x[x.length-1]),E=[],m||D.push(u?[y,x[0]]:[x[0],y]);for(var j=1;j<F.length-1;j++){var q=[F[j-1],F[j],F[j+1],F[j+2]],$=ZC._a_(x[j+1]-x[j]);$=Math.min($,Math.max(c.C.I,c.C.F));var ee=ZC.AQ.Y9(c.Q9,q,$);for(e=0;e<ee.length;e++)null!==ZC._n_(ee[e][0])&&null!==ZC._n_(ee[e][1])?(s=u?[ee[e][1],x[j]+(c.B1.AW?1:-1)*ee[e][0]*$]:[x[j]+(c.B1.AW?-1:1)*ee[e][0]*$,ee[e][1]],E.push(s),m?u?V[ZC._i_(s[1])]=s[0]:V[ZC._i_(s[0])]=s[1]:(D.push(s),K.push(s))):E.push(null)}m||D.push(u?[y,D[D.length-1][1]]:[D[D.length-1][0],y])}if(!m&&K.length>0){var ie=K[K.length-1];u||ie[0]<c.B1.iX+c.B1.I&&(K.push(u?[y,ie[1]]:[ie[0],y]),K.push(u?[y,c.B1.iY]:[c.B1.iX+c.B1.I,y]))}if(m){var te=[],ne=[],ae=[],le=[];for(C in V)ae.push([C,V[C]]);for(C in ae.sort(function(e,i){return e[0]-i[0]}),J)le.push([C,J[C]]);for(le.sort(function(e,i){return e[0]-i[0]}),e=0;e<ae.length;e++)u?te.push([ae[e][1],ae[e][0]]):te.push([ae[e][0],ae[e][1]]);for(e=0;e<le.length;e++)u?ne.push([le[e][1],le[e][0]]):ne.push([le[e][0],le[e][1]]);for(C in(D=te.concat(ne.reverse()))[0]&&D.push(D[0]),J=c.A.RU["s"+c.DZ]={},V)J[C]=V[C]}var oe=new ZC.DT(c);if(oe.copy(c),oe.CZ=!0,oe.L5=!0,oe.AZ=0,oe.AU=0,oe.EX=0,oe.G9=0,oe.N7=c.O6?180:90,oe.parse(),oe.C6=c.HX,oe.Z=c.CP("bl",c.C.CC?0:1),oe.D=D,oe.A3W(),oe.K=c.K+"-area",oe.paint(),c.CZ=!1,ZC.CR.setup(c.QE,c),ZC.CR.paint(c.QE,c,E),c.C.B9&&c.C.B9.I2&&c.QN){var re,se=c.C.B9,Ae=c.mapPointsToPreview(D),Ce=new ZC.DT(c.A);Ce.copy(c),Ce.CZ=!0,Ce.L5=!0,Ce.AZ=0,Ce.AU=0,Ce.EX=0,Ce.G9=0,Ce.C6=c.HX,Ce.D1=[A.iX,A.iY,A.iX+A.I,A.iY+A.F],Ce.K=c.K+"-area-preview",Ce.DK=c.K+"-preview",Ce.Z=se.Z;var ce=c.o["preview-state"];ce&&(null!==ZC._n_(ce["alpha-area"])?(re=ce.alpha,ce.alpha=c.o["preview-state"]["alpha-area"]):ce.alpha=Ce.C6,Ce.append(ce),Ce.parse(),null!==ZC._n_(re)?ce.alpha=re:delete ce.alpha),Ce.D=Ae,Ce.paint();var ue=c.mapPointsToPreview(E),pe=ZC.Q.EB(se.Z,c.H.AA),Ze=new ZC.D0(c);Ze.copy(c),Ze.CZ=!0,Ze.L5=!0,Ze.K=c.K+"-line-preview",Ze.DK=c.K+"-preview",Ze.AZ=1,ce&&(Ze.append(ce),Ze.parse()),ZC.CR.paint(pe,Ze,ue,null,3)}c.CC&&(c.A.D6=K)}}}),ZC.A21=ZC.VY.CA({$i:function(e){this.b(e);var i=this;i.AF="bar",i.sMetaType="bar",i.F4=.1,i.D3=0,i.bKeyWidth=!1,i.YO=-1,i.CF=.1,i.CT=.1,i.EZ=0,i.TI=!1,i.LY=[],i.P3="bg",i.A3H=!0,i.N1=!1},parse:function(){var e=this;if(e.BP=e.NR(),e.C2=e.BP[0],e.B7=e.BP[1],e.BW=e.BP[1],e.A0=e.BP[1],e.AE=e.BP[2],e.NO(),e.b(),"histogram"===e.CW&&(e.F4=e.CF=e.CT=0),e.assign_a([["group-bars","A3H","b"],["show-zero","TI","b"],["offset-values","LY"],["bar-space","F4","fp"],["bar-width","D3","fp"],["key-width","bKeyWidth","b"],["bar-max-width","YO","fp"],["bars-space-left","CF","fp"],["bars-space-right","CT","fp"],["bars-overlap","EZ","fp"],["smart-sampling","N1","b"]]),e.A3H||(e.EZ=1),0===e.F4&&0===e.CF&&0===e.CT&&(e.FC=!1),e.B1=e.C.BL(e.BU("k")[0]),e.CM=e.C.BL(e.BU("v")[0]),null!==ZC._n_(e.o.column)){var i=e.o.column.split("/");if(2===i.length){var t=ZC._i_(i[0]),n=ZC._i_(i[1]),a=e.CF;e.CF>=1&&(a=e.CF/e.B1.AC);var l=e.CT;e.CT>=1&&(l=e.CT/e.B1.AC);var o=1-a-l,r=ZC._x_(o/(3*n+1));e.CF=a+r+3*(t-1)*r,e.CT=1-e.CF-2*r}}},SM:function(){var e,i=this;if(i.RL)return i.RL;if(i.o["fast-dimensions"]&&i.A.A4[0].RL)return i.A.A4[0].RL;i.bKeyWidth&&(i.assign_a([["bar-width","D3","fp"]]),i.D3=((i.B1.CO?i.B1.F:i.B1.I)-i.B1.AB-i.B1.BV)*(i.D3/(i.B1.BJ-i.B1.B3)));var t,n=i.B1.AC*i.Y,a=0;for(i.A.K3[i.AF]=i.A.K3[i.AF]||[],e=0;e<i.A.K3[i.AF].length;e++){var l=i.A.K3[i.AF][e][0];i.A.A4[l].BO[0]===i.BO[0]&&a++}if(i.LP)for(a=0,e=0;e<i.A.A4.length;e++)"bar"===i.A.A4[e].sMetaType&&(a=ZC.BQ(a,i.A.A4[e].S.length));if(null===ZC._n_(i.B1.ET)&&(i.B1.ET=0,i.B1.WK={}),i.CC&&null!==ZC._n_(i.B1.WK["stack-"+i.DZ]))t=i.B1.WK["stack-"+i.DZ];else{for(t=i.B1.ET,e=0;e<i.L;e++)if((i.A.A4[e].AN||"hide"===i.C.getToggleAction())&&i.BO[0]===i.A.A4[e].BO[0]&&i.A.A4[e].AF===i.AF&&(!i.CC||i.A.A4[e].DZ!==i.DZ)&&!i.A.A4[e].HM){t++;break}i.B1.ET=t,i.B1.WK["stack-"+i.DZ]=t}for(var o=!0,r=0,s=[],A=0;A<i.A.A4.length;A++)i.A.A4[A].D3<=1?o=!1:null!==ZC._n_(i.A.A4[A].D3)&&(i.A.A4[A].CC&&-1!==ZC.AV(s,i.A.A4[A].DZ)||(s.push(i.A.A4[A].DZ),r+=i.A.A4[A].D3));var C=i.CF;C<=1&&(C*=n);var c,u=i.CT;u<=1&&(u*=n),C=ZC._i_(C),u=ZC._i_(u);var p,Z,h,d,f=i.EZ;return o?(c=r,0===i.EZ||a<=1?((p=i.F4)<=1&&(p*=c/a),u=(h=n-c-(p=ZC.BQ(0,p))*(a-1))-(C=h*(d=0===u?1:C/u)/(1+d)),C<1&&(C=u=0,p=n-c,a>1&&(p/=a-1),p<0&&(c=n-C-u-(p=0)*(a-1))),Z=(c=ZC.BQ(c,1*a))/a):a>1&&(p=0,Z=c/a,f<=1&&(f*=Z),u=(h=n-(c=a*(Z-(f=ZC.CY(f,Z)))+f)-p*(a-1))-(C=h*(d=0===u?1:C/u)/(1+d)),C<1&&(c-=1-C))):(c=n-C-u,0===i.EZ||a<=1?((p=i.F4)<=1&&(p*=c/a),u=(h=n-c-(p=ZC.BQ(0,p))*(a-1))-(C=h*(d=0===u?1:C/u)/(1+d)),C<1&&(C=u=0,p=n-c,a>1&&(p/=a-1),p<0&&(c=n-C-u-(p=0)*(a-1))),Z=(c=ZC.BQ(c,1*a))/a):a>1&&(p=0,Z=c/a,f>1&&(f=Z/f),f*=Z=c/(a-a*f+f),u=(h=n-c-p*(a-1))-(C=h*(d=0===u?1:C/u)/(1+d)),C<1&&(c-=1-C))),-1!==i.YO&&Z>i.YO&&!i.E.bw&&(i.D3=i.YO),i.RL={AC:n,ET:t,CF:C,CT:u,F4:p,D3:Z,EZ:f},{AC:n,ET:t,CF:C,CT:u,F4:p,D3:Z,EZ:f}},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0);var i=e.FC;e.A2L=!1,e.S8=null;var t=1;e.B1.EF&&(t=e.S.length/(e.B1.DX-e.B1.DC)),0!==e.E7.length||e.HT||e.C.KI||"svg"!==e.H.AA||!(e.B1.A1-e.B1.W>2048||e.B1.EF&&t*(e.B1.A1-e.B1.W)>2048)||(e.A2L=!0,null===ZC._n_(e.o["rect-shortcut"])&&(e.FC=!0)),e.FC||(e.A2L=!1),e.PB(),e.FC=i,e.RefNode=null,e.WA=null}}),ZC.QY=ZC.A21.CA({$i:function(e){this.b(e),this.AF="vbar"},TQ:function(){return new ZC.ZB(this)}}),ZC.R0=ZC.A21.CA({$i:function(e){this.b(e),this.AF="hbar"},TQ:function(){return new ZC.ZA(this)}}),ZC.P7=ZC.VY.CA({$i:function(e,i){this.b(e),this.AF=i||"scatter",this.P3="markerbg",this.bPoly=!1,this.HX=.5},TQ:function(){return new ZC.A5Q(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.A0=e.BP[1],e.AE=e.BP[1],e.B7=e.BP[2],e.BW=e.BP[2],e.NO(),e.b(),e.assign_a([["alpha-area","HX","f",0,1]]),e.B1=e.C.BL(e.BU("k")[0]),e.CM=e.C.BL(e.BU("v")[0])},paint:function(){var e,i,t,n=this;if(n.b(),n.KF=n.CP("bl",0),n._oCtxNode=ZC.Q.EB(n.CP("bl",0),n.H.AA),!n.I3||n.C.AJ["3d"]||"fast"!==n.A0X||0!==n.RX)n.PB(!0);else{var a=null,l=n.B1,o=n.CM;n.XN(!0);var r=new ZC.DT(n.A);for(r.Z=n.CP("bl",1),r.C7=n.CP("bl",0),r.B7=n.BP[3],r.BW=n.BP[3],r.A0=n.BP[2],"bubble"===n.AF||"hbubble"===n.AF?r.AE=n.BP[1]:r.AE=n.BP[2],r.append(n.A2.o),r.parse(),i=0;i<=n.S.length;i++)if(a=n.FK(i)){var s=!1;l.CO?ZC.DS(a.iX,o.iX+(o.AW?o.BV:o.AB)-1,o.iX+o.I-(o.AW?o.AB:o.BV)+1)&&ZC.DS(a.iY,l.iY+(l.AW?l.BV:l.AB)-1,l.iY+l.F-(l.AW?l.AB:l.BV)+1)&&(s=!0):ZC.DS(a.iX,l.iX+(l.AW?l.BV:l.AB)-1,l.iX+l.I-(l.AW?l.AB:l.BV)+1)&&ZC.DS(a.iY,o.iY+(o.AW?o.AB:o.BV)-1,o.iY+o.F-(o.AW?o.BV:o.AB)+1)&&(s=!0),s&&(a.JD=!0,n.S[i].JD=!0,r.K=a.K+"-marker",r.iX=a.iX,r.iY=a.iY,"circle"!==r.DU&&r.parse(),"none"!==n.IZ&&(n.C.IX[n.L]||n.C.KI)&&(r.o={},r.LO={},n.C.CB["p"+n.L]&&n.C.CB["p"+n.L]["n"+i]?r.LO=n.PM?n.PM.o:{}:"none"!==n.O2&&("plot"===n.O2&&n.C.IX[i]||"graph"===n.O2&&n.C.KI)&&(r.LO=n.PI?n.PI.o:{}),r.B7=n.BP[3],r.BW=n.BP[3],r.A0=n.BP[2],"bubble"===n.AF||"hbubble"===n.AF?r.AE=n.BP[1]:r.AE=n.BP[2],r.append(n.A2.o),r.parse()),r.paint())}}if(n.bPoly){for(e=[],i=0,t=n.S.length;i<t;i++)e.push([n.S[i].iX,n.S[i].iY]);e.length&&e.push(e[0]);var A=new ZC.DT(n);A.copy(n),A.C6=n.HX,A.CZ=!0,A.L5=!0,A.AZ=0,A.AU=0,A.EX=0,A.G9=0,A.Z=n.KF,A.D=e,A.A3W(),A.K=n.K+"-area",A.paint(),n.CZ=!1,ZC.CR.setup(n._oCtxNode,n),ZC.CR.paint(n._oCtxNode,n,e)}}}),ZC.RZ=ZC.VY.CA({$i:function(e,i){this.b(e),this.AF=i||"bubble",this.VR=null,this.W4=null,this.A1M=1,this.JE=1,this.AA5="area",this.P3="markerbg"},TQ:function(){return new ZC.A6X(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.A0=e.BP[2],e.AE=e.BP[1],e.B7=e.BP[2],e.BW=e.BP[2],e.NO(),e.b(),e.assign_a([["min-size","VR","i"],["max-size","W4","i"],["scaling","AA5"],["sizing-group","A1M","i"],["size-factor","JE","f"]]),e.B1=e.C.BL(e.BU("k")[0]),e.CM=e.C.BL(e.BU("v")[0]),null===ZC._n_(e.VR)&&(e.VR=15),null===ZC._n_(e.W4)&&(e.W4=.75*Math.min(e.B1.AB,e.B1.BV,e.CM.AB,e.CM.BV),e.W4=ZC.BQ(25,ZC.CY(50,e.W4)))},getSize:function(e){var i,t=this,n=null;switch(e=ZC.BQ(e,t.RM),i=t.WU===t.RM?e-t.RM:(e-t.RM)/(t.WU-t.RM),t.AA5){case"radius":n=t.VR+t.JE*(t.W4-t.VR)*i;break;case"area":case"sqrt":n=t.VR+t.JE*(t.W4-t.VR)*Math.sqrt(i)}return ZC.BQ(t.VR,n)},paint:function(){var e=this;if(e.b(),e.KF=e.CP("bl",0),null!==ZC._n_(e.W4)){e.WU=-ZC.MAX,e.RM=ZC.MAX;for(var i=e.A.A4,t=0,n=i.length;t<n;t++)if(i[t].A1M===e.A1M)for(var a=0,l=i[t].S.length;a<l;a++)e.WU=ZC.BQ(e.WU,ZC._a_(i[t].S[a].SI)),e.RM=ZC.CY(e.RM,ZC._a_(i[t].S[a].SI))}e.PB(!0)}}),ZC.VV=ZC.HV.CA({$i:function(e){this.b(e);var i=this;i.AF="pie",i.BO=["scale","scale-v","scale-r"],i.PS=0,i.DH=0,i.TI=!1,i.A7O=!0,i.C3=null,i.P3="bg"},TQ:function(){return new ZC.A8V(this)},parse:function(){var e,i,t=this;null===ZC._n_(t.o["value-box"])&&(t.o["value-box"]={}),"ring"!==t.A.A.o.type&&"ring3d"!==t.A.A.o.type||(t.PS=.35),t.BP=t.NR(),t.C2=t.BP[0],t.A0=t.BP[1],t.AE=t.BP[2],t.BW=t.BP[0],t.B7=t.BP[0],t.NO(),t.b(),t.C3=new ZC.D0(t),t.C.A.B8.load(t.C3.o,["graph.plot.value-box.connector",t.AF+".plot.value-box.connector"]),null!==ZC._n_(e=t.C.o.plot)&&null!==ZC._n_(e["value-box"])&&null!==ZC._n_(i=e["value-box"].connector)&&t.C3.append(i),t.C3.append(t.o["value-box"].connector),t.assign_a([["offset","DV","fp"],["slice","PS","fp"],["show-zero","TI","b"],["detach","A7O","b"],["ref-angle","DH","i"]]),t.DH%=360;for(var n=0,a=t.S.length;n<a;n++)t.S[n]&&(t.S[n].CN=t.PS,t.S[n]&&(t.C.E["plot"+t.L+".visible"]||"hide"===t.C.getToggleAction())&&(null===ZC._n_(t.A.KM[n])&&(t.A.KM[n]=0),t.A.KM[n]+=ZC._f_(t.S[n].AD)))},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0),e.PB(!0)}}),ZC.TO=ZC.HV.CA({$i:function(e){this.b(e);var i=this;i.AF="nestedpie",i.BO=["scale"],i.U2=0,i.SN=0,i.DH=0,i.C3=null,i.P3="bg",i.aBandWidths=null},TQ:function(){return new ZC.A49(this)},parse:function(){var e,i,t=this;t.BP=t.NR(),t.C2=t.BP[0],t.A0=t.BP[1],t.AE=t.BP[2],t.BW=t.BP[0],t.B7=t.BP[0],t.NO(),t.b(),t.U&&(t.C3=new ZC.D0(t),t.C.A.B8.load(t.C3.o,["graph.plot.value-box.connector",t.AF+".plot.value-box.connector"]),null!==ZC._n_(e=t.C.o.plot)&&null!==ZC._n_(e["value-box"])&&null!==ZC._n_(i=e["value-box"].connector)&&t.C3.append(i),t.C3.append(t.o["value-box"].connector)),t.assign_a([["slice-start","U2","fp"],["offset","U2","fp"],["slice","U2","fp"],["band-space","SN","fp"],["ref-angle","DH","i"],["band-widths","aBandWidths"]]),t.DH%=360;for(var n=0,a=t.S.length;n<a;n++)t.S[n]&&(t.C.E["plot"+t.L+".visible"]||"hide"===t.C.getToggleAction())&&(null===ZC._n_(t.A.KM[n])&&(t.A.KM[n]=0),t.A.KM[n]+=ZC._f_(t.S[n].AD))},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0),e.PB(!0)}}),ZC.XE=ZC.HV.CA({$i:function(e){this.b(e);var i=this;i.AF="radar",i.SV=3,i.BO=["scale-k","scale-v","scale"],i.HX=.5,i.CW="line",i.A60=null,i.XC=!1,i.D=[],i.AH=[]},TQ:function(){return new ZC.A76(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.B7=e.BP[1],e.A0=e.BP[3],e.AE=e.BP[3],e.NO(),e.b(),e.applyRGBA(),e.assign_a([["active-area","XC","b"],["alpha-area","HX","f",0,1],["angle-space","A60","f"]]),e.B1=e.C.BL("scale-k"),e.CM=e.C.BL("scale-v"),"range"===e.CW&&(e.A0X="normal",e.I3=!1)},paint:function(){var e=this;e.b(),e.B1.V.length===e.V.length&&-1===ZC.AV(e.V,null)||(e.A0X="normal",e.I3=!1),e.KF=ZC.AK(e.C.K+"-plot-"+e.L+"-bl-0-c"),e.A56=ZC.Q.EB(e.CP("bl",0),e.H.AA),e.QE=ZC.Q.EB(e.CP("bl",2),e.H.AA),e.PB(!0)}}),ZC.A4P=ZC.A21.CA({$i:function(e){this.b(e);var i=this;i.F4=.2,i.CF=.28,i.CT=.28,i.EZ=0,i.FJ=null,i.A34=[],i.Q0=[],i.AA0=!0,i.P3="bg"},ABZ:function(e){var i;if("goal"===e){if(null!==ZC._n_(i=this.FJ.o.tooltip))return i;if(null!==ZC._n_(i=this.FJ.o["tooltip-text"]))return{text:i}}return{}},parse:function(){var e,i=this;if(i.BP=i.NR(),i.b(),null!==ZC._n_(i.A34=i.o.goals))for(var t=0,n=i.A34.length;t<n;t++)null!==ZC._n_(i.A34[t])?"string"==typeof i.A34[t]?i.Q0[t]=ZC.AV(i.CM.JK,i.A34[t]):i.Q0[t]=ZC._f_(i.A34[t]):i.Q0[t]=null;i.FJ=new ZC.HL(i),i.FJ.copy(i),i.FJ.append({"background-color":i.BP[3]}),i.FJ.o["tooltip-text"]="%node-goal-value",i.H.B8.load(i.FJ.o,["("+i.AF+").plot.goal"],!0,!0),null!==ZC._n_(e=i.o.goal)&&i.FJ.append(e),i.FJ.parse()}}),ZC.TC=ZC.A4P.CA({$i:function(e){this.b(e),this.AF="vbullet"},TQ:function(){return new ZC.A5R(this)}}),ZC.TF=ZC.A4P.CA({$i:function(e){this.b(e),this.AF="hbullet"},TQ:function(){return new ZC.A5P(this)}}),ZC.XG=ZC.VY.CA({$i:function(e){this.b(e);var i=this;i.AF="piano",i.CW="alpha",i.A7I="plot-max",i.QG=.2,i.UU=1,i.P3="bg"},TQ:function(){return new ZC.A7H(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.B7=e.BP[1],e.BW=e.BP[1],e.A0=e.BP[2],e.AE=e.BP[1],e.NO(),e.b(),e.assign_a([["min-ratio","QG","f",0,1],["max-ratio","UU","f",0,1],["reference","A7I",""]]),e.QG>=e.UU&&(e.QG=.2,e.UU=1),e.B1=e.C.BL(e.BU("k")[0]),e.CM=e.C.BL(e.BU("v")[0])},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0),e.A4J=e.A3B=-ZC.MAX,e.Y8=e.WV=ZC.MAX,e.A67=e.A4L=0;for(var i=0,t=e.A.A4.length;i<t;i++)for(var n=e.A.A4[i],a=0,l=n.S.length;a<l;a++)if(n.S[a]){var o=ZC._f_(n.S[a].AD);n.L===e.L&&(e.A4J=ZC.BQ(e.A4J,o),e.Y8=ZC.CY(e.Y8,o),e.A67+=o),e.A3B=ZC.BQ(e.A3B,o),e.WV=ZC.CY(e.WV,o),e.A4L+=o}e.PB()}}),ZC.W7=ZC.VY.CA({$i:function(e){this.b(e);var i=this;i.KZ=.1,i.O9=.1,i.LZ=0,i.A2I="dynamic",i.OR=[],i.VI=[],i.P3="bg"},parse:function(){var e,i,t,n,a=this;if(a.BP=a.NR(),a.C2=a.BP[0],a.B7=a.BP[1],a.BW=a.BP[1],a.A0=a.BP[2],a.AE=a.BP[1],a.NO(),a.b(),a.assign_a([["start-width","A2I"],["min-exit","LZ","fp"],["space-entry","KZ","fp"],["offset","KZ","fp"],["offset","O9","fp"]]),null!==ZC._n_(t=a.o.entry))for(t instanceof Array||(t=[t]),e=0,i=t.length;e<i;e++){var l=new ZC.DT(a);l.o=t[e],l.parse(),a.OR.push(l)}if(null!==ZC._n_(n=a.o.exit))for(n instanceof Array||(n=[n]),e=0,i=n.length;e<i;e++){var o=new ZC.DT(a);o.o=n[e],o.parse(),a.VI.push(o)}a.B1=a.C.BL(a.BU("k")[0]),a.CM=a.C.BL(a.BU("v")[0])},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0),e.PB()}}),ZC.VA=ZC.W7.CA({$i:function(e){this.b(e),this.AF="vfunnel"},TQ:function(){return new ZC.A5V(this)}}),ZC.V8=ZC.W7.CA({$i:function(e){this.b(e),this.AF="hfunnel"},TQ:function(){return new ZC.A5U(this)}}),ZC.VB=ZC.A21.CA({$i:function(e){this.b(e);var i=this;i.AF="stock",i.CW="candlestick",i.MV={size:0},i.P3="bg"},TQ:function(){return new ZC.A7B(this)},parse:function(){this.b()},paint:function(){this.b(),this.paintPreview()},paintPreview:function(){var e=this,i=e.C.BL(e.BU("v")[0]),t=i.AT(i.H6);if(e.C.B9&&e.C.B9.I2&&e.QN){for(var n=e.C.P,a=e.C.B9,l=[],o=[],r=!0,s=0,A=e.S.length;s<A;s++)if(null!==ZC._n_(e.S[s])&&null!==ZC._n_(e.S[s].DP[2])){var C=i.AT(e.S[s].DP[2]);r&&(o.push([e.S[s].iX,t]),r=!1),l.push([e.S[s].iX,C]),o.push([e.S[s].iX,C])}o.length&&o.push([o[o.length-1][0],t]);var c=e.mapPointsToPreview(o),u=e.o.preview||{};if("area"===(u.type||"area")){var p=new ZC.DT(e.A);p.copy(e),p.append({"background-color":e.BW,"alpha-area":.2}),p.append(u),p.parse(),p.CZ=!0,p.L5=!0,p.AZ=0,p.AU=0,p.EX=0,p.G9=0,p.C6=ZC._f_(p.o["alpha-area"]),p.D1=[n.iX,n.iY,n.iX+n.I,n.iY+n.F],p.K=e.K+"-area-preview",p.Z=a.Z,p.D=c,p.paint()}var Z=e.mapPointsToPreview(l),h=ZC.Q.EB(a.Z,e.H.AA),d=new ZC.D0(e);d.copy(e),d.append({"line-color":e.BW,"line-width":1}),d.append(u),d.parse(),ZC.CR.paint(h,d,Z,null,3)}}}),ZC.X7=ZC.HV.CA({$i:function(e){this.b(e);var i=this;i.AF="gauge",i.SV=3,i.BO=["scale-r","scale-v","scale"],i.HX=.5,i.HW=[10,0,0,0,0],i.P3="bg"},TQ:function(){return new ZC.A7C(this)},parse:function(){var e,i=this;i.BP=i.NR(),i.C2=i.BP[0],i.B7=i.BP[1],i.A0=i.BP[3],i.AE=i.BP[3],i.NO(),i.b(),i.assign_a([["alpha-area","HX","f",0,1],["indicator","HW"]]),null!==ZC._n_(e=i.o.csize)&&(i.HW[0]=ZC._i_(e)),i.HW=[ZC._f_(i.HW[0]||"10"),ZC._f_(i.HW[1]||"0"),ZC._f_(i.HW[2]||"0"),ZC._f_(i.HW[3]||"0"),ZC._f_(i.HW[4]||"0")]},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0),e.PB(!0)}}),ZC.SQ=ZC.VY.CA({$i:function(e){this.b(e);var i=this;i.AF="range",i.Y=1,i.CW="segmented",i.SV=3,i.HX=.5},TQ:function(){return new ZC.A7E(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.B7=e.BP[1],e.A0=e.BP[0],e.AE=e.BP[1],e.NO(),e.b(),e.applyRGBA(),e.ZQ("alpha-area","HX","f",0,1),e.B1=e.C.BL(e.BU("k")[0]),e.CM=e.C.BL(e.BU("v")[0])},PB:function(){var e,i,t=this,n=t.O6;t.XN(!1);var a=t.C.P;t.Y=1;var l=n?a.F:a.I;t.B1.EF||!t.Q8&&5*(t.B1.A1-t.B1.W)>l&&(t.Y=ZC._i_(5*(t.B1.A1-t.B1.W)/l));var o=t.B1.EF;if(o&&t.PY[0]===ZC.MAX&&t.PY[1]===-ZC.MAX&&(o=!1),o)for(e=0,i=t.S.length;e<i;e++)t.S[e]&&ZC.DS(t.S[e].BT,t.B1.V[t.B1.W],t.B1.V[t.B1.A1])&&(t.S[e].Z=t.KF,t.S[e].MM="min",t.S[e].paint(),t.S[e].MM="max",t.S[e].paint(),delete t.S[e].E["intersect.index"]);else for(e=t.B1.W;e<=t.B1.A1;e+=t.Y)t.S[e]&&(t.S[e].MM="min",t.S[e].paint(),t.S[e].MM="max",t.S[e].paint(),delete t.S[e].E["intersect.index"])},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0),e.A56=ZC.Q.EB(e.CP("bl",1),e.H.AA),e.QE=ZC.Q.EB(e.CP("bl",2),e.H.AA),e.PB(),e.D=null,e.D6=null,e.ZR=null,e.S4=null}}),ZC.XJ=ZC.VV.CA({$i:function(e){this.b(e);this.AF="pie3d",this.NK=-1},parse:function(){this.b(),this.assign_a([["thickness","NK","ia"]])},TQ:function(){return new ZC.A72(this)}}),ZC.UE=ZC.QY.CA({$i:function(e){this.b(e),this.AF="vbar3d"},TQ:function(){return new ZC.A6V(this)},parse:function(){var e=this;e.b(),null===ZC._n_(e.o["border-color"])&&(e.BW=e.BP[0]),null===ZC._n_(e.o["line-color"])&&(e.B7=e.BP[0])},paint:function(){this.b(),this.sharedZScale()}}),ZC.VZ=ZC.R0.CA({$i:function(e){this.b(e),this.AF="hbar3d"},TQ:function(){return new ZC.A6Y(this)},parse:function(){var e=this;e.b(),null===ZC._n_(e.o["border-color"])&&(e.BW=e.BP[0]),null===ZC._n_(e.o["line-color"])&&(e.B7=e.BP[0])}}),ZC.UC=ZC.QK.CA({$i:function(e){this.b(e),this.AF="line3d"},TQ:function(){return new ZC.A6W(this)},parse:function(){var e=this;e.b(),null===ZC._n_(e.o["border-color"])&&(e.BW=e.BP[1])},paint:function(){this.b(),this.sharedZScale()}}),ZC.UB=ZC.QV.CA({$i:function(e){this.b(e),this.AF="area3d"},TQ:function(){return new ZC.A6S(this)},parse:function(){var e=this;e.b(),null===ZC._n_(e.o["border-color"])&&(e.BW=e.BP[1])},paint:function(){this.b(),this.sharedZScale()}}),ZC.YU=ZC.HV.CA({$i:function(e){this.b(e);var i=this;i.AF="venn",i.AC0=[],i.A9Z=[],i.BO=["scale"],i.P3="bg"},TQ:function(){return new ZC.A85(this)},parse:function(){var e=this;e.BP=e.NR(),e.C2=e.BP[0],e.BW=e.BP[1],e.A0=e.BP[3],e.AE=e.BP[3],e.NO(),e.b(),e.assign_a([["join","AC0"],["share","A9Z"]])},paint:function(){var e=this;e.b(),e.KF=e.CP("bl",0),e.PB(!0)}});var LG={$i:function(e){this.b(e);var i=this;i.C=e.A.A,i.H=i.C.A,i.L=-1,i.AD=null,i.DP=[],i.CS=null,i.BT=null,i.CK=null,i.JO=[],i.I2=!1,i.PU=!0,i.N=i,i.JD=!1,i.A26=!1},H3:function(e,i){this.b(this.A,e,i,this.LT(null,!1),this.A.MJ)},UY:function(){return[this.iX,this.iY,{reference:this,center:!0}]},ACE:function(){return[this.iX,this.iY]},getTooltipPosition:function(e,i,t){var n,a,l,o,r=this;switch(r.paint(!0),n=r.iX,a=r.iY,l=r.I,o=r.F,i){case"center":n=r.iX+l/2,a=r.iY+o/2;break;case"top":n=r.iX+l/2,a=r.iY,a=t?a-t:a;break;case"bottom":n=r.iX+l/2,a=r.iY+o,a=t?a+t:a;break;case"left":n=r.iX,a=r.iY+o/2,n=t?n-t:n;break;case"right":n=r.iX+l,a=r.iY+o/2,n=t?n+t:n;break;default:n+=r.BM,a+=r.BH}return{x:n,y:a}},setNodeData:function(e){var i=this;for(var t in e)e.hasOwnProperty(t)&&(i.A.I3?i.A.S[i.L][t]=e[t]:i.E[t]=e[t])},getNodeData:function(e){return this.A.I3?this.A.S[this.L][e]:this.E[e]},AB2:function(){var e,i,t=this,n=t.C.E,a=t.A.L;null===ZC._n_(n.update)&&(n.update={});var l=n.update,o=""+t.AD,r=t.A.MP();for(ZC.P5(o)&&ZC._f_(o)<0&&"currency"===r.negation&&(o=ZC._a_(ZC._f_(o))),r.utc=t.C.UL,r.timezone=t.C.NB,o=ZC.AP.G2(o,r,t.A),l["plot-"+a+"-value"]=o,l["plot-"+a+"-value-0"]=o,e=0,i=t.DP.length;e<i;e++)l["plot-"+a+"-value-"+(e+1)]=t.DP[e];for(l["plot-value"]=l["plot-value-0"]=o,e=0,i=t.DP.length;e<i;e++)l["plot-value-"+(e+1)]=t.DP[e];for(var s in t.A.KH){var A=null;A="object"==typeof t.A.KH[s]&&t.A.KH[s].length?t.A.KH[s][t.L]:t.A.KH[s],l["plot-"+a+"-data-"+s]=A}},T6:function(){var e,i,t=this,n=t.A.B1,a=t.A.CM,l=[n.W,n.A1,a.W,a.A1];if(t.A.I3&&(t.CS=t.A.S[t.L].CS),t.JO!==l){n.CO?(null!==t.BT?t.iY=n.AT(t.BT):t.iY=n.IB(t.L),t.A.CC&&"100%"===t.A.KQ?t.A.A.F8[t.L]["%total-"+t.A.DZ]>0?t.iX=a.AT(100*t.CS/t.A.A.F8[t.L]["%total-"+t.A.DZ]):t.iX=a.AT(100*t.CS):t.iX=a.AT(t.CS+0)):(null!==t.BT?t.iX=n.AT(t.BT):t.A.LP?"bar"===t.A.sMetaType?t.iX=n.IB(t.A.R4):t.iX=n.IB(t.A.R4)+t.A.RK+t.L*(n.AC-2*t.A.RK)/(t.A.S.length-1)-n.AC/2:"log"===n.C1?t.iX=n.AT(t.L):t.iX=n.IB(t.L),t.A.CC&&"100%"===t.A.KQ?t.A.A.F8[t.L]["%total-"+t.A.DZ]>0?t.iY=a.AT(100*t.CS/t.A.A.F8[t.L]["%total-"+t.A.DZ]):t.iY=a.AT(100*t.CS):t.iY=a.AT(t.CS+0)),t.A.I3&&(t.A.S[t.L].iX=t.iX,t.A.S[t.L].iY=t.iY),t.JO=l}t.I2||(0!==t.A.E7.length||-1===ZC.AV(["line","area","vbar","hbar","line3d","area3d","vbar3d","hbar3d"],t.A.AF)||t.A.o.override?ZC.A5.browser.mozilla?(t.copy(t.A),t.E7=t.A.E7,t.DE(),t.parse(!1),t.N=t):t.A.o.override?(t.copy(t.A),t.E7=t.A.E7,t.DE(),t.parse(!1),t.N=t):(e=t.ACJ(t.A.E7),null===ZC._n_(i=t.A.A68[e])?(t.copy(t.A),t.E7=t.A.E7,t.DE(),t.parse(!1),t.N=t,t.A.A68[e]=t):t.N=i):t.N=t.A,t.A.o.override&&(t.N.E.plotidx=t.A.L,t.N.E.nodeidx=t.L,t.N.parse(!1)),t.I2=!0)},a11y:function(){var e=this,i="";if(e.H.bA11y){if(e.A.I3){var t=this.A.FK(e.L,1,!0);t&&(i=t.JV(this.C.A7.o.text||this.A.A7.o.text||this.A.JB))}else i=e.JV(this.C.A7.o.text||this.A.A7.o.text||this.A.JB);return e.A.AM&&-1===i.indexOf(e.A.AM)&&(i=e.A.AM+":"+i),i=i.replace(/<.+?>/gi," "),'tabindex="0" aria-label="Series '+(this.A.L+1)+" of "+this.A.A.A4.length+", point "+(this.L+1)+" of "+this.A.S.length+". "+i+'"'}return""},A96:function(){var e,i=this;if(i.o.value instanceof Array&&(i.CK=i.o.value.join(" "),"string"==typeof i.o.value[0]?-1!==(e=ZC.AV(i.A.B1.IQ,i.o.value[0]))?i.BT=e:(i.A.B1.IQ.push(i.o.value[0]),i.BT=i.A.B1.IQ.length-1):i.BT=parseFloat(i.o.value[0]),"string"==typeof i.o.value[1]?-1!==(e=ZC.AV(i.A.CM.JK,i.o.value[1]))?i.AD=e:(i.A.CM.JK.push(i.o.value[1]),i.AD=i.A.CM.JK.length-1):i.AD=parseFloat(i.o.value[1]),null!==i.BT&&i.A.V4(i.BT,i.L),i.A.YL>0&&i.o.value.length>i.A.YL))for(var t=i.o.value.length-i.A.YL;t<i.o.value.length;t++)i.DP.push(i.o.value[t])},parse:function(e){var i=this;if(i.E.plotidx=i.A.L,i.E.nodeidx=i.L,i.K=i.A.K+"-node-"+i.L,null===ZC._n_(e)&&(e=!0),e){if(i.o.value instanceof Array||i.A.AA0)i.A96();else if(i.CK=i.o.value,"string"==typeof i.o.value){var t=ZC.AV(i.A.CM.JK,i.o.value);-1!==t?i.AD=t:(i.A.CM.JK.push(i.o.value),i.AD=i.A.CM.JK.length-1)}else i.AD=i.o.value;null===i.CS&&(i.CS=i.AD)}else i.b()},J2:function(e){return this.JV(e,{})},getFormatValue:function(){return this.AD},JV:function(AM,ER,LN,bUrl){var s=this,G,CK,BC,i,A6,D5,oRE;void 0===LN&&(LN=!1);var oPPI=s.A.JM,oPS=s.A.A,EY,PH;if(!bUrl&&"javascript:"===AM.substring(0,11))try{var EC=AM.replace("javascript:","").replace("()","");eval(EC)&&(G=0===s.DP.length?s.AD:[s.AD].concat(s.DP),AM=eval(EC).call(s,G,{nodeindex:s.L,plotindex:s.A.L,plotid:s.A.H8,nodeinfo:s.LT(null,!1),plotinfo:s.A.UW()})||AM)}catch(e){}if(AM+="",s.A.A78){for(EY in CK=s.getFormatValue(),null!==ZC._n_(s.A.CM.JK[CK])&&s.A26&&(CK=s.A.CM.JK[CK]),AM=AM.replace(/%node-numeric-value/g,s.AD).replace(/%node-value/g,CK).replace(/%previous-node-value/g,s.A.S[s.L-1]?s.A.S[s.L-1].AD:null).replace(/%next-node-value/g,s.A.S[s.L+1]?s.A.S[s.L+1].AD:null).replace(/%node-index/g,s.L).replace(/%plot-text/g,s.A.AM).replace(/%plot-index/g,s.A.L).replace(/%plot-count/g,oPS.A4.length).replace(/%p/g,s.A.L).replace(/%P/g,oPS.A4.length).replace(/%v/g,CK).replace(/%V/g,s.AD).replace(/%i/g,s.L).replace(/%n/g,s.L),s.A.KH)PH="",PH=s.A.KH[EY]instanceof Array?null!==s.A.KH[EY][s.L]?s.A.KH[EY][s.L]:"":null!==s.A.KH[EY]?s.A.KH[EY]:"",oRE=new RegExp("%data-"+EY,"g"),AM=AM.replace(oRE,PH);return AM}var PK="",S1="",RN="",WF="",R=s.C.BL(s.A.BU("k")[0]),X=s.C.BL(s.A.BU("v")[0]);R&&(null!==s.BT?PK=S1=RN=s.BT:(null!==ZC._n_(R.V[s.L])&&(PK=S1=RN=R.V[s.L]),null!==ZC._n_(R.BX[s.L])&&(RN=S1=R.BX[s.L]))),null!==ZC._n_(G=s.A.B1.IQ[PK])&&"number"==typeof PK&&(PK=G),null!==ZC._n_(G=s.A.B1.IQ[S1])&&"number"==typeof S1&&(S1=G),null!==ZC._n_(G=s.A.B1.IQ[RN])&&"number"==typeof RN&&(RN=G),WF=null!==ZC._n_(s.A.AM)?s.A.AM:"Series "+(s.A.L+1),s.A.LP&&s.A.A.A4[s.L]&&(WF=s.A.A.A4[s.L].AM||"Series "+s.L);var TV=(WF+"").split(/\s+/),A61=PK;R&&(BC=R.MP(),ER&&ER["transform-date"]&&ZC._cp_({"transform-date":!0,"transform-date-format":ER["transform-date-format"]},BC),BC.utc=s.C.UL,BC.timezone=s.C.NB,RN=S1=ZC.AP.G2(PK,BC,R,!0),null===s.BT&&(null===ZC._n_(R.BX[s.BT])&&null===ZC._n_(R.BX[s.L])||(S1=RN=R.BX[s.BT]||R.BX[s.L])),BC["transform-date"]&&(RN=ZC.AP.G2(RN,BC,R,!0)));var A4D=(S1+"").split(/\s+/),A6P=(RN+"").split(/\s+/),W2=(PK+"").split(/\s+/);CK=s.getFormatValue(),s.A.CM&&null!==ZC._n_(s.A.CM.JK[CK])&&s.A26&&(CK=s.A.CM.JK[CK]);var OO=ZC.P5(CK)&&ZC._f_(CK)<0;if(BC=s.A.MP(),ZC._cp_(ER,BC),OO&&"currency"===BC.negation&&(CK=ZC._a_(ZC._f_(CK))),BC.utc=s.C.UL,BC.timezone=s.C.NB,CK=ZC.AP.G2(CK,BC,s.A,!(!X||!X.FG)&&X.FG),"%v"===AM&&"%vv"!==AM||"%node-value"===AM)return CK;if("%t"===AM||"%plot-text"===AM)return WF;var CV=s.CV||[],oNode_,YP,A6B,oPlot_,p,pLen;if(X&&X.NE){var YW=X.MP();null===ZC._n_(YW.decimals)&&(YW.decimals=0);var AB1=X.CO?X.NE(this.iX,!0,"piano"===s.A.AF):X.NE(this.iY,!0,"piano"===s.A.AF),WL=X.FQ(0,AB1,YW);CV.push(["%scale-value-value",WL],["%vv",WL]),null!==ZC._n_(G=X.BX[s.L])?CV.push(["%scale-value-label",G],["%vl",G]):CV.push(["%scale-value-label",WL],["%vl",WL])}if(X&&(-1!==AM.indexOf("%scale-value-text")||-1!==AM.indexOf("%vt")))for(-1!==(G=ZC.AV(X.V,s.AD))&&null!==ZC._n_(X.BX)&&null!==ZC._n_(X.BX[G])?CV.push(["%scale-value-text",X.BX[G]],["%vt",X.BX[G]]):CV.push(["%scale-value-text",s.AD],["%vt",s.AD]),oRE=-1!==AM.indexOf("%vt(")?new RegExp("(%vt)\\(([0-9]*)\\)"):new RegExp("(%scale-value-text)\\(([0-9]*)\\)");D5=oRE.exec(AM);)YP="",""!==(G=D5[2])&&(A6B=ZC._i_(G),null!==ZC._n_(oPlot_=s.A.A.A4[A6B])&&(oNode_=oPlot_.FK(s.L),null!==oNode_&&(YP=oNode_.JV(D5[1])))),AM=AM.replace(D5[0],YP),""!==YP&&CV.push([D5[0],YP]);for(EY in null!==ZC._n_(s.A.LY)&&null!==ZC._n_(s.A.LY[s.L])&&CV.push(["%offset-values",s.A.LY[s.L]]),s.A.A.A1C&&CV.push(["%stack-top",-1!==ZC.AV(s.A.A.A1C,s.A.L)?1:0]),s.A.KH)PH="",PH=s.A.KH[EY]instanceof Array?null!==s.A.KH[EY][s.L]?s.A.KH[EY][s.L]:"":null!==s.A.KH[EY]?s.A.KH[EY]:"","number"==typeof PH&&(PH=ZC.AP.G2(PH,BC,s.A,!(!X||!X.FG)&&X.FG)),CV.push(["%data-"+EY,PH]);for(i=0;i<A4D.length;i++)CV.push(["%scale-key-label-"+i,A4D[i]],["%kl"+i,A4D[i]]);for(i=0;i<A6P.length;i++)CV.push(["%scale-key-text-"+i,A6P[i]],["%kt"+i,A6P[i]]);for(i=0;i<W2.length;i++)CV.push(["%scale-key-value-"+i,W2[i]],["%kv"+i,W2[i]],["%k"+i,W2[i]]);for(p=0,pLen=oPS.A4.length;p<pLen;p++)null!==ZC._n_(oPS.A4[p].S[s.L])&&CV.push(["%plot-"+p+"-value",oPS.A4[p].S[s.L].AD]);CV.push(["%scale-key-label",S1],["%scale-key-text",RN],["%scale-key-value",PK],["%scale-key-value-ts",A61],["%kvts",A61],["%kt",RN],["%kl",S1],["%kv",PK],["%k",PK],["%node-value",CK],["%v",CK],["%node-numeric-value",s.AD],["%previous-node-value",s.A.S[s.L-1]?s.A.S[s.L-1].AD:null],["%next-node-value",s.A.S[s.L+1]?s.A.S[s.L+1].AD:null],["%V",s.AD],["%node-index",s.L],["%node-x",s.iX],["%node-y",s.iY],["%chart-width",s.H.I],["%chart-height",s.H.F],["%i",s.L],["%n",s.L],["%node-count",s.A.S.length],["%N",s.A.S.length]);var ABN=oPPI["%plot-sum"],A3R=ABN+"",ABQ=oPPI["%plot-average"],A3Q=ABQ+"",A8L=ZC._f_(oPS.F8["%pstack-"+s.L+"-"+s.A.DZ+"-sum"]||"0"),A4N=A8L+"",ABC=ZC._f_(A8L/oPS.F8["%pstack-"+s.L+"-"+s.A.DZ+"-stack-length"]),A5D=String(ABC),A9F=String(oPS.F8["%pstack-"+s.L+"-"+s.A.DZ+"-stack-length"]),A70=0;null!==ZC._n_(oPS.F8)&&null!==ZC._n_(oPS.F8[s.L])&&(A70=ZC._f_(oPS.F8[s.L]["%total-"+s.A.DZ]||"0"));var A39=A70+"";A3R=ZC.AP.G2(A3R,BC),A3Q=ZC.AP.G2(A3Q,BC),A39=ZC.AP.G2(A39,BC),A4N=ZC.AP.G2(A4N,BC),A5D=ZC.AP.G2(A5D,BC),CV.push(["%node-error-plus",s.E["node-error-plus"]],["%node-error-minus",s.E["node-error-minus"]],["%stack-total",A4N],["%stack-average",A5D],["%stack-length",A9F],["%total",A39],["%plot-min-index",oPPI["%plot-min-index"]],["%pmi",oPPI["%plot-min-index"]],["%plot-max-index",oPPI["%plot-max-index"]],["%pxi",oPPI["%plot-max-index"]],["%plot-min-value",oPPI["%plot-min-value"]],["%pmv",oPPI["%plot-min-value"]],["%plot-max-value",oPPI["%plot-max-value"]],["%pxv",oPPI["%plot-max-value"]],["%plot-sum",A3R],["%psum",A3R],["%plot-average",A3Q],["%pavg",A3Q],["%plot-values",oPPI["%plot-values"]],["%pv",oPPI["%plot-values"]]);var A9M=100*s.AD/oPPI["%plot-sum"],YX=A9M+"";null!==ZC._n_(BC.decimals)&&(YX=ZC.AP.G2(YX,BC)),CV.push(["%plot-percent",YX],["%pper",YX]);var bNpv=!1,WE,AX,J,C0;for(i=0,A6=CV.length;i<A6;i++)if("%npv"===CV[i][0]){bNpv=!0;break}if(!bNpv&&null!==ZC._n_(s.A.A.F8)&&null!==ZC._n_(s.A.A.F8[s.L])){var JP=100*s.AD/s.A.A.F8[s.L]["%total-"+s.A.DZ],HO=JP+"";null!==ZC._n_(BC.decimals)&&(HO=ZC.AP.G2(HO,BC)),CV.push(["%node-percent-value",HO],["%npv",HO])}for(i=0;i<TV.length;i++)CV.push(["%plot-text-"+i,TV[i]],["%t"+i,TV[i]]);for(CV.push(["%plot-text",WF],["%t",WF],["%plot-description",s.A.P2],["%plot-index",s.A.L],["%p",s.A.L],["%plot-count",oPS.A4.length],["%P",oPS.A4.length],["%id",s.H.K],["%graphid",s.C.K.replace(s.H.K+"-graph-","")]),-1!==AM.indexOf("%negation")&&(OO&&"currency"===BC.negation?(CV.push(["%negation","-"]),OO=!1):CV.push(["%negation",""])),CV.push(["%node-x",s.iX],["%node-y",s.iY],["%node-width",s.I],["%node-height",s.F],["%node-size",s.E["marker.size"]||1]),zingchart.DEV.SORTTOKENS&&CV.sort(ZC.A1H),oRE=new RegExp("\\(([^(]+?)\\)\\(([0-9]*)\\)(\\(*)([0-9]*)(\\)*)");D5=oRE.exec(AM);){WE="";var CQ=s.A.L,D9=s.L;""!==(G=D5[2])&&(CQ=ZC._i_(G)),""!==(G=D5[4])&&(D9=ZC._i_(G)),null!==(J=oPS.A4[CQ])&&(AX=J.FK(D9,3),null!==AX&&(WE=AX.JV(D5[1],ER))),AM=AM.replace(D5[0],WE)}if(-1!==AM.indexOf("%prop-")){oRE=new RegExp("%prop-([a-zA-Z0-9-]+)");for(var oMap=s.getPMap();D5=oRE.exec(AM);)null!==ZC._n_(oMap[D5[1]])&&null!==ZC._n_(s[oMap[D5[1]]])&&(AM=AM.replace(D5[0],s[oMap[D5[1]]]))}if(-1!==AM.indexOf("%linecolor"))for(oRE=new RegExp("%linecolor([0-9]*)");D5=oRE.exec(AM);)""===D5[1]?(C0=s.N||s,C0.B7||(C0=s.A)):C0=oPS.A4[D5[1]],AM=AM.replace(D5[0],C0&&C0.B7||"#000");if(-1!==AM.indexOf("%backgroundcolor"))for(oRE=new RegExp("%backgroundcolor([0-9]*)");D5=oRE.exec(AM);)""===D5[1]?(C0=s.N||s,C0.B7||(C0=s.A)):C0=oPS.A4[D5[1]],AM="markerbg"===s.A.P3?AM.replace(D5[0],C0&&C0.A2&&C0.A2.A0||"#000"):AM.replace(D5[0],C0&&C0.A0||"#000");if(-1!==AM.indexOf("%color"))for(oRE=new RegExp("%color([0-9]*)");D5=oRE.exec(AM);)""===D5[1]?(C0=s.N||s,C0.B7&&"line"!==s.A.P3||(C0=s.A)):C0=oPS.A4[D5[1]],AM="line"===s.A.P3?AM.replace(D5[0],C0&&C0.B7||"#000"):"markerbg"===s.A.P3?AM.replace(D5[0],C0&&C0.A2&&C0.A2.A0||"#000"):AM.replace(D5[0],C0&&C0.A0||"#000");for(AM=ZC.AP.YN(AM,this),i=0,A6=CV.length;i<A6;i++)oRE=new RegExp(CV[i][0],"g"),AM="undefined"==typeof CV[i][1]?AM.replace(oRE,""):LN?AM.replace(oRE,encodeURIComponent(CV[i][1])):AM.replace(oRE,CV[i][1]);return AM=AM.replace(new RegExp("%data-([a-zA-Z0-9]+)","g"),""),OO&&"currency"===BC.negation&&(AM="-"+AM),AM},paint:function(){},paint_:function(){},ABF:function(){return{color:this.N.A0}},Y4:function(){return{"border-color":this.N.A0,"background-color":this.N.AE,color:this.N.C2}},A8E:function(){return this.Y4()},GW:function(e,i){var t,n,a,l=this;if(i||(i=1),l.A.NQ&&l.A.NQ.length>0&&l.A.NQ.length>i-1&&l.GW(e,i+1),l.AN||"pie"===l.A.AF||"pie3d"===l.A.AF){var o,r=1===i?l.A.U:l.A.NQ[i-2];if(r){if(l.A.A74)(o=l.A.A74).K=l.K+"-value-box-"+i,o.Z=o.C7=l.H.usc()?l.H.mc("top"):l.C.AJ["3d"]||l.H.K9?ZC.AK(l.C.K+"-plots-vb-c"):ZC.AK(l.C.K+"-plot-"+l.A.L+"-vb-c"),o.IL=l.H.usc()?ZC.AK(l.C.A.K+"-top"):ZC.AK(l.C.A.K+"-text"),o.E.plotidx=l.A.L,o.E.nodeidx=l.L,a=ZC.AP.O3(o.o,l.A.o),o.JV=function(e){return l.JV(e,a)},o.parse();else{o=new ZC.DN(l.A),r.o.rules||l.A.U.HT||(n="all",null!==ZC._n_(t=r.o.type)&&(n=t),"pie"===l.C.AF||"nestedpie"===l.C.AF||"pie3d"===l.C.AF||"all"!==n||l.A.NQ&&0!==l.A.NQ.length||(l.A.A74=o)),o.append(r.o),l.appendToValueBox&&!e&&(o.parse(),o.append(l.appendToValueBox(o))),o.GL=l.C.K+"-value-box "+l.C.K+"-plot-"+l.A.L+"-value-box zc-value-box",o.K=l.K+"-value-box-"+i,o.Z=o.C7=l.H.usc()?l.H.mc("top"):l.C.AJ["3d"]||l.H.K9?ZC.AK(l.C.K+"-plots-vb-c"):ZC.AK(l.C.K+"-plot-"+l.A.L+"-vb-c"),o.IL=l.H.usc()?ZC.AK(l.C.A.K+"-top"):ZC.AK(l.C.A.K+"-text"),a=ZC.AP.O3(o.o,l.A.o),o.JV=function(e){return l.JV(e,a)};var s=l.ABF(o);if(null!==ZC._n_(t=s.color)&&(o.C2=t),null!==ZC._n_(t=s["background-color"])&&(o.A0=o.AE=t),o.E.plotidx=l.A.L,o.E.nodeidx=l.L,l.A.U.HT&&(l.A.U.H3(l.A.U,o,null,l.LT(null,!1)),o.parse()),o.parse(),o.J2=function(e){return l.J2(e)},o.DE()&&(a=o.overrideFormat(a),o.parse()),!l.A.YJ){var A=new ZC.DN(l.A);A.copy(o),l.A.YJ=A}if(n="all",null!==ZC._n_(t=r.o.type)&&(n=t),o.AN){o.AN=!1;var C=l.A.o["value-box"].text||"";if("values("===n.substring(0,7)){var c=n.substring(7,n.length).replace(")","").split(",");-1!==ZC.AV(c,l.AD)&&(o.AN=!0)}else{var u=n.split(","),p={min:"%plot-min-value",max:"%plot-max-value",first:"%plot-min-index",last:"%plot-max-index"};for(var Z in p)-1!==ZC.AV(u,Z)&&(("first"!==Z&&"last"!==Z||l.L!==l.A.JM[p[Z]])&&("min"!==Z&&"max"!==Z||l.AD!==l.A.JM[p[Z]])||("object"==typeof C&&null!==ZC._n_(C[Z])&&(o.o.text=C[Z],o.parse()),o.AN=!0));-1!==ZC.AV(u,"all")&&(o.AN=!0)}}}if(l.C.E["plot"+l.A.L+".visible"]||(o.E["css-display"]="none"),e)return o;if(o.AN&&null!==ZC._n_(o.AM)&&""!==o.AM){var h=l.AC8(o);o.E.positioninfo=h,o.iX=h[0],o.iY=h[1];var d={};if(-1!==o.iX&&-1!==o.iY){var f=!1;if(null!==ZC._n_(o.o.overlap)&&!ZC._b_(o.o.overlap)){d={x:o.iX,y:o.iY,width:o.I,height:o.F};for(var _=0,g=l.A.A.YZ.length;_<g;_++)if(ZC.AQ.XM(d,l.A.A.YZ[_])){f=!0;break}}f||(l.C.E["plot"+l.A.L+".visible"]||(o.E["css-display"]="none"),o.E.lbltype="vb"+l.C.L,o.paint(),o.EK(),l.A.A.YZ.push(d),!o.K9&&ZC.AK(l.H.K+"-map")&&l.A.A.HE.push(ZC.AP.O5(l.C.K,o)))}}return o}}},setupValueBoxWH:function(e){if(null!==ZC._n_(e.o.width)){var i=ZC.II(e.o.width);i<=1&&(i=this.I*i),e.I=i}if(null!==ZC._n_(e.o.height)){var t=ZC.II(e.o.height);t<=1&&(t=this.I*t),e.F=t}return e},AC8:function(e){var i,t=this,n=t.C.BL(t.A.BU("v")[0]),a=t.AD>=n.LA&&!n.AW||t.AD<n.LA&&n.AW?-1:1,l="auto";if(null!==ZC._n_(i=e.o.placement)&&(l=i),"auto"===l){var o=null!==ZC._n_(t.A.S[t.L-1])?t.A.S[t.L-1].AD:t.AD,r=null!==ZC._n_(t.A.S[t.L+1])?t.A.S[t.L+1].AD:t.AD;o>=t.AD&&t.AD<=r?l="bottom":o<=t.AD&&t.AD>=r?l="top":o>=t.AD&&t.AD>=r?l=o/t.AD>t.AD/r?"bottom":"top":o<=t.AD&&t.AD<=r&&(l=t.AD/o>r/t.AD?"top":"bottom")}var s=e.I,A=e.F,C=t.iX-s/2,c=t.iY-A/2;switch(l){case"top":c-=a*(A/2+4);break;case"bottom":c+=a*(A/2+4);break;case"left":C-=s/2+4;break;case"right":C+=s/2+4}return t.C.AJ["3d"]||(C=ZC.BQ(t.C.P.iX-s/2,C),C=ZC.CY(t.C.P.iX+t.C.P.I-s/2,C),c=ZC.BQ(t.C.P.iY-A,c),c=ZC.CY(t.C.P.iY+t.C.P.F,c)),null!==ZC._n_(e.o.x)&&(C=e.iX),null!==ZC._n_(e.o.y)&&(c=e.iY),[ZC._i_(C),ZC._i_(c)]},P8:function(e,i){var t,n,a,l,o,r=this;if("undefined"==typeof r.A.bBS&&(r.A.bBS=-1===ZC.AV(["bubble","hbubble","scatter","hscatter"],r.A.AF)),null!==ZC._n_(r.A.o["markers-on-top"])&&(r.A.bBS=ZC._b_(r.A.o["markers-on-top"])),!r.C.OA||!r.A.bBS){null===ZC._n_(e)&&(e=!1),null===ZC._n_(i)&&(i=!1);var s=r.C.P.E.tolerance||2;if(ZC.DS(r.iX,r.C.P.iX-s,r.C.P.iX+r.C.P.I+s)&&ZC.DS(r.iY,r.C.P.iY-s,r.C.P.iY+r.C.P.F+s)){var A=r.C.K+"-node-area "+r.C.K+"-plotset-plot-"+r.A.L+"-node-area zc-node-area";if(-1===ZC.AV(r.H.KR,"skip_segment_tracking")&&r.A.FY){if(r.A.Y1&&!zingchart.DEV.SKIPTRACKERS){var C=r.getNodeData("points");-1!==ZC.AV(r.H.KR,"use_fast_mode")&&-1!==ZC.AV(["line","area"],r.A.AF)&&void 0===C&&r.paint(!0),""!==(a="undefined"==typeof r.E.polypoints?ZC.AQ.PR(ZC.AQ.Z0(C,ZC.BQ(6,r.A.AZ/2)),4):ZC.AQ.PR(C,4))&&r.A.A.HE.push(ZC.Q.G0("poly",r.A.EA,r.N.IV)+'class="'+A+'" id="'+r.K+'" coords="'+a+'" />')}if(("area"===r.A.AF||"area3d"===r.A.AF||"radar"===r.A.AF&&("area"===r.A.CW||"range"===r.A.CW))&&r.A.XC){var c=r.getNodeData("pointsarea");""!==(a=ZC.AQ.PR(c,4))&&r.A.A.HE.push(ZC.Q.G0("poly",r.A.EA,r.A.IV)+'class="'+A+'" id="'+r.K+'--area" coords="'+a+'" />')}}if(r.A.U||!r.A.I3||!r.A.A2.o||"none"!==r.A.A2.o.type&&(null===ZC._n_(r.A.A2.o.visible)||ZC._b_(r.A.A2.o.visible))){if(i||r.A.R7){if(r.A.HB)l=r.A.HB,"svg"!==r.H.AA&&(e?(o=new ZC.CE(r.C,r.iX-ZC.AO.E2,r.iY-ZC.AO.E3,r.A.E["z-start"]||0),l.iX=ZC._x_(o.ED[0]),l.iY=ZC._x_(o.ED[1]),r.E["3dxy"]=[l.iX,l.iY]):(l.iX=ZC._x_(r.iX),l.iY=ZC._x_(r.iY)),l.E.plotidx=r.A.L,l.E.nodeidx=r.L,l.K=r.K+"-marker",l.parse(!0));else{if(r.I3?r.A._oMarker?l=r.A._oMarker:r.A._oMarker=l=new ZC.DT(r.A):l=new ZC.DT(r.A),l.K=r.K+"-marker",l.E["p-width"]=r.A.B1.AC,l.E["p-height"]=r.A.CM.AC,r.A.bBS)l.Z=r.A.CP("fl",0),l.C7=r.A.CP("fl",0);else if(l.Z=r.A.CP("bl",1),l.C7=r.A.CP("bl",0),Object&&Object.keys&&Object.keys(r.C.CB).length>0){var u=r.C.CB["p"+r.A.L];"none"!==r.A.IZ&&u&&u["n"+r.L]&&(l.Z=r.A.CP("bl",2))}if(e?(o=new ZC.CE(r.C,r.iX-ZC.AO.E2,r.iY-ZC.AO.E3,r.A.E["z-start"]||0),l.iX=ZC._x_(o.ED[0]),l.iY=ZC._x_(o.ED[1]),r.E["3dxy"]=[l.iX,l.iY]):(l.iX=ZC._x_(r.iX),l.iY=ZC._x_(r.iY)),l.B7=r.A.BP[3],l.BW=r.A.BP[3],l.A0=r.A.BP[2],"bubble"===r.A.AF||"hbubble"===r.A.AF?l.AE=r.A.BP[1]:l.AE=r.A.BP[2],l.append(r.A.A2.o),null!==ZC._n_(r.E["marker.size"])&&(l.AI=r.E["marker.size"]),l.E.plotidx=r.A.L,l.E.nodeidx=r.L,"none"!==r.A.IZ&&(r.C.IX[r.A.L]||r.C.KI))if(r.C.CB["p"+r.A.L]&&r.C.CB["p"+r.A.L]["n"+r.L]){if(l.LO={},r.A.PM&&ZC._cp_(r.A.PM.o,l.LO),l.LO.rules){var p=new ZC.DT(r.A);p.o=l.LO,p.parse(),p.J2=function(e){return r.J2(e)},p.DE()&&(l.LO=p.o)}}else"none"!==r.A.O2&&("plot"===r.A.O2&&r.C.IX[r.A.L]||"graph"===r.A.O2&&r.C.KI)&&(l.LO=r.A.PI?r.A.PI.o:{});null!==ZC._n_(t=r.A.o.marker)&&null!==ZC._n_(t.styles)&&null!==ZC._n_(n=t.styles[r.L])&&("string"==typeof n?l.append({"background-color":ZC.AP.QU(n,20),"line-color":ZC.AP.JN(n,20),"border-color":ZC.AP.JN(n,20)}):l.append(n)),l.parse(),l.J2=function(e){return r.J2(e)},l.DE()&&l.parse()}if(r.E["marker.size"]=ZC.BQ(2.02,r.E["marker.size"]||l.AI),l.DK=A,!(e||ZC.DS(l.iX,r.C.P.iX-2,r.C.P.iX+r.C.P.I+2)&&ZC.DS(l.iY,r.C.P.iY-2,r.C.P.iY+r.C.P.F+2)))return;if(l.HT&&(r.A.YH=!1,l.H3(l,l,null,r.LT(null,!1)),l.parse()),r.NC=l,l.AN&&"none"!==l.AF){var Z=function(){if(r.A.bBS||r.N6(ZC.Q.EB(r.A.CP("bl",0),r.H.AA)),r.E["marker.type"]=l.DU,r.A.FY&&-1===ZC.AV(r.H.KR,"skip_marker_tracking")&&!zingchart.DEV.SKIPTRACKERS){var e=r.E["3dxy"]?r.E["3dxy"][0]:r.iX,i=r.E["3dxy"]?r.E["3dxy"][1]:r.iY,t=parseInt(e+l.BM+ZC.MAPTX,10),n=parseInt(i+l.BH+ZC.MAPTX,10),a=parseInt(ZC.BQ(ZC.mobile?6:3,r.E["marker.size"]+1)*(ZC.mobile?1.25:1.05),10),o=!0;if("undefined"!=typeof r.A.aLastMarkerXY)Math.sqrt((t-r.A.aLastMarkerXY[0])*(t-r.A.aLastMarkerXY[0])+(n-r.A.aLastMarkerXY[1])*(n-r.A.aLastMarkerXY[1]))<zingchart.DEV.MINTRACKERDIFF&&(o=!1);else r.A.aLastMarkerXY=[t,n];o&&(r.A.aLastMarkerXY=[t,n],-1!==ZC.AV(["pie","square","rect","rectangle"],l.DU)?r.A.A.HE.push(ZC.Q.G0("poly",r.A.EA,r.A.IV)+'class="'+A+'" id="'+r.K+'--marker" coords="'+l.FF()+'" />'):r.A.A.HE.push(ZC.Q.G0("circle",r.A.EA,r.A.IV)+'class="'+A+'" '+r.a11y()+' id="'+r.K+'--marker" coords="'+t+","+n+","+a+'" />'))}if(r.A.U&&(r.A.E.vboxid=r.K,r.GW()),!r.A.bBS&&r.C.B9&&r.C.B9.I2&&r.A.QN&&r.C.B9.AN){var s=r.C.P,C=r.C.B9,c=C.AR,u=r.A.HB||l,p=new ZC.DT(r.A);p.copy(u);var Z=(r.iX-s.iX)/s.I,h=(r.iY-s.iY)/s.F,d=Math.min(c.F/s.F,c.I/s.I);p.iX=c.iX+c.AU+Z*(c.I-2*c.AU),p.iY=c.iY+c.AU+h*(c.F-2*c.AU),p.K=r.K+"-marker-preview",p.DK=r.A.K+"-preview";var f=u.AI;null!==ZC._n_(r.E["marker.size"])&&(f=r.E["marker.size"]),p.AI=ZC.BQ(2.02,.9*d*f),p.Z=p.C7=C.Z,p.parse(),p.paint()}},h=!1;if((!r.A.bBS||"radar"===r.A.AF&&"dots"===r.A.CW)&&(h=!0),r.A.GG&&h&&!r.C.HH){var d=l,f={},_=l.C6,g=l.AI,v=l.iX,b=l.iY;d.iX=v,d.iY=b,f.x=v,f.y=b;var B,m=r.A.L7,E=r.C.P;for(B in d.C6=0,f.alpha=_,3===m?(d.AI=2,f.size=g):8===m?(d.iX=v-E.iX,f.x=v):9===m?(d.iX=v+E.iX,f.x=v):10===m?(d.iY=b-E.iY,f.y=b):11===m&&(d.iY=b+E.iY,f.y=b),r.A.FV)d[ZC.E4.GN[ZC.EE(B)]]=r.A.FV[B],f[ZC.EE(B)]=r.N[ZC.E4.GN[ZC.EE(B)]];if(null===ZC._n_(r.C.EN)&&(r.C.EN={}),null!==ZC._n_(r.C.EN[r.A.L+"-"+r.L]))for(B in r.C.EN[r.A.L+"-"+r.L])d[ZC.E4.GN[ZC.EE(B)]]=r.C.EN[r.A.L+"-"+r.L][B];r.C.EN[r.A.L+"-"+r.L]={},ZC._cp_(f,r.C.EN[r.A.L+"-"+r.L]);var D=new ZC.E4(d,f,r.A.JF,r.A.L6,ZC.E4.RI[r.A.L8],function(){Z()});D.AX=r,D.OF=function(){r.N6(ZC.Q.EB(r.A.CP("bl",0),r.H.AA))},r.LM(D)}else{var K="circle"===l.DU?"circle":"path";if(r.A.HI){var F=function(i,t){var n=i.cloneNode(!1),a=r.iX,o=r.iY;if(e){var s=new ZC.CE(r.C,a-ZC.AO.E2,o-ZC.AO.E3,r.A.E["z-start"]||0);a=ZC._x_(s.ED[0]),o=ZC._x_(s.ED[1]),r.E["3dxy"]=[a,o]}n.setAttribute("transform","translate("+ZC._i_(a-l.iX)+","+ZC._i_(o-l.iY)+") "+(n.getAttribute("transform")||"")),n.setAttribute("id",t),"bubble"!==r.A.AF&&"hbubble"!==r.A.AF||n.setAttribute("r",r.E["marker.size"]),i.parentNode.appendChild(n)};l.M8&&F(r.A.RA,r.K+"-marker-sh-"+K),F(r.A.HI,r.K+"-marker-"+K),l.DA&&F(r.A.QB,r.K+"-marker-imgfill")}else{l.paint();var x=l.A0!==l.AE;if(!r.C.IX[r.A.L]&&r.A.YH&&!x)if("svg"===r.H.AA){if(-1===ZC.AV(["pie","square","rect","rectangle","cross","plus","custom"],l.DU))if(r.A.HB=l,zingchart.DEV.DOMFRAGMENTS&&document.querySelector){for(var I in r.H.G1)r.A.HI||(r.A.HI=r.H.G1[I].querySelector("#"+r.K+"-marker-"+K)),l.M8&&!r.A.RA&&(r.A.RA=r.H.G1[I].querySelector("#"+r.K+"-marker-sh-"+K)),l.DA&&!r.A.QB&&(r.A.QB=r.H.G1[I].querySelector("#"+r.K+"-marker-imgfill")||r.H.G1[I].querySelector("#"+r.K+"-marker-path-imgfill"));r.A.HI||(r.A.HI=ZC.AK(r.K+"-marker-"+K),l.M8&&(r.A.RA=ZC.AK(r.K+"-marker-sh-"+K)),l.DA&&(r.A.QB=ZC.AK(r.K+"-marker-imgfill")))}else r.A.HI=ZC.AK(r.K+"-marker-"+K),l.M8&&(r.A.RA=ZC.AK(r.K+"-marker-sh-"+K)),l.DA&&(r.A.QB=ZC.AK(r.K+"-marker-imgfill")||ZC.AK(r.K+"-marker-path-imgfill"))}else"bubble"!==r.A.AF&&"hbubble"!==r.A.AF&&(e||(r.A.HB=l))}"svg"===r.H.AA&&r.A.applyJsRuleSvg(r.A.A2,r.K+"-marker-"+K,r.LT()),Z()}}else r.A.U&&r.GW()}else r.A.U&&r.GW()}}}},LM:function(e,i){var t,n=this,a=n.C.LW,l=a.PG,o=n.A.TL;switch(o){default:i&&a.add(i),a.add(e);break;case 1:case 2:case 3:if(i){var r="all";if(1===o?r="plots-group-"+n.L+"-area":2===o&&(r="nodes-group-"+n.A.L+"-area"),null===ZC._n_(l[r])){var s=new ZC.VK(r);a.A9K(s,i.XI)}l[r].add(i)}if(t="all",1===o?t="plots-group-"+n.L:2===o&&(t="nodes-group-"+n.A.L),null===ZC._n_(l[t])){var A=new ZC.VK(t);a.A9K(A,e.XI)}l[t].add(e)}},TR:function(e){var i=this;i.A.I3&&i.A.bXY&&(i.T6(),e&&("scatter"!==i.A.AF&&"hscatter"!==i.A.AF&&"bubble"!==i.A.AF&&"hbubble"!==i.A.AF||i.paint(!0)));var t=i.A.BP;i.M5({layer:e,type:"shape",id:"marker",marker:!0,initcb:function(){this.DU=i.E["marker.type"],this.iX=i.iX,this.iY=i.iY,"bubble"===i.A.AF||"hbubble"===i.A.AF?(this.AE=t[3],this.A0=t[2]):(this.B7=t[3],this.BW=t[3],this.A0=t[2],this.AE=t[1]),this.AI=i.E["marker.size"]}})},A1F:function(e){var i=this;i.M5({layer:e,type:"line",id:"line",initcb:function(){this.B7=i.A.BP[3]}})},M5:function(e){if(!ZC.move){var i,t,n,a,l,o,r=this,s=e.layer||"hover",A=e.id||"",C=!1;switch(r.GJ=null,null!==ZC._n_(i=e.marker)&&(C=ZC._b_(i)),s){case"hover":null!==ZC._n_(r.C.CB["p"+r.A.L])&&null!==ZC._n_(r.C.CB["p"+r.A.L]["n"+r.L])||(n=C?r.A.GA:r.A.IE,a="hover");break;case"highlight":n=C?r.A.V6:r.A.S2,a="hover"}if(null!==ZC._n_(e.state)&&(n=e.state),n&&r.C.E["plot"+r.A.L+".visible"]&&n.AN){switch(e.type){case"box":(o=new ZC.HL(r.A)).PU=!0;break;case"line":o=new ZC.DT(r.A),l=ZC.Q.EB(r.C.K+"-"+a+"-c",r.H.AA),o.CZ=!1;break;case"shape":o=new ZC.DT(r.A);break;case"area":o=new ZC.DT(r.A),l=ZC.Q.EB(r.C.K+"-"+a+"-c",r.H.AA)}if(C&&(o.E["p-width"]=r.A.B1.AC,o.E["p-height"]=r.A.CM.AC),zingchart.DEV.PLOTSHLAYER&&"hover"===a?o.Z=o.C7=ZC.AK(r.C.K+"-plots-hover-c"):o.Z=o.C7=ZC.AK(r.C.K+"-"+a+"-c"),o.K=r.K+"-"+(""!==A?A+"-":"")+s,o.E.plotidx=r.A.L,o.E.nodeidx=r.L,"hover"!==s&&(o.A2A=!0),e.initcb&&e.initcb.call(o),o.append(n.o),e.parsecb&&e.parsecb.call(o),"hover"===s&&null!==ZC._n_(i=r.A.o)&&null!==ZC._n_(i.styles)&&null!==ZC._n_(t=i.styles[r.L])&&("string"==typeof t?o.append({"background-color":t,"line-color":t,"border-color":t}):o.append(t)),null!==ZC._n_(i=r.A.o[s+"-state"])&&null!==ZC._n_(i.styles)&&null!==ZC._n_(t=i.styles[r.L])&&("string"==typeof t?o.append({"background-color":t,"line-color":t,"border-color":t}):o.append(t)),r.A.HT&&r.H3(o,s),"hover"===s&&r.A.A2&&r.A.A2.HT&&(r.A.A2.H3(r.A.A2,o,null,r.LT(null,!1)),o.parse()),o.parse(),o.J2=function(e){return r.J2(e)},o.DE()&&o.parse(),o.AN){switch(e.setupcb&&e.setupcb.call(o),e.type){case"box":case"shape":o.locate(2),o.paint();break;case"line":ZC.CR.setup(l,o),"plot"===r.A.A3K?ZC.CR.paint(l,o,r.A.V3):ZC.CR.paint(l,o,r.getNodeData("points"));break;case"area":"spline"!==r.A.CW&&(null!==ZC._n_(i=n.o["alpha-area"])&&(o.C6=ZC._f_(i)),ZC.CR.setup(l,o),o.paint())}r.GJ=o}}}},N6:function(){},setup:function(){},A0W:function(){},LD:function(){var e=this;ZC.Q.EU([e.K+"-hover-gradient",e.K+"-marker-hover-gradient",e.H.K+"-tooltip-text-gradient",e.H.K+"-tooltip-text-sh-gradient"])},LT:function(e,i){var t=this;void 0===i&&(i=!0);var n=!1;"none"!==t.A.IZ&&t.C.CB&&t.C.CB["p"+t.A.L]&&t.C.CB["p"+t.A.L]["n"+t.L]&&(n=!0);var a={id:t.C.A.K,graphid:t.C.K,graphindex:t.C.L,plotid:t.A.H8,plotindex:t.A.L,nodeindex:t.L,key:null===t.BT?t.L:t.BT,scaleval:t.A.B1?t.A.B1.V[null===t.BT?t.L:t.BT]:null,scaletext:t.A.B1?t.A.B1.FQ(t.L,null===t.BT?null:t.A):null,value:t.AD,text:i?t.JV(t.A.JB):t.A.JB,ev:e?ZC.A5.BZ(e):null,x:t.iX,y:t.iY,width:t.I,height:t.F,size:t.E["marker.size"]||1,selected:n};for(var l in t.A.KH)t.A.KH[l]instanceof Array?null!==ZC._n_(t.A.KH[l][t.L])&&(a["data-"+l]=t.A.KH[l][t.L]):a["data-"+l]=t.A.KH[l];return a},X4:function(e,i){ZC.AP.BY("node_"+i,this.H,this.LT(e))}};ZC.LG=ZC.DN.CA(LG),ZC.A38=ZC.LG.CA({setup:function(){this.T6()},ABF:function(){return{color:this.A.I3?this.A.B7:this.N.B7}},Y4:function(){return{"background-color":this.N.B7,"border-color":this.N.B7,color:this.N.C2}},getTooltipPosition:function(e,i){return this.b(e,i,this.NC.AI)},paint:function(e){var i=this;void 0===e&&(e=!1),i.b();var t=i.A.O6,n=i.A.QE,a=i.A.B1,l=i.A.S;if(i.setup(),!i.A.I3||i.C.AJ["3d"]||i.A.FY){i.N.CZ=i.CZ=!1,i.N.C7=i.A.CP("bl",0);var o=[],r=i.A.CW;(i.C.OA||i.A.U8)&&"spline"===i.A.CW&&(r="segmented");var s="undefined"!=typeof i.A.GB?i.A.GB:i.A.Y,A="undefined"!=typeof i.A.HD?i.A.HD:i.A.Y,C=!0,c=!0;(null===ZC._n_(l[i.L-s])||"log"!==a.C1&&!a.EF&&i.L<=a.W)&&(C=!1);var u,p,Z,h,d=i.A.LP?i.A.S.length:a.A1;switch((null===ZC._n_(l[i.L+A])||"log"!==a.C1&&!a.EF&&i.L>=d)&&(c=!1),r){default:C&&(i.A.FK(i.L-s,0).setup(),i.A.UT&&(u=ZC.AQ.JT(i.A.S[i.L-s].iX,i.A.S[i.L-s].iY,i.A.S[i.L].iX,i.A.S[i.L].iY),o.push(u))),o.push([i.iX,i.iY]),c&&(i.A.FK(i.L+A,2).setup(),u=i.A.UT?ZC.AQ.JT(i.A.S[i.L].iX,i.A.S[i.L].iY,i.A.S[i.L+A].iX,i.A.S[i.L+A].iY,i.N.C6):[l[i.L+A].iX,l[i.L+A].iY],o.push(u));break;case"spline":if(i.A.D&&(o=i.A.D),i.A.D=[],l[i.L+1]){var f=[],_=[];for(p=-1;p<3;p++)l[i.L+p]?(i.A.FK(i.L+p,2).setup(),t?(f.push(l[i.L+p].iX),_.push(l[i.L+p].iY)):(f.push(l[i.L+p].iY),_.push(l[i.L+p].iX))):0===f.length?t?(_.push(i.iY),f.push(i.iX)):(_.push(i.iX),f.push(i.iY)):(f.push(f[f.length-1]),_.push(_[_.length-1]));var g=ZC._a_(_[2]-_[1]);g=Math.min(g,Math.max(i.C.I,i.C.F));var v=ZC.AQ.Y9(i.A.Q9,f,g);if(i.A.UT){for(p=0;p<ZC._i_(v.length/2)+(1===i.N.C6?1:0);p++)v[p]&&(t?o.push([v[p][1],i.iY+(a.AW?1:-1)*v[p][0]*g]):o.push([i.iX+(a.AW?-1:1)*v[p][0]*g,v[p][1]]));for(p=ZC._i_(v.length/2)-1,Z=v.length;p<Z;p++)v[p]&&(t?i.A.D.push([v[p][1],i.iY+(a.AW?1:-1)*v[p][0]*g]):i.A.D.push([i.iX+(a.AW?-1:1)*v[p][0]*g,v[p][1]]))}else for(p=0;p<ZC._i_(v.length);p++)t?o.push([v[p][1],i.iY+(a.AW?1:-1)*v[p][0]*g]):o.push([i.iX+(a.AW?-1:1)*v[p][0]*g,v[p][1]])}break;case"stepped":if(C)switch(i.A.FK(i.L-s,0).setup(),u=ZC.AQ.JT(i.A.S[i.L-s].iX,i.A.S[i.L-s].iY,i.A.S[i.L].iX,i.A.S[i.L].iY),i.A.SL){default:t?o.push([l[i.L-s].iX,u[1]],[i.iX,u[1]]):o.push([u[0],l[i.L-s].iY],[u[0],i.iY]);break;case"before":o.push([i.A.S[i.L-s].iX,l[i.L-s].iY],[i.A.S[i.L-s].iX,i.iY]);break;case"after":}if(o.push([i.iX,i.iY]),c)switch(i.A.FK(i.L+A,0).setup(),u=ZC.AQ.JT(i.A.S[i.L+s].iX,i.A.S[i.L+s].iY,i.A.S[i.L].iX,i.A.S[i.L].iY),i.A.SL){default:o.push(t?[i.iX,u[1]]:[u[0],i.iY]);break;case"before":break;case"after":o.push([i.A.S[i.L+s].iX,i.iY],[i.A.S[i.L+s].iX,l[i.L+A].iY])}break;case"jumped":C?(i.A.FK(i.L-s,0).setup(),u=ZC.AQ.JT(i.A.S[i.L-s].iX,i.A.S[i.L-s].iY,i.A.S[i.L].iX,i.A.S[i.L].iY),o.push(t?[i.iX,u[1]]:[u[0],i.iY])):o.push(t?[i.iX,i.iY-a.AC/2]:[i.iX-a.AC/2,i.iY]),o.push([i.iX,i.iY]),c?(i.A.FK(i.L+A,0).setup(),u=ZC.AQ.JT(i.A.S[i.L+s].iX,i.A.S[i.L+s].iY,i.A.S[i.L].iX,i.A.S[i.L].iY),o.push(t?[i.iX,u[1]]:[u[0],i.iY])):o.push(t?[i.iX,i.iY+a.AC/2]:[i.iX+a.AC/2,i.iY])}if(i.setNodeData({points:o}),"ready"!==i.C.MA&&(i.A.V3=i.A.V3.concat(o)),!e&&!i.C.AJ["3d"]){var b=i.N=i.A.ID(i,i.N),B=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area";if(b.DK=B,b.K=i.K,i.A.HT&&i.H3(b),ZC.CR.setup(n,b),i.paintPreview(b,o),i.A.GG&&!i.C.HH){var m=new ZC.DT(i),E={};m.copy(b),m.K=i.K,m.Z=i.A.CP("bl",1),m.C7=i.A.CP("bl",0),m.D=o,E.points=o;var D=[],K=i.A.L7,F=i.C.P;for(m.C6=0,E.alpha=b.C6,p=0;p<o.length;p++)2===K?D[p]=[o[p][0],F.iY+F.F/2]:3===K?D[p]=[o[p][0],F.iY-5]:4===K?D[p]=[o[p][0],F.iY+F.F+5]:5===K?D[p]=[F.iX-5,o[p][1]]:6===K?D[p]=[F.iX+F.I+5,o[p][1]]:7===K?D[p]=[F.iX+F.I/2,o[p][1]]:8===K?D[p]=[o[p][0]-F.I,o[p][1]]:9===K?D[p]=[o[p][0]+F.I,o[p][1]]:10===K?D[p]=[o[p][0],o[p][1]-F.F]:11===K?D[p]=[o[p][0],o[p][1]+F.F]:12===K?D[p]=[(o[0][0]+o[o.length-1][0])/2,o[0][1]]:13===K&&(D[p]=[o[0][0],(o[0][1]+o[o.length-1][1])/2]),K>1&&(m.D=D,E.points=o);for(h in i.A.FV)m[ZC.E4.GN[ZC.EE(h)]]=i.A.FV[h],E[ZC.EE(h)]=b[ZC.E4.GN[ZC.EE(h)]];if(i.C.EN||(i.C.EN={}),null!==ZC._n_(i.C.EN[i.A.L+"-"+i.L]))for(h in i.C.EN[i.A.L+"-"+i.L])m[ZC.E4.GN[ZC.EE(h)]]=i.C.EN[i.A.L+"-"+i.L][h];i.C.EN[i.A.L+"-"+i.L]={},ZC._cp_(E,i.C.EN[i.A.L+"-"+i.L]);var x=new ZC.E4(m,E,i.A.JF,i.A.L6,ZC.E4.RI[i.A.L8],function(){I()});x.AX=i,x.OF=function(){i.N6(ZC.Q.EB(i.A.CP("bl",1),i.H.AA))},x.IK=n,i.LM(x)}else ZC.CR.paint(n,b,o),I()}}function I(){!i.C.OA&&ZC.DS(i.iX,a.iX-1,a.iX+a.I+1)&&ZC.DS(i.iY,a.iY-1,a.iY+a.F+1)&&(i.P8(),i.N6(ZC.Q.EB(i.A.CP("bl",1),i.H.AA)),i.A.U&&i.A.U.AN&&i.A.E.vboxid!==i.K&&i.GW())}},paintPreview:function(e,i){var t=this;if(t.C.B9&&t.C.B9.I2&&t.A.QN){var n,a=t.A.mapPointsToPreview(i);t.A.WB?n=t.A.WB:(n=new ZC.D0(t),t.A.WB=n),n.copy(e),n.K=t.K+"-line-preview",n.DK=t.A.K+"-preview";var l=ZC.Q.EB(t.C.B9.Z,t.H.AA);n.AZ=1;var o=t.o["preview-state"];o&&(n.append(o),n.parse()),ZC.CR.paint(l,n,a,null,3)}},A0W:function(e){var i=this;ZC.move||(i.A1F(e),i.A.R7&&i.TR(e))}}),ZC.A35=ZC.LG.CA({setup:function(){this.T6()},ABF:function(){return{color:this.A.I3?this.A.B7:this.N.B7}},Y4:function(){return{"background-color":this.N.B7,"border-color":this.N.B7,color:this.N.C2}},getTooltipPosition:function(e,i){return this.b(e,i,this.NC.AI)},paint:function(e){var i,t,n,a,l,o,r,s,A=this;void 0===e&&(e=!1),A.b();var C=A.A.O6,c=A.A.QE,u=A.A.B1,p=A.A.CM,Z=A.A.S;if(A.setup(),!A.A.I3||A.C.AJ["3d"]||A.A.FY){A.N.CZ=A.CZ=!1,A.N.C7=A.A.CP("bl",1);var h=p.H6,d=p.AT(h);d=C?ZC._l_(d,p.iX,p.iY+p.I):ZC._l_(d,p.iY,p.iY+p.F);var f=u.DJ?u.AC/2:0,_=[],g=[],v=[],b=null;null!==ZC._n_(A.A.A.F1)&&null!==ZC._n_(A.A.A.F1[A.L])&&(b=A.A.A.F1[A.L]);var B=A.A.CW;(A.C.OA||A.A.U8)&&"spline"===A.A.CW&&(B="segmented"),t=A.N.AZ/2-1,n="svg"===A.H.AA&&ZC.mobile?A.N.HX/4:0,"vml"===A.H.AA&&A.A.GG&&(n=.5),A.C.AJ["3d"]&&(1===A.A.HX?n=1:(n=A.A.HX/3,"canvas"===A.H.AA&&(ZC.A5.browser.msie||ZC.A5.browser.opera)&&(n=.5)),u.AW&&(n=-n));var m,E="undefined"!=typeof A.A.GB?A.A.GB:A.A.Y,D="undefined"!=typeof A.A.HD?A.A.HD:A.A.Y,K=!0,F=!0;(!Z[A.L-E]||"log"!==u.C1&&!u.EF&&A.L<=u.W)&&(K=!1);var x=A.A.LP?A.A.S.length:u.A1;switch((!Z[A.L+D]||"log"!==u.C1&&!u.EF&&A.L>=x)&&(F=!1),B){default:if(K)A.A.FK(A.L-E,0).setup(),A.A.UT?(l=ZC.AQ.JT(Z[A.L-E].iX,Z[A.L-E].iY,Z[A.L].iX,Z[A.L].iY),v.push([ZC._i_(l[0])-n,l[1]-t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(l[0])-n,d]),g.push([ZC._i_(l[0])-n,l[1]+t]),_.push([l[0],l[1]])):g.push([ZC._i_(A.iX),d]);else if(u.EF||A.L!==u.W)A.A.CC&&null!==ZC._n_(b)?(m=A.A.A.A4[A.A.L-1])&&m.S[A.L]&&g.push([ZC._i_(A.iX),m.S[A.L].iY+t]):(g.push([ZC._i_(A.iX),d]),v.push([ZC._i_(A.iX-u.AC/2),d]),v.push([ZC._i_(A.iX),d]));else if(u.AW)A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(u.iX+u.I-u.BV-f),d]),g.push([ZC._i_(u.iX+u.I-u.BV-f),A.iY+t]);else{var I=ZC._i_(u.iX+u.AB+f);A.A.LP&&(I=u.IB(A.A.R4)-u.AC/2),A.A.CC&&null!==ZC._n_(b)||g.push([I,d]),g.push([I,A.iY+t])}v.push([ZC._i_(A.iX),A.iY-t]),g.push([ZC._i_(A.iX),A.iY+t]),_.push([A.iX,A.iY]),F?(A.A.FK(A.L+D,2).setup(),a=A.A.UT?ZC.AQ.JT(Z[A.L].iX,Z[A.L].iY,Z[A.L+D].iX,Z[A.L+D].iY):[Z[A.L+D].iX,Z[A.L+D].iY],v.push([ZC._i_(a[0]),a[1]-t]),g.push([ZC._i_(a[0]),a[1]+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(a[0]),d]),l=A.A.UT?ZC.AQ.JT(Z[A.L].iX,Z[A.L].iY,Z[A.L+D].iX,Z[A.L+D].iY,A.N.C6):[Z[A.L+D].iX,Z[A.L+D].iY],_.push([l[0],l[1]])):A.L===u.A1?u.AW?(g.push([u.iX+u.AB-f,A.iY+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(u.iX+u.AB-f),d])):(g.push([u.iX+u.I-u.BV-f,A.iY+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(u.iX+u.I-u.BV-f),d])):A.A.CC&&null!==ZC._n_(b)?(m=A.A.A.A4[A.A.L-1])&&m.S[A.L]&&g.push([ZC._i_(A.iX),m.S[A.L].iY+t]):(g.push([ZC._i_(A.iX),d]),v.push([ZC._i_(A.iX),d]),v.push([ZC._i_(A.iX+u.AC/2),d]));break;case"spline":if(null!==ZC._n_(A.A.D6)&&(v=A.A.D6),null!==ZC._n_(A.A.AH)&&(g=A.A.AH),A.A.D6=[],A.A.AH=[],null!==ZC._n_(A.A.D)&&(_=A.A.D),A.A.D=[],Z[A.L+1]){var y=[],w=[];for(o=-1;o<3;o++)Z[A.L+o]?(A.A.FK(A.L+o,2).setup(),C?(y.push(Z[A.L+o].iX),w.push(Z[A.L+o].iY)):(y.push(Z[A.L+o].iY),w.push(Z[A.L+o].iX))):0===y.length?C?(w.push(A.iY),y.push(A.iX)):(w.push(A.iX),y.push(A.iY)):(y.push(y[y.length-1]),w.push(w[w.length-1]));var Y=ZC._a_(w[2]-w[1]);Y=Math.min(Y,Math.max(A.C.I,A.C.F));var X=ZC.AQ.Y9(A.A.Q9,y,Y);if(A.A.UT){for(0===g.length&&(A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(A.iX+(u.AW?-1:1)*X[0][0]*Y),d])),o=0;o<ZC._i_(X.length/2)+(1===A.N.C6?1:0);o++)X[o]&&(C?_.push([X[o][1],A.iY+(u.AW?1:-1)*X[o][0]*Y]):_.push([A.iX+(u.AW?-1:1)*X[o][0]*Y,X[o][1]]));for(o=0;o<ZC._i_(X.length/2)+(1===A.N.HX?1:0);o++)v.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]-t]),g.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]]);for(A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(g[g.length-1][0]),d]),s=1===A.HX?ZC.CY(2,ZC._i_(X.length/2)):1,o=ZC._i_(X.length/2)-1,r=X.length;o<r;o++)X[o]&&(C?A.A.D.push([X[o][1],A.iY+(u.AW?1:-1)*X[o][0]*Y]):A.A.D.push([A.iX+(u.AW?-1:1)*X[o][0]*Y,X[o][1]]));for(o=ZC._i_(X.length/2)-s,r=X.length;o<r;o++)0===A.A.AH.length&&(A.A.CC&&null!==ZC._n_(b)||A.A.AH.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),d])),A.A.AH.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]]),A.A.D6.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]-t])}else{for(0===g.length&&(A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(A.iX+(u.AW?-1:1)*X[0][0]*Y),d])),o=0;o<X.length;o++)C?_.push([X[o][1],A.iY+(u.AW?1:-1)*X[o][0]*Y]):_.push([A.iX+(u.AW?-1:1)*X[o][0]*Y,X[o][1]]);for(o=0;o<X.length;o++)v.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]-t]),g.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]]);for(A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(g[g.length-1][0]),d]),s=1===A.HX?ZC.CY(2,ZC._i_(X.length/2)):1,o=X.length,r=X.length;o<r;o++)C?A.A.D.push([X[o][1],A.iY+(u.AW?1:-1)*X[o][0]*Y]):A.A.D.push([A.iX+(u.AW?-1:1)*X[o][0]*Y,X[o][1]]);for(o=X.length-s,r=X.length;o<r;o++)0===A.A.AH.length&&(A.A.CC&&null!==ZC._n_(b)||A.A.AH.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),d])),A.A.AH.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]]),A.A.D6.push([ZC._i_(A.iX+(u.AW?-1:1)*X[o][0]*Y),X[o][1]-t])}}else g.length>0&&g.push([g[g.length-1][0],d]);break;case"stepped":if(K)switch(A.A.FK(A.L-E,0).setup(),l=ZC.AQ.JT(Z[A.L-E].iX,Z[A.L-E].iY,Z[A.L].iX,Z[A.L].iY),A.A.SL){default:v.push([ZC._i_(l[0])-n,A.iY-t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(l[0])-n,d]),g.push([ZC._i_(l[0])-n,A.iY+t]),_.push(C?[Z[A.L-E].iX,l[1]]:[l[0],Z[A.L-E].iY]),_.push(C?[A.iX,l[1]]:[l[0],A.iY]);break;case"before":v.push([ZC._i_(Z[A.L-E].iX)-n,A.iY-t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(Z[A.L-E].iX)-n,d]),g.push([ZC._i_(Z[A.L-E].iX)-n,A.iY+t]),_.push([Z[A.L-E].iX,Z[A.L-E].iY]),_.push([Z[A.L-E].iX,A.iY]);break;case"after":v.push([ZC._i_(A.iX)-n,A.iY-t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(A.iX)-n,d]),g.push([ZC._i_(A.iX)-n,A.iY+t])}else u.EF||A.L!==u.W?A.A.CC&&null!==ZC._n_(b)?(m=A.A.A.A4[A.A.L-1])&&m.S[A.L]&&g.push([ZC._i_(A.iX),m.S[A.L].iY+t]):(g.push([ZC._i_(A.iX),d]),v.push([ZC._i_(A.iX-u.AC/2),d]),v.push([ZC._i_(A.iX),d])):u.AW?(A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(u.iX+u.I-u.BV-f),d]),g.push([ZC._i_(u.iX+u.I-u.BV-f),A.iY+t])):(A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(u.iX+u.AB+f),d]),g.push([ZC._i_(u.iX+u.AB+f),A.iY+t]));if(v.push([ZC._i_(A.iX),A.iY-t]),g.push([ZC._i_(A.iX),A.iY+t]),_.push([A.iX,A.iY]),F)switch(A.A.FK(A.L+D,2).setup(),l=ZC.AQ.JT(Z[A.L].iX,Z[A.L].iY,Z[A.L+D].iX,Z[A.L+D].iY,A.N.C6),A.A.SL){default:v.push([ZC._i_(l[0]),A.iY-t]),g.push([ZC._i_(l[0]),A.iY+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(l[0]),d]),_.push(C?[A.iX,l[1]]:[l[0],A.iY]);break;case"before":v.push([ZC._i_(A.iX),A.iY-t]),g.push([ZC._i_(A.iX),A.iY+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(A.iX),d]);break;case"after":v.push([ZC._i_(Z[A.L+D].iX),A.iY-t]),g.push([ZC._i_(Z[A.L+D].iX),A.iY+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(Z[A.L+D].iX),d]),_.push([Z[A.L+D].iX,A.iY]),_.push([Z[A.L+D].iX,Z[A.L+D].iY])}else A.L===u.A1?u.AW?(g.push([u.iX+u.AB-f,A.iY+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(u.iX+u.AB-f),d])):(g.push([u.iX+u.I-u.BV-f,A.iY+t]),A.A.CC&&null!==ZC._n_(b)||g.push([ZC._i_(u.iX+u.I-u.BV-f),d])):A.A.CC&&null!==ZC._n_(b)?(m=A.A.A.A4[A.A.L-1])&&m.S[A.L]&&g.push([ZC._i_(A.iX),m.S[A.L].iY+t]):(g.push([ZC._i_(A.iX),d]),v.push([ZC._i_(A.iX),d]),v.push([ZC._i_(A.iX+u.AC/2),d]))}if(A.A.CC&&null!==ZC._n_(b))for(o=b.length-1;o>=0;o--)g.push(b[o]);if(A.setNodeData({points:_,pointsarea:g}),"ready"!==A.C.MA&&(A.A.V3=A.A.V3.concat(_)),null===ZC._n_(A.A.A.F1)&&(A.A.A.F1=[]),A.A.A.F1[A.L]=v,!e&&!A.C.AJ["3d"]){var M=A.N=A.A.ID(A,A.N),L=A.C.K+"-node-area "+A.C.K+"-plotset-plot-"+A.A.L+"-node-area zc-node-area";M.DK=L,M.K=A.K,A.A.HT&&A.H3(M);var H,P=A.C.P;if(0!==A.A.E7.length||A.A.HT||"undefined"==typeof A.A.AA6||A.N.o.override||A.C.KI?((H=new ZC.DT(A.A)).copy(M),H.C6=A.A.HX):H=A.A.AA6,A.H3(H),H.C6=ZC._f_(H.o["alpha-area"]||"1"),H.CZ=!1,H.L5=!0,H.AZ=0,H.AU=0,H.EX=0,H.G9=0,H.Z=A.A.CP("bl",A.C.CC?0:1),H.D=g,H.D1=[P.iX,P.iY,P.iX+P.I,P.iY+P.F],null!==ZC._n_(i=A.A.E["min-y"])&&(H.E["bound-1"]=i,H.D1[1]=i),null!==ZC._n_(i=A.A.E["max-y"])&&(H.E["bound-3"]=i,H.D1[3]=i),H.K=A.K+"-area",A.A.GG||(H.E.areanode=!0),ZC.CR.setup(c,M),A.paintPreview(M,_,g),A.A.GG&&!A.C.HH){var N=new ZC.DT(A),G={};N.copy(M),N.K=A.K,N.Z=A.A.CP("bl",2),N.C7=A.A.CP("bl",1),N.D=_;var S=H,O={},k=[],T=[];N.D=_,G.points=_,S.D=g,O.points=g;var z=A.A.L7,Q=A.C.P;N.C6=0,G.alpha=M.C6,S.C6=0,O.alpha=A.A.HX;var J,V=function(e){for(var i=e?g:_,t=e?T:k,n=0;n<i.length;n++)2===z?t[n]=[i[n][0],Q.iY+A.C.P.F/2]:3===z?t[n]=[i[n][0],Q.iY-5]:4===z?t[n]=[i[n][0],Q.iY+Q.F+5]:5===z?t[n]=[Q.iX-5,i[n][1]]:6===z?t[n]=[Q.iX+Q.I+5,i[n][1]]:7===z?t[n]=[Q.iX+Q.I/2,i[n][1]]:8===z?t[n]=[i[n][0]-Q.I,i[n][1]]:9===z?t[n]=[i[n][0]+Q.I,i[n][1]]:10===z?t[n]=[i[n][0],i[n][1]-Q.F]:11===z?t[n]=[i[n][0],i[n][1]+Q.F]:12===z?t[n]=[(i[0][0]+i[i.length-1][0])/2,i[0][1]]:13===z&&(t[n]=[i[0][0],(i[0][1]+i[i.length-1][1])/2]),z>1&&(e?(S.D=T,O.points=g):(N.D=k,G.points=_))};for(J in V(),V(!0),A.A.FV)N[ZC.E4.GN[ZC.EE(J)]]=A.A.FV[J],G[ZC.EE(J)]=M[ZC.E4.GN[ZC.EE(J)]],S[ZC.E4.GN[ZC.EE(J)]]=A.A.FV[J],O[ZC.EE(J)]=M[ZC.E4.GN[ZC.EE(J)]];if(null===ZC._n_(A.C.EN)&&(A.C.EN={}),null===ZC._n_(A.C.SS)&&(A.C.SS={}),null!==ZC._n_(A.C.EN[A.A.L+"-"+A.L])){for(J in A.C.EN[A.A.L+"-"+A.L])N[ZC.E4.GN[ZC.EE(J)]]=A.C.EN[A.A.L+"-"+A.L][J];for(J in A.C.SS[A.A.L+"-"+A.L])S[ZC.E4.GN[ZC.EE(J)]]=A.C.SS[A.A.L+"-"+A.L][J]}A.C.EN[A.A.L+"-"+A.L]={},ZC._cp_(G,A.C.EN[A.A.L+"-"+A.L]),A.C.SS[A.A.L+"-"+A.L]={},ZC._cp_(O,A.C.SS[A.A.L+"-"+A.L]);var R=new ZC.E4(N,G,A.A.JF,A.A.L6,ZC.E4.RI[A.A.L8],function(){U()});R.AX=A,R.OF=function(){A.N6(ZC.Q.EB(A.A.CP("bl",1),A.H.AA))},R.IK=c;var W=new ZC.E4(S,O,A.A.JF,A.A.L6,ZC.E4.RI[A.A.L8],function(){});W.AX=A,A.LM(R,W)}else H.paint(),0!==A.A.E7.length||"undefined"!=typeof A.A.AA6||A.N.o.override||A.C.KI||A.C.HH||(A.A.AA6=H),ZC.CR.paint(c,M,_),U()}}function U(){!A.C.OA&&ZC.DS(A.iX,u.iX-1,u.iX+u.I+1)&&ZC.DS(A.iY,u.iY-1,u.iY+u.F+1)&&(A.P8(),A.N6(ZC.Q.EB(A.A.CP("bl",1),A.H.AA)),A.A.U&&A.A.U.AN&&A.A.E.vboxid!==A.K&&A.GW())}},paintPreview:function(e,i,t){var n=this;if(n.C.B9&&n.C.B9.I2&&n.A.QN){var a,l=n.C.P,o=n.C.B9,r=n.A.mapPointsToPreview(t),s=new ZC.DT(n.A);s.copy(e),s.CZ=!0,s.L5=!0,s.AZ=0,s.AU=0,s.EX=0,s.G9=0,s.C6=n.A.HX,s.D1=[l.iX,l.iY,l.iX+l.I,l.iY+l.F],s.K=n.K+"-area-preview",s.DK=n.A.K+"-preview",s.Z=o.Z;var A,C=n.A.o["preview-state"];C&&(null!==ZC._n_(C["alpha-area"])?(a=C.alpha,C.alpha=C["alpha-area"]):C.alpha=s.C6,s.append(C),s.parse(),null!==ZC._n_(a)?C.alpha=a:delete C.alpha),s.D=r,s.paint();var c=n.A.mapPointsToPreview(i);n.A.WB?A=n.A.WB:(A=new ZC.D0(n),n.A.WB=A),A.copy(e),A.K=n.K+"-line-preview",A.DK=n.A.K+"-preview";var u=ZC.Q.EB(o.Z,n.H.AA);A.AZ=1,C&&(A.append(C),A.parse()),ZC.CR.paint(u,A,c,null,3)}},A0W:function(e){var i=this;ZC.move||(i.A.O6||i.M5({layer:e,type:"area",initcb:function(){this.A0=i.A.BP[2],this.AE=i.A.BP[2],this.D=i.getNodeData("pointsarea")||[]},setupcb:function(){this.AZ=0,this.AU=0,this.C6=i.A.HX;var e=i.C.P;this.D1=[e.iX,e.iY,e.iX+e.I,e.iY+e.F]}}),i.A1F(e),i.A.R7&&i.TR(e))}}),ZC.ZB=ZC.LG.CA({setup:function(){this.T6()},UY:function(){var e=this;e.paint(!0);var i=e.C.BL(e.A.BU("v")[0]);return[e.iX+e.I/2,e.iY+(i.AW?e.F:0),{reference:e,center:!0}]},AC8:function(e){var i=this,t="top-out",n=i.C.BL(i.A.BU("v")[0]),a=i.AD>=n.H6&&!n.AW||i.AD<n.H6&&n.AW?1:-1;e=i.setupValueBoxWH(e),null!==ZC._n_(e.o.placement)&&(t=e.o.placement);var l=e.I,o=e.F,r=i.iX+i.I/2-l/2,s=i.iYVal-o/2,A=e.A9%180==90,C=A?l/2:o/2,c=A?l/2-o/2:0;switch(t){case"top-out":case"top":s-=a*(C+5);break;case"top-in":s+=a*(C+5);break;case"middle":s+=a*(i.F/2);break;case"bottom-in":s+=a*(i.F-C-5);break;case"bottom-out":case"bottom":s+=a*(i.F+o/2+5)}if(null!==ZC._n_(e.o.x)||null!==ZC._n_(e.o.y))null!==ZC._n_(e.o.x)&&(r=e.iX),null!==ZC._n_(e.o.y)&&(s=e.iY);else{var u=ZC._c_(i.A.o.tolerance,5);if(!ZC.AQ._boxoverlap2_(i,i.C.P,u))return[-1,-1]}var p=e.o.tolerance||[i.C.P.E8,i.C.P.E9,i.C.P.DR,i.C.P.DY];return i.C.AJ["3d"]||(r=ZC.BQ(i.C.P.iX+0-p[3],r),r=ZC.CY(i.C.P.iX+i.C.P.I-l-0+p[1],r),s-c<i.C.P.iY+5-p[0]&&(s=i.C.P.iY+5-p[0]+c),s+c>i.C.P.iY+i.C.P.F-o-5+p[2]&&(s=i.C.P.iY+i.C.P.F-o-5+p[2]-c)),[ZC._i_(r),ZC._i_(s)]},getPMap:function(){var e=this.b();return this.addPMap(e,"barWidth","I"),e},paint:function(e){var i,t=this;if(t.b(),!t.C.AJ["3d"]){void 0===e&&(e=!1);var n=t.A.B1,a=t.A.CM;t.setup();var l,o,r,s,A,C=a.H6,c=a.AT(C),u=t.A.SM(),p=u.AC,Z=u.ET,h=u.CF,d=u.CT,f=u.F4,_=u.D3,g=u.EZ;if(e?Z=t.A.E["node-"+t.L+"-bar-index"]:t.A.E["node-"+t.L+"-bar-index"]=u.ET,t.A.CC){l=0;for(var v=t.A.A.KB[Z],b=0;b<v.length;b++){var B=t.A.A.A4[v[b]].S[t.L];B&&(l+=B.AD)}}var m=1,E=1;if(t.A.CC&&(t.CS!==t.AD&&(m=(l-t.CS+t.AD)/l),E=(l-t.CS)/l),a.AW){var D=m;m=E,E=D}t.A.LP&&(Z=t.L);var K=t.iX-p/2+h+Z*(_+f)-Z*g;if(K=ZC._l_(K,t.iX-p/2+h,t.iX+p/2-d),t.A.D3>0){var F=_;(_=t.A.D3)<=1&&(_*=F),K+=(F-_)/2}var x=_,I=t.iY,y=null!==ZC._n_(t.A.LY[t.L])?t.A.LY[t.L]:0;if(I=t.A.CC&&"100%"===t.A.KQ?a.AT(100*(t.CS+y)/t.A.A.F8[t.L]["%total-"+t.A.DZ]):a.AT(t.CS+y),t.A.CC){o="100%"===t.A.KQ?a.AT(100*(t.CS-t.AD+y)/t.A.A.F8[t.L]["%total-"+t.A.DZ]):a.AT(t.CS-t.AD+y),I=ZC._i_(I),o=ZC._i_(o);var w=!a.AW&&t.AD>=0||a.AW&&t.AD<=0?-1:1,Y=0,X=0;""!==t.A.Q1?(Y=t.WO(t.A.Q1)[0],X=0):Y=t.A.AU,""!==t.A.NP?(X=t.WO(t.A.NP)[0],Y=0):X=t.A.AU,Y!==X&&(w=0),r=I-o+w*Y,t.AD<0&&(I=o),a.AW?r>0&&(r=ZC._a_(r),I=o):r<0&&(r=ZC._a_(r),I=o-r),a.AW&&t.AD<0&&(r+=X)}else o=a.AT(y),(r=I-o)<0?(r=ZC._a_(r),I=o-r):I=o;if(t.A.TI&&t.A.CC&&t.A.L>0&&t.A.A.A4[t.A.L-1].S[t.L]&&0===t.A.A.A4[t.A.L-1].S[t.L].AD&&(r-=1,I+=a.AW?1:-1),r<2&&(t.AD>0||t.A.TI)&&(r=1,a.AW?t.A.CC&&t.A.L>0&&(I-=1):t.A.CC?0===t.A.L&&(I-=1):I=y?o-1:c-2),t.I=x,t.F=r,t.iX=K,t.iY=I,a.AW?t.AD>=a.H6?t.iYVal=I+t.F:t.iYVal=I:t.AD>=a.H6?t.iYVal=I:t.iYVal=I+t.F,t.C.CX){var M="middle";t.C.CX.o.marker&&null!==ZC._n_(i=t.C.CX.o.marker.alignment)&&(M=i),null!==ZC._n_(t.A.o["guide-marker"])&&null!==ZC._n_(i=t.A.o["guide-marker"].alignment)&&(M=i),"node"===M&&(t.E.A5M=t.iX+t.I/2)}if(!e){var L;t.setNodeData({x:K,y:I,w:x,h:r});var H=!0;if("none"!==t.A.IZ||t.C.IX[t.A.L]||t.C.KI||t.A.SY&&t.A.SY[t.L]?(L=t.N=t.A.ID(t,t.N),H=!1):L=t.N,(0!==t.A.E7.length||t.A.HT||t.N.o.override||t.C.KI)&&(H=!1),t.AN){var P;switch(t.A.CW){default:0!==t.A.E7.length||t.A.HT||"undefined"==typeof t.A.TY||t.N.o.override||t.C.KI?(P=new ZC.HL(t.A)).copy(L):P=t.A.TY,t.A.HT&&(t.H3(P),P.parse()),P.FC=t.A.FC,P.K=t.K,P.iX=K,P.iY=I,P.I=t.I,P.F=t.F,n.AC<5&&P.I<5?(P.I=ZC.BQ(1,P.I)+1,P.N4=!1,P.CZ=!1):P.N4=!0,P.I<5&&n.A1!==n.W&&t.C.P.I/(n.A1-n.W)<1&&(P.QW=!0);break;case"pyramid":case"cone":0!==t.A.E7.length||t.A.HT||"undefined"==typeof t.A.TY||t.N.o.override||t.C.KI?(P=new ZC.DT(t.A)).copy(L):P=t.A.TY,t.A.HT&&(t.H3(P),P.parse()),P.K=t.K,a.AW&&!t.A.CC?(A=t.AD>=0?0:t.F,s=t.AD>=0?t.F:0):(A=t.AD>=0?t.F:0,s=t.AD>=0?0:t.F),P.D=[],P.D.push([K+t.I/2-m*t.I/2,I+A],[K+t.I/2+m*t.I/2,I+A]),t.A.CC&&0!==E?P.D.push([K+t.I/2+E*t.I/2,I+s],[K+t.I/2-E*t.I/2,I+s]):P.D.push([K+t.I/2,I+s]),P.D.push([P.D[0][0],P.D[0][1]]),t.setNodeData({points:P.D}),P.iX=K,P.iY=I,P.locate(2)}P.Z=t.A.CP("bl",1),P.C7=t.A.CP("bl",0),t.paintPreview(L,H);var N=t.C.K+"-node-area "+t.C.K+"-plotset-plot-"+t.A.L+"-node-area zc-node-area";P.DK=N;var G=ZC._c_(t.A.o.tolerance,5),S=function(){if("undefined"!=typeof t.paint_&&t.paint_(),t.N6(ZC.Q.EB(P.Z,t.H.AA)),ZC.AQ._boxoverlap2_(t,t.C.P,G)&&t.A.FY&&-1===ZC.AV(t.H.KR,"skip_segment_tracking")){var e=x<5?.5:-.5,i=r<3?.5:-.5,n=ZC.Q.G0("rect",t.A.EA,P.IV)+'class="'+N+'" '+t.a11y()+' id="'+t.K+'" coords="'+ZC._i_(K+t.A.BM+ZC.MAPTX-e)+","+ZC._i_(I+t.A.BH+ZC.MAPTX-i)+","+ZC._i_(K+t.A.BM+x+ZC.MAPTX+e)+","+ZC._i_(I+t.A.BH+r+ZC.MAPTX+i)+'" />';t.A.A.HE.push(n)}t.A.U&&t.A.U.AN&&t.GW()};if(t.A.GG&&!t.C.HH){var O=P,k={};O.iX=K,O.iY=I,O.I=x,O.F=r,k.x=K,k.y=I,k.width=x,k.height=r;var T,z=t.A.L7,Q=t.C.P;for(T in O.C6=0,k.alpha=L.C6,2===z?(O.iY=Q.iY+Q.F/2,O.F=1,k.height=t.F,k.y=I):3===z?(O.iY=Q.iY,O.F=1,k.height=t.F,k.y=I):4===z?(O.iY=Q.iY+Q.F,O.F=1,k.height=t.F,k.y=I):5===z?(O.iX=Q.iX,O.I=1,k.width=t.I,k.x=K):6===z?(O.iX=Q.iX+Q.I,O.I=1,k.width=t.I,k.x=K):7===z?(O.iX=Q.iX+Q.I/2,O.I=1,k.width=t.I,k.x=K):8===z?(O.iX=K-Q.I,k.x=K):9===z?(O.iX=K+Q.I,k.x=K):10===z?(O.iY=I-Q.F,k.y=I):11===z?(O.iY=I+Q.F,k.y=I):12===z?(O.I=1,k.width=t.I):13===z&&(O.F=1,k.height=t.F),t.A.FV)O[ZC.E4.GN[ZC.EE(T)]]=t.A.FV[T],k[ZC.EE(T)]=L[ZC.E4.GN[ZC.EE(T)]];if(null===ZC._n_(t.C.EN)&&(t.C.EN={}),null!==ZC._n_(t.C.EN[t.A.L+"-"+t.L]))for(T in t.C.EN[t.A.L+"-"+t.L])O[ZC.E4.GN[ZC.EE(T)]]=t.C.EN[t.A.L+"-"+t.L][T];if(t.C.EN[t.A.L+"-"+t.L]={},ZC._cp_(k,t.C.EN[t.A.L+"-"+t.L]),ZC.AQ._boxoverlap2_(t,t.C.P,G)){var J=new ZC.E4(O,k,t.A.JF,t.A.L6,ZC.E4.RI[t.A.L8],function(){S()});J.AX=t,J.OF=function(){t.N6(ZC.Q.EB(P.Z,t.H.AA))},t.LM(J)}}else{if(P.AN||0===t.A.E7.length&&!t.A.HT)if(t.A.WA||(t.A.WA={iX:P.iX,iY:P.iY,F:P.F}),t.A.A2L)if(t.A.S8)if(t.A.S8.el&&"RECT"===t.A.S8.el.tagName.toUpperCase()){var V=!1;if(t.A.N1&&t.A.WA&&ZC._a_(P.iX-t.A.WA.iX)<.75&&ZC._a_(P.iY-t.A.WA.iY)<1.5&&ZC._a_(P.F-t.A.WA.F)<1.5&&(V=!0),!V){t.A.WA={iX:P.iX,iY:P.iY,F:P.F};var R=t.A.S8.el.cloneNode(!1);R.setAttribute("id",t.K),R.setAttribute("x",t.iX),R.setAttribute("y",t.iY),R.setAttribute("height",t.F),t.A.S8.df?t.H.G1[P.Z.id].appendChild(R):t.A.S8.el.parentNode.appendChild(R)}}else P.paint();else P.paint(),t.A.S8={id:P.K+"-path"},zingchart.DEV.DOMFRAGMENTS&&document.querySelector&&t.H.G1&&t.H.G1[P.Z.id]?(t.A.S8.df=!0,t.A.S8.el=t.H.G1[P.Z.id].querySelector("#"+P.K+"-path")):(t.A.S8.df=!1,t.A.S8.el=ZC.AK(t.A.S8.id));else ZC.AQ._boxoverlap2_(t,t.C.P,G)&&P.paint();P.AN&&S()}"svg"===t.H.AA&&t.A.applyJsRuleSvg(t.A,t.K+"-path",t.LT()),0!==t.A.E7.length||t.A.HT||"undefined"!=typeof t.A.TY||t.N.o.override||t.C.KI||t.A.GG||(t.A.TY=P)}}}},paintPreview:function(e,i){var t,n,a=this;if(a.C.B9&&a.C.B9.I2&&a.A.QN){var l=a.C.P,o=a.C.B9,r=o.AR,s=(a.iX-l.iX)/l.I,A=(a.iY-l.iY)/l.F;a.A.WC?t=a.A.WC:(t=new ZC.HL(a.A),a.A.WC=t,t.copy(e),(n=a.A.o["preview-state"])&&(t.append(n),t.parse())),i||(t.copy(e),(n=a.A.o["preview-state"])&&(t.append(n),t.parse())),t.K=a.K+"-preview",t.DK=a.A.K+"-preview",t.iX=r.iX+r.AU+s*(r.I-2*r.AU),t.iY=r.iY+r.AU+A*(r.F-2*r.AU),t.I=a.I/l.I*(r.I-2*r.AU),t.F=a.F/l.F*(r.F-2*r.AU),r.I/a.A.S.length<10?(t.I=t.I+.5,t.N4=!1,t.CZ=!1):(t.N4=!0,t.CZ=!0),t.Z=t.C7=o.Z,t.paint()}},A0W:function(e){var i=this;if(e=e||"hover",!ZC.move){var t="";switch(i.A.CW){default:t="box";break;case"pyramid":t="shape"}i.M5({layer:e,type:t,initcb:function(){this.A0=i.A.BP[3],this.B7=i.A.BP[1],this.BW=i.A.BP[1],this.AE=i.A.BP[2]},setupcb:function(){switch(i.A.CW){default:this.iX=i.getNodeData("x"),this.iY=i.getNodeData("y"),this.I=i.getNodeData("w"),this.F=i.getNodeData("h");var e=i.C.P;this.iY<e.iY&&(this.F=this.F-(e.iY-this.iY),this.iY=e.iY),this.iY+this.F>e.iY+e.F&&(this.F=e.iY+e.F-this.iY);break;case"pyramid":case"cone":this.D=i.getNodeData("points")}}}),i.N6(ZC.Q.EB(i.C.K+"-hover-c",i.H.AA),!0),i.A.RL=null}}}),ZC.ZA=ZC.LG.CA({setup:function(){this.T6()},UY:function(){var e=this;e.paint(!0);var i=e.C.BL(e.A.BU("v")[0]);return[e.iX+(i.AW?0:e.I),e.iY+e.F/2,{reference:e,center:!0}]},AC8:function(e){var i=this,t="top-out",n=i.C.BL(i.A.BU("v")[0]),a=i.AD>=n.H6&&!n.AW||i.AD<n.H6&&n.AW?-1:1;null!==ZC._n_(e.o.placement)&&(t=e.o.placement);var l=e.I,o=e.F,r=i.iXVal-l/2,s=i.iY+i.F/2-o/2,A=e.A9%180==90?o/2:l/2;switch(t){case"top-out":case"top":r-=a*(A+5);break;case"top-in":r+=a*(A+5);break;case"middle":r+=a*(i.I/2);break;case"bottom-in":r+=a*(i.I-A-5);break;case"bottom-out":case"bottom":r+=a*(i.I+A+5)}if(null!==ZC._n_(e.o.x)||null!==ZC._n_(e.o.y))null!==ZC._n_(e.o.x)&&(r=e.iX),null!==ZC._n_(e.o.y)&&(s=e.iY);else{var C=ZC._c_(i.A.o.tolerance,5);if(!ZC.AQ._boxoverlap2_(i,i.C.P,C))return[-1,-1]}var c=e.o.tolerance||[i.C.P.E8,i.C.P.E9,i.C.P.DR,i.C.P.DY];return i.C.AJ["3d"]||(r=ZC.BQ(i.C.P.iX+5-c[3],r),r=ZC.CY(i.C.P.iX+i.C.P.I-l-5+c[1],r),s=ZC.BQ(i.C.P.iY+0-c[0],s),s=ZC.CY(i.C.P.iY+i.C.P.F-o/2-0+c[2],s)),[ZC._i_(r),ZC._i_(s)]},paint:function(e){var i=this;if(i.b(),!i.C.AJ["3d"]){void 0===e&&(e=!1);var t=i.A.B1,n=i.A.CM;i.setup();var a,l,o,r,s,A=i.A.SM(),C=A.AC,c=A.ET,u=A.CF,p=A.CT,Z=A.F4,h=A.D3,d=A.EZ;if(e?c=i.A.E["node-"+i.L+"-bar-index"]:i.A.E["node-"+i.L+"-bar-index"]=A.ET,i.A.CC){a=0;for(var f=i.A.A.KB[c],_=0;_<f.length;_++){var g=i.A.A.A4[f[_]].S[i.L];g&&(a+=g.AD)}}var v=1,b=1;if(i.A.CC&&(i.CS!==i.AD&&(v=(a-i.CS+i.AD)/a),b=(a-i.CS)/a),n.AW){var B=v;v=b,b=B}i.A.LP&&(c=i.L);var m=i.iY-C/2+u+c*(h+Z)-c*d;if(m=ZC._l_(m,i.iY-C/2+u,i.iY+C/2-p),i.A.D3>0){var E=h;(h=i.A.D3)<=1&&(h*=E),m+=(E-h)/2}var D=h,K=i.iX,F=null!==ZC._n_(i.A.LY[i.L])?i.A.LY[i.L]:0;if(K=i.A.CC&&"100%"===i.A.KQ?n.AT(100*(i.CS+F)/i.A.A.F8[i.L]["%total-"+i.A.DZ]):n.AT(i.CS+F),i.A.CC){l="100%"===i.A.KQ?n.AT(100*(i.CS-i.AD+F)/i.A.A.F8[i.L]["%total-"+i.A.DZ]):n.AT(i.CS-i.AD+F),K=ZC._i_(K),l=ZC._i_(l);var x=!n.AW&&i.AD>=0||n.AW&&i.AD<=0?1:-1,I=0,y=0;""!==i.A.OJ?(I=i.WO(i.A.OJ)[0],y=0):I=i.A.AU,""!==i.A.P6?(y=i.WO(i.A.P6)[0],I=0):y=i.A.AU,I!==y&&(x=0),o=K-l+x*I,i.AD>0?K=l:o=ZC._a_(o),n.AW?o>0?(o=ZC._a_(o),K=l):(o=ZC._a_(o),K-=o):o<0&&(o=ZC._a_(o),K=l-o)}else l=n.AT(F),(o=K-l)<0?(o=ZC._a_(o),K=l-o):K=l;if(i.A.TI&&i.A.CC&&i.A.L>0&&i.A.A.A4[i.A.L-1].S[i.L]&&0===i.A.A.A4[i.A.L-1].S[i.L].AD&&(o-=1,K+=n.AW?-1:1),o<1&&(i.AD>0||i.A.TI)&&(o=1,n.AW?i.A.CC?0===i.A.L&&(K-=1):K-=2:i.A.L>0&&i.A.CC&&(K-=1)),i.I=o,i.F=D,i.iX=K,i.iY=m,n.AW?i.AD>=n.H6?i.iXVal=K:i.iXVal=K+i.I:i.AD>=n.H6?i.iXVal=K+i.I:i.iXVal=K,!e){var w;i.setNodeData({x:K,y:m,w:o,h:D});var Y=!0;if("none"!==i.A.IZ||i.C.IX[i.A.L]||i.C.KI||i.A.SY&&i.A.SY[i.L]?(w=i.N=i.A.ID(i,i.N),Y=!1):w=i.N,(0!==i.A.E7.length||i.A.HT||i.N.o.override||i.C.KI)&&(Y=!1),i.AN){var X;switch(i.A.CW){default:0!==i.A.E7.length||i.A.HT||"undefined"==typeof i.A.TY||i.N.o.override||i.C.KI?(X=new ZC.HL(i.A)).copy(w):X=i.A.TY,i.A.HT&&(i.H3(X),X.parse()),X.FC=i.A.FC,X.K=i.K,X.iX=K,X.iY=m,X.I=i.I,X.F=i.F,t.AC<5&&X.F<5?(X.F=ZC.BQ(1,X.F)+1,X.N4=!1,X.CZ=!1):X.N4=!0,X.F<5&&t.A1!==t.W&&i.C.P.F/(t.A1-t.W)<1&&(X.QW=!0);break;case"pyramid":case"cone":0!==i.A.E7.length||i.A.HT||"undefined"==typeof i.A.TY||i.N.o.override||i.C.KI?(X=new ZC.DT(i.A)).copy(w):X=i.A.TY,i.A.HT&&(i.H3(X),X.parse()),X.K=i.K,n.AW&&!i.A.CC?(s=i.AD>=0?i.I:0,r=i.AD>=0?0:i.I):(s=i.AD>=0?0:i.I,r=i.AD>=0?i.I:0),X.D=[],X.D.push([K+s,m+i.F/2-v*i.F/2],[K+s,m+i.F/2+v*i.F/2]),i.A.CC&&0!==b?X.D.push([K+r,m+i.F/2+b*i.F/2],[K+r,m+i.F/2-b*i.F/2]):X.D.push([K+r,m+i.F/2]),X.D.push([X.D[0][0],X.D[0][1]]),i.E.points=X.D,X.iX=K,X.iY=m,X.locate(2)}X.Z=i.A.CP("bl",1),X.C7=i.A.CP("bl",0),i.paintPreview(w,Y);var M=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area";X.DK=M;var L=ZC._c_(i.A.o.tolerance,5),H=function(){if("undefined"!=typeof i.paint_&&i.paint_(),i.N6(ZC.Q.EB(X.Z,i.H.AA)),ZC.AQ._boxoverlap2_(i,i.C.P,L)&&i.A.FY&&-1===ZC.AV(i.H.KR,"skip_segment_tracking")){var e=o<3?.5:-.5,t=D<5?.5:-.5,n=ZC.Q.G0("rect",i.A.EA,X.IV)+'class="'+M+'" '+i.a11y()+' id="'+i.K+'" coords="'+ZC._i_(K+i.A.BM+ZC.MAPTX-e)+","+ZC._i_(m+i.A.BH+ZC.MAPTX-t)+","+ZC._i_(K+i.A.BM+o+ZC.MAPTX+e)+","+ZC._i_(m+i.A.BH+D+ZC.MAPTX+t)+'" />';i.A.A.HE.push(n)}i.A.U&&i.A.U.AN&&i.GW()};if(i.A.GG&&!i.C.HH){var P=X,N={};P.iX=K,P.iY=m,P.I=o,P.F=D,N.x=K,N.y=m,N.width=o,N.height=D;var G,S=i.A.L7,O=i.C.P;for(G in P.C6=0,N.alpha=w.C6,2===S?(P.iX=O.iX+O.I/2,P.I=1,N.width=i.I,N.x=K):3===S?(P.iX=O.iX+O.I,P.I=1,N.width=i.I,N.x=K):4===S?(P.iX=O.iX,P.I=1,N.width=i.I,N.x=K):5===S?(P.iY=O.iY+O.F,P.F=1,N.height=i.F,N.y=m):6===S?(P.iY=O.iY,P.F=1,N.height=i.F,N.y=m):7===S?(P.iY=O.iY+O.F/2,P.F=1,N.height=i.F,N.y=m):8===S?(P.iY=m+O.F,N.y=m):9===S?(P.iY=m-O.F,N.y=m):10===S?(P.iX=K+O.I,N.x=K):11===S?(P.iX=K-O.I,N.x=K):12===S?(P.F=1,N.height=i.F):13===S&&(P.I=1,N.width=i.I),i.A.FV)P[ZC.E4.GN[ZC.EE(G)]]=i.A.FV[G],N[ZC.EE(G)]=i.N[ZC.E4.GN[ZC.EE(G)]];if(null===ZC._n_(i.C.EN)&&(i.C.EN={}),null!==ZC._n_(i.C.EN[i.A.L+"-"+i.L]))for(G in i.C.EN[i.A.L+"-"+i.L])P[ZC.E4.GN[ZC.EE(G)]]=i.C.EN[i.A.L+"-"+i.L][G];if(i.C.EN[i.A.L+"-"+i.L]={},ZC._cp_(N,i.C.EN[i.A.L+"-"+i.L]),ZC.AQ._boxoverlap2_(i,i.C.P,L)){var k=new ZC.E4(P,N,i.A.JF,i.A.L6,ZC.E4.RI[i.A.L8],function(){H()});k.AX=i,k.OF=function(){i.N6(ZC.Q.EB(X.Z,i.H.AA))},i.LM(k)}}else(X.AN||0===i.A.E7.length&&!i.A.HT)&&ZC.AQ._boxoverlap2_(i,i.C.P,L)&&X.paint(),X.AN&&H();"svg"===i.H.AA&&i.A.applyJsRuleSvg(i.A,i.K+"-path",i.LT()),0!==i.A.E7.length||i.A.HT||"undefined"!=typeof i.A.TY||i.N.o.override||i.C.KI||i.A.GG||(i.A.TY=X)}}}},paintPreview:function(e,i){var t,n,a=this;if(a.C.B9&&a.C.B9.I2&&a.A.QN){var l=a.C.P,o=a.C.B9,r=o.AR,s=(a.iX-l.iX)/l.I,A=(a.iY-l.iY)/l.F;a.A.WC?t=a.A.WC:(t=new ZC.HL(a.A),a.A.WC=t,t.copy(e),(n=a.A.o["preview-state"])&&(t.append(n),t.parse())),i||(t.copy(e),(n=a.A.o["preview-state"])&&(t.append(n),t.parse())),t.K=a.K+"-preview",t.DK=a.A.K+"-preview",t.iX=r.iX+r.AU+s*(r.I-2*r.AU),t.iY=r.iY+r.AU+A*(r.F-2*r.AU),t.I=a.I/l.I*(r.I-2*r.AU),t.F=a.F/l.F*(r.F-2*r.AU),r.I/a.A.S.length<10?(t.I=t.I+.5,t.N4=!1,t.CZ=!1):(t.N4=!0,t.CZ=!0),t.Z=t.C7=o.Z,t.paint()}},A0W:function(e){var i=this;if(!ZC.move){var t="";switch(i.A.CW){default:t="box";break;case"pyramid":t="shape"}i.M5({layer:e,type:t,initcb:function(){this.B7=i.A.BP[1],this.BW=i.A.BP[1],this.A0=i.A.BP[3],this.AE=i.A.BP[2]},setupcb:function(){switch(i.A.CW){default:this.iX=i.getNodeData("x"),this.iY=i.getNodeData("y"),this.I=i.getNodeData("w"),this.F=i.getNodeData("h");var e=i.C.P;this.iX<e.iX&&(this.I=this.I-(e.iX-this.iX),this.iX=e.iX),this.iX+this.I>e.iX+e.I&&(this.I=e.iX+e.I-this.iX);break;case"pyramid":case"cone":this.D=i.getNodeData("points")}}}),i.N6(ZC.Q.EB(i.C.K+"-hover-c",i.H.AA),!0),i.A.RL=null}}}),ZC.A5Q=ZC.LG.CA({setup:function(){var e=this,i=e.A.B1,t=e.A.CM,n=[i.W,i.A1,t.W,t.A1];if(e.JO!==n){if("scatter"===e.A.AF){if(e.A.LP&&e.A.PY){var a=ZC.AQ.VS(e.A.PY[0],e.A.PY[1]),l=(e.BT-a[0])/(a[1]-a[0]);e.iX=i.IB(e.A.R4)-i.AC/2+e.A.RK+l*(i.AC-2*e.A.RK)}else e.iX=i.AT(e.BT);e.iY=t.AT(e.AD)}else e.iY=i.AT(e.BT),e.iX=t.AT(e.AD);e.JO=n}e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},parse:function(){this.b(),this.o.value instanceof Array||(this.BT=this.L)},ABF:function(){return{color:"-1"===this.A.A2.A0?this.N.A0:this.A.A2.A0}},getTooltipPosition:function(e,i){return this.b(e,i,this.NC.AI)},Y4:function(){return{"background-color":"-1"===this.A.A2.AE?this.N.AE:this.A.A2.AE,"border-color":"-1"===this.A.A2.AE?this.N.AE:this.A.A2.AE,color:this.N.C2}},paint:function(e){var i=this;i.b();var t=i.A.B1,n=i.A.CM;i.setup(),e||(t.CO?ZC.DS(i.iX,n.iX+(n.AW?n.BV:n.AB)-1,n.iX+n.I-(n.AW?n.AB:n.BV)+1)&&ZC.DS(i.iY,t.iY+(t.AW?t.BV:t.AB)-1,t.iY+t.F-(t.AW?t.AB:t.BV)+1)&&i.P8(!1,!0):ZC.DS(i.iX,t.iX+(t.AW?t.BV:t.AB)-1,t.iX+t.I-(t.AW?t.AB:t.BV)+1)&&ZC.DS(i.iY,n.iY+(n.AW?n.AB:n.BV)-1,n.iY+n.F-(n.AW?n.BV:n.AB)+1)&&i.P8(!1,!0))},A0W:function(e){ZC.move||this.TR(e)}}),ZC.A6X=ZC.LG.CA({$i:function(e){this.b(e),this.SI=null},parse:function(){this.b(),this.o.value instanceof Array||(this.BT=this.L),this.o.value instanceof Array&&null!==ZC._n_(this.o.value[2])?this.SI=ZC._f_(this.o.value[2]):this.SI=2},ABF:function(){return{color:"-1"===this.A.A2.A0?this.N.A0:this.A.A2.A0}},getTooltipPosition:function(e,i){var t=this.A.getSize(ZC._a_(this.SI));return this.b(e,i,t)},Y4:function(){return{"background-color":"-1"===this.A.A2.AE?this.N.AE:this.A.A2.AE,"border-color":"-1"===this.A.A2.AE?this.N.AE:this.A.A2.AE,color:this.N.C2}},JV:function(e,i,t,n){var a=this,l=a.A.MP();ZC._cp_(i,l);var o=ZC.AP.G2(a.SI,l);return a.CV=[["%v0",a.BT],["%v1",a.AD],["%v2",o],["%node-size-value",o]],e=a.b(e,i,t,n)},setup:function(){var e=this,i=e.A.B1,t=e.A.CM,n=[i.W,i.A1,t.W,t.A1];if(e.JO!==n){if("bubble"===e.A.AF){if(e.A.LP&&e.A.PY){var a=ZC.AQ.VS(e.A.PY[0],e.A.PY[1]),l=(e.BT-a[0])/(a[1]-a[0]);e.iX=i.IB(e.A.R4)-i.AC/2+e.A.RK+l*(i.AC-2*e.A.RK)}else e.iX=i.AT(e.BT);e.iY=t.AT(e.AD)}else e.iY=i.AT(e.BT),e.iX=t.AT(e.AD);e.JO=n}e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},AC8:function(e){var i,t=this,n="auto";null!==ZC._n_(i=e.o.placement)&&(n=i);var a=e.I,l=e.F,o=t.E["marker.size"],r=t.iX-a/2,s=t.iY-l/2,A=0,C=0;switch(n){case"top":s-=l/2+o,C=t.iY-t.C.P.iY+o;break;case"bottom":s+=l/2+o,C=t.C.P.iY+t.C.P.F-t.iY+o;break;case"left":r-=a/2+o,A=t.iX-t.C.P.iX+o;break;case"right":r+=a/2+o,A=t.C.P.iX+t.C.P.I-t.iX+o}return null!==ZC._n_(e.o.x)&&(r=e.iX),null!==ZC._n_(e.o.y)&&(s=e.iY),r<t.C.P.iX&&(r=t.C.P.iX+A),r+a>t.C.P.iX+t.C.P.I&&(r=t.C.P.iX+t.C.P.I-a-A),s<t.C.P.iY&&(s=t.C.P.iY+C),s+l>t.C.P.iY+t.C.P.F&&(s=t.C.P.iY+t.C.P.F-l-C),[ZC._i_(r),ZC._i_(s)]},paint:function(e){var i=this;void 0===e&&(e=!1),i.b();var t=i.A.B1,n=i.A.CM;i.setup(),i.E["marker.size"]=i.A.getSize(ZC._a_(i.SI)),e||(t.CO?ZC.DS(i.iX,n.iX+(n.AW?n.BV:n.AB)-1,n.iX+n.I-(n.AW?n.AB:n.BV)+1)&&ZC.DS(i.iY,t.iY+(t.AW?t.BV:t.AB)-1,t.iY+t.F-(t.AW?t.AB:t.BV)+1)&&i.P8(!1,!0):ZC.DS(i.iX,t.iX+(t.AW?t.BV:t.AB)-1,t.iX+t.I-(t.AW?t.AB:t.BV)+1)&&ZC.DS(i.iY,n.iY+(n.AW?n.AB:n.BV)-1,n.iY+n.F-(n.AW?n.BV:n.AB)+1)&&i.P8(!1,!0))},A0W:function(e){ZC.move||this.TR(e)}}),ZC.A8V=ZC.LG.CA({bCXY:!0,U:null,$i:function(e){this.b(e)},parse:function(){this.b()},AB2:function(){this.b();var e=this.C.E;e.update.npv=e.update["node-percent-value"]=this.JV("%npv")},JV:function(e,i,t,n){var a=this,l=a.A.MP();ZC._cp_(i,l),-1===e.indexOf("%npv")&&-1===e.indexOf("%node-percent-value")||null!==ZC._n_(l.decimals)&&-1!==l.decimals||(l.decimals=1);var o=0,r="0";if(a.A.A.KM[a.L]>0&&(r=""+(o=100*a.AD/a.A.A.KM[a.L])),a.A.A.A4.length>1&&a.A.L===a.A.A.A4.length-1){var s=0;if(null===ZC._n_(a.A.o.totals)){for(var A=0;A<a.A.A.A4.length-1;A++)if(a.A.A.A4[A].AN&&null!==ZC._n_(a.A.A.A4[A].S[a.L])){var C=0,c="0";a.A.A.KM[a.L]>0&&(c=""+(C=100*a.A.A.A4[A].S[a.L].AD/a.A.A.KM[a.L])),null!==ZC._n_(l.decimals)&&(c=C.toFixed(ZC.BQ(0,ZC._i_(l.decimals)))),s+=ZC._f_(c)}r=""+(o=Math.max(0,100-s))}}null!==ZC._n_(l.decimals)&&(r=o.toFixed(ZC.BQ(0,ZC._i_(l.decimals))));var u,p=ZC._f_(a.A.A.KM[a.L]||"0");return u=ZC.AP.G2(p,l,a.A),a.CV=[["%node-percent-value",r],["%npv",r],["%pie-total-value",u]],e=a.b(e,i,t,n)},getTooltipPosition:function(e,i){var t,n,a,l=this,o=(l.B4+l.BK)/2%360;switch(i){case"out":n=(t=ZC.AQ.BN(l.iX,l.iY,l.AI+l.DV+e.DV,o))[0]+l.BM,a=t[1]+l.BH,o>270&&o<=360?a-=e.F:o>90&&o<=180?n-=e.I:o>180&&o<=270&&(n-=e.I,a-=e.F);break;case"center":n=(t=ZC.AQ.BN(l.iX,l.iY,l.CN+.5*(l.AI-l.CN)+l.DV,o))[0]+l.BM,a=t[1]+l.BH;break;default:n=l.iX+l.BM,a=l.iY+l.BH}return{x:n,y:a}},UY:function(e){var i,t=this,n=(t.B4+t.BK)/2%360,a=0;null!==ZC._n_(i=e["offset-r"])&&(a=ZC._f_(ZC._p_(i))),a<1&&(a*=t.AI);var l=ZC.AQ.BN(t.iX,t.iY,t.CN+.6*(t.AI-t.CN)+t.DV+a,n);return[l[0],l[1],{reference:t,center:!0}]},ACE:function(){var e=this,i=(e.B4+e.BK)/2%360,t=ZC.AQ.BN(e.iX,e.iY,e.CN+.5*(e.AI-e.CN)+e.DV,i);return[t[0],t[1]]},setup:function(){var e=this,i=e.C.BL(e.A.BU("k")[0]),t=e.L%i.H0,n=Math.floor(e.L/i.H0);e.iX=i.iX+t*i.GK+i.GK/2+i.BM,e.iY=i.iY+n*i.GF+i.GF/2+i.BH,e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},ABF:function(e){var i,t={},n="out";return null!==ZC._n_(i=e.o.placement)&&(n=i),t.color="out"===n?this.A0:this.C2,t},AC8:function(e){var i,t=this,n="out";null!==ZC._n_(i=e.o.placement)&&(n=i);var a,l,o,r,s,A=e.I,C=e.F,c=(t.B4+t.BK)/2%360,u=c;if("out"===n){c=u=t.A.A.YE["n"+t.L][t.A.L];var p=function(i,n){n<0&&(n=360+n),n%=360;var a=(s=ZC.AQ.BN(t.iX,t.iY,i+t.DV+e.DV+20,n))[0]+e.BM-A/2,l=s[1]+e.BH-C/2;return n>=0&&n<=90||n>=270&&n<=360?a+=A/2+10:a-=A/2+10,[a,l]},Z=p(t.AI,u);a=Z[0],l=Z[1],t.U=e;var h={x:a,y:l,width:A,height:C},d=zingchart.DEV.SPREADTYPE;r=!0;for(var f=0,_=0,g=-1,v=0,b=0;r&&b<1024;){r=!1;for(var B=0,m=t.A.A.TS.length;B<m;B++)o=t.A.A.TS[B],(ZC.AQ.XM(h,o)||h.x+e.I>t.C.P.iX+t.C.P.I||h.x<t.C.P.iX||h.y+e.F>t.C.P.iY+t.C.P.F||h.y<t.C.P.iY)&&(r=!0,0===d?(f+=.4,g*=-1):1===d&&(_+=2),Z=p(t.AI+_,u+f*g),h.x=Z[0],h.y=Z[1],b++,++v>100&&(v=0,0===d?(f=0,_+=2):1===d&&(_=0,f+=.4,g*=-1)))}a=h.x,l=h.y,c=u+f,o={text:t.A.AM,x:h.x,y:h.y,width:A,height:C,plotindex:t.A.L,nodeindex:t.L},t.A.A.TS.push(o)}else if("in"===n||"radial"===n){var E=t.CN<30?.65:.5;a=(s=t.B4%360==t.BK%360?0===t.CN?[t.iX,t.iY]:ZC.AQ.BN(t.iX,t.iY,t.CN+.3*(t.AI-t.CN)+t.DV+e.DV,270):ZC.AQ.BN(t.iX,t.iY,t.CN+E*(t.AI-t.CN)+t.DV+e.DV,c))[0]-A/2+t.BM,l=s[1]-C/2+t.BH}else if(-1!==n.indexOf("fixed=")){var D=n.split(/=|;|,/),K=(t.AI+t.CN)/2,F=c;D[1]&&(K=(K=ZC.II(D[1],!0))>=-1&&K<=1||-1!==D[1].indexOf("%")?t.CN+t.DV+K*(t.AI-t.CN):t.CN+t.DV+K),D[2]&&(F=(F=ZC.II(D[2],!0))>=-1&&F<=1||-1!==D[2].indexOf("%")?t.B4+F*(t.BK-t.B4):t.B4+F),D[3]&&("+"===D[3].charAt(0)||"-"===D[3].charAt(0)?(F%=360,e.A9=F+ZC._f_(D[3]),e.A9>90&&e.A9<270&&(e.A9+=180)):e.A9=ZC._f_(D[3])),a=(s=ZC.AQ.BN(t.iX,t.iY,K,F))[0]-A/2,l=s[1]-C/2}else"center"===n&&(a=t.iX-A/2+t.BM,l=t.iY-C/2+t.BH);return r&&(a=-9999,l=-9999,e.AN=!1),null!==ZC._n_(e.o.x)&&(a=e.iX),null!==ZC._n_(e.o.y)&&(l=e.iY),a>=-2&&(a=ZC._a_(a)),l>=-2&&(l=ZC._a_(l)),[ZC._i_(a),ZC._i_(l),c]},appendToValueBox:function(e){var i=this,t={};if("radial"===e.o.placement){var n=.9*ZC._a_(i.AI-i.CN),a=Math.PI*(i.AI+i.CN)*.9*ZC._a_(i.BK-i.B4)/360,l=ZC._i_(Math.max(n,a)/(.75*e.DG));if(null===ZC._n_(e.o.visible)?t.visible=1===i.A.A.A4.length||a>1.25*e.DG:t.visible=e.J9.visible,null===ZC._n_(e.o["max-chars"])&&(t["max-chars"]=l),null===ZC._n_(e.o.angle)){var o=(i.B4+i.BK)/2%360;i.A.A.A4.length>1?a>n?o>0&&o<180?o-=90:o+=90:o>90&&o<270&&(o+=180):o=0,t.angle=o}}return t},GW:function(e,i){var t,n=this,a=n.b(e,i);if(e)return a;if(n.AN&&a.AN&&null!==ZC._n_(a.AM)&&""!==a.AM){var l="out";if(null!==ZC._n_(t=a.o.placement)&&(l=t),"out"===l){var o=!0;if(null!==ZC._n_(t=a.o.connected)&&(o=ZC._b_(t)),o){var r=new ZC.DT(n.A);r.Z=r.C7=n.A.CP("bl",0),r.append(n.A.C3.o),r.K=n.K+"-connector",r.B7=n.A0,r.DU="line",r.D=[];var s=a.E.positioninfo,A=(n.B4+n.BK)/2%360,C=ZC.AQ.BN(n.iX,n.iY,n.AI+n.DV,A);C[0]+=n.BM,C[1]+=n.BH,r.D.push(C);var c=ZC.AQ.BN(n.iX,n.iY,n.AI+n.DV+10,A);c[0]+=n.BM,c[1]+=n.BH,a.iX>=n.iX?"vml"===n.H.AA?r.D.push([s[0],s[1]+a.F/2]):r.D.push([c[0],c[1],s[0],s[1]+a.F/2]):"vml"===n.H.AA?r.D.push([s[0]+a.I+2,s[1]+a.F/2]):r.D.push([c[0],c[1],s[0]+a.I+2,s[1]+a.F/2]),r.parse(),r.J2=function(e){return n.J2(e)},r.DE()&&r.parse(),r.AN&&r.paint()}}}},paint:function(){var e,i=this;if(i.b(),!(i.AD<0)){var t=i.C.BL(i.A.BU("k")[0]);i.setup();var n="pie-sel-"+i.A.L+"-"+i.L;if(i.o.detached&&"undefined"==typeof i.C.E[n]&&(i.C.E[n]=!0),i.AI=ZC.CY(t.GF,t.GK)/2,null!==ZC._n_(i.A.o.size)){var a=ZC.II(i.A.o.size,!1);i.AI=a<=1?i.AI*a:a}else i.AI=t.JE*i.AI;i.CN<=1&&(i.CN*=i.AI),i.CN=Math.max(0,i.CN),i.o.slice=i.CN,i.DV<=1&&(i.DV*=i.AI),i.o["offset-r"]=i.DV,i.C.E[n]&&(i.DV+=ZC._i_(.15*i.AI));var l=i.N=i.A.ID(i,i);if(i.H3(l),i.AD>=0||0===i.A.A.KM[i.L]){var o=new ZC.DT(i.A);o.K=i.K,o.Z=i.A.CP("bl",1),o.C7=i.A.CP("bl",0),o.copy(l);var r=i.iX,s=i.iY;i.DV>0&&(r=(e=ZC.AQ.BN(i.iX,i.iY,i.DV,(i.B4+i.BK)/2))[0],s=e[1]),o.iX=r,o.iY=s,o.AI=i.AI,o.o.size=i.AI,o.DU="pie",o.B4=ZC._f_(i.B4),o.BK=ZC._f_(i.BK),o.CN=i.CN,o.E.plotidx=i.A.L,o.E.nodeidx=i.L,o.parse(),i.G4=o;var A=function(){if(!i.A.K9&&i.AN){var e=o.FF(),t=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area",n=ZC.Q.G0("poly",i.A.EA,i.A.IV)+'class="'+t+'" '+i.a11y()+' id="'+i.K+'" coords="'+e+'" />';i.A.A.HE.push(n)}i.A.U&&i.GW()};if(i.AN)if(i.A.GG&&!i.C.HH){var C=o,c={};C.iX=r,C.iY=s,C.B4=i.B4,C.BK=i.BK,c.angleStart=i.B4,c.angleEnd=i.BK,c.x=r,c.y=s;var u,p=i.A.L7;for(u in C.C6=0,c.alpha=l.C6,2===p?(C.BK=i.B4,c.angleEnd=i.BK):3===p?(C.AI=i.CN,c.size=i.AI):4===p?(e=ZC.AQ.BN(i.iX,i.iY,1.2*i.AI,(i.B4+i.BK)/2),C.iX=e[0],C.iY=e[1],c.x=r,c.y=s):5===p&&(C.B4=C.BK=(i.B4+i.BK)/2,c.angleStart=i.B4,c.angleEnd=i.BK),i.A.FV)C[ZC.E4.GN[ZC.EE(u)]]=i.A.FV[u],c[ZC.EE(u)]=l[ZC.E4.GN[ZC.EE(u)]];if(null===ZC._n_(i.C.EN)&&(i.C.EN={}),null!==ZC._n_(i.C.EN[i.A.L+"-"+i.L]))for(u in i.C.EN[i.A.L+"-"+i.L])C[ZC.E4.GN[ZC.EE(u)]]=i.C.EN[i.A.L+"-"+i.L][u];i.C.EN[i.A.L+"-"+i.L]={},ZC._cp_(c,i.C.EN[i.A.L+"-"+i.L]);var Z=new ZC.E4(C,c,i.A.JF,i.A.L6,ZC.E4.RI[i.A.L8],function(){A()});Z.AX=i,i.LM(Z)}else o.paint(),A()}else i.A.U&&i.GW()}},A0W:function(e){var i=this;ZC.move||i.M5({layer:e,type:"shape",initcb:function(){if(this.copy(i),this.iX=i.iX,this.iY=i.iY,i.DV>0){var e=ZC.AQ.BN(i.iX,i.iY,i.DV,(i.B4+i.BK)/2);this.iX=e[0],this.iY=e[1]}this.AI=i.AI,this.DU="pie",this.A0=i.A.BP[3],this.AE=i.A.BP[2],this.B4=ZC._f_(i.B4),this.BK=ZC._f_(i.BK),this.CN=i.CN},parsecb:function(){this.o.size=i.AI,this.o.slice=i.CN,this.o["offset-r"]=i.DV}})},X4:function(e,i){var t=this;if(t.b(e,i),"click"===i&&e.which<=1&&t.A.A7O){zingchart.SKIP.ANIMATION=!0,zingchart.SKIP.EVENT=!0;var n="pie-sel-"+t.A.L+"-"+t.L;t.C.E[n]="undefined"==typeof t.C.E[n]||!t.C.E[n],t.C.K6(),zingchart.SKIP.EVENT=!1,zingchart.SKIP.ANIMATION=!1}}}),ZC.A49=ZC.LG.CA({bCXY:!0,$i:function(e){this.b(e)},setup:function(){var e=this,i=e.C.BL(e.A.BU("k")[0]);e.iX=i.iX+i.I/2+i.BM,e.iY=i.iY+i.F/2+i.BH,e.I2||(e.copy(e.A),e.o.slice=null,e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},ACE:function(){var e=this,i=(e.B4+e.BK)/2%360,t=ZC.AQ.BN(e.iX,e.iY,e.CN+e.E.bandwidth/2+e.DV,i);return[t[0],t[1]]},JV:function(e,i,t,n){var a=this,l=a.A.MP();ZC._cp_(i,l);var o=100*a.AD/a.A.A.KM[a.L],r=""+o;return null!==ZC._n_(l.decimals)&&(r=o.toFixed(ZC.BQ(0,ZC._i_(l.decimals)))),a.CV=[["%node-percent-value",r],["%npv",r]],e=a.b(e,i,t,n)},ABF:function(e){var i={},t="in";return null!==ZC._n_(e.o.placement)&&(t=e.o.placement),i.color="out"===t?this.A0:this.C2,i},AC8:function(e){var i=this,t="in";null!==ZC._n_(e.o.placement)&&(t=e.o.placement);var n,a,l,o=e.I,r=e.F,s=(i.B4+i.BK)/2%360;return"out"===t?i.L===i.A.S.length-1?(l=ZC.AQ.BN(i.iX,i.iY,i.A.U2+i.A.S.length*(i.E.bandwidth+i.E.bandspace)+15+e.DV,s),n=s>=0&&s<90||s>=270&&s<360?l[0]+10+i.BM:l[0]-o-10+i.BM,a=l[1]-r/2+i.BH):(n=-1,a=-1):(n=(l=ZC.AQ.BN(i.iX,i.iY,i.CN+i.E.bandwidth/2+e.DV,s))[0]-o/2+i.BM,a=l[1]-r/2+i.BH),null!==ZC._n_(e.o.x)&&(n=e.iX),null!==ZC._n_(e.o.y)&&(a=e.iY),[ZC._i_(n),ZC._i_(a),s]},GW:function(e){var i=this,t=i.b(e);if(e)return t;if(t.AN&&null!==ZC._n_(t.AM)&&""!==t.AM){var n="in";if(null!==ZC._n_(t.o.placement)&&(n=t.o.placement),"out"===n&&i.L===i.A.S.length-1){var a=new ZC.DT(i.A);a.Z=a.C7=i.H.usc()?i.H.mc("top"):i.C.AJ["3d"]||i.H.K9?ZC.AK(i.C.K+"-plots-vb-c"):ZC.AK(i.C.K+"-plot-"+i.A.L+"-vb-c"),a.append(i.A.C3.o),a.B7=i.A0,a.DU="line",a.D=[];var l=(i.B4+i.BK)/2%360,o=ZC.AQ.BN(i.iX,i.iY,i.CN+i.E.bandwidth+t.DV,l),r=ZC.AQ.BN(i.iX,i.iY,i.A.U2+i.A.S.length*(i.E.bandwidth+i.E.bandspace)+15+t.DV,l);o[0]+=i.BM,r[0]+=i.BM,o[1]+=i.BH,r[1]+=i.BH,a.D.push(o),l>=0&&l<90||l>=270&&l<360?a.D.push([r[0],r[1],r[0]+10,r[1]]):a.D.push([r[0],r[1],r[0]-10,r[1]]),a.parse(),a.J2=function(e){return i.J2(e)},a.DE()&&a.parse(),a.AN&&a.paint()}}},paint:function(){var e,i=this;i.b();var t=i.C.BL(i.A.BU("k")[0]);i.setup(),i.AI=ZC.CY(t.I,t.F)/2,i.AI=t.JE*i.AI,i.CN=i.A.U2,i.CN<1&&(i.CN=i.A.U2*i.AI);var n=i.A.SN;n<1&&(n=i.A.SN*i.AI);var a=2,l=i.AI-i.CN;if(null!==ZC._n_(i.A.aBandWidths)&&null!==ZC._n_(i.A.aBandWidths[i.L])){(a=ZC._f_(i.A.aBandWidths[i.L]))>1&&(a/=100),a=ZC._i_(l*a),a=ZC.BQ(a,2);for(var o=0,r=0;r<i.L;r++)o+=ZC._f_(i.A.aBandWidths[r]);o>1&&(o/=100),o=ZC._i_(l*o),i.CN+=o,i.AI=i.CN+a}else a=(l-(i.A.S.length-1)*n)/i.A.S.length,a=ZC.BQ(a,2),i.CN+=i.L*(a+n),i.AI=i.CN+a;var s=i.N=i.A.ID(i,i);i.H3(s);var A=new ZC.DT(i.A);A.K=i.K,A.Z=i.A.CP("bl",1),A.C7=i.A.CP("bl",0),A.copy(s),A.iX=i.iX,A.iY=i.iY,A.DU="pie",A.B4=i.B4,A.BK=i.BK,A.CN=i.CN,A.AI=i.AI,A.parse();var C=A.CN;function c(){var e=A.FF(),t=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area",n=ZC.Q.G0("poly",i.A.EA,i.A.IV)+'class="'+t+'" '+i.a11y()+' id="'+i.K+'" coords="'+e+'" />';i.A.A.HE.push(n),i.A.U&&i.A.U.AN&&i.GW()}if(i.E.bandwidth=a,i.E.bandspace=n,i.A.GG&&!i.C.HH){var u=A,p={};u.B4=i.B4,u.BK=i.BK,p.angleStart=i.B4,p.angleEnd=i.BK;var Z=i.A.L7;if(u.C6=0,p.alpha=s.C6,2===Z)u.BK=i.B4,p.angleEnd=i.BK;else if(3===Z)u.CN=C+i.E.bandwidth,p.slice=C;else if(4===Z){var h=ZC.AQ.BN(i.iX,i.iY,i.AI,(i.B4+i.BK)/2);u.iX=h[0],u.iY=h[1],p.x=i.iX,p.y=i.iY}else 5===Z&&(u.B4=u.BK=(i.B4+i.BK)/2,p.angleStart=i.B4,p.angleEnd=i.BK);for(e in i.A.FV)u[ZC.E4.GN[ZC.EE(e)]]=i.A.FV[e],p[ZC.EE(e)]=s[ZC.E4.GN[ZC.EE(e)]];if(i.C.EN||(i.C.EN={}),null!==ZC._n_(i.C.EN[i.A.L+"-"+i.L]))for(e in i.C.EN[i.A.L+"-"+i.L])u[ZC.E4.GN[ZC.EE(e)]]=i.C.EN[i.A.L+"-"+i.L][e];i.C.EN[i.A.L+"-"+i.L]={},ZC._cp_(p,i.C.EN[i.A.L+"-"+i.L]);var d=new ZC.E4(u,p,i.A.JF,i.A.L6,ZC.E4.RI[i.A.L8],function(){c()});d.AX=i,i.LM(d)}else A.paint(),c()},A0W:function(e){var i=this;ZC.move||i.M5({layer:e,type:"shape",initcb:function(){this.copy(i),this.iX=i.iX,this.iY=i.iY,this.DU="pie",this.A0=i.A.BP[3],this.AE=i.A.BP[2],this.B4=i.B4,this.BK=i.BK,this.CN=i.CN,this.AI=i.AI},parsecb:function(){this.o.slice=null}})}}),ZC.A76=ZC.LG.CA({$i:function(e){this.b(e);var i=this;i.CD=null,i.CJ=null,i.MM="max"},JV:function(e,i,t,n){var a=this;return"range"===a.A.CW&&(a.CV=[["%node-min-value",a.CD],["%node-max-value",a.CJ]]),e=a.b(e,i,t,n)},A96:function(){var e=this;if("range"===e.A.CW&&e.o.value instanceof Array){var i=e.o.value.length;i>2&&(e.BT=ZC._f_(e.o.value[0])),e.CD=ZC._f_(e.o.value[i-2]),e.CJ=ZC._f_(e.o.value[i-1]),e.AD=e.CS=e.CJ,e.DP.push(e.CD)}else e.b()},setup:function(){var e=this,i=e.A.B1,t=e.A.CM,n=[i.W,i.A1,t.W,t.A1];if(e.JO!==n){var a;a="range"===e.A.CW?t.U6("min"===e.MM?e.CD:e.CJ):t.U6(e.CS);var l=null!==ZC._n_(e.BT),o=i.A71(l?e.BT:e.L,a,l);e.iX=o[0],e.iY=o[1],e.JO=n}e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},AC8:function(e){var i,t=this,n=t.A.B1,a=t.A.CM,l=t.C.BL("scale"),o=l.iX+l.I/2,r=l.iY+l.F/2,s=e.I,A=e.F,C="out";null!==ZC._n_(e.o.placement)&&(C=e.o.placement);var c=1.15;switch(C){case"out":c=1.15;break;case"over":c=1;break;case"in":c=.85;break;case"middle":c=.5}var u,p,Z=n.EI/(n.V.length-(360===n.EI||n.DJ?0:1)),h=a.U6(t.CS);switch(t.A.CW){case"matrix":case"piano":var d=(ZC.CY(l.I/2,l.F/2)*l.JE-a.AB)/t.A.A.A4.length;u=a.AB+t.A.L*d,p=a.AB+(t.A.L+1)*d,i=ZC.AQ.BN(o,r,(u+p)/2*c+e.DV,n.DH+(n.DJ?Z/2:0)+t.L*Z);break;default:if(null!==ZC._n_(t.BT)){var f=n.DH+n.EI*(t.BT-n.B3)/(n.BJ-n.B3);i=ZC.AQ.BN(o,r,a.AB+h*c+e.DV,f)}else i=ZC.AQ.BN(o,r,a.AB+h*c+e.DV,n.DH+(n.DJ?Z/2:0)+t.L*Z)}return i[0]-=s/2,i[1]-=A/2,null!==ZC._n_(e.o.x)&&(i[0]=e.iX),null!==ZC._n_(e.o.y)&&(i[1]=e.iY),[ZC._i_(i[0]),ZC._i_(i[1])]},ABF:function(){return{color:"rose"===this.A.CW?this.A0:this.B7}},Y4:function(){return{"background-color":"rose"===this.A.CW?this.A0:this.B7,"border-color":"rose"===this.A.CW?this.A0:this.B7,color:this.C2}},paint:function(){var e,i,t=this;t.b();var n,a,l=t.A.QE,o=t.A.A56,r=t.A.B1,s=t.A.CM,A=t.A.S;t.setup(),t.CZ=!1,t.C7=t.A.CP("bl",0);var C,c=[],u=[],p=[],Z=[],h="range"===t.A.CW;function d(){if(t.A.RX>=t.A.S.length&&t.A.Y1){var e=t.C.K+"-node-area "+t.C.K+"-plotset-plot-"+t.A.L+"-node-area zc-node-area",i="",a="";-1!==ZC.AV(["line","area","range"],t.A.CW)?""!==(a="range"!==t.A.CW||t.A.XC?ZC.AQ.PR(ZC.AQ.Z0(t.E.points),4):ZC.AQ.PR(u,4))&&(i=ZC.Q.G0("poly",t.A.EA,t.A.IV)+'class="'+e+'" '+t.a11y()+' id="'+t.K+'" coords="'+a+'" />'):-1!==ZC.AV(["rose","column","bar","matrix","piano"],t.A.CW)&&(a=n.FF(),i=ZC.Q.G0("poly",t.A.EA,t.A.IV)+'class="'+e+'" '+t.a11y()+' id="'+t.K+'" coords="'+a+'" data-z-sort="'+(t.A.A.A4.length-t.A.L)+'" />'),t.A.A.HE.push(i)}t.A.U&&t.A.E.vboxid!==t.K&&t.GW()}var f,_,g,v,b,B=t.N=t.A.ID(t,t);if(t.A.HT&&t.H3(B),-1!==ZC.AV(["line","area","range"],t.A.CW)){c=[],u=[],p=[],Z=[];var m=t.iX,E=t.iY,D=t.iX,K=t.iY;h&&(t.MM="max",t.setup(),m=t.iX,E=t.iY,t.MM="min",t.setup(),D=t.iX,K=t.iY),t.A.I3&&(t.A.D.push([m,E]),t.A.AH.push([m,E])),t.L>0?(C=A[t.L-1])&&(C.MM="max",C.setup(),a=ZC.AQ.JT(C.iX,C.iY,m,E),c.push(a),u.push(a),h&&(C.MM="min",C.setup(),a=ZC.AQ.JT(C.iX,C.iY,D,K),p.push(a),Z.push(a))):(C=A[t.A.S.length-1])&&(C.MM="max",C.setup(),a=ZC.AQ.JT(C.iX,C.iY,m,E),c.push(a),u.push(a),h&&(C.MM="min",C.setup(),a=ZC.AQ.JT(C.iX,C.iY,D,K),p.push(a),Z.push(a))),c.push([m,E]),u.push([m,E]),h&&(p.push([D,K]),Z.push([D,K])),t.L<t.A.S.length-1?(C=A[t.L+1])&&(C.MM="max",C.setup(),a=ZC.AQ.JT(m,E,C.iX,C.iY),c.push(a),u.push(a),h&&(C.MM="min",C.setup(),a=ZC.AQ.JT(D,K,C.iX,C.iY),p.push(a),Z.push(a))):(C=A[0])&&(C.MM="max",C.setup(),a=ZC.AQ.JT(m,E,C.iX,C.iY),c.push(a),u.push(a),h&&(C.MM="min",C.setup(),a=ZC.AQ.JT(D,K,C.iX,C.iY),p.push(a),Z.push(a))),ZC.CR.setup(l,B)}h&&(c.push(null),c=c.concat(p.reverse()),u=u.concat(Z.reverse()));var F,x,I,y,w,Y,X,M,L,H,P,N=t.C.P;if(f=t.C.BL("scale"),"area"!==t.A.CW&&"range"!==t.A.CW||(_=f.iX+f.I/2,g=f.iY+f.F/2,v=360/r.V.length,"area"===t.A.CW&&u.push([_,g]),t.A.I3||((b=new ZC.DT(t.A)).K=t.K+"-area",b.Z=t.A.CP("bl",0),b.copy(B),b.L5=!0,b.D=u,b.parse(),b.C6=t.A.HX,1===b.C6&&0===b.AU&&(b.A0=ZC.AP.QU(ZC.AP.GC(b.A0),20),b.AE=ZC.AP.QU(ZC.AP.GC(b.AE),20),b.AU=2,b.BW=b.A0),b.D1=[N.iX,N.iY,N.iX+N.I,N.iY+N.F],ZC.CR.setup(o,b))),t.E.points=c,t.E.pointsarea=u,t.setNodeData({points:c,pointsarea:u}),t.A.I3&&t.L===r.A1&&("area"===t.A.CW&&((b=new ZC.DT(t.A)).K=t.K+"-area",b.Z=t.A.CP("bl",0),b.copy(t.A),b.L5=!0,b.D=t.A.AH,b.parse(),b.C6=t.A.HX,b.D1=[N.iX,N.iY,N.iX+N.I,N.iY+N.F],b.paint()),"line"!==t.A.CW&&"area"!==t.A.CW&&"range"!==t.A.CW||(t.A.D[0]&&t.A.D.push([t.A.D[0][0],t.A.D[0][1]]),ZC.CR.paint(l,B,t.A.D))),-1!==ZC.AV(["dots","scatter","area","line"],t.A.CW))t.P8(!1,!0);else if(-1!==ZC.AV(["rose","column","bar","piano","matrix"],t.A.CW)){(n=new ZC.DT(t.A)).K=t.K+"-pie",n.copy(B),n.Z=t.A.CP("bl",1),n.C7=t.A.CP("bl",0),_=(f=t.C.BL("scale")).iX+f.I/2,g=f.iY+f.F/2;var G=.1*(v=r.EI/(r.V.length-(360===r.EI||r.DJ?0:1)));t.A.CC||(G=.1*v+.4*v*t.A.L/t.A.A.A4.length),null!==ZC._n_(e=t.A.A60)&&(G=e<1?v*e:e),Y=s.AB;var S=t.A.A;t.A.CC&&null!==ZC._n_(S.A2E["stack"+t.L])&&(Y+=S.A2E["stack"+t.L]);var O=ZC._i_(s.U6(t.CS));if(t.A.CC&&(S.A2E["stack"+t.L]=O),null===ZC._n_(t.BT))I=r.DH+t.L*v-v/2+G+(r.DJ?v/2:0),y=r.DH+(t.L+1)*v-v/2-G+(r.DJ?v/2:0);else{var k=r.DH+r.EI*(t.BT-r.B3)/(r.BJ-r.B3);I=k-v/2+G,y=k+v/2-G}if(w=O+s.AB,"piano"===t.A.CW||"matrix"===t.A.CW){var T=(ZC.CY(f.I/2,f.F/2)*f.JE-s.AB)/t.A.A.A4.length;w=s.AB+t.A.L*T,Y=s.AB+(t.A.L+1)*T}t.setNodeData({x:_,y:g,sz:w,sl:Y,as:I,ae:y}),n.iX=_,n.iY=g,n.DU="pie",n.B4=I,n.BK=y,n.AI=w,n.CN=Y,n.parse(),n.J2=function(e){return t.J2(e)},n.DE()&&n.parse()}if(t.A.GG&&-1!==ZC.AV(["line","area","rose","column","bar","matrix","piano"],t.A.CW)){switch(t.A.CW){case"line":case"area":x={},(F=new ZC.DT(t)).copy(B),F.K=t.K,F.Z=t.A.CP("bl",1),F.C7=t.A.CP("bl",0),F.D=c,F.C6=0,x.alpha=B.C6,x.points=c;var z=[];"area"===t.A.CW&&(L={},X=[],(M=b).D=u,M.C6=0,L.points=u,L.alpha=t.A.HX);break;case"rose":case"column":case"bar":case"matrix":case"piano":x={},(F=n).iX=_,F.iY=g,F.B4=I,F.BK=y,F.C6=0,x.angleStart=I,x.angleEnd=y,x.x=_,x.y=g,x.size=w,x.alpha=B.C6}var Q,J=t.A.L7,V=t.C.P;switch(J){case 1:break;case 7:switch(t.A.CW){case"line":case"area":for(i=0;i<c.length;i++)z[i]=[c[i][0],V.iY+V.F/2];if(F.D=z,x.points=c,"area"===t.A.CW){for(i=0;i<u.length;i++)X[i]=[u[i][0],V.iY+V.F/2];M.D=X,L.points=u}}break;case 2:switch(t.A.CW){case"line":case"area":for(i=0;i<c.length;i++)z[i]=[V.iX+V.I/2,c[i][1]];if(F.D=z,x.points=c,"area"===t.A.CW){for(i=0;i<u.length;i++)X[i]=[V.iX+V.I/2,u[i][1]];M.D=X,L.points=u}break;case"rose":case"column":case"bar":case"matrix":case"piano":F.BK=I,x.angleEnd=y}break;case 3:switch(t.A.CW){case"line":case"area":for(i=0;i<c.length;i++)z[i]=[V.iX+V.I/2,V.iY+V.F/2];if(F.D=z,x.points=c,"area"===t.A.CW){for(i=0;i<u.length;i++)X[i]=[V.iX+V.I/2,V.iY+V.F/2];M.D=X,L.points=u}break;case"rose":case"column":case"bar":case"matrix":case"piano":F.AI=s.AB,x.size=w}break;case 4:switch(t.A.CW){case"line":case"area":for(i=0;i<c.length;i++)H=V.iX+V.I/2-c[i][0],P=V.iY+V.F/2-c[i][1],z[i]=[V.iX+V.I/2-2.5*H,V.iY+V.F/2-2.5*P];if(F.D=z,x.points=c,"area"===t.A.CW){for(i=0;i<u.length;i++)H=V.iX+V.I/2-u[i][0],P=V.iY+V.F/2-u[i][1],X[i]=[V.iX+V.I/2-2.5*H,V.iY+V.F/2-2.5*P];M.D=X,L.points=u}break;case"rose":case"column":case"bar":case"matrix":case"piano":F.AI=2*w,x.size=w}break;case 5:switch(t.A.CW){case"rose":case"column":case"bar":case"matrix":case"piano":F.B4=F.BK=(I+y)/2,x.angleStart=I,x.angleEnd=y}}for(Q in t.A.FV)F[ZC.E4.GN[ZC.EE(Q)]]=t.A.FV[Q],x[ZC.EE(Q)]=B[ZC.E4.GN[ZC.EE(Q)]];if(null===ZC._n_(t.C.EN)&&(t.C.EN={},"area"===t.A.CW&&(t.C.SS={})),null!==ZC._n_(t.C.EN[t.A.L+"-"+t.L])){for(Q in t.C.EN[t.A.L+"-"+t.L])F[ZC.E4.GN[ZC.EE(Q)]]=t.C.EN[t.A.L+"-"+t.L][Q];if("area"===t.A.CW)for(Q in t.C.SS[t.A.L+"-"+t.L])M[ZC.E4.GN[ZC.EE(Q)]]=t.C.SS[t.A.L+"-"+t.L][Q]}t.C.EN[t.A.L+"-"+t.L]={},ZC._cp_(x,t.C.EN[t.A.L+"-"+t.L]),"area"===t.A.CW&&(t.C.SS[t.A.L+"-"+t.L]={},ZC._cp_(L,t.C.SS[t.A.L+"-"+t.L]));var R=new ZC.E4(F,x,t.A.JF,t.A.L6,ZC.E4.RI[t.A.L8],function(){d()});R.AX=t,-1!==ZC.AV(["line","area"],t.A.CW)&&(R.IK=l);var W=null;"area"===t.A.CW&&((W=new ZC.E4(M,L,t.A.JF,t.A.L6,ZC.E4.RI[t.A.L8],function(){})).AX=t),t.LM(R,W)}else{switch(t.A.CW){case"line":case"area":case"range":t.A.I3||(ZC.CR.paint(l,B,c),"area"!==t.A.CW&&"range"!==t.A.CW||b.paint());break;case"rose":case"column":case"bar":case"matrix":case"piano":n.paint()}d()}},A0W:function(e){var i=this;ZC.move||(i.A.IE&&i.A.AN&&(-1!==ZC.AV(["line","area","range"],i.A.CW)?(i.A1F(e),"area"!==i.A.CW&&"range"!==i.A.CW||i.M5({layer:e,type:"area",initcb:function(){this.D=i.E.pointsarea},setupcb:function(){this.AZ=0,this.AU=0,this.C6=i.A.HX;var e=i.C.P;this.D1=[e.iX,e.iY,e.iX+e.I,e.iY+e.F]}})):-1!==ZC.AV(["rose","column","bar","matrix","piano"],i.A.CW)&&i.M5({layer:e,type:"shape",initcb:function(){this.copy(i),this.B7=i.A.BP[1],this.BW=i.A.BP[1],this.A0=i.A.BP[3],this.AE=i.A.BP[2],this.iX=i.getNodeData("x"),this.iY=i.getNodeData("y"),this.CN=i.getNodeData("sl"),this.B4=i.getNodeData("as"),this.BK=i.getNodeData("ae"),this.DU="pie",this.AI=i.getNodeData("sz")}})),-1!==ZC.AV(["dots","scatter","line"],i.A.CW)&&i.TR(e))}}),ZC.A5R=ZC.ZB.CA({$i:function(e){this.b(e),this.FJ=null},JV:function(e,i,t,n){var a=this,l=a.A.MP();ZC._cp_(i,l);var o=ZC.AP.G2(a.A.Q0[a.L],l);return a.CV=[["%node-goal-value",o],["%g",o]],e=a.b(e,i,t,n)},AC8:function(e){var i=this;return"goal"===ZC._n_(e.o.placement)?[i.FJ.iX+i.FJ.I/2-e.I/2,i.FJ.iY-e.F]:i.b(e)},A96:function(){var e,i=this;if(i.DP=[],i.CK=i.o.value,"string"==typeof i.o.value){var t=ZC.AV(i.A.CM.JK,i.o.value);-1!==t?i.AD=t:(i.A.CM.JK.push(i.o.value),i.AD=i.A.CM.JK.length-1)}else i.AD=ZC._f_(i.o.value);i.A.o.goals&&null!==ZC._n_(e=i.A.o.goals[i.L])&&i.DP.push(ZC._f_(e))},paint:function(){this.b()},paint_:function(){var e,i,t=this;if(null!==ZC._n_(t.A.Q0[t.L])&&t.AN){var n=t.A.CM.AT(t.A.Q0[t.L]);t.FJ=new ZC.HL(t.A),t.FJ.K=t.K+"-goal",t.FJ.copy(t.A.FJ),t.FJ.Z=t.A.CP("fl",0),t.FJ.C7=t.A.CP("fl",0),t.FJ.J2=function(e){return t.J2(e)},t.FJ.DE()&&t.FJ.parse(),null!==ZC._n_(e=t.FJ.o)&&null!==ZC._n_(e.styles)&&null!==ZC._n_(i=e.styles[t.L])&&("string"==typeof i?t.FJ.append({"background-color":i}):t.FJ.append(i),t.FJ.parse());var a=.2;if(null!==ZC._n_(e=t.FJ.o.extension)&&(a=ZC._f_(e)),t.FJ.iX=t.getNodeData("x")-t.I*a,t.FJ.I=t.I*(1+2*a),null===ZC._n_(t.A.FJ.o.height)&&(t.FJ.F=ZC.CY(5,t.C.P.F/30)),t.FJ.iY=n-t.FJ.F/2,t.FJ.AN){t.FJ.paint();var l=t.C.K+"-node-area "+t.C.K+"-plotset-plot-"+t.A.L+"-node-area zc-node-area";t.A.A.HE.push(ZC.Q.G0("rect",t.A.EA,t.A.IV)+'class="'+l+'" id="'+t.K+'--goal" coords="'+ZC._i_(t.FJ.iX+t.A.BM+ZC.MAPTX)+","+ZC._i_(t.FJ.iY+t.A.BH+ZC.MAPTX)+","+ZC._i_(t.FJ.iX+t.A.BM+t.FJ.I+ZC.MAPTX)+","+ZC._i_(t.FJ.iY+t.A.BH+t.FJ.F+ZC.MAPTX)+'" />')}}},A0W:function(e){var i=this;if(!ZC.move&&(i.b(e),i.FJ&&i.FJ.AN)){var t=new ZC.HL(i.A);t.copy(i.FJ),t.Z=ZC.AK(i.C.K+"-hover-c"),t.M8=!1,t.iX=i.FJ.iX,t.iY=i.FJ.iY,t.paint()}}}),ZC.A5P=ZC.ZA.CA({$i:function(e){this.b(e),this.FJ=null},JV:function(e,i,t,n){var a=this,l=a.A.MP();ZC._cp_(i,l);var o=ZC.AP.G2(a.A.Q0[a.L],l);return a.CV=[["%node-goal-value",o],["%g",o]],e=a.b(e,i,t,n)},AC8:function(e){var i=this;return"goal"===ZC._n_(e.o.placement)?[i.FJ.iX+i.FJ.I,i.FJ.iY+i.FJ.F/2-e.F/2]:i.b(e)},A96:function(){var e,i=this;if(i.DP=[],i.CK=i.o.value,"string"==typeof i.o.value){var t=ZC.AV(i.A.CM.JK,i.o.value);-1!==t?i.AD=t:(i.A.CM.JK.push(i.o.value),i.AD=i.A.CM.JK.length-1)}else i.AD=ZC._f_(i.o.value);i.A.o.goals&&null!==ZC._n_(e=i.A.o.goals[i.L])&&i.DP.push(ZC._f_(e))},paint:function(){this.b()},paint_:function(){var e,i,t=this;if(null!==ZC._n_(t.A.Q0[t.L])&&t.AN){var n=t.A.CM.AT(t.A.Q0[t.L]);t.FJ=new ZC.HL(t.A),t.FJ.K=t.K+"-goal",t.FJ.copy(t.A.FJ),t.FJ.Z=t.A.CP("fl",0),t.FJ.C7=t.A.CP("fl",0),t.FJ.J2=function(e){return t.J2(e)},t.FJ.DE()&&t.FJ.parse(),null!==ZC._n_(e=t.FJ.o)&&null!==ZC._n_(e.styles)&&null!==ZC._n_(i=e.styles[t.L])&&("string"==typeof i?t.FJ.append({"background-color":i}):t.FJ.append(i),t.FJ.parse());var a=.2;if(null!==ZC._n_(e=t.FJ.o.extension)&&(a=ZC._f_(e)),t.FJ.iY=t.getNodeData("y")-t.F*a,t.FJ.F=t.F*(1+2*a),null===ZC._n_(t.A.FJ.o.width)&&(t.FJ.I=ZC.CY(5,t.C.P.I/30)),t.FJ.iX=n-t.FJ.I/2,t.FJ.AN){t.FJ.paint();var l=t.C.K+"-node-area "+t.C.K+"-plotset-plot-"+t.A.L+"-node-area zc-node-area";t.A.A.HE.push(ZC.Q.G0("rect",t.A.EA,t.A.IV)+'class="'+l+'" id="'+t.K+'--goal" coords="'+ZC._i_(t.FJ.iX+t.A.BM+ZC.MAPTX)+","+ZC._i_(t.FJ.iY+t.A.BH+ZC.MAPTX)+","+ZC._i_(t.FJ.iX+t.A.BM+t.FJ.I+ZC.MAPTX)+","+ZC._i_(t.FJ.iY+t.A.BH+t.FJ.F+ZC.MAPTX)+'" />')}}},A0W:function(e){var i=this;if(!ZC.move&&(i.b(e),i.FJ&&i.FJ.AN)){var t=new ZC.HL(i.A);t.copy(i.FJ),t.Z=ZC.AK(i.C.K+"-hover-c"),t.M8=!1,t.iX=i.FJ.iX,t.iY=i.FJ.iY,t.paint()}}}),ZC.A7H=ZC.LG.CA({A96:function(){var e,i=this;i.o.value instanceof Array&&null!==ZC._n_(i.o.value[1])&&(i.CK=i.o.value[1],"string"==typeof i.o.value[0]?-1!==(e=ZC.AV(i.A.B1.IQ,i.o.value[0]))?i.BT=e:(i.A.B1.IQ.push(i.o.value[0]),i.BT=i.A.B1.IQ.length-1):i.BT=ZC._f_(i.o.value[0]),"string"==typeof i.o.value[1]?-1!==(e=ZC.AV(i.A.CM.JK,i.o.value[1]))?i.AD=e:(i.A.CM.JK.push(i.o.value[1]),i.AD=i.A.CM.JK.length-1):i.AD=ZC._f_(i.o.value[1]),null!==i.BT&&i.A.V4(i.BT,i.L))},setup:function(){var e=this,i=e.A.B1,t=e.A.CM,n=[i.W,i.A1,t.W,t.A1];e.JO!==n&&(i.AW?e.iX=i.iX+i.I-i.AB-(e.L-i.W+1)*i.AC:e.iX=i.iX+i.AB+(e.L-i.W)*i.AC,t.AW?e.iY=t.iY+t.AB+(e.A.L-t.B3)*t.AC:e.iY=t.iY+t.F-t.AB-(e.A.L-t.B3+1)*t.AC,e.JO=n),e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0),e.H3(e)},AC8:function(e){var i=this,t="over";null!==ZC._n_(e.o.placement)&&(t=e.o.placement);var n=e.I,a=e.F,l=i.iX+i.I/2-n/2,o=i.iY+i.F/2-a/2;switch(t){case"top":o-=i.F/2+a/2+2;break;case"left":l-=i.I/2+n/2+2;break;case"bottom":o+=i.F/2+a/2+2;break;case"right":l+=i.I/2+n/2+2}return null!==ZC._n_(e.o.x)&&(l=e.iX),null!==ZC._n_(e.o.y)&&(o=e.iY),[ZC._i_(l),ZC._i_(o)]},ABF:function(){return{color:"#000"}},getFormatValue:function(){return this.CK},JV:function(e,i,t,n){var a,l=this,o=l.A.CM,r=l.A.L;return a=null!==ZC._n_(o.BX[r])?o.BX[r]:o.V[r],l.CV=[["%y",a],["%scale-value-label",a]],e=l.b(e,i,t,n)},T6:function(){var e=this;e.setup();var i,t=e.A.B1,n=e.A.CM;switch(e.A.A7I){case"plot-max":i=(ZC._f_(e.AD)-e.A.Y8)/(e.A.A4J-e.A.Y8);break;case"plot-total":i=(ZC._f_(e.AD)-e.A.Y8)/(e.A.A67-e.A.Y8);break;case"chart-max":i=(ZC._f_(e.AD)-e.A.WV)/(e.A.A3B-e.A.WV);break;case"chart-total":i=(ZC._f_(e.AD)-e.A.WV)/(e.A.A4L-e.A.WV)}switch(ZC.P5(i)||(i=.5),e.I=t.AC,e.F=n.AC,e.A.CW){case"alpha":case"brightness":e.C6=e.A.QG+i*(e.A.UU-e.A.QG);break;case"horizontal":e.I=1.01+e.A.QG*t.AC+i*t.AC*(e.A.UU-e.A.QG),t.AW&&(e.iX=e.iX+t.AC-e.I);break;case"vertical":e.F=1.01+e.A.QG*n.AC+i*n.AC*(e.A.UU-e.A.QG),n.AW||(e.iY=e.iY+n.AC-e.F);break;case"size":e.I=1.01+e.A.QG*t.AC+i*t.AC*(e.A.UU-e.A.QG),e.F=1.01+e.A.QG*n.AC+i*n.AC*(e.A.UU-e.A.QG),e.iX+=(t.AC-e.I)/2,e.iY+=(n.AC-e.F)/2}e.iX-=e.AU/2,e.iY-=e.AU/2,e.I+=e.AU,e.F+=e.AU},paint:function(){var e=this;e.b(),e.T6();var i=e.C.P;if(!(e.iY+5<i.iY||e.iY+5>=i.iY+i.F)){if(e.AN){var t=zingchart.pool.getInstance("HL",e,e.A.K+"-piano-box");if(t.K=e.K,t.copy(e),("none"!==e.A.IZ||e.C.IX[e.A.L]||e.C.KI||e.A.SY&&e.A.SY[e.L])&&t.copy(e.A.ID(e,t)),t.iX=e.iX,t.iY=e.iY,t.I=e.I,t.F=e.F,t.Z=e.A.CP("bl",1),t.C7=e.A.CP("bl",0),(-1!==t.BW&&t.AU>0||t.Q1+t.OJ+t.NP+t.P6!==""||-1!==t.A0||-1!==t.AE||""!==t.DA||""!==t.GR||""!==t.HN)&&(t.paint(),!t.K9)){var n=e.C.K+"-node-area "+e.C.K+"-plotset-plot-"+e.A.L+"-node-area zc-node-area";e.A.A.HE.push(ZC.Q.G0("rect",e.A.EA,e.A.IV)+'class="'+n+'" '+e.a11y()+' id="'+e.K+'" coords="'+ZC._i_(e.iX+ZC.MAPTX)+","+ZC._i_(e.iY+ZC.MAPTX)+","+ZC._i_(e.iX+e.I+ZC.MAPTX)+","+ZC._i_(e.iY+e.F+ZC.MAPTX)+'" />')}}e.A.U&&e.A.U.AN&&e.GW()}},A0W:function(e){var i=this;ZC.move||i.M5({layer:e,type:"box",initcb:function(){this.AE=i.A.BP[3],this.B7=i.A.BP[1],this.BW=i.A.BP[1],this.A0=i.A.BP[2]},setupcb:function(){this.iX=i.iX,this.iY=i.iY,this.I=i.I,this.F=i.F}})}}),ZC.A5V=ZC.LG.CA({setup:function(){var e=this,i=e.A.B1,t=e.A.CM,n=[i.W,i.A1,t.W,t.A1];e.JO!==n&&(i.AW?e.iX=i.iX+i.I-i.AB-(e.L+1)*i.AC:e.iX=i.iX+i.AB+e.L*i.AC,t.AW?e.iY=t.iY+t.AB+e.A.L*t.AC:e.iY=t.iY+t.F-t.AB-(e.A.L+1)*t.AC,e.JO=n),e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},JV:function(e,i,t,n){var a,l,o=this,r=ZC._f_(o.A.A.F8["%pstack-"+o.L+"-0-sum"]||"0"),s=o.A.MP();if(ZC._cp_(i,s),o.CV=[],o.A.L>0&&o.A.A.A4[o.A.L-1]&&o.A.A.A4[o.A.L-1].S[o.L]?l=""+(a=100*o.AD/o.A.A.A4[o.A.L-1].S[o.L].AD):(a=100,l="100"),null!==ZC._n_(s.decimals)&&(l=a.toFixed(ZC.BQ(0,ZC._i_(s.decimals)))),o.CV.push(["%output-percent-value",l]),r>0){var A=100*o.AD/r,C=""+A;null!==ZC._n_(s.decimals)&&(C=A.toFixed(ZC.BQ(0,ZC._i_(s.decimals)))),o.CV.push(["%node-percent-value",C]),o.CV.push(["%npv",C])}return e=o.b(e,i,t,n)},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c,u,p=this;p.b();var Z=p.A.B1,h=p.A.CM;p.setup(),"static"===p.A.A2I?(p.C.AY.SC[p.L],e=p.C.AY.A7K[p.L]):(p.C.AY.B3,e=p.C.AY.BJ);var d=p.A.KZ;d<=1&&(d*=Z.AC);var f=p.A.O9;f<=1&&(f*=Z.AC);var _=p.A.LZ;_<=1&&(_*=Z.AC);var g=Z.AC-d-f-_,v=_+g*(p.AD/e),b=0;p.A.L+1<p.A.A.A4.length&&p.A.A.A4[p.A.L+1].S[p.L]&&(b=p.A.A.A4[p.A.L+1].S[p.L].AD);var B=_+g*(b/e);p.E["entry-exit"]=[v,B];var m=p.iX+(Z.AW?f:d)+g/2+_/2;if(n=[],h.AW?n.push([m-v/2,p.iY],[m+v/2,p.iY],[m+B/2,p.iY+h.AC],[m-B/2,p.iY+h.AC],[m-v/2,p.iY]):n.push([m-v/2,p.iY+h.AC],[m+v/2,p.iY+h.AC],[m+B/2,p.iY],[m-B/2,p.iY],[m-v/2,p.iY+h.AC]),p.E.points=n,p.AN){var E=new ZC.DT(p.A);E.K=p.K+"-trapeze",E.copy(p),E.D=n,E.parse(),E.Z=p.A.CP("bl",1),E.C7=p.A.CP("bl",0),E.paint();var D=E.FF(),K=p.C.K+"-node-area "+p.C.K+"-plotset-plot-"+p.A.L+"-node-area zc-node-area";p.A.A.HE.push(ZC.Q.G0("poly",p.A.EA,p.A.IV)+'class="'+K+'" id="'+p.K+'" coords="'+D+'" />')}for(i=0,t=p.A.OR.length;i<t;i++){var F=p.A.OR[i];F&&null!==ZC._n_(F.o.values)&&null!==ZC._n_(F.o.values[p.L])&&(null===ZC._n_(F.o.width)&&null===ZC._n_(F.o.height)||((a=new ZC.HL(p.A)).append(F.o),a.parse()),l=0,o=0,null!==ZC._n_(F.o.width)&&(l=a.I),null!==ZC._n_(F.o.height)&&(o=a.F),0===l&&(l=ZC.BQ(20,Z.AC/10)),0===o&&(o=ZC.BQ(16,h.AC/10)),(r=new ZC.DT(p.A)).K=p.K+"-arrow-entry",r.copy(p),r.append(F.o),r.parse(),n=[],1===p.A.OR.length?A=p.iY+h.AC/2:(C=h.AC/(p.A.OR.length+1),A=p.iY+C+i*C),Z.AW?(s=p.iX+Z.AC+l-d-g/2+(v+B)/4-_/2+2,n.push([s,A-2*o/6],[s-2*l/3,A-o/6],[s-2*l/3,A-3*o/6],[s-l,A],[s-2*l/3,A+3*o/6],[s-2*l/3,A+o/6],[s,A+2*o/6],[s,A-2*o/6])):(s=p.iX+d-l+g/2-(v+B)/4+_/2-2,n.push([s,A-2*o/6],[s+2*l/3,A-o/6],[s+2*l/3,A-3*o/6],[s+l,A],[s+2*l/3,A+3*o/6],[s+2*l/3,A+o/6],[s,A+2*o/6],[s,A-2*o/6])),r.D=n,r.parse(),r.Z=p.A.CP("bl",1),r.C7=p.A.CP("bl",0),r.paint(),null!==ZC._n_(F.o.labels)&&null!==ZC._n_(F.o.labels[p.L])&&""!==F.o.labels[p.L]&&(c=F.o.labels[p.L],(u=new ZC.DN(p.A)).K=p.K+"-entry-label-"+i,u.GL=p.K+"-entry-label "+p.A.K+"-entry-label zc-entry-label",u.copy(p),u.o.text=c,u.append(F.o),null!==ZC._n_(F.o.label)&&u.append(F.o.label),u.Z=p.A.CP("fl",0),u.parse(),Z.AW?u.iX=s+2:u.iX=s-u.I-2,u.iY=A-u.F/2,u.paint(),u.EK()))}for(i=0,t=p.A.VI.length;i<t;i++){var x=p.A.VI[i];x&&null!==ZC._n_(x.o.values)&&null!==ZC._n_(x.o.values[p.L])&&(null===ZC._n_(x.o.width)&&null===ZC._n_(x.o.height)||((a=new ZC.HL(p.A)).append(x.o),a.parse()),l=0,o=0,null!==ZC._n_(x.o.width)&&(l=a.I),null!==ZC._n_(x.o.height)&&(o=a.F),0===l&&(l=ZC.BQ(20,Z.AC/10)),0===o&&(o=ZC.BQ(16,h.AC/10)),(r=new ZC.DT(p.A)).K=p.K+"-arrow-exit",r.copy(p),r.append(x.o),r.parse(),n=[],1===p.A.VI.length?A=p.iY+h.AC/2:(C=h.AC/(p.A.VI.length+1),A=p.iY+C+i*C),Z.AW?(s=p.iX+f+g/2-(v+B)/4+_/2-2,n.push([s,A-2*o/6],[s-2*l/3,A-o/6],[s-2*l/3,A-3*o/6],[s-l,A],[s-2*l/3,A+3*o/6],[s-2*l/3,A+o/6],[s,A+2*o/6],[s,A-2*o/6])):(s=p.iX+Z.AC-f-g/2+(v+B)/4-_/2+2,n.push([s,A-2*o/6],[s+2*l/3,A-o/6],[s+2*l/3,A-3*o/6],[s+l,A],[s+2*l/3,A+3*o/6],[s+2*l/3,A+o/6],[s,A+2*o/6],[s,A-2*o/6])),r.D=n,r.parse(),r.Z=p.A.CP("bl",1),r.C7=p.A.CP("bl",0),r.paint(),null!==ZC._n_(x.o.labels)&&null!==ZC._n_(x.o.labels[p.L])&&""!==x.o.labels[p.L]&&(c=x.o.labels[p.L],(u=new ZC.DN(p.A)).K=p.K+"-exit-label-"+i,u.GL=p.K+"-exit-label "+p.A.K+"-exit-label zc-exit-label",u.copy(p),u.o.text=c,u.append(x.o),null!==ZC._n_(x.o.label)&&u.append(x.o.label),u.parse(),u.Z=p.A.CP("fl",0),Z.AW?u.iX=s-l-u.I-2:u.iX=s+l+2,u.iY=A-u.F/2,u.paint(),u.EK()))}p.A.U&&p.GW()},AC8:function(e){var i,t=this,n=t.A.B1,a=t.A.CM;null!==ZC._n_(e.o.placement)&&(i=e.o.placement);var l=t.iX+n.AC/2-e.I/2,o=t.iY+a.AC/2-e.F/2,r=t.E["entry-exit"],s=(r[0]+r[1])/2;switch(i){case"in":case"auto":break;case"top":o=t.iY+5;break;case"bottom":o=t.iY+a.AC-e.F-5;break;case"left":l=t.iX+n.AC/2-s/2+5;break;case"left-out":l=t.iX+n.AC/2-s/2-e.I-5;break;case"right":l=t.iX+n.AC/2+s/2-e.I-5;break;case"right-out":l=t.iX+n.AC/2+s/2+5}return null!==ZC._n_(e.o.x)&&(l=e.iX),null!==ZC._n_(e.o.y)&&(o=e.iY),[ZC._i_(l),ZC._i_(o)]},A0W:function(){var e=this;if(!ZC.move&&e.A.IE&&e.A.AN){e.b();var i=new ZC.DT(e.A);i.K=e.K+"-trapeze-hover",i.Z=ZC.AK(e.C.K+"-hover-c"),i.D=e.E.points,i.parse(),i.B7=e.A.BP[1],i.BW=e.A.BP[1],i.A0=e.A.BP[2],i.AE=e.A.BP[3],i.append(e.A.IE.o),i.parse(),i.J2=function(i){return e.J2(i)},i.DE()&&i.parse(),i.AN&&i.paint()}}}),ZC.A5U=ZC.LG.CA({setup:function(){var e=this,i=e.A.B1,t=e.A.CM,n=[i.W,i.A1,t.W,t.A1];e.JO!==n&&(i.AW?e.iY=i.iY+i.AB+e.L*i.AC:e.iY=i.iY+i.F-i.AB-(e.L+1)*i.AC,t.AW?e.iX=t.iX+t.I-t.AB-(e.A.L+1)*t.AC:e.iX=t.iX+t.AB+e.A.L*t.AC,e.JO=n),e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},JV:function(e,i,t,n){var a,l,o=this,r=ZC._f_(o.A.A.F8["%pstack-"+o.L+"-0-sum"]||"0"),s=o.A.MP();if(ZC._cp_(i,s),o.CV=[],o.A.L>0&&o.A.A.A4[o.A.L-1]&&o.A.A.A4[o.A.L-1].S[o.L]?l=""+(a=100*o.AD/o.A.A.A4[o.A.L-1].S[o.L].AD):(a=100,l="100"),null!==ZC._n_(s.decimals)&&(l=a.toFixed(ZC.BQ(0,ZC._i_(s.decimals)))),o.CV.push(["%output-percent-value",l]),r>0){var A=100*o.AD/r,C=""+A;null!==ZC._n_(s.decimals)&&(C=A.toFixed(ZC.BQ(0,ZC._i_(s.decimals)))),o.CV.push(["%node-percent-value",C]),o.CV.push(["%npv",C])}return e=o.b(e,i,t,n)},AC8:function(e){var i,t=this,n=t.A.B1,a=t.A.CM;null!==ZC._n_(e.o.placement)&&(i=e.o.placement);var l=t.iX+a.AC/2-e.I/2,o=t.iY+n.AC/2-e.F/2,r=t.E["entry-exit"],s=(r[0]+r[1])/2;switch(i){case"in":case"auto":break;case"top":l=t.iX+a.AC-e.I-5;break;case"bottom":l=t.iX+5;break;case"left":o=t.iY+n.AC/2-s/2+5;break;case"left-out":o=t.iY+n.AC/2-s/2-e.F-5;break;case"right":o=t.iY+n.AC/2+s/2-e.F-5;break;case"right-out":o=t.iY+n.AC/2+s/2+5}return null!==ZC._n_(e.o.x)&&(l=e.iX),null!==ZC._n_(e.o.y)&&(o=e.iY),[ZC._i_(l),ZC._i_(o)]},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c,u,p=this;p.b();var Z=p.A.B1,h=p.A.CM;p.setup(),"static"===p.A.A2I?(p.C.AY.SC[p.L],e=p.C.AY.A7K[p.L]):(p.C.AY.B3,e=p.C.AY.BJ);var d=p.A.KZ;d<=1&&(d*=Z.AC);var f=p.A.O9;f<=1&&(f*=Z.AC);var _=p.A.LZ;_<=1&&(_*=Z.AC);var g=Z.AC-d-f-_,v=_+g*(p.AD/e),b=0;p.A.L+1<p.A.A.A4.length&&p.A.A.A4[p.A.L+1].S[p.L]&&(b=p.A.A.A4[p.A.L+1].S[p.L].AD);var B=_+g*(b/e);p.E["entry-exit"]=[v,B];var m=p.iY+(Z.AW?d:f)+g/2+_/2;if(o=[],h.AW?o.push([p.iX+h.AC,m-v/2],[p.iX+h.AC,m+v/2],[p.iX,m+B/2],[p.iX,m-B/2],[p.iX+h.AC,m-v/2]):o.push([p.iX,m-v/2],[p.iX,m+v/2],[p.iX+h.AC,m+B/2],[p.iX+h.AC,m-B/2],[p.iX,m-v/2]),p.E.points=o,p.AN){var E=new ZC.DT(p.A);E.K=p.K+"-trapeze",E.copy(p),E.D=o,E.parse(),E.Z=p.A.CP("bl",1),E.C7=p.A.CP("bl",0),E.paint();var D=E.FF(),K=p.C.K+"-node-area "+p.C.K+"-plotset-plot-"+p.A.L+"-node-area zc-node-area";p.A.A.HE.push(ZC.Q.G0("poly",p.A.EA,p.A.IV)+'class="'+K+'" id="'+p.K+'" coords="'+D+'" />')}for(i=0,t=p.A.OR.length;i<t;i++){var F=p.A.OR[i];F&&null!==ZC._n_(F.o.values)&&null!==ZC._n_(F.o.values[p.L])&&(null===ZC._n_(F.o.width)&&null===ZC._n_(F.o.height)||((l=new ZC.HL(p.A)).append(F.o),l.parse()),n=0,a=0,null!==ZC._n_(F.o.width)&&(n=l.I),null!==ZC._n_(F.o.height)&&(a=l.F),0===a&&(a=ZC.BQ(20,Z.AC/10)),0===n&&(n=ZC.BQ(16,h.AC/10)),(r=new ZC.DT(p.A)).K=p.K+"-arrow-entry",r.copy(p),r.append(F.o),r.parse(),o=[],1===p.A.OR.length?s=p.iX+h.AC/2:(C=h.AC/(p.A.OR.length+1),s=p.iX+C+i*C),Z.AW?(A=p.iY+d-a+g/2-(v+B)/4+_/2-2,o.push([s-2*n/6,A],[s+2*n/6,A],[s+n/6,A+2*a/3],[s+3*n/6,A+2*a/3],[s,A+a],[s-3*n/6,A+2*a/3],[s-n/6,A+2*a/3])):(A=p.iY+Z.AC+a-d-g/2+(v+B)/4-_/2+2,o.push([s-2*n/6,A],[s+2*n/6,A],[s+n/6,A-2*a/3],[s+3*n/6,A-2*a/3],[s,A-a],[s-3*n/6,A-2*a/3],[s-n/6,A-2*a/3])),r.D=o,r.parse(),r.Z=p.A.CP("bl",1),r.C7=p.A.CP("bl",0),r.paint(),null!==ZC._n_(F.o.labels)&&null!==ZC._n_(F.o.labels[p.L])&&""!==F.o.labels[p.L]&&(c=F.o.labels[p.L],(u=new ZC.DN(p.A)).K=p.K+"-entry-label-"+i,u.GL=p.K+"-entry-label "+p.A.K+"-entry-label zc-entry-label",u.copy(p),u.o.text=c,u.append(F.o),null!==ZC._n_(F.o.label)&&u.append(F.o.label),u.AM=c,u.Z=p.A.CP("fl",0),u.parse(),u.iX=s-u.I/2,Z.AW?u.iY=A-u.F-2:u.iY=A+2,u.paint(),u.EK()))}for(i=0,t=p.A.VI.length;i<t;i++){var x=p.A.VI[i];x&&null!==ZC._n_(x.o.values)&&null!==ZC._n_(x.o.values[p.L])&&(null===ZC._n_(x.o.width)&&null===ZC._n_(x.o.height)||((l=new ZC.HL(p.A)).append(x.o),l.parse()),n=0,a=0,null!==ZC._n_(x.o.width)&&(n=l.I),null!==ZC._n_(x.o.height)&&(a=l.F),0===a&&(a=ZC.BQ(20,Z.AC/10)),0===n&&(n=ZC.BQ(16,h.AC/10)),(r=new ZC.DT(p.A)).K=p.K+"-arrow-exit",r.copy(p),r.append(x.o),r.parse(),o=[],1===p.A.OR.length?s=p.iX+h.AC/2:(C=h.AC/(p.A.OR.length+1),s=p.iX+C+i*C),Z.AW?(A=p.iY+d+g/2+(v+B)/4+_/2+2,o.push([s-2*n/6,A],[s+2*n/6,A],[s+n/6,A+2*a/3],[s+3*n/6,A+2*a/3],[s,A+a],[s-3*n/6,A+2*a/3],[s-n/6,A+2*a/3])):(A=p.iY+Z.AC-d-g/2-(v+B)/4-_/2-2,o.push([s-2*n/6,A],[s+2*n/6,A],[s+n/6,A-2*a/3],[s+3*n/6,A-2*a/3],[s,A-a],[s-3*n/6,A-2*a/3],[s-n/6,A-2*a/3])),r.D=o,r.parse(),r.Z=p.A.CP("bl",1),r.C7=p.A.CP("bl",0),r.paint(),null!==ZC._n_(x.o.labels)&&null!==ZC._n_(x.o.labels[p.L])&&""!==x.o.labels[p.L]&&(c=x.o.labels[p.L],(u=new ZC.DN(p.A)).K=p.K+"-exit-label-"+i,u.GL=p.K+"-exit-label "+p.A.K+"-exit-label zc-exit-label",u.copy(p),u.o.text=c,u.append(x.o),null!==ZC._n_(x.o.label)&&u.append(x.o.label),u.AM=c,u.Z=p.A.CP("fl",0),u.parse(),u.iX=s-u.I/2,Z.AW?u.iY=A+a+2:u.iY=A-a-u.F-2,u.paint(),u.EK()))}p.A.U&&p.GW()},A0W:function(){var e=this;if(!ZC.move&&e.A.IE&&e.A.AN){e.b();var i=new ZC.DT(e.A);i.K=e.K+"-trapeze-hover",i.Z=ZC.AK(e.C.K+"-hover-c"),i.D=e.E.points,i.parse(),i.B7=e.A.BP[1],i.BW=e.A.BP[1],i.A0=e.A.BP[2],i.AE=e.A.BP[3],i.append(e.A.IE.o),i.parse(),i.J2=function(i){return e.J2(i)},i.DE()&&i.parse(),i.AN&&i.paint()}}}),ZC.A7B=ZC.LG.CA({$i:function(e){this.b(e),this.J0=null},setup:function(){var e=this,i=e.A.B1,t=e.A.CM,n=[i.W,i.A1,t.W,t.A1];if(e.JO!==n&&(null!==e.BT?e.iX=i.AT(e.BT):e.iX=i.IB(e.L),e.iY=t.AT(e.AD),e.E.XF=t.AT(e.AD),e.E.A9R=t.AT(e.DP[0]),e.E.AAV=t.AT(e.DP[1]),e.E.VC=t.AT(e.DP[2]),e.JO=n),(!e.I2||e.A.I3&&e.A.MV.size<3)&&(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.J0=new ZC.DN(e.A),e.J0.copy(e),e.DP[2]<e.AD&&(e.J0.A0=e.J0.AE=e.C2,e.J0.BW=e.B7),e.DP[2]<e.AD?(e.A.o["trend-down"]&&(e.J0.append(e.A.o["trend-down"]),e.J0.parse()),e.A.MV.down||(e.A.MV.down=new ZC.DN(e.A),e.A.MV.down.copy(e.J0),e.A.MV.size++)):e.DP[2]>e.AD?(e.A.o["trend-up"]&&(e.J0.append(e.A.o["trend-up"]),e.J0.parse()),e.A.MV.up||(e.A.MV.up=new ZC.DN(e.A),e.A.MV.up.copy(e.J0),e.A.MV.size++)):(e.A.o["trend-equal"]&&(e.J0.append(e.A.o["trend-equal"]),e.J0.parse()),e.A.MV.equal||(e.A.MV.equal=new ZC.DN(e.A),e.A.MV.equal.copy(e.J0),e.A.MV.size++)),e.I2=!0),e.A.I3){e.DP[2]<e.AD?e.J0=e.A.MV.down:e.DP[2]>e.AD?e.J0=e.A.MV.up:e.J0=e.A.MV.equal;var a=ZC.CY(e.E.XF,e.E.VC),l=ZC.BQ(e.E.XF,e.E.VC)-ZC.CY(e.E.XF,e.E.VC);l<2&&(l=2),e.E.A7M=a+l/2}},JV:function(e,i,t,n){var a=this,l=a.A.MP();function o(e){return ZC.AP.G2(e,l)}return ZC._cp_(i,l),a.CV=[["%node-value-stock-open",o(a.AD)],["%open",o(a.AD)],["%v0",o(a.AD)],["%node-value-stock-high",o(a.DP[0])],["%high",o(a.DP[0])],["%v1",o(a.DP[0])],["%node-value-stock-low",o(a.DP[1])],["%low",o(a.DP[1])],["%v2",o(a.DP[1])],["%node-value-stock-close",o(a.DP[2])],["%close",o(a.DP[2])],["%v3",o(a.DP[2])]],e=a.b(e,i,t,n)},A96:function(){var e,i,t=this;if(t.DP=[],t.o.value instanceof Array&&5===t.o.value.length)t.BT=ZC._f_(t.o.value[0]),null!==t.BT&&(null!==ZC._n_(t.A.K2[t.BT])&&-1!==ZC.AV(t.A.K2[t.BT],t.L)||t.A.V4(t.BT,t.L)),i=[t.o.value[1],t.o.value[2],t.o.value[3],t.o.value[4]];else if(t.o.value[1]instanceof Array){if("string"==typeof t.o.value[0]){var n=ZC.AV(t.A.B1.IQ,t.o.value[0]);-1!==n?t.BT=n:(t.A.B1.IQ.push(t.o.value[0]),t.BT=t.A.B1.IQ.length-1)}else t.BT=ZC._f_(t.o.value[0]);null!==t.BT&&(null!==ZC._n_(t.A.K2[t.BT])&&-1!==ZC.AV(t.A.K2[t.BT],t.L)||t.A.V4(t.BT,t.L)),i=t.o.value[1]}else i=t.o.value;t.CK=i.join(" "),t.AD=ZC._f_(i[0]),null!==ZC._n_(e=i[1])&&t.DP.push(ZC._f_(e)),null!==ZC._n_(e=i[2])&&t.DP.push(ZC._f_(e)),null!==ZC._n_(e=i[3])&&t.DP.push(ZC._f_(e))},ABF:function(){var e=this,i={};return e.DP[2]<e.AD?i["background-color"]=e.J0.B7:i["background-color"]=e.J0.A0,i.color=e.J0.C2,i},Y4:function(){var e=this,i={};return e.DP[2]<e.AD?i["background-color"]=e.J0.B7:i["background-color"]=e.J0.A0,i["border-color"]=i["background-color"],i.color=e.J0.C2,i},A8E:function(){return this.Y4()},paint:function(){var e,i=this;i.b();var t=i.A.B1;i.setup();for(var n=t.AC*i.A.Y,a=i.A.L,l=0,o=0;o<i.A.A.K3.stock.length;o++)l++,-1!==ZC.AV(i.A.A.K3[i.A.AF][o],i.A.L)&&(a=o);var r=i.A.CF;r<=1&&(r*=n);var s=i.A.CT;s<=1&&(s*=n);var A=n-r-s,C=i.A.F4;C<=1&&(C*=A),A<1&&(A=.8*n,r=.1*n,s=.1*n);var c=A,u=i.A.EZ;0!==u&&(C=0),l>1&&(u>1?c=(A-(l-1)*C+(l-1)*u)/l:u*=c=(A-(l-1)*C)/(l-(l-1)*u)),c=ZC._l_(c,1,A);var p=i.iX-n/2+r+a*(c+C)-a*u;p=ZC._l_(p,i.iX-n/2+r,i.iX+n/2-s);var Z,h=c,d=ZC.CY(i.E.XF,i.E.VC),f=ZC.BQ(i.E.XF,i.E.VC)-ZC.CY(i.E.XF,i.E.VC);if(f<2&&(f=2),r+s===0&&(p-=.5,h+=1),i.I=h,i.F=f,i.iX=p,i.E.A7M=d+f/2,i.setNodeData({x:p,y:d,w:h,h:f}),i.AN){Z=ZC.Q.EB(i.H.usc()?i.H.K+"-main-c":i.H.K9?i.C.K+"-plots-bl-c":i.C.K+"-plot-"+i.A.L+"-bl-1-c",i.H.AA);var _,g=i.iX+i.I/2;i.DP[2]<i.AD&&(e=i.A.o["trend-down"])?(i.E["selected-state"]=e["selected-state"],i.E["background-state"]=e["background-state"]):i.DP[2]>i.AD&&(e=i.A.o["trend-up"])?(i.E["selected-state"]=e["selected-state"],i.E["background-state"]=e["background-state"]):i.DP[2]===i.AD&&(e=i.A.o["trend-equal"])&&(i.E["selected-state"]=e["selected-state"],i.E["background-state"]=e["background-state"]);var v=i.A.ID(i,i.J0);switch(i.A.CW){default:var b,B;(_=[]).push([g,i.E.A9R],[g,ZC.CY(i.E.XF,i.E.VC)],null,[g,i.E.AAV],[g,ZC.BQ(i.E.XF,i.E.VC)]),ZC.CR.paint(Z,v,_),B=i.DP[2]<i.AD?i.A.ABS:i.DP[2]>i.AD?i.A.ACP:i.A.AB8,0!==i.A.E7.length||void 0===B||i.N.o.override||i.C.KI?(b=new ZC.HL(i.A)).copy(v):b=B,i.H3(b),b.Z=i.A.CP("bl",1),b.C7=i.A.CP("bl",0),b.K=i.K,b.iX=p,b.iY=d,b.I=i.I,b.F=i.F,b.paint(),0!==i.A.E7.length||void 0!==B||i.N.o.override||i.C.KI||(i.DP[2]<i.AD?i.A.ABS=b:i.DP[2]>i.AD?i.A.ACP=b:i.A.AB8=b);break;case"whisker":case"ohlc":_=[];var m=Math.max(i.I/4,4);_.push([g,i.E.A9R],[g,i.E.AAV],null,[g-m,i.E.XF],[g,i.E.XF],null,[g+m,i.E.VC],[g,i.E.VC]),i.H3(v),ZC.CR.paint(Z,v,_)}if(i.A.FY){var E=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area";i.A.A.HE.push(ZC.Q.G0("rect",i.A.EA,i.A.IV)+'class="'+E+'" id="'+i.K+'" coords="'+ZC._i_(p+ZC.MAPTX)+","+ZC._i_(i.E.A9R+ZC.MAPTX)+","+ZC._i_(p+h+ZC.MAPTX)+","+ZC._i_(i.E.AAV+ZC.MAPTX)+'" />')}i.A.U&&i.A.U.AN&&i.GW()}},A0W:function(){var e=this;if(!ZC.move&&e.A.IE&&e.A.AN)switch(e.b(),e.A.CW){case"candlestick":var i=new ZC.HL(e.A);i.K=e.K+"-hover",i.Z=ZC.AK(e.C.K+"-hover-c"),i.C2=e.A.BP[0],i.AE=e.A.BP[3],i.B7=e.A.BP[1],i.BW=e.A.BP[1],i.A0=e.A.BP[2],i.append(e.A.IE.o),i.PU=!0,i.parse(),i.J2=function(i){return e.J2(i)},i.DE()&&i.parse(),e.DP[2]<e.AD&&(i.A0=i.AE=i.C2,i.BW=i.B7),e.DP[2]<e.AD&&e.A.o["trend-down"]?(i.append(e.A.o["trend-down"]),i.append(e.A.o["hover-state"]),e.A.o["trend-down"]["hover-state"]&&i.append(e.A.o["trend-down"]["hover-state"]),i.parse()):e.DP[2]>e.AD&&e.A.o["trend-up"]?(i.append(e.A.o["trend-up"]),i.append(e.A.o["hover-state"]),e.A.o["trend-up"]["hover-state"]&&i.append(e.A.o["trend-up"]["hover-state"]),i.parse()):e.DP[2]===e.AD&&e.A.o["trend-equal"]&&(i.append(e.A.o["trend-equal"]),i.append(e.A.o["hover-state"]),e.A.o["trend-equal"]["hover-state"]&&i.append(e.A.o["trend-equal"]["hover-state"]),i.parse()),i.iX=e.getNodeData("x"),i.iY=e.getNodeData("y"),i.I=e.getNodeData("w"),i.F=e.getNodeData("h");var t=e.C.P;i.iY<t.iY&&(i.F=i.F-(t.iY-i.iY),i.iY=t.iY),i.iY+i.F>t.iY+t.F&&(i.F=t.iY+t.F-i.iY),i.AN&&i.paint()}}}),ZC.A7C=ZC.LG.CA({setup:function(){var e=this,i=e.C.BL(e.A.BU("k")[0]),t=e.C.BL(e.A.BU("v")[0]),n=e.L%i.H0,a=Math.floor(e.L/i.H0),l=t.EI/(t.BJ-t.B3);e.iX=i.iX+n*i.GK+i.GK/2,e.iY=i.iY+a*i.GF+i.GF/2,e.E.angle=t.DH-t.EI/2+l*(e.AD-t.B3),t.AW&&(e.E.angle=t.DH+t.EI/2-l*(e.AD-t.B3)),e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0)},AC8:function(e){var i,t,n,a=e.I,l=e.F,o=this,r=o.C.BL(o.A.BU("k")[0]),s=ZC.CY(r.GK/2,r.GF/2)*r.JE,A=o.L%r.H0,C=Math.floor(o.L/r.H0),c=r.iX+A*r.GK+r.GK/2+r.BM,u=r.iY+C*r.GF+r.GF/2+r.BH;switch(e.o.placement){case"center":t=c-a/2+o.BM,n=u-l/2+o.BH;break;case"edge":t=(i=ZC.AQ.BN(c,u,s+e.DV,o.E.angle))[0]-a/2+o.BM,n=i[1]-l/2+o.BH;break;case"tip":t=(i=ZC.AQ.BN(c,u,o.E.size+e.DV,o.E.angle))[0]-a/2+o.BM,n=i[1]-l/2+o.BH;break;default:t=(i=ZC.AQ.BN(c,u,s/2+e.DV,o.E.angle))[0]-a/2+o.BM,n=i[1]-l/2+o.BH}return null!==ZC._n_(e.o.x)&&(t=e.iX),null!==ZC._n_(e.o.y)&&(n=e.iY),[ZC._i_(t),ZC._i_(n)]},ABF:function(){return{color:this.A0}},Y4:function(){return{"background-color":this.A0,"border-color":this.B7,color:this.C2}},paint:function(){var e,i=this;i.b(),i.setup(),i.CZ=!1;var t=i.C.BL(i.A.BU("k")[0]),n=ZC.CY(t.GK/2,t.GF/2)*t.JE,a=i.L%t.H0,l=Math.floor(i.L/t.H0),o=t.iX+a*t.GK+t.GK/2+t.BM,r=t.iY+l*t.GF+t.GF/2+t.BH,s=ZC.II(i.A.o.size||"0.9",!1);s>0&&s<=1&&(s*=n),i.E.size=s;var A=i.N=i.A.ID(i,i),C=new ZC.DT(i.A);function c(t){var a=[],l=i.A.HW;l[4]>-1&&l[4]<1&&(l[4]=ZC._i_(l[4]*n));var A=ZC.AQ.BN(o,r,l[4],t);if(l[0]>=0)for(e=-l[2];e<=180+l[2];e+=5)a.push(ZC.AQ.BN(A[0],A[1],l[0],t+270-e));else a.push(ZC.AQ.BN(A[0],A[1],ZC._a_(l[0]),t-90)),a.push(ZC.AQ.BN(A[0],A[1],ZC._a_(l[0]),t+90));if(0===l[1])a.push(ZC.AQ.BN(o,r,s>0?s:.9*n,t));else if(l[1]>0)for(A=ZC.AQ.BN(o,r,s>0?s:.9*n,t),e=-l[3];e<=180+l[3];e+=5)a.push(ZC.AQ.BN(A[0],A[1],l[1],t-270-e));else A=ZC.AQ.BN(o,r,(s>0?s:.9*n)+l[1],t),a.push(ZC.AQ.BN(A[0],A[1],ZC._a_(l[1]/(90/l[3])),t+90),ZC.AQ.BN(A[0],A[1],ZC._a_(l[1]),t+90),ZC.AQ.BN(o,r,s>0?s:.9*n,t),ZC.AQ.BN(A[0],A[1],ZC._a_(l[1]),t+270),ZC.AQ.BN(A[0],A[1],ZC._a_(l[1]/(90/l[3])),t+270));return a.push([a[0][0],a[0][1]]),a}function u(){var e=C.FF(),t=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area",n=ZC.Q.G0("poly",i.A.EA,i.A.IV)+'class="'+t+'" id="'+i.K+'" coords="'+e+'" />';i.A.A.HE.push(n)}C.copy(A),C.Z=i.A.CP("bl",1),C.C7=i.A.CP("bl",0),C.K=i.K+"-arrow";var p=i.C.BL(i.A.BU("v")[0]),Z=p.DH-p.EI/2,h=c(i.E.angle);if(i.E.points=h,C.DU="poly",C.D=h,C.parse(),C.J2=function(e){return i.J2(e)},C.DE()&&C.parse(),i.A.GG&&!i.C.HH){var d,f=C,_={},g=i.A.L7;for(d in f.C6=0,_.alpha=A.C6,2===g&&(f.A2J=Z,_.A2J=i.E.angle),i.A.FV)f[ZC.E4.GN[ZC.EE(d)]]=i.A.FV[d],_[ZC.EE(d)]=A[ZC.E4.GN[ZC.EE(d)]];if(i.C.EN||(i.C.EN={}),null!==ZC._n_(i.C.EN[i.A.L+"-"+i.L]))for(d in i.C.EN[i.A.L+"-"+i.L]){var v=ZC.E4.GN[ZC.EE(d)];null===ZC._n_(v)&&(v=d),f[v]=i.C.EN[i.A.L+"-"+i.L][d]}i.C.EN[i.A.L+"-"+i.L]={},ZC._cp_(_,i.C.EN[i.A.L+"-"+i.L]);var b=new ZC.E4(f,_,i.A.JF,i.A.L6,ZC.E4.RI[i.A.L8],function(){u()});b.AX=i,b.A0B=function(e,i){null!==ZC._n_(i.A2J)&&(e.D=c(i.A2J))},i.LM(b),i.A.U&&i.GW()}else C.paint(),i.A.U&&i.GW(),u()},A0W:function(e){var i=this;ZC.move||i.M5({layer:e,type:"shape",initcb:function(){this.copy(i),this.B7=i.A.BP[1],this.BW=i.A.BP[1],this.A0=i.A.BP[3],this.AE=i.A.BP[2],this.D=i.E.points,this.Z=this.C7=i.A.CP("bl",2)}})}}),ZC.A7E=ZC.LG.CA({$i:function(e){this.b(e);var i=this;i.CD=null,i.CJ=null,i.MM="min"},JV:function(e,i,t,n){var a=this;return a.CV=[["%range-set",a.MM],["%node-min-value",a.CD],["%node-max-value",a.CJ]],e=a.b(e,i,t,n)},A96:function(){var e,i,t=this;t.o.value[1]instanceof Array?("string"==typeof t.o.value[0]?-1!==(i=ZC.AV(t.A.B1.IQ,t.o.value[0]))?t.BT=i:(t.A.B1.IQ.push(t.o.value[0]),t.BT=t.A.B1.IQ.length-1):t.BT=ZC._f_(t.o.value[0]),null!==t.BT&&(null!==ZC._n_(t.A.K2[t.BT])&&-1!==ZC.AV(t.A.K2[t.BT],t.L)||t.A.V4(t.BT,t.L)),e=t.o.value[1]):e=t.o.value,"string"==typeof e[0]?-1!==(i=ZC.AV(t.A.CM.JK,e[0]))?t.CD=i:(t.A.CM.JK.push(e[0]),t.CD=t.A.CM.JK.length-1):t.CD=ZC._f_(e[0]),t.DP.push(t.CD),"string"==typeof e[1]?-1!==(i=ZC.AV(t.A.CM.JK,e[1]))?t.CJ=i:(t.A.CM.JK.push(e[1]),t.CJ=t.A.CM.JK.length-1):t.CJ=ZC._f_(e[1]),t.CK=e.join(" "),t.AD=t.CJ},setup:function(){var e=this,i=e.A.O6,t=e.A.B1,n=e.A.CM,a=[t.W,t.A1,n.W,n.A1,e.MM];null===ZC._n_(e.AH)&&(e.AH=[]),e.JO!==a&&(i?(null!==e.BT?e.iY=t.AT(e.BT):e.iY=t.IB(e.L),e.iX=n.AT("min"===e.MM?e.CD:e.CJ)):(null!==e.BT?e.iX=t.AT(e.BT):e.iX=t.IB(e.L),e.iY=n.AT("min"===e.MM?e.CD:e.CJ)),e.JO=a),e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse()),e.E.NA=n.AT(e.CD),e.E.R5=n.AT(e.CJ),e.I2=!0},ABF:function(){return{color:this.B7}},Y4:function(){return{"background-color":this.B7,"border-color":this.B7,color:this.C2}},paint:function(){var e,i=this;i.b();var t=i.A.B1,n=i.A.QE,a=i.A.O6,l=i.A.S;i.setup(),null!==ZC._n_(i.A.o[i.MM+"-line"])&&(i.append(i.A.o[i.MM+"-line"]),i.parse()),i.CZ=!1,i.C7=i.A.CP("bl",1);var o,r,s,A,C,c,u,p,Z,h,d,f,_,g=[],v=[];switch(i.A.CW){default:var b=!0;!t.EF&&i.L<=t.W&&(b=!1),l[i.L-i.A.Y]||(b=!1),b&&(l[i.L-i.A.Y].MM=i.MM,l[i.L-i.A.Y].setup(),a?(r=[i.E.NA,i.iY],s=[l[i.L-i.A.Y].E.NA,l[i.L-i.A.Y].iY],A=[i.E.R5,i.iY],C=[l[i.L-i.A.Y].E.R5,l[i.L-i.A.Y].iY],c=ZC.AQ.A4K(r,s,A,C),o=ZC.DS(c[1],l[i.L-i.A.Y].iY,i.iY)?c:ZC.AQ.JT(l[i.L-i.A.Y].iX,l[i.L-i.A.Y].iY,l[i.L].iX,l[i.L].iY),v.push([o[0],ZC._i_(o[1])]),g.push([o[0],o[1]])):(r=[i.iX,i.E.NA],s=[l[i.L-i.A.Y].iX,l[i.L-i.A.Y].E.NA],A=[i.iX,i.E.R5],C=[l[i.L-i.A.Y].iX,l[i.L-i.A.Y].E.R5],c=ZC.AQ.A4K(r,s,A,C),o=ZC.DS(c[0],l[i.L-i.A.Y].iX,i.iX)?c:ZC.AQ.JT(l[i.L-i.A.Y].iX,l[i.L-i.A.Y].iY,l[i.L].iX,l[i.L].iY),v.push([ZC._i_(o[0]),o[1]]),g.push([o[0],o[1]]))),a?v.push([i.iX,ZC._i_(i.iY)]):v.push([ZC._i_(i.iX),i.iY]),g.push([i.iX,i.iY]);var B=!0;!t.EF&&i.L>=t.A1&&(B=!1),l[i.L+i.A.Y]||(B=!1),B&&(l[i.L+i.A.Y].MM=i.MM,l[i.L+i.A.Y].setup(),a?(r=[i.E.NA,i.iY],s=[l[i.L+i.A.Y].E.NA,l[i.L+i.A.Y].iY],A=[i.E.R5,i.iY],C=[l[i.L+i.A.Y].E.R5,l[i.L+i.A.Y].iY],c=ZC.AQ.A4K(r,s,A,C),o=ZC.DS(c[1],l[i.L+i.A.Y].iY,i.iY)?c:ZC.AQ.JT(l[i.L].iX,l[i.L].iY,l[i.L+i.A.Y].iX,l[i.L+i.A.Y].iY),v.push([o[0],ZC._i_(o[1])]),g.push([o[0],o[1]])):(r=[i.iX,i.E.NA],s=[l[i.L+i.A.Y].iX,l[i.L+i.A.Y].E.NA],A=[i.iX,i.E.R5],C=[l[i.L+i.A.Y].iX,l[i.L+i.A.Y].E.R5],c=ZC.AQ.A4K(r,s,A,C),o=ZC.DS(c[0],l[i.L+i.A.Y].iX,i.iX)?c:ZC.AQ.JT(l[i.L].iX,l[i.L].iY,l[i.L+i.A.Y].iX,l[i.L+i.A.Y].iY),v.push([ZC._i_(o[0]),o[1]]),g.push([o[0],o[1]])));break;case"spline":if("undefined"==typeof i.E["intersect.index"]&&(i.E["intersect.index"]=-1,l[i.L+i.A.Y])){var m=[],E=[],D=[];for(u=-1;u<3;u++)l[i.L+u]?(l[i.L+u].setup(),m.push(l[i.L+u].E.NA),D.push(l[i.L+u].E.R5),a?E.push(l[i.L+u].iY):E.push(l[i.L+u].iX)):(m.push(i.E.NA),D.push(i.E.R5),a?E.push(i.iY):E.push(i.iX));Z=ZC._a_(E[2]-E[1]);var K=ZC.AQ.Y9(i.A.Q9,m,ZC._i_(Z)),F=ZC.AQ.Y9(i.A.Q9,D,ZC._i_(Z));if(l[i.L+i.A.Y].CD===l[i.L+i.A.Y].CJ)i.E["intersect.index"]=K.length;else{var x=K[0][1]-F[0][1];for(u=1,p=K.length;u<p;u++)if(Math.round(x*(K[u][1]-F[u][1]),2)<=0){i.E["intersect.index"]=u+1;break}}i.E["spline.points.min"]=K,i.E["spline.points.max"]=F,i.E["spline.xdiff"]=Z}Z=i.E["spline.xdiff"]||t.AC,null===ZC._n_(i.A.ZR)&&(i.A.ZR={}),null===ZC._n_(i.A.S4)&&(i.A.S4={});var I=[],y=[];if("min"===i.MM){if(null!==ZC._n_(e=i.A.S4.max))for(u=e.length-1;u>=0;u--)i.AH.push(i.A.S4.max[u]);if(null!==ZC._n_(e=i.A.S4.min))for(u=0,p=e.length;u<p;u++)i.AH.push(e[u])}if(null!==ZC._n_(e=i.A.ZR[i.MM]))for(g=[],u=0,p=e.length;u<p;u++)g.push(e[u]);if(l[i.L+i.A.Y]&&i.L<t.A1){"min"===i.MM?h=i.E["spline.points.min"]:"max"===i.MM&&(h=i.E["spline.points.max"]),d=-1===i.E["intersect.index"]?ZC._i_(h.length/2):i.E["intersect.index"];var w=a?t.AW?1:-1:t.AW?-1:1;for(u=0;u<d;u++)a?(g.push([h[u][1],i.iY+w*h[u][0]*Z]),v.push([h[u][1],ZC._i_(i.iY+w*h[u][0]*Z)])):(g.push([i.iX+w*h[u][0]*Z,h[u][1]]),v.push([ZC._i_(i.iX+w*h[u][0]*Z),h[u][1]]));var Y=1===i.HX?ZC.CY(2,d):1;for(u=d-1,p=h.length;u<p;u++)a?I.push([h[u][1],i.iY+w*h[u][0]*Z]):I.push([i.iX+w*h[u][0]*Z,h[u][1]]);for(u=d-Y,p=h.length;u<p;u++)a?y.push([h[u][1],ZC._i_(i.iY+w*h[u][0]*Z)]):y.push([ZC._i_(i.iX+w*h[u][0]*Z),h[u][1]])}else g.push([l[i.L].iX,l[i.L].iY]),a?(I.push([l[i.L].iX,ZC._i_(l[i.L].iY)]),v.push([l[i.L].iX,ZC._i_(l[i.L].iY)]),y.push([l[i.L].iX,ZC._i_(l[i.L].iY)])):(I.push([ZC._i_(l[i.L].iX),l[i.L].iY]),v.push([ZC._i_(l[i.L].iX),l[i.L].iY]),y.push([ZC._i_(l[i.L].iX),l[i.L].iY]));i.A.ZR[i.MM]=I,i.A.S4[i.MM]=y}if("min"===i.MM)for(u=0,p=v.length;u<p;u++)i.AH.push(v[u]);else for(u=v.length-1;u>=0;u--)i.AH.push(v[u]);if("max"===i.MM){var X=new ZC.DT(i.A);X.K=i.K+"-area",X.Z=i.A.CP("bl",0),X.copy(i),X.AZ=0,X.AU=0,X.EX=0,X.G9=0,X.parse(),X.D=i.AH,X.C6=i.A.HX;var M=i.C.P;for(X.D1=[M.iX,M.iY,M.iX+M.I,M.iY+M.F],X.paint(),i.E.pointsarea=[],u=0,p=i.AH.length;u<p;u++)i.E.pointsarea.push(i.AH[u]);i.AH=[],i.A.FY&&(_=X.FF(),f=i.C.K+"-node-area "+i.C.K+"-plot-"+i.A.L+"-node-area zc-node-area",i.A.A.HE.push(ZC.Q.G0("poly",i.A.EA,i.A.IV)+'class="'+f+'" id="'+i.K+'--area" coords="'+_+'" />'))}"min"===i.MM?i.E.points=g:(i.E.points.push(null),i.E.points=i.E.points.concat(g));var L=new ZC.D0(i);L.copy(i),L.append(i.A.o[i.MM+"-line"]),L.parse(),ZC.CR.setup(n,L),ZC.CR.paint(n,L,g),"max"===i.MM&&i.paintPreview(i,i.E.points,i.E.pointsarea);if(a?ZC.DS(i.iY,t.iY-1,t.iY+t.F+1)&&ZC.DS(i.iX,t.iX-1,t.iX+t.I+1):ZC.DS(i.iX,t.iX-1,t.iX+t.I+1)&&ZC.DS(i.iY,t.iY-1,t.iY+t.F+1)){var H=new ZC.DT(i.A);H.K=i.K+"-marker-"+i.MM,H.Z=H.C7=i.A.CP("fl",0),H.iX=i.iX,H.iY=i.iY,H.B7=i.A.BP[3],H.BW=i.A.BP[3],H.A0=i.A.BP[2],H.AE=i.A.BP[2],H.append(i.A.A2.o),i.A.o[i.MM+"-marker"]&&H.append(i.A.o[i.MM+"-marker"]),H.parse(),H.J2=function(e){return i.J2(e)},H.DE()&&H.parse(),H.AN&&"none"!==H.AF&&(i.A.MS>t.A1-t.W&&H.paint(),i.E["marker.type"]=H.DU,f=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area",t.AW&&g.reverse(),i.A.FY&&(""!==(_=ZC.AQ.PR(ZC.AQ.Z0(i.E.points),4))?i.A.A.HE.push(ZC.Q.G0("poly",i.A.EA,i.A.IV)+'class="'+f+'" '+i.a11y()+' id="'+i.K+"--"+i.MM+'" coords="'+_+'" />'):i.A.A.HE.push(ZC.Q.G0("circle",i.A.EA,i.A.IV)+'class="'+f+'" '+i.a11y()+' id="'+i.K+"--"+i.MM+'" coords="'+ZC._i_(H.iX+ZC.MAPTX)+","+ZC._i_(H.iY+ZC.MAPTX)+","+ZC._i_(1.5*ZC.BQ(3,H.AI))+'" />'))),i.A.U&&i.A.U.AN&&i.GW()}},paintPreview:function(e,i,t){var n=this;if(n.C.B9&&n.C.B9.I2&&n.A.QN){var a,l=n.C.P,o=n.C.B9,r=n.A.mapPointsToPreview(t),s=new ZC.DT(n.A);s.copy(e),s.CZ=!0,s.L5=!0,s.AZ=0,s.AU=0,s.EX=0,s.G9=0,s.C6=n.A.HX,s.D1=[l.iX,l.iY,l.iX+l.I,l.iY+l.F],s.K=n.K+"-area-preview",s.Z=o.Z,s.D=r,s.paint();var A=n.A.mapPointsToPreview(i);n.A.WB?a=n.A.WB:(a=new ZC.D0(n),n.A.WB=a),a.copy(e);var C=ZC.Q.EB(o.Z,n.H.AA);a.AZ=1,ZC.CR.paint(C,a,A,null,3)}},A0W:function(){var e=this,i=e.A.O6;if(!ZC.move){var t=e.A.B1;if(e.A.GA&&e.A.AN){var n=ZC.Q.EB(e.C.K+"-hover-c",e.H.AA),a=new ZC.DT(e.A);if(a.K=e.K+"-area-hover",a.Z=ZC.AK(e.C.K+"-hover-c"),a.L5=!0,a.copy(e),a.append(e.A.IE.o),a.D=e.E.pointsarea,a.parse(),a.AN){a.C6=e.A.HX;var l=e.C.P;a.D1=[l.iX,l.iY,l.iX+l.I,l.iY+l.F],ZC.CR.setup(n,a),a.paint()}var o=ZC.Q.EB(e.C.K+"-hover-c",e.H.AA),r=new ZC.D0(e.A);r.K=e.K+"-line-hover",r.CZ=!1,r.B7=e.A.BP[3],r.append(e.A.IE.o),r.parse(),r.J2=function(i){return e.J2(i)},r.DE()&&r.parse(),r.AN&&(ZC.CR.setup(o,r),ZC.CR.paint(o,r,e.E.points))}if(e.A.MS>t.A1-t.W&&e.A.GA&&e.A.AN){e.b();var s=new ZC.DT(e.A);s.K=e.K+"-marker-max-hover",s.Z=ZC.AK(e.C.K+"-hover-c"),s.DU=e.E["marker.type"],i?(s.iY=e.iY,s.iX=e.E.R5):(s.iX=e.iX,s.iY=e.E.R5),s.B7=e.A.BP[3],s.BW=e.A.BP[3],s.A0=e.A.BP[2],s.AE=e.A.BP[2],s.append(e.A.GA.o),s.parse(),s.J2=function(i){return e.J2(i)},s.DE()&&s.parse(),s.AN&&"none"!==s.AF&&s.paint(),s.K=e.K+"-marker-min-hover",i?s.iX=e.E.NA:s.iY=e.E.NA,s.AN&&"none"!==s.AF&&s.paint()}}}}),ZC.A72=ZC.LG.CA({bCXY:!0,U:null,$i:function(e){this.b(e)},parse:function(){this.b()},AB2:function(){this.b();var e=this.C.E;e.update.npv=e.update["node-percent-value"]=this.JV("%npv")},JV:function(e,i,t,n){var a=this,l=a.A.MP();ZC._cp_(i,l),-1===e.indexOf("%npv")&&-1===e.indexOf("%node-percent-value")||null!==ZC._n_(l.decimals)&&-1!==l.decimals||(l.decimals=1);var o=0,r="0";if(a.A.A.KM[a.L]>0&&(r=""+(o=100*a.AD/a.A.A.KM[a.L])),a.A.A.A4.length>1&&a.A.L===a.A.A.A4.length-1){var s=0;if(null===ZC._n_(a.A.o.totals)){for(var A=0;A<a.A.A.A4.length-1;A++)if(a.A.A.A4[A].AN&&null!==ZC._n_(a.A.A.A4[A].S[a.L])){var C=0,c="0";a.A.A.KM[a.L]>0&&(c=""+(C=100*a.A.A.A4[A].S[a.L].AD/a.A.A.KM[a.L])),null!==ZC._n_(l.decimals)&&(c=C.toFixed(ZC.BQ(0,ZC._i_(l.decimals)))),s+=ZC._f_(c)}r=""+(o=Math.max(0,100-s))}}null!==ZC._n_(l.decimals)&&(r=o.toFixed(ZC.BQ(0,ZC._i_(l.decimals))));var u,p=ZC._f_(a.A.A.KM[a.L]||"0");return u=ZC.AP.G2(p,l,a.A),a.CV=[["%node-percent-value",r],["%npv",r],["%pie-total-value",u]],e=a.b(e,i,t,n)},UY:function(e){var i,t=this,n=(t.B4+t.BK)/2%360,a=0;null!==ZC._n_(i=e["offset-r"])&&(a=ZC._f_(ZC._p_(i))),a<1&&(a*=t.AI);var l=new ZC.CE(t.C,(t.CN+.5*(t.AI-t.CN)+t.DV+a)*ZC.EH(n),(t.CN+.5*(t.AI-t.CN)+t.DV+a)*ZC.EP(n),0).ED;return[l[0],l[1],{reference:t,center:!0}]},setup:function(){var e=this,i=e.C.BL(e.A.BU("k")[0]),t=e.L%i.H0,n=Math.floor(e.L/i.H0);e.iX=i.iX+t*i.GK+i.GK/2+i.BM,e.iY=i.iY+n*i.GF+i.GF/2+i.BH,e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(),e.I2=!0)},ABF:function(e){var i={},t="out";return null!==ZC._n_(e.o.placement)&&(t=e.o.placement),i.color="out"===t?this.A0:this.C2,i},AC8:function(e){var i,t=this,n="out";null!==ZC._n_(i=e.o.placement)&&(n=i);var a,l,o,r,s,A=e.I,C=e.F,c=(t.B4+t.BK)/2%360,u=c;if("out"===n){c=u=t.A.A.YE["n"+t.L][t.A.L];var p=function(i,n){n<0&&(n=360+n),n%=360;var a=ZC.AQ.BN(t.iX,t.iY,i+t.DV+e.DV+20,n),l=t.C.F0["x-angle"];l>45&&t.A.A.A4.length>10&&(t.C.F0["x-angle"]=45+(l-45)/3),s=new ZC.CE(t.C,a[0]-ZC.AO.E2,a[1]-ZC.AO.E3,0),t.C.F0["x-angle"]=l,a[0]=s.ED[0],a[1]=s.ED[1];var o=a[0]+e.BM-A/2,r=a[1]+e.BH-C/2;return n>=0&&n<=90||n>=270&&n<=360?o+=A/2+10:o-=A/2+10,[o,r]},Z=p(t.AI,u);a=Z[0],l=Z[1],t.U=e;var h={x:a,y:l,width:A,height:C},d=zingchart.DEV.SPREADTYPE;r=!0;for(var f=0,_=0,g=-1,v=0,b=0;r&&b<1024;){r=!1;for(var B=0,m=t.A.A.TS.length;B<m;B++)o=t.A.A.TS[B],(ZC.AQ.XM(h,o,t.A.A.A4.length>10?-8:-2)||h.x+e.I>t.C.P.iX+t.C.P.I||h.x<t.C.P.iX||h.y+e.F>t.C.P.iY+t.C.P.F||h.y<t.C.P.iY)&&(r=!0,0===d?(f+=.4,g*=-1):1===d&&(_+=1),Z=p(t.AI+_,u+f*g),h.x=Z[0],h.y=Z[1],b++,++v>100&&(v=0,0===d?(f=0,_+=4):1===d&&(_=0,f+=1,g*=-1)))}a=h.x,l=h.y,c=u+f,o={text:t.A.AM,x:h.x,y:h.y,width:A,height:C,plotindex:t.A.L,nodeindex:t.L},t.A.A.TS.push(o)}else if("in"===n){var E=t.CN<30?.65:.5,D=ZC.AQ.BN(t.iX,t.iY,t.CN+E*(t.AI-t.CN)+t.DV+e.DV,c);s=new ZC.CE(t.C,D[0]-ZC.AO.E2,D[1]-ZC.AO.E3,0),D[0]=s.ED[0],D[1]=s.ED[1],a=D[0]+e.BM-A/2,l=D[1]+e.BH-C/2}else"center"===n&&(a=(s=new ZC.CE(t.C,t.iX-ZC.AO.E2,t.iY-ZC.AO.E3,0)).ED[0]+e.BM-A/2,l=s.ED[1]+e.BH-C/2);return r&&(a=-9999,l=-9999,e.AN=!1),null!==ZC._n_(e.o.x)&&(a=e.iX),null!==ZC._n_(e.o.y)&&(l=e.iY),a>=-2&&(a=ZC._a_(a)),l>=-2&&(l=ZC._a_(l)),[ZC._i_(a),ZC._i_(l),c]},GW:function(e,i){var t,n=this,a=n.b(e,i);if(e)return a;if(n.AN&&a.AN&&null!==ZC._n_(a.AM)&&""!==a.AM){var l="out";if(null!==ZC._n_(a.o.placement)&&(l=a.o.placement),"out"===l){var o=!0;if(null!==ZC._n_(t=a.o.connected)&&(o=ZC._b_(t)),o){var r=new ZC.DT(n.A);r.Z=r.C7=n.A.CP("bl",0),r.append(n.A.C3.o),r.B7=n.A0,r.DU="line",r.D=[];var s=a.E.positioninfo,A=(n.B4+n.BK)/2%360,C=0;A>=0&&A<=180&&(C=n.E.thickness/2);var c=ZC.AQ.BN(n.iX,n.iY,n.AI+n.DV+a.DV,A);(c=new ZC.CE(n.C,c[0]-ZC.AO.E2,c[1]-ZC.AO.E3,C).ED)[0]+=n.BM,c[1]+=n.BH,r.D.push(c);var u=ZC.AQ.BN(n.iX,n.iY,n.AI+n.DV+a.DV+20,A);(u=new ZC.CE(n.C,u[0]-ZC.AO.E2,u[1]-ZC.AO.E3,C).ED)[0]+=n.BM,u[1]+=n.BH,a.iX>=n.iX?r.D.push([u[0],u[1],s[0],s[1]+a.F/2]):r.D.push([u[0],u[1],s[0]+a.I+2,s[1]+a.F/2]),r.parse(),r.J2=function(e){return n.J2(e)},r.DE()&&r.parse(),r.AN&&r.paint()}}}},paint:function(){var e,i,t,n,a,l,o,r,s,A=this,C=A.C.CL,c=A.C.BL(A.A.BU("k")[0]),u=A.C.F0["x-angle"],p=A.C.F0["y-angle"];A.setup();var Z="pie-sel-"+A.A.L+"-"+A.L;if(A.o.detached&&"undefined"==typeof A.C.E[Z]&&(A.C.E[Z]=!0),!(A.AD<0)){var h=ZC.BQ(.7,ZC.EH(u));A.AI=ZC.CY(c.GF/h,c.GK)/2,null!==ZC._n_(A.A.o.size)?A.AI=A.A.AI:A.AI=c.JE*A.AI,A.CN<1&&(A.CN*=A.AI),A.CN=Math.max(0,A.CN),A.o.slice=A.CN,A.DV<1&&(A.DV*=A.AI),A.o["offset-r"]=A.DV;var d=A.A.NK;-1===d&&(d=A.AI/5),A.E.thickness=d;var f=A.iX-ZC.AO.E2,_=A.iY-ZC.AO.E3;A.B4=ZC._i_(A.B4),A.BK=ZC._i_(A.BK);var g=(A.B4+A.BK)/2;A.C.E[Z]&&(A.DV+=ZC._i_(.15*A.AI)),A.DV>0&&(f+=A.DV*ZC.EH(g),_+=A.DV*ZC.EP(g));var v=A.N=A.A.ID(A,A);v.DK=A.K+"-3dfacet";var b=new ZC.D0(A);if(b.copy(v),b.A0=ZC.AP.JN(ZC.AP.GC(b.A0)),b.AE=ZC.AP.JN(ZC.AP.GC(b.AE)),A.AD>=0||0===A.A.A.KM[A.L]){for(o=[],e=A.B4,o.push([f+A.CN*ZC.EH(e),_+A.CN*ZC.EP(e),0]),e=A.B4;e<=A.BK;e+=1)o.push([f+A.AI*ZC.EH(e),_+A.AI*ZC.EP(e),0]);for(e=A.BK,o.push([f+A.CN*ZC.EH(e),_+A.CN*ZC.EP(e),0]),e=A.BK;e>=A.B4;e-=1)o.push([f+A.CN*ZC.EH(e),_+A.CN*ZC.EP(e),0]);if((i=ZC.DI.D8(v,A.C,o)).K=A.K+"-facet1",C.add(i),t=null,A.B4%360>=0+p&&A.B4%360<180+p||A.BK%360>0+p){r=A.B4,s=A.BK;var B=function(e,i,n){var a,l=[];for(a=e,l.push([f+A.AI*ZC.EH(a),_+A.AI*ZC.EP(a),0]),a=e;a<=i;a+=1)l.push([f+A.AI*ZC.EH(a),_+A.AI*ZC.EP(a),0]);for(a=i,l.push([f+A.AI*ZC.EH(a),_+A.AI*ZC.EP(a),d]),a=i;a>=e;a-=1)l.push([f+A.AI*ZC.EH(a),_+A.AI*ZC.EP(a),d]);(t=ZC.DI.D8(b,A.C,l)).MD=[.01,1,1,1],t.K=A.K+"-facet2"+n,C.add(t)};r<180&&s>360?(B(r=r<0?r+360:r,180,1),B(360,s,2)):(r=ZC.BQ(r,s>360?365:5),(s=ZC.CY(s,s>360?535:175))>r&&B(r,s,1))}if(l=null,A.CN>0+p&&A.BK>180+p){for(o=[],e=A.B4,r=A.B4,A.B4<180+p&&A.BK>180+p&&(e=180+p,r=180+p),o.push([f+A.CN*ZC.EH(e),_+A.CN*ZC.EP(e),0]),e=r;e<=A.BK;e+=1)o.push([f+A.CN*ZC.EH(e),_+A.CN*ZC.EP(e),0]);for(e=A.BK,o.push([f+A.CN*ZC.EH(e),_+A.CN*ZC.EP(e),d]),e=A.BK;e>=r;e-=1)o.push([f+A.CN*ZC.EH(e),_+A.CN*ZC.EP(e),d]);(l=ZC.DI.D8(b,A.C,o)).K=A.K+"-facet3",C.add(l)}var m=function(e,i,t){return[[f+e*ZC.EH(t),_+e*ZC.EP(t),0],[f+e*ZC.EH(t),_+e*ZC.EP(t),d],[f+i*ZC.EH(t),_+i*ZC.EP(t),d],[f+i*ZC.EH(t),_+i*ZC.EP(t),0]]};(n=ZC.DI.D8(b,A.C,{points:m(A.CN,A.AI,A.B4),mathpoints:m(A.CN+1,A.AI+1,A.B4-1)})).K=A.K+"-facet4",C.add(n),(a=ZC.DI.D8(b,A.C,{points:m(A.CN,A.AI,A.BK),mathpoints:m(A.CN+1,A.AI+1,A.BK+1)})).K=A.K+"-facet5",C.add(a);var E=A.C.K+"-node-area "+A.C.K+"-plotset-plot-"+A.A.L+"-node-area zc-node-area",D=ZC.Q.G0("poly",A.A.EA)+'class="'+E+'" id="'+A.K,K=A.A.A.HE;K.push(D+'--top" '+A.a11y()+' data-z-sort="1" coords="'+i.FF()+'" />'),t&&K.push(D+'--outer" data-z-sort="1" coords="'+t.FF()+'" />'),(A.CN>0||A.DV>0)&&(l&&K.push(D+'--inner" data-z-sort="2" coords="'+l.FF()+'" />'),K.push(D+'--start" data-z-sort="2" coords="'+n.FF()+'" />',D+'--end" data-z-sort="2" coords="'+a.FF()+'" />'))}A.A.U&&A.GW()}},X4:function(e,i){var t=this;if(t.b(e,i),"click"===i&&e.which<=1&&t.A.A7O){var n="pie-sel-"+t.A.L+"-"+t.L;t.C.E[n]="undefined"==typeof t.C.E[n]||!t.C.E[n],t.C.K6()}}}),ZC.A6V=ZC.ZB.CA({setup:function(){this.T6()},UY:function(){var e=this;e.paint(!0);var i=e.C.BL(e.A.BU("v")[0]),t=e.iX+e.I/2,n=e.iY+(i.AW?e.F:0),a=new ZC.CE(e.C,t-ZC.AO.E2,n-ZC.AO.E3,e.A.E["z-start"]);return[ZC._i_(a.ED[0]),ZC._i_(a.ED[1]),{reference:e,center:!0}]},AC8:function(e){var i=this,t=i.b(e);if("-1/-1"!==t.join("/")){var n=new ZC.CE(i.C,t[0]+e.I/2-ZC.AO.E2,t[1]+e.F/2-ZC.AO.E3,i.A.E["z-mid"]);return[ZC._i_(n.ED[0])-e.I/2,ZC._i_(n.ED[1])-e.F/2]}return t},paint:function(e){var i,t=this;t.b(),void 0===e&&(e=!1);var n=t.C.CL,a=t.A.B1,l=t.A.CM;t.setup();var o,r,s,A,C,c,u,p,Z,h,d,f,_,g,v,b,B=t.A.SM(),m=B.AC,E=B.ET,D=B.CF,K=B.CT,F=B.F4,x=B.D3,I=B.EZ;if(e?E=t.A.E["node-"+t.L+"-bar-index"]:t.A.E["node-"+t.L+"-bar-index"]=B.ET,t.A.CC){s=0;var y=t.A.A.KB[E];for(o=0;o<y.length;o++){var w=t.A.A.A4[y[o]].S[t.L];w&&(s+=w.AD)}}var Y=1,X=1;if(t.A.CC&&s>0&&(t.CS!==t.AD&&(Y=(s-t.CS+t.AD)/s),X=(s-t.CS)/s),l.AW){var M=Y;Y=X,X=M}t.A.LP&&(E=t.L);var L=t.iX-m/2+D+E*(x+F)-E*I;if(L=ZC._l_(L,t.iX-m/2+D,t.iX+m/2-K),t.A.D3>0){var H=x;(x=t.A.D3)<=1&&(x*=H),L+=(H-x)/2}var P=x,N=t.iY,G=null!==ZC._n_(t.A.LY[t.L])?t.A.LY[t.L]:0;if(N=t.A.CC&&"100%"===t.A.KQ?l.AT(100*(t.CS+G)/t.A.A.F8[t.L]["%total-"+t.A.DZ]):l.AT(t.CS+G),t.A.CC?(C=N-(A="100%"===t.A.KQ?l.AT(100*(t.CS-t.AD+G)/t.A.A.F8[t.L]["%total-"+t.A.DZ]):l.AT(t.CS-t.AD+G)),t.AD<0&&(N=A),l.AW?C>0&&(C=ZC._a_(C),N=A):C<0&&(N=A-(C=ZC._a_(C)))):N=(C=N-(A=l.AT(G)))<0?A-(C=ZC._a_(C)):A,D+K===0&&(L-=.5,P+=1),t.I=P,t.F=C,t.iX=L,t.iY=N,l.AW?t.AD>=l.H6?t.iYVal=N+t.F:t.iYVal=N:t.AD>=l.H6?t.iYVal=N:t.iYVal=N+t.F,t.C.CX){var S="middle";t.C.CX.o.marker&&null!==ZC._n_(i=t.C.CX.o.marker.alignment)&&(S=i),null!==ZC._n_(t.A.o["guide-marker"])&&null!==ZC._n_(i=t.A.o["guide-marker"].alignment)&&(S=i),"node"===S&&(t.E.A5M=t.iX+t.I/2)}if(!e){var O,k,T,z=L-ZC.AO.E2,Q=N-ZC.AO.E3,J=0,V=ZC.AO.FT,R=0,W=V;if(t.A.A3H){if(k=J,"mixed3d"===t.C.AF||"mixed"===t.C.AF){for(O=1,o=0,r=t.A.A.A4.length;o<r;o++)"vbar3d"!==t.A.A.A4[o].AF&&O++;k=(O-1)*(ZC.AO.FT/O),V=ZC._i_(.9*V/O)}T=k+V}else{if(O=0,R=-1,W=ZC.AO.FT,"hide"===t.C.getToggleAction())O=t.A.A.A4.length,R=t.A.L,W/=O;else if(t.A.CC)R=0;else{for(o=0;o<t.A.A.A4.length;o++)t.C.E["plot"+o+".visible"]&&R++;for(o=0;o<t.A.A.A4.length;o++)t.C.E["plot"+o+".visible"]&&(O++,t.A.L>o&&R--);W/=O,R=O-R-1}k=R*W+.2*W,T=(R+1)*W-.2*W}if(null!==ZC._n_(t.A.o["z-start"])&&(k=ZC._i_(t.A.o["z-start"])),null!==ZC._n_(t.A.o["z-end"])&&(T=ZC._i_(t.A.o["z-end"])),null!==ZC._n_(t.A.o.depth)){var U=ZC._i_(t.A.o.depth);k=R*W+W/2-U,T=R*W+W/2+U}J=k,V=T-k,t.A.E["z-plots"]=O,t.A.E["z-cnt"]=R,t.A.E["z-depth"]=W,t.A.E["z-start"]=k,t.A.E["z-mid"]=(k+T)/2;var j=t.N=t.A.ID(t,t.N);if(j.DK=t.K+"-3dfacet",t.A.HT&&(t.H3(j),j.parse()),j.AN){var q=new ZC.D0(t);q.copy(j),q.A0=ZC.AP.JN(ZC.AP.GC(q.A0)),q.AE=ZC.AP.JN(ZC.AP.GC(q.AE)),q.BW=ZC.AP.JN(ZC.AP.GC(q.BW));var $=new ZC.D0(t);$.copy(j),$.A0=ZC.AP.JN(ZC.AP.GC($.A0),15),$.AE=ZC.AP.JN(ZC.AP.GC($.AE),15),$.BW=ZC.AP.JN(ZC.AP.GC($.BW),15);var ee=new ZC.D0(t);ee.copy(j);var ie=t.C.K+"-node-area "+t.C.K+"-plotset-plot-"+t.A.L+"-node-area zc-node-area",te=ZC.Q.G0("poly",t.A.EA,t.N.IV)+'class="'+ie+'" id="'+t.K,ne=t.C.F0.true3d,ae=t.I/2,le=V/2,oe=Y*ae,re=X*ae,se=X*le,Ae=Y*le;l.AW&&!t.A.CC?(c=t.AD>=0?0:t.F,u=t.AD>=0?t.F:0):(c=t.AD>=0?t.F:0,u=t.AD>=0?0:t.F);var Ce=t.A.A.HE,ce=ZC.CY(le,ae),ue=t.C.F0["y-angle"],pe=t.C.F0.angle,Ze=ZC.EH(pe)*le,he=ZC.EP(pe)*le;ne||(ce=ZC.CY(2*Ze,ae));var de=function(e){var i=0,n=t.A.L,o=t.L,r=t.A.A.A4.length,s=t.A.S.length;switch((t.A.CC?"s":"")+(a.AW?"k":"")+(l.AW?"v":"")){case"":case"v":i=10*n+1e4*o+e;break;case"sv":i=10*(r-n)+1e4*o+e;break;case"k":i=10*n+1e4*(s-o)+e;break;case"skv":i=10*(r-n)+1e4*(s-o)+e;break;case"kv":i=10*n+1e4*(s-o)+e;break;case"s":i=10*n+1e4*o+e;break;case"sk":i=10*n+1e4*(s-o)+e}return i},fe=ZC.MAX,_e=-ZC.MAX,ge=ZC.MAX,ve=-ZC.MAX,be=ZC.MAX,Be=-ZC.MAX,me=ZC.MAX,Ee=-ZC.MAX;if("cylinder"===t.A.CW)for(b=0;b<=360;b+=4)(Z=new ZC.CE(t.C,z+ZC.EP(b)*ce+ae,Q,J+ZC.EH(b)*ce+le)).ED[0]<ge&&(ge=Z.ED[0],fe=b),Z.ED[0]>ve&&(ve=Z.ED[0],_e=b),(Z=new ZC.CE(t.C,z+ZC.EP(b)*ce+ae,Q+t.F,J+ZC.EH(b)*ce+le)).ED[0]<me&&(me=Z.ED[0],be=b),Z.ED[0]>Ee&&(Ee=Z.ED[0],Be=b);var De=t.A.o.facets||{};switch(t.A.CW){default:De.bottom?((p=new ZC.D0(t)).copy(q),p.append(De.bottom),p.parse(),_=ZC.DI.DB(p,t.C,z+.1,z+t.I-.1,Q+t.F-.1,Q+t.F-.1,J+.1,J+V-.1,"x")):_=ZC.DI.DB(q,t.C,z+.1,z+t.I-.1,Q+t.F-.1,Q+t.F-.1,J+.1,J+V-.1,"x"),_.K=t.K+"-facet1",_.FX=de(1),n.add(_),De.top?((p=new ZC.D0(t)).copy(q),p.append(De.top),p.parse(),f=ZC.DI.DB(p,t.C,z+.1,z+t.I-.1,Q+.1,Q+.1,J+.1,J+V-.1,"x")):f=ZC.DI.DB(q,t.C,z+.1,z+t.I-.1,Q+.1,Q+.1,J+.1,J+V-.1,"x"),f.K=t.K+"-facet2",f.FX=de(3),n.add(f),De.left?((p=new ZC.D0(t)).copy($),p.append(De.left),p.parse(),g=ZC.DI.DB(p,t.C,z+.1,z+.1,Q+.1,Q+t.F-.1,J+.1,J+V-.1,"z")):g=ZC.DI.DB($,t.C,z+.1,z+.1,Q+.1,Q+t.F-.1,J+.1,J+V-.1,"z"),g.K=t.K+"-facet3",g.FX=de(2),n.add(g),De.right?((p=new ZC.D0(t)).copy($),p.append(De.right),p.parse(),v=ZC.DI.DB(p,t.C,z+t.I-.1,z+t.I-.1,Q+.1,Q+t.F-.1,J+.1,J+V-.1,"z")):v=ZC.DI.DB($,t.C,z+t.I-.1,z+t.I-.1,Q+.1,Q+t.F-.1,J+.1,J+V-.1,"z"),v.K=t.K+"-facet4",v.FX=de(4),n.add(v),De.front?((p=new ZC.D0(t)).copy(ee),p.append(De.front),p.parse(),d=ZC.DI.DB(p,t.C,z+.1,z+t.I-.1,Q+.1,Q+t.F-.1,J+.1,J+.1,"y")):d=ZC.DI.DB(ee,t.C,z+.1,z+t.I-.1,Q+.1,Q+t.F-.1,J+.1,J+.1,"y"),d.K=t.K+"-facet5",d.FX=de(5),n.add(d),t.A.FY&&(1===X&&Ce.push(te+'--top" coords="'+f.FF()+'" />'),Ce.push(te+'--left" coords="'+g.FF()+'" />',te+'--right" coords="'+v.FF()+'" />',te+'--front" coords="'+d.FF()+'" '+t.a11y()+' data-z-sort="-100" />'));break;case"pyramid":De.bottom?((p=new ZC.D0(t)).copy(q),p.append(De.bottom),p.parse(),_=ZC.DI.DB(p,t.C,z+ae-oe,z+ae+oe,Q+c,Q+c,J+le-Ae,J+le+Ae,"x")):_=ZC.DI.DB(q,t.C,z+ae-oe,z+ae+oe,Q+c,Q+c,J+le-Ae,J+le+Ae,"x"),_.K=t.K+"-facet1",_.FX=de(l.AW&&!t.A.CC?6:1),n.add(_),h=[[z+ae-oe,Q+c,J+le-Ae],[z+ae+oe,Q+c,J+le-Ae]],t.A.CC&&0!==X?h.push([z+ae+re,Q+u,J+le-se],[z+ae-re,Q+u,J+le-se]):h.push([z+ae,Q+u,J+le]),De.front?((p=new ZC.D0(t)).copy(j),p.append(De.front),p.parse(),d=ZC.DI.D8(p,t.C,h)):d=ZC.DI.D8(j,t.C,h),d.K=t.K+"-facet2",d.FX=de(3),n.add(d),h=[[z+ae-oe,Q+c,J+le-Ae],[z+ae-oe,Q+c,J+le+Ae]],t.A.CC&&0!==X?h.push([z+ae-re,Q+u,J+le+se],[z+ae-re,Q+u,J+le-se]):h.push([z+ae,Q+u,J+le]),De.left?((p=new ZC.D0(t)).copy($),p.append(De.left),p.parse(),g=ZC.DI.D8(p,t.C,h)):g=ZC.DI.D8($,t.C,h),g.K=t.K+"-facet3",g.FX=de(2),n.add(g),h=[[z+ae+oe,Q+c,J+le-Ae],[z+ae+oe,Q+c,J+le+Ae]],t.A.CC&&0!==X?h.push([z+ae+re,Q+u,J+le+se],[z+ae+re,Q+u,J+le-se]):h.push([z+ae,Q+u,J+le]),De.right?((p=new ZC.D0(t)).copy($),p.append(De.right),p.parse(),v=ZC.DI.D8(p,t.C,h)):v=ZC.DI.D8($,t.C,h),v.K=t.K+"-facet4",v.FX=de(4),n.add(v),t.A.CC&&0!==X&&(h=[[z+ae-re,Q+u,J+le-se],[z+ae-re,Q+u,J+le+se],[z+ae+re,Q+u,J+le+se],[z+ae+re,Q+u,J+le-se]],De.top?((p=new ZC.D0(t)).copy(q),p.append(De.top),p.parse(),f=ZC.DI.D8(p,t.C,h)):f=ZC.DI.D8(q,t.C,h),f.K=t.K+"-facet5",f.FX=de(5),n.add(f)),t.A.FY&&Ce.push(te+'--left" coords="'+g.FF()+'" />',te+'--right" coords="'+v.FF()+'" />',te+'--front" coords="'+d.FF()+'" '+t.a11y()+' data-z-sort="-100" />');break;case"cylinder":if(h=[],ne)for(b=0;b<=360;b+=5)h.push([z+ZC.EP(b)*ce+ae,Q+t.F,J+ZC.EH(b)*ce+le]);else for(b=0;b<=360;b+=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce+ae+Ze,N+t.F+ZC.EP(b)*(ce/2)-he],h.push(Z);if(De.bottom?((p=new ZC.D0(t)).copy(q),p.append(De.bottom),p.parse(),_=ZC.DI.D8(p,t.C,h,!ne)):_=ZC.DI.D8(q,t.C,h,!ne),_.K=t.K+"-facet1",_.FX=de(1),n.add(_),h=[],ne)for(b=0;b<=360;b+=5)h.push([z+ZC.EP(b)*ce+ae,Q,J+ZC.EH(b)*ce+le]);else for(b=0;b<=360;b+=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce+ae+Ze,N+ZC.EP(b)*(ce/2)-he],h.push(Z);if(De.top?((p=new ZC.D0(t)).copy(q),p.append(De.top),p.parse(),f=ZC.DI.D8(p,t.C,h,!ne)):f=ZC.DI.D8(q,t.C,h,!ne),f.K=t.K+"-facet2",f.FX=de(3),n.add(f),h=[],ne){for(b=ZC.CY(fe,_e);b<=ZC.BQ(fe,_e);b+=1)h.push([z+ZC.EP(b)*ce+ae,Q,J+ZC.EH(b)*ce+le]);for(h.push([z+ZC.EP(b)*ce+ae,Q+t.F,J+ZC.EH(b)*ce+le]),b=ZC.BQ(be,Be);b>=ZC.CY(be,Be);b-=1)h.push([z+ZC.EP(b)*ce+ae,Q+t.F,J+ZC.EH(b)*ce+le])}else{for(b=0;b<=180;b+=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce+ae+Ze,N+t.F+ZC.EP(b)*(ce/2)-he],h.push(Z);for(b=180;b>=0;b-=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce+ae+Ze,N+ZC.EP(b)*(ce/2)-he],h.push(Z)}De.front?((p=new ZC.D0(t)).copy(j),p.append(De.front),p.parse(),d=ZC.DI.D8(p,t.C,h,!ne)):d=ZC.DI.D8(j,t.C,h,!ne),d.K=t.K+"-facet3",d.FX=de(2),n.add(d),t.A.FY&&Ce.push(te+'--front" coords="'+d.FF()+'" '+t.a11y()+' data-z-sort="-100" />',te+'--top" coords="'+f.FF()+'" />');break;case"cone":if(h=[],ne)for(b=0;b<=360;b+=5)h.push([z+ZC.EP(b)*ce*Y+ae,Q+c,J+ZC.EH(b)*ce*Y+le]);else for(b=0;b<=360;b+=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce*Y+ae+Ze,N+c+ZC.EP(b)*(ce/2)*Y-he],h.push(Z);if(De.bottom?((p=new ZC.D0(t)).copy(q),p.append(De.bottom),p.parse(),_=ZC.DI.D8(p,t.C,h,!ne)):_=ZC.DI.D8(q,t.C,h,!ne),_.K=t.K+"-facet1",_.FX=de(1),n.add(_),h=[],ne){for(b=90+ue;b<=270+ue;b+=5)h.push([z+ZC.EP(b)*ce*Y+ae,Q+c,J+ZC.EH(b)*ce*Y+le]);if(t.A.CC&&0!==X)for(b=270+ue;b>=90+ue;b-=5)h.push([z+ZC.EP(b)*ce*X+ae,Q+u,J+ZC.EH(b)*ce*X+le]);else h.push([z+ae,Q+u,J+le])}else{for(b=0;b<=180;b+=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce*Y+ae+Ze,N+c+ZC.EP(b)*(ce/2)*Y-he],h.push(Z);if(t.A.CC&&0!==X)for(b=180;b>=0;b-=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce*X+ae+Ze,N+u+ZC.EP(b)*(ce/2)*X-he],h.push(Z);else(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ae+Ze,N+u-he],h.push(Z)}if(De.front?((p=new ZC.D0(t)).copy(j),p.append(De.front),p.parse(),d=ZC.DI.D8(p,t.C,h,!ne)):d=ZC.DI.D8(j,t.C,h,!ne),d.K=t.K+"-facet2",d.FX=de(2),n.add(d),t.A.CC&&0!==X){if(h=[],ne)for(b=0;b<=360;b+=5)h.push([z+ZC.EP(b)*ce*X+ae,Q+u,J+ZC.EH(b)*ce*X+le]);else for(b=0;b<=360;b+=5)(Z=new ZC.CE(t.C,0,0,0)).ED=[L+ZC.EH(b)*ce*X+ae+Ze,N+u+ZC.EP(b)*(ce/2)*X-he],h.push(Z);De.top?((p=new ZC.D0(t)).copy(q),p.append(De.top),p.parse(),f=ZC.DI.D8(p,t.C,h,!ne)):f=ZC.DI.D8(q,t.C,h,!ne),f.K=t.K+"-facet3",n.add(f),f.FX=de(3)}t.A.FY&&Ce.push(te+'--front" coords="'+d.FF()+'" data-z-sort="-100" />')}t.A.U&&t.A.U.AN&&t.GW()}t.paintPreview(j)}},A0W:function(){}}),ZC.A6Y=ZC.ZA.CA({setup:function(){this.T6()},UY:function(){var e=this;e.paint(!0);var i=e.C.BL(e.A.BU("v")[0]),t=e.iX+(i.AW?0:e.I),n=e.iY+e.F/2,a=new ZC.CE(e.C,t-ZC.AO.E2,n-ZC.AO.E3,e.A.E["z-start"]);return[ZC._i_(a.ED[0]),ZC._i_(a.ED[1]),{reference:e,center:!0}]},AC8:function(e){var i=this,t=i.b(e);if("-1/-1"!==t.join("/")){var n=new ZC.CE(i.C,t[0]-ZC.AO.E2,t[1]-ZC.AO.E3,i.A.E["z-start"]);return[ZC._i_(n.ED[0]),ZC._i_(n.ED[1])]}return t},paint:function(e){var i=this;i.b(),void 0===e&&(e=!1);var t=i.C.CL,n=i.A.B1,a=i.A.CM;i.setup();var l,o,r,s,A,C,c,u,p,Z,h,d,f,_,g=i.A.SM(),v=g.AC,b=g.ET,B=g.CF,m=g.CT,E=g.F4,D=g.D3,K=g.EZ;if(e?b=i.A.E["node-"+i.L+"-bar-index"]:i.A.E["node-"+i.L+"-bar-index"]=g.ET,i.A.CC){l=0;for(var F=i.A.A.KB[b],x=0;x<F.length;x++){var I=i.A.A.A4[F[x]].S[i.L];I&&(l+=I.AD)}}var y=1,w=1;if(i.A.CC&&(i.CS!==i.AD&&(y=(l-i.CS+i.AD)/l),w=(l-i.CS)/l),a.AW){var Y=y;y=w,w=Y}i.A.LP&&(b=i.L);var X=i.iY-v/2+B+b*(D+E)-b*K;if(X=ZC._l_(X,i.iY-v/2+B,i.iY+v/2-m),i.A.D3>0){var M=D;(D=i.A.D3)<=1&&(D*=M),X+=(M-D)/2}var L=D,H=i.iX,P=null!==ZC._n_(i.A.LY[i.L])?i.A.LY[i.L]:0;if(H=i.A.CC&&"100%"===i.A.KQ?a.AT(100*(i.CS+P)/i.A.A.F8[i.L]["%total-"+i.A.DZ]):a.AT(i.CS+P),i.A.CC?(r=H-(o="100%"===i.A.KQ?a.AT(100*(i.CS-i.AD+P)/i.A.A.F8[i.L]["%total-"+i.A.DZ]):a.AT(i.CS-i.AD+P)),i.AD>0?H=o:r=ZC._a_(r),a.AW?r>0?(r=ZC._a_(r),H=o):H-=r=ZC._a_(r):r<0&&(H=o-(r=ZC._a_(r)))):H=(r=H-(o=a.AT(P)))<0?o-(r=ZC._a_(r)):o,B+m===0&&(X-=.5,L+=1),i.I=r,i.F=L,i.iX=H,i.iY=X,a.AW?i.AD>=a.H6?i.iXVal=H:i.iXVal=H+i.I:i.AD>=a.H6?i.iXVal=H+i.I:i.iXVal=H,!e){var N=H+r-ZC.AO.E2,G=X-ZC.AO.E3,S=0,O=ZC.AO.FT;null!==ZC._n_(i.A.o["z-start"])&&(S=ZC._i_(i.A.o["z-start"])),null!==ZC._n_(i.A.o["z-end"])&&(O=ZC._i_(i.A.o["z-end"])-S),i.A.E["z-start"]=S,i.A.E["z-mid"]=S+O/2;var k=i.N=i.A.ID(i,i.N);if(k.DK=i.K+"-3dfacet",i.A.HT&&(i.H3(k),k.parse()),k.AN){var T=new ZC.D0(i);T.copy(k),T.A0=ZC.AP.JN(ZC.AP.GC(T.A0)),T.AE=ZC.AP.JN(ZC.AP.GC(T.AE)),T.BW=ZC.AP.JN(ZC.AP.GC(T.BW));var z=new ZC.D0(i);z.copy(k),z.A0=ZC.AP.JN(ZC.AP.GC(z.A0),15),z.AE=ZC.AP.JN(ZC.AP.GC(z.AE),15),z.BW=ZC.AP.JN(ZC.AP.GC(z.BW),15);var Q=new ZC.D0(i);Q.copy(k);var J=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area",V=ZC.Q.G0("poly",i.A.EA,i.N.IV)+'class="'+J+'" id="'+i.K,R=i.C.F0.true3d,W=i.F/2,U=O/2,j=y*W,q=w*W,$=w*U,ee=y*U;a.AW&&!i.A.CC?(A=i.AD>=0?0:i.I,s=i.AD>=0?i.I:0):(A=i.AD>=0?i.I:0,s=i.AD>=0?0:i.I);var ie=i.A.A.HE,te=ZC.CY(U,W),ne=i.C.F0["x-angle"],ae=i.C.F0.angle,le=ZC.EH(ae)*U,oe=ZC.EP(ae)*U;R||(te=ZC.CY(2*oe,W));var re=function(e){var t=-1,l=i.A.L,o=i.L,r=i.A.A.A4.length,s=i.A.S.length;switch((i.A.CC?"s":"")+(n.AW?"k":"")+(a.AW?"v":"")){case"":case"v":case"sv":t=10*(r-l)+1e4*o+e;break;case"k":case"skv":case"kv":t=10*(r-l)+1e4*(s-o)+e;break;case"s":t=10*l+1e4*o+e;break;case"sk":t=10*l+1e4*(s-o)+e}return ZC._i_(t)},se=i.A.o.facets||{};switch(i.A.CW){default:se.left?((C=new ZC.D0(i)).copy(z),C.append(se.left),C.parse(),c=ZC.DI.DB(C,i.C,N-i.I+.1,N-.1,G+.1,G+.1,S+.1,S+O-.1,"x")):c=ZC.DI.DB(z,i.C,N-i.I+.1,N-.1,G+.1,G+.1,S+.1,S+O-.1,"x"),c.K=i.K+"-facet1",c.FX=re(5),t.add(c),se.right?((C=new ZC.D0(i)).copy(z),C.append(se.right),C.parse(),h=ZC.DI.DB(C,i.C,N-i.I+.1,N-.1,G+i.F-.1,G+i.F-.1,S+.1,S+O-.1,"x")):h=ZC.DI.DB(z,i.C,N-i.I+.1,N-.1,G+i.F-.1,G+i.F-.1,S+.1,S+O-.1,"x"),h.K=i.K+"-facet2",h.FX=re(1),t.add(h),se.bottom?((C=new ZC.D0(i)).copy(T),C.append(se.bottom),C.parse(),u=ZC.DI.DB(C,i.C,N-i.I+.1,N-i.I+.1,G+i.F-.1,G+.1,S+.1,S+O-.1,"z")):u=ZC.DI.DB(T,i.C,N-i.I+.1,N-i.I+.1,G+i.F-.1,G+.1,S+.1,S+O-.1,"z"),u.K=i.K+"-facet3",u.FX=re(2),t.add(u),se.top?((C=new ZC.D0(i)).copy(T),C.append(se.top),C.parse(),p=ZC.DI.DB(C,i.C,N-.1,N-.1,G+i.F-.1,G+.1,S+.1,S+O-.1,"z")):p=ZC.DI.DB(T,i.C,N-.1,N-.1,G+i.F-.1,G+.1,S+.1,S+O-.1,"z"),p.K=i.K+"-facet4",p.FX=re(3),t.add(p),se.front?((C=new ZC.D0(i)).copy(Q),C.append(se.front),C.parse(),Z=ZC.DI.DB(C,i.C,N-i.I+.1,N-.1,G+i.F-.1,G+.1,S+.1,S+.1,"y")):Z=ZC.DI.DB(Q,i.C,N-i.I+.1,N-.1,G+i.F-.1,G+.1,S+.1,S+.1,"y"),Z.K=i.K+"-facet5",Z.FX=re(4),t.add(Z),i.A.FY&&(i.A.CC||ie.push(V+'--top" coords="'+p.FF()+'" />'),ie.push(V+'--left" coords="'+c.FF()+'" />',V+'--right" coords="'+h.FF()+'" />',V+'--front" coords="'+Z.FF()+'" '+i.a11y()+' data-z-sort="-100" />'));break;case"pyramid":se.bottom?((C=new ZC.D0(i)).copy(T),C.append(se.bottom),C.parse(),u=ZC.DI.DB(C,i.C,N-A,N-A,G+W-j,G+W+j,U-ee,U+ee,"z")):u=ZC.DI.DB(T,i.C,N-A,N-A,G+W-j,G+W+j,U-ee,U+ee,"z"),u.K=i.K+"-facet1",u.FX=re(a.AW&&!i.A.CC?6:1),t.add(u),_=[[N-A,G+W-j,U-ee],[N-A,G+W+j,U-ee]],i.A.CC&&0!==w?_.push([N-s,G+W+q,U-$],[N-s,G+W-q,U-$]):_.push([N-s,G+W,O/2]),se.front?((C=new ZC.D0(i)).copy(k),C.append(se.front),C.parse(),Z=ZC.DI.D8(C,i.C,_)):Z=ZC.DI.D8(k,i.C,_),Z.K=i.K+"-facet2",Z.FX=re(3),t.add(Z),_=[[N-A,G+W-j,U-ee],[N-A,G+W-j,U+ee]],i.A.CC&&0!==w?_.push([N-s,G+W-q,U+$],[N-s,G+W-q,U-$]):_.push([N-s,G+i.F/2,O/2]),se.left?((C=new ZC.D0(i)).copy(z),C.append(se.left),C.parse(),c=ZC.DI.D8(C,i.C,_)):c=ZC.DI.D8(z,i.C,_),c.K=i.K+"-facet3",c.FX=re(4),t.add(c),_=[[N-A,G+W+j,U-ee],[N-A,G+W+j,U+ee]],i.A.CC&&0!==w?_.push([N-s,G+W+q,U+$],[N-s,G+W+q,U-$]):_.push([N-s,G+W,O/2]),se.right?((C=new ZC.D0(i)).copy(z),C.append(se.right),C.parse(),h=ZC.DI.D8(C,i.C,_)):h=ZC.DI.D8(z,i.C,_),h.K=i.K+"-facet4",h.FX=re(2),t.add(h),i.A.CC&&0!==w&&(se.top?((C=new ZC.D0(i)).copy(T),C.append(se.top),C.parse(),p=ZC.DI.DB(C,i.C,N-s,N-s,G+W-q,G+W+q,U-$,U+$,"z")):p=ZC.DI.DB(T,i.C,N-s,N-s,G+W-q,G+W+q,U-$,U+$,"z"),p.K=i.K+"-facet5",p.FX=re(5),t.add(p)),i.A.FY&&ie.push(V+'--left" coords="'+c.FF()+'" />',V+'--right" coords="'+h.FF()+'" />',V+'--front" coords="'+Z.FF()+'" '+i.a11y()+' data-z-sort="-100" />');break;case"cylinder":if(_=[],R)for(d=0;d<=360;d+=5)_.push([N-i.I,G+ZC.EP(d)*te+W,S+ZC.EH(d)*te+U]);else for(d=0;d<=360;d+=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+ZC.EH(d)*(te/2)+le,X+W+ZC.EP(d)*te-oe],_.push(f);if(se.bottom?((C=new ZC.D0(i)).copy(T),C.append(se.bottom),C.parse(),u=ZC.DI.D8(C,i.C,_,!R)):u=ZC.DI.D8(T,i.C,_,!R),u.K=i.K+"-facet1",u.FX=re(1),t.add(u),_=[],R){for(d=90-ne;d<=270-ne;d+=5)_.push([N-i.I,G+ZC.EP(d)*te+W,S+ZC.EH(d)*te+U]);for(_.push([N,G+ZC.EP(d)*te+W,S+ZC.EH(d)*te+U]),d=270-ne;d>=90-ne;d-=5)_.push([N,G+ZC.EP(d)*te+W,S+ZC.EH(d)*te+U])}else{for(d=90;d<=270;d+=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+ZC.EH(d)*(te/2)+le,X+W+ZC.EP(d)*te-oe],_.push(f);for(d=270;d>=90;d-=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+ZC.EH(d)*(te/2)+i.I+le,X+W+ZC.EP(d)*te-oe],_.push(f)}if(se.front?((C=new ZC.D0(i)).copy(k),C.append(se.front),C.parse(),Z=ZC.DI.D8(C,i.C,_,!R)):Z=ZC.DI.D8(k,i.C,_,!R),Z.K=i.K+"-facet2",Z.FX=re(2),t.add(Z),_=[],R)for(d=0;d<=360;d+=5)_.push([N,G+ZC.EP(d)*te+W,S+ZC.EH(d)*te+U]);else for(d=0;d<=360;d+=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+ZC.EH(d)*(te/2)+i.I+le,X+W+ZC.EP(d)*te-oe],_.push(f);se.top?((C=new ZC.D0(i)).copy(T),C.append(se.top),C.parse(),p=ZC.DI.D8(C,i.C,_,!R)):p=ZC.DI.D8(T,i.C,_,!R),p.K=i.K+"-facet3",p.FX=re(3),t.add(p),i.A.FY&&ie.push(V+'--front" coords="'+Z.FF()+'" '+i.a11y()+' data-z-sort="-100" />',V+'--top" coords="'+p.FF()+'" />');break;case"cone":if(_=[],R)for(d=0;d<=360;d+=5)_.push([N-A,G+ZC.EP(d)*te*y+W,ZC.EH(d)*te*y+U]);else for(d=0;d<=360;d+=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+s+ZC.EH(d)*(te/2)*y+le,X+W+ZC.EP(d)*te*y-oe],_.push(f);if(se.bottom?((C=new ZC.D0(i)).copy(T),C.append(se.bottom),C.parse(),u=ZC.DI.D8(C,i.C,_,!R)):u=ZC.DI.D8(T,i.C,_,!R),u.K=i.K+"-facet1",u.FX=re(1),t.add(u),_=[],R){for(d=90-ne;d<=270-ne;d+=5)_.push([N-A,G+ZC.EP(d)*te*y+W,ZC.EH(d)*te*y+U]);if(i.A.CC&&0!==w)for(d=270-ne;d>=90-ne;d-=5)_.push([N-s,G+ZC.EP(d)*te*w+W,ZC.EH(d)*te*w+U]);else _.push([N-s,G+W,te])}else{for(d=90;d<=270;d+=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+s+ZC.EH(d)*(te/2)*y+le,X+W+ZC.EP(d)*te*y-oe],_.push(f);if(i.A.CC&&0!==w)for(d=270;d>=90;d-=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+A+ZC.EH(d)*(te/2)*w+le,X+W+ZC.EP(d)*te*w-oe],_.push(f);else(f=new ZC.CE(i.C,0,0,0)).ED=[H+A+le,X+W-oe],_.push(f)}if(se.front?((C=new ZC.D0(i)).copy(k),C.append(se.front),C.parse(),Z=ZC.DI.D8(C,i.C,_,!R)):Z=ZC.DI.D8(k,i.C,_,!R),Z.K=i.K+"-facet2",Z.FX=re(2),t.add(Z),i.A.CC&&0!==w){if(_=[],R)for(d=0;d<=360;d+=5)_.push([N-s,G+ZC.EP(d)*te*w+W,ZC.EH(d)*te*w+U]);else for(d=0;d<=360;d+=5)(f=new ZC.CE(i.C,0,0,0)).ED=[H+A+ZC.EH(d)*(te/2)*w+le,X+W+ZC.EP(d)*te*w-oe],_.push(f);se.top?((C=new ZC.D0(i)).copy(T),C.append(se.top),C.parse(),p=ZC.DI.D8(C,i.C,_,!R)):p=ZC.DI.D8(T,i.C,_,!R),p.K=i.K+"-facet3",p.FX=re(3),t.add(p)}i.A.FY&&ie.push(V+'--front" coords="'+Z.FF()+'" data-z-sort="-100" />')}}i.A.U&&i.A.U.AN&&i.GW()}},A0W:function(){}}),ZC.A6W=ZC.A38.CA({setup:function(){this.T6()},ABF:function(){return{color:this.N.B7}},Y4:function(){return{"background-color":this.N.B7,"border-color":this.N.B7,color:this.N.C2}},AC8:function(e){var i=this,t=i.b(e);return new ZC.CE(i.C,t[0]-ZC.AO.E2,t[1]-ZC.AO.E3,i.A.E["z-start"]).ED},paint:function(){var e,i,t=this;t.b();var n,a=t.E.points;(n="none"!==t.A.IZ?t.N=t.A.ID(t,t.N):t.N).DK=t.K+"-3dfacet",t.A.HT&&t.H3(n);var l=0,o=-1,r=ZC.AO.FT;if("hide"===t.C.getToggleAction())t.A.CC?o=0:(l=t.A.A.A4.length,o=t.A.L,r/=l);else if(t.A.CC)o=0;else{for(e=0;e<t.A.A.A4.length;e++)t.C.E["plot"+e+".visible"]&&o++;for(e=0;e<t.A.A.A4.length;e++)t.C.E["plot"+e+".visible"]&&(l++,t.A.L>e&&o--);r/=l,o=l-o-1}n.A0=n.AE=n.B7,"spline"===t.A.CW&&(n.BW=n.B7);var s=t.A.A.HE,A=t.C.K+"-node-area "+t.C.K+"-plotset-plot-"+t.A.L+"-node-area zc-node-area",C=ZC.Q.G0("poly",t.A.EA,t.N.IV)+'class="'+A+'" id="'+t.K,c=o*r,u=(o+1)*r;if(null!==ZC._n_(t.A.o["z-start"])&&(c=ZC._i_(t.A.o["z-start"])),null!==ZC._n_(t.A.o["z-end"])&&(u=ZC._i_(t.A.o["z-end"])),null!==ZC._n_(t.A.o.depth)){var p=ZC._i_(t.A.o.depth);c=o*r+r/2-p,u=o*r+r/2+p}t.A.E["z-plots"]=l,t.A.E["z-cnt"]=o,t.A.E["z-depth"]=r,t.A.E["z-start"]=c,t.A.E["z-mid"]=(c+u)/2;var Z,h,d,f=[],_=[],g=n;ZC._a_(c-u)<=2&&(t.C.CL.SH[t.A.K]||(t.C.CL.SH[t.A.K]={zIndex:t.A.L,style:n,points:[]},t.C.CL.SH[t.A.K].style.M8=!1,t.C.CL.SH[t.A.K].style.AZ=ZC.BQ(1,ZC._i_(ZC._a_(c-u)/1))));for(var v=0;v<a.length-1;v++){if(ZC._a_(c-u)>2){var b=-ZC._i_(ZC.TK(Math.atan((a[v+1][1]-a[v][1])/(a[v+1][0]-a[v][0]))));(g=new ZC.D0(t)).copy(n),g.A0=ZC.AP.JN(ZC.AP.GC(g.A0),b),g.AE=ZC.AP.JN(ZC.AP.GC(g.AE),b),g.BW=ZC.AP.JN(ZC.AP.GC(g.BW),b)}var B,m,E,D;if(t.A.oP0&&ZC._a_(c-u)<=2?((B=t.A.oP0).parse(t.C,a[v][0]-ZC.AO.E2,a[v][1]-ZC.AO.E3,c),(m=t.A.oP1).parse(t.C,a[v+1][0]-ZC.AO.E2,a[v+1][1]-ZC.AO.E3,c),(E=t.A.oP2).parse(t.C,a[v+1][0]-ZC.AO.E2,a[v+1][1]-ZC.AO.E3,u-1),(D=t.A.oP3).parse(t.C,a[v][0]-ZC.AO.E2,a[v][1]-ZC.AO.E3,u-1)):(B=t.A.oP0=new ZC.CE(t.C,a[v][0]-ZC.AO.E2,a[v][1]-ZC.AO.E3,c),m=t.A.oP1=new ZC.CE(t.C,a[v+1][0]-ZC.AO.E2,a[v+1][1]-ZC.AO.E3,c),E=t.A.oP2=new ZC.CE(t.C,a[v+1][0]-ZC.AO.E2,a[v+1][1]-ZC.AO.E3,u-1),D=t.A.oP3=new ZC.CE(t.C,a[v][0]-ZC.AO.E2,a[v][1]-ZC.AO.E3,u-1)),ZC._a_(c-u)>2?((Z=new ZC.W6(g,t.C)).K=t.K+"-facet"+v,Z.add(B),Z.add(m),Z.add(E),Z.add(D),t.C.CL.add(Z)):(t.C.CL.SH[t.A.K].points.push(B.ED),v===a.length-2&&t.C.CL.SH[t.A.K].points.push(m.ED),"spline"===t.A.CW&&(B=new ZC.CE(t.C,a[v][0]-ZC.AO.E2,a[v][1]-ZC.AO.E3,c-10),D=new ZC.CE(t.C,a[v][0]-ZC.AO.E2,a[v][1]-ZC.AO.E3,u-1+10))),f.push(B.ED),_.push(D.ED),t.A.FY&&"spline"!==t.A.CW)if(ZC._a_(c-u)>2)i=Z.FF();else{for(h=ZC.AQ.Z0([B.ED,m.ED],4),d=0;d<h.length;d++)h[d][0]=Math.round(h[d][0]),h[d][1]=Math.round(h[d][1]);i=h.join(",")}"spline"!==t.A.CW&&t.A.FY&&s.push(C+"--face"+v+'" '+t.a11y()+' coords="'+i+'" />')}"spline"===t.A.CW?(t.E.polypoints=!0,t.E.points=f.concat(_.reverse())):t.E.points=null,t.A.A2.o&&("spline"===t.A.CW||"none"===t.A.A2.o.type||null!==ZC._n_(t.A.A2.o.visible)&&!ZC._b_(t.A.A2.o.visible))&&"spline"!==t.A.CW||t.P8(!0),t.A.U&&t.A.U.AN&&t.GW(),t.paintPreview(n,a)},A0W:function(){}}),ZC.A6S=ZC.A35.CA({setup:function(){this.T6()},ABF:function(){return{color:this.N.B7}},Y4:function(){return{"background-color":this.N.B7,"border-color":this.N.B7,color:this.N.C2}},AC8:function(e){var i=this,t=i.b(e);return new ZC.CE(i.C,t[0]-ZC.AO.E2,t[1]-ZC.AO.E3,i.A.E["z-start"]).ED},paint:function(){var e,i,t=this;t.b();var n=t.A.CM,a=n.H6,l=n.AT(a);l=ZC._l_(l,n.iY,n.iY+n.F);var o,r=t.E.points,s=t.E.pointsarea;(o="none"!==t.A.IZ?t.N=t.A.ID(t,t.N):t.N).DK=t.K+"-3dfacet",t.A.HT&&t.H3(o);var A=0,C=-1,c=ZC.AO.FT;if("hide"===t.C.getToggleAction())t.A.CC?C=0:(A=t.A.A.A4.length,C=t.A.L,c/=A);else if(t.A.CC)C=0;else{for(e=0;e<t.A.A.A4.length;e++)t.C.E["plot"+e+".visible"]&&C++;for(e=0;e<t.A.A.A4.length;e++)t.C.E["plot"+e+".visible"]&&(A++,t.A.L>e&&C--);c/=A,C=A-C-1}var u=new ZC.D0(t);u.copy(o),u.A0=u.AE=o.B7,"spline"===t.A.CW&&(u.BW=o.B7);var p=new ZC.D0(t);p.copy(o),p.L5=!0,p.AU=0,p.C6=t.A.HX,p.A0=ZC.AP.QU(ZC.AP.GC(p.A0),30),p.AE=ZC.AP.QU(ZC.AP.GC(p.AE),30);var Z,h,d=t.A.A.HE,f=t.C.K+"-node-area "+t.C.K+"-plotset-plot-"+t.A.L+"-node-area zc-node-area",_=ZC.Q.G0("poly",t.A.EA,t.N.IV)+'class="'+f+'" id="'+t.K,g=[],v=[],b=C*c,B=(C+1)*c;if(null!==ZC._n_(t.A.o["z-start"])&&(b=ZC._i_(t.A.o["z-start"])),null!==ZC._n_(t.A.o["z-end"])&&(B=ZC._i_(t.A.o["z-end"])),null!==ZC._n_(t.A.o.depth)){var m=ZC._i_(t.A.o.depth);b=C*c+c/2-m,B=C*c+c/2+m}t.A.E["z-plots"]=A,t.A.E["z-cnt"]=C,t.A.E["z-depth"]=c,t.A.E["z-start"]=b,t.A.E["z-mid"]=(b+B)/2;var E=new ZC.W6(p,t.C);for(Z=0,h=s.length;Z<h;Z++){var D=new ZC.CE(t.C,s[Z][0]-ZC.AO.E2,s[Z][1]-ZC.AO.E3,b);E.add(D)}t.C.CL.add(E),t.E.pointsarea=s,t.L===t.A.S.length-1&&((E=new ZC.W6(p,t.C)).add(new ZC.CE(t.C,t.iX-.5-ZC.AO.E2,t.iY-ZC.AO.E3,b)),E.add(new ZC.CE(t.C,t.iX-.5-ZC.AO.E2,l-ZC.AO.E3,b)),E.add(new ZC.CE(t.C,t.iX-.5-ZC.AO.E2,l-ZC.AO.E3,B-1)),E.add(new ZC.CE(t.C,t.iX-.5-ZC.AO.E2,t.iY-ZC.AO.E3,B-1)),E.K=t.K+"-facet99",t.C.CL.add(E));var K=o;for(ZC._a_(b-B)<=2&&(t.C.CL.SH[t.A.K]||(t.C.CL.SH[t.A.K]={zIndex:t.A.L,style:o,points:[]},t.C.CL.SH[t.A.K].style.M8=!1,t.C.CL.SH[t.A.K].style.AZ=ZC.BQ(1,ZC._i_(ZC._a_(b-B)/1)))),Z=0;Z<r.length-1;Z++){if(ZC._a_(b-B)>2){var F=-ZC._i_(ZC.TK(Math.atan((r[Z+1][1]-r[Z][1])/(r[Z+1][0]-r[Z][0]))));(K=new ZC.D0(t)).copy(u),K.A0=ZC.AP.JN(ZC.AP.GC(K.A0),F),K.AE=ZC.AP.JN(ZC.AP.GC(K.AE),F),K.BW=ZC.AP.JN(ZC.AP.GC(K.BW),F)}var x=new ZC.CE(t.C,r[Z][0]-ZC.AO.E2,r[Z][1]-ZC.AO.E3,b),I=new ZC.CE(t.C,r[Z+1][0]-ZC.AO.E2,r[Z+1][1]-ZC.AO.E3,b),y=new ZC.CE(t.C,r[Z+1][0]-ZC.AO.E2,r[Z+1][1]-ZC.AO.E3,B-1),w=new ZC.CE(t.C,r[Z][0]-ZC.AO.E2,r[Z][1]-ZC.AO.E3,B-1);if(ZC._a_(b-B)>2?((E=new ZC.W6(K,t.C)).K=t.K+"-facet"+Z,E.add(x),E.add(I),E.add(y),E.add(w),t.C.CL.add(E)):(t.C.CL.SH[t.A.K].points.push(x.ED),Z===r.length-2&&t.C.CL.SH[t.A.K].points.push(I.ED),"spline"===t.A.CW&&(x=new ZC.CE(t.C,r[Z][0]-ZC.AO.E2,r[Z][1]-ZC.AO.E3,b-10),w=new ZC.CE(t.C,r[Z][0]-ZC.AO.E2,r[Z][1]-ZC.AO.E3,B-1+10))),g.push(x.ED),v.push(w.ED),t.A.FY&&"spline"!==t.A.CW)if(ZC._a_(b-B)>2)i=E.FF();else{for(var Y=ZC.AQ.Z0([E.D[0].ED,E.D[1].ED],4),X=0;X<Y.length;X++)Y[X][0]=Math.round(Y[X][0]),Y[X][1]=Math.round(Y[X][1]);i=Y.join(",")}"spline"!==t.A.CW&&t.A.FY&&d.push(_+"--face"+Z+'" coords="'+i+'" />')}"spline"===t.A.CW?(t.E.polypoints=!0,t.E.points=g.concat(v.reverse())):t.E.points=null,t.A.A2.o&&("none"===t.A.A2.o.type||null!==ZC._n_(t.A.A2.o.visible)&&!ZC._b_(t.A.A2.o.visible))&&"spline"!==t.A.CW||t.P8(!0),t.A.U&&t.A.U.AN&&t.GW(),t.paintPreview(o,r,s)},A0W:function(){}}),ZC.A85=ZC.LG.CA({$i:function(e){this.b(e),this.WG=0,this.WP=0},JV:function(e,i,t,n){var a=this,l=null;return l=a.A.L<a.A.A.A4.length-1?a.A.A.A4[a.A.L+1]:a.A.A.A4[0],a.CV=[["%paired-plot-text",l.AM],["%paired-node-value",l.S[a.L].AD],["%joined-value",a.WP],["%shared-value",null===ZC._n_(a.A.A.X9[a.L])?0:a.A.A.X9[a.L].area]],e=a.b(e,i,t,n)},setup:function(){var e=this,i=e.C.BL("scale"),t=e.L%i.H0,n=Math.floor(e.L/i.H0);e.iX=i.iX+t*i.GK+i.GK/2+i.BM,e.iY=i.iY+n*i.GF+i.GF/2+i.BH,e.I2||(e.copy(e.A),e.E7=e.A.E7,e.DE()&&e.parse(!1),e.I2=!0),e.I=i.GK/2,e.F=i.GF/2},AC8:function(e){var i=this,t=e.I,n=e.F,a=i.iX-t/2,l=i.iY-n/2;if(3===i.A.A.A4.length)switch(i.A.L){case 0:a-=i.AI/4,l+=i.AI/8;break;case 1:a+=i.AI/4,l+=i.AI/8;break;case 2:l-=i.AI/4}else switch(i.A.L){case 0:a-=i.AI/4;break;case 1:a+=i.AI/4}return null!==ZC._n_(e.o.x)&&(a=e.iX),null!==ZC._n_(e.o.y)&&(l=e.iY),a+=e.BM,l+=e.BH,[ZC._i_(a),ZC._i_(l)]},GW:function(){var e,i,t=this,n=t.b(),a=t.C.K+"-value-box "+t.C.K+"-plot-"+t.A.L+"-value-box zc-value-box",l=t.H.usc()?t.H.mc("top"):t.C.AJ["3d"]||t.H.K9?ZC.AK(t.C.K+"-plots-vb-c"):ZC.AK(t.C.K+"-plot-"+t.A.L+"-vb-c"),o=t.H.usc()?ZC.AK(t.C.A.K+"-top"):ZC.AK(t.C.A.K+"-text");if(null!==ZC._n_(n.o.joined)){if(0===t.A.L&&!t.C.E["plot1.visible"]||1===t.A.L&&!t.C.E["plot2.visible"]||2===t.A.L&&!t.C.E["plot0.visible"])return;t.A.L<t.A.A.A4.length-1?t.A.A.A4[t.A.L+1]:t.A.A.A4[0],e=t.A.A.DW[t.A.L][t.L].intxy,(i=new ZC.DN(t)).copy(n),i.o.text=""+t.WP,i.append(n.o.joined),i.JV=function(e){return t.JV(e,{})},i.parse(),i.GL=a,i.K=t.K+"-value-box-join",i.Z=n.C7=l,i.IL=o,i.iX=e[0]-i.I/2,i.iY=e[1]-i.F/2,i.AN&&(i.paint(),i.EK())}if(null!==ZC._n_(n.o.shared)&&2===t.A.L){if(!t.C.E["plot0.visible"]||!t.C.E["plot1.visible"]||!t.C.E["plot2.visible"])return;e=t.A.A.X9[t.L].xy,(i=new ZC.DN(t)).copy(n),i.o.text=""+t.A.A.HE[t.A.L],i.append(n.o.shared),i.JV=function(e){return t.JV(e,{})},i.parse(),i.GL=a,i.K=t.K+"-value-box-shared",i.Z=n.C7=l,i.IL=o,i.iX=e[0]-i.I/2,i.iY=e[1]-i.F/2,i.AN&&(i.paint(),i.EK())}},ABF:function(){return{color:this.B7}},Y4:function(){return{"background-color":this.BW,"border-color":this.BW,color:this.C2}},paint:function(){var e,i=this;if(i.A.L>=3)i.A.U&&i.GW();else{i.b();var t=i.N=i.A.ID(i,i),n=new ZC.DT(i.A);n.K=i.K,n.Z=i.A.CP("bl",1),n.C7=i.A.CP("bl",0),n.copy(t);var a=i.iX,l=i.iY;if(n.iX=a,n.iY=l,n.AI=i.AI,n.DU="circle",n.E.plotidx=i.A.L,n.E.nodeidx=i.L,n.parse(),i.FP=n,i.A.GG&&!i.C.HH){var o=n,r={};o.iX=a,o.iY=l,r.x=a,r.y=l;var s=i.A.L7;if(o.C6=0,r.alpha=t.C6,3===s)o.AI=2,r.size=i.AI;else if(4===s){switch(i.A.L){case 0:o.iX=a-3*i.AI,o.iY=l;break;case 1:o.iX=a+3*i.AI,o.iY=l;break;case 2:o.iX=a,o.iY=l-3*i.AI}r.x=a,r.y=l}for(e in i.A.FV)o[ZC.E4.GN[ZC.EE(e)]]=i.A.FV[e],r[ZC.EE(e)]=t[ZC.E4.GN[ZC.EE(e)]];if(i.C.EN||(i.C.EN={}),null!==ZC._n_(i.C.EN[i.A.L+"-"+i.L]))for(e in i.C.EN[i.A.L+"-"+i.L])o[ZC.E4.GN[ZC.EE(e)]]=i.C.EN[i.A.L+"-"+i.L][e];i.C.EN[i.A.L+"-"+i.L]={},ZC._cp_(r,i.C.EN[i.A.L+"-"+i.L]);var A=new ZC.E4(o,r,i.A.JF,i.A.L6,ZC.E4.RI[i.A.L8],function(){C()});A.AX=i,i.LM(A)}else n.paint(),C()}function C(){var e=i.C.K+"-node-area "+i.C.K+"-plotset-plot-"+i.A.L+"-node-area zc-node-area",t=ZC.Q.G0("circle",i.A.EA,i.A.IV)+'class="'+e+'" '+i.a11y()+' id="'+i.K+'" coords="'+ZC._i_(i.iX+ZC.MAPTX)+","+ZC._i_(i.iY+ZC.MAPTX)+","+ZC._i_(ZC.BQ(ZC.mobile?6:3,i.AI)*(ZC.mobile?2:1.2))+'" />';i.A.A.HE.push(t),i.A.U&&i.GW()}},A0W:function(e){var i=this;ZC.move||i.M5({layer:e,type:"shape",initcb:function(){this.DU="circle",this.A0=i.A.BP[3],this.AE=i.A.BP[3]},setupcb:function(){this.iX=i.iX,this.iY=i.iY,this.AI=i.AI}})}}),ZC.LG.prototype.N6=function(e,i){var t,n,a=this;if(void 0===i&&(i=!1),i)"undefined"!=typeof a.E.pointserror&&((t=new ZC.D0(a)).copy(a.A),a.A.JA&&(t.copy(a.A.JA),t.append(a.A.JA.o["hover-state"])),t.parse(),t.K=a.K+"--error-hover",t.AN&&ZC.CR.paint(e,t,a.E.pointserror));else{var l=a.A.CM,o=a.A.B1;if(0!==a.A.S6.length){var r=null,s=null,A=!0;a.A.S6.length<=2?(null!==ZC._n_(a.A.S6[0])&&a.A.S6[0]instanceof Array&&(A=!1),null!==ZC._n_(a.A.S6[1])&&a.A.S6[1]instanceof Array&&(A=!1)):A=!1,A?(r=a.A.S6[0],s=a.A.S6[1]):null!==ZC._n_(n=a.A.S6[a.L])&&n instanceof Array&&(r=s=n[0],2===n.length&&(s=n[1])),a.E["node-error-plus"]=r,a.E["node-error-minus"]=s,-1!==(r+"").indexOf("%")&&(r=ZC.II(r))<=1&&(r*=a.AD),-1!==(s+"").indexOf("%")&&(s=ZC.II(s))<=1&&(s*=a.AD);var C=[],c=ZC.II(a.A.JA&&a.A.JA.o.size||.5);c<=1&&(c="vbar"===a.A.AF?ZC._i_(c*a.I):"hbar"===a.A.AF?ZC._i_(c*a.F):ZC._i_(c*o.AC));var u,p=0;if(p=o.CO?a.F:a.I,null!==ZC._n_(r)){var Z=l.AT(a.CS+r);o.CO?(u=l.AW?a.AD<0?a.iX+a.I:a.iX:a.AD>0?a.iX+a.I:a.iX,C.push([Z,a.iY+p/2-c/2],[Z,a.iY+p/2+c/2],null,[Z,a.iY+p/2],[u,a.iY+p/2])):(u=l.AW?a.AD>0?a.iY+a.F:a.iY:a.AD<0?a.iY+a.F:a.iY,C.push([a.iX+p/2-c/2,Z],[a.iX+p/2+c/2,Z],null,[a.iX+p/2,Z],[a.iX+p/2,u]))}if(null!==ZC._n_(s)){var h=l.AT(a.CS-s);o.CO?(u=l.AW?a.AD<0?a.iX+a.I:a.iX:a.AD>0?a.iX+a.I:a.iX,C.push(null,[h,a.iY+p/2-c/2],[h,a.iY+p/2+c/2],null,[h,a.iY+p/2],[u,a.iY+p/2])):(u=l.AW?a.AD>0?a.iY+a.F:a.iY:a.AD<0?a.iY+a.F:a.iY,C.push(null,[a.iX+p/2-c/2,h],[a.iX+p/2+c/2,h],null,[a.iX+p/2,h],[a.iX+p/2,u]))}(t=new ZC.D0(a)).copy(a.A),a.A.JA&&t.copy(a.A.JA),t.parse(),t.K=a.K+"--error",t.CZ=!1,ZC.CR.paint(e,t,C),a.E.pointserror=C}}};var F3={$i:function(e){this.b(e);var i=this;i.H=i.A.A,i.BE="",i.V=[],i.BX=[],i.A53=[],i.DJ=!1,i.M=null,i.BR=null,i.IT=null,i.D7=null,i.FR=0,i.I9=null,i.G5=null,i.H6=0,i.P0=null,i.L=1,i.AB=0,i.A46=0,i.BV=0,i.AW=!1,i.CO=!1,i.AC=0,i.iStepMultiplier=1,i.DQ=-1,i.RD=ZC.HJ["thousands-separator"]||"",i.RW=ZC.HJ["decimals-separator"]||".",i.ZX=!1,i.SE=2,i.A33=!1,i.TX="",i.A04="standard",i.CI=null,i.AF="",i.EG=ZC.MAX,i.M0=ZC.MAX,i.GO=!1,i.Y7=!1,i.KN=null,i.NN=null,i.Q4=[],i.E5=1,i.B3=-1,i.BJ=-1,i.SG=-1,i.FW=-1,i.H1=-1,i.C1="lin",i.E6=10,i.FG=null,i.OZ=1,i.PU=!0,i.A0J=!1,i.aAutoFit=[!1,!1],i.LR=null,i.WH=null,i.T9=!1,i.I1=-1,i.YQ=!1,i.BA="default",i.PZ=!1,i.VE=!1,i.R2=1,i.sMaster="",i.bNormalize=!0,i.bAllowDuplicates=!1},parse:function(){this.b();var e,i=this;if(null!==ZC._n_(e=i.o.step))if(ZC.P5(e))i.E5=ZC._f_(e);else{var t=e.replace(/[0-9]/gi,""),n=parseInt(e.replace(/[^0-9]/gi,""),10);switch(n=n||1,t){case"second":i.E5=1e3*n;break;case"minute":i.E5=1e3*n*60;break;case"hour":i.E5=1e3*n*60*60;break;case"day":i.E5=1e3*n*60*60*24;break;case"week":i.E5=1e3*n*60*60*24*7;break;case"month":i.E5=2629743e3*n;break;case"year":i.E5=31556926e3*n}}if(null!==ZC._n_(i.o.multiplier)&&null===ZC._n_(i.o.short)&&(i.o.short=i.o.multiplier),i.assign_a([["labels","BX"],["tooltip-text","A53"],["format","CI"],["offset-start","AB","i"],["offset-start","A46","i"],["offset-end","BV","i"],["minor-ticks","FR","i"],["step-multiplier","iStepMultiplier","i"],["index","L","i"],["mirrored","AW","b"],["zooming","GO","b"],["zoom-snap","Y7","b"],["fixed-step","PZ","b"],["zoom-to","KN"],["force-view","YQ","b"],["zoom-to-values","NN"],["items-overlap","A0J","b"],["used","T9","b"],["max-labels","EG","i"],["max-items","EG","i"],["ref-value","H6","f"],["decimals","DQ","ia"],["decimals-separator","RW"],["thousands-separator","RD"],["short","A33","b"],["short-unit","TX"],["negation","A04"],["exponent","ZX","b"],["exponent-decimals","SE","ia"],["progression","C1"],["log-base","E6","fa"],["scale-factor","OZ","fa"],["show-labels","LR"],["max-decimals","I1","i"],["placement","BA"],["factor","R2","f"],["master","sMaster"],["blended","VE","b"],["ranged","DJ","b"],["normalize","bNormalize","b"],["allow-duplicates","bAllowDuplicates","b"]]),"log"===i.C1&&(null===ZC._n_(i.o["minor-ticks"])&&(i.FR=Math.max(0,i.E6-2)),null!==ZC._n_(i.KN)&&"v"===i.AF&&(i.KN[0]=ZC.G6(i.KN[0],i.E6),i.KN[1]=ZC.G6(i.KN[1],i.E6))),null!==ZC._n_(e=i.o["auto-fit"])&&(e.length?(i.aAutoFit[0]=ZC._b_(e[0]),i.aAutoFit[1]=ZC._b_(e[e.length-1])):i.aAutoFit[0]=i.aAutoFit[1]=ZC._b_(e)),"string"==typeof i.BX){var a=i.BX.split(":"),l=1;3===a.length&&(l=ZC._f_(a[2])),i.BX=[];for(var o=ZC._f_(a[0]);o<ZC._f_(a[1]);o+=l)i.BX.push(""+o);i.BX.push(""+a[1])}null!==ZC._n_(i.o["fixed-items"])&&(i.EG=ZC.MAX),i.EG=ZC.BQ(i.EG,2),null!==ZC._n_(e=i.o.offset)&&(i.AB=i.BV=ZC._i_(e),0!==ZC._i_(e)||"mixed"!==i.A.AF&&"mixed3d"!==i.A.AF||(i.DJ=!1)),null!==ZC._n_(e=i.o["max-ticks"])?i.M0=ZC._i_(e):i.M0=i.EG,i.M0=ZC.BQ(2,i.M0),null!==ZC._n_(e=i.o.transform)&&(i.FG=new ZC.D0,i.FG.append(e));var r=i.A.A.B8,s="("+i.A.AF+")",A=i.BE.replace(/\-[0-9]/,""),C=i.BE.replace(/\-[0-9]/,"-n");function c(e){var t=[s+".SCALE."+e,s+"."+i.BE+"."+e,s+"."+A+"."+e,s+"."+A+"["+i.BA+"]."+e,s+"."+C+"."+e];return i.A.AJ["3d"]&&(t=t.concat([s+".SCALE[3d]."+e,s+"."+i.BE+"[3d]."+e,s+"."+A+"[3d]."+e,s+"."+C+"[3d]."+e])),t}if(null===ZC._n_(i.o.placement)&&i.L>1&&(i.BA="opposite"),null!==ZC._n_(e=i.o.markers))for(var u=0,p=e.length;u<p;u++){var Z=new ZC.A0F(i);Z.L=u,Z.K=i.K+"-marker-"+u,r.load(Z.o,c("marker")),Z.append(e[u]),Z.parse(),i.Q4.push(Z)}i.P0=new ZC.D0(i),r.load(i.P0.o,c("ref-line")),i.P0.append(i.o["ref-line"]),"k"===i.AF&&(i.P0.AN=!1),i.P0.parse(),i.M=new ZC.DN(i),r.load(i.M.o,c("label")),i.M.append(i.o.label),i.M.K=i.K+"-label",i.M.parse(),i.BR=new ZC.DN(i),r.load(i.BR.o,c("item")),i.BR.append(i.o.item),i.BR.K=i.K+"-item",i.BR.parse(),i.IT=new ZC.D0(i),r.load(i.IT.o,c("tick")),i.IT.append(i.o.tick),i.IT.parse(),i.D7=new ZC.D0(i),r.load(i.D7.o,c("guide")),i.D7.append(i.o.guide),i.D7.parse(),null===ZC._n_(i.D7.o.items)&&"-1"!==i.D7.A0&&"-1"!==i.D7.AE&&i.D7.A0!==i.D7.AE&&(i.D7.o.items=[{alpha:i.D7.C6,"background-color":i.D7.A0},{alpha:i.D7.C6,"background-color":i.D7.AE}]),i.I9=new ZC.D0(i),r.load(i.I9.o,c("minor-tick")),i.I9.append(i.o["minor-tick"]),i.I9.parse(),i.G5=new ZC.D0(i),r.load(i.G5.o,c("minor-guide")),i.G5.append(i.o["minor-guide"]),i.G5.parse(),i.A51()},A51:function(){var e,i=this,t={x:"iX",y:"iY",width:"I",height:"F"};for(var n in t){var a=i.A.P[t[n]];null!==ZC._n_(i.o[n])&&(a=ZC.II(i.o[n]))>=0&&a<=1&&(a="x"===n||"y"===n?i.A.P["x"===n?"iX":"iY"]+ZC._i_(a*i.A.P["x"===n?"I":"F"]):ZC._i_(a*i.A.P[t[n]])),i[t[n]]=a}null!==ZC._n_(e=i.o.offset)&&(i.AB=i.BV=ZC._f_(ZC._p_(e))),null!==ZC._n_(e=i.o["offset-start"])&&(i.AB=ZC._f_(ZC._p_(e))),null!==ZC._n_(e=i.o["offset-end"])&&(i.BV=ZC._f_(ZC._p_(e)));var l="k"===i.AF&&!i.CO||"v"===i.AF&&i.CO?i.I:i.F;i.AB<1&&(i.AB*=l),i.BV<1&&(i.BV*=l)},YM:function(e){var i=this;null!==ZC._n_(i.o.rules)&&(i.WH||(i.WH=new ZC.F3(i.A)),i.WH.append(i.o),i.WH.parse(),i.WH.J2=e,i.WH.DE()&&(i.WH.parse(),i.DQ=i.WH.DQ,i.CI=i.WH.CI))},J1:function(){},A7U:function(){},AC9:function(){},A96:function(){},clear:function(){},build:function(){},MP:function(){var e,i=this,t={negation:i.A04,"thousands-separator":i.RD,"decimals-separator":i.RW,decimals:i.DQ,"max-decimals":i.I1,short:i.A33,"short-unit":i.TX,exponent:i.ZX,"exponent-decimals":i.SE};if(i.FG)switch(i.FG.o.type){case"date":t["transform-date"]=!0,null!==ZC._n_(e=i.FG.o.text)&&(i.FG.o.all=e);var n=i.V[i.A1]-i.V[i.W],a="",l="",o={},r=["msecond","second","minute","hour","day","month","year"];for(var s in r)o[r[s]]=ZC.HJ["date-formats"][r[s]];l=0<=n&&n<=1e3?"msecond":1e3<n&&n<=36e5?"second":36e5<n&&n<=864e5?"minute":864e5<n&&n<=26784e5?"hour":26784e5<n&&n<=316224e5?"day":316224e5<n&&n<=632448e6?"month":"year",a=null!==ZC._n_(i.FG.o[l])?i.FG.o[l]:null!==ZC._n_(i.FG.o.all)?i.FG.o.all:o[l],i.E.dateformat=a,t["transform-date-format"]=i.E.dateformat}return t},A0E:function(){for(var e=this,i=e.A.AY.A4,t=-1,n=0,a=i.length;n<a;n++){var l=i[n].BU(e.AF);if(-1!==ZC.AV(l,e.BE)){switch(i[n].AF){case"pie":case"pie3d":case"nestedpie":case"vbar":case"vbar3d":case"hbar":case"hbar3d":case"vbullet":case"hbullet":case"area":case"area3d":case"gauge":case"vfunnel":case"hfunnel":case"venn":t=i[n].A0;break;case"scatter":case"bubble":t=-1!==i[n].A2.A0?i[n].A2.A0:i[n].A0;break;default:t=i[n].B7}break}}return t},paint:function(){var e=this;e.build(),e.A.AJ["3d"]||e.b()},MX:function(e,i,t,n){var a=this;if(null===ZC._n_(n)&&(n=5),a.A.AJ["3d"]){var l=new ZC.CE(a.A,e.iX+e.I/2-ZC.AO.E2,e.iY+e.F/2-ZC.AO.E3,0+e.AA8);e.iX=l.ED[0]-e.I/2+("v"===t?"default"===a.BA?-n:n:0),e.iY=l.ED[1]-e.F/2+("h"===t?"default"===a.BA?n:-n:0);var o=ZC.DI.A2T(a.A,e);null===ZC._n_(i)&&(i=e.A9,e.A9%90==0&&(i+=e.V9?0:o)),e.A9=i}return i},X3:function(e,i,t){var n=this,a=(t.items,t.lcoords),l=t.lstep,o=t.tdim,r=t.mdim,s=t.dim,A=t.html,C=[e.iX+e.BM,e.iY+e.BH,e.I,e.F],c=ZC._a_(e.A9%180),u=!1;c%360!=0&&(u=!0),u&&(C=[e.iX+e.BM+e.I/2-e.F/2,e.iY+e.BH+e.F/2-e.I/2,e.F,e.I]);var p=!0;if(e.AN){if(!n.A0J)if("log"===n.C1||i!==n.W&&i!==n.A1){i%l==0&&(p=!0);for(var Z=0,h=a.length;Z<h;Z++)if(ZC.AQ.XM({x:C[0],y:C[1],width:C[2],height:C[3]},{x:a[Z][0],y:a[Z][1],width:a[Z][2],height:a[Z][3]})){p=!1;break}}else p=!0;p&&(a.push(C),e.paint(),0,r=ZC.BQ(r,1.5*e.DG*(e.AM||"").split("<br>").length),"h"===s?(o+=e.F,r=ZC.BQ(r,ZC._a_(ZC.EP(c))*ZC.BQ(e.I,e.F))):"w"===s&&(o+=e.I,r=ZC.BQ(r,ZC._a_(ZC.EH(c))*ZC.BQ(e.I,e.F))),e.EK(),null===ZC._n_(n.o.tooltip)&&e.K9||(null!==ZC._n_(n.o.tooltip)&&(n.o.tooltip.text=n.o.tooltip.text||"%scale-value"),A.push(ZC.AP.O5(n.A.K,e))))}return{tdim:o,mdim:r,overlaps:!p}},VG:function(e,i){var t=this;if("v"===t.AF&&(t.H6!==t.B3&&t.H6!==t.BJ||(null===ZC._n_(t.o["ref-line"])||null!==ZC._n_(t.o["ref-line"])&&null===ZC._n_(t.o["ref-line"].visible))&&(t.P0.AN=!1)),t.P0.K=t.K+"-ref-line",t.V.length>0&&t.P0.AN&&!t.A.AJ["3d"]&&t.P0.AZ>0){"inherit"===t.P0.o["line-color"]&&-1!==i&&(t.P0.B7=i);var n=t.H6;if("k"===t.AF&&!t.CO||"v"===t.AF&&t.CO){var a=t.AT(n);a>=t.iX&&a<=t.iX+t.I&&ZC.CR.paint(e,t.P0,[[a,t.iY],[a,t.iY+t.F]])}else{var l=t.AT(n);l>=t.iY&&l<=t.iY+t.F&&ZC.CR.paint(e,t.P0,[[t.iX,l],[t.iX+t.I,l]])}}},paint_:function(){},XL:function(){for(var e=this,i=0,t=e.Q4.length;i<t;i++)e.V.length>0&&e.Q4[i].paint()},gc:function(){ZC.AP.gc(this,["V","BX","Z","C7","D7","BR","M","G5","I9","P0","IT","J2","o","I6","J9","A","H"])}};ZC.F3=ZC.HL.CA(F3);var ZI={$i:function(e){this.b(e);var i=this;i.EF=!1,i.AF="k",i.DC=-1,i.DX=-1,i.W=-1,i.A1=-1,i.V7=1,i.DQ=null,i.OK=0,i.A5E=!1,i.O1=!1,i.U9={},i.IQ=[],i.iMinOffset=0},zoomTo:function(e,i){var t=this;if(t.GO){null!==ZC._n_(e)?t.W=e:t.W=t.DC,null!==ZC._n_(i)?t.A1=i:t.A1=t.DX;var n=t.IQ;if(n.length>0?(t.B3=ZC.AV(n,t.V[t.W]),t.BJ=ZC.AV(n,t.V[t.A1])):(t.B3=t.V[t.W],t.BJ=t.V[t.A1]),t.H.H2.C||(t.H.H2.C=t.A),t.A.H2&&null!==ZC._n_(t.A.H2.o.shared)&&ZC._b_(t.A.H2.o.shared)&&t.A.K===t.H.H2.C.K)for(var a=0,l=t.H.AG.length;a<l;a++){var o=t.H.AG[a];if(o.K!==t.A.K&&null!==ZC._n_(o.H2.o.shared)&&ZC._b_(o.H2.o.shared)){var r=o.BL(t.BE);r&&r.GO&&(e=Math.max(r.DC,Math.min(r.DX,t.W)),i=Math.max(r.DC,Math.min(r.DX,t.A1)),r.zoomTo(e,i),ZC.AK(o.K)&&(o.clear(!0),o.E["shared-zoom"]=!0,o.paint(),o.B9&&o.B9.update(e,i,null,null,!0)))}}t.J1()}},zoomToV:function(e,i){var t=this;null!==ZC._n_(e)?t.B3=e:t.B3=t.FW,null!==ZC._n_(i)?t.BJ=i:t.BJ=t.H1,t.RQ(t.B3,t.BJ,null===ZC._n_(e)&&null===ZC._n_(i))},FQ:function(L,J,ER,bKeep,AD){var s=this,CU="";J?(CU=J.S[L].BT,s.FG&&"date"===s.FG.o.type||"number"==typeof CU||(null!==ZC._n_(s.BX[CU])?CU=s.BX[CU]:null!==ZC._n_(s.V[CU])&&(CU=s.V[CU]))):CU="log"===s.C1&&bKeep?L+1:null!==ZC._n_(s.BX[L])?s.BX[L]:s.V[L],"number"==typeof CU&&null!==ZC._n_(s.IQ[CU])&&(CU=s.IQ[CU]),null!==ZC._n_(AD)&&(CU=AD);var OO=ZC.P5(CU)&&ZC._f_(CU)<0,BC=s.MP();if(ZC._cp_(ER,BC),OO&&"currency"===BC.negation&&(CU=ZC._a_(ZC._f_(CU))),BC.utc=s.A.UL,BC.timezone=s.A.NB,CU=ZC.AP.G2(CU,BC,s,!0),s.CI)if("()"===s.CI.substring(s.CI.length-2)||"javascript:"===s.CI.substring(0,11))try{var EC=s.CI.replace("javascript:","").replace("()","");eval(EC)&&(CU=eval(EC).call(s,CU))}catch(e){}else CU=OO&&"currency"===BC.negation?"-"+s.CI.replace(/%v|%scale-value/g,CU):s.CI.replace(/%v|%scale-value/g,CU);return CU},JV:function(e,i,t,n,a){var l=this,o=l.FQ(i,t,n,a),r=[];r.push(["%scale-label",o],["%scale-index",i],["%scale-position",i]),l.FG&&"date"===l.FG.o.type?r.push(["%scale-value",o],["%v",o]):"log"===l.C1&&a?r.push(["%scale-value",Math.pow(l.E6,i)],["%v",Math.pow(l.E6,i)]):r.push(["%scale-value",ZC._c_(l.V[i],"")],["%v",ZC._c_(l.V[i],"")]),r.push(["%l",o],["%t",o],["%i",i],["%c",i]),r.sort(ZC.A1H);for(var s=0,A=r.length;s<A;s++){var C=new RegExp(r[s][0],"g");e=e.replace(C,r[s][1])}return e},A7U:function(){var e=this,i=ZC.BQ(e.V.length,e.BX.length),t=0;if(i>0&&e.BR.A9%180==0){for(var n=ZC.BQ(1,ZC._i_(i/20)),a=0,l=0;l<i;l+=n){for(var o=((e.BX[l]||e.V[l])+"").split(/<br>|<br\/>|<br \/>|\n/),r=0,s=0,A=o.length;s<A;s++)r=ZC.BQ(r,11*o[s].replace(/<.+?>/gi,"").replace(/<\/.+?>/gi,"").length);t+=r,a++}t=.75*t/Math.max(1,a)}else t=15;e.CO?e.EG=ZC._i_((e.F-e.AB-e.BV)/15):e.EG=ZC._i_((e.I-e.AB-e.BV)/t),e.EG=ZC.CY(e.EG,20),(e.BJ-e.B3)/e.E5+1<e.EG?e.EG=ZC.BQ(e.EG,ZC._i_((e.BJ-e.B3)/e.E5)+1):(e.BJ-e.B3)/(2*e.E5)+1<e.EG&&(e.EG=ZC.BQ(e.EG,ZC._i_((e.BJ-e.B3)/(2*e.E5))+1)),e.EG=ZC.BQ(2,e.EG)},AC9:function(){var e=this;null===ZC._n_(e.o["max-ticks"])&&(e.M0=e.EG)},A96:function(e){var i,t,n,a,l,o=this;if(1===e&&o.o.transform&&"date"===o.o.transform.type&&(null===ZC._n_(o.o.transform.uniform)||ZC._b_(o.o.transform.uniform)||(o.O1=!0)),1===e&&null!==ZC._n_(o.o.values))if(o.V=[],"object"==typeof o.o.values)for(o.V=o.o.values,0===o.BX.length&&(o.BX=o.V),n=0,a=o.V.length;n<a;n++)"string"==typeof o.V[n]&&(o.A5E=!0,o.IQ.push(o.V[n]));else{var r=o.o.values.split(":"),s=o.E5;if(3===r.length&&(s=ZC._f_(r[2])),o.E5=o.SG=s,ZC._f_(r[0])>ZC._f_(r[1])){var A=r[0];r[0]=r[1],r[1]=A}if(s<=0&&(s=1),r.length>1){for(var C=0,c=0,u=0,p=(""+s).split("."),Z=ZC._f_(r[0]);Z<=ZC._f_(r[1]);Z+=s){var h=(""+Z).split(".");p.length>1&&h.length>1&&p[1].length>0&&h[1].length>=9&&ZC._a_(h[1].length-p[1].length)>2?(C+=p[1].length,c=ZC.BQ(c,p[1].length),u++,null!==(l=ZC._n_(o.o.decimals))?o.V.push(ZC._f_(Number(Z).toFixed(ZC._i_(l)))):o.V.push(ZC._f_(ZC._fixed_(Number(Z),p[1].length))),Z=ZC._f_(ZC._fixed_(Number(Z),p[1].length))):(C+=h[1]?h[1].length:0,c=ZC.BQ(c,h[1]?h[1].length:0),u++,null!==(l=ZC._n_(o.o.decimals))?o.V.push(ZC._f_(Number(Z).toFixed(ZC._i_(l)))):o.V.push(Z))}null===ZC._n_(o.o.decimals)&&(C=Math.ceil(C/u),o.DQ=ZC._a_(c-C)<=1?c:C)}}if(2===e){var d=0,f=[];0===o.V.length?(i=ZC.MAX,t=-ZC.MAX):(i=o.V[0],t=o.V[o.V.length-1]);var _,g,v=o.A.AY.A4,b=!1;for(n=0,a=v.length;n<a;n++){var B=v[n].BU();if(-1!==ZC.AV(B,o.BE)){for(var m=0===f.length,E=0,D=v[n].S.length;E<D;E++)if(v[n].S[E])if(null!==v[n].S[E].BT){var K=v[n].S[E].BT;i=ZC.CY(i,K),t=ZC.BQ(t,K),o.O1&&m&&f.push(K),o.EF=!0,v[n].EF=!0}else b=!0;else o.O1&&m&&f.push("");v[n].EF||(d=ZC.BQ(d,v[n].S.length))}}if(null!==ZC._n_(o.o.values))for(n=0;n<o.V.length;n++)null===o.V[n]&&(o.V[n]="");if(null!==ZC._n_(o.o.labels))for(n=0;n<o.BX.length;n++)null===o.BX[n]&&(o.BX[n]="");if(d>o.V.length&&o.V.length>0&&!o.EF)for(n=o.V.length;n<d;n++);var F=0;for(n=0;n<v.length;n++)v[n].LP&&(-1===v[n].R4&&(v[n].R4=F),F++,o.DJ=!0);if(0===o.V.length)for(n=0;n<F;n++)o.V.push(n),o.BX.push(n);if(0===o.V.length)if(o.EF)b&&i>0&&(i=0),b&&t<d-1&&(t=d-1),null!==ZC._n_(o.o["min-value"])&&(i=ZC._f_(o.o["min-value"])),null!==ZC._n_(o.o["max-value"])&&(t=ZC._f_(o.o["max-value"])),t-i<o.E5&&t-i>0&&(o.E5=Math.pow(10,Math.floor(ZC.G6(t-i)/Math.LN10))),o.O1||o.RQ(i,t,!0),0===i&&0===t&&"0,1"===o.V.join(",")&&(o.V=[0]);else if(null!==ZC._n_(o.o["max-value"])){_=0,g=0,null!==ZC._n_(o.o["min-value"])&&(_=ZC._f_(o.o["min-value"])),g=ZC._f_(o.o["max-value"]),n=0;var x=_;if(o.FG&&null!==ZC._n_(o.FG.o.type))switch(o.FG.o.type){case"date":o.E5=o.A1X(_,g)}else(g-_)/o.E5>1e4&&(o.E5=Math.pow(10,ZC.BQ(1,ZC._i_(ZC.G6(ZC._a_(g-_),10)-4))));for(;x<g;)x=o.A.A2P(n*o.E5+_),null===ZC._n_(o.V[n])&&(o.V[n]=x),n++}else if(g=(_=null!==ZC._n_(o.o["min-value"])?ZC._f_(o.o["min-value"]):0)+(d-1)*o.E5,"log"===o.C1)o.RQ(_,g,!0);else for(n=0;n<d;n++)null===ZC._n_(o.V[n])&&(o.V[n]=o.A.A2P(n*o.E5+_));o.O1&&o.EF&&(o.V=[].concat(f),o.BX=[].concat(f))}if(o.O1)for(o.U9={},n=0,a=o.BX.length;n<a;n++)o.U9[o.BX[n]]=n;if(o.W=0,o.A1=o.V.length-1,o.DC=0,o.DX=o.V.length-1,o.IQ.length>0?(o.B3=o.W,o.BJ=o.A1):(o.B3=ZC._f_(o.V[o.W]),o.BJ=ZC._f_(o.V[o.A1])),o.NN){-1===ZC.AV(o.V,o.NN[0])&&ZC.P5(o.NN[0])&&null!==ZC._n_(o.V[0])&&-1!==o.SG&&(o.NN[0]=o.V[0]+o.SG*Math.floor((o.NN[0]-o.V[0])/o.SG)),-1===ZC.AV(o.V,o.NN[1])&&ZC.P5(o.NN[1])&&null!==ZC._n_(o.V[0])&&-1!==o.SG&&(o.NN[1]=o.V[0]+o.SG*Math.ceil((o.NN[1]-o.V[0])/o.SG));var I=ZC.AV(o.V,o.NN[0]),y=ZC.AV(o.V,o.NN[1]);o.KN=[-1===I?0:I,-1===y?o.V.length-1:y]}o.KN&&-1!==o.W&&-1!==o.A1&&((o.KN[0]>o.A1||o.KN[0]<o.W)&&(o.KN[0]=o.W),(o.KN[1]>o.A1||o.KN[1]<o.W)&&(o.KN[1]=o.A1));var w=o.H.E["graph"+o.A.L+".zoom"];if(null===ZC._n_(o.H.E.preservezoom)||o.H.E.preservezoom){var Y=1===o.L?"":"-"+o.L;void 0!==w&&null!==ZC._n_(w["xmin"+Y])&&null!==ZC._n_(w["xmax"+Y])&&(o.KN=[w["xmin"+Y],w["xmax"+Y]])}else o.H.E["graph"+o.A.L+".zoom"]={};o.KN&&(o.A.A17=!0)},RQ:function(e,i,t){var n,a,l,o,r=this,s=!1,A=null!==ZC._n_(r.o.step)&&-1!==(""+r.o.step).indexOf("month");if(r.FG&&null!==ZC._n_(r.FG.o.type))switch(r.FG.o.type){case"date":var C=r.A1X(e,i);(i-e)%C!=0&&(A||(i+=C-(i-e)%C)),n=[e,i,C,1,C],s=!0}else if("log"===r.C1)n=[e,i,1,1,1];else{var c=null!==ZC._n_(r.o.step)||null!==ZC._n_(r.o["min-value"])||null!==ZC._n_(r.o["max-value"]);n=e!==i?ZC.AQ.VS(e,i,r.E5,r.OZ,c):[e,i,r.E5,1,r.E5]}-1===r.SG&&(r.SG=n[4]);var u=n[0],p=n[1];o=n[2],t&&"log"===r.C1&&(u=Math.floor(ZC.G6(u,r.E6)),p=Math.ceil(ZC.G6(p,r.E6))),null===ZC._n_(r.o.step)&&(p-u)/o>1e4&&(o=(p-u)/1e4,l=Math.ceil(ZC.G6(o)/Math.LN10),o=Math.pow(10,l)),null===ZC._n_(r.o["min-value"])&&u!==p&&(s&&A||(u-=u%o)),null===ZC._n_(r.o["max-value"])&&u!==p&&(s&&A||(p=p-p%o+(p%o==0?0:o))),l=Math.floor(ZC.G6(o)/Math.LN10);var Z,h=n[3];if(l<h&&l<0&&(h=l),"log"===r.C1&&(h=ZC.BQ(1,h)),r.V=[],s&&A){var d=ZC.AP.Y5(u,"%Y-%n-%d-%H-%i-%s",!1,0).split("-"),f=new Date(u).getTimezoneOffset(),_=!0,g=ZC._i_((""+r.o.step).replace("month",""));0===g&&(g=1);var v=ZC._i_(d[1]),b=ZC._i_(d[0]);for(r.V.push(u);_&&u!==p;){_=!1;var B=ZC._i_(d[2]);v+g>=12&&b++,v=(v+g)%12,(31===B&&(3===v||5===v||8===v||10===v)||B>28&&1===v)&&(B=1===v?b%4==0&&b%100!=0||b%400==0?29:28:30);var m=new Date(b,v,B,ZC._i_(d[3]),ZC._i_(d[4]),ZC._i_(d[5])),E=m.getTimezoneOffset(),D=m.getTime()+6e4*(f-E);r.V.push(D),D<p&&D<=i&&(_=!0)}}else if(t){r.FW=e,r.H1=i,r.V7=ZC._i_((p-u)/o);var K=(""+o).split("."),F=new String(K[1]||"0").length;for((p-u)%o!=0&&(p-=(p-u)%o)<i&&(p=p-(p-u)%o+o),a=u;a<=p+1e-4;a+=o){var x,I;Z=a;var y=r.DQ;if("log"===r.C1)for(var w=!0;w;)w=!1,I=x=Math.pow(r.E6,Z),x=ZC._f_(ZC._fixed_(x,y)),I<1&&I!==x&&ZC.BQ(I,x)/ZC.CY(I,x)>1.005&&(w=!0,++y>ZC.CY(20,-1===r.I1?99:r.I1)&&(w=!1));else x=null!==y?ZC._f_(ZC._fixed_(Z,Math.max(y,F))):ZC._f_(ZC._fixed_(Z,F));r.V.push(x)}}else for(o=ZC._f_((i-e)/r.V7),a=0;a<=r.V7;a++)Z=e+o*a,h<0&&(Z=ZC._f_(Z.toFixed(-h))),r.V.push(Z);r.W=0,r.A1=r.V.length-1,r.DC=0,r.DX=r.V.length-1,r.B3=ZC._f_(r.V[r.W]),r.BJ=ZC._f_(r.V[r.A1])},A1X:function(e,i,t){void 0===t&&(t=!1);var n=i-e,a=Math.floor(ZC.G6(n)/Math.LN10);return null===ZC._n_(this.o.step)||t?a<=3?1:4===a?1e3:5===a?1e4:6===a?2e4:7===a?3e4:8===a?6e4:9===a?6e5:10===a?12e5:11===a?18e5:36e5:this.E5},parse:function(){this.b()},clear:function(){this.b()},build:function(){this.b()},paint:function(){this.b(),null!==ZC._n_(this.o.values)&&(this.T9=!0)}};ZC.ZI=ZC.F3.CA(ZI);var VQ={$i:function(e){this.b(e);var i=this;i.AF="v",i.W=-1,i.A1=-1,i.V7=0,i.DQ=null,i.KQ="normal",i.JK=[],i.bExtendMinValue=!0,i.bExtendMaxValue=!0},zoomTo:function(e,i){var t,n,a=this;if(a.GO){null!==ZC._n_(e)?a.B3=e:a.B3=a.FW,null!==ZC._n_(i)?a.BJ=i:a.BJ=a.H1,("piano"===a.A.AF||a.PZ)&&(a.B3=ZC._i_(a.B3),a.BJ=ZC._i_(a.BJ)),a.RQ(a.B3,a.BJ,!1);var l=a.A.BU("v");for(t=0;t<l.length;t++)l[t].BE!==a.BE&&l[t].sMaster===a.BE&&l[t].zoomTo(e,i);if(""===a.sMaster){if(a.H.H2.C||(a.H.H2.C=a.A),a.A.H2&&null!==ZC._n_(a.A.H2.o.shared)&&ZC._b_(a.A.H2.o.shared)&&a.A.K===a.H.H2.C.K)for(t=0,n=a.H.AG.length;t<n;t++){var o=a.H.AG[t];if(o.K!==a.A.K&&null!==ZC._n_(o.H2.o.shared)&&ZC._b_(o.H2.o.shared)){var r=o.BL(a.BE);r&&r.GO&&(e=Math.max(r.FW,Math.min(r.H1,a.B3)),i=Math.max(r.FW,Math.min(r.H1,a.BJ)),r.zoomTo(e,i),ZC.AK(o.K)&&(o.clear(!0),o.E["shared-zoom"]=!0,o.paint(),o.B9&&o.B9.update(null,null,e,i,!0)))}}a.J1()}}},FQ:function(L,CU,ER){var s=this;void 0===CU&&(CU="",CU=null!==ZC._n_(s.BX[L])?s.BX[L]:s.V[L]),"number"==typeof CU&&null!==ZC._n_(s.JK[CU])&&(CU=s.JK[CU]);var OO=ZC.P5(CU)&&ZC._f_(CU)<0,BC=s.MP();if(ZC._cp_(ER,BC),null!==ZC._n_(s.E["max-power"])&&(BC["max-power"]=s.E["max-power"]),OO&&"currency"===BC.negation&&(CU=ZC._a_(ZC._f_(CU))),BC.utc=s.A.UL,BC.timezone=s.A.NB,CU=ZC.AP.G2(CU,BC,s,!0),s.CI)if("()"===s.CI.substring(s.CI.length-2)||"javascript:"===s.CI.substring(0,11))try{var EC=s.CI.replace("javascript:","").replace("()","");eval(EC)&&(CU=eval(EC).call(s,CU))}catch(e){}else CU=OO&&"currency"===BC.negation?"-"+s.CI.replace(/%v|%scale-value/g,CU):s.CI.replace(/%v|%scale-value/g,CU);return CU},A7U:function(){var e=this,i=ZC.BQ(e.V.length,e.BX.length);if(0===i&&(i=10),"log"===e.C1)e.EG=999;else{var t=Math.max(15,10*ZC.BQ(e.V.join("").length,e.BX.join("").length)/i);e.CO?e.EG=ZC._i_((e.I-e.AB-e.BV)/t):e.EG=ZC._i_((e.F-e.AB-e.BV)/10),e.EG=ZC.CY(e.EG,10),e.EG=ZC.BQ(2,e.EG)}},AC9:function(){var e=this;null===ZC._n_(e.o["max-ticks"])&&(e.M0=e.EG)},A96:function(e){var i,t,n,a,l,o,r,s=this;if(""!==s.sMaster&&2===e){var A=s.A.BL(s.sMaster);if(A)return s.B3=A.B3,s.FW=A.FW,s.BJ=A.BJ,s.H1=A.H1,s.E5=A.E5,s.SG=A.SG,s.W=A.W,s.A1=A.A1,s.DC=A.DC,s.DX=A.DX,s.V=[].concat(A.V),void(s.BX=[].concat(A.BX))}1===e&&null===ZC._n_(s.o.values)&&null!==ZC._n_(i=s.A.ABG("v"))&&(s.o.values=i);var C,c=0,u=s.JK;if(1===e&&null!==ZC._n_(s.o.values)){if(s.V=[],"object"==typeof s.o.values){var p=s.o.values,Z=ZC.XY(p),h=ZC.A1L(p),d=!0;for(t=0,n=p.length-2;t<n;t++)if("number"==typeof p[t+2]&&"number"==typeof p[t+1]&&"number"==typeof p[t]&&ZC._f_(p[t+2])-ZC._f_(p[t+1])!=ZC._f_(p[t+1])-ZC._f_(p[t])){d=!1;break}if(!d&&(s.o.values=Z+":"+h,!s.LR))for(s.LR=[],t=0,n=p.length;t<n;t++)s.LR.push(""+p[t])}if("object"==typeof s.o.values){for(ZC._cpa_(s.o.values,s.V),0===s.BX.length&&ZC._cpa_(s.BX,s.V),t=0,n=s.V.length;t<n;t++)if("string"==typeof s.V[t]){var f=s.V[t],_=ZC.AV(u,s.V[t]);-1===_||s.bAllowDuplicates?(u.push(s.V[t]),s.V[t]=u.length-1):s.V[t]=_,null===ZC._n_(s.BX[t])&&(s.BX[t]=f)}}else{var g=s.o.values.split(":");if(r=1,3===g.length&&(r=ZC._f_(g[2])),ZC._f_(g[0])>ZC._f_(g[1])){var v=g[0];g[0]=g[1],g[1]=v}if(r<=0&&(r=1),null!==ZC._n_(s.o["fixed-items"])&&(r=(ZC._f_(g[1])-ZC._f_(g[0]))/ZC.BQ(1,ZC._i_(s.o["fixed-items"])-1),s.V7=ZC.BQ(1,ZC._i_(s.o["fixed-items"])-1)),g.length>1){for(var b=0,B=0,m=0,E=(""+r).split("."),D=ZC._f_(g[0]);D<=ZC._f_(g[1]);D+=r)a=(""+D).split("."),E.length>1&&a.length>1&&E[1].length>0&&a[1].length>=9&&ZC._a_(a[1].length-E[1].length)>2?(b+=E[1].length,B=ZC.BQ(B,E[1].length),m++,s.V.push(ZC._f_(ZC._fixed_(Number(D),E[1].length)))):(b+=ZC._i_(a[1]?a[1].length:0),B=ZC.BQ(B,a[1]?a[1].length:0),m++,s.V.push(D));D-ZC._f_(g[1])!=0&&ZC._a_(D-ZC._f_(g[1]))/r<1e-8&&s.V.push(ZC._f_(g[1])),null===ZC._n_(s.o.decimals)&&(b=(a=(""+r).split("."))[1]?a[1].length:Math.ceil(b/m),s.DQ=ZC._a_(B-b)<=1?B:b)}}s.W=0,s.A1=s.V.length-1,s.E5=r,u.length>1?(c=ZC.XY(s.V,!0),s.B3=ZC.XY(s.V),s.BJ=ZC.A1L(s.V)):(s.B3=s.V[0],s.BJ=s.V[s.V.length-1]),"log"===s.C1&&(0===s.B3&&(C=Math.floor(ZC.G6(c,s.E6)),s.B3=Math.pow(s.E6,Math.min(-1,C))),s.RQ(ZC.G6(s.B3,s.E6),ZC.G6(s.BJ,s.E6),!1))}if(2===e){var K={};null===ZC._n_(s.o.values)&&(s.V=[],l=ZC.MAX,o=-ZC.MAX);var F=[],x=s.A.AY.A4;for(t=0,n=x.length;t<n;t++)if(s.A.E["plot"+t+".visible"]||"hide"===s.A.getToggleAction()){var I=x[t].BU();if(-1!==ZC.AV(I,s.BE))for(var y=-1!==ZC.AV(["vbar","hbar","vbar3d","hbar3d"],x[t].AF),w=[],Y=0,X=x[t].V.length;Y<X;Y++)if(x[t].S[Y]){var M=null===x[t].S[Y].BT?Y:x[t].S[Y].BT;if(x[t].CC&&-1!==ZC.AV(w,M))continue;w.push(M);var L=x[t].LY&&null!==ZC._n_(x[t].LY[Y])?ZC._f_(x[t].LY[Y]):0;if(x[t].CC)null===ZC._n_(K[x[t].DZ])&&(K[x[t].DZ]=[]),null===ZC._n_(K[x[t].DZ][M])?x[t].S[Y].AD>=0||!y?K[x[t].DZ][M]=[x[t].S[Y].AD,0]:K[x[t].DZ][M]=[0,x[t].S[Y].AD]:x[t].S[Y].AD>=0||!y?K[x[t].DZ][M][0]+=x[t].S[Y].AD:K[x[t].DZ][M][1]+=x[t].S[Y].AD,x[t].S[Y].AD>=0||!y?x[t].S[Y].CS=K[x[t].DZ][M][0]:x[t].S[Y].CS=K[x[t].DZ][M][1],null===ZC._n_(s.o.values)&&F.push(K[x[t].DZ][M][0]+L,K[x[t].DZ][M][1]+L);else if(null===ZC._n_(s.o.values)){F.push(x[t].S[Y].AD+L),0!==L&&F.push(L);for(var H=0,P=x[t].S[Y].DP.length;H<P;H++)F.push(x[t].S[Y].DP[H]+L)}}}F.length>0&&(c=ZC.XY(F,!0),l=ZC.XY(F),o=ZC.A1L(F)),0!==s.V.length||l!==Number.MAX_VALUE&&o!==Number.MIN_VALUE||(s.V=[0,1],l=0,o=1),null===ZC._n_(s.o.values)&&(null!==ZC._n_(s.o["min-value"])&&"auto"!==s.o["min-value"]?l=ZC._f_(s.o["min-value"]):l>0&&"auto"!==s.o["min-value"]&&"log"!==s.C1&&(l=0),null!==ZC._n_(s.o["max-value"])&&(o=ZC._f_(s.o["max-value"])),l===ZC.MAX&&o===-ZC.MAX?(s.W=0,s.A1=0,s.B3=0,s.BJ=0):"log"===s.C1?(0===l&&(C=Math.floor(ZC.G6(c,s.E6)),l=Math.pow(s.E6,Math.min(-1,C))),s.RQ(ZC.G6(l,s.E6),ZC.G6(o,s.E6),!1)):s.RQ(l,o,!0))}2===e&&(-1===s.FW&&-1===s.H1&&(s.FW=s.B3,s.H1=s.BJ),-1===s.SG&&(s.SG=s.E5)),"auto"===s.o["min-value"]&&null===ZC._n_(s.o["ref-value"])&&(s.H6=s.B3),0===s.V7&&(s.V7=ZC._i_((s.BJ-s.B3)/s.E5));var N=s.H.E["graph"+s.A.L+".zoom"];if(null===ZC._n_(s.H.E.preservezoom)||s.H.E.preservezoom){var G=1===s.L?"":"-"+s.L;2===e&&void 0!==N&&null!==ZC._n_(N["ymin"+G])&&null!==ZC._n_(N["ymax"+G])&&(ZC.DS(N["ymin"+G],s.B3,s.BJ)||(N["ymin"+G]=s.B3),ZC.DS(N["ymax"+G],s.B3,s.BJ)||(N["ymax"+G]=s.BJ),s.KN=[N["ymin"+G],N["ymax"+G]])}else s.H.E["graph"+s.A.L+".zoom"]={};s.KN&&(s.A.A17=!0)},RQ:function(e,i,t){var n,a,l,o,r=this;"piano"!==r.A.AF&&!r.PZ&&r.JK.length>1&&(e=0),r.TX.length&&null===ZC._n_(r.o["scale-factor"])&&(l=Math.floor(ZC.G6(ZC._a_(i),ZC._f_(r.TX[0]))),r.OZ=Math.pow(ZC._f_(r.TX[0]),l)/Math.pow(1e3,l),r.E["max-power"]=l);var s=(o=r.FG&&"date"===r.FG.o.type?ZC.AQ.VS(e,i,"lin"===r.C1?r.E5:null,r.OZ,r.bNormalize,r.EG):ZC.AQ.VS(e,i,"lin"===r.C1?r.o.step:null,r.OZ,r.bNormalize,r.EG))[0],A=o[1],C=!1;a=Math.floor(o[0]),"log"===r.C1&&(l=Math.ceil(o[1]),o[1]-o[0]>=.5?C=!0:o=ZC.AQ.VS(Math.pow(r.E6,o[0]),Math.pow(r.E6,o[1]),null,r.OZ,r.bNormalize));var c,u,p=o[0],Z=o[1],h=o[2];if(null!==ZC._n_(r.o["fixed-items"])&&(h=(Z-p)/ZC.BQ(1,ZC._i_(r.o["fixed-items"])-1)),r.PZ&&i===e&&(i+h<=r.BJ?i+=h:e-=h),1!==r.R2&&(p*=r.R2,Z*=r.R2,h*=r.R2),null!==ZC._n_(r.E["o-decimals"])?r.DQ=r.E["o-decimals"]:r.E["o-decimals"]=r.DQ,null===ZC._n_(r.o.decimals))if("log"===r.C1&&C)r.DQ=a<0?null:0;else if(r.bNormalize)r.A33||(r.DQ=0);else{var d=ZC.G6(i-e,10);r.DQ=o[3],r.DQ>9&&(d>=1?r.DQ=1:d>0&&d<1&&(r.DQ=2))}var f,_,g,v=!0;if(C){var b,B;a=Math.floor(p),l=Math.ceil(Z),f=Math.pow(r.E6,e),_=Math.pow(r.E6,i),r.V=[];var m=[0,2,5];for(B=[0,1,2,3,4,5,6,7,8,9,10],n=a;n<=l;n++){var E=o[3];if(E=n<0?Math.max(ZC._a_(n),E):0,n===l)for(b=0;b<m.length;b++)g=Math.pow(r.E6,n)+m[b]*Math.pow(r.E6,n-1),g=ZC._f_(g.toFixed(E)),-1===ZC.AV(r.V,g)&&r.V.push(g);for(b=0;b<B.length;b++)g=B[b]*Math.pow(r.E6,n),g=ZC._f_(g.toFixed(E)),-1===ZC.AV(r.V,g)&&r.V.push(g)}r.V.sort(function(e,i){return e-i});for(var D=-1,K=-1,F=0;F<r.V.length-1;F++)r.V[F]<=f&&f<=r.V[F+1]&&(D=F),r.V[F]===_?K=F:r.V[F]<=_&&_<=r.V[F+1]&&(K=F+1);r.V=r.V.slice(D,K+1),0===r.V[0]&&r.V.shift(),s=ZC.G6(r.V[0],r.E6),A=ZC.G6(r.V[r.V.length-1],r.E6)}else{for("log"===r.C1&&(f=Math.pow(r.E6,e),_=Math.pow(r.E6,i));v;){v=!1,r.V=[],c=u=p;do{u=c,u=ZC._f_(u.toFixed(r.DQ)),-1!==ZC.AV(r.V,u)&&(v=!0),"log"===r.C1?u>=p&&u<=Z&&r.V.push(u):r.V.push(u),c+=h,c=ZC._f_(c.toFixed(o[3]))}while(c<=Z);v&&(r.DQ+=1)}"log"===r.C1&&(s=ZC.G6(p,r.E6),A=ZC.G6(Z,r.E6),r.V.push(p),r.V.push(Z),r.V.sort(function(e,i){return e-i}))}r.E5=h,r.W=0,r.A1=r.V.length-1,t?(r.B3=r.bExtendMinValue?s:e,r.BJ=r.bExtendMaxValue?A:i):(r.B3=e,r.BJ=i)},parse:function(){var e=this;e.assign_a([["stack-type","KQ"],["CA-min-value","bExtendMinValue","b"],["CA-max-value","bExtendMaxValue","b"]]),(e.A.CC&&"100%"===e.A.KQ||"100%"===e.KQ)&&null===ZC._n_(e.o.values)&&(e.o.values="0:100:20",e.o.format="%v%"),this.b()},clear:function(){this.b()},build:function(){this.b()},paint:function(){this.b(),null===ZC._n_(this.E.decimals)&&(this.E.decimals=null!==ZC._n_(this.DQ)?this.DQ:-1),null!==ZC._n_(this.o.values)&&(this.T9=!0)}};ZC.VQ=ZC.F3.CA(VQ);var Q6={$i:function(e){this.b(e)},parse:function(){this.b()},J1:function(){var e=this;e.A1===e.W?e.AC=e.I-e.AB-e.BV:e.AC=(e.I-e.AB-e.BV)/(e.A1-e.W+(e.DJ?1:0))},A96:function(e){this.b(e),this.J1()},zoomTo:function(e,i){this.b(e,i);this.J1()},clear:function(){},build:function(){this.b()},NE:function(e){var i,t=this;return i=t.AW?(t.iX+t.I-t.AB-e)/(t.I-t.AB-t.BV):(e-t.iX-t.AB)/(t.I-t.AB-t.BV),t.B3+ZC._f_((t.BJ-t.B3)*i)},OE:function(e,i,t){var n,a,l,o=this;void 0===t&&(t=!1);var r=o.DJ?o.AC:0;l=o.AW?(o.iX+o.I-e-o.AB-r/2)/(o.I-o.AB-o.BV-r):(e-o.iX-o.AB-r/2)/(o.I-o.AB-o.BV-r);var s,A=!1;if(i)for(s in i.K2){A=!0;break}if(i&&!o.O1&&A){var C=o.V[o.W];"string"==typeof C&&(C=ZC.AV(o.IQ,C)),"log"===o.C1&&(C=ZC.G6(C,o.E6));var c=o.V[o.A1];"string"==typeof c&&(c=ZC.AV(o.IQ,c)),"log"===o.C1&&(c=ZC.G6(c,o.E6));var u=C+ZC._f_((c-C)*l);"log"===o.C1&&(u=Math.pow(o.E6,u));var p=ZC.MAX;for(s in a=null,i.K2)(n=Math.abs(s-u))<p&&(p=n,a=i.K2[s]);if(null===ZC._n_(a)&&(a=u),p>i.A2K){var Z=Math.ceil((c-C)/(o.I-o.AB-o.BV));if(i.V.length<2&&(Z*=100),p>Z)return null}return a}var h=o.W,d=o.A1;return o.EF&&(null!==ZC._n_(n=o.V[h])&&(h=n),null!==ZC._n_(n=o.V[d])&&(d=n)),"log"===o.C1&&(h=ZC.G6(h,o.E6),d=ZC.G6(d,o.E6)),a=t?o.DJ?h+(d-h+1)*l:h+(d-h)*l:o.DJ?o.W+(o.A1-o.W+1)*l:o.W+(o.A1-o.W)*l,"log"===o.C1?(a=Math.pow(o.E6,a),a=Math.floor(a)-1):(a=o.DJ?Math.floor(a):ZC._i_(a),a=ZC.BQ(0,a),a=ZC.CY(o.DX,a)),a},IB:function(e){var i=this;i.W,i.A1;return i.EF&&!i.O1&&(i.B3,i.BJ),"log"===i.C1&&(e=ZC.G6(e+1,i.E6)),i.AW?i.iX+i.I-i.AB-(e-i.W+(i.DJ?1:0))*i.AC+(i.DJ?i.AC/2:0):i.iX+i.AB+(e-i.W)*i.AC+(i.DJ?i.AC/2:0)},AT:function(e){var i,t,n,a,l,o=this;if("log"===o.C1&&(0===e&&(e=o.B3),e=ZC.G6(e,o.E6)),o.O1){var r=o.U9[e];return o.IB(r)}if(-1!==(i=ZC.AV(o.IQ,e)))return o.IB(i);if(!o.A5E&&(o.EF||o.FG&&"date"===o.FG.o.type)){a=o.V[o.W],l=o.V[o.A1];var s=o.I;return"log"===o.C1&&(a=ZC.G6(a,o.E6),l=ZC.G6(l,o.E6),o.W===o.DC&&o.A1===o.DX&&(s=(o.A1-o.W)*o.AC)),l===a?t=0:(n=l-a,t=(s-o.AB-o.BV-(o.DJ?o.AC:0))/n),o.AW?o.iX+o.I-o.AB-(e-a)*t-(o.DJ?o.AC/2:0)+o.iMinOffset:o.iX+o.AB+(e-a)*t+(o.DJ?o.AC/2:0)-o.iMinOffset}return a=o.B3,l=o.BJ,"log"===o.C1&&(a=ZC.G6(a,o.E6),l=ZC.G6(l,o.E6)),l===a?t=0:(n=l-a+(o.DJ?1:0),t=(o.I-o.AB-o.BV)/n),o.AW?o.iX+o.I-o.AB-(e-a)*t-(o.DJ?o.AC/2:0):o.iX+o.AB+(e-a)*t+(o.DJ?o.AC/2:0)},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c,u,p,Z,h,d,f=this;f.b(),null!==ZC._n_(f.A.A.E[f.BE+"-feed-offset-start"])&&(f.AB=f.A.A.E[f.BE+"-feed-offset-start"]),"bubble"!==f.A.AF&&"scatter"!==f.A.AF||(-1===f.AB&&-1===f.BV||1===f.V.length)&&(f.AB=f.BV=f.I/(f.V.length+1),f.J1());var _=f.BJ,g=f.B3;if("log"===f.C1&&(null!==ZC._n_(f.o["max-value"])&&(_=ZC._f_(f.o["max-value"])),null!==ZC._n_(f.o["min-value"])&&(g=ZC._f_(f.o["min-value"])),(_!==f.BJ||g!==f.B3)&&f.W===f.DC&&f.A1===f.DX)){var v=f.AC;f.AC=(f.I-f.AB-f.BV)/(ZC.G6(_,f.E6)-ZC.G6(g,f.E6))-.1;var b=ZC.G6(g,f.E6)-ZC.G6(f.B3,f.E6),B=ZC.G6(f.BJ,f.E6)-ZC.G6(_,f.E6);f.iMinOffset=b*(f.AC-v)*(f.V.length-1)/(B+b)}var m=f.A0E(),E=0,D=1,K=1,F={};for(i=0,t=f.A.BO.length;i<t;i++)"scale-x"===f.A.BO[i].BE.substring(0,7)&&f.A.BO[i].BA===f.BA&&E++,"scale-x"===f.A.BO[i].BE.substring(0,7)&&("default"===f.A.BO[i].BA?(F[f.A.BO[i].BE]=D,D++):(F[f.A.BO[i].BE]=K,K++));var x=F[f.BE],I="default"===f.BA,y=null,w=null;for(i=0,t=f.A.AY.A4.length;i<t;i++){var Y=f.A.AY.A4[i],X=Y.BU();if(-1!==ZC.AV(X,f.BE)){var M=f.A.BL(Y.BU("v")[0]);y=M.AT(M.H6),w=Y;break}}var L=8;null!==ZC._n_(f.IT.o.size)&&(L=ZC._i_(f.IT.o.size));var H=4;null!==ZC._n_(f.I9.o.size)&&(H=ZC._i_(f.I9.o.size));var P=ZC._i_(f.A.E[f.BE+"-distance"]||-1);f.VE&&(P=0),"default"===f.BA?(A=ZC._i_(f.A.P.DR/E),a=f.iY+f.F+(x-1)*A,-1!==P&&(a=f.iY+f.F+P)):(A=ZC._i_(f.A.P.E8/E),a=f.iY-(x-1)*A,-1!==P&&(a=f.iY-P));var N=a;if(f.A.HS&&(f.A.HS.AN=!0,f.DC===f.W&&f.DX===f.A1&&(f.A.HS.AN=!1),f.A.HS.AN&&0===f.A.HS.B0.BH&&"default"===f.BA&&(a+=f.A.HS.B0.F+f.AZ/2)),f.E.iY=a,f.AN&&f.T9){null!==ZC._n_(f.o["fixed-items"])&&(f.M0=f.EG=ZC._i_(f.o["fixed-items"]));var G=ZC.BQ(1,Math.ceil((f.A1-f.W)/(f.M0-1))),S=ZC.BQ(1,Math.ceil((f.A1-f.W)/(f.EG-1)));null===ZC._n_(f.o["fixed-items"])&&ZC._b_(f.o.normalize)&&(G=ZC.AQ.A0K(G),S=ZC.AQ.A0K(S));for(var O=f.iStepMultiplier,k=3;k>0;k--)f.iStepMultiplier>k&&f.A1-f.W<=k*f.iStepMultiplier&&(O=k);G*=O,S*=O;var T,z,Q,J=0,V=f.AC*G/(f.FR+1),R=f.AW?f.iX+f.BV:f.iX+f.AB,W=f.AW?f.iX+f.I-f.AB:f.iX+f.I-f.BV;if(null===ZC._n_(y)&&(y=a),l=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-ml-0-c"),r=ZC.Q.EB(l,f.H.AA),o=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-bl-0-c"),s=ZC.Q.EB(o,f.H.AA),"inherit"===f.o["line-color"]&&-1!==m&&(f.B7=m),f.A.AJ["3d"]){if((Z=ZC.DI.DB(f,f.A,f.iX-ZC.AO.E2,f.iX-ZC.AO.E2+f.I,a-ZC.AO.E3,a-ZC.AO.E3,-1,ZC.AO.FT+1,"x")).K=f.K+"-line",f.A.F0.true3d&&(f.A.F0["x-angle"]>0?Z.MD=[1===f.L?-100:100,1,1]:Z.MD=[1===f.L?100:-100,1,1]),f.A.CL.add(Z),null!==ZC._n_(f.o.axis)){var U=new ZC.D0(f);U.append(f.o.axis),U.parse(),U.A0=U.AE=U.B7,(Z=ZC.DI.DB(U,f.A,f.iX-ZC.AO.E2,f.iX-ZC.AO.E2+f.I,a-ZC.AO.E3,a-ZC.AO.E3,-U.AZ/2,U.AZ/2,"x")).K=f.K+"-axis",f.A.CL.add(Z)}}else{C=[[f.iX-1,N],[f.iX+f.I+1,N]];var j=f.K;f.K+="-line",ZC.CR.paint(r,f,C),f.K=j}if(f.V.length>0&&f.D7.AN){var q=null===ZC._n_(f.D7.o["offset-start"])?0:ZC._i_(f.D7.o["offset-start"]),$=null===ZC._n_(f.D7.o["offset-end"])?0:ZC._i_(f.D7.o["offset-end"]);if(f.D7.o.items&&f.D7.o.items.length>0&&!f.A.AJ["3d"])for(h=new ZC.HL(f),i=f.W;i<f.A1+(f.DJ?1:0);i++)c=i-f.W,d=i%f.D7.o.items.length,h.append(f.D7.o.items[d]),h.K=f.K+"-guide-"+i,h.Z=o,h.parse(),f.AW?h.iX=f.iX+f.I-f.AB-c*f.AC-f.AC:h.iX=f.iX+f.AB+c*f.AC,h.iY=f.iY+q,h.I=f.AC,h.F=f.F-q-$,h.paint();if(f.D7.AZ>0)for(f.GT=0,i=f.W;i<=f.A1+(f.DJ?1:0);i++)if(f.K4=i,i===f.W||i===f.A1+(f.DJ?1:0)||(i-f.W)%G==0){(f.D7.E7.length>0||i===f.W)&&((p=new ZC.D0(f)).Z=p.C7=o,p.copy(f.D7),p.J2=Xe,p.DE()&&p.parse()),C=[],c=i-f.W,u="log"===f.C1?f.AT(f.V[i]):f.AW?f.iX+f.I-f.AB-c*f.AC:f.iX+f.AB+c*f.AC;var ee=f.iY+q,ie=f.F-q-$;if(p.AN)if(f.A.AJ["3d"]){var te=new ZC.D0(f);te.copy(p),null!==ZC._n_(f.o["scale-z"])&&null!==ZC._n_(e=f.o["scale-z"].guide)&&(te.append(e),te.parse()),te.A0=te.AE=te.B7,Z=ZC.DI.DB(te,f.A,u-ZC.AO.E2-te.AZ/2,u-ZC.AO.E2+te.AZ/2,a-ZC.AO.E3,a-ZC.AO.E3,0,ZC.AO.FT,"z"),f.A.CL.add(Z),p.A0=p.AE=p.B7,(Z=ZC.DI.DB(p,f.A,u-ZC.AO.E2-p.AZ/2,u-ZC.AO.E2+p.AZ/2,ee-ZC.AO.E3,ee+ie-ZC.AO.E3,ZC.AO.FT+2,ZC.AO.FT+2,"y")).K=f.K+"-guide-"+i,f.A.CL.add(Z)}else C.push([u,ee],[u,ee+ie]),p.K=f.K+"-guide-"+i,ZC.CR.paint(s,p,C);f.GT++}}if(f.V.length>0&&f.G5.AN&&!f.A.AJ["3d"]&&f.G5.o.items&&f.G5.o.items.length>0)for(h=new ZC.HL(f),i=f.W;i<f.A1+(f.DJ?1:0);i++)for(f.K4=i,c=i-f.W,f.GT=0,n=1;n<=f.FR;n++)d=f.GT%f.G5.o.items.length,h.append(f.G5.o.items[d]),h.K=f.K+"-guide-"+i+"-"+n,h.Z=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-bl-0-c"),h.parse(),f.AW?h.iX=f.iX+f.I-f.AB-c*f.AC-(n+1)*V:h.iX=f.iX+f.AB+c*f.AC+n*V,h.iY=f.iY,h.I=V,h.F=f.F,h.paint(),f.GT++;if(f.G5.AZ>0)for(i=f.W;i<f.A1+(f.DJ?1:0);i++)if(f.K4=i,i%G==0)for(c=i-f.W,f.GT=0,n=1;n<=f.FR;n++)C=[],(p=new ZC.D0(f)).copy(f.G5),p.J2=Xe,p.DE()&&p.parse(),u="log"===f.C1?f.AT(f.V[i]+n*(f.V[i+1]-f.V[i])/(f.FR+1)):f.AW?f.iX+f.I-f.AB-c*f.AC-n*V:f.iX+f.AB+c*f.AC+n*V,ZC.DS(u,R,W)&&(C.push([u,f.iY],[u,f.iY+f.F]),p.AN&&(p.K=f.K+"-minor-guide-"+n,ZC.CR.paint(s,p,C))),f.GT++;if(f.VG(s,m),f.V.length>0&&f.IT.AN){switch(f.IT.o.placement){case"inner":break;case"outer":J+=L;break;default:J+=L/2}if(!zingchart.DEV.SMARTDATELABELS||!f.FG||"date"!==f.FG.o.type)for(f.GT=0,i=f.W;i<=f.A1+(f.DJ?1:0);i++)if(i===f.W||i===f.A1+(f.DJ?1:0)||(i-f.W)%G==0){f.K4=i;var ne=L;if(C=[],c=i-f.W,(f.IT.E7.length>0||i===f.W)&&((p=new ZC.DT(f)).copy(f.IT),"inherit"===f.IT.o["line-color"]&&-1!==m&&(p.B7=m),p.J2=Xe,p.DE()&&p.parse(),p.AI>1&&(ne=p.AI)),u="log"===f.C1?f.AT(f.V[i]):f.AW?f.iX+f.I-f.AB-c*f.AC:f.iX+f.AB+c*f.AC,ZC.DS(u,R,W)){switch(p.o.placement){case"ref-auto":C.push([u,y+ne/2],[u,y-ne/2]);break;case"ref-top":C.push([u,y-ne],[u,y]);break;case"ref-bottom":C.push([u,y+ne],[u,y]);break;case"inner":C.push([u,a-(I?ne:-ne)],[u,a]);break;case"outer":C.push([u,a],[u,a+(I?ne:-ne)]);break;default:C.push([u,a+ne/2],[u,a-ne/2])}if(p.AN){for(z=ZC._i_(p.o["offset-x"]||"0"),Q=ZC._i_(p.o["offset-y"]||"0"),T=0;T<C.length;T++)C[T][0]+=z,C[T][1]+=Q;if(p.K=f.K+"-tick-"+i,f.A.AJ["3d"]&&f.A.F0.true3d){var ae,le=[];for(T=0;T<C.length;T++)ae=new ZC.CE(f.A,C[T][0]-ZC.AO.E2,C[T][1]-ZC.AO.E3,0),le.push([ae.ED[0],ae.ED[1]]);ZC.CR.paint(r,p,le)}else ZC.CR.paint(r,p,C)}}f.GT++}}var oe=[];if(f.V.length>0&&f.FR>0&&f.I9.AN&&!f.A.AJ["3d"])for(i=f.W;i<f.A1+(f.DJ?1:0);i++)if(f.K4=i,i%G==0)for(c=i-f.W,f.GT=0,n=1;n<=f.FR;n++){if(C=[],(p=new ZC.D0(f)).copy(f.I9),"inherit"===f.I9.o["line-color"]&&-1!==m&&(p.B7=m),p.J2=Xe,p.DE()&&p.parse(),"log"===f.C1){var re=Math.round(ZC.G6(f.V[i],f.E6)),se=f.V[i]+n*(f.V[i+1]-f.V[i])/(f.FR+1);se=re<0?ZC._f_(se.toFixed(-re)):ZC._f_(se.toFixed(re)),oe.push(se),u=f.AT(se)}else u=f.AW?f.iX+f.I-f.AB-c*f.AC-n*V:f.iX+f.AB+c*f.AC+n*V;if(ZC.DS(u,R,W)){switch(p.o.placement){case"ref-auto":C.push([u,y+H/2],[u,y-H/2]);break;case"ref-top":C.push([u,y],[u,y-H]);break;case"ref-bottom":C.push([u,y],[u,y+H]);break;case"inner":C.push([u,a-(I?H:-H)],[u,a]);break;case"outer":C.push([u,a],[u,a+(I?H:-H)]);break;default:C.push([u,a+H/2],[u,a-H/2])}if(p.AN){for(z=ZC._i_(p.o["offset-x"]||"0"),Q=ZC._i_(p.o["offset-y"]||"0"),T=0;T<C.length;T++)C[T][0]+=z,C[T][1]+=Q;p.K=f.K+"-minor-tick-"+i,ZC.CR.paint(r,p,C)}}f.GT++}f.XL();var Ae=null,Ce=null,ce=f.CI,ue=f.DQ,pe=[],Ze=new ZC.DT(f);Ze.copy(f.IT);var he,de=0,fe=0,_e=0,ge=[],ve=[];if(f.o["custom-items"])for(i=0;i<f.o["custom-items"].length;i++)Me(f.o["custom-items"][i][0],!1,!0,f.o["custom-items"][i][1]);if(f.V.length>0&&f.BR.AN)if(zingchart.DEV.SMARTDATELABELS&&f.FG&&"date"===f.FG.o.type){var be=f.getOptimalDateInterval(f.V[f.A1]-f.V[f.W]),Be=be[0];he=be[1];var me=be[2],Ee=be[3];_e=be[4];var De=me*Math.ceil(f.V[f.W]/me),Ke=me*Math.floor(f.V[f.A1]/me),Fe="";f.GT=0;var xe=!0;for(i=De;i<=Ke;i+=me){xe=!0;var Ie=ZC.AP.Y5(i,Be,f.A.UL,f.A.NB);if(Ie!==Fe){switch(Ee){case"yr":_e>15&&(xe=ZC._i_(Ie)%2==0);break;case"mon":_e>15&&(xe=ZC._i_(Ie)%3==0);break;case"day":_e>45?xe=1===ZC._i_(Ie)||15===ZC._i_(Ie):_e>30?xe=1===ZC._i_(Ie)||10===ZC._i_(Ie)||20===ZC._i_(Ie):_e>15&&(xe=1===ZC._i_(Ie)||10===ZC._i_(Ie)||15===ZC._i_(Ie)||20===ZC._i_(Ie)||25===ZC._i_(Ie));break;case"hr":_e>45?xe=ZC._i_(Ie)%12==0:_e>30?xe=ZC._i_(Ie)%6==0:_e>15&&(xe=ZC._i_(Ie)%3==0);break;case"min":case"sec":_e>45?xe=ZC._i_(Ie)%30==0:_e>30?xe=ZC._i_(Ie)%10==0:_e>15&&(xe=ZC._i_(Ie)%5==0)}xe&&(Me(i,!0),Fe=Ie)}}Ze.AN&&(Ze.K=f.K+"-ticks",ZC.CR.paint(r,Ze,pe))}else for(f.GT=0,Me(f.W),f.GT=f.A1-f.W,Me(f.A1),f.GT=1,i=f.W+1;i<f.A1;i++)(i-f.W)%S==0&&Me(i);for(i=0;i<oe.length;i++){var ye=f.FQ(i,null,null,!1,oe[i]);Me(ye,!1,!0,ye)}if(f.M.AN&&f.M.AM&&""!==f.M.AM){(Ae=new ZC.DN(f)).copy(f.M),Ae.K=f.A.K+"-"+f.BE.replace(/\-/g,"_")+"-item_title",Ae.GL=f.K+"-label "+f.A.K+"-scale-label zc-scale-label",Ae.AM=f.M.AM,Ae.Z=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-ml-0-c"),Ae.IL=f.H.usc()?ZC.AK(f.H.K+"-main"):ZC.AK(f.H.K+"-text"),Ae.parse(),"inherit"!==f.M.o["font-color"]&&"inherit"!==f.M.o.color||-1===m||(Ae.C2=m);var we=f.iX+(f.AW?f.BV:f.AB),Ye=f.I-f.AB-f.BV;switch("chart"===Ae.o["center-point"]&&(we=f.A.iX,Ye=f.A.I),Ae.O8){case"left":Ae.iX=we;break;case"center":Ae.iX=we+Ye/2-Ae.I/2;break;case"right":Ae.iX=we+Ye-Ae.I}Ae.iY=I?a+J+fe:a-Ae.F-J-fe,f.M.iX=Ae.iX,f.M.iY=Ae.iY,Ae.AN&&(f.MX(Ae,null,"h"),Ae.paint(),Ae.EK(),null===ZC._n_(Ae.o.tooltip)&&Ae.K9||ve.push(ZC.AP.O5(f.A.K,Ae)))}ve.length>0&&ZC.AK(f.A.A.K+"-map")&&(ZC.AK(f.A.A.K+"-map").innerHTML+=ve.join("")),null!==ZC._n_(f.o.transform)&&"date"===f.o.transform.type&&f.paintTransformDate()}function Xe(e){return e=(e=(e=(e=(e=(e=e.replace(/%scale-last-position/g,f.A1-f.W)).replace(/(%c)|(%scale-position)/g,f.GT)).replace(/(%i)|(%scale-index)/g,f.K4)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(f.V[f.K4])?f.V[f.K4]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(f.BX[f.K4])?f.BX[f.K4]:"")).replace(/%scale-day-of-week/g,ZC.AP.Y5(f.V[f.K4],"%w",f.A.UL,f.A.NB))}function Me(e,i,t,n){var l;if(f.K4=e,c=e-f.W,(f.BR.E7.length>0||e===f.W||!Ae||f.BR.HT||t)&&(Ae=new ZC.DN(f)),Ae.copy(f.BR),Ae.GL=f.K+"-item "+f.A.K+"-scale-item zc-scale-item",Ae.K=f.A.K+"-"+f.BE.replace(/\-/g,"_")+"-item_"+(n?"c"+n:e),Ae.E["p-width"]=f.AC,f.CI=ce,f.DQ=ue,t||f.YM(Xe),l=i?ZC.AP.Y5(e,he,f.A.UL,f.A.NB):n||f.FQ(e,null,null),!t&&f.BR.HT){var o=f.A.GX();ZC._cp_({index:e,cnt:c,text:l},o),f.H3(f.BR,Ae,null,o,f.BR.MJ)}if(!(null!==ZC._n_(f.LR)&&-1===ZC.AV(f.LR,l)||(Ae.AM=l,Ae.Z=Ae.C7=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-ml-0-c"),Ae.IL=f.H.usc()?ZC.AK(f.H.K+"-main"):ZC.AK(f.H.K+"-text"),Ae.E.nodeidx=e,Ae.parse(),f.BR.A29&&f.BR.A9%180==0&&(Ae.o.width=ZC._i_(.9*f.AC),Ae.parse()),"inherit"!==f.BR.o["font-color"]&&"inherit"!==f.BR.o.color||-1===m||(Ae.C2=m),t||(Ae.J2=Xe,Ae.DE()&&Ae.parse()),Ae.o["auto-fit"]&&(Ae.I=ZC._i_(f.AC)),i?(u=f.AT(e),Ae.iX=u-Ae.I/2-(f.DJ?f.AC/2:0)):t?(u=f.AT(e),Ae.iX=u-Ae.I/2):"log"===f.C1?(u=f.AT(f.V[e]),Ae.iX=u-Ae.I/2+(f.DJ?f.AC/2:0)*(f.AW?-1:1)):f.AW?(u=f.iX+f.I-f.AB-c*f.AC,Ae.iX=u-Ae.I/2-(f.DJ?f.AC/2:0)):(u=f.iX+f.AB+c*f.AC,Ae.iX=u-Ae.I/2+(f.DJ?f.AC/2:0)),u<f.iX-1||u>f.iX+f.I+1))){if(f.A.B9&&f.A.B9.BX&&f.A.B9.I2){for(var r=!1,s=0;s<f.A.B9.BX.length;s++)f.A.B9.BX[s].text===Ae.AM&&(r=!0);r||f.A.B9.BX.push({x:ZC._i_(u),text:Ae.AM})}switch(Ae.o.placement){case"inner":Ae.iY=I?a-Ae.F-L:a+L;break;case"ref-top":Ae.iY=y-Ae.F-L;break;case"ref-bottom":Ae.iY=y+L;break;case"ref-auto":w&&w.S[e]?(w.FK(e).setup(),w.FK(e).iY<y?Ae.iY=y+L:Ae.iY=y-Ae.F-L):Ae.iY=y+L;break;default:Ae.iY=I?a+L:a-Ae.F-L}if(Ce=f.MX(Ae,Ce,"h",0),f.BR.o["auto-align"]&&f.BR.A9%180!=0){var A=ZC.DS(f.BR.A9,0,180)?I?1:-1:I?-1:1;Ae.iX+=A*Ae.I*ZC.EH(f.BR.A9)/2,Ae.iY+=A*(Ae.I*ZC.EP(f.BR.A9)/2-Ae.F*ZC.EP(f.BR.A9)/2)}var C=f.X3(Ae,e,{items:_e,lcoords:ge,lstep:S,tdim:de,mdim:fe,dim:"h",html:ve});if(de=C.tdim,fe=C.mdim,!C.overlaps&&i&&f.IT.AN)switch(Ze.o.placement){case"ref-auto":pe.push([u,y+L/2],[u,y-L/2],null);break;case"ref-top":pe.push([u,y-L],[u,y],null);break;case"ref-bottom":pe.push([u,y+L],[u,y],null);break;case"inner":pe.push([u,a-(I?L:-L)],[u,a],null);break;case"outer":pe.push([u,a],[u,a+(I?L:-L)],null);break;default:pe.push([u,a+L/2],[u,a-L/2],null)}f.GT++}}},getOptimalDateInterval:function(e){var i,t,n,a,l;return 0<=e&&e<=3*ZC.SEC?(i="%q",t="%q ms",n=10,a="ms",l=ZC._i_(e/10)):3*ZC.SEC<e&&e<=3*ZC.MIN?(i="%s",t="%h:%i:%s %A",n=ZC.SEC,a="sec",l=ZC._i_(e/ZC.SEC)):3*ZC.MIN<e&&e<=3*ZC.HR?(i="%i",t="%h:%i %A",n=ZC.MIN,a="min",l=ZC._i_(e/ZC.MIN)):3*ZC.HR<e&&e<=3*ZC.DAY?(i="%h:%i",t="%M %d, %h %A",n=ZC.HR,a="hr",l=ZC._i_(e/ZC.HR)):3*ZC.DAY<e&&e<=3*ZC.MON?(i="%d",t="%M %d",n=ZC.DAY,a="day",l=ZC._i_(e/ZC.DAY)):3*ZC.MON<e&&e<=3*ZC.YR?(i="%m",t="%M %Y",n=ZC.DAY,a="mon",l=ZC._i_(e/ZC.MON)):(i="%Y",t="%Y",n=ZC.DAY,a="yr",l=ZC._i_(e/ZC.YR)),[i,t,n,a,l]},paintTransformDate:function(){var e,i,t,n,a=this;i=ZC.Q.EB(a.H.usc()?a.H.K+"-main-c":a.A.K+"-scales-bl-0-c",a.H.AA);var l=[],o=1;function r(e,i){void 0===i&&(i=!1),0<=e&&e<=2*ZC.SEC?(t="%q",n="%q ms",i&&r(60*e)):2*ZC.SEC<e&&e<=2*ZC.MIN?(t="%s",n="%h:%i:%s %A",i&&r(60*e),e>10*ZC.SEC&&(o=2),e>30*ZC.SEC&&(o=5),e>60*ZC.SEC&&(o=10)):2*ZC.MIN<e&&e<=2*ZC.HR?(t="%i",n="%h:%i %A",i&&r(24*e),e>10*ZC.MIN&&(o=2),e>30*ZC.MIN&&(o=5),e>60*ZC.MIN&&(o=10)):2*ZC.HR<e&&e<=2*ZC.DAY?(t="%h",n="%M %d, %h %A",i&&r(30*e),e>6*ZC.HR&&(o=2),e>12*ZC.HR&&(o=4),e>24*ZC.HR&&(o=6)):2*ZC.DAY<e&&e<=2*ZC.MON?(t="%d",n="%M %d",i&&r(366*e),e>12*ZC.DAY&&(l=[1,5,9,13,17,21,25,29]),e>24*ZC.DAY&&(l=[1,6,11,16,21,26])):2*ZC.MON<e&&e<=2*ZC.YR?(t="%m",n="%M %Y",i&&r(10*e),e>9*ZC.MON&&(l=[1,4,7,10])):(t="%Y",n="%Y",e>9*ZC.YR&&(o=3),e>16*ZC.YR&&(o=4),e>25*ZC.YR&&(o=5))}r(a.V[a.A1]-a.V[a.W]);var s=null,A=null,C=[],c=!1,u=!1;function p(e){var u,p;if(null!==ZC._n_(a.V[e])&&""!==a.V[e]){if(a.O1&&e!==a.W&&e!==a.A1&&null!==ZC._n_(a.V[e-1])&&""!==a.V[e-1]&&null!==ZC._n_(a.V[e])&&""!==a.V[e]){var Z=a.V[e]-a.V[e-1];null!==ZC._n_(A)&&A!==Z&&r(A,!0),A=Z}var h=ZC.AP.Y5(a.V[e],t,a.A.UL,a.A.NB);if(h!==s&&ZC._i_(h)%o==0&&(0===l.length||-1!==ZC.AV(l,ZC._i_(h)))){var d,f=!0,_=e-a.W;u=a.AW?a.iX+a.I-a.AB-_*a.AC:a.iX+a.AB+_*a.AC+(a.DJ?a.AC/2:0);var g=new ZC.DN(a);a.H.B8.load(g.o,"graph.SCALE.transform[date].item"),null!==ZC._n_(d=a.o.transform.item)&&g.append(d),g.GL=a.K+"-item "+a.A.K+"-scale-item zc-scale-item",g.K=a.K+"-date-item-"+e;var v=ZC.AP.Y5(a.V[e],n,a.A.UL,a.A.NB);g.AM=v,g.Z=g.C7=a.H.usc()?a.H.mc():ZC.AK(a.A.K+"-scales-ml-0-c"),g.IL=a.H.usc()?ZC.AK(a.H.K+"-main"):ZC.AK(a.H.K+"-text"),g.parse(),a.AW?g.iX=u-g.I/2-(a.DJ?a.AC/2:0):g.iX=u,g.iY=a.iY,a.A.AJ["3d"]&&(a.A.NX(),p=new ZC.CE(a.A,g.iX+g.I/2-ZC.AO.E2,g.iY+g.F/2-ZC.AO.E3,0),g.iX=p.ED[0]-g.I/2,g.iY=p.ED[1]-g.F/2);var b=[g.iX+g.BM,g.iY+g.BH,g.I,g.F];if(g.A9%180==90&&(b=[g.iX+g.BM+g.I/2-g.F/2,g.iY+g.BH+g.F/2-g.I/2,g.F,g.I]),a.A.B9&&a.A.B9.I2){for(var B=!1,m=0;m<a.A.B9.BX.length;m++)a.A.B9.BX[m].text===g.AM&&(B=!0);B||g.iX>=a.iX&&g.iX+g.I<=a.iX+a.I&&a.A.B9.BX.push({x:ZC._i_(g.iX),text:g.AM})}if(g.AN&&c){if(f=!0,!a.A0J){if(e===a.W||e===a.A1)f=!0;else for(var E=0,D=C.length;E<D;E++)if(ZC.DS(b[0],C[E][0],C[E][0]+C[E][2])||ZC.DS(b[0]+b[2],C[E][0],C[E][0]+C[E][2])){f=!1;break}g.iX+g.BM+g.I>a.iX+a.BM+a.I&&(f=!1)}if(f){C.push(b),g.paint(),g.EK();var K=new ZC.D0(a);null!==ZC._n_(d=a.o.transform.guide)&&K.append(d),K.AZ=1,K.B7="#ccc",K.parse();var F=[];if(F.push([u,a.iY],[u,a.iY+a.F]),a.A.AJ["3d"]){a.A.NX();for(var x=0,I=F.length;x<I;x++)p=new ZC.CE(a.A,F[x][0]-ZC.AO.E2,F[x][1]-ZC.AO.E3,0),F[x][0]=p.ED[0],F[x][1]=p.ED[1]}K.AN&&ZC.CR.paint(i,K,F)}}0}s=h}}if(a.A.B9&&a.A.B9.I2&&(a.A.B9.BX=[]),a.V.length>0&&(c=!1,null!==ZC._n_(e=a.o.transform.item)&&(c=!(null!==ZC._n_(e.visible)&&!ZC._b_(e.visible))),u=!1,a.A.B9&&a.A.B9.BX&&(u=!0),c||u)){p(a.W),p(a.A1);for(var Z=a.W+1;Z<a.A1;Z++)p(Z)}}};ZC.Q6=ZC.ZI.CA(Q6);var Q3={$i:function(e){this.b(e)},parse:function(){this.b()},J1:function(){var e=this;e.A1===e.W?e.AC=e.F-e.AB-e.BV:e.AC=(e.F-e.AB-e.BV)/(e.A1-e.W+(e.DJ?1:0))},A96:function(e){this.b(e),this.J1()},clear:function(){},build:function(){this.b()},zoomTo:function(e,i){this.b(e,i),this.J1()},NE:function(e,i,t){var n,a=this;n=a.AW?(e-a.iY-a.AB)/(a.F-a.AB-a.BV):(a.iY+a.F-a.AB-e)/(a.F-a.AB-a.BV);var l=a.B3+ZC._f_((a.BJ-a.B3)*n);return t&&(l=ZC._a_(a.AW?Math.ceil(l):Math.floor(l))),"log"===a.C1&&i&&(l=Math.pow(a.E6,l)),l},AT:function(e){var i=this,t=i.BJ-i.B3,n=0===t?0:(i.F-i.AB-i.BV-(i.DJ?i.AC:0))/t;return"log"===i.C1&&(e=0===e?i.FW:ZC.G6(e,i.E6)),i.AW?i.iY+i.AB+(e-i.B3)*n:i.iY+i.F-i.AB-(e-i.B3)*n},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c,u,p,Z,h,d,f,_,g=this;g.b(),"bubble"!==g.A.AF&&"scatter"!==g.A.AF||1!==g.V.length||(g.AB=g.F/2);var v=g.A0E(),b=0,B=1,m=1,E={};for(i=0,t=g.A.BO.length;i<t;i++)g.A.BO[i].AN&&g.A.BO[i].T9&&("scale-y"===g.A.BO[i].BE.substring(0,7)&&g.A.BO[i].BA===g.BA&&b++,"scale-y"===g.A.BO[i].BE.substring(0,7)&&("default"===g.A.BO[i].BA?(E[g.A.BO[i].BE]=B,B++):(E[g.A.BO[i].BE]=m,m++)));var D=E[g.BE],K="default"===g.BA,F=null,x=null;for(i=0,t=g.A.AY.A4.length;i<t;i++){var I=g.A.AY.A4[i],y=I.BU();if(-1!==ZC.AV(y,g.BE)){var w=g.A.BL(I.BU("k")[0]);F=w.AT(w.H6),x=I;break}}var Y=8;null!==ZC._n_(g.IT.o.size)&&(Y=ZC._i_(g.IT.o.size));var X=4;null!==ZC._n_(g.I9.o.size)&&(X=ZC._i_(g.I9.o.size));var M=ZC._i_(g.A.E[g.BE+"-distance"]||-1);g.VE&&(M=0),"default"===g.BA?(_=ZC._i_(g.A.P.DY/b),n=g.iX-(D-1)*_,-1!==M&&(n=g.iX-M)):(_=ZC._i_(g.A.P.E9/b),n=g.iX+g.I+(D-1)*_,-1!==M&&(n=g.iX+g.I+M));var L=n;if(g.A.HQ&&"scale-y"===g.BE&&(g.A.HQ.AN=!0,g.FW===g.B3&&g.H1===g.BJ&&(g.A.HQ.AN=!1),g.A.HQ.AN&&0===g.A.HQ.B0.BM&&"default"===g.BA&&(n-=g.A.HQ.B0.I+g.AZ/2)),g.E.iX=n,g.AN&&g.T9){for(var H=Math.ceil((g.A1-g.W)/(g.EG-1)),P=Math.ceil((g.A1-g.W)/(g.M0-1)),N=g.iStepMultiplier,G=3;G>0;G--)g.iStepMultiplier>G&&g.A1-g.W<=G*g.iStepMultiplier&&(N=G);P*=N,H*=N;var S=0,O=g.AC*P/(g.FR+1);if(a=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-ml-0-c"),l=ZC.Q.EB(a,g.H.AA),o=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-bl-0-c"),r=ZC.Q.EB(o,g.H.AA),g.T9||g.YQ||null!==ZC._n_(g.A.o[g.BE])){if("inherit"===g.o["line-color"]&&-1!==v&&(g.B7=v),g.A.AJ["3d"]){if((u=ZC.DI.DB(g,g.A,n-ZC.AO.E2,n-ZC.AO.E2,g.iY-ZC.AO.E3,g.iY-ZC.AO.E3+g.F,-1,ZC.AO.FT+1,"y")).K=g.K+"-line",g.A.F0.true3d&&(g.A.F0["y-angle"]>0?u.MD=[1===g.L?-100:100,1,1]:u.MD=[1===g.L?100:-100,1,1]),g.A.CL.add(u),null!==ZC._n_(g.o.axis)){var k=new ZC.D0(g);k.append(g.o.axis),k.parse(),k.A0=k.AE=k.B7,(u=ZC.DI.DB(k,g.A,n-ZC.AO.E2,n-ZC.AO.E2,g.iY-ZC.AO.E3,g.iY-ZC.AO.E3+g.F,-k.AZ/2,k.AZ/2,"y")).K=g.K+"-axis",g.A.CL.add(u)}}else{A=[[L,g.iY+g.F],[L,g.iY]];var T=g.K;g.K+="-line",ZC.CR.paint(l,g,A),g.K=T}var z=0,Q=0,J=[],V=[];if(g.T9||g.YQ){if(g.V.length>0&&g.D7.AN){var R=null===ZC._n_(g.D7.o["offset-start"])?0:ZC._i_(g.D7.o["offset-start"]),W=null===ZC._n_(g.D7.o["offset-end"])?0:ZC._i_(g.D7.o["offset-end"]);if(g.D7.o.items&&g.D7.o.items.length>0&&!g.A.AJ["3d"])for(g.GT=0,p=new ZC.HL(g),i=g.W;i<g.A1+(g.DJ?1:0);i++)g.K4=i,i%P==0&&(C=i-g.W,Z=g.GT%g.D7.o.items.length,p.append(g.D7.o.items[Z]),p.K=g.K+"-guide-"+i,p.Z=o,p.parse(),p.iX=g.iX+R,s="log"===g.C1?g.AT(g.V[i]):g.AT(g.V[i])-(g.AW?0:g.AC*P),p.iY=s,p.I=g.I-R-W,p.F=g.AC*P,p.paint(),g.GT++);if(g.D7.AZ>0)for(g.GT=0,i=g.W;i<=g.A1+(g.DJ?1:0);i++)if(g.K4=i,i===g.W||i===g.A1||i%P==0){(g.D7.E7.length>0||i===g.W||"log"===g.C1)&&((c=new ZC.D0(g)).Z=c.C7=o,"log"===g.C1?ZC.AQ._int_(ZC.G6(g.V[i],g.E6))?c.copy(g.D7):c.copy(g.G5):c.copy(g.D7),c.J2=ue,c.DE()&&c.parse()),A=[],C=i-g.W;var U=g.iX+R,j=g.I-R-W;if(s=(g.C1,g.AT(g.V[i])),c.AN)if(g.A.AJ["3d"]){var q=new ZC.D0(g);q.copy(c),null!==ZC._n_(g.o["scale-z"])&&null!==ZC._n_(e=g.o["scale-z"].guide)&&(q.append(e),q.parse()),q.A0=q.AE=q.B7,u=ZC.DI.DB(q,g.A,n-ZC.AO.E2,n-ZC.AO.E2,s-ZC.AO.E3-q.AZ/2,s-ZC.AO.E3+q.AZ/2,0,ZC.AO.FT,"y"),g.A.CL.add(u),c.A0=c.AE=c.B7,(u=ZC.DI.DB(c,g.A,U-ZC.AO.E2,U-ZC.AO.E2+j,s-ZC.AO.E3-c.AZ/2,s-ZC.AO.E3+c.AZ/2,ZC.AO.FT+2,ZC.AO.FT+2,"x")).K=g.K+"-guide-"+i,g.A.CL.add(u)}else A.push([U,s],[U+j,s]),c.K=g.K+"-guide-"+i,ZC.CR.paint(r,c,A);g.GT++}}if(g.V.length>0&&g.G5.AN&&O>2&&!g.A.AJ["3d"]){if(g.G5.o.items&&g.G5.o.items.length>0)for(p=new ZC.HL(g),i=g.W;i<g.A1+(g.DJ?1:0);i++)if(g.K4=i,i%P==0)for(C=i-g.W,g.GT=0,h=1;h<=g.FR;h++)Z=g.GT%g.G5.o.items.length,p.append(g.G5.o.items[Z]),p.K=g.K+"-guide-"+i+"-"+h,p.Z=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-bl-0-c"),p.parse(),p.iX=g.iX,s=g.AW?g.iY+g.AB+C*g.AC+h*O:g.iY+g.F-g.AB-C*g.AC-(h+1)*O,p.iY=s,p.I=g.I,p.F=O,p.paint(),g.GT++;if(g.G5.AZ>0&&"log"!==g.C1)for(i=g.W;i<g.A1+(g.DJ?1:0);i++)if(g.K4=i,i===g.W||i===g.A1||i%P==0)for(C=i-g.W,g.GT=0,h=1;h<=g.FR;h++)A=[],(c=new ZC.D0(g)).copy(g.G5),c.J2=ue,c.DE()&&c.parse(),s="log"===g.C1?g.AT(g.V[i]+h*(g.V[i+1]-g.V[i])/(g.FR+1)):g.AT(g.V[i]+h*H*(g.V[i+1]-g.V[i])/(g.FR+1)),ZC.DS(s,g.iY,g.iY+g.F)&&(A.push([g.iX,s],[g.iX+g.I,s]),c.AN&&(c.K=g.K+"-minor-guide-"+h,ZC.CR.paint(r,c,A))),g.GT++}var $,ee,ie;if(g.VG(r,v),g.V.length>0&&g.IT.AN){switch(g.IT.o.placement){case"inner":break;case"outer":S+=Y;break;default:S+=Y/2}for(g.GT=0,d=ZC.AV(g.V,0),i=g.W;i<=g.A1+(g.DJ?1:0);i++){g.K4=i;var te=-1;if((i===g.W||i===g.A1||i%P==0||ZC._b_(g.o["show-zero"])&&i===d)&&(A=[],C=i-g.W,(g.IT.E7.length>0||i===g.W||"log"===g.C1)&&(c=new ZC.D0(g),"log"===g.C1?ZC.AQ._int_(ZC.G6(g.V[i],g.E6))?c.copy(g.IT):(c.copy(g.I9),te=Y,Y=X):c.copy(g.IT),"inherit"===g.IT.o["line-color"]&&-1!==v&&(c.B7=v),c.J2=ue,c.DE()&&c.parse()),s=(g.C1,g.AT(g.V[i])),ZC.DS(s,g.A.P.iY,g.A.P.iY+g.A.P.F))){switch(c.o.placement){case"ref-right":A.push([F,s],[F+Y,s]);break;case"ref-left":A.push([F,s],[F-Y,s]);break;case"ref-auto":A.push([F-Y/2,s],[F+Y/2,s]);break;case"inner":A.push([n,s],[n+(K?Y:-Y),s]);break;case"outer":A.push([n,s],[n-(K?Y:-Y),s]);break;default:A.push([n+Y/2,s],[n-Y/2,s])}if(-1!==te&&(Y=te,te=-1),c.AN){for(ee=ZC._i_(c.o["offset-x"]||"0"),ie=ZC._i_(c.o["offset-y"]||"0"),$=0;$<A.length;$++)A[$][0]+=ee,A[$][1]+=ie;if(c.K=g.K+"-tick-"+i,g.A.AJ["3d"]&&g.A.F0.true3d){var ne,ae=[];for($=0;$<A.length;$++)ne=new ZC.CE(g.A,A[$][0]-ZC.AO.E2,A[$][1]-ZC.AO.E3,0),ae.push([ne.ED[0],ne.ED[1]]);ZC.CR.paint(l,c,ae)}else ZC.CR.paint(l,c,A)}g.GT++}}}if(g.V.length>0&&g.I9.AN&&g.FR>0&&O>5&&!g.A.AJ["3d"]&&"log"!==g.C1)for(i=g.W;i<g.A1+(g.DJ?1:0);i++)if(g.K4=i,i===g.W||i===g.A1||i%P==0)for(C=i-g.W,g.GT=0,h=1;h<=g.FR;h++){if(A=[],(c=new ZC.D0(g)).copy(g.I9),"inherit"===g.I9.o["line-color"]&&-1!==v&&(c.B7=v),c.J2=ue,c.DE()&&c.parse(),s="log"===g.C1?g.AT(g.V[i]+h*(g.V[i+1]-g.V[i])/(g.FR+1)):g.AT(g.V[i]+h*H*(g.V[i+1]-g.V[i])/(g.FR+1)),ZC.DS(s,g.iY,g.iY+g.F)){switch(c.o.placement){case"ref-right":A.push([F,s],[F+X,s]);break;case"ref-left":A.push([F,s],[F-X,s]);break;case"ref-auto":A.push([F-X/2,s],[F+X/2,s]);break;case"inner":A.push([n,s],[n+(K?X:-X),s]);break;default:A.push([n,s],[n-(K?X:-X),s]);break;case"cross":A.push([n+X/2,s],[n-X/2,s])}if(c.AN){for(ee=ZC._i_(c.o["offset-x"]||"0"),ie=ZC._i_(c.o["offset-y"]||"0"),$=0;$<A.length;$++)A[$][0]+=ee,A[$][1]+=ie;c.K=g.K+"-minor-tick-"+i,ZC.CR.paint(l,c,A)}}g.GT++}g.XL();var le=null,oe=g.CI,re=g.DQ,se=function(e){var i;if(g.K4=e,C=e-g.W,(g.BR.E7.length>0||e===g.W||!f||g.BR.HT)&&(f=new ZC.DN(g)),f.copy(g.BR),f.GL=g.K+"-item "+g.A.K+"-scale-item zc-scale-item",f.K=g.A.K+"-"+g.BE.replace(/\-/g,"_")+"-item_"+e,g.CI=oe,g.DQ=re,g.YM(ue),i=("piano"===g.A.AF||g.PZ)&&g.BX.length?g.FQ(e+g.B3):g.FQ(e),g.BR.HT){var t=g.A.GX();ZC._cp_({index:e,cnt:C,text:i},t),g.H3(g.BR,f,null,t,g.BR.MJ)}if(null===ZC._n_(g.LR)||-1!==ZC.AV(g.LR,i)){switch(f.AM=i,f.Z=f.C7=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-ml-0-c"),f.IL=g.H.usc()?ZC.AK(g.H.K+"-main"):ZC.AK(g.H.K+"-text"),f.parse(),"inherit"!==g.BR.o["font-color"]&&"inherit"!==g.BR.o.color||-1===v||(f.C2=v),f.J2=ue,f.DE()&&f.parse(),f.o.placement){case"ref-left":f.iX=F-f.I-Y;break;case"ref-right":f.iX=F+Y;break;case"ref-auto":x&&x.S[e]?(x.FK(e).setup(),x.FK(e).iX<F?f.iX=F+Y:f.iX=F-f.I-Y):f.iX=F+Y;break;case"middle":f.iX=n-f.I/2;break;case"inner":f.iX=K?n+Y:n-f.I-Y;break;default:f.iX=K?n-f.I-Y:n+Y}if("log"===g.C1?f.iY=g.AT(g.V[e])-f.F/2:f.iY=g.AT(g.V[e])-f.F/2+(g.AW?1:-1)*(g.DJ?g.AC/2:0),le=g.MX(f,le,"v"),g.BR.o["auto-align"]&&g.BR.A9%180!=0){var a=K?1:-1;90===g.BR.A9||270===g.BR.A9?f.iX+=a*(f.I/2-f.F/2):ZC.DS(g.BR.A9,0,90)||ZC.DS(g.BR.A9,270,360)?(f.iX+=a*(f.I-f.I*ZC.EH(g.BR.A9))/2,f.iY-=a*f.I*ZC.EP(g.BR.A9)/2):ZC.DS(g.BR.A9,90,270)&&(f.iX+=a*(f.I+f.I*ZC.EH(g.BR.A9))/2,f.iY+=a*f.I*ZC.EP(g.BR.A9)/2)}if(ZC.DS(f.iY+f.F/2,g.A.P.iY,g.A.P.iY+g.A.P.F)){var l=g.X3(f,e,{items:0,lcoords:J,lstep:H,tdim:z,mdim:Q,dim:"w",html:V});z=l.tdim,Q=l.mdim,g.GT++}}};if(g.V.length>0&&g.BR.AN)if("log"===g.C1){var Ae=[];for(i=g.W;i<=g.A1;i++)ZC.AQ._int_(ZC.G6(g.V[i],g.E6))&&(g.GT=i,se(i),Ae.push(i));for(i=g.W;i<=g.A1;i++)-1===ZC.AV(Ae,i)&&(g.GT=i,se(i))}else for(g.GT=0,se(g.W),g.GT=g.A1-g.W,se(g.A1),-1!==(d=ZC.AV(g.V,0))&&ZC._b_(g.o["show-zero"])&&(g.GT=d,se(d)),g.GT=1,i=g.W+1;i<g.A1;i++)i%H==0&&se(i)}if(g.M.AN&&g.M.AM&&""!==g.M.AM){(f=new ZC.DN(g)).copy(g.M),f.K=g.A.K+"-"+g.BE.replace(/\-/g,"_")+"-item_title",f.GL=g.K+"-label "+g.A.K+"-scale-label zc-scale-label",f.AM=g.M.AM,f.Z=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-ml-0-c"),f.IL=g.H.usc()?ZC.AK(g.H.K+"-main"):ZC.AK(g.H.K+"-text"),f.parse(),"inherit"!==g.M.o["font-color"]&&"inherit"!==g.M.o.color||-1===v||(f.C2=v);var Ce=g.iY+(g.AW?g.AB:g.BV),ce=g.F-g.BV-g.AB;switch("chart"===f.o["center-point"]&&(Ce=g.A.iY,ce=g.A.F),f.JX){case"top":f.iY=Ce+f.I/2-f.F/2;break;case"middle":f.iY=Ce+ce/2-f.F/2;break;case"bottom":f.iY=Ce+ce-f.I/2-f.F/2}f.iX=K?n-f.I/2-f.F/2-S-Q:n+Q+f.F/2+S-f.I/2,g.M.iX=f.iX,g.M.iY=f.iY,f.AN&&(g.MX(f,null,"v",10),f.paint(),f.EK(),null===ZC._n_(f.o.tooltip)&&f.K9||V.push(ZC.AP.O5(g.A.K,f)))}V.length>0&&ZC.AK(g.A.A.K+"-map")&&(ZC.AK(g.A.A.K+"-map").innerHTML+=V.join(""))}}function ue(e){return e=(e=(e=(e=(e=e.replace(/%scale-last-position/g,g.A1-g.W)).replace(/(%c)|(%scale-position)/g,g.GT)).replace(/(%i)|(%scale-index)/g,g.K4)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(g.V[g.K4])?g.V[g.K4]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(g.BX[g.K4])?g.BX[g.K4]:"")}}};ZC.Q3=ZC.VQ.CA(Q3);var SU={$i:function(e){this.b(e),this.CO=!0},parse:function(){this.b()},J1:function(){var e=this;e.A1===e.W?e.AC=e.F-e.AB-e.BV:e.AC=(e.F-e.AB-e.BV)/(e.A1-e.W+(e.DJ?1:0))},A96:function(e){this.b(e),this.J1()},clear:function(){},build:function(){this.b()},zoomTo:function(e,i){this.b(e,i),this.J1()},NE:function(e){var i,t=this;return i=t.AW?(e-t.iY-t.AB)/(t.F-t.AB-t.BV):(t.iY+t.F-t.AB-e)/(t.F-t.AB-t.BV),t.B3+ZC._f_((t.BJ-t.B3)*i)},OE:function(e,i,t){var n,a,l,o,r=this;void 0===t&&(t=!1);var s=r.DJ?r.AC:0;l=r.AW?(e-r.iY-r.AB-s/2)/(r.F-r.AB-r.BV-s):(r.iY+r.F-e-r.AB-s/2)/(r.F-r.AB-r.BV-s);var A=!1;if(i)for(o in i.K2){A=!0;break}if(i&&!r.O1&&A){var C=r.V[r.W];"string"==typeof C&&(C=ZC.AV(r.IQ,C)),"log"===r.C1&&(C=ZC.G6(C,r.E6));var c=r.V[r.A1];"string"==typeof c&&(c=ZC.AV(r.IQ,c)),"log"===r.C1&&(c=ZC.G6(c,r.E6));var u=C+ZC._f_((c-C)*l);"log"===r.C1&&(u=Math.pow(r.E6,u));var p=ZC.MAX;for(o in a=null,i.K2)(n=Math.abs(o-u))<p&&(p=n,a=i.K2[o]);if(null===ZC._n_(a)&&(a=u),p>i.A2K){var Z=Math.ceil((c-C)/(r.I-r.AB-r.BV));if(i.V.length<2&&(Z*=100),p>Z)return null}return a}var h=r.W,d=r.A1;return r.EF&&(null!==ZC._n_(n=r.V[h])&&(h=n),null!==ZC._n_(n=r.V[d])&&(d=n)),"log"===r.C1&&(h=ZC.G6(h,r.E6),d=ZC.G6(d,r.E6)),a=t?r.DJ?h+(d-h+1)*l:h+(d-h)*l:r.DJ?r.W+(r.A1-r.W+1)*l:r.W+(r.A1-r.W)*l,"log"===r.C1?(a=Math.pow(r.E6,a),a=Math.floor(a)-1):(a=r.DJ?Math.floor(a):ZC._i_(a),a=ZC.BQ(0,a),a=ZC.CY(r.DX,a)),a},IB:function(e){var i=this;i.W,i.A1;return i.EF&&!i.O1&&(i.B3,i.BJ),"log"===i.C1&&(e=ZC.G6(e+1,i.E6)),i.AW?i.iY+i.AB+(e-i.W)*i.AC+(i.DJ?i.AC/2:0):i.iY+i.F-i.AB-(e-i.W)*i.AC-(i.DJ?i.AC/2:0)},AT:function(e){var i,t,n,a,l,o=this;if("log"===o.C1&&(0===e&&(e=o.B3),e=ZC.G6(e,o.E6)),o.O1){var r=o.U9[e];return o.IB(r)}return-1!==(i=ZC.AV(o.IQ,e))?o.IB(i):!o.A5E&&(o.EF||o.FG&&"date"===o.FG.o.type)?(a=o.V[o.W],l=o.V[o.A1],"log"===o.C1&&(a=ZC.G6(a,o.E6),l=ZC.G6(l,o.E6)),l===a?n=0:(t=l-a,n=(o.F-o.AB-o.BV-(o.DJ?o.AC:0))/t),o.AW?o.iY+o.AB+(e-a)*n+(o.DJ?o.AC/2:0):o.iY+o.F-o.AB-(e-a)*n-(o.DJ?o.AC/2:0)):(a=o.B3,l=o.BJ,"log"===o.C1&&(a=ZC.G6(a,o.E6),l=ZC.G6(l,o.E6)),l===a?n=0:(t=l-a+(o.DJ?1:0),n=(o.F-o.AB-o.BV)/t),o.AW?o.iY+o.AB+(e-a)*n+(o.DJ?o.AC/2:0):o.iY+o.F-o.AB-(e-a)*n-(o.DJ?o.AC/2:0))},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c,u,p,Z,h,d,f=this;if(f.AN){f.b(),null!==ZC._n_(f.A.A.E[f.BE+"-feed-offset-start"])&&(f.AB=f.A.A.E[f.BE+"-feed-offset-start"]),"hbubble"!==f.A.AF&&"hscatter"!==f.A.AF||(-1===f.AB&&-1===f.BV||1===f.V.length)&&(f.AB=f.BV=f.F/(f.V.length+1),f.J1());var _=f.A0E(),g=0,v=1,b=1,B={};for(i=0,t=f.A.BO.length;i<t;i++)"scale-x"===f.A.BO[i].BE.substring(0,7)&&f.A.BO[i].BA===f.BA&&g++,"scale-x"===f.A.BO[i].BE.substring(0,7)&&("default"===f.A.BO[i].BA?(B[f.A.BO[i].BE]=v,v++):(B[f.A.BO[i].BE]=b,b++));var m=B[f.BE],E="default"===f.BA,D=null,K=null;for(i=0,t=f.A.AY.A4.length;i<t;i++){var F=f.A.AY.A4[i],x=F.BU();if(-1!==ZC.AV(x,f.BE)){var I=f.A.BL(F.BU("v")[0]);D=I.AT(I.H6),K=F;break}}var y=8;null!==ZC._n_(f.IT.o.size)&&(y=ZC._i_(f.IT.o.size));var w=4;null!==ZC._n_(f.I9.o.size)&&(w=ZC._i_(f.I9.o.size));var Y=ZC._i_(f.A.E[f.BE+"-distance"]||-1);f.VE&&(Y=0),"default"===f.BA?(n=ZC._i_(f.A.P.DY/g),a=f.iX-(m-1)*n,-1!==Y&&(a=f.iX-Y)):(n=ZC._i_(f.A.P.E9/g),a=f.iX+f.I+(m-1)*n,-1!==Y&&(a=f.iX+f.I+Y));var X=a;if(f.A.HS&&"scale-x"===f.BE&&(f.A.HS.AN=!0,f.DC===f.W&&f.DX===f.A1&&(f.A.HS.AN=!1),f.A.HS.AN&&0===f.A.HS.B0.BM&&"default"===f.BA&&(a-=f.A.HS.B0.I+f.AZ/2)),f.E.iX=a,f.AN&&f.T9){null!==ZC._n_(f.o["fixed-items"])&&(f.M0=f.EG=ZC._i_(f.o["fixed-items"]));var M=Math.ceil((f.A1-f.W)/(f.M0-1)),L=Math.ceil((f.A1-f.W)/(f.EG-1));null===ZC._n_(f.o["fixed-items"])&&ZC._b_(f.o.normalize)&&(M=ZC.AQ.A0K(M),L=ZC.AQ.A0K(L));for(var H=f.iStepMultiplier,P=3;P>0;P--)f.iStepMultiplier>P&&f.A1-f.W<=P*f.iStepMultiplier&&(H=P);M*=H,L*=H;var N,G,S,O=0,k=f.AC*M/(f.FR+1);if(null===ZC._n_(D)&&(D=a),l=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-ml-0-c"),o=ZC.Q.EB(l,f.H.AA),r=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-bl-0-c"),s=ZC.Q.EB(r,f.H.AA),"inherit"===f.o["line-color"]&&-1!==_&&(f.B7=_),f.A.AJ["3d"])(p=ZC.DI.DB(f,f.A,a-ZC.AO.E2,a-ZC.AO.E2,f.iY-ZC.AO.E3,f.iY-ZC.AO.E3+f.F,-1,ZC.AO.FT+1,"y")).K=f.K+"-line",f.A.F0.true3d&&(f.A.F0["x-angle"]>0?p.MD=[1===f.L?-100:100,1,1]:p.MD=[1===f.L?100:-100,1,1]),f.A.CL.add(p);else{C=[[X,f.iY+f.F],[X,f.iY]];var T=f.K;f.K+="-line",ZC.CR.paint(o,f,C),f.K=T}if(f.V.length>0&&f.D7.AN){var z=null===ZC._n_(f.D7.o["offset-start"])?0:ZC._i_(f.D7.o["offset-start"]),Q=null===ZC._n_(f.D7.o["offset-end"])?0:ZC._i_(f.D7.o["offset-end"]);if(f.D7.o.items&&f.D7.o.items.length>0&&!f.A.AJ["3d"])for(Z=new ZC.HL(f),i=f.W;i<f.A1+(f.DJ?1:0);i++)A=i-f.W,d=i%f.D7.o.items.length,Z.append(f.D7.o.items[d]),Z.K=f.K+"-guide-"+i,Z.Z=r,Z.parse(),Z.iX=f.iX+z,f.AW?Z.iY=f.iY+f.AB+A*f.AC:Z.iY=f.iY+f.F-f.AB-(A+1)*f.AC,Z.I=f.I-z-Q,Z.F=f.AC,Z.paint();if(f.D7.AZ>0)for(f.GT=0,i=f.W;i<=f.A1+(f.DJ?1:0);i++)if(f.K4=i,i===f.W||i===f.A1+(f.DJ?1:0)||(i-f.W)%M==0){(f.D7.E7.length>0||i===f.W)&&((u=new ZC.D0(f)).Z=u.C7=r,u.copy(f.D7),u.J2=Ce,u.DE()&&u.parse()),A=i-f.W,C=[],c=f.AW?f.iY+f.AB+A*f.AC:f.iY+f.F-f.AB-A*f.AC;var J=f.iX+z,V=f.I-z-Q;if(u.AN)if(f.A.AJ["3d"]){var R=new ZC.D0(f);R.copy(u),null!==ZC._n_(f.o["scale-z"])&&null!==ZC._n_(e=f.o["scale-z"].guide)&&(R.append(e),R.parse()),R.A0=R.AE=R.B7,p=ZC.DI.DB(R,f.A,a-ZC.AO.E2,a-ZC.AO.E2,c-ZC.AO.E3-R.AZ/2,c-ZC.AO.E3+R.AZ/2,0,ZC.AO.FT,"z"),f.A.CL.add(p),u.A0=u.AE=u.B7,(p=ZC.DI.DB(u,f.A,J-ZC.AO.E2,J-ZC.AO.E2+V,c-ZC.AO.E3-R.AZ/2,c-ZC.AO.E3+R.AZ/2,ZC.AO.FT+2,ZC.AO.FT+2,"x")).K=f.K+"-guide-"+i,f.A.CL.add(p)}else C.push([J,c],[J+V,c]),u.K=f.K+"-guide-"+i,ZC.CR.paint(s,u,C);f.GT++}}if(f.V.length>0&&f.G5.AN&&!f.A.AJ["3d"]){if(f.G5.o.items&&f.G5.o.items.length>0)for(Z=new ZC.HL(f),i=f.W;i<f.A1+(f.DJ?1:0);i++)for(f.K4=i,A=i-f.W,f.GT=0,h=1;h<=f.FR;h++)d=f.GT%f.G5.o.items.length,Z.append(f.G5.o.items[d]),Z.K=f.K+"-guide-"+i+"-"+h,Z.Z=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-bl-0-c"),Z.parse(),Z.iX=f.iX,f.AW?Z.iY=f.iY+f.AB+(A+1)*f.AC-(h+1)*k:Z.iY=f.iY+f.F-f.AB-(A+1)*f.AC+h*k,Z.I=f.I,Z.F=k,Z.paint(),f.GT++;if(f.G5.AZ>0)for(i=f.W;i<f.A1+(f.DJ?1:0);i++)if(f.K4=i,i%M==0)for(A=i-f.W,f.GT=0,h=1;h<=f.FR;h++)C=[],(u=new ZC.D0(f)).copy(f.G5),u.J2=Ce,u.DE()&&u.parse(),c="log"===f.C1?f.AT(f.V[i]+h*(f.V[i+1]-f.V[i])/(f.FR+1)):f.AW?f.iY+f.AB+A*f.AC+h*k:f.iY+f.F-f.AB-A*f.AC-h*k,ZC.DS(c,f.iY,f.iY+f.F)&&(C.push([f.iX,c],[f.iX+f.I,c]),u.AN&&(u.K=f.K+"-minor-guide-"+h,ZC.CR.paint(s,u,C))),f.GT++}if(f.VG(s,_),f.V.length>0&&f.IT.AN&&(!f.A.AJ["3d"]||!f.A.F0.true3d)){switch(f.IT.o.placement){case"inner":break;case"outer":O+=y;break;default:O+=y/2}for(f.GT=0,i=f.W;i<=f.A1+(f.DJ?1:0);i++)if(f.K4=i,i===f.W||i===f.A1+(f.DJ?1:0)||(i-f.W)%M==0){switch(C=[],A=i-f.W,(f.IT.E7.length>0||i===f.W)&&((u=new ZC.D0(f)).copy(f.IT),"inherit"===f.IT.o["line-color"]&&-1!==_&&(u.B7=_),u.J2=Ce,u.DE()&&u.parse()),c=f.AW?f.iY+f.AB+A*f.AC:f.iY+f.F-f.AB-A*f.AC,u.o.placement){case"ref-auto":C.push([D-y/2,c],[D+y/2,c]);break;case"ref-left":C.push([D-y,c],[D,c]);break;case"ref-right":C.push([D+y,c],[D,c]);break;case"inner":C.push([a,c],[a+(E?y:-y),c]);break;case"outer":C.push([a,c],[a-(E?y:-y),c]);break;default:C.push([a+y/2,c],[a-y/2,c])}if(u.AN){for(G=ZC._i_(u.o["offset-x"]||"0"),S=ZC._i_(u.o["offset-y"]||"0"),N=0;N<C.length;N++)C[N][0]+=G,C[N][1]+=S;u.K=f.K+"-tick-"+i,ZC.CR.paint(o,u,C)}f.GT++}}var W,U=[];if(f.V.length>0&&f.FR>0&&f.I9.AN&&!f.A.AJ["3d"])for(i=f.W;i<f.A1+(f.DJ?1:0);i++)if(i===f.W||i===f.A1+(f.DJ?1:0)||i%M==0)for(A=i-f.W,h=1;h<=f.FR;h++){if(C=[],(u=new ZC.D0(f)).copy(f.I9),"inherit"===f.I9.o["line-color"]&&-1!==_&&(u.B7=_),u.J2=Ce,u.DE()&&u.parse(),"log"===f.C1){c=f.AT(f.V[i]+h*(f.V[i+1]-f.V[i])/(f.FR+1));var j=Math.round(ZC.G6(f.V[i],f.E6)),q=f.V[i]+h*(f.V[i+1]-f.V[i])/(f.FR+1);q=j<0?ZC._f_(q.toFixed(-j)):ZC._f_(q.toFixed(j)),U.push(q),c=f.AT(q)}else c=f.AW?f.iY+f.AB+A*f.AC+h*k:f.iY+f.F-f.AB-A*f.AC-h*k;if(ZC.DS(c,f.iY,f.iY+f.F)){switch(u.o.placement){case"ref-auto":C.push([D-w/2,c],[D+w/2,c]);break;case"ref-left":C.push([D-w,c],[D,c]);break;case"ref-right":C.push([D+w,c],[D,c]);break;case"inner":C.push([a,c],[a+(E?w:-w),c]);break;case"outer":C.push([a,c],[a-(E?w:-w),c]);break;default:C.push([a+w/2,c],[a-w/2,c])}if(u.AN){for(G=ZC._i_(u.o["offset-x"]||"0"),S=ZC._i_(u.o["offset-y"]||"0"),N=0;N<C.length;N++)C[N][0]+=G,C[N][1]+=S;u.K=f.K+"-minor-tick-"+i,ZC.CR.paint(o,u,C)}}f.GT++}f.XL();var $=null,ee=f.CI,ie=f.DQ,te=0,ne=0,ae=0,le=[],oe=[];if(1===f.V.length&&f.BR.AN)f.GT=0,ce(f.W);else if(f.V.length>1&&f.BR.AN)for(f.GT=0,ce(f.W),f.GT=f.A1-f.W,ce(f.A1),f.GT=1,i=f.W+1;i<f.A1;i++)(i-f.W)%L==0&&ce(i);for(i=0;i<U.length;i++){var re=f.FQ(i,null,null,!1,U[i]);ce(re,!0,re)}if(f.M.AN&&f.M.AM&&""!==f.M.AM){(W=new ZC.DN(f)).copy(f.M),W.K=f.A.K+"-"+f.BE.replace(/\-/g,"_")+"-item_title",W.GL=f.K+"-label "+f.A.K+"-scale-label zc-scale-label",W.AM=f.M.AM,W.Z=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-ml-0-c"),W.IL=f.H.usc()?ZC.AK(f.H.K+"-main"):ZC.AK(f.H.K+"-text"),W.parse(),"inherit"!==f.M.o["font-color"]&&"inherit"!==f.M.o.color||-1===_||(W.C2=_);var se=f.iY+(f.AW?f.AB:f.BV),Ae=f.F-f.AB-f.BV;switch("chart"===W.o["center-point"]&&(se=f.A.iY,Ae=f.A.F),W.JX){case"top":W.iY=se+W.I/2-W.F/2;break;case"middle":W.iY=se+Ae/2-W.F/2;break;case"bottom":W.iY=se+Ae-W.I/2-W.F/2}W.iX=E?a-W.I/2-W.F/2-O-ne:a+W.F/2+ne+O-W.I/2,f.M.iX=W.iX,f.M.iY=W.iY,W.AN&&(f.MX(W,null,"v"),W.paint(),W.EK(),null===ZC._n_(W.o.tooltip)&&W.K9||oe.push(ZC.AP.O5(f.A.K,W)))}oe.length>0&&ZC.AK(f.A.A.K+"-map")&&(ZC.AK(f.A.A.K+"-map").innerHTML+=oe.join(""))}}function Ce(e){return e=(e=(e=(e=(e=e.replace(/%scale-last-position/g,f.A1-f.W)).replace(/(%c)|(%scale-position)/g,f.GT)).replace(/(%i)|(%scale-index)/g,f.K4)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(f.V[f.K4])?f.V[f.K4]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(f.BX[f.K4])?f.BX[f.K4]:"")}function ce(e,i,t){f.K4=e,A=e-f.W,(f.BR.E7.length>0||e===f.W||!W||f.BR.HT)&&(W=new ZC.DN(f)),W.copy(f.BR),W.K=f.A.K+"-"+f.BE.replace(/\-/g,"_")+"-item_"+(t?"c"+t:e),W.GL=f.K+"-item "+f.A.K+"-scale-item zc-scale-item",W.E["p-height"]=f.AC,f.CI=ee,f.DQ=ie,f.YM(Ce);var n="";if(n=t||f.FQ(e),f.BR.HT){var l=f.A.GX();ZC._cp_({index:e,cnt:A,text:n},l),f.H3(f.BR,W,null,l,f.BR.MJ)}if(null===ZC._n_(f.LR)||-1!==ZC.AV(f.LR,n)){switch(W.AM=n,W.Z=W.C7=f.H.usc()?f.H.mc():ZC.AK(f.A.K+"-scales-ml-0-c"),W.IL=f.H.usc()?ZC.AK(f.H.K+"-main"):ZC.AK(f.H.K+"-text"),W.E.nodeidx=e,W.parse(),"inherit"!==f.BR.o["font-color"]&&"inherit"!==f.BR.o.color||-1===_||(W.C2=_),W.J2=Ce,W.DE()&&W.parse(),W.o["auto-fit"]&&(W.F=ZC._i_(f.AC)),W.o.placement){case"inner":W.iX=E?a+y:a-W.I-y;break;case"ref-left":W.iX=D-W.I-y;break;case"ref-right":W.iX=D+y;break;case"ref-auto":K&&K.S[e]?(K.S[e].setup(),K.S[e].iX<D?W.iX=D+y:W.iX=D-W.I-y):W.iX=D+y;break;default:W.iX=E?a-W.I-y:a+y}if(i?(c=f.AT(e),W.iY=c-W.F/2-(f.DJ?f.AC/2:0)):f.AW?W.iY=f.iY+f.AB+A*f.AC-W.F/2+(f.DJ?f.AC/2:0):W.iY=f.iY+f.F-f.AB-A*f.AC-W.F/2-(f.DJ?f.AC/2:0),$=f.MX(W,$,"v"),f.BR.o["auto-align"]&&f.BR.A9%180!=0){var o=E?1:-1;90===f.BR.A9||270===f.BR.A9?W.iX+=o*(W.I/2-W.F/2):ZC.DS(f.BR.A9,0,90)||ZC.DS(f.BR.A9,270,360)?(W.iX+=o*(W.I-W.I*ZC.EH(f.BR.A9))/2,W.iY-=o*W.I*ZC.EP(f.BR.A9)/2):ZC.DS(f.BR.A9,90,270)&&(W.iX+=o*(W.I+W.I*ZC.EH(f.BR.A9))/2,W.iY+=o*W.I*ZC.EP(f.BR.A9)/2)}var r=f.X3(W,e,{items:ae,lcoords:le,lstep:L,tdim:te,mdim:ne,dim:"w",html:oe});te=r.tdim,ne=r.mdim,f.GT++}}}};ZC.SU=ZC.ZI.CA(SU);var SR={$i:function(e){this.b(e),this.CO=!0},parse:function(){this.b()},J1:function(){var e=this;e.A1===e.W?e.AC=e.I-e.AB-e.BV:e.AC=(e.I-e.AB-e.BV)/(e.A1-e.W+(e.DJ?1:0))},A96:function(e){this.b(e),this.J1()},zoomTo:function(e,i){this.b(e,i),this.J1()},clear:function(){},build:function(){this.b()},NE:function(e,i){var t,n=this;t=n.AW?(n.iX+n.I-n.AB-e)/(n.I-n.AB-n.BV):(e-n.iX-n.AB)/(n.I-n.AB-n.BV);var a=n.B3+ZC._f_((n.BJ-n.B3)*t);return"log"===n.C1&&i&&(a=Math.pow(n.E6,a)),a},AT:function(e){var i=this,t=i.BJ-i.B3,n=0===t?0:(i.I-i.AB-i.BV-(i.DJ?i.AC:0))/t;return"log"===i.C1&&(e=0===e?i.FW:ZC.G6(e,i.E6)),i.AW?i.iX+i.I-i.AB-(e-i.B3)*n:i.iX+i.AB+(e-i.B3)*n},paint:function(){var e,i,t,n,a,l,o,r,s,A,C,c,u,p,Z,h,d,f,_,g=this;if(g.AN&&0!==g.V.length){g.b(),"hbubble"!==g.A.AF&&"hscatter"!==g.A.AF||1!==g.V.length||(g.AB=g.I/2);var v=g.A0E(),b=0,B=1,m=1,E={};for(i=0,t=g.A.BO.length;i<t;i++)"scale-y"===g.A.BO[i].BE.substring(0,7)&&g.A.BO[i].BA===g.BA&&b++,"scale-y"===g.A.BO[i].BE.substring(0,7)&&("default"===g.A.BO[i].BA?(E[g.A.BO[i].BE]=B,B++):(E[g.A.BO[i].BE]=m,m++));var D=E[g.BE],K="default"===g.BA;for(i=0,t=g.A.AY.A4.length;i<t;i++){var F=g.A.AY.A4[i],x=F.BU();if(-1!==ZC.AV(x,g.BE)){var I=g.A.BL(F.BU("k")[0]);I.AT(I.H6),F;break}}var y=8;null!==ZC._n_(g.IT.o.size)&&(y=ZC._i_(g.IT.o.size));var w=4;null!==ZC._n_(g.I9.o.size)&&(w=ZC._i_(g.I9.o.size));var Y=ZC._i_(g.A.E[g.BE+"-distance"]||-1);g.VE&&(Y=0),"default"===g.BA?(Z=ZC._i_(g.A.P.DR/b),n=g.iY+g.F+(D-1)*Z,-1!==Y&&(n=g.iY+g.F+Y)):(Z=ZC._i_(g.A.P.E8/b),n=g.iY-(D-1)*Z,-1!==Y&&(n=g.iY-Y));var X=n;if(g.A.HQ&&(g.A.HQ.AN=!0,g.FW===g.B3&&g.H1===g.BJ&&(g.A.HQ.AN=!1),g.A.HQ.AN&&0===g.A.HQ.B0.BH&&"default"===g.BA&&(n+=g.A.HQ.B0.F+g.AZ/2)),g.E.iY=n,g.AN&&g.T9){for(var M=Math.ceil((g.A1-g.W)/(g.EG-1)),L=Math.ceil((g.A1-g.W)/(g.M0-1)),H=g.iStepMultiplier,P=3;P>0;P--)g.iStepMultiplier>P&&g.A1-g.W<=P*g.iStepMultiplier&&(H=P);L*=H,M*=H;var N=0,G=g.AC*L/(g.FR+1);if(a=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-ml-0-c"),l=ZC.Q.EB(a,g.H.AA),o=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-bl-0-c"),r=ZC.Q.EB(o,g.H.AA),g.T9||g.YQ||null!==ZC._n_(g.A.o[g.BE])){if("inherit"===g.o["line-color"]&&-1!==v&&(g.B7=v),g.A.AJ["3d"])(u=ZC.DI.DB(g,g.A,g.iX-ZC.AO.E2,g.iX-ZC.AO.E2+g.I,n-ZC.AO.E3,n-ZC.AO.E3,-1,ZC.AO.FT+1,"x")).K=g.K+"-line",g.A.F0.true3d&&(g.A.F0["y-angle"]>0?u.MD=[1===g.L?-100:100,1,1]:u.MD=[1===g.L?100:-100,1,1]),g.A.CL.add(u);else{s=[[g.iX,X],[g.iX+g.I,X]];var S=g.K;g.K+="-line",ZC.CR.paint(l,g,s),g.K=S}var O=[],k=0,T=0,z=[];if(g.T9||g.YQ){if(g.V.length>0&&g.D7.AN){var Q=null===ZC._n_(g.D7.o["offset-start"])?0:ZC._i_(g.D7.o["offset-start"]),J=null===ZC._n_(g.D7.o["offset-end"])?0:ZC._i_(g.D7.o["offset-end"]);if(g.D7.o.items&&g.D7.o.items.length>0&&!g.A.AJ["3d"])for(g.GT=0,d=new ZC.HL(g),i=g.W;i<g.A1+(g.DJ?1:0);i++)g.K4=i,i%L==0&&(A=i-g.W,h=g.GT%g.D7.o.items.length,d.append(g.D7.o.items[h]),d.K=g.K+"-guide-"+i,d.Z=o,d.parse(),C="log"===g.C1?g.AT(g.V[i]):g.AT(g.V[i])-(g.AW?g.AC*L:0),d.iX=C,d.iY=g.iY+Q,d.I=g.AC*L,d.F=g.F-Q-J,d.paint(),g.GT++);if(g.D7.AZ>0)for(g.GT=0,i=g.W;i<=g.A1+(g.DJ?1:0);i++)if(g.K4=i,i===g.W||i===g.A1||i%L==0){(g.D7.E7.length>0||i===g.W||"log"===g.C1)&&((c=new ZC.D0(g)).Z=c.C7=o,"log"===g.C1?ZC.AQ._int_(ZC.G6(g.V[i],g.E6))?c.copy(g.D7):c.copy(g.G5):c.copy(g.D7),c.J2=re,c.DE()&&c.parse()),s=[],A=i-g.W;var V=g.iY+Q,R=g.F-Q-J;if(C=(g.C1,g.AT(g.V[i])),c.AN)if(g.A.AJ["3d"]){var W=new ZC.D0(g);W.copy(c),null!==ZC._n_(g.o["scale-z"])&&null!==ZC._n_(e=g.o["scale-z"].guide)&&(W.append(e),W.parse()),W.A0=W.AE=W.B7,u=ZC.DI.DB(W,g.A,C-ZC.AO.E2-W.AZ/2,C-ZC.AO.E2+W.AZ/2,n-ZC.AO.E3,n-ZC.AO.E3,0,ZC.AO.FT,"z"),g.A.CL.add(u),c.A0=c.AE=c.B7,(u=ZC.DI.DB(c,g.A,C-ZC.AO.E2-c.AZ/2,C-ZC.AO.E2+c.AZ/2,V-ZC.AO.E3,V-ZC.AO.E3+R,ZC.AO.FT+2,ZC.AO.FT+2,"y")).K=g.K+"-guide-"+i,g.A.CL.add(u)}else s.push([C,V],[C,V+R]),c.K=g.K+"-guide-"+i,ZC.CR.paint(r,c,s);g.GT++}}if(g.V.length>0&&g.G5.AN&&G>2&&!g.A.AJ["3d"]){if(g.G5.o.items&&g.G5.o.items.length>0)for(d=new ZC.HL(g),i=g.W;i<g.A1+(g.DJ?1:0);i++)if(g.K4=i,i%L==0)for(A=i-g.W,g.GT=0,p=0;p<=g.FR;p++)h=g.GT%g.G5.o.items.length,d.append(g.G5.o.items[h]),d.K=g.K+"-guide-"+i+"-"+p,d.Z=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-bl-0-c"),d.parse(),C=g.AW?g.iX+g.I-g.AB-A*g.AC-(p+1)*G:g.iX+g.AB+A*g.AC+p*G,d.iX=C,d.iY=g.iY,d.I=G,d.F=g.F,d.paint(),g.GT++;if(g.G5.AZ>0&&"log"!==g.C1)for(i=g.W;i<g.A1+(g.DJ?1:0);i++)if(g.K4=i,i===g.W||i===g.A1||i%L==0)for(A=i-g.W,g.GT=0,p=1;p<=g.FR;p++)s=[],(c=new ZC.D0(g)).copy(g.G5),c.J2=re,c.DE()&&c.parse(),C="log"===g.C1?g.AT(g.V[i]+p*(g.V[i+1]-g.V[i])/(g.FR+1)):g.AT(g.V[i]+p*M*(g.V[i+1]-g.V[i])/(g.FR+1)),ZC.DS(C,g.iX,g.iX+g.I)&&(s.push([C,g.iY],[C,g.iY+g.F]),c.AN&&(c.K=g.K+"-minor-guide-"+p,ZC.CR.paint(r,c,s))),g.GT++}var U,j,q;if(g.VG(r,v),g.V.length>0&&g.IT.AN&&(!g.A.AJ["3d"]||!g.A.F0.true3d)){switch(g.IT.o.placement){case"inner":break;case"outer":N+=y;break;default:N+=y/2}for(g.GT=0,f=ZC.AV(g.V,0),i=g.W;i<=g.A1+(g.DJ?1:0);i++){g.K4=i;var $=-1;if((i===g.W||i===g.A1||i%L==0||ZC._b_(g.o["show-zero"])&&i===f)&&(s=[],A=i-g.W,(g.IT.E7.length>0||i===g.W||"log"===g.C1)&&(c=new ZC.D0(g),"log"===g.C1?ZC.AQ._int_(ZC.G6(g.V[i],g.E6))?c.copy(g.IT):(c.copy(g.I9),$=y,y=w):c.copy(g.IT),"inherit"===g.IT.o["line-color"]&&-1!==v&&(c.B7=v),c.J2=re,c.DE()&&c.parse()),C=(g.C1,g.AT(g.V[i])),ZC.DS(C,g.A.P.iX,g.A.P.iX+g.A.P.I))){switch(c.o.placement){case"inner":s.push([C,n-(K?y:-y)],[C,n]);break;case"outer":s.push([C,n],[C,n+(K?y:-y)]);break;default:s.push([C,n+y/2],[C,n-y/2])}if(-1!==$&&(y=$,$=-1),c.AN){for(j=ZC._i_(c.o["offset-x"]||"0"),q=ZC._i_(c.o["offset-y"]||"0"),U=0;U<s.length;U++)s[U][0]+=j,s[U][1]+=q;c.K=g.K+"-tick-"+i,ZC.CR.paint(l,c,s)}g.GT++}}}if(g.V.length>0&&g.I9.AN&&g.FR>0&&G>5&&!g.A.AJ["3d"]&&"log"!==g.C1)for(i=g.W;i<g.A1+(g.DJ?1:0);i++)if(g.K4=i,i===g.W||i===g.A1||i%L==0)for(A=i-g.W,g.GT=0,p=1;p<=g.FR;p++){if(s=[],(c=new ZC.D0(g)).copy(g.I9),"inherit"===g.I9.o["line-color"]&&-1!==v&&(c.B7=v),c.J2=re,c.DE()&&c.parse(),C="log"===g.C1?g.AT(g.V[i]+p*(g.V[i+1]-g.V[i])/(g.FR+1)):g.AT(g.V[i]+p*M*(g.V[i+1]-g.V[i])/(g.FR+1)),ZC.DS(C,g.iX,g.iX+g.I)){switch(c.o.placement){case"inner":s.push([C,n-(K?w:-w)],[C,n]);break;default:s.push([C,n],[C,n+(K?w:-w)]);break;case"cross":s.push([C,n+w/2],[C,n-w/2])}if(c.AN){for(j=ZC._i_(c.o["offset-x"]||"0"),q=ZC._i_(c.o["offset-y"]||"0"),U=0;U<s.length;U++)s[U][0]+=j,s[U][1]+=q;c.K=g.K+"-minor-tick-"+i,ZC.CR.paint(l,c,s)}}g.GT++}g.XL();var ee=null,ie=g.CI,te=g.DQ,ne=function(e){var i;if(g.K4=e,A=e-g.W,(g.BR.E7.length>0||e===g.W||!_||g.BR.HT)&&(_=new ZC.DN(g)),_.copy(g.BR),_.GL=g.K+"-item "+g.A.K+"-scale-item zc-scale-item",_.K=g.A.K+"-"+g.BE.replace(/\-/g,"_")+"-item_"+e,g.CI=ie,g.DQ=te,g.YM(re),i=("piano"===g.A.AF||g.PZ)&&g.BX.length?g.FQ(e+g.B3):g.FQ(e),g.BR.HT){var t=g.A.GX();ZC._cp_({index:e,cnt:A,text:i},t),g.H3(g.BR,_,null,t,g.BR.MJ)}if(null===ZC._n_(g.LR)||-1!==ZC.AV(g.LR,i)){switch(_.AM=i,_.Z=_.C7=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-ml-0-c"),_.IL=g.H.usc()?ZC.AK(g.H.K+"-main"):ZC.AK(g.H.K+"-text"),_.parse(),"inherit"!==g.BR.o["font-color"]&&"inherit"!==g.BR.o.color||-1===v||(_.C2=v),_.J2=re,_.E7=g.BR.E7,_.DE()&&_.parse(),_.o.placement){case"inner":_.iY=K?n-_.KA-y:n+y;break;default:_.iY=K?n+y:n-_.KA-y}if("log"===g.C1?_.iX=g.AT(g.V[e])-_.I/2:_.iX=g.AT(g.V[e])-_.I/2-(g.AW?1:-1)*(g.DJ?g.AC/2:0),ee=g.MX(_,ee,"h"),g.BR.o["auto-align"]&&g.BR.A9%180!=0){var a=ZC.DS(g.BR.A9,0,180)?K?1:-1:1===K?-1:1;_.iX+=a*_.I*ZC.EH(g.BR.A9)/2,_.iY+=a*(_.I*ZC.EP(g.BR.A9)/2-_.F*ZC.EP(g.BR.A9)/2)}if(ZC.DS(_.iX+_.I/2,g.A.P.iX,g.A.P.iX+g.A.P.I)){var l=g.X3(_,e,{items:0,lcoords:O,lstep:M,tdim:k,mdim:T,dim:"h",html:z});k=l.tdim,T=l.mdim,g.GT++}}};if(g.V.length>0&&g.BR.AN)if("log"===g.C1){var ae=[];for(i=g.W;i<=g.A1;i++)ZC.AQ._int_(ZC.G6(g.V[i],g.E6))&&(g.GT=i,ne(i),ae.push(i));for(i=g.W;i<=g.A1;i++)-1===ZC.AV(ae,i)&&(g.GT=i,ne(i))}else for(g.GT=0,ne(g.W),g.GT=g.A1-g.W,ne(g.A1),-1!==(f=ZC.AV(g.V,0))&&ZC._b_(g.o["show-zero"])&&(g.GT=f,ne(f)),g.GT=1,i=g.W+1;i<g.A1;i++)i%M==0&&ne(i)}if(g.M.AN&&g.M.AM&&""!==g.M.AM){(_=new ZC.DN(g)).copy(g.M),_.K=g.A.K+"-"+g.BE.replace(/\-/g,"_")+"-item_title",_.GL=g.K+"-label "+g.A.K+"-scale-label zc-scale-label",_.AM=g.M.AM,_.Z=g.H.usc()?g.H.mc():ZC.AK(g.A.K+"-scales-ml-0-c"),_.IL=g.H.usc()?ZC.AK(g.H.K+"-main"):ZC.AK(g.H.K+"-text"),_.parse(),"inherit"!==g.M.o["font-color"]&&"inherit"!==g.M.o.color||-1===v||(_.C2=v);var le=g.iX+(g.AW?g.BV:g.AB),oe=g.I-g.AB-g.BV;switch("chart"===_.o["center-point"]&&(le=g.A.iX,oe=g.A.I),_.O8){case"left":_.iX=le;break;case"center":_.iX=le+oe/2-_.I/2;break;case"right":_.iX=le+oe-_.I}_.iY=K?n+N+T:n-T-_.F-N,g.M.iX=_.iX,g.M.iY=_.iY,_.AN&&(g.MX(_,null,"h"),_.paint(),_.EK(),null===ZC._n_(_.o.tooltip)&&_.K9||z.push(ZC.AP.O5(g.A.K,_)))}z.length>0&&ZC.AK(g.A.A.K+"-map")&&(ZC.AK(g.A.A.K+"-map").innerHTML+=z.join(""))}}}function re(e){return e=(e=(e=(e=(e=e.replace(/%scale-last-position/g,g.A1-g.W)).replace(/(%c)|(%scale-position)/g,g.GT)).replace(/(%i)|(%scale-index)/g,g.K4)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(g.V[g.K4])?g.V[g.K4]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(g.BX[g.K4])?g.BX[g.K4]:"")}}};ZC.SR=ZC.VQ.CA(SR);var T2={$i:function(e){this.b(e);var i=this;i.NF="",i.KS=1,i.H0=1,i.GK=0,i.GF=0,i.JE=.6},parse:function(){var e=this;e.b(),e.iX+=e.DY,e.iY+=e.E8,e.I-=e.DY+e.E9,e.F-=e.E8+e.DR,e.ZQ("layout","NF"),null!==ZC._n_(e.o["size-factor"])&&(e.JE=ZC._f_(ZC._p_(e.o["size-factor"])))},A96:function(e){var i=this;i.b(e),0===i.V.length&&(i.V=[""]);var t=ZC.AQ.A2C(i.NF,i.V.length,!1);i.KS=t[0],i.H0=t[1],i.GK=i.I/i.H0,i.GF=i.F/i.KS},A51:function(){var e=this;e.b(),e.GK=e.I/e.H0,e.GF=e.F/e.KS},clear:function(){},build:function(){this.b()},paint:function(){var e,i,t,n,a,l=this;if(l.AN){if(l.b(),e=ZC.Q.EB(l.H.usc()?l.H.K+"-main-c":l.A.K+"-scales-ml-0-c",l.H.AA),i=ZC.Q.EB(l.H.usc()?l.H.K+"-main-c":l.A.K+"-scales-bl-0-c",l.H.AA),(t=[]).push([l.iX,l.iY],[l.iX+l.I,l.iY],[l.iX+l.I,l.iY+l.F],[l.iX,l.iY+l.F],[l.iX,l.iY]),ZC.CR.paint(e,l,t),l.D7.AN){if(l.D7.o.items&&l.D7.o.items.length>0)for(n=0,a=l.V.length;n<a;n++){var o=n%l.H0,r=Math.floor(n/l.H0),s=new ZC.HL(l),A=n%l.D7.o.items.length;s.o=l.D7.o.items[A],s.K=l.K+"-guide-"+n,s.Z=l.H.usc()?l.H.mc():ZC.AK(l.A.K+"-scales-bl-0-c"),s.parse(),s.iX=l.iX+o*l.GK,s.iY=l.iY+r*l.GF,s.I=l.GK,s.F=l.GF,s.paint()}if(l.D7.AZ>0){for(t=[],n=0;n<=l.H0;n++)t.push([l.iX+n*l.GK,l.iY],[l.iX+n*l.GK,l.iY+l.F],null);for(n=0;n<=l.KS;n++)t.push([l.iX,l.iY+n*l.GF],[l.iX+l.I,l.iY+n*l.GF],null);ZC.CR.paint(i,l.D7,t)}}var C,c=[];if(l.BR.AN){for(n=0,a=l.V.length;n<a;n++)u(n);c.length>0&&ZC.AK(l.A.A.K+"-map")&&(ZC.AK(l.A.A.K+"-map").innerHTML+=c.join(""))}}function u(e){(l.BR.E7.length>0||0===e)&&(C=new ZC.DN(l)),C.copy(l.BR);var i=e%l.H0,t=Math.floor(e/l.H0);C.GL=l.K+"-item "+l.A.K+"-scale-item zc-scale-item",C.K=l.A.K+"-"+l.BE.replace(/\-/g,"_")+"-item_"+e;var n=l.FQ(e);if((null===ZC._n_(l.LR)||-1!==ZC.AV(l.LR,n))&&(C.AM=n,C.Z=l.H.usc()?l.H.mc():ZC.AK(l.A.K+"-scales-ml-0-c"),C.parse(),C.J2=function(i){return i=(i=(i=i.replace(/%i/g,e)).replace(/%v/g,null!==ZC._n_(l.V[e])?l.V[e]:"")).replace(/%l/g,null!==ZC._n_(l.BX[e])?l.BX[e]:"")},C.E7=l.BR.E7,C.DE()&&C.parse(),C.AN)){var a="bottom";null!==ZC._n_(l.BR.o.placement)&&(a=l.BR.o.placement);var o=l.iX+i*l.GK,r=l.iY+t*l.GF;switch(a){case"top-left":C.iX=o,C.iY=r;break;case"top-right":C.iX=o+l.GK-C.I,C.iY=r;break;case"bottom-left":C.iX=o,C.iY=r+l.GF-C.F;break;case"bottom-right":C.iX=o+l.GK-C.I,C.iY=r+l.GF-C.F;break;case"top":C.iX=o+l.GK/2-C.I/2,C.iY=r;break;case"right":C.iX=o+l.GK-C.I,C.iY=r+l.GF/2-C.F/2;break;case"left":C.iX=o,C.iY=r+l.GF/2-C.F/2;break;default:C.iX=o+l.GK/2-C.I/2,C.iY=r+l.GF-C.F}C.paint(),C.EK(),null===ZC._n_(l.o.tooltip)&&C.K9||c.push(ZC.AP.O5(l.A.K,C))}}}};ZC.T2=ZC.ZI.CA(T2);var A2B={$i:function(e){this.b(e);this.DH=0,this.EI=360},parse:function(){var e,i=this;i.b(),null!==ZC._n_(e=i.o["ref-angle"])&&(i.DH=ZC._i_(e)%360),null!==ZC._n_(e=i.o.aperture)&&(i.EI=ZC._i_(e)%360,0===i.EI&&(i.EI=360))}};ZC.A2B=ZC.ZI.CA(A2B);var A4E={$i:function(e){this.b(e)},parse:function(){this.b()},J1:function(){},A96:function(e){this.b(e),this.J1()},clear:function(){this.b()},build:function(){this.b()},paint:function(){this.b()}};ZC.A4E=ZC.VQ.CA(A4E),ZC.A7Z=ZC.A4E.CA({$i:function(e){this.b(e);var i=this;i.DH=-90,i.EI=180,i.QA=null,i.IW=null,i.CW="circle"},parse:function(){var e,i=this;i.b(),null!==ZC._n_(e=i.o["ref-angle"])&&(i.DH=ZC._i_(e)%360),null!==ZC._n_(e=i.o.aperture)&&(i.EI=ZC._i_(e)),null!==ZC._n_(e=i.o.center)&&(i.QA=new ZC.DT(i),i.QA.append(e),i.QA.parse()),null!==ZC._n_(e=i.o.ring)&&(i.IW=new ZC.DT(i),i.H.B8.load(i.IW.o,[i.A.AF+"."+i.BE+".ring"]),i.IW.append(e),i.IW.parse())},A96:function(e){this.b(e)},clear:function(){},build:function(){this.b()},AT:function(e){var i=this,t=i.A.BL("scale"),n=t.iX+t.I/2,a=t.iY+t.F/2,l=i.A.BL("scale-"+i.L);l||(l=i.A.BL("scale"));var o=ZC.CY(l.GK/2,l.GF/2)*l.JE,r=i.BJ-i.B3,s=i.EI/r;return ZC.AQ.BN(n,a,o,i.DH-i.EI/2+s*(e-i.B3))},IB:function(e){return this.AT(this.V[e])},paintMarker:function(e){var i,t=this;if(e.F7){var n,a=t.A.BL("scale-"+t.L);if(a||(a=t.A.BL("scale")),e.AN){var l=t.A.K+"-scales-"+("top"===e.BA?"f":"b")+"l-0-c";e.Z=e.C7=ZC.AK(t.H.usc()?a.H.K+"-main-c":l),n=ZC.Q.EB(e.Z,t.H.AA);var o=ZC.CY(a.GK/2,a.GF/2)*a.JE,r=ZC.II(e.o["offset-start"]||"0");r>0&&r<1&&(r*=o);var s=ZC.II(e.o["offset-end"]||"0");s>0&&s<1&&(s*=o),e.M&&(e.M.Z=t.H.usc()?t.H.mc():ZC.AK(t.A.K+"-scales-ml-0-c"),e.M.K=e.A.A.K+"-"+e.A.BE.replace(/\-/g,"_")+"-marker_"+e.L,e.M.GL=e.A.K+"-marker-label "+e.A.A.K+"-scale-marker-label zc-scale-marker-label");for(var A=0;A<a.V.length;A++){var C,c=A%a.H0,u=Math.floor(A/a.H0),p=a.iX+c*a.GK+a.GK/2+a.BM,Z=a.iY+u*a.GF+a.GF/2+a.BH;switch(e.AF){case"line":if(e.F7.length>0){var h=t.DH-t.EI/2+t.EI*(e.F7[0]-t.B3)/(t.BJ-t.B3);C=h;var d=[];d.push(ZC.AQ.BN(p,Z,r,h)),d.push(ZC.AQ.BN(p,Z,o-s,h)),2===d.length&&(ZC.CR.setup(n,e),ZC.CR.paint(n,e,d))}break;case"area":if(e.F7.length>1){var f=t.DH-t.EI/2+t.EI*(e.F7[0]-t.B3)/(t.BJ-t.B3),_=t.DH-t.EI/2+t.EI*(e.F7[1]-t.B3)/(t.BJ-t.B3);C=(f+_)/2;var g=new ZC.DT(e);g.Z=e.Z,g.append(e.o),g.append({size:o-s,slice:r,type:"pie","angle-start":f,"angle-end":_}),g.K=a.K+"-marker-"+e.L,g.iX=p,g.iY=Z,g.parse(),g.paint()}}if(e.M){var v;null!==ZC._n_(i=e.M.o["offset-r"])?v=ZC._f_(ZC._p_(i)):v<1?v*=o-s-r:v=0;var b=ZC.AQ.BN(p,Z,(o-s-r)/2+v,C);e.M.iX=b[0]-e.M.I/2,e.M.iY=b[1]-e.M.F/2,e.M.paint()}}}}},paint:function(){var e,i,t,n,a,l,o,r,s,A=this;if(A.AN&&0!==A.V.length){A.AW&&A.V.reverse(),e=ZC.Q.EB(A.H.usc()?A.H.K+"-main-c":A.A.K+"-scales-bl-0-c",A.H.AA);var C=ZC._i_(A.IT.o.size||8),c=ZC._i_(A.I9.o.size||4),u=0,p=ZC.BQ(1,Math.ceil((A.A1-A.W)/(A.M0-1))),Z=ZC.BQ(1,Math.ceil((A.A1-A.W)/(A.EG-1))),h=A.A.BL("scale-"+A.L);h||(h=A.A.BL("scale"));for(var d,f,_,g=ZC.CY(h.GK/2,h.GF/2)*h.JE,v=A.EI/(A.V.length-1),b=0;b<h.V.length;b++){var B=b%h.H0,m=Math.floor(b/h.H0),E=h.iX+B*h.GK+h.GK/2+h.BM,D=h.iY+m*h.GF+h.GF/2+h.BH,K=new ZC.DT(A);if(K.Z=A.H.usc()?A.H.mc():ZC.AK(A.A.K+"-scales-bl-0-c"),K.copy(A),K.K=A.K+"-"+b,K.iX=E,K.iY=D,K.AI=g-.5,K.DU=360===A.EI?"circle":"pie",K.B4=A.DH-A.EI/2+360,K.BK=A.DH+A.EI/2+360,K.CN=0,K.parse(),K.paint(),A.D7.AN){if(A.D7.o.items&&A.D7.o.items.length>0)for(i=0;i<A.V.length-1;i++)K=new ZC.DT(A),o=i%A.D7.o.items.length,K.append(A.D7.o.items[o]),K.Z=A.H.usc()?A.H.mc():ZC.AK(A.A.K+"-scales-bl-0-c"),K.iX=E,K.iY=D,K.K=A.K+"-pie-"+i,K.o.type="pie",K.o.size=g-A.BV,K.CN=A.AB,K.B4=A.DH-A.EI/2+i*v+360,K.BK=A.DH-A.EI/2+(i+1)*v+360,K.parse(),K.paint();if(A.D7.AZ>0)for(i=0,t=A.V.length;i<t;i++)(d=new ZC.D0(A)).copy(A.D7),d.J2=Y,d.E7=A.D7.E7,d.DE()&&d.parse(),(l=[]).push(ZC.AQ.BN(E,D,g-A.BV,A.DH-A.EI/2+i*v)),l.push(ZC.AQ.BN(E,D,A.AB,A.DH-A.EI/2+i*v)),ZC.CR.paint(e,d,l)}if(A.G5.AN&&A.G5.AZ>0&&A.FR>0)for(i=0,t=A.V.length;i<t-1;i++)for(r=A.DH-A.EI/2+i*v,f=v/(A.FR+1),_=1;_<=A.FR;_++)(d=new ZC.D0(A)).copy(A.G5),d.J2=Y,d.E7=A.G5.E7,d.DE()&&d.parse(),(l=[]).push(ZC.AQ.BN(E,D,g-A.BV,A.DH-A.EI/2+i*v+_*f)),l.push(ZC.AQ.BN(E,D,A.AB,A.DH-A.EI/2+i*v+_*f)),ZC.CR.paint(e,d,l);if(A.XL(),A.H.ZV(),A.IW&&((a=new ZC.DT(A)).append(A.IW.o),a.Z=A.H.usc()?A.H.mc():ZC.AK(A.A.K+"-scales-bl-0-c"),a.K=A.K+"-ring",a.iX=E,a.iY=D,360!==A.EI?(a.o.type="pie",n=ZC._i_(a.o.size),n=ZC.BQ(1,ZC.CY(n,g)),a.CN=g-n,a.o.size=g,a.B4=A.DH-A.EI/2+360,a.BK=A.DH+A.EI/2+360):(a.o.type="circle",n=ZC._i_(a.o.size),n=ZC.BQ(1,ZC.CY(n,g)),a.o.size=g),a.parse(),a.AN&&n+a.AU>0&&(a.paint(),360===A.EI&&(a.K=A.K+"-ring-inner",a.o.size=g-n,a.parse(),a.paint())),A.IW.o.items&&A.IW.o.items.length>0||A.IW.o.rules))for(i=0;i<A.V.length-1;i++)(a=new ZC.DT(A)).append(A.IW.o),A.IW.o.items&&(o=i%A.IW.o.items.length,a.append(A.IW.o.items[o])),a.Z=A.H.usc()?A.H.mc():ZC.AK(A.A.K+"-scales-bl-0-c"),a.K=A.K+"-ring-"+i,a.iX=E,a.iY=D,a.o.type="pie",n=ZC._i_(a.o.size),n=ZC.BQ(0,ZC.CY(n,g)),a.CN=g-n,a.o.size=g,a.B4=A.DH-A.EI/2+i*v+360,a.BK=A.DH-A.EI/2+(i+1)*v+360+.25,a.parse(),a.J2=Y,a.E7=A.IW.E7,a.DE()&&a.parse(),a.AN&&n+a.AU>0&&a.paint();if(A.IT.AN){switch(A.IT.o.placement){case"outer":u+=C;break;default:u+=C/2}for(l=[],i=0,t=A.V.length;i<t;i++)if(i===A.W||i===A.A1||i%p==0){switch(r=A.DH-A.EI/2+i*v,s=[0,0],A.IT.o.placement){case"inner":s=[-C,0];break;case"outer":s=[0,C];break;default:s=[-C/2,C/2]}l.push(ZC.AQ.BN(E,D,g+s[0],r),ZC.AQ.BN(E,D,g+s[1],r),null)}ZC.CR.paint(e,A.IT,l)}if(A.I9.AN&&A.FR>0){for(l=[],i=0,t=A.V.length;i<t-1;i++)for(r=A.DH-A.EI/2+i*v,f=v/(A.FR+1),_=1;_<=A.FR;_++){switch(s=[0,0],A.I9.o.placement){case"inner":s=[-c,0];break;case"outer":s=[0,c];break;default:s=[-c/2,c/2]}l.push(ZC.AQ.BN(E,D,g+s[0],r+_*f),ZC.AQ.BN(E,D,g+s[1],r+_*f),null)}ZC.CR.paint(e,A.I9,l)}if(A.BR.AN){var F=[];for(i=0,t=A.V.length;i<t;i++)if(i===A.W||i===A.A1||i%Z==0){var x=new ZC.DN(A);x.append(A.BR.o),x.GL=A.K+"-item "+A.A.K+"-scale-item zc-scale-item",x.K=A.A.K+"-"+A.BE.replace(/\-/g,"_")+"-item_"+b+"_"+i;var I=A.FQ(i);if(x.AM=I,x.Z=x.C7=A.H.usc()?A.H.mc():ZC.AK(A.A.K+"-scales-ml-0-c"),x.parse(),"auto"===x.o.angle&&(x.A9=A.DH-A.EI/2+i*v+90),x.J2=Y,x.E7=A.BR.E7,x.DE()&&x.parse(),x.AN){x.F=x.KA;var y,w=1.15*Math.sqrt(x.I*x.I/4+x.F*x.F/4);switch(A.BR.o.placement){case"inner":y=ZC.AQ.BN(E,D,g+A.BR.DV-w-5+u,A.DH-A.EI/2+i*v);break;default:y=ZC.AQ.BN(E,D,g+A.BR.DV+w+u,A.DH-A.EI/2+i*v)}x.iX=y[0]-x.I/2,x.iY=y[1]-x.F/2,x.paint(),x.EK(),null===ZC._n_(A.o.tooltip)&&x.K9||(null!==ZC._n_(A.o.tooltip)&&(A.o.tooltip.text=A.o.tooltip.text||"%scale-value"),F.push(ZC.AP.O5(A.A.K,x)))}}F.length>0&&ZC.AK(A.A.A.K+"-map")&&(ZC.AK(A.A.A.K+"-map").innerHTML+=F.join(""))}}}function Y(e){return e=(e=(e=(e=e.replace(/%i/g,i)).replace(/%k/g,i)).replace(/%v/g,null!==ZC._n_(A.V[i])?A.V[i]:"")).replace(/%l/g,null!==ZC._n_(A.BX[i])?A.BX[i]:"")}},paint_:function(){var e=this,i=e.A.BL("scale-"+e.L);i||(i=e.A.BL("scale"));for(var t=0;t<i.V.length;t++){var n=t%i.H0,a=Math.floor(t/i.H0),l=i.iX+n*i.GK+i.GK/2+i.BM,o=i.iY+a*i.GF+i.GF/2+i.BH;if(e.QA){var r=new ZC.DT(e);r.append(e.QA.o),r.Z=r.C7=e.H.usc()?e.H.mc("top"):ZC.AK(e.A.K+"-scales-ml-0-c"),r.K=e.K+"-"+t+"-center",r.iX=l,r.iY=o,r.o.type=r.o.type||"circle",r.parse(),r.AN&&r.paint()}}}});var ZL={$i:function(e){this.b(e);var i=this;i.DH=0,i.CW="star",i.DJ=!1},parse:function(){this.b(),this.assign_a([["aspect","CW"],["ref-angle","DH","i"],["ranged","DJ","b"]])},A7U:function(){var e=this,i=ZC.BQ(e.V.length,e.BX.length);e.EG=ZC.CY(30,i)},A96:function(e){this.b(e)},clear:function(){},build:function(){this.b()},A71:function(e,i,t){var n=this,a=n.A.BL("scale"),l=a.iX+a.I/2,o=a.iY+a.F/2,r=n.A.BL("scale-v");if(t){var s=n.DH+n.EI*(e-n.B3)/(n.BJ-n.B3);return ZC.AQ.BN(l,o,i+r.AB,s)}var A=n.EI/(n.V.length-(360===n.EI||n.DJ?0:1));return ZC.AQ.BN(l,o,i+r.AB,n.DH+e*A)},IB:function(e){var i=this.A.BL("scale"),t=ZC.CY(i.I/2,i.F/2)*i.JE;return this.A71(e,t)},AT:function(e){var i=this,t=ZC.AV(i.V,e);-1===t&&(t=0);var n=i.A.BL("scale"),a=ZC.CY(n.I/2,n.F/2)*n.JE;return i.A71(t,a)},paint:function(){var e,i,t,n,a,l,o,r,s=this;if(s.AN&&0!==s.V.length){s.b();var A=ZC.BQ(1,Math.floor((s.A1-s.W)/(s.M0-1))),C=ZC.BQ(1,Math.floor((s.A1-s.W)/(s.EG-1)));e=ZC.Q.EB(s.H.usc()?s.H.K+"-main-c":s.A.K+"-scales-ml-0-c",s.H.AA),i=ZC.Q.EB(s.H.usc()?s.H.K+"-main-c":s.A.K+"-scales-bl-0-c",s.H.AA);var c,u=ZC._i_(s.IT.o.size||8),p=0,Z=s.A.BL("scale"),h=ZC.CY(Z.I/2,Z.F/2)*Z.JE,d=s.A.BL("scale-v"),f=Z.iX+Z.I/2,_=Z.iY+Z.F/2,g=s.EI/(s.V.length-(360===s.EI||s.DJ?0:1));if(s.D7.AN){if(s.D7.o.items&&s.D7.o.items.length>0){var v=0;for(t=0,n=s.V.length-(360===s.EI||s.DJ?0:1);t<n;t+=A){if(r=s.DH+t*g,"circle"===s.CW){var b=new ZC.DT(s);a=v%s.D7.o.items.length,b.append(s.D7.o.items[a]),b.Z=s.H.usc()?s.H.mc():ZC.AK(s.A.K+"-scales-bl-0-c"),b.iX=f,b.iY=_,b.o.type="pie",b.o.size=h,b.CN=d.AB,b.B4=r,b.BK=r+A*g,b.parse(),b.paint()}else{var B=new ZC.DT(s);a=v%s.D7.o.items.length,B.o=s.D7.o.items[a],B.Z=s.H.usc()?s.H.mc():ZC.AK(s.A.K+"-scales-bl-0-c"),B.AZ=0,B.AU=0,B.EX=0,B.G9=0,(l=[]).push(ZC.AQ.BN(f,_,d.AB,r),ZC.AQ.BN(f,_,h,r),ZC.AQ.BN(f,_,h,r+A*g),ZC.AQ.BN(f,_,d.AB,r+A*g)),B.D=l,B.parse();var m=s.A.P;B.D1=[m.iX,m.iY,m.iX+m.I,m.iY+m.F],B.paint()}v++}}if(s.D7.AZ>0)for(t=0,n=s.V.length+(s.DJ?1:0);t<n;t+=A)r=s.DH+t*g,(o=new ZC.D0(s)).copy(s.D7),o.K=s.K+"-guide-"+t,o.J2=I,o.E7=s.D7.E7,o.DE()&&o.parse(),(l=[]).push(ZC.AQ.BN(f,_,h,r),ZC.AQ.BN(f,_,d.AB,r)),ZC.CR.paint(i,o,l)}if(s.IT.AN){switch(s.IT.o.placement){case"inner":break;case"outer":p+=u;break;default:p+=u/2}for(l=[],t=0,n=s.V.length+(s.DJ?1:0);t<n;t+=A){switch(r=s.DH+t*g,(o=new ZC.D0(s)).copy(s.IT),o.o.placement){case"inner":l=[ZC.AQ.BN(f,_,h-u,r),ZC.AQ.BN(f,_,h,r)];break;case"outer":l=[ZC.AQ.BN(f,_,h,r),ZC.AQ.BN(f,_,h+u,r)];break;default:l=[ZC.AQ.BN(f,_,h-u/2,r),ZC.AQ.BN(f,_,h+u/2,r)]}for(var E=ZC._i_(o.o["offset-x"]||"0"),D=ZC._i_(o.o["offset-y"]||"0"),K=0;K<l.length;K++)l[K]&&(l[K][0]+=E,l[K][1]+=D);o.K=s.K+"-tick-"+t,ZC.CR.paint(e,o,l)}}var F,x=[];if(s.BR.AN){for(t=0,n=s.V.length;t<n;t+=C)y(t);x.length>0&&ZC.AK(s.A.A.K+"-map")&&(ZC.AK(s.A.A.K+"-map").innerHTML+=x.join(""))}}function I(e){return e=(e=(e=e.replace(/(%i)|(%scale-index)/g,t)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(s.V[t])?s.V[t]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(s.BX[t])?s.BX[t]:"")}function y(e){(s.BR.E7.length>0||0===e)&&(c=new ZC.DN(s)),c.copy(s.BR),c.GL=s.K+"-item "+s.A.K+"-scale-item zc-scale-item",c.K=s.A.K+"-"+s.BE.replace(/\-/g,"_")+"-item_"+e;var i=s.FQ(e);if(null===ZC._n_(s.LR)||-1!==ZC.AV(s.LR,i)){c.AM=i,c.Z=c.C7=s.H.usc()?s.H.mc():ZC.AK(s.A.K+"-scales-ml-0-c"),c.parse(),c.J2=function(i){return i=(i=(i=i.replace(/(%i)|(%scale-index)/g,e)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(s.V[e])?s.V[e]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(s.BX[e])?s.BX[e]:"")},c.E7=s.BR.E7,c.DE()&&c.parse();var t=ZC.II(c.DV,!0);if(t>-1&&t<1&&(t*=h),r=s.DH+e*g+(s.DJ?g/2:0),s.BR.o["auto-align"]){var n=1.25;1-ZC._a_(ZC.EH(r))>.7&&(n=2.5*(1-ZC._a_(ZC.EH(r))));var a=(1-ZC._a_(ZC.EH(r)))*c.DG*n;F=ZC.AQ.BN(f,_,h+t+p+a,r),ZC.EH(r)>0?(c.iX=F[0],c.iY=F[1]-c.F/2):(c.iX=F[0]-c.I,c.iY=F[1]-c.F/2)}else s.BR.o["auto-rotate"]?(F=ZC.AQ.BN(f,_,h+t+p+c.F/2,r),c.iX=F[0]-c.I/2,c.iY=F[1]-c.F/2,c.A9=r+90):(F=ZC.AQ.BN(f,_,h+t+p+ZC._a_(10*ZC.EP(r))+ZC._a_(c.I/2*ZC.EH(r)),r),c.iX=F[0]-c.I/2,c.iY=F[1]-c.F/2);c.AN&&(c.paint(),c.EK(),null===ZC._n_(s.o.tooltip)&&c.K9||(null!==ZC._n_(s.o.tooltip)&&(s.o.tooltip.text=s.o.tooltip.text||"%scale-value"),x.push(ZC.AP.O5(s.A.K,c))))}}}};ZC.ZL=ZC.A2B.CA(ZL);var ZK={$i:function(e){this.b(e)},parse:function(){this.b()},J1:function(){var e=this,i=e.A.BL("scale"),t=ZC.CY(i.I/2,i.F/2)*i.JE;e.AC=(t-e.AB-e.BV)/(e.A1-e.W)},A96:function(e){this.b(e),this.J1()},A7U:function(){var e=this,i=e.A.BL("scale"),t=ZC.CY(i.I/2,i.F/2)*i.JE;e.EG=ZC.BQ(2,ZC._i_((t-e.AB-e.BV)/20))},U6:function(e){var i=this,t=i.A.BL("scale"),n=ZC.CY(t.I/2,t.F/2)*t.JE,a=i.BJ-i.B3,l=(n-i.AB-i.BV)/a;return(e-i.B3)*l},AT:function(e){var i=this,t=i.U6(e),n=i.A.BL("scale-k"),a=i.A.BL("scale"),l=a.iX+a.I/2+a.BM,o=a.iY+a.F/2+a.BH;return ZC.AQ.BN(l,o,t,n.DH)},clear:function(){},build:function(){this.b()},paint:function(){var e,i,t,n,a,l,o,r=this;if(r.AN&&0!==r.V.length){r.b(),e=ZC.Q.EB(r.H.usc()?r.H.K+"-main-c":r.A.K+"-scales-ml-0-c",r.H.AA),i=ZC.Q.EB(r.H.usc()?r.H.K+"-main-c":r.A.K+"-scales-bl-0-c",r.H.AA);var s,A,C=r.A.BL("scale-k"),c=ZC._i_(r.IT.o.size||8),u=Math.ceil((r.A1-r.W)/(r.EG-1)),p=Math.ceil((r.A1-r.W)/(r.M0-1)),Z=r.A.BL("scale"),h=ZC.CY(Z.I/2,Z.F/2)*Z.JE,d=Z.iX+Z.I/2+Z.BM,f=Z.iY+Z.F/2+Z.BH,_=C.EI/(C.V.length-(360===C.EI||C.DJ?0:1));if(r.D7.AN){if(r.D7.o.items&&r.D7.o.items.length>0)for(t=0,n=r.V.length;t<n-1;t++){var g=t%r.D7.o.items.length;if("circle"===C.CW){var v=new ZC.DT(r);v.Z=r.H.usc()?r.H.mc():ZC.AK(r.A.K+"-scales-bl-0-c"),v.append(r.D7.o.items[g]),v.o.type="pie",v.o.size=r.AB+(t+1)*r.AC,v.iX=d,v.iY=f,v.CN=r.AB+t*r.AC,360===C.EI?(v.B4=0,v.BK=360):(v.B4=C.DH,v.BK=C.DH+C.EI),v.parse(),v.paint()}else{var b=new ZC.DT(r);for(b.append(r.D7.o.items[g]),b.Z=r.H.usc()?r.H.mc():ZC.AK(r.A.K+"-scales-bl-0-c"),o=[],a=0,l=C.V.length;a<l;a++)o.push(ZC.AQ.BN(d,f,r.AB+t*r.AC,C.DH+a*_));for(360===C.EI&&o.push(ZC.AQ.BN(d,f,r.AB+t*r.AC,C.DH),ZC.AQ.BN(d,f,r.AB+(t+1)*r.AC,C.DH)),a=C.V.length-1;a>=0;a--)o.push(ZC.AQ.BN(d,f,r.AB+(t+1)*r.AC,C.DH+a*_));b.D=o,b.parse(),b.AZ=0,b.AU=0,b.EX=0,b.G9=0;var B=r.A.P;b.D1=[B.iX,B.iY,B.iX+B.I,B.iY+B.F],b.paint()}}if(r.D7.AZ>0)for(t=0,n=r.V.length;t<n;t++)if(t===r.W||t===r.A1||t%p==0)if("circle"===C.CW){var m=new ZC.DT(r);m.Z=r.H.usc()?r.H.mc():ZC.AK(r.A.K+"-scales-bl-0-c"),m.append(r.D7.o);var E=C.EI;360===E&&(E=359),m.append({type:"arc",size:r.AB+t*r.AC,angleStart:C.DH-.25,angleEnd:C.DH+E+.25}),m.K=r.K+"-guide-"+t,m.iX=d,m.iY=f,m.parse(),m.J2=y,m.E7=r.D7.E7,m.DE()&&m.parse(),m.paint()}else{var D=new ZC.D0(r);for(D.copy(r.D7),D.K=r.K+"-guide-"+t,D.J2=y,D.E7=r.D7.E7,D.DE()&&D.parse(),o=[],a=0,l=C.V.length-(360===C.EI||C.DJ?0:1);a<l;a++)o.push(ZC.AQ.BN(d,f,r.AB+t*r.AC,C.DH+a*_),ZC.AQ.BN(d,f,r.AB+t*r.AC,C.DH+(a+1)*_));ZC.CR.paint(i,D,o)}}if(r.P0.AN&&r.P0.AZ>0&&((o=[]).push(ZC.AQ.BN(d,f,r.AB,C.DH),ZC.AQ.BN(d,f,h-r.BV,C.DH)),ZC.CR.paint(e,r.P0,o)),r.IT.AN){switch(r.IT.o.placement){case"inner":break;case"outer":c;break;default:c/2}for(o=[],t=0,n=r.V.length;t<n;t++)if(t===r.W||t===r.A1||t%p==0){var K=ZC.AQ.BN(d,f,r.AB+t*r.AC,C.DH);switch(r.IT.o.placement){case"inner":o.push([K[0],K[1]]),C.DH%180==0?o.push([K[0],K[1]-c]):o.push([K[0]-c,K[1]]),o.push(null);break;case"outer":o.push([K[0],K[1]]),C.DH%180==0?o.push([K[0],K[1]+c]):o.push([K[0]+c,K[1]]),o.push(null);break;default:C.DH%180==0?o.push([K[0],K[1]-c/2],[K[0],K[1]+c/2]):o.push([K[0]-c/2,K[1]],[K[0]+c/2,K[1]]),o.push(null)}}for(var F=ZC._i_(r.IT.o["offset-x"]||"0"),x=ZC._i_(r.IT.o["offset-y"]||"0"),I=0;I<o.length;I++)o[I]&&(o[I][0]+=F,o[I][1]+=x);ZC.CR.paint(e,r.IT,o)}if(A=[],r.V.length>0&&r.BR.AN)for(r.GT=0,Y(r.W),r.GT=r.A1-r.W,Y(r.A1),r.GT=1,t=r.W+1;t<r.A1;t++)t%u==0&&Y(t);A.length>0&&ZC.AK(r.A.A.K+"-map")&&(ZC.AK(r.A.A.K+"-map").innerHTML+=A.join(""))}function y(e){return e=(e=(e=e.replace(/(%i)|(%scale-index)/g,t)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(r.V[t])?r.V[t]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(r.BX[t])?r.BX[t]:"")}function w(e){return e=(e=(e=(e=e.replace(/(%c)|(%scale-position)/g,r.GT)).replace(/(%i)|(%scale-index)/g,r.K4)).replace(/(%v)|(%scale-value)/g,null!==ZC._n_(r.V[r.K4])?r.V[r.K4]:"")).replace(/(%l)|(%scale-label)/g,null!==ZC._n_(r.BX[r.K4])?r.BX[r.K4]:"")}function Y(e){r.K4=e,(s=new ZC.DN(r)).copy(r.BR),s.K=r.A.K+"-"+r.BE.replace(/\-/g,"_")+"-item_"+e,s.GL=r.K+"-item "+r.A.K+"-scale-item zc-scale-item";var i=r.FQ(e);if(s.AM=i,null===ZC._n_(r.LR)||-1!==ZC.AV(r.LR,i)){s.Z=s.C7=r.H.usc()?r.H.mc():ZC.AK(r.A.K+"-scales-fl-0-c"),s.parse(),s.J2=w,s.DE()&&s.parse();var t=ZC.AQ.BN(d,f,r.AB+e*r.AC,C.DH);switch(s.F=s.KA,s.I=s.NM,C.DH%180==0?(s.iX=t[0]-s.I/2,s.iY=t[1]):(s.iX=t[0],s.iY=t[1]-s.F/2),r.IT.o.placement){case"inner":break;case"outer":C.DH%180==0?s.iY+=c:s.iX+=c;break;default:C.DH%180==0?s.iY+=c/2:s.iX+=c/2}s.AN&&(s.paint(),s.EK(),null===ZC._n_(r.o.tooltip)&&s.K9||(null!==ZC._n_(r.o.tooltip)&&(r.o.tooltip.text=r.o.tooltip.text||"%scale-value"),A.push(ZC.AP.O5(r.A.K,s))))}}}};ZC.ZK=ZC.VQ.CA(ZK);var A0F={$i:function(e){this.b(e);var i=this;i.C6=.95,i.L=0,i.AF=null,i.M=null,i.F7=null,i.A62=!1,i.BA="bottom",i.AB=0,i.BV=0,i.MK="normal",i.O4="normal",i.K7=[5,5],i.A0O=[0,0],i.YT=""},parse:function(){this.b();var e,i=this;i.assign_a([["type","AF"],["value-range","A62","b"],["offset-start","AB","i"],["offset-end","BV","i"],["placement","BA"],["pair-scale","YT"],["label-placement","MK"],["label-alignment","O4"],["range","F7"]]),null===ZC._n_(i.o.alpha)&&(i.o.alpha="area"===i.AF?.25:.95),null!==ZC._n_(e=i.o["label-tolerance"])&&("object"==typeof e&&e.length?(i.K7[0]=ZC._i_(e[0]||"5"),i.K7[1]=ZC._i_(e[1]||"5")):i.K7[0]=i.K7[1]=ZC._i_(e||"5")),i.assign_a([["alpha","C6","f",0,1]]),null===ZC._n_(e=i.o.label)&&null===ZC._n_(i.o.text)||(i.M=new ZC.DN(i),i.A.A.A.B8.load(i.M.o,["("+i.A.AF+").SCALE.marker.label"]),null!==ZC._n_(i.o.text)&&i.M.append({text:i.o.text}),i.M.append(e),i.M.parse(),i.A0O=[i.M.BM,i.M.BH])},paint:function(){var e,i,t,n,a,l,o,r=this;if(r.F7)if(-1===r.A.BE.indexOf("scale-r")){if(r.AN){var s,A,C,c,u=r.A,p=r.A.A.P.AU,Z=u.A.K+"-scales-"+("top"===r.BA?"f":"b")+"l-0-c";r.Z=r.C7=ZC.AK(u.H.usc()?u.H.K+"-main-c":Z),e=ZC.Q.EB(r.Z,u.H.AA),a=[];var h,d=0,f=0;r.BM>-1&&r.BM<1&&(r.BM=Math.ceil(r.BM*u.AC)),r.BH>-1&&r.BH<1&&(r.BH=Math.ceil(r.BH*u.AC)),r.M&&(r.M.Z=u.H.usc()?u.H.mc():ZC.AK(u.A.K+"-scales-ml-0-c"),r.M.K=r.A.A.K+"-"+r.A.BE.replace(/\-/g,"_")+"-marker_"+r.L,r.M.GL=r.A.K+"-marker-label "+r.A.A.K+"-scale-marker-label zc-scale-marker-label");var _=r.A.A,g=function(e,i){var t;return-1!==(i+"").indexOf("%")?(t=ZC._f_(i.replace("%","")),t="k"===e.AF?ZC._i_(t*(e.DX-e.DC)/100):t*(e.H1-e.FW)/100):t=i,r.A62||"v"===e.AF?e.AT(t):e.IB(t)};if("poly"===r.AF){var v,b,B,m;for(_=r.A.A,"k"===u.AF?(v=u,b=""===r.YT?_.BU("v")[0]:_.BL(r.YT)||_.BU("v")[0]):"v"===u.AF&&(b=u,v=""===r.YT?_.BU("k")[0]:_.BL(r.YT)||_.BU("k")[0]),l=0,o=r.F7.length;l<o;l++)B=g(v,r.F7[l][0]),m=b.AT(r.F7[l][1]),a.push([B,m]),d+=B,f+=m;if(d/=a.length,f/=a.length,a.length>=3){if(a[0].join("/")!==a[a.length-1].join("/")&&a.push([a[0][0],a[0][1]]),u.A.AJ["3d"])for(u.A.NX(),i=0,t=a.length;i<t;i++)n=new ZC.CE(u.A,a[i][0]-ZC.AO.E2,a[i][1]-ZC.AO.E3,ZC.AO.FT),a[i][0]=n.ED[0],a[i][1]=n.ED[1];(h=new ZC.DT(r.A)).K=u.K+"-marker-"+r.L,h.Z=h.C7=u.H.usc()?u.H.mc():ZC.AK(Z),h.copy(r),h.AZ=0,h.AU=0,h.EX=0,h.G9=0,h.D=a,h.parse(),h.paint()}}else if("line"===r.AF){if(-1!==u.BE.indexOf("scale-x")?1===r.F7.length?s=A=g(u,r.F7[0]):2===r.F7.length&&(s=g(u,r.F7[0]),A=g(u,r.F7[1])):-1!==u.BE.indexOf("scale-y")&&(1===r.F7.length?s=A=g(u,r.F7[0]):2===r.F7.length&&(s=g(u,r.F7[0]),A=g(u,r.F7[1]))),-1!==u.BE.indexOf("scale-x")&&u.CO||-1!==u.BE.indexOf("scale-y")&&!u.CO?(a.push([u.iX+r.AB,s],[u.iX+u.I-r.BV,A]),r.o&&r.o.tooltip&&(_.o.labels=_.o.labels||[],_.o.labels.push({x:u.iX,y:s-r.AZ,width:u.I,height:2*r.AZ,alpha:0,tooltip:r.o.tooltip})),r.M&&("opposite"===r.MK?r.M.iX=u.iX+u.I-r.M.I-r.BV:r.M.iX=u.iX+r.AB,"opposite"===r.MK?r.M.iY=A-(u.AW?0:r.M.F):r.M.iY=s-(u.AW?0:r.M.F))):(a.push([s,u.iY+u.F-r.AB],[A,u.iY+r.BV]),r.o&&r.o.tooltip&&(_.o.labels=_.o.labels||[],_.o.labels.push({x:s-r.AZ,y:u.iY,width:2*r.AZ,height:u.F,alpha:0,tooltip:r.o.tooltip})),r.M&&("opposite"===r.MK?r.M.iX=A-(u.AW?r.M.I:0):r.M.iX=s-(u.AW?r.M.I:0),"opposite"===r.MK?r.M.iY=u.iY+r.M.I-r.M.F+r.BV:r.M.iY=u.iY+u.F-r.M.F-r.AB)),u.A.AJ["3d"])for(u.A.NX(),i=0,t=a.length;i<t;i++)n=new ZC.CE(u.A,a[i][0]-ZC.AO.E2,a[i][1]-ZC.AO.E3,ZC.AO.FT),a[i][0]=n.ED[0],a[i][1]=n.ED[1];2===a.length&&(ZC.CR.setup(e,r),ZC.CR.paint(e,r,a))}else if("area"===r.AF&&(-1!==u.BE.indexOf("scale-x")?2===r.F7.length?(s=C=g(u,r.F7[0]),A=c=g(u,r.F7[1])):4===r.F7.length&&(s=g(u,r.F7[0]),A=g(u,r.F7[1]),C=g(u,r.F7[2]),c=g(u,r.F7[3])):-1!==u.BE.indexOf("scale-y")&&(2===r.F7.length?(s=C=u.AT(r.F7[0]),A=c=u.AT(r.F7[1])):4===r.F7.length&&(s=u.AT(r.F7[0]),A=u.AT(r.F7[1]),C=u.AT(r.F7[2]),c=u.AT(r.F7[3]))),A=s===A?A+1:A,c=C===c?c+1:c,-1!==u.BE.indexOf("scale-x")&&u.CO||-1!==u.BE.indexOf("scale-y")&&!u.CO?(a.push([u.iX+p,s],[u.iX+u.I-p,C],[u.iX+u.I-p,c],[u.iX+p,A],[u.iX+p,s]),r.M&&("opposite"===r.MK?r.M.iX=u.iX+u.I-r.M.I-r.BV:r.M.iX=u.iX+r.AB,"opposite"===r.MK?r.M.iY=A-(u.AW?0:r.M.F):r.M.iY=s-(u.AW?0:r.M.F))):(a.push([s,u.iY+u.F-p],[C,u.iY+p],[c,u.iY+p],[A,u.iY+u.F-p],[s,u.iY+u.F-p]),r.M&&("opposite"===r.MK?r.M.iX=A-(u.AW?r.M.I:0):r.M.iX=s-(u.AW?r.M.I:0),"opposite"===r.MK?r.M.iY=u.iY+r.M.I-r.M.F+r.BV:r.M.iY=u.iY+u.F-r.M.F-r.AB)),a.length>=4)){if(u.A.AJ["3d"])for(u.A.NX(),i=0,t=a.length;i<t;i++)n=new ZC.CE(u.A,a[i][0]-ZC.AO.E2,a[i][1]-ZC.AO.E3,ZC.AO.FT),a[i][0]=n.ED[0],a[i][1]=n.ED[1];(h=new ZC.DT(r.A)).K=u.K+"-marker-"+r.L,h.Z=h.C7=u.H.usc()?u.H.mc():ZC.AK(Z),h.copy(r),h.AZ=0,h.AU=0,h.EX=0,h.G9=0,h.D=a,h.parse(),h.BM=r.BM,h.BH=r.BH,h.paint()}var E=!0,D=u.A.P;2===a.length&&(-1!==u.BE.indexOf("scale-x")&&u.CO||-1!==u.BE.indexOf("scale-y")&&!u.CO?ZC.DS(a[0][1],D.iY-r.K7[1],D.iY+D.F+r.K7[1])&&ZC.DS(a[1][1],D.iY-r.K7[1],D.iY+D.F+r.K7[1])||(E=!1):ZC.DS(a[0][0],D.iX-r.K7[0],D.iX+D.I+r.K7[0])&&ZC.DS(a[1][0],D.iX-r.K7[0],D.iX+D.I+r.K7[0])||(E=!1));var K=r.O4;if(r.M&&E&&("poly"===r.AF?(r.M.iX=ZC._i_(d-r.M.I/2),r.M.iY=ZC._i_(f-r.M.F/2)):("auto"===r.O4&&(K=-1!==u.BE.indexOf("scale-x")&&!u.CO||-1!==u.BE.indexOf("scale-y")&&u.CO?s<u.iX+u.I/2?"normal":"opposite":s>u.iY+u.F/2?"normal":"opposite"),r.M.BM=r.M.BH=0,(-1!==u.BE.indexOf("scale-x")&&!u.CO||-1!==u.BE.indexOf("scale-y")&&u.CO)&&null===ZC._n_(r.M.o.angle)&&(r.M.A9=270),-1!==u.BE.indexOf("scale-x")&&!u.CO||-1!==u.BE.indexOf("scale-y")&&u.CO?(r.M.A9%180==90&&(r.M.BM-=(u.AW?-1:1)*(r.M.I/2-r.M.F/2),r.M.BH-=r.M.I/2-r.M.F/2,"opposite"===r.MK&&(r.M.BH=-r.M.I/2+r.M.F/2),"opposite"===K&&(r.M.BM-=r.M.F)),r.M.A9%180==0&&("opposite"===r.MK&&(r.M.BH=-r.M.I+r.M.F),"opposite"===K&&(r.M.BM-=r.M.I))):(r.M.A9%180==90&&(r.M.BM-=r.M.I/2-r.M.F/2,r.M.BH-=(u.AW?-1:1)*(r.M.I/2-r.M.F/2),"opposite"===r.MK&&(r.M.BM=r.M.I/2-r.M.F/2),"opposite"===K&&(r.M.BH+=r.M.I)),r.M.A9%180==0&&"opposite"===K&&(r.M.BH+=r.M.F)),r.M.BM+=r.A0O[0]+r.BM,r.M.BH+=r.A0O[1]+r.BH),u.A.AJ["3d"]&&(n=new ZC.CE(u.A,r.M.iX-ZC.AO.E2,r.M.iY-ZC.AO.E3,ZC.AO.FT),r.M.iX=n.ED[0],r.M.iY=n.ED[1]),ZC.DS(r.M.iX+r.M.BM+(r.M.A9%180==0?r.M.I/2:r.M.F/2),r.A.A.P.iX-r.K7[0],r.A.A.P.iX+r.A.A.P.I+r.K7[0])&&ZC.DS(r.M.iY+r.M.BH+(r.M.A9%180==0?r.M.F/2:r.M.I/2),r.A.A.P.iY-r.K7[1],r.A.A.P.iY+r.A.A.P.F+r.K7[1])&&(r.M.paint(),r.M.EK(),!r.M.K9&&"normal"===zingchart.OBJECTMODE&&(u.E["marker_text_"+r.L]=r.M.AM,ZC.AK(_.A.K+"-map"))))){var F=ZC.AP.O5(_.K,r.M);ZC.AK(_.A.K+"-map").innerHTML=ZC.AK(_.A.K+"-map").innerHTML+F}}}else r.A.paintMarker(r)}};ZC.A0F=ZC.DT.CA(A0F);var VK={$i:function(e){var i=this;i.LW=null,i.A5H=0,i.OX=[],i.BE=e,i.A3J=!0},add:function(e){var i=this;i.OX.push(e),e.K1=i,e.LW=i.LW,e.C0.U0=!0,e.X1=i.OX.length-1,i.A3J=!1}};ZC.VK=ZC.C9.CA(VK);var E4={$i:function(e,i,t,n,a,l){var o=this;for(var r in o.LW=null,o.C0=e,o.AX=null,o.A57=0,o.IK=null,o.O=i||{},o.A5K=t||500,o.XI=n||-1,o.A0B=null,o.T4=null,o.OF=null,null!==ZC._n_(l)&&(o.T4=l),o.A4F=ZC.E4.linear,null!==ZC._n_(a)&&""!==a&&(o.A4F=a),o.ADJ={},o.C5={},o.ACK=[],o.RG=ZC._i_(o.A5K/ZC.PE.U3),o.RG>100&&(o.RG=100),(ZC.vml||ZC.mobile)&&(o.RG=ZC._i_(o.RG/4)),o.RG<5&&(o.RG=5),o.O)null!==ZC._n_(ZC.E4.GN[r])?o.C5[r]=o.C0[ZC.E4.GN[r]]:o.C5[r]=o.C0[r];o.Y=0,o.K1=null,o.X1=-1},status:function(){return this.Y+1>this.RG?0:1},step:function(){var e,i,t,n,a,l,o=this,r=1,s=o.LW.C.H.AA;if(o.Y++,o.Y>o.RG&&(o.Y===o.RG+1&&-1!==o.X1&&(o.K1.A5H++,o.K1.A5H===o.K1.OX.length&&(o.K1.A3J=!0)),r=0),r){var A={};if(o.Y===o.RG)A=o.O,o.A57=1;else for(var C in o.A57=o.A4F(o.Y,0,1,o.RG),o.O)switch(C){case"points":var c=[];for(a=0,l=o.O[C].length;a<l;a++)if(null!==ZC._n_(o.C5[C][a])){c[a]=[];for(var u=0,p=o.O[C][a].length;u<p;u++)c[a][u]=o.A4F(o.Y,o.C5[C][a][u],o.O[C][a][u]-o.C5[C][a][u],o.RG)}A[C]=c;break;case"lineColor":case"borderColor":case"backgroundColor1":case"backgroundColor2":var Z=o.C5[C].replace("#",""),h=ZC.AP.GC(o.O[C]).replace("#",""),d=ZC.QX(Z.slice(0,2)),f=ZC.QX(Z.slice(2,4)),_=ZC.QX(Z.slice(4,6)),g=ZC.QX(h.slice(0,2)),v=ZC.QX(h.slice(2,4)),b=ZC.QX(h.slice(4,6)),B=ZC.OT(ZC._i_(o.A4F(o.Y,d,g-d,o.RG)));1===B.length&&(B="0"+B);var m=ZC.OT(ZC._i_(o.A4F(o.Y,f,v-f,o.RG)));1===m.length&&(m="0"+m);var E=ZC.OT(ZC._i_(o.A4F(o.Y,_,b-_,o.RG)));1===E.length&&(E="0"+E),A[C]="#"+B+m+E;break;default:A[C]=o.A4F(o.Y,o.C5[C],o.O[C]-o.C5[C],o.RG)}if(o.C0.append(A),o.C0.U0=!0,o.C0.parse(),o.AX&&(null!==ZC._n_(e=o.C0.E["bound-1"])&&(o.C0.D1[1]=e),null!==ZC._n_(e=o.C0.E["bound-3"])&&(o.C0.D1[3]=e),"vml"===s&&1===o.Y&&("undefined"!=typeof o.AX.A.HX?o.C0.E.opacity2=o.AX.A.HX:o.C0.E.opacity2=o.AX.A.C6),o.AX.H&&(o.AX.H.E[o.AX.K+"-bounds"]=[o.AX.iX,o.AX.iY,o.AX.iX+o.AX.I,o.AX.iY+o.AX.F])),o.A0B)try{o.A0B(o.C0,A)}catch(X){}if(o.AX){var D={id:o.AX.H.K,graphid:o.AX.C.K,plotindex:o.AX.A.L,nodeindex:o.AX.L,stage:o.A57,value:o.AX.AD*o.A57};ZC.AP.BY("animation_step",o.AX.H,D)}}if(o.AX){if(1===o.Y||"canvas"===s)-1!==ZC.AV(["svg","vml"],s)?0===ZC.A5("#"+o.C0.K+"-path").length&&o.paint():o.paint();else if(o.Y<=o.RG){switch(s){case"svg":o.C0.WZ(!0);break;case"vml":o.C0.WY(null,!0)}o.C0.W0&&o.C0.W0(),"vml"===s&&/\-plotset\-plot-\d+\-node\-\d+\-area/.test(o.C0.K)&&(o.C0.AZ=0),i=null,"undefined"!=typeof o.C0.DU&&"box"===o.C0.DU&&(i=o.C0.AZ,o.C0.AZ=o.C0.AU);var K=!1;if("svg"===s&&ZC.AK(o.C0.K+"-path")&&"rect"===ZC.AK(o.C0.K+"-path").tagName&&(K=!0),K)t=[],n=[];else if(t=ZC.Q.A2W(o.C0.D,s,o.C0,!1,!0),o.C0.M8){var F=ZC.Q._sh_(o.C0.D,o.C0);n=ZC.Q.A2W(F,s,o.C0,!1,!0)}null!==ZC._n_(i)&&(o.C0.AZ=i);var x=o.C0.C6,I=o.C0.O0,y=o.C0.T5,w=o.C0.JW,Y=o.C0.AI;switch(s){case"svg":ZC.A5("#"+o.C0.K+"-path").attr("d",t.join(" ")).attr("stroke-opacity",I).attr("fill-opacity",x),o.C0.M8&&ZC.A5("#"+o.C0.K+"-sh-path").attr("d",n.join(" ")).attr("stroke-opacity",I*y).attr("fill-opacity",x*y),K&&(ZC.A5("#"+o.C0.K+"-path").attr("x",o.C0.iX).attr("y",o.C0.iY).attr("width",ZC.BQ(0,o.C0.I)).attr("height",ZC.BQ(0,o.C0.F)),o.C0.M8&&ZC.A5("#"+o.C0.K+"-sh-path").attr("x",o.C0.iX+w*ZC.EH(o.C0.OH)).attr("y",o.C0.iY+w*ZC.EP(o.C0.OH)).attr("width",ZC.BQ(0,o.C0.I)).attr("height",ZC.BQ(0,o.C0.F))),ZC.A5("#"+o.C0.K+"-circle").attr("stroke-opacity",I).attr("cx",o.C0.iX).attr("cy",o.C0.iY).attr("r",Y).attr("fill-opacity",x),o.C0.M8&&ZC.A5("#"+o.C0.K+"-sh-circle").attr("stroke-opacity",I*y).attr("cx",o.C0.iX+w).attr("r",Y).attr("cy",o.C0.iY+w).attr("fill-opacity",x*y),""!==o.C0.DA&&ZC.A5("#"+o.C0.K+"-path-imgfill").attr("d",t.join(" ")).attr("stroke-opacity",I).attr("fill-opacity",x),ZC.A5("#"+o.C0.K+"-goal-path").remove();break;case"vml":ZC.A5("#"+o.C0.K+"-path").children().each(function(){this.v=t.join(" "),this.opacity=x}),o.C0.M8&&ZC.A5("#"+o.C0.K+"-sh-path").children().each(function(){this.v=n.join(" "),this.opacity=x*y}),ZC.A5("#"+o.C0.K+"-circle").children().each(function(){this.opacity=x}),ZC.A5("#"+o.C0.K+"-circle").each(function(){this.style.left=o.C0.iX-Y+"px",this.style.top=o.C0.iY-Y+"px",this.style.width=2*Y+"px",this.style.height=2*Y+"px"}),o.C0.M8&&(ZC.A5("#"+o.C0.K+"-sh-circle").children().each(function(){this.opacity=x*y}),ZC.A5("#"+o.C0.K+"-sh-circle").each(function(){this.style.left=o.C0.iX-Y+w+"px",this.style.top=o.C0.iY-Y+w+"px",this.style.width=2*Y+"px",this.style.height=2*Y+"px"})),ZC.A5("#"+o.C0.K+"-goal-path").remove()}}}else o.LW.C.Q5=!0,o.LW.C.A0M(),o.LW.C.KK();return o.Y===o.RG+1&&null!==ZC._n_(o.T4)&&o.T4(),r},paint:function(){var e=this;if(null!==ZC._n_(e.IK)?ZC.CR.paint(e.IK,e.C0,e.C0.D):e.C0.paint(),e.OF)try{1===e.A57&&e.OF()}catch(i){}}};ZC.E4=ZC.C9.CA(E4),ZC.E4.GN={angleStart:"B4",angleEnd:"BK",slice:"CN",size:"AI",x:"iX",y:"iY",width:"I",height:"F",alpha:"C6",angle:"A9",fillAngle:"N7",points:"D",lineWidth:"AZ",lineColor:"B7",borderWidth:"AU",borderColor:"BW",backgroundColor1:"A0",backgroundColor2:"AE"},ZC.E4.linear=function(e,i,t,n){return t*e/n+i},ZC.E4.backEaseOut=function(e,i,t,n){var a=(e/=n)*e;return i+t*(4*(a*e)+-9*a+6*e)},ZC.E4.elasticEaseOut=function(e,i,t,n){var a=(e/=n)*e,l=a*e;return i+t*(37.045*l*a+-116.2825*a*a+134.08*l+-68.59*a+14.7475*e)},ZC.E4.bounceEaseOut=function(e,i,t,n){return(e/=n)<1/2.75?t*(7.5625*e*e)+i:e<2/2.75?t*(7.5625*(e-=1.5/2.75)*e+.75)+i:e<2.5/2.75?t*(7.5625*(e-=2.25/2.75)*e+.9375)+i:t*(7.5625*(e-=2.625/2.75)*e+.984375)+i},ZC.E4.regularEaseOut=function(e,i,t,n){var a=(e/=n)*e;return i+t*(a*e+-3*a+3*e)},ZC.E4.strongEaseOut=function(e,i,t,n){var a=(e/=n)*e,l=a*e;return i+t*(l*a+-5*a*a+10*l+-10*a+5*e)},ZC.E4.RI=[ZC.E4.linear,ZC.E4.backEaseOut,ZC.E4.elasticEaseOut,ZC.E4.bounceEaseOut,ZC.E4.strongEaseOut,ZC.E4.regularEaseOut],ZC.ANIMATION={SLOW:4e3,FAST:1e3,LINEAR:0,BACK_EASE_OUT:1,ELASTIC_EASE_OUT:2,BOUNCE_EASE_OUT:3,STRONG_EASE_OUT:4,REGULAR_EASE_OUT:5,NO_SEQUENCE:0,BY_PLOT:1,BY_NODE:2,BY_PLOT_AND_NODE:3,FADE_IN:1,EXPAND_VERTICAL:2,EXPAND_TOP:3,EXPAND_BOTTOM:4,EXPAND_LEFT:5,EXPAND_RIGHT:6,EXPAND_HORIZONTAL:7,SLIDE_LEFT:8,SLIDE_RIGHT:9,SLIDE_TOP:10,SLIDE_BOTTOM:11,UNFOLD_HORIZONTAL:12,UNFOLD_VERTICAL:13,EXPAND:2,GROW:3,FLY_IN:4,UNFOLD:5},ZC.PE=ZC.C9.CA({$i:function(e){var i=this;i.C=e,i.RP=!1,i.C4=null,i.OX=[],i.PG={},i.onStop=null},A9K:function(e,i){var t=this;null===ZC._n_(t.PG[e.BE])&&(t.PG[e.BE]=e,e.LW=t,t.RP||(null!==ZC._n_(i)&&i>0?window.setTimeout(function(){t.start()},i+1):t.start()))},add:function(e){var i=this;e.LW=i,e.XI>0?(i.OX.push(e),window.setTimeout(function(){e.C0.U0=!0,i.RP||i.start()},e.XI+1)):(e.C0.U0=!0,i.OX.push(e),i.RP||i.start())},start:function(){var e=this;e.RP=!0,ZC.AP.BY("animation_start",e.C.A,{id:e.C.A.K,graphid:e.C.K});var i=!0;!function t(){i||e.step(),i=!1,e.RP&&(e.C4=window.requestAnimFrame(t))}()},step:function(){var e,i=this,t=0;if(i.RP){for(var n=0,a=i.OX.length;n<a;n++)t+=i.OX[n].status();if("canvas"===i.C.H.AA)if(i.C.H.K9)null!==ZC._n_(e=ZC.AK(i.C.K+"-plots-bl-c"))&&e.getContext("2d").clearRect(i.C.iX,i.C.iY,i.C.I,i.C.F);else for(n=0,a=i.C.AY.A4.length;n<a;n++)for(var l=0;l<i.C.AY.A4[n].SV;l++)null!==ZC._n_(e=ZC.AK(i.C.K+"-plot-"+n+"-bl-"+l+"-c"))&&e.getContext("2d").clearRect(i.C.iX,i.C.iY,i.C.I,i.C.F);for(n=0,a=i.OX.length;n<a;n++)0===i.OX[n].step()&&(i.OX[n].C0.U0=!1);for(var o in i.PG)for(i.PG[o].A3J||(t+=1),n=0,a=i.PG[o].OX.length;n<a;n++)i.PG[o].OX[n].X1===i.PG[o].A5H?0===i.PG[o].OX[n].step()&&(i.PG[o].OX[n].C0.U0=!1):"canvas"===i.C.H.AA&&i.PG[o].OX[n].paint();0===t&&(i.PG={},i.OX=[],i.stop())}},stop:function(e){null===ZC._n_(e)&&(e=!1);var i,t=this;if(e&&(t.bDead=!0),window.clearAnimFrame(t.C4),t.C.A0M(),t.C.Q5=!1,ZC.AK(t.C.H.K)){t.C.KK(),window.setTimeout(function(){if((i=ZC.AK(t.C.A.K+"-map"))&&t.C.AY.HE){-1===ZC.AV(["bubble","mixed","vbullet","hbullet","radar"],t.C.AF)&&1!==zingchart.SORTTRACKERS||t.C.AY.HE.sort(function(e,i){return ZC.AP.N2(e)>ZC.AP.N2(i)?1:-1});var e='<area shape="rect" coords="0,0,1,1" id="mark'+t.C.L+'">',n=i.innerHTML.indexOf(e);-1!==n?i.innerHTML=i.innerHTML.substring(0,n+e.length)+t.C.a11y()+t.C.AY.HE.join("")+i.innerHTML.substring(n+e.length):i.innerHTML+=t.C.a11y()+t.C.AY.HE.join("")}},33),t.C.A6U(),t.RP=!1;for(var n=0,a=t.OX.length;n<a;n++)t.OX[n].T4=null;if(t.OX=[],t.PG={},e||ZC.AP.BY("animation_end",t.C.A,{id:t.C.A.K,graphid:t.C.K}),null!==ZC._n_(t.onStop))try{t.onStop()}catch(l){}}}}),ZC.PE.U3=33,function(){for(var e=["ms","moz","webkit","o"],i=0,t=e.length;i<t&&!window.requestAnimFrame;++i)window.requestAnimFrame=window.requestAnimationFrame||window[e[i]+"RequestAnimationFrame"],window.cancelAnimFrame=window.cancelAnimationFrame||window[e[i]+"CancelAnimationFrame"]||window[e[i]+"CancelRequestAnimationFrame"];window.requestAnimFrame||(window.requestAnimFrame=function(e){return window.setTimeout(e,ZC.PE.U3)}),window.clearAnimFrame||(window.clearAnimFrame=function(e){window.clearTimeout(e)})}(),zingchart.bind(null,"dataparse",function(e,i){for(var t,n,a=0,l=i.graphset.length;a<l;a++)if(i.graphset[a].type&&-1!==ZC.AV(["pie","line","vline","area","varea","bar","vbar","hbar","line3d","area3d","bar3d","vbar3d","hbar3d"],i.graphset[a].type)&&i.graphset[a].nav){var o=i.graphset[a];ZC._todash_(o);var r=o.nav||{};ZC._todash_(r);var s,A,C,c=ZC.II(r.threshold||"10%"),u=r.others||{text:"Others"},p=r.back||{},Z=r.slice||"0.3",h=o.series||[],d=[];if("pie"===i.graphset[a].type){var f=0;for(t=0;t<h.length;t++)h[t].values&&null!==ZC._n_(h[t].values[0])&&(f+=h[t].values[0]);c>0&&c<1&&(c*=f),s=[].concat(h);var _=0,g="";for(A=1,t=h.length-1;t>=0;t--)h[t].values&&null!==ZC._n_(h[t].values[0])&&h[t].values[0]<c&&(_+=h[t].values[0],g+=(h[t].text||"Item no."+A)+":"+h[t].values[0]+"<br>",h[t].slice=Z,d.push(h[t]),h.splice(t,1),A++);_>0&&(A>2?(C={values:[_],detach:!1,"data-group":[1],"tooltip-text":g=g.substring(0,g.length-4)},ZC._cp_(u,C),h.push(C),zingchart.bind(e.id,"plot_click",function(i){if(i.xdata.group){var t=zingchart.getLoader(i.id);if(!t)return;var n=zingchart.getGraph(t,i.graphid);for(var a in n.getAttributes())"pie-sel-"===a.substring(0,8)&&n.setAttribute(a,null);zingchart.exec(e.id,"setseriesdata",{data:d}),window.setTimeout(function(){var i=zingchart.exec(e.id,"getobjectinfo",{object:"node",plotindex:0,nodeindex:0}),t={id:"navpie_btnback",x:i.x,y:i.y,text:"< Back",anchor:"c",cursor:"hand"};ZC._cp_(p,t),zingchart.exec(e.id,"addobject",{type:"label",data:t})},1)}}),zingchart.bind(e.id,"label_click",function(i){if("navpie_btnback"===i.label.id){var t=zingchart.getLoader(i.id);if(!t)return;var n=zingchart.getGraph(t,i.graphid);for(var a in n.getAttributes())"pie-sel-"===a.substring(0,8)&&n.setAttribute(a,null);zingchart.exec(e.id,"removeobject",{type:"label",id:"navpie_btnback"}),zingchart.exec(e.id,"setseriesdata",{data:h})}})):o.series=[].concat(s))}else{var v=0,b=[];for(t=0;t<h.length;t++){if(b[t]=0,h[t].values&&h[t].values.length)for(n=0;n<h[t].values.length;n++)b[t]+=ZC._a_(h[t].values[n]);v=ZC.BQ(v,b[t])}c>0&&c<1&&(c*=v),s=[].concat(h);var B=[],m=[];for(A=1,t=h.length-1;t>=0;t--)if(b[t]<c){if(h[t].values&&h[t].values.length)for(n=0;n<h[t].values.length;n++)B[n]=ZC._f_(B[n]||"0"),B[n]+=h[t].values[n],m[n]=m[n]||"",m[n]+=(h[t].text||"Item no."+A)+":"+h[t].values[n]+"<br>";d.push(h[t]),h.splice(t,1),A++}if(B.length)if(A>2){for(n=0;n<m.length;n++)m[n]=m[n].substring(0,m[n].length-4);C={values:B,detach:!1,"data-group":[1],"data-tt-text":m,"tooltip-text":"%data-tt-text"},ZC._cp_(u,C),h.push(C),zingchart.bind(e.id,"plot_click",function(i){if(i.xdata.group){if(!zingchart.getLoader(i.id))return;zingchart.exec(e.id,"setseriesdata",{data:d}),window.setTimeout(function(){var i=zingchart.exec(e.id,"getobjectinfo",{object:"plotarea"}),t={id:"navxy_btnback",x:i.x+i.width/2,y:i.y,text:"< Back",anchor:"c",cursor:"hand"};ZC._cp_(p,t),zingchart.exec(e.id,"addobject",{type:"label",data:t})},1)}}),zingchart.bind(e.id,"label_click",function(i){if("navxy_btnback"===i.label.id){if(!zingchart.getLoader(i.id))return;zingchart.exec(e.id,"removeobject",{type:"label",id:"navxy_btnback"}),zingchart.exec(e.id,"setseriesdata",{data:h})}})}else o.series=[].concat(s)}}return i});}
