<?php 
include('include/config.php');
include('include/function.php');
include('include/graph.php');

?>
<!doctype html>

<html class="no-js" lang="zxx">
<style>
		.rs-container {
			font-family: Arial, Helvetica, sans-serif;
			height: 45px;
			position: relative;
			float: right;
			z-index: 999;
			margin-right: 130px;
		}
		.rs-tooltip{
			display:none;
		}
	</style>
<head>

    <meta charset="utf-8">

    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title>Climate Shakti - Sectors</title>

    <meta name="robots" content="noindex, follow" />

    <meta name="description" content="">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon" />

    <link rel="stylesheet" href="css/font-icons.css">

    <link rel="stylesheet" href="css/plugins.css">

    <link rel="stylesheet" href="css/style.css">

    <link rel="stylesheet" href="css/responsive.css">

    <script src="https://cdn.zingchart.com/zingchart.min.js"></script>

  <style>

    .chart--container {

      height: 100%;

      width: 100%;

      min-height: 650px;

    }



    .zc-ref {

      display: none;

    }

    #myChart-license-text { display:none;}
	
	.map-scale1{
					display: flex;
					flex-wrap: nowrap;
					max-width: 460px;
					z-index: 1;
					position: absolute;
					bottom: 14px;
					width: 100%;
				}
				.map-scale1 > div{
					width:20%;
					height:8px;
				}
				.map-scale1 > div > span {
					margin-top: -25px;
					display: block;
					width: 100%;
					text-align: center;
					font-size: 12px;
					line-height: 10px;
				}
				.map-scale1 > div.fst{
					background:#ebeced;
				}
				.map-scale1 > div.snd{
					background:#dcdcdc;
				}
				.map-scale1 > div.trd{
					background:#bdbdbd;
				}
				.map-scale1 > div.for{
					background:#a3a2a2;
				}
				.map-scale1 > div.fft{
					background:#8b8b8b;
				}
				
				
				
				.map-scale1.ghg-emm2 > div.fst{
					background:#c2e0fd;
				}
				.map-scale1.ghg-emm2 > div.snd{
					background:#7ebbf7;
				}
				.map-scale1.ghg-emm2 > div.trd{
					background:#5998d6;
				}
				.map-scale1.ghg-emm2 > div.for{					
					background:#3a71a7;
				}
				.map-scale1.ghg-emm2 > div.fft{
					background:#2b5680;
				}
				
				.map-scale1.ghg-emm3 > div.fst{
					background:#c4fff0;
				}
				.map-scale1.ghg-emm3 > div.snd{
					background: #8affe1;
				}
				.map-scale1.ghg-emm3 > div.trd{
					background:#49f1c6;
				}
				.map-scale1.ghg-emm3 > div.for{					
					background:#17ca9c;
				}
				.map-scale1.ghg-emm3 > div.fft{
					background:#00a57b;
				}
				
				
				
				.map-scale1.ghg-emm4 > div.fst{
					background:#f9e8e3;
				}
				.map-scale1.ghg-emm4 > div.snd{
					background: #f4cabb;
				}
				.map-scale1.ghg-emm4 > div.trd{
					background:#feb296;
				}
				.map-scale1.ghg-emm4 > div.for{					
					background:#fa936d;
				}
				.map-scale1.ghg-emm4 > div.fft{
					background:#f96e3b;
				}
				
				.map-scale1.ghg-emm5 > div.fst{
					background:#ffdbe7;
				}
				.map-scale1.ghg-emm5 > div.snd{
					background: #f2b4c8;
				}
				.map-scale1.ghg-emm5 > div.trd{
					background:#e77a9c;
				}
				.map-scale1.ghg-emm5 > div.for{					
					background:#dd3b6d;
				}
				.map-scale1.ghg-emm5 > div.fft{
					background:#c01348;
				}
				
				.map-scale1.ghg-emm6 > div.fst{
					background:#aee1ff;
				}
				.map-scale1.ghg-emm6 > div.snd{
					background: #54b8f2;
				}
				.map-scale1.ghg-emm6 > div.trd{
					background:#60a1c6;
				}
				.map-scale1.ghg-emm6 > div.for{					
					background:#5092f6;
				}
				.map-scale1.ghg-emm6 > div.fft{
					background:#3138ff;
				}
				
				.map-scale1.ghg-emm7 > div.fst{
					background:#fcddaf;
				}
				.map-scale1.ghg-emm7 > div.snd{
					background: #ffb947;
				}
				.map-scale1.ghg-emm7 > div.trd{
					background:#ffa618;
				}
				.map-scale1.ghg-emm7 > div.for{					
					background:#dda348;
				}
				.map-scale1.ghg-emm7 > div.fft{
					background:#bba538;
				}
				
				
				
				
				<?php /*?>.map-scale1 > div.six{
					background:#09581b;
				}
				.map-scale1 > div.sev{
					background:#003a11;
				}<?php */?>
	.zingchart-tooltip {
	  padding: 7px 5px;
	  background-color: #fff;
	  border-radius: 1px;
	  border: 1px solid #dcdcdc;
	  box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
	  line-height: 20px;
	  -webkit-font-smoothing: antialiased;
	}
	
	.zingchart-tooltip .scalex-value {
	  color: #838383;
	  font-size: 14px !important;
	  font-weight: normal !important;
	  line-height: 24px;
	}
	
	.zingchart-tooltip .scaley-value {
	  color: #4184f3;
	  font-size: 24px !important;
	  font-weight: normal !important;
	}
	.map-botom {
		position: absolute;
		right: 0;
		max-width: 699px;
	}
	.map-botom p {
		margin-top: -33px;
		z-index: 100;
		max-width: 100%;
		text-align: center;
		padding: 0 70px;
		font-size: 14px;
		line-height: 20px;
	}
	.map-botom p a{
		color:#b83b30;
	}
	.map-botom p a:hover{
		color:#dba617;
	}
	
	.mp-heading {
		position: absolute;
		top: 9px;
	}
  </style>

</head>



<body>

    <!--[if lte IE 9]>

        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>

    <![endif]-->



    <!-- Add your site or application content here -->



<!-- Body main wrapper start -->

<div class="body-wrapper">



   <?php include('include/header.php');?>



   





    <div class="ltn__utilize-overlay"></div>



    <!-- BREADCRUMB AREA START -->

    <div class="ltn__breadcrumb-area text-left bg-overlay-black-80 bg-image " data-bs-bg="img/bg/breadcumb-bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h4 class="page-title">Sectors Dashboard </h4>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="index.php"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                                <li>Sectors Dashboard</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- BREADCRUMB AREA END -->



    <!-- ABOUT US AREA START -->

	<div class="ltn__about-us-area pt-120-- pt-20 mt--30">

        <div class="container">

            <div class="row">

			 <?php if(isset($_GET['st'])) {echo "<h4 class='mt-2 mb-2'> Sector: ".$_GET['st'] = str_replace('-', ' ', $_GET['st'])."</h4>" ;};?>

                <div class="col-lg-12">
					
                    <input type="text"  class="form-control slider" id="date-range-slider2" />
					<div id="fundingsector_data">
                    <?php 
						//$beween = " AND years BETWEEN '2015' AND '2018' ";
						//$beween="";
						fundingsector($conn,"fundingChart","");
					?>
                    </div>
                    
                    <div id="myChart" class="chart--container"></div>
					<h6 class="mp-heading">Dominant Sectors by Funding - (<span id="sector-name">AFOLU</span>)</h6>
                    <div class="map-scale1">
                        <div class="fst" data-toggle="tooltip" data-placement="top" title="">
                            <span>2.2 Million</span>
                        </div>
                        <div class="snd" data-toggle="tooltip" data-placement="top" title="">
                            <span>5.8 Million</span>
                        </div>
                        <div class="trd" data-toggle="tooltip" data-placement="top" title="">
                            <span>12 Million</span>
                        </div>
                        <div class="for" data-toggle="tooltip" data-placement="top" title="">
                            <span>85.5 Million</span>
                        </div>
                        <div class="fft" data-toggle="tooltip" data-placement="top" title="">
                            <span>115 Million</span>
                        </div>
                    </div>
                    
                    <div class="map-botom">
                    	<p>Click Here to Know About the Interrelationships between <a href="#">Sectors – GHG Emissions and Funding</a>.</p>
                    </div>
                    

                </div>

				

				

								

            </div>

        </div>

    </div>

    <div class="ltn__about-us-area pt-50 pb-30 mt--30">

        <div class="container">

         

		<div class="row">

            	<div class="col-12">

                	<div class="table-responsive">

                    	<table class="table table-bordered sectors-table">

                        	<thead>

                            	<tr>

                                	<th>Sl. No.</th>

                                    <th>Sectors with most Funding</th>

                                    <th>Contribution</th>

                                    <th>Sectoral Spending</th>

                                    <th>Maximum sectoral fund to state</th>

                                </tr>

                            </thead>

                            <tbody>
                                <?php $mi=1;
								$sqlsector1=mysqli_query($conn,"select sum(rupee_budget) as budget from projects where story_level_id='2'");
								$datasector1=mysqli_fetch_object($sqlsector1);
								$sqlsector=mysqli_query($conn,"select s.name as sector_name,s.id as sectorid, p.sector_id, sum(p.rupee_budget) budget from projects p,sectors s where p.sector_id=s.id and p.story_level_id='2' group by p.sector_id order by budget desc");
								      while($datasector=mysqli_fetch_object($sqlsector))
									  {

                      $selstdata=mysqli_query($conn,"SELECT sum(projects_state.rupee_budget) as totbgt,projects_state.state_id,state.name FROM `projects_state` INNER join state on projects_state.state_id=state.id where projects_state.sector_id='".$datasector->sectorid."' GROUP by projects_state.state_id ORDER by totbgt desc limit 0,1");
                     $statedata=mysqli_fetch_array($selstdata);
										  $perc=round(($datasector->budget*100/$datasector1->budget),1);
										  
										  ?>
                            	<tr>

                                	<td><strong><?=$mi?>.</strong></td>

                                    <td><strong><?=$datasector->sector_name?></strong></td>

                                    <td><?=$perc?>% Share </td>

                                    <td><i class="fa fa-rupee-sign"></i> <?=number_format($datasector->budget);?></td>

                                    <td><div class="map-img ">
                                    	<a href="#" >
                                    	<div class="d-flex align-items-center">
                                        	<img src="img/sectors/1.jpg" alt="#">
                                        	<div>
											<?php //$sqlsgtateshare=mysqli_query($conn,"select state_id from projects where sector_id='".$datasector->sector_id."' and rupee_budget ")?>
                                            <strong> <?=$statedata['name']?></strong><br><i> State share: <span class="btn btn-dark btn-sm btn-round"><?=$statedata['totbgt']?></span></i>
                                            </div>
                                        </div>

                                    	 </a>
										
                                        </div>

                                     </td>

                                </tr>
									  <?php $mi++; } ?>
                                

                            </tbody>

                        </table>

                    </div>

                </div>

            </div>

		</div>

    </div>
    
    
    <!-- ABOUT US AREA END -->

<?php
    $selemissiondata=mysqli_query($conn,"SELECT sum(sectorial_data.data_value) as totammission,sectors.name,sectors.sector_color FROM `sectorial_data` INNER join sectors on sectorial_data.sector_name=sectors.id group by sectorial_data.sector_name");


    while($rowdata=mysqli_fetch_object($selemissiondata))
    {
    	$gdata.="{
	  text: '".$rowdata->name."',
      values: ['".$rowdata->totammission."',],
      'backgroundColor': '".$rowdata->sector_color."',
      'valueBox': [{
          text: '%node-value',
          decimals: 0,
          fontColor: '#000',
          fontWeight: 'normal',
          fontSize: 11,
          placement: 'out',
          offsetR: -15
        },
        {
          text: '".$rowdata->name."',
          fontColor: '#000',
          'fontSize': 10,
          placement: 'fixed=50%;'
        }
      ]
    },";
    }
?>

<?php
    $selgr2=mysqli_query($conn,"SELECT years FROM `sectorial_data` group by years");
    while($gr2data=mysqli_fetch_object($selgr2))
    {
       $selsectnm=mysqli_query($conn,"SELECT sum(sectorial_data.data_value) as totammission,sectors.name,sectors.sector_color FROM `sectorial_data` INNER join sectors on sectorial_data.sector_name=sectors.id where sectorial_data.years=2007 group by sectorial_data.sector_name");
        while($sectdata=mysqli_fetch_object($selsectnm))
        {

        }
    }
?>


   <?php include('include/footer.php');?>




</div>

<script src="js/plugins.js"></script>
<script src="js/main.js"></script> 



    <script>

var bgColorMain = '#FFF';

var aYears = [2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021];

var aColors = ['#3CC1CF','#FBAE44','#485463','#EF413C','#999999','#4C4C4C'];






let bgColor = 'none';


let data = [

['All India', 9, 20, 21.5, 38.3, 14.1, 'ALL'],

['Andaman and Nicobar', 9, 20, 21.5, 38.3, 14.1, 'AN'],

['Andhra Pradesh', 10, 10, 21.7, 28.1, 15.1, 'AP'],

['Arunachal Pradesh', 11, 12, 21.9, 21.5, 16.1, 'AR'],

['Assam', 12, 9, 22.1, 34.1, 17.1, 'AS'],

['Bihar', 13, 20, 22.3, 38.3, 18.1, 'BR'],

['Chandigarh', 14, 10, 22.5, 28.1, 19.1, 'CH'],

['Dadra and Nagar Haveli', 15, 12, 22.7, 21.5, 20.1, 'DN'],

['Daman and Diu', 16, 9, 22.9, 34.1, 21.1, 'DD'],

['Delhi', 17, 20, 23.1, 38.3, 22.1, 'DL'],

['Goa', 18, 10, 23.3, 28.1, 23.1, 'GA'],

['Gujarat', 19, 12, 23.5, 21.5, 24.1, 'GJ'],

['Haryana', 20, 9, 23.7, 34.1, 25.1, 'HR'],

['Himachal Pradesh', 21, 20, 23.9, 38.3, 26.1, 'HP'],

['Jammu and Kashmir', 22, 10, 24.1, 28.1, 27.1, 'JK'],

['Karnataka', 23, 12, 24.3, 21.5, 28.1, 'KA'],

['Kerala', 24, 9, 24.5, 34.1, 29.1, 'KL'],

['Madhya Pradesh', 25, 20, 24.7, 38.3, 30.1, 'MP'],

['Maharashtra', 26, 10, 24.9, 28.1, 31.1, 'MH'],

['Manipur', 27, 12, 25.1, 21.5, 32.1, 'MN'],

['Meghalaya', 28, 9, 25.3, 34.1, 33.1, 'ML'],

['Mizoram', 29, 20, 25.5, 38.3, 34.1, 'MZ'],

['Nagaland', 30, 10, 25.7, 28.1, 35.1, 'NL'],

['Orissa', 31, 12, 25.9, 21.5, 36.1, 'OR'],

['Puducherry', 32, 9, 26.1, 34.1, 37.1, 'PY'],

['Punjab', 33, 20, 26.3, 38.3, 38.1, 'PB'],

['Rajasthan', 34, 10, 26.5, 28.1, 39.1, 'RJ'],

['Sikkim', 35, 12, 26.7, 21.5, 40.1, 'SK'],

['Tamil Nadu', 36, 9, 26.9, 34.1, 41.1, 'TN'],

['Tripura', 37, 20, 27.1, 38.3, 42.1, 'TR'],

['Uttar Pradesh', 38, 10, 27.3, 28.1, 43.1, 'UP'],

['West Bengal', 39, 12, 27.5, 21.5, 44.1, 'WB'],

['Uttaranchal', 40, 20, 27.7, 38.3, 45.1, 'UT'],

['Jharkhand', 41, 10, 27.9, 28.1, 46.1, 'JH'],

['Chhattisgarh', 42, 12, 28.1, 21.5, 47.1, 'CT'],

['Telangana', 43, 9, 28.3, 34.1, 48.1, 'TL']

];



// better placement to avoid pie overlap

let oOffsets = {

  RP: [15, -15]

};



let _r_ = function (min, max) {

  return Math.round(min + (max - min) * Math.random());

};



let getNameById = function (sId) {

  let sName = 'N/A';

  for (let i = 0; i < data.length; i++) {

    if (sId === data[i][6]) {

      sName = data[i][0];

    }

  }

  return sName;

};



let oCacheDataArea = {};

let getRandomDataArea = function (sId) {

  if (oCacheDataArea[sId]) {

    return oCacheDataArea[sId];

  }

  let aValues = [

    [],

    [],

    [],

    []

  ];

  for (let i = 0; i < data.length; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);
	

    let v2 = 100 - v0 - v1 - v3;

    aValues[0].push(v0);

    aValues[1].push(v1);

    aValues[2].push(v2);

    aValues[3].push(v3);

  }

  oCacheDataArea[sId] = aValues;

  return aValues;

};


let xCacheDataArea = {};

let xgetRandomDataArea = function (sId) {

  if (xCacheDataArea[sId]) {

    return xCacheDataArea[sId];

  }

  let xValues = [

    [],

    [],

    [],

    []

  ];

  for (let i = 0; i < data.length; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);
	

    let v2 = 100 - v0 - v1 - v3;

    xValues[0].push(v0);

    xValues[1].push(v1);

    xValues[2].push(v2);

    xValues[3].push(v3);

  }

  xCacheDataArea[sId] = xValues;

  return xValues;

};



let bCacheDataArea = {};

let bgetRandomDataArea = function (sId) {

  if (bCacheDataArea[sId]) {

    return bCacheDataArea[sId];

  }

  let bValues = [

    [],

    [],

    [],

    [],

	[]

  ];

  for (let i = 0; i <1; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);

	let v4 = _r_(7, 15);

    let v2 = 100 - v0 - v1 - v3 - v4;

    bValues[0].push(v0);

    bValues[1].push(v1);

    bValues[2].push(v2);

    bValues[3].push(v3);

	bValues[4].push(v4);

  }

  bCacheDataArea[sId] = bValues;

  return bValues;

};


let eCacheDataArea = {};

let egetRandomDataArea = function (sId) {

  if (eCacheDataArea[sId]) {

    return eCacheDataArea[sId];

  }

  let eValues = [

    [],

    [],

    [],

    []

  ];

  for (let i = 0; i<1; i++) {

    let v0 = _r_(5023, 1521);

    let v1 = _r_(2532, 3503);

    let v3 = _r_(1509, 1027);

    let v2 = 10000 - v0 - v1 - v3;

    eValues[0].push(v0);

    eValues[1].push(v1);

    eValues[2].push(v2);

    eValues[3].push(v3);

  }

  eCacheDataArea[0] = eValues;

  return eValues;

};


let cCacheDataArea = {};

let cgetRandomDataArea = function (sId) {

  if (cCacheDataArea[sId]) {

    return cCacheDataArea[sId];

  }

  let cValues = [

    [],

    [],

    [],

    [],

	[]

  ];

  for (let i = 0; i <1; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);

	let v4 = _r_(7, 15);

    let v2 = 100 - v0 - v1 - v3 - v4;

    cValues[0].push(v0);

    cValues[1].push(v1);

    cValues[2].push(v2);

    cValues[3].push(v3);

	cValues[4].push(v4);

  }

  cCacheDataArea[sId] = cValues;

  return cValues;

};



let oCacheDataPop = {};

let getRandomDataPop = function (sId) {

  if (oCacheDataPop[sId]) {

    return oCacheDataPop[sId];

  }

  let aValues = [];

  let iPop = ZC._r_(200, 800);
  
  for (let i = 0; i < data.length; i++) {

    aValues.push(iPop);

    iPop += _r_(-200, 200);

  }

  let bValues = [];

  let iPop1 = ZC._r_(200, 830);

  for (let i = 0; i < data.length; i++) {

    bValues.push(iPop1);

    iPop1 += _r_(-200, 200);

  }

  oCacheDataPop[sId] = [aValues,bValues];
  
  let gdpValues = [7.5,9.5,9.6,9.3,6.7,8.6,8.9,6.7,5.5,6.4,7.4];
  let ghgValues = [6.0,6.0,7.7,5.4,6.3,4.8,5.6,6.9,3.0,2.9,1.2];
  return [gdpValues,ghgValues];
 // return [aValues,bValues];
  

};



let oCacheDataPopg = {};

let getRandomDataPopg = function (sId) {

  if (oCacheDataPopg[sId]) {

    return oCacheDataPopg[sId];

  }

  let aValuesg = [];

  let iPopg = ZC._r_(200, 830);

  for (let i = 0; i < data.length; i++) {

    aValuesg.push(iPopg);

    iPopg += _r_(-200, 200);

  }

  oCacheDataPopg[sId] = [aValuesg];
  //let gdpValues = [7.5,9.5,9.6,9.3,6.7,8.6,8.9,6.7,5.5,6.4,7.4];
  let ghgValues = [6.0,6.0,7.7,5.4,6.3,4.8,5.6,6.9,3.0,2.9,1.2];
  return [ghgValues];
  //return [aValuesg];

};





let updateAreaPopCharts = function (sId) {

  zingchart.exec('myChart', 'setdata', {

    graphid: 'gmap',

    data: getMapData(sId),

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'histarea',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'histpop',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'bhistpop',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

 zingchart.exec('myChart', 'modify', {

    graphid: 'pielegend',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'histarea',

    values: getRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'histpop',

    values: getRandomDataPop(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'bhistpop',

    values: bgetRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'pielegend',

    values: bgetRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'update');

}


/*zingchart.bind('myChart', 'shape_click', function (p) {  
  if (p.shape.mapItem) {
    updateAreaPopCharts(p.shape.id);
  }
});*/
zingchart.bind('myChart', 'node_click', function (p) {
	//console.log(p);
	if(p.graphid=='myChart-graph-bhistpop'){
		var ng = p.plotindex;
		var data00= ['Agriculture', 'Forestry and land use', 'Energy', 'Industrial Product  and Process Use', 'Waste'];
		//alert(ng);
		//alert(data00[ng]);
		
		window.location.href = "sub-sector.php?st="+data00[ng];
	}
	//console.log(p);

  if (p.graphid.indexOf('zc-graph-pie') === 0) {

    updateAreaPopCharts(p.graphid.replace('zc-graph-pie', ''));

  }

});



zingchart.bind('myChart', 'node_click', function (p) {	
  if (p.graphid.indexOf('zc-graph-pie') === 0) {	
    updateAreaPopCharts(p.graphid.replace('zc-graph-pie', ''));
  }
});
zingchart.bind('myChart', 'shape_click', function (p) {	
 // alert();
  if($.isNumeric(p.shape.id)){
	  //alert(p.shape.id);
	  if(p.shape.id==1950){
		 $('.map-scale1').removeClass('ghg-emm2');
		 $('.map-scale1').removeClass('ghg-emm3');
		 $('.map-scale1').removeClass('ghg-emm4');
		 $('.map-scale1').removeClass('ghg-emm5');
		 $('.map-scale1').removeClass('ghg-emm6');
		 $('.map-scale1').removeClass('ghg-emm7');		 
		 $('#sector-name').text('AFOLU');
		 $('.map-scale1').find('.fst').find('span').text('2.2 Million');
		 $('.map-scale1').find('.snd').find('span').text('5.8 Million');
		 $('.map-scale1').find('.trd').find('span').text('12 Million');
		 $('.map-scale1').find('.for').find('span').text('85.5 Million');
		 $('.map-scale1').find('.fft').find('span').text('115 Million');
	  }else if(p.shape.id==1990){
		 $('.map-scale1').addClass('ghg-emm2');
		 $('.map-scale1').removeClass('ghg-emm3');
		 $('.map-scale1').removeClass('ghg-emm4');
		 $('.map-scale1').removeClass('ghg-emm5');
		 $('.map-scale1').removeClass('ghg-emm6');
		 $('.map-scale1').removeClass('ghg-emm7');
		 $('#sector-name').text('Energy');
		 $('.map-scale1').find('.fst').find('span').text('1.1 Million');
		 $('.map-scale1').find('.snd').find('span').text('2.3 Million');
		 $('.map-scale1').find('.trd').find('span').text('6 Million');
		 $('.map-scale1').find('.for').find('span').text('22 Million');
		 $('.map-scale1').find('.fft').find('span').text('36 Million');
	 }else if(p.shape.id==1991){
		 $('.map-scale1').addClass('ghg-emm3');
		 $('.map-scale1').removeClass('ghg-emm2');
		 $('.map-scale1').removeClass('ghg-emm4');
		 $('.map-scale1').removeClass('ghg-emm5');
		 $('.map-scale1').removeClass('ghg-emm6');
		 $('.map-scale1').removeClass('ghg-emm7');
		 $('#sector-name').text('Climate Governance & Policy');
		 $('.map-scale1').find('.fst').find('span').text('4.1 Million');
		 $('.map-scale1').find('.snd').find('span').text('3.5 Million');
		 $('.map-scale1').find('.trd').find('span').text('18 Million');
		 $('.map-scale1').find('.for').find('span').text('35 Million');
		 $('.map-scale1').find('.fft').find('span').text('49 Million');
	  }else if(p.shape.id==1992){
		 $('.map-scale1').addClass('ghg-emm4');
		 $('.map-scale1').removeClass('ghg-emm2');
		 $('.map-scale1').removeClass('ghg-emm3');
		 $('.map-scale1').removeClass('ghg-emm5');
		 $('.map-scale1').removeClass('ghg-emm6');
		 $('.map-scale1').removeClass('ghg-emm7');
		 $('#sector-name').text('Waste');
		 $('.map-scale1').find('.fst').find('span').text('2.9 Million');
		 $('.map-scale1').find('.snd').find('span').text('5.4 Million');
		 $('.map-scale1').find('.trd').find('span').text('15 Million');
		 $('.map-scale1').find('.for').find('span').text('75 Million');
		 $('.map-scale1').find('.fft').find('span').text('89 Million');
	  }else if(p.shape.id==1993){
		 $('.map-scale1').addClass('ghg-emm5');
		 $('.map-scale1').removeClass('ghg-emm2');
		 $('.map-scale1').removeClass('ghg-emm3');
		 $('.map-scale1').removeClass('ghg-emm4');
		 $('.map-scale1').removeClass('ghg-emm6');
		 $('.map-scale1').removeClass('ghg-emm7');
		 $('#sector-name').text('Climate and Governance');
		 $('.map-scale1').find('.fst').find('span').text('1.1 Million');
		 $('.map-scale1').find('.snd').find('span').text('2 Million');
		 $('.map-scale1').find('.trd').find('span').text('8 Million');
		 $('.map-scale1').find('.for').find('span').text('11 Million');
		 $('.map-scale1').find('.fft').find('span').text('15 Million');
	  }else if(p.shape.id==1994){
		 $('.map-scale1').addClass('ghg-emm6');
		 $('.map-scale1').removeClass('ghg-emm2');
		 $('.map-scale1').removeClass('ghg-emm3');
		 $('.map-scale1').removeClass('ghg-emm4');
		 $('.map-scale1').removeClass('ghg-emm5');
		 $('.map-scale1').removeClass('ghg-emm7');
		 $('#sector-name').text('Sustainable Transport');
		 $('.map-scale1').find('.fst').find('span').text('5.1 Million');
		 $('.map-scale1').find('.snd').find('span').text('9 Million');
		 $('.map-scale1').find('.trd').find('span').text('34 Million');
		 $('.map-scale1').find('.for').find('span').text('67 Million');
		 $('.map-scale1').find('.fft').find('span').text('91 Million');
	  }else{
		 $('.map-scale1').addClass('ghg-emm7');
		 $('.map-scale1').removeClass('ghg-emm2');
		 $('.map-scale1').removeClass('ghg-emm3');
		 $('.map-scale1').removeClass('ghg-emm4');
		 $('.map-scale1').removeClass('ghg-emm5');
		 $('.map-scale1').removeClass('ghg-emm6');
		  $('#sector-name').text('Others');
		 $('.map-scale1').find('.fst').find('span').text('4.1 Million');
		 $('.map-scale1').find('.snd').find('span').text('9 Million');
		 $('.map-scale1').find('.trd').find('span').text('22 Million');
		 $('.map-scale1').find('.for').find('span').text('65 Million');
		 $('.map-scale1').find('.fft').find('span').text('89 Million');
	  }
	 
  }else{
 
	 //updateAreaPopCharts(p.shape.id)
  }
  if (p.shape.mapItem == true) {
	  //updateAreaPopCharts(p.shape.id)
    //alert(p.shape.id);
    //updateAreaPopCharts(p.shape.id);
	 
	
  }
  
      let year = p.shapeid;
      if (Object.keys(population).indexOf(year) < 0) {
		  //alert('1');
        return;
      }
      if (lastClick == year) {
		  //alert('2');
        lastClick = null;
        zingchart.exec('myChart', 'setdata', {
          data: mapConfig,
		  graphid: 'gmapc'
        });
      } else {
		  //alert('3');
        lastClick = year;
        let newData = copy(mapConfig);
        newData.shapes[0].options.style.items = createItems(year);
        zingchart.exec('myChart', 'setdata', {
          data: newData,
		  graphid: 'gmapc'
        });
      }
  	
	
});




let addPieGraphs = function () {
  for (let i = 0; i < data.length; i++) {
    let info = data[i];
    let xy = zingchart.maps.getXY('mapind', [info[1], info[2]]);
    let oGraph = {
      id: 'pie' + info[6],
      type: 'pie',
      x: xy[0] - 80 + (oOffsets[info[6]] ? oOffsets[info[6]][0] : 0),
      y: xy[1] - 25 + (oOffsets[info[6]] ? oOffsets[info[6]][1] : 0),
      width: '160px',
      height: '50px',
      backgroundColor: 'none',
      plotarea: {
        margin: '2px'
      },
      plot: {
        detach: false,
        alpha: 0.75,
        borderWidth: '0px',
        valueBox: {
          visible: false
        }
      },
      title: {
        fontSize: '10px',
        offsetY: '40px',
        fontWeight: 'bold',
        text: info[0]
      },
      tooltip: {
        padding: '10px',
        fontSize: '13px',
        fontWeight: 'bold',
        text: '%node-value% in %plot-text'
      },
      series: [{
        text: 'Settlement Area',
        values: [info[5]],
        backgroundColor: '#d15c5c'
      },
      {
        text: 'Forest Area',
        values: [info[4]],
        backgroundColor: '#56b556'
      },
      {
        text: 'Agriculture',
        values: [info[3]],
        backgroundColor: '#e5e510'
      },
      {
        text: 'Other',

        values: [Number((100 - info[3] - info[4] - info[5]).toFixed(1))],

        backgroundColor: '#999'

      }

      ]

    };

    zingchart.exec('myChart', 'addgraph', {

      data: oGraph,

      update: false

    });

  }

  zingchart.exec('myChart', 'update');

}

let mapConfig = {
	
    backgroundColor: 'none',
    x: '0px',
    y: '0px',
    width: '800px',
    height: '600px',
    type: 'null',
    id: 'gmapc',
	
    title: {
      align: 'left',
      fontSize: '15px',
      paddingLeft: '20px',
      text: ''
    },
    source: {
      text: '(*) dummy data',
      offsetX: '-50px'
    },
    colorScale : {
      layout : 'h',
      width : 300,
      height : 10,
      margin : 'auto auto 20 auto',
      item : {
        fontSize : 10,
        offsetY : -5
      },
      cursor : {
        size : 3
      },
      map : true
    },
      shapes: [{
          type: 'zingchart.maps',
          options: {
            id: 'map',
            name: 'ind',
			zooming: false,
            panning: false,
            scrolling: false,
			scale: true,
			width: '480px',
        	height: '580px',
            colorScale : true,
            style: {
			  controls: {visible: false},
			  label: {visible: false},
              hoverState: {visible: false},
              tooltip: {borderRadius: '0px'},
              backgroundColor: '#ebebeb',
			  
			  items: {
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#edfaef',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#b8e6bf',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#68de7c',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},

BR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#b8e6bf',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#68de7c',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#005c12',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#edfaef',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#b8e6bf',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#68de7c',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#00a32a',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#b8e6bf',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#68de7c',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#005c12',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#edfaef',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#b8e6bf',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#68de7c',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#00a32a',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#b8e6bf',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Uttarakhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#008a20',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#68de7c',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#1ed14b',label: {visible: true}},



}
			  
            },
			x: '0px',
			y: '20px',
			width: '480px',
			height: '580px',
          }
        },{
          type: 'circle',
          id: '1950',
          backgroundColor: '#8b8b8b',
          borderColor: '#8b8b8b',
          borderWidth: '1px',
          cursor: 'pointer',
          label: {
            text: 'AFOLU',
        	fontColor: '#000',
        	fontFamily: 'arial',
        	offsetX: '40px',
			fontWeight : 'bold',
          },
		  size: '10px',
		  x: '280px',
		  y: '385px'
    },
        {
          type: 'circle',
          id: '1990',
          backgroundColor: '#2b5680',
		  borderColor: '#2b5680',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Energy',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '40px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '412px'
    },{
          type: 'circle',
          id: '1991',
          backgroundColor: '#00a57b',
		  borderColor: '#00a57b',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Climate Governance & Policy',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '97px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '440px'
		},{
          type: 'circle',
          id: '1992',
          backgroundColor: '#f96e3b',
		  borderColor: '#f96e3b',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Waste',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '40px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '468px'
		},{
          type: 'circle',
          id: '1993',
          backgroundColor: '#c01348',
		  borderColor: '#c01348',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Climate and Governance',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '85px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '496px'
		},
        
      ]
    };



    // Keep track of last shape clicked
    let lastClick = null;

    // Population data for updating the chart
    let population = {
      1950: {
        bgColor: '#d63638',
        states: ['AN','AP','AR','BR','CH','DN','DD','GA','GJ','HR','JK','KA','KL','MP','MH','MN']
      },
      1990: {
        bgColor: '#2271b1',
        states: ['AN','AP','AR','BR','CH','DN','DD','GA','GJ','HR','JK','KA','KL','MP','MH','MN']
      },
	  1991: {
        bgColor: '#FF4500',
        states: ['AN','AP','AR','BR','CH','DN','DD','GA','GJ','HR','JK','KA','KL','MP','MH','MN']
      },
	  1992: {
        bgColor: '#FF4500',
        states: ['AN','AP','AR','BR','CH','DN','DD','GA','GJ','HR','JK','KA','KL','MP','MH','MN']
      },
	  1993: {
        bgColor: '#FF4500',
        states: ['AN','AP','AR','BR','CH','DN','DD','GA','GJ','HR','JK','KA','KL','MP','MH','MN']
      },
	  1994: {
        bgColor: '#FF4500',
        states: ['AN','AP','AR','BR','CH','DN','DD','GA','GJ','HR','JK','KA','KL','MP','MH','MN']
      },
	  1995: {
        bgColor: '#FF4500',
        states: ['AN','AP','AR','BR','CH','DN','DD','GA','GJ','HR','JK','KA','KL','MP','MH','MN']
      }
    };

    // Returns the styled items object
    let createItems = (year) => {
      let data = population[year];
	  let items = {};
	  if(year==1950)
	  {
      items = {
        <?php 
            $selsqlafou="SELECT sum(rupee_budget) as rupee_budget,sum(doller_budget) as doller_budget,state.* FROM `projects_state` inner JOIN state on projects_state.state_id=state.id where sector_id=2 GROUP BY state_id";
            $mapqryafou=mysqli_query($conn,$selsqlafou);
            while($afouMapData=mysqli_fetch_object($mapqryafou)){
            
            if($_SESSION['currency']==1){ 
                $stateamount=$afouMapData->rupee_budget/1000000;
                if($stateamount<=2.2){
                    $mapbgcolorafou='#88898e4d';
                }elseif($stateamount>2.2 && $stateamount<=5.8){
                    $mapbgcolorafou='#8a8a8c66';
                }elseif($stateamount>5.8 && $stateamount<=12){
                    $mapbgcolorafou='#88888e94';
                }elseif($stateamount>12 && $stateamount<=85.5){
                    $mapbgcolorafou='#86868f';
                }else{
                    $mapbgcolorafou='#89898d';
                }
            
            }
?>
        
<?=$afouMapData->state_code;?>: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;"><?=$afouMapData->name;?></span><br><span style="font-size:12px;font-weight:bold;">Total Funding: </span><?php if($_SESSION['currency']==1){ echo "&#8377;".number_format($afouMapData->rupee_budget/1000000,2); }else{ echo "&#36;".number_format($afouMapData->doller_budget/1000000,2);} ?>'},backgroundColor: '<?=$mapbgcolorafou;?>',label: {visible: true}},

<?php } ?>

}
	  }
	  if(year==1990) {
		        items = { 
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#9ec2e6',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#9ec2e6',label: {visible: true}},

BR: { tooltip : {lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#3582c4',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#4f94d4',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#72aee6',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#72aee6',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#0a4b78',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#0a4b78',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#0a4b78',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#9ec2e6',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#9ec2e6',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#3582c4',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#4f94d4',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#72aee6',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#72aee6',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#0a4b78',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#0a4b78',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#043959',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#9ec2e6',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c5d9ed',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#9ec2e6',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#3582c4',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#53acff', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#53acff',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#4f94d4',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttaranchal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#72aee6',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#72aee6',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#0a4b78',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#0a4b78',label: {visible: true}},

};
	  }
	  
	  if(year==1991) {
		        items = { 
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff8e51',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

BR: { tooltip : {lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff4500',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff4500',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff4500',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff903f',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff4500',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#043959',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff4500',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb295',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff4500',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttaranchal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#eb4810',label: {visible: true}},

};
	  }
	  
	   if(year==1992) {
		   items = { 
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ff8981',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

BR: { tooltip : {lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f42c2e',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f42c2e',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f42c2e',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f65050',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f42c2e',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#043959',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f42c2e',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f6a3a3',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f42c2e',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttaranchal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ec474b',label: {visible: true}},

};
	   }
	  if(year==1993) {
		   items = { 
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#c660b0',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

BR: { tooltip : {lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f254d0',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f254d0',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f254d0',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f650ab',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f254d0',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#043959',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f254d0',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffaeed',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#f254d0',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttaranchal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#e334bd',label: {visible: true}},

};
	   }
	   if(year==1994) {
		   items = { 
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#60a1c6',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

BR: { tooltip : {lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#54b8f2',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#54b8f2',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#54b8f2',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#5092f6',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#54b8f2',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#043959',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#54b8f2',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#aee1ff',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#54b8f2',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttaranchal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#34a3e3',label: {visible: true}},

};
	   }
	   if(year==1995) {
		   items = { 
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#dda348',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

BR: { tooltip : {lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#d38b38',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#d38b38',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffb947',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe447',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#d38b38',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#043959',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#d38b38',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffe0ae',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#d38b38',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttaranchal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301'},backgroundColor: '#ffa618',label: {visible: true}},

};
	   }
      
      return items;
    }

    // Deep copy a Javascript object
    let copy = (obj) => {
      return JSON.parse(JSON.stringify(obj));
    }   

var getMapData = function (sId) {

  let oGraphMainMap = {
    backgroundColor: 'none',
    x: '0px',
    y: '0px',
    width: '800px',
    height: '600px',
    type: 'null',
    id: 'gmap',
    title: {
      align: 'left',
      fontSize: '15px',
      paddingLeft: '20px',
      text: ''

    },
    source: {
      text: '(*) dummy data',
      offsetX: '-50px'
    },

    shapes: [{
      type: 'zingchart.maps',
      options: {
        x: '0px',
        y: '20px',
        width: '480px',
        height: '580px',
        id: 'mapdeu',
        name: 'ind',
        zooming: false,
        panning: false,
        scrolling: false,
        scale: true,
        style: {
          controls: {
            visible: false
          },
          label: {
            visible: false
          },   
          hoverState: {
            visible: false
          },
           items: {
AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102340<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AN">View More</a>'},backgroundColor: '#edfaef',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104425<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>5.27 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>4.05 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AP">View More</a>'},backgroundColor: '#b8e6bf',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102341<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>15.33 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>5.01 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AR">View More</a>'},backgroundColor: '#68de7c',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104426<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>3.50 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>6.8 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AS">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},

BR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102342<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>12.30 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>7.09 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?BR">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104427<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>12 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?CH">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102343<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>6.77 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>4.05 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?DN">View More</a>'},backgroundColor: '#b8e6bf',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104428<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>5.77 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>5.01 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?DD">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102344<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>2 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>6.8 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?DL">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104429<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>16 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>7.09 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?GA">View More</a>'},backgroundColor: '#68de7c',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Gujarat</span><br><span style="font-size:10px;ffont-weight:bold;">Income Per Capita: </span>₹ 102345<br><span style="font-size:10px;ffont-weight:bold;">Total Population: </span>7 Crores<br><span style="font-size:10px;ffont-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:10px;ffont-weight:bold;">Projects: </span>71<br><span style="font-size:10px;ffont-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:#fff; text-align: center; cursor: pointer; ffont-weight:bold;" href="view-profile.php?GJ">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104430<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>2.95 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>4.05 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?HR">View More</a>'},backgroundColor: '#005c12',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102346<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>74 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>5.01 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?HP">View More</a>'},backgroundColor: '#edfaef',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104431<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>1.34 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>6.8 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?JK">View More</a>'},backgroundColor: '#b8e6bf',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102347<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>6.70 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>7.09 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?KA">View More</a>'},backgroundColor: '#68de7c',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104432<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>3.55 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?KL">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102348<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>8.45 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>4.05 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MP">View More</a>'},backgroundColor: '#00a32a',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104433<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>12.44 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>5.01 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MH">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102349<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>31.65 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>6.8 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MN">View More</a>'},backgroundColor: '#b8e6bf',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104434<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>33 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>7.09 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?ML">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102350<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>12.16 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MZ">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104435<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>22 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>4.05 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?NL">View More</a>'},backgroundColor: '#68de7c',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Odisha</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102351<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>4.55 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>5.01 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?OR">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104436<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>15.71 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>6.8 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?PY">View More</a>'},backgroundColor: '#005c12',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102352<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>3 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>7.09 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?PB">View More</a>'},backgroundColor: '#edfaef',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104437<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>7.92 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?RJ">View More</a>'},backgroundColor: '#b8e6bf',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102353<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>6.77 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>4.05 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?SK">View More</a>'},backgroundColor: '#68de7c',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104438<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>7.65 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>5.01 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?TN">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102354<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>41 Lakhs<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>6.8 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?TR">View More</a>'},backgroundColor: '#00a32a',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104439<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>23 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>7.09 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?UP">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102355<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>9.8 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>3.21 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?WB">View More</a>'},backgroundColor: '#b8e6bf',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Uttarakhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104440<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>1.14 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>4.05 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?UT">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102356<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>3.85 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>5.01 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?JH">View More</a>'},backgroundColor: '#008a20',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 104441<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>2.95 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>6.8 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?CT">View More</a>'},backgroundColor: '#68de7c',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:21px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Income Per Capita: </span>₹ 102357<br><span style="font-size:12px;font-weight:bold;">Total Population: </span>3.80 Crores<br><span style="font-size:12px;font-weight:bold;">CO2 Emission: </span>7.09 MT<br><span style="font-size:12px;font-weight:bold;">Projects: </span>71<br><span style="font-size:12px;font-weight:bold;">Total Funding: </span>₹1421301<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?TL">View More</a>'},backgroundColor: '#1ed14b',label: {visible: true}},



}

        }

      }

    },{
          type: 'circle',
          id: '1950',
          backgroundColor: '#036219',
          borderColor: '#036219',
          borderWidth: '1px',
          cursor: 'pointer',
          label: {
            text: 'Air Quality',
        	fontColor: '#000',
        	fontFamily: 'arial',
        	offsetX: '50px',
			fontWeight : 'bold',
          },
		  size: '10px',
		  x: '280px',
		  y: '385px'
    },
        {
          type: 'circle',
          id: '1990',
          backgroundColor: '#0a4b78',
		  borderColor: '#0a4b78',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Climate Finance',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '64px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '412px'
    },{
          type: 'circle',
          id: '1991',
          backgroundColor: '#eb4810',
		  borderColor: '#eb4810',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Climate Governance & Policy',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '97px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '440px'
		},{
          type: 'circle',
          id: '1992',
          backgroundColor: '#ff4242',
		  borderColor: '#ff4242',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Energy Efficiency',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '67px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '468px'
		},{
          type: 'circle',
          id: '1993',
          backgroundColor: '#e334bd',
		  borderColor: '#e334bd',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Sustainable land use',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '74px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '496px'
		},{
          type: 'circle',
          id: '1994',
          backgroundColor: '#3138ff',
		  borderColor: '#3138ff',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Sustainable Transport',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '78px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '522px'
		},{
          type: 'circle',
          id: '1995',
          backgroundColor: '#bba538',
		  borderColor: '#bba538',
		  borderWidth: '1px',
		  cursor: 'pointer',
		  label: {
			text: 'Others',
			fontColor: '#000000',
			fontFamily: 'arial',
			margin:'50',
			offsetX: '38px',
			fontWeight : 'bold',
		  },
		  size: '10px',
		  x: '280px',
		  y: '549px'
		}
	
	],
	"legend": {
	 'background-color': "#ffffff",
    'border-width':0,
    'border-color': "red",
    'border-radius': "0px",
	fontSize: "4px",
	width:"150%",
    padding: "0%",
 	 layout: "2x2", //row x column
	  x: "0%",
	  y: "95%",
  },
	choropleth: {
        legend: {
          header: {
            text: 'Population Range'
          },
          item: {
            cursor: 'pointer',
          },
          marker: {
            cursor: 'pointer'
          },
          align: 'left',
          verticalAlign: 'bottom',
          items: [{
            text: ' > 100,000'
          }]
        }
      }
  };

  oGraphMainMap.shapes[0].options.style.items[sId] = {
    backgroundColor: '#eeeeee #c2edc3'
  };
  return oGraphMainMap;
};


<?php 
$secarrayfinalsect1=array();
$secarrayfinalsect2=array();
$secarrayfinalsect3=array();
$secarrayfinalsect4=array();

$secarrayfinalsectVal1=array();
$secarrayfinalsectVal2=array();
$secarrayfinalsectVal3=array();
$secarrayfinalsectVal4=array();

  $selectsecsql="select sector_pre,data_value,sector_name,years from sectorial_data group by sector_name,years ORDER BY `sectorial_data`.`years` ASC";
    $secqry=mysqli_query($conn,$selectsecsql);
    while($secarray=mysqli_fetch_array($secqry)){
      if($secarray['sector_name']==1){
        $secarrayfinalsect1[]=round($secarray['sector_pre'],1);
		$secarrayfinalsectVal1[]=$secarray['data_value'];
      }elseif($secarray['sector_name']==2){
        $secarrayfinalsect2[]=round($secarray['sector_pre'],1);
		$secarrayfinalsectVal2[]=$secarray['data_value'];
      }elseif($secarray['sector_name']==3){
        $secarrayfinalsect3[]=round($secarray['sector_pre'],1);
		$secarrayfinalsectVal3[]=$secarray['data_value'];
      }else{
        $secarrayfinalsect4[]=round($secarray['sector_pre'],1);
		$secarrayfinalsectVal4[]=$secarray['data_value'];
      }
        
    }
    $sec1=implode(",",$secarrayfinalsect1);
    $sec2=implode(",",$secarrayfinalsect2);
    $sec3=implode(",",$secarrayfinalsect3);
    $sec4=implode(",",$secarrayfinalsect4);
	
	$secVal1=implode(",",$secarrayfinalsectVal1);
    $secVal2=implode(",",$secarrayfinalsectVal2);
    $secVal3=implode(",",$secarrayfinalsectVal3);
    $secVal4=implode(",",$secarrayfinalsectVal4);

?>

let aAreaValues =[[<?=$sec1;?>], [<?=$sec2;?>],[<?=$sec3;?>],[<?=$sec4;?>]];
let aAreaValues4 =[[<?=$secVal1;?>], [<?=$secVal2;?>],[<?=$secVal3;?>],[<?=$secVal4;?>]];
// let abs='%node-value'*5;
let oGraphHistoryArea = {
  id: 'histarea',
  backgroundColor: 'none',
  x: '480px',
  y: '300px',
  width: '360px',
  height: '250px',
  type: 'bar',
  stacked: true,
  "legend": {
	 'background-color': "#ffffff",
    'border-width':0,
    'border-color': "red",
    'border-radius': "0px",
	fontSize: "4px",
	width:"97%",
    padding: "0%",
 	 layout: "2x3", //row x column
	  x: "0%",
	  y: "95%",
  },
  title: {
    fontSize: '14px',
    text: 'Maximum sectoral fund to state'
  },
  source: {
    text: ''
  },
  plotarea: {
    margin: '35 5 35 35'
  },
  scaleX: {
    values: '2005:2015:1',
    maxItems: 99,
    itemsOverlap: true,
    item: {
      fontSize: '9px'
    }
  },
  tooltip: {
    text: '%plot-text in %scale-key-text: %node-value%'
  },
  scaleY: {
    format: '%v%',
    item: {
      fontSize: '10px'
    }
  },
  plot: {
    animation: {
      speed: 200,
      effect: 'ANIMATION_FADE_IN',
      method: 'ANIMATION_LINEAR',
      sequence: 'ANIMATION_BY_NODE'
    }
  },
  series: [{
    backgroundColor: '#8b8b8b',
    values: aAreaValues[0],
    text: 'AFOLU'  
	},
   {
    backgroundColor: '#2b5680',
    values: aAreaValues[1],
    text: 'Energy'
  },
  {
    backgroundColor: '#00a57b',
    values: aAreaValues[2],
    text: 'Industrial product and <br>process use'
  },
  {
    backgroundColor: '#f96e3b',
    values: aAreaValues[3],
    text: 'Waste'
  }
  ]};


let aPopValues = getRandomDataPop(data[0][6]);
let bPopValues = getRandomDataPopg(data[0][6]); 
let oGraphHistoryPop = {
  type: 'ring',
  id: 'bhistpop',
  backgroundColor: bgColor,
  x: '880px',
  y: '270px',
  width: '290px',
  height: '290px',
  wrapText: true,
  "legend": {
	 'background-color': "#ffffff",
    'border-width':0,
    'border-color': "red",
    'border-radius': "0px",
	"white-space": "normal",
	wrapText: true,
	width:"320px",
    padding: "0%",
 	 layout: "2x2", //row x column
	  x: "0%",
	  y: "92%",
  },
  title: {
    fontSize: '14px',
    text: 'Emissions by sector',
	y:'30'
  },
  scale: {
    sizeFactor: 0.75
  },
  'scaleR': {
    refAngle: 270
  },
  plot: {
    'borderWidth': 0
  },
  tooltip: {
    text: '%t: %node-value'
  },
  series: [<?=$gdata?>]
};



let chartConfig = {

  flat: true,

  backgroundColor: '#fff',

  borderColor: '#fff',

  borderWidth: '0px',

  graphset: [

    //getMapData(data[0][6]),
    mapConfig,
    oGraphHistoryArea,
    oGraphHistoryPop
	

  ]

};

///fundingcharts

let bInit = true;

zingchart.bind('myChart', 'load', function () {

  if (bInit) {

    bInit = false;

    addPieGraphs();

  }

});



//zingchart.DEV.MAPSONBOTTOM = 0;

// renders chart

zingchart.loadModules('maps, maps-ind', function (e) {

  zingchart.render({

    id: 'myChart',
    modules: 'choropleth',
    data: chartConfig,
	
    height: '100%',

    width: '100%'

  });

});





	</script>

<script src="js/plugins.js"></script>

<script src="js/main.js"></script>

<script>
$(document).ready(function(){
  $('[data-toggle="tooltip"]').tooltip();
});
</script>
<script>


function getDaterangeval(v){
    //alert('ccc');
	$.ajax({
		url:"get_data.php",
		type:"POST",
		data:{date_range:v},
		success:function(response){
			console.log(response);  
			$('#fundingsector_data').html(response);
		}
	}); 
}

</script>
</body>

</html>



