<!doctype html>

<html class="no-js" lang="zxx">

<head>

    <meta charset="utf-8">

    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <title>Climate Shakti - Dashboard</title>

    <meta name="robots" content="noindex, follow" />

    <meta name="description" content="">

    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="shortcut icon" href="img/favicon.png" type="image/x-icon" />

    <link rel="stylesheet" href="css/font-icons.css">

    <link rel="stylesheet" href="css/plugins.css">

    <link rel="stylesheet" href="css/style.css">

    <link rel="stylesheet" href="css/responsive.css">

    <script src="https://cdn.zingchart.com/zingchart.min.js"></script>

  <style>

    .chart--container {

      height: 100%;

      width: 100%;

      min-height: 650px;

    }



    .zc-ref {

      display: none;

    }

    #myChart-license-text { display:none;}

	#container123 {

	 position:absolute;

	 float:right;

	 right: 0;

	 z-index:10;

	}

	

	

  </style>



     

</head>



<body>

    <!--[if lte IE 9]>

        <p class="browserupgrade">You are using an <strong>outdated</strong> browser. Please <a href="https://browsehappy.com/">upgrade your browser</a> to improve your experience and security.</p>

    <![endif]-->



    <!-- Add your site or application content here -->



<!-- Body main wrapper start -->

<div class="body-wrapper">



   <?php include('include/header.php');?>



   





    <div class="ltn__utilize-overlay"></div>



    <!-- BREADCRUMB AREA START -->
    
    
    <div class="ltn__breadcrumb-area text-left bg-overlay-black-80 bg-image " data-bs-bg="img/bg/breadcumb-bg.jpg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="ltn__breadcrumb-inner">
                        <h4 class="page-title">Dashboard</h4>
                        <div class="ltn__breadcrumb-list">
                            <ul>
                                <li><a href="index.php"><span class="ltn__secondary-color"><i class="fas fa-home"></i></span> Home</a></li>
                                <li>Dashboard</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    

    <!-- BREADCRUMB AREA END -->



    <!-- ABOUT US AREA START -->

    <div class="ltn__about-us-area pt-120--- pt-20 pb-30 mt--30">

        <div class="container">

            <div class="row">

                <div class="col-lg-12">
                <style type="text/css">
                .map-scale1{
					display: flex;
					flex-wrap: nowrap;
					max-width: 476px;
					z-index: 9999999;
					position: absolute;
					bottom: 42px;
					width: 100%;
				}
				.map-scale1 > div{
					width:33%;
					height:8px;
				}
				.map-scale1 > div.fst{
					background:#e65054;
				}
				.map-scale1 > div.snd{
					background:#b32d2e;
				}
				.map-scale1 > div.trd{
					background:#691c1c;
				}
                </style>

                    <div id="myChart" class="chart--container">

                    <a href="https://www.zingchart.com/" rel="noopener" class="zc-ref">Powered by ZingChart</a>

                   <div id="container123" style="width:328px; height: 450px; "></div>
				   <div class="inner-map-statics">
                   		<div class="mp-slider">
                        	<div>
                            	<h6>Socio Economic Profile </h6>
                            	<ul class="ltn__list-item-1 clearfix dashboard-listing sm-box">
								    <li> <strong>Total Population <small><i>(2011)</i></small></strong>  <span> : 1.21 Billion </span></li>
                                    <li> <strong>Population in Urban Areas <small><i>(2011)</i></small></strong><span> : 30% </span></li>
                                    <li> <strong>Population Density <small><i>(2011)</i></small></strong><span> : 382 Person/ &nbsp;&nbsp; sq. km </span></li>      								<li> <strong>GDP Growth Rate <small><i>(2021)</i></small></strong>: 8.4%</li>
                                </ul>
                            </div>
                            <div>
                            	<h6>Climate Profile </h6>
                            	<ul class="ltn__list-item-1 clearfix dashboard-listing sm-box">
                                    <li> <strong>Annual Max Temperature <small><i>(2021)</i></small></strong> <span>: 44 °C </span></li>
                                    <li> <strong>Annual Min Temperature <small><i>(2011)</i></small></strong> <span>: 20.76 °C </span></li>
                                    <li> <strong>Rainfall in India <small><i>(2021)</i></small></strong> <span>: 1,881(mm)</span></li>
                                    <li><strong> GHG Emission <small><i>(2016)</i></small></strong><span>: 2,531.07 &nbsp;&nbsp; million tCO<sub>2</sub>e</span></li>
                                    
                                   
                                </ul>
                            </div>
                        </div>
                   </div>
                   
                   
				   <div id="fundinglabel">

				   <span class="x-m-font">Total Funding</span>
				   <span><i class="fa fa-rupee-sign"></i> <span class="counter">759</span> Million</span>
                   <span class="x-sm-font">(Provisinal Data for 2021)</span>

				   </div>

                </div>

                
					<div class="map-scale1">
                   	<div class="fst" data-toggle="tooltip" data-placement="top" title="Low Vulnerability">
                    
                    </div>
                    <div class="snd" data-toggle="tooltip" data-placement="top" title="Medium Vulnerability">
                    
                    </div>
                    <div class="trd" data-toggle="tooltip" data-placement="top" title="High Vulnerability">
                    
                    </div>
                   </div>
                </div>

				<div class="col-md-5">                 	

                    <div class="maps-boxes extra-height">

                        <div class="map-heading justify-content-start">

                            <h4>Focus Area for Intervention</h4>

                        </div>

                        <ul class="ltn__list-item-1 ltn__list-item-1-before clearfix dashboard-listing">                    

                            <li> <a href="sectors.php?st=Air-Quality">Air quality</a></li>

                            <li> <a href="sectors.php?st=Clean-Finance">Climate Finance</a></li>

                            <li> <a href="sectors.php?st=Climate-Governance-and-Policy">Climate governance and policy</a></li>

                            

                            <li> <a href="sectors.php?st=Energy-Efficiency">Energy Efficiency</a></li>

                            <li> <a href="sectors.php?st=Sustainable-Land-Use">Sustainable land use</a></li>

                            <li> <a href="sectors.php?st=Sustainable-Transport">Sustainable Transport</a></li>
                            <li> <a href="sectors.php?st=Other">Others</a></li>


                        </ul>

                        

                    </div>                 

                 </div>

                 <div class="col-md-7">                 	

                    <div class="maps-boxes extra-height">

                        <div class="map-heading justify-content-start">

                            <h4 class="text-left">Success Stories</h4>

                        </div>

                        <div class="ltn__search-by-place-area">

                            <div>                                

                                <div class="row latest-stories slick-arrow-3">

                                    <div class="col-lg-4">

                                        <div class="story-box">    

                                        	<div class="story-up">                                         

                                                <div class="story-data">

                                                    <h6><a href="#">New Microgrid Is a Symbol of Resilience for Bad River Band</a></h6>

                                                    <p>Bad River Band of Lake Superior Tribe of Chippewa Indians complete the Ishkonige Nawadide Solar Microgrid Project.</p>

                                                    <div class="read-m-btn">

                                                        <a href="#">Read More <i class="flaticon-right-arrow"></i></a>

                                                    </div>

                                                </div>

                                                <div class="story-img">

                                                    <a href="#"><img src="img/10.jpg" alt="#"></a>

                                                </div>

                                            </div>

                                            <div class="story-down"> 

                                            	<ul class="ltn__list-item-1 ltn__list-item-1-before clearfix dashboard-listing">

                                                    <li> 30,000 people are numerable because of extreme climate condition</li>

                                                    <li> Government of Odisha Has mandated all industry to create equivalent green cover</li>

                                                </ul>

                                            </div>

                                        </div>

                                    </div>                                  

                                    <div class="col-lg-4">

                                        <div class="story-box">    

                                        	<div class="story-up">                                         

                                                <div class="story-data">

                                                    <h6><a href="#">New Microgrid Is a Symbol of Resilience for Bad River Band</a></h6>

                                                    <p>Bad River Band of Lake Superior Tribe of Chippewa Indians complete the Ishkonige Nawadide Solar Microgrid Project.</p>

                                                    <div class="read-m-btn">

                                                        <a href="#">Read More <i class="flaticon-right-arrow"></i></a>

                                                    </div>

                                                </div>

                                                <div class="story-img">

                                                    <a href="#"><img src="img/10.jpg" alt="#"></a>

                                                </div>

                                            </div>

                                            <div class="story-down"> 

                                            	<ul class="ltn__list-item-1 ltn__list-item-1-before clearfix dashboard-listing">

                                                    <li> 30,000 people are numerable because of extreme climate condition</li>

                                                    <li> Government of Odisha Has mandated all industry to create equivalent green cover</li>

                                                </ul>

                                            </div>

                                        </div>

                                    </div>

                                    

                                    

                                    

                                    

                                    

                                    

                                    <!--  -->

                                </div>

                            </div>

                        </div>

                        

                    </div>                 

                 </div>

                

            </div>

        </div>

    </div>

	

	

             	



    <!-- ABOUT US AREA END -->



    



    



   



    



   <?php include('include/footer.php');?>



</div>



<script src="https://code.highcharts.com/highcharts.js"></script>

<script src="https://code.highcharts.com/modules/data.js"></script>

<script src="https://code.highcharts.com/modules/sunburst.js"></script>

<script src="https://code.highcharts.com/modules/exporting.js"></script>

<script src="https://code.highcharts.com/modules/accessibility.js"></script>

<script src="https://code.highcharts.com/highcharts-more.js"></script>

<script>

Highcharts.chart('container123', {

    colors: ['#00a32a','#00ba37','#dba617','#4f94d4','#8c8f94','#f86368','#451313'],

    chart: {

        type: 'column',

        inverted: true,

        polar: true

    },

    title: {

		style: {

			"fontSize": "15px",

			"fontFamily": "'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Helvetica, Arial, sans-serif",

			"fontWeight": "bold",

			"color": "#414042"

		},

        text: 'Funding Snapshot (Since 2015)'

    },

	subtitle: {

        text: '(in Million)',

		style: {

			"fontSize": "12px",

			"fontFamily": "'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Helvetica, Arial, sans-serif",

			"fontWeight": "bold",

			"color": "#414042"

		}

    },

    tooltip: {
        inside: true

    },

    pane: {

        size: '85%',

        innerSize: '20%',

        endAngle: 270

    },

    xAxis: {

        tickInterval: 1,

        labels: {

            align: 'right',

            useHTML: true,

            allowOverlap: true,

            step: 1,

            y: 3,

            style: {

                fontSize: '13px'

            }

        },

        lineWidth: 0,

        categories: ['2015','2016','2017','2018','2019','2020','2021']

    },

    yAxis: {

        crosshair: {

            enabled: true,

            color: '#333'

        },

        lineWidth: 0,

        tickInterval: 25,

        reversedStacks: false,

        endOnTick: true,

        showLastLabel: true

    },

    plotOptions: {

        column: {

            stacking: 'normal',

            borderWidth: 0,

            pointPadding: 0,

            groupPadding: 0.15

        }

    },

	legend: {
	   layout: 'horizontal',
       itemDistance: 20,
	   itemWidth: 130,
	  itemStyle: {
	
		fontWeight: 'bold',
	
		fontSize: '9px'
	
	  }

},

    series: [{

        name: 'Air quality',

        data: [0.00,16.95,0.00,31.93,6.17,72.37,3.46]

    }, {

        name: 'Climate Finance',

        data: [108.75,87.42,123.11,67.85,151.27,117.42,2.79]

    }, {

        name: 'Climate Governance and Policy',

        data: [449.18,277.94,330.40,202.06,218.88,387.92,5.67]

    }, {

        name: 'Energy Efficiency',

        data: [0.00,0.00,10.89,0.00,0.00,0.00,0.00]

    }, {

        name: 'Sustainable Land Use',

        data: [85,65.77,113,152,67.80,11.09,0.00]

    }, {

        name: 'Sustainable Transport',

        data: [98.87,78.45,118.30,22.51,64.80,128.09,0.00]

    }, {

        name: 'Others',

        data: [171.43,67.88,87.30,35.51,79.80,145.09,0.00]

    }],

	exporting: {

    enabled: false

  }

});

</script>

    <script>

var bgColorMain = '#FFF';

var aYears = [2007,2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021];

var aColors = ['#3CC1CF','#FBAE44','#485463','#EF413C','#999999','#4C4C4C'];



var aGender = ['Men','Women'];

var aAge = ['18-24','25-34','35-44','45-54','55-64','65+'];

var aRegion = ['Northeast','Midwest','South','West'];



// g2 ////////////////////////////////

var aSeries2_a = [48.48,59.06,64.82,66.54,56.31,66.28,72.31,79.82,75.03,77.52,74.34,82.93,86.13,86.79,86.27];

var aSeries2_b = [3.3,5.0,5.1,5.8,4.8,5.8,6.9,8.0,7.0,7.4,6.9,8.4,9.1,9.0,8.8];



var aTooltip2 = ['Per person expected Halloween spending','Total expected Halloween spending(in billions)'];

//////////////////////////////////////



// g3 /////////////////////////////////

var aSeries3_a = [

	[53,60,61,62,59,62,65,66,65,67,64,67,69,68,67],

	[95,96,95,96,94,96,96,96,96,95,94,94,95,95,95]

];



var aSeries3_b = [

	[16.98,21.57,23.33,24.17,20.75,23.37,26.52,28.65,27.85,29.26,27.33,31.03,31.73,31.26,31.05],

	[17.09,18.72,19.84,20.39,17.99,20.29,21.05,23.27,22.37,23.39,23.10,24.43,25.27,25.47,25.37],

	[12.35,15.63,17.73,18.25,14.54,18.66,19.79,23.56,20.99,21.20,20.34,23.62,25.24,26.21,26.03],

	[2.06,3.14,3.92,3.73,3.02,3.95,4.96,4.34,3.82,3.67,3.57,3.84,3.88,3.85,3.82]

];



var aSeries3_c = [

	[1.2,1.8,1.8,2.1,1.8,2.0,2.5,2.9,2.6,2.8,2.5,3.1,3.4,3.2,3.2],

	[1.2,1.6,1.6,1.8,1.5,1.8,2.0,2.3,2.1,2.2,2.1,2.5,2.7,2.6,2.6],

	[0.8,1.3,1.4,1.6,1.2,1.6,1.9,2.4,2.0,2.0,1.9,2.4,2.7,2.7,2.7],

	[0.1,0.3,0.3,0.3,0.3,0.4,0.5,0.6,0.4,0.4,0.3,0.4,0.4,0.4,0.39]

];



var aTooltip3 = ['Costumes','Candy','Decorations','Greeting Cards'];

//////////////////////////////////////



// g4 ////////////////////////////////

let bgColor = 'none';

// gender

var aData4_a = [

	['67%','$96.13'],

	['69%','$76.92']

];

var aSeries4_a = [

	[[2,0,32], [2,1,33]],

	[[5,0,33], [5,1,31]]

];



// age

var aData4_b = [

	['88%','$88.23'],

	['84%','$109.11'],

	['78%','$115.53'],

	['66%','$91.30'],

	['54%','$74.19'],

	['45%','$47.01']

];

var aSeries4_b = [

	[[1,0,30], [1,1,31]],

	[[2,0,32], [2,1,32]],

	[[3,0,32], [3,1,34]],

	[[4,0,30], [4,1,30]],

	[[5,0,26], [5,1,26]],

	[[6,0,26], [6,1,26]]

];



// region

var aData4_c = [

	['70%','$92.78'],

	['69%','77.57$'],

	['67%','$89.84'],

	['67%','$83.16']

];

var aSeries4_c = [

	[[1,0,30], [1,1,31]],

	[[2,0,32], [2,1,32]],

	[[3,0,32], [3,1,34]],

	[[4,0,30], [4,1,30]]

];

//////////////////////////////////////



// g5 ////////////////////////////////

var aTooltip5 = ['Costumes (including children<br>and pets)','Candy','Decorations','Greeting cards'];



var aSeries5_a = [

	[68,96,73,35],

	[66,93,71,33]

];



var aSeries5_b = [

	[87,92,77,32],

	[88,93,80,40],

	[87,95,79,40],

	[68,96,73,31],

	[51,96,70,31],

	[32,94,57,31]

];



var aSeries5_c = [

	[68,95,75,40],

	[62,95,67,32],

	[69,95,73,34],

	[67,93,71,31]

];

//////////////////////////////////////



// g6 ////////////////////////////////

var aTooltip6 = ['Dress<br>in costume','Dress your<br>pet(s) in costume','Throw/attend<br>a party','Hand out<br>candy','Carve a<br>pumpkin','Visit a<br>haunted house','Take children<br>trick-or-treating','Decorate your<br>home/yard','Other<br>(please specify)'];



var aSeries6_a = [

	[47,15,36,68,41,22,27,41,3],

	[47,19,28,69,48,22,30,56,3]

];



var aSeries6_b = [

	[73,26,53,56,53,40,26,45,2],

	[68,27,42,60,54,34,41,50,2],

	[56,22,34,65,50,29,47,47,2],

	[44,16,29,72,46,20,29,52,3],

	[34,12,24,77,40,14,20,53,3],

	[19,4,16,78,29,5,12,45,6]

];



var aSeries6_c = [

	[48,18,33,69,41,22,26,50,3],

	[45,15,31,69,47,22,30,50,4],

	[46,18,30,69,43,24,30,47,2],

	[50,17,33,67,47,21,28,48,4]

];

//////////////////////////////////////



// g7 ////////////////////////////////

var aTooltip7 = ['Before September','September','First 2 weeks of October','Last 2 weeks of October'];



var aSeries7_a = [

	[6,28,42,24],

	[6,34,42,18]

];



var aSeries7_b = [

	[4,28,50,18],

	[7,40,40,13],

	[9,37,40,13],

	[6,30,44,19],

	[6,29,43,22],

	[4,21,39,37]

];



var aSeries7_c = [

	[7,32,41,20],

	[6,34,40,21],

	[6,31,43,20],

	[6,28,43,23]

];

//////////////////////////////////////



// g9 ////////////////////////////////

var aTooltip9_a = ['Print Media','Online search','Retail store or costume shop','Friends/family','Pop culture','Current Events','Facebook','Instagram','Pinterest','Twitter','YouTube','Blogs','Habit','Other','N/A'];

var aTooltip9 = ['Print Media (magazines, catalogs, etc.)','Online Search','Within a retail store or costume shop','Friends/Family','Pop Culture (celebrities, TV shows, movies, etc.)','Current Events','Facebook','Instagram','Pinterest','Twitter','YouTube','Blogs','Habit/Wear the same costume each year','Other','Does not apply/Will not wear costume'];



var aSeries9_a = [

	[11,35,28,20,16,7,16,14,18,6,14,3,6,3,27]

];



var aSeries9_b = [

	[12,35,27,21,18,8,19,15,12,9,19,4,6,3,26],

	[11,35,30,18,14,6,14,14,25,3,10,3,6,3,28]

];



var aSeries9_c = [

	[13,56,40,32,32,8,23,35,33,13,30,6,7,2,6],

	[14,48,35,26,25,10,25,25,28,10,21,7,6,2,9],

	[15,45,35,22,22,10,25,19,23,8,17,3,6,4,12],

	[12,33,29,18,13,8,15,9,18,3,12,2,4,3,27],

	[10,25,25,14,7,4,10,4,10,2,8,1,7,4,39],

	[7,12,13,10,3,3,5,1,5,0,2,1,8,4,58]

];

var aSeries9_d = [

	[13,35,30,20,15,8,15,14,17,7,14,4,5,3,27],

	[10,32,27,19,14,6,17,11,19,5,10,3,7,3,29],

	[12,36,29,20,17,7,19,16,19,6,16,4,6,3,26],

	[11,35,27,18,17,7,13,15,18,5,14,3,7,4,26]

];

let data = [

['All India', 9, 20, 21.5, 38.3, 14.1, 'ALL'],

['Andaman and Nicobar', 9, 20, 21.5, 38.3, 14.1, 'AN'],

['Andhra Pradesh', 10, 10, 21.7, 28.1, 15.1, 'AP'],

['Arunachal Pradesh', 11, 12, 21.9, 21.5, 16.1, 'AR'],

['Assam', 12, 9, 22.1, 34.1, 17.1, 'AS'],

['Bihar', 13, 20, 22.3, 38.3, 18.1, 'BR'],

['Chandigarh', 14, 10, 22.5, 28.1, 19.1, 'CH'],

['Dadra and Nagar Haveli', 15, 12, 22.7, 21.5, 20.1, 'DN'],

['Daman and Diu', 16, 9, 22.9, 34.1, 21.1, 'DD'],

['Delhi', 17, 20, 23.1, 38.3, 22.1, 'DL'],

['Goa', 18, 10, 23.3, 28.1, 23.1, 'GA'],

['Gujarat', 19, 12, 23.5, 21.5, 24.1, 'GJ'],

['Haryana', 20, 9, 23.7, 34.1, 25.1, 'HR'],

['Himachal Pradesh', 21, 20, 23.9, 38.3, 26.1, 'HP'],

['Jammu and Kashmir', 22, 10, 24.1, 28.1, 27.1, 'JK'],

['Karnataka', 23, 12, 24.3, 21.5, 28.1, 'KA'],

['Kerala', 24, 9, 24.5, 34.1, 29.1, 'KL'],

['Madhya Pradesh', 25, 20, 24.7, 38.3, 30.1, 'MP'],

['Maharashtra', 26, 10, 24.9, 28.1, 31.1, 'MH'],

['Manipur', 27, 12, 25.1, 21.5, 32.1, 'MN'],

['Meghalaya', 28, 9, 25.3, 34.1, 33.1, 'ML'],

['Mizoram', 29, 20, 25.5, 38.3, 34.1, 'MZ'],

['Nagaland', 30, 10, 25.7, 28.1, 35.1, 'NL'],

['Orissa', 31, 12, 25.9, 21.5, 36.1, 'OR'],

['Puducherry', 32, 9, 26.1, 34.1, 37.1, 'PY'],

['Punjab', 33, 20, 26.3, 38.3, 38.1, 'PB'],

['Rajasthan', 34, 10, 26.5, 28.1, 39.1, 'RJ'],

['Sikkim', 35, 12, 26.7, 21.5, 40.1, 'SK'],

['Tamil Nadu', 36, 9, 26.9, 34.1, 41.1, 'TN'],

['Tripura', 37, 20, 27.1, 38.3, 42.1, 'TR'],

['Uttar Pradesh', 38, 10, 27.3, 28.1, 43.1, 'UP'],

['West Bengal', 39, 12, 27.5, 21.5, 44.1, 'WB'],

['Uttaranchal', 40, 20, 27.7, 38.3, 45.1, 'UT'],

['Jharkhand', 41, 10, 27.9, 28.1, 46.1, 'JH'],

['Chhattisgarh', 42, 12, 28.1, 21.5, 47.1, 'CT'],

['Telangana', 43, 9, 28.3, 34.1, 48.1, 'TL']

];



// better placement to avoid pie overlap

let oOffsets = {

  RP: [15, -15]

};



let _r_ = function (min, max) {

  return Math.round(min + (max - min) * Math.random());

};



let getNameById = function (sId) {

  let sName = 'N/A';

  for (let i = 0; i < data.length; i++) {

    if (sId === data[i][6]) {

      sName = data[i][0];

    }

  }

  return sName;

};



let oCacheDataArea = {};

let getRandomDataArea = function (sId) {

  if (oCacheDataArea[sId]) {

    return oCacheDataArea[sId];

  }

  let aValues = [

    [],

    [],

    [],

    []

  ];

  for (let i = 0; i < data.length; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);
	

    let v2 = 100 - v0 - v1 - v3;

    aValues[0].push(v0);

    aValues[1].push(v1);

    aValues[2].push(v2);

    aValues[3].push(v3);

  }

  oCacheDataArea[sId] = aValues;

  return aValues;

};


let xCacheDataArea = {};

let xgetRandomDataArea = function (sId) {

  if (xCacheDataArea[sId]) {

    return xCacheDataArea[sId];

  }

  let xValues = [

    [],

    [],

    [],

    []

  ];

  for (let i = 0; i < data.length; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);
	

    let v2 = 100 - v0 - v1 - v3;

    xValues[0].push(v0);

    xValues[1].push(v1);

    xValues[2].push(v2);

    xValues[3].push(v3);

  }

  xCacheDataArea[sId] = xValues;

  return xValues;

};



let bCacheDataArea = {};

let bgetRandomDataArea = function (sId) {

  if (bCacheDataArea[sId]) {

    return bCacheDataArea[sId];

  }

  let bValues = [

    [],

    [],

    [],

    [],

	[]

  ];

  for (let i = 0; i <1; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);

	let v4 = _r_(7, 15);

    let v2 = 100 - v0 - v1 - v3 - v4;

    bValues[0].push(v0);

    bValues[1].push(v1);

    bValues[2].push(v2);

    bValues[3].push(v3);

	bValues[4].push(v4);

  }

  bCacheDataArea[sId] = bValues;

  return bValues;

};


let eCacheDataArea = {};

let egetRandomDataArea = function (sId) {

  if (eCacheDataArea[sId]) {

    return eCacheDataArea[sId];

  }

  let eValues = [

    [],

    [],

    [],

    []

  ];

  for (let i = 0; i<1; i++) {

    let v0 = _r_(5023, 1521);

    let v1 = _r_(2532, 3503);

    let v3 = _r_(1509, 1027);

    let v2 = 10000 - v0 - v1 - v3;

    eValues[0].push(v0);

    eValues[1].push(v1);

    eValues[2].push(v2);

    eValues[3].push(v3);

  }

  eCacheDataArea[0] = eValues;

  return eValues;

};


let cCacheDataArea = {};

let cgetRandomDataArea = function (sId) {

  if (cCacheDataArea[sId]) {

    return cCacheDataArea[sId];

  }

  let cValues = [

    [],

    [],

    [],

    [],

	[]

  ];

  for (let i = 0; i <1; i++) {

    let v0 = _r_(5, 15);

    let v1 = _r_(25, 35);

    let v3 = _r_(5, 10);

	let v4 = _r_(7, 15);

    let v2 = 100 - v0 - v1 - v3 - v4;

    cValues[0].push(v0);

    cValues[1].push(v1);

    cValues[2].push(v2);

    cValues[3].push(v3);

	cValues[4].push(v4);

  }

  cCacheDataArea[sId] = cValues;

  return cValues;

};



let oCacheDataPop = {};

let getRandomDataPop = function (sId) {

  if (oCacheDataPop[sId]) {

    return oCacheDataPop[sId];

  }

  let aValues = [];

  let iPop = ZC._r_(200, 800);
  
  for (let i = 0; i < data.length; i++) {

    aValues.push(iPop);

    iPop += _r_(-200, 200);

  }

  let bValues = [];

  let iPop1 = ZC._r_(200, 830);

  for (let i = 0; i < data.length; i++) {

    bValues.push(iPop1);

    iPop1 += _r_(-200, 200);

  }

  oCacheDataPop[sId] = [aValues,bValues];
  
  let gdpValues = [7.5,9.5,9.6,9.3,6.7,8.6,8.9,6.7,5.5,6.4,7.4];
  let ghgValues = [6.0,6.0,7.7,5.4,6.3,4.8,5.6,6.9,3.0,2.9,1.2];
  return [gdpValues,ghgValues];
 // return [aValues,bValues];
  

};



let oCacheDataPopg = {};

let getRandomDataPopg = function (sId) {

  if (oCacheDataPopg[sId]) {

    return oCacheDataPopg[sId];

  }

  let aValuesg = [];

  let iPopg = ZC._r_(200, 830);

  for (let i = 0; i < data.length; i++) {

    aValuesg.push(iPopg);

    iPopg += _r_(-200, 200);

  }

  oCacheDataPopg[sId] = [aValuesg];
  //let gdpValues = [7.5,9.5,9.6,9.3,6.7,8.6,8.9,6.7,5.5,6.4,7.4];
  let ghgValues = [6.0,6.0,7.7,5.4,6.3,4.8,5.6,6.9,3.0,2.9,1.2];
  return [ghgValues];
  //return [aValuesg];

};





let updateAreaPopCharts = function (sId) {

  zingchart.exec('myChart', 'setdata', {

    graphid: 'gmap',

    data: getMapData(sId),

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'histarea',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'histpop',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'modify', {

    graphid: 'bhistpop',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

 zingchart.exec('myChart', 'modify', {

    graphid: 'pielegend',

    data: {

      subtitle: {

        text: getNameById(sId)

      }

    },

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'histarea',

    values: getRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'histpop',

    values: getRandomDataPop(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'bhistpop',

    values: bgetRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'setseriesvalues', {

    graphid: 'pielegend',

    values: bgetRandomDataArea(sId),

    update: false

  });

  zingchart.exec('myChart', 'update');

}



zingchart.bind('myChart', 'node_click', function (p) {

	
  if (p.graphid.indexOf('zc-graph-pie') === 0) {
	
    updateAreaPopCharts(p.graphid.replace('zc-graph-pie', ''));

  }

});

zingchart.bind('myChart', 'shape_click', function (p) {

  if (p.shape.mapItem) {

    updateAreaPopCharts(p.shape.id);
	//alert(p.shape.id);
	window.location.href = "dashboard_state.php?st="+p.shape.id;
  }
  

});



let addPieGraphs = function () {

  for (let i = 0; i < data.length; i++) {

    let info = data[i];

    let xy = zingchart.maps.getXY('mapind', [info[1], info[2]]);

    let oGraph = {

      id: 'pie' + info[6],

      type: 'pie',

      x: xy[0] - 80 + (oOffsets[info[6]] ? oOffsets[info[6]][0] : 0),

      y: xy[1] - 25 + (oOffsets[info[6]] ? oOffsets[info[6]][1] : 0),

      width: '160px',

      height: '50px',

      backgroundColor: 'none',

      plotarea: {

        margin: '2px'

      },

      plot: {

        detach: false,

        alpha: 0.75,

        borderWidth: '0px',

        valueBox: {

          visible: false

        }

      },

      title: {

        fontSize: '10px',

        offsetY: '40px',

        fontWeight: 'bold',

        text: info[0]

      },

      tooltip: {

        padding: '10px',

        fontSize: '13px',

        fontWeight: 'bold',

        text: '%node-value% in %plot-text'

      },

      series: [{

        text: 'Settlement Area',

        values: [info[5]],

        backgroundColor: '#d15c5c'

      },

      {

        text: 'Forest Area',

        values: [info[4]],

        backgroundColor: '#56b556'

      },

      {

        text: 'Agriculture',

        values: [info[3]],

        backgroundColor: '#e5e510'

      },

      {

        text: 'Other',

        values: [Number((100 - info[3] - info[4] - info[5]).toFixed(1))],

        backgroundColor: '#999'

      }

      ]

    };

    zingchart.exec('myChart', 'addgraph', {

      data: oGraph,

      update: false

    });

  }

  zingchart.exec('myChart', 'update');

}



var getMapData = function (sId) {

  let oGraphMainMap = {

    backgroundColor: 'none',

    x: '0px',

    y: '0px',

    width: '800px',

    height: '600px',

    type: 'null',

    id: 'gmap',

    title: {

      align: 'left',

      fontSize: '15px',

      paddingLeft: '20px',

      text: ''

    },

    source: {

      text: '(*) dummy data',

      offsetX: '-50px'

    },

    shapes: [{

      type: 'zingchart.maps',

      options: {

        x: '0px',

        y: '20px',

        width: '480px',

        height: '580px',

        id: 'mapdeu',

        name: 'ind',

        zooming: false,

        panning: false,

        scrolling: false,

        scale: true,

        style: {

          controls: {

            visible: false

          },

          label: {

            visible: false

          },

          

          hoverState: {

            visible: false

          },

          items: {

AN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andaman and Nicobar</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AN">View More</a>'},backgroundColor: '#fcfof1',label: {visible: true}},

AP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Andhra Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AP">View More</a>'},backgroundColor: '#facfd2',label: {visible: true}},

AR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Arunachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AR">View More</a>'},backgroundColor: '#ffabaf',label: {visible: true}},

AS: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Assam</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?AS">View More</a>'},backgroundColor: '#ff8085',label: {visible: true}},

BR: { tooltip : {lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Bihar</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?BR">View More</a>'},backgroundColor: '#f86368',label: {visible: true}},

CH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chandigarh</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?CH">View More</a>'},backgroundColor: '#e65054',label: {visible: true}},

DN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Dadra and Nagar Haveli</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?DN">View More</a>'},backgroundColor: '#d63638',label: {visible: true}},

DD: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Daman and Diu</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?DD">View More</a>'},backgroundColor: '#b32d2e',label: {visible: true}},

DL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Delhi</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?DL">View More</a>'},backgroundColor: '#8a2424',label: {visible: true}},

GA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Goa</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?GA">View More</a>'},backgroundColor: '#691c1c',label: {visible: true}},

GJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Gujarat</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:#fff; text-align: center; cursor: pointer; ffont-weight:bold;" href="view-profile.php?GJ">View More</a>'},backgroundColor: '#451313',label: {visible: true}},

HR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Haryana</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?HR">View More</a>'},backgroundColor: '#240a0a',label: {visible: true}},

HP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Himachal Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?HP">View More</a>'},backgroundColor: '#fcfof1',label: {visible: true}},

JK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jammu and Kashmir</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?JK">View More</a>'},backgroundColor: '#facfd2',label: {visible: true}},

KA: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Karnataka</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?KA">View More</a>'},backgroundColor: '#ffabaf',label: {visible: true}},

KL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Kerala</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?KL">View More</a>'},backgroundColor: '#ff8085',label: {visible: true}},

MP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Madhya Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MP">View More</a>'},backgroundColor: '#f86368',label: {visible: true}},

MH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Maharashtra</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MH">View More</a>'},backgroundColor: '#e65054',label: {visible: true}},

MN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Manipur</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MN">View More</a>'},backgroundColor: '#d63638',label: {visible: true}},

ML: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Meghalaya</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?ML">View More</a>'},backgroundColor: '#b32d2e',label: {visible: true}},

MZ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Mizoram</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?MZ">View More</a>'},backgroundColor: '#8a2424',label: {visible: true}},

NL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Nagaland</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?NL">View More</a>'},backgroundColor: '#691c1c',label: {visible: true}},

OR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Orissa</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?OR">View More</a>'},backgroundColor: '#451313',label: {visible: true}},

PY: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Puducherry</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?PY">View More</a>'},backgroundColor: '#240a0a',label: {visible: true}},

PB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Punjab</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?PB">View More</a>'},backgroundColor: '#fcfof1',label: {visible: true}},

RJ: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Rajasthan</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?RJ">View More</a>'},backgroundColor: '#facfd2',label: {visible: true}},

SK: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Sikkim</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?SK">View More</a>'},backgroundColor: '#ffabaf',label: {visible: true}},

TN: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tamil Nadu</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?TN">View More</a>'},backgroundColor: '#ff8085',label: {visible: true}},

TR: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Tripura</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?TR">View More</a>'},backgroundColor: '#f86368',label: {visible: true}},

UP: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttar Pradesh</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?UP">View More</a>'},backgroundColor: '#e65054',label: {visible: true}},

WB: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">West Bengal</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?WB">View More</a>'},backgroundColor: '#d63638',label: {visible: true}},

UT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Uttaranchal</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?UT">View More</a>'},backgroundColor: '#b32d2e',label: {visible: true}},

JH: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '14 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Jharkhand</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?JH">View More</a>'},backgroundColor: '#8a2424',label: {visible: true}},

CT: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '12 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Chhattisgarh</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?CT">View More</a>'},backgroundColor: '#691c1c',label: {visible: true}},

TL: { tooltip : { lineHeight : 22, callout : true, align : 'left', calloutWidth : 18, calloutHeight : 8, borderRadius : 3, color : '#000', backgroundColor : '#f9f9f9', padding : '10 20', borderWidth : 0,shadow : true, shadowColor : '#333', shadowAlpha : 0.7, fontSize : 13, shadowDistance : 2,text : '<span style="font-size:19px;font-weight:bold;">Telangana</span><br><span style="font-size:12px;font-weight:bold;">Total Population: </span>0.4 Million <br><span style="font-size:12px;font-weight:bold;">Net State Domestic Product: </span>&#8377; 0.10 Million<br><span style="font-size:12px;font-weight:bold;">Literacy Rate: </span>30% <br><span style="font-size:12px;font-weight:bold;">Adaptation Funding: </span>&#8377; 0.2 Million<br><span style="font-size:12px;font-weight:bold;">Number of CSOs: </span>120<br><a style="font-size:15px; padding: 5px 5px; background-color:#b83b30; color:blue; text-align: center; cursor: pointer; font-weight:bold; border:1px thin solid #ccc" href="view-profile.php?TL">View More</a>'},backgroundColor: '#451313',label: {visible: true}},



}

        }

      }

    },{

      type: 'circle',

      id: '1950',

      backgroundColor: '#d63638',

      borderColor: '#fff',

      borderWidth: '1px',

      cursor: 'pointer',

      label: {

        text: 'Vulnerability',

        fontColor: '#d63638',

        fontFamily: 'arial',

        offsetX: '50px',

		fontWeight : 'bold',

      },

      size: '10px',

      x: '280px',

      y: '500px'

    },

    {

      type: 'circle',

      id: '1990',

      backgroundColor: '#2271b1',

      borderColor: '#fff',

      borderWidth: '1px',

      cursor: 'pointer',

      label: {

        text: 'GHG Emission (Per Capita)',

        fontColor: '#2271b1',

        fontFamily: 'arial',

		margin:'50',

        offsetX: '88px',

		fontWeight : 'bold',

      },

      size: '10px',

      x: '280px',

      y: '530px'

    }],
	"legend": {
	 'background-color': "#ffffff",
    'border-width':0,
    'border-color': "red",
    'border-radius': "0px",
	fontSize: "4px",
	width:"150%",
    padding: "0%",
 	 layout: "2x2", //row x column
	  x: "0%",
	  y: "95%",
  },
	choropleth: {
        legend: {
          header: {
            text: 'Population Range'
          },
          item: {
            cursor: 'pointer',
          },
          marker: {
            cursor: 'pointer'
          },
          align: 'left',
          verticalAlign: 'bottom',
          items: [{
            text: ' > 100,000'
          }]
        }
      }
  };

  oGraphMainMap.shapes[0].options.style.items[sId] = {

    backgroundColor: '#eeeeee #c2edc3'

  };

  return oGraphMainMap;

};



let aAreaValues = getRandomDataArea(data[0][6]);
let aAreaValues1= egetRandomDataArea(data[0][6]);
let abs='%node-value'*5;
let oGraphHistoryArea = {

  id: 'histarea',

  backgroundColor: 'none',

  x: '480px',

  y: '0px',

  width: '360px',

  height: '250px',

  type: 'bar',

  stacked: true,
  
  "legend": {
	 'background-color': "#ffffff",
    'border-width':0,
    'border-color': "red",
    'border-radius': "0px",
	fontSize: "4px",
	width:"150%",
    padding: "0%",
 	 layout: "2x2", //row x column
	  x: "0%",
	  y: "95%",
  },

  title: {

    fontSize: '14px',

    text: 'Sectoral Contribution to GHG Emission [2005-2015]'

  },

  subtitle: {

    fontSize: '12px',

    offsetY: '-5px',

    text: getNameById(data[0][6])

  },

  source: {

    text: ''

  },

  plotarea: {

    margin: '55 5 35 35'

  },

  scaleX: {

    values: '2005:2015:1',

    maxItems: 99,

    itemsOverlap: true,

    item: {

      fontSize: '9px'

    }

  },
  tooltip: {
    
    text: '%plot-text in %scale-key-text: %node-value% (' + _r_(500, 1500) * 5 + ') MT'

  },

  scaleY: {

    format: '%v%',

    item: {

      fontSize: '10px'

    }

  },

  plot: {

    animation: {

      speed: 200,

      effect: 'ANIMATION_FADE_IN',

      method: 'ANIMATION_LINEAR',

      sequence: 'ANIMATION_BY_NODE'

    }

  },

  series: [{

    backgroundColor: '#f86368',
    values: aAreaValues[0],
    mas: 8721,
    text: 'Agriculture, Forestry and Other Land Use'

  },

  {

    backgroundColor: '#00ba37',

    values: aAreaValues[1],
    mas: 2187,
    text: 'Energy'

  },

  {

    backgroundColor: '#dba617',

    values: aAreaValues[2],
    mas: 7026,
    text: 'Industrial Product and Process Use'

  },

  {

    backgroundColor: '#4f94d4',

    values: aAreaValues[3],
    mas: 3210,
    text: 'Waste'

  }

  ]

};



let aPopValues = getRandomDataPop(data[0][6]);

let bPopValues = getRandomDataPopg(data[0][6]); 

let oGraphHistoryPop = {

  id: 'histpop',

  backgroundColor: 'none',

  x: '480px',

  y: '290px',

  width: '360px',

  height: '260px',

  type: 'line',
  "legend": {
	 'background-color': "#ffffff",
    'border-width':0,
    'border-color': "red",
    'border-radius': "0px",
	width:"92%",
    padding: "0%",
 	 layout: "2x3", //row x column
	  x: "0%",
	  y: "95%",
  },

  title: {

    fontSize: '14px',

    text: '% Growth of GDP vs GHG Emissions'

  },

  subtitle: {

    fontSize: '12px',

    offsetY: '-5px',

    text: getNameById(data[0][6])

  },

  source: {

    text: ''

  },

  plotarea: {

    margin: '55 5 35 35'

  },

  scaleX: {

    values: '2005:2015:1',

    maxItems: 99,

    itemsOverlap: true,

    item: {

      fontSize: '9px'

    }

  },

  scaleY: {

    minValue: 'auto',

    short: true,

    decimals: 2,

    item: {

      fontSize: '10px'

    }

  },

  plot: {

    alpha: 0.75,

    animation: {

      speed: 200,

      effect: 'ANIMATION_FADE_IN',

      method: 'ANIMATION_LINEAR',

      sequence: 'ANIMATION_BY_NODE'

    }

  },

  series: [{

    lineColor: '#e65054',

    backgroundColor: '#e65054',

    marker: {

      type: 'square',

      backgroundColor: '#e65054'

    },
	text: "GDP",
	tooltip: {

    short: true,

    decimals: 2,

    text: 'GDP in %scale-key-text: %node-value %'

  },

    values: aPopValues[0]

  },{

    lineColor: '#333',

    backgroundColor: '#333',

    marker: {

      type: 'square',

      backgroundColor: '#333'

    },
	text: "GHG",
	tooltip: {

    short: true,

    decimals: 2,

    text: 'GHG in %scale-key-text: %node-value %'

  },

    values: bPopValues[0]

  }]

};

let bAreaValues = bgetRandomDataArea(data[0][6]);

let g9 = {

  type: 'ring',

  id: 'bhistpop',

  backgroundColor: bgColor,

  x: '850px',

  y: '250px',

  width: '350px',

  height: '350px',



  title: {

    fontSize: '14px',

    text: 'Global Emissions by Economic Sector'

  },

  subtitle: {

    fontSize: '12px',

    offsetY: '-5px',

    text: getNameById(data[0][6])

  },

  scale: {

    sizeFactor: 0.75

  },

  'scaleR': {

    refAngle: 270

  },



  plot: {

    'borderWidth': 0

  },



  tooltip: {

    text: '%node-value%'

  },

  series: [{

      values: [37],

      'backgroundColor': '#f86368',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          fontColor: '#000',

          fontWeight: 'normal',

          fontSize: 11,

          placement: 'out',

          offsetR: -15

        },

        {

          text: 'Climate Policy',

          fontColor: '#000',

          'fontSize': 10,

          placement: 'fixed=50%;'

        }

      ]

    },

    {

      values: [28],

      'backgroundColor': '#00ba37',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          'fontColor': '#000',

          'fontWeight': 'normal',

          fontSize: 11,

          placement: 'out',

          offsetR: -10

        },

        {

          text: 'Clean Power',

          fontColor: '#000',

          fontSize: 10,

          placement: 'fixed=50%;'

        }

      ]

    },

    {

      values: [18],

      'backgroundColor': '#dba617',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          'fontColor': '#000',

          fontWeight: 'normal',

          'fontSize': 11,

          placement: 'out',

          'offsetR': -19

        },

        {

          text: 'Energy Efficiency',

          'fontColor': '#000',

          'fontSize': 10,

          placement: 'fixed=50%;'

        }

      ]

    },

    {

      values: [17],

      'backgroundColor': '#4f94d4',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          fontColor: '#000',

          fontWeight: 'normal',

          'fontSize': 11,

          placement: 'out',

          offsetR: -10

        },

        {

          text: 'Electric Mobility',

          fontColor: '#000',

          'fontSize': 10,

          placement: 'fixed=50%;'

        }

      ]

    },

    {

      values: [12],

      'backgroundColor': '#8c8f94',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          fontColor: '#000',

          fontWeight: 'normal',

          'fontSize': 11,

          placement: 'out',

          offsetR: -10

        },

        {

          text: 'Transport',

          fontColor: '#000',

          'fontSize': 10,

          placement: 'fixed=50%;'

        }

      ]

    }

  ]

};



let fundingcharts = {

  type: 'nestedpie',

  x: '850px',

  y: '0px',

  width: '300px',

  height: '280px',

  title: {

    fontSize: '14px',

    text: 'Funding Snapshot (In Last 10 Years)'

  },

  legend: {

    borderColor: 'gray',

    borderRadius: '5px',

    borderWidth: '1px',

    dragHandler: 'icon',

    header: {

      text: 'Sectors',

      fontColor: 'purple',

      fontFamily: 'Georgia',

      fontSize: '12px',

      fontWeight: 'normal'

    },

    icon: {

      lineColor: 'orange'

    },

    item: {

      fontColor: 'black',

      fontFamily: 'Georgia'

    },

    lineStyle: 'dashdot',

    marker: {

      type: 'circle'

    },

    minimize: true,

    toggleAction: 'remove'

  },

  plot: {

    tooltip: {

      text: '%data-year Ages %t: %v',

      padding: '10%',

      alpha: 0.7,

      backgroundColor: 'white',

      borderColor: 'gray',

      borderRadius: '3px',

      borderWidth: '1px',

      fontColor: 'black',

      fontFamily: 'Georgia',

      fontSize: '12px',

      lineStyle: 'dashdot',

      textAlpha: 1

    },

    valueBox: {

      text: '%data-year',

      fontColor: 'white',

      fontFamily: 'Georgia',

      fontSize: '12px',

      fontWeight: 'normal',

      rules: [

        {

          rule: '%p != 0',

          visible: false

        }

      ]

    },

    alpha: 0.8,

    animation: {

      effect: 'ANIMATION_EXPAND_LEFT',

      onLegendToggle: false,

      method: 'ANIMATION_BACK_EASE_OUT',

      sequence: 'ANIMATION_BY_PLOT',

      speed: 700

    },

    borderColor: 'white',

    borderWidth: '1px',

    dataYear: ['2005', '2010', '2015'],

    shadow: false,

    sliceStart: '30%'

  },

  series: [

    {

      text: 'Climate Policy',

      values: [59, 55, 30],

      backgroundColor: 'orange red',

      tooltipText: 'Ages %t: %v'

    },

    {

      text: 'Energy Efficiency',

      values: [60, 50, 35],

      backgroundColor: 'yellow orange'

    },

    {

      text: 'Clean Power',

      values: [50, 40, 30],

      backgroundColor: 'green blue'

    },

    {

      text: 'Clean Energy Finance',

      values: [61, 59, 35],

      backgroundColor: 'blue purple'

    },

    {

      text: 'Transport',

      values: [65, 55, 45],

      backgroundColor: 'purple red'

    }

  ]

};



let oRingLegend = {

  id: 'ringlegend',

  type: 'ring',

  x: '850px',

  y: '250px',

  width: '300px',

  height: '260px',

  backgroundColor: 'none',

  plotarea: {

    margin: '5px'

  },

  title: {

    fontSize: '14px',

    text: 'Sectors'

  },

  subtitle: {

    fontSize: '12px',

    offsetY: '-5px',

    text: getNameById(data[0][6])

  },

  scale: {

    sizeFactor: 0.75

  },

  'scaleR': {

    refAngle: 270

  },

  tooltip: {

    text: '%plot-value%'

  },

  plot: {

    flat: true,

    maxTrackers: 0,

    detach: false,

    alpha: 0.6,

    borderWidth: '0px',

    valueBox: {

      placement: 'out',

      offsetR: -25,

      align: 'left',

      text: '%plot-text',

      fontSize: '10px',

      fontWeight: 'bold',

      color: '#333',

      connector: {

        visible: false

      }

    }

  },

  tooltip: {

    visible: false

  },

  scale: {

    sizeFactor: 0.8

  },

  series: [{

    text: 'Climage Policy',

    values: [1],

	placement: 'out',

    backgroundColor: '#d15c5c'

  },

  {

    text: 'Clean Power',

    values: [1],

	placement: 'out',

    backgroundColor: '#00ba37'

  },

  {

    text: 'Energy Efficiency',

    values: [1],

	placement: 'out',

    backgroundColor: '#dba617'

  },

  {

    text: 'Electric Mobility',

    values: [1],

	placement: 'out',

    backgroundColor: '#4f94d4'

  }

  ,

  {

    text: 'Transport',

    values: [1],

	placement: 'out',

    backgroundColor: '#8c8f94'

  }

  ]

};

let cAreaValues = cgetRandomDataArea(data[0][6]);

let oGraphLegend = {

  id: 'pielegend',

  type: 'hbar',

  x: '850px',

  y: '0px',

  width: '300px',

  height: '280px',

  backgroundColor: 'none',

  plotarea: {

    margin: '50px'

  },

  title: {

    fontSize: '14px',

    text: 'GHG Emissions by Gas',

	offsetX: '-0px'

  },

  subtitle: {

    fontSize: '12px',

    offsetY: '-5px',

	offsetX: '-0px',

    text: getNameById(data[0][6])

  },

  plot: {

    'barWidth': '70%',

    valueBox: {

      text: '%node-value%',

      fontSize: 10,

      fontWeight: 'normal',

      color: '#000',

	  values: ['Carbon dioxide (CO2)  ','Methane (CH4) ','Nitrous oxide (N2O) ','Fluorinated gases (F-gases) ','Others gases'],

    }

  },

  tooltip: {

    text: '%node-value%'

  },

  scaleX: {

    //values: ['Climage Policy','Clean Power','Energy Efficiency','Electric Mobility','Transport'],

    lineWidth: 0,

    itemsOverlap: true,

    item: {

      'fontColor': '#000',

      'textAlign': 'center',

      'fontWeight': 'normal',

      'fontSize': 10,

    },

    tick: {

      visible: false

    },

    guide: {

      visible: false

    }



  },

  scaleY: {

    minValue: 0,

    maxValue: 25,

    'lineWidth': 0,

    item: {

      visible: false

    },

    guide: {

      visible: false

    },

    tick: {

      visible: false

    }

  },

  series: [{

      values: [37],

      'backgroundColor': '#FFDA00',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          fontColor: '#000',

          fontWeight: 'normal',

          fontSize: 11,

          placement: 'out',

          offsetR: -15

        },

        {

          text: 'Carbon dioxide (CO2)',

          fontColor: '#004280',

          'fontSize': 10,

		  x: '650px',

          y: '75px'

        }

      ]

    },

    {

      values: [28],

      'backgroundColor': '#FFA300',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          'fontColor': '#000',

          'fontWeight': 'normal',

          fontSize: 11,

          placement: 'out',

          offsetR: -10

        },

        {

          text: 'Methane (CH4)',

          fontColor: '#004280',

          fontSize: 10,

		  x: '650px',

          y: '105px'

        }

      ]

    },

    {

      values: [18],

      'backgroundColor': '#00BCF2',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          'fontColor': '#000',

          fontWeight: 'normal',

          'fontSize': 11,

          placement: 'out',

          offsetR: -15

        },

        {

          text: 'Nitrous oxide (N2O)',

          'fontColor': '#004280',

          'fontSize': 10,

		  x: '650px',

          y: '135px'

        }

      ]

    },

    {

      values: [17],

      'backgroundColor': '#7DAB4B',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          fontColor: '#000',

          fontWeight: 'normal',

          'fontSize': 11,

          placement: 'out',

          offsetR: -10

        },

        {

          text: 'Fluorinated gases (F-gases)',

          fontColor: '#004280',

          'fontSize': 10,

		  x: '650px',

          y: '165px',

        }

      ]

    },

    {

      values: [12],

      'backgroundColor': '#7DAB4B',

      'valueBox': [{

          text: '%node-value%',

          decimals: 0,

          fontColor: '#000',

          fontWeight: 'normal',

          'fontSize': 11,

          placement: 'out',

          offsetR: -10

        },

        {

          text: 'Other Gases',

          fontColor: '#004280',

          'fontSize': 10,

		  x: '600px',

          y: '195px',

        }

      ]

    }

  ]

  /*series: [{

    values: [1, 2, 3, 4, 5],

    backgroundColor: ['#d15c5c','#00ba37','#dba617','#4f94d4','#8c8f94']

  }]*/

};



// New



// New1

var g3 = {

	x : 900,

	y : 0,

	width : '400',

	height : '450',

	type : 'line',

	plotarea : {

		margin : '130 50 40 40'

	},

	backgroundColor : 'none',

	title : {

		offsetY : 5,

		text : 'Historical: Purchasing plans',

		width : '100%',

		align : 'center',

		fontColor : '#FBAE44',

		fontWeight : 'bold',

		fontSize : '14px',

		padding : 5

	},



	subtitle : {

		flat : true,

		text : 'Historical Halloween spending and celebration plans (2007 - 2021)',

		align : 'left',

		fontColor : '#464646',

		fontWeight : 'normal',

		fontStyle : 'italic',

		fontSize: '12px',

        offsetY: '-5px',

	},



	labels : [

		{

			x : 500,

			y : 45,

			width : '100%',

			borderBottom : '1px solid #EDEDED'

		}

	],



	plot : {

		aspect : 'spline',

		marker : {

			type : 'circle',

			borderWidth : 0,

			size : 4

		},

		hoverMarker : {

			type : 'circle',

			size : 5,

			backgroundColor : '#FFF',

			borderWidth : 1

		},

		valueBox : {

			text : '%node-value%',

			fontColor : '#464646',

			fontWeight : 'normal',

			fontSize : 10

		},

		animation : {

			effect : 1,

			sequence : 2,

			speed : 100

		}

	},



	tooltip : {

		backgroundColor : '#000',

		align : 'center',

		alpha : 0.75,

		borderWidth : 0,

		fontColor : '#fff',

		fontSize : 11,

		fontWeight : 'normal',

		borderRadius : 4,

		callout : true,

		padding : '5 10 10 5'

	},



	legend : {

		layout : '1x',

		backgroundColor : 'none',

		margin : '460 auto 0 auto',

		borderWidth : 0,

		marker : {

			type : 'circle',

			size : 8,

			borderWidth : 0,

		},

		item : {

			fontSize : 10,

			fontWeight : 'normal',

			color : '#464646'

		}

	},



	scaleX : {

		values : aYears,

		itemsOverlap : true,

		lineWidth : 0,

		item : {

			fontColor : '#464646',

			fontSize : 11,

			offsetY : -40

		},

		guide : {

			visible : false

		},

		tick : {

			visible : false

		}

	},



	scaleY : {

		minValue : 'auto',

		offsetStart : 45,

		offsetEnd : 5,

		lineWidth : 0,

		item : {

			visible : false

		},

		guide : {

			visible : false

		},

		tick : {

			visible : false

		}

	},



	series: [

		{

			values : aSeries3_a[0],

			lineColor : '#3CC1CF',

			lineWidth : 2,

			text : aTooltip3[0],

			tooltip : {

				text : '<span style="font-size:16px;color:#3CC1CF;">\u25CF</span><b>Costumes</b><br> %scale-key-value: %node-value%'

			},

			marker : {

				backgroundColor : '#3CC1CF'

			},

			hoverMarker : {

				borderColor : '#3CC1CF'

			}

		},

		{

			values : aSeries3_a[1],

			lineColor : '#FBAE44',

			lineWidth : 2,

			text : aTooltip3[1],

			tooltip : {

				text : '<span style="font-size:16px;color:#FBAE44;">\u25CF</span><b>Candy</b><br> %scale-key-value: %node-value%'

			},

			marker : {

				backgroundColor : '#FBAE44'

			},

			hoverMarker : {

				borderColor : '#FBAE44'

			}

		}

	]



};



let chartConfig = {

  flat: true,

  backgroundColor: '#fff',

  borderColor: '#fff',

  borderWidth: '0px',

  graphset: [

    getMapData(data[0][6]),

    oGraphHistoryArea,

    oGraphHistoryPop

	

  ]

};

///fundingcharts

let bInit = true;

zingchart.bind('myChart', 'load', function () {

  if (bInit) {

    bInit = false;

    addPieGraphs();

  }

});



//zingchart.DEV.MAPSONBOTTOM = 0;

// renders chart

zingchart.loadModules('maps, maps-ind', function (e) {

  zingchart.render({

    id: 'myChart',
    modules: 'choropleth',
    data: chartConfig,
	
    height: '100%',

    width: '100%'

  });

});





	</script>

<script src="js/plugins.js"></script>

<script src="js/main.js"></script>
<script>
$(document).ready(function(){
  $('[data-toggle="tooltip"]').tooltip();
});
</script>


</body>

</html>



