<style>
#chartdiv {
  width: 100%;
  height: 450px;
  padding-bottom:80px;
}
</style>

<!-- Resources -->
<script src="https://cdn.amcharts.com/lib/5/index.js"></script>
<script src="https://cdn.amcharts.com/lib/5/xy.js"></script>
<script src="https://cdn.amcharts.com/lib/5/radar.js"></script>
<script src="https://cdn.amcharts.com/lib/5/themes/Animated.js"></script>

<!-- Chart code -->
<script>
am5.ready(function() {

// Create root element
// https://www.amcharts.com/docs/v5/getting-started/#Root_element
var root = am5.Root.new("chartdiv");

// Set themes
// https://www.amcharts.com/docs/v5/concepts/themes/
root.setThemes([
  am5themes_Animated.new(root)
]);

var data2 = [];
data2[0] = [
  {
     category: "2016",
     value: 45,
  },
  {
    category: "2017",
    value: 12,
  },
  {
    category: "2018",
    value: 7,
  },
  {
    category: "2019",
    value: 19,
  },
  {
    category: "2020",
    value: 22,
  },
  {
    category: "2021",
    value: 78,
  }
]
data2[1] = [
  {
     category: "2016",
     value: 71,
  },
  {
    category: "2017",
    value: 91,
  },
  {
    category: "2018",
    value: 34,
  },
  {
    category: "2019",
    value: 89,
  },
  {
    category: "2020",
    value: 54,
  },
  {
    category: "2021",
    value: 30,
  }
],data2[2] = [
  {
     category: "2016",
     value: 56,
  },
  {
    category: "2017",
    value: 87,
  },
  {
    category: "2018",
    value: 23,
  },
  {
    category: "2019",
    value: 29,
  },
  {
    category: "2020",
    value: 67,
  },
  {
    category: "2021",
    value: 45,
  }
],data2[3] = [
  {
     category: "2016",
     value: 14,
  },
  {
    category: "2017",
    value: 57,
  },
  {
    category: "2018",
    value: 32,
  },
  {
    category: "2019",
    value: 19,
  },
  {
    category: "2020",
    value: 6,
  },
  {
    category: "2021",
    value: 78,
  }
],data2[4] = [
  {
     category: "2016",
     value: 65,
  },
  {
    category: "2017",
    value: 11,
  },
  {
    category: "2018",
    value: 76,
  },
  {
    category: "2019",
    value: 75,
  },
  {
    category: "2020",
    value: 47,
  },
  {
    category: "2021",
    value: 52,
  }
],data2[5] = [
  {
     category: "2016",
     value: 12,
  },
  {
    category: "2017",
    value: 56,
  },
  {
    category: "2018",
    value: 19,
  },
  {
    category: "2019",
    value: 76,
  },
  {
    category: "2020",
    value: 54,
  },
  {
    category: "2021",
    value: 93,
  }
],data2[6] = [
  {
     category: "2016",
     value: 59,
  },
  {
    category: "2017",
    value: 89,
  },
  {
    category: "2018",
    value: 57,
  },
  {
    category: "2019",
    value: 54,
  },
  {
    category: "2020",
    value: 36,
  },
  {
    category: "2021",
    value: 89,
  }
];
//console.log(data2);

// Create chart
// https://www.amcharts.com/docs/v5/charts/radar-chart/
var chart = root.container.children.push(am5radar.RadarChart.new(root, {
  panX: false,
  panY: false,
  wheelX: "panX",
  wheelY: "zoomX",
  innerRadius: am5.percent(40)
}));

// Add cursor
// https://www.amcharts.com/docs/v5/charts/radar-chart/#Cursor
var cursor = chart.set("cursor", am5radar.RadarCursor.new(root, {
  behavior: "zoomX"
}));

cursor.lineY.set("visible", false);

// Create axes and their renderers
// https://www.amcharts.com/docs/v5/charts/radar-chart/#Adding_axes
var xRenderer = am5radar.AxisRendererCircular.new(root, {
  strokeOpacity: 0.1,
  minGridDistance: 50
});

xRenderer.labels.template.setAll({
  radius: 10,
  maxPosition: 0.98
});

var xAxis = chart.xAxes.push(am5xy.ValueAxis.new(root, {
  renderer: xRenderer,
  extraMax: 0.1,
  tooltip: am5.Tooltip.new(root, {}),
  numberFormat: "#' MT'",
}));

var yAxis = chart.yAxes.push(am5xy.CategoryAxis.new(root, {
  categoryField: "category",
  renderer: am5radar.AxisRendererRadial.new(root, { minGridDistance: 20 })
}));

// Create series
// https://www.amcharts.com/docs/v5/charts/radar-chart/#Adding_series
var ss = ['Air Quality','Climate Finance','Climate Governance & Policy','Energy Eefficiency','Sustainable Land Use','Sustainable Transport','Others'];
for (var i = 0; i < data2.length; i++) {
	
  var series = chart.series.push(am5radar.RadarColumnSeries.new(root, {
    stacked: true,
    name: ss[i],
    xAxis: xAxis,
    yAxis: yAxis,
    valueXField: "value",
    categoryYField: "category"
  }));

 series.set("stroke", root.interfaceColors.get("background"));
  series.columns.template.setAll({
    width: am5.p100,
    strokeOpacity: 0.1,
    tooltipText: "{name}: {valueX}"
  });


  //series.data.setAll(generateDatas(6));
  //alert(i);
  //var datanew =data2[i];
  series.data.setAll(data2[i]);
  //console.log(data2);
  series.appear(1000);
  
  
 
}

// Add scrollbars
chart.set("scrollbarX", am5.Scrollbar.new(root, { orientation: "horizontal", exportable: false }));
chart.set("scrollbarY", am5.Scrollbar.new(root, { orientation: "vertical", exportable: false }));


//var data33 = generateDatas(6);
//console.log(data33);
var data = series.data.setAll(data2[6]);
//yAxis.data.setAll(data);

yAxis.data.setAll(data2[6]);
chart.appear(1000, 100);
// Animate chart and series in
// https://www.amcharts.com/docs/v5/concepts/animations/#Initial_animation


var legend = chart.children.push(am5.Legend.new(root, {}));
var legend = chart.children.push(am5.Legend.new(root, {
  clickTarget:"itemContainer",
  centerX: am5.percent(50),
  x: am5.percent(50),
  y: am5.percent(100),
  centerY: am5.percent(30),
}));
legend.markers.template.setAll({
  width: 15,
  height: 15
});
legend.labels.template.setAll({
  fontSize: 14,
  fontWeight: "700",
});

legend.valueLabels.template.setAll({
  fontSize: 14,
  fontWeight: "700",
  width:'100',
});
legend.markerRectangles.template.setAll({
  cornerRadiusTL: 10,
  cornerRadiusTR: 10,
  cornerRadiusBL: 10,
  cornerRadiusBR: 10
});
legend.data.setAll(chart.series.values);
}); // end am5.ready()
</script>

<!-- HTML -->
<div id="chartdiv"></div>