// Doughnut Chart 
$(document).ready(function(){
	
	 function hexToRgb(hex) {
      // Expand shorthand form (e.g. "03F") to full form (e.g. "0033FF")
      var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
      hex = hex.replace(shorthandRegex, function (m, r, g, b) {
        return r + r + g + g + b + b;
      });

      var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);
      return result ? {
        r: parseInt(result[1], 16),
        g: parseInt(result[2], 16),
        b: parseInt(result[3], 16)
      } : null;
    }

    function createChart(id, type, options) {
      var data = {
        labels: ['January', 'February', 'March'],
        datasets: [
          {
            label: 'My First dataset',
            data: [50445, 33655, 15900],
            backgroundColor: [
              '#FF6384',
              '#36A2EB',
              '#FFCE56'
            ]
          }
        ]
      };

      new Chart(document.getElementById(id), {
        type: type,
        data: data,
        options: options
      });
    }

    ['pie', 'doughnut'].forEach(function (type) {
      
      
      createChart(type + '-canvas11', type, {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          labels: [
            {
              render: 'label',
              position: 'outside'
            },
            {
              render: 'percentage'
            }
          ]
        }
      });
    });
    

   
	
	
	
	     
});
// Doughnut Chart 